#!/bin/bash

# Copyright 2016-2020, Intel Corporation, All Rights Reserved.

# The  source code,  information and material  ("Material")  contained herein is
# owned  by  Intel  Corporation or its suppliers or licensors, and title to such
# Material  remains  with  Intel  Corporation  or  its  suppliers  or licensors.
# The  Material  contains proprietary information of  Intel or its suppliers and
# licensors.   The Material is protected by  worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published,  uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission. No license under any patent,
# copyright  or other intellectual property rights in the Material is granted to
# or conferred upon you, either expressly,  by implication, inducement, estoppel
# or  otherwise.  Any license  under such intellectual  property rights  must be
# express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not  remove or alter this
# notice or any other notice embedded in Materials by Intel or Intel's suppliers
# or licensors in any way.

is_absolute_path()
{
    echo $1 | grep '^/' > /dev/null 2>&1 ; return $?
}

detect_oneapi()
{
    local DEFAULT_INSTALL_DIR_ROOT="/opt/intel"
    local DEFAULT_INSTALL_DIR_USER="${HOME}/intel"
    
    local INSTALL_SUBDIR="/oneapi"

    local oneapi_location=""

    local DEFAULT_CACHE_DIR_ROOT="/var/intel/installercache"
    local DEFAULT_CACHE_DIR_USER="/${HOME}/intel/installercache"
    local MARKER_FILE=".installdir_marker"


    for cache_root in "${DEFAULT_CACHE_DIR_ROOT}" "${DEFAULT_CACHE_DIR_USER}" ; do
    if [ -e "${cache_root}/${MARKER_FILE}" ] ; then
        oneapi_location=`cat "${cache_root}/${MARKER_FILE}" `
            break
        fi
    done


    # if still not found, check files in default locations
    if [ -z "${oneapi_location}" -a -f "${DEFAULT_INSTALL_DIR_USER}/${INSTALL_SUBDIR}/setvars.sh" ] ; then
        oneapi_location="${DEFAULT_INSTALL_DIR_USER}"
    fi

    # last resort
    if [ -z "${oneapi_location}" ] ; then
        oneapi_location="${DEFAULT_INSTALL_DIR_ROOT}/${INSTALL_SUBDIR}"
    fi

    echo "${oneapi_location}"
}

if [ -z "$SHADOW_PREFIX" ] ; then
    SHADOW_PREFIX=`detect_oneapi`
fi

LINKS="
$PREFIX/bin/mpiexec	$SHADOW_PREFIX/mpi/2021.1.1/bin/mpiexec
$PREFIX/bin/IMB-MPI1	$SHADOW_PREFIX/mpi/2021.1.1/bin/IMB-MPI1
$PREFIX/bin/IMB-MT	$SHADOW_PREFIX/mpi/2021.1.1/bin/IMB-MT
$PREFIX/bin/IMB-NBC	$SHADOW_PREFIX/mpi/2021.1.1/bin/IMB-NBC
$PREFIX/bin/IMB-P2P	$SHADOW_PREFIX/mpi/2021.1.1/bin/IMB-P2P
$PREFIX/bin/IMB-RMA	$SHADOW_PREFIX/mpi/2021.1.1/bin/IMB-RMA
$PREFIX/bin/cpuinfo	$SHADOW_PREFIX/mpi/2021.1.1/bin/cpuinfo
$PREFIX/bin/hydra_bstrap_proxy	$SHADOW_PREFIX/mpi/2021.1.1/bin/hydra_bstrap_proxy
$PREFIX/bin/hydra_nameserver	$SHADOW_PREFIX/mpi/2021.1.1/bin/hydra_nameserver
$PREFIX/bin/hydra_pmi_proxy	$SHADOW_PREFIX/mpi/2021.1.1/bin/hydra_pmi_proxy
$PREFIX/bin/impi_info	$SHADOW_PREFIX/mpi/2021.1.1/bin/impi_info
$PREFIX/bin/libfabric/fi_info	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/bin/fi_info
$PREFIX/bin/libfabric/fi_pingpong	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/bin/fi_pingpong
$PREFIX/bin/mpiexec.hydra	$SHADOW_PREFIX/mpi/2021.1.1/bin/mpiexec.hydra
$PREFIX/bin/mpirun	$SHADOW_PREFIX/mpi/2021.1.1/bin/mpirun
$PREFIX/bin/mpitune	$SHADOW_PREFIX/mpi/2021.1.1/bin/mpitune
$PREFIX/bin/mpitune_fast	$SHADOW_PREFIX/mpi/2021.1.1/bin/mpitune_fast
$PREFIX/bin/tune/_collections.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/_collections.so
$PREFIX/bin/tune/_functools.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/_functools.so
$PREFIX/bin/tune/_io.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/_io.so
$PREFIX/bin/tune/_random.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/_random.so
$PREFIX/bin/tune/_struct.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/_struct.so
$PREFIX/bin/tune/binascii.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/binascii.so
$PREFIX/bin/tune/cStringIO.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/cStringIO.so
$PREFIX/bin/tune/datetime.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/datetime.so
$PREFIX/bin/tune/fcntl.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/fcntl.so
$PREFIX/bin/tune/itertools.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/itertools.so
$PREFIX/bin/tune/math.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/math.so
$PREFIX/bin/tune/mpitune	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/mpitune
$PREFIX/bin/tune/operator.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/operator.so
$PREFIX/bin/tune/select.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/select.so
$PREFIX/bin/tune/time.so	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune/time.so
$PREFIX/bin/tune_fast/mpitune_fast	$SHADOW_PREFIX/mpi/2021.1.1/bin/tune_fast/mpitune_fast
$PREFIX/etc/collectives.conf	$SHADOW_PREFIX/mpi/2021.1.1/etc/collectives.conf
$PREFIX/etc/pt2pt.conf	$SHADOW_PREFIX/mpi/2021.1.1/etc/pt2pt.conf
$PREFIX/etc/tune_cfg/impi2018.py	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/impi2018.py
$PREFIX/etc/tune_cfg/impi2019.py	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/impi2019.py
$PREFIX/etc/tune_cfg/sample_allgather.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_allgather.cfg
$PREFIX/etc/tune_cfg/sample_allgatherv.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_allgatherv.cfg
$PREFIX/etc/tune_cfg/sample_allreduce.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_allreduce.cfg
$PREFIX/etc/tune_cfg/sample_alltoall.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_alltoall.cfg
$PREFIX/etc/tune_cfg/sample_alltoallv.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_alltoallv.cfg
$PREFIX/etc/tune_cfg/sample_barrier.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_barrier.cfg
$PREFIX/etc/tune_cfg/sample_bcast.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_bcast.cfg
$PREFIX/etc/tune_cfg/sample_gather.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_gather.cfg
$PREFIX/etc/tune_cfg/sample_gatherv.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_gatherv.cfg
$PREFIX/etc/tune_cfg/sample_legacy_format.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_legacy_format.cfg
$PREFIX/etc/tune_cfg/sample_reduce.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_reduce.cfg
$PREFIX/etc/tune_cfg/sample_reduce_scatter.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_reduce_scatter.cfg
$PREFIX/etc/tune_cfg/sample_scatter.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_scatter.cfg
$PREFIX/etc/tune_cfg/sample_scatterv.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_scatterv.cfg
$PREFIX/etc/tune_cfg/sample_windows.cfg	$SHADOW_PREFIX/mpi/2021.1.1/etc/tune_cfg/sample_windows.cfg
$PREFIX/etc/tuning_clx-ap_ofi.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_clx-ap_ofi.dat
$PREFIX/etc/tuning_clx-ap_shm-ofi.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_clx-ap_shm-ofi.dat
$PREFIX/etc/tuning_clx-ap_shm.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_clx-ap_shm.dat
$PREFIX/etc/tuning_generic_ofi.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_generic_ofi.dat
$PREFIX/etc/tuning_generic_ofi_mlx_hcoll.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_generic_ofi_mlx_hcoll.dat
$PREFIX/etc/tuning_generic_shm-ofi.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_generic_shm-ofi.dat
$PREFIX/etc/tuning_generic_shm-ofi_mlx_hcoll.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_generic_shm-ofi_mlx_hcoll.dat
$PREFIX/etc/tuning_generic_shm.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_generic_shm.dat
$PREFIX/etc/tuning_knl_ofi.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_knl_ofi.dat
$PREFIX/etc/tuning_knl_shm-ofi.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_knl_shm-ofi.dat
$PREFIX/etc/tuning_knl_shm.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_knl_shm.dat
$PREFIX/etc/tuning_skx_ofi.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_skx_ofi.dat
$PREFIX/etc/tuning_skx_ofi_efa.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_skx_ofi_efa.dat
$PREFIX/etc/tuning_skx_ofi_tcp-ofi-rxm.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_skx_ofi_tcp-ofi-rxm.dat
$PREFIX/etc/tuning_skx_shm-ofi.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_skx_shm-ofi.dat
$PREFIX/etc/tuning_skx_shm-ofi_efa.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_skx_shm-ofi_efa.dat
$PREFIX/etc/tuning_skx_shm-ofi_tcp-ofi-rxm.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_skx_shm-ofi_tcp-ofi-rxm.dat
$PREFIX/etc/tuning_skx_shm.dat	$SHADOW_PREFIX/mpi/2021.1.1/etc/tuning_skx_shm.dat
$PREFIX/etc/vt.conf	$SHADOW_PREFIX/mpi/2021.1.1/etc/vt.conf
$PREFIX/etc/vtfs.conf	$SHADOW_PREFIX/mpi/2021.1.1/etc/vtfs.conf
$PREFIX/etc/vtim.conf	$SHADOW_PREFIX/mpi/2021.1.1/etc/vtim.conf
$PREFIX/etc/vtmc.conf	$SHADOW_PREFIX/mpi/2021.1.1/etc/vtmc.conf
$PREFIX/lib/libmpijava.so	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpijava.so
$PREFIX/lib/libmpijava.so.1	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpijava.so.1
$PREFIX/lib/libmpicxx.so	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpicxx.so
$PREFIX/lib/libmpicxx.so.12	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpicxx.so.12
$PREFIX/lib/libmpicxx.so.12.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpicxx.so.12.0
$PREFIX/lib/libmpifort.so	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpifort.so
$PREFIX/lib/libmpifort.so.12	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpifort.so.12
$PREFIX/lib/libmpifort.so.12.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpifort.so.12.0
$PREFIX/lib/release_mt/libmpi_ilp64.so	$SHADOW_PREFIX/mpi/2021.1.1/lib/release_mt/libmpi_ilp64.so
$PREFIX/lib/libmpi_ilp64.so	$SHADOW_PREFIX/mpi/2021.1.1/lib/release/libmpi_ilp64.so
$PREFIX/lib/release_mt/libmpi_ilp64.so.4	$SHADOW_PREFIX/mpi/2021.1.1/lib/release_mt/libmpi_ilp64.so.4
$PREFIX/lib/libmpi_ilp64.so.4	$SHADOW_PREFIX/mpi/2021.1.1/lib/release/libmpi_ilp64.so.4
$PREFIX/lib/libfabric/libfabric.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/libfabric.so
$PREFIX/lib/release_mt/libmpi.so	$SHADOW_PREFIX/mpi/2021.1.1/lib/release_mt/libmpi.so
$PREFIX/lib/release_mt/libmpi.so.12	$SHADOW_PREFIX/mpi/2021.1.1/lib/release_mt/libmpi.so.12
$PREFIX/lib/release_mt/libmpi.so.12.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/release_mt/libmpi.so.12.0
$PREFIX/lib/libmpi.so	$SHADOW_PREFIX/mpi/2021.1.1/lib/release/libmpi.so
$PREFIX/lib/libmpi.so.12	$SHADOW_PREFIX/mpi/2021.1.1/lib/release/libmpi.so.12
$PREFIX/lib/libmpi.so.12.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/release/libmpi.so.12.0
$PREFIX/lib/libfabric/prov/libefa-fi.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/prov/libefa-fi.so
$PREFIX/lib/libfabric/libfabric.so.1	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/libfabric.so.1
$PREFIX/lib/libfabric/prov/libmlx-fi.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/prov/libmlx-fi.so
$PREFIX/lib/libfabric/prov/libpsmx2-fi.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/prov/libpsmx2-fi.so
$PREFIX/lib/libfabric/prov/librxm-fi.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/prov/librxm-fi.so
$PREFIX/lib/libfabric/prov/libshm-fi.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/prov/libshm-fi.so
$PREFIX/lib/libfabric/prov/libsockets-fi.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/prov/libsockets-fi.so
$PREFIX/lib/libfabric/prov/libtcp-fi.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/prov/libtcp-fi.so
$PREFIX/lib/libfabric/prov/libverbs-fi.so	$SHADOW_PREFIX/mpi/2021.1.1/libfabric/lib/prov/libverbs-fi.so
$PREFIX/lib/libmpi_shm_heap_proxy.so	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpi_shm_heap_proxy.so
$PREFIX/lib/libmpicxx.so.12.0.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpicxx.so.12.0.0
$PREFIX/lib/libmpifort.so.12.0.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpifort.so.12.0.0
$PREFIX/lib/libmpijava.so.1.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/libmpijava.so.1.0
$PREFIX/lib/mpi.jar	$SHADOW_PREFIX/mpi/2021.1.1/lib/mpi.jar
$PREFIX/lib/libmpi.so.12.0.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/release/libmpi.so.12.0.0
$PREFIX/lib/libmpi_ilp64.so.4.1	$SHADOW_PREFIX/mpi/2021.1.1/lib/release/libmpi_ilp64.so.4.1
$PREFIX/lib/release_mt/libmpi.so.12.0.0	$SHADOW_PREFIX/mpi/2021.1.1/lib/release_mt/libmpi.so.12.0.0
$PREFIX/lib/release_mt/libmpi_ilp64.so.4.1	$SHADOW_PREFIX/mpi/2021.1.1/lib/release_mt/libmpi_ilp64.so.4.1
$PREFIX/share/licensing/mpi/license.txt	$SHADOW_PREFIX/mpi/2021.1.1/licensing/license.txt
$PREFIX/share/licensing/mpi/third-party-programs.txt	$SHADOW_PREFIX/mpi/2021.1.1/licensing/third-party-programs.txt
$PREFIX/etc/conda/activate.d/mpivars.activate.sh	$SHADOW_PREFIX/mpi/2021.1.1/etc/conda/activate.d/mpivars.activate.sh
$PREFIX/etc/conda/deactivate.d/mpivars.deactivate.sh	$SHADOW_PREFIX/mpi/2021.1.1/etc/conda/deactivate.d/mpivars.deactivate.sh

"

echo_toplevel_dir_for_absolute_path()
{
    echo $1 | sed 's%^/%%' | sed 's%/.*$%%g'
}

link()
{
    local BASE_DIR=$1
    local LINK=$2
    local TARGET=$3
    [ -z "$LINK" ] && return
    [ -z "$TARGET" ] && return
    [ ! -d "$BASE_DIR" ] && mkdir -p $BASE_DIR

    # link it!
    pushd $BASE_DIR > /dev/null 2>&1
    ln -sfT $RELATIVE_FLAG $TARGET $LINK > /dev/null  2>&1
    popd > /dev/null 2>&1
}

link_if_exists()
{
    local BASE_DIR=$1
    local TARGET=$3
    if is_absolute_path $TARGET ; then
        [ -e "$TARGET" ] && link $1 $2 $3
    else
        [ -e "$BASE_DIR/$TARGET" ] && link $1 $2 $3
    fi
}

rmlink()
{
    local LINK=$1
    [ -h "$LINK" ] && rm -f $LINK
}

create_links()
{
    for str in $(echo "$LINKS" | sed 's/	/;/g') ; do
        str=$(echo "$str" | sed 's/;/	/g')
        SOURCE=`echo "$str" | cut -f 1`
        BASE_DIR=`dirname $SOURCE`
        LINK_NAME=`basename $SOURCE`
        TARGET=`echo "$str" | cut -f 2`
        # link_if_exists $BASE_DIR $LINK_NAME $TARGET
        link $BASE_DIR $LINK_NAME $TARGET
    done
}

remove_links()
{
    for str in $(echo "$LINKS" | sed 's/	/;/g') ; do
        str=$(echo "$str" | sed 's/;/	/g')
        SOURCE=`echo "$str" | cut -f 1`
        BASE_DIR=`dirname $SOURCE`
        LINK_NAME=`basename $SOURCE`
        TARGET=`echo "$str" | cut -f 2`
        rmlink "$BASE_DIR/$LINK_NAME"
        rmdir -p "$BASE_DIR" || true
    done
}

create_links

exit 0

