#!/bin/sh
# shellcheck shell=sh

# Copyright 2020 Intel Corporation.
#
# This software and the related documents are Intel copyrighted materials,
# and your use of them is governed by the express license under which they
# were provided to you (License). Unless the License provides otherwise,
# you may not use, modify, copy, publish, distribute, disclose or transmit
# this software or the related documents without Intel's prior written
# permission.
#
# This software and the related documents are provided as is, with no express
# or implied warranties, other than those that are expressly stated in the
# License.

Help()
{
   printf "The script detects all products from oneAPI family installed via YUM/APT and binary installer.\n"
   printf "The result of the script will be put to the listOfInstalledProductsAndComponents.txt file by default.\n\n"
   printf "Syntax: $0 [path|-h|--help]\n"
   printf "options:\n"
   printf "path             Changing path to script output file.\n"
   printf "%s | --help      Print this Help.\n" "-h"
}

get_script_path() (
  script="$1"
  while [ -L "$script" ] ; do
    # combining next two lines fails in zsh shell
    script_dir=$(command dirname -- "$script")
    script_dir=$(cd "$script_dir" && command pwd -P)
    script="$(readlink "$script")"
    case $script in
      (/*) ;;
       (*) script="$script_dir/$script" ;;
    esac
  done
  # combining next two lines fails in zsh shell
  script_dir=$(command dirname -- "$script")
  script_dir=$(cd "$script_dir" && command pwd -P)
  printf "$script_dir"
)

script_location=$(get_script_path "$0")

while getopts ":h" option; do
   case $option in
      h)
        Help
        exit
        ;;
      *)
        ;;

   esac
done

parse_cmd_parameters()
{
    if [ $# -gt 0 ]; then
        OutputFile="$1"
    else
        OutputFile="${script_location}/listOfInstalledProductsAndComponents.txt"
    fi
}

# script start

parse_cmd_parameters "$@"
binary_installer="${script_location}/installer"

if [ -f "$binary_installer" ]; then
    printf "Installed oneAPI products have been detected:" | tee "$OutputFile"
    countLineOfProduct=0
    $binary_installer --list-products |
    while read -r lineOfProduct; do
        if [ $countLineOfProduct -ge "2" ]; then
            printf "\n\n%s\n%s" "${id}" "${separationLine}" | tee -a "$OutputFile"
            printf "\n%s\n" "$lineOfProduct" | tee -a "$OutputFile"
            productId="${lineOfProduct%% *}"
            lineOfProductWOleadSpaces="$(printf "${lineOfProduct}" | sed -e "s/${productId}//" | sed -e "s/^[[:space:]]*//")"
            productVer="${lineOfProductWOleadSpaces%% *}"
            $binary_installer --list-components --product-id="${productId}" --product-ver="${productVer}" |
            while read -r lineOfComponent; do
                printf "\n%s" "$lineOfComponent" | tee -a "$OutputFile"
            done
        elif [ $countLineOfProduct -eq "0" ]; then
            id="$lineOfProduct"
        elif [ $countLineOfProduct -eq "1" ]; then
            separationLine="$lineOfProduct"
        fi
        countLineOfProduct=$(( countLineOfProduct + 1 ))
    done
else
    printf "\nNo oneAPI products were installed using binary installer" > "$OutputFile"
fi

if [ "$( printf "$OSTYPE" | grep "darwin*" )" ]; then
    printf "\n"
    exit 0
fi

if [ -f /etc/os-release ] # Check yum\apt started 
then
    if [ "$( ! grep -q "^ID=" < "/etc/os-release" )" ]; then
        printf "\n\nUnknown OS: Yum/apt channels will not be checked\n"
        exit 1
    fi
fi

    printf "\n\nYum:" | tee -a "$OutputFile"
    printf "\n=======================================================================\n" | tee -a "$OutputFile"
if command -v yum > /dev/null 2>&1 ; then
    yum list --installed | grep oneapi | tee -a "$OutputFile"
else
    printf "Yum manager is not installed in this machine\n" | tee -a "$OutputFile"
fi
    printf "\nApt:" | tee -a "$OutputFile"
    printf "\n=======================================================================\n" | tee -a "$OutputFile"
if command -v apt > /dev/null 2>&1 ; then
    apt list --installed | grep oneapi | tee -a "$OutputFile"
else
    printf "Apt manager is not installed in this machine\n" | tee -a "$OutputFile"
fi
    printf "\nZypper:" | tee -a "$OutputFile"
    printf "\n=======================================================================\n" | tee -a "$OutputFile"
if command -v zypper > /dev/null 2>&1 && ! command -v yum > /dev/null 2>&1 ; then
    zypper search --installed-only | grep oneapi | tr -s " " | tee -a "$OutputFile"
else
    if command -v yum > /dev/null 2>&1 ; then
        printf "See Yum output\n" | tee -a "$OutputFile"
    else
        printf "Zypper manager is not installed in this machine\n" | tee -a "$OutputFile"
    fi
fi