! *
! **********************************************************************************
! * INTEL CORPORATION                                                              *
! * Copyright 2006-2020 Intel Corporation All Rights Reserved.                     *
! *                                                                                *
! * The source code contained or described herein and all documents related to     *
! * the source code ("Material") are owned by Intel Corporation or its suppliers   *
! * or licensors. Title to the Material remains with Intel Corporation or its      *
! * suppliers and licensors. The Material contains trade secrets and proprietary   *
! * and confidential information of Intel or its suppliers and licensors. The      *
! * Material is protected by worldwide copyright and trade secret laws and         *
! * treaty provisions. No part of the Material may be used, copied, reproduced,    *
! * modified, published, uploaded, posted, transmitted, distributed, or            *
! * disclosed in any way without Intel's prior express written permission.         *
! *                                                                                *
! * No license under any patent, copyright, trade secret or other intellectual     *
! * property right is granted to or conferred upon you by disclosure or delivery   *
! * of the Materials, either expressly, by implication, inducement, estoppel or    *
! * otherwise. Any license under such intellectual property rights must be         *
! * express and approved by Intel in writing.                                      *
! **********************************************************************************
! *

!
! **************************** Edit History *******************************
!
! May-09-2006  SAR  Initial creation.
! Aug-01-2006  SJW  make all INTEGER declarations be KIND=4
! Aug-21-2009  POL  added Fortran 2008 constants
! Aug-10-2010  JEB  Added the Fortran 2008 STAT_* constants.
! Sep-01-2010  SAR  Remove the LOCK_TYPE extensions to .EQ. and .NE.. 
! June-02-2014 JEB  Add IOSTAT_INQUIRE_INTERNAL_UNIT, the value returned from
!                   an INQUIRE on an internal unit after doing a user-defined-IO
!                   operation.
! June 17-2014 JEB  Change value of IOSTAT_INQUIRE_INTERNAL_UNIT to 90 based on
!                   careful reading of the standard; it must be unique, positive
!                   and can never change once defined.
! Sep 16-2016  vrm  Added COMPILER_VERSION and COMPILER_OPTIONS support.
! May 01-2017  JEB  Add STAT_FAILED_IMAGE.
! May 10-2017  JEB  Add STAT_UNLOCK_FAILED_IMAGE.
! Dec 08-2017  vrm  Add EVENT_TYPE.
! Oct 20-2018  JEB  Add CURRENT_TEAM, INITIAL_TEAM, and PARENT_TEAM from the 2018 standard.
! Apr 11-2019  jlk  Add TEAM_TYPE definition.
! Jul 12-2019  JEB  Correct STAT_FAILED_IMAGE value (was 783, should be 782).  Correct
!                   STAT_UNLOCKED_OTHER_IMAGE value (was 784, should be 783).  Note 
!                   a possible extension.  The definitive source is 'libfor/for_msg.src'.
! Apr 14-2020  JEB  Fix spelling ("STAT_UNLOCK_FAILED_IMAGE" to "STAT_UNLOCKED_FAILED_IMAGE").
! Apr 22-2020  JEB  Add VERSION_NUMBER and CHECK_VALID to TEAM_TYPE definition.
!
! Created from the Fortran 2008 standard (J3/09-007) 13.8.2
!--

MODULE ISO_FORTRAN_ENV

    USE, INTRINSIC :: ISO_C_BINDING, ONLY: C_PTR, C_NULL_PTR

!DEC$ IF DEFINED(_WIN32) .OR. DEFINED(_WIN64)
!DEC$ OBJCOMMENT LIB:"ifmodintr.lib"
!DEC$ ENDIF

!DIR$ ATTRIBUTES MODULE_INTRINSIC              :: COMPILER_VERSION
!DIR$ ATTRIBUTES MODULE_INTRINSIC              :: COMPILER_OPTIONS

    INTEGER (KIND=4), PARAMETER                :: ATOMIC_INT_KIND              = 4
    INTEGER (KIND=4), PARAMETER                :: ATOMIC_LOGICAL_KIND          = 4
    INTEGER (KIND=4), PARAMETER, DIMENSION (1) :: CHARACTER_KINDS              = (/ 1 /)
    INTEGER (KIND=4), PARAMETER                :: CHARACTER_STORAGE_SIZE       = 8
    INTEGER (KIND=4), PARAMETER                :: ERROR_UNIT                   = 0
    INTEGER (KIND=4), PARAMETER                :: FILE_STORAGE_SIZE            = 8 ! -assume byterecl
    INTEGER (KIND=4), PARAMETER                :: INPUT_UNIT                   = 5
    INTEGER (KIND=4), PARAMETER, DIMENSION (4) :: INTEGER_KINDS                = (/1, 2, 4, 8/)
    INTEGER (KIND=4), PARAMETER                :: INT8                         = 1
    INTEGER (KIND=4), PARAMETER                :: INT16                        = 2
    INTEGER (KIND=4), PARAMETER                :: INT32                        = 4
    INTEGER (KIND=4), PARAMETER                :: INT64                        = 8
    INTEGER (KIND=4), PARAMETER                :: IOSTAT_END                   = -1
    INTEGER (KIND=4), PARAMETER                :: IOSTAT_EOR                   = -2
    INTEGER (KIND=4), PARAMETER                :: IOSTAT_INQUIRE_INTERNAL_UNIT = 90
    INTEGER (KIND=4), PARAMETER, DIMENSION (4) :: LOGICAL_KINDS                = (/1, 2, 4, 8/)
    INTEGER (KIND=4), PARAMETER                :: NUMERIC_STORAGE_SIZE         = 32
    INTEGER (KIND=4), PARAMETER                :: OUTPUT_UNIT                  = 6
    INTEGER (KIND=4), PARAMETER, DIMENSION (3) :: REAL_KINDS                   = (/4, 8, 16/)
    INTEGER (KIND=4), PARAMETER                :: REAL32                       = 4
    INTEGER (KIND=4), PARAMETER                :: REAL64                       = 8
    INTEGER (KIND=4), PARAMETER                :: REAL128                      = 16
!
! These values are the error-message indices for the related error messages.
!
    INTEGER (KIND=4), PARAMETER                :: STAT_LOCKED                  = 775
    INTEGER (KIND=4), PARAMETER                :: STAT_UNLOCKED                = 776
    INTEGER (KIND=4), PARAMETER                :: STAT_LOCKED_OTHER_IMAGE      = 777
    INTEGER (KIND=4), PARAMETER                :: STAT_STOPPED_IMAGE           = 778

! Not in the standard but implied in 11.16.11 p9: a processor-dependent value different
! from the ones in the standard.  This is for the case where an image attepts an
! UNLOCK but another image holds the lock.
!
! Not defined here, but a possible extension.
!
!    INTEGER (KIND=4), PARAMETER                :: STAT_UNLOCKED_OTHER_IMAGE    = 780

! Added in 2015 standard.
!
    INTEGER (KIND=4), PARAMETER                :: STAT_FAILED_IMAGE            = 782
    INTEGER (KIND=4), PARAMETER                :: STAT_UNLOCKED_FAILED_IMAGE   = 783
!
! These values are the standard-defined shorthands for the specified teams.
!
    INTEGER (KIND=4), PARAMETER                :: INITIAL_TEAM                 = 785
    INTEGER (KIND=4), PARAMETER                :: CURRENT_TEAM                 = 786
    INTEGER (KIND=4), PARAMETER                :: PARENT_TEAM                  = 787

! -------------------------------------------------------------------------
! LOCK_TYPE definition
! It's a special derived type for LOCK / UNLOCK statements
! -------------------------------------------------------------------------
    !DEC$ IF DEFINED(_M_IA64) .OR. DEFINED(__MACH__)
    ! ---------------------------
    ! no LOCK_TYPE on IPF and MAC
    ! ---------------------------
    !DEC$ ELSE 

    TYPE :: LOCK_TYPE
        PRIVATE
        INTEGER(INT_PTR_KIND()) :: lock_var = 0
    END TYPE LOCK_TYPE
    !DEC$ ATTRIBUTES LOCK_TYPE :: LOCK_TYPE

    TYPE :: EVENT_TYPE
        PRIVATE
        INTEGER(KIND=8) :: event = 0
    END TYPE EVENT_TYPE
    !DEC$ ATTRIBUTES EVENT_TYPE :: EVENT_TYPE

    !! INTERFACE OPERATOR(.EQ.)
    !!    LOGICAL FUNCTION for_LT_EQ(X,Y) BIND(C)
    !!    USE, INTRINSIC :: ISO_C_BINDING
    !!    IMPORT LOCK_TYPE
    !!    TYPE (LOCK_TYPE), INTENT(IN) :: X, Y
    !!    END FUNCTION for_LT_EQ
    !! END INTERFACE OPERATOR (.EQ.)

    !! INTERFACE OPERATOR(.NE.)
    !!    LOGICAL FUNCTION for_LT_NE(X,Y) BIND(C)
    !!    USE, INTRINSIC :: ISO_C_BINDING
    !!     IMPORT LOCK_TYPE
    !!     TYPE (LOCK_TYPE), INTENT(IN) :: X, Y
    !!     END FUNCTION for_LT_NE
    !! END INTERFACE OPERATOR (.NE.)

    !DEC$ ENDIF

! -------------------------------------------------------------------------
! TEAM_TYPE definition
! -------------------------------------------------------------------------
    TYPE TEAM_TYPE
        PRIVATE
        ! Pointer to internal team descriptor
        TYPE(C_PTR)      :: TEAM_PTR = C_NULL_PTR
        INTEGER(KIND=4)  :: VERSION_NUMBER
        INTEGER(KIND=4)  :: CHECK_VALID
    END TYPE
    !DEC$ IF (__INTEL_COMPILER .GT. 1910)
        !DEC$ ATTRIBUTES TEAM_TYPE :: TEAM_TYPE
    !DEC$ ENDIF

END MODULE ISO_FORTRAN_ENV 
