! *
! **********************************************************************************
! * INTEL CORPORATION                                                              *
! * Copyright 2012-2018 Intel Corporation All Rights Reserved.                     *
! *                                                                                *
! * The source code contained or described herein and all documents related to     *
! * the source code ("Material") are owned by Intel Corporation or its suppliers   *
! * or licensors. Title to the Material remains with Intel Corporation or its      *
! * suppliers and licensors. The Material contains trade secrets and proprietary   *
! * and confidential information of Intel or its suppliers and licensors. The      *
! * Material is protected by worldwide copyright and trade secret laws and         *
! * treaty provisions. No part of the Material may be used, copied, reproduced,    *
! * modified, published, uploaded, posted, transmitted, distributed, or            *
! * disclosed in any way without Intel's prior express written permission.         *
! *                                                                                *
! * No license under any patent, copyright, trade secret or other intellectual     *
! * property right is granted to or conferred upon you by disclosure or delivery   *
! * of the Materials, either expressly, by implication, inducement, estoppel or    *
! * otherwise. Any license under such intellectual property rights must be         *
! * express and approved by Intel in writing.                                      *
! **********************************************************************************
! *

module ifestablish

    ! This module lets the user code establish an error handler.
    !
    implicit none
   
    private
    public :: establishqq_handler, ESTABLISHQQ

    ! Interface for the user's callback routine.
    !
    abstract interface

        function establishqq_handler (error_code, continuable, message_string, context)

        import
        ! Function result that indicates whether or not the condition was handled.
        ! .TRUE. means that the handler took action and execution should continue if possible;
        ! .FALSE. means that the handler wishes the RTL to do what it would normally do with this condition.
        !
        logical :: establishqq_handler
        !DEC$ ATTRIBUTES DEFAULT :: establishqq_handler
    
        ! Arguments
        !
        integer(4),   intent(in) :: error_code         ! RTL error code from IOSTAT table
        logical(4),   intent(in) :: continuable        ! .TRUE. if condition is continuable
        character(*), intent(in) :: message_string     ! Formatted message string as in ERRMSG/IOMSG
        integer(INT_PTR_KIND()), intent(in) :: context ! Address-sized integer as passed in to call to ESTABLISHQQ
                                                       ! For whatever purpose the programmer desires.  The value is
                                                       ! saved, so changes after the establish call have no effect.
        end function establishqq_handler
    
    end interface
    
    ! ESTABLISHQQ function
    !
    interface

        function ESTABLISHQQ (handler_routine, context, prev_handler, prev_context)

        import
        ! Function result indicating whether or not the request succeeded
        !
        logical(4) :: ESTABLISHQQ
        !DEC$ ATTRIBUTES DEFAULT :: ESTABLISHQQ

        ! Arguments
        !
        procedure(establishqq_handler) :: handler_routine

        integer(INT_PTR_KIND()), intent(in):: context                   ! Address-sized integer to be passed along to handler
        procedure(establishqq_handler), pointer, intent(out), optional :: prev_handler
                                                                        ! Set to point to previous handler, if any
        integer(INT_PTR_KIND()), intent(out), optional :: prev_context  ! Set to previous context, if any
        end function ESTABLISHQQ

    end interface
    
end module ifestablish
