! *
! **********************************************************************************
! * INTEL CORPORATION                                                              *
! * Copyright 2014 Intel Corporation All Rights Reserved.                          *
! *                                                                                *
! * The source code contained or described herein and all documents related to     *
! * the source code ("Material") are owned by Intel Corporation or its suppliers   *
! * or licensors. Title to the Material remains with Intel Corporation or its      *
! * suppliers and licensors. The Material contains trade secrets and proprietary   *
! * and confidential information of Intel or its suppliers and licensors. The      *
! * Material is protected by worldwide copyright and trade secret laws and         *
! * treaty provisions. No part of the Material may be used, copied, reproduced,    *
! * modified, published, uploaded, posted, transmitted, distributed, or            *
! * disclosed in any way without Intel's prior express written permission.         *
! *                                                                                *
! * No license under any patent, copyright, trade secret or other intellectual     *
! * property right is granted to or conferred upon you by disclosure or delivery   *
! * of the Materials, either expressly, by implication, inducement, estoppel or    *
! * otherwise. Any license under such intellectual property rights must be         *
! * express and approved by Intel in writing.                                      *
! **********************************************************************************
! *

! This module is not named 'ifalloc' because it is possible that in the 
! future, other kinds of allocation will permit replacing their default
! allocation method with a user routine.  E.g., someday 'ifarrayalloc'
! might be defined.
!
module ifcommonalloc

    ! This module lets the user code provide the allocation routine for 
    ! dynamic COMMON blocks.
    !
    implicit none

    ! This is the kind of routine to define to do the allocation.
    !
    abstract interface   
        subroutine alloc_rtn (mem, size, name)
            use, intrinsic                :: ISO_C_BINDING 
        import
            type(C_PTR),    intent(OUT)   :: mem        ! Put a 'C' pointer to the allocated memory here
            integer(C_INT), intent(INOUT) :: size       ! The requested size in bytes of the memory to 
                                                        ! be allocated; result is the actual size allocated
            character, dimension(*), intent(IN) :: name ! The name of the COMMON to be allocated.
        end subroutine alloc_rtn
    end interface

    ! This is the Fortran run-time library routine to call.
    !
    ! Pass it a pointer to the user routine to be called when
    ! the memory for a dynamic COMMON is to be allocated.
    !
    interface
        function set_ftn_alloc (alloc_func_ptr) BIND(C, NAME="for__set_ftn_alloc")
            use, intrinsic :: ISO_C_BINDING
            type(C_FUNPTR) :: set_ftn_alloc
            type(C_FUNPTR), intent(IN), VALUE :: alloc_func_ptr
       end function set_ftn_alloc
    end interface

end module ifcommonalloc
