/*
**********************************************************************************
** INTEL CORPORATION                                                            **
** Copyright 2003-2011 Intel Corporation All Rights Reserved.                   **
**                                                                              **
** Portions Copyright 1992-2002, Hewlett-Packard Corporation. All Rights        **
** Reserved.                                                                    **
**                                                                              **
** The source code contained or described herein and all documents related to   **
** the source code ("Material") are owned by Intel Corporation or its suppliers **
** or licensors. Title to the Material remains with Intel Corporation or its    **
** suppliers and licensors. The Material contains trade secrets and proprietary **
** and confidential information of Intel or its suppliers and licensors. The    **
** Material is protected by worldwide copyright and trade secret laws and       **
** treaty provisions. No part of the Material may be used, copied, reproduced,  **
** modified, published, uploaded, posted, transmitted, distributed, or          **
** disclosed in any way without Intel's prior express written permission.       **
**                                                                              **
** No license under any patent, copyright, trade secret or other intellectual   **
** property right is granted to or conferred upon you by disclosure or delivery **
** of the Materials, either expressly, by implication, inducement, estoppel or  **
** otherwise. Any license under such intellectual property rights must be       **
** express and approved by Intel in writing.                                    **
**********************************************************************************
*/

#include "for_iosdef.h"
 
/*** MODULE for_fp_class IDENT JDR1-001 ***/
#ifndef FOR_FP_FLAGS
#define FOR_FP_FLAGS 1
#define FOR_K_FP_SNAN 0
#define FOR_K_FP_QNAN 1
#define FOR_K_FP_POS_INF 2
#define FOR_K_FP_NEG_INF 3
#define FOR_K_FP_POS_NORM 4
#define FOR_K_FP_NEG_NORM 5
#define FOR_K_FP_POS_DENORM 6
#define FOR_K_FP_NEG_DENORM 7
#define FOR_K_FP_POS_ZERO 8
#define FOR_K_FP_NEG_ZERO 9
#endif
 
/*** MODULE for_fpe_flags IDENT WCH1-006 ***/

#ifndef FOR_FPE_FLAGS
#define FOR_FPE_FLAGS 1
#define FOR_K_FPE_CNT_UNDERFLOW 0
#define FOR_K_FPE_CNT_OVERFLOW 1
#define FOR_K_FPE_CNT_DIVIDE0 2
#define FOR_K_FPE_CNT_INVALID 3
#define FOR_K_FPE_CNT_INEXACT 4
#define FOR_K_FPE_CNT_ARRAY_MAX 4
#define FPE_M_TRAP_UND 1
#define FPE_M_TRAP_OVF 2
#define FPE_M_TRAP_DIV0 4
#define FPE_M_TRAP_INV 8
#define FPE_M_TRAP_INE 16
#define FPE_M_RESERVED_01 32
#define FPE_M_RESERVED_02 64
#define FPE_M_RESERVED_03 128
#define FPE_M_MSG_OVF 256
#define FPE_M_MSG_UND 512
#define FPE_M_MSG_DIV0 1024
#define FPE_M_MSG_INV 2048
#define FPE_M_MSG_INE 4096
#define FPE_M_RESERVED_05 8192
#define FPE_M_RESERVED_06 16384
#define FPE_M_RESERVED_07 32768
#define FPE_M_ABRUPT_UND 65536
#define FPE_M_ABRUPT_OVF 131072
#define FPE_M_ABRUPT_DIV0 262144
#define FPE_M_ABRUPT_INV 524288
#define FPE_M_ABRUPT_DMZ 1048576
#define FPE_M_RESERVED_09 2097152
#define FPE_M_RESERVED_10 4194304
#define FPE_M_RESERVED_11 8388608
#define FPE_M_RESERVED_12 16777216
#define FPE_M_RESERVED_13 33554432
#define FPE_M_RESERVED_14 67108864
#define FPE_M_RESERVED_15 134217728
#define FPE_M_RESERVED_16 268435456
#define FPE_M_RESERVED_17 536870912
#define FPE_M_RESERVED_18 1073741824
#define FPE_M_RESERVED_19 -2147483648
typedef struct _for_fpe_flags {
    unsigned FPE_V_TRAP_UND : 1;
    unsigned FPE_V_TRAP_OVF : 1;
    unsigned FPE_V_TRAP_DIV0 : 1;
    unsigned FPE_V_TRAP_INV : 1;
    unsigned FPE_V_TRAP_INE : 1;
    unsigned FPE_V_RESERVED_01 : 1;
    unsigned FPE_V_RESERVED_02 : 1;
    unsigned FPE_V_RESERVED_03 : 1;
    unsigned FPE_V_MSG_OVF : 1;
    unsigned FPE_V_MSG_UND : 1;
    unsigned FPE_V_MSG_DIV0 : 1;
    unsigned FPE_V_MSG_INV : 1;
    unsigned FPE_V_MSG_INE : 1;
    unsigned FPE_V_RESERVED_05 : 1;
    unsigned FPE_V_RESERVED_06 : 1;
    unsigned FPE_V_RESERVED_07 : 1;
    unsigned FPE_V_ABRUPT_UND : 1;
    unsigned FPE_V_ABRUPT_OVF : 1;
    unsigned FPE_V_ABRUPT_DIV0 : 1;
    unsigned FPE_V_ABRUPT_INV : 1;
    unsigned FPE_V_ABRUPT_DMZ : 1;
    unsigned FPE_V_RESERVED_09 : 1;
    unsigned FPE_V_RESERVED_10 : 1;
    unsigned FPE_V_RESERVED_11 : 1;
    unsigned FPE_V_RESERVED_12 : 1;
    unsigned FPE_V_RESERVED_13 : 1;
    unsigned FPE_V_RESERVED_14 : 1;
    unsigned FPE_V_RESERVED_15 : 1;
    unsigned FPE_V_RESERVED_16 : 1;
    unsigned FPE_V_RESERVED_17 : 1;
    unsigned FPE_V_RESERVED_18 : 1;
    unsigned FPE_V_RESERVED_19 : 1;
    } for_fpe_flags;
#endif
/*
**  These are the platform dependent values that must be supplied
**  as the argument to for_set_fpe() to get the desired fpe:n behavior
**  established in the Fortran rtl and operating system.  They are
**  provided here as macros for convenience and documentation.
**
**  Note:  Just because a macro may be defined here for a platform,
**  it does not imply that fpe:n behavior is supported on that platform.
**  The mask values provided for the unsupported cases would be correct
**  if we ever decide to do the work in the rtl handler to complete a
**  trapped operation.  See the notes below.
**
**  Also, not all fpe:n and check:option combinations make sense
**  necessarily, but a user is generally not prohibited from specifying
**  any of the possible combinations.  So this code accounts for all.
*/
#if defined ( ALPHA ) || defined ( __alpha )
/*
**  Use these definitions for Tru64 Unix, Linux, Windows NT, and OpenVMS
**  on Alpha hardware.
*/
/*
** fpe:0 == /float=ieee/ieee_mode=fast on VMS.
*/
#define FOR_SET_FPE0_MASK (				\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV		\
)
/*
** fpe:0 check:underflow == /float=ieee/ieee_mode=fast/check=(under) on VMS.
**
** fpe:0 check:underflow is not supported on Alpha Linux.
*/
#define FOR_SET_FPE0_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_ABRUPT_DMZ |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND		\
)
/*
** fpe:1 == /float=ieee/ieee_mode=under on VMS.
**
** fpe:1 is not supported on Alpha Linux.
*/
#define FOR_SET_FPE1_MASK (				\
				FPE_M_ABRUPT_UND |	\
				FPE_M_ABRUPT_DMZ	\
)
/*
** fpe:1 check:underflow == /float=ieee/ieee=under/check=(under) on VMS.
**
** fpe:1 check:underflow is not supported on Alpha Linux.
*/
#define FOR_SET_FPE1_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_ABRUPT_DMZ |	\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** fpe:2 == /float=ieee/ieee_mode=under/check=(fp_exceptions) on VMS.
**
** fpe:2 is not supported on Alpha NT or Alpha Linux.
*/
#define FOR_SET_FPE2_MASK (				\
				FPE_M_ABRUPT_UND |	\
				FPE_M_ABRUPT_DMZ |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe2 and fpe2 check underflow are the same thing.
**
** fpe:2 check:underflow ==
**     /float=ieee/ieee_mode=under/check=(fp_exceptions) on VMS.
**
** fpe:2 check:underflow, is not supported on Alpha NT or Alpha Linux.
*/
#define FOR_SET_FPE2_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_ABRUPT_DMZ |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** fpe:3 == /float=ieee/ieee_mode=denorm on VMS.
*/
#define FOR_SET_FPE3_MASK 0
/*
** fpe:3 check:underflow == /float=ieee/ieee_mode=denorm/check=(under) on VMS.
**
** fpe:3 check:underflow, is not supported on Alpha NT or Alpha Linux.
*/
#define FOR_SET_FPE3_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** fpe:4 == /float=ieee/ieee_mode=denorm/check=(fp_exceptions) on VMS.
**
** fpe:4 is not supported on Alpha NT or Alpha Linux.
*/
#define FOR_SET_FPE4_MASK (				\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe4 and fpe4 check underflow are the same thing.
** fpe:4 check:underflow ==
**    /float=ieee/ieee_mode=denorm/check=(fp_exceptions) on VMS.
**
** fpe:4 check:underflow, is not supported on Alpha NT or Alpha Linux.
*/
#define FOR_SET_FPE4_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe5 and fpe5 check underflow are the same as
** fpe3 and fpe3 check underflow.
**
** fpe:5 == /float=ieee/ieee_mode=inexact on VMS.
** fpe:5 check:underflow == /float=ieee/ieee_mode=inexact/check=(under) on VMS.
**
** fpe:5 and fpe:5 check:underflow, is not supported on Alpha NT
** or Alpha Linux.
*/
#define FOR_SET_FPE5_MASK 0
#define FOR_SET_FPE5_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** Note that fpe6 and fpe6 check underflow are the same as
** fpe4 and fpe4 check underflow with the addition of trapping,
** producing messages, and counting of floating inexact exceptions.
**
**
** fpe:6 == /float=ieee/ieee_mode=inexact/check=(fp_exceptions) on VMS.
**
** fpe:6 and fpe:6 check:underflow, is not supported on Alpha NT
** or Alpha Linux.
*/
#define FOR_SET_FPE6_MASK (				\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_TRAP_INE |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV |		\
				FPE_M_MSG_INE		\
)
/*
** Note that fpe6 and fpe6 check underflow are the same thing.
**
** fpe:6 check:underflow ==
**          /float=ieee/ieee_mode=inexact/check=(fp_exceptions) on VMS.
**
** fpe:6 check:underflow, not supported on Alpha NT or Alpha Linux.
*/
#define FOR_SET_FPE6_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_TRAP_INE |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV |		\
				FPE_M_MSG_INE		\
)
#endif
#if defined ( _X86_ )
/*
**  Use these definitions for all Windows operating systems running on X86.
*/
#define FOR_SET_FPE0_MASK (				\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV		\
)
#define FOR_SET_FPE0_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND		\
)
/*
** fpe:1, Not currently supported on X86.
*/
#define FOR_SET_FPE1_MASK (				\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND		\
)
/*
** fpe:1 check:underflow, Not currently supported on X86.
*/
#define FOR_SET_FPE1_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** fpe:2, Not currently supported on X86.
*/
#define FOR_SET_FPE2_MASK (				\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe2 and fpe2 check underflow are the same thing.
**
** fpe:2 check:underflow, Not currently supported on X86.
*/
#define FOR_SET_FPE2_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
#define FOR_SET_FPE3_MASK 0
/*
** fpe:3 check:underflow currently traps and aborts on X86 for an underflow.
*/
#define FOR_SET_FPE3_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** fpe:4, Not currently supported on X86.
*/
#define FOR_SET_FPE4_MASK (				\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe4 and fpe4 check underflow are the same thing.
**
** fpe:4 check:underflow, Not currently supported on X86.
*/
#define FOR_SET_FPE4_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe5 and fpe5 check underflow are the same as
** fpe3 and fpe3 check underflow.
**
** fpe:5, Not currently supported on X86.
** (well, they sort of are, but they don't do anything with respect
** to floating inexacts which is the whole point of fpe:5.)
*/
#define FOR_SET_FPE5_MASK 0
#define FOR_SET_FPE5_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** Note that fpe6 and fpe6 check underflow are the same as
** fpe4 and fpe4 check underflow with the addition of trapping,
** producing messages, and counting of floating inexact exceptions.
**
** fpe:6, Not currently supported on X86.
*/
#define FOR_SET_FPE6_MASK (				\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_TRAP_INE |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV |		\
				FPE_M_MSG_INE		\
)
/*
** Note that fpe6 and fpe6 check underflow are the same thing.
**
** fpe:6 check:underflow, Not currently supported on X86.
*/
#define FOR_SET_FPE6_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_TRAP_INE |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV |		\
				FPE_M_MSG_INE		\
)
#endif
#if defined ( _M_IA64 )
/*
**  Use these definitions for all Windows operating systems running on Intel(R) IA-64 architecture.
*/
#define FOR_SET_FPE0_MASK (				\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV		\
)
#define FOR_SET_FPE0_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND		\
)
#define FOR_SET_FPE1_MASK (				\
				FPE_M_ABRUPT_UND	\
)
#define FOR_SET_FPE1_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** fpe:2, Not currently supported on Intel(R) IA-64 architecture.
*/
#define FOR_SET_FPE2_MASK (				\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe2 and fpe2 check underflow are the same thing.
**
** fpe:2 check:underflow, Not currently supported on Intel(R) IA-64 architecture.
*/
#define FOR_SET_FPE2_CHECK_UND_MASK (			\
				FPE_M_ABRUPT_UND |	\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
#define FOR_SET_FPE3_MASK 0
/*
** fpe:3 check:underflow currently traps and aborts on Intel(R) IA-64 architecture for an underflow.
*/
#define FOR_SET_FPE3_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** fpe:4, Not currently supported on Intel(R) IA-64 architecture.
*/
#define FOR_SET_FPE4_MASK (				\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe4 and fpe4 check underflow are the same thing.
**
** fpe:4 check:underflow, Not currently supported on Intel(R) IA-64 architecture.
*/
#define FOR_SET_FPE4_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV		\
)
/*
** Note that fpe5 and fpe5 check underflow are the same as
** fpe3 and fpe3 check underflow.
**
** fpe:5, Not currently supported on Intel(R) IA-64 architecture.
** (well, they sort of are, but they don't do anything with respect
** to floating inexacts which is the whole point of fpe:5.)
*/
#define FOR_SET_FPE5_MASK 0
#define FOR_SET_FPE5_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_MSG_UND		\
)
/*
** Note that fpe6 and fpe6 check underflow are the same as
** fpe4 and fpe4 check underflow with the addition of trapping,
** producing messages, and counting of floating inexact exceptions.
**
** fpe:6, Not currently supported on Intel(R) IA-64 architecture.
*/
#define FOR_SET_FPE6_MASK (				\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_TRAP_INE |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV |		\
				FPE_M_MSG_INE		\
)
/*
** Note that fpe6 and fpe6 check underflow are the same thing.
**
** fpe:6 check:underflow, Not currently supported on Intel(R) IA-64 architecture.
*/
#define FOR_SET_FPE6_CHECK_UND_MASK (			\
				FPE_M_TRAP_UND |	\
				FPE_M_TRAP_OVF |	\
				FPE_M_TRAP_DIV0 |	\
				FPE_M_TRAP_INV |	\
				FPE_M_TRAP_INE |	\
				FPE_M_MSG_UND |		\
				FPE_M_MSG_OVF |		\
				FPE_M_MSG_DIV0 |	\
				FPE_M_MSG_INV |		\
				FPE_M_MSG_INE		\
)
#endif
 
/*** MODULE for_reent_codes IDENT SAR1-002 ***/

#ifndef FOR_REENT_CODES
#define FOR_REENT_CODES 1
#define FOR_K_REENTRANCY_NONE 0
#define FOR_K_REENTRANCY_ASYNCH 1
#define FOR_K_REENTRANCY_THREADED 2
#define FOR_K_REENTRANCY_INFO 3
#endif


/*** MODULE for_prefetch_flags IDENT SAR1-002 ***/
#ifndef FOR_PREFETCH_FLAGS
#define FOR_PREFETCH_FLAGS 1
#define FOR_K_PREFETCH_T0  0
#define FOR_K_PREFETCH_T1  1
#define FOR_K_PREFETCH_T2  2
#define FOR_K_PREFETCH_NTA 3
#endif
