/*
* ISO_Fortran_binding.h
*
***********************************************************************************
** INTEL CORPORATION                                                              *
** Copyright (C) 2014-2015 Intel Corporation. All Rights Reserved.                *
**                                                                                *
** The source code contained or described herein and all documents related to     *
** the source code ("Material") are owned by Intel Corporation or its suppliers   *
** or licensors. Title to the Material remains with Intel Corporation or its      *
** suppliers and licensors. The Material contains trade secrets and proprietary   *
** and confidential information of Intel or its suppliers and licensors. The      *
** Material is protected by worldwide copyright and trade secret laws and         *
** treaty provisions. No part of the Material may be used, copied, reproduced,    *
** modified, published, uploaded, posted, transmitted, distributed, or            *
** disclosed in any way without Intel's prior express written permission.         *
**                                                                                *
** No license under any patent, copyright, trade secret or other intellectual     *
** property right is granted to or conferred upon you by disclosure or delivery   *
** of the Materials, either expressly, by implication, inducement, estoppel or    *
** otherwise. Any license under such intellectual property rights must be         *
** express and approved by Intel in writing.                                      *
***********************************************************************************
*
* Defines structures, typedefs, macros, functions and constants in support of
* Fortran TS29113 - Further Interoperability of Fortran with C
*
* 16-001  SBL  Original 30-Oct-2014
* 16-002  SBL  Add flags and reserved fields. 17-Dec-2014
*/

#ifndef __ISO_FORTRAN_BINDING_INCLUDED
#define __ISO_FORTRAN_BINDING_INCLUDED

#include <stddef.h>
#include <stdint.h> // needed for intptr_t on Linux and MacOS

#if defined(__cplusplus)
extern "C" {
#endif

// Macros and typedefs

// Macros specifying attribute codes

#define CFI_attribute_pointer       1
#define CFI_attribute_allocatable   2
#define CFI_attribute_other         3
#define CFI__max_attribute          CFI_attribute_other

    // Macros specifying type codes

#define CFI_type_int8_t             1
#define CFI_type_int16_t            2
#define CFI_type_int32_t            3
#define CFI_type_int64_t            4
#define CFI_type_signed_char        CFI_type_int8_t
#define CFI_type_short              CFI_type_int16_t
#define CFI_type_int                CFI_type_int32_t
#ifdef _WIN32
#define CFI_type_long               CFI_type_int32_t
#else
#define CFI_type_long               CFI_type_int64_t
#endif
#define CFI_type_long_long          CFI_type_int64_t
#if defined(__x86_64__) || defined(_M_X64)
#define CFI_type_size_t             CFI_type_int64_t
#else
#define CFI_type_size_t             CFI_type_int32_t
#endif

#define CFI_type_int_least8_t       CFI_type_int8_t
#define CFI_type_int_least16_t      CFI_type_int16_t
#define CFI_type_int_least32_t      CFI_type_int32_t
#define CFI_type_int_least64_t      CFI_type_int64_t
#define CFI_type_int_fast8_t        CFI_type_int8_t
#define CFI_type_int_fast16_t       CFI_type_int16_t
#define CFI_type_int_fast32_t       CFI_type_int32_t
#define CFI_type_int_fast64_t       CFI_type_int64_t
#define CFI_type_intmax_t           CFI_type_int64_t
#define CFI_type_intptr_t           CFI_type_size_t
#define CFI_type_ptrdiff_t          CFI_type_size_t
#define CFI_type_float              5
#define CFI_type_double             6
#if defined(__linux__) && defined(__i386__)
#define CFI_type_long_double        -1  // Unsupported 12-byte type
#elif defined(__MACH__)
#define CFI_type_long_double        7   // REAL(16)
#else
#define CFI_type_long_double        CFI_type_double // Windows
#endif
#define CFI_type_float_Complex      8   
#define CFI_type_double_Complex     9
#if defined(__linux__) && defined(__i386__)
#define CFI_type_long_double_Complex    -1  // Unsupported 12-byte type
#elif defined(__MACH__)
#define CFI_type_long_double_Complex    10   // COMPLEX(16)
#else
#define CFI_type_long_double_Complex    CFI_type_double_Complex
#endif
#define CFI_type_Bool               11
#define CFI_type_char               12  
#define CFI_type_cptr               CFI_type_intptr_t
#define CFI_type_struct             13
#define CFI_type_other              -2
#define CFI__max_type               CFI_type_struct

// Macros specifying error codes

#define CFI_SUCCESS                     0
#define CFI_ERROR_BASE_ADDR_NULL        1
#define CFI_ERROR_BASE_ADDR_NOT_NULL    2
#define CFI_INVALID_ELEM_LEN            3
#define CFI_INVALID_RANK                4
#define CFI_INVALID_TYPE                5
#define CFI_INVALID_ATTRIBUTE           6
#define CFI_INVALID_EXTENT              7
#define CFI_INVALID_DESCRIPTOR          8
#define CFI_ERROR_MEM_ALLOCATION        9
#define CFI_ERROR_OUT_OF_BOUNDS         10
// Begin Intel-defined error codes
#define CFI_INTEL_INVALID_ARGUMENT      11

// CFI_cdesc_t definitions

typedef ptrdiff_t CFI_index_t;
#define CFI_MAX_RANK 31
#define CFI_VERSION 0x80860001  // Increment low 16 bits only
#define CFI__VERSION_0001 CFI_VERSION
typedef ptrdiff_t CFI_rank_t;
typedef ptrdiff_t CFI_attribute_t;
typedef ptrdiff_t CFI_type_t;

typedef struct CFI_dim_t_
{
    CFI_index_t     extent;
    CFI_index_t     sm;
    CFI_index_t     lower_bound;
} CFI_dim_t;

typedef struct CFI_cdesc_t_
{
    void * base_addr;
    size_t elem_len;
    int version;
    CFI_attribute_t attribute;
    CFI_rank_t rank;
    CFI_type_t type;
    // Begin Intel-specific fields - these are for
    // Intel compiler/library use only and should 
    // not be modified
    intptr_t intel_flags;
    intptr_t intel_reserved1;
    intptr_t intel_reserved2;
    // End Intel-specific fields
    CFI_dim_t dim[];
} CFI_cdesc_t;

#define CFI_CDESC_T(r) \
struct \
{ \
    void * base_addr; \
    size_t elem_len; \
    int version; \
    CFI_attribute_t attribute; \
    CFI_rank_t rank; \
    CFI_type_t type; \
    intptr_t intel_flags; \
    intptr_t intel_reserved1; \
    intptr_t intel_reserved2; \
    CFI_dim_t dim[r]; \
} 


// Functions

void * for_CFI_address(const CFI_cdesc_t * dv, const CFI_index_t subscripts[]);
#define CFI_address(dv,subscripts) for_CFI_address(dv,subscripts)

int for_CFI_allocate(CFI_cdesc_t * dv, const CFI_index_t lower_bounds[],
    const CFI_index_t upper_bounds[], size_t elem_len);
#define CFI_allocate(dv,lower_bounds,upper_bounds,elem_len) \
    for_CFI_allocate(dv,lower_bounds,upper_bounds,elem_len)

int for_CFI_deallocate(CFI_cdesc_t * dv);
#define CFI_deallocate(dv) for_CFI_deallocate(dv)

int for_CFI_establish(CFI_cdesc_t * dv, void * base_addr, CFI_attribute_t attribute,
    CFI_type_t type, size_t elem_len, CFI_rank_t rank, const CFI_index_t extents[], int version);
#define CFI_establish(dv,base_addr,attribute,type,elem_len,rank,extents) \
    for_CFI_establish(dv,base_addr,attribute,type,elem_len,rank,extents,CFI_VERSION)

int for_CFI_is_contiguous(const CFI_cdesc_t * dv);
#define CFI_is_contiguous(dv) for_CFI_is_contiguous(dv)

int for_CFI_section(CFI_cdesc_t * result, const CFI_cdesc_t * source,
    const CFI_index_t lower_bounds[], const CFI_index_t upper_bounds[], const CFI_index_t strides[]);
#define CFI_section(result,source,lower_bounds,upper_bounds,strides) \
    for_CFI_section(result,source,lower_bounds,upper_bounds,strides)

int for_CFI_select_part(CFI_cdesc_t * result, const CFI_cdesc_t * source, size_t displacement, size_t
    elem_len);
#define CFI_select_part(result,source,displacement,elem_len) \
    for_CFI_select_part(result,source,displacement,elem_len)

int for_CFI_setpointer(CFI_cdesc_t * result, CFI_cdesc_t * source, const CFI_index_t lower_bounds[]);
#define CFI_setpointer(result,source,lower_bounds) for_CFI_setpointer(result,source,lower_bounds)

#if defined(__cplusplus)
}
#endif

#endif // __ISO_FORTRAN_BINDING_INCLUDED
