#!/bin/bash
# shellcheck disable=SC2034

# Copyright (c) 2019-2020, Intel Corporation, All Rights Reserved.
#
# This software and the related documents are Intel copyrighted materials.
# Your use of them is governed by the express license under which they were
# provided to you (License). Unless the License provides otherwise, you may
# not use, modify, copy, publish, distribute, disclose or transmit this
# software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express
# or implied warranties, other than those that are expressly stated in the
# License.

# ############################################################################

# Support for -v (verbose) flag and 'speak' function.
# Use 'speak' if you want to echo only verbose is enabled.
#
# Colors are defined to be used with echo or speak (with the -e flag).
# example:
#   echo -e "the roof, the roof, the roof is ${RED}on fire${NC}!!"

# when using colors, be sure to ALWAYS bookend you usage with ${NC} (No Color)
# or you will affect the output for everyone. The following colors have been
# defined: GREEN, RED, CYAN and NC (No Color).


# capture verbose flag from supplied arguments
VERBOSE=false

for arg do
  shift
  case "$arg" in
    (-v|--verbose)
      VERBOSE=true
      ;;
    (--)
      ;;
    (*)
      set -- "$@" "$arg"
      ;;
  esac
  # echo "\$@ = " "$@"
done


# ############################################################################

# Speak() accepts the same arguments as echo.
# Speak() only echoes if the verbose flag is set.

# Usage:
#   speak "text to echo when verbose enabled")
#   see commented sample code, below
#
# Inputs:
#   one or more strings
#
# Outputs:
#   the text strings if verbose was enabled

speak() {
  if [ "$VERBOSE" = "true" ] ; then
    echo -e "$@"
  fi
}

# constants for color
GREEN='\033[0;32m'
RED='\033[0;31m'
CYAN='\033[0;36m'
NC='\033[0m' # No Color


# ############################################################################

# sample speak() usage

# ping -c1 -W1 -q example.com &>/dev/null
# status=$(echo $?)
# if [[ $status == 0 ]] ; then
#   speak -e "  Internet connection is ${GREEN}working${NC}!"
# else
#   echo -e "  Internet connection is ${RED}not working${NC}!"
#   speak -e "  'ping -c1 -W1 -q example.com' reported ${CYAN}$status${NC} return code."
# fi
