#!/bin/bash

# Copyright 2016-2020, Intel Corporation, All Rights Reserved.

# The  source code,  information and material  ("Material")  contained herein is
# owned  by  Intel  Corporation or its suppliers or licensors, and title to such
# Material  remains  with  Intel  Corporation  or  its  suppliers  or licensors.
# The  Material  contains proprietary information of  Intel or its suppliers and
# licensors.   The Material is protected by  worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published,  uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission. No license under any patent,
# copyright  or other intellectual property rights in the Material is granted to
# or conferred upon you, either expressly,  by implication, inducement, estoppel
# or  otherwise.  Any license  under such intellectual  property rights  must be
# express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not  remove or alter this
# notice or any other notice embedded in Materials by Intel or Intel's suppliers
# or licensors in any way.

is_absolute_path()
{
    echo $1 | grep '^/' > /dev/null 2>&1 ; return $?
}

detect_oneapi()
{
    local DEFAULT_INSTALL_DIR_ROOT="/opt/intel"
    local DEFAULT_INSTALL_DIR_USER="${HOME}/intel"
    
    local INSTALL_SUBDIR="/oneapi"

    local oneapi_location=""

    local DEFAULT_CACHE_DIR_ROOT="/var/intel/installercache"
    local DEFAULT_CACHE_DIR_USER="/${HOME}/intel/installercache"
    local MARKER_FILE=".installdir_marker"


    for cache_root in "${DEFAULT_CACHE_DIR_ROOT}" "${DEFAULT_CACHE_DIR_USER}" ; do
    if [ -e "${cache_root}/${MARKER_FILE}" ] ; then
        oneapi_location=`cat "${cache_root}/${MARKER_FILE}" `
            break
        fi
    done


    # if still not found, check files in default locations
    if [ -z "${oneapi_location}" -a -f "${DEFAULT_INSTALL_DIR_USER}/${INSTALL_SUBDIR}/setvars.sh" ] ; then
        oneapi_location="${DEFAULT_INSTALL_DIR_USER}"
    fi

    # last resort
    if [ -z "${oneapi_location}" ] ; then
        oneapi_location="${DEFAULT_INSTALL_DIR_ROOT}/${INSTALL_SUBDIR}"
    fi

    echo "${oneapi_location}"
}

if [ -z "$SHADOW_PREFIX" ] ; then
    SHADOW_PREFIX=`detect_oneapi`
fi

LINKS="
$PREFIX/lib/libiomp5.so	$SHADOW_PREFIX/compiler/2021.1.2/linux/compiler/lib/intel64_lin/libiomp5.so
$PREFIX/lib/libiomp5_db.so	$SHADOW_PREFIX/compiler/2021.1.2/linux/compiler/lib/intel64_lin/libiomp5_db.so
$PREFIX/lib/libiompstubs5.so	$SHADOW_PREFIX/compiler/2021.1.2/linux/compiler/lib/intel64_lin/libiompstubs5.so
$PREFIX/licensing/compiler/openmp/third-party-programs.txt	$SHADOW_PREFIX/compiler/2021.1.2/licensing/openmp/third-party-programs.txt
$PREFIX/lib/libomptarget.so	$SHADOW_PREFIX/lib/libomptarget.so
$PREFIX/lib/libomptarget.rtl.x86_64.so	$SHADOW_PREFIX/lib/libomptarget.rtl.x86_64.so
$PREFIX/lib/libomptarget.rtl.opencl.so	$SHADOW_PREFIX/lib/libomptarget.rtl.opencl.so
$PREFIX/lib/libomptarget.rtl.level0.so	$SHADOW_PREFIX/lib/libomptarget.rtl.level0.so

"

echo_toplevel_dir_for_absolute_path()
{
    echo $1 | sed 's%^/%%' | sed 's%/.*$%%g'
}

link()
{
    local BASE_DIR=$1
    local LINK=$2
    local TARGET=$3
    [ -z "$LINK" ] && return
    [ -z "$TARGET" ] && return
    [ ! -d "$BASE_DIR" ] && mkdir -p $BASE_DIR

    # link it!
    pushd $BASE_DIR > /dev/null 2>&1
    ln -sfT $RELATIVE_FLAG $TARGET $LINK > /dev/null  2>&1
    popd > /dev/null 2>&1
}

link_if_exists()
{
    local BASE_DIR=$1
    local TARGET=$3
    if is_absolute_path $TARGET ; then
        [ -e "$TARGET" ] && link $1 $2 $3
    else
        [ -e "$BASE_DIR/$TARGET" ] && link $1 $2 $3
    fi
}

rmlink()
{
    local LINK=$1
    [ -h "$LINK" ] && rm -f $LINK
}

create_links()
{
    for str in $(echo "$LINKS" | sed 's/	/;/g') ; do
        str=$(echo "$str" | sed 's/;/	/g')
        SOURCE=`echo "$str" | cut -f 1`
        BASE_DIR=`dirname $SOURCE`
        LINK_NAME=`basename $SOURCE`
        TARGET=`echo "$str" | cut -f 2`
        # link_if_exists $BASE_DIR $LINK_NAME $TARGET
        link $BASE_DIR $LINK_NAME $TARGET
    done
}

remove_links()
{
    for str in $(echo "$LINKS" | sed 's/	/;/g') ; do
        str=$(echo "$str" | sed 's/;/	/g')
        SOURCE=`echo "$str" | cut -f 1`
        BASE_DIR=`dirname $SOURCE`
        LINK_NAME=`basename $SOURCE`
        TARGET=`echo "$str" | cut -f 2`
        rmlink "$BASE_DIR/$LINK_NAME"
        rmdir -p "$BASE_DIR" || true
    done
}

create_links

exit 0

