subroutine turtke_advv(dt_dif)
    ! +------------------------------------------------------------------------+
    ! | MAR TURBULENCE (TKE)                                   14-09-2001  MAR |
    ! |   subroutine turtke_advv includes TKE Vertical Advection Contribution  |
    ! |              solved by a 1st Order Accurate in Space Upstream Scheme   |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |  INPUT / OUTPUT: The Vertical Turbulent Fluxes are included for:       |
    ! |  ^^^^^^^^^^^^^^                                                        |
    ! |       a) Turbulent Kinetic Energy             ect_TE(mx,my,mz) [m2/s2] |
    ! |       b) Turbulent Kinetic Energy Dissipation eps_TE(mx,my,mz) [m2/s3] |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_te
    use mar_wk

    implicit none

    ! +--Global Variables
    ! +  ================

    real dt_dif

    ! +--Local  Variables
    ! +  ================

    integer i, j, k, m
    real tran

    ! +--Vertical Courant Number
    ! +  =======================

    !$OMP PARALLEL do private(i,j,k,tran)
    do j = 1, my

        if(staggr) then
            do k = 1, mmz1
                !       do j=1,my
                do i = 1, mx
                    WKxyz3(i, j, k) = psigDY(i, j, k)
                enddo
                !       end do
            enddo
        else
            do k = 1, mmz1
                !       do j=1,my
                do i = 1, mx
                    WKxyz3(i, j, k) = 0.50 * (psigDY(i, j, kp1(k)) + psigDY(i, j, k))
                enddo
                !       end do
            enddo
        endif

        do k = 1, mmz1
            !       do j=1,my
            do i = 1, mx
                WKxyz1(i, j, k) = -max(zero, WKxyz3(i, j, k)) &
                                  * dt_dif / (pstDYn(i, j) * dsigm1(k))
                WKxyz2(i, j, k) = -min(zero, WKxyz3(i, j, k)) &
                                  * dt_dif / (pstDYn(i, j) * dsigm1(k + 1))
            enddo
            !       end do
        enddo

        k = mz
        !       do j=1,my
        do i = 1, mx
            WKxyz1(i, j, k) = -max(zero, WKxyz3(i, j, k)) &
                              * dt_dif / (pstDYn(i, j) * dsigm1(k))
            !       end do
        enddo

        ! +--Vertical Advection of TKE and TKE Dissipation
        ! +  =============================================

        do k = kp1(1), mz
            !       do j=1,my
            do i = 1, mx
                WKxyz4(i, j, k) = ect_TE(i, j, k) - ect_TE(i, j, k - 1)
                WKxyz5(i, j, k) = eps_TE(i, j, k) - eps_TE(i, j, k - 1)
            enddo
            !       end do
        enddo

        do k = kp1(1), mmz1
            !       do j=1,my
            do i = 1, mx
                tran = zero
                tran = WKxyz1(i, j, k) * WKxyz4(i, j, k) &
                       + WKxyz2(i, j, k) * WKxyz4(i, j, k + 1)
                ect_TE(i, j, k) = ect_TE(i, j, k) + tran
                eps_TE(i, j, k) = eps_TE(i, j, k) &
                                  + WKxyz1(i, j, k) * WKxyz5(i, j, k) &
                                  + WKxyz2(i, j, k) * WKxyz5(i, j, k + 1)

                tranTE(i, j, k) = tranTE(i, j, k) + tran / dt_dif

            enddo
            !       end do
        enddo

        ! +--Work Arrays Reset
        ! +  =================

        do k = 1, mz
            !       do j=1,my
            do i = 1, mx
                WKxyz1(i, j, k) = 0.0
                WKxyz2(i, j, k) = 0.0
                WKxyz3(i, j, k) = 0.0
                WKxyz4(i, j, k) = 0.0
                WKxyz5(i, j, k) = 0.0
            enddo
        enddo
    enddo
    !$OMP END PARALLEL DO

    return
endsubroutine turtke_advv
