#include "MAR_pp.def"
subroutine turhor_kh
    ! +------------------------------------------------------------------------+
    ! | MAR TURBULENCE HORIZONTAL                              08-04-2021  MAR |
    ! |   subroutine turhor_kh computes the Horizontal Diffusion Coefficient   |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT  (via common block)                                            |
    ! |   ^^^^^   uairDY(i,j,k): Horizontal Wind Speed (x-Direction)     (m/s) |
    ! |           vairDY(i,j,k): Horizontal Wind Speed (y-Direction)     (m/s) |
    ! |                                                                        |
    ! |   OUTPUT (via common block)                                            |
    ! |   ^^^^^^   TUkhx(i,j,k): Horizont.Diff.Coefficient (i+1/2,j,k)  (m2/s) |
    ! |            TUkhy(i,j,k): Horizont.Diff.Coefficient (i,j+1/2,k)  (m2/s) |
    ! |                                                                        |
    ! |   REFER.: Tag et al., JAM 18, 1429--1441, 1979                         |
    ! |   ^^^^^^^                                                              |
    ! +------------------------------------------------------------------------+
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_tu
    use mar_wk

    implicit none

    integer i, j, k, m

    ! +--Reset of the Horizontal Diffusion Coefficient
    ! +  =============================================

    ! +--2D Model Version
    ! +  ================

    if(mmy == 1) then

        do k = 1, mz
            do j = 1, my
                do i = 1, mx
                    TUkhx(i, j, k) = 0.0
                    TUkhy(i, j, k) = 0.0
                enddo
            enddo
        enddo

        j = 1
        do k = 1, mz
            do i = 1, mx
                WKxza(i, k) = uairDY(ip1(i), j, k) - uairDY(i, j, k)
                WKxzb(i, k) = vairDY(ip1(i), j, k) - vairDY(i, j, k)
            enddo
        enddo

        do k = 1, mz
            do i = 1, mx
                TUkhx(i, j, k) = TUkhff * dxy3(i, j) &
                                 * (sqrt(0.5 * (WKxzb(i, k) * WKxzb(i, k)) &
                                         + WKxza(i, k) * WKxza(i, k)))
                WKxza(i, k) = 0.0
                WKxzb(i, k) = 0.0
            enddo
            TUkhx(mx, j, k) = 0.0
        enddo

        ! +--Upper Absorbing Layer
        ! +  ---------------------

        if(TUkhmx > 0.0) then
            do k = 1, mzabso
                do j = 1, my
                    do i = 1, mx
                        TUkhx(i, j, k) = TUkhx(i, j, k) + TUspon(k)
                    enddo
                enddo
            enddo
        endif

        ! +--3D Model Version
        ! +  ================

    else

        !$OMP PARALLEL do private(i,j,k)
        do k = 1, mz

            do j = 1, my
                do i = 1, mx
                    TUkhx(i, j, k) = 0.0
                    TUkhy(i, j, k) = 0.0
                enddo
            enddo

            ! +--x Direction
            ! +  -----------

            do i = 1, mx
                do j = jp11, my1
                    WKxyz1(i, j, k) = &
                        vairDY(ip1(i), j, k) - vairDY(i, j, k)
                    WKxyz3(i, j, k) = &
                        uairDY(ip1(i), j, k) - uairDY(i, j, k)
                enddo
            enddo

            do j = jp11, my1
                do i = 1, mx
                    WKxyz2(i, j, k) = &
                        uairDY(i, jp1(j), k) - uairDY(i, jm1(j), k)
                    WKxyz4(i, j, k) = &
                        vairDY(i, jp1(j), k) - vairDY(i, jm1(j), k)
                    WKxyz5(i, j, k) = &
                        vairDY(i, jp1(j), k)
                    WKxyz6(i, j, k) = &
                        vairDY(i, jm1(j), k)
                enddo
            enddo

            do i = 1, mx
                do j = jp11, my1
                    TUkhx(i, j, k) = TUkhff * dxy3(i, j) * (sqrt( &
                                                            0.5 * ((WKxyz1(i, j, k) &
                                                                    + 0.5 * (WKxyz2(i, j, k)))**2) &
                                                            + (WKxyz3(i, j, k))**2 &
                                                            + (0.25 * (WKxyz4(i, j, k) &
                                                                       + WKxyz5(ip1(i), j, k) &
                                                                       - WKxyz6(ip1(i), j, k)))**2))

                    ! The 3 previous Loops Stand for the following non-vectorized Loop:
                    !          TUkhx(i,j,k) = TUkhff * dxy3(i, j) *(sqrt( &
                    !             0.5*((vairDY(ip1(i),    j ,k)-vairDY(i,    j ,k) &
                    !           + 0.5* (uairDY(i     ,jp1(j),k)-uairDY(i,jm1(j),k)))**2) &
                    !           +      (uairDY(ip1(i),    j ,k)-uairDY(i,    j ,k)) **2 &
                    !           +(0.25*(vairDY(i     ,jp1(j),k)-vairDY(i,jm1(j),k) &
                    !                  +vairDY(ip1(i),jp1(j),k) &
                    !                  -vairDY(ip1(i),jm1(j),k)))**2))
                enddo
            enddo

            ! +--y Direction
            ! +  -----------

            do j = 1, my
                do i = ip11, mx1
                    WKxyz1(i, j, k) = &
                        vairDY(i, jp1(j), k) - vairDY(i, j, k)
                    WKxyz3(i, j, k) = &
                        uairDY(i, jp1(j), k) - uairDY(i, j, k)
                enddo
            enddo

            do i = ip11, mx1
                do j = 1, my
                    WKxyz2(i, j, k) = &
                        uairDY(ip1(i), j, k) - uairDY(im1(i), j, k)
                    WKxyz4(i, j, k) = &
                        vairDY(ip1(i), j, k) - vairDY(im1(i), j, k)
                    WKxyz5(i, j, k) = &
                        vairDY(ip1(i), j, k)
                    WKxyz6(i, j, k) = &
                        vairDY(im1(i), j, k)
                enddo
            enddo

            do j = 1, my
                do i = ip11, mx1
                    TUkhy(i, j, k) = TUkhff * dxy3(i, j) * (sqrt( &
                                                            0.5 * ((WKxyz1(i, j, k) &
                                                                    + 0.5 * (WKxyz2(i, j, k)))**2) &
                                                            + (WKxyz3(i, j, k))**2 &
                                                            + (0.25 * (WKxyz4(i, j, k) &
                                                                       + WKxyz5(i, jp1(j), k) &
                                                                       - WKxyz6(i, jp1(j), k)))**2))

                    ! The 3 previous Loops Stand for the following non-vectorized Loop:
                    !          TUkhy(i,j,k) = TUkhff * dxy3(i, j) *(sqrt( &
                    !             0.5*((vairDY(    i ,jp1(j),k)-vairDY(    i ,j,k) &
                    !           + 0.5* (uairDY(ip1(i),    j ,k)-uairDY(im1(i),j,k)))**2) &
                    !           +      (uairDY(    i ,jp1(j),k)-uairDY(    i ,j,k)) **2 &
                    !           +(0.25*(vairDY(ip1(i),    j ,k)-vairDY(im1(i),j,k) &
                    !                  +vairDY(ip1(i),jp1(j),k) &
                    !                  -vairDY(im1(i),jp1(j),k)))**2))
                enddo
            enddo

            do i = 1, mx
                do j = jp11, my1
                    WKxyz1(i, j, k) = 0.
                    WKxyz2(i, j, k) = 0.
                    WKxyz3(i, j, k) = 0.
                    WKxyz4(i, j, k) = 0.
                    WKxyz5(i, j, k) = 0.
                    WKxyz6(i, j, k) = 0.
                enddo
            enddo

            ! +--Upper Absorbing Layer
            ! +  ---------------------

            if(k <= mzabso .and. TUkhmx > 0.0) then

                do j = 1, my
                    do i = 1, mx
                        TUkhx(i, j, k) = TUkhx(i, j, k) + TUspon(k)
                        TUkhy(i, j, k) = TUkhy(i, j, k) + TUspon(k)
                    enddo
                enddo
            endif
        enddo
        !$OMP END PARALLEL DO

    endif

#ifdef OB
    ! +--Lateral Boundary Values
    ! +  -----------------------
    if(mmx > 1) then
        do k = 1, mz
            do j = 1, my
                TUkhx(1, j, k) = 0.0
                TUkhx(mx, j, k) = 0.0
                TUkhy(1, j, k) = 0.0
                TUkhy(mx, j, k) = 0.0
            enddo
        enddo
    endif
    if(mmy > 1) then
        do k = 1, mz
            do i = 1, mx
                TUkhx(i, 1, k) = 0.0
                TUkhx(i, my, k) = 0.0
                TUkhy(i, 1, k) = 0.0
                TUkhy(i, my, k) = 0.0
            enddo
        enddo
    endif
#endif
    return
end
