! trackwind, Cécile Agosta, Oct. 2022
! track changes in winds (momentum budget)
!
module trackwind
    implicit none
    ! track_winf : activation of trackwind in mar
    logical, parameter :: track_wind = .false.
    ! track dyndgz : activation of trackwind in dyndgz, to distangle advection from pressure gradient force
    logical, parameter :: track_wind_dyndgz = .false.
    ! ntwind : effective number of tracked wind component
    integer, save :: ntwind
    ! ntwind_dgz : effective number of tracked wind component in dyndgz
    integer, parameter :: ntwind_dgz = 3
    ! wind
    ! ====
    ! tracked components indexes
    integer, save :: i_dyndgz ! dyndgz : Horizontal Pressure Gradient Force
    integer, save :: i_dynfil ! dynfil : Horizontal filtering
    integer, save :: i_coriol ! coriol : Coriolis
    integer, save :: i_turhor ! turhor : Horizontal diffusion
    integer, save :: i_turabl ! turabl : Boundary Layer Turbulence
    integer, save :: i_lbcnud ! lbcnud : Lateral Boundary Condition
    ! index for dyndgz
    integer, save :: i_dyndgz_adv ! dgzadv : Advection contribution to Horizontal PGF
    integer, save :: i_dyndgz_pgf ! dgzpgf : Horizontal PGF
    integer, save :: i_dyndgz_ray ! dgzpgf : Rayleigh Friction
    integer, save :: iloc_adv ! local dyndgz index for advetion
    integer, save :: iloc_pgf ! local dyndgz index for PGH
    integer, save :: iloc_ray ! local dyndgz index for Rayleigh Friction
    integer, save :: itw_dgz(ntwind_dgz) ! local dgz index
    ! momentum : horizontal wind
    ! ==========================
    ! tracked components names
    character(len = 3), allocatable, save :: name_wind(:)
    ! delta_u, delta_v : cumulative change in wind components
    real, allocatable, save :: delta_u(:, :, :, :) ! (mx, my, mz, ntwind)
    real, allocatable, save :: delta_v(:, :, :, :) ! (mx, my, mz, ntwind)
    ! uairDY_save, vairDY_save : Save state before routine call
    real, allocatable :: uairDY_save(:, :, :)
    real, allocatable :: vairDY_save(:, :, :)
    ! for out_nc outputs
    ! ==================
    real, allocatable, save :: delta_u_NCsave(:, :, :, :) ! (mx, my, mz, ntwind)
    real, allocatable, save :: delta_v_NCsave(:, :, :, :) ! (mx, my, mz, ntwind)
    ! ddelta_wind = delta_wind - delta_wind_save
    real, allocatable :: ddelta_wind(:, :, :)
    ! for outice outputs
    ! ==================
    real, allocatable, save :: duIB(:, :, :, :) ! duIB : delta_u in m s-1 h-1
    real, allocatable, save :: dvIB(:, :, :, :) ! dvIB : delta_v in m s-1 h-1
    real, allocatable, save :: delta_u_IBsave(:, :, :, :) ! delta_u_IBsave : delta_u from previous time save
    real, allocatable, save :: delta_v_IBsave(:, :, :, :) ! delta_v_IBsave : delta_v from previous time save
    ! temporary variables
    ! ===================
    integer itw ! iteration for tracked wind chances
    integer iloc ! iteration for tracked wind chances in dyndgz
    real :: c1a_tmp(ntwind_dgz)
    real :: ddux_tmp(ntwind_dgz)
    real :: ddvx_tmp(ntwind_dgz)
    real, allocatable, save :: ubef(:, :, :, :)
    real, allocatable, save :: vbef(:, :, :, :)
    real, allocatable, save :: dg1x(:, :, :, :)
    real, allocatable, save :: dgzx(:, :, :, :)
    real, allocatable, save :: dg1y(:, :, :, :)
    real, allocatable, save :: dgzy(:, :, :, :)
    
    ! ! momentum : vertical wind psig
    ! ! =============================
    ! real :: psigDY_save(mx, my, mz) ! Save state before routine call
    ! ! dyndps : Mass Continuity
    ! real, save :: dp_dyndps(mx, my, mz)
    ! ! dynfil : Filtering
    ! real, save :: dp_dynfil(mx, my, mz)

contains
    
    subroutine trackwind_init()
        use mardim, only : mx, my, mz
        use mar_ib, only : ml
        implicit none
        ! set up indexes
        ! ==============
        ! ntwind : effective number of tracked wind component
        ntwind = 0
        ntwind = ntwind + 1
        i_dyndgz = ntwind
        ntwind = ntwind + 1
        i_dynfil = ntwind
        ntwind = ntwind + 1
        i_coriol = ntwind
        ntwind = ntwind + 1
        i_turhor = ntwind
        ntwind = ntwind + 1
        i_turabl = ntwind
        ntwind = ntwind + 1
        i_lbcnud = ntwind
        if(track_wind_dyndgz) then
            iloc = 0
            ! Horizontal advection
            ntwind = ntwind + 1
            iloc = iloc + 1
            i_dyndgz_adv = ntwind
            iloc_adv = iloc
            itw_dgz(iloc_adv) = i_dyndgz_adv
            ! PGF
            ntwind = ntwind + 1
            iloc = iloc + 1
            i_dyndgz_pgf = ntwind
            iloc_pgf = iloc
            itw_dgz(iloc_pgf) = i_dyndgz_pgf
            ! Rayleigh friction
            ntwind = ntwind + 1
            iloc = iloc + 1
            i_dyndgz_ray = ntwind
            iloc_ray = iloc
            itw_dgz(iloc_ray) = i_dyndgz_ray
        endif
        allocate(name_wind(ntwind))
        ! set wind names
        ! ===============
        name_wind(i_dyndgz) = 'dgz'
        name_wind(i_dynfil) = 'fil'
        name_wind(i_coriol) = 'cor'
        name_wind(i_turhor) = 'dif'
        name_wind(i_turabl) = 'tur'
        name_wind(i_lbcnud) = 'lbc'
        if(track_wind_dyndgz) then
            name_wind(i_dyndgz_adv) = 'adv'
            name_wind(i_dyndgz_pgf) = 'pgf'
            name_wind(i_dyndgz_ray) = 'ray'
        endif
        ! allocates
        ! =========
        allocate(uairDY_save(mx, my, mz))
        allocate(vairDY_save(mx, my, mz))
        allocate(delta_u(mx, my, mz, ntwind))
        allocate(delta_v(mx, my, mz, ntwind))
        allocate(delta_u_NCsave(mx, my, mz, ntwind))
        allocate(delta_v_NCsave(mx, my, mz, ntwind))
        allocate(ddelta_wind(mx, my, mz))
        allocate(duIB(mx, my, ml, ntwind))
        allocate(dvIB(mx, my, ml, ntwind))
        allocate(delta_u_IBsave(mx, my, mz, ntwind))
        allocate(delta_v_IBsave(mx, my, mz, ntwind))
        ! initial values
        ! ==============
        uairDY_save = 0.
        vairDY_save = 0.
        delta_u = 0.
        delta_v = 0.
        delta_u_NCsave = 0.
        delta_v_NCsave = 0.
        ddelta_wind = 0.
        duIB = 0.
        dvIB = 0.
        delta_u_IBsave = 0.
        delta_v_IBsave = 0.
        ! temporary variables
        ! ===================
        if(track_wind_dyndgz) then
            ! allocate
            allocate(ubef(mx, my, mz, ntwind_dgz))
            allocate(vbef(mx, my, mz, ntwind_dgz))
            allocate(dg1x(mx, my, mz, ntwind_dgz))
            allocate(dgzx(mx, my, mz, ntwind_dgz))
            allocate(dg1y(mx, my, mz, ntwind_dgz))
            allocate(dgzy(mx, my, mz, ntwind_dgz))
            ! initial values
            c1a_tmp = 0.
            ddux_tmp = 0.
            ddvx_tmp = 0.
            ubef = 0.
            vbef = 0.
            dg1x = 0.
            dgzx = 0.
            dg1y = 0.
            dgzy = 0.
        endif
    
    endsubroutine trackwind_init

endmodule trackwind
