! trackwater, Cécile Agosta, Oct. 2022
! track changes in water vapor (water budget)
module trackwater
    ! track_water : activation of trackwater in mar
    logical, parameter :: track_water = .false.
    ! track turabl : activation of trackwater in turabl, to distangle surface sublimation from mixing
    logical, parameter :: track_water_turabl = .false.
    ! track dynadv : activation of trackwater in dynadv_lfb_2p, to distangle horizontal from vertical advection
    logical, parameter :: track_water_dynadv = .false.
    ! ntwater : effective number of tracked water component
    integer, save :: ntwater
    ! water vapor
    ! ===========
    ! tracked components indexes
    integer, save :: j_dynadv ! dynadv : LFB horizontal advection
    integer, save :: j_turhor ! turhor : Horizontal diffusion
    integer, save :: j_turabl ! turabl : Boundary Layer Turbulence
    integer, save :: j_sspray ! sspray : Sea Spray
    integer, save :: j_hydgen ! hydgen : Microphysics
    integer, save :: j_lbcnud ! lbcnud : Lateral Boundary Condition
    integer, save :: j_cvagen ! cvagen : Convection
    ! index for turabl
    integer, save :: j_turabl_mix ! turabl_mix : Mixing with other layers without surface sublimation
    integer, save :: j_turabl_sbl ! turabl_sbl : Mixing of surface sublimation
    ! index for dynadv_lfb_2p
    integer, save :: j_dynadv_hor ! dynadv_hor : Horizontal advection
    integer, save :: j_dynadv_ver ! dynadv_ver : Vertical advection
    integer, save :: j_dynadv_sav ! dynadv_sav : Mass conservation operations
    ! tracked components names
    character(len = 3), allocatable, save :: name_water(:)
    ! delta_qv : cumulative change in water vapor components (kg/kg)
    real, allocatable, save :: delta_qv(:, :, :, :)
    ! qvDY_save : Save state before routine call (kg/kg)
    real, allocatable :: qvDY_save(:, :, :)
    ! for out_nc outputs (kg/kg)
    ! ==========================
    real, allocatable, save :: delta_qv_NCsave(:, :, :, :)
    ! ddelta_water = delta_qv - delta_qv_save (kg/kg)
    real, allocatable :: ddelta_water(:, :, :)
    ! for outice outputs
    ! ==================
    real, allocatable, save :: dqvIB(:, :, :, :) ! dqvIB : delta_qv in (g / kg) hour-1
    real, allocatable, save :: delta_qv_IBsave(:, :, :, :) ! delta_qv_IBsave : delta_qv from previous time save (kg / kg)
    ! temporary variables
    ! ===================
    integer jtw ! iteration for tracked water changes
    real :: delta_qv_tmp ! temporary variable in turabl
    real, allocatable :: dqp1_h(:, :, :) ! temporary variable in dynadv_lfb_2p
    real, allocatable :: dqp1_v(:, :, :) ! temporary variable in dynadv_lfb_2p
    real, allocatable :: dqm1_h(:, :, :) ! temporary variable in dynadv_lfb_2p
    real, allocatable :: dqm1_v(:, :, :) ! temporary variable in dynadv_lfb_2p

contains
    
    subroutine trackwater_init()
        use mardim, only : mx, my, mz
        use mar_ib, only : ml
        implicit none
        ! set up indexes
        ! ==============
        ! ntwater : effective number of tracked water component
        ntwater = 0
        ntwater = ntwater + 1
        j_dynadv = ntwater
        ntwater = ntwater + 1
        j_turhor = ntwater
        ntwater = ntwater + 1
        j_turabl = ntwater
        ntwater = ntwater + 1
        j_sspray = ntwater
        ntwater = ntwater + 1
        j_hydgen = ntwater
        ntwater = ntwater + 1
        j_lbcnud = ntwater
        ntwater = ntwater + 1
        j_cvagen = ntwater
        if(track_water_turabl) then
            ntwater = ntwater + 1
            j_turabl_mix = ntwater
            ntwater = ntwater + 1
            j_turabl_sbl = ntwater
        endif
        if(track_water_dynadv) then
            ntwater = ntwater + 1
            j_dynadv_hor = ntwater
            ntwater = ntwater + 1
            j_dynadv_ver = ntwater
            ntwater = ntwater + 1
            j_dynadv_sav = ntwater
        endif
        allocate(name_water(ntwater))
        ! set water names
        ! ===============
        name_water(j_dynadv) = 'adv'
        name_water(j_turhor) = 'dif'
        name_water(j_turabl) = 'tur'
        name_water(j_sspray) = 'spr'
        name_water(j_hydgen) = 'hyd'
        name_water(j_lbcnud) = 'lbc'
        name_water(j_cvagen) = 'cva'
        if(track_water_turabl) then
            name_water(j_turabl_mix) = 'mix'
            name_water(j_turabl_sbl) = 'sbl'
        endif
        if(track_water_dynadv) then
            name_water(j_dynadv_hor) = 'hor'
            name_water(j_dynadv_ver) = 'ver'
            name_water(j_dynadv_sav) = 'sav'
        endif
        ! allocates
        ! =========
        allocate(qvDY_save(mx, my, mz))
        allocate(delta_qv(mx, my, mz, ntwater))
        allocate(delta_qv_NCsave(mx, my, mz, ntwater))
        allocate(ddelta_water(mx, my, mz))
        allocate(dqvIB(mx, my, ml, ntwater))
        allocate(delta_qv_IBsave(mx, my, mz, ntwater))
        ! initial values
        ! ==============
        qvDY_save = 0.
        delta_qv = 0.
        delta_qv_NCsave = 0.
        ddelta_water = 0.
        dqvIB = 0.
        delta_qv_IBsave = 0.
        ! temporary variables
        ! ===================
        delta_qv_tmp = 0.
        if(track_water_dynadv) then
            ! allocate
            allocate(dqp1_h(mx, my, mz), dqp1_v(mx, my, mz))
            allocate(dqm1_h(mx, my, mz), dqm1_v(mx, my, mz))
            ! initial values
            dqp1_h = 0.
            dqp1_v = 0.
            dqm1_h = 0.
            dqm1_v = 0.
        endif
    endsubroutine trackwater_init

endmodule trackwater
