subroutine tlat(tlat_a, tlat_b, tlat_c, tlat_d, tlat_p, tlat_q, nx, n, tlat_x)
    ! +
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS FILTER                                    20-09-2001  MAR |
    ! |   subroutine tlat  uses the Gaussian Elimination Algorithm             |
    ! |    (e.g. Pielke (1984), pp.302--303)                                   |
    ! |    (needed to solve the implicit scheme developped for filtering)      |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:   tlat_a,tlat_b,tlat_c: tri-diagional matrix coefficients     |
    ! |   ^^^^^    tlat_d              : tri-diagional matrix independent term |
    ! |            tlat_p,tlat_q       : working          variables            |
    ! |            n                   : dimension of the variables            |
    ! |            ix                  : switch                                |
    ! |            tlat_x              : variable to solve                     |
    ! |                                                                        |
    ! |   OUTPUT:  tlat_x                                                      |
    ! |   ^^^^^^                                                               |
    ! +------------------------------------------------------------------------+
    ! +
    implicit none
    ! +
    integer nx, n
    real tlat_a(nx), tlat_b(nx), tlat_c(nx), tlat_d(nx)
    real tlat_x(nx), tlat_p(nx), tlat_q(nx)
    ! +
    integer k, l
    integer ix
    ! +
    data ix/0/
    ! +
    ! +
    ! +--Forward  Sweep
    ! +  ==============
    ! +
    if(ix /= 1) then
        tlat_p(1) = tlat_b(1)
        tlat_q(1) = -tlat_c(1) / tlat_p(1)
        do k = 2, n
            tlat_p(k) = tlat_a(k) * tlat_q(k - 1) + tlat_b(k)
            tlat_q(k) = -tlat_c(k) / tlat_p(k)
        enddo
    endif
    ! +
    tlat_x(1) = tlat_d(1) / tlat_p(1)
    do k = 2, n
        tlat_x(k) = (tlat_d(k) - tlat_a(k) * tlat_x(k - 1)) / tlat_p(k)
    enddo
    ! +
    ! +
    ! +--Backward Sweep
    ! +  ==============
    ! +
    do l = 2, n
        k = n - l + 1
        tlat_x(k) = tlat_q(k) * tlat_x(k + 1) + tlat_x(k)
    enddo
    ! +
    return
endsubroutine tlat
