subroutine timgeo
    ! +------------------------------------------------------------------------+
    ! | MAR TIME                                                1-11-2001  MAR |
    ! |   subroutine timgeo computes Current Universal and Local Times         |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |    INPUT (via common block)                                            |
    ! |    ^^^^^  itexpe: Experiment Iteration Counter                         |
    ! |           itizGE(mx,my): Time Zone                                     |
    ! |                                                                        |
    ! |   OUTPUT (via common block)                                            |
    ! |   ^^^^^^  iyrrGE       : year                                          |
    ! |           mmarGE       : Month                                         |
    ! |           jdarGE       : Day                                           |
    ! |           jhurGE       : Universal Time                      (Hour UT) |
    ! |           jhlrGE(mx,my): Local     Time                      (Hour LT) |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge

    implicit none

    ! +--Local  Variables
    ! +  ================
    integer i, j, k, m
    !XF
    integer njmo, leap
    integer(kind=8) jdarGE8, jhurGE8, minuGE8, jsecGE8
    !XF

    ! +--Universal Time
    ! +  ==============
    iyrrGE = iyr0GE
    mmarGE = mma0GE
    jdarGE8 = jda0GE
    jhurGE8 = jhu0GE
    minuGE8 = 0
    jsecGE8 = itexpe * idt
240 continue
    if(jsecGE8 < 60) go to 241
    jsecGE8 = jsecGE8 - 60
    minuGE8 = minuGE8 + 1
    go to 240
241 continue
    if(minuGE8 < 60) go to 242
    minuGE8 = minuGE8 - 60
    jhurGE8 = jhurGE8 + 1
    go to 241
242 continue
    if(jhurGE8 < 24) go to 243
    jhurGE8 = jhurGE8 - 24
    jdarGE8 = jdarGE8 + 1
    go to 242
243 continue
    !XF
    leap = 1
    if(mod(iyrrGE, 100) == 0 .and. mod(iyrrGE, 400) /= 0) leap = 0
    !XF

    njmo = njmoGE(mmarGE) &
           + njmbGE(mmarGE) * max(0, 1 - mod(iyrrGE, 4)) &
           * leap

    if(jdarGE8 <= njmo) go to 244
    jdarGE8 = jdarGE8 - njmo
    mmarGE = mmarGE + 1
    if(mmarGE <= 12) go to 243
    mmarGE = mmarGE - 12
    iyrrGE = iyrrGE + 1
    go to 243
244 continue

    ! +--Local     Time
    ! +  ==============
    do j = 1, my
        do i = 1, mx
            jhlrGE(i, j) = jhurGE8 + itizGE(i, j)
            if(jhlrGE(i, j) >= 24) jhlrGE(i, j) = jhlrGE(i, j) - 24
            if(jhlrGE(i, j) < 0) jhlrGE(i, j) = jhlrGE(i, j) + 24
        enddo
    enddo
    jdarGE = jdarGE8
    jhurGE = jhurGE8
    minuGE = minuGE8
    jsecGE = jsecGE8
    return
endsubroutine timgeo
