#include "MAR_pp.def"
subroutine time_steps
    ! +------------------------------------------------------------------------+
    ! | MAR time_steps                                       02-03-2022    MAR |
    ! +------------------------------------------------------------------------+

    use mardim
    use mar_ge
    use margrd
    use marphy
    use marctr
    use mar_sv
    use marssn
    use mar_ib

    implicit none

    character(8) :: date_mar
    character(10) :: time_mar

    real dt_base, new_dt

    new_dt = dt

    if(mod(int(real(3600.*24./OutdyIB) / dt), 1) /= 0) dt = dt - 5

    if(dt > 300) new_dt = 300
    if(dx <= 30000 .and. dt > 240) new_dt = 240
    if(dx <= 25000 .and. dt > 180) new_dt = 180
    if(dx <= 20000 .and. dt > 150) new_dt = 150
    if(dx <= 15000 .and. dt > 120) new_dt = 120
    if(dx <= 10000 .and. dt >  90) new_dt = 90
    if(dx <= 5000  .and. dt >  60) new_dt = 60
    if(dx <= 2500  .and. dt >  30) new_dt = 30

    if(dt > 300               ) new_dt = 240
    if(dt > 240 .and. dt < 300) new_dt = 240
    if(dt > 225 .and. dt < 240) new_dt = 225
    if(dt > 200 .and. dt < 225) new_dt = 200
    if(dt > 180 .and. dt < 200) new_dt = 180
    if(dt > 150 .and. dt < 180) new_dt = 150
    if(dt > 120 .and. dt < 150) new_dt = 120
    if(dt > 100 .and. dt < 120) new_dt = 100
    if(dt > 90  .and. dt < 100) new_dt = 90
    if(dt > 80  .and. dt <  90) new_dt = 80
    if(dt > 75  .and. dt <  80) new_dt = 75
    if(dt > 60  .and. dt <  75) new_dt = 60
    if(dt > 50  .and. dt <  60) new_dt = 50
    if(dt > 45  .and. dt <  50) new_dt = 45
    if(dt > 40  .and. dt <  45) new_dt = 40
    if(dt > 30  .and. dt <  40) new_dt = 30
    if(dt > 25  .and. dt <  30) new_dt = 25
    if(dt > 20  .and. dt <  25) new_dt = 20
    if(dt > 15  .and. dt <  20) new_dt = 15
    if(dt > 12  .and. dt <  15) new_dt = 12
    if(dt > 10  .and. dt <  12) new_dt = 10
    if(dt > 8   .and. dt <  10) new_dt = 8
    if(dt > 5   .and. dt <   8) new_dt = 5
    if(dt > 2   .and. dt <   5) new_dt = 2
    if(dt < 2) stop

    if(dt /= new_dt) then

        write(6, *)
        write(6, 800) nint(dt), nint(new_dt)
        write(6, *)
800     format(" ERROR: The time step is too high!! ", i3, "s ->", i3, "s")

        itexpe = nint(real(itexpe) * dt / new_dt)
        nboucl = nint(real(nboucl) * dt / new_dt)
        jtRadi2 = nint(real(jtRadi2) * dt / new_dt)

        dt = new_dt
        idt = dt
        jdt = (dt - idt) * 100.
        dtfast = dt / (ntFast + 1)

        call timgeo()

    endif

    !     -----------------------------------------------------------------

    dt_base = 60.
    if(dt > 60) dt_base = min(dt / 2., dt_base)

    !     -----------------------------------------------------------------

    jtRadi2 = min(int(real(3600.*24./OutdyIB) / dt), jtRadi2)

    !     ! characteristic time of radCEP (3600s)
    jtRadi2 = max(900 / int(dt), jtRadi2) ! 15 min
    jtRadi2 = min(3 * 3600 / int(dt), jtRadi2) ! 3h

    if(600./real(jtRadi2) /= 600 / jtRadi2) &
        jtRadi2 = max(900 / int(dt), jtRadi2)

    if(900./real(jtRadi2) /= 900 / jtRadi2) &
        jtRadi2 = max(1200 / int(dt), jtRadi2)

    if(1200./real(jtRadi2) /= 1200 / jtRadi2) &
        jtRadi2 = max(1800 / int(dt), jtRadi2)

    if(1800./real(jtRadi2) /= 1800 / jtRadi2) &
        jtRadi2 = max(3600 / int(dt), jtRadi2)

    jtRadi = jtRadi2

    !     -----------------------------------------------------------------

    !     ! characteristic time of sisvat (60s)
    ntPhys = nint(dt / dt_base)
    !c#BS ntPhys  = max(2,ntPhys)

    !     ! characteristic time of Hydmic (60s)
    ntHyd = nint(dt / dt_base)
    !c#BS ntHyd   = max(2,ntHyd)

    !     ! subgrid scale steps (turbulence and convection) (60s)
    ntDiff = nint(dt / dt_base)
    if(OutdyIB > 4) ntDiff = max(2, ntDiff)
#ifdef BS
    ntDiff = max(2, ntDiff)
#endif

    ntPhys = min(3, max(1, ntPhys))
    ntHyd  = min(3, max(1, ntHyd))
    ntDiff = min(2, max(1, ntDiff))

    dtPhys = dt / real(ntPhys)
    dtHyd  = dt / real(ntHyd)
    dtDiff = dt / real(ntDiff)

    dtRadi = max(600., min(7200., dt * jtRadi)); jtRadi = real(dtRadi) / dt

    !     -----------------------------------------------------------------

    call date_and_time(DATE=date_mar)
    call date_and_time(TIME=time_mar)

    write(6, 400) jdarGE, mmarGE, iyrrGE, jhurGE, minuGE, jsecGE

400 format(/,' MAR  time : ', i2, '/', i2, '/', i4, ' ', i2, ':', i2, ':', i2)

    write(6, *) "Real time : "//date_mar(5:6)//"/" &
        //date_mar(7:8)//"/"//date_mar(1:4)//" "//time_mar(1:2) &
        //":"//time_mar(3:4)//":"//time_mar(5:6)

    write(6, 401) dt, dtHyd, dtDiff, dtRadi, nt_Mix
401 format(' Step time : dt=', f5.1, ", dtHyd=", f5.1, &
           ", dtDiff=", f5.1, ", dtRadi=", f6.0, ' s', &
           ", nt_Mix=", i2,/)

endsubroutine time_steps
