subroutine timcur
    ! +------------------------------------------------------------------------+
    ! | MAR TIME                                               18-09-2001  MAR |
    ! |   subroutine timcur computes MAR               Time                    |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |    INPUT (via common block)                                            |
    ! |    ^^^^^  itexpe: Experiment Iteration Counter                         |
    ! |                                                                        |
    ! |   OUTPUT (via common block)                                            |
    ! |   ^^^^^^  jdaMAR: Nb of Days    Since Run Beginning (i.e. itexpe = 0)  |
    ! |           jhaMAR: Nb of Hours                                          |
    ! |           jmmMAR: Nb of Minutes                                        |
    ! |           jssMAR: Nb of Seconds                                        |
    ! |           jhaRUN: Nb of Hours   Since Run Beginning                    |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use marctr
    use marphy
    use mardim
    use margrd

    implicit none

    ! +--MAR Time
    ! +  ========
    jssMAR = itexpe * idt
    jmmMAR = jssMAR / 60
    jhaRUN = jmmMAR / 60
    jdaMAR = jhaRUN / 24
    jhaMAR = jhaRUN - jdaMAR * 24
    jmmMAR = jmmMAR - (jdaMAR * 24 + jhaMAR) * 60
    jssMAR = jssMAR - ((jdaMAR * 24 + jhaMAR) * 60 + jmmMAR) * 60
    return
endsubroutine timcur
