subroutine TIMcor(i, j)
    ! +------------------------------------------------------------------------+
    ! | MAR TIME                                               30-11-2000  MAR |
    ! |   subroutine TIMcor computes Corrected Local Times                     |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |    INPUT (via common block)                                            |
    ! |    ^^^^^  jhurGE     : Universal Time                        (Hour UT) |
    ! |           itizGE(i,j): Time Zone      of Grid Point (i,j)              |
    ! |           jhlrGE(i,j): Local     Time at Grid Point (i,j)    (Hour LT) |
    ! |           mmarGE     : Month                                           |
    ! |           jdarGE     : Day                                             |
    ! |                                                                        |
    ! |   OUTPUT: mmplus     : Month    (corrected)                            |
    ! |   ^^^^^^^ jdplus     : Day      (corrected)                            |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marphy
    use mardim
    use margrd
    use mar_ge

    implicit none

    integer, intent(in) :: i
    integer, intent(in) :: j

    ! +--Corrected Time Base
    ! +  ===================

    jdplus = jdarGE
    if(jhurGE + itizGE(i, j) < jhlrGE(i, j)) jdplus = jdarGE - 1
    if(jhurGE + itizGE(i, j) > jhlrGE(i, j)) jdplus = jdarGE + 1
    if(jdplus == 0) then
        mmplus = mmarGE - 1 + 12
        mmplus = mod(mmplus, 12)
        jdplus = njmoGE(mmplus)
    else
        if(jdplus > njmoGE(mmarGE)) then
            mmplus = mmarGE + 1
            jdplus = 1
        else
            mmplus = mmarGE
        endif
    endif

    return
endsubroutine TIMcor
