#include "MAR_pp.def"
subroutine svasav(ordr)
    ! +------------------------------------------------------------------------+
    ! | MAR OUTPUT                                             12-07-2019  MAR |
    ! |   subroutine svasav is used to save the main SVAT  Variables           |
    ! |                                                                        |
    ! | # OPTIONS:   #OA: Ocean Albedo is prescribed                           |
    ! | # ^^^^^^^^                                                             |
    ! +------------------------------------------------------------------------+
    use marctr
    use mardim
    use margrd
    use mar_ge
    use mar_lb
    use mar_sl
    use mar_sv
    use mar_tv
    use mar_vb
    use marssn
    use mardsv
    use mar_bs
    use mar_ib
#ifdef iso
    use mariso, only: iso_init_type, rosSNo_iso, wasSNo_iso, SWaSNo_iso, &
                      snohSN_iso, eta_TV_iso, wiso, niso
#endif

    implicit none

    ! +--Global Variables
    ! +  ================
    character(len=4) ordr

    ! +--Local  Variables
    ! +  ================
    integer i, j, k, m
    character(len=6) vartyp
    integer n1, n2, iteSVA, iyrSVA, mmaSVA, jdaSVA, jhuSVA, n
    integer i50, j50, iim, jjm, msc
    integer(kind=8) itexpe2
    logical :: iniWRI
    data iniWRI/.true./
    real mskSNo2(mx, my)
    real wes_IB(mx, my, mw), weetIB(mx, my, mw)

    ! +--READ
    ! +  ====
    if(ordr == 'read') then
404     continue ! problem of itexpe
        ! +--Open File
        ! +  ---------
        open(unit=11, status='old', form='unformatted', file='MARsvt.DAT')
        ! +--Read DATA
        ! +  ---------
        read(11) iteSVA
        read(11) iyrSVA, mmaSVA, jdaSVA, jhuSVA
        if(itexpe == 0) then
            if(iteSVA /= itexpe .or. &
               iyrSVA /= iyr0GE .or. &
               mmaSVA /= mma0GE .or. &
               jdaSVA /= jda0GE .or. &
               jhuSVA /= jhu0GE) then
                write(6, 600) itexpe, iyrSVA, mmaSVA, jdaSVA, jhuSVA, &
                    iyr0GE, mma0GE, jda0GE, jhu0GE
600             format(' ++ERROR++ MARsvt improperly specified ', &
                       /, '          iyr    mma    jda    jhu', &
                       /, i6, 4i7, ' Old', /, 6x, 4i7, ' Current')
            endif
        else
            if(iteSVA /= itexpe .or. &
               iyrSVA /= iyrrGE .or. &
               mmaSVA /= mmarGE .or. &
               jdaSVA /= jdarGE .or. &
               jhuSVA /= jhurGE) then
                write(6, 600) itexpe, iyrSVA, mmaSVA, jdaSVA, jhuSVA, iyrrGE, mmarGE, jdarGE, jhurGE
            endif
            if(mmaSVA /= mmarGE .or. jdaSVA /= jdarGE .or. jhuSVA /= jhurGE) then
                write(6, *)
                write(6, 400) jdarGE, mmarGE, iyrrGE, jhurGE
400             format(' MARrun time : ', i2, '/', i2, '/', i4, ' ', i2, ':00')
                write(6, 401) jdaSVA, mmaSVA, iyrSVA, jhuSVA
401             format(' MARsim time : ', i2, '/', i2, '/', i4, ' ', i2, ':00')
                write(6, *)
                itexpe2 = itexpe
                do n = -300, 300, 1
                    itexpe = real(itexpe2) / dt * (dt + n)
                    call timgeo()
                    if(iyrrGE == iyrSVA .and. mmarGE == mmaSVA .and. &
                       jdaSVA == jdarGE .and. jhuSVA == jhurGE) then
                        write(6, 402) nint(dt + n)
402                     format(' Previous time step:', i4)
                        write(6, 403) nint(dt)
403                     format(' Current  time step:', i4)
                        write(6, *) "Reinitialization of itexpe..."
                        write(6, *)
                        close(11)
                        goto 404
                    endif
                enddo
                stop
            endif
        endif
        ! IOi_TV : IO i Index
        read(11) IOi_TV
        ! IOj_TV : IO j Index
        read(11) IOj_TV
        ! isolTV : Soil Type Index
        read(11) isolTV
        ! iWaFTV : =0 ==> no Water Flux  =1 ==> free Drainage
        read(11) iWaFTV
        ! AlbSTV : Dry Soil Albedo
        read(11) AlbSTV
        ! ivegTV : Vegetation Type Index
        read(11) ivegTV
        ! ifraTV : Vegetation Class Coverage
        read(11) ifraTV
        ! alaiTV : Leaf Area Index [-]
        read(11) alaiTV
        ! glf_TV : Green Leaf Fraction [-]
        read(11) glf_TV
        ! TsolTV : Soil Temperature [K]
        read(11) TsolTV
        ! eta_TV : Soil Moisture [m3/m3]
        read(11) eta_TV

        ! +--If Simulation start, then initialize further
        ! +  --------------------------------------------
        if(itexpe == 0) then
            do j = 1, my
                do i = 1, mx
                    if(isolSL(i, j) == 1) then
                        ifraTV(i, j, 1) = 100
                        ivegTV(i, j, 1) = 0
                        isolTV(i, j) = 0
#ifdef OA
                        AlbSTV(i, j) = 0.15
#endif
                    endif
                    if(isolSL(i, j) == 5) then
                        tsrfSL(i, j, 1) = 0.0d+0
                        do n = 1, nvx
                            tsrfSL(i, j, 1) = tsrfSL(i, j, 1) + TsolTV(i, j, n, 1) * ifraTV(i, j, n)
                        enddo
                        tsrfSL(i, j, 1) = tsrfSL(i, j, 1) * 1.0d-2
                        albsSL(i, j) = AlbSTV(i, j)
                        alb0SL(i, j) = albsSL(i, j)
                        albeSL(i, j) = albsSL(i, j)
                        if(tsrfSL(i, j, 1) < 200.) then
                            write(6, 6000) i, j
6000                        format(' WARNING: undefined Surface Temperature (i j) = (', 2i4, ')')
                        endif
                    endif
                    ! +--Set of SISVAT Variables
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~
                    if(VSISVAT) then
                        if(isolSL(i, j) <= 2) then
                            ifraTV(i, j, 1) = 100
                            ivegTV(i, j, 1) = 0
                            isolTV(i, j) = 0
                            if(reaVAR .and. reaLBC) then
                                do n = 1, nvx
                                    TvegTV(i, j, n) = sst_LB(i, j)
                                    do k = 1, llx
                                        TsolTV(i, j, n, k) = sst_LB(i, j)
                                        eta_TV(i, j, n, k) = 1.
                                    enddo
                                enddo
                            else
                                do n = 1, nvx
                                    TvegTV(i, j, n) = SST_SL
                                    do k = 1, llx
                                        TsolTV(i, j, n, k) = SST_SL
                                        eta_TV(i, j, n, k) = 1.
                                    enddo
                                enddo
                            endif
                        else
                            if(.not. reaLBC) then
                                do n = 1, nvx
                                    TvegTV(i, j, n) = SST_SL
                                enddo
                            else
                                do n = 1, nvx
                                    TvegTV(i, j, n) = TairSL(i, j)
                                enddo
                            endif
                        endif
                    endif
                    do n = 1, max(mw, nvx)
                        n1 = min(n, mw)
                        n2 = min(n, nvx)
                        tsrfSL(i, j, n1) = TsolTV(i, j, n2, 1)
                    enddo
                enddo
            enddo
#ifdef iso
            ! isotopic initialization of soil
            call mariso_init_tv(iso_init_type, eta_TV, eta_TV_iso)
#endif

            if(iniWRI) then
                n = 123
                i50 = min(mx, 66)
                j50 = min(my, 66)
                vartyp = 'isolTV'
                write(4, 4001) vartyp, n,((isolTV(i, j), i=1, i50), j=j50, 1, -1)
4001            format(/, ' --- svasav --- ', a6, ' ---', i4, ' ---', /,(66i2))
4002            format(/, ' --- svasav --- ', a6, ' ---', i4, ' ---', /,(66f6.2))
                vartyp = 'iWaFTV'
                write(4, 4001) vartyp, n,((iWaFTV(i, j), i=1, i50), j=j50, 1, -1)
                do n = 1, nvx
                    vartyp = 'ifraTV'
                    write(4, 4002) vartyp, n,((ifraTV(i, j, n), i=1, i50), j=j50, 1, -1)
                    vartyp = 'ivegTV'
                    write(4, 4001) vartyp, n,((ivegTV(i, j, n), i=1, i50), j=j50, 1, -1)
                enddo
                iniWRI = .false.
            endif
        endif

        ! +--If SISVAT is set up
        ! +  ~~~~~~~~~~~~~~~~~~~
        if(VSISVAT .and. .not. reaVAR) then
            do j = 1, my
                do i = 1, mx
                    sst_LB(i, j) = SST_SL
                    sst1LB(i, j) = SST_SL
                    sst2LB(i, j) = SST_SL
                enddo
            enddo
        endif

        ! +--If Simulation start, then set to zero
        ! +  -------------------------------------
        if(itexpe == 0) then
            do msc = 1, nvx
                do jjm = 1, jmx
                    do iim = 1, imx
                        CaSnTV(iim, jjm, msc) = 0.0
                        CaWaTV(iim, jjm, msc) = 0.0
                        WEq_SN(iim, jjm, msc) = 0.0
                    enddo
                enddo
            enddo
            do msc = 1, nsx
                do jjm = 1, jmx
                    do iim = 1, imx
                        snohSN(iim, jjm, msc) = 0.0
#ifdef iso
                        do wiso = 1, niso
                            snohSN_iso(wiso, iim, jjm, msc) = 0.0
                        enddo
#endif
                    enddo
                enddo
            enddo
        endif

        ! +--If Simulation restart, then read further
        ! +  ----------------------------------------
        if(itexpe /= 0 .and. reaVAR) then
            ! CaSnTV : Canopy Intercepted Snow Content[kg/m2]
            read(11) CaSnTV
            ! CaWaTV : Canopy Intercepted Water Content [kg/m2]
            read(11) CaWaTV
            ! psivTV : Vegetation Hydraulic Potential [m]
            read(11) psivTV
            ! psigTV : Ground Hydraulic Potential [m]
            read(11) psigTV
            ! TvegTV : Skin Vegetation Temperature [K]
            read(11) TvegTV
            ! TgrdTV : Skin Soil Temperature [K]
            read(11) TgrdTV
            do msc = 1, nvx
                do jjm = 1, jmx
                    do iim = 1, imx
                        if(CaWaTV(iim, jjm, msc) <= 1.d-20) then
                            CaWaTV(iim, jjm, msc) = 0.d+00
                        endif
                    enddo
                enddo
            enddo
            ! Total evapTV : Evapotranspiration [mm w.e.]
            read(11) evapTV
            ! draiTV : Drainage Flow [mm/s]
            read(11) draiTV
            ! runoTV : Integrated Drainage Flow [mm]
            read(11) runoTV

            ! +--Snow Pack Characteristics
            ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~
            if(mw /= 5) then
                ! mskSNo2 : Snow/Ice Type Index [-]
                read(11) mskSNo2
                do i = 1, mx
                    do j = 1, my
                        mskSNo(i, j, 1) = mskSNo2(i, j)
                    enddo
                enddo
            else
                ! mskSNo : Snow/Ice Type Index [-]
                read(11) mskSNo
            endif
            ! nssSNo : Nb Snow and Ice Layers
            read(11) nssSNo
            ! issSNo : Nb Superimposed Ice Layers
            read(11) issSNo
            ! nisSNo : Nb Ice Layers
            read(11) nisSNo
            ! nhsSNo : Snow History [-]
            read(11) nhsSNo
            ! dzsSNo : Snow Layers Thickness [m]
            read(11) dzsSNo
            ! rosSNo : Snow Volumic Mass [kg/m3]
            read(11) rosSNo
            ! wasSNo : Snow Water Content [kg/kg]
            read(11) wasSNo
            ! tisSNo : Snow Temperature [K]
            read(11) tisSNo
            ! g1sSNo : Snow Dendricity / Sphericity [-]
            read(11) g1sSNo
            ! g2sSNo : Snow Sphericity / Size [-] [0.0001 m]
            read(11) g2sSNo
            ! agsSNo : Snow Age [day]
            read(11) agsSNo
            do n = 1, nsno
                do k = 1, nsx
                    do j = 1, my
                        do i = 1, mx
                            if(agsSNo(i, j, k, n) <= 1000 .and. dzsSNo(i, j, k, n) > 0) then
                                agsSNo(i, j, k, n) = real(jdarGE + njyrGE(mmarGE)) / 365.+iyrrGE
                            endif
                        enddo
                    enddo
                enddo
            enddo
            ! snohSN : Snow Buffer Layer [kg/m2], [mm]
            read(11) snohSN
            ! BrosSN : Snow Buffer Layer Density [kg/m3]
            read(11) BrosSN
            ! BG1sSN : Snow Buffer Layer Dendri/Spher. [-]
            read(11) BG1sSN
            ! BG2sSN : Snow Buffer Layer Spheri/Size [-] [0.0001 m]
            read(11) BG2sSN
            ! SWaSNo : Snow Surficial Water [m]
            read(11) SWaSNo
            ! zWE0SN : Initial Snow Thickn.[mm w.e.]
            read(11) zWE0SN
            ! zWE_SN : Current Snow Thickn.[mm w.e.]
            read(11) zWE_SN
            ! zWEcSN : Non-erodible Snow Thickn.[mm w.e.]
            read(11) zWEcSN
            ! SaltSN : u*_th [m/s]
            read(11) SaltSN
            ! SLussl : u*_s* [kg/kg.m/s]
            read(11) SLussl
            ! blowSN : NEW MAX Erosion [kg/m2]
            read(11) blowSN
            ! WEq_SN : Added Snow Amount [m w.e.]
            read(11) WEq_SN
            ! SLn_z0 : Z0_momentum (instantaneous) [m]
            read(11) SLn_z0
            ! SLn_r0 : Z0_scalar (instantaneous) [m]
            read(11) SLn_r0
#ifdef BS
            ! SLn_b0 : Z0_erosion (instantaneous) [m]
            read(11) SLn_b0
#endif
#ifdef ZA
            ! ua_0BS : Wind, x-component (t-dt) [m/s]
            read(11) ua_0BS
            ! va_0BS : Wind, y-component (t-dt) [m/s]
            read(11) va_0BS
            ! VVs_BS : (wind, Sastrugi) Relevance [m/s]
            read(11) VVs_BS
            ! RRs_BS : (wind, Sastrugi) Counter [-]
            read(11) RRs_BS
            ! DDs_BS : (wind, Sastrugi) Angle [dg]
            read(11) DDs_BS
            ! Z0SaBS : Z0(Sastrugi Height) [m]
            read(11) Z0SaBS
#endif
            read(11) wes_IB  ! Snow/ice Sublimation [mm w.e.]
            read(11) weetIB  ! Evapotranspiration [mm w.e.]
            wee_IB(:, :, :, 3) = wes_IB(:, :, :)
            wee_IB(:, :, :, 1) = weetIB(:, :, :)
            read(11) wem_IB  ! Snow/ice M < ng [mm w.e.]
            read(11) wer_IB  ! Snow/ice Refreezing [mm w.e.]
            read(11) wei0IB  ! Bottom Snow/ice added [mm w.e.]
            read(11) weu_IB  ! Run-off [mm w.e.]
            read(11) zn0IB   ! Initial Snow Height [m]
            read(11) mb0IB   ! Initial Mass Balance [mmWE]
            if(mw == 5) then
                read(11) gradTM !*CL* Local temp. gradient [C/m]
                read(11) gradQM !*CL* Local hum. gradient [g/kg/m]
            endif
#ifdef iso
            ! read isotopic composition of water in the soil
            open(unit=12, status='old', form='unformatted', file='MARsvt_iso.DAT')
            ! rosSNo_iso : Snow Volumic Mass [kg/m3]
            read(12) rosSNo_iso
            ! wasSNo_iso: Soil humidity content (=> in the snow cover ) [kg/kg]
            read(12) wasSNo_iso
            ! SWaSNo_iso: Surficial Water Mass [kg/m2]
            read(12) SWaSNo_iso
            ! snohSN_iso : Snow Buffer Layer Thickness [mmWE]
            read(12) snohSN_iso
            ! eta_TV_iso : Soil Moisture Content [m3/m3]
            read(12) eta_TV_iso
            close(unit=12)
#endif
        else if(itexpe == 0) then
            do j = 1, my
                do i = 1, mx
                    evapTV(i, j) = 0.0
#ifdef ZA
                    VVs_BS(i, j) = 10.0
                    RRs_BS(i, j) = 1.0
                    DDs_BS(i, j) = 0.0
#endif
                enddo
            enddo
        endif

        close(unit=11)

        ! +--SVAT Prescribed Evolutive VBC (Vegetation Boundary Condition)
        ! +                                (i.e., Green Leaf Fraction)
        ! +  -------------------------------------------------------------
        tim1VB = ou2sGE(iyrSVA, mmaSVA, jdaSVA, jhuSVA, 0, 0)
        tim2VB = tim1VB
        do n = 1, nvx
            do j = 1, my
                do i = 1, mx
#ifdef LN
                    LAI1VB(i, j, n) = alaiTV(i, j, n)
                    LAI2VB(i, j, n) = alaiTV(i, j, n)
#endif
                    glf1VB(i, j, n) = glf_TV(i, j, n)
                    glf2VB(i, j, n) = glf_TV(i, j, n)
                enddo
            enddo
        enddo
#ifdef GL
        ! MAR-GRISLI coupling
        call ice_sheet_model_coupling
#endif
    endif

    ! +--write
    ! +  =====
    if(ordr == 'writ') then
        open(unit=11, status='unknown', form='unformatted', file='MARsvt.DAT')
        write(11) itexpe
        write(11) iyrrGE, mmarGE, jdarGE, jhurGE
        ! IOi_TV : IO i Index
        write(11) IOi_TV
        ! IOj_TV : IO j Index
        write(11) IOj_TV
        ! isolTV : Soil Type Index
        write(11) isolTV
        ! iWaFTV : =0 ==> no Water Flux =1 ==> free Drainage
        write(11) iWaFTV
        ! AlbSTV : Dry Soil Albedo
        write(11) AlbSTV
        ! ivegTV : Vegetation Type Index
        write(11) ivegTV
        ! ifraTV : Vegetation Class Coverage
        write(11) ifraTV
        ! alaiTV :  Leaf Area Index [-]
        write(11) alaiTV
        ! glf_TV : Green Leaf Fraction [-]
        write(11) glf_TV
        ! TsolTV : Soil Temperature [K]
        write(11) TsolTV
        ! eta_TV : Soil Moisture [m3/m3]
        write(11) eta_TV
        ! CaSnTV : Canopy Intercepted Snow  Content[m w.e.]
        write(11) CaSnTV
        ! CaWaTV : Canopy Intercepted Water Content [kg/m2]
        write(11) CaWaTV
        ! psivTV : Vegetation Hydraulic Potential [m]
        write(11) psivTV
        ! psigTV : Ground Hydraulic Potential [m]
        write(11) psigTV
        ! TvegTV : Skin Vegetation Temperature [K]
        write(11) TvegTV
        ! TgrdTV : Skin Soil Temperature [K]
        write(11) TgrdTV
        ! evapTV : Total Evapotranspiration [mm w.e.]
        write(11) evapTV
        ! draiTV : Drainage Flow [mm/s]
        write(11) draiTV
        ! runoTV : Integrated Drainage Flow [mm]
        write(11) runoTV
        do i = 1, mx
            do j = 1, my
                mskSNo2(i, j) = mskSNo(i, j, 1)
            enddo
        enddo
        ! +--Snow Pack Characteristics
        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~
        if(mw /= 5) then
            ! mskSNo2 : Snow/Ice Type Index [-]
            write(11) mskSNo2
        else
            ! mskSNo : Snow/Ice Type Index [-]
            write(11) mskSNo
        endif
        ! nssSNo : Nb Snow and Ice Layers
        write(11) nssSNo
        ! issSNo : Nb Superimposed Ice Layers
        write(11) issSNo
        ! nisSNo : Nb Ice Layers
        write(11) nisSNo
        ! nhsSNo : Snow History [-]
        write(11) nhsSNo
        ! dzsSNo : Snow Layers Thickness [m]
        write(11) dzsSNo
        ! rosSNo : Snow Volumic Mass [kg/m3]
        write(11) rosSNo
        ! wasSNo : Snow Water Content [m3/m3]
        write(11) wasSNo
        ! tisSNo : Snow Temperature [K]
        write(11) tisSNo
        ! g1sSNo : Snow Dendricity / Sphericity [-]
        write(11) g1sSNo
        ! g2sSNo : Snow Sphericity / Size [-] [0.0001 m]
        write(11) g2sSNo
        ! agsSNo : Snow Age [day]
        write(11) agsSNo
        ! snohSN : Snow Buffer Layer [kg/m2], [mm]
        write(11) snohSN
        ! BrosSN : Snow Buffer Layer Density [kg/m3]
        write(11) BrosSN
        ! BG1sSN : Snow Buffer Layer Dendri/Spher. [-]
        write(11) BG1sSN
        ! BG2sSN : Snow Buffer Layer Spheri/Size [-] [0.0001 m]
        write(11) BG2sSN
        ! SWaSNo : Snow Surficial Water [m]
        write(11) SWaSNo
        ! zWE0SN : Initial Snow Thickness [mm w.e.]
        write(11) zWE0SN
        ! zWE_SN : Current Snow Thickness [mm w.e.]
        write(11) zWE_SN
        ! zWEcSN : Non-erodible Snow Thickness [mm w.e.]
        write(11) zWEcSN
        ! SaltSN : u*_th [m/s]
        write(11) SaltSN
        ! SLussl : u*_s* [kg/kg.m/s]
        write(11) SLussl
        ! blowSN : NEW  MAX Erosion [kg/m2]
        write(11) blowSN
        ! WEq_SN : Added Snow Amount [m w.e.]
        write(11) WEq_SN
        ! SLn_z0 : Z0_momentum (instantaneous) [m]
        write(11) SLn_z0
        ! SLn_r0 : Z0_scalar (instantaneous) [m]
        write(11) SLn_r0
#ifdef BS
        ! SLn_b0 : Z0_erosion (instantaneous) [m]
        write(11) SLn_b0
#endif
#ifdef ZA
        ! ua_0BS : Wind, x-component (t-dt) [m/s]
        write(11) ua_0BS
        ! va_0BS : Wind, y-component (t-dt) [m/s]
        write(11) va_0BS
        ! VVs_BS : (wind, Sastrugi) Relevance [m/s]
        write(11) VVs_BS
        ! RRs_BS : (wind, Sastrugi) Counter [-]
        write(11) RRs_BS
        ! DDs_BS : (wind, Sastrugi) Angle [dg]
        write(11) DDs_BS
        ! Z0SaBS : Z0 (Sastrugi Height) [m]
        write(11) Z0SaBS
#endif
        ! wes_IB : Snow/ice Sublimation [mm w.e.]
        write(11) wes_IB
        ! wee_IB : Evapotranspiration [mm w.e.]
        write(11) weetIB
        wes_IB(:, :, :) = wee_IB(:, :, :, 3)
        weetIB(:, :, :) = wee_IB(:, :, :, 1)
        ! wem_IB : Snow/ice M < ng [mm w.e.]
        write(11) wem_IB
        ! wer_IB : Snow/ice Refreezing [mm w.e.]
        write(11) wer_IB
        ! wei0IB : Bottom Snow/ice added [mm w.e.]
        write(11) wei0IB
        ! weu_IB : Run-off [mm w.e.]
        write(11) weu_IB
        ! zn0IB : Initial Snow Height [m]
        write(11) zn0IB
        ! mb0IB : Initial Mass Balance [mmWE]
        write(11) mb0IB
        if(mw == 5) then
            ! gradTM :*CL* Local temp. gradient [C/m]
            write(11) gradTM
            ! gradQM :*CL* Local hum. gradient [g/kg/m]
            write(11) gradQM
        endif
        close(unit=11)
#ifdef iso
        ! write isotopic composition of water in the soil
        open(unit=11, status='unknown', form='unformatted', file='MARsvt_iso.DAT')
        ! rosSNo_iso : Snow Volumic Mass [kg/m3]
        write(11) rosSNo_iso
        ! wasSNo_iso: Soil humidity content (=> in the snow cover ) [kg/kg]
        write(11) wasSNo_iso
        ! SWaSNo_iso: Surficial Water Mass [kg/m2]
        write(11) SWaSNo_iso
        ! snohSN_iso : Snow Buffer Layer Thickness [mmWE]
        write(11) snohSN_iso
        ! eta_TV_iso : Soil Moisture Content [m3/m3]
        write(11) eta_TV_iso
        close(unit=11)
#endif
    endif
    return
endsubroutine svasav
