#include "MAR_pp.def"
subroutine sspray
    ! +--------------------------------------------------------------------------+
    ! |                                                          Sat 29-Jul-2009 |
    ! |                                                                          |
    ! |   subroutine sspray computes contribution of Sea Spray                   |
    ! |              ^^^^^^                       to Sensible & Latent Heat Flux |
    ! |                                                                          |
    ! |   Reference A_03 Andreas, 2003, Preprints.                               |
    ! |                  12th Conference on Interactions of the Sea & Atmosphere |
    ! |                  Long Beach, CA, American Meteorological Society         |
    ! |                  http://ams.confex.com/ams/pdfpapers/77949.pdf           |
    ! |                                                                          |
    ! |             AD02 Andreas & Decosmo, 2002, BLM 103, 303-333               |
    ! |                  The signature of sea spray                              |
    ! |                                in the HEXOS turbulent heat flux data     |
    ! |                                                                          |
    ! |             AE01 Andreas & Emanuel, 2001, JAS  58, 3741-3751             |
    ! |                  Effects of Sea Spray on Tropical Cyclone Intensity      |
    ! |                                                                          |
    ! |             A_95 Andreas, 1995, JAS 52(7) , 852-862                      |
    ! |                  The Temperature of Evaporating Sea Spray Droplets       |
    ! |                                                                          |
    ! |             A_90 Andreas, 1990, Tellus 42B, 481-497                      |
    ! |                  Time Constants for the Evolution of Sea Spray Droplets  |
    ! |                                                                          |
    ! |                                                                          |
    ! +--------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_sl
    use mar_wk
#ifdef iso
    use mariso, only: wiso, niso, qvDY_iso, qiHY_iso
#endif

    implicit none

    ! +--Internal  Constants and Variables
    ! +  =================================
    ! alphaC : A_03 (3)
    real, parameter :: alphaC = 0.0185
    ! Uf_Spr = .1 = 1/tau_f where tau_f = 10 sec (A_90 fig9)
    real, parameter :: Uf_Spr = 0.1
    ! t50_eq : (A_90 fig9)
    real, parameter :: t50_eq = 0.2000e+3
    ! f50_eq : 0.3125e-4 = 50.e-6 m * 0.5 / 0.8 ; * 0.5  when RH = 0.8 (A_90, p490)
    real, parameter :: f50_eq = 0.3125e-4
    integer i, j, k, m
    real ustar2, alo10g, A13wav, tf_Spr
    real Ta_wet, r50_eq, r50__t, r50n_t, QS_Spr, qq_Spr, QL_Spr
    real :: qq_spr_mass
#ifdef iso
    real :: qq_spr_iso(niso)
    ! rh : diagnostic
    real :: rh, fac, fac1, fac2, fac3
#endif

    ! +--Wave Height
    ! +  ===========

    do j = 1, my
        do i = 1, mx
            ! AD02 ( 4)
            A13wav = 0.015 * ssvSL(i, j, mz)
#ifdef A3
            ustar2 = SLuusl(i, j, 1) * SLuusl(i, j, 1)
            alo10g = log(10.*gravit / alphaC)
            ! A_03 (13)
            A13wav = 0.015 * (ustar2 / vonkar) * (2.*ustar2 - SLuusl(i, j, 1) * (2.*alo10g + 8.)) &
                     + (alo10g * alo10g + 2.*alo10g + 4.)
#endif
            A13wav = min(20., A13wav)

            ! +--Sea Spray Residence Time
            ! +  ========================
            ! A_03 (12)
            tf_Spr = A13wav / Uf_Spr

            ! +--Sea Spray Sensible Heat Flux Correction
            ! +  =======================================
            ! A_95
            Ta_wet = tairDY(i, j, mz) - (Lv_H2O / cp) * (qvswDY(i, j, mz) - qvDY(i, j, mz))
            Ta_wet = max(tfrwat, Ta_wet)
            ! AE01 ( 7)
            QS_Spr = 4.187e6 * (tsrfSL(i, j, 1) - Ta_wet) &
                     ! A_03 (14a)
                     * 1.65e-6 * SLuusl(i, j, 1) * SLuusl(i, j, 1) * SLuusl(i, j, 1)

            ! +--Sea Spray Latent Heat Flux Correction
            ! +  =====================================

            ! A_90 p490
            r50_eq = f50_eq * min(1., qvDY(i, j, mz) / qvswDY(i, j, mz))
            r50__t = r50_eq + (50.e-6 - r50_eq) * exp(-tf_Spr / t50_eq)
            r50n_t = r50__t / 50.e-6
            ! A_03 (11)
            qq_Spr = 1000.00 * (1.-r50n_t * r50n_t * r50n_t) * 2.65e-8 * SLuusl(i, j, 1)**2.61
            ! A_03 (11)
            QL_Spr = -Lv_H2O * qq_Spr

            ! +--Update
            ! +  ======
#ifdef X
            ! +--Increment
            ! +  ~~~~~~~~~
            pktaDY(i, j, mz) = pktaDY(i, j, mz) + maskSL(i, j) * SLsrfl(i, j, 1) &
                               * (QS_Spr + QL_Spr) * dt_Loc / (1.e3 * pstDYn(i, j) * dsigm1(mz) * grvinv) &
                               / (pkDY(i, j, mz) * cp)
#endif
            WKxy1(i, j) = maskSL(i, j) * SLsrfl(i, j, 1) &
                          * (QS_Spr + QL_Spr) * dt_Loc / (1.e3 * pstDYn(i, j) * dsigm1(mz) * grvinv) &
                          / (pkDY(i, j, mz) * cp)   !

            ! +--Increment (after limiting the fluxes)
            ! +  ~~~~~~~~~
            WKxy2(i, j) = &
                ! LOWER
                max(0.0, sign(1., pktaDY(i, j, mz) - pktaDY(i, j, mzz))) &
                * max(0.0, sign(1., pktaDY(i, j, mzz) - pktaDY(i, j, mz) - WKxy1(i, j))) &
                * max(WKxy1(i, j), pktaDY(i, j, mzz) - pktaDY(i, j, mz)) &
                ! UPPER
                + max(0.0, sign(1., pktaDY(i, j, mz) - pktaDY(i, j, mzz) + WKxy1(i, j))) &
                * max(0.0, sign(1., pktaDY(i, j, mzz) - pktaDY(i, j, mz))) &
                * min(WKxy1(i, j), pktaDY(i, j, mzz) - pktaDY(i, j, mz)) &
                ! OTHER
                + max(0.0, sign(1., pktaDY(i, j, mz) - pktaDY(i, j, mzz) + WKxy1(i, j)) &
                      * sign(1., pktaDY(i, j, mz) - pktaDY(i, j, mzz))) &
                * WKxy1(i, j)

            !  max: 10°C/h
            WKxy2(i, j) = sign(1., WKxy2(i, j)) * min(10.*dt / 3600., abs(WKxy2(i, j)))
            pktaDY(i, j, mz) = pktaDY(i, j, mz) + WKxy2(i, j)

            qq_Spr = qq_Spr * WKxy2(i, j) / (sign(1.0, WKxy1(i, j)) * max(eps9, abs(WKxy1(i, j))))
            qq_spr_mass = maskSL(i, j) * SLsrfl(i, j, 1) * qq_Spr * dt_Loc / (1.e3 * pstDYn(i, j) * dsigm1(mz) * grvinv)

#ifdef iso
            ! todo : check if vectorized by the compiler, check performance
            call iso_surf_ocean(pstDYn(i, j), tsrfSL(i, j, 1), qvDY(i, j, mz), ssvSL(i, j, mz), qvDY_iso(:, i, j, mz), &
                                qq_spr_mass, qq_spr_iso)
            do wiso = 1, niso
                qvDY_iso(wiso, i, j, mz) = qvDY_iso(wiso, i, j, mz) + qq_spr_iso(wiso)
            enddo
            ! **reminder**, water update (here qvDY) must be **after** isotope factionation computation
#endif
            qvDY(i, j, mz) = qvDY(i, j, mz) + qq_spr_mass
        enddo
    enddo

    do j = 1, my
        do i = 1, mx
            WKxy1(i, j) = 0.0
            WKxy2(i, j) = 0.0
        enddo
    enddo

    return
end
