subroutine SISVAT_zCr
    ! +
    ! +------------------------------------------------------------------------+
    ! | MAR          SISVAT_zCr                                12-12-2002  MAR |
    ! |   subroutine SISVAT_zCr determines criteria for Layers Agregation      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   PARAMETERS:  klonv: Total Number of columns =                        |
    ! |   ^^^^^^^^^^        = Total Number of continental     grid boxes       |
    ! |                     X       Number of Mosaic Cell per grid box         |
    ! |                                                                        |
    ! |   INPUT /  isnoSV   = total Nb of Ice/Snow Layers                      |
    ! |   OUTPUT:  iiceSV   = total Nb of Ice      Layers                      |
    ! |   ^^^^^^   ispiSV   = 0,...,nsno: Uppermost Superimposed Ice Layer     |
    ! |            istoSV   = 0,...,5 :   Snow     History (see istdSV data)   |
    ! |                                                                        |
    ! |   INPUT /  ro__SV   : Soil/Snow Volumic Mass                   [kg/m3] |
    ! |   OUTPUT:           & Snow     Temperatures (layers  1,2,...,nsno) [K] |
    ! |   ^^^^^^   G1snSV   : Dendricity (<0) or Sphericity (>0) of Snow Layer |
    ! |            G2snSV   : Sphericity (>0) or Size            of Snow Layer |
    ! |            agsnSV   : Snow       Age                             [day] |
    ! |                                                                        |
    ! |   OUTPUT:  LIndsv   : Relative Index of a contiguous Layer to agregate |
    ! |   ^^^^^^                                                               |
    ! +------------------------------------------------------------------------+
    ! +
    use marphy
    use mar_sv
    use mardsv
    use mar0sv
    use marxsv
    use marysv
    ! +
    implicit none
    ! +
    ! +--Internal Variables
    ! +  ==================
    ! +
    integer ikl, isn, is0, is1
    integer isno_1                        ! Switch:  ! Snow Layer over Ice
    real Dtyp_0, Dtyp_1                 ! Snow Grains Difference Measure
    real DenSph                        ! 1. when contiguous spheric
    ! +                                           !     and dendritic  Grains
    real DendOK                        ! 1. when dendritic  Grains
    real dTypMx                        ! Grain Type Differ.
    real dTypSp                        ! Sphericity Weight
    real dTypRo                        ! Density    Weight
    real dTypDi                        ! Grain Diam.Weight
    real dTypHi                        ! History    Weight

    ! +--DATA
    ! +  ====

    data dTypMx/200.0/             ! Grain Type Weight
    data dTypSp/0.5/             ! Sphericity Weight
    data dTypRo/0.5/             ! Density    Weight
    data dTypDi/10.0/             ! Grain Diam.Weight
    data dTypHi/100.0/             ! History    Weight

    ! +--Agregation Criteria
    ! +  ===================
    ! +
    do ikl = 1, klonv
        i_thin(ikl) = min(i_thin(ikl), isnoSV(ikl))
        isn = max(1, i_thin(ikl))
        ! +
        ! +
        ! +--Comparison with the downward Layer
        ! +  ----------------------------------
        ! +
        ! Downward Layer Index
        is0 = max(1, i_thin(ikl) - 1)
        ! isn/is1 Dendricity/Sphericity Switch
        DenSph = max(zero, &
                     sign(unun, &
                          epsi - G1snSV(ikl, isn) &
                          * G1snSV(ikl, is0)))
        ! Dendricity Switch
        DendOK = max(zero, &
                     sign(unun, &
                          epsi - G1snSV(ikl, isn)))
        ! +
        Dtyp_0 = &
            DenSph * dTypMx &
            + (1.-DenSph) &
            ! Dendricity Contribution
            * DendOK * ((abs(G1snSV(ikl, isn) - G1snSV(ikl, is0)) &
                         ! Sphericity Contribution
                         + abs(G2snSV(ikl, isn) - G2snSV(ikl, is0))) * dTypSp &
                        ! Density Contribution
                        + abs(ro__SV(ikl, isn) - ro__SV(ikl, is0)) * dTypRo) &
            + (1.-DenSph) &
            ! Sphericity Contribution
            * (1.-DendOK) * ((abs(G1snSV(ikl, isn) - G1snSV(ikl, is0)) &
                              ! Size Contribution
                              + abs(G2snSV(ikl, isn) - G2snSV(ikl, is0))) * dTypDi &
                             ! Density  Contribution
                             + abs(ro__SV(ikl, isn) - ro__SV(ikl, is0)) * dTypRo)
        Dtyp_0 = &
            min(dTypMx, &
                Dtyp_0 &
                ! History  Contribution
                + abs(istoSV(ikl, isn) - istoSV(ikl, is0)) * dTypHi) &
            !"Same Layer"Score
            + (1 - abs(isn - is0)) * 1.e+6 &
            !"Ice /Snow Interface" Score
            + max(0, 1 - abs(iiceSV(ikl) &
                             - is0)) * 1.e+6
        ! +
        ! +
        ! +--Comparison with the   upward Layer
        ! +  ----------------------------------
        ! +
        ! Upward   Layer Index
        is1 = min(i_thin(ikl) + 1, &
                  max(1, isnoSV(ikl)))
        ! isn/is1 Dendricity/Sphericity Switch
        DenSph = max(zero, &
                     sign(unun, &
                          epsi - G1snSV(ikl, isn) &
                          * G1snSV(ikl, is1)))
        ! Dendricity Switch
        DendOK = max(zero, &
                     sign(unun, &
                          epsi - G1snSV(ikl, isn)))
        ! +
        Dtyp_1 = &
            DenSph * dTypMx &
            + (1.-DenSph) &
            ! Dendricity Contribution
            * DendOK * ((abs(G1snSV(ikl, isn) &
                             - G1snSV(ikl, is1)) &
                         ! Sphericity Contribution
                         + abs(G2snSV(ikl, isn) - G2snSV(ikl, is1))) * dTypSp &
                        ! Density Contribution
                        + abs(ro__SV(ikl, isn) - ro__SV(ikl, is1)) * dTypRo) &
            + (1.-DenSph) &
            ! Sphericity Contribution
            * (1.-DendOK) * ((abs(G1snSV(ikl, isn) &
                                  - G1snSV(ikl, is1)) &
                              ! Size Contribution
                              + abs(G2snSV(ikl, isn) - G2snSV(ikl, is1))) * dTypDi &
                             ! Density Contribution
                             + abs(ro__SV(ikl, isn) - ro__SV(ikl, is1)) * dTypRo)
        Dtyp_1 = &
            min(dTypMx, &
                Dtyp_1 &
                ! History Contribution
                + abs(istoSV(ikl, isn) &
                      - istoSV(ikl, is1)) * dTypHi) &
            !"Same Layer"Score
            + (1 - abs(isn - is1)) * 1.e+6 &
            !"Ice /Snow Interface" Score
            + max(0, 1 - abs(iiceSV(ikl) &
                             - isn)) * 1.e+6
        ! +
        ! +
        ! +--Index of the Layer to agregate
        ! +  ==============================
        ! +
        LIndsv(ikl) = sign(unun, Dtyp_0 &
                           - Dtyp_1)
        ! Switch = 1
        isno_1 = (1 - min(abs(isnoSV(ikl) &
                              !   if isno = iice +1
                              - iiceSV(ikl) - 1), 1)) &
                 ! Switch = 1
                 * (1 - min(abs(isnoSV(ikl) &
                                !   if isno = i_ithin
                                - i_thin(ikl)), 1))
        ! Contiguous Layer is
        LIndsv(ikl) = (1 - isno_1) * LIndsv(ikl) &
                      ! downward for top L.
                      - isno_1
        i_thin(ikl) = max(1, i_thin(ikl))
    enddo
    ! +
    return
endsubroutine SISVAT_zCr
