#include "MAR_pp.def"
subroutine SISVAT_wEq(labWEq, istart)
    ! +------------------------------------------------------------------------+
    ! | MAR          SISVAT_wEq                                22-09-2001  MAR |
    ! |   subroutine SISVAT_wEq computes the Snow/Ice  Water  Equivalent       |
    ! |                                                                        |
    ! |                                                                        |
    ! |   Preprocessing  Option: SISVAT IO (not always a standard preprocess.) |
    ! |   ^^^^^^^^^^^^^^^^^^^^^  ^^^^^^^^^                                     |
    ! |   FILE                 |      CONTENT                                  |
    ! |   ~~~~~~~~~~~~~~~~~~~~~+~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ |
    ! | # SISVAT_wEq.ve        | #ve: OUTPUT/Verification: Snow/Ice Water Eqv. |
    ! |                        |      unit 45, subroutine  SISVAT_wEq **ONLY** |
    ! +------------------------------------------------------------------------+

    use marphy
    use mar_sv
    use marxsv

    implicit none

    character * 6 labWEq
    integer istart

    logical logWEq
    common / SISVAT_wEq_L / logWEq

    ! +--Local  Variables
    ! +  ================

    integer ikl, isn
    real SnoWEQ, IceWEQ

    ! +--Switch Initialization
    ! +  =====================

    if(.not. logWEq) then
        logWEq = .true.
        open(unit=45, status='unknown', file='SISVAT_wEq.ve')
        rewind 45
    endif

    ! +--Snow Water Equivalent
    ! +  =====================

    ikl = 1
    if(isnoSV(ikl) > iiceSV(ikl)) then

        SnoWEQ = 0.
        do isn = iiceSV(ikl) + 1, isnoSV(ikl)
            SnoWEQ = SnoWEQ + ro__SV(ikl, isn) * dzsnSV(ikl, isn)
        enddo

    endif

    ! +--Ice  Water Equivalent
    ! +  =====================

    if(iiceSV(1) > 0) then

        IceWEQ = 0.
        do isn = 1, iiceSV(ikl)
            IceWEQ = IceWEQ + ro__SV(ikl, isn) * dzsnSV(ikl, isn)
        enddo

    endif

    ! +--OUTPUT
    ! +  ======

    if(istart == 1) then
        write(45, 45) dahost, i___SV(lwriSV(1)), j___SV(lwriSV(1)), &
            n___SV(lwriSV(1))
45      format(a18, 10('-'), 'Pt.', 3i4, 60('-'))
    endif

    write(45, 450) labWEq, IceWEQ, iiceSV(ikl), SnoWEQ &
        , IceWEQ + SnoWEQ, isnoSV(ikl) &
        , drr_SV(ikl) * dt__SV &
        , dsn_SV(ikl) * dt__SV &
        , BufsSV(ikl)
450 format(a6, 3x, '  I+S =', f11.4, '(', i2, ') +', f11.4, ' =', &
           f11.4, '(', i2, ')', &
           '  drr =', f7.4, &
           '  dsn =', f7.4, &
           '  Buf =', f7.4)

    return
endsubroutine SISVAT_wEq
