#include "MAR_pp.def"
subroutine sno_filtering()
    ! +------------------------------------------------------------------------+
    ! | SISVAT                                                 25-04-2020  MAR |
    ! |                                                                        |
    ! |   subroutine snow_filtering                                            |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_sv
    use mar_sl
    use mar_hy
    use marssn
    use mardsv
    use mar_tv

    implicit none

    real weight ! weight for the central pixel

    integer i, j, k, m
    integer l, kk, n, nb
    real g2_ave, ro_ave, nbr1, nbr2, nbr3, nbr4
    real al_ave, ussave, corr, ww, dz_ave
    real ratio(mx, my, mw), g2_new(mx, my, mw), ussnew(mx, my, mw)
    integer correction(mx, my, mw)
    real(kind=8) sumin, sumou

    logical density_filtering

    density_filtering = .true.

    weight = 4.*max(1., min(10., sqrt(dx / 1000)))
#ifdef BS
    weight = 12.*max(1., min(10., sqrt(dx / 1000)))
#endif

!$OMP PARALLEL do &
!$OMP private(i,j,k,l,n,m,ww,nbr1,nbr2,nbr3,ro_ave,g2_ave,al_ave,ussave, &
!$OMP         dz_ave,corr,nbr4) &
!$OMP schedule(dynamic)
    do j = 7, my - 6 ! only the interesting domain
        do i = 7, mx - 6

            !      ! increase the melt of snowpack when some sub pixels are snow free.
            do n = 1, mw
                do m = 1, mw
                    if(n /= m) then
                        if(nssSNo(i, j, m) == 0 .and. nssSNo(i, j, n) > 1 .and. &
                           ivegTV(i, j, m) > 0 .and. ivegTV(i, j, n) > 0 .and. &
                           ifraTV(i, j, m) > 0 .and. ifraTV(i, j, n) > 0 .and. &
                           tairDY(i, j, mz) > 275.15) then

                            tisSNo(i, j, n, nssSNo(i, j, n)) = 273.15 &
                                                               + max(0., min(tsrfSL(i, j, m), tairDY(i, j, mz) - 273.15) / 20.)

                            tisSNo(i, j, n, nssSNo(i, j, n)) = max(273.15, &
                                                                   min(tisSNo(i, j, n, nssSNo(i, j, n)), 274.15))

                        endif
                    endif
                enddo

                if(SLsrfl(i, j, n) <= 0) then
                    nssSNo(i, j, n) = 0
                    do k = 1, nsno
                        dzsSNo(i, j, n, k) = 0.
                    enddo
                endif
            enddo

            do n = 1, min(mw, 2) ! sea ice and ice sheet only

                ratio(i, j, n) = 1.
                correction(i, j, n) = 0.
                !c#BS       ussnew(i,j,n) = uss_HY(i,j)
                ! only in the accumulation zone
                if(nssSNo(i, j, n) > 3 .and. &
                   ifraTV(i, j, n) > 0 .and. &
                   ivegTV(i, j, n) <= 0. .and. &
                   rosSNo(i, j, n, max(1, nssSNo(i, j, n))) < 700. .and. &
                   dzsSNo(i, j, n, max(1, nssSNo(i, j, n))) > 0.001) then

                    nbr1 = 0; nbr2 = 0; nbr3 = 0; nbr4 = 0
                    ro_ave = 0; g2_ave = 0; al_ave = 0; dz_ave = 0
                    !c#BS    ussave=0

                    !        ! only in the accumulation zone
                    do k = -1, 1; do l = -1, 1
                            if(nssSNo(i + k, j + l, n) > 3 .and. &
                               ifraTV(i + k, j + l, n) > 0 .and. &
                               ivegTV(i + k, j + l, n) <= 0 .and. &
                               rosSNo(i + k, j + l, n, max(1, nssSNo(i + k, j + l, n))) < 700. .and. &
                               dzsSNo(i + k, j + l, n, max(1, nssSNo(i + k, j + l, n))) > 0.001 .and. &
                               tisSNo(i + k, j + l, n, max(1, nssSNo(i + k, j + l, n))) < 273. .and. &
                               tisSNo(i + k, j + l, n, max(1, nssSNo(i + k, j + l, n))) > 263.) then

                                ww = 1
                                if(k == 0 .or. l == 0) ww = 2
                                if(k == 0 .and. l == 0) ww = weight

                                dz_ave = dz_ave + dzsSNo(i + k, j + l, n, nssSNo(i + k, j + l, n)) * ww

                                ro_ave = ro_ave + rosSNo(i + k, j + l, n, nssSNo(i + k, j + l, n)) * ww

                                al_ave = al_ave + albxSL(i + k, j + l, n) * ww
                                !c#BS      ussave = ussave + uss_HY(i,j)      *min(12.,ww)

                                nbr1 = nbr1 + 1
                                nbr2 = nbr2 + ww
                                !c#BS      nbr4  = nbr4+min(12.,ww)

                                if(g1sSNo(i + k, j + l, n, nssSNo(i + k, j + l, n)) >= 0) then
                                    g2_ave = g2_ave + g2sSNo(i + k, j + l, n, nssSNo(i + k, j + l, n)) * ww
                                    nbr3 = nbr3 + ww
                                endif
                            endif
                        enddo; 
                    enddo

                    al_ave = al_ave / max(1., nbr2)
                    ro_ave = ro_ave / max(1., nbr2)
                    dz_ave = dz_ave / max(1., nbr2)
                    g2_ave = g2_ave / max(1., nbr3)
                    !c#BS    ussave = ussave / max(1.,nbr4)

                    if(dz_ave >= dzsSNo(i, j, n, nssSNo(i, j, n))) then
                        corr = dzsSNo(i, j, n, nssSNo(i, j, n)) / dz_ave
                    else
                        corr = dz_ave / dzsSNo(i, j, n, nssSNo(i, j, n))
                    endif

                    corr = corr * (1.- &
                                   (700.-rosSNo(i, j, n, nssSNo(i, j, n)))**2 / &
                                   (700.-300.))**2
                    corr = max(0.1, min(0.9, corr))

                    ro_ave = ro_ave * corr &
                             + rosSNo(i, j, n, nssSNo(i, j, n)) * (1.-corr)

                    ratio(i, j, n) = ro_ave / (rosSNo(i, j, n, nssSNo(i, j, n)))
                    ratio(i, j, n) = max(0.9, min(1.1, ratio(i, j, n))) ! max 10 %

                    corr = ratio(i, j, n) ! backup

                    if(tisSNo(i, j, n, nssSNo(i, j, n)) > 273.14 .or. &
                       tairdy(i, j, mz) > 275.14) then
                        ratio(i, j, n) = 1
                    endif

                    g2_new(i, j, n) = g2sSNo(i, j, n, nssSNo(i, j, n))

                    !        ! problem of albedo in the accumulation zone
                    if(albxSL(i, j, n) < al_ave * 0.99 .and. &
                       g1sSNo(i, j, n, nssSNo(i, j, n)) > 0 .and. &
                       albxSL(i, j, n) < 0.72) then

                        if(nbr3 > 0) g2_new(i, j, n) = min(g2_new(i, j, n), g2_ave)
                        ratio(i, j, n) = min(1., corr)
                        if(nbr1 >= 6) nbr1 = 9
                    endif

                    ! refreezing of aquifer in winter!!
                    ! if(tairdy(i, j, mz)<253.15) then
                    !     tisSNo(i, j, n, 1) = min(tisSNo(i, j, n, 1), 273.145)
                    ! end if

                    if(nbr1 >= 8) then
                        correction(i, j, n) = 1
                        !c#BS     ussnew(i,j,n)    =ussave
                    endif

                endif
            enddo
        enddo
    enddo
!$OMP END PARALLEL DO

    !c#BS sumin=0. ; sumou=0.

    do j = 7, my - 6
        do i = 7, mx - 6

            !c#BS  sumin=sumin+uss_hy(i,j)
            !c#BS  sumou=sumou+ussnew(i,j,1)

            do n = 1, 2
                if(correction(i, j, n) == 1) then
                    g2sSNo(i, j, n, nssSNo(i, j, n)) = g2_new(i, j, n)
                    if(density_filtering) then
                        dzsSNo(i, j, n, nssSNo(i, j, n)) = dzsSNo(i, j, n, nssSNo(i, j, n)) &
                                                           / ratio(i, j, n)
                        rosSNo(i, j, n, nssSNo(i, j, n)) = rosSNo(i, j, n, nssSNo(i, j, n)) &
                                                           * ratio(i, j, n)
                    endif
                endif
            enddo
        enddo
    enddo

    !c#BS if(abs(sumin)>epsi.and.abs(sumou)>epsi) then
    !c#BS  do j = 7,my-6
    !c#BS  do i = 7,mx-6
    !c#BS   uss_HY(i,j)=ussnew(i,j,1)*sumin/sumou
    !c#BS  end do
    !c#BS  end do
    !c#BS end if

endsubroutine sno_filtering
