module radcep
    use mardim
    implicit none
    integer, parameter :: klonr = 1
    integer, parameter :: klevr = mz
    integer, parameter :: nn_aer = 6
    character(len=6), save :: CMIP_scenario

    real, save, allocatable :: Ae_MAR(:, :, :, :)
    real, save, allocatable :: O3_MAR(:, :, :)

    logical :: RADini = .false.
    logical :: RADin2 = .false.
    common / c_RADini / RADini, RADin2
    !$OMP threadprivate( /c_RADini/)
    save

contains

    subroutine radcep_init()

    use mardim, only: mx, my, mz
    implicit none

    allocate(Ae_MAR(mx, my, nn_aer, mz))
    allocate(O3_MAR(mx, my, mz))

    endsubroutine radcep_init

endmodule radcep
