MODULE YOERAD

#include "tsmbkind.h"

    IMPLICIT NONE

    SAVE

!     ------------------------------------------------------------------
!*    ** *YOERAD* - CONTROL OPTIONS FOR RADIATION CONFIGURATION
!     ------------------------------------------------------------------

    INTEGER_M :: NAER
    INTEGER_M :: NMODE
    INTEGER_M :: NOZOCL
    INTEGER_M :: NRADFR
    INTEGER_M :: NRADPFR
    INTEGER_M :: NRADPLA
    INTEGER_M :: NRINT
    INTEGER_M :: NRADNFR
    INTEGER_M :: NRADSFR
    INTEGER_M :: NRPROMA
    INTEGER_M :: NRADF2C
    INTEGER_M :: NRADC2F
    INTEGER_M :: NLW
    INTEGER_M :: NSW
    INTEGER_M :: NTSW
    INTEGER_M :: NCSRADF
    INTEGER_M :: NHOWINH
    INTEGER_M :: NOVLP

    INTEGER_M :: NICEOPT
    INTEGER_M :: NLIQOPT
    INTEGER_M :: NRADIP
    INTEGER_M :: NRADLP

    LOGICAL LERAD6H
    LOGICAL LERADHS
    LOGICAL LEPO3RA
    LOGICAL LRADLB
    LOGICAL LONEWSW

    LOGICAL LOWASYF
    LOGICAL LOWHSSS
    LOGICAL LOIFUEC

    LOGICAL LECSRAD
    LOGICAL LRRTM
    LOGICAL LINHOM
    LOGICAL LHVOLCA
    LOGICAL LNEWAER
    LOGICAL LRADLP
    LOGICAL LTEMPDS

    LOGICAL LDICESR
    REAL_B :: RMINICE

    REAL_B :: RAOVLP, RBOVLP

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
! LERAD6H: LOGICAL : .T. TO ALLOW MORE FREQUENT RADIATION CALCULATIONS
!                  : DURING FIRST 6 HOURS OF FORECAST
! LERADHS: LOGICAL : .T. IF RAD.COMPUTED ON A COARSER SAMPLED GRID
! LEPO3RA: LOGICAL : .T. IF PROGNOSTIC OZONE (EC) IS PASSED TO RADIATION
! NAER   : INTEGER : CONFIGURATION INDEX FOR AEROSOLS
! NMODE  : INTEGER : CONFIGURATION FOR RADIATION CODE: FLUX VS. RADIANCE
! NOZOCL : INTEGER : CHOICE OF OZONE CLIMATOLOGY (0 old, 1 new)
! NRADFR : INTEGER : FREQUENCY OF FULL RADIATION COMPUTATIONS
!                    IF(NRADFR.GT.0): RAD EVERY 'NRADFR' TIME-STEPS
!                    IF(NRADFR.LT.0): RAD EVERY '-NRADFR' HOURS
! NRADPFR: INTEGER : PRINT FREQUENCY FOR RAD.STATISTICS (in RAD.T.STEPS)
! NRADPLA: INTEGER : PRINT RAD.STATISTICS EVERY 'NRADPLA' ROWS
! NRINT  : INTEGER : INTERPOLATION DISTANCE (in points)
! NRADNFR: INTEGER : NORMAL   FREQUENCY OF RADIATION STEPS
! NRADSFR: INTEGER : START-UP FREQUENCY OF RADIATION STEPS
! NOVLP  : INTEGER : CLOUD OVERLAP CONFIGURATION
! NRPROMA: INTEGER : VECTOR LENGTH FOR RADIATION CALCULATIONS
! NRADF2C: INTEGER : INTERPOLATION SCHEME FOR FINE TO COURSE GRID TO BE
!                  : USED WHEN NRINT IS GREATER THAN 1
! NRADC2F: INTEGER : INTERPOLATION SCHEME FOR COURSE TO FINE GRID TO BE
!                  : USED WHEN NRINT IS GREATER THAN 1
! NLW    : INTEGER : NUMBER OF LONGWAVE SPECTRAL INTERVALS
! NSW    : INTEGER : NUMBER OF SHORTWAVE SPECTRAL INTERVALS
! NTSW   : INTEGER : MAXIMUM POSSIBLE NUMBER OF SW SPECTRAL INTERVALS
! LRADLB : LOGICAL : .T. IF RADIATION COURSER GRID IS TO BE LOAD BALANCED
!                  : OVER PROCESSORS (I.E. WHEN NRINT>1)
!
! LOWASYF: LOGICAL : .F. IF WATER CLOUDS AS FOUQUART (SW)
!                  : .T. IF WATER CLOUDS AS SLINGO   (SW)
! LOWHSSS: LOGICAL : .F. IF WATER CLOUDS AS SMITH-SHI (LW)
!                  : .T. IF WATER CLOUDS AS SAVIJARVI (LW)
! LOIFUEC: LOGICAL : .F. IF ICE CLOUDS AS EBERT-CURRY (LW & SW)
!                  : .T. IF ICE CLOUDS AS FU-LIOU / FU ET AL. (LW & SW)
!
! LONEWSW: LOGICAL : .T. IF NEW SW CODE IS ACTIVE
! LECSRAD: LOGICAL : .T. IF CLEAR-SKY RADIATION IS ARCHIVED AS PEXTR2
! NCSRADF: INTEGER : 1 IF ACCUMULATED, 2 IF INSTANTANEOUS
! LRRTM  : LOGICAL : .T. IF RRTM140MR IS USED FOR LW RADIATION TRANSFER
! LINHOM : LOGICAL : .T. INHOMOGENEITY EFFECT, ON BOTH LW & SW RADIATION
!                    ON BOTH STRATIFORM & CONVECTIVE CLOUDS
! LHVOLCA: LOGICAL : .T. IF GISS HISTORY OF VOLCANIC AEROSOLS IS ON
! LNEWAER: LOGICAL : .T. IF AEROSOL MONTHLY DISTRIBUTIONS ARE USED
! LRADLP : LOGICAL : .T. IF CLOUD WATER EFFECTIVE RADIUS IS COMPUTED
! LRADIP : LOGICAL : .F. IF CHRIS'S 21R3 ICE EFFECTIVE RADIUS IS USED
! LTEMPDS: LOGICAL : .T. ALLOWS FOR SURFACE T DISCONTINUITY IN RAD.COMP.

! LDICESR: LOGICAL : .T. ICE EFFECETIVE DIAMETER A LA SUN-RIKUS, 1999

! RAOVLP : REAL    : COEFFICIENTS FOR ALPHA1 FACTOR IN HOGAN &
! RBOVLP : REAL    : ILLINGWORTH's PARAMETRIZATION
!     ------------------------------------------------------------------
END MODULE YOERAD
