MODULE YOELW

#include "tsmbkind.h"

    IMPLICIT NONE

    SAVE

!     ------------------------------------------------------------------
!*    ** *YOELW* - COEFFICIENTS OF THE LONGWAVE RADIATION TRANSFER
!     ------------------------------------------------------------------

    INTEGER_M :: MXIXT
    INTEGER_M :: NSIL
    INTEGER_M :: NIPD
    INTEGER_M :: NIPD2
    INTEGER_M :: NTR
    INTEGER_M :: NTRA
    INTEGER_M :: NUA
    INTEGER_M :: NG1
    INTEGER_M :: NG1P1
    REAL_B :: ALWT(8, 3)
    REAL_B :: BLWT(8, 3)
    REAL_B :: PDGA(11, 16, 3)
    REAL_B :: PDGB(11, 16, 3)
    REAL_B :: RPTYPE(4)
    REAL_B :: RETYPE(4)
    REAL_B :: RNTNU(4)
    REAL_B :: RO1H
    REAL_B :: RO2H
    REAL_B :: RO3T(4)
    REAL_B :: RPIALF0
    REAL_B :: RT1(2)
    REAL_B :: TINTP(11)
    REAL_B :: TREF
    REAL_B :: TSTAND
    REAL_B :: TSTP
    REAL_B :: WG1(2)
    REAL_B :: XP(6, 6)
    REAL_B :: RVGCO2
    REAL_B :: RVGH2O
    REAL_B :: RVGO3

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!  MXIXT :  INTEGER  MAXIMUM TEMPERATURE INDEX FOR TRANSMISSIVITIES
!  NSIL  :  INTEGER  NUMBER OF SPECTRAL INTERVALS
!  NIPD  :  INTEGER  NUMBER OF BANDS DESCRIBED BY PADE APPROXIMANTS
!  NIPD2 :  INTEGER  NIPD*2
!  NTR   :  INTEGER  NUMBER OF REFERENCE TEMPERATURES
!  NTRA  :  INTEGER  NUMBER OF TRANSMISSION FUNCTIONS
!  NUA   :  INTEGER  NUMBER OF ABSORBER AMOUNTS
!  NG1   :  INTEGER  ORDER OF THE GAUSSIAN QUADRATURE
!  NG1P1 :  INTEGER  NG1+1
!  ALWT  :  REAL     A-TYPE COEFF. FOR TEMPERATURE DEPENDENCE
!  BLWT  :  REAL     B-TYPE COEFF. FOR TEMPERATURE DEPENDENCE
!  RNTNU :  REAL     ABSORPTION COEFFICIENT E-TYPE
!  PDGA  :  REAL     PADE APPROXIMANTS - NUMERATOR
!  PDGB  :  REAL     PADE APPROXIMANTS - DENOMINATOR
!  RPTYPE:  REAL     P-TYPE COEFFICIENTS
!  RETYPE:  REAL     E-TYPE COEFFICIENTS
!  RO1H  :  REAL     K/DELTA 1ST OZONE SUB-INTERVAL
!  RO2H  :  REAL     K/DELTA 2ND OZONE SUB-INTERVAL
!  RO3T  :  REAL     TEMPERATURE DEPENDENCE COEFFICIENTS FOR OZONE
!  RPIALF0: REAL     PI*ALFA0/DELTA OZONE SUB-INTERVALS
!  RT1   :  REAL     ROOTS FOR GAUSSIAN QUADRATURE
!  TINTP :  REAL     TEMPERATURE INTERVALS FOR TRANSMISSIVITIES
!  TREF  :  REAL     REFERENCE TEMPERATURE IN PLANCK FUNCTION POLYNOMIAL
!  TSTAND:  REAL     REFERENCE TEMPERATURE FOR TEMPERATURE DEPENDENCE
!  TSTP  :  REAL     TEMEPERATURE STEP BETWEEN TRANSMISSIVITIES
!  WG1   :  REAL     WEIGHTS FOR GAUSSIAN QUADRATURE
!  XP    :  REAL     POLYNOMIAL COEFFICIENTS OF PLANCK FUNCTION
!  RVGCO2:  REAL     RESIDUAL PRESSURE FOR CO2 VOIGT LINE HALF-WIDTH
!  RVGH2O:  REAL     RESIDUAL PRESSURE FOR H2O VOIGT LINE HALF-WIDTH
!  RVGO3 :  REAL     RESIDUAL PRESSURE FOR O3  VOIGT LINE HALF-WIDTH

!     ------------------------------------------------------------------
END MODULE YOELW
