MODULE YOECLD

#include "tsmbkind.h"

    IMPLICIT NONE

    SAVE

!     -----------------------------------------------------------------
!*    ** *YOECLD* - CONTROL PARAMETERS FOR DIAGNOSTIC CLOUDS
!     -----------------------------------------------------------------

!REAL_B,ALLOCATABLE:: CETA(:)
    REAL_B :: CETA(600)

    REAL_B :: RANVA
    REAL_B :: RANVB
    REAL_B :: RANVH
    REAL_B :: RCCA
    REAL_B :: RCCB
    REAL_B :: RCCC
    REAL_B :: RCFCT
    REAL_B :: RCLWMR
    REAL_B :: RCSCAL
    REAL_B :: RETAHB
    REAL_B :: RETAMB
    REAL_B :: RLOIA
    REAL_B :: RLOIB
    REAL_B :: RLOIC
    REAL_B :: RLOID
    REAL_B :: RLONIA
    REAL_B :: RLONIB
    REAL_B :: RRHH
    REAL_B :: RRHL
    REAL_B :: RRHM
    REAL_B :: RGAMMAS
    REAL_B :: REPSCR
    REAL_B :: REPSEC
    LOGICAL LOMEGA

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!  RANVA :  REAL     COEFFICIENT FOR ANVIL CLOUDS
!  RANVB :  REAL     COEFFICIENT FOR ANVIL CLOUDS
!  RANVH :  REAL     MINIMUM HIGH CLOUD COVER FOR ANVIL CLOUDS
!  RCCA  :  REAL     COEFFICIENT FOR DIAGNOSTIC OF CONVECTIVE CLOUD
!  RCCB  :  REAL     COEFFICIENT FOR DIAGNOSTIC OF CONVECTIVE CLOUD
!  RCCC  :  REAL     MAXIMUM COVER BY CONVECTIVE CLOUD
!  RCFCT :  REAL     WEIGHTING FACTOR FOR CONVECTIVE CLOUD TOWER
!  RCLWMR:  REAL     LIQUID WATER MIXING RATIO FOR CONVECTIVE CLOUD
!  RCSCAL:  REAL     SCALING FACTOR FOR CONVECTIVE RAIN
!  CETA(NFLEV) REAL  MODEL REFERENCE ETA-LEVEL
!  RETAHB:  REAL     ETA-LEVEL LIMIT FOR HIGH CLOUDS
!  RETAMB:  REAL     ETA-LEVEL LIMIT FOR MEDIUM CLOUDS
!  RLOIA :  REAL     COEFFICIENT FOR LOW CLOUD WHEN NO INVERSION
!  RLOIB :  REAL     COEFFICIENT FOR LOW CLOUD WHEN INVERSION
!  RLOIC :  REAL     COEFFICIENT FOR LOW CLOUD WHEN INVERSION
!  RLOID :  REAL     COEFFICIENT FOR LOW CLOUD WHEN INVERSION
!  RLONIA:  REAL     COEFFICIENT FOR LOW CLOUD WHEN INVERSION
!  RLONIB:  REAL     COEFFICIENT FOR LOW CLOUD WHEN NO INVERSION
!  RRHH  :  REAL     CRITICAL RELATIVE HUMIDITY FOR HIGH CLOUDS
!  RRHL  :  REAL     CRITICAL RELATIVE HUMIDITY FOR LOW CLOUDS
!  RRHM  :  REAL     CRITICAL RELATIVE HUMIDITY FOR MEDIUM CLOUDS
!  GAMMAS:  REAL     PROPORTIONALITY FACTOR FOR LIQUID WATER CONTENT
!  REPSCR:  REAL     MINIMUM CONVECTIVE PRECIPITATION (SECURITY FACTOR)
!  REPSEC:  REAL     MINIMUM HORIZONTAL CLOUD COVER (SECURITY FACTOR)
!  LOMEGA:  LOGICAL  SWITCH FOR OMEGA-FILTER ON MIDDLE CLOUD
!     ------------------------------------------------------------------
END MODULE YOECLD
