MODULE YOEPHY

#include "tsmbkind.h"

    IMPLICIT NONE

    SAVE

!     -----------------------------------------------------------------
!*    ** *YOEPHY* - SWITCHES RELATED TO DIABATIC PROCESSES
!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

    INTEGER_M :: NDBUG
    LOGICAL LEPHYS
    LOGICAL LEOCON
    LOGICAL LEAERO
    LOGICAL LECOND
    LOGICAL LECUMF
    LOGICAL LEDCLD
    LOGICAL LEEVAP
    LOGICAL LEGWDG
    LOGICAL LEOZOC
    LOGICAL LEQNGT
    LOGICAL LERADC
    LOGICAL LERADI
    LOGICAL LERADS
    LOGICAL LESATU
    LOGICAL LESHCV
    LOGICAL LESICE
    LOGICAL LESURF
    LOGICAL LEVDIF
    LOGICAL LEDYNT
    LOGICAL LEZERO
    LOGICAL LEDBUG
    LOGICAL LTEAERO
    LOGICAL LTECOND
    LOGICAL LTECUMF
    LOGICAL LTEDCLD
    LOGICAL LTEEVAP
    LOGICAL LTEGWDG
    LOGICAL LTEOZOC
    LOGICAL LTEQNGT
    LOGICAL LTERADI
    LOGICAL LTERADS
    LOGICAL LTESATU
    LOGICAL LTESHCV
    LOGICAL LTESICE
    LOGICAL LTESURF
    LOGICAL LTEVDIF
    LOGICAL LAGPHY
    LOGICAL LEPCLD
    LOGICAL LEO3CH
    LOGICAL LBUD23
    LOGICAL LEMETHOX

!     J.-J. MORCRETTE       E.C.M.W.F.      91/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
! LEPHYS : LOGICAL : SWITCH THE FULL E.C.M.W.F. PHYSICS PACKAGE ON
! LAGPHY : LOGICAL : IF TRUE, PHYSICS PACKAGE CALLED IN LAGGED MODE
! LEOCON : LOGICAL : IF TRUE, KEEP THE "OLD" CONSTANTS WITHIN PHYSICS !
! LEAERO : LOGICAL : TURN THE CLIMATOLOGICAL AEROSOLS ON
! LECOND : LOGICAL : TURN THE LARGE-SCALE CONDENSATION ON
! LECUMF : LOGICAL : TURN THE MASS-FLUX CUMULUS CONVECTION SCHEME ON
! LEDCLD : LOGICAL : TURN THE DIAGNOSTIC CLOUD SCHEME ON
! LEPCLD : LOGICAL : TURN THE PROGNOSTIC CLOUD SCHEME ON
! LEEVAP : LOGICAL : TURN THE EVAPORATION OF PRECIPITATION ON
! LEGWDG : LOGICAL : TURN THE GRAVITY WAVE DRAG ON
! LEOZOC : LOGICAL : TURN THE CLIMATOLOGICAL OZONE ON
! LEQNGT : LOGICAL : TURN THE NEGATIVE HUMIDITY FIXER ON
! LERADC : LOGICAL : SWITCH THE INTERPOLATION SCHEME FOR RADIATION
! LERADI : LOGICAL : TURN THE RADIATION SCHEME ON
! LERADS : LOGICAL : TURN THE INTERACTIVE SURFACE RADIATIVE PROPERTIESON
! LESATU : LOGICAL : TURN THE ECMWF CY39 THERMODYNAMIC FUNCTIONS ON
! LESHCV : LOGICAL : TURN THE SHALLOW CONV. IN THE MASS-FLUX SCHEME ON
! LESICE : LOGICAL : TURN THE INTERACTIVE SEA ICE PROCESSES ON
! LESURF : LOGICAL : TURN THE INTERACTIVE SURFACE PROCESSES ON
! LEVDIF : LOGICAL : TURN THE VERTICAL DIFFUSION ON
! LEO3CH : LOGICAL : TURN THE O3 CHEMISTRY ON (for EC prog. ozone)
! LEDYNT : LOGICAL : TO USE DYNAMICAL TENDENCIES AS INPUT TO PHYSICS
! LEZERO : LOGICAL : KEEP PURE T-DT INPUTS WITHIN ALL PHYS. ROUTINES
! LEDBUG : LOGICAL : SWITCH THE DEBUGGING AID PRINTS ON
! LBUD23 : LOGICAL : SWITCH FOR 3 AND 2 DIMENSIONAL BUDGETS
! LEMETHOX: LOGICAL : TURN THE METHANE OXIDATION ON

! LTE... : LOGICAL : CHECK OF I/O ARGUMENTS FOR EVERY PHYSICS ROUTINE
!     -----------------------------------------------------------------
!$OMP threadprivate ( &
!$OMP LEPHYS, &
!$OMP LEOCON, &
!$OMP LEAERO, &
!$OMP LECOND, &
!$OMP LECUMF, &
!$OMP LEDCLD, &
!$OMP LEEVAP, &
!$OMP LEGWDG, &
!$OMP LEOZOC, &
!$OMP LEQNGT, &
!$OMP LERADC, &
!$OMP LERADI, &
!$OMP LERADS, &
!$OMP LESATU, &
!$OMP LESHCV, &
!$OMP LESICE, &
!$OMP LESURF, &
!$OMP LEVDIF, &
!$OMP LEDYNT, &
!$OMP LEZERO, &
!$OMP LEDBUG, &
!$OMP LTEAERO, &
!$OMP LTECOND, &
!$OMP LTECUMF, &
!$OMP LTEDCLD, &
!$OMP LTEEVAP, &
!$OMP LTEGWDG, &
!$OMP LTEOZOC, &
!$OMP LTEQNGT, &
!$OMP LTERADI, &
!$OMP LTERADS, &
!$OMP LTESATU, &
!$OMP LTESHCV, &
!$OMP LTESICE, &
!$OMP LTESURF, &
!$OMP LTEVDIF, &
!$OMP LAGPHY, &
!$OMP LEPCLD, &
!$OMP LEO3CH, &
!$OMP LBUD23, &
!$OMP LEMETHOX, &
!$OMP   NDBUG &
!$OMP )
END MODULE YOEPHY
