!*
!     ------------------------------------------------------------------
#ifdef DOC

!     CE COMDECK CONTIENT DEUX GROUPES DE FONCTIONS THERMODYNAMIQUES :

!        * LE PREMIER (RLV,RLS,RLF,ESW,ESS,ES) CORRESPOND A DES
!     FONCTIONS ABSOLUES (OU INTRINSEQUES) QUI DOIVENT ETRE UTILISEES
!     POUR TOUT CE QUI CONCERNE LE MONDE REEL (DONNEES OBSERVEES ET
!     SORTIES DESTINEES A ETRE COMPAREES A DE TELLES DONNEES).

!        * LE SECOND (FOEW,FODLEW,FOQS,FODQS,FOLH) CORRESPOND AU MONDE
!     DE LA PHYSIQUE DU MODELE (ET PAR CONSEQUENT DE TOUTE LES PARTIES
!     DU CODE QUI DOIVENT ETRE COMPATIBLES AVEC CETTE PHYSIQUE :
!     ANALYSE/DYNAMIQUE/POST-PROCESSING ... ). LES DIFFERENCES ENTRE LES
!     DEUX GROUPES VIENNENT, DANS LA CONFIGURATION ACTUELLE DE LA
!     PHYSIQUE, DES POINTS SUIVANTS :
!         - CALCULS RELATIFS A LA VARIABLE Q DU MODELE
!         - CALCULS DE DERIVATION PAR RAPPORT A LA TEMPERATURE
!         - ABSENCE D'ETATS HORS-EQUILIBRE = UNE SEULE CHALEUR LATENTE
!           DE FUSION
!         - POSSIBILITE DE TRAVAILLER SANS LA PHASE GLACE = INDICE DE
!           TEST BINAIRE.

!     ------------------------------------------------------------------
#endif
!     ABSOLUTE THERMODYNAMICAL FUNCTIONS .


!     RLV : LATENT HEAT OF VAPOURISATION
!     RLS : LATENT HEAT OF SUBLIMATION
!     RLF : LATENT HEAT OF FUSION
!     ESW : SATURATION IN PRESENCE OF WATER
!     ESS : SATURATION IN PRESENCE OF ICE
!     ES  : SATURATION (IF T>RTT THEN WATER ; IF T<RTT THEN ICE)
!        INPUT (FOR ALL SIX FUNCTIONS) : PTARG = TEMPERATURE .
REAL_B :: RLV,RLS,RLF,ESW,ESS,ES
REAL_B :: PTARG

RLV(PTARG)=RLVTT+(RCPV-RCW)*(PTARG-RTT)
RLS(PTARG)=RLSTT+(RCPV-RCS)*(PTARG-RTT)
RLF(PTARG)=RLS(PTARG)-RLV(PTARG)
ESW(PTARG)=EXP(RALPW-RBETW/PTARG-RGAMW*LOG(PTARG))
ESS(PTARG)=EXP(RALPS-RBETS/PTARG-RGAMS*LOG(PTARG))
ES (PTARG)=EXP(&
          &(RALPW+RALPD*MAX(_ZERO_,SIGN(_ONE_,RTT-PTARG)))&
         &-(RBETW+RBETD*MAX(_ZERO_,SIGN(_ONE_,RTT-PTARG)))/PTARG &
         &-(RGAMW+RGAMD*MAX(_ZERO_,SIGN(_ONE_,RTT-PTARG)))*LOG(PTARG))

!     ------------------------------------------------------------------
!     FONCTIONS THERMODYNAMIQUES : FONCTIONS DEFINIES DE LA PHYSIQUE .


!     FONCTION DE LA TENSION DE VAPEUR SATURANTE .
!        INPUT : PTARG = TEMPERATURE
!                PDELARG = 0 SI EAU (QUELQUE SOIT PTARG)
!                          1 SI GLACE (QUELQUE SOIT PTARG).
REAL_B :: FOEW
REAL_B :: PDELARG
FOEW ( PTARG,PDELARG ) = EXP (&
    &( RALPW+PDELARG*RALPD )&
  &- ( RBETW+PDELARG*RBETD ) / PTARG &
  &- ( RGAMW+PDELARG*RGAMD ) * LOG(PTARG) )

!     FONCTION DERIVEE DU LOGARITHME NEPERIEN DE LA PRECEDENTE (FOEW) .
!        INPUT : PTARG = TEMPERATURE
!                PDELARG = 0 SI EAU (QUELQUE SOIT PTARG)
!                          1 SI GLACE (QUELQUE SOIT PTARG).
REAL_B :: FODLEW
FODLEW ( PTARG,PDELARG ) = (&
      &( RBETW+PDELARG*RBETD )&
    &- ( RGAMW+PDELARG*RGAMD ) * PTARG )&
    &/ ( PTARG*PTARG )

!     FONCTION HUMIDITE SPECIFIQUE SATURANTE .
!        INPUT : PESPFAR = RAPPORT FOEW SUR PRESSION.
REAL_B :: FOQS
REAL_B :: PESPFAR
FOQS ( PESPFAR ) = PESPFAR / ( _ONE_+RETV*MAX(_ZERO_,&
    &(_ONE_-PESPFAR)) )

!     FONCTION DERIVEE EN TEMPERATURE DE LA PRECEDENTE (FOQS) .
!        INPUT : PQSFARG = FOQS
!                PESPFAR = RAPPORT FOEW SUR PRESSION
!                PDLEFAR = FODLEW.
REAL_B :: FODQS 
REAL_B :: PQSFARG,PDLEFAR 
FODQS ( PQSFARG,PESPFAR,PDLEFAR ) = ( PQSFARG &
   &* (_ONE_-PQSFARG)*PDLEFAR ) / (_ONE_-PESPFAR)

!     FONCTION CHALEUR LATENTE .
!        INPUT : PTARG = TEMPERATURE
!                PDELARG = 0 SI EAU (QUELQUE SOIT PTARG)
!                          1 SI GLACE (QUELQUE SOIT PTARG).
REAL_B :: FOLH
FOLH ( PTARG,PDELARG ) =  RV * (&
    &( RBETW+PDELARG*RBETD )&
  &- ( RGAMW+PDELARG*RGAMD ) * PTARG )
!     ------------------------------------------------------------------

