SUBROUTINE SUSW

!**** *SUSW*   - INITIALIZE COMMON YOESW

!     PURPOSE.
!     --------
!           INITIALIZE YOESW, THE COMMON THAT CONTAINS COEFFICIENTS
!           NEEDED TO RUN THE SHORTWAVE RADIATION SUBROUTINES

!**   INTERFACE.
!     ----------
!        *CALL* *SUSW

!        EXPLICIT ARGUMENTS :
!        --------------------
!        NONE

!        IMPLICIT ARGUMENTS :
!        --------------------
!        COMMON YOESW

!     METHOD.
!     -------
!        SEE DOCUMENTATION

!     EXTERNALS.
!     ----------

!     REFERENCE.
!     ----------
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE IFS

!     AUTHOR.
!     -------
!        JEAN-JACQUES MORCRETTE *ECMWF*

!     MODIFICATIONS.
!     --------------
!        ORIGINAL : 88-12-15

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOMCST   , ONLY : RG
USE YOESW    , ONLY : APAD     ,BPAD     ,RRAY     ,RSUN     ,&
            &RPDH1    ,RPDU1    ,RPNH     ,RPNU     ,RSWCE    ,&
            &RSWCP    ,RTDH2O   ,RTDUMG   ,RTH2O    ,RTUMG    ,D

!      ----------------------------------------------------------------

!*       1.    SET VALUES.
!              -----------



IMPLICIT NONE
REAL_B   :: ZPDH2O=0.8_JPRB
REAL_B   :: ZPDUMG=0.75_JPRB
REAL_B   :: ZPRH2O=30000._JPRB
REAL_B   :: ZPRUMG=30000._JPRB

!     LOCAL REAL SCALARS
REAL_B :: ZH2O, ZUMG

RPDH1=ZPDH2O+_ONE_
RPDU1=ZPDUMG+_ONE_
ZH2O=_ONE_/( 10._JPRB* RG * RPDH1 )
ZUMG=_ONE_/( 10._JPRB* RG * RPDU1 )
RPNU = ZUMG/(ZPRUMG**ZPDUMG)
RPNH = ZH2O/(ZPRH2O**ZPDH2O)

!      RSWCP=0.002*RSWCE


RTDH2O = 0.40_JPRB
RTDUMG = 0.375_JPRB
RTH2O = 240._JPRB
RTUMG = 240._JPRB
RSWCE = 0._JPRB
RSWCP = 0._JPRB

RSUN(1) = 0.441676_JPRB
D(1,:) = (/ 0.00_JPRB, 0.00_JPRB, 0.00_JPRB /)
!* DERIVED FROM HITRAN APRIL 1991
!       H2O:  Pref=300 hPa, Tref=240K, Pdep=0.8
!       O3 :  unchanged

APAD(1, 1, :) = (/&
 &0.912418292E+05_JPRB,&
 &0.723613782E+05_JPRB,&
 &0.596037057E+04_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
APAD(1, 2, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
APAD(1, 3, :) = (/&
 &0.925887084E-04_JPRB,&
 &0.129353723E-01_JPRB,&
 &0.800821928E+00_JPRB,&
 &0.242715973E+02_JPRB,&
 &0.878331486E+02_JPRB,&
 &0.191559725E+02_JPRB,&
 &0.000000000E+00_JPRB/)

BPAD(1, 1, :) = (/&
 &0.912418292E+05_JPRB,&
 &0.724555318E+05_JPRB,&
 &0.602593328E+04_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
BPAD(1, 2, :) = (/&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB/)
BPAD(1, 3, :) = (/&
 &0.925887084E-04_JPRB,&
 &0.131812683E-01_JPRB,&
 &0.812706117E+00_JPRB,&
 &0.249863591E+02_JPRB,&
 &0.931071925E+02_JPRB,&
 &0.252233437E+02_JPRB,&
 &0.100000000E+01_JPRB/)

RRAY(1,1:6) = (/&
 &.428937E-01_JPRB, .890743E+00_JPRB,-.288555E+01_JPRB,&
 &.522744E+01_JPRB,-.469173E+01_JPRB, .161645E+01_JPRB/)

RSUN(2) = 0.558324_JPRB

D(2,1:3) = (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.800000000_JPRB /)

!* INTERVAL 2:  0.68 - 4.00 MICRONS
!* DERIVED FROM HITRAN APRIL 1991
!       H2O:  Pref=300 hPa, Tref=240K, Pdep=0.80
!       UMG:  Pref=300 hPa, Tref=240K, Pdep=0.75 (CO2+O2+CH4+N2O+CO)
!       O3 :  unchanged

APAD(2, 1, :) = (/&
 &0.376655383E-08_JPRB,&
 &0.978576773E-04_JPRB,&
 &0.387714006E+00_JPRB,&
 &0.118461660E+03_JPRB,&
 &0.119079797E+04_JPRB,&
 &0.293353397E+03_JPRB,&
 &0.000000000E+00_JPRB/)
APAD(2, 2, :) = (/&
 &0.739646016E-08_JPRB,&
 &0.131849595E-03_JPRB,&
 &0.437772681E+00_JPRB,&
 &0.151345118E+03_JPRB,&
 &0.233628890E+04_JPRB,&
 &0.797219934E+03_JPRB,&
 &0.000000000E+00_JPRB/)
APAD(2, 3, :) = (/&
 &0.410177786E+03_JPRB,&
 &0.672595424E+02_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E-00_JPRB,&
 &0.000000000E+00_JPRB/)

BPAD(2, 1, :) = (/&
 &0.376655383E-08_JPRB,&
 &0.979023421E-04_JPRB,&
 &0.388611139E+00_JPRB,&
 &0.120291383E+03_JPRB,&
 &0.130531005E+04_JPRB,&
 &0.415049409E+03_JPRB,&
 &0.100000000E+01_JPRB/)
BPAD(2, 2, :) = (/&
 &0.739646016E-08_JPRB,&
 &0.131861712E-03_JPRB,&
 &0.437949001E+00_JPRB,&
 &0.151692730E+03_JPRB,&
 &0.237071130E+04_JPRB,&
 &0.867914360E+03_JPRB,&
 &0.100000000E+01_JPRB/)
BPAD(2, 3, :) = (/&
 &0.410177786E+03_JPRB,&
 &0.731185438E+02_JPRB,&
 &0.100000000E+01_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB,&
 &0.000000000E+00_JPRB/)

RRAY(2,1:6) = (/&
 &.697200E-02_JPRB, .173297E-01_JPRB,-.850903E-01_JPRB,&
 &.248261E+00_JPRB,-.302031E+00_JPRB, .129662E+00_JPRB/)
RETURN
END SUBROUTINE SUSW
