SUBROUTINE SUECAESU_12

!**   OPTICAL THICKNESS OF SULFATE-TYPE AEROSOLS
!                          December

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESU* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSU


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,12:12)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Total Sulfate Aerosol    month: 12 --- lat:  1  90.0
ZAER (:, 1,12) = (/&
&.443E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat:  2  86.0
ZAER (:, 2,12) = (/&
&.995E-03_JPRB,.126E-02_JPRB,.169E-02_JPRB,.207E-02_JPRB,.253E-02_JPRB,.282E-02_JPRB,.319E-02_JPRB,&
&.367E-02_JPRB,.404E-02_JPRB,.434E-02_JPRB,.458E-02_JPRB,.498E-02_JPRB,.364E-02_JPRB,.286E-02_JPRB,&
&.231E-02_JPRB,.184E-02_JPRB,.150E-02_JPRB,.118E-02_JPRB,.947E-03_JPRB,.872E-03_JPRB,.870E-03_JPRB,&
&.100E-02_JPRB,.114E-02_JPRB,.119E-02_JPRB,.102E-02_JPRB,.101E-02_JPRB,.984E-03_JPRB,.946E-03_JPRB,&
&.901E-03_JPRB,.823E-03_JPRB,.775E-03_JPRB,.731E-03_JPRB,.626E-03_JPRB,.595E-03_JPRB,.538E-03_JPRB,&
&.445E-03_JPRB,.345E-03_JPRB,.304E-03_JPRB,.291E-03_JPRB,.270E-03_JPRB,.266E-03_JPRB,.269E-03_JPRB,&
&.257E-03_JPRB,.251E-03_JPRB,.243E-03_JPRB,.238E-03_JPRB,.242E-03_JPRB,.225E-03_JPRB,.207E-03_JPRB,&
&.200E-03_JPRB,.185E-03_JPRB,.182E-03_JPRB,.176E-03_JPRB,.174E-03_JPRB,.173E-03_JPRB,.178E-03_JPRB,&
&.181E-03_JPRB,.188E-03_JPRB,.202E-03_JPRB,.223E-03_JPRB,.219E-03_JPRB,.232E-03_JPRB,.224E-03_JPRB,&
&.228E-03_JPRB,.248E-03_JPRB,.268E-03_JPRB,.296E-03_JPRB,.353E-03_JPRB,.369E-03_JPRB,.434E-03_JPRB,&
&.487E-03_JPRB,.674E-03_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat:  3  82.0
ZAER (:, 3,12) = (/&
&.712E-02_JPRB,.635E-02_JPRB,.604E-02_JPRB,.592E-02_JPRB,.612E-02_JPRB,.653E-02_JPRB,.700E-02_JPRB,&
&.702E-02_JPRB,.715E-02_JPRB,.730E-02_JPRB,.739E-02_JPRB,.771E-02_JPRB,.693E-02_JPRB,.550E-02_JPRB,&
&.431E-02_JPRB,.334E-02_JPRB,.255E-02_JPRB,.197E-02_JPRB,.201E-02_JPRB,.193E-02_JPRB,.201E-02_JPRB,&
&.224E-02_JPRB,.265E-02_JPRB,.317E-02_JPRB,.385E-02_JPRB,.306E-02_JPRB,.248E-02_JPRB,.210E-02_JPRB,&
&.195E-02_JPRB,.203E-02_JPRB,.196E-02_JPRB,.148E-02_JPRB,.107E-02_JPRB,.788E-03_JPRB,.551E-03_JPRB,&
&.407E-03_JPRB,.268E-03_JPRB,.233E-03_JPRB,.220E-03_JPRB,.238E-03_JPRB,.276E-03_JPRB,.329E-03_JPRB,&
&.361E-03_JPRB,.356E-03_JPRB,.343E-03_JPRB,.321E-03_JPRB,.304E-03_JPRB,.279E-03_JPRB,.317E-03_JPRB,&
&.316E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.297E-03_JPRB,.265E-03_JPRB,&
&.240E-03_JPRB,.228E-03_JPRB,.248E-03_JPRB,.263E-03_JPRB,.288E-03_JPRB,.290E-03_JPRB,.329E-03_JPRB,&
&.472E-03_JPRB,.694E-03_JPRB,.997E-03_JPRB,.217E-02_JPRB,.367E-02_JPRB,.470E-02_JPRB,.594E-02_JPRB,&
&.726E-02_JPRB,.844E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat:  4  78.0
ZAER (:, 4,12) = (/&
&.117E-01_JPRB,.960E-02_JPRB,.874E-02_JPRB,.933E-02_JPRB,.936E-02_JPRB,.930E-02_JPRB,.923E-02_JPRB,&
&.814E-02_JPRB,.890E-02_JPRB,.730E-02_JPRB,.695E-02_JPRB,.768E-02_JPRB,.615E-02_JPRB,.635E-02_JPRB,&
&.735E-02_JPRB,.625E-02_JPRB,.440E-02_JPRB,.388E-02_JPRB,.308E-02_JPRB,.249E-02_JPRB,.305E-02_JPRB,&
&.353E-02_JPRB,.397E-02_JPRB,.549E-02_JPRB,.569E-02_JPRB,.431E-02_JPRB,.553E-02_JPRB,.493E-02_JPRB,&
&.394E-02_JPRB,.372E-02_JPRB,.339E-02_JPRB,.264E-02_JPRB,.245E-02_JPRB,.139E-02_JPRB,.844E-03_JPRB,&
&.663E-03_JPRB,.475E-03_JPRB,.304E-03_JPRB,.313E-03_JPRB,.334E-03_JPRB,.365E-03_JPRB,.463E-03_JPRB,&
&.506E-03_JPRB,.518E-03_JPRB,.579E-03_JPRB,.599E-03_JPRB,.626E-03_JPRB,.678E-03_JPRB,.709E-03_JPRB,&
&.714E-03_JPRB,.757E-03_JPRB,.615E-03_JPRB,.521E-03_JPRB,.502E-03_JPRB,.432E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.341E-03_JPRB,.320E-03_JPRB,.374E-03_JPRB,.384E-03_JPRB,.400E-03_JPRB,.545E-03_JPRB,&
&.715E-03_JPRB,.969E-03_JPRB,.133E-02_JPRB,.163E-02_JPRB,.228E-02_JPRB,.518E-02_JPRB,.139E-01_JPRB,&
&.137E-01_JPRB,.130E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat:  5  74.0
ZAER (:, 5,12) = (/&
&.995E-02_JPRB,.104E-01_JPRB,.120E-01_JPRB,.136E-01_JPRB,.131E-01_JPRB,.117E-01_JPRB,.115E-01_JPRB,&
&.109E-01_JPRB,.108E-01_JPRB,.114E-01_JPRB,.116E-01_JPRB,.106E-01_JPRB,.121E-01_JPRB,.136E-01_JPRB,&
&.149E-01_JPRB,.163E-01_JPRB,.149E-01_JPRB,.116E-01_JPRB,.865E-02_JPRB,.736E-02_JPRB,.789E-02_JPRB,&
&.666E-02_JPRB,.476E-02_JPRB,.517E-02_JPRB,.679E-02_JPRB,.741E-02_JPRB,.729E-02_JPRB,.815E-02_JPRB,&
&.778E-02_JPRB,.741E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.731E-02_JPRB,.524E-02_JPRB,.241E-02_JPRB,&
&.115E-02_JPRB,.801E-03_JPRB,.464E-03_JPRB,.361E-03_JPRB,.456E-03_JPRB,.631E-03_JPRB,.944E-03_JPRB,&
&.126E-02_JPRB,.142E-02_JPRB,.120E-02_JPRB,.102E-02_JPRB,.951E-03_JPRB,.130E-02_JPRB,.146E-02_JPRB,&
&.184E-02_JPRB,.164E-02_JPRB,.100E-02_JPRB,.840E-03_JPRB,.613E-03_JPRB,.479E-03_JPRB,.504E-03_JPRB,&
&.505E-03_JPRB,.475E-03_JPRB,.522E-03_JPRB,.639E-03_JPRB,.659E-03_JPRB,.674E-03_JPRB,.703E-03_JPRB,&
&.884E-03_JPRB,.110E-02_JPRB,.159E-02_JPRB,.218E-02_JPRB,.302E-02_JPRB,.467E-02_JPRB,.815E-02_JPRB,&
&.113E-01_JPRB,.103E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat:  6  70.0
ZAER (:, 6,12) = (/&
&.143E-01_JPRB,.152E-01_JPRB,.160E-01_JPRB,.146E-01_JPRB,.126E-01_JPRB,.116E-01_JPRB,.119E-01_JPRB,&
&.102E-01_JPRB,.113E-01_JPRB,.120E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.136E-01_JPRB,.114E-01_JPRB,&
&.120E-01_JPRB,.146E-01_JPRB,.145E-01_JPRB,.120E-01_JPRB,.936E-02_JPRB,.830E-02_JPRB,.889E-02_JPRB,&
&.956E-02_JPRB,.771E-02_JPRB,.768E-02_JPRB,.865E-02_JPRB,.974E-02_JPRB,.933E-02_JPRB,.100E-01_JPRB,&
&.104E-01_JPRB,.109E-01_JPRB,.116E-01_JPRB,.110E-01_JPRB,.115E-01_JPRB,.102E-01_JPRB,.856E-02_JPRB,&
&.430E-02_JPRB,.233E-02_JPRB,.188E-02_JPRB,.216E-02_JPRB,.351E-02_JPRB,.422E-02_JPRB,.394E-02_JPRB,&
&.488E-02_JPRB,.527E-02_JPRB,.585E-02_JPRB,.347E-02_JPRB,.266E-02_JPRB,.188E-02_JPRB,.328E-02_JPRB,&
&.511E-02_JPRB,.570E-02_JPRB,.313E-02_JPRB,.185E-02_JPRB,.123E-02_JPRB,.112E-02_JPRB,.124E-02_JPRB,&
&.121E-02_JPRB,.125E-02_JPRB,.136E-02_JPRB,.175E-02_JPRB,.230E-02_JPRB,.238E-02_JPRB,.215E-02_JPRB,&
&.170E-02_JPRB,.182E-02_JPRB,.302E-02_JPRB,.539E-02_JPRB,.885E-02_JPRB,.999E-02_JPRB,.917E-02_JPRB,&
&.117E-01_JPRB,.124E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat:  7  66.0
ZAER (:, 7,12) = (/&
&.142E-01_JPRB,.147E-01_JPRB,.155E-01_JPRB,.142E-01_JPRB,.126E-01_JPRB,.111E-01_JPRB,.113E-01_JPRB,&
&.121E-01_JPRB,.110E-01_JPRB,.109E-01_JPRB,.128E-01_JPRB,.148E-01_JPRB,.140E-01_JPRB,.135E-01_JPRB,&
&.126E-01_JPRB,.134E-01_JPRB,.123E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.123E-01_JPRB,.177E-01_JPRB,&
&.217E-01_JPRB,.198E-01_JPRB,.131E-01_JPRB,.118E-01_JPRB,.124E-01_JPRB,.143E-01_JPRB,.158E-01_JPRB,&
&.142E-01_JPRB,.130E-01_JPRB,.122E-01_JPRB,.141E-01_JPRB,.147E-01_JPRB,.152E-01_JPRB,.133E-01_JPRB,&
&.106E-01_JPRB,.975E-02_JPRB,.887E-02_JPRB,.925E-02_JPRB,.105E-01_JPRB,.132E-01_JPRB,.121E-01_JPRB,&
&.905E-02_JPRB,.770E-02_JPRB,.118E-01_JPRB,.162E-01_JPRB,.153E-01_JPRB,.151E-01_JPRB,.175E-01_JPRB,&
&.192E-01_JPRB,.163E-01_JPRB,.102E-01_JPRB,.688E-02_JPRB,.477E-02_JPRB,.427E-02_JPRB,.571E-02_JPRB,&
&.633E-02_JPRB,.657E-02_JPRB,.715E-02_JPRB,.731E-02_JPRB,.850E-02_JPRB,.979E-02_JPRB,.925E-02_JPRB,&
&.820E-02_JPRB,.103E-01_JPRB,.147E-01_JPRB,.169E-01_JPRB,.164E-01_JPRB,.168E-01_JPRB,.193E-01_JPRB,&
&.181E-01_JPRB,.153E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat:  8  62.0
ZAER (:, 8,12) = (/&
&.131E-01_JPRB,.144E-01_JPRB,.157E-01_JPRB,.158E-01_JPRB,.160E-01_JPRB,.143E-01_JPRB,.110E-01_JPRB,&
&.120E-01_JPRB,.129E-01_JPRB,.136E-01_JPRB,.124E-01_JPRB,.120E-01_JPRB,.125E-01_JPRB,.103E-01_JPRB,&
&.112E-01_JPRB,.128E-01_JPRB,.146E-01_JPRB,.134E-01_JPRB,.124E-01_JPRB,.141E-01_JPRB,.168E-01_JPRB,&
&.216E-01_JPRB,.218E-01_JPRB,.172E-01_JPRB,.148E-01_JPRB,.151E-01_JPRB,.159E-01_JPRB,.170E-01_JPRB,&
&.176E-01_JPRB,.145E-01_JPRB,.120E-01_JPRB,.131E-01_JPRB,.164E-01_JPRB,.153E-01_JPRB,.134E-01_JPRB,&
&.129E-01_JPRB,.143E-01_JPRB,.154E-01_JPRB,.153E-01_JPRB,.158E-01_JPRB,.153E-01_JPRB,.180E-01_JPRB,&
&.210E-01_JPRB,.216E-01_JPRB,.216E-01_JPRB,.235E-01_JPRB,.271E-01_JPRB,.247E-01_JPRB,.275E-01_JPRB,&
&.261E-01_JPRB,.233E-01_JPRB,.156E-01_JPRB,.108E-01_JPRB,.915E-02_JPRB,.115E-01_JPRB,.162E-01_JPRB,&
&.177E-01_JPRB,.163E-01_JPRB,.156E-01_JPRB,.179E-01_JPRB,.191E-01_JPRB,.188E-01_JPRB,.200E-01_JPRB,&
&.212E-01_JPRB,.216E-01_JPRB,.267E-01_JPRB,.302E-01_JPRB,.224E-01_JPRB,.208E-01_JPRB,.256E-01_JPRB,&
&.207E-01_JPRB,.124E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat:  9  58.0
ZAER (:, 9,12) = (/&
&.129E-01_JPRB,.140E-01_JPRB,.145E-01_JPRB,.160E-01_JPRB,.156E-01_JPRB,.142E-01_JPRB,.123E-01_JPRB,&
&.109E-01_JPRB,.111E-01_JPRB,.123E-01_JPRB,.117E-01_JPRB,.107E-01_JPRB,.108E-01_JPRB,.125E-01_JPRB,&
&.133E-01_JPRB,.140E-01_JPRB,.127E-01_JPRB,.126E-01_JPRB,.145E-01_JPRB,.159E-01_JPRB,.148E-01_JPRB,&
&.138E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.120E-01_JPRB,.123E-01_JPRB,.131E-01_JPRB,.175E-01_JPRB,&
&.169E-01_JPRB,.180E-01_JPRB,.171E-01_JPRB,.143E-01_JPRB,.158E-01_JPRB,.148E-01_JPRB,.136E-01_JPRB,&
&.146E-01_JPRB,.150E-01_JPRB,.151E-01_JPRB,.157E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.191E-01_JPRB,&
&.249E-01_JPRB,.289E-01_JPRB,.287E-01_JPRB,.268E-01_JPRB,.272E-01_JPRB,.266E-01_JPRB,.202E-01_JPRB,&
&.230E-01_JPRB,.214E-01_JPRB,.240E-01_JPRB,.229E-01_JPRB,.200E-01_JPRB,.203E-01_JPRB,.205E-01_JPRB,&
&.202E-01_JPRB,.195E-01_JPRB,.198E-01_JPRB,.237E-01_JPRB,.246E-01_JPRB,.229E-01_JPRB,.263E-01_JPRB,&
&.258E-01_JPRB,.249E-01_JPRB,.251E-01_JPRB,.248E-01_JPRB,.182E-01_JPRB,.155E-01_JPRB,.174E-01_JPRB,&
&.162E-01_JPRB,.139E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 10  54.0
ZAER (:,10,12) = (/&
&.147E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.146E-01_JPRB,.134E-01_JPRB,.116E-01_JPRB,.117E-01_JPRB,&
&.114E-01_JPRB,.120E-01_JPRB,.118E-01_JPRB,.117E-01_JPRB,.118E-01_JPRB,.120E-01_JPRB,.123E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.126E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.119E-01_JPRB,.113E-01_JPRB,&
&.117E-01_JPRB,.774E-02_JPRB,.133E-01_JPRB,.139E-01_JPRB,.143E-01_JPRB,.131E-01_JPRB,.134E-01_JPRB,&
&.140E-01_JPRB,.152E-01_JPRB,.147E-01_JPRB,.141E-01_JPRB,.168E-01_JPRB,.167E-01_JPRB,.161E-01_JPRB,&
&.164E-01_JPRB,.161E-01_JPRB,.160E-01_JPRB,.151E-01_JPRB,.149E-01_JPRB,.147E-01_JPRB,.153E-01_JPRB,&
&.184E-01_JPRB,.208E-01_JPRB,.196E-01_JPRB,.192E-01_JPRB,.229E-01_JPRB,.257E-01_JPRB,.251E-01_JPRB,&
&.240E-01_JPRB,.244E-01_JPRB,.231E-01_JPRB,.235E-01_JPRB,.254E-01_JPRB,.253E-01_JPRB,.211E-01_JPRB,&
&.190E-01_JPRB,.187E-01_JPRB,.193E-01_JPRB,.193E-01_JPRB,.206E-01_JPRB,.219E-01_JPRB,.224E-01_JPRB,&
&.210E-01_JPRB,.204E-01_JPRB,.180E-01_JPRB,.169E-01_JPRB,.163E-01_JPRB,.163E-01_JPRB,.156E-01_JPRB,&
&.163E-01_JPRB,.160E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 11  50.0
ZAER (:,11,12) = (/&
&.138E-01_JPRB,.143E-01_JPRB,.131E-01_JPRB,.119E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.121E-01_JPRB,.119E-01_JPRB,.112E-01_JPRB,.104E-01_JPRB,.868E-02_JPRB,.803E-02_JPRB,&
&.817E-02_JPRB,.931E-02_JPRB,.110E-01_JPRB,.112E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.929E-02_JPRB,&
&.862E-02_JPRB,.555E-02_JPRB,.108E-01_JPRB,.990E-02_JPRB,.979E-02_JPRB,.104E-01_JPRB,.102E-01_JPRB,&
&.974E-02_JPRB,.113E-01_JPRB,.123E-01_JPRB,.134E-01_JPRB,.154E-01_JPRB,.158E-01_JPRB,.155E-01_JPRB,&
&.153E-01_JPRB,.147E-01_JPRB,.154E-01_JPRB,.150E-01_JPRB,.153E-01_JPRB,.141E-01_JPRB,.136E-01_JPRB,&
&.130E-01_JPRB,.136E-01_JPRB,.149E-01_JPRB,.127E-01_JPRB,.126E-01_JPRB,.136E-01_JPRB,.137E-01_JPRB,&
&.123E-01_JPRB,.119E-01_JPRB,.127E-01_JPRB,.137E-01_JPRB,.144E-01_JPRB,.143E-01_JPRB,.149E-01_JPRB,&
&.169E-01_JPRB,.172E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.170E-01_JPRB,.169E-01_JPRB,.167E-01_JPRB,&
&.162E-01_JPRB,.159E-01_JPRB,.149E-01_JPRB,.135E-01_JPRB,.130E-01_JPRB,.134E-01_JPRB,.137E-01_JPRB,&
&.139E-01_JPRB,.138E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 12  46.0
ZAER (:,12,12) = (/&
&.121E-01_JPRB,.124E-01_JPRB,.123E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.116E-01_JPRB,.106E-01_JPRB,&
&.101E-01_JPRB,.981E-02_JPRB,.901E-02_JPRB,.880E-02_JPRB,.892E-02_JPRB,.771E-02_JPRB,.694E-02_JPRB,&
&.830E-02_JPRB,.966E-02_JPRB,.915E-02_JPRB,.946E-02_JPRB,.919E-02_JPRB,.830E-02_JPRB,.837E-02_JPRB,&
&.819E-02_JPRB,.489E-02_JPRB,.103E-01_JPRB,.106E-01_JPRB,.114E-01_JPRB,.113E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.109E-01_JPRB,.127E-01_JPRB,.140E-01_JPRB,.139E-01_JPRB,.144E-01_JPRB,.142E-01_JPRB,&
&.133E-01_JPRB,.130E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.127E-01_JPRB,.115E-01_JPRB,&
&.122E-01_JPRB,.129E-01_JPRB,.146E-01_JPRB,.132E-01_JPRB,.109E-01_JPRB,.972E-02_JPRB,.106E-01_JPRB,&
&.103E-01_JPRB,.107E-01_JPRB,.113E-01_JPRB,.120E-01_JPRB,.104E-01_JPRB,.992E-02_JPRB,.104E-01_JPRB,&
&.111E-01_JPRB,.123E-01_JPRB,.132E-01_JPRB,.137E-01_JPRB,.140E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,&
&.145E-01_JPRB,.137E-01_JPRB,.130E-01_JPRB,.124E-01_JPRB,.119E-01_JPRB,.115E-01_JPRB,.116E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 13  42.0
ZAER (:,13,12) = (/&
&.112E-01_JPRB,.115E-01_JPRB,.111E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.108E-01_JPRB,.113E-01_JPRB,&
&.108E-01_JPRB,.855E-02_JPRB,.849E-02_JPRB,.757E-02_JPRB,.842E-02_JPRB,.899E-02_JPRB,.927E-02_JPRB,&
&.894E-02_JPRB,.863E-02_JPRB,.867E-02_JPRB,.920E-02_JPRB,.908E-02_JPRB,.816E-02_JPRB,.728E-02_JPRB,&
&.642E-02_JPRB,.469E-02_JPRB,.642E-02_JPRB,.147E-01_JPRB,.165E-01_JPRB,.148E-01_JPRB,.129E-01_JPRB,&
&.115E-01_JPRB,.112E-01_JPRB,.117E-01_JPRB,.122E-01_JPRB,.120E-01_JPRB,.126E-01_JPRB,.120E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,&
&.114E-01_JPRB,.135E-01_JPRB,.140E-01_JPRB,.120E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,&
&.105E-01_JPRB,.114E-01_JPRB,.122E-01_JPRB,.118E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.111E-01_JPRB,&
&.103E-01_JPRB,.923E-02_JPRB,.924E-02_JPRB,.102E-01_JPRB,.112E-01_JPRB,.115E-01_JPRB,.119E-01_JPRB,&
&.120E-01_JPRB,.122E-01_JPRB,.109E-01_JPRB,.104E-01_JPRB,.101E-01_JPRB,.113E-01_JPRB,.112E-01_JPRB,&
&.102E-01_JPRB,.100E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 14  38.0
ZAER (:,14,12) = (/&
&.130E-01_JPRB,.118E-01_JPRB,.124E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.109E-01_JPRB,.114E-01_JPRB,&
&.113E-01_JPRB,.965E-02_JPRB,.105E-01_JPRB,.941E-02_JPRB,.105E-01_JPRB,.101E-01_JPRB,.997E-02_JPRB,&
&.950E-02_JPRB,.931E-02_JPRB,.808E-02_JPRB,.850E-02_JPRB,.790E-02_JPRB,.777E-02_JPRB,.850E-02_JPRB,&
&.767E-02_JPRB,.617E-02_JPRB,.102E-01_JPRB,.978E-02_JPRB,.155E-01_JPRB,.148E-01_JPRB,.151E-01_JPRB,&
&.138E-01_JPRB,.135E-01_JPRB,.127E-01_JPRB,.123E-01_JPRB,.117E-01_JPRB,.115E-01_JPRB,.119E-01_JPRB,&
&.110E-01_JPRB,.109E-01_JPRB,.118E-01_JPRB,.112E-01_JPRB,.111E-01_JPRB,.136E-01_JPRB,.158E-01_JPRB,&
&.171E-01_JPRB,.159E-01_JPRB,.136E-01_JPRB,.118E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.108E-01_JPRB,&
&.110E-01_JPRB,.112E-01_JPRB,.109E-01_JPRB,.108E-01_JPRB,.114E-01_JPRB,.109E-01_JPRB,.986E-02_JPRB,&
&.917E-02_JPRB,.828E-02_JPRB,.898E-02_JPRB,.107E-01_JPRB,.108E-01_JPRB,.124E-01_JPRB,.120E-01_JPRB,&
&.121E-01_JPRB,.118E-01_JPRB,.658E-02_JPRB,.119E-01_JPRB,.138E-01_JPRB,.140E-01_JPRB,.128E-01_JPRB,&
&.118E-01_JPRB,.971E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 15  34.0
ZAER (:,15,12) = (/&
&.124E-01_JPRB,.120E-01_JPRB,.133E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.103E-01_JPRB,.954E-02_JPRB,&
&.955E-02_JPRB,.939E-02_JPRB,.993E-02_JPRB,.102E-01_JPRB,.104E-01_JPRB,.896E-02_JPRB,.872E-02_JPRB,&
&.850E-02_JPRB,.786E-02_JPRB,.837E-02_JPRB,.852E-02_JPRB,.703E-02_JPRB,.657E-02_JPRB,.773E-02_JPRB,&
&.126E-01_JPRB,.829E-02_JPRB,.137E-01_JPRB,.122E-01_JPRB,.117E-01_JPRB,.184E-01_JPRB,.193E-01_JPRB,&
&.176E-01_JPRB,.165E-01_JPRB,.158E-01_JPRB,.139E-01_JPRB,.128E-01_JPRB,.119E-01_JPRB,.122E-01_JPRB,&
&.113E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.148E-01_JPRB,.106E-01_JPRB,.212E-01_JPRB,&
&.215E-01_JPRB,.182E-01_JPRB,.150E-01_JPRB,.135E-01_JPRB,.137E-01_JPRB,.131E-01_JPRB,.113E-01_JPRB,&
&.109E-01_JPRB,.104E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.898E-02_JPRB,&
&.103E-01_JPRB,.104E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.915E-02_JPRB,.171E-01_JPRB,.152E-01_JPRB,&
&.141E-01_JPRB,.883E-02_JPRB,.958E-02_JPRB,.912E-02_JPRB,.157E-01_JPRB,.137E-01_JPRB,.127E-01_JPRB,&
&.124E-01_JPRB,.119E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 16  30.0
ZAER (:,16,12) = (/&
&.142E-01_JPRB,.147E-01_JPRB,.143E-01_JPRB,.133E-01_JPRB,.129E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.106E-01_JPRB,.100E-01_JPRB,.958E-02_JPRB,.103E-01_JPRB,.117E-01_JPRB,.123E-01_JPRB,.104E-01_JPRB,&
&.956E-02_JPRB,.869E-02_JPRB,.839E-02_JPRB,.876E-02_JPRB,.860E-02_JPRB,.801E-02_JPRB,.858E-02_JPRB,&
&.154E-01_JPRB,.125E-01_JPRB,.172E-01_JPRB,.171E-01_JPRB,.167E-01_JPRB,.259E-01_JPRB,.264E-01_JPRB,&
&.222E-01_JPRB,.190E-01_JPRB,.180E-01_JPRB,.166E-01_JPRB,.148E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.124E-01_JPRB,.112E-01_JPRB,.122E-01_JPRB,.161E-01_JPRB,.194E-01_JPRB,.147E-01_JPRB,.198E-01_JPRB,&
&.176E-01_JPRB,.286E-01_JPRB,.215E-01_JPRB,.179E-01_JPRB,.162E-01_JPRB,.154E-01_JPRB,.148E-01_JPRB,&
&.146E-01_JPRB,.129E-01_JPRB,.132E-01_JPRB,.120E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.125E-01_JPRB,&
&.143E-01_JPRB,.174E-01_JPRB,.204E-01_JPRB,.122E-01_JPRB,.109E-01_JPRB,.118E-01_JPRB,.104E-01_JPRB,&
&.109E-01_JPRB,.119E-01_JPRB,.127E-01_JPRB,.108E-01_JPRB,.164E-01_JPRB,.144E-01_JPRB,.141E-01_JPRB,&
&.137E-01_JPRB,.135E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 17  26.0
ZAER (:,17,12) = (/&
&.179E-01_JPRB,.184E-01_JPRB,.175E-01_JPRB,.161E-01_JPRB,.144E-01_JPRB,.133E-01_JPRB,.128E-01_JPRB,&
&.129E-01_JPRB,.118E-01_JPRB,.124E-01_JPRB,.135E-01_JPRB,.144E-01_JPRB,.136E-01_JPRB,.117E-01_JPRB,&
&.101E-01_JPRB,.890E-02_JPRB,.884E-02_JPRB,.947E-02_JPRB,.989E-02_JPRB,.116E-01_JPRB,.126E-01_JPRB,&
&.240E-01_JPRB,.198E-01_JPRB,.199E-01_JPRB,.211E-01_JPRB,.201E-01_JPRB,.207E-01_JPRB,.373E-01_JPRB,&
&.268E-01_JPRB,.218E-01_JPRB,.188E-01_JPRB,.174E-01_JPRB,.162E-01_JPRB,.155E-01_JPRB,.149E-01_JPRB,&
&.142E-01_JPRB,.141E-01_JPRB,.167E-01_JPRB,.211E-01_JPRB,.127E-01_JPRB,.176E-01_JPRB,.317E-01_JPRB,&
&.191E-01_JPRB,.378E-01_JPRB,.251E-01_JPRB,.200E-01_JPRB,.193E-01_JPRB,.185E-01_JPRB,.181E-01_JPRB,&
&.164E-01_JPRB,.155E-01_JPRB,.154E-01_JPRB,.140E-01_JPRB,.136E-01_JPRB,.147E-01_JPRB,.168E-01_JPRB,&
&.195E-01_JPRB,.229E-01_JPRB,.275E-01_JPRB,.147E-01_JPRB,.106E-01_JPRB,.102E-01_JPRB,.114E-01_JPRB,&
&.157E-01_JPRB,.158E-01_JPRB,.136E-01_JPRB,.107E-01_JPRB,.182E-01_JPRB,.196E-01_JPRB,.163E-01_JPRB,&
&.165E-01_JPRB,.174E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 18  22.0
ZAER (:,18,12) = (/&
&.197E-01_JPRB,.188E-01_JPRB,.182E-01_JPRB,.162E-01_JPRB,.155E-01_JPRB,.149E-01_JPRB,.151E-01_JPRB,&
&.145E-01_JPRB,.142E-01_JPRB,.139E-01_JPRB,.150E-01_JPRB,.156E-01_JPRB,.137E-01_JPRB,.124E-01_JPRB,&
&.122E-01_JPRB,.114E-01_JPRB,.113E-01_JPRB,.125E-01_JPRB,.178E-01_JPRB,.230E-01_JPRB,.277E-01_JPRB,&
&.591E-01_JPRB,.317E-01_JPRB,.193E-01_JPRB,.200E-01_JPRB,.184E-01_JPRB,.210E-01_JPRB,.190E-01_JPRB,&
&.264E-01_JPRB,.216E-01_JPRB,.196E-01_JPRB,.188E-01_JPRB,.166E-01_JPRB,.167E-01_JPRB,.153E-01_JPRB,&
&.156E-01_JPRB,.182E-01_JPRB,.232E-01_JPRB,.220E-01_JPRB,.119E-01_JPRB,.140E-01_JPRB,.193E-01_JPRB,&
&.171E-01_JPRB,.152E-01_JPRB,.198E-01_JPRB,.107E-01_JPRB,.194E-01_JPRB,.224E-01_JPRB,.250E-01_JPRB,&
&.152E-01_JPRB,.151E-01_JPRB,.179E-01_JPRB,.176E-01_JPRB,.174E-01_JPRB,.194E-01_JPRB,.221E-01_JPRB,&
&.257E-01_JPRB,.299E-01_JPRB,.355E-01_JPRB,.304E-01_JPRB,.146E-01_JPRB,.137E-01_JPRB,.167E-01_JPRB,&
&.214E-01_JPRB,.172E-01_JPRB,.144E-01_JPRB,.228E-01_JPRB,.248E-01_JPRB,.305E-01_JPRB,.290E-01_JPRB,&
&.237E-01_JPRB,.212E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 19  18.0
ZAER (:,19,12) = (/&
&.201E-01_JPRB,.188E-01_JPRB,.180E-01_JPRB,.171E-01_JPRB,.173E-01_JPRB,.170E-01_JPRB,.171E-01_JPRB,&
&.167E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.170E-01_JPRB,.173E-01_JPRB,.156E-01_JPRB,.149E-01_JPRB,&
&.179E-01_JPRB,.187E-01_JPRB,.205E-01_JPRB,.274E-01_JPRB,.312E-01_JPRB,.362E-01_JPRB,.512E-01_JPRB,&
&.102E+00_JPRB,.301E-01_JPRB,.189E-01_JPRB,.176E-01_JPRB,.164E-01_JPRB,.180E-01_JPRB,.183E-01_JPRB,&
&.143E-01_JPRB,.202E-01_JPRB,.194E-01_JPRB,.191E-01_JPRB,.180E-01_JPRB,.174E-01_JPRB,.179E-01_JPRB,&
&.205E-01_JPRB,.247E-01_JPRB,.276E-01_JPRB,.211E-01_JPRB,.107E-01_JPRB,.136E-01_JPRB,.165E-01_JPRB,&
&.135E-01_JPRB,.112E-01_JPRB,.141E-01_JPRB,.941E-02_JPRB,.168E-01_JPRB,.222E-01_JPRB,.190E-01_JPRB,&
&.150E-01_JPRB,.173E-01_JPRB,.197E-01_JPRB,.212E-01_JPRB,.235E-01_JPRB,.260E-01_JPRB,.302E-01_JPRB,&
&.343E-01_JPRB,.449E-01_JPRB,.496E-01_JPRB,.455E-01_JPRB,.397E-01_JPRB,.224E-01_JPRB,.253E-01_JPRB,&
&.284E-01_JPRB,.257E-01_JPRB,.238E-01_JPRB,.449E-01_JPRB,.493E-01_JPRB,.524E-01_JPRB,.585E-01_JPRB,&
&.379E-01_JPRB,.238E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 20  14.0
ZAER (:,20,12) = (/&
&.193E-01_JPRB,.182E-01_JPRB,.181E-01_JPRB,.182E-01_JPRB,.188E-01_JPRB,.194E-01_JPRB,.198E-01_JPRB,&
&.199E-01_JPRB,.203E-01_JPRB,.200E-01_JPRB,.201E-01_JPRB,.202E-01_JPRB,.198E-01_JPRB,.200E-01_JPRB,&
&.266E-01_JPRB,.323E-01_JPRB,.386E-01_JPRB,.412E-01_JPRB,.439E-01_JPRB,.482E-01_JPRB,.642E-01_JPRB,&
&.421E-01_JPRB,.286E-01_JPRB,.190E-01_JPRB,.151E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.160E-01_JPRB,&
&.148E-01_JPRB,.210E-01_JPRB,.204E-01_JPRB,.198E-01_JPRB,.187E-01_JPRB,.200E-01_JPRB,.219E-01_JPRB,&
&.252E-01_JPRB,.287E-01_JPRB,.272E-01_JPRB,.185E-01_JPRB,.101E-01_JPRB,.114E-01_JPRB,.153E-01_JPRB,&
&.142E-01_JPRB,.921E-02_JPRB,.774E-02_JPRB,.147E-01_JPRB,.152E-01_JPRB,.165E-01_JPRB,.162E-01_JPRB,&
&.172E-01_JPRB,.196E-01_JPRB,.232E-01_JPRB,.287E-01_JPRB,.350E-01_JPRB,.419E-01_JPRB,.504E-01_JPRB,&
&.566E-01_JPRB,.649E-01_JPRB,.668E-01_JPRB,.594E-01_JPRB,.578E-01_JPRB,.586E-01_JPRB,.396E-01_JPRB,&
&.401E-01_JPRB,.801E-01_JPRB,.829E-01_JPRB,.800E-01_JPRB,.667E-01_JPRB,.600E-01_JPRB,.599E-01_JPRB,&
&.319E-01_JPRB,.227E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 21  10.0
ZAER (:,21,12) = (/&
&.189E-01_JPRB,.185E-01_JPRB,.195E-01_JPRB,.206E-01_JPRB,.213E-01_JPRB,.224E-01_JPRB,.233E-01_JPRB,&
&.241E-01_JPRB,.246E-01_JPRB,.250E-01_JPRB,.253E-01_JPRB,.260E-01_JPRB,.259E-01_JPRB,.280E-01_JPRB,&
&.358E-01_JPRB,.429E-01_JPRB,.471E-01_JPRB,.504E-01_JPRB,.496E-01_JPRB,.584E-01_JPRB,.570E-01_JPRB,&
&.291E-01_JPRB,.239E-01_JPRB,.165E-01_JPRB,.142E-01_JPRB,.139E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,&
&.140E-01_JPRB,.203E-01_JPRB,.205E-01_JPRB,.209E-01_JPRB,.198E-01_JPRB,.195E-01_JPRB,.217E-01_JPRB,&
&.230E-01_JPRB,.240E-01_JPRB,.208E-01_JPRB,.159E-01_JPRB,.937E-02_JPRB,.104E-01_JPRB,.134E-01_JPRB,&
&.121E-01_JPRB,.851E-02_JPRB,.121E-01_JPRB,.132E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.165E-01_JPRB,&
&.189E-01_JPRB,.225E-01_JPRB,.288E-01_JPRB,.381E-01_JPRB,.511E-01_JPRB,.670E-01_JPRB,.838E-01_JPRB,&
&.107E+00_JPRB,.135E+00_JPRB,.151E+00_JPRB,.821E-01_JPRB,.105E+00_JPRB,.103E+00_JPRB,.106E+00_JPRB,&
&.123E+00_JPRB,.147E+00_JPRB,.140E+00_JPRB,.103E+00_JPRB,.782E-01_JPRB,.572E-01_JPRB,.452E-01_JPRB,&
&.270E-01_JPRB,.207E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 22   6.0
ZAER (:,22,12) = (/&
&.200E-01_JPRB,.197E-01_JPRB,.218E-01_JPRB,.230E-01_JPRB,.248E-01_JPRB,.265E-01_JPRB,.276E-01_JPRB,&
&.290E-01_JPRB,.297E-01_JPRB,.296E-01_JPRB,.318E-01_JPRB,.352E-01_JPRB,.377E-01_JPRB,.404E-01_JPRB,&
&.479E-01_JPRB,.555E-01_JPRB,.624E-01_JPRB,.654E-01_JPRB,.685E-01_JPRB,.852E-01_JPRB,.422E-01_JPRB,&
&.298E-01_JPRB,.216E-01_JPRB,.164E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,.163E-01_JPRB,.153E-01_JPRB,&
&.136E-01_JPRB,.212E-01_JPRB,.215E-01_JPRB,.223E-01_JPRB,.210E-01_JPRB,.180E-01_JPRB,.183E-01_JPRB,&
&.194E-01_JPRB,.209E-01_JPRB,.186E-01_JPRB,.162E-01_JPRB,.993E-02_JPRB,.113E-01_JPRB,.125E-01_JPRB,&
&.114E-01_JPRB,.891E-02_JPRB,.127E-01_JPRB,.132E-01_JPRB,.142E-01_JPRB,.152E-01_JPRB,.172E-01_JPRB,&
&.203E-01_JPRB,.252E-01_JPRB,.329E-01_JPRB,.454E-01_JPRB,.626E-01_JPRB,.827E-01_JPRB,.104E+00_JPRB,&
&.132E+00_JPRB,.160E+00_JPRB,.155E+00_JPRB,.143E+00_JPRB,.144E+00_JPRB,.144E+00_JPRB,.155E+00_JPRB,&
&.171E+00_JPRB,.965E-01_JPRB,.885E-01_JPRB,.110E+00_JPRB,.823E-01_JPRB,.518E-01_JPRB,.331E-01_JPRB,&
&.239E-01_JPRB,.199E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 23   2.0
ZAER (:,23,12) = (/&
&.248E-01_JPRB,.260E-01_JPRB,.274E-01_JPRB,.296E-01_JPRB,.346E-01_JPRB,.351E-01_JPRB,.353E-01_JPRB,&
&.390E-01_JPRB,.415E-01_JPRB,.435E-01_JPRB,.488E-01_JPRB,.557E-01_JPRB,.616E-01_JPRB,.701E-01_JPRB,&
&.748E-01_JPRB,.782E-01_JPRB,.809E-01_JPRB,.933E-01_JPRB,.104E+00_JPRB,.990E-01_JPRB,.592E-01_JPRB,&
&.441E-01_JPRB,.263E-01_JPRB,.180E-01_JPRB,.151E-01_JPRB,.152E-01_JPRB,.180E-01_JPRB,.162E-01_JPRB,&
&.226E-01_JPRB,.236E-01_JPRB,.227E-01_JPRB,.213E-01_JPRB,.210E-01_JPRB,.201E-01_JPRB,.199E-01_JPRB,&
&.197E-01_JPRB,.179E-01_JPRB,.172E-01_JPRB,.961E-02_JPRB,.105E-01_JPRB,.121E-01_JPRB,.151E-01_JPRB,&
&.125E-01_JPRB,.982E-02_JPRB,.903E-02_JPRB,.140E-01_JPRB,.146E-01_JPRB,.158E-01_JPRB,.183E-01_JPRB,&
&.213E-01_JPRB,.264E-01_JPRB,.342E-01_JPRB,.458E-01_JPRB,.610E-01_JPRB,.823E-01_JPRB,.100E+00_JPRB,&
&.114E+00_JPRB,.788E-01_JPRB,.132E+00_JPRB,.810E-01_JPRB,.148E+00_JPRB,.166E+00_JPRB,.157E+00_JPRB,&
&.898E-01_JPRB,.152E+00_JPRB,.122E+00_JPRB,.718E-01_JPRB,.620E-01_JPRB,.402E-01_JPRB,.304E-01_JPRB,&
&.254E-01_JPRB,.230E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 24  -2.0
ZAER (:,24,12) = (/&
&.346E-01_JPRB,.396E-01_JPRB,.435E-01_JPRB,.461E-01_JPRB,.515E-01_JPRB,.531E-01_JPRB,.560E-01_JPRB,&
&.593E-01_JPRB,.650E-01_JPRB,.695E-01_JPRB,.749E-01_JPRB,.856E-01_JPRB,.979E-01_JPRB,.113E+00_JPRB,&
&.126E+00_JPRB,.138E+00_JPRB,.147E+00_JPRB,.147E+00_JPRB,.138E+00_JPRB,.132E+00_JPRB,.123E+00_JPRB,&
&.498E-01_JPRB,.277E-01_JPRB,.182E-01_JPRB,.151E-01_JPRB,.147E-01_JPRB,.237E-01_JPRB,.226E-01_JPRB,&
&.226E-01_JPRB,.223E-01_JPRB,.207E-01_JPRB,.202E-01_JPRB,.198E-01_JPRB,.183E-01_JPRB,.175E-01_JPRB,&
&.159E-01_JPRB,.157E-01_JPRB,.161E-01_JPRB,.952E-02_JPRB,.101E-01_JPRB,.113E-01_JPRB,.122E-01_JPRB,&
&.105E-01_JPRB,.918E-02_JPRB,.896E-02_JPRB,.878E-02_JPRB,.147E-01_JPRB,.162E-01_JPRB,.180E-01_JPRB,&
&.205E-01_JPRB,.244E-01_JPRB,.295E-01_JPRB,.368E-01_JPRB,.478E-01_JPRB,.637E-01_JPRB,.793E-01_JPRB,&
&.535E-01_JPRB,.109E+00_JPRB,.114E+00_JPRB,.674E-01_JPRB,.141E+00_JPRB,.162E+00_JPRB,.109E+00_JPRB,&
&.939E-01_JPRB,.665E-01_JPRB,.372E-01_JPRB,.367E-01_JPRB,.394E-01_JPRB,.321E-01_JPRB,.291E-01_JPRB,&
&.295E-01_JPRB,.308E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 25  -6.0
ZAER (:,25,12) = (/&
&.328E-01_JPRB,.372E-01_JPRB,.406E-01_JPRB,.427E-01_JPRB,.465E-01_JPRB,.488E-01_JPRB,.519E-01_JPRB,&
&.568E-01_JPRB,.619E-01_JPRB,.672E-01_JPRB,.748E-01_JPRB,.863E-01_JPRB,.980E-01_JPRB,.115E+00_JPRB,&
&.133E+00_JPRB,.147E+00_JPRB,.170E+00_JPRB,.177E+00_JPRB,.172E+00_JPRB,.144E+00_JPRB,.147E+00_JPRB,&
&.545E-01_JPRB,.299E-01_JPRB,.181E-01_JPRB,.145E-01_JPRB,.217E-01_JPRB,.219E-01_JPRB,.219E-01_JPRB,&
&.210E-01_JPRB,.199E-01_JPRB,.191E-01_JPRB,.190E-01_JPRB,.181E-01_JPRB,.172E-01_JPRB,.990E-02_JPRB,&
&.984E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.945E-02_JPRB,.904E-02_JPRB,.938E-02_JPRB,.947E-02_JPRB,&
&.935E-02_JPRB,.856E-02_JPRB,.819E-02_JPRB,.839E-02_JPRB,.159E-01_JPRB,.167E-01_JPRB,.185E-01_JPRB,&
&.206E-01_JPRB,.221E-01_JPRB,.258E-01_JPRB,.289E-01_JPRB,.347E-01_JPRB,.433E-01_JPRB,.541E-01_JPRB,&
&.657E-01_JPRB,.742E-01_JPRB,.840E-01_JPRB,.872E-01_JPRB,.871E-01_JPRB,.807E-01_JPRB,.561E-01_JPRB,&
&.435E-01_JPRB,.313E-01_JPRB,.244E-01_JPRB,.260E-01_JPRB,.269E-01_JPRB,.235E-01_JPRB,.244E-01_JPRB,&
&.263E-01_JPRB,.290E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 26 -10.0
ZAER (:,26,12) = (/&
&.298E-01_JPRB,.336E-01_JPRB,.367E-01_JPRB,.391E-01_JPRB,.410E-01_JPRB,.427E-01_JPRB,.458E-01_JPRB,&
&.521E-01_JPRB,.576E-01_JPRB,.630E-01_JPRB,.714E-01_JPRB,.811E-01_JPRB,.911E-01_JPRB,.105E+00_JPRB,&
&.117E+00_JPRB,.126E+00_JPRB,.139E+00_JPRB,.142E+00_JPRB,.154E+00_JPRB,.120E+00_JPRB,.954E-01_JPRB,&
&.458E-01_JPRB,.290E-01_JPRB,.177E-01_JPRB,.211E-01_JPRB,.211E-01_JPRB,.211E-01_JPRB,.202E-01_JPRB,&
&.199E-01_JPRB,.199E-01_JPRB,.207E-01_JPRB,.225E-01_JPRB,.235E-01_JPRB,.213E-01_JPRB,.125E-01_JPRB,&
&.134E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.138E-01_JPRB,.110E-01_JPRB,.959E-02_JPRB,.897E-02_JPRB,&
&.803E-02_JPRB,.825E-02_JPRB,.838E-02_JPRB,.806E-02_JPRB,.951E-02_JPRB,.176E-01_JPRB,.187E-01_JPRB,&
&.199E-01_JPRB,.201E-01_JPRB,.215E-01_JPRB,.236E-01_JPRB,.269E-01_JPRB,.314E-01_JPRB,.375E-01_JPRB,&
&.401E-01_JPRB,.423E-01_JPRB,.509E-01_JPRB,.593E-01_JPRB,.562E-01_JPRB,.459E-01_JPRB,.351E-01_JPRB,&
&.294E-01_JPRB,.247E-01_JPRB,.211E-01_JPRB,.206E-01_JPRB,.202E-01_JPRB,.200E-01_JPRB,.216E-01_JPRB,&
&.237E-01_JPRB,.263E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 27 -14.0
ZAER (:,27,12) = (/&
&.245E-01_JPRB,.277E-01_JPRB,.305E-01_JPRB,.333E-01_JPRB,.343E-01_JPRB,.347E-01_JPRB,.363E-01_JPRB,&
&.400E-01_JPRB,.452E-01_JPRB,.498E-01_JPRB,.571E-01_JPRB,.663E-01_JPRB,.776E-01_JPRB,.914E-01_JPRB,&
&.101E+00_JPRB,.108E+00_JPRB,.112E+00_JPRB,.114E+00_JPRB,.657E-01_JPRB,.453E-01_JPRB,.619E-01_JPRB,&
&.514E-01_JPRB,.430E-01_JPRB,.296E-01_JPRB,.218E-01_JPRB,.215E-01_JPRB,.212E-01_JPRB,.207E-01_JPRB,&
&.216E-01_JPRB,.228E-01_JPRB,.263E-01_JPRB,.306E-01_JPRB,.322E-01_JPRB,.185E-01_JPRB,.185E-01_JPRB,&
&.196E-01_JPRB,.198E-01_JPRB,.191E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,.161E-01_JPRB,.128E-01_JPRB,&
&.104E-01_JPRB,.912E-02_JPRB,.873E-02_JPRB,.794E-02_JPRB,.166E-01_JPRB,.184E-01_JPRB,.199E-01_JPRB,&
&.209E-01_JPRB,.197E-01_JPRB,.112E-01_JPRB,.191E-01_JPRB,.231E-01_JPRB,.309E-01_JPRB,.354E-01_JPRB,&
&.189E-01_JPRB,.184E-01_JPRB,.357E-01_JPRB,.419E-01_JPRB,.416E-01_JPRB,.316E-01_JPRB,.274E-01_JPRB,&
&.251E-01_JPRB,.238E-01_JPRB,.211E-01_JPRB,.185E-01_JPRB,.175E-01_JPRB,.170E-01_JPRB,.181E-01_JPRB,&
&.195E-01_JPRB,.219E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 28 -18.0
ZAER (:,28,12) = (/&
&.184E-01_JPRB,.220E-01_JPRB,.250E-01_JPRB,.258E-01_JPRB,.271E-01_JPRB,.252E-01_JPRB,.246E-01_JPRB,&
&.244E-01_JPRB,.264E-01_JPRB,.318E-01_JPRB,.413E-01_JPRB,.534E-01_JPRB,.656E-01_JPRB,.792E-01_JPRB,&
&.882E-01_JPRB,.952E-01_JPRB,.504E-01_JPRB,.439E-01_JPRB,.441E-01_JPRB,.558E-01_JPRB,.437E-01_JPRB,&
&.374E-01_JPRB,.352E-01_JPRB,.282E-01_JPRB,.222E-01_JPRB,.217E-01_JPRB,.212E-01_JPRB,.225E-01_JPRB,&
&.253E-01_JPRB,.258E-01_JPRB,.282E-01_JPRB,.301E-01_JPRB,.309E-01_JPRB,.184E-01_JPRB,.200E-01_JPRB,&
&.195E-01_JPRB,.186E-01_JPRB,.188E-01_JPRB,.183E-01_JPRB,.185E-01_JPRB,.187E-01_JPRB,.197E-01_JPRB,&
&.155E-01_JPRB,.148E-01_JPRB,.189E-01_JPRB,.104E-01_JPRB,.119E-01_JPRB,.130E-01_JPRB,.251E-01_JPRB,&
&.313E-01_JPRB,.288E-01_JPRB,.143E-01_JPRB,.134E-01_JPRB,.224E-01_JPRB,.376E-01_JPRB,.337E-01_JPRB,&
&.336E-01_JPRB,.199E-01_JPRB,.325E-01_JPRB,.318E-01_JPRB,.290E-01_JPRB,.250E-01_JPRB,.232E-01_JPRB,&
&.228E-01_JPRB,.222E-01_JPRB,.214E-01_JPRB,.180E-01_JPRB,.156E-01_JPRB,.149E-01_JPRB,.152E-01_JPRB,&
&.155E-01_JPRB,.164E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 29 -22.0
ZAER (:,29,12) = (/&
&.154E-01_JPRB,.179E-01_JPRB,.218E-01_JPRB,.249E-01_JPRB,.224E-01_JPRB,.207E-01_JPRB,.182E-01_JPRB,&
&.160E-01_JPRB,.160E-01_JPRB,.189E-01_JPRB,.239E-01_JPRB,.400E-01_JPRB,.584E-01_JPRB,.689E-01_JPRB,&
&.835E-01_JPRB,.532E-01_JPRB,.426E-01_JPRB,.596E-01_JPRB,.454E-01_JPRB,.435E-01_JPRB,.359E-01_JPRB,&
&.327E-01_JPRB,.305E-01_JPRB,.270E-01_JPRB,.230E-01_JPRB,.224E-01_JPRB,.214E-01_JPRB,.232E-01_JPRB,&
&.250E-01_JPRB,.239E-01_JPRB,.228E-01_JPRB,.237E-01_JPRB,.263E-01_JPRB,.140E-01_JPRB,.136E-01_JPRB,&
&.169E-01_JPRB,.205E-01_JPRB,.213E-01_JPRB,.249E-01_JPRB,.269E-01_JPRB,.270E-01_JPRB,.297E-01_JPRB,&
&.225E-01_JPRB,.254E-01_JPRB,.167E-01_JPRB,.195E-01_JPRB,.166E-01_JPRB,.157E-01_JPRB,.297E-01_JPRB,&
&.403E-01_JPRB,.269E-01_JPRB,.251E-01_JPRB,.246E-01_JPRB,.147E-01_JPRB,.196E-01_JPRB,.310E-01_JPRB,&
&.411E-01_JPRB,.356E-01_JPRB,.320E-01_JPRB,.412E-01_JPRB,.271E-01_JPRB,.246E-01_JPRB,.217E-01_JPRB,&
&.220E-01_JPRB,.226E-01_JPRB,.210E-01_JPRB,.184E-01_JPRB,.158E-01_JPRB,.140E-01_JPRB,.138E-01_JPRB,&
&.141E-01_JPRB,.145E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 30 -26.0
ZAER (:,30,12) = (/&
&.142E-01_JPRB,.154E-01_JPRB,.179E-01_JPRB,.169E-01_JPRB,.133E-01_JPRB,.136E-01_JPRB,.139E-01_JPRB,&
&.125E-01_JPRB,.114E-01_JPRB,.103E-01_JPRB,.107E-01_JPRB,.189E-01_JPRB,.430E-01_JPRB,.577E-01_JPRB,&
&.408E-01_JPRB,.362E-01_JPRB,.402E-01_JPRB,.656E-01_JPRB,.382E-01_JPRB,.277E-01_JPRB,.252E-01_JPRB,&
&.236E-01_JPRB,.239E-01_JPRB,.235E-01_JPRB,.237E-01_JPRB,.226E-01_JPRB,.205E-01_JPRB,.194E-01_JPRB,&
&.194E-01_JPRB,.189E-01_JPRB,.160E-01_JPRB,.151E-01_JPRB,.183E-01_JPRB,.207E-01_JPRB,.110E-01_JPRB,&
&.117E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.189E-01_JPRB,.285E-01_JPRB,.380E-01_JPRB,.446E-01_JPRB,&
&.378E-01_JPRB,.317E-01_JPRB,.339E-01_JPRB,.326E-01_JPRB,.280E-01_JPRB,.375E-01_JPRB,.193E-01_JPRB,&
&.218E-01_JPRB,.339E-01_JPRB,.389E-01_JPRB,.299E-01_JPRB,.123E-01_JPRB,.146E-01_JPRB,.271E-01_JPRB,&
&.344E-01_JPRB,.388E-01_JPRB,.413E-01_JPRB,.462E-01_JPRB,.518E-01_JPRB,.382E-01_JPRB,.293E-01_JPRB,&
&.270E-01_JPRB,.284E-01_JPRB,.243E-01_JPRB,.205E-01_JPRB,.178E-01_JPRB,.162E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.146E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 31 -30.0
ZAER (:,31,12) = (/&
&.154E-01_JPRB,.148E-01_JPRB,.154E-01_JPRB,.146E-01_JPRB,.128E-01_JPRB,.106E-01_JPRB,.917E-02_JPRB,&
&.834E-02_JPRB,.832E-02_JPRB,.806E-02_JPRB,.783E-02_JPRB,.100E-01_JPRB,.267E-01_JPRB,.391E-01_JPRB,&
&.195E-01_JPRB,.201E-01_JPRB,.286E-01_JPRB,.406E-01_JPRB,.321E-01_JPRB,.204E-01_JPRB,.253E-01_JPRB,&
&.247E-01_JPRB,.198E-01_JPRB,.201E-01_JPRB,.198E-01_JPRB,.191E-01_JPRB,.177E-01_JPRB,.169E-01_JPRB,&
&.160E-01_JPRB,.157E-01_JPRB,.138E-01_JPRB,.110E-01_JPRB,.102E-01_JPRB,.142E-01_JPRB,.961E-02_JPRB,&
&.971E-02_JPRB,.121E-01_JPRB,.160E-01_JPRB,.181E-01_JPRB,.285E-01_JPRB,.344E-01_JPRB,.406E-01_JPRB,&
&.516E-01_JPRB,.405E-01_JPRB,.396E-01_JPRB,.370E-01_JPRB,.338E-01_JPRB,.244E-01_JPRB,.220E-01_JPRB,&
&.226E-01_JPRB,.295E-01_JPRB,.281E-01_JPRB,.144E-01_JPRB,.483E-02_JPRB,.305E-02_JPRB,.527E-02_JPRB,&
&.105E-01_JPRB,.263E-01_JPRB,.405E-01_JPRB,.540E-01_JPRB,.420E-01_JPRB,.570E-01_JPRB,.497E-01_JPRB,&
&.529E-01_JPRB,.416E-01_JPRB,.320E-01_JPRB,.255E-01_JPRB,.216E-01_JPRB,.191E-01_JPRB,.173E-01_JPRB,&
&.166E-01_JPRB,.161E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 32 -34.0
ZAER (:,32,12) = (/&
&.154E-01_JPRB,.147E-01_JPRB,.139E-01_JPRB,.133E-01_JPRB,.114E-01_JPRB,.961E-02_JPRB,.804E-02_JPRB,&
&.734E-02_JPRB,.692E-02_JPRB,.725E-02_JPRB,.769E-02_JPRB,.927E-02_JPRB,.188E-01_JPRB,.165E-01_JPRB,&
&.142E-01_JPRB,.156E-01_JPRB,.194E-01_JPRB,.283E-01_JPRB,.482E-01_JPRB,.358E-01_JPRB,.276E-01_JPRB,&
&.369E-01_JPRB,.293E-01_JPRB,.241E-01_JPRB,.186E-01_JPRB,.154E-01_JPRB,.142E-01_JPRB,.138E-01_JPRB,&
&.135E-01_JPRB,.128E-01_JPRB,.108E-01_JPRB,.882E-02_JPRB,.860E-02_JPRB,.968E-02_JPRB,.143E-01_JPRB,&
&.800E-02_JPRB,.937E-02_JPRB,.128E-01_JPRB,.155E-01_JPRB,.378E-01_JPRB,.480E-01_JPRB,.613E-01_JPRB,&
&.860E-01_JPRB,.826E-01_JPRB,.359E-01_JPRB,.345E-01_JPRB,.277E-01_JPRB,.317E-01_JPRB,.270E-01_JPRB,&
&.188E-01_JPRB,.170E-01_JPRB,.167E-01_JPRB,.614E-02_JPRB,.303E-02_JPRB,.340E-02_JPRB,.320E-02_JPRB,&
&.574E-02_JPRB,.208E-01_JPRB,.298E-01_JPRB,.355E-01_JPRB,.325E-01_JPRB,.572E-01_JPRB,.646E-01_JPRB,&
&.369E-01_JPRB,.447E-01_JPRB,.318E-01_JPRB,.253E-01_JPRB,.226E-01_JPRB,.207E-01_JPRB,.189E-01_JPRB,&
&.180E-01_JPRB,.167E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 33 -38.0
ZAER (:,33,12) = (/&
&.156E-01_JPRB,.148E-01_JPRB,.143E-01_JPRB,.131E-01_JPRB,.113E-01_JPRB,.984E-02_JPRB,.902E-02_JPRB,&
&.804E-02_JPRB,.818E-02_JPRB,.836E-02_JPRB,.863E-02_JPRB,.105E-01_JPRB,.739E-02_JPRB,.940E-02_JPRB,&
&.937E-02_JPRB,.962E-02_JPRB,.133E-01_JPRB,.222E-01_JPRB,.386E-01_JPRB,.456E-01_JPRB,.439E-01_JPRB,&
&.684E-01_JPRB,.417E-01_JPRB,.264E-01_JPRB,.182E-01_JPRB,.146E-01_JPRB,.131E-01_JPRB,.122E-01_JPRB,&
&.114E-01_JPRB,.104E-01_JPRB,.878E-02_JPRB,.911E-02_JPRB,.852E-02_JPRB,.923E-02_JPRB,.137E-01_JPRB,&
&.895E-02_JPRB,.173E-01_JPRB,.199E-01_JPRB,.246E-01_JPRB,.288E-01_JPRB,.462E-01_JPRB,.525E-01_JPRB,&
&.281E-01_JPRB,.312E-01_JPRB,.381E-01_JPRB,.355E-01_JPRB,.312E-01_JPRB,.335E-01_JPRB,.316E-01_JPRB,&
&.340E-01_JPRB,.127E-01_JPRB,.115E-01_JPRB,.122E-01_JPRB,.785E-02_JPRB,.598E-02_JPRB,.604E-02_JPRB,&
&.907E-02_JPRB,.131E-01_JPRB,.192E-01_JPRB,.227E-01_JPRB,.427E-01_JPRB,.372E-01_JPRB,.348E-01_JPRB,&
&.367E-01_JPRB,.179E-01_JPRB,.245E-01_JPRB,.220E-01_JPRB,.217E-01_JPRB,.199E-01_JPRB,.185E-01_JPRB,&
&.177E-01_JPRB,.166E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 34 -42.0
ZAER (:,34,12) = (/&
&.149E-01_JPRB,.140E-01_JPRB,.143E-01_JPRB,.140E-01_JPRB,.132E-01_JPRB,.128E-01_JPRB,.120E-01_JPRB,&
&.109E-01_JPRB,.104E-01_JPRB,.962E-02_JPRB,.942E-02_JPRB,.976E-02_JPRB,.564E-02_JPRB,.632E-02_JPRB,&
&.681E-02_JPRB,.864E-02_JPRB,.118E-01_JPRB,.213E-01_JPRB,.459E-01_JPRB,.598E-01_JPRB,.500E-01_JPRB,&
&.476E-01_JPRB,.547E-01_JPRB,.385E-01_JPRB,.245E-01_JPRB,.158E-01_JPRB,.139E-01_JPRB,.119E-01_JPRB,&
&.109E-01_JPRB,.937E-02_JPRB,.832E-02_JPRB,.865E-02_JPRB,.909E-02_JPRB,.116E-01_JPRB,.183E-01_JPRB,&
&.139E-01_JPRB,.153E-01_JPRB,.234E-01_JPRB,.254E-01_JPRB,.254E-01_JPRB,.263E-01_JPRB,.340E-01_JPRB,&
&.568E-01_JPRB,.510E-01_JPRB,.297E-01_JPRB,.353E-01_JPRB,.549E-01_JPRB,.314E-01_JPRB,.322E-01_JPRB,&
&.482E-01_JPRB,.326E-01_JPRB,.177E-01_JPRB,.127E-01_JPRB,.166E-01_JPRB,.162E-01_JPRB,.143E-01_JPRB,&
&.167E-01_JPRB,.174E-01_JPRB,.201E-01_JPRB,.190E-01_JPRB,.229E-01_JPRB,.216E-01_JPRB,.233E-01_JPRB,&
&.365E-01_JPRB,.228E-01_JPRB,.243E-01_JPRB,.225E-01_JPRB,.192E-01_JPRB,.177E-01_JPRB,.162E-01_JPRB,&
&.151E-01_JPRB,.157E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 35 -46.0
ZAER (:,35,12) = (/&
&.149E-01_JPRB,.144E-01_JPRB,.141E-01_JPRB,.139E-01_JPRB,.151E-01_JPRB,.161E-01_JPRB,.157E-01_JPRB,&
&.143E-01_JPRB,.124E-01_JPRB,.109E-01_JPRB,.997E-02_JPRB,.937E-02_JPRB,.532E-02_JPRB,.504E-02_JPRB,&
&.533E-02_JPRB,.797E-02_JPRB,.118E-01_JPRB,.198E-01_JPRB,.303E-01_JPRB,.374E-01_JPRB,.547E-01_JPRB,&
&.484E-01_JPRB,.390E-01_JPRB,.298E-01_JPRB,.332E-01_JPRB,.245E-01_JPRB,.191E-01_JPRB,.140E-01_JPRB,&
&.102E-01_JPRB,.964E-02_JPRB,.928E-02_JPRB,.891E-02_JPRB,.101E-01_JPRB,.110E-01_JPRB,.185E-01_JPRB,&
&.226E-01_JPRB,.123E-01_JPRB,.176E-01_JPRB,.202E-01_JPRB,.200E-01_JPRB,.231E-01_JPRB,.278E-01_JPRB,&
&.317E-01_JPRB,.271E-01_JPRB,.251E-01_JPRB,.322E-01_JPRB,.462E-01_JPRB,.303E-01_JPRB,.324E-01_JPRB,&
&.373E-01_JPRB,.450E-01_JPRB,.412E-01_JPRB,.275E-01_JPRB,.299E-01_JPRB,.263E-01_JPRB,.232E-01_JPRB,&
&.217E-01_JPRB,.208E-01_JPRB,.241E-01_JPRB,.239E-01_JPRB,.214E-01_JPRB,.205E-01_JPRB,.186E-01_JPRB,&
&.166E-01_JPRB,.253E-01_JPRB,.189E-01_JPRB,.154E-01_JPRB,.145E-01_JPRB,.147E-01_JPRB,.140E-01_JPRB,&
&.126E-01_JPRB,.138E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 36 -50.0
ZAER (:,36,12) = (/&
&.152E-01_JPRB,.157E-01_JPRB,.147E-01_JPRB,.156E-01_JPRB,.174E-01_JPRB,.168E-01_JPRB,.153E-01_JPRB,&
&.133E-01_JPRB,.112E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.587E-02_JPRB,.597E-02_JPRB,.566E-02_JPRB,&
&.777E-02_JPRB,.114E-01_JPRB,.158E-01_JPRB,.257E-01_JPRB,.255E-01_JPRB,.358E-01_JPRB,.441E-01_JPRB,&
&.371E-01_JPRB,.300E-01_JPRB,.251E-01_JPRB,.334E-01_JPRB,.286E-01_JPRB,.196E-01_JPRB,.125E-01_JPRB,&
&.119E-01_JPRB,.121E-01_JPRB,.119E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.142E-01_JPRB,.215E-01_JPRB,&
&.239E-01_JPRB,.135E-01_JPRB,.145E-01_JPRB,.198E-01_JPRB,.198E-01_JPRB,.265E-01_JPRB,.335E-01_JPRB,&
&.276E-01_JPRB,.312E-01_JPRB,.298E-01_JPRB,.355E-01_JPRB,.316E-01_JPRB,.299E-01_JPRB,.357E-01_JPRB,&
&.366E-01_JPRB,.443E-01_JPRB,.478E-01_JPRB,.504E-01_JPRB,.438E-01_JPRB,.328E-01_JPRB,.289E-01_JPRB,&
&.273E-01_JPRB,.281E-01_JPRB,.275E-01_JPRB,.258E-01_JPRB,.209E-01_JPRB,.197E-01_JPRB,.193E-01_JPRB,&
&.171E-01_JPRB,.139E-01_JPRB,.161E-01_JPRB,.159E-01_JPRB,.152E-01_JPRB,.122E-01_JPRB,.120E-01_JPRB,&
&.127E-01_JPRB,.137E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 37 -54.0
ZAER (:,37,12) = (/&
&.159E-01_JPRB,.152E-01_JPRB,.147E-01_JPRB,.175E-01_JPRB,.188E-01_JPRB,.183E-01_JPRB,.153E-01_JPRB,&
&.128E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,.682E-02_JPRB,.681E-02_JPRB,.736E-02_JPRB,.785E-02_JPRB,&
&.998E-02_JPRB,.128E-01_JPRB,.148E-01_JPRB,.187E-01_JPRB,.209E-01_JPRB,.261E-01_JPRB,.421E-01_JPRB,&
&.247E-01_JPRB,.212E-01_JPRB,.194E-01_JPRB,.179E-01_JPRB,.266E-01_JPRB,.165E-01_JPRB,.117E-01_JPRB,&
&.111E-01_JPRB,.120E-01_JPRB,.129E-01_JPRB,.138E-01_JPRB,.137E-01_JPRB,.149E-01_JPRB,.203E-01_JPRB,&
&.132E-01_JPRB,.202E-01_JPRB,.213E-01_JPRB,.171E-01_JPRB,.198E-01_JPRB,.220E-01_JPRB,.285E-01_JPRB,&
&.275E-01_JPRB,.233E-01_JPRB,.209E-01_JPRB,.263E-01_JPRB,.247E-01_JPRB,.276E-01_JPRB,.341E-01_JPRB,&
&.381E-01_JPRB,.442E-01_JPRB,.423E-01_JPRB,.484E-01_JPRB,.424E-01_JPRB,.328E-01_JPRB,.310E-01_JPRB,&
&.310E-01_JPRB,.314E-01_JPRB,.254E-01_JPRB,.226E-01_JPRB,.221E-01_JPRB,.205E-01_JPRB,.185E-01_JPRB,&
&.156E-01_JPRB,.213E-01_JPRB,.178E-01_JPRB,.187E-01_JPRB,.164E-01_JPRB,.935E-02_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.157E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 38 -58.0
ZAER (:,38,12) = (/&
&.184E-01_JPRB,.171E-01_JPRB,.166E-01_JPRB,.184E-01_JPRB,.189E-01_JPRB,.182E-01_JPRB,.145E-01_JPRB,&
&.105E-01_JPRB,.119E-01_JPRB,.729E-02_JPRB,.620E-02_JPRB,.663E-02_JPRB,.986E-02_JPRB,.106E-01_JPRB,&
&.128E-01_JPRB,.144E-01_JPRB,.127E-01_JPRB,.145E-01_JPRB,.251E-01_JPRB,.238E-01_JPRB,.247E-01_JPRB,&
&.161E-01_JPRB,.172E-01_JPRB,.173E-01_JPRB,.302E-01_JPRB,.239E-01_JPRB,.161E-01_JPRB,.130E-01_JPRB,&
&.115E-01_JPRB,.119E-01_JPRB,.133E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.143E-01_JPRB,.205E-01_JPRB,&
&.169E-01_JPRB,.184E-01_JPRB,.145E-01_JPRB,.883E-02_JPRB,.991E-02_JPRB,.150E-01_JPRB,.145E-01_JPRB,&
&.176E-01_JPRB,.199E-01_JPRB,.200E-01_JPRB,.268E-01_JPRB,.260E-01_JPRB,.232E-01_JPRB,.257E-01_JPRB,&
&.339E-01_JPRB,.419E-01_JPRB,.404E-01_JPRB,.400E-01_JPRB,.319E-01_JPRB,.312E-01_JPRB,.350E-01_JPRB,&
&.331E-01_JPRB,.292E-01_JPRB,.286E-01_JPRB,.252E-01_JPRB,.280E-01_JPRB,.264E-01_JPRB,.221E-01_JPRB,&
&.181E-01_JPRB,.124E-01_JPRB,.206E-01_JPRB,.197E-01_JPRB,.184E-01_JPRB,.988E-02_JPRB,.177E-01_JPRB,&
&.181E-01_JPRB,.184E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 39 -62.0
ZAER (:,39,12) = (/&
&.223E-01_JPRB,.203E-01_JPRB,.193E-01_JPRB,.193E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.775E-02_JPRB,&
&.665E-02_JPRB,.671E-02_JPRB,.800E-02_JPRB,.837E-02_JPRB,.908E-02_JPRB,.114E-01_JPRB,.131E-01_JPRB,&
&.136E-01_JPRB,.117E-01_JPRB,.113E-01_JPRB,.124E-01_JPRB,.208E-01_JPRB,.225E-01_JPRB,.255E-01_JPRB,&
&.150E-01_JPRB,.264E-01_JPRB,.251E-01_JPRB,.210E-01_JPRB,.177E-01_JPRB,.142E-01_JPRB,.581E-02_JPRB,&
&.106E-01_JPRB,.121E-01_JPRB,.135E-01_JPRB,.145E-01_JPRB,.139E-01_JPRB,.130E-01_JPRB,.120E-01_JPRB,&
&.111E-01_JPRB,.114E-01_JPRB,.113E-01_JPRB,.569E-02_JPRB,.616E-02_JPRB,.104E-01_JPRB,.950E-02_JPRB,&
&.137E-01_JPRB,.171E-01_JPRB,.165E-01_JPRB,.217E-01_JPRB,.248E-01_JPRB,.238E-01_JPRB,.234E-01_JPRB,&
&.258E-01_JPRB,.327E-01_JPRB,.373E-01_JPRB,.413E-01_JPRB,.343E-01_JPRB,.304E-01_JPRB,.339E-01_JPRB,&
&.337E-01_JPRB,.304E-01_JPRB,.292E-01_JPRB,.287E-01_JPRB,.299E-01_JPRB,.257E-01_JPRB,.203E-01_JPRB,&
&.175E-01_JPRB,.120E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.124E-01_JPRB,.127E-01_JPRB,.131E-01_JPRB,&
&.125E-01_JPRB,.234E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 40 -66.0
ZAER (:,40,12) = (/&
&.144E-01_JPRB,.142E-01_JPRB,.205E-01_JPRB,.184E-01_JPRB,.109E-01_JPRB,.967E-02_JPRB,.911E-02_JPRB,&
&.881E-02_JPRB,.837E-02_JPRB,.885E-02_JPRB,.961E-02_JPRB,.106E-01_JPRB,.101E-01_JPRB,.105E-01_JPRB,&
&.102E-01_JPRB,.114E-01_JPRB,.131E-01_JPRB,.128E-01_JPRB,.132E-01_JPRB,.150E-01_JPRB,.261E-01_JPRB,&
&.151E-01_JPRB,.152E-01_JPRB,.136E-01_JPRB,.202E-01_JPRB,.160E-01_JPRB,.637E-02_JPRB,.419E-02_JPRB,&
&.472E-02_JPRB,.108E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.141E-01_JPRB,.121E-01_JPRB,.102E-01_JPRB,&
&.936E-02_JPRB,.875E-02_JPRB,.902E-02_JPRB,.868E-02_JPRB,.542E-02_JPRB,.670E-02_JPRB,.783E-02_JPRB,&
&.810E-02_JPRB,.974E-02_JPRB,.116E-01_JPRB,.150E-01_JPRB,.195E-01_JPRB,.210E-01_JPRB,.211E-01_JPRB,&
&.226E-01_JPRB,.256E-01_JPRB,.354E-01_JPRB,.442E-01_JPRB,.401E-01_JPRB,.329E-01_JPRB,.348E-01_JPRB,&
&.372E-01_JPRB,.352E-01_JPRB,.302E-01_JPRB,.237E-01_JPRB,.192E-01_JPRB,.212E-01_JPRB,.192E-01_JPRB,&
&.194E-01_JPRB,.162E-01_JPRB,.150E-01_JPRB,.147E-01_JPRB,.157E-01_JPRB,.157E-01_JPRB,.155E-01_JPRB,&
&.157E-01_JPRB,.150E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 41 -70.0
ZAER (:,41,12) = (/&
&.253E-01_JPRB,.214E-01_JPRB,.194E-01_JPRB,.164E-01_JPRB,.938E-02_JPRB,.999E-02_JPRB,.101E-01_JPRB,&
&.102E-01_JPRB,.167E-01_JPRB,.159E-01_JPRB,.940E-02_JPRB,.175E-01_JPRB,.195E-01_JPRB,.117E-01_JPRB,&
&.112E-01_JPRB,.113E-01_JPRB,.199E-01_JPRB,.125E-01_JPRB,.126E-01_JPRB,.124E-01_JPRB,.131E-01_JPRB,&
&.150E-01_JPRB,.145E-01_JPRB,.231E-01_JPRB,.195E-01_JPRB,.148E-01_JPRB,.725E-02_JPRB,.510E-02_JPRB,&
&.411E-02_JPRB,.391E-02_JPRB,.458E-02_JPRB,.691E-02_JPRB,.140E-01_JPRB,.126E-01_JPRB,.107E-01_JPRB,&
&.966E-02_JPRB,.857E-02_JPRB,.844E-02_JPRB,.870E-02_JPRB,.952E-02_JPRB,.101E-01_JPRB,.637E-02_JPRB,&
&.640E-02_JPRB,.111E-01_JPRB,.130E-01_JPRB,.161E-01_JPRB,.213E-01_JPRB,.311E-01_JPRB,.294E-01_JPRB,&
&.317E-01_JPRB,.208E-01_JPRB,.238E-01_JPRB,.271E-01_JPRB,.263E-01_JPRB,.262E-01_JPRB,.264E-01_JPRB,&
&.270E-01_JPRB,.354E-01_JPRB,.311E-01_JPRB,.259E-01_JPRB,.240E-01_JPRB,.216E-01_JPRB,.220E-01_JPRB,&
&.233E-01_JPRB,.226E-01_JPRB,.226E-01_JPRB,.236E-01_JPRB,.190E-01_JPRB,.200E-01_JPRB,.209E-01_JPRB,&
&.335E-01_JPRB,.178E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 42 -74.0
ZAER (:,42,12) = (/&
&.225E-01_JPRB,.200E-01_JPRB,.191E-01_JPRB,.178E-01_JPRB,.173E-01_JPRB,.178E-01_JPRB,.190E-01_JPRB,&
&.186E-01_JPRB,.179E-01_JPRB,.172E-01_JPRB,.173E-01_JPRB,.177E-01_JPRB,.108E-01_JPRB,.110E-01_JPRB,&
&.195E-01_JPRB,.205E-01_JPRB,.220E-01_JPRB,.218E-01_JPRB,.215E-01_JPRB,.125E-01_JPRB,.214E-01_JPRB,&
&.221E-01_JPRB,.218E-01_JPRB,.197E-01_JPRB,.161E-01_JPRB,.840E-02_JPRB,.612E-02_JPRB,.479E-02_JPRB,&
&.410E-02_JPRB,.393E-02_JPRB,.402E-02_JPRB,.527E-02_JPRB,.128E-01_JPRB,.141E-01_JPRB,.126E-01_JPRB,&
&.124E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.123E-01_JPRB,.126E-01_JPRB,.128E-01_JPRB,.122E-01_JPRB,&
&.107E-01_JPRB,.111E-01_JPRB,.132E-01_JPRB,.184E-01_JPRB,.213E-01_JPRB,.260E-01_JPRB,.263E-01_JPRB,&
&.260E-01_JPRB,.281E-01_JPRB,.341E-01_JPRB,.334E-01_JPRB,.231E-01_JPRB,.257E-01_JPRB,.260E-01_JPRB,&
&.275E-01_JPRB,.294E-01_JPRB,.264E-01_JPRB,.261E-01_JPRB,.441E-01_JPRB,.427E-01_JPRB,.417E-01_JPRB,&
&.438E-01_JPRB,.450E-01_JPRB,.400E-01_JPRB,.392E-01_JPRB,.332E-01_JPRB,.331E-01_JPRB,.344E-01_JPRB,&
&.333E-01_JPRB,.264E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 43 -78.0
ZAER (:,43,12) = (/&
&.258E-01_JPRB,.257E-01_JPRB,.247E-01_JPRB,.237E-01_JPRB,.226E-01_JPRB,.219E-01_JPRB,.208E-01_JPRB,&
&.194E-01_JPRB,.189E-01_JPRB,.183E-01_JPRB,.179E-01_JPRB,.183E-01_JPRB,.186E-01_JPRB,.192E-01_JPRB,&
&.198E-01_JPRB,.210E-01_JPRB,.208E-01_JPRB,.208E-01_JPRB,.126E-01_JPRB,.125E-01_JPRB,.124E-01_JPRB,&
&.203E-01_JPRB,.195E-01_JPRB,.113E-01_JPRB,.846E-02_JPRB,.730E-02_JPRB,.641E-02_JPRB,.526E-02_JPRB,&
&.500E-02_JPRB,.499E-02_JPRB,.584E-02_JPRB,.649E-02_JPRB,.113E-01_JPRB,.143E-01_JPRB,.151E-01_JPRB,&
&.167E-01_JPRB,.185E-01_JPRB,.197E-01_JPRB,.198E-01_JPRB,.120E-01_JPRB,.215E-01_JPRB,.217E-01_JPRB,&
&.203E-01_JPRB,.201E-01_JPRB,.209E-01_JPRB,.219E-01_JPRB,.245E-01_JPRB,.278E-01_JPRB,.289E-01_JPRB,&
&.296E-01_JPRB,.322E-01_JPRB,.351E-01_JPRB,.362E-01_JPRB,.384E-01_JPRB,.331E-01_JPRB,.305E-01_JPRB,&
&.323E-01_JPRB,.195E-01_JPRB,.326E-01_JPRB,.347E-01_JPRB,.346E-01_JPRB,.345E-01_JPRB,.375E-01_JPRB,&
&.396E-01_JPRB,.370E-01_JPRB,.364E-01_JPRB,.344E-01_JPRB,.316E-01_JPRB,.302E-01_JPRB,.290E-01_JPRB,&
&.271E-01_JPRB,.258E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 44 -82.0
ZAER (:,44,12) = (/&
&.260E-01_JPRB,.263E-01_JPRB,.263E-01_JPRB,.260E-01_JPRB,.253E-01_JPRB,.244E-01_JPRB,.236E-01_JPRB,&
&.223E-01_JPRB,.216E-01_JPRB,.207E-01_JPRB,.203E-01_JPRB,.198E-01_JPRB,.193E-01_JPRB,.192E-01_JPRB,&
&.193E-01_JPRB,.197E-01_JPRB,.202E-01_JPRB,.207E-01_JPRB,.202E-01_JPRB,.198E-01_JPRB,.116E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.118E-01_JPRB,.110E-01_JPRB,.103E-01_JPRB,.971E-02_JPRB,.915E-02_JPRB,&
&.881E-02_JPRB,.865E-02_JPRB,.914E-02_JPRB,.921E-02_JPRB,.909E-02_JPRB,.157E-01_JPRB,.163E-01_JPRB,&
&.174E-01_JPRB,.201E-01_JPRB,.218E-01_JPRB,.234E-01_JPRB,.242E-01_JPRB,.251E-01_JPRB,.254E-01_JPRB,&
&.246E-01_JPRB,.239E-01_JPRB,.238E-01_JPRB,.239E-01_JPRB,.248E-01_JPRB,.259E-01_JPRB,.269E-01_JPRB,&
&.276E-01_JPRB,.282E-01_JPRB,.282E-01_JPRB,.281E-01_JPRB,.275E-01_JPRB,.270E-01_JPRB,.263E-01_JPRB,&
&.263E-01_JPRB,.269E-01_JPRB,.286E-01_JPRB,.308E-01_JPRB,.338E-01_JPRB,.331E-01_JPRB,.322E-01_JPRB,&
&.311E-01_JPRB,.299E-01_JPRB,.283E-01_JPRB,.273E-01_JPRB,.258E-01_JPRB,.248E-01_JPRB,.247E-01_JPRB,&
&.249E-01_JPRB,.258E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 45 -86.0
ZAER (:,45,12) = (/&
&.231E-01_JPRB,.221E-01_JPRB,.211E-01_JPRB,.203E-01_JPRB,.197E-01_JPRB,.191E-01_JPRB,.186E-01_JPRB,&
&.182E-01_JPRB,.182E-01_JPRB,.181E-01_JPRB,.182E-01_JPRB,.184E-01_JPRB,.183E-01_JPRB,.184E-01_JPRB,&
&.183E-01_JPRB,.185E-01_JPRB,.186E-01_JPRB,.187E-01_JPRB,.186E-01_JPRB,.187E-01_JPRB,.188E-01_JPRB,&
&.188E-01_JPRB,.190E-01_JPRB,.190E-01_JPRB,.194E-01_JPRB,.187E-01_JPRB,.184E-01_JPRB,.182E-01_JPRB,&
&.180E-01_JPRB,.178E-01_JPRB,.177E-01_JPRB,.174E-01_JPRB,.175E-01_JPRB,.176E-01_JPRB,.180E-01_JPRB,&
&.184E-01_JPRB,.190E-01_JPRB,.193E-01_JPRB,.198E-01_JPRB,.200E-01_JPRB,.203E-01_JPRB,.206E-01_JPRB,&
&.208E-01_JPRB,.212E-01_JPRB,.214E-01_JPRB,.219E-01_JPRB,.220E-01_JPRB,.226E-01_JPRB,.226E-01_JPRB,&
&.230E-01_JPRB,.234E-01_JPRB,.236E-01_JPRB,.240E-01_JPRB,.242E-01_JPRB,.245E-01_JPRB,.247E-01_JPRB,&
&.248E-01_JPRB,.251E-01_JPRB,.253E-01_JPRB,.253E-01_JPRB,.250E-01_JPRB,.251E-01_JPRB,.250E-01_JPRB,&
&.250E-01_JPRB,.250E-01_JPRB,.247E-01_JPRB,.247E-01_JPRB,.245E-01_JPRB,.244E-01_JPRB,.242E-01_JPRB,&
&.240E-01_JPRB,.238E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 12 --- lat: 46 -90.0
ZAER (:,46,12) = (/&
&.218E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,.224E-01_JPRB,&
&.224E-01_JPRB,.224E-01_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=12   
  DO JI=1,46
    DO JL=1,72
      RAERSU(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SULFATE AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESU_12
