SUBROUTINE SUECAESU_11

!**   OPTICAL THICKNESS OF SULFATE-TYPE AEROSOLS
!                          November

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESU* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSU


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,11:11)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Total Sulfate Aerosol    month: 11 --- lat:  1  90.0
ZAER (:, 1,11) = (/&
&.419E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat:  2  86.0
ZAER (:, 2,11) = (/&
&.823E-03_JPRB,.102E-02_JPRB,.119E-02_JPRB,.133E-02_JPRB,.146E-02_JPRB,.162E-02_JPRB,.172E-02_JPRB,&
&.184E-02_JPRB,.194E-02_JPRB,.206E-02_JPRB,.212E-02_JPRB,.219E-02_JPRB,.166E-02_JPRB,.147E-02_JPRB,&
&.130E-02_JPRB,.114E-02_JPRB,.102E-02_JPRB,.946E-03_JPRB,.838E-03_JPRB,.812E-03_JPRB,.781E-03_JPRB,&
&.724E-03_JPRB,.723E-03_JPRB,.740E-03_JPRB,.629E-03_JPRB,.576E-03_JPRB,.547E-03_JPRB,.517E-03_JPRB,&
&.492E-03_JPRB,.489E-03_JPRB,.487E-03_JPRB,.494E-03_JPRB,.509E-03_JPRB,.534E-03_JPRB,.557E-03_JPRB,&
&.589E-03_JPRB,.550E-03_JPRB,.551E-03_JPRB,.548E-03_JPRB,.536E-03_JPRB,.524E-03_JPRB,.526E-03_JPRB,&
&.514E-03_JPRB,.525E-03_JPRB,.524E-03_JPRB,.531E-03_JPRB,.532E-03_JPRB,.533E-03_JPRB,.506E-03_JPRB,&
&.462E-03_JPRB,.426E-03_JPRB,.391E-03_JPRB,.362E-03_JPRB,.348E-03_JPRB,.332E-03_JPRB,.321E-03_JPRB,&
&.316E-03_JPRB,.316E-03_JPRB,.324E-03_JPRB,.333E-03_JPRB,.346E-03_JPRB,.332E-03_JPRB,.330E-03_JPRB,&
&.327E-03_JPRB,.343E-03_JPRB,.352E-03_JPRB,.385E-03_JPRB,.414E-03_JPRB,.452E-03_JPRB,.499E-03_JPRB,&
&.557E-03_JPRB,.623E-03_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat:  3  82.0
ZAER (:, 3,11) = (/&
&.285E-02_JPRB,.327E-02_JPRB,.358E-02_JPRB,.384E-02_JPRB,.401E-02_JPRB,.414E-02_JPRB,.370E-02_JPRB,&
&.315E-02_JPRB,.277E-02_JPRB,.255E-02_JPRB,.250E-02_JPRB,.260E-02_JPRB,.228E-02_JPRB,.227E-02_JPRB,&
&.230E-02_JPRB,.239E-02_JPRB,.255E-02_JPRB,.279E-02_JPRB,.260E-02_JPRB,.214E-02_JPRB,.183E-02_JPRB,&
&.158E-02_JPRB,.157E-02_JPRB,.163E-02_JPRB,.233E-02_JPRB,.203E-02_JPRB,.183E-02_JPRB,.185E-02_JPRB,&
&.197E-02_JPRB,.224E-02_JPRB,.221E-02_JPRB,.165E-02_JPRB,.122E-02_JPRB,.958E-03_JPRB,.854E-03_JPRB,&
&.894E-03_JPRB,.689E-03_JPRB,.639E-03_JPRB,.610E-03_JPRB,.614E-03_JPRB,.643E-03_JPRB,.712E-03_JPRB,&
&.679E-03_JPRB,.694E-03_JPRB,.702E-03_JPRB,.697E-03_JPRB,.684E-03_JPRB,.641E-03_JPRB,.545E-03_JPRB,&
&.490E-03_JPRB,.459E-03_JPRB,.433E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,.434E-03_JPRB,.385E-03_JPRB,&
&.356E-03_JPRB,.342E-03_JPRB,.347E-03_JPRB,.368E-03_JPRB,.446E-03_JPRB,.412E-03_JPRB,.416E-03_JPRB,&
&.442E-03_JPRB,.505E-03_JPRB,.575E-03_JPRB,.785E-03_JPRB,.873E-03_JPRB,.105E-02_JPRB,.132E-02_JPRB,&
&.168E-02_JPRB,.214E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat:  4  78.0
ZAER (:, 4,11) = (/&
&.630E-02_JPRB,.597E-02_JPRB,.605E-02_JPRB,.635E-02_JPRB,.634E-02_JPRB,.635E-02_JPRB,.548E-02_JPRB,&
&.505E-02_JPRB,.491E-02_JPRB,.330E-02_JPRB,.292E-02_JPRB,.326E-02_JPRB,.279E-02_JPRB,.249E-02_JPRB,&
&.266E-02_JPRB,.276E-02_JPRB,.294E-02_JPRB,.336E-02_JPRB,.313E-02_JPRB,.272E-02_JPRB,.268E-02_JPRB,&
&.360E-02_JPRB,.340E-02_JPRB,.350E-02_JPRB,.419E-02_JPRB,.382E-02_JPRB,.411E-02_JPRB,.449E-02_JPRB,&
&.470E-02_JPRB,.462E-02_JPRB,.373E-02_JPRB,.264E-02_JPRB,.224E-02_JPRB,.154E-02_JPRB,.128E-02_JPRB,&
&.120E-02_JPRB,.803E-03_JPRB,.750E-03_JPRB,.777E-03_JPRB,.674E-03_JPRB,.701E-03_JPRB,.731E-03_JPRB,&
&.675E-03_JPRB,.666E-03_JPRB,.700E-03_JPRB,.746E-03_JPRB,.742E-03_JPRB,.729E-03_JPRB,.579E-03_JPRB,&
&.601E-03_JPRB,.780E-03_JPRB,.721E-03_JPRB,.645E-03_JPRB,.636E-03_JPRB,.553E-03_JPRB,.460E-03_JPRB,&
&.448E-03_JPRB,.467E-03_JPRB,.465E-03_JPRB,.488E-03_JPRB,.460E-03_JPRB,.417E-03_JPRB,.497E-03_JPRB,&
&.551E-03_JPRB,.554E-03_JPRB,.646E-03_JPRB,.669E-03_JPRB,.584E-03_JPRB,.100E-02_JPRB,.243E-02_JPRB,&
&.379E-02_JPRB,.538E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat:  5  74.0
ZAER (:, 5,11) = (/&
&.669E-02_JPRB,.629E-02_JPRB,.602E-02_JPRB,.484E-02_JPRB,.442E-02_JPRB,.461E-02_JPRB,.472E-02_JPRB,&
&.562E-02_JPRB,.661E-02_JPRB,.567E-02_JPRB,.499E-02_JPRB,.478E-02_JPRB,.447E-02_JPRB,.438E-02_JPRB,&
&.472E-02_JPRB,.531E-02_JPRB,.514E-02_JPRB,.491E-02_JPRB,.437E-02_JPRB,.383E-02_JPRB,.414E-02_JPRB,&
&.391E-02_JPRB,.309E-02_JPRB,.275E-02_JPRB,.329E-02_JPRB,.410E-02_JPRB,.505E-02_JPRB,.620E-02_JPRB,&
&.604E-02_JPRB,.625E-02_JPRB,.640E-02_JPRB,.476E-02_JPRB,.350E-02_JPRB,.270E-02_JPRB,.211E-02_JPRB,&
&.160E-02_JPRB,.122E-02_JPRB,.998E-03_JPRB,.843E-03_JPRB,.804E-03_JPRB,.965E-03_JPRB,.114E-02_JPRB,&
&.123E-02_JPRB,.109E-02_JPRB,.768E-03_JPRB,.678E-03_JPRB,.858E-03_JPRB,.113E-02_JPRB,.154E-02_JPRB,&
&.173E-02_JPRB,.178E-02_JPRB,.136E-02_JPRB,.121E-02_JPRB,.959E-03_JPRB,.821E-03_JPRB,.754E-03_JPRB,&
&.756E-03_JPRB,.681E-03_JPRB,.685E-03_JPRB,.695E-03_JPRB,.819E-03_JPRB,.969E-03_JPRB,.106E-02_JPRB,&
&.101E-02_JPRB,.954E-03_JPRB,.969E-03_JPRB,.107E-02_JPRB,.135E-02_JPRB,.222E-02_JPRB,.399E-02_JPRB,&
&.626E-02_JPRB,.703E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat:  6  70.0
ZAER (:, 6,11) = (/&
&.574E-02_JPRB,.629E-02_JPRB,.716E-02_JPRB,.585E-02_JPRB,.480E-02_JPRB,.530E-02_JPRB,.564E-02_JPRB,&
&.543E-02_JPRB,.539E-02_JPRB,.611E-02_JPRB,.816E-02_JPRB,.870E-02_JPRB,.823E-02_JPRB,.711E-02_JPRB,&
&.650E-02_JPRB,.649E-02_JPRB,.621E-02_JPRB,.598E-02_JPRB,.534E-02_JPRB,.477E-02_JPRB,.430E-02_JPRB,&
&.447E-02_JPRB,.399E-02_JPRB,.357E-02_JPRB,.412E-02_JPRB,.523E-02_JPRB,.601E-02_JPRB,.663E-02_JPRB,&
&.698E-02_JPRB,.713E-02_JPRB,.749E-02_JPRB,.666E-02_JPRB,.593E-02_JPRB,.475E-02_JPRB,.358E-02_JPRB,&
&.249E-02_JPRB,.187E-02_JPRB,.162E-02_JPRB,.163E-02_JPRB,.224E-02_JPRB,.279E-02_JPRB,.331E-02_JPRB,&
&.392E-02_JPRB,.412E-02_JPRB,.332E-02_JPRB,.191E-02_JPRB,.159E-02_JPRB,.168E-02_JPRB,.213E-02_JPRB,&
&.323E-02_JPRB,.441E-02_JPRB,.403E-02_JPRB,.262E-02_JPRB,.198E-02_JPRB,.182E-02_JPRB,.178E-02_JPRB,&
&.201E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.214E-02_JPRB,.238E-02_JPRB,.290E-02_JPRB,.268E-02_JPRB,&
&.218E-02_JPRB,.231E-02_JPRB,.303E-02_JPRB,.372E-02_JPRB,.380E-02_JPRB,.472E-02_JPRB,.530E-02_JPRB,&
&.605E-02_JPRB,.564E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat:  7  66.0
ZAER (:, 7,11) = (/&
&.519E-02_JPRB,.569E-02_JPRB,.545E-02_JPRB,.498E-02_JPRB,.447E-02_JPRB,.488E-02_JPRB,.659E-02_JPRB,&
&.652E-02_JPRB,.585E-02_JPRB,.514E-02_JPRB,.518E-02_JPRB,.545E-02_JPRB,.598E-02_JPRB,.677E-02_JPRB,&
&.803E-02_JPRB,.851E-02_JPRB,.720E-02_JPRB,.686E-02_JPRB,.704E-02_JPRB,.645E-02_JPRB,.587E-02_JPRB,&
&.580E-02_JPRB,.565E-02_JPRB,.459E-02_JPRB,.552E-02_JPRB,.598E-02_JPRB,.543E-02_JPRB,.640E-02_JPRB,&
&.806E-02_JPRB,.831E-02_JPRB,.844E-02_JPRB,.653E-02_JPRB,.526E-02_JPRB,.503E-02_JPRB,.478E-02_JPRB,&
&.402E-02_JPRB,.358E-02_JPRB,.241E-02_JPRB,.262E-02_JPRB,.346E-02_JPRB,.360E-02_JPRB,.460E-02_JPRB,&
&.512E-02_JPRB,.585E-02_JPRB,.701E-02_JPRB,.673E-02_JPRB,.617E-02_JPRB,.510E-02_JPRB,.547E-02_JPRB,&
&.554E-02_JPRB,.552E-02_JPRB,.539E-02_JPRB,.573E-02_JPRB,.472E-02_JPRB,.470E-02_JPRB,.487E-02_JPRB,&
&.514E-02_JPRB,.549E-02_JPRB,.621E-02_JPRB,.634E-02_JPRB,.753E-02_JPRB,.813E-02_JPRB,.784E-02_JPRB,&
&.665E-02_JPRB,.674E-02_JPRB,.717E-02_JPRB,.787E-02_JPRB,.765E-02_JPRB,.673E-02_JPRB,.607E-02_JPRB,&
&.576E-02_JPRB,.546E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat:  8  62.0
ZAER (:, 8,11) = (/&
&.519E-02_JPRB,.489E-02_JPRB,.519E-02_JPRB,.459E-02_JPRB,.463E-02_JPRB,.539E-02_JPRB,.563E-02_JPRB,&
&.590E-02_JPRB,.584E-02_JPRB,.521E-02_JPRB,.498E-02_JPRB,.448E-02_JPRB,.446E-02_JPRB,.500E-02_JPRB,&
&.639E-02_JPRB,.860E-02_JPRB,.913E-02_JPRB,.812E-02_JPRB,.753E-02_JPRB,.755E-02_JPRB,.767E-02_JPRB,&
&.796E-02_JPRB,.600E-02_JPRB,.521E-02_JPRB,.516E-02_JPRB,.444E-02_JPRB,.456E-02_JPRB,.669E-02_JPRB,&
&.822E-02_JPRB,.909E-02_JPRB,.833E-02_JPRB,.748E-02_JPRB,.629E-02_JPRB,.567E-02_JPRB,.519E-02_JPRB,&
&.499E-02_JPRB,.450E-02_JPRB,.389E-02_JPRB,.441E-02_JPRB,.483E-02_JPRB,.463E-02_JPRB,.605E-02_JPRB,&
&.657E-02_JPRB,.680E-02_JPRB,.854E-02_JPRB,.774E-02_JPRB,.812E-02_JPRB,.881E-02_JPRB,.778E-02_JPRB,&
&.795E-02_JPRB,.901E-02_JPRB,.805E-02_JPRB,.876E-02_JPRB,.957E-02_JPRB,.877E-02_JPRB,.859E-02_JPRB,&
&.940E-02_JPRB,.874E-02_JPRB,.919E-02_JPRB,.925E-02_JPRB,.101E-01_JPRB,.980E-02_JPRB,.969E-02_JPRB,&
&.928E-02_JPRB,.102E-01_JPRB,.104E-01_JPRB,.916E-02_JPRB,.894E-02_JPRB,.850E-02_JPRB,.748E-02_JPRB,&
&.682E-02_JPRB,.586E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat:  9  58.0
ZAER (:, 9,11) = (/&
&.540E-02_JPRB,.502E-02_JPRB,.527E-02_JPRB,.513E-02_JPRB,.539E-02_JPRB,.589E-02_JPRB,.582E-02_JPRB,&
&.565E-02_JPRB,.590E-02_JPRB,.570E-02_JPRB,.497E-02_JPRB,.487E-02_JPRB,.608E-02_JPRB,.684E-02_JPRB,&
&.727E-02_JPRB,.828E-02_JPRB,.804E-02_JPRB,.798E-02_JPRB,.743E-02_JPRB,.698E-02_JPRB,.756E-02_JPRB,&
&.806E-02_JPRB,.752E-02_JPRB,.737E-02_JPRB,.641E-02_JPRB,.543E-02_JPRB,.565E-02_JPRB,.788E-02_JPRB,&
&.818E-02_JPRB,.669E-02_JPRB,.611E-02_JPRB,.641E-02_JPRB,.702E-02_JPRB,.669E-02_JPRB,.610E-02_JPRB,&
&.527E-02_JPRB,.475E-02_JPRB,.496E-02_JPRB,.621E-02_JPRB,.698E-02_JPRB,.683E-02_JPRB,.731E-02_JPRB,&
&.771E-02_JPRB,.884E-02_JPRB,.911E-02_JPRB,.792E-02_JPRB,.833E-02_JPRB,.803E-02_JPRB,.943E-02_JPRB,&
&.938E-02_JPRB,.108E-01_JPRB,.105E-01_JPRB,.956E-02_JPRB,.108E-01_JPRB,.105E-01_JPRB,.926E-02_JPRB,&
&.924E-02_JPRB,.969E-02_JPRB,.103E-01_JPRB,.105E-01_JPRB,.101E-01_JPRB,.965E-02_JPRB,.901E-02_JPRB,&
&.754E-02_JPRB,.814E-02_JPRB,.899E-02_JPRB,.736E-02_JPRB,.740E-02_JPRB,.649E-02_JPRB,.652E-02_JPRB,&
&.569E-02_JPRB,.566E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 10  54.0
ZAER (:,10,11) = (/&
&.504E-02_JPRB,.545E-02_JPRB,.581E-02_JPRB,.586E-02_JPRB,.555E-02_JPRB,.510E-02_JPRB,.487E-02_JPRB,&
&.490E-02_JPRB,.542E-02_JPRB,.548E-02_JPRB,.522E-02_JPRB,.591E-02_JPRB,.685E-02_JPRB,.690E-02_JPRB,&
&.703E-02_JPRB,.785E-02_JPRB,.730E-02_JPRB,.693E-02_JPRB,.709E-02_JPRB,.735E-02_JPRB,.727E-02_JPRB,&
&.741E-02_JPRB,.474E-02_JPRB,.858E-02_JPRB,.794E-02_JPRB,.729E-02_JPRB,.742E-02_JPRB,.832E-02_JPRB,&
&.760E-02_JPRB,.684E-02_JPRB,.716E-02_JPRB,.632E-02_JPRB,.685E-02_JPRB,.711E-02_JPRB,.665E-02_JPRB,&
&.614E-02_JPRB,.552E-02_JPRB,.559E-02_JPRB,.569E-02_JPRB,.576E-02_JPRB,.579E-02_JPRB,.604E-02_JPRB,&
&.634E-02_JPRB,.723E-02_JPRB,.801E-02_JPRB,.808E-02_JPRB,.909E-02_JPRB,.798E-02_JPRB,.761E-02_JPRB,&
&.829E-02_JPRB,.847E-02_JPRB,.844E-02_JPRB,.836E-02_JPRB,.970E-02_JPRB,.947E-02_JPRB,.844E-02_JPRB,&
&.840E-02_JPRB,.871E-02_JPRB,.103E-01_JPRB,.994E-02_JPRB,.988E-02_JPRB,.955E-02_JPRB,.892E-02_JPRB,&
&.778E-02_JPRB,.648E-02_JPRB,.640E-02_JPRB,.457E-02_JPRB,.466E-02_JPRB,.551E-02_JPRB,.569E-02_JPRB,&
&.588E-02_JPRB,.545E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 11  50.0
ZAER (:,11,11) = (/&
&.579E-02_JPRB,.567E-02_JPRB,.546E-02_JPRB,.577E-02_JPRB,.571E-02_JPRB,.574E-02_JPRB,.567E-02_JPRB,&
&.537E-02_JPRB,.538E-02_JPRB,.546E-02_JPRB,.537E-02_JPRB,.573E-02_JPRB,.603E-02_JPRB,.622E-02_JPRB,&
&.666E-02_JPRB,.704E-02_JPRB,.685E-02_JPRB,.640E-02_JPRB,.659E-02_JPRB,.647E-02_JPRB,.590E-02_JPRB,&
&.539E-02_JPRB,.345E-02_JPRB,.702E-02_JPRB,.694E-02_JPRB,.742E-02_JPRB,.809E-02_JPRB,.841E-02_JPRB,&
&.830E-02_JPRB,.829E-02_JPRB,.773E-02_JPRB,.761E-02_JPRB,.793E-02_JPRB,.761E-02_JPRB,.763E-02_JPRB,&
&.745E-02_JPRB,.743E-02_JPRB,.734E-02_JPRB,.676E-02_JPRB,.647E-02_JPRB,.594E-02_JPRB,.589E-02_JPRB,&
&.616E-02_JPRB,.682E-02_JPRB,.686E-02_JPRB,.661E-02_JPRB,.631E-02_JPRB,.580E-02_JPRB,.547E-02_JPRB,&
&.565E-02_JPRB,.568E-02_JPRB,.631E-02_JPRB,.680E-02_JPRB,.712E-02_JPRB,.678E-02_JPRB,.731E-02_JPRB,&
&.778E-02_JPRB,.820E-02_JPRB,.887E-02_JPRB,.885E-02_JPRB,.847E-02_JPRB,.881E-02_JPRB,.805E-02_JPRB,&
&.678E-02_JPRB,.599E-02_JPRB,.539E-02_JPRB,.530E-02_JPRB,.529E-02_JPRB,.524E-02_JPRB,.590E-02_JPRB,&
&.658E-02_JPRB,.597E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 12  46.0
ZAER (:,12,11) = (/&
&.655E-02_JPRB,.662E-02_JPRB,.628E-02_JPRB,.588E-02_JPRB,.557E-02_JPRB,.558E-02_JPRB,.517E-02_JPRB,&
&.486E-02_JPRB,.480E-02_JPRB,.482E-02_JPRB,.497E-02_JPRB,.510E-02_JPRB,.493E-02_JPRB,.517E-02_JPRB,&
&.584E-02_JPRB,.644E-02_JPRB,.632E-02_JPRB,.629E-02_JPRB,.639E-02_JPRB,.561E-02_JPRB,.475E-02_JPRB,&
&.434E-02_JPRB,.283E-02_JPRB,.653E-02_JPRB,.781E-02_JPRB,.890E-02_JPRB,.935E-02_JPRB,.911E-02_JPRB,&
&.893E-02_JPRB,.890E-02_JPRB,.878E-02_JPRB,.822E-02_JPRB,.739E-02_JPRB,.759E-02_JPRB,.843E-02_JPRB,&
&.816E-02_JPRB,.767E-02_JPRB,.809E-02_JPRB,.745E-02_JPRB,.716E-02_JPRB,.686E-02_JPRB,.609E-02_JPRB,&
&.619E-02_JPRB,.648E-02_JPRB,.687E-02_JPRB,.682E-02_JPRB,.579E-02_JPRB,.500E-02_JPRB,.530E-02_JPRB,&
&.585E-02_JPRB,.620E-02_JPRB,.647E-02_JPRB,.685E-02_JPRB,.684E-02_JPRB,.729E-02_JPRB,.767E-02_JPRB,&
&.775E-02_JPRB,.818E-02_JPRB,.838E-02_JPRB,.855E-02_JPRB,.878E-02_JPRB,.834E-02_JPRB,.802E-02_JPRB,&
&.716E-02_JPRB,.598E-02_JPRB,.523E-02_JPRB,.495E-02_JPRB,.542E-02_JPRB,.533E-02_JPRB,.599E-02_JPRB,&
&.643E-02_JPRB,.632E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 13  42.0
ZAER (:,13,11) = (/&
&.799E-02_JPRB,.666E-02_JPRB,.633E-02_JPRB,.585E-02_JPRB,.523E-02_JPRB,.479E-02_JPRB,.476E-02_JPRB,&
&.451E-02_JPRB,.435E-02_JPRB,.430E-02_JPRB,.456E-02_JPRB,.490E-02_JPRB,.493E-02_JPRB,.516E-02_JPRB,&
&.524E-02_JPRB,.525E-02_JPRB,.496E-02_JPRB,.518E-02_JPRB,.533E-02_JPRB,.480E-02_JPRB,.412E-02_JPRB,&
&.390E-02_JPRB,.277E-02_JPRB,.378E-02_JPRB,.812E-02_JPRB,.948E-02_JPRB,.101E-01_JPRB,.962E-02_JPRB,&
&.919E-02_JPRB,.881E-02_JPRB,.884E-02_JPRB,.775E-02_JPRB,.755E-02_JPRB,.722E-02_JPRB,.664E-02_JPRB,&
&.620E-02_JPRB,.646E-02_JPRB,.613E-02_JPRB,.641E-02_JPRB,.697E-02_JPRB,.664E-02_JPRB,.622E-02_JPRB,&
&.673E-02_JPRB,.729E-02_JPRB,.735E-02_JPRB,.734E-02_JPRB,.723E-02_JPRB,.696E-02_JPRB,.746E-02_JPRB,&
&.784E-02_JPRB,.794E-02_JPRB,.779E-02_JPRB,.751E-02_JPRB,.755E-02_JPRB,.718E-02_JPRB,.731E-02_JPRB,&
&.751E-02_JPRB,.702E-02_JPRB,.693E-02_JPRB,.696E-02_JPRB,.758E-02_JPRB,.722E-02_JPRB,.698E-02_JPRB,&
&.636E-02_JPRB,.618E-02_JPRB,.548E-02_JPRB,.551E-02_JPRB,.584E-02_JPRB,.616E-02_JPRB,.631E-02_JPRB,&
&.672E-02_JPRB,.667E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 14  38.0
ZAER (:,14,11) = (/&
&.796E-02_JPRB,.691E-02_JPRB,.668E-02_JPRB,.609E-02_JPRB,.589E-02_JPRB,.604E-02_JPRB,.639E-02_JPRB,&
&.618E-02_JPRB,.547E-02_JPRB,.566E-02_JPRB,.512E-02_JPRB,.552E-02_JPRB,.498E-02_JPRB,.524E-02_JPRB,&
&.511E-02_JPRB,.510E-02_JPRB,.428E-02_JPRB,.419E-02_JPRB,.448E-02_JPRB,.452E-02_JPRB,.451E-02_JPRB,&
&.447E-02_JPRB,.371E-02_JPRB,.610E-02_JPRB,.645E-02_JPRB,.122E-01_JPRB,.121E-01_JPRB,.111E-01_JPRB,&
&.980E-02_JPRB,.933E-02_JPRB,.880E-02_JPRB,.857E-02_JPRB,.799E-02_JPRB,.672E-02_JPRB,.624E-02_JPRB,&
&.618E-02_JPRB,.654E-02_JPRB,.608E-02_JPRB,.627E-02_JPRB,.677E-02_JPRB,.712E-02_JPRB,.777E-02_JPRB,&
&.838E-02_JPRB,.873E-02_JPRB,.917E-02_JPRB,.932E-02_JPRB,.887E-02_JPRB,.863E-02_JPRB,.861E-02_JPRB,&
&.868E-02_JPRB,.888E-02_JPRB,.903E-02_JPRB,.874E-02_JPRB,.834E-02_JPRB,.810E-02_JPRB,.775E-02_JPRB,&
&.721E-02_JPRB,.675E-02_JPRB,.617E-02_JPRB,.608E-02_JPRB,.616E-02_JPRB,.719E-02_JPRB,.752E-02_JPRB,&
&.739E-02_JPRB,.712E-02_JPRB,.390E-02_JPRB,.678E-02_JPRB,.799E-02_JPRB,.849E-02_JPRB,.863E-02_JPRB,&
&.817E-02_JPRB,.667E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 15  34.0
ZAER (:,15,11) = (/&
&.899E-02_JPRB,.820E-02_JPRB,.806E-02_JPRB,.762E-02_JPRB,.740E-02_JPRB,.711E-02_JPRB,.736E-02_JPRB,&
&.724E-02_JPRB,.717E-02_JPRB,.640E-02_JPRB,.611E-02_JPRB,.624E-02_JPRB,.569E-02_JPRB,.561E-02_JPRB,&
&.542E-02_JPRB,.522E-02_JPRB,.474E-02_JPRB,.436E-02_JPRB,.414E-02_JPRB,.422E-02_JPRB,.463E-02_JPRB,&
&.824E-02_JPRB,.648E-02_JPRB,.112E-01_JPRB,.106E-01_JPRB,.100E-01_JPRB,.166E-01_JPRB,.157E-01_JPRB,&
&.146E-01_JPRB,.131E-01_JPRB,.105E-01_JPRB,.942E-02_JPRB,.833E-02_JPRB,.730E-02_JPRB,.742E-02_JPRB,&
&.711E-02_JPRB,.738E-02_JPRB,.733E-02_JPRB,.782E-02_JPRB,.872E-02_JPRB,.554E-02_JPRB,.128E-01_JPRB,&
&.138E-01_JPRB,.141E-01_JPRB,.134E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,.114E-01_JPRB,.108E-01_JPRB,&
&.997E-02_JPRB,.920E-02_JPRB,.916E-02_JPRB,.904E-02_JPRB,.879E-02_JPRB,.840E-02_JPRB,.773E-02_JPRB,&
&.734E-02_JPRB,.653E-02_JPRB,.630E-02_JPRB,.718E-02_JPRB,.457E-02_JPRB,.891E-02_JPRB,.922E-02_JPRB,&
&.945E-02_JPRB,.572E-02_JPRB,.609E-02_JPRB,.621E-02_JPRB,.121E-01_JPRB,.120E-01_JPRB,.118E-01_JPRB,&
&.100E-01_JPRB,.895E-02_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 16  30.0
ZAER (:,16,11) = (/&
&.116E-01_JPRB,.108E-01_JPRB,.976E-02_JPRB,.933E-02_JPRB,.913E-02_JPRB,.993E-02_JPRB,.986E-02_JPRB,&
&.901E-02_JPRB,.914E-02_JPRB,.899E-02_JPRB,.869E-02_JPRB,.834E-02_JPRB,.779E-02_JPRB,.748E-02_JPRB,&
&.763E-02_JPRB,.705E-02_JPRB,.591E-02_JPRB,.540E-02_JPRB,.559E-02_JPRB,.569E-02_JPRB,.627E-02_JPRB,&
&.139E-01_JPRB,.108E-01_JPRB,.150E-01_JPRB,.152E-01_JPRB,.144E-01_JPRB,.236E-01_JPRB,.224E-01_JPRB,&
&.194E-01_JPRB,.156E-01_JPRB,.125E-01_JPRB,.118E-01_JPRB,.104E-01_JPRB,.955E-02_JPRB,.959E-02_JPRB,&
&.927E-02_JPRB,.936E-02_JPRB,.950E-02_JPRB,.104E-01_JPRB,.130E-01_JPRB,.110E-01_JPRB,.161E-01_JPRB,&
&.158E-01_JPRB,.284E-01_JPRB,.198E-01_JPRB,.161E-01_JPRB,.148E-01_JPRB,.146E-01_JPRB,.129E-01_JPRB,&
&.109E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,.963E-02_JPRB,.900E-02_JPRB,.988E-02_JPRB,.945E-02_JPRB,&
&.855E-02_JPRB,.756E-02_JPRB,.827E-02_JPRB,.567E-02_JPRB,.684E-02_JPRB,.759E-02_JPRB,.813E-02_JPRB,&
&.883E-02_JPRB,.894E-02_JPRB,.974E-02_JPRB,.104E-01_JPRB,.189E-01_JPRB,.164E-01_JPRB,.144E-01_JPRB,&
&.129E-01_JPRB,.115E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 17  26.0
ZAER (:,17,11) = (/&
&.143E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.129E-01_JPRB,.126E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.115E-01_JPRB,.125E-01_JPRB,.130E-01_JPRB,.129E-01_JPRB,.125E-01_JPRB,.111E-01_JPRB,.978E-02_JPRB,&
&.970E-02_JPRB,.856E-02_JPRB,.730E-02_JPRB,.713E-02_JPRB,.720E-02_JPRB,.847E-02_JPRB,.982E-02_JPRB,&
&.190E-01_JPRB,.135E-01_JPRB,.151E-01_JPRB,.193E-01_JPRB,.182E-01_JPRB,.189E-01_JPRB,.289E-01_JPRB,&
&.213E-01_JPRB,.167E-01_JPRB,.146E-01_JPRB,.133E-01_JPRB,.121E-01_JPRB,.108E-01_JPRB,.110E-01_JPRB,&
&.115E-01_JPRB,.120E-01_JPRB,.136E-01_JPRB,.167E-01_JPRB,.117E-01_JPRB,.145E-01_JPRB,.219E-01_JPRB,&
&.175E-01_JPRB,.324E-01_JPRB,.198E-01_JPRB,.161E-01_JPRB,.176E-01_JPRB,.177E-01_JPRB,.137E-01_JPRB,&
&.115E-01_JPRB,.110E-01_JPRB,.106E-01_JPRB,.102E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.965E-02_JPRB,&
&.953E-02_JPRB,.109E-01_JPRB,.136E-01_JPRB,.117E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.108E-01_JPRB,&
&.106E-01_JPRB,.116E-01_JPRB,.120E-01_JPRB,.118E-01_JPRB,.191E-01_JPRB,.177E-01_JPRB,.152E-01_JPRB,&
&.149E-01_JPRB,.148E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 18  22.0
ZAER (:,18,11) = (/&
&.171E-01_JPRB,.160E-01_JPRB,.154E-01_JPRB,.141E-01_JPRB,.140E-01_JPRB,.129E-01_JPRB,.136E-01_JPRB,&
&.143E-01_JPRB,.148E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.142E-01_JPRB,.119E-01_JPRB,.112E-01_JPRB,&
&.109E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.112E-01_JPRB,.121E-01_JPRB,.128E-01_JPRB,.162E-01_JPRB,&
&.381E-01_JPRB,.228E-01_JPRB,.155E-01_JPRB,.169E-01_JPRB,.161E-01_JPRB,.246E-01_JPRB,.184E-01_JPRB,&
&.208E-01_JPRB,.172E-01_JPRB,.163E-01_JPRB,.155E-01_JPRB,.138E-01_JPRB,.127E-01_JPRB,.135E-01_JPRB,&
&.155E-01_JPRB,.172E-01_JPRB,.203E-01_JPRB,.231E-01_JPRB,.137E-01_JPRB,.146E-01_JPRB,.189E-01_JPRB,&
&.156E-01_JPRB,.126E-01_JPRB,.155E-01_JPRB,.943E-02_JPRB,.198E-01_JPRB,.262E-01_JPRB,.196E-01_JPRB,&
&.128E-01_JPRB,.123E-01_JPRB,.134E-01_JPRB,.135E-01_JPRB,.138E-01_JPRB,.130E-01_JPRB,.126E-01_JPRB,&
&.143E-01_JPRB,.183E-01_JPRB,.241E-01_JPRB,.295E-01_JPRB,.152E-01_JPRB,.115E-01_JPRB,.113E-01_JPRB,&
&.103E-01_JPRB,.108E-01_JPRB,.114E-01_JPRB,.176E-01_JPRB,.180E-01_JPRB,.209E-01_JPRB,.232E-01_JPRB,&
&.232E-01_JPRB,.199E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 19  18.0
ZAER (:,19,11) = (/&
&.193E-01_JPRB,.172E-01_JPRB,.165E-01_JPRB,.151E-01_JPRB,.153E-01_JPRB,.147E-01_JPRB,.156E-01_JPRB,&
&.164E-01_JPRB,.169E-01_JPRB,.170E-01_JPRB,.163E-01_JPRB,.156E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.147E-01_JPRB,.155E-01_JPRB,.175E-01_JPRB,.184E-01_JPRB,.180E-01_JPRB,.191E-01_JPRB,.318E-01_JPRB,&
&.849E-01_JPRB,.266E-01_JPRB,.162E-01_JPRB,.139E-01_JPRB,.132E-01_JPRB,.176E-01_JPRB,.176E-01_JPRB,&
&.137E-01_JPRB,.176E-01_JPRB,.155E-01_JPRB,.162E-01_JPRB,.159E-01_JPRB,.148E-01_JPRB,.166E-01_JPRB,&
&.198E-01_JPRB,.220E-01_JPRB,.254E-01_JPRB,.229E-01_JPRB,.128E-01_JPRB,.155E-01_JPRB,.210E-01_JPRB,&
&.131E-01_JPRB,.993E-02_JPRB,.141E-01_JPRB,.955E-02_JPRB,.178E-01_JPRB,.209E-01_JPRB,.187E-01_JPRB,&
&.158E-01_JPRB,.171E-01_JPRB,.186E-01_JPRB,.195E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.226E-01_JPRB,&
&.263E-01_JPRB,.307E-01_JPRB,.341E-01_JPRB,.345E-01_JPRB,.287E-01_JPRB,.135E-01_JPRB,.134E-01_JPRB,&
&.131E-01_JPRB,.130E-01_JPRB,.127E-01_JPRB,.230E-01_JPRB,.284E-01_JPRB,.353E-01_JPRB,.460E-01_JPRB,&
&.416E-01_JPRB,.259E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 20  14.0
ZAER (:,20,11) = (/&
&.190E-01_JPRB,.171E-01_JPRB,.167E-01_JPRB,.161E-01_JPRB,.166E-01_JPRB,.172E-01_JPRB,.177E-01_JPRB,&
&.182E-01_JPRB,.193E-01_JPRB,.192E-01_JPRB,.184E-01_JPRB,.177E-01_JPRB,.173E-01_JPRB,.169E-01_JPRB,&
&.187E-01_JPRB,.220E-01_JPRB,.249E-01_JPRB,.249E-01_JPRB,.246E-01_JPRB,.330E-01_JPRB,.604E-01_JPRB,&
&.423E-01_JPRB,.262E-01_JPRB,.167E-01_JPRB,.117E-01_JPRB,.115E-01_JPRB,.125E-01_JPRB,.142E-01_JPRB,&
&.134E-01_JPRB,.177E-01_JPRB,.170E-01_JPRB,.167E-01_JPRB,.157E-01_JPRB,.170E-01_JPRB,.199E-01_JPRB,&
&.245E-01_JPRB,.265E-01_JPRB,.282E-01_JPRB,.224E-01_JPRB,.120E-01_JPRB,.130E-01_JPRB,.212E-01_JPRB,&
&.143E-01_JPRB,.914E-02_JPRB,.818E-02_JPRB,.154E-01_JPRB,.159E-01_JPRB,.168E-01_JPRB,.167E-01_JPRB,&
&.172E-01_JPRB,.186E-01_JPRB,.208E-01_JPRB,.238E-01_JPRB,.277E-01_JPRB,.329E-01_JPRB,.399E-01_JPRB,&
&.479E-01_JPRB,.526E-01_JPRB,.528E-01_JPRB,.475E-01_JPRB,.434E-01_JPRB,.410E-01_JPRB,.243E-01_JPRB,&
&.209E-01_JPRB,.349E-01_JPRB,.372E-01_JPRB,.395E-01_JPRB,.411E-01_JPRB,.436E-01_JPRB,.500E-01_JPRB,&
&.321E-01_JPRB,.234E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 21  10.0
ZAER (:,21,11) = (/&
&.184E-01_JPRB,.178E-01_JPRB,.181E-01_JPRB,.187E-01_JPRB,.195E-01_JPRB,.201E-01_JPRB,.204E-01_JPRB,&
&.212E-01_JPRB,.222E-01_JPRB,.226E-01_JPRB,.216E-01_JPRB,.217E-01_JPRB,.227E-01_JPRB,.234E-01_JPRB,&
&.242E-01_JPRB,.283E-01_JPRB,.329E-01_JPRB,.356E-01_JPRB,.419E-01_JPRB,.564E-01_JPRB,.572E-01_JPRB,&
&.278E-01_JPRB,.207E-01_JPRB,.127E-01_JPRB,.109E-01_JPRB,.113E-01_JPRB,.121E-01_JPRB,.133E-01_JPRB,&
&.126E-01_JPRB,.179E-01_JPRB,.186E-01_JPRB,.190E-01_JPRB,.181E-01_JPRB,.191E-01_JPRB,.219E-01_JPRB,&
&.251E-01_JPRB,.271E-01_JPRB,.254E-01_JPRB,.188E-01_JPRB,.105E-01_JPRB,.116E-01_JPRB,.170E-01_JPRB,&
&.120E-01_JPRB,.855E-02_JPRB,.127E-01_JPRB,.141E-01_JPRB,.149E-01_JPRB,.153E-01_JPRB,.160E-01_JPRB,&
&.170E-01_JPRB,.186E-01_JPRB,.217E-01_JPRB,.264E-01_JPRB,.336E-01_JPRB,.432E-01_JPRB,.555E-01_JPRB,&
&.744E-01_JPRB,.863E-01_JPRB,.903E-01_JPRB,.611E-01_JPRB,.694E-01_JPRB,.713E-01_JPRB,.755E-01_JPRB,&
&.818E-01_JPRB,.905E-01_JPRB,.943E-01_JPRB,.652E-01_JPRB,.528E-01_JPRB,.425E-01_JPRB,.388E-01_JPRB,&
&.259E-01_JPRB,.205E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 22   6.0
ZAER (:,22,11) = (/&
&.189E-01_JPRB,.188E-01_JPRB,.201E-01_JPRB,.207E-01_JPRB,.226E-01_JPRB,.234E-01_JPRB,.236E-01_JPRB,&
&.242E-01_JPRB,.256E-01_JPRB,.262E-01_JPRB,.262E-01_JPRB,.264E-01_JPRB,.267E-01_JPRB,.319E-01_JPRB,&
&.294E-01_JPRB,.321E-01_JPRB,.433E-01_JPRB,.503E-01_JPRB,.553E-01_JPRB,.633E-01_JPRB,.337E-01_JPRB,&
&.246E-01_JPRB,.167E-01_JPRB,.129E-01_JPRB,.118E-01_JPRB,.129E-01_JPRB,.146E-01_JPRB,.140E-01_JPRB,&
&.126E-01_JPRB,.198E-01_JPRB,.200E-01_JPRB,.206E-01_JPRB,.210E-01_JPRB,.199E-01_JPRB,.213E-01_JPRB,&
&.242E-01_JPRB,.239E-01_JPRB,.204E-01_JPRB,.173E-01_JPRB,.104E-01_JPRB,.117E-01_JPRB,.135E-01_JPRB,&
&.115E-01_JPRB,.854E-02_JPRB,.131E-01_JPRB,.136E-01_JPRB,.142E-01_JPRB,.145E-01_JPRB,.152E-01_JPRB,&
&.165E-01_JPRB,.186E-01_JPRB,.218E-01_JPRB,.273E-01_JPRB,.363E-01_JPRB,.475E-01_JPRB,.596E-01_JPRB,&
&.761E-01_JPRB,.912E-01_JPRB,.790E-01_JPRB,.757E-01_JPRB,.811E-01_JPRB,.847E-01_JPRB,.923E-01_JPRB,&
&.105E+00_JPRB,.650E-01_JPRB,.640E-01_JPRB,.840E-01_JPRB,.578E-01_JPRB,.392E-01_JPRB,.280E-01_JPRB,&
&.221E-01_JPRB,.195E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 23   2.0
ZAER (:,23,11) = (/&
&.202E-01_JPRB,.207E-01_JPRB,.225E-01_JPRB,.239E-01_JPRB,.272E-01_JPRB,.293E-01_JPRB,.289E-01_JPRB,&
&.309E-01_JPRB,.325E-01_JPRB,.329E-01_JPRB,.342E-01_JPRB,.351E-01_JPRB,.365E-01_JPRB,.475E-01_JPRB,&
&.480E-01_JPRB,.504E-01_JPRB,.535E-01_JPRB,.604E-01_JPRB,.589E-01_JPRB,.601E-01_JPRB,.384E-01_JPRB,&
&.288E-01_JPRB,.195E-01_JPRB,.146E-01_JPRB,.128E-01_JPRB,.133E-01_JPRB,.164E-01_JPRB,.152E-01_JPRB,&
&.204E-01_JPRB,.218E-01_JPRB,.217E-01_JPRB,.203E-01_JPRB,.210E-01_JPRB,.196E-01_JPRB,.203E-01_JPRB,&
&.223E-01_JPRB,.207E-01_JPRB,.170E-01_JPRB,.960E-02_JPRB,.108E-01_JPRB,.126E-01_JPRB,.159E-01_JPRB,&
&.127E-01_JPRB,.980E-02_JPRB,.891E-02_JPRB,.135E-01_JPRB,.136E-01_JPRB,.139E-01_JPRB,.149E-01_JPRB,&
&.160E-01_JPRB,.177E-01_JPRB,.207E-01_JPRB,.258E-01_JPRB,.329E-01_JPRB,.433E-01_JPRB,.506E-01_JPRB,&
&.580E-01_JPRB,.404E-01_JPRB,.629E-01_JPRB,.377E-01_JPRB,.716E-01_JPRB,.813E-01_JPRB,.841E-01_JPRB,&
&.518E-01_JPRB,.957E-01_JPRB,.955E-01_JPRB,.759E-01_JPRB,.489E-01_JPRB,.296E-01_JPRB,.228E-01_JPRB,&
&.206E-01_JPRB,.197E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 24  -2.0
ZAER (:,24,11) = (/&
&.215E-01_JPRB,.238E-01_JPRB,.262E-01_JPRB,.285E-01_JPRB,.332E-01_JPRB,.362E-01_JPRB,.404E-01_JPRB,&
&.422E-01_JPRB,.465E-01_JPRB,.522E-01_JPRB,.565E-01_JPRB,.584E-01_JPRB,.557E-01_JPRB,.676E-01_JPRB,&
&.681E-01_JPRB,.739E-01_JPRB,.783E-01_JPRB,.862E-01_JPRB,.695E-01_JPRB,.668E-01_JPRB,.600E-01_JPRB,&
&.301E-01_JPRB,.218E-01_JPRB,.154E-01_JPRB,.124E-01_JPRB,.122E-01_JPRB,.189E-01_JPRB,.181E-01_JPRB,&
&.183E-01_JPRB,.192E-01_JPRB,.184E-01_JPRB,.186E-01_JPRB,.190E-01_JPRB,.176E-01_JPRB,.163E-01_JPRB,&
&.162E-01_JPRB,.159E-01_JPRB,.154E-01_JPRB,.938E-02_JPRB,.105E-01_JPRB,.118E-01_JPRB,.126E-01_JPRB,&
&.106E-01_JPRB,.851E-02_JPRB,.803E-02_JPRB,.782E-02_JPRB,.128E-01_JPRB,.136E-01_JPRB,.142E-01_JPRB,&
&.145E-01_JPRB,.162E-01_JPRB,.180E-01_JPRB,.209E-01_JPRB,.256E-01_JPRB,.308E-01_JPRB,.379E-01_JPRB,&
&.244E-01_JPRB,.460E-01_JPRB,.475E-01_JPRB,.280E-01_JPRB,.607E-01_JPRB,.781E-01_JPRB,.631E-01_JPRB,&
&.604E-01_JPRB,.575E-01_JPRB,.477E-01_JPRB,.502E-01_JPRB,.325E-01_JPRB,.220E-01_JPRB,.187E-01_JPRB,&
&.185E-01_JPRB,.194E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 25  -6.0
ZAER (:,25,11) = (/&
&.200E-01_JPRB,.225E-01_JPRB,.250E-01_JPRB,.279E-01_JPRB,.310E-01_JPRB,.335E-01_JPRB,.361E-01_JPRB,&
&.398E-01_JPRB,.441E-01_JPRB,.481E-01_JPRB,.519E-01_JPRB,.563E-01_JPRB,.587E-01_JPRB,.630E-01_JPRB,&
&.666E-01_JPRB,.719E-01_JPRB,.742E-01_JPRB,.686E-01_JPRB,.718E-01_JPRB,.657E-01_JPRB,.780E-01_JPRB,&
&.408E-01_JPRB,.259E-01_JPRB,.155E-01_JPRB,.117E-01_JPRB,.158E-01_JPRB,.157E-01_JPRB,.163E-01_JPRB,&
&.162E-01_JPRB,.157E-01_JPRB,.150E-01_JPRB,.154E-01_JPRB,.152E-01_JPRB,.149E-01_JPRB,.831E-02_JPRB,&
&.817E-02_JPRB,.802E-02_JPRB,.832E-02_JPRB,.854E-02_JPRB,.890E-02_JPRB,.949E-02_JPRB,.960E-02_JPRB,&
&.933E-02_JPRB,.795E-02_JPRB,.754E-02_JPRB,.744E-02_JPRB,.133E-01_JPRB,.143E-01_JPRB,.152E-01_JPRB,&
&.159E-01_JPRB,.164E-01_JPRB,.183E-01_JPRB,.168E-01_JPRB,.190E-01_JPRB,.209E-01_JPRB,.256E-01_JPRB,&
&.285E-01_JPRB,.278E-01_JPRB,.330E-01_JPRB,.369E-01_JPRB,.457E-01_JPRB,.441E-01_JPRB,.403E-01_JPRB,&
&.375E-01_JPRB,.335E-01_JPRB,.278E-01_JPRB,.276E-01_JPRB,.213E-01_JPRB,.176E-01_JPRB,.167E-01_JPRB,&
&.172E-01_JPRB,.183E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 26 -10.0
ZAER (:,26,11) = (/&
&.178E-01_JPRB,.200E-01_JPRB,.224E-01_JPRB,.249E-01_JPRB,.269E-01_JPRB,.283E-01_JPRB,.307E-01_JPRB,&
&.349E-01_JPRB,.394E-01_JPRB,.436E-01_JPRB,.481E-01_JPRB,.507E-01_JPRB,.513E-01_JPRB,.549E-01_JPRB,&
&.609E-01_JPRB,.648E-01_JPRB,.715E-01_JPRB,.750E-01_JPRB,.920E-01_JPRB,.762E-01_JPRB,.620E-01_JPRB,&
&.334E-01_JPRB,.227E-01_JPRB,.150E-01_JPRB,.163E-01_JPRB,.140E-01_JPRB,.143E-01_JPRB,.136E-01_JPRB,&
&.132E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.809E-02_JPRB,&
&.829E-02_JPRB,.866E-02_JPRB,.861E-02_JPRB,.855E-02_JPRB,.811E-02_JPRB,.785E-02_JPRB,.764E-02_JPRB,&
&.760E-02_JPRB,.680E-02_JPRB,.662E-02_JPRB,.687E-02_JPRB,.787E-02_JPRB,.150E-01_JPRB,.168E-01_JPRB,&
&.185E-01_JPRB,.181E-01_JPRB,.196E-01_JPRB,.157E-01_JPRB,.160E-01_JPRB,.186E-01_JPRB,.231E-01_JPRB,&
&.220E-01_JPRB,.185E-01_JPRB,.220E-01_JPRB,.295E-01_JPRB,.369E-01_JPRB,.301E-01_JPRB,.270E-01_JPRB,&
&.255E-01_JPRB,.231E-01_JPRB,.196E-01_JPRB,.172E-01_JPRB,.151E-01_JPRB,.143E-01_JPRB,.147E-01_JPRB,&
&.153E-01_JPRB,.162E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 27 -14.0
ZAER (:,27,11) = (/&
&.147E-01_JPRB,.161E-01_JPRB,.177E-01_JPRB,.194E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.219E-01_JPRB,&
&.243E-01_JPRB,.287E-01_JPRB,.341E-01_JPRB,.405E-01_JPRB,.449E-01_JPRB,.480E-01_JPRB,.531E-01_JPRB,&
&.572E-01_JPRB,.616E-01_JPRB,.615E-01_JPRB,.660E-01_JPRB,.390E-01_JPRB,.275E-01_JPRB,.426E-01_JPRB,&
&.385E-01_JPRB,.322E-01_JPRB,.227E-01_JPRB,.155E-01_JPRB,.142E-01_JPRB,.133E-01_JPRB,.121E-01_JPRB,&
&.114E-01_JPRB,.109E-01_JPRB,.117E-01_JPRB,.131E-01_JPRB,.147E-01_JPRB,.849E-02_JPRB,.930E-02_JPRB,&
&.103E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.937E-02_JPRB,.871E-02_JPRB,.821E-02_JPRB,.730E-02_JPRB,&
&.727E-02_JPRB,.718E-02_JPRB,.737E-02_JPRB,.703E-02_JPRB,.144E-01_JPRB,.162E-01_JPRB,.197E-01_JPRB,&
&.254E-01_JPRB,.280E-01_JPRB,.118E-01_JPRB,.155E-01_JPRB,.170E-01_JPRB,.194E-01_JPRB,.240E-01_JPRB,&
&.126E-01_JPRB,.112E-01_JPRB,.201E-01_JPRB,.226E-01_JPRB,.288E-01_JPRB,.211E-01_JPRB,.215E-01_JPRB,&
&.215E-01_JPRB,.207E-01_JPRB,.175E-01_JPRB,.145E-01_JPRB,.130E-01_JPRB,.123E-01_JPRB,.125E-01_JPRB,&
&.129E-01_JPRB,.140E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 28 -18.0
ZAER (:,28,11) = (/&
&.124E-01_JPRB,.133E-01_JPRB,.147E-01_JPRB,.150E-01_JPRB,.163E-01_JPRB,.138E-01_JPRB,.135E-01_JPRB,&
&.137E-01_JPRB,.158E-01_JPRB,.212E-01_JPRB,.288E-01_JPRB,.372E-01_JPRB,.469E-01_JPRB,.527E-01_JPRB,&
&.518E-01_JPRB,.570E-01_JPRB,.280E-01_JPRB,.258E-01_JPRB,.231E-01_JPRB,.322E-01_JPRB,.303E-01_JPRB,&
&.273E-01_JPRB,.247E-01_JPRB,.207E-01_JPRB,.164E-01_JPRB,.145E-01_JPRB,.127E-01_JPRB,.117E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.130E-01_JPRB,.136E-01_JPRB,.135E-01_JPRB,.806E-02_JPRB,.900E-02_JPRB,&
&.108E-01_JPRB,.152E-01_JPRB,.170E-01_JPRB,.177E-01_JPRB,.159E-01_JPRB,.142E-01_JPRB,.120E-01_JPRB,&
&.109E-01_JPRB,.106E-01_JPRB,.163E-01_JPRB,.114E-01_JPRB,.157E-01_JPRB,.139E-01_JPRB,.281E-01_JPRB,&
&.359E-01_JPRB,.524E-01_JPRB,.244E-01_JPRB,.182E-01_JPRB,.214E-01_JPRB,.254E-01_JPRB,.216E-01_JPRB,&
&.242E-01_JPRB,.167E-01_JPRB,.263E-01_JPRB,.203E-01_JPRB,.180E-01_JPRB,.173E-01_JPRB,.188E-01_JPRB,&
&.201E-01_JPRB,.206E-01_JPRB,.184E-01_JPRB,.143E-01_JPRB,.124E-01_JPRB,.114E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.116E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 29 -22.0
ZAER (:,29,11) = (/&
&.114E-01_JPRB,.120E-01_JPRB,.135E-01_JPRB,.152E-01_JPRB,.144E-01_JPRB,.108E-01_JPRB,.901E-02_JPRB,&
&.855E-02_JPRB,.816E-02_JPRB,.960E-02_JPRB,.124E-01_JPRB,.227E-01_JPRB,.447E-01_JPRB,.586E-01_JPRB,&
&.636E-01_JPRB,.362E-01_JPRB,.313E-01_JPRB,.429E-01_JPRB,.347E-01_JPRB,.279E-01_JPRB,.225E-01_JPRB,&
&.229E-01_JPRB,.223E-01_JPRB,.194E-01_JPRB,.169E-01_JPRB,.153E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,&
&.117E-01_JPRB,.121E-01_JPRB,.135E-01_JPRB,.143E-01_JPRB,.136E-01_JPRB,.766E-02_JPRB,.829E-02_JPRB,&
&.123E-01_JPRB,.200E-01_JPRB,.173E-01_JPRB,.201E-01_JPRB,.228E-01_JPRB,.222E-01_JPRB,.218E-01_JPRB,&
&.190E-01_JPRB,.235E-01_JPRB,.165E-01_JPRB,.238E-01_JPRB,.286E-01_JPRB,.259E-01_JPRB,.378E-01_JPRB,&
&.444E-01_JPRB,.329E-01_JPRB,.409E-01_JPRB,.375E-01_JPRB,.194E-01_JPRB,.152E-01_JPRB,.204E-01_JPRB,&
&.281E-01_JPRB,.425E-01_JPRB,.305E-01_JPRB,.417E-01_JPRB,.177E-01_JPRB,.169E-01_JPRB,.177E-01_JPRB,&
&.193E-01_JPRB,.221E-01_JPRB,.189E-01_JPRB,.155E-01_JPRB,.144E-01_JPRB,.136E-01_JPRB,.130E-01_JPRB,&
&.127E-01_JPRB,.120E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 30 -26.0
ZAER (:,30,11) = (/&
&.122E-01_JPRB,.115E-01_JPRB,.120E-01_JPRB,.116E-01_JPRB,.104E-01_JPRB,.860E-02_JPRB,.800E-02_JPRB,&
&.773E-02_JPRB,.690E-02_JPRB,.637E-02_JPRB,.679E-02_JPRB,.107E-01_JPRB,.304E-01_JPRB,.495E-01_JPRB,&
&.366E-01_JPRB,.360E-01_JPRB,.433E-01_JPRB,.722E-01_JPRB,.497E-01_JPRB,.314E-01_JPRB,.229E-01_JPRB,&
&.238E-01_JPRB,.250E-01_JPRB,.226E-01_JPRB,.190E-01_JPRB,.165E-01_JPRB,.142E-01_JPRB,.127E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.117E-01_JPRB,.119E-01_JPRB,.137E-01_JPRB,.144E-01_JPRB,.795E-02_JPRB,&
&.127E-01_JPRB,.143E-01_JPRB,.130E-01_JPRB,.150E-01_JPRB,.221E-01_JPRB,.242E-01_JPRB,.256E-01_JPRB,&
&.230E-01_JPRB,.210E-01_JPRB,.233E-01_JPRB,.301E-01_JPRB,.393E-01_JPRB,.436E-01_JPRB,.242E-01_JPRB,&
&.278E-01_JPRB,.427E-01_JPRB,.516E-01_JPRB,.425E-01_JPRB,.140E-01_JPRB,.114E-01_JPRB,.151E-01_JPRB,&
&.231E-01_JPRB,.457E-01_JPRB,.520E-01_JPRB,.591E-01_JPRB,.609E-01_JPRB,.302E-01_JPRB,.238E-01_JPRB,&
&.218E-01_JPRB,.274E-01_JPRB,.262E-01_JPRB,.213E-01_JPRB,.183E-01_JPRB,.161E-01_JPRB,.151E-01_JPRB,&
&.145E-01_JPRB,.132E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 31 -30.0
ZAER (:,31,11) = (/&
&.123E-01_JPRB,.119E-01_JPRB,.118E-01_JPRB,.111E-01_JPRB,.968E-02_JPRB,.864E-02_JPRB,.814E-02_JPRB,&
&.753E-02_JPRB,.688E-02_JPRB,.601E-02_JPRB,.587E-02_JPRB,.906E-02_JPRB,.174E-01_JPRB,.344E-01_JPRB,&
&.242E-01_JPRB,.294E-01_JPRB,.457E-01_JPRB,.610E-01_JPRB,.600E-01_JPRB,.435E-01_JPRB,.554E-01_JPRB,&
&.447E-01_JPRB,.320E-01_JPRB,.232E-01_JPRB,.177E-01_JPRB,.153E-01_JPRB,.138E-01_JPRB,.130E-01_JPRB,&
&.118E-01_JPRB,.107E-01_JPRB,.103E-01_JPRB,.993E-02_JPRB,.106E-01_JPRB,.121E-01_JPRB,.703E-02_JPRB,&
&.875E-02_JPRB,.121E-01_JPRB,.130E-01_JPRB,.146E-01_JPRB,.197E-01_JPRB,.244E-01_JPRB,.285E-01_JPRB,&
&.277E-01_JPRB,.228E-01_JPRB,.342E-01_JPRB,.594E-01_JPRB,.445E-01_JPRB,.270E-01_JPRB,.229E-01_JPRB,&
&.252E-01_JPRB,.372E-01_JPRB,.318E-01_JPRB,.149E-01_JPRB,.513E-02_JPRB,.253E-02_JPRB,.366E-02_JPRB,&
&.842E-02_JPRB,.383E-01_JPRB,.670E-01_JPRB,.756E-01_JPRB,.761E-01_JPRB,.678E-01_JPRB,.466E-01_JPRB,&
&.585E-01_JPRB,.469E-01_JPRB,.354E-01_JPRB,.265E-01_JPRB,.217E-01_JPRB,.184E-01_JPRB,.165E-01_JPRB,&
&.143E-01_JPRB,.131E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 32 -34.0
ZAER (:,32,11) = (/&
&.120E-01_JPRB,.115E-01_JPRB,.113E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.952E-02_JPRB,.887E-02_JPRB,&
&.772E-02_JPRB,.683E-02_JPRB,.605E-02_JPRB,.683E-02_JPRB,.112E-01_JPRB,.170E-01_JPRB,.185E-01_JPRB,&
&.217E-01_JPRB,.251E-01_JPRB,.379E-01_JPRB,.431E-01_JPRB,.538E-01_JPRB,.517E-01_JPRB,.628E-01_JPRB,&
&.845E-01_JPRB,.485E-01_JPRB,.256E-01_JPRB,.173E-01_JPRB,.130E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,&
&.112E-01_JPRB,.109E-01_JPRB,.106E-01_JPRB,.936E-02_JPRB,.881E-02_JPRB,.970E-02_JPRB,.127E-01_JPRB,&
&.695E-02_JPRB,.765E-02_JPRB,.102E-01_JPRB,.133E-01_JPRB,.297E-01_JPRB,.438E-01_JPRB,.505E-01_JPRB,&
&.432E-01_JPRB,.417E-01_JPRB,.324E-01_JPRB,.369E-01_JPRB,.242E-01_JPRB,.349E-01_JPRB,.279E-01_JPRB,&
&.177E-01_JPRB,.183E-01_JPRB,.170E-01_JPRB,.554E-02_JPRB,.336E-02_JPRB,.257E-02_JPRB,.266E-02_JPRB,&
&.384E-02_JPRB,.248E-01_JPRB,.556E-01_JPRB,.651E-01_JPRB,.471E-01_JPRB,.763E-01_JPRB,.722E-01_JPRB,&
&.338E-01_JPRB,.401E-01_JPRB,.306E-01_JPRB,.247E-01_JPRB,.217E-01_JPRB,.190E-01_JPRB,.163E-01_JPRB,&
&.144E-01_JPRB,.130E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 33 -38.0
ZAER (:,33,11) = (/&
&.116E-01_JPRB,.111E-01_JPRB,.107E-01_JPRB,.102E-01_JPRB,.988E-02_JPRB,.975E-02_JPRB,.895E-02_JPRB,&
&.763E-02_JPRB,.730E-02_JPRB,.677E-02_JPRB,.823E-02_JPRB,.128E-01_JPRB,.757E-02_JPRB,.965E-02_JPRB,&
&.149E-01_JPRB,.153E-01_JPRB,.211E-01_JPRB,.299E-01_JPRB,.365E-01_JPRB,.446E-01_JPRB,.787E-01_JPRB,&
&.101E+00_JPRB,.542E-01_JPRB,.282E-01_JPRB,.178E-01_JPRB,.121E-01_JPRB,.980E-02_JPRB,.931E-02_JPRB,&
&.942E-02_JPRB,.975E-02_JPRB,.903E-02_JPRB,.919E-02_JPRB,.904E-02_JPRB,.907E-02_JPRB,.126E-01_JPRB,&
&.924E-02_JPRB,.174E-01_JPRB,.175E-01_JPRB,.198E-01_JPRB,.263E-01_JPRB,.425E-01_JPRB,.463E-01_JPRB,&
&.236E-01_JPRB,.219E-01_JPRB,.197E-01_JPRB,.227E-01_JPRB,.269E-01_JPRB,.362E-01_JPRB,.394E-01_JPRB,&
&.362E-01_JPRB,.139E-01_JPRB,.110E-01_JPRB,.118E-01_JPRB,.727E-02_JPRB,.474E-02_JPRB,.434E-02_JPRB,&
&.639E-02_JPRB,.136E-01_JPRB,.220E-01_JPRB,.227E-01_JPRB,.488E-01_JPRB,.611E-01_JPRB,.540E-01_JPRB,&
&.409E-01_JPRB,.204E-01_JPRB,.275E-01_JPRB,.220E-01_JPRB,.185E-01_JPRB,.165E-01_JPRB,.149E-01_JPRB,&
&.137E-01_JPRB,.127E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 34 -42.0
ZAER (:,34,11) = (/&
&.115E-01_JPRB,.108E-01_JPRB,.105E-01_JPRB,.996E-02_JPRB,.954E-02_JPRB,.930E-02_JPRB,.882E-02_JPRB,&
&.850E-02_JPRB,.780E-02_JPRB,.776E-02_JPRB,.998E-02_JPRB,.122E-01_JPRB,.597E-02_JPRB,.731E-02_JPRB,&
&.103E-01_JPRB,.137E-01_JPRB,.186E-01_JPRB,.341E-01_JPRB,.530E-01_JPRB,.736E-01_JPRB,.592E-01_JPRB,&
&.447E-01_JPRB,.431E-01_JPRB,.299E-01_JPRB,.226E-01_JPRB,.146E-01_JPRB,.104E-01_JPRB,.826E-02_JPRB,&
&.769E-02_JPRB,.798E-02_JPRB,.827E-02_JPRB,.848E-02_JPRB,.878E-02_JPRB,.935E-02_JPRB,.121E-01_JPRB,&
&.124E-01_JPRB,.142E-01_JPRB,.216E-01_JPRB,.243E-01_JPRB,.354E-01_JPRB,.326E-01_JPRB,.430E-01_JPRB,&
&.503E-01_JPRB,.459E-01_JPRB,.207E-01_JPRB,.193E-01_JPRB,.451E-01_JPRB,.286E-01_JPRB,.291E-01_JPRB,&
&.456E-01_JPRB,.310E-01_JPRB,.175E-01_JPRB,.124E-01_JPRB,.148E-01_JPRB,.149E-01_JPRB,.114E-01_JPRB,&
&.128E-01_JPRB,.149E-01_JPRB,.163E-01_JPRB,.221E-01_JPRB,.305E-01_JPRB,.318E-01_JPRB,.401E-01_JPRB,&
&.528E-01_JPRB,.347E-01_JPRB,.312E-01_JPRB,.256E-01_JPRB,.194E-01_JPRB,.163E-01_JPRB,.150E-01_JPRB,&
&.137E-01_JPRB,.125E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 35 -46.0
ZAER (:,35,11) = (/&
&.123E-01_JPRB,.113E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.100E-01_JPRB,.946E-02_JPRB,.102E-01_JPRB,&
&.934E-02_JPRB,.876E-02_JPRB,.922E-02_JPRB,.117E-01_JPRB,.141E-01_JPRB,.823E-02_JPRB,.710E-02_JPRB,&
&.966E-02_JPRB,.140E-01_JPRB,.180E-01_JPRB,.291E-01_JPRB,.352E-01_JPRB,.415E-01_JPRB,.375E-01_JPRB,&
&.491E-01_JPRB,.317E-01_JPRB,.197E-01_JPRB,.192E-01_JPRB,.156E-01_JPRB,.117E-01_JPRB,.821E-02_JPRB,&
&.720E-02_JPRB,.720E-02_JPRB,.775E-02_JPRB,.817E-02_JPRB,.857E-02_JPRB,.100E-01_JPRB,.121E-01_JPRB,&
&.171E-01_JPRB,.114E-01_JPRB,.153E-01_JPRB,.198E-01_JPRB,.210E-01_JPRB,.343E-01_JPRB,.556E-01_JPRB,&
&.395E-01_JPRB,.343E-01_JPRB,.264E-01_JPRB,.250E-01_JPRB,.428E-01_JPRB,.323E-01_JPRB,.401E-01_JPRB,&
&.590E-01_JPRB,.647E-01_JPRB,.504E-01_JPRB,.309E-01_JPRB,.282E-01_JPRB,.209E-01_JPRB,.150E-01_JPRB,&
&.143E-01_JPRB,.176E-01_JPRB,.261E-01_JPRB,.321E-01_JPRB,.330E-01_JPRB,.317E-01_JPRB,.355E-01_JPRB,&
&.315E-01_JPRB,.444E-01_JPRB,.303E-01_JPRB,.234E-01_JPRB,.191E-01_JPRB,.168E-01_JPRB,.156E-01_JPRB,&
&.151E-01_JPRB,.129E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 36 -50.0
ZAER (:,36,11) = (/&
&.131E-01_JPRB,.116E-01_JPRB,.105E-01_JPRB,.101E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,&
&.114E-01_JPRB,.982E-02_JPRB,.979E-02_JPRB,.114E-01_JPRB,.789E-02_JPRB,.913E-02_JPRB,.771E-02_JPRB,&
&.124E-01_JPRB,.158E-01_JPRB,.193E-01_JPRB,.298E-01_JPRB,.342E-01_JPRB,.368E-01_JPRB,.314E-01_JPRB,&
&.367E-01_JPRB,.322E-01_JPRB,.220E-01_JPRB,.203E-01_JPRB,.143E-01_JPRB,.113E-01_JPRB,.945E-02_JPRB,&
&.782E-02_JPRB,.776E-02_JPRB,.801E-02_JPRB,.917E-02_JPRB,.104E-01_JPRB,.129E-01_JPRB,.184E-01_JPRB,&
&.238E-01_JPRB,.144E-01_JPRB,.210E-01_JPRB,.248E-01_JPRB,.280E-01_JPRB,.401E-01_JPRB,.561E-01_JPRB,&
&.400E-01_JPRB,.462E-01_JPRB,.388E-01_JPRB,.442E-01_JPRB,.354E-01_JPRB,.351E-01_JPRB,.470E-01_JPRB,&
&.575E-01_JPRB,.707E-01_JPRB,.737E-01_JPRB,.692E-01_JPRB,.448E-01_JPRB,.294E-01_JPRB,.268E-01_JPRB,&
&.257E-01_JPRB,.292E-01_JPRB,.314E-01_JPRB,.262E-01_JPRB,.256E-01_JPRB,.320E-01_JPRB,.275E-01_JPRB,&
&.241E-01_JPRB,.228E-01_JPRB,.238E-01_JPRB,.190E-01_JPRB,.175E-01_JPRB,.169E-01_JPRB,.155E-01_JPRB,&
&.159E-01_JPRB,.146E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 37 -54.0
ZAER (:,37,11) = (/&
&.139E-01_JPRB,.107E-01_JPRB,.950E-02_JPRB,.990E-02_JPRB,.117E-01_JPRB,.146E-01_JPRB,.152E-01_JPRB,&
&.146E-01_JPRB,.113E-01_JPRB,.107E-01_JPRB,.632E-02_JPRB,.676E-02_JPRB,.777E-02_JPRB,.767E-02_JPRB,&
&.108E-01_JPRB,.143E-01_JPRB,.132E-01_JPRB,.154E-01_JPRB,.226E-01_JPRB,.319E-01_JPRB,.382E-01_JPRB,&
&.209E-01_JPRB,.182E-01_JPRB,.139E-01_JPRB,.115E-01_JPRB,.126E-01_JPRB,.974E-02_JPRB,.832E-02_JPRB,&
&.750E-02_JPRB,.732E-02_JPRB,.802E-02_JPRB,.104E-01_JPRB,.140E-01_JPRB,.187E-01_JPRB,.283E-01_JPRB,&
&.184E-01_JPRB,.335E-01_JPRB,.429E-01_JPRB,.260E-01_JPRB,.357E-01_JPRB,.574E-01_JPRB,.506E-01_JPRB,&
&.394E-01_JPRB,.480E-01_JPRB,.438E-01_JPRB,.500E-01_JPRB,.427E-01_JPRB,.432E-01_JPRB,.429E-01_JPRB,&
&.485E-01_JPRB,.474E-01_JPRB,.525E-01_JPRB,.678E-01_JPRB,.577E-01_JPRB,.472E-01_JPRB,.435E-01_JPRB,&
&.413E-01_JPRB,.378E-01_JPRB,.299E-01_JPRB,.265E-01_JPRB,.312E-01_JPRB,.273E-01_JPRB,.224E-01_JPRB,&
&.213E-01_JPRB,.287E-01_JPRB,.209E-01_JPRB,.179E-01_JPRB,.180E-01_JPRB,.111E-01_JPRB,.169E-01_JPRB,&
&.149E-01_JPRB,.144E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 38 -58.0
ZAER (:,38,11) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.123E-01_JPRB,.125E-01_JPRB,.144E-01_JPRB,.219E-01_JPRB,.194E-01_JPRB,&
&.135E-01_JPRB,.981E-02_JPRB,.560E-02_JPRB,.519E-02_JPRB,.482E-02_JPRB,.596E-02_JPRB,.637E-02_JPRB,&
&.714E-02_JPRB,.107E-01_JPRB,.130E-01_JPRB,.170E-01_JPRB,.231E-01_JPRB,.276E-01_JPRB,.367E-01_JPRB,&
&.157E-01_JPRB,.143E-01_JPRB,.134E-01_JPRB,.158E-01_JPRB,.108E-01_JPRB,.869E-02_JPRB,.739E-02_JPRB,&
&.687E-02_JPRB,.699E-02_JPRB,.826E-02_JPRB,.106E-01_JPRB,.138E-01_JPRB,.190E-01_JPRB,.259E-01_JPRB,&
&.334E-01_JPRB,.329E-01_JPRB,.349E-01_JPRB,.199E-01_JPRB,.285E-01_JPRB,.559E-01_JPRB,.326E-01_JPRB,&
&.320E-01_JPRB,.408E-01_JPRB,.393E-01_JPRB,.450E-01_JPRB,.398E-01_JPRB,.387E-01_JPRB,.406E-01_JPRB,&
&.418E-01_JPRB,.378E-01_JPRB,.386E-01_JPRB,.464E-01_JPRB,.433E-01_JPRB,.510E-01_JPRB,.598E-01_JPRB,&
&.435E-01_JPRB,.381E-01_JPRB,.341E-01_JPRB,.330E-01_JPRB,.307E-01_JPRB,.240E-01_JPRB,.220E-01_JPRB,&
&.179E-01_JPRB,.113E-01_JPRB,.195E-01_JPRB,.193E-01_JPRB,.183E-01_JPRB,.106E-01_JPRB,.164E-01_JPRB,&
&.146E-01_JPRB,.144E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 39 -62.0
ZAER (:,39,11) = (/&
&.147E-01_JPRB,.147E-01_JPRB,.152E-01_JPRB,.157E-01_JPRB,.910E-02_JPRB,.110E-01_JPRB,.104E-01_JPRB,&
&.703E-02_JPRB,.569E-02_JPRB,.564E-02_JPRB,.542E-02_JPRB,.574E-02_JPRB,.654E-02_JPRB,.690E-02_JPRB,&
&.773E-02_JPRB,.103E-01_JPRB,.128E-01_JPRB,.132E-01_JPRB,.198E-01_JPRB,.245E-01_JPRB,.273E-01_JPRB,&
&.131E-01_JPRB,.236E-01_JPRB,.245E-01_JPRB,.180E-01_JPRB,.146E-01_JPRB,.895E-02_JPRB,.408E-02_JPRB,&
&.899E-02_JPRB,.103E-01_JPRB,.116E-01_JPRB,.141E-01_JPRB,.168E-01_JPRB,.187E-01_JPRB,.220E-01_JPRB,&
&.220E-01_JPRB,.226E-01_JPRB,.265E-01_JPRB,.155E-01_JPRB,.164E-01_JPRB,.268E-01_JPRB,.178E-01_JPRB,&
&.174E-01_JPRB,.220E-01_JPRB,.239E-01_JPRB,.272E-01_JPRB,.287E-01_JPRB,.327E-01_JPRB,.369E-01_JPRB,&
&.371E-01_JPRB,.347E-01_JPRB,.307E-01_JPRB,.329E-01_JPRB,.385E-01_JPRB,.375E-01_JPRB,.401E-01_JPRB,&
&.367E-01_JPRB,.358E-01_JPRB,.326E-01_JPRB,.325E-01_JPRB,.332E-01_JPRB,.314E-01_JPRB,.256E-01_JPRB,&
&.138E-01_JPRB,.840E-02_JPRB,.809E-02_JPRB,.820E-02_JPRB,.770E-02_JPRB,.835E-02_JPRB,.880E-02_JPRB,&
&.885E-02_JPRB,.150E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 40 -66.0
ZAER (:,40,11) = (/&
&.109E-01_JPRB,.105E-01_JPRB,.168E-01_JPRB,.171E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,.986E-02_JPRB,&
&.880E-02_JPRB,.753E-02_JPRB,.680E-02_JPRB,.713E-02_JPRB,.842E-02_JPRB,.897E-02_JPRB,.975E-02_JPRB,&
&.111E-01_JPRB,.148E-01_JPRB,.141E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.151E-01_JPRB,.215E-01_JPRB,&
&.115E-01_JPRB,.128E-01_JPRB,.142E-01_JPRB,.190E-01_JPRB,.163E-01_JPRB,.548E-02_JPRB,.444E-02_JPRB,&
&.573E-02_JPRB,.121E-01_JPRB,.137E-01_JPRB,.138E-01_JPRB,.136E-01_JPRB,.125E-01_JPRB,.146E-01_JPRB,&
&.174E-01_JPRB,.207E-01_JPRB,.210E-01_JPRB,.204E-01_JPRB,.116E-01_JPRB,.128E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.182E-01_JPRB,.189E-01_JPRB,.223E-01_JPRB,.268E-01_JPRB,.271E-01_JPRB,.245E-01_JPRB,&
&.251E-01_JPRB,.285E-01_JPRB,.305E-01_JPRB,.289E-01_JPRB,.291E-01_JPRB,.302E-01_JPRB,.361E-01_JPRB,&
&.392E-01_JPRB,.389E-01_JPRB,.347E-01_JPRB,.334E-01_JPRB,.336E-01_JPRB,.280E-01_JPRB,.225E-01_JPRB,&
&.212E-01_JPRB,.141E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,.106E-01_JPRB,&
&.110E-01_JPRB,.110E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 41 -70.0
ZAER (:,41,11) = (/&
&.234E-01_JPRB,.212E-01_JPRB,.209E-01_JPRB,.198E-01_JPRB,.110E-01_JPRB,.103E-01_JPRB,.990E-02_JPRB,&
&.962E-02_JPRB,.166E-01_JPRB,.172E-01_JPRB,.108E-01_JPRB,.182E-01_JPRB,.184E-01_JPRB,.119E-01_JPRB,&
&.129E-01_JPRB,.126E-01_JPRB,.188E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.138E-01_JPRB,.131E-01_JPRB,&
&.110E-01_JPRB,.124E-01_JPRB,.236E-01_JPRB,.186E-01_JPRB,.156E-01_JPRB,.756E-02_JPRB,.579E-02_JPRB,&
&.580E-02_JPRB,.556E-02_JPRB,.586E-02_JPRB,.739E-02_JPRB,.150E-01_JPRB,.140E-01_JPRB,.135E-01_JPRB,&
&.153E-01_JPRB,.173E-01_JPRB,.187E-01_JPRB,.184E-01_JPRB,.178E-01_JPRB,.184E-01_JPRB,.118E-01_JPRB,&
&.119E-01_JPRB,.198E-01_JPRB,.228E-01_JPRB,.257E-01_JPRB,.280E-01_JPRB,.286E-01_JPRB,.294E-01_JPRB,&
&.301E-01_JPRB,.193E-01_JPRB,.261E-01_JPRB,.264E-01_JPRB,.264E-01_JPRB,.231E-01_JPRB,.241E-01_JPRB,&
&.247E-01_JPRB,.262E-01_JPRB,.302E-01_JPRB,.353E-01_JPRB,.343E-01_JPRB,.306E-01_JPRB,.295E-01_JPRB,&
&.265E-01_JPRB,.197E-01_JPRB,.138E-01_JPRB,.130E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,.141E-01_JPRB,&
&.248E-01_JPRB,.152E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 42 -74.0
ZAER (:,42,11) = (/&
&.239E-01_JPRB,.232E-01_JPRB,.231E-01_JPRB,.224E-01_JPRB,.216E-01_JPRB,.218E-01_JPRB,.223E-01_JPRB,&
&.220E-01_JPRB,.214E-01_JPRB,.204E-01_JPRB,.201E-01_JPRB,.194E-01_JPRB,.118E-01_JPRB,.115E-01_JPRB,&
&.191E-01_JPRB,.187E-01_JPRB,.184E-01_JPRB,.183E-01_JPRB,.173E-01_JPRB,.120E-01_JPRB,.221E-01_JPRB,&
&.220E-01_JPRB,.214E-01_JPRB,.215E-01_JPRB,.175E-01_JPRB,.969E-02_JPRB,.815E-02_JPRB,.644E-02_JPRB,&
&.534E-02_JPRB,.474E-02_JPRB,.484E-02_JPRB,.559E-02_JPRB,.121E-01_JPRB,.132E-01_JPRB,.137E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB,.153E-01_JPRB,.160E-01_JPRB,.168E-01_JPRB,.174E-01_JPRB,.176E-01_JPRB,&
&.185E-01_JPRB,.209E-01_JPRB,.236E-01_JPRB,.269E-01_JPRB,.296E-01_JPRB,.327E-01_JPRB,.319E-01_JPRB,&
&.286E-01_JPRB,.313E-01_JPRB,.380E-01_JPRB,.462E-01_JPRB,.269E-01_JPRB,.250E-01_JPRB,.255E-01_JPRB,&
&.244E-01_JPRB,.236E-01_JPRB,.336E-01_JPRB,.391E-01_JPRB,.610E-01_JPRB,.558E-01_JPRB,.511E-01_JPRB,&
&.441E-01_JPRB,.368E-01_JPRB,.307E-01_JPRB,.278E-01_JPRB,.269E-01_JPRB,.264E-01_JPRB,.260E-01_JPRB,&
&.265E-01_JPRB,.257E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 43 -78.0
ZAER (:,43,11) = (/&
&.273E-01_JPRB,.260E-01_JPRB,.254E-01_JPRB,.241E-01_JPRB,.227E-01_JPRB,.218E-01_JPRB,.213E-01_JPRB,&
&.207E-01_JPRB,.199E-01_JPRB,.193E-01_JPRB,.191E-01_JPRB,.192E-01_JPRB,.199E-01_JPRB,.198E-01_JPRB,&
&.200E-01_JPRB,.201E-01_JPRB,.186E-01_JPRB,.171E-01_JPRB,.960E-02_JPRB,.103E-01_JPRB,.110E-01_JPRB,&
&.201E-01_JPRB,.202E-01_JPRB,.122E-01_JPRB,.939E-02_JPRB,.820E-02_JPRB,.779E-02_JPRB,.681E-02_JPRB,&
&.650E-02_JPRB,.632E-02_JPRB,.671E-02_JPRB,.666E-02_JPRB,.113E-01_JPRB,.143E-01_JPRB,.149E-01_JPRB,&
&.156E-01_JPRB,.160E-01_JPRB,.168E-01_JPRB,.185E-01_JPRB,.125E-01_JPRB,.231E-01_JPRB,.245E-01_JPRB,&
&.249E-01_JPRB,.262E-01_JPRB,.281E-01_JPRB,.317E-01_JPRB,.358E-01_JPRB,.403E-01_JPRB,.423E-01_JPRB,&
&.416E-01_JPRB,.428E-01_JPRB,.439E-01_JPRB,.425E-01_JPRB,.407E-01_JPRB,.365E-01_JPRB,.358E-01_JPRB,&
&.391E-01_JPRB,.275E-01_JPRB,.474E-01_JPRB,.470E-01_JPRB,.454E-01_JPRB,.412E-01_JPRB,.400E-01_JPRB,&
&.388E-01_JPRB,.340E-01_JPRB,.324E-01_JPRB,.309E-01_JPRB,.293E-01_JPRB,.293E-01_JPRB,.305E-01_JPRB,&
&.303E-01_JPRB,.289E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 44 -82.0
ZAER (:,44,11) = (/&
&.250E-01_JPRB,.237E-01_JPRB,.226E-01_JPRB,.219E-01_JPRB,.214E-01_JPRB,.211E-01_JPRB,.206E-01_JPRB,&
&.200E-01_JPRB,.201E-01_JPRB,.199E-01_JPRB,.201E-01_JPRB,.204E-01_JPRB,.209E-01_JPRB,.208E-01_JPRB,&
&.206E-01_JPRB,.200E-01_JPRB,.191E-01_JPRB,.185E-01_JPRB,.176E-01_JPRB,.171E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,.110E-01_JPRB,.104E-01_JPRB,.101E-01_JPRB,.962E-02_JPRB,&
&.920E-02_JPRB,.886E-02_JPRB,.877E-02_JPRB,.879E-02_JPRB,.885E-02_JPRB,.148E-01_JPRB,.151E-01_JPRB,&
&.155E-01_JPRB,.173E-01_JPRB,.192E-01_JPRB,.208E-01_JPRB,.226E-01_JPRB,.246E-01_JPRB,.265E-01_JPRB,&
&.265E-01_JPRB,.279E-01_JPRB,.292E-01_JPRB,.303E-01_JPRB,.319E-01_JPRB,.329E-01_JPRB,.321E-01_JPRB,&
&.320E-01_JPRB,.325E-01_JPRB,.326E-01_JPRB,.331E-01_JPRB,.336E-01_JPRB,.338E-01_JPRB,.348E-01_JPRB,&
&.353E-01_JPRB,.356E-01_JPRB,.354E-01_JPRB,.355E-01_JPRB,.340E-01_JPRB,.336E-01_JPRB,.334E-01_JPRB,&
&.325E-01_JPRB,.325E-01_JPRB,.320E-01_JPRB,.312E-01_JPRB,.296E-01_JPRB,.284E-01_JPRB,.274E-01_JPRB,&
&.266E-01_JPRB,.261E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 45 -86.0
ZAER (:,45,11) = (/&
&.181E-01_JPRB,.177E-01_JPRB,.171E-01_JPRB,.167E-01_JPRB,.165E-01_JPRB,.162E-01_JPRB,.159E-01_JPRB,&
&.160E-01_JPRB,.160E-01_JPRB,.161E-01_JPRB,.163E-01_JPRB,.166E-01_JPRB,.157E-01_JPRB,.155E-01_JPRB,&
&.152E-01_JPRB,.151E-01_JPRB,.150E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.149E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.152E-01_JPRB,.154E-01_JPRB,.163E-01_JPRB,.161E-01_JPRB,.159E-01_JPRB,.162E-01_JPRB,&
&.163E-01_JPRB,.163E-01_JPRB,.165E-01_JPRB,.169E-01_JPRB,.172E-01_JPRB,.176E-01_JPRB,.179E-01_JPRB,&
&.184E-01_JPRB,.190E-01_JPRB,.195E-01_JPRB,.204E-01_JPRB,.214E-01_JPRB,.222E-01_JPRB,.234E-01_JPRB,&
&.242E-01_JPRB,.249E-01_JPRB,.259E-01_JPRB,.267E-01_JPRB,.276E-01_JPRB,.278E-01_JPRB,.278E-01_JPRB,&
&.279E-01_JPRB,.281E-01_JPRB,.282E-01_JPRB,.280E-01_JPRB,.280E-01_JPRB,.278E-01_JPRB,.277E-01_JPRB,&
&.274E-01_JPRB,.273E-01_JPRB,.271E-01_JPRB,.265E-01_JPRB,.258E-01_JPRB,.258E-01_JPRB,.259E-01_JPRB,&
&.255E-01_JPRB,.256E-01_JPRB,.250E-01_JPRB,.243E-01_JPRB,.235E-01_JPRB,.228E-01_JPRB,.219E-01_JPRB,&
&.208E-01_JPRB,.199E-01_JPRB/)
!-- Total Sulfate Aerosol    month: 11 --- lat: 46 -90.0
ZAER (:,46,11) = (/&
&.198E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,&
&.207E-01_JPRB,.207E-01_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=11  
  DO JI=1,46
    DO JL=1,72
      RAERSU(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SULFATE AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESU_11
