SUBROUTINE SUECAESS_12

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      December

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,12:12)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month: 12 --- lat:  1  90.0
ZAER (:, 1,12) = (/&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  2  86.0
ZAER (:, 2,12) = (/&
&.248E-03_JPRB,.248E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,.324E-03_JPRB,&
&.324E-03_JPRB,.358E-03_JPRB,.358E-03_JPRB,.368E-03_JPRB,.368E-03_JPRB,.381E-03_JPRB,.381E-03_JPRB,&
&.388E-03_JPRB,.388E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,&
&.394E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,&
&.285E-03_JPRB,.285E-03_JPRB,.250E-03_JPRB,.250E-03_JPRB,.212E-03_JPRB,.212E-03_JPRB,.165E-03_JPRB,&
&.165E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,.176E-03_JPRB,.176E-03_JPRB,.185E-03_JPRB,.185E-03_JPRB,&
&.189E-03_JPRB,.189E-03_JPRB,.182E-03_JPRB,.182E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.183E-03_JPRB,&
&.183E-03_JPRB,.181E-03_JPRB,.181E-03_JPRB,.171E-03_JPRB,.171E-03_JPRB,.160E-03_JPRB,.160E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.152E-03_JPRB,.152E-03_JPRB,.162E-03_JPRB,&
&.162E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.198E-03_JPRB,.198E-03_JPRB,.230E-03_JPRB,.230E-03_JPRB,&
&.264E-03_JPRB,.264E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  3  82.0
ZAER (:, 3,12) = (/&
&.248E-03_JPRB,.248E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,.324E-03_JPRB,&
&.324E-03_JPRB,.358E-03_JPRB,.358E-03_JPRB,.368E-03_JPRB,.368E-03_JPRB,.381E-03_JPRB,.381E-03_JPRB,&
&.388E-03_JPRB,.388E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,&
&.394E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,&
&.285E-03_JPRB,.285E-03_JPRB,.250E-03_JPRB,.250E-03_JPRB,.212E-03_JPRB,.212E-03_JPRB,.165E-03_JPRB,&
&.165E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,.176E-03_JPRB,.176E-03_JPRB,.185E-03_JPRB,.185E-03_JPRB,&
&.189E-03_JPRB,.189E-03_JPRB,.182E-03_JPRB,.182E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.183E-03_JPRB,&
&.183E-03_JPRB,.181E-03_JPRB,.181E-03_JPRB,.171E-03_JPRB,.171E-03_JPRB,.160E-03_JPRB,.160E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.152E-03_JPRB,.152E-03_JPRB,.162E-03_JPRB,&
&.162E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.198E-03_JPRB,.198E-03_JPRB,.230E-03_JPRB,.230E-03_JPRB,&
&.264E-03_JPRB,.264E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  4  78.0
ZAER (:, 4,12) = (/&
&.535E-03_JPRB,.535E-03_JPRB,.437E-03_JPRB,.437E-03_JPRB,.368E-03_JPRB,.368E-03_JPRB,.406E-03_JPRB,&
&.406E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.528E-03_JPRB,.528E-03_JPRB,&
&.613E-03_JPRB,.613E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.627E-03_JPRB,.627E-03_JPRB,.641E-03_JPRB,&
&.641E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,&
&.332E-03_JPRB,.332E-03_JPRB,.390E-03_JPRB,.390E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.378E-03_JPRB,&
&.378E-03_JPRB,.228E-03_JPRB,.228E-03_JPRB,.205E-03_JPRB,.205E-03_JPRB,.279E-03_JPRB,.279E-03_JPRB,&
&.344E-03_JPRB,.344E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.397E-03_JPRB,&
&.397E-03_JPRB,.314E-03_JPRB,.314E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.147E-03_JPRB,.147E-03_JPRB,&
&.125E-03_JPRB,.125E-03_JPRB,.161E-03_JPRB,.161E-03_JPRB,.206E-03_JPRB,.206E-03_JPRB,.216E-03_JPRB,&
&.216E-03_JPRB,.263E-03_JPRB,.263E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.393E-03_JPRB,.393E-03_JPRB,&
&.584E-03_JPRB,.584E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  5  74.0
ZAER (:, 5,12) = (/&
&.535E-03_JPRB,.535E-03_JPRB,.437E-03_JPRB,.437E-03_JPRB,.368E-03_JPRB,.368E-03_JPRB,.406E-03_JPRB,&
&.406E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.528E-03_JPRB,.528E-03_JPRB,&
&.613E-03_JPRB,.613E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.627E-03_JPRB,.627E-03_JPRB,.641E-03_JPRB,&
&.641E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,&
&.332E-03_JPRB,.332E-03_JPRB,.390E-03_JPRB,.390E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.378E-03_JPRB,&
&.378E-03_JPRB,.228E-03_JPRB,.228E-03_JPRB,.205E-03_JPRB,.205E-03_JPRB,.279E-03_JPRB,.279E-03_JPRB,&
&.344E-03_JPRB,.344E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.397E-03_JPRB,&
&.397E-03_JPRB,.314E-03_JPRB,.314E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.147E-03_JPRB,.147E-03_JPRB,&
&.125E-03_JPRB,.125E-03_JPRB,.161E-03_JPRB,.161E-03_JPRB,.206E-03_JPRB,.206E-03_JPRB,.216E-03_JPRB,&
&.216E-03_JPRB,.263E-03_JPRB,.263E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.393E-03_JPRB,.393E-03_JPRB,&
&.584E-03_JPRB,.584E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  6  70.0
ZAER (:, 6,12) = (/&
&.314E-02_JPRB,.314E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.797E-03_JPRB,.797E-03_JPRB,.163E-02_JPRB,&
&.163E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,&
&.261E-02_JPRB,.261E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.240E-02_JPRB,&
&.240E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.921E-03_JPRB,.921E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,&
&.685E-03_JPRB,.685E-03_JPRB,.819E-03_JPRB,.819E-03_JPRB,.204E-02_JPRB,.204E-02_JPRB,.184E-02_JPRB,&
&.184E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.847E-03_JPRB,.847E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,&
&.562E-03_JPRB,.562E-03_JPRB,.993E-03_JPRB,.993E-03_JPRB,.172E-02_JPRB,.172E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,&
&.321E-02_JPRB,.321E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  7  66.0
ZAER (:, 7,12) = (/&
&.314E-02_JPRB,.314E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.797E-03_JPRB,.797E-03_JPRB,.163E-02_JPRB,&
&.163E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,&
&.261E-02_JPRB,.261E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.240E-02_JPRB,&
&.240E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.921E-03_JPRB,.921E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,&
&.685E-03_JPRB,.685E-03_JPRB,.819E-03_JPRB,.819E-03_JPRB,.204E-02_JPRB,.204E-02_JPRB,.184E-02_JPRB,&
&.184E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.847E-03_JPRB,.847E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,&
&.562E-03_JPRB,.562E-03_JPRB,.993E-03_JPRB,.993E-03_JPRB,.172E-02_JPRB,.172E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,&
&.321E-02_JPRB,.321E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  8  62.0
ZAER (:, 8,12) = (/&
&.794E-02_JPRB,.794E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.587E-02_JPRB,.587E-02_JPRB,.582E-02_JPRB,&
&.582E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.638E-02_JPRB,.638E-02_JPRB,&
&.663E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,&
&.431E-02_JPRB,.431E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,.471E-02_JPRB,&
&.471E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.465E-02_JPRB,.465E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.502E-02_JPRB,.502E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.459E-02_JPRB,.459E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.540E-02_JPRB,&
&.540E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,&
&.815E-02_JPRB,.815E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  9  58.0
ZAER (:, 9,12) = (/&
&.794E-02_JPRB,.794E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.587E-02_JPRB,.587E-02_JPRB,.582E-02_JPRB,&
&.582E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.638E-02_JPRB,.638E-02_JPRB,&
&.663E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,&
&.431E-02_JPRB,.431E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,.471E-02_JPRB,&
&.471E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.465E-02_JPRB,.465E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.502E-02_JPRB,.502E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.459E-02_JPRB,.459E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.540E-02_JPRB,&
&.540E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,&
&.815E-02_JPRB,.815E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 10  54.0
ZAER (:,10,12) = (/&
&.975E-02_JPRB,.975E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.805E-02_JPRB,&
&.805E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,&
&.751E-02_JPRB,.751E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.648E-02_JPRB,&
&.648E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,&
&.711E-02_JPRB,.711E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.800E-02_JPRB,&
&.800E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,&
&.679E-02_JPRB,.679E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 11  50.0
ZAER (:,11,12) = (/&
&.975E-02_JPRB,.975E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.805E-02_JPRB,&
&.805E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,&
&.751E-02_JPRB,.751E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.648E-02_JPRB,&
&.648E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,&
&.711E-02_JPRB,.711E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.800E-02_JPRB,&
&.800E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,&
&.679E-02_JPRB,.679E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 12  46.0
ZAER (:,12,12) = (/&
&.702E-02_JPRB,.702E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.692E-02_JPRB,&
&.692E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.596E-02_JPRB,.596E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.656E-02_JPRB,.656E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,&
&.884E-02_JPRB,.884E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.911E-02_JPRB,&
&.911E-02_JPRB,.891E-02_JPRB,.891E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,&
&.710E-02_JPRB,.710E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,&
&.783E-02_JPRB,.783E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.786E-02_JPRB,&
&.786E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,&
&.655E-02_JPRB,.655E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 13  42.0
ZAER (:,13,12) = (/&
&.702E-02_JPRB,.702E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.692E-02_JPRB,&
&.692E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.596E-02_JPRB,.596E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.656E-02_JPRB,.656E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,&
&.884E-02_JPRB,.884E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.911E-02_JPRB,&
&.911E-02_JPRB,.891E-02_JPRB,.891E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,&
&.710E-02_JPRB,.710E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,&
&.783E-02_JPRB,.783E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.786E-02_JPRB,&
&.786E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,&
&.655E-02_JPRB,.655E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 14  38.0
ZAER (:,14,12) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.699E-02_JPRB,&
&.699E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,.620E-02_JPRB,.620E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,&
&.785E-02_JPRB,.785E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,&
&.694E-02_JPRB,.694E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.764E-02_JPRB,&
&.764E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.699E-02_JPRB,.699E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,&
&.660E-02_JPRB,.660E-02_JPRB,.614E-02_JPRB,.614E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.501E-02_JPRB,.501E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,&
&.569E-02_JPRB,.569E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 15  34.0
ZAER (:,15,12) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.699E-02_JPRB,&
&.699E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,.620E-02_JPRB,.620E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,&
&.785E-02_JPRB,.785E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,&
&.694E-02_JPRB,.694E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.764E-02_JPRB,&
&.764E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.699E-02_JPRB,.699E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,&
&.660E-02_JPRB,.660E-02_JPRB,.614E-02_JPRB,.614E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.501E-02_JPRB,.501E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,&
&.569E-02_JPRB,.569E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 16  30.0
ZAER (:,16,12) = (/&
&.826E-02_JPRB,.826E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.736E-02_JPRB,&
&.736E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,&
&.908E-02_JPRB,.908E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.647E-02_JPRB,&
&.647E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,&
&.679E-02_JPRB,.679E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.713E-02_JPRB,&
&.713E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,&
&.411E-02_JPRB,.411E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.833E-02_JPRB,&
&.833E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,&
&.774E-02_JPRB,.774E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.258E-02_JPRB,&
&.258E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.639E-02_JPRB,.639E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 17  26.0
ZAER (:,17,12) = (/&
&.826E-02_JPRB,.826E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.736E-02_JPRB,&
&.736E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,&
&.908E-02_JPRB,.908E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.647E-02_JPRB,&
&.647E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,&
&.679E-02_JPRB,.679E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.713E-02_JPRB,&
&.713E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,&
&.411E-02_JPRB,.411E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.833E-02_JPRB,&
&.833E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,&
&.774E-02_JPRB,.774E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.258E-02_JPRB,&
&.258E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.639E-02_JPRB,.639E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 18  22.0
ZAER (:,18,12) = (/&
&.973E-02_JPRB,.973E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.806E-02_JPRB,&
&.806E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.544E-02_JPRB,&
&.544E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.938E-03_JPRB,.938E-03_JPRB,.859E-03_JPRB,.859E-03_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.652E-02_JPRB,&
&.652E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.169E-02_JPRB,.169E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.851E-02_JPRB,.851E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,.309E-02_JPRB,&
&.309E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.812E-02_JPRB,.812E-02_JPRB,&
&.969E-02_JPRB,.969E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 19  18.0
ZAER (:,19,12) = (/&
&.973E-02_JPRB,.973E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.806E-02_JPRB,&
&.806E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.544E-02_JPRB,&
&.544E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.938E-03_JPRB,.938E-03_JPRB,.859E-03_JPRB,.859E-03_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.652E-02_JPRB,&
&.652E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.169E-02_JPRB,.169E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.851E-02_JPRB,.851E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,.309E-02_JPRB,&
&.309E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.812E-02_JPRB,.812E-02_JPRB,&
&.969E-02_JPRB,.969E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 20  14.0
ZAER (:,20,12) = (/&
&.802E-02_JPRB,.802E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.978E-02_JPRB,.978E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.254E-02_JPRB,&
&.254E-02_JPRB,.400E-03_JPRB,.400E-03_JPRB,.316E-03_JPRB,.316E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.525E-02_JPRB,.525E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.834E-02_JPRB,.834E-02_JPRB,.580E-02_JPRB,&
&.580E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.596E-03_JPRB,.596E-03_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,.841E-02_JPRB,&
&.841E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.940E-02_JPRB,.940E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.876E-02_JPRB,.876E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.780E-02_JPRB,.780E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 21  10.0
ZAER (:,21,12) = (/&
&.802E-02_JPRB,.802E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.978E-02_JPRB,.978E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.254E-02_JPRB,&
&.254E-02_JPRB,.400E-03_JPRB,.400E-03_JPRB,.316E-03_JPRB,.316E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.525E-02_JPRB,.525E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.834E-02_JPRB,.834E-02_JPRB,.580E-02_JPRB,&
&.580E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.596E-03_JPRB,.596E-03_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,.841E-02_JPRB,&
&.841E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.940E-02_JPRB,.940E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.876E-02_JPRB,.876E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.780E-02_JPRB,.780E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 22   6.0
ZAER (:,22,12) = (/&
&.822E-02_JPRB,.822E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.127E-01_JPRB,.127E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.771E-02_JPRB,.771E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.392E-03_JPRB,.392E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.869E-02_JPRB,.869E-02_JPRB,.578E-02_JPRB,&
&.578E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.387E-02_JPRB,.387E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.745E-02_JPRB,.745E-02_JPRB,.730E-02_JPRB,&
&.730E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.518E-02_JPRB,.518E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,&
&.459E-02_JPRB,.459E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.459E-02_JPRB,&
&.459E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 23   2.0
ZAER (:,23,12) = (/&
&.822E-02_JPRB,.822E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.127E-01_JPRB,.127E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.771E-02_JPRB,.771E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.392E-03_JPRB,.392E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.869E-02_JPRB,.869E-02_JPRB,.578E-02_JPRB,&
&.578E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.387E-02_JPRB,.387E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.745E-02_JPRB,.745E-02_JPRB,.730E-02_JPRB,&
&.730E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.518E-02_JPRB,.518E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,&
&.459E-02_JPRB,.459E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.459E-02_JPRB,&
&.459E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 24  -2.0
ZAER (:,24,12) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.151E-01_JPRB,&
&.151E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.923E-02_JPRB,.923E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.375E-02_JPRB,&
&.375E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,.512E-02_JPRB,.512E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.856E-02_JPRB,.856E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,&
&.487E-02_JPRB,.487E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.966E-02_JPRB,&
&.966E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.679E-02_JPRB,.679E-02_JPRB,.701E-02_JPRB,.701E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.952E-02_JPRB,.952E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 25  -6.0
ZAER (:,25,12) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.151E-01_JPRB,&
&.151E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.923E-02_JPRB,.923E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.375E-02_JPRB,&
&.375E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,.512E-02_JPRB,.512E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.856E-02_JPRB,.856E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,&
&.487E-02_JPRB,.487E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.966E-02_JPRB,&
&.966E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.679E-02_JPRB,.679E-02_JPRB,.701E-02_JPRB,.701E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.952E-02_JPRB,.952E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 26 -10.0
ZAER (:,26,12) = (/&
&.151E-01_JPRB,.151E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.166E-01_JPRB,.166E-01_JPRB,.155E-01_JPRB,&
&.155E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.805E-02_JPRB,.805E-02_JPRB,.991E-02_JPRB,&
&.991E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.165E-01_JPRB,.165E-01_JPRB,&
&.165E-01_JPRB,.165E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.896E-02_JPRB,.896E-02_JPRB,.474E-02_JPRB,&
&.474E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,&
&.375E-02_JPRB,.375E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.907E-02_JPRB,.907E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.938E-02_JPRB,.938E-02_JPRB,&
&.941E-02_JPRB,.941E-02_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.143E-01_JPRB,.143E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 27 -14.0
ZAER (:,27,12) = (/&
&.151E-01_JPRB,.151E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.166E-01_JPRB,.166E-01_JPRB,.155E-01_JPRB,&
&.155E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.805E-02_JPRB,.805E-02_JPRB,.991E-02_JPRB,&
&.991E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.165E-01_JPRB,.165E-01_JPRB,&
&.165E-01_JPRB,.165E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.896E-02_JPRB,.896E-02_JPRB,.474E-02_JPRB,&
&.474E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,&
&.375E-02_JPRB,.375E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.907E-02_JPRB,.907E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.938E-02_JPRB,.938E-02_JPRB,&
&.941E-02_JPRB,.941E-02_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.143E-01_JPRB,.143E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 28 -18.0
ZAER (:,28,12) = (/&
&.134E-01_JPRB,.134E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.981E-02_JPRB,.981E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,&
&.153E-01_JPRB,.153E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.927E-02_JPRB,.927E-02_JPRB,.614E-02_JPRB,&
&.614E-02_JPRB,.523E-02_JPRB,.523E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,&
&.340E-02_JPRB,.340E-02_JPRB,.362E-02_JPRB,.362E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.739E-02_JPRB,&
&.739E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.619E-02_JPRB,.619E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.182E-01_JPRB,&
&.182E-01_JPRB,.185E-01_JPRB,.185E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 29 -22.0
ZAER (:,29,12) = (/&
&.134E-01_JPRB,.134E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.981E-02_JPRB,.981E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,&
&.153E-01_JPRB,.153E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.927E-02_JPRB,.927E-02_JPRB,.614E-02_JPRB,&
&.614E-02_JPRB,.523E-02_JPRB,.523E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,&
&.340E-02_JPRB,.340E-02_JPRB,.362E-02_JPRB,.362E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.739E-02_JPRB,&
&.739E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.619E-02_JPRB,.619E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.182E-01_JPRB,&
&.182E-01_JPRB,.185E-01_JPRB,.185E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 30 -26.0
ZAER (:,30,12) = (/&
&.126E-01_JPRB,.126E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.983E-02_JPRB,.983E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,&
&.543E-02_JPRB,.543E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.587E-02_JPRB,&
&.587E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.452E-02_JPRB,.452E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,&
&.382E-02_JPRB,.382E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.302E-02_JPRB,&
&.302E-02_JPRB,.289E-02_JPRB,.289E-02_JPRB,.256E-02_JPRB,.256E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 31 -30.0
ZAER (:,31,12) = (/&
&.126E-01_JPRB,.126E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.983E-02_JPRB,.983E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,&
&.543E-02_JPRB,.543E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.587E-02_JPRB,&
&.587E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.452E-02_JPRB,.452E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,&
&.382E-02_JPRB,.382E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.302E-02_JPRB,&
&.302E-02_JPRB,.289E-02_JPRB,.289E-02_JPRB,.256E-02_JPRB,.256E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 32 -34.0
ZAER (:,32,12) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.976E-02_JPRB,.976E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,&
&.365E-02_JPRB,.365E-02_JPRB,.330E-02_JPRB,.330E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.670E-02_JPRB,&
&.670E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.207E-02_JPRB,&
&.207E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.905E-03_JPRB,.905E-03_JPRB,.933E-03_JPRB,.933E-03_JPRB,.289E-02_JPRB,.289E-02_JPRB,.492E-02_JPRB,&
&.492E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.152E-01_JPRB,.152E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 33 -38.0
ZAER (:,33,12) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.976E-02_JPRB,.976E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,&
&.365E-02_JPRB,.365E-02_JPRB,.330E-02_JPRB,.330E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.670E-02_JPRB,&
&.670E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.207E-02_JPRB,&
&.207E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.905E-03_JPRB,.905E-03_JPRB,.933E-03_JPRB,.933E-03_JPRB,.289E-02_JPRB,.289E-02_JPRB,.492E-02_JPRB,&
&.492E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.152E-01_JPRB,.152E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 34 -42.0
ZAER (:,34,12) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.980E-02_JPRB,.980E-02_JPRB,.569E-02_JPRB,.569E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.170E-02_JPRB,&
&.170E-02_JPRB,.403E-02_JPRB,.403E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.549E-02_JPRB,.549E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.345E-02_JPRB,.345E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.222E-02_JPRB,.222E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.773E-03_JPRB,.773E-03_JPRB,.739E-03_JPRB,.739E-03_JPRB,.181E-02_JPRB,&
&.181E-02_JPRB,.325E-02_JPRB,.325E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.151E-01_JPRB,.151E-01_JPRB,&
&.164E-01_JPRB,.164E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 35 -46.0
ZAER (:,35,12) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.980E-02_JPRB,.980E-02_JPRB,.569E-02_JPRB,.569E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.170E-02_JPRB,&
&.170E-02_JPRB,.403E-02_JPRB,.403E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.549E-02_JPRB,.549E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.345E-02_JPRB,.345E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.222E-02_JPRB,.222E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.773E-03_JPRB,.773E-03_JPRB,.739E-03_JPRB,.739E-03_JPRB,.181E-02_JPRB,&
&.181E-02_JPRB,.325E-02_JPRB,.325E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.151E-01_JPRB,.151E-01_JPRB,&
&.164E-01_JPRB,.164E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 36 -50.0
ZAER (:,36,12) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.971E-02_JPRB,.971E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.967E-02_JPRB,&
&.967E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,&
&.247E-02_JPRB,.247E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.148E-01_JPRB,.148E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.732E-02_JPRB,.732E-02_JPRB,.461E-02_JPRB,.461E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,&
&.224E-02_JPRB,.224E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.132E-02_JPRB,&
&.132E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.965E-03_JPRB,.965E-03_JPRB,&
&.882E-03_JPRB,.882E-03_JPRB,.745E-03_JPRB,.745E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,.656E-03_JPRB,&
&.656E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 37 -54.0
ZAER (:,37,12) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.971E-02_JPRB,.971E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.967E-02_JPRB,&
&.967E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,&
&.247E-02_JPRB,.247E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.148E-01_JPRB,.148E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.732E-02_JPRB,.732E-02_JPRB,.461E-02_JPRB,.461E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,&
&.224E-02_JPRB,.224E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.132E-02_JPRB,&
&.132E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.965E-03_JPRB,.965E-03_JPRB,&
&.882E-03_JPRB,.882E-03_JPRB,.745E-03_JPRB,.745E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,.656E-03_JPRB,&
&.656E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 38 -58.0
ZAER (:,38,12) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.355E-02_JPRB,&
&.355E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.206E-02_JPRB,&
&.206E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.161E-01_JPRB,.161E-01_JPRB,.148E-01_JPRB,&
&.148E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.817E-02_JPRB,.817E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.294E-02_JPRB,.294E-02_JPRB,.219E-02_JPRB,.219E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.154E-02_JPRB,&
&.154E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,&
&.829E-03_JPRB,.829E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,.814E-03_JPRB,&
&.814E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,&
&.860E-02_JPRB,.860E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 39 -62.0
ZAER (:,39,12) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.355E-02_JPRB,&
&.355E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.206E-02_JPRB,&
&.206E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.161E-01_JPRB,.161E-01_JPRB,.148E-01_JPRB,&
&.148E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.817E-02_JPRB,.817E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.294E-02_JPRB,.294E-02_JPRB,.219E-02_JPRB,.219E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.154E-02_JPRB,&
&.154E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,&
&.829E-03_JPRB,.829E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,.814E-03_JPRB,&
&.814E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,&
&.860E-02_JPRB,.860E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 40 -66.0
ZAER (:,40,12) = (/&
&.306E-02_JPRB,.306E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.117E-02_JPRB,&
&.117E-02_JPRB,.727E-03_JPRB,.727E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.900E-03_JPRB,.900E-03_JPRB,.185E-02_JPRB,.185E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.518E-02_JPRB,.518E-02_JPRB,&
&.409E-02_JPRB,.409E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.858E-03_JPRB,.858E-03_JPRB,&
&.738E-03_JPRB,.738E-03_JPRB,.647E-03_JPRB,.647E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.119E-02_JPRB,.119E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,&
&.324E-02_JPRB,.324E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 41 -70.0
ZAER (:,41,12) = (/&
&.306E-02_JPRB,.306E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.117E-02_JPRB,&
&.117E-02_JPRB,.727E-03_JPRB,.727E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.900E-03_JPRB,.900E-03_JPRB,.185E-02_JPRB,.185E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.518E-02_JPRB,.518E-02_JPRB,&
&.409E-02_JPRB,.409E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.858E-03_JPRB,.858E-03_JPRB,&
&.738E-03_JPRB,.738E-03_JPRB,.647E-03_JPRB,.647E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.119E-02_JPRB,.119E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,&
&.324E-02_JPRB,.324E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 42 -74.0
ZAER (:,42,12) = (/&
&.149E-02_JPRB,.149E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.717E-03_JPRB,.717E-03_JPRB,.732E-03_JPRB,.732E-03_JPRB,.894E-03_JPRB,.894E-03_JPRB,&
&.959E-03_JPRB,.959E-03_JPRB,.999E-03_JPRB,.999E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.910E-03_JPRB,&
&.910E-03_JPRB,.804E-03_JPRB,.804E-03_JPRB,.803E-03_JPRB,.803E-03_JPRB,.870E-03_JPRB,.870E-03_JPRB,&
&.845E-03_JPRB,.845E-03_JPRB,.828E-03_JPRB,.828E-03_JPRB,.915E-03_JPRB,.915E-03_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.695E-02_JPRB,.695E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,&
&.590E-02_JPRB,.590E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.843E-03_JPRB,.843E-03_JPRB,.676E-03_JPRB,.676E-03_JPRB,&
&.610E-03_JPRB,.610E-03_JPRB,.592E-03_JPRB,.592E-03_JPRB,.657E-03_JPRB,.657E-03_JPRB,.825E-03_JPRB,&
&.825E-03_JPRB,.858E-03_JPRB,.858E-03_JPRB,.958E-03_JPRB,.958E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.146E-02_JPRB,.146E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 43 -78.0
ZAER (:,43,12) = (/&
&.149E-02_JPRB,.149E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.717E-03_JPRB,.717E-03_JPRB,.732E-03_JPRB,.732E-03_JPRB,.894E-03_JPRB,.894E-03_JPRB,&
&.959E-03_JPRB,.959E-03_JPRB,.999E-03_JPRB,.999E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.910E-03_JPRB,&
&.910E-03_JPRB,.804E-03_JPRB,.804E-03_JPRB,.803E-03_JPRB,.803E-03_JPRB,.870E-03_JPRB,.870E-03_JPRB,&
&.845E-03_JPRB,.845E-03_JPRB,.828E-03_JPRB,.828E-03_JPRB,.915E-03_JPRB,.915E-03_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.695E-02_JPRB,.695E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,&
&.590E-02_JPRB,.590E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.843E-03_JPRB,.843E-03_JPRB,.676E-03_JPRB,.676E-03_JPRB,&
&.610E-03_JPRB,.610E-03_JPRB,.592E-03_JPRB,.592E-03_JPRB,.657E-03_JPRB,.657E-03_JPRB,.825E-03_JPRB,&
&.825E-03_JPRB,.858E-03_JPRB,.858E-03_JPRB,.958E-03_JPRB,.958E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.146E-02_JPRB,.146E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 44 -82.0
ZAER (:,44,12) = (/&
&.714E-03_JPRB,.714E-03_JPRB,.740E-03_JPRB,.740E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.792E-03_JPRB,&
&.792E-03_JPRB,.812E-03_JPRB,.812E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,&
&.825E-03_JPRB,.825E-03_JPRB,.814E-03_JPRB,.814E-03_JPRB,.773E-03_JPRB,.773E-03_JPRB,.678E-03_JPRB,&
&.678E-03_JPRB,.631E-03_JPRB,.631E-03_JPRB,.632E-03_JPRB,.632E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,&
&.650E-03_JPRB,.650E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.652E-03_JPRB,&
&.652E-03_JPRB,.917E-03_JPRB,.917E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,&
&.623E-03_JPRB,.623E-03_JPRB,.547E-03_JPRB,.547E-03_JPRB,.533E-03_JPRB,.533E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,&
&.507E-03_JPRB,.507E-03_JPRB,.544E-03_JPRB,.544E-03_JPRB,.618E-03_JPRB,.618E-03_JPRB,.679E-03_JPRB,&
&.679E-03_JPRB,.686E-03_JPRB,.686E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,.725E-03_JPRB,.725E-03_JPRB,&
&.713E-03_JPRB,.713E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 45 -86.0
ZAER (:,45,12) = (/&
&.714E-03_JPRB,.714E-03_JPRB,.740E-03_JPRB,.740E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.792E-03_JPRB,&
&.792E-03_JPRB,.812E-03_JPRB,.812E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,&
&.825E-03_JPRB,.825E-03_JPRB,.814E-03_JPRB,.814E-03_JPRB,.773E-03_JPRB,.773E-03_JPRB,.678E-03_JPRB,&
&.678E-03_JPRB,.631E-03_JPRB,.631E-03_JPRB,.632E-03_JPRB,.632E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,&
&.650E-03_JPRB,.650E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.652E-03_JPRB,&
&.652E-03_JPRB,.917E-03_JPRB,.917E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,&
&.623E-03_JPRB,.623E-03_JPRB,.547E-03_JPRB,.547E-03_JPRB,.533E-03_JPRB,.533E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,&
&.507E-03_JPRB,.507E-03_JPRB,.544E-03_JPRB,.544E-03_JPRB,.618E-03_JPRB,.618E-03_JPRB,.679E-03_JPRB,&
&.679E-03_JPRB,.686E-03_JPRB,.686E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,.725E-03_JPRB,.725E-03_JPRB,&
&.713E-03_JPRB,.713E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 46 -90.0
ZAER (:,46,12) = (/&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=12  
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_12
