SUBROUTINE SUECAESS_09

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      September

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,9:9)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  9 --- lat:  1  90.0
ZAER (:, 1, 9) = (/&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  2  86.0
ZAER (:, 2, 9) = (/&
&.749E-03_JPRB,.749E-03_JPRB,.750E-03_JPRB,.750E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.809E-03_JPRB,&
&.809E-03_JPRB,.867E-03_JPRB,.867E-03_JPRB,.944E-03_JPRB,.944E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.898E-03_JPRB,.898E-03_JPRB,&
&.758E-03_JPRB,.758E-03_JPRB,.604E-03_JPRB,.604E-03_JPRB,.465E-03_JPRB,.465E-03_JPRB,.357E-03_JPRB,&
&.357E-03_JPRB,.275E-03_JPRB,.275E-03_JPRB,.243E-03_JPRB,.243E-03_JPRB,.239E-03_JPRB,.239E-03_JPRB,&
&.255E-03_JPRB,.255E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,.289E-03_JPRB,&
&.289E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.341E-03_JPRB,.341E-03_JPRB,&
&.381E-03_JPRB,.381E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.439E-03_JPRB,.439E-03_JPRB,.465E-03_JPRB,&
&.465E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.682E-03_JPRB,.682E-03_JPRB,&
&.726E-03_JPRB,.726E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  3  82.0
ZAER (:, 3, 9) = (/&
&.749E-03_JPRB,.749E-03_JPRB,.750E-03_JPRB,.750E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.809E-03_JPRB,&
&.809E-03_JPRB,.867E-03_JPRB,.867E-03_JPRB,.944E-03_JPRB,.944E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.898E-03_JPRB,.898E-03_JPRB,&
&.758E-03_JPRB,.758E-03_JPRB,.604E-03_JPRB,.604E-03_JPRB,.465E-03_JPRB,.465E-03_JPRB,.357E-03_JPRB,&
&.357E-03_JPRB,.275E-03_JPRB,.275E-03_JPRB,.243E-03_JPRB,.243E-03_JPRB,.239E-03_JPRB,.239E-03_JPRB,&
&.255E-03_JPRB,.255E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,.289E-03_JPRB,&
&.289E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.341E-03_JPRB,.341E-03_JPRB,&
&.381E-03_JPRB,.381E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.439E-03_JPRB,.439E-03_JPRB,.465E-03_JPRB,&
&.465E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.682E-03_JPRB,.682E-03_JPRB,&
&.726E-03_JPRB,.726E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  4  78.0
ZAER (:, 4, 9) = (/&
&.738E-03_JPRB,.738E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.793E-03_JPRB,.793E-03_JPRB,.792E-03_JPRB,&
&.792E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,.936E-03_JPRB,.936E-03_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.104E-02_JPRB,.104E-02_JPRB,.885E-03_JPRB,.885E-03_JPRB,.799E-03_JPRB,.799E-03_JPRB,.728E-03_JPRB,&
&.728E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.326E-03_JPRB,.326E-03_JPRB,&
&.367E-03_JPRB,.367E-03_JPRB,.393E-03_JPRB,.393E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.511E-03_JPRB,&
&.511E-03_JPRB,.544E-03_JPRB,.544E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.379E-03_JPRB,.379E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.419E-03_JPRB,.419E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.421E-03_JPRB,&
&.421E-03_JPRB,.418E-03_JPRB,.418E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.557E-03_JPRB,.557E-03_JPRB,&
&.673E-03_JPRB,.673E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  5  74.0
ZAER (:, 5, 9) = (/&
&.738E-03_JPRB,.738E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.793E-03_JPRB,.793E-03_JPRB,.792E-03_JPRB,&
&.792E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,.936E-03_JPRB,.936E-03_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.104E-02_JPRB,.104E-02_JPRB,.885E-03_JPRB,.885E-03_JPRB,.799E-03_JPRB,.799E-03_JPRB,.728E-03_JPRB,&
&.728E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.326E-03_JPRB,.326E-03_JPRB,&
&.367E-03_JPRB,.367E-03_JPRB,.393E-03_JPRB,.393E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.511E-03_JPRB,&
&.511E-03_JPRB,.544E-03_JPRB,.544E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.379E-03_JPRB,.379E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.419E-03_JPRB,.419E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.421E-03_JPRB,&
&.421E-03_JPRB,.418E-03_JPRB,.418E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.557E-03_JPRB,.557E-03_JPRB,&
&.673E-03_JPRB,.673E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  6  70.0
ZAER (:, 6, 9) = (/&
&.196E-02_JPRB,.196E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.220E-02_JPRB,&
&.220E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.336E-02_JPRB,.336E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.392E-02_JPRB,&
&.392E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.865E-03_JPRB,.865E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.705E-03_JPRB,.705E-03_JPRB,.774E-03_JPRB,.774E-03_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.255E-02_JPRB,&
&.255E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,&
&.207E-02_JPRB,.207E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  7  66.0
ZAER (:, 7, 9) = (/&
&.196E-02_JPRB,.196E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.220E-02_JPRB,&
&.220E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.336E-02_JPRB,.336E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.392E-02_JPRB,&
&.392E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.865E-03_JPRB,.865E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.705E-03_JPRB,.705E-03_JPRB,.774E-03_JPRB,.774E-03_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.255E-02_JPRB,&
&.255E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,&
&.207E-02_JPRB,.207E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  8  62.0
ZAER (:, 8, 9) = (/&
&.948E-02_JPRB,.948E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.965E-02_JPRB,&
&.965E-02_JPRB,.903E-02_JPRB,.903E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,&
&.278E-02_JPRB,.278E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.953E-03_JPRB,&
&.953E-03_JPRB,.146E-02_JPRB,.146E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,&
&.258E-02_JPRB,.258E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.796E-02_JPRB,&
&.796E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,&
&.667E-02_JPRB,.667E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  9  58.0
ZAER (:, 9, 9) = (/&
&.948E-02_JPRB,.948E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.965E-02_JPRB,&
&.965E-02_JPRB,.903E-02_JPRB,.903E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,&
&.278E-02_JPRB,.278E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.953E-03_JPRB,&
&.953E-03_JPRB,.146E-02_JPRB,.146E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,&
&.258E-02_JPRB,.258E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.796E-02_JPRB,&
&.796E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,&
&.667E-02_JPRB,.667E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 10  54.0
ZAER (:,10, 9) = (/&
&.916E-02_JPRB,.916E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.993E-02_JPRB,&
&.993E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,&
&.927E-02_JPRB,.927E-02_JPRB,.909E-02_JPRB,.909E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.835E-02_JPRB,&
&.835E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,&
&.878E-02_JPRB,.878E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 11  50.0
ZAER (:,11, 9) = (/&
&.916E-02_JPRB,.916E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.993E-02_JPRB,&
&.993E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,&
&.927E-02_JPRB,.927E-02_JPRB,.909E-02_JPRB,.909E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.835E-02_JPRB,&
&.835E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,&
&.878E-02_JPRB,.878E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 12  46.0
ZAER (:,12, 9) = (/&
&.768E-02_JPRB,.768E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.908E-02_JPRB,&
&.908E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.982E-02_JPRB,.982E-02_JPRB,.984E-02_JPRB,&
&.984E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.953E-02_JPRB,.953E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.874E-02_JPRB,.874E-02_JPRB,.916E-02_JPRB,.916E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,&
&.649E-02_JPRB,.649E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 13  42.0
ZAER (:,13, 9) = (/&
&.768E-02_JPRB,.768E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.908E-02_JPRB,&
&.908E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.982E-02_JPRB,.982E-02_JPRB,.984E-02_JPRB,&
&.984E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.953E-02_JPRB,.953E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.874E-02_JPRB,.874E-02_JPRB,.916E-02_JPRB,.916E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,&
&.649E-02_JPRB,.649E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 14  38.0
ZAER (:,14, 9) = (/&
&.759E-02_JPRB,.759E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.996E-02_JPRB,.996E-02_JPRB,.995E-02_JPRB,.995E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.792E-02_JPRB,&
&.792E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.438E-02_JPRB,.438E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,&
&.996E-02_JPRB,.996E-02_JPRB,.931E-02_JPRB,.931E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.804E-02_JPRB,&
&.804E-02_JPRB,.764E-02_JPRB,.764E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.801E-02_JPRB,.801E-02_JPRB,.928E-02_JPRB,.928E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.943E-02_JPRB,&
&.943E-02_JPRB,.978E-02_JPRB,.978E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.641E-02_JPRB,&
&.641E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 15  34.0
ZAER (:,15, 9) = (/&
&.759E-02_JPRB,.759E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.996E-02_JPRB,.996E-02_JPRB,.995E-02_JPRB,.995E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.792E-02_JPRB,&
&.792E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.438E-02_JPRB,.438E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,&
&.996E-02_JPRB,.996E-02_JPRB,.931E-02_JPRB,.931E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.804E-02_JPRB,&
&.804E-02_JPRB,.764E-02_JPRB,.764E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.801E-02_JPRB,.801E-02_JPRB,.928E-02_JPRB,.928E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.943E-02_JPRB,&
&.943E-02_JPRB,.978E-02_JPRB,.978E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.641E-02_JPRB,&
&.641E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 16  30.0
ZAER (:,16, 9) = (/&
&.797E-02_JPRB,.797E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.937E-02_JPRB,&
&.937E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.926E-02_JPRB,.926E-02_JPRB,.804E-02_JPRB,&
&.804E-02_JPRB,.434E-02_JPRB,.434E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,&
&.742E-02_JPRB,.742E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.778E-02_JPRB,&
&.778E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.314E-02_JPRB,.314E-02_JPRB,&
&.446E-02_JPRB,.446E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,&
&.741E-02_JPRB,.741E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.252E-02_JPRB,&
&.252E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.516E-02_JPRB,.516E-02_JPRB,.837E-02_JPRB,.837E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 17  26.0
ZAER (:,17, 9) = (/&
&.797E-02_JPRB,.797E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.937E-02_JPRB,&
&.937E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.926E-02_JPRB,.926E-02_JPRB,.804E-02_JPRB,&
&.804E-02_JPRB,.434E-02_JPRB,.434E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,&
&.742E-02_JPRB,.742E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.778E-02_JPRB,&
&.778E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.314E-02_JPRB,.314E-02_JPRB,&
&.446E-02_JPRB,.446E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,&
&.741E-02_JPRB,.741E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.252E-02_JPRB,&
&.252E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.516E-02_JPRB,.516E-02_JPRB,.837E-02_JPRB,.837E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 18  22.0
ZAER (:,18, 9) = (/&
&.961E-02_JPRB,.961E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,&
&.617E-02_JPRB,.617E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.754E-02_JPRB,&
&.754E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.889E-02_JPRB,&
&.889E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.816E-02_JPRB,.816E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.906E-02_JPRB,.906E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.978E-02_JPRB,.978E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 19  18.0
ZAER (:,19, 9) = (/&
&.961E-02_JPRB,.961E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,&
&.617E-02_JPRB,.617E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.754E-02_JPRB,&
&.754E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.889E-02_JPRB,&
&.889E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.816E-02_JPRB,.816E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.906E-02_JPRB,.906E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.978E-02_JPRB,.978E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 20  14.0
ZAER (:,20, 9) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.472E-02_JPRB,&
&.472E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.673E-02_JPRB,.673E-02_JPRB,.919E-02_JPRB,.919E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.568E-02_JPRB,&
&.568E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.980E-02_JPRB,.980E-02_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 21  10.0
ZAER (:,21, 9) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.472E-02_JPRB,&
&.472E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.673E-02_JPRB,.673E-02_JPRB,.919E-02_JPRB,.919E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.568E-02_JPRB,&
&.568E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.980E-02_JPRB,.980E-02_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 22   6.0
ZAER (:,22, 9) = (/&
&.144E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.136E-01_JPRB,&
&.136E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.832E-02_JPRB,.832E-02_JPRB,&
&.653E-02_JPRB,.653E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.557E-02_JPRB,.557E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.436E-02_JPRB,&
&.436E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,&
&.380E-02_JPRB,.380E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.965E-02_JPRB,&
&.965E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,&
&.660E-02_JPRB,.660E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 23   2.0
ZAER (:,23, 9) = (/&
&.144E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.136E-01_JPRB,&
&.136E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.832E-02_JPRB,.832E-02_JPRB,&
&.653E-02_JPRB,.653E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.557E-02_JPRB,.557E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.436E-02_JPRB,&
&.436E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,&
&.380E-02_JPRB,.380E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.965E-02_JPRB,&
&.965E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,&
&.660E-02_JPRB,.660E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 24  -2.0
ZAER (:,24, 9) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.940E-02_JPRB,.940E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.770E-02_JPRB,.770E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.309E-02_JPRB,&
&.309E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.676E-03_JPRB,.676E-03_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.316E-02_JPRB,.316E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.733E-02_JPRB,&
&.733E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,&
&.395E-02_JPRB,.395E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.926E-02_JPRB,&
&.926E-02_JPRB,.909E-02_JPRB,.909E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 25  -6.0
ZAER (:,25, 9) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.940E-02_JPRB,.940E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.770E-02_JPRB,.770E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.309E-02_JPRB,&
&.309E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.676E-03_JPRB,.676E-03_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.316E-02_JPRB,.316E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.733E-02_JPRB,&
&.733E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,&
&.395E-02_JPRB,.395E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.926E-02_JPRB,&
&.926E-02_JPRB,.909E-02_JPRB,.909E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 26 -10.0
ZAER (:,26, 9) = (/&
&.113E-01_JPRB,.113E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.804E-02_JPRB,.804E-02_JPRB,&
&.579E-02_JPRB,.579E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.510E-02_JPRB,&
&.510E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,&
&.965E-02_JPRB,.965E-02_JPRB,.670E-02_JPRB,.670E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.770E-03_JPRB,&
&.770E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.661E-02_JPRB,&
&.661E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,&
&.298E-02_JPRB,.298E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.854E-02_JPRB,&
&.854E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.956E-02_JPRB,.956E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 27 -14.0
ZAER (:,27, 9) = (/&
&.113E-01_JPRB,.113E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.804E-02_JPRB,.804E-02_JPRB,&
&.579E-02_JPRB,.579E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.510E-02_JPRB,&
&.510E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,&
&.965E-02_JPRB,.965E-02_JPRB,.670E-02_JPRB,.670E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.770E-03_JPRB,&
&.770E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.661E-02_JPRB,&
&.661E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,&
&.298E-02_JPRB,.298E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.854E-02_JPRB,&
&.854E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.956E-02_JPRB,.956E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 28 -18.0
ZAER (:,28, 9) = (/&
&.119E-01_JPRB,.119E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.146E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.770E-02_JPRB,.770E-02_JPRB,&
&.475E-02_JPRB,.475E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.452E-02_JPRB,.452E-02_JPRB,.603E-02_JPRB,&
&.603E-02_JPRB,.834E-02_JPRB,.834E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.559E-02_JPRB,.559E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.862E-03_JPRB,.862E-03_JPRB,&
&.897E-03_JPRB,.897E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.429E-02_JPRB,&
&.429E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,&
&.151E-02_JPRB,.151E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 29 -22.0
ZAER (:,29, 9) = (/&
&.119E-01_JPRB,.119E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.146E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.770E-02_JPRB,.770E-02_JPRB,&
&.475E-02_JPRB,.475E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.452E-02_JPRB,.452E-02_JPRB,.603E-02_JPRB,&
&.603E-02_JPRB,.834E-02_JPRB,.834E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.559E-02_JPRB,.559E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.862E-03_JPRB,.862E-03_JPRB,&
&.897E-03_JPRB,.897E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.429E-02_JPRB,&
&.429E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,&
&.151E-02_JPRB,.151E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 30 -26.0
ZAER (:,30, 9) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.919E-02_JPRB,.919E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,&
&.374E-02_JPRB,.374E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.633E-02_JPRB,&
&.633E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,.502E-02_JPRB,&
&.502E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,&
&.208E-02_JPRB,.208E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.174E-02_JPRB,&
&.174E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.947E-03_JPRB,.947E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,&
&.907E-03_JPRB,.907E-03_JPRB,.166E-02_JPRB,.166E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,.666E-02_JPRB,&
&.666E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 31 -30.0
ZAER (:,31, 9) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.919E-02_JPRB,.919E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,&
&.374E-02_JPRB,.374E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.633E-02_JPRB,&
&.633E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,.502E-02_JPRB,&
&.502E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,&
&.208E-02_JPRB,.208E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.174E-02_JPRB,&
&.174E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.947E-03_JPRB,.947E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,&
&.907E-03_JPRB,.907E-03_JPRB,.166E-02_JPRB,.166E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,.666E-02_JPRB,&
&.666E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 32 -34.0
ZAER (:,32, 9) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.936E-02_JPRB,.936E-02_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.878E-02_JPRB,.878E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.405E-02_JPRB,&
&.405E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.856E-02_JPRB,.856E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,&
&.878E-02_JPRB,.878E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.636E-02_JPRB,&
&.636E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,&
&.391E-02_JPRB,.391E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.162E-02_JPRB,&
&.162E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,&
&.635E-03_JPRB,.635E-03_JPRB,.891E-03_JPRB,.891E-03_JPRB,.252E-02_JPRB,.252E-02_JPRB,.351E-02_JPRB,&
&.351E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,&
&.984E-02_JPRB,.984E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 33 -38.0
ZAER (:,33, 9) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.936E-02_JPRB,.936E-02_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.878E-02_JPRB,.878E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.405E-02_JPRB,&
&.405E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.856E-02_JPRB,.856E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,&
&.878E-02_JPRB,.878E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.636E-02_JPRB,&
&.636E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,&
&.391E-02_JPRB,.391E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.162E-02_JPRB,&
&.162E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,&
&.635E-03_JPRB,.635E-03_JPRB,.891E-03_JPRB,.891E-03_JPRB,.252E-02_JPRB,.252E-02_JPRB,.351E-02_JPRB,&
&.351E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,&
&.984E-02_JPRB,.984E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 34 -42.0
ZAER (:,34, 9) = (/&
&.837E-02_JPRB,.837E-02_JPRB,.845E-02_JPRB,.845E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.868E-02_JPRB,&
&.868E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,&
&.303E-02_JPRB,.303E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.167E-02_JPRB,&
&.167E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,&
&.721E-02_JPRB,.721E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.676E-02_JPRB,&
&.676E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,&
&.311E-02_JPRB,.311E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.859E-03_JPRB,.859E-03_JPRB,&
&.691E-03_JPRB,.691E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.756E-03_JPRB,.756E-03_JPRB,.168E-02_JPRB,&
&.168E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.606E-02_JPRB,.606E-02_JPRB,.696E-02_JPRB,.696E-02_JPRB,&
&.786E-02_JPRB,.786E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 35 -46.0
ZAER (:,35, 9) = (/&
&.837E-02_JPRB,.837E-02_JPRB,.845E-02_JPRB,.845E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.868E-02_JPRB,&
&.868E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,&
&.303E-02_JPRB,.303E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.167E-02_JPRB,&
&.167E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,&
&.721E-02_JPRB,.721E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.676E-02_JPRB,&
&.676E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,&
&.311E-02_JPRB,.311E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.859E-03_JPRB,.859E-03_JPRB,&
&.691E-03_JPRB,.691E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.756E-03_JPRB,.756E-03_JPRB,.168E-02_JPRB,&
&.168E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.606E-02_JPRB,.606E-02_JPRB,.696E-02_JPRB,.696E-02_JPRB,&
&.786E-02_JPRB,.786E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 36 -50.0
ZAER (:,36, 9) = (/&
&.561E-02_JPRB,.561E-02_JPRB,.650E-02_JPRB,.650E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.803E-02_JPRB,&
&.803E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.134E-02_JPRB,&
&.134E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,&
&.765E-02_JPRB,.765E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.664E-02_JPRB,&
&.664E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,&
&.225E-02_JPRB,.225E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.959E-03_JPRB,.959E-03_JPRB,.881E-03_JPRB,.881E-03_JPRB,&
&.791E-03_JPRB,.791E-03_JPRB,.718E-03_JPRB,.718E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.683E-03_JPRB,&
&.683E-03_JPRB,.225E-02_JPRB,.225E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,&
&.508E-02_JPRB,.508E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 37 -54.0
ZAER (:,37, 9) = (/&
&.561E-02_JPRB,.561E-02_JPRB,.650E-02_JPRB,.650E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.803E-02_JPRB,&
&.803E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.134E-02_JPRB,&
&.134E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,&
&.765E-02_JPRB,.765E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.664E-02_JPRB,&
&.664E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,&
&.225E-02_JPRB,.225E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.959E-03_JPRB,.959E-03_JPRB,.881E-03_JPRB,.881E-03_JPRB,&
&.791E-03_JPRB,.791E-03_JPRB,.718E-03_JPRB,.718E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.683E-03_JPRB,&
&.683E-03_JPRB,.225E-02_JPRB,.225E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,&
&.508E-02_JPRB,.508E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 38 -58.0
ZAER (:,38, 9) = (/&
&.287E-02_JPRB,.287E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.785E-03_JPRB,.785E-03_JPRB,&
&.558E-03_JPRB,.558E-03_JPRB,.648E-03_JPRB,.648E-03_JPRB,.354E-02_JPRB,.354E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,&
&.743E-02_JPRB,.743E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.984E-02_JPRB,&
&.984E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.970E-03_JPRB,.970E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,.788E-03_JPRB,.788E-03_JPRB,&
&.736E-03_JPRB,.736E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.516E-03_JPRB,&
&.516E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,&
&.238E-02_JPRB,.238E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 39 -62.0
ZAER (:,39, 9) = (/&
&.287E-02_JPRB,.287E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.785E-03_JPRB,.785E-03_JPRB,&
&.558E-03_JPRB,.558E-03_JPRB,.648E-03_JPRB,.648E-03_JPRB,.354E-02_JPRB,.354E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,&
&.743E-02_JPRB,.743E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.984E-02_JPRB,&
&.984E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.970E-03_JPRB,.970E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,.788E-03_JPRB,.788E-03_JPRB,&
&.736E-03_JPRB,.736E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.516E-03_JPRB,&
&.516E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,&
&.238E-02_JPRB,.238E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 40 -66.0
ZAER (:,40, 9) = (/&
&.722E-03_JPRB,.722E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.604E-03_JPRB,.604E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.743E-03_JPRB,.743E-03_JPRB,.657E-03_JPRB,.657E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.677E-03_JPRB,.677E-03_JPRB,.790E-03_JPRB,.790E-03_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.130E-02_JPRB,.130E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.690E-02_JPRB,&
&.690E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.228E-02_JPRB,.228E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.156E-02_JPRB,&
&.156E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,.619E-03_JPRB,.619E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,&
&.477E-03_JPRB,.477E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.424E-03_JPRB,&
&.424E-03_JPRB,.413E-03_JPRB,.413E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,&
&.527E-03_JPRB,.527E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 41 -70.0
ZAER (:,41, 9) = (/&
&.722E-03_JPRB,.722E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.604E-03_JPRB,.604E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.743E-03_JPRB,.743E-03_JPRB,.657E-03_JPRB,.657E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.677E-03_JPRB,.677E-03_JPRB,.790E-03_JPRB,.790E-03_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.130E-02_JPRB,.130E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.690E-02_JPRB,&
&.690E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.228E-02_JPRB,.228E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.156E-02_JPRB,&
&.156E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,.619E-03_JPRB,.619E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,&
&.477E-03_JPRB,.477E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.424E-03_JPRB,&
&.424E-03_JPRB,.413E-03_JPRB,.413E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,&
&.527E-03_JPRB,.527E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 42 -74.0
ZAER (:,42, 9) = (/&
&.405E-03_JPRB,.405E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.334E-03_JPRB,.334E-03_JPRB,.340E-03_JPRB,&
&.340E-03_JPRB,.407E-03_JPRB,.407E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.424E-03_JPRB,.424E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.416E-03_JPRB,.416E-03_JPRB,.491E-03_JPRB,&
&.491E-03_JPRB,.670E-03_JPRB,.670E-03_JPRB,.982E-03_JPRB,.982E-03_JPRB,.851E-03_JPRB,.851E-03_JPRB,&
&.627E-03_JPRB,.627E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.218E-02_JPRB,&
&.218E-02_JPRB,.434E-02_JPRB,.434E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.353E-02_JPRB,.353E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.801E-03_JPRB,.801E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,&
&.369E-03_JPRB,.369E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.871E-03_JPRB,&
&.871E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,.308E-03_JPRB,.308E-03_JPRB,&
&.337E-03_JPRB,.337E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 43 -78.0
ZAER (:,43, 9) = (/&
&.405E-03_JPRB,.405E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.334E-03_JPRB,.334E-03_JPRB,.340E-03_JPRB,&
&.340E-03_JPRB,.407E-03_JPRB,.407E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.424E-03_JPRB,.424E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.416E-03_JPRB,.416E-03_JPRB,.491E-03_JPRB,&
&.491E-03_JPRB,.670E-03_JPRB,.670E-03_JPRB,.982E-03_JPRB,.982E-03_JPRB,.851E-03_JPRB,.851E-03_JPRB,&
&.627E-03_JPRB,.627E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.218E-02_JPRB,&
&.218E-02_JPRB,.434E-02_JPRB,.434E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.353E-02_JPRB,.353E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.801E-03_JPRB,.801E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,&
&.369E-03_JPRB,.369E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.871E-03_JPRB,&
&.871E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,.308E-03_JPRB,.308E-03_JPRB,&
&.337E-03_JPRB,.337E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 44 -82.0
ZAER (:,44, 9) = (/&
&.341E-03_JPRB,.341E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.335E-03_JPRB,.335E-03_JPRB,.346E-03_JPRB,&
&.346E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.361E-03_JPRB,.361E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.442E-03_JPRB,&
&.442E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.533E-03_JPRB,.533E-03_JPRB,.446E-03_JPRB,.446E-03_JPRB,&
&.360E-03_JPRB,.360E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.365E-03_JPRB,&
&.365E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.708E-03_JPRB,.708E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,&
&.432E-03_JPRB,.432E-03_JPRB,.418E-03_JPRB,.418E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.358E-03_JPRB,&
&.358E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.326E-03_JPRB,.326E-03_JPRB,.316E-03_JPRB,.316E-03_JPRB,&
&.319E-03_JPRB,.319E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.339E-03_JPRB,.339E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.317E-03_JPRB,.317E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.331E-03_JPRB,.331E-03_JPRB,&
&.340E-03_JPRB,.340E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 45 -86.0
ZAER (:,45, 9) = (/&
&.341E-03_JPRB,.341E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.335E-03_JPRB,.335E-03_JPRB,.346E-03_JPRB,&
&.346E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.361E-03_JPRB,.361E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.442E-03_JPRB,&
&.442E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.533E-03_JPRB,.533E-03_JPRB,.446E-03_JPRB,.446E-03_JPRB,&
&.360E-03_JPRB,.360E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.365E-03_JPRB,&
&.365E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.708E-03_JPRB,.708E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,&
&.432E-03_JPRB,.432E-03_JPRB,.418E-03_JPRB,.418E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.358E-03_JPRB,&
&.358E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.326E-03_JPRB,.326E-03_JPRB,.316E-03_JPRB,.316E-03_JPRB,&
&.319E-03_JPRB,.319E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.339E-03_JPRB,.339E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.317E-03_JPRB,.317E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.331E-03_JPRB,.331E-03_JPRB,&
&.340E-03_JPRB,.340E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 46 -90.0
ZAER (:,46, 9) = (/&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=9   
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_09
