SUBROUTINE SUECAESS_08

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      August

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,8:8)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  8 --- lat:  1  90.0
ZAER (:, 1, 8) = (/&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  2  86.0
ZAER (:, 2, 8) = (/&
&.876E-03_JPRB,.876E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,&
&.837E-03_JPRB,.837E-03_JPRB,.733E-03_JPRB,.733E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.503E-03_JPRB,&
&.503E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,&
&.410E-03_JPRB,.410E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.319E-03_JPRB,.319E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,&
&.359E-03_JPRB,.359E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.385E-03_JPRB,&
&.385E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.400E-03_JPRB,.400E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,&
&.375E-03_JPRB,.375E-03_JPRB,.382E-03_JPRB,.382E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.432E-03_JPRB,&
&.432E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,.532E-03_JPRB,.532E-03_JPRB,.636E-03_JPRB,.636E-03_JPRB,&
&.760E-03_JPRB,.760E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  3  82.0
ZAER (:, 3, 8) = (/&
&.876E-03_JPRB,.876E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,&
&.837E-03_JPRB,.837E-03_JPRB,.733E-03_JPRB,.733E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.503E-03_JPRB,&
&.503E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,&
&.410E-03_JPRB,.410E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.319E-03_JPRB,.319E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,&
&.359E-03_JPRB,.359E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.385E-03_JPRB,&
&.385E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.400E-03_JPRB,.400E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,&
&.375E-03_JPRB,.375E-03_JPRB,.382E-03_JPRB,.382E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.432E-03_JPRB,&
&.432E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,.532E-03_JPRB,.532E-03_JPRB,.636E-03_JPRB,.636E-03_JPRB,&
&.760E-03_JPRB,.760E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  4  78.0
ZAER (:, 4, 8) = (/&
&.744E-03_JPRB,.744E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.139E-02_JPRB,.139E-02_JPRB,.170E-02_JPRB,&
&.170E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.112E-02_JPRB,&
&.112E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,&
&.841E-03_JPRB,.841E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.372E-03_JPRB,&
&.372E-03_JPRB,.310E-03_JPRB,.310E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.492E-03_JPRB,.492E-03_JPRB,.545E-03_JPRB,&
&.545E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,.361E-03_JPRB,&
&.361E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,.494E-03_JPRB,.494E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,&
&.698E-03_JPRB,.698E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  5  74.0
ZAER (:, 5, 8) = (/&
&.744E-03_JPRB,.744E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.139E-02_JPRB,.139E-02_JPRB,.170E-02_JPRB,&
&.170E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.112E-02_JPRB,&
&.112E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,&
&.841E-03_JPRB,.841E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.372E-03_JPRB,&
&.372E-03_JPRB,.310E-03_JPRB,.310E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.492E-03_JPRB,.492E-03_JPRB,.545E-03_JPRB,&
&.545E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,.361E-03_JPRB,&
&.361E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,.494E-03_JPRB,.494E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,&
&.698E-03_JPRB,.698E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  6  70.0
ZAER (:, 6, 8) = (/&
&.171E-02_JPRB,.171E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.256E-02_JPRB,&
&.256E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.233E-02_JPRB,.233E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.278E-02_JPRB,&
&.278E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.561E-03_JPRB,.561E-03_JPRB,.524E-03_JPRB,&
&.524E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,&
&.658E-03_JPRB,.658E-03_JPRB,.806E-03_JPRB,.806E-03_JPRB,.890E-03_JPRB,.890E-03_JPRB,.959E-03_JPRB,&
&.959E-03_JPRB,.108E-02_JPRB,.108E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.868E-03_JPRB,.868E-03_JPRB,.767E-03_JPRB,.767E-03_JPRB,.776E-03_JPRB,&
&.776E-03_JPRB,.864E-03_JPRB,.864E-03_JPRB,.996E-03_JPRB,.996E-03_JPRB,.125E-02_JPRB,.125E-02_JPRB,&
&.146E-02_JPRB,.146E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  7  66.0
ZAER (:, 7, 8) = (/&
&.171E-02_JPRB,.171E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.256E-02_JPRB,&
&.256E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.233E-02_JPRB,.233E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.278E-02_JPRB,&
&.278E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.561E-03_JPRB,.561E-03_JPRB,.524E-03_JPRB,&
&.524E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,&
&.658E-03_JPRB,.658E-03_JPRB,.806E-03_JPRB,.806E-03_JPRB,.890E-03_JPRB,.890E-03_JPRB,.959E-03_JPRB,&
&.959E-03_JPRB,.108E-02_JPRB,.108E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.868E-03_JPRB,.868E-03_JPRB,.767E-03_JPRB,.767E-03_JPRB,.776E-03_JPRB,&
&.776E-03_JPRB,.864E-03_JPRB,.864E-03_JPRB,.996E-03_JPRB,.996E-03_JPRB,.125E-02_JPRB,.125E-02_JPRB,&
&.146E-02_JPRB,.146E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  8  62.0
ZAER (:, 8, 8) = (/&
&.781E-02_JPRB,.781E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.465E-02_JPRB,&
&.465E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.684E-02_JPRB,.684E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.785E-03_JPRB,.785E-03_JPRB,.900E-03_JPRB,&
&.900E-03_JPRB,.131E-02_JPRB,.131E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.171E-02_JPRB,.171E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.263E-02_JPRB,&
&.263E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,&
&.312E-02_JPRB,.312E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.354E-02_JPRB,&
&.354E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.360E-02_JPRB,.360E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,&
&.704E-02_JPRB,.704E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  9  58.0
ZAER (:, 9, 8) = (/&
&.781E-02_JPRB,.781E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.465E-02_JPRB,&
&.465E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.684E-02_JPRB,.684E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.785E-03_JPRB,.785E-03_JPRB,.900E-03_JPRB,&
&.900E-03_JPRB,.131E-02_JPRB,.131E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.171E-02_JPRB,.171E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.263E-02_JPRB,&
&.263E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,&
&.312E-02_JPRB,.312E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.354E-02_JPRB,&
&.354E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.360E-02_JPRB,.360E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,&
&.704E-02_JPRB,.704E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 10  54.0
ZAER (:,10, 8) = (/&
&.926E-02_JPRB,.926E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,.618E-02_JPRB,&
&.618E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.724E-02_JPRB,.724E-02_JPRB,&
&.924E-02_JPRB,.924E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.994E-02_JPRB,&
&.994E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 11  50.0
ZAER (:,11, 8) = (/&
&.926E-02_JPRB,.926E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,.618E-02_JPRB,&
&.618E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.724E-02_JPRB,.724E-02_JPRB,&
&.924E-02_JPRB,.924E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.994E-02_JPRB,&
&.994E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 12  46.0
ZAER (:,12, 8) = (/&
&.979E-02_JPRB,.979E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.922E-02_JPRB,&
&.922E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.983E-02_JPRB,.983E-02_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.886E-02_JPRB,.886E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.759E-02_JPRB,.759E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 13  42.0
ZAER (:,13, 8) = (/&
&.979E-02_JPRB,.979E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.922E-02_JPRB,&
&.922E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.983E-02_JPRB,.983E-02_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.886E-02_JPRB,.886E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.759E-02_JPRB,.759E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 14  38.0
ZAER (:,14, 8) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.810E-02_JPRB,&
&.810E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,&
&.993E-02_JPRB,.993E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,.919E-02_JPRB,&
&.919E-02_JPRB,.898E-02_JPRB,.898E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.947E-02_JPRB,.947E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.963E-02_JPRB,.963E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,&
&.916E-02_JPRB,.916E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.763E-02_JPRB,&
&.763E-02_JPRB,.474E-02_JPRB,.474E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 15  34.0
ZAER (:,15, 8) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.810E-02_JPRB,&
&.810E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,&
&.993E-02_JPRB,.993E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,.919E-02_JPRB,&
&.919E-02_JPRB,.898E-02_JPRB,.898E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.947E-02_JPRB,.947E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.963E-02_JPRB,.963E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,&
&.916E-02_JPRB,.916E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.763E-02_JPRB,&
&.763E-02_JPRB,.474E-02_JPRB,.474E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 16  30.0
ZAER (:,16, 8) = (/&
&.113E-01_JPRB,.113E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,.997E-02_JPRB,.997E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.997E-02_JPRB,.997E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.824E-02_JPRB,&
&.824E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,&
&.768E-02_JPRB,.768E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.846E-02_JPRB,&
&.846E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.513E-02_JPRB,.513E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.123E-01_JPRB,.123E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 17  26.0
ZAER (:,17, 8) = (/&
&.113E-01_JPRB,.113E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,.997E-02_JPRB,.997E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.997E-02_JPRB,.997E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.824E-02_JPRB,&
&.824E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,&
&.768E-02_JPRB,.768E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.846E-02_JPRB,&
&.846E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.513E-02_JPRB,.513E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.123E-01_JPRB,.123E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 18  22.0
ZAER (:,18, 8) = (/&
&.129E-01_JPRB,.129E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.928E-02_JPRB,.928E-02_JPRB,.764E-02_JPRB,&
&.764E-02_JPRB,.457E-02_JPRB,.457E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.312E-02_JPRB,.312E-02_JPRB,&
&.651E-02_JPRB,.651E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.791E-02_JPRB,&
&.791E-02_JPRB,.698E-02_JPRB,.698E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,&
&.314E-02_JPRB,.314E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.904E-02_JPRB,.904E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.457E-02_JPRB,&
&.457E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.123E-01_JPRB,.123E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 19  18.0
ZAER (:,19, 8) = (/&
&.129E-01_JPRB,.129E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.928E-02_JPRB,.928E-02_JPRB,.764E-02_JPRB,&
&.764E-02_JPRB,.457E-02_JPRB,.457E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.312E-02_JPRB,.312E-02_JPRB,&
&.651E-02_JPRB,.651E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.791E-02_JPRB,&
&.791E-02_JPRB,.698E-02_JPRB,.698E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,&
&.314E-02_JPRB,.314E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.904E-02_JPRB,.904E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.457E-02_JPRB,&
&.457E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.123E-01_JPRB,.123E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 20  14.0
ZAER (:,20, 8) = (/&
&.163E-01_JPRB,.163E-01_JPRB,.166E-01_JPRB,.166E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.752E-02_JPRB,.752E-02_JPRB,.988E-02_JPRB,.988E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.596E-02_JPRB,&
&.596E-02_JPRB,.451E-02_JPRB,.451E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,&
&.344E-02_JPRB,.344E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.877E-02_JPRB,.877E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.125E-01_JPRB,.125E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 21  10.0
ZAER (:,21, 8) = (/&
&.163E-01_JPRB,.163E-01_JPRB,.166E-01_JPRB,.166E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.752E-02_JPRB,.752E-02_JPRB,.988E-02_JPRB,.988E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.596E-02_JPRB,&
&.596E-02_JPRB,.451E-02_JPRB,.451E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,&
&.344E-02_JPRB,.344E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.877E-02_JPRB,.877E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.125E-01_JPRB,.125E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 22   6.0
ZAER (:,22, 8) = (/&
&.167E-01_JPRB,.167E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.900E-02_JPRB,.900E-02_JPRB,&
&.746E-02_JPRB,.746E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.465E-02_JPRB,.465E-02_JPRB,.234E-02_JPRB,&
&.234E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,&
&.851E-02_JPRB,.851E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.428E-02_JPRB,&
&.428E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,&
&.554E-02_JPRB,.554E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,&
&.700E-02_JPRB,.700E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 23   2.0
ZAER (:,23, 8) = (/&
&.167E-01_JPRB,.167E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.900E-02_JPRB,.900E-02_JPRB,&
&.746E-02_JPRB,.746E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.465E-02_JPRB,.465E-02_JPRB,.234E-02_JPRB,&
&.234E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,&
&.851E-02_JPRB,.851E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.428E-02_JPRB,&
&.428E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,&
&.554E-02_JPRB,.554E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,&
&.700E-02_JPRB,.700E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 24  -2.0
ZAER (:,24, 8) = (/&
&.116E-01_JPRB,.116E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.143E-01_JPRB,&
&.143E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.839E-02_JPRB,.839E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,.326E-02_JPRB,&
&.326E-02_JPRB,.372E-02_JPRB,.372E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.908E-02_JPRB,.908E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,.319E-02_JPRB,&
&.319E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.927E-03_JPRB,.927E-03_JPRB,.193E-02_JPRB,.193E-02_JPRB,&
&.418E-02_JPRB,.418E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.766E-02_JPRB,&
&.766E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.596E-02_JPRB,.596E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.743E-02_JPRB,&
&.743E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 25  -6.0
ZAER (:,25, 8) = (/&
&.116E-01_JPRB,.116E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.143E-01_JPRB,&
&.143E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.839E-02_JPRB,.839E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,.326E-02_JPRB,&
&.326E-02_JPRB,.372E-02_JPRB,.372E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.908E-02_JPRB,.908E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,.319E-02_JPRB,&
&.319E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.927E-03_JPRB,.927E-03_JPRB,.193E-02_JPRB,.193E-02_JPRB,&
&.418E-02_JPRB,.418E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.766E-02_JPRB,&
&.766E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.596E-02_JPRB,.596E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.743E-02_JPRB,&
&.743E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 26 -10.0
ZAER (:,26, 8) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.138E-01_JPRB,&
&.138E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.808E-02_JPRB,.808E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.699E-02_JPRB,&
&.699E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.832E-02_JPRB,.832E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.646E-03_JPRB,&
&.646E-03_JPRB,.371E-03_JPRB,.371E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,&
&.211E-02_JPRB,.211E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,&
&.334E-02_JPRB,.334E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.725E-02_JPRB,&
&.725E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 27 -14.0
ZAER (:,27, 8) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.138E-01_JPRB,&
&.138E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.808E-02_JPRB,.808E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.699E-02_JPRB,&
&.699E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.832E-02_JPRB,.832E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.646E-03_JPRB,&
&.646E-03_JPRB,.371E-03_JPRB,.371E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,&
&.211E-02_JPRB,.211E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,&
&.334E-02_JPRB,.334E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.725E-02_JPRB,&
&.725E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 28 -18.0
ZAER (:,28, 8) = (/&
&.127E-01_JPRB,.127E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,&
&.438E-02_JPRB,.438E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.933E-02_JPRB,&
&.933E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.730E-02_JPRB,.730E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.755E-03_JPRB,&
&.755E-03_JPRB,.645E-03_JPRB,.645E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,.892E-03_JPRB,.892E-03_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.635E-02_JPRB,&
&.635E-02_JPRB,.378E-02_JPRB,.378E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.962E-02_JPRB,&
&.962E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.925E-02_JPRB,.925E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.997E-02_JPRB,.997E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 29 -22.0
ZAER (:,29, 8) = (/&
&.127E-01_JPRB,.127E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,&
&.438E-02_JPRB,.438E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.933E-02_JPRB,&
&.933E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.730E-02_JPRB,.730E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.755E-03_JPRB,&
&.755E-03_JPRB,.645E-03_JPRB,.645E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,.892E-03_JPRB,.892E-03_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.635E-02_JPRB,&
&.635E-02_JPRB,.378E-02_JPRB,.378E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.962E-02_JPRB,&
&.962E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.925E-02_JPRB,.925E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.997E-02_JPRB,.997E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 30 -26.0
ZAER (:,30, 8) = (/&
&.105E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.790E-02_JPRB,.790E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.236E-02_JPRB,.236E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.721E-02_JPRB,.721E-02_JPRB,.324E-02_JPRB,&
&.324E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,&
&.204E-02_JPRB,.204E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.187E-02_JPRB,&
&.187E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.702E-03_JPRB,.702E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,&
&.704E-03_JPRB,.704E-03_JPRB,.200E-02_JPRB,.200E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.675E-02_JPRB,&
&.675E-02_JPRB,.793E-02_JPRB,.793E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,&
&.937E-02_JPRB,.937E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 31 -30.0
ZAER (:,31, 8) = (/&
&.105E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.790E-02_JPRB,.790E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.236E-02_JPRB,.236E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.721E-02_JPRB,.721E-02_JPRB,.324E-02_JPRB,&
&.324E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,&
&.204E-02_JPRB,.204E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.187E-02_JPRB,&
&.187E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.702E-03_JPRB,.702E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,&
&.704E-03_JPRB,.704E-03_JPRB,.200E-02_JPRB,.200E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.675E-02_JPRB,&
&.675E-02_JPRB,.793E-02_JPRB,.793E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,&
&.937E-02_JPRB,.937E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 32 -34.0
ZAER (:,32, 8) = (/&
&.754E-02_JPRB,.754E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,&
&.195E-02_JPRB,.195E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.273E-02_JPRB,&
&.273E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.951E-02_JPRB,.951E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.748E-02_JPRB,.748E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,&
&.339E-02_JPRB,.339E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.139E-02_JPRB,&
&.139E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.902E-03_JPRB,.902E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,&
&.495E-03_JPRB,.495E-03_JPRB,.847E-03_JPRB,.847E-03_JPRB,.232E-02_JPRB,.232E-02_JPRB,.267E-02_JPRB,&
&.267E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.764E-02_JPRB,.764E-02_JPRB,&
&.738E-02_JPRB,.738E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 33 -38.0
ZAER (:,33, 8) = (/&
&.754E-02_JPRB,.754E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,&
&.195E-02_JPRB,.195E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.273E-02_JPRB,&
&.273E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.951E-02_JPRB,.951E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.748E-02_JPRB,.748E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,&
&.339E-02_JPRB,.339E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.139E-02_JPRB,&
&.139E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.902E-03_JPRB,.902E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,&
&.495E-03_JPRB,.495E-03_JPRB,.847E-03_JPRB,.847E-03_JPRB,.232E-02_JPRB,.232E-02_JPRB,.267E-02_JPRB,&
&.267E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.764E-02_JPRB,.764E-02_JPRB,&
&.738E-02_JPRB,.738E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 34 -42.0
ZAER (:,34, 8) = (/&
&.556E-02_JPRB,.556E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.663E-02_JPRB,&
&.663E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,&
&.269E-02_JPRB,.269E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.113E-02_JPRB,&
&.113E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.672E-02_JPRB,.672E-02_JPRB,.465E-02_JPRB,&
&.465E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.250E-02_JPRB,.250E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.987E-03_JPRB,&
&.987E-03_JPRB,.816E-03_JPRB,.816E-03_JPRB,.752E-03_JPRB,.752E-03_JPRB,.644E-03_JPRB,.644E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,&
&.573E-02_JPRB,.573E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 35 -46.0
ZAER (:,35, 8) = (/&
&.556E-02_JPRB,.556E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.663E-02_JPRB,&
&.663E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,&
&.269E-02_JPRB,.269E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.113E-02_JPRB,&
&.113E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.672E-02_JPRB,.672E-02_JPRB,.465E-02_JPRB,&
&.465E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.250E-02_JPRB,.250E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.987E-03_JPRB,&
&.987E-03_JPRB,.816E-03_JPRB,.816E-03_JPRB,.752E-03_JPRB,.752E-03_JPRB,.644E-03_JPRB,.644E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,&
&.573E-02_JPRB,.573E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 36 -50.0
ZAER (:,36, 8) = (/&
&.488E-02_JPRB,.488E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.508E-02_JPRB,&
&.508E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.842E-03_JPRB,.842E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,.871E-03_JPRB,&
&.871E-03_JPRB,.702E-03_JPRB,.702E-03_JPRB,.210E-02_JPRB,.210E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,&
&.631E-02_JPRB,.631E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.491E-02_JPRB,&
&.491E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,.677E-03_JPRB,.677E-03_JPRB,.609E-03_JPRB,&
&.609E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.546E-03_JPRB,.546E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,&
&.465E-03_JPRB,.465E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.565E-03_JPRB,&
&.565E-03_JPRB,.203E-02_JPRB,.203E-02_JPRB,.355E-02_JPRB,.355E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,&
&.526E-02_JPRB,.526E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 37 -54.0
ZAER (:,37, 8) = (/&
&.488E-02_JPRB,.488E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.508E-02_JPRB,&
&.508E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.842E-03_JPRB,.842E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,.871E-03_JPRB,&
&.871E-03_JPRB,.702E-03_JPRB,.702E-03_JPRB,.210E-02_JPRB,.210E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,&
&.631E-02_JPRB,.631E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.491E-02_JPRB,&
&.491E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,.677E-03_JPRB,.677E-03_JPRB,.609E-03_JPRB,&
&.609E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.546E-03_JPRB,.546E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,&
&.465E-03_JPRB,.465E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.565E-03_JPRB,&
&.565E-03_JPRB,.203E-02_JPRB,.203E-02_JPRB,.355E-02_JPRB,.355E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,&
&.526E-02_JPRB,.526E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 38 -58.0
ZAER (:,38, 8) = (/&
&.431E-02_JPRB,.431E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.560E-03_JPRB,.560E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.610E-03_JPRB,.610E-03_JPRB,.259E-02_JPRB,.259E-02_JPRB,.178E-02_JPRB,&
&.178E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.397E-02_JPRB,.397E-02_JPRB,&
&.595E-02_JPRB,.595E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,.695E-02_JPRB,.695E-02_JPRB,.581E-02_JPRB,&
&.581E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.956E-03_JPRB,.956E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,.689E-03_JPRB,&
&.689E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.488E-03_JPRB,.488E-03_JPRB,&
&.433E-03_JPRB,.433E-03_JPRB,.398E-03_JPRB,.398E-03_JPRB,.363E-03_JPRB,.363E-03_JPRB,.381E-03_JPRB,&
&.381E-03_JPRB,.111E-02_JPRB,.111E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,&
&.363E-02_JPRB,.363E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 39 -62.0
ZAER (:,39, 8) = (/&
&.431E-02_JPRB,.431E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.560E-03_JPRB,.560E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.610E-03_JPRB,.610E-03_JPRB,.259E-02_JPRB,.259E-02_JPRB,.178E-02_JPRB,&
&.178E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.397E-02_JPRB,.397E-02_JPRB,&
&.595E-02_JPRB,.595E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,.695E-02_JPRB,.695E-02_JPRB,.581E-02_JPRB,&
&.581E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.956E-03_JPRB,.956E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,.689E-03_JPRB,&
&.689E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.488E-03_JPRB,.488E-03_JPRB,&
&.433E-03_JPRB,.433E-03_JPRB,.398E-03_JPRB,.398E-03_JPRB,.363E-03_JPRB,.363E-03_JPRB,.381E-03_JPRB,&
&.381E-03_JPRB,.111E-02_JPRB,.111E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,&
&.363E-02_JPRB,.363E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 40 -66.0
ZAER (:,40, 8) = (/&
&.153E-02_JPRB,.153E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,.709E-03_JPRB,.709E-03_JPRB,.547E-03_JPRB,&
&.547E-03_JPRB,.834E-03_JPRB,.834E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.641E-03_JPRB,.641E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.111E-02_JPRB,&
&.111E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,&
&.133E-02_JPRB,.133E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.552E-02_JPRB,&
&.552E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.713E-03_JPRB,.713E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,&
&.398E-03_JPRB,.398E-03_JPRB,.356E-03_JPRB,.356E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.363E-03_JPRB,&
&.363E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.455E-03_JPRB,.455E-03_JPRB,.601E-03_JPRB,.601E-03_JPRB,&
&.749E-03_JPRB,.749E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 41 -70.0
ZAER (:,41, 8) = (/&
&.153E-02_JPRB,.153E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,.709E-03_JPRB,.709E-03_JPRB,.547E-03_JPRB,&
&.547E-03_JPRB,.834E-03_JPRB,.834E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.641E-03_JPRB,.641E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.111E-02_JPRB,&
&.111E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,&
&.133E-02_JPRB,.133E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.552E-02_JPRB,&
&.552E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.713E-03_JPRB,.713E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,&
&.398E-03_JPRB,.398E-03_JPRB,.356E-03_JPRB,.356E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.363E-03_JPRB,&
&.363E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.455E-03_JPRB,.455E-03_JPRB,.601E-03_JPRB,.601E-03_JPRB,&
&.749E-03_JPRB,.749E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 42 -74.0
ZAER (:,42, 8) = (/&
&.546E-03_JPRB,.546E-03_JPRB,.905E-03_JPRB,.905E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.360E-03_JPRB,&
&.360E-03_JPRB,.518E-03_JPRB,.518E-03_JPRB,.687E-03_JPRB,.687E-03_JPRB,.498E-03_JPRB,.498E-03_JPRB,&
&.465E-03_JPRB,.465E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,.121E-02_JPRB,&
&.121E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.843E-03_JPRB,.843E-03_JPRB,&
&.575E-03_JPRB,.575E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.314E-02_JPRB,&
&.314E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.373E-02_JPRB,.373E-02_JPRB,.332E-02_JPRB,.332E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.566E-03_JPRB,.566E-03_JPRB,&
&.403E-03_JPRB,.403E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,.121E-02_JPRB,&
&.121E-02_JPRB,.361E-03_JPRB,.361E-03_JPRB,.299E-03_JPRB,.299E-03_JPRB,.322E-03_JPRB,.322E-03_JPRB,&
&.359E-03_JPRB,.359E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 43 -78.0
ZAER (:,43, 8) = (/&
&.546E-03_JPRB,.546E-03_JPRB,.905E-03_JPRB,.905E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.360E-03_JPRB,&
&.360E-03_JPRB,.518E-03_JPRB,.518E-03_JPRB,.687E-03_JPRB,.687E-03_JPRB,.498E-03_JPRB,.498E-03_JPRB,&
&.465E-03_JPRB,.465E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,.121E-02_JPRB,&
&.121E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.843E-03_JPRB,.843E-03_JPRB,&
&.575E-03_JPRB,.575E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.314E-02_JPRB,&
&.314E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.373E-02_JPRB,.373E-02_JPRB,.332E-02_JPRB,.332E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.566E-03_JPRB,.566E-03_JPRB,&
&.403E-03_JPRB,.403E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,.121E-02_JPRB,&
&.121E-02_JPRB,.361E-03_JPRB,.361E-03_JPRB,.299E-03_JPRB,.299E-03_JPRB,.322E-03_JPRB,.322E-03_JPRB,&
&.359E-03_JPRB,.359E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 44 -82.0
ZAER (:,44, 8) = (/&
&.354E-03_JPRB,.354E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.312E-03_JPRB,&
&.312E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.506E-03_JPRB,.506E-03_JPRB,.622E-03_JPRB,&
&.622E-03_JPRB,.828E-03_JPRB,.828E-03_JPRB,.830E-03_JPRB,.830E-03_JPRB,.680E-03_JPRB,.680E-03_JPRB,&
&.575E-03_JPRB,.575E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.923E-03_JPRB,.923E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.644E-03_JPRB,.644E-03_JPRB,&
&.482E-03_JPRB,.482E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.507E-03_JPRB,&
&.507E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,&
&.370E-03_JPRB,.370E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.391E-03_JPRB,.391E-03_JPRB,.338E-03_JPRB,&
&.338E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.282E-03_JPRB,.282E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 45 -86.0
ZAER (:,45, 8) = (/&
&.354E-03_JPRB,.354E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.312E-03_JPRB,&
&.312E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.506E-03_JPRB,.506E-03_JPRB,.622E-03_JPRB,&
&.622E-03_JPRB,.828E-03_JPRB,.828E-03_JPRB,.830E-03_JPRB,.830E-03_JPRB,.680E-03_JPRB,.680E-03_JPRB,&
&.575E-03_JPRB,.575E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.923E-03_JPRB,.923E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.644E-03_JPRB,.644E-03_JPRB,&
&.482E-03_JPRB,.482E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.507E-03_JPRB,&
&.507E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,&
&.370E-03_JPRB,.370E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.391E-03_JPRB,.391E-03_JPRB,.338E-03_JPRB,&
&.338E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.282E-03_JPRB,.282E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 46 -90.0
ZAER (:,46, 8) = (/&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=8   
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_08
