SUBROUTINE SUECAESS_07

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      July

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,7:7)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  7 --- lat:  1  90.0
ZAER (:, 1, 7) = (/&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  2  86.0
ZAER (:, 2, 7) = (/&
&.782E-03_JPRB,.782E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,.948E-03_JPRB,&
&.948E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.977E-03_JPRB,.977E-03_JPRB,.963E-03_JPRB,.963E-03_JPRB,&
&.906E-03_JPRB,.906E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,.756E-03_JPRB,&
&.756E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,.708E-03_JPRB,.708E-03_JPRB,.694E-03_JPRB,.694E-03_JPRB,&
&.661E-03_JPRB,.661E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.331E-03_JPRB,&
&.331E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,&
&.217E-03_JPRB,.217E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.250E-03_JPRB,&
&.250E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,&
&.301E-03_JPRB,.301E-03_JPRB,.317E-03_JPRB,.317E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.345E-03_JPRB,&
&.345E-03_JPRB,.381E-03_JPRB,.381E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.517E-03_JPRB,.517E-03_JPRB,&
&.670E-03_JPRB,.670E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  3  82.0
ZAER (:, 3, 7) = (/&
&.782E-03_JPRB,.782E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,.948E-03_JPRB,&
&.948E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.977E-03_JPRB,.977E-03_JPRB,.963E-03_JPRB,.963E-03_JPRB,&
&.906E-03_JPRB,.906E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,.756E-03_JPRB,&
&.756E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,.708E-03_JPRB,.708E-03_JPRB,.694E-03_JPRB,.694E-03_JPRB,&
&.661E-03_JPRB,.661E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.331E-03_JPRB,&
&.331E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,&
&.217E-03_JPRB,.217E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.250E-03_JPRB,&
&.250E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,&
&.301E-03_JPRB,.301E-03_JPRB,.317E-03_JPRB,.317E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.345E-03_JPRB,&
&.345E-03_JPRB,.381E-03_JPRB,.381E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.517E-03_JPRB,.517E-03_JPRB,&
&.670E-03_JPRB,.670E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  4  78.0
ZAER (:, 4, 7) = (/&
&.113E-02_JPRB,.113E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.113E-02_JPRB,&
&.113E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,.999E-03_JPRB,.999E-03_JPRB,&
&.106E-02_JPRB,.106E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.994E-03_JPRB,.994E-03_JPRB,.904E-03_JPRB,&
&.904E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,.806E-03_JPRB,.806E-03_JPRB,.869E-03_JPRB,.869E-03_JPRB,&
&.889E-03_JPRB,.889E-03_JPRB,.840E-03_JPRB,.840E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,.499E-03_JPRB,&
&.499E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.245E-03_JPRB,.245E-03_JPRB,.283E-03_JPRB,.283E-03_JPRB,&
&.349E-03_JPRB,.349E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.369E-03_JPRB,.369E-03_JPRB,.352E-03_JPRB,&
&.352E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,&
&.396E-03_JPRB,.396E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.477E-03_JPRB,&
&.477E-03_JPRB,.534E-03_JPRB,.534E-03_JPRB,.617E-03_JPRB,.617E-03_JPRB,.778E-03_JPRB,.778E-03_JPRB,&
&.997E-03_JPRB,.997E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  5  74.0
ZAER (:, 5, 7) = (/&
&.113E-02_JPRB,.113E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.113E-02_JPRB,&
&.113E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,.999E-03_JPRB,.999E-03_JPRB,&
&.106E-02_JPRB,.106E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.994E-03_JPRB,.994E-03_JPRB,.904E-03_JPRB,&
&.904E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,.806E-03_JPRB,.806E-03_JPRB,.869E-03_JPRB,.869E-03_JPRB,&
&.889E-03_JPRB,.889E-03_JPRB,.840E-03_JPRB,.840E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,.499E-03_JPRB,&
&.499E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.245E-03_JPRB,.245E-03_JPRB,.283E-03_JPRB,.283E-03_JPRB,&
&.349E-03_JPRB,.349E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.369E-03_JPRB,.369E-03_JPRB,.352E-03_JPRB,&
&.352E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,&
&.396E-03_JPRB,.396E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.477E-03_JPRB,&
&.477E-03_JPRB,.534E-03_JPRB,.534E-03_JPRB,.617E-03_JPRB,.617E-03_JPRB,.778E-03_JPRB,.778E-03_JPRB,&
&.997E-03_JPRB,.997E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  6  70.0
ZAER (:, 6, 7) = (/&
&.210E-02_JPRB,.210E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.181E-02_JPRB,&
&.181E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.157E-02_JPRB,.157E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.960E-03_JPRB,.960E-03_JPRB,.818E-03_JPRB,.818E-03_JPRB,.707E-03_JPRB,&
&.707E-03_JPRB,.587E-03_JPRB,.587E-03_JPRB,.460E-03_JPRB,.460E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,&
&.685E-03_JPRB,.685E-03_JPRB,.853E-03_JPRB,.853E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,.638E-03_JPRB,&
&.638E-03_JPRB,.611E-03_JPRB,.611E-03_JPRB,.702E-03_JPRB,.702E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,&
&.743E-03_JPRB,.743E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.813E-03_JPRB,.813E-03_JPRB,.994E-03_JPRB,&
&.994E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.162E-02_JPRB,.162E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  7  66.0
ZAER (:, 7, 7) = (/&
&.210E-02_JPRB,.210E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.181E-02_JPRB,&
&.181E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.157E-02_JPRB,.157E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.960E-03_JPRB,.960E-03_JPRB,.818E-03_JPRB,.818E-03_JPRB,.707E-03_JPRB,&
&.707E-03_JPRB,.587E-03_JPRB,.587E-03_JPRB,.460E-03_JPRB,.460E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,&
&.685E-03_JPRB,.685E-03_JPRB,.853E-03_JPRB,.853E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,.638E-03_JPRB,&
&.638E-03_JPRB,.611E-03_JPRB,.611E-03_JPRB,.702E-03_JPRB,.702E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,&
&.743E-03_JPRB,.743E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.813E-03_JPRB,.813E-03_JPRB,.994E-03_JPRB,&
&.994E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.162E-02_JPRB,.162E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  8  62.0
ZAER (:, 8, 7) = (/&
&.789E-02_JPRB,.789E-02_JPRB,.728E-02_JPRB,.728E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.387E-02_JPRB,&
&.387E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.850E-02_JPRB,&
&.850E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.197E-02_JPRB,.197E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.194E-02_JPRB,&
&.194E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.197E-02_JPRB,.197E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,.213E-02_JPRB,&
&.213E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.201E-02_JPRB,.201E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.406E-02_JPRB,&
&.406E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,&
&.743E-02_JPRB,.743E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  9  58.0
ZAER (:, 9, 7) = (/&
&.789E-02_JPRB,.789E-02_JPRB,.728E-02_JPRB,.728E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.387E-02_JPRB,&
&.387E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.850E-02_JPRB,&
&.850E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.197E-02_JPRB,.197E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.194E-02_JPRB,&
&.194E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.197E-02_JPRB,.197E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,.213E-02_JPRB,&
&.213E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.201E-02_JPRB,.201E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.406E-02_JPRB,&
&.406E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,&
&.743E-02_JPRB,.743E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 10  54.0
ZAER (:,10, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.941E-02_JPRB,.941E-02_JPRB,.939E-02_JPRB,&
&.939E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.155E-01_JPRB,.155E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.831E-02_JPRB,.831E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.835E-02_JPRB,.835E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.849E-02_JPRB,.849E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.944E-02_JPRB,&
&.944E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,&
&.881E-02_JPRB,.881E-02_JPRB,.979E-02_JPRB,.979E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.999E-02_JPRB,.999E-02_JPRB,&
&.983E-02_JPRB,.983E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 11  50.0
ZAER (:,11, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.941E-02_JPRB,.941E-02_JPRB,.939E-02_JPRB,&
&.939E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.155E-01_JPRB,.155E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.831E-02_JPRB,.831E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.835E-02_JPRB,.835E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.849E-02_JPRB,.849E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.944E-02_JPRB,&
&.944E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,&
&.881E-02_JPRB,.881E-02_JPRB,.979E-02_JPRB,.979E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.999E-02_JPRB,.999E-02_JPRB,&
&.983E-02_JPRB,.983E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 12  46.0
ZAER (:,12, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.981E-02_JPRB,&
&.981E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.120E-01_JPRB,.120E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.138E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.822E-02_JPRB,.822E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 13  42.0
ZAER (:,13, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.981E-02_JPRB,&
&.981E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.120E-01_JPRB,.120E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.138E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.822E-02_JPRB,.822E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 14  38.0
ZAER (:,14, 7) = (/&
&.106E-01_JPRB,.106E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.813E-02_JPRB,&
&.813E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.922E-02_JPRB,.922E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.956E-02_JPRB,.956E-02_JPRB,&
&.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.643E-02_JPRB,.643E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.974E-02_JPRB,.974E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 15  34.0
ZAER (:,15, 7) = (/&
&.106E-01_JPRB,.106E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.813E-02_JPRB,&
&.813E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.922E-02_JPRB,.922E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.956E-02_JPRB,.956E-02_JPRB,&
&.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.643E-02_JPRB,.643E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.974E-02_JPRB,.974E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 16  30.0
ZAER (:,16, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.970E-02_JPRB,.970E-02_JPRB,.789E-02_JPRB,&
&.789E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.541E-02_JPRB,.541E-02_JPRB,&
&.807E-02_JPRB,.807E-02_JPRB,.908E-02_JPRB,.908E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.942E-02_JPRB,&
&.942E-02_JPRB,.916E-02_JPRB,.916E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.600E-02_JPRB,.600E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,.106E-01_JPRB,&
&.106E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.823E-02_JPRB,.823E-02_JPRB,.489E-02_JPRB,.489E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,&
&.957E-02_JPRB,.957E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 17  26.0
ZAER (:,17, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.970E-02_JPRB,.970E-02_JPRB,.789E-02_JPRB,&
&.789E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.541E-02_JPRB,.541E-02_JPRB,&
&.807E-02_JPRB,.807E-02_JPRB,.908E-02_JPRB,.908E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.942E-02_JPRB,&
&.942E-02_JPRB,.916E-02_JPRB,.916E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.600E-02_JPRB,.600E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,.106E-01_JPRB,&
&.106E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.823E-02_JPRB,.823E-02_JPRB,.489E-02_JPRB,.489E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,&
&.957E-02_JPRB,.957E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 18  22.0
ZAER (:,18, 7) = (/&
&.112E-01_JPRB,.112E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.793E-02_JPRB,&
&.793E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,&
&.703E-02_JPRB,.703E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.898E-02_JPRB,&
&.898E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.479E-02_JPRB,.479E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,&
&.331E-02_JPRB,.331E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.915E-02_JPRB,.915E-02_JPRB,.564E-02_JPRB,.564E-02_JPRB,.485E-02_JPRB,&
&.485E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.914E-02_JPRB,.914E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 19  18.0
ZAER (:,19, 7) = (/&
&.112E-01_JPRB,.112E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.793E-02_JPRB,&
&.793E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,&
&.703E-02_JPRB,.703E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.898E-02_JPRB,&
&.898E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.479E-02_JPRB,.479E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,&
&.331E-02_JPRB,.331E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.915E-02_JPRB,.915E-02_JPRB,.564E-02_JPRB,.564E-02_JPRB,.485E-02_JPRB,&
&.485E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.914E-02_JPRB,.914E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 20  14.0
ZAER (:,20, 7) = (/&
&.145E-01_JPRB,.145E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.167E-01_JPRB,.167E-01_JPRB,.166E-01_JPRB,&
&.166E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.934E-02_JPRB,.934E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.571E-02_JPRB,&
&.571E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.726E-02_JPRB,&
&.726E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,&
&.371E-02_JPRB,.371E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.121E-01_JPRB,.121E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.850E-02_JPRB,.850E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,.123E-01_JPRB,.123E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 21  10.0
ZAER (:,21, 7) = (/&
&.145E-01_JPRB,.145E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.167E-01_JPRB,.167E-01_JPRB,.166E-01_JPRB,&
&.166E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.934E-02_JPRB,.934E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.571E-02_JPRB,&
&.571E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.726E-02_JPRB,&
&.726E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,&
&.371E-02_JPRB,.371E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.121E-01_JPRB,.121E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.850E-02_JPRB,.850E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,.123E-01_JPRB,.123E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 22   6.0
ZAER (:,22, 7) = (/&
&.152E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.905E-02_JPRB,.905E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.314E-02_JPRB,&
&.314E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,&
&.945E-02_JPRB,.945E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,.488E-02_JPRB,&
&.488E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,&
&.642E-02_JPRB,.642E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 23   2.0
ZAER (:,23, 7) = (/&
&.152E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.905E-02_JPRB,.905E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.314E-02_JPRB,&
&.314E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,&
&.945E-02_JPRB,.945E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,.488E-02_JPRB,&
&.488E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,&
&.642E-02_JPRB,.642E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 24  -2.0
ZAER (:,24, 7) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.833E-02_JPRB,.833E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.327E-02_JPRB,&
&.327E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.939E-02_JPRB,.939E-02_JPRB,.680E-02_JPRB,.680E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.331E-02_JPRB,&
&.331E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,&
&.499E-02_JPRB,.499E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.850E-02_JPRB,&
&.850E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,&
&.484E-02_JPRB,.484E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.750E-02_JPRB,&
&.750E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 25  -6.0
ZAER (:,25, 7) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.833E-02_JPRB,.833E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.327E-02_JPRB,&
&.327E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.939E-02_JPRB,.939E-02_JPRB,.680E-02_JPRB,.680E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.331E-02_JPRB,&
&.331E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,&
&.499E-02_JPRB,.499E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.850E-02_JPRB,&
&.850E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,&
&.484E-02_JPRB,.484E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.750E-02_JPRB,&
&.750E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 26 -10.0
ZAER (:,26, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.137E-01_JPRB,&
&.137E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.948E-02_JPRB,.948E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,&
&.730E-02_JPRB,.730E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.669E-02_JPRB,&
&.669E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,&
&.907E-02_JPRB,.907E-02_JPRB,.523E-02_JPRB,.523E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.107E-02_JPRB,&
&.107E-02_JPRB,.549E-03_JPRB,.549E-03_JPRB,.424E-03_JPRB,.424E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.703E-02_JPRB,.703E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,.658E-02_JPRB,.658E-02_JPRB,&
&.307E-02_JPRB,.307E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.556E-02_JPRB,&
&.556E-02_JPRB,.620E-02_JPRB,.620E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,&
&.943E-02_JPRB,.943E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 27 -14.0
ZAER (:,27, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.137E-01_JPRB,&
&.137E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.948E-02_JPRB,.948E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,&
&.730E-02_JPRB,.730E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.669E-02_JPRB,&
&.669E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,&
&.907E-02_JPRB,.907E-02_JPRB,.523E-02_JPRB,.523E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.107E-02_JPRB,&
&.107E-02_JPRB,.549E-03_JPRB,.549E-03_JPRB,.424E-03_JPRB,.424E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.703E-02_JPRB,.703E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,.658E-02_JPRB,.658E-02_JPRB,&
&.307E-02_JPRB,.307E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.556E-02_JPRB,&
&.556E-02_JPRB,.620E-02_JPRB,.620E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,&
&.943E-02_JPRB,.943E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 28 -18.0
ZAER (:,28, 7) = (/&
&.116E-01_JPRB,.116E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,&
&.497E-02_JPRB,.497E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.752E-02_JPRB,&
&.752E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.692E-02_JPRB,.692E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.849E-03_JPRB,&
&.849E-03_JPRB,.789E-03_JPRB,.789E-03_JPRB,.819E-03_JPRB,.819E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.198E-02_JPRB,.198E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.920E-02_JPRB,&
&.920E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,&
&.149E-02_JPRB,.149E-02_JPRB,.269E-02_JPRB,.269E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 29 -22.0
ZAER (:,29, 7) = (/&
&.116E-01_JPRB,.116E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,&
&.497E-02_JPRB,.497E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.752E-02_JPRB,&
&.752E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.692E-02_JPRB,.692E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.849E-03_JPRB,&
&.849E-03_JPRB,.789E-03_JPRB,.789E-03_JPRB,.819E-03_JPRB,.819E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.198E-02_JPRB,.198E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.920E-02_JPRB,&
&.920E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,&
&.149E-02_JPRB,.149E-02_JPRB,.269E-02_JPRB,.269E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 30 -26.0
ZAER (:,30, 7) = (/&
&.996E-02_JPRB,.996E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.956E-02_JPRB,.956E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.284E-02_JPRB,.284E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.652E-02_JPRB,.652E-02_JPRB,.277E-02_JPRB,&
&.277E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.221E-02_JPRB,&
&.221E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.773E-03_JPRB,.773E-03_JPRB,.527E-03_JPRB,.527E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.273E-02_JPRB,.273E-02_JPRB,.424E-02_JPRB,&
&.424E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,&
&.888E-02_JPRB,.888E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 31 -30.0
ZAER (:,31, 7) = (/&
&.996E-02_JPRB,.996E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.956E-02_JPRB,.956E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.284E-02_JPRB,.284E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.652E-02_JPRB,.652E-02_JPRB,.277E-02_JPRB,&
&.277E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.221E-02_JPRB,&
&.221E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.773E-03_JPRB,.773E-03_JPRB,.527E-03_JPRB,.527E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.273E-02_JPRB,.273E-02_JPRB,.424E-02_JPRB,&
&.424E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,&
&.888E-02_JPRB,.888E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 32 -34.0
ZAER (:,32, 7) = (/&
&.519E-02_JPRB,.519E-02_JPRB,.555E-02_JPRB,.555E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.730E-02_JPRB,&
&.730E-02_JPRB,.679E-02_JPRB,.679E-02_JPRB,.562E-02_JPRB,.562E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,&
&.301E-02_JPRB,.301E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.307E-02_JPRB,&
&.307E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,&
&.747E-02_JPRB,.747E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.462E-02_JPRB,&
&.462E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,&
&.274E-02_JPRB,.274E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.781E-03_JPRB,.781E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,&
&.274E-03_JPRB,.274E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.186E-02_JPRB,.186E-02_JPRB,.292E-02_JPRB,&
&.292E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.579E-02_JPRB,.579E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,&
&.505E-02_JPRB,.505E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 33 -38.0
ZAER (:,33, 7) = (/&
&.519E-02_JPRB,.519E-02_JPRB,.555E-02_JPRB,.555E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.730E-02_JPRB,&
&.730E-02_JPRB,.679E-02_JPRB,.679E-02_JPRB,.562E-02_JPRB,.562E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,&
&.301E-02_JPRB,.301E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.307E-02_JPRB,&
&.307E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,&
&.747E-02_JPRB,.747E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.462E-02_JPRB,&
&.462E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,&
&.274E-02_JPRB,.274E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.781E-03_JPRB,.781E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,&
&.274E-03_JPRB,.274E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.186E-02_JPRB,.186E-02_JPRB,.292E-02_JPRB,&
&.292E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.579E-02_JPRB,.579E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,&
&.505E-02_JPRB,.505E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 34 -42.0
ZAER (:,34, 7) = (/&
&.488E-02_JPRB,.488E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.600E-02_JPRB,&
&.600E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,&
&.194E-02_JPRB,.194E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.887E-03_JPRB,&
&.887E-03_JPRB,.233E-02_JPRB,.233E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,&
&.677E-02_JPRB,.677E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.436E-02_JPRB,&
&.436E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,&
&.200E-02_JPRB,.200E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.870E-03_JPRB,&
&.870E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,&
&.287E-03_JPRB,.287E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.392E-02_JPRB,.392E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,&
&.430E-02_JPRB,.430E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 35 -46.0
ZAER (:,35, 7) = (/&
&.488E-02_JPRB,.488E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.600E-02_JPRB,&
&.600E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,&
&.194E-02_JPRB,.194E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.887E-03_JPRB,&
&.887E-03_JPRB,.233E-02_JPRB,.233E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,&
&.677E-02_JPRB,.677E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.436E-02_JPRB,&
&.436E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,&
&.200E-02_JPRB,.200E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.870E-03_JPRB,&
&.870E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,&
&.287E-03_JPRB,.287E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.392E-02_JPRB,.392E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,&
&.430E-02_JPRB,.430E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 36 -50.0
ZAER (:,36, 7) = (/&
&.428E-02_JPRB,.428E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.500E-02_JPRB,&
&.500E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.678E-03_JPRB,.678E-03_JPRB,&
&.576E-03_JPRB,.576E-03_JPRB,.588E-03_JPRB,.588E-03_JPRB,.805E-03_JPRB,.805E-03_JPRB,.904E-03_JPRB,&
&.904E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,.178E-02_JPRB,.178E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,&
&.566E-02_JPRB,.566E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.435E-02_JPRB,&
&.435E-02_JPRB,.258E-02_JPRB,.258E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.108E-02_JPRB,.108E-02_JPRB,.849E-03_JPRB,.849E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,.523E-03_JPRB,&
&.523E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.437E-03_JPRB,.437E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.341E-03_JPRB,&
&.341E-03_JPRB,.138E-02_JPRB,.138E-02_JPRB,.284E-02_JPRB,.284E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,&
&.370E-02_JPRB,.370E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 37 -54.0
ZAER (:,37, 7) = (/&
&.428E-02_JPRB,.428E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.500E-02_JPRB,&
&.500E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.678E-03_JPRB,.678E-03_JPRB,&
&.576E-03_JPRB,.576E-03_JPRB,.588E-03_JPRB,.588E-03_JPRB,.805E-03_JPRB,.805E-03_JPRB,.904E-03_JPRB,&
&.904E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,.178E-02_JPRB,.178E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,&
&.566E-02_JPRB,.566E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.435E-02_JPRB,&
&.435E-02_JPRB,.258E-02_JPRB,.258E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.108E-02_JPRB,.108E-02_JPRB,.849E-03_JPRB,.849E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,.523E-03_JPRB,&
&.523E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.437E-03_JPRB,.437E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.341E-03_JPRB,&
&.341E-03_JPRB,.138E-02_JPRB,.138E-02_JPRB,.284E-02_JPRB,.284E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,&
&.370E-02_JPRB,.370E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 38 -58.0
ZAER (:,38, 7) = (/&
&.340E-02_JPRB,.340E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.219E-02_JPRB,&
&.219E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.684E-03_JPRB,.684E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.367E-03_JPRB,.367E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.246E-02_JPRB,.246E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,&
&.462E-02_JPRB,.462E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.486E-02_JPRB,&
&.486E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.945E-03_JPRB,.945E-03_JPRB,.739E-03_JPRB,.739E-03_JPRB,.578E-03_JPRB,.578E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.443E-03_JPRB,.443E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,&
&.350E-03_JPRB,.350E-03_JPRB,.321E-03_JPRB,.321E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.315E-03_JPRB,&
&.315E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.173E-02_JPRB,.173E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,&
&.271E-02_JPRB,.271E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 39 -62.0
ZAER (:,39, 7) = (/&
&.340E-02_JPRB,.340E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.219E-02_JPRB,&
&.219E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.684E-03_JPRB,.684E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.367E-03_JPRB,.367E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.246E-02_JPRB,.246E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,&
&.462E-02_JPRB,.462E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.486E-02_JPRB,&
&.486E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.945E-03_JPRB,.945E-03_JPRB,.739E-03_JPRB,.739E-03_JPRB,.578E-03_JPRB,.578E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.443E-03_JPRB,.443E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,&
&.350E-03_JPRB,.350E-03_JPRB,.321E-03_JPRB,.321E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.315E-03_JPRB,&
&.315E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.173E-02_JPRB,.173E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,&
&.271E-02_JPRB,.271E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 40 -66.0
ZAER (:,40, 7) = (/&
&.165E-02_JPRB,.165E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.739E-03_JPRB,&
&.739E-03_JPRB,.933E-03_JPRB,.933E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,.617E-03_JPRB,.617E-03_JPRB,&
&.486E-03_JPRB,.486E-03_JPRB,.684E-03_JPRB,.684E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.912E-03_JPRB,.912E-03_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.284E-02_JPRB,.284E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.139E-02_JPRB,.139E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.675E-03_JPRB,.675E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,.391E-03_JPRB,.391E-03_JPRB,&
&.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.492E-03_JPRB,&
&.492E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,&
&.867E-03_JPRB,.867E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 41 -70.0
ZAER (:,41, 7) = (/&
&.165E-02_JPRB,.165E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.739E-03_JPRB,&
&.739E-03_JPRB,.933E-03_JPRB,.933E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,.617E-03_JPRB,.617E-03_JPRB,&
&.486E-03_JPRB,.486E-03_JPRB,.684E-03_JPRB,.684E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.912E-03_JPRB,.912E-03_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.284E-02_JPRB,.284E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.139E-02_JPRB,.139E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.675E-03_JPRB,.675E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,.391E-03_JPRB,.391E-03_JPRB,&
&.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.492E-03_JPRB,&
&.492E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,&
&.867E-03_JPRB,.867E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 42 -74.0
ZAER (:,42, 7) = (/&
&.766E-03_JPRB,.766E-03_JPRB,.113E-02_JPRB,.113E-02_JPRB,.800E-03_JPRB,.800E-03_JPRB,.613E-03_JPRB,&
&.613E-03_JPRB,.686E-03_JPRB,.686E-03_JPRB,.820E-03_JPRB,.820E-03_JPRB,.614E-03_JPRB,.614E-03_JPRB,&
&.543E-03_JPRB,.543E-03_JPRB,.535E-03_JPRB,.535E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.513E-03_JPRB,.513E-03_JPRB,&
&.427E-03_JPRB,.427E-03_JPRB,.442E-03_JPRB,.442E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,.251E-02_JPRB,&
&.251E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.248E-02_JPRB,.248E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,&
&.243E-02_JPRB,.243E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.555E-03_JPRB,.555E-03_JPRB,&
&.358E-03_JPRB,.358E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.140E-02_JPRB,&
&.140E-02_JPRB,.440E-03_JPRB,.440E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.456E-03_JPRB,.456E-03_JPRB,&
&.573E-03_JPRB,.573E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 43 -78.0
ZAER (:,43, 7) = (/&
&.766E-03_JPRB,.766E-03_JPRB,.113E-02_JPRB,.113E-02_JPRB,.800E-03_JPRB,.800E-03_JPRB,.613E-03_JPRB,&
&.613E-03_JPRB,.686E-03_JPRB,.686E-03_JPRB,.820E-03_JPRB,.820E-03_JPRB,.614E-03_JPRB,.614E-03_JPRB,&
&.543E-03_JPRB,.543E-03_JPRB,.535E-03_JPRB,.535E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.513E-03_JPRB,.513E-03_JPRB,&
&.427E-03_JPRB,.427E-03_JPRB,.442E-03_JPRB,.442E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,.251E-02_JPRB,&
&.251E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.248E-02_JPRB,.248E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,&
&.243E-02_JPRB,.243E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.555E-03_JPRB,.555E-03_JPRB,&
&.358E-03_JPRB,.358E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.140E-02_JPRB,&
&.140E-02_JPRB,.440E-03_JPRB,.440E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.456E-03_JPRB,.456E-03_JPRB,&
&.573E-03_JPRB,.573E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 44 -82.0
ZAER (:,44, 7) = (/&
&.398E-03_JPRB,.398E-03_JPRB,.378E-03_JPRB,.378E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.348E-03_JPRB,&
&.348E-03_JPRB,.356E-03_JPRB,.356E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,&
&.362E-03_JPRB,.362E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.383E-03_JPRB,.383E-03_JPRB,&
&.372E-03_JPRB,.372E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.622E-03_JPRB,.622E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB,.469E-03_JPRB,.469E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.421E-03_JPRB,&
&.421E-03_JPRB,.398E-03_JPRB,.398E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.405E-03_JPRB,.405E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.401E-03_JPRB,&
&.401E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,&
&.400E-03_JPRB,.400E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 45 -86.0
ZAER (:,45, 7) = (/&
&.398E-03_JPRB,.398E-03_JPRB,.378E-03_JPRB,.378E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.348E-03_JPRB,&
&.348E-03_JPRB,.356E-03_JPRB,.356E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,&
&.362E-03_JPRB,.362E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.383E-03_JPRB,.383E-03_JPRB,&
&.372E-03_JPRB,.372E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.622E-03_JPRB,.622E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB,.469E-03_JPRB,.469E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.421E-03_JPRB,&
&.421E-03_JPRB,.398E-03_JPRB,.398E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.405E-03_JPRB,.405E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.401E-03_JPRB,&
&.401E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,&
&.400E-03_JPRB,.400E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 46 -90.0
ZAER (:,46, 7) = (/&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=7   
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_07
