SUBROUTINE SUECAESS_06

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      June

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,6:6)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  6 --- lat:  1  90.0
ZAER (:, 1, 6) = (/&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  2  86.0
ZAER (:, 2, 6) = (/&
&.548E-03_JPRB,.548E-03_JPRB,.550E-03_JPRB,.550E-03_JPRB,.584E-03_JPRB,.584E-03_JPRB,.644E-03_JPRB,&
&.644E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,&
&.829E-03_JPRB,.829E-03_JPRB,.832E-03_JPRB,.832E-03_JPRB,.817E-03_JPRB,.817E-03_JPRB,.796E-03_JPRB,&
&.796E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,.756E-03_JPRB,.756E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,&
&.693E-03_JPRB,.693E-03_JPRB,.615E-03_JPRB,.615E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.401E-03_JPRB,&
&.401E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,&
&.288E-03_JPRB,.288E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,.290E-03_JPRB,.290E-03_JPRB,.292E-03_JPRB,&
&.292E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,&
&.275E-03_JPRB,.275E-03_JPRB,.297E-03_JPRB,.297E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.364E-03_JPRB,&
&.364E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,&
&.541E-03_JPRB,.541E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  3  82.0
ZAER (:, 3, 6) = (/&
&.548E-03_JPRB,.548E-03_JPRB,.550E-03_JPRB,.550E-03_JPRB,.584E-03_JPRB,.584E-03_JPRB,.644E-03_JPRB,&
&.644E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,&
&.829E-03_JPRB,.829E-03_JPRB,.832E-03_JPRB,.832E-03_JPRB,.817E-03_JPRB,.817E-03_JPRB,.796E-03_JPRB,&
&.796E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,.756E-03_JPRB,.756E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,&
&.693E-03_JPRB,.693E-03_JPRB,.615E-03_JPRB,.615E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.401E-03_JPRB,&
&.401E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,&
&.288E-03_JPRB,.288E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,.290E-03_JPRB,.290E-03_JPRB,.292E-03_JPRB,&
&.292E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,&
&.275E-03_JPRB,.275E-03_JPRB,.297E-03_JPRB,.297E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.364E-03_JPRB,&
&.364E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,&
&.541E-03_JPRB,.541E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  4  78.0
ZAER (:, 4, 6) = (/&
&.648E-03_JPRB,.648E-03_JPRB,.640E-03_JPRB,.640E-03_JPRB,.620E-03_JPRB,.620E-03_JPRB,.643E-03_JPRB,&
&.643E-03_JPRB,.699E-03_JPRB,.699E-03_JPRB,.761E-03_JPRB,.761E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.125E-02_JPRB,&
&.125E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.989E-03_JPRB,.989E-03_JPRB,.744E-03_JPRB,&
&.744E-03_JPRB,.477E-03_JPRB,.477E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,.413E-03_JPRB,.413E-03_JPRB,&
&.549E-03_JPRB,.549E-03_JPRB,.653E-03_JPRB,.653E-03_JPRB,.667E-03_JPRB,.667E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.456E-03_JPRB,.456E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,&
&.301E-03_JPRB,.301E-03_JPRB,.311E-03_JPRB,.311E-03_JPRB,.341E-03_JPRB,.341E-03_JPRB,.369E-03_JPRB,&
&.369E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,.564E-03_JPRB,.564E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,&
&.664E-03_JPRB,.664E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  5  74.0
ZAER (:, 5, 6) = (/&
&.648E-03_JPRB,.648E-03_JPRB,.640E-03_JPRB,.640E-03_JPRB,.620E-03_JPRB,.620E-03_JPRB,.643E-03_JPRB,&
&.643E-03_JPRB,.699E-03_JPRB,.699E-03_JPRB,.761E-03_JPRB,.761E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.125E-02_JPRB,&
&.125E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.989E-03_JPRB,.989E-03_JPRB,.744E-03_JPRB,&
&.744E-03_JPRB,.477E-03_JPRB,.477E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,.413E-03_JPRB,.413E-03_JPRB,&
&.549E-03_JPRB,.549E-03_JPRB,.653E-03_JPRB,.653E-03_JPRB,.667E-03_JPRB,.667E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.456E-03_JPRB,.456E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,&
&.301E-03_JPRB,.301E-03_JPRB,.311E-03_JPRB,.311E-03_JPRB,.341E-03_JPRB,.341E-03_JPRB,.369E-03_JPRB,&
&.369E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,.564E-03_JPRB,.564E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,&
&.664E-03_JPRB,.664E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  6  70.0
ZAER (:, 6, 6) = (/&
&.147E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,&
&.272E-02_JPRB,.272E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.321E-02_JPRB,.321E-02_JPRB,.295E-02_JPRB,&
&.295E-02_JPRB,.229E-02_JPRB,.229E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.103E-02_JPRB,&
&.103E-02_JPRB,.721E-03_JPRB,.721E-03_JPRB,.559E-03_JPRB,.559E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,&
&.772E-03_JPRB,.772E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.767E-03_JPRB,.767E-03_JPRB,&
&.675E-03_JPRB,.675E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.934E-03_JPRB,&
&.934E-03_JPRB,.130E-02_JPRB,.130E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.181E-02_JPRB,.181E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  7  66.0
ZAER (:, 7, 6) = (/&
&.147E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,&
&.272E-02_JPRB,.272E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.321E-02_JPRB,.321E-02_JPRB,.295E-02_JPRB,&
&.295E-02_JPRB,.229E-02_JPRB,.229E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.103E-02_JPRB,&
&.103E-02_JPRB,.721E-03_JPRB,.721E-03_JPRB,.559E-03_JPRB,.559E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,&
&.772E-03_JPRB,.772E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.767E-03_JPRB,.767E-03_JPRB,&
&.675E-03_JPRB,.675E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.934E-03_JPRB,&
&.934E-03_JPRB,.130E-02_JPRB,.130E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.181E-02_JPRB,.181E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  8  62.0
ZAER (:, 8, 6) = (/&
&.855E-02_JPRB,.855E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.361E-02_JPRB,&
&.361E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.912E-02_JPRB,.912E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.981E-02_JPRB,&
&.981E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,&
&.333E-02_JPRB,.333E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.195E-02_JPRB,&
&.195E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.963E-03_JPRB,.963E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.439E-02_JPRB,&
&.439E-02_JPRB,.425E-02_JPRB,.425E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,.444E-02_JPRB,&
&.444E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,&
&.894E-02_JPRB,.894E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  9  58.0
ZAER (:, 9, 6) = (/&
&.855E-02_JPRB,.855E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.361E-02_JPRB,&
&.361E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.912E-02_JPRB,.912E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.981E-02_JPRB,&
&.981E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,&
&.333E-02_JPRB,.333E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.195E-02_JPRB,&
&.195E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.963E-03_JPRB,.963E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.439E-02_JPRB,&
&.439E-02_JPRB,.425E-02_JPRB,.425E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,.444E-02_JPRB,&
&.444E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,&
&.894E-02_JPRB,.894E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 10  54.0
ZAER (:,10, 6) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.930E-02_JPRB,.930E-02_JPRB,.853E-02_JPRB,&
&.853E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,&
&.961E-02_JPRB,.961E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.804E-02_JPRB,.804E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.948E-02_JPRB,.948E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.596E-02_JPRB,&
&.596E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.468E-02_JPRB,.468E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,&
&.775E-02_JPRB,.775E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.135E-01_JPRB,&
&.135E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.930E-02_JPRB,.930E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 11  50.0
ZAER (:,11, 6) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.930E-02_JPRB,.930E-02_JPRB,.853E-02_JPRB,&
&.853E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,&
&.961E-02_JPRB,.961E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.804E-02_JPRB,.804E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.948E-02_JPRB,.948E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.596E-02_JPRB,&
&.596E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.468E-02_JPRB,.468E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,&
&.775E-02_JPRB,.775E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.135E-01_JPRB,&
&.135E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.930E-02_JPRB,.930E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 12  46.0
ZAER (:,12, 6) = (/&
&.947E-02_JPRB,.947E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.961E-02_JPRB,&
&.961E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.896E-02_JPRB,&
&.896E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.985E-02_JPRB,.985E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.157E-01_JPRB,.157E-01_JPRB,.172E-01_JPRB,&
&.172E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.139E-01_JPRB,&
&.139E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 13  42.0
ZAER (:,13, 6) = (/&
&.947E-02_JPRB,.947E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.961E-02_JPRB,&
&.961E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.896E-02_JPRB,&
&.896E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.985E-02_JPRB,.985E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.157E-01_JPRB,.157E-01_JPRB,.172E-01_JPRB,&
&.172E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.139E-01_JPRB,&
&.139E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 14  38.0
ZAER (:,14, 6) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.935E-02_JPRB,.935E-02_JPRB,.760E-02_JPRB,&
&.760E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.950E-02_JPRB,.950E-02_JPRB,.980E-02_JPRB,&
&.980E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.975E-02_JPRB,.975E-02_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.125E-01_JPRB,&
&.125E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.620E-02_JPRB,.620E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 15  34.0
ZAER (:,15, 6) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.935E-02_JPRB,.935E-02_JPRB,.760E-02_JPRB,&
&.760E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.950E-02_JPRB,.950E-02_JPRB,.980E-02_JPRB,&
&.980E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.975E-02_JPRB,.975E-02_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.125E-01_JPRB,&
&.125E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.620E-02_JPRB,.620E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 16  30.0
ZAER (:,16, 6) = (/&
&.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.968E-02_JPRB,.968E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.735E-02_JPRB,&
&.735E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.907E-02_JPRB,&
&.907E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,&
&.611E-02_JPRB,.611E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.903E-02_JPRB,.903E-02_JPRB,&
&.861E-02_JPRB,.861E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.492E-02_JPRB,.492E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 17  26.0
ZAER (:,17, 6) = (/&
&.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.968E-02_JPRB,.968E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.735E-02_JPRB,&
&.735E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.907E-02_JPRB,&
&.907E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,&
&.611E-02_JPRB,.611E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.903E-02_JPRB,.903E-02_JPRB,&
&.861E-02_JPRB,.861E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.492E-02_JPRB,.492E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 18  22.0
ZAER (:,18, 6) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.784E-02_JPRB,&
&.784E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,&
&.690E-02_JPRB,.690E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.961E-02_JPRB,.961E-02_JPRB,.923E-02_JPRB,&
&.923E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,&
&.358E-02_JPRB,.358E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,.806E-02_JPRB,.806E-02_JPRB,.114E-01_JPRB,&
&.114E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.799E-02_JPRB,.799E-02_JPRB,.694E-02_JPRB,&
&.694E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 19  18.0
ZAER (:,19, 6) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.784E-02_JPRB,&
&.784E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,&
&.690E-02_JPRB,.690E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.961E-02_JPRB,.961E-02_JPRB,.923E-02_JPRB,&
&.923E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,&
&.358E-02_JPRB,.358E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,.806E-02_JPRB,.806E-02_JPRB,.114E-01_JPRB,&
&.114E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.799E-02_JPRB,.799E-02_JPRB,.694E-02_JPRB,&
&.694E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 20  14.0
ZAER (:,20, 6) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.151E-01_JPRB,&
&.151E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.841E-02_JPRB,.841E-02_JPRB,.550E-02_JPRB,&
&.550E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,&
&.806E-02_JPRB,.806E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.779E-02_JPRB,&
&.779E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,&
&.447E-02_JPRB,.447E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,.124E-01_JPRB,.124E-01_JPRB,.154E-01_JPRB,&
&.154E-01_JPRB,.170E-01_JPRB,.170E-01_JPRB,.171E-01_JPRB,.171E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 21  10.0
ZAER (:,21, 6) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.151E-01_JPRB,&
&.151E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.841E-02_JPRB,.841E-02_JPRB,.550E-02_JPRB,&
&.550E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,&
&.806E-02_JPRB,.806E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.779E-02_JPRB,&
&.779E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,&
&.447E-02_JPRB,.447E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,.124E-01_JPRB,.124E-01_JPRB,.154E-01_JPRB,&
&.154E-01_JPRB,.170E-01_JPRB,.170E-01_JPRB,.171E-01_JPRB,.171E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 22   6.0
ZAER (:,22, 6) = (/&
&.149E-01_JPRB,.149E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.159E-01_JPRB,&
&.159E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.847E-02_JPRB,.847E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.868E-02_JPRB,.868E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.387E-02_JPRB,.387E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,&
&.820E-02_JPRB,.820E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.900E-02_JPRB,.900E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,&
&.666E-02_JPRB,.666E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.736E-02_JPRB,&
&.736E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 23   2.0
ZAER (:,23, 6) = (/&
&.149E-01_JPRB,.149E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.159E-01_JPRB,&
&.159E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.847E-02_JPRB,.847E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.868E-02_JPRB,.868E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.387E-02_JPRB,.387E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,&
&.820E-02_JPRB,.820E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.900E-02_JPRB,.900E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,&
&.666E-02_JPRB,.666E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.736E-02_JPRB,&
&.736E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 24  -2.0
ZAER (:,24, 6) = (/&
&.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.988E-02_JPRB,.988E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.208E-02_JPRB,&
&.208E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.801E-02_JPRB,.801E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.359E-02_JPRB,&
&.359E-02_JPRB,.292E-02_JPRB,.292E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,&
&.626E-02_JPRB,.626E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.132E-01_JPRB,.132E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.930E-02_JPRB,.930E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.667E-02_JPRB,.667E-02_JPRB,&
&.482E-02_JPRB,.482E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.753E-02_JPRB,&
&.753E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,.961E-02_JPRB,.961E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 25  -6.0
ZAER (:,25, 6) = (/&
&.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.988E-02_JPRB,.988E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.208E-02_JPRB,&
&.208E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.801E-02_JPRB,.801E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.359E-02_JPRB,&
&.359E-02_JPRB,.292E-02_JPRB,.292E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,&
&.626E-02_JPRB,.626E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.132E-01_JPRB,.132E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.930E-02_JPRB,.930E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.667E-02_JPRB,.667E-02_JPRB,&
&.482E-02_JPRB,.482E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.753E-02_JPRB,&
&.753E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,.961E-02_JPRB,.961E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 26 -10.0
ZAER (:,26, 6) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.883E-02_JPRB,.883E-02_JPRB,&
&.664E-02_JPRB,.664E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.649E-02_JPRB,&
&.649E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.924E-02_JPRB,.924E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.913E-03_JPRB,.913E-03_JPRB,.908E-03_JPRB,.908E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.249E-02_JPRB,.249E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.143E-01_JPRB,.143E-01_JPRB,.134E-01_JPRB,&
&.134E-01_JPRB,.806E-02_JPRB,.806E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.988E-02_JPRB,&
&.988E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 27 -14.0
ZAER (:,27, 6) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.883E-02_JPRB,.883E-02_JPRB,&
&.664E-02_JPRB,.664E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.649E-02_JPRB,&
&.649E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.924E-02_JPRB,.924E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.913E-03_JPRB,.913E-03_JPRB,.908E-03_JPRB,.908E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.249E-02_JPRB,.249E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.143E-01_JPRB,.143E-01_JPRB,.134E-01_JPRB,&
&.134E-01_JPRB,.806E-02_JPRB,.806E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.988E-02_JPRB,&
&.988E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 28 -18.0
ZAER (:,28, 6) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.775E-02_JPRB,.775E-02_JPRB,&
&.550E-02_JPRB,.550E-02_JPRB,.412E-02_JPRB,.412E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.648E-02_JPRB,&
&.648E-02_JPRB,.963E-02_JPRB,.963E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.889E-02_JPRB,.889E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.144E-02_JPRB,.144E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.841E-02_JPRB,&
&.841E-02_JPRB,.504E-02_JPRB,.504E-02_JPRB,.283E-02_JPRB,.283E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,&
&.176E-02_JPRB,.176E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.714E-02_JPRB,&
&.714E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 29 -22.0
ZAER (:,29, 6) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.775E-02_JPRB,.775E-02_JPRB,&
&.550E-02_JPRB,.550E-02_JPRB,.412E-02_JPRB,.412E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.648E-02_JPRB,&
&.648E-02_JPRB,.963E-02_JPRB,.963E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.889E-02_JPRB,.889E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.144E-02_JPRB,.144E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.841E-02_JPRB,&
&.841E-02_JPRB,.504E-02_JPRB,.504E-02_JPRB,.283E-02_JPRB,.283E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,&
&.176E-02_JPRB,.176E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.714E-02_JPRB,&
&.714E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 30 -26.0
ZAER (:,30, 6) = (/&
&.904E-02_JPRB,.904E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.903E-02_JPRB,&
&.903E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.666E-02_JPRB,.666E-02_JPRB,&
&.443E-02_JPRB,.443E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.539E-02_JPRB,&
&.539E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.937E-02_JPRB,.937E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.340E-02_JPRB,&
&.340E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,&
&.184E-02_JPRB,.184E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.198E-02_JPRB,&
&.198E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,&
&.833E-03_JPRB,.833E-03_JPRB,.140E-02_JPRB,.140E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.468E-02_JPRB,&
&.468E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 31 -30.0
ZAER (:,31, 6) = (/&
&.904E-02_JPRB,.904E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.903E-02_JPRB,&
&.903E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.666E-02_JPRB,.666E-02_JPRB,&
&.443E-02_JPRB,.443E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.539E-02_JPRB,&
&.539E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.937E-02_JPRB,.937E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.340E-02_JPRB,&
&.340E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,&
&.184E-02_JPRB,.184E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.198E-02_JPRB,&
&.198E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,&
&.833E-03_JPRB,.833E-03_JPRB,.140E-02_JPRB,.140E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.468E-02_JPRB,&
&.468E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 32 -34.0
ZAER (:,32, 6) = (/&
&.563E-02_JPRB,.563E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.446E-02_JPRB,.446E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,&
&.244E-02_JPRB,.244E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.259E-02_JPRB,&
&.259E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.389E-02_JPRB,&
&.389E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,&
&.268E-02_JPRB,.268E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.848E-03_JPRB,.848E-03_JPRB,.760E-03_JPRB,.760E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,&
&.440E-03_JPRB,.440E-03_JPRB,.511E-03_JPRB,.511E-03_JPRB,.164E-02_JPRB,.164E-02_JPRB,.291E-02_JPRB,&
&.291E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,&
&.631E-02_JPRB,.631E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 33 -38.0
ZAER (:,33, 6) = (/&
&.563E-02_JPRB,.563E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.446E-02_JPRB,.446E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,&
&.244E-02_JPRB,.244E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.259E-02_JPRB,&
&.259E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.389E-02_JPRB,&
&.389E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,&
&.268E-02_JPRB,.268E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.848E-03_JPRB,.848E-03_JPRB,.760E-03_JPRB,.760E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,&
&.440E-03_JPRB,.440E-03_JPRB,.511E-03_JPRB,.511E-03_JPRB,.164E-02_JPRB,.164E-02_JPRB,.291E-02_JPRB,&
&.291E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,&
&.631E-02_JPRB,.631E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 34 -42.0
ZAER (:,34, 6) = (/&
&.573E-02_JPRB,.573E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.742E-03_JPRB,.742E-03_JPRB,&
&.623E-03_JPRB,.623E-03_JPRB,.603E-03_JPRB,.603E-03_JPRB,.627E-03_JPRB,.627E-03_JPRB,.587E-03_JPRB,&
&.587E-03_JPRB,.237E-02_JPRB,.237E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.675E-02_JPRB,.675E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.367E-02_JPRB,&
&.367E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.924E-03_JPRB,&
&.924E-03_JPRB,.652E-03_JPRB,.652E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,&
&.456E-03_JPRB,.456E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.145E-02_JPRB,&
&.145E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,&
&.515E-02_JPRB,.515E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 35 -46.0
ZAER (:,35, 6) = (/&
&.573E-02_JPRB,.573E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.742E-03_JPRB,.742E-03_JPRB,&
&.623E-03_JPRB,.623E-03_JPRB,.603E-03_JPRB,.603E-03_JPRB,.627E-03_JPRB,.627E-03_JPRB,.587E-03_JPRB,&
&.587E-03_JPRB,.237E-02_JPRB,.237E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.675E-02_JPRB,.675E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.367E-02_JPRB,&
&.367E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.924E-03_JPRB,&
&.924E-03_JPRB,.652E-03_JPRB,.652E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,&
&.456E-03_JPRB,.456E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.145E-02_JPRB,&
&.145E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,&
&.515E-02_JPRB,.515E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 36 -50.0
ZAER (:,36, 6) = (/&
&.462E-02_JPRB,.462E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.495E-02_JPRB,.495E-02_JPRB,.538E-02_JPRB,&
&.538E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.595E-03_JPRB,.595E-03_JPRB,&
&.306E-03_JPRB,.306E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.624E-03_JPRB,&
&.624E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.213E-02_JPRB,.213E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,&
&.636E-02_JPRB,.636E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.978E-03_JPRB,.978E-03_JPRB,&
&.957E-03_JPRB,.957E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.887E-03_JPRB,.887E-03_JPRB,.693E-03_JPRB,&
&.693E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.492E-03_JPRB,.492E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,&
&.406E-03_JPRB,.406E-03_JPRB,.365E-03_JPRB,.365E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.390E-03_JPRB,&
&.390E-03_JPRB,.147E-02_JPRB,.147E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.424E-02_JPRB,.424E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 37 -54.0
ZAER (:,37, 6) = (/&
&.462E-02_JPRB,.462E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.495E-02_JPRB,.495E-02_JPRB,.538E-02_JPRB,&
&.538E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.595E-03_JPRB,.595E-03_JPRB,&
&.306E-03_JPRB,.306E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.624E-03_JPRB,&
&.624E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.213E-02_JPRB,.213E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,&
&.636E-02_JPRB,.636E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.978E-03_JPRB,.978E-03_JPRB,&
&.957E-03_JPRB,.957E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.887E-03_JPRB,.887E-03_JPRB,.693E-03_JPRB,&
&.693E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.492E-03_JPRB,.492E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,&
&.406E-03_JPRB,.406E-03_JPRB,.365E-03_JPRB,.365E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.390E-03_JPRB,&
&.390E-03_JPRB,.147E-02_JPRB,.147E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.424E-02_JPRB,.424E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 38 -58.0
ZAER (:,38, 6) = (/&
&.343E-02_JPRB,.343E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.231E-02_JPRB,&
&.231E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.647E-03_JPRB,.647E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,&
&.305E-03_JPRB,.305E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.233E-02_JPRB,.233E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,&
&.494E-02_JPRB,.494E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.485E-02_JPRB,&
&.485E-02_JPRB,.395E-02_JPRB,.395E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.830E-03_JPRB,.830E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,.576E-03_JPRB,&
&.576E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.337E-03_JPRB,.337E-03_JPRB,&
&.295E-03_JPRB,.295E-03_JPRB,.260E-03_JPRB,.260E-03_JPRB,.234E-03_JPRB,.234E-03_JPRB,.243E-03_JPRB,&
&.243E-03_JPRB,.878E-03_JPRB,.878E-03_JPRB,.157E-02_JPRB,.157E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.281E-02_JPRB,.281E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 39 -62.0
ZAER (:,39, 6) = (/&
&.343E-02_JPRB,.343E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.231E-02_JPRB,&
&.231E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.647E-03_JPRB,.647E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,&
&.305E-03_JPRB,.305E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.233E-02_JPRB,.233E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,&
&.494E-02_JPRB,.494E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.485E-02_JPRB,&
&.485E-02_JPRB,.395E-02_JPRB,.395E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.830E-03_JPRB,.830E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,.576E-03_JPRB,&
&.576E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.337E-03_JPRB,.337E-03_JPRB,&
&.295E-03_JPRB,.295E-03_JPRB,.260E-03_JPRB,.260E-03_JPRB,.234E-03_JPRB,.234E-03_JPRB,.243E-03_JPRB,&
&.243E-03_JPRB,.878E-03_JPRB,.878E-03_JPRB,.157E-02_JPRB,.157E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.281E-02_JPRB,.281E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 40 -66.0
ZAER (:,40, 6) = (/&
&.186E-02_JPRB,.186E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.988E-03_JPRB,.988E-03_JPRB,.830E-03_JPRB,&
&.830E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.823E-03_JPRB,.823E-03_JPRB,.699E-03_JPRB,.699E-03_JPRB,&
&.491E-03_JPRB,.491E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.689E-03_JPRB,.689E-03_JPRB,.928E-03_JPRB,&
&.928E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.484E-02_JPRB,&
&.484E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.383E-02_JPRB,.383E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.669E-03_JPRB,.669E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.259E-03_JPRB,.259E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.328E-03_JPRB,&
&.328E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.581E-03_JPRB,.581E-03_JPRB,&
&.903E-03_JPRB,.903E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 41 -70.0
ZAER (:,41, 6) = (/&
&.186E-02_JPRB,.186E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.988E-03_JPRB,.988E-03_JPRB,.830E-03_JPRB,&
&.830E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.823E-03_JPRB,.823E-03_JPRB,.699E-03_JPRB,.699E-03_JPRB,&
&.491E-03_JPRB,.491E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.689E-03_JPRB,.689E-03_JPRB,.928E-03_JPRB,&
&.928E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.484E-02_JPRB,&
&.484E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.383E-02_JPRB,.383E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.669E-03_JPRB,.669E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.259E-03_JPRB,.259E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.328E-03_JPRB,&
&.328E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.581E-03_JPRB,.581E-03_JPRB,&
&.903E-03_JPRB,.903E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 42 -74.0
ZAER (:,42, 6) = (/&
&.818E-03_JPRB,.818E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.812E-03_JPRB,.812E-03_JPRB,.663E-03_JPRB,&
&.663E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.887E-03_JPRB,.887E-03_JPRB,.687E-03_JPRB,.687E-03_JPRB,&
&.596E-03_JPRB,.596E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.560E-03_JPRB,.560E-03_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.696E-03_JPRB,.696E-03_JPRB,&
&.516E-03_JPRB,.516E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,.359E-02_JPRB,&
&.359E-02_JPRB,.393E-02_JPRB,.393E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,&
&.320E-02_JPRB,.320E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.179E-02_JPRB,&
&.179E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.382E-03_JPRB,.382E-03_JPRB,&
&.346E-03_JPRB,.346E-03_JPRB,.553E-03_JPRB,.553E-03_JPRB,.138E-02_JPRB,.138E-02_JPRB,.128E-02_JPRB,&
&.128E-02_JPRB,.298E-03_JPRB,.298E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,&
&.535E-03_JPRB,.535E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 43 -78.0
ZAER (:,43, 6) = (/&
&.818E-03_JPRB,.818E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.812E-03_JPRB,.812E-03_JPRB,.663E-03_JPRB,&
&.663E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.887E-03_JPRB,.887E-03_JPRB,.687E-03_JPRB,.687E-03_JPRB,&
&.596E-03_JPRB,.596E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.560E-03_JPRB,.560E-03_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.696E-03_JPRB,.696E-03_JPRB,&
&.516E-03_JPRB,.516E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,.359E-02_JPRB,&
&.359E-02_JPRB,.393E-02_JPRB,.393E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,&
&.320E-02_JPRB,.320E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.179E-02_JPRB,&
&.179E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.382E-03_JPRB,.382E-03_JPRB,&
&.346E-03_JPRB,.346E-03_JPRB,.553E-03_JPRB,.553E-03_JPRB,.138E-02_JPRB,.138E-02_JPRB,.128E-02_JPRB,&
&.128E-02_JPRB,.298E-03_JPRB,.298E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,&
&.535E-03_JPRB,.535E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 44 -82.0
ZAER (:,44, 6) = (/&
&.421E-03_JPRB,.421E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.405E-03_JPRB,&
&.405E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,.525E-03_JPRB,.525E-03_JPRB,&
&.564E-03_JPRB,.564E-03_JPRB,.628E-03_JPRB,.628E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,.843E-03_JPRB,&
&.843E-03_JPRB,.845E-03_JPRB,.845E-03_JPRB,.684E-03_JPRB,.684E-03_JPRB,.626E-03_JPRB,.626E-03_JPRB,&
&.691E-03_JPRB,.691E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.911E-03_JPRB,.911E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.687E-03_JPRB,&
&.687E-03_JPRB,.582E-03_JPRB,.582E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,&
&.435E-03_JPRB,.435E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.383E-03_JPRB,&
&.383E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,&
&.394E-03_JPRB,.394E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 45 -86.0
ZAER (:,45, 6) = (/&
&.421E-03_JPRB,.421E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.405E-03_JPRB,&
&.405E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,.525E-03_JPRB,.525E-03_JPRB,&
&.564E-03_JPRB,.564E-03_JPRB,.628E-03_JPRB,.628E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,.843E-03_JPRB,&
&.843E-03_JPRB,.845E-03_JPRB,.845E-03_JPRB,.684E-03_JPRB,.684E-03_JPRB,.626E-03_JPRB,.626E-03_JPRB,&
&.691E-03_JPRB,.691E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.911E-03_JPRB,.911E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.687E-03_JPRB,&
&.687E-03_JPRB,.582E-03_JPRB,.582E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,&
&.435E-03_JPRB,.435E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.383E-03_JPRB,&
&.383E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,&
&.394E-03_JPRB,.394E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 46 -90.0
ZAER (:,46, 6) = (/&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=6  
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_06
