SUBROUTINE SUECAESS_05

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      May

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,5:5)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  5 --- lat:  1  90.0
ZAER (:, 1, 5) = (/&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  2  86.0
ZAER (:, 2, 5) = (/&
&.505E-03_JPRB,.505E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.525E-03_JPRB,&
&.525E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.503E-03_JPRB,.503E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,&
&.494E-03_JPRB,.494E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.535E-03_JPRB,&
&.535E-03_JPRB,.602E-03_JPRB,.602E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,&
&.633E-03_JPRB,.633E-03_JPRB,.561E-03_JPRB,.561E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.387E-03_JPRB,&
&.387E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.348E-03_JPRB,.348E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,&
&.371E-03_JPRB,.371E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.398E-03_JPRB,&
&.398E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,&
&.357E-03_JPRB,.357E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.339E-03_JPRB,&
&.339E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.371E-03_JPRB,.371E-03_JPRB,.410E-03_JPRB,.410E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  3  82.0
ZAER (:, 3, 5) = (/&
&.505E-03_JPRB,.505E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.525E-03_JPRB,&
&.525E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.503E-03_JPRB,.503E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,&
&.494E-03_JPRB,.494E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.535E-03_JPRB,&
&.535E-03_JPRB,.602E-03_JPRB,.602E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,&
&.633E-03_JPRB,.633E-03_JPRB,.561E-03_JPRB,.561E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.387E-03_JPRB,&
&.387E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.348E-03_JPRB,.348E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,&
&.371E-03_JPRB,.371E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.398E-03_JPRB,&
&.398E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,&
&.357E-03_JPRB,.357E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.339E-03_JPRB,&
&.339E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.371E-03_JPRB,.371E-03_JPRB,.410E-03_JPRB,.410E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  4  78.0
ZAER (:, 4, 5) = (/&
&.114E-02_JPRB,.114E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.909E-03_JPRB,.909E-03_JPRB,.848E-03_JPRB,&
&.848E-03_JPRB,.831E-03_JPRB,.831E-03_JPRB,.821E-03_JPRB,.821E-03_JPRB,.746E-03_JPRB,.746E-03_JPRB,&
&.671E-03_JPRB,.671E-03_JPRB,.639E-03_JPRB,.639E-03_JPRB,.604E-03_JPRB,.604E-03_JPRB,.760E-03_JPRB,&
&.760E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.126E-02_JPRB,.126E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.856E-03_JPRB,.856E-03_JPRB,.545E-03_JPRB,&
&.545E-03_JPRB,.348E-03_JPRB,.348E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.410E-03_JPRB,.410E-03_JPRB,&
&.526E-03_JPRB,.526E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.644E-03_JPRB,&
&.644E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,&
&.496E-03_JPRB,.496E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.491E-03_JPRB,&
&.491E-03_JPRB,.539E-03_JPRB,.539E-03_JPRB,.556E-03_JPRB,.556E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,&
&.757E-03_JPRB,.757E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  5  74.0
ZAER (:, 5, 5) = (/&
&.114E-02_JPRB,.114E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.909E-03_JPRB,.909E-03_JPRB,.848E-03_JPRB,&
&.848E-03_JPRB,.831E-03_JPRB,.831E-03_JPRB,.821E-03_JPRB,.821E-03_JPRB,.746E-03_JPRB,.746E-03_JPRB,&
&.671E-03_JPRB,.671E-03_JPRB,.639E-03_JPRB,.639E-03_JPRB,.604E-03_JPRB,.604E-03_JPRB,.760E-03_JPRB,&
&.760E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.126E-02_JPRB,.126E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.856E-03_JPRB,.856E-03_JPRB,.545E-03_JPRB,&
&.545E-03_JPRB,.348E-03_JPRB,.348E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.410E-03_JPRB,.410E-03_JPRB,&
&.526E-03_JPRB,.526E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.644E-03_JPRB,&
&.644E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,&
&.496E-03_JPRB,.496E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.491E-03_JPRB,&
&.491E-03_JPRB,.539E-03_JPRB,.539E-03_JPRB,.556E-03_JPRB,.556E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,&
&.757E-03_JPRB,.757E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  6  70.0
ZAER (:, 6, 5) = (/&
&.337E-02_JPRB,.337E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,&
&.167E-02_JPRB,.167E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,.990E-03_JPRB,&
&.990E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,&
&.180E-02_JPRB,.180E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.965E-03_JPRB,&
&.965E-03_JPRB,.649E-03_JPRB,.649E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,&
&.659E-03_JPRB,.659E-03_JPRB,.927E-03_JPRB,.927E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.142E-02_JPRB,&
&.142E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.138E-02_JPRB,&
&.138E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.194E-02_JPRB,.194E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  7  66.0
ZAER (:, 7, 5) = (/&
&.337E-02_JPRB,.337E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,&
&.167E-02_JPRB,.167E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,.990E-03_JPRB,&
&.990E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,&
&.180E-02_JPRB,.180E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.965E-03_JPRB,&
&.965E-03_JPRB,.649E-03_JPRB,.649E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,&
&.659E-03_JPRB,.659E-03_JPRB,.927E-03_JPRB,.927E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.142E-02_JPRB,&
&.142E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.138E-02_JPRB,&
&.138E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.194E-02_JPRB,.194E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  8  62.0
ZAER (:, 8, 5) = (/&
&.804E-02_JPRB,.804E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.664E-02_JPRB,.664E-02_JPRB,.472E-02_JPRB,&
&.472E-02_JPRB,.640E-02_JPRB,.640E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.929E-02_JPRB,.929E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.602E-02_JPRB,.602E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.362E-02_JPRB,.362E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.132E-02_JPRB,.132E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,&
&.791E-02_JPRB,.791E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,.709E-02_JPRB,&
&.709E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,&
&.813E-02_JPRB,.813E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  9  58.0
ZAER (:, 9, 5) = (/&
&.804E-02_JPRB,.804E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.664E-02_JPRB,.664E-02_JPRB,.472E-02_JPRB,&
&.472E-02_JPRB,.640E-02_JPRB,.640E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.929E-02_JPRB,.929E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.602E-02_JPRB,.602E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.362E-02_JPRB,.362E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.132E-02_JPRB,.132E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,&
&.791E-02_JPRB,.791E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,.709E-02_JPRB,&
&.709E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,&
&.813E-02_JPRB,.813E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 10  54.0
ZAER (:,10, 5) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.963E-02_JPRB,.963E-02_JPRB,.872E-02_JPRB,&
&.872E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.826E-02_JPRB,.826E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.926E-02_JPRB,.926E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,&
&.872E-02_JPRB,.872E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.903E-02_JPRB,.903E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,&
&.947E-02_JPRB,.947E-02_JPRB,.912E-02_JPRB,.912E-02_JPRB,.983E-02_JPRB,.983E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 11  50.0
ZAER (:,11, 5) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.963E-02_JPRB,.963E-02_JPRB,.872E-02_JPRB,&
&.872E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.826E-02_JPRB,.826E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.926E-02_JPRB,.926E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,&
&.872E-02_JPRB,.872E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.903E-02_JPRB,.903E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,&
&.947E-02_JPRB,.947E-02_JPRB,.912E-02_JPRB,.912E-02_JPRB,.983E-02_JPRB,.983E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 12  46.0
ZAER (:,12, 5) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.925E-02_JPRB,.925E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.916E-02_JPRB,&
&.916E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,&
&.139E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.969E-02_JPRB,.969E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 13  42.0
ZAER (:,13, 5) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.925E-02_JPRB,.925E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.916E-02_JPRB,&
&.916E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,&
&.139E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.969E-02_JPRB,.969E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 14  38.0
ZAER (:,14, 5) = (/&
&.112E-01_JPRB,.112E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.987E-02_JPRB,.987E-02_JPRB,.928E-02_JPRB,&
&.928E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.750E-02_JPRB,&
&.750E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.913E-02_JPRB,.913E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,&
&.894E-02_JPRB,.894E-02_JPRB,.860E-02_JPRB,.860E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.667E-02_JPRB,&
&.667E-02_JPRB,.432E-02_JPRB,.432E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 15  34.0
ZAER (:,15, 5) = (/&
&.112E-01_JPRB,.112E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.987E-02_JPRB,.987E-02_JPRB,.928E-02_JPRB,&
&.928E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.750E-02_JPRB,&
&.750E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.913E-02_JPRB,.913E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,&
&.894E-02_JPRB,.894E-02_JPRB,.860E-02_JPRB,.860E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.667E-02_JPRB,&
&.667E-02_JPRB,.432E-02_JPRB,.432E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 16  30.0
ZAER (:,16, 5) = (/&
&.999E-02_JPRB,.999E-02_JPRB,.856E-02_JPRB,.856E-02_JPRB,.789E-02_JPRB,.789E-02_JPRB,.821E-02_JPRB,&
&.821E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.868E-02_JPRB,&
&.868E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,&
&.887E-02_JPRB,.887E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.967E-02_JPRB,.967E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,.433E-02_JPRB,.433E-02_JPRB,&
&.632E-02_JPRB,.632E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.953E-02_JPRB,.953E-02_JPRB,.972E-02_JPRB,&
&.972E-02_JPRB,.999E-02_JPRB,.999E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.826E-02_JPRB,.826E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.425E-02_JPRB,&
&.425E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 17  26.0
ZAER (:,17, 5) = (/&
&.999E-02_JPRB,.999E-02_JPRB,.856E-02_JPRB,.856E-02_JPRB,.789E-02_JPRB,.789E-02_JPRB,.821E-02_JPRB,&
&.821E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.868E-02_JPRB,&
&.868E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,&
&.887E-02_JPRB,.887E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.967E-02_JPRB,.967E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,.433E-02_JPRB,.433E-02_JPRB,&
&.632E-02_JPRB,.632E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.953E-02_JPRB,.953E-02_JPRB,.972E-02_JPRB,&
&.972E-02_JPRB,.999E-02_JPRB,.999E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.826E-02_JPRB,.826E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.425E-02_JPRB,&
&.425E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 18  22.0
ZAER (:,18, 5) = (/&
&.879E-02_JPRB,.879E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.993E-02_JPRB,&
&.993E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.879E-02_JPRB,&
&.879E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.345E-02_JPRB,.345E-02_JPRB,&
&.703E-02_JPRB,.703E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.894E-02_JPRB,&
&.894E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,&
&.457E-02_JPRB,.457E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.834E-02_JPRB,.834E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.711E-02_JPRB,.711E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.952E-02_JPRB,.952E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 19  18.0
ZAER (:,19, 5) = (/&
&.879E-02_JPRB,.879E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.993E-02_JPRB,&
&.993E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.879E-02_JPRB,&
&.879E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.345E-02_JPRB,.345E-02_JPRB,&
&.703E-02_JPRB,.703E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.894E-02_JPRB,&
&.894E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,&
&.457E-02_JPRB,.457E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.834E-02_JPRB,.834E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.711E-02_JPRB,.711E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.952E-02_JPRB,.952E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 20  14.0
ZAER (:,20, 5) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.829E-02_JPRB,.829E-02_JPRB,.519E-02_JPRB,&
&.519E-02_JPRB,.223E-02_JPRB,.223E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.433E-02_JPRB,.433E-02_JPRB,&
&.843E-02_JPRB,.843E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.830E-02_JPRB,&
&.830E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.375E-02_JPRB,.375E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.135E-01_JPRB,.135E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.974E-02_JPRB,.974E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 21  10.0
ZAER (:,21, 5) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.829E-02_JPRB,.829E-02_JPRB,.519E-02_JPRB,&
&.519E-02_JPRB,.223E-02_JPRB,.223E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.433E-02_JPRB,.433E-02_JPRB,&
&.843E-02_JPRB,.843E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.830E-02_JPRB,&
&.830E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.375E-02_JPRB,.375E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.135E-01_JPRB,.135E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.974E-02_JPRB,.974E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 22   6.0
ZAER (:,22, 5) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB,.860E-02_JPRB,.860E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.827E-03_JPRB,.827E-03_JPRB,.131E-02_JPRB,.131E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.792E-02_JPRB,.792E-02_JPRB,.996E-02_JPRB,.996E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,.721E-02_JPRB,&
&.721E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.832E-02_JPRB,.832E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,&
&.568E-02_JPRB,.568E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,.591E-02_JPRB,&
&.591E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.120E-01_JPRB,.120E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 23   2.0
ZAER (:,23, 5) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB,.860E-02_JPRB,.860E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.827E-03_JPRB,.827E-03_JPRB,.131E-02_JPRB,.131E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.792E-02_JPRB,.792E-02_JPRB,.996E-02_JPRB,.996E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,.721E-02_JPRB,&
&.721E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.832E-02_JPRB,.832E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,&
&.568E-02_JPRB,.568E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,.591E-02_JPRB,&
&.591E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.120E-01_JPRB,.120E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 24  -2.0
ZAER (:,24, 5) = (/&
&.106E-01_JPRB,.106E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.233E-02_JPRB,&
&.233E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.267E-02_JPRB,&
&.267E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,&
&.422E-02_JPRB,.422E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.701E-02_JPRB,&
&.701E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.465E-02_JPRB,.465E-02_JPRB,&
&.399E-02_JPRB,.399E-02_JPRB,.536E-02_JPRB,.536E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.685E-02_JPRB,&
&.685E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,&
&.959E-02_JPRB,.959E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 25  -6.0
ZAER (:,25, 5) = (/&
&.106E-01_JPRB,.106E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.233E-02_JPRB,&
&.233E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.267E-02_JPRB,&
&.267E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,&
&.422E-02_JPRB,.422E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.701E-02_JPRB,&
&.701E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.465E-02_JPRB,.465E-02_JPRB,&
&.399E-02_JPRB,.399E-02_JPRB,.536E-02_JPRB,.536E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.685E-02_JPRB,&
&.685E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,&
&.959E-02_JPRB,.959E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 26 -10.0
ZAER (:,26, 5) = (/&
&.126E-01_JPRB,.126E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.141E-01_JPRB,&
&.141E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.811E-02_JPRB,.811E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.689E-02_JPRB,&
&.689E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.962E-02_JPRB,.962E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,&
&.253E-02_JPRB,.253E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.864E-02_JPRB,&
&.864E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,&
&.381E-02_JPRB,.381E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.827E-02_JPRB,.827E-02_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 27 -14.0
ZAER (:,27, 5) = (/&
&.126E-01_JPRB,.126E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.141E-01_JPRB,&
&.141E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.811E-02_JPRB,.811E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.689E-02_JPRB,&
&.689E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.962E-02_JPRB,.962E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,&
&.253E-02_JPRB,.253E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.864E-02_JPRB,&
&.864E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,&
&.381E-02_JPRB,.381E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.827E-02_JPRB,.827E-02_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 28 -18.0
ZAER (:,28, 5) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.954E-02_JPRB,.954E-02_JPRB,&
&.762E-02_JPRB,.762E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.664E-02_JPRB,.664E-02_JPRB,.748E-02_JPRB,&
&.748E-02_JPRB,.988E-02_JPRB,.988E-02_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.977E-02_JPRB,.977E-02_JPRB,.812E-02_JPRB,.812E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.220E-02_JPRB,&
&.220E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,&
&.202E-02_JPRB,.202E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 29 -22.0
ZAER (:,29, 5) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.954E-02_JPRB,.954E-02_JPRB,&
&.762E-02_JPRB,.762E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.664E-02_JPRB,.664E-02_JPRB,.748E-02_JPRB,&
&.748E-02_JPRB,.988E-02_JPRB,.988E-02_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.977E-02_JPRB,.977E-02_JPRB,.812E-02_JPRB,.812E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.220E-02_JPRB,&
&.220E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,&
&.202E-02_JPRB,.202E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 30 -26.0
ZAER (:,30, 5) = (/&
&.548E-02_JPRB,.548E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,&
&.468E-02_JPRB,.468E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.612E-02_JPRB,&
&.612E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.349E-02_JPRB,&
&.349E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.352E-02_JPRB,.352E-02_JPRB,.524E-02_JPRB,&
&.524E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,&
&.617E-02_JPRB,.617E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 31 -30.0
ZAER (:,31, 5) = (/&
&.548E-02_JPRB,.548E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,&
&.468E-02_JPRB,.468E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.612E-02_JPRB,&
&.612E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.349E-02_JPRB,&
&.349E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.352E-02_JPRB,.352E-02_JPRB,.524E-02_JPRB,&
&.524E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,&
&.617E-02_JPRB,.617E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 32 -34.0
ZAER (:,32, 5) = (/&
&.539E-02_JPRB,.539E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.642E-02_JPRB,&
&.642E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.655E-02_JPRB,.655E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,&
&.173E-02_JPRB,.173E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.250E-02_JPRB,&
&.250E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,&
&.833E-02_JPRB,.833E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.412E-02_JPRB,&
&.412E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,&
&.261E-02_JPRB,.261E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.101E-02_JPRB,&
&.101E-02_JPRB,.920E-03_JPRB,.920E-03_JPRB,.948E-03_JPRB,.948E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,.171E-02_JPRB,.171E-02_JPRB,.260E-02_JPRB,&
&.260E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.732E-02_JPRB,.732E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 33 -38.0
ZAER (:,33, 5) = (/&
&.539E-02_JPRB,.539E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.642E-02_JPRB,&
&.642E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.655E-02_JPRB,.655E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,&
&.173E-02_JPRB,.173E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.250E-02_JPRB,&
&.250E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,&
&.833E-02_JPRB,.833E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.412E-02_JPRB,&
&.412E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,&
&.261E-02_JPRB,.261E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.101E-02_JPRB,&
&.101E-02_JPRB,.920E-03_JPRB,.920E-03_JPRB,.948E-03_JPRB,.948E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,.171E-02_JPRB,.171E-02_JPRB,.260E-02_JPRB,&
&.260E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.732E-02_JPRB,.732E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 34 -42.0
ZAER (:,34, 5) = (/&
&.748E-02_JPRB,.748E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,&
&.683E-03_JPRB,.683E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.560E-03_JPRB,.560E-03_JPRB,.472E-03_JPRB,&
&.472E-03_JPRB,.209E-02_JPRB,.209E-02_JPRB,.464E-02_JPRB,.464E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,&
&.789E-02_JPRB,.789E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,.419E-02_JPRB,&
&.419E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,&
&.219E-02_JPRB,.219E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.868E-03_JPRB,&
&.868E-03_JPRB,.734E-03_JPRB,.734E-03_JPRB,.647E-03_JPRB,.647E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,&
&.532E-03_JPRB,.532E-03_JPRB,.455E-03_JPRB,.455E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,&
&.809E-02_JPRB,.809E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 35 -46.0
ZAER (:,35, 5) = (/&
&.748E-02_JPRB,.748E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,&
&.683E-03_JPRB,.683E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.560E-03_JPRB,.560E-03_JPRB,.472E-03_JPRB,&
&.472E-03_JPRB,.209E-02_JPRB,.209E-02_JPRB,.464E-02_JPRB,.464E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,&
&.789E-02_JPRB,.789E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,.419E-02_JPRB,&
&.419E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,&
&.219E-02_JPRB,.219E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.868E-03_JPRB,&
&.868E-03_JPRB,.734E-03_JPRB,.734E-03_JPRB,.647E-03_JPRB,.647E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,&
&.532E-03_JPRB,.532E-03_JPRB,.455E-03_JPRB,.455E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,&
&.809E-02_JPRB,.809E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 36 -50.0
ZAER (:,36, 5) = (/&
&.683E-02_JPRB,.683E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.480E-02_JPRB,&
&.480E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.882E-03_JPRB,.882E-03_JPRB,&
&.457E-03_JPRB,.457E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.620E-03_JPRB,.620E-03_JPRB,.696E-03_JPRB,&
&.696E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.271E-02_JPRB,.271E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,&
&.749E-02_JPRB,.749E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.404E-02_JPRB,&
&.404E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.816E-03_JPRB,&
&.816E-03_JPRB,.692E-03_JPRB,.692E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.491E-03_JPRB,.491E-03_JPRB,&
&.406E-03_JPRB,.406E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.276E-03_JPRB,.276E-03_JPRB,.356E-03_JPRB,&
&.356E-03_JPRB,.159E-02_JPRB,.159E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.641E-02_JPRB,.641E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 37 -54.0
ZAER (:,37, 5) = (/&
&.683E-02_JPRB,.683E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.480E-02_JPRB,&
&.480E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.882E-03_JPRB,.882E-03_JPRB,&
&.457E-03_JPRB,.457E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.620E-03_JPRB,.620E-03_JPRB,.696E-03_JPRB,&
&.696E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.271E-02_JPRB,.271E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,&
&.749E-02_JPRB,.749E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.404E-02_JPRB,&
&.404E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.816E-03_JPRB,&
&.816E-03_JPRB,.692E-03_JPRB,.692E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.491E-03_JPRB,.491E-03_JPRB,&
&.406E-03_JPRB,.406E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.276E-03_JPRB,.276E-03_JPRB,.356E-03_JPRB,&
&.356E-03_JPRB,.159E-02_JPRB,.159E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.641E-02_JPRB,.641E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 38 -58.0
ZAER (:,38, 5) = (/&
&.464E-02_JPRB,.464E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.173E-02_JPRB,&
&.173E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.717E-03_JPRB,.717E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.279E-02_JPRB,.279E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,&
&.588E-02_JPRB,.588E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,.422E-02_JPRB,&
&.422E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,&
&.805E-03_JPRB,.805E-03_JPRB,.797E-03_JPRB,.797E-03_JPRB,.774E-03_JPRB,.774E-03_JPRB,.665E-03_JPRB,&
&.665E-03_JPRB,.527E-03_JPRB,.527E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,&
&.273E-03_JPRB,.273E-03_JPRB,.229E-03_JPRB,.229E-03_JPRB,.232E-03_JPRB,.232E-03_JPRB,.378E-03_JPRB,&
&.378E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,&
&.388E-02_JPRB,.388E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 39 -62.0
ZAER (:,39, 5) = (/&
&.464E-02_JPRB,.464E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.173E-02_JPRB,&
&.173E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.717E-03_JPRB,.717E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.279E-02_JPRB,.279E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,&
&.588E-02_JPRB,.588E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,.422E-02_JPRB,&
&.422E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,&
&.805E-03_JPRB,.805E-03_JPRB,.797E-03_JPRB,.797E-03_JPRB,.774E-03_JPRB,.774E-03_JPRB,.665E-03_JPRB,&
&.665E-03_JPRB,.527E-03_JPRB,.527E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,&
&.273E-03_JPRB,.273E-03_JPRB,.229E-03_JPRB,.229E-03_JPRB,.232E-03_JPRB,.232E-03_JPRB,.378E-03_JPRB,&
&.378E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,&
&.388E-02_JPRB,.388E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 40 -66.0
ZAER (:,40, 5) = (/&
&.188E-02_JPRB,.188E-02_JPRB,.223E-02_JPRB,.223E-02_JPRB,.621E-03_JPRB,.621E-03_JPRB,.506E-03_JPRB,&
&.506E-03_JPRB,.827E-03_JPRB,.827E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.491E-03_JPRB,.491E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.693E-03_JPRB,.693E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.691E-03_JPRB,&
&.691E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.371E-02_JPRB,.371E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.183E-02_JPRB,.183E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.673E-03_JPRB,.673E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.285E-03_JPRB,.285E-03_JPRB,&
&.246E-03_JPRB,.246E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.406E-03_JPRB,&
&.406E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,&
&.144E-02_JPRB,.144E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 41 -70.0
ZAER (:,41, 5) = (/&
&.188E-02_JPRB,.188E-02_JPRB,.223E-02_JPRB,.223E-02_JPRB,.621E-03_JPRB,.621E-03_JPRB,.506E-03_JPRB,&
&.506E-03_JPRB,.827E-03_JPRB,.827E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.491E-03_JPRB,.491E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.693E-03_JPRB,.693E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.691E-03_JPRB,&
&.691E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.371E-02_JPRB,.371E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.183E-02_JPRB,.183E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.673E-03_JPRB,.673E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.285E-03_JPRB,.285E-03_JPRB,&
&.246E-03_JPRB,.246E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.406E-03_JPRB,&
&.406E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,&
&.144E-02_JPRB,.144E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 42 -74.0
ZAER (:,42, 5) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.576E-03_JPRB,.576E-03_JPRB,.446E-03_JPRB,&
&.446E-03_JPRB,.932E-03_JPRB,.932E-03_JPRB,.866E-03_JPRB,.866E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,&
&.334E-03_JPRB,.334E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.376E-03_JPRB,.376E-03_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.740E-03_JPRB,.740E-03_JPRB,&
&.647E-03_JPRB,.647E-03_JPRB,.644E-03_JPRB,.644E-03_JPRB,.157E-02_JPRB,.157E-02_JPRB,.298E-02_JPRB,&
&.298E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,&
&.391E-02_JPRB,.391E-02_JPRB,.295E-02_JPRB,.295E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.142E-02_JPRB,&
&.142E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.310E-03_JPRB,.310E-03_JPRB,&
&.345E-03_JPRB,.345E-03_JPRB,.673E-03_JPRB,.673E-03_JPRB,.253E-02_JPRB,.253E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.420E-03_JPRB,.420E-03_JPRB,.468E-03_JPRB,.468E-03_JPRB,.732E-03_JPRB,.732E-03_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 43 -78.0
ZAER (:,43, 5) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.576E-03_JPRB,.576E-03_JPRB,.446E-03_JPRB,&
&.446E-03_JPRB,.932E-03_JPRB,.932E-03_JPRB,.866E-03_JPRB,.866E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,&
&.334E-03_JPRB,.334E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.376E-03_JPRB,.376E-03_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.740E-03_JPRB,.740E-03_JPRB,&
&.647E-03_JPRB,.647E-03_JPRB,.644E-03_JPRB,.644E-03_JPRB,.157E-02_JPRB,.157E-02_JPRB,.298E-02_JPRB,&
&.298E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,&
&.391E-02_JPRB,.391E-02_JPRB,.295E-02_JPRB,.295E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.142E-02_JPRB,&
&.142E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.310E-03_JPRB,.310E-03_JPRB,&
&.345E-03_JPRB,.345E-03_JPRB,.673E-03_JPRB,.673E-03_JPRB,.253E-02_JPRB,.253E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.420E-03_JPRB,.420E-03_JPRB,.468E-03_JPRB,.468E-03_JPRB,.732E-03_JPRB,.732E-03_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 44 -82.0
ZAER (:,44, 5) = (/&
&.421E-03_JPRB,.421E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.356E-03_JPRB,&
&.356E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.339E-03_JPRB,.339E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,&
&.332E-03_JPRB,.332E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.440E-03_JPRB,&
&.440E-03_JPRB,.485E-03_JPRB,.485E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.446E-03_JPRB,.446E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.947E-03_JPRB,&
&.947E-03_JPRB,.150E-02_JPRB,.150E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.488E-03_JPRB,.488E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,.330E-03_JPRB,&
&.330E-03_JPRB,.337E-03_JPRB,.337E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.610E-03_JPRB,.610E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.807E-03_JPRB,&
&.807E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.346E-03_JPRB,.346E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,&
&.415E-03_JPRB,.415E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 45 -86.0
ZAER (:,45, 5) = (/&
&.421E-03_JPRB,.421E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.356E-03_JPRB,&
&.356E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.339E-03_JPRB,.339E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,&
&.332E-03_JPRB,.332E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.440E-03_JPRB,&
&.440E-03_JPRB,.485E-03_JPRB,.485E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.446E-03_JPRB,.446E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.947E-03_JPRB,&
&.947E-03_JPRB,.150E-02_JPRB,.150E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.488E-03_JPRB,.488E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,.330E-03_JPRB,&
&.330E-03_JPRB,.337E-03_JPRB,.337E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.610E-03_JPRB,.610E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.807E-03_JPRB,&
&.807E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.346E-03_JPRB,.346E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,&
&.415E-03_JPRB,.415E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 46 -90.0
ZAER (:,46, 5) = (/&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=5   
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_05
