SUBROUTINE SUECAESS_03

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN
!                                      March

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,3:3)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  3 --- lat:  1  90.0
ZAER (:, 1, 3) = (/&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  2  86.0
ZAER (:, 2, 3) = (/&
&.400E-03_JPRB,.400E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.486E-03_JPRB,.486E-03_JPRB,.523E-03_JPRB,&
&.523E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,&
&.585E-03_JPRB,.585E-03_JPRB,.555E-03_JPRB,.555E-03_JPRB,.534E-03_JPRB,.534E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.520E-03_JPRB,.520E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.488E-03_JPRB,.488E-03_JPRB,&
&.448E-03_JPRB,.448E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.251E-03_JPRB,&
&.251E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.169E-03_JPRB,.169E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,&
&.159E-03_JPRB,.159E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.158E-03_JPRB,&
&.158E-03_JPRB,.152E-03_JPRB,.152E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,&
&.173E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.184E-03_JPRB,.184E-03_JPRB,.199E-03_JPRB,&
&.199E-03_JPRB,.225E-03_JPRB,.225E-03_JPRB,.260E-03_JPRB,.260E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,&
&.355E-03_JPRB,.355E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  3  82.0
ZAER (:, 3, 3) = (/&
&.400E-03_JPRB,.400E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.486E-03_JPRB,.486E-03_JPRB,.523E-03_JPRB,&
&.523E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,&
&.585E-03_JPRB,.585E-03_JPRB,.555E-03_JPRB,.555E-03_JPRB,.534E-03_JPRB,.534E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.520E-03_JPRB,.520E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.488E-03_JPRB,.488E-03_JPRB,&
&.448E-03_JPRB,.448E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.251E-03_JPRB,&
&.251E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.169E-03_JPRB,.169E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,&
&.159E-03_JPRB,.159E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.158E-03_JPRB,&
&.158E-03_JPRB,.152E-03_JPRB,.152E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,&
&.173E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.184E-03_JPRB,.184E-03_JPRB,.199E-03_JPRB,&
&.199E-03_JPRB,.225E-03_JPRB,.225E-03_JPRB,.260E-03_JPRB,.260E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,&
&.355E-03_JPRB,.355E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  4  78.0
ZAER (:, 4, 3) = (/&
&.429E-03_JPRB,.429E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.860E-03_JPRB,.860E-03_JPRB,.777E-03_JPRB,&
&.777E-03_JPRB,.695E-03_JPRB,.695E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.751E-03_JPRB,.751E-03_JPRB,&
&.960E-03_JPRB,.960E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.962E-03_JPRB,.962E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.889E-03_JPRB,.889E-03_JPRB,.736E-03_JPRB,.736E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.400E-03_JPRB,&
&.400E-03_JPRB,.236E-03_JPRB,.236E-03_JPRB,.136E-03_JPRB,.136E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.178E-03_JPRB,.178E-03_JPRB,.193E-03_JPRB,.193E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.214E-03_JPRB,.214E-03_JPRB,.243E-03_JPRB,.243E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,&
&.270E-03_JPRB,.270E-03_JPRB,.244E-03_JPRB,.244E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.181E-03_JPRB,&
&.181E-03_JPRB,.183E-03_JPRB,.183E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.301E-03_JPRB,.301E-03_JPRB,&
&.348E-03_JPRB,.348E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  5  74.0
ZAER (:, 5, 3) = (/&
&.429E-03_JPRB,.429E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.860E-03_JPRB,.860E-03_JPRB,.777E-03_JPRB,&
&.777E-03_JPRB,.695E-03_JPRB,.695E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.751E-03_JPRB,.751E-03_JPRB,&
&.960E-03_JPRB,.960E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.962E-03_JPRB,.962E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.889E-03_JPRB,.889E-03_JPRB,.736E-03_JPRB,.736E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.400E-03_JPRB,&
&.400E-03_JPRB,.236E-03_JPRB,.236E-03_JPRB,.136E-03_JPRB,.136E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.178E-03_JPRB,.178E-03_JPRB,.193E-03_JPRB,.193E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.214E-03_JPRB,.214E-03_JPRB,.243E-03_JPRB,.243E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,&
&.270E-03_JPRB,.270E-03_JPRB,.244E-03_JPRB,.244E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.181E-03_JPRB,&
&.181E-03_JPRB,.183E-03_JPRB,.183E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.301E-03_JPRB,.301E-03_JPRB,&
&.348E-03_JPRB,.348E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  6  70.0
ZAER (:, 6, 3) = (/&
&.308E-02_JPRB,.308E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.224E-02_JPRB,&
&.224E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.268E-02_JPRB,.268E-02_JPRB,.269E-02_JPRB,&
&.269E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.941E-03_JPRB,.941E-03_JPRB,.764E-03_JPRB,.764E-03_JPRB,.564E-03_JPRB,&
&.564E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,&
&.299E-03_JPRB,.299E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,.543E-03_JPRB,&
&.543E-03_JPRB,.718E-03_JPRB,.718E-03_JPRB,.942E-03_JPRB,.942E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.768E-03_JPRB,&
&.768E-03_JPRB,.523E-03_JPRB,.523E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,.955E-03_JPRB,.955E-03_JPRB,&
&.185E-02_JPRB,.185E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  7  66.0
ZAER (:, 7, 3) = (/&
&.308E-02_JPRB,.308E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.224E-02_JPRB,&
&.224E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.268E-02_JPRB,.268E-02_JPRB,.269E-02_JPRB,&
&.269E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.941E-03_JPRB,.941E-03_JPRB,.764E-03_JPRB,.764E-03_JPRB,.564E-03_JPRB,&
&.564E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,&
&.299E-03_JPRB,.299E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,.543E-03_JPRB,&
&.543E-03_JPRB,.718E-03_JPRB,.718E-03_JPRB,.942E-03_JPRB,.942E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.768E-03_JPRB,&
&.768E-03_JPRB,.523E-03_JPRB,.523E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,.955E-03_JPRB,.955E-03_JPRB,&
&.185E-02_JPRB,.185E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  8  62.0
ZAER (:, 8, 3) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.965E-02_JPRB,.965E-02_JPRB,.819E-02_JPRB,.819E-02_JPRB,.558E-02_JPRB,&
&.558E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.957E-02_JPRB,.957E-02_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.989E-02_JPRB,&
&.989E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,&
&.171E-02_JPRB,.171E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.949E-03_JPRB,.949E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,&
&.957E-03_JPRB,.957E-03_JPRB,.247E-02_JPRB,.247E-02_JPRB,.362E-02_JPRB,.362E-02_JPRB,.332E-02_JPRB,&
&.332E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,&
&.713E-02_JPRB,.713E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,&
&.964E-02_JPRB,.964E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  9  58.0
ZAER (:, 9, 3) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.965E-02_JPRB,.965E-02_JPRB,.819E-02_JPRB,.819E-02_JPRB,.558E-02_JPRB,&
&.558E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.957E-02_JPRB,.957E-02_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.989E-02_JPRB,&
&.989E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,&
&.171E-02_JPRB,.171E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.949E-03_JPRB,.949E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,&
&.957E-03_JPRB,.957E-03_JPRB,.247E-02_JPRB,.247E-02_JPRB,.362E-02_JPRB,.362E-02_JPRB,.332E-02_JPRB,&
&.332E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,&
&.713E-02_JPRB,.713E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,&
&.964E-02_JPRB,.964E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 10  54.0
ZAER (:,10, 3) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.939E-02_JPRB,.939E-02_JPRB,.882E-02_JPRB,&
&.882E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.938E-02_JPRB,.938E-02_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.971E-02_JPRB,&
&.971E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.771E-02_JPRB,.771E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,&
&.687E-02_JPRB,.687E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.878E-02_JPRB,.878E-02_JPRB,.876E-02_JPRB,&
&.876E-02_JPRB,.931E-02_JPRB,.931E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 11  50.0
ZAER (:,11, 3) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.939E-02_JPRB,.939E-02_JPRB,.882E-02_JPRB,&
&.882E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.938E-02_JPRB,.938E-02_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.971E-02_JPRB,&
&.971E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.771E-02_JPRB,.771E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,&
&.687E-02_JPRB,.687E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.878E-02_JPRB,.878E-02_JPRB,.876E-02_JPRB,&
&.876E-02_JPRB,.931E-02_JPRB,.931E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 12  46.0
ZAER (:,12, 3) = (/&
&.828E-02_JPRB,.828E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.743E-02_JPRB,&
&.743E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,&
&.786E-02_JPRB,.786E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.628E-02_JPRB,&
&.628E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,&
&.879E-02_JPRB,.879E-02_JPRB,.896E-02_JPRB,.896E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.821E-02_JPRB,&
&.821E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB,.699E-02_JPRB,.699E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.819E-02_JPRB,&
&.819E-02_JPRB,.898E-02_JPRB,.898E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.969E-02_JPRB,&
&.969E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,&
&.656E-02_JPRB,.656E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 13  42.0
ZAER (:,13, 3) = (/&
&.828E-02_JPRB,.828E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.743E-02_JPRB,&
&.743E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,&
&.786E-02_JPRB,.786E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.628E-02_JPRB,&
&.628E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,&
&.879E-02_JPRB,.879E-02_JPRB,.896E-02_JPRB,.896E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.821E-02_JPRB,&
&.821E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB,.699E-02_JPRB,.699E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.819E-02_JPRB,&
&.819E-02_JPRB,.898E-02_JPRB,.898E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.969E-02_JPRB,&
&.969E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,&
&.656E-02_JPRB,.656E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 14  38.0
ZAER (:,14, 3) = (/&
&.704E-02_JPRB,.704E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.756E-02_JPRB,&
&.756E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.745E-02_JPRB,.745E-02_JPRB,&
&.773E-02_JPRB,.773E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.425E-02_JPRB,.425E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,&
&.819E-02_JPRB,.819E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.845E-02_JPRB,&
&.845E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,&
&.802E-02_JPRB,.802E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.562E-02_JPRB,&
&.562E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 15  34.0
ZAER (:,15, 3) = (/&
&.704E-02_JPRB,.704E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.756E-02_JPRB,&
&.756E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.745E-02_JPRB,.745E-02_JPRB,&
&.773E-02_JPRB,.773E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.425E-02_JPRB,.425E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,&
&.819E-02_JPRB,.819E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.845E-02_JPRB,&
&.845E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,&
&.802E-02_JPRB,.802E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.562E-02_JPRB,&
&.562E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 16  30.0
ZAER (:,16, 3) = (/&
&.847E-02_JPRB,.847E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.771E-02_JPRB,&
&.771E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.942E-02_JPRB,.942E-02_JPRB,.782E-02_JPRB,&
&.782E-02_JPRB,.432E-02_JPRB,.432E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,&
&.752E-02_JPRB,.752E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,.906E-02_JPRB,&
&.906E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.289E-02_JPRB,.289E-02_JPRB,&
&.477E-02_JPRB,.477E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.904E-02_JPRB,.904E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.299E-02_JPRB,&
&.299E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 17  26.0
ZAER (:,17, 3) = (/&
&.847E-02_JPRB,.847E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.771E-02_JPRB,&
&.771E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.942E-02_JPRB,.942E-02_JPRB,.782E-02_JPRB,&
&.782E-02_JPRB,.432E-02_JPRB,.432E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,&
&.752E-02_JPRB,.752E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,.906E-02_JPRB,&
&.906E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.289E-02_JPRB,.289E-02_JPRB,&
&.477E-02_JPRB,.477E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.904E-02_JPRB,.904E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.299E-02_JPRB,&
&.299E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 18  22.0
ZAER (:,18, 3) = (/&
&.839E-02_JPRB,.839E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.851E-02_JPRB,&
&.851E-02_JPRB,.908E-02_JPRB,.908E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.715E-03_JPRB,.715E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.643E-02_JPRB,.643E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.272E-02_JPRB,.272E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.766E-02_JPRB,.766E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.329E-02_JPRB,&
&.329E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.953E-02_JPRB,.953E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 19  18.0
ZAER (:,19, 3) = (/&
&.839E-02_JPRB,.839E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.851E-02_JPRB,&
&.851E-02_JPRB,.908E-02_JPRB,.908E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.715E-03_JPRB,.715E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.643E-02_JPRB,.643E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.272E-02_JPRB,.272E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.766E-02_JPRB,.766E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.329E-02_JPRB,&
&.329E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.953E-02_JPRB,.953E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 20  14.0
ZAER (:,20, 3) = (/&
&.960E-02_JPRB,.960E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.845E-02_JPRB,.845E-02_JPRB,.653E-02_JPRB,.653E-02_JPRB,.368E-02_JPRB,&
&.368E-02_JPRB,.549E-03_JPRB,.549E-03_JPRB,.248E-03_JPRB,.248E-03_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.671E-02_JPRB,.671E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.802E-02_JPRB,&
&.802E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.262E-02_JPRB,.262E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.779E-02_JPRB,.779E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.979E-02_JPRB,.979E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 21  10.0
ZAER (:,21, 3) = (/&
&.960E-02_JPRB,.960E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.845E-02_JPRB,.845E-02_JPRB,.653E-02_JPRB,.653E-02_JPRB,.368E-02_JPRB,&
&.368E-02_JPRB,.549E-03_JPRB,.549E-03_JPRB,.248E-03_JPRB,.248E-03_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.671E-02_JPRB,.671E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.802E-02_JPRB,&
&.802E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.262E-02_JPRB,.262E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.779E-02_JPRB,.779E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.979E-02_JPRB,.979E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 22   6.0
ZAER (:,22, 3) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.134E-01_JPRB,&
&.134E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.882E-02_JPRB,.882E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.850E-03_JPRB,&
&.850E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.219E-02_JPRB,.219E-02_JPRB,&
&.818E-02_JPRB,.818E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.828E-02_JPRB,.828E-02_JPRB,.620E-02_JPRB,&
&.620E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.486E-02_JPRB,.486E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.953E-02_JPRB,.953E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,&
&.400E-02_JPRB,.400E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.546E-02_JPRB,&
&.546E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 23   2.0
ZAER (:,23, 3) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.134E-01_JPRB,&
&.134E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.882E-02_JPRB,.882E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.850E-03_JPRB,&
&.850E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.219E-02_JPRB,.219E-02_JPRB,&
&.818E-02_JPRB,.818E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.828E-02_JPRB,.828E-02_JPRB,.620E-02_JPRB,&
&.620E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.486E-02_JPRB,.486E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.953E-02_JPRB,.953E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,&
&.400E-02_JPRB,.400E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.546E-02_JPRB,&
&.546E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 24  -2.0
ZAER (:,24, 3) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.154E-01_JPRB,&
&.154E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.331E-02_JPRB,&
&.331E-02_JPRB,.219E-02_JPRB,.219E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.883E-02_JPRB,.883E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.380E-02_JPRB,&
&.380E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.460E-02_JPRB,.460E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.934E-02_JPRB,&
&.934E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,.562E-02_JPRB,.562E-02_JPRB,&
&.495E-02_JPRB,.495E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.947E-02_JPRB,&
&.947E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 25  -6.0
ZAER (:,25, 3) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.154E-01_JPRB,&
&.154E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.331E-02_JPRB,&
&.331E-02_JPRB,.219E-02_JPRB,.219E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.883E-02_JPRB,.883E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.380E-02_JPRB,&
&.380E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.460E-02_JPRB,.460E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.934E-02_JPRB,&
&.934E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,.562E-02_JPRB,.562E-02_JPRB,&
&.495E-02_JPRB,.495E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.947E-02_JPRB,&
&.947E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 26 -10.0
ZAER (:,26, 3) = (/&
&.141E-01_JPRB,.141E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.170E-01_JPRB,&
&.170E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.843E-02_JPRB,.843E-02_JPRB,.921E-02_JPRB,&
&.921E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.985E-02_JPRB,.985E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.371E-02_JPRB,&
&.371E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.271E-02_JPRB,.271E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 27 -14.0
ZAER (:,27, 3) = (/&
&.141E-01_JPRB,.141E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.170E-01_JPRB,&
&.170E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.843E-02_JPRB,.843E-02_JPRB,.921E-02_JPRB,&
&.921E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.985E-02_JPRB,.985E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.371E-02_JPRB,&
&.371E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.271E-02_JPRB,.271E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 28 -18.0
ZAER (:,28, 3) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.997E-02_JPRB,.997E-02_JPRB,.990E-02_JPRB,.990E-02_JPRB,.978E-02_JPRB,&
&.978E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.872E-02_JPRB,.872E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.383E-02_JPRB,&
&.383E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,&
&.281E-02_JPRB,.281E-02_JPRB,.314E-02_JPRB,.314E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.461E-02_JPRB,&
&.461E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.489E-02_JPRB,.489E-02_JPRB,&
&.485E-02_JPRB,.485E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.144E-01_JPRB,&
&.144E-01_JPRB,.158E-01_JPRB,.158E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 29 -22.0
ZAER (:,29, 3) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.997E-02_JPRB,.997E-02_JPRB,.990E-02_JPRB,.990E-02_JPRB,.978E-02_JPRB,&
&.978E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.872E-02_JPRB,.872E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.383E-02_JPRB,&
&.383E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,&
&.281E-02_JPRB,.281E-02_JPRB,.314E-02_JPRB,.314E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.461E-02_JPRB,&
&.461E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.489E-02_JPRB,.489E-02_JPRB,&
&.485E-02_JPRB,.485E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.144E-01_JPRB,&
&.144E-01_JPRB,.158E-01_JPRB,.158E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 30 -26.0
ZAER (:,30, 3) = (/&
&.918E-02_JPRB,.918E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.893E-02_JPRB,&
&.893E-02_JPRB,.748E-02_JPRB,.748E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,&
&.440E-02_JPRB,.440E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.814E-02_JPRB,.814E-02_JPRB,.856E-02_JPRB,&
&.856E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.932E-02_JPRB,.932E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.370E-02_JPRB,&
&.370E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,&
&.241E-02_JPRB,.241E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.199E-02_JPRB,&
&.199E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,&
&.189E-02_JPRB,.189E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.845E-02_JPRB,&
&.845E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 31 -30.0
ZAER (:,31, 3) = (/&
&.918E-02_JPRB,.918E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.893E-02_JPRB,&
&.893E-02_JPRB,.748E-02_JPRB,.748E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,&
&.440E-02_JPRB,.440E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.814E-02_JPRB,.814E-02_JPRB,.856E-02_JPRB,&
&.856E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.932E-02_JPRB,.932E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.370E-02_JPRB,&
&.370E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,&
&.241E-02_JPRB,.241E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.199E-02_JPRB,&
&.199E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,&
&.189E-02_JPRB,.189E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.845E-02_JPRB,&
&.845E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 32 -34.0
ZAER (:,32, 3) = (/&
&.131E-01_JPRB,.131E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.954E-02_JPRB,.954E-02_JPRB,.985E-02_JPRB,&
&.985E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.367E-02_JPRB,&
&.367E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,&
&.855E-02_JPRB,.855E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.464E-02_JPRB,&
&.464E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,&
&.270E-02_JPRB,.270E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.972E-03_JPRB,&
&.972E-03_JPRB,.813E-03_JPRB,.813E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,&
&.706E-03_JPRB,.706E-03_JPRB,.553E-03_JPRB,.553E-03_JPRB,.201E-02_JPRB,.201E-02_JPRB,.315E-02_JPRB,&
&.315E-02_JPRB,.589E-02_JPRB,.589E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 33 -38.0
ZAER (:,33, 3) = (/&
&.131E-01_JPRB,.131E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.954E-02_JPRB,.954E-02_JPRB,.985E-02_JPRB,&
&.985E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.367E-02_JPRB,&
&.367E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,&
&.855E-02_JPRB,.855E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.464E-02_JPRB,&
&.464E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,&
&.270E-02_JPRB,.270E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.972E-03_JPRB,&
&.972E-03_JPRB,.813E-03_JPRB,.813E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,&
&.706E-03_JPRB,.706E-03_JPRB,.553E-03_JPRB,.553E-03_JPRB,.201E-02_JPRB,.201E-02_JPRB,.315E-02_JPRB,&
&.315E-02_JPRB,.589E-02_JPRB,.589E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 34 -42.0
ZAER (:,34, 3) = (/&
&.149E-01_JPRB,.149E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.965E-02_JPRB,.965E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,&
&.857E-03_JPRB,.857E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.827E-03_JPRB,.827E-03_JPRB,.832E-03_JPRB,&
&.832E-03_JPRB,.259E-02_JPRB,.259E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,&
&.902E-02_JPRB,.902E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.606E-02_JPRB,&
&.606E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.719E-03_JPRB,&
&.719E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.427E-03_JPRB,.427E-03_JPRB,&
&.383E-03_JPRB,.383E-03_JPRB,.347E-03_JPRB,.347E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 35 -46.0
ZAER (:,35, 3) = (/&
&.149E-01_JPRB,.149E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.965E-02_JPRB,.965E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,&
&.857E-03_JPRB,.857E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.827E-03_JPRB,.827E-03_JPRB,.832E-03_JPRB,&
&.832E-03_JPRB,.259E-02_JPRB,.259E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,&
&.902E-02_JPRB,.902E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.606E-02_JPRB,&
&.606E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.719E-03_JPRB,&
&.719E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.427E-03_JPRB,.427E-03_JPRB,&
&.383E-03_JPRB,.383E-03_JPRB,.347E-03_JPRB,.347E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 36 -50.0
ZAER (:,36, 3) = (/&
&.141E-01_JPRB,.141E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.819E-02_JPRB,.819E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.732E-03_JPRB,.732E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.383E-02_JPRB,.383E-02_JPRB,.971E-02_JPRB,.971E-02_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.846E-03_JPRB,.846E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,.615E-03_JPRB,&
&.615E-03_JPRB,.545E-03_JPRB,.545E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.369E-03_JPRB,.369E-03_JPRB,&
&.348E-03_JPRB,.348E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.520E-03_JPRB,&
&.520E-03_JPRB,.239E-02_JPRB,.239E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.945E-02_JPRB,.945E-02_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 37 -54.0
ZAER (:,37, 3) = (/&
&.141E-01_JPRB,.141E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.819E-02_JPRB,.819E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.732E-03_JPRB,.732E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.383E-02_JPRB,.383E-02_JPRB,.971E-02_JPRB,.971E-02_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.846E-03_JPRB,.846E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,.615E-03_JPRB,&
&.615E-03_JPRB,.545E-03_JPRB,.545E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.369E-03_JPRB,.369E-03_JPRB,&
&.348E-03_JPRB,.348E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.520E-03_JPRB,&
&.520E-03_JPRB,.239E-02_JPRB,.239E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.945E-02_JPRB,.945E-02_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 38 -58.0
ZAER (:,38, 3) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.881E-02_JPRB,.881E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.645E-02_JPRB,&
&.645E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.916E-03_JPRB,.916E-03_JPRB,&
&.736E-03_JPRB,.736E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.179E-01_JPRB,.179E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.310E-02_JPRB,.310E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.931E-03_JPRB,.931E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.595E-03_JPRB,&
&.595E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.385E-03_JPRB,.385E-03_JPRB,&
&.455E-03_JPRB,.455E-03_JPRB,.520E-03_JPRB,.520E-03_JPRB,.557E-03_JPRB,.557E-03_JPRB,.740E-03_JPRB,&
&.740E-03_JPRB,.162E-02_JPRB,.162E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,&
&.814E-02_JPRB,.814E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 39 -62.0
ZAER (:,39, 3) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.881E-02_JPRB,.881E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.645E-02_JPRB,&
&.645E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.916E-03_JPRB,.916E-03_JPRB,&
&.736E-03_JPRB,.736E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.179E-01_JPRB,.179E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.310E-02_JPRB,.310E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.931E-03_JPRB,.931E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.595E-03_JPRB,&
&.595E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.385E-03_JPRB,.385E-03_JPRB,&
&.455E-03_JPRB,.455E-03_JPRB,.520E-03_JPRB,.520E-03_JPRB,.557E-03_JPRB,.557E-03_JPRB,.740E-03_JPRB,&
&.740E-03_JPRB,.162E-02_JPRB,.162E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,&
&.814E-02_JPRB,.814E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 40 -66.0
ZAER (:,40, 3) = (/&
&.497E-02_JPRB,.497E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.270E-02_JPRB,&
&.270E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.982E-03_JPRB,.982E-03_JPRB,&
&.772E-03_JPRB,.772E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.152E-02_JPRB,&
&.152E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,&
&.275E-02_JPRB,.275E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.158E-01_JPRB,&
&.158E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.902E-02_JPRB,.902E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.291E-02_JPRB,.291E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.644E-03_JPRB,.644E-03_JPRB,.496E-03_JPRB,.496E-03_JPRB,.486E-03_JPRB,.486E-03_JPRB,&
&.581E-03_JPRB,.581E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,.849E-03_JPRB,.849E-03_JPRB,.988E-03_JPRB,&
&.988E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,&
&.382E-02_JPRB,.382E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 41 -70.0
ZAER (:,41, 3) = (/&
&.497E-02_JPRB,.497E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.270E-02_JPRB,&
&.270E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.982E-03_JPRB,.982E-03_JPRB,&
&.772E-03_JPRB,.772E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.152E-02_JPRB,&
&.152E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,&
&.275E-02_JPRB,.275E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.158E-01_JPRB,&
&.158E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.902E-02_JPRB,.902E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.291E-02_JPRB,.291E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.644E-03_JPRB,.644E-03_JPRB,.496E-03_JPRB,.496E-03_JPRB,.486E-03_JPRB,.486E-03_JPRB,&
&.581E-03_JPRB,.581E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,.849E-03_JPRB,.849E-03_JPRB,.988E-03_JPRB,&
&.988E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,&
&.382E-02_JPRB,.382E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 42 -74.0
ZAER (:,42, 3) = (/&
&.200E-02_JPRB,.200E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.626E-03_JPRB,.626E-03_JPRB,&
&.528E-03_JPRB,.528E-03_JPRB,.624E-03_JPRB,.624E-03_JPRB,.670E-03_JPRB,.670E-03_JPRB,.146E-02_JPRB,&
&.146E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.949E-02_JPRB,&
&.949E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.844E-02_JPRB,.844E-02_JPRB,.724E-02_JPRB,.724E-02_JPRB,&
&.690E-02_JPRB,.690E-02_JPRB,.569E-02_JPRB,.569E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.629E-03_JPRB,.629E-03_JPRB,&
&.649E-03_JPRB,.649E-03_JPRB,.911E-03_JPRB,.911E-03_JPRB,.227E-02_JPRB,.227E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.946E-03_JPRB,.946E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.186E-02_JPRB,.186E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 43 -78.0
ZAER (:,43, 3) = (/&
&.200E-02_JPRB,.200E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.626E-03_JPRB,.626E-03_JPRB,&
&.528E-03_JPRB,.528E-03_JPRB,.624E-03_JPRB,.624E-03_JPRB,.670E-03_JPRB,.670E-03_JPRB,.146E-02_JPRB,&
&.146E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.949E-02_JPRB,&
&.949E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.844E-02_JPRB,.844E-02_JPRB,.724E-02_JPRB,.724E-02_JPRB,&
&.690E-02_JPRB,.690E-02_JPRB,.569E-02_JPRB,.569E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.629E-03_JPRB,.629E-03_JPRB,&
&.649E-03_JPRB,.649E-03_JPRB,.911E-03_JPRB,.911E-03_JPRB,.227E-02_JPRB,.227E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.946E-03_JPRB,.946E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.186E-02_JPRB,.186E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 44 -82.0
ZAER (:,44, 3) = (/&
&.476E-03_JPRB,.476E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,.558E-03_JPRB,&
&.558E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,.615E-03_JPRB,.615E-03_JPRB,.603E-03_JPRB,.603E-03_JPRB,&
&.642E-03_JPRB,.642E-03_JPRB,.725E-03_JPRB,.725E-03_JPRB,.833E-03_JPRB,.833E-03_JPRB,.947E-03_JPRB,&
&.947E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.239E-02_JPRB,&
&.239E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.252E-02_JPRB,.252E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,&
&.950E-03_JPRB,.950E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.660E-03_JPRB,&
&.660E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.622E-03_JPRB,.622E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,&
&.657E-03_JPRB,.657E-03_JPRB,.784E-03_JPRB,.784E-03_JPRB,.940E-03_JPRB,.940E-03_JPRB,.942E-03_JPRB,&
&.942E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.538E-03_JPRB,.538E-03_JPRB,&
&.515E-03_JPRB,.515E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 45 -86.0
ZAER (:,45, 3) = (/&
&.476E-03_JPRB,.476E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,.558E-03_JPRB,&
&.558E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,.615E-03_JPRB,.615E-03_JPRB,.603E-03_JPRB,.603E-03_JPRB,&
&.642E-03_JPRB,.642E-03_JPRB,.725E-03_JPRB,.725E-03_JPRB,.833E-03_JPRB,.833E-03_JPRB,.947E-03_JPRB,&
&.947E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.239E-02_JPRB,&
&.239E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.252E-02_JPRB,.252E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,&
&.950E-03_JPRB,.950E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.660E-03_JPRB,&
&.660E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.622E-03_JPRB,.622E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,&
&.657E-03_JPRB,.657E-03_JPRB,.784E-03_JPRB,.784E-03_JPRB,.940E-03_JPRB,.940E-03_JPRB,.942E-03_JPRB,&
&.942E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.538E-03_JPRB,.538E-03_JPRB,&
&.515E-03_JPRB,.515E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 46 -90.0
ZAER (:,46, 3) = (/&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=3   
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS_03
