SUBROUTINE SUECAESD_05

!**   OPTICAL THICKNESS OF AEROSOLS OF SOIL-DUST ORIGIN
!                                      May

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESD* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSD


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,5:5)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Total Soil Dust Aerosol  month:  5 --- lat:  1  90.0
ZAER (:, 1, 5) = (/&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat:  2  86.0
ZAER (:, 2, 5) = (/&
&.114E-02_JPRB,.114E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.111E-02_JPRB,.109E-02_JPRB,.108E-02_JPRB,&
&.107E-02_JPRB,.108E-02_JPRB,.110E-02_JPRB,.111E-02_JPRB,.113E-02_JPRB,.115E-02_JPRB,.117E-02_JPRB,&
&.120E-02_JPRB,.123E-02_JPRB,.126E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.127E-02_JPRB,.126E-02_JPRB,&
&.125E-02_JPRB,.124E-02_JPRB,.123E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,.123E-02_JPRB,.121E-02_JPRB,&
&.119E-02_JPRB,.117E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.116E-02_JPRB,&
&.115E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.110E-02_JPRB,&
&.109E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.114E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,&
&.116E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat:  3  82.0
ZAER (:, 3, 5) = (/&
&.989E-03_JPRB,.970E-03_JPRB,.960E-03_JPRB,.948E-03_JPRB,.940E-03_JPRB,.938E-03_JPRB,.944E-03_JPRB,&
&.955E-03_JPRB,.976E-03_JPRB,.100E-02_JPRB,.103E-02_JPRB,.105E-02_JPRB,.106E-02_JPRB,.107E-02_JPRB,&
&.110E-02_JPRB,.113E-02_JPRB,.116E-02_JPRB,.120E-02_JPRB,.125E-02_JPRB,.129E-02_JPRB,.133E-02_JPRB,&
&.135E-02_JPRB,.136E-02_JPRB,.137E-02_JPRB,.138E-02_JPRB,.139E-02_JPRB,.141E-02_JPRB,.142E-02_JPRB,&
&.140E-02_JPRB,.138E-02_JPRB,.135E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.130E-02_JPRB,.128E-02_JPRB,&
&.125E-02_JPRB,.122E-02_JPRB,.121E-02_JPRB,.119E-02_JPRB,.116E-02_JPRB,.114E-02_JPRB,.112E-02_JPRB,&
&.110E-02_JPRB,.108E-02_JPRB,.107E-02_JPRB,.106E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.106E-02_JPRB,&
&.105E-02_JPRB,.106E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.107E-02_JPRB,.107E-02_JPRB,.108E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.110E-02_JPRB,.111E-02_JPRB,&
&.112E-02_JPRB,.113E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.114E-02_JPRB,.112E-02_JPRB,.108E-02_JPRB,&
&.104E-02_JPRB,.101E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat:  4  78.0
ZAER (:, 4, 5) = (/&
&.104E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.101E-02_JPRB,.100E-02_JPRB,.984E-03_JPRB,.968E-03_JPRB,&
&.969E-03_JPRB,.997E-03_JPRB,.103E-02_JPRB,.105E-02_JPRB,.107E-02_JPRB,.105E-02_JPRB,.103E-02_JPRB,&
&.102E-02_JPRB,.103E-02_JPRB,.107E-02_JPRB,.113E-02_JPRB,.122E-02_JPRB,.132E-02_JPRB,.144E-02_JPRB,&
&.156E-02_JPRB,.170E-02_JPRB,.175E-02_JPRB,.176E-02_JPRB,.179E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,&
&.177E-02_JPRB,.173E-02_JPRB,.166E-02_JPRB,.158E-02_JPRB,.152E-02_JPRB,.144E-02_JPRB,.138E-02_JPRB,&
&.130E-02_JPRB,.123E-02_JPRB,.122E-02_JPRB,.120E-02_JPRB,.115E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.112E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.111E-02_JPRB,.110E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.110E-02_JPRB,.112E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,&
&.110E-02_JPRB,.109E-02_JPRB,.108E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.110E-02_JPRB,.113E-02_JPRB,&
&.116E-02_JPRB,.119E-02_JPRB,.121E-02_JPRB,.125E-02_JPRB,.126E-02_JPRB,.122E-02_JPRB,.114E-02_JPRB,&
&.109E-02_JPRB,.106E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat:  5  74.0
ZAER (:, 5, 5) = (/&
&.112E-02_JPRB,.111E-02_JPRB,.113E-02_JPRB,.116E-02_JPRB,.117E-02_JPRB,.116E-02_JPRB,.112E-02_JPRB,&
&.108E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.109E-02_JPRB,.106E-02_JPRB,&
&.101E-02_JPRB,.972E-03_JPRB,.957E-03_JPRB,.990E-03_JPRB,.107E-02_JPRB,.120E-02_JPRB,.137E-02_JPRB,&
&.157E-02_JPRB,.175E-02_JPRB,.188E-02_JPRB,.197E-02_JPRB,.204E-02_JPRB,.210E-02_JPRB,.215E-02_JPRB,&
&.216E-02_JPRB,.211E-02_JPRB,.203E-02_JPRB,.192E-02_JPRB,.180E-02_JPRB,.164E-02_JPRB,.148E-02_JPRB,&
&.135E-02_JPRB,.124E-02_JPRB,.117E-02_JPRB,.111E-02_JPRB,.105E-02_JPRB,.104E-02_JPRB,.106E-02_JPRB,&
&.108E-02_JPRB,.111E-02_JPRB,.116E-02_JPRB,.120E-02_JPRB,.123E-02_JPRB,.120E-02_JPRB,.117E-02_JPRB,&
&.114E-02_JPRB,.115E-02_JPRB,.120E-02_JPRB,.124E-02_JPRB,.123E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.118E-02_JPRB,.116E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.116E-02_JPRB,.119E-02_JPRB,&
&.123E-02_JPRB,.129E-02_JPRB,.134E-02_JPRB,.138E-02_JPRB,.140E-02_JPRB,.136E-02_JPRB,.129E-02_JPRB,&
&.121E-02_JPRB,.116E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat:  6  70.0
ZAER (:, 6, 5) = (/&
&.128E-02_JPRB,.123E-02_JPRB,.120E-02_JPRB,.122E-02_JPRB,.129E-02_JPRB,.127E-02_JPRB,.121E-02_JPRB,&
&.115E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.114E-02_JPRB,.116E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,&
&.115E-02_JPRB,.111E-02_JPRB,.107E-02_JPRB,.104E-02_JPRB,.103E-02_JPRB,.112E-02_JPRB,.127E-02_JPRB,&
&.141E-02_JPRB,.150E-02_JPRB,.160E-02_JPRB,.170E-02_JPRB,.190E-02_JPRB,.215E-02_JPRB,.234E-02_JPRB,&
&.241E-02_JPRB,.233E-02_JPRB,.222E-02_JPRB,.212E-02_JPRB,.206E-02_JPRB,.193E-02_JPRB,.170E-02_JPRB,&
&.149E-02_JPRB,.131E-02_JPRB,.114E-02_JPRB,.102E-02_JPRB,.960E-03_JPRB,.945E-03_JPRB,.950E-03_JPRB,&
&.972E-03_JPRB,.103E-02_JPRB,.113E-02_JPRB,.123E-02_JPRB,.132E-02_JPRB,.134E-02_JPRB,.129E-02_JPRB,&
&.122E-02_JPRB,.119E-02_JPRB,.124E-02_JPRB,.131E-02_JPRB,.132E-02_JPRB,.127E-02_JPRB,.122E-02_JPRB,&
&.119E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.120E-02_JPRB,.124E-02_JPRB,&
&.129E-02_JPRB,.131E-02_JPRB,.135E-02_JPRB,.142E-02_JPRB,.148E-02_JPRB,.151E-02_JPRB,.153E-02_JPRB,&
&.149E-02_JPRB,.139E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat:  7  66.0
ZAER (:, 7, 5) = (/&
&.148E-02_JPRB,.146E-02_JPRB,.140E-02_JPRB,.130E-02_JPRB,.131E-02_JPRB,.118E-02_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.114E-02_JPRB,.118E-02_JPRB,.121E-02_JPRB,.123E-02_JPRB,.125E-02_JPRB,.126E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.125E-02_JPRB,.122E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.136E-02_JPRB,&
&.141E-02_JPRB,.147E-02_JPRB,.154E-02_JPRB,.165E-02_JPRB,.191E-02_JPRB,.234E-02_JPRB,.274E-02_JPRB,&
&.290E-02_JPRB,.278E-02_JPRB,.266E-02_JPRB,.250E-02_JPRB,.239E-02_JPRB,.228E-02_JPRB,.208E-02_JPRB,&
&.184E-02_JPRB,.162E-02_JPRB,.137E-02_JPRB,.116E-02_JPRB,.105E-02_JPRB,.100E-02_JPRB,.986E-03_JPRB,&
&.101E-02_JPRB,.107E-02_JPRB,.116E-02_JPRB,.128E-02_JPRB,.136E-02_JPRB,.140E-02_JPRB,.138E-02_JPRB,&
&.131E-02_JPRB,.128E-02_JPRB,.130E-02_JPRB,.134E-02_JPRB,.133E-02_JPRB,.129E-02_JPRB,.121E-02_JPRB,&
&.116E-02_JPRB,.114E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.116E-02_JPRB,.125E-02_JPRB,&
&.133E-02_JPRB,.134E-02_JPRB,.138E-02_JPRB,.157E-02_JPRB,.189E-02_JPRB,.190E-02_JPRB,.182E-02_JPRB,&
&.179E-02_JPRB,.162E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat:  8  62.0
ZAER (:, 8, 5) = (/&
&.192E-02_JPRB,.171E-02_JPRB,.159E-02_JPRB,.142E-02_JPRB,.129E-02_JPRB,.113E-02_JPRB,.111E-02_JPRB,&
&.119E-02_JPRB,.129E-02_JPRB,.135E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,&
&.138E-02_JPRB,.137E-02_JPRB,.135E-02_JPRB,.132E-02_JPRB,.130E-02_JPRB,.126E-02_JPRB,.137E-02_JPRB,&
&.149E-02_JPRB,.150E-02_JPRB,.162E-02_JPRB,.184E-02_JPRB,.225E-02_JPRB,.276E-02_JPRB,.311E-02_JPRB,&
&.329E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.314E-02_JPRB,.304E-02_JPRB,.280E-02_JPRB,.257E-02_JPRB,&
&.234E-02_JPRB,.212E-02_JPRB,.181E-02_JPRB,.154E-02_JPRB,.134E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.128E-02_JPRB,.131E-02_JPRB,.137E-02_JPRB,.147E-02_JPRB,.156E-02_JPRB,.166E-02_JPRB,.162E-02_JPRB,&
&.156E-02_JPRB,.150E-02_JPRB,.148E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.142E-02_JPRB,.134E-02_JPRB,&
&.127E-02_JPRB,.121E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.119E-02_JPRB,.133E-02_JPRB,&
&.151E-02_JPRB,.164E-02_JPRB,.177E-02_JPRB,.248E-02_JPRB,.280E-02_JPRB,.255E-02_JPRB,.236E-02_JPRB,&
&.230E-02_JPRB,.214E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat:  9  58.0
ZAER (:, 9, 5) = (/&
&.238E-02_JPRB,.218E-02_JPRB,.195E-02_JPRB,.168E-02_JPRB,.147E-02_JPRB,.130E-02_JPRB,.128E-02_JPRB,&
&.138E-02_JPRB,.147E-02_JPRB,.153E-02_JPRB,.156E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.159E-02_JPRB,&
&.162E-02_JPRB,.161E-02_JPRB,.155E-02_JPRB,.147E-02_JPRB,.141E-02_JPRB,.137E-02_JPRB,.136E-02_JPRB,&
&.155E-02_JPRB,.162E-02_JPRB,.182E-02_JPRB,.240E-02_JPRB,.337E-02_JPRB,.395E-02_JPRB,.421E-02_JPRB,&
&.410E-02_JPRB,.379E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.366E-02_JPRB,.347E-02_JPRB,.310E-02_JPRB,&
&.288E-02_JPRB,.273E-02_JPRB,.249E-02_JPRB,.218E-02_JPRB,.187E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,&
&.166E-02_JPRB,.168E-02_JPRB,.179E-02_JPRB,.191E-02_JPRB,.201E-02_JPRB,.205E-02_JPRB,.202E-02_JPRB,&
&.198E-02_JPRB,.197E-02_JPRB,.195E-02_JPRB,.189E-02_JPRB,.183E-02_JPRB,.176E-02_JPRB,.166E-02_JPRB,&
&.157E-02_JPRB,.153E-02_JPRB,.148E-02_JPRB,.146E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.153E-02_JPRB,&
&.179E-02_JPRB,.203E-02_JPRB,.265E-02_JPRB,.350E-02_JPRB,.331E-02_JPRB,.309E-02_JPRB,.307E-02_JPRB,&
&.287E-02_JPRB,.259E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 10  54.0
ZAER (:,10, 5) = (/&
&.262E-02_JPRB,.253E-02_JPRB,.235E-02_JPRB,.208E-02_JPRB,.175E-02_JPRB,.150E-02_JPRB,.145E-02_JPRB,&
&.155E-02_JPRB,.165E-02_JPRB,.174E-02_JPRB,.173E-02_JPRB,.171E-02_JPRB,.172E-02_JPRB,.173E-02_JPRB,&
&.177E-02_JPRB,.178E-02_JPRB,.175E-02_JPRB,.167E-02_JPRB,.157E-02_JPRB,.151E-02_JPRB,.159E-02_JPRB,&
&.258E-02_JPRB,.342E-02_JPRB,.460E-02_JPRB,.593E-02_JPRB,.712E-02_JPRB,.777E-02_JPRB,.734E-02_JPRB,&
&.627E-02_JPRB,.518E-02_JPRB,.452E-02_JPRB,.405E-02_JPRB,.382E-02_JPRB,.365E-02_JPRB,.346E-02_JPRB,&
&.329E-02_JPRB,.316E-02_JPRB,.290E-02_JPRB,.265E-02_JPRB,.249E-02_JPRB,.242E-02_JPRB,.240E-02_JPRB,&
&.235E-02_JPRB,.238E-02_JPRB,.251E-02_JPRB,.262E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,&
&.268E-02_JPRB,.270E-02_JPRB,.263E-02_JPRB,.249E-02_JPRB,.230E-02_JPRB,.209E-02_JPRB,.193E-02_JPRB,&
&.182E-02_JPRB,.174E-02_JPRB,.171E-02_JPRB,.172E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.187E-02_JPRB,&
&.205E-02_JPRB,.258E-02_JPRB,.393E-02_JPRB,.409E-02_JPRB,.364E-02_JPRB,.353E-02_JPRB,.328E-02_JPRB,&
&.291E-02_JPRB,.269E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 11  50.0
ZAER (:,11, 5) = (/&
&.284E-02_JPRB,.277E-02_JPRB,.267E-02_JPRB,.246E-02_JPRB,.215E-02_JPRB,.186E-02_JPRB,.173E-02_JPRB,&
&.175E-02_JPRB,.181E-02_JPRB,.180E-02_JPRB,.168E-02_JPRB,.167E-02_JPRB,.176E-02_JPRB,.183E-02_JPRB,&
&.189E-02_JPRB,.191E-02_JPRB,.189E-02_JPRB,.183E-02_JPRB,.176E-02_JPRB,.171E-02_JPRB,.292E-02_JPRB,&
&.544E-02_JPRB,.146E-01_JPRB,.214E-01_JPRB,.198E-01_JPRB,.161E-01_JPRB,.125E-01_JPRB,.922E-02_JPRB,&
&.749E-02_JPRB,.637E-02_JPRB,.565E-02_JPRB,.506E-02_JPRB,.454E-02_JPRB,.433E-02_JPRB,.426E-02_JPRB,&
&.414E-02_JPRB,.390E-02_JPRB,.360E-02_JPRB,.340E-02_JPRB,.333E-02_JPRB,.333E-02_JPRB,.323E-02_JPRB,&
&.331E-02_JPRB,.351E-02_JPRB,.354E-02_JPRB,.345E-02_JPRB,.346E-02_JPRB,.351E-02_JPRB,.360E-02_JPRB,&
&.360E-02_JPRB,.351E-02_JPRB,.334E-02_JPRB,.313E-02_JPRB,.287E-02_JPRB,.259E-02_JPRB,.233E-02_JPRB,&
&.214E-02_JPRB,.196E-02_JPRB,.187E-02_JPRB,.193E-02_JPRB,.195E-02_JPRB,.197E-02_JPRB,.212E-02_JPRB,&
&.237E-02_JPRB,.399E-02_JPRB,.582E-02_JPRB,.501E-02_JPRB,.420E-02_JPRB,.385E-02_JPRB,.335E-02_JPRB,&
&.304E-02_JPRB,.292E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 12  46.0
ZAER (:,12, 5) = (/&
&.341E-02_JPRB,.334E-02_JPRB,.321E-02_JPRB,.302E-02_JPRB,.273E-02_JPRB,.243E-02_JPRB,.221E-02_JPRB,&
&.211E-02_JPRB,.199E-02_JPRB,.188E-02_JPRB,.178E-02_JPRB,.187E-02_JPRB,.204E-02_JPRB,.211E-02_JPRB,&
&.208E-02_JPRB,.202E-02_JPRB,.196E-02_JPRB,.188E-02_JPRB,.184E-02_JPRB,.195E-02_JPRB,.296E-02_JPRB,&
&.346E-02_JPRB,.151E-01_JPRB,.474E-01_JPRB,.463E-01_JPRB,.282E-01_JPRB,.184E-01_JPRB,.140E-01_JPRB,&
&.117E-01_JPRB,.970E-02_JPRB,.830E-02_JPRB,.751E-02_JPRB,.686E-02_JPRB,.632E-02_JPRB,.591E-02_JPRB,&
&.550E-02_JPRB,.507E-02_JPRB,.469E-02_JPRB,.443E-02_JPRB,.415E-02_JPRB,.392E-02_JPRB,.394E-02_JPRB,&
&.471E-02_JPRB,.454E-02_JPRB,.426E-02_JPRB,.419E-02_JPRB,.418E-02_JPRB,.422E-02_JPRB,.430E-02_JPRB,&
&.429E-02_JPRB,.427E-02_JPRB,.403E-02_JPRB,.359E-02_JPRB,.326E-02_JPRB,.303E-02_JPRB,.279E-02_JPRB,&
&.256E-02_JPRB,.238E-02_JPRB,.246E-02_JPRB,.247E-02_JPRB,.234E-02_JPRB,.235E-02_JPRB,.281E-02_JPRB,&
&.434E-02_JPRB,.863E-02_JPRB,.866E-02_JPRB,.651E-02_JPRB,.500E-02_JPRB,.392E-02_JPRB,.340E-02_JPRB,&
&.336E-02_JPRB,.342E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 13  42.0
ZAER (:,13, 5) = (/&
&.392E-02_JPRB,.378E-02_JPRB,.358E-02_JPRB,.343E-02_JPRB,.326E-02_JPRB,.301E-02_JPRB,.278E-02_JPRB,&
&.261E-02_JPRB,.240E-02_JPRB,.218E-02_JPRB,.210E-02_JPRB,.224E-02_JPRB,.230E-02_JPRB,.223E-02_JPRB,&
&.210E-02_JPRB,.200E-02_JPRB,.197E-02_JPRB,.190E-02_JPRB,.186E-02_JPRB,.195E-02_JPRB,.228E-02_JPRB,&
&.247E-02_JPRB,.457E-02_JPRB,.382E-01_JPRB,.461E-01_JPRB,.254E-01_JPRB,.177E-01_JPRB,.148E-01_JPRB,&
&.128E-01_JPRB,.105E-01_JPRB,.856E-02_JPRB,.747E-02_JPRB,.670E-02_JPRB,.600E-02_JPRB,.583E-02_JPRB,&
&.584E-02_JPRB,.562E-02_JPRB,.502E-02_JPRB,.464E-02_JPRB,.432E-02_JPRB,.419E-02_JPRB,.484E-02_JPRB,&
&.729E-02_JPRB,.713E-02_JPRB,.611E-02_JPRB,.556E-02_JPRB,.495E-02_JPRB,.455E-02_JPRB,.446E-02_JPRB,&
&.447E-02_JPRB,.474E-02_JPRB,.449E-02_JPRB,.397E-02_JPRB,.357E-02_JPRB,.340E-02_JPRB,.321E-02_JPRB,&
&.298E-02_JPRB,.306E-02_JPRB,.348E-02_JPRB,.309E-02_JPRB,.276E-02_JPRB,.346E-02_JPRB,.516E-02_JPRB,&
&.108E-01_JPRB,.135E-01_JPRB,.921E-02_JPRB,.731E-02_JPRB,.627E-02_JPRB,.468E-02_JPRB,.393E-02_JPRB,&
&.387E-02_JPRB,.392E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 14  38.0
ZAER (:,14, 5) = (/&
&.441E-02_JPRB,.418E-02_JPRB,.391E-02_JPRB,.370E-02_JPRB,.359E-02_JPRB,.347E-02_JPRB,.333E-02_JPRB,&
&.313E-02_JPRB,.282E-02_JPRB,.261E-02_JPRB,.257E-02_JPRB,.248E-02_JPRB,.234E-02_JPRB,.220E-02_JPRB,&
&.213E-02_JPRB,.206E-02_JPRB,.202E-02_JPRB,.196E-02_JPRB,.188E-02_JPRB,.187E-02_JPRB,.190E-02_JPRB,&
&.227E-02_JPRB,.643E-02_JPRB,.191E-01_JPRB,.246E-01_JPRB,.193E-01_JPRB,.152E-01_JPRB,.130E-01_JPRB,&
&.110E-01_JPRB,.938E-02_JPRB,.802E-02_JPRB,.677E-02_JPRB,.594E-02_JPRB,.534E-02_JPRB,.532E-02_JPRB,&
&.547E-02_JPRB,.535E-02_JPRB,.482E-02_JPRB,.456E-02_JPRB,.471E-02_JPRB,.556E-02_JPRB,.788E-02_JPRB,&
&.111E-01_JPRB,.983E-02_JPRB,.716E-02_JPRB,.602E-02_JPRB,.543E-02_JPRB,.503E-02_JPRB,.475E-02_JPRB,&
&.459E-02_JPRB,.471E-02_JPRB,.405E-02_JPRB,.347E-02_JPRB,.346E-02_JPRB,.370E-02_JPRB,.363E-02_JPRB,&
&.346E-02_JPRB,.405E-02_JPRB,.485E-02_JPRB,.445E-02_JPRB,.509E-02_JPRB,.760E-02_JPRB,.117E-01_JPRB,&
&.183E-01_JPRB,.153E-01_JPRB,.990E-02_JPRB,.856E-02_JPRB,.808E-02_JPRB,.638E-02_JPRB,.496E-02_JPRB,&
&.454E-02_JPRB,.444E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 15  34.0
ZAER (:,15, 5) = (/&
&.500E-02_JPRB,.460E-02_JPRB,.426E-02_JPRB,.400E-02_JPRB,.391E-02_JPRB,.386E-02_JPRB,.379E-02_JPRB,&
&.354E-02_JPRB,.322E-02_JPRB,.304E-02_JPRB,.283E-02_JPRB,.251E-02_JPRB,.238E-02_JPRB,.229E-02_JPRB,&
&.227E-02_JPRB,.221E-02_JPRB,.212E-02_JPRB,.200E-02_JPRB,.192E-02_JPRB,.194E-02_JPRB,.203E-02_JPRB,&
&.274E-02_JPRB,.552E-02_JPRB,.989E-02_JPRB,.144E-01_JPRB,.147E-01_JPRB,.133E-01_JPRB,.118E-01_JPRB,&
&.102E-01_JPRB,.931E-02_JPRB,.824E-02_JPRB,.713E-02_JPRB,.636E-02_JPRB,.572E-02_JPRB,.536E-02_JPRB,&
&.533E-02_JPRB,.521E-02_JPRB,.496E-02_JPRB,.501E-02_JPRB,.735E-02_JPRB,.154E-01_JPRB,.245E-01_JPRB,&
&.223E-01_JPRB,.133E-01_JPRB,.835E-02_JPRB,.693E-02_JPRB,.640E-02_JPRB,.589E-02_JPRB,.534E-02_JPRB,&
&.505E-02_JPRB,.471E-02_JPRB,.410E-02_JPRB,.388E-02_JPRB,.391E-02_JPRB,.404E-02_JPRB,.408E-02_JPRB,&
&.412E-02_JPRB,.454E-02_JPRB,.638E-02_JPRB,.847E-02_JPRB,.120E-01_JPRB,.168E-01_JPRB,.286E-01_JPRB,&
&.309E-01_JPRB,.296E-01_JPRB,.240E-01_JPRB,.135E-01_JPRB,.960E-02_JPRB,.791E-02_JPRB,.655E-02_JPRB,&
&.571E-02_JPRB,.525E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 16  30.0
ZAER (:,16, 5) = (/&
&.529E-02_JPRB,.483E-02_JPRB,.444E-02_JPRB,.424E-02_JPRB,.406E-02_JPRB,.403E-02_JPRB,.390E-02_JPRB,&
&.370E-02_JPRB,.337E-02_JPRB,.304E-02_JPRB,.282E-02_JPRB,.266E-02_JPRB,.259E-02_JPRB,.244E-02_JPRB,&
&.226E-02_JPRB,.220E-02_JPRB,.214E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.204E-02_JPRB,.215E-02_JPRB,&
&.283E-02_JPRB,.591E-02_JPRB,.108E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.118E-01_JPRB,.102E-01_JPRB,&
&.875E-02_JPRB,.796E-02_JPRB,.739E-02_JPRB,.676E-02_JPRB,.622E-02_JPRB,.575E-02_JPRB,.577E-02_JPRB,&
&.580E-02_JPRB,.565E-02_JPRB,.622E-02_JPRB,.773E-02_JPRB,.149E-01_JPRB,.349E-01_JPRB,.440E-01_JPRB,&
&.303E-01_JPRB,.153E-01_JPRB,.101E-01_JPRB,.833E-02_JPRB,.737E-02_JPRB,.662E-02_JPRB,.608E-02_JPRB,&
&.568E-02_JPRB,.545E-02_JPRB,.504E-02_JPRB,.471E-02_JPRB,.458E-02_JPRB,.447E-02_JPRB,.442E-02_JPRB,&
&.450E-02_JPRB,.503E-02_JPRB,.730E-02_JPRB,.132E-01_JPRB,.195E-01_JPRB,.286E-01_JPRB,.435E-01_JPRB,&
&.425E-01_JPRB,.359E-01_JPRB,.257E-01_JPRB,.162E-01_JPRB,.113E-01_JPRB,.895E-02_JPRB,.757E-02_JPRB,&
&.661E-02_JPRB,.585E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 17  26.0
ZAER (:,17, 5) = (/&
&.545E-02_JPRB,.493E-02_JPRB,.448E-02_JPRB,.426E-02_JPRB,.405E-02_JPRB,.389E-02_JPRB,.365E-02_JPRB,&
&.340E-02_JPRB,.303E-02_JPRB,.274E-02_JPRB,.262E-02_JPRB,.253E-02_JPRB,.250E-02_JPRB,.242E-02_JPRB,&
&.221E-02_JPRB,.207E-02_JPRB,.203E-02_JPRB,.204E-02_JPRB,.209E-02_JPRB,.211E-02_JPRB,.229E-02_JPRB,&
&.293E-02_JPRB,.492E-02_JPRB,.109E-01_JPRB,.127E-01_JPRB,.113E-01_JPRB,.955E-02_JPRB,.776E-02_JPRB,&
&.672E-02_JPRB,.613E-02_JPRB,.584E-02_JPRB,.563E-02_JPRB,.551E-02_JPRB,.564E-02_JPRB,.626E-02_JPRB,&
&.663E-02_JPRB,.733E-02_JPRB,.102E-01_JPRB,.149E-01_JPRB,.249E-01_JPRB,.364E-01_JPRB,.317E-01_JPRB,&
&.224E-01_JPRB,.145E-01_JPRB,.994E-02_JPRB,.871E-02_JPRB,.712E-02_JPRB,.632E-02_JPRB,.580E-02_JPRB,&
&.537E-02_JPRB,.524E-02_JPRB,.505E-02_JPRB,.479E-02_JPRB,.458E-02_JPRB,.439E-02_JPRB,.438E-02_JPRB,&
&.454E-02_JPRB,.525E-02_JPRB,.911E-02_JPRB,.206E-01_JPRB,.246E-01_JPRB,.314E-01_JPRB,.392E-01_JPRB,&
&.388E-01_JPRB,.263E-01_JPRB,.199E-01_JPRB,.145E-01_JPRB,.109E-01_JPRB,.892E-02_JPRB,.772E-02_JPRB,&
&.678E-02_JPRB,.600E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 18  22.0
ZAER (:,18, 5) = (/&
&.463E-02_JPRB,.435E-02_JPRB,.391E-02_JPRB,.347E-02_JPRB,.298E-02_JPRB,.270E-02_JPRB,.255E-02_JPRB,&
&.234E-02_JPRB,.209E-02_JPRB,.194E-02_JPRB,.191E-02_JPRB,.194E-02_JPRB,.207E-02_JPRB,.216E-02_JPRB,&
&.212E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.207E-02_JPRB,.215E-02_JPRB,.238E-02_JPRB,.286E-02_JPRB,&
&.350E-02_JPRB,.429E-02_JPRB,.709E-02_JPRB,.103E-01_JPRB,.604E-02_JPRB,.584E-02_JPRB,.568E-02_JPRB,&
&.511E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.513E-02_JPRB,.567E-02_JPRB,.639E-02_JPRB,.742E-02_JPRB,&
&.835E-02_JPRB,.948E-02_JPRB,.111E-01_JPRB,.134E-01_JPRB,.196E-01_JPRB,.316E-01_JPRB,.308E-01_JPRB,&
&.153E-01_JPRB,.112E-01_JPRB,.942E-02_JPRB,.854E-02_JPRB,.630E-02_JPRB,.573E-02_JPRB,.527E-02_JPRB,&
&.481E-02_JPRB,.452E-02_JPRB,.436E-02_JPRB,.424E-02_JPRB,.420E-02_JPRB,.422E-02_JPRB,.443E-02_JPRB,&
&.509E-02_JPRB,.626E-02_JPRB,.121E-01_JPRB,.267E-01_JPRB,.288E-01_JPRB,.287E-01_JPRB,.317E-01_JPRB,&
&.279E-01_JPRB,.211E-01_JPRB,.153E-01_JPRB,.989E-02_JPRB,.794E-02_JPRB,.689E-02_JPRB,.601E-02_JPRB,&
&.533E-02_JPRB,.488E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 19  18.0
ZAER (:,19, 5) = (/&
&.338E-02_JPRB,.323E-02_JPRB,.278E-02_JPRB,.230E-02_JPRB,.197E-02_JPRB,.179E-02_JPRB,.171E-02_JPRB,&
&.163E-02_JPRB,.157E-02_JPRB,.151E-02_JPRB,.150E-02_JPRB,.156E-02_JPRB,.168E-02_JPRB,.177E-02_JPRB,&
&.183E-02_JPRB,.188E-02_JPRB,.198E-02_JPRB,.214E-02_JPRB,.241E-02_JPRB,.287E-02_JPRB,.325E-02_JPRB,&
&.335E-02_JPRB,.331E-02_JPRB,.463E-02_JPRB,.596E-02_JPRB,.428E-02_JPRB,.422E-02_JPRB,.439E-02_JPRB,&
&.438E-02_JPRB,.440E-02_JPRB,.488E-02_JPRB,.570E-02_JPRB,.681E-02_JPRB,.763E-02_JPRB,.830E-02_JPRB,&
&.879E-02_JPRB,.920E-02_JPRB,.925E-02_JPRB,.938E-02_JPRB,.111E-01_JPRB,.131E-01_JPRB,.118E-01_JPRB,&
&.928E-02_JPRB,.783E-02_JPRB,.702E-02_JPRB,.614E-02_JPRB,.521E-02_JPRB,.465E-02_JPRB,.432E-02_JPRB,&
&.404E-02_JPRB,.380E-02_JPRB,.364E-02_JPRB,.369E-02_JPRB,.402E-02_JPRB,.472E-02_JPRB,.573E-02_JPRB,&
&.730E-02_JPRB,.959E-02_JPRB,.138E-01_JPRB,.217E-01_JPRB,.254E-01_JPRB,.245E-01_JPRB,.244E-01_JPRB,&
&.216E-01_JPRB,.140E-01_JPRB,.765E-02_JPRB,.551E-02_JPRB,.455E-02_JPRB,.402E-02_JPRB,.359E-02_JPRB,&
&.343E-02_JPRB,.335E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 20  14.0
ZAER (:,20, 5) = (/&
&.198E-02_JPRB,.189E-02_JPRB,.166E-02_JPRB,.146E-02_JPRB,.142E-02_JPRB,.145E-02_JPRB,.147E-02_JPRB,&
&.142E-02_JPRB,.142E-02_JPRB,.143E-02_JPRB,.148E-02_JPRB,.157E-02_JPRB,.167E-02_JPRB,.174E-02_JPRB,&
&.184E-02_JPRB,.201E-02_JPRB,.220E-02_JPRB,.236E-02_JPRB,.262E-02_JPRB,.291E-02_JPRB,.310E-02_JPRB,&
&.276E-02_JPRB,.306E-02_JPRB,.358E-02_JPRB,.372E-02_JPRB,.352E-02_JPRB,.372E-02_JPRB,.393E-02_JPRB,&
&.401E-02_JPRB,.449E-02_JPRB,.547E-02_JPRB,.679E-02_JPRB,.792E-02_JPRB,.813E-02_JPRB,.790E-02_JPRB,&
&.789E-02_JPRB,.803E-02_JPRB,.779E-02_JPRB,.729E-02_JPRB,.724E-02_JPRB,.734E-02_JPRB,.712E-02_JPRB,&
&.683E-02_JPRB,.647E-02_JPRB,.600E-02_JPRB,.530E-02_JPRB,.425E-02_JPRB,.355E-02_JPRB,.326E-02_JPRB,&
&.316E-02_JPRB,.314E-02_JPRB,.319E-02_JPRB,.344E-02_JPRB,.392E-02_JPRB,.472E-02_JPRB,.599E-02_JPRB,&
&.770E-02_JPRB,.973E-02_JPRB,.122E-01_JPRB,.153E-01_JPRB,.176E-01_JPRB,.164E-01_JPRB,.130E-01_JPRB,&
&.908E-02_JPRB,.519E-02_JPRB,.331E-02_JPRB,.264E-02_JPRB,.237E-02_JPRB,.212E-02_JPRB,.193E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 21  10.0
ZAER (:,21, 5) = (/&
&.996E-03_JPRB,.103E-02_JPRB,.106E-02_JPRB,.111E-02_JPRB,.119E-02_JPRB,.130E-02_JPRB,.138E-02_JPRB,&
&.142E-02_JPRB,.149E-02_JPRB,.155E-02_JPRB,.166E-02_JPRB,.180E-02_JPRB,.196E-02_JPRB,.210E-02_JPRB,&
&.228E-02_JPRB,.249E-02_JPRB,.263E-02_JPRB,.272E-02_JPRB,.287E-02_JPRB,.304E-02_JPRB,.281E-02_JPRB,&
&.258E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.272E-02_JPRB,.309E-02_JPRB,.350E-02_JPRB,.382E-02_JPRB,&
&.410E-02_JPRB,.477E-02_JPRB,.580E-02_JPRB,.678E-02_JPRB,.731E-02_JPRB,.729E-02_JPRB,.710E-02_JPRB,&
&.708E-02_JPRB,.709E-02_JPRB,.673E-02_JPRB,.646E-02_JPRB,.671E-02_JPRB,.669E-02_JPRB,.654E-02_JPRB,&
&.678E-02_JPRB,.650E-02_JPRB,.516E-02_JPRB,.376E-02_JPRB,.302E-02_JPRB,.259E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.257E-02_JPRB,.267E-02_JPRB,.283E-02_JPRB,.318E-02_JPRB,.384E-02_JPRB,.493E-02_JPRB,&
&.626E-02_JPRB,.754E-02_JPRB,.871E-02_JPRB,.962E-02_JPRB,.960E-02_JPRB,.756E-02_JPRB,.491E-02_JPRB,&
&.268E-02_JPRB,.151E-02_JPRB,.130E-02_JPRB,.115E-02_JPRB,.103E-02_JPRB,.997E-03_JPRB,.990E-03_JPRB,&
&.100E-02_JPRB,.970E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 22   6.0
ZAER (:,22, 5) = (/&
&.901E-03_JPRB,.995E-03_JPRB,.111E-02_JPRB,.124E-02_JPRB,.136E-02_JPRB,.147E-02_JPRB,.156E-02_JPRB,&
&.165E-02_JPRB,.174E-02_JPRB,.183E-02_JPRB,.197E-02_JPRB,.213E-02_JPRB,.232E-02_JPRB,.248E-02_JPRB,&
&.267E-02_JPRB,.284E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.284E-02_JPRB,.294E-02_JPRB,.256E-02_JPRB,&
&.205E-02_JPRB,.196E-02_JPRB,.189E-02_JPRB,.199E-02_JPRB,.227E-02_JPRB,.264E-02_JPRB,.307E-02_JPRB,&
&.364E-02_JPRB,.439E-02_JPRB,.529E-02_JPRB,.597E-02_JPRB,.624E-02_JPRB,.631E-02_JPRB,.643E-02_JPRB,&
&.651E-02_JPRB,.652E-02_JPRB,.671E-02_JPRB,.690E-02_JPRB,.743E-02_JPRB,.778E-02_JPRB,.810E-02_JPRB,&
&.806E-02_JPRB,.649E-02_JPRB,.371E-02_JPRB,.265E-02_JPRB,.245E-02_JPRB,.207E-02_JPRB,.190E-02_JPRB,&
&.182E-02_JPRB,.174E-02_JPRB,.160E-02_JPRB,.156E-02_JPRB,.175E-02_JPRB,.210E-02_JPRB,.257E-02_JPRB,&
&.307E-02_JPRB,.344E-02_JPRB,.352E-02_JPRB,.331E-02_JPRB,.273E-02_JPRB,.180E-02_JPRB,.102E-02_JPRB,&
&.636E-03_JPRB,.548E-03_JPRB,.528E-03_JPRB,.490E-03_JPRB,.527E-03_JPRB,.605E-03_JPRB,.677E-03_JPRB,&
&.751E-03_JPRB,.811E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 23   2.0
ZAER (:,23, 5) = (/&
&.977E-03_JPRB,.111E-02_JPRB,.125E-02_JPRB,.141E-02_JPRB,.156E-02_JPRB,.173E-02_JPRB,.189E-02_JPRB,&
&.204E-02_JPRB,.219E-02_JPRB,.234E-02_JPRB,.250E-02_JPRB,.264E-02_JPRB,.278E-02_JPRB,.294E-02_JPRB,&
&.308E-02_JPRB,.321E-02_JPRB,.329E-02_JPRB,.332E-02_JPRB,.340E-02_JPRB,.385E-02_JPRB,.356E-02_JPRB,&
&.228E-02_JPRB,.228E-02_JPRB,.243E-02_JPRB,.267E-02_JPRB,.313E-02_JPRB,.369E-02_JPRB,.416E-02_JPRB,&
&.469E-02_JPRB,.525E-02_JPRB,.581E-02_JPRB,.631E-02_JPRB,.677E-02_JPRB,.709E-02_JPRB,.748E-02_JPRB,&
&.771E-02_JPRB,.803E-02_JPRB,.864E-02_JPRB,.949E-02_JPRB,.105E-01_JPRB,.118E-01_JPRB,.131E-01_JPRB,&
&.138E-01_JPRB,.132E-01_JPRB,.107E-01_JPRB,.573E-02_JPRB,.352E-02_JPRB,.239E-02_JPRB,.197E-02_JPRB,&
&.167E-02_JPRB,.140E-02_JPRB,.111E-02_JPRB,.924E-03_JPRB,.931E-03_JPRB,.102E-02_JPRB,.113E-02_JPRB,&
&.124E-02_JPRB,.123E-02_JPRB,.113E-02_JPRB,.959E-03_JPRB,.734E-03_JPRB,.538E-03_JPRB,.476E-03_JPRB,&
&.456E-03_JPRB,.437E-03_JPRB,.428E-03_JPRB,.445E-03_JPRB,.490E-03_JPRB,.560E-03_JPRB,.654E-03_JPRB,&
&.751E-03_JPRB,.854E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 24  -2.0
ZAER (:,24, 5) = (/&
&.947E-03_JPRB,.108E-02_JPRB,.121E-02_JPRB,.137E-02_JPRB,.159E-02_JPRB,.188E-02_JPRB,.217E-02_JPRB,&
&.244E-02_JPRB,.270E-02_JPRB,.292E-02_JPRB,.309E-02_JPRB,.332E-02_JPRB,.344E-02_JPRB,.338E-02_JPRB,&
&.352E-02_JPRB,.377E-02_JPRB,.399E-02_JPRB,.402E-02_JPRB,.410E-02_JPRB,.427E-02_JPRB,.435E-02_JPRB,&
&.464E-02_JPRB,.499E-02_JPRB,.521E-02_JPRB,.554E-02_JPRB,.680E-02_JPRB,.848E-02_JPRB,.106E-01_JPRB,&
&.120E-01_JPRB,.119E-01_JPRB,.115E-01_JPRB,.110E-01_JPRB,.106E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.113E-01_JPRB,.117E-01_JPRB,.129E-01_JPRB,.153E-01_JPRB,.173E-01_JPRB,.199E-01_JPRB,.250E-01_JPRB,&
&.307E-01_JPRB,.350E-01_JPRB,.400E-01_JPRB,.405E-01_JPRB,.159E-01_JPRB,.676E-02_JPRB,.465E-02_JPRB,&
&.335E-02_JPRB,.237E-02_JPRB,.173E-02_JPRB,.129E-02_JPRB,.102E-02_JPRB,.870E-03_JPRB,.945E-03_JPRB,&
&.971E-03_JPRB,.926E-03_JPRB,.962E-03_JPRB,.958E-03_JPRB,.906E-03_JPRB,.844E-03_JPRB,.803E-03_JPRB,&
&.836E-03_JPRB,.861E-03_JPRB,.871E-03_JPRB,.856E-03_JPRB,.810E-03_JPRB,.749E-03_JPRB,.729E-03_JPRB,&
&.754E-03_JPRB,.832E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 25  -6.0
ZAER (:,25, 5) = (/&
&.145E-02_JPRB,.155E-02_JPRB,.175E-02_JPRB,.204E-02_JPRB,.241E-02_JPRB,.288E-02_JPRB,.338E-02_JPRB,&
&.386E-02_JPRB,.440E-02_JPRB,.494E-02_JPRB,.522E-02_JPRB,.545E-02_JPRB,.561E-02_JPRB,.554E-02_JPRB,&
&.562E-02_JPRB,.601E-02_JPRB,.650E-02_JPRB,.677E-02_JPRB,.709E-02_JPRB,.763E-02_JPRB,.843E-02_JPRB,&
&.990E-02_JPRB,.106E-01_JPRB,.111E-01_JPRB,.120E-01_JPRB,.141E-01_JPRB,.179E-01_JPRB,.217E-01_JPRB,&
&.250E-01_JPRB,.260E-01_JPRB,.275E-01_JPRB,.298E-01_JPRB,.320E-01_JPRB,.343E-01_JPRB,.335E-01_JPRB,&
&.315E-01_JPRB,.314E-01_JPRB,.329E-01_JPRB,.374E-01_JPRB,.425E-01_JPRB,.473E-01_JPRB,.561E-01_JPRB,&
&.714E-01_JPRB,.903E-01_JPRB,.114E+00_JPRB,.165E+00_JPRB,.181E+00_JPRB,.328E-01_JPRB,.174E-01_JPRB,&
&.129E-01_JPRB,.102E-01_JPRB,.828E-02_JPRB,.617E-02_JPRB,.394E-02_JPRB,.232E-02_JPRB,.182E-02_JPRB,&
&.178E-02_JPRB,.177E-02_JPRB,.188E-02_JPRB,.218E-02_JPRB,.239E-02_JPRB,.241E-02_JPRB,.226E-02_JPRB,&
&.222E-02_JPRB,.218E-02_JPRB,.220E-02_JPRB,.213E-02_JPRB,.195E-02_JPRB,.173E-02_JPRB,.160E-02_JPRB,&
&.148E-02_JPRB,.142E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 26 -10.0
ZAER (:,26, 5) = (/&
&.317E-02_JPRB,.325E-02_JPRB,.356E-02_JPRB,.415E-02_JPRB,.500E-02_JPRB,.600E-02_JPRB,.699E-02_JPRB,&
&.785E-02_JPRB,.866E-02_JPRB,.955E-02_JPRB,.101E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.101E-01_JPRB,&
&.102E-01_JPRB,.110E-01_JPRB,.121E-01_JPRB,.125E-01_JPRB,.130E-01_JPRB,.140E-01_JPRB,.155E-01_JPRB,&
&.183E-01_JPRB,.204E-01_JPRB,.214E-01_JPRB,.230E-01_JPRB,.259E-01_JPRB,.316E-01_JPRB,.371E-01_JPRB,&
&.411E-01_JPRB,.432E-01_JPRB,.471E-01_JPRB,.540E-01_JPRB,.649E-01_JPRB,.755E-01_JPRB,.837E-01_JPRB,&
&.847E-01_JPRB,.858E-01_JPRB,.846E-01_JPRB,.788E-01_JPRB,.815E-01_JPRB,.893E-01_JPRB,.970E-01_JPRB,&
&.115E+00_JPRB,.148E+00_JPRB,.186E+00_JPRB,.242E+00_JPRB,.336E+00_JPRB,.146E+00_JPRB,.512E-01_JPRB,&
&.331E-01_JPRB,.312E-01_JPRB,.344E-01_JPRB,.321E-01_JPRB,.226E-01_JPRB,.118E-01_JPRB,.621E-02_JPRB,&
&.436E-02_JPRB,.381E-02_JPRB,.415E-02_JPRB,.464E-02_JPRB,.528E-02_JPRB,.564E-02_JPRB,.582E-02_JPRB,&
&.581E-02_JPRB,.544E-02_JPRB,.512E-02_JPRB,.482E-02_JPRB,.436E-02_JPRB,.385E-02_JPRB,.360E-02_JPRB,&
&.338E-02_JPRB,.320E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 27 -14.0
ZAER (:,27, 5) = (/&
&.753E-02_JPRB,.748E-02_JPRB,.779E-02_JPRB,.822E-02_JPRB,.886E-02_JPRB,.994E-02_JPRB,.113E-01_JPRB,&
&.125E-01_JPRB,.136E-01_JPRB,.154E-01_JPRB,.171E-01_JPRB,.182E-01_JPRB,.186E-01_JPRB,.178E-01_JPRB,&
&.177E-01_JPRB,.192E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.201E-01_JPRB,.198E-01_JPRB,.202E-01_JPRB,&
&.222E-01_JPRB,.246E-01_JPRB,.257E-01_JPRB,.274E-01_JPRB,.310E-01_JPRB,.357E-01_JPRB,.405E-01_JPRB,&
&.462E-01_JPRB,.529E-01_JPRB,.620E-01_JPRB,.747E-01_JPRB,.904E-01_JPRB,.110E+00_JPRB,.137E+00_JPRB,&
&.167E+00_JPRB,.180E+00_JPRB,.178E+00_JPRB,.149E+00_JPRB,.126E+00_JPRB,.120E+00_JPRB,.119E+00_JPRB,&
&.126E+00_JPRB,.146E+00_JPRB,.169E+00_JPRB,.202E+00_JPRB,.264E+00_JPRB,.206E+00_JPRB,.965E-01_JPRB,&
&.625E-01_JPRB,.645E-01_JPRB,.744E-01_JPRB,.733E-01_JPRB,.612E-01_JPRB,.411E-01_JPRB,.257E-01_JPRB,&
&.129E-01_JPRB,.728E-02_JPRB,.671E-02_JPRB,.762E-02_JPRB,.928E-02_JPRB,.106E-01_JPRB,.115E-01_JPRB,&
&.120E-01_JPRB,.117E-01_JPRB,.107E-01_JPRB,.982E-02_JPRB,.913E-02_JPRB,.852E-02_JPRB,.831E-02_JPRB,&
&.814E-02_JPRB,.790E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 28 -18.0
ZAER (:,28, 5) = (/&
&.191E-01_JPRB,.179E-01_JPRB,.176E-01_JPRB,.179E-01_JPRB,.176E-01_JPRB,.165E-01_JPRB,.146E-01_JPRB,&
&.144E-01_JPRB,.153E-01_JPRB,.168E-01_JPRB,.185E-01_JPRB,.207E-01_JPRB,.252E-01_JPRB,.298E-01_JPRB,&
&.327E-01_JPRB,.379E-01_JPRB,.403E-01_JPRB,.365E-01_JPRB,.306E-01_JPRB,.275E-01_JPRB,.248E-01_JPRB,&
&.231E-01_JPRB,.234E-01_JPRB,.247E-01_JPRB,.269E-01_JPRB,.300E-01_JPRB,.333E-01_JPRB,.360E-01_JPRB,&
&.394E-01_JPRB,.461E-01_JPRB,.586E-01_JPRB,.798E-01_JPRB,.109E+00_JPRB,.135E+00_JPRB,.172E+00_JPRB,&
&.214E+00_JPRB,.212E+00_JPRB,.211E+00_JPRB,.195E+00_JPRB,.170E+00_JPRB,.148E+00_JPRB,.137E+00_JPRB,&
&.134E+00_JPRB,.149E+00_JPRB,.170E+00_JPRB,.184E+00_JPRB,.195E+00_JPRB,.219E+00_JPRB,.174E+00_JPRB,&
&.116E+00_JPRB,.106E+00_JPRB,.116E+00_JPRB,.111E+00_JPRB,.998E-01_JPRB,.774E-01_JPRB,.531E-01_JPRB,&
&.313E-01_JPRB,.170E-01_JPRB,.103E-01_JPRB,.107E-01_JPRB,.133E-01_JPRB,.160E-01_JPRB,.183E-01_JPRB,&
&.201E-01_JPRB,.210E-01_JPRB,.215E-01_JPRB,.218E-01_JPRB,.214E-01_JPRB,.207E-01_JPRB,.208E-01_JPRB,&
&.208E-01_JPRB,.204E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 29 -22.0
ZAER (:,29, 5) = (/&
&.337E-01_JPRB,.334E-01_JPRB,.333E-01_JPRB,.347E-01_JPRB,.344E-01_JPRB,.315E-01_JPRB,.260E-01_JPRB,&
&.206E-01_JPRB,.183E-01_JPRB,.181E-01_JPRB,.183E-01_JPRB,.201E-01_JPRB,.280E-01_JPRB,.409E-01_JPRB,&
&.515E-01_JPRB,.624E-01_JPRB,.719E-01_JPRB,.529E-01_JPRB,.445E-01_JPRB,.396E-01_JPRB,.358E-01_JPRB,&
&.293E-01_JPRB,.253E-01_JPRB,.239E-01_JPRB,.247E-01_JPRB,.263E-01_JPRB,.290E-01_JPRB,.310E-01_JPRB,&
&.327E-01_JPRB,.350E-01_JPRB,.448E-01_JPRB,.640E-01_JPRB,.967E-01_JPRB,.132E+00_JPRB,.163E+00_JPRB,&
&.203E+00_JPRB,.202E+00_JPRB,.215E+00_JPRB,.228E+00_JPRB,.214E+00_JPRB,.205E+00_JPRB,.187E+00_JPRB,&
&.150E+00_JPRB,.148E+00_JPRB,.163E+00_JPRB,.172E+00_JPRB,.178E+00_JPRB,.195E+00_JPRB,.198E+00_JPRB,&
&.156E+00_JPRB,.127E+00_JPRB,.133E+00_JPRB,.132E+00_JPRB,.118E+00_JPRB,.991E-01_JPRB,.779E-01_JPRB,&
&.574E-01_JPRB,.352E-01_JPRB,.194E-01_JPRB,.178E-01_JPRB,.184E-01_JPRB,.175E-01_JPRB,.201E-01_JPRB,&
&.231E-01_JPRB,.265E-01_JPRB,.300E-01_JPRB,.317E-01_JPRB,.338E-01_JPRB,.342E-01_JPRB,.339E-01_JPRB,&
&.341E-01_JPRB,.340E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 30 -26.0
ZAER (:,30, 5) = (/&
&.426E-01_JPRB,.460E-01_JPRB,.505E-01_JPRB,.530E-01_JPRB,.518E-01_JPRB,.476E-01_JPRB,.425E-01_JPRB,&
&.368E-01_JPRB,.313E-01_JPRB,.274E-01_JPRB,.246E-01_JPRB,.222E-01_JPRB,.289E-01_JPRB,.496E-01_JPRB,&
&.546E-01_JPRB,.697E-01_JPRB,.921E-01_JPRB,.620E-01_JPRB,.504E-01_JPRB,.450E-01_JPRB,.418E-01_JPRB,&
&.375E-01_JPRB,.329E-01_JPRB,.286E-01_JPRB,.261E-01_JPRB,.251E-01_JPRB,.257E-01_JPRB,.274E-01_JPRB,&
&.288E-01_JPRB,.295E-01_JPRB,.330E-01_JPRB,.421E-01_JPRB,.619E-01_JPRB,.101E+00_JPRB,.145E+00_JPRB,&
&.182E+00_JPRB,.197E+00_JPRB,.201E+00_JPRB,.279E+00_JPRB,.265E+00_JPRB,.220E+00_JPRB,.189E+00_JPRB,&
&.155E+00_JPRB,.149E+00_JPRB,.163E+00_JPRB,.179E+00_JPRB,.191E+00_JPRB,.184E+00_JPRB,.183E+00_JPRB,&
&.168E+00_JPRB,.152E+00_JPRB,.152E+00_JPRB,.144E+00_JPRB,.122E+00_JPRB,.105E+00_JPRB,.932E-01_JPRB,&
&.813E-01_JPRB,.624E-01_JPRB,.363E-01_JPRB,.260E-01_JPRB,.304E-01_JPRB,.307E-01_JPRB,.282E-01_JPRB,&
&.312E-01_JPRB,.373E-01_JPRB,.410E-01_JPRB,.427E-01_JPRB,.444E-01_JPRB,.448E-01_JPRB,.434E-01_JPRB,&
&.419E-01_JPRB,.415E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 31 -30.0
ZAER (:,31, 5) = (/&
&.518E-01_JPRB,.579E-01_JPRB,.607E-01_JPRB,.591E-01_JPRB,.565E-01_JPRB,.533E-01_JPRB,.514E-01_JPRB,&
&.498E-01_JPRB,.459E-01_JPRB,.410E-01_JPRB,.372E-01_JPRB,.347E-01_JPRB,.357E-01_JPRB,.495E-01_JPRB,&
&.562E-01_JPRB,.685E-01_JPRB,.827E-01_JPRB,.661E-01_JPRB,.548E-01_JPRB,.489E-01_JPRB,.461E-01_JPRB,&
&.435E-01_JPRB,.402E-01_JPRB,.361E-01_JPRB,.324E-01_JPRB,.296E-01_JPRB,.287E-01_JPRB,.286E-01_JPRB,&
&.278E-01_JPRB,.276E-01_JPRB,.282E-01_JPRB,.299E-01_JPRB,.365E-01_JPRB,.610E-01_JPRB,.111E+00_JPRB,&
&.139E+00_JPRB,.155E+00_JPRB,.191E+00_JPRB,.317E+00_JPRB,.307E+00_JPRB,.186E+00_JPRB,.156E+00_JPRB,&
&.134E+00_JPRB,.141E+00_JPRB,.170E+00_JPRB,.198E+00_JPRB,.207E+00_JPRB,.182E+00_JPRB,.163E+00_JPRB,&
&.159E+00_JPRB,.165E+00_JPRB,.149E+00_JPRB,.127E+00_JPRB,.114E+00_JPRB,.106E+00_JPRB,.110E+00_JPRB,&
&.107E+00_JPRB,.899E-01_JPRB,.657E-01_JPRB,.500E-01_JPRB,.518E-01_JPRB,.546E-01_JPRB,.506E-01_JPRB,&
&.523E-01_JPRB,.610E-01_JPRB,.593E-01_JPRB,.594E-01_JPRB,.571E-01_JPRB,.557E-01_JPRB,.512E-01_JPRB,&
&.456E-01_JPRB,.459E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 32 -34.0
ZAER (:,32, 5) = (/&
&.599E-01_JPRB,.638E-01_JPRB,.640E-01_JPRB,.595E-01_JPRB,.562E-01_JPRB,.542E-01_JPRB,.534E-01_JPRB,&
&.534E-01_JPRB,.524E-01_JPRB,.504E-01_JPRB,.486E-01_JPRB,.477E-01_JPRB,.501E-01_JPRB,.557E-01_JPRB,&
&.630E-01_JPRB,.771E-01_JPRB,.794E-01_JPRB,.648E-01_JPRB,.546E-01_JPRB,.487E-01_JPRB,.457E-01_JPRB,&
&.431E-01_JPRB,.411E-01_JPRB,.386E-01_JPRB,.361E-01_JPRB,.340E-01_JPRB,.318E-01_JPRB,.298E-01_JPRB,&
&.286E-01_JPRB,.278E-01_JPRB,.270E-01_JPRB,.261E-01_JPRB,.265E-01_JPRB,.348E-01_JPRB,.619E-01_JPRB,&
&.886E-01_JPRB,.120E+00_JPRB,.172E+00_JPRB,.238E+00_JPRB,.264E+00_JPRB,.164E+00_JPRB,.127E+00_JPRB,&
&.120E+00_JPRB,.119E+00_JPRB,.143E+00_JPRB,.165E+00_JPRB,.178E+00_JPRB,.193E+00_JPRB,.179E+00_JPRB,&
&.162E+00_JPRB,.138E+00_JPRB,.133E+00_JPRB,.127E+00_JPRB,.122E+00_JPRB,.126E+00_JPRB,.140E+00_JPRB,&
&.156E+00_JPRB,.142E+00_JPRB,.138E+00_JPRB,.128E+00_JPRB,.116E+00_JPRB,.110E+00_JPRB,.100E+00_JPRB,&
&.975E-01_JPRB,.890E-01_JPRB,.753E-01_JPRB,.710E-01_JPRB,.650E-01_JPRB,.657E-01_JPRB,.600E-01_JPRB,&
&.531E-01_JPRB,.550E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 33 -38.0
ZAER (:,33, 5) = (/&
&.646E-01_JPRB,.647E-01_JPRB,.633E-01_JPRB,.585E-01_JPRB,.530E-01_JPRB,.494E-01_JPRB,.497E-01_JPRB,&
&.512E-01_JPRB,.518E-01_JPRB,.515E-01_JPRB,.514E-01_JPRB,.528E-01_JPRB,.565E-01_JPRB,.594E-01_JPRB,&
&.622E-01_JPRB,.663E-01_JPRB,.657E-01_JPRB,.563E-01_JPRB,.493E-01_JPRB,.456E-01_JPRB,.434E-01_JPRB,&
&.404E-01_JPRB,.380E-01_JPRB,.365E-01_JPRB,.349E-01_JPRB,.334E-01_JPRB,.315E-01_JPRB,.297E-01_JPRB,&
&.286E-01_JPRB,.277E-01_JPRB,.263E-01_JPRB,.247E-01_JPRB,.243E-01_JPRB,.254E-01_JPRB,.330E-01_JPRB,&
&.514E-01_JPRB,.711E-01_JPRB,.984E-01_JPRB,.127E+00_JPRB,.140E+00_JPRB,.131E+00_JPRB,.123E+00_JPRB,&
&.109E+00_JPRB,.107E+00_JPRB,.117E+00_JPRB,.145E+00_JPRB,.206E+00_JPRB,.283E+00_JPRB,.257E+00_JPRB,&
&.201E+00_JPRB,.150E+00_JPRB,.135E+00_JPRB,.168E+00_JPRB,.173E+00_JPRB,.170E+00_JPRB,.180E+00_JPRB,&
&.221E+00_JPRB,.256E+00_JPRB,.252E+00_JPRB,.234E+00_JPRB,.201E+00_JPRB,.177E+00_JPRB,.156E+00_JPRB,&
&.134E+00_JPRB,.114E+00_JPRB,.954E-01_JPRB,.861E-01_JPRB,.791E-01_JPRB,.769E-01_JPRB,.737E-01_JPRB,&
&.689E-01_JPRB,.657E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 34 -42.0
ZAER (:,34, 5) = (/&
&.692E-01_JPRB,.657E-01_JPRB,.611E-01_JPRB,.556E-01_JPRB,.490E-01_JPRB,.449E-01_JPRB,.458E-01_JPRB,&
&.474E-01_JPRB,.477E-01_JPRB,.467E-01_JPRB,.462E-01_JPRB,.477E-01_JPRB,.518E-01_JPRB,.545E-01_JPRB,&
&.550E-01_JPRB,.543E-01_JPRB,.505E-01_JPRB,.473E-01_JPRB,.433E-01_JPRB,.397E-01_JPRB,.371E-01_JPRB,&
&.354E-01_JPRB,.330E-01_JPRB,.320E-01_JPRB,.318E-01_JPRB,.310E-01_JPRB,.298E-01_JPRB,.284E-01_JPRB,&
&.274E-01_JPRB,.267E-01_JPRB,.255E-01_JPRB,.234E-01_JPRB,.223E-01_JPRB,.216E-01_JPRB,.239E-01_JPRB,&
&.352E-01_JPRB,.471E-01_JPRB,.640E-01_JPRB,.861E-01_JPRB,.923E-01_JPRB,.936E-01_JPRB,.970E-01_JPRB,&
&.977E-01_JPRB,.101E+00_JPRB,.108E+00_JPRB,.154E+00_JPRB,.325E+00_JPRB,.444E+00_JPRB,.305E+00_JPRB,&
&.228E+00_JPRB,.181E+00_JPRB,.145E+00_JPRB,.153E+00_JPRB,.159E+00_JPRB,.182E+00_JPRB,.240E+00_JPRB,&
&.343E+00_JPRB,.387E+00_JPRB,.368E+00_JPRB,.340E+00_JPRB,.293E+00_JPRB,.236E+00_JPRB,.192E+00_JPRB,&
&.154E+00_JPRB,.129E+00_JPRB,.114E+00_JPRB,.100E+00_JPRB,.875E-01_JPRB,.833E-01_JPRB,.811E-01_JPRB,&
&.791E-01_JPRB,.740E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 35 -46.0
ZAER (:,35, 5) = (/&
&.718E-01_JPRB,.668E-01_JPRB,.598E-01_JPRB,.537E-01_JPRB,.479E-01_JPRB,.453E-01_JPRB,.448E-01_JPRB,&
&.454E-01_JPRB,.443E-01_JPRB,.405E-01_JPRB,.403E-01_JPRB,.416E-01_JPRB,.443E-01_JPRB,.461E-01_JPRB,&
&.461E-01_JPRB,.454E-01_JPRB,.426E-01_JPRB,.397E-01_JPRB,.358E-01_JPRB,.329E-01_JPRB,.320E-01_JPRB,&
&.316E-01_JPRB,.296E-01_JPRB,.276E-01_JPRB,.274E-01_JPRB,.272E-01_JPRB,.264E-01_JPRB,.253E-01_JPRB,&
&.246E-01_JPRB,.241E-01_JPRB,.235E-01_JPRB,.229E-01_JPRB,.221E-01_JPRB,.205E-01_JPRB,.203E-01_JPRB,&
&.249E-01_JPRB,.333E-01_JPRB,.439E-01_JPRB,.627E-01_JPRB,.740E-01_JPRB,.726E-01_JPRB,.737E-01_JPRB,&
&.774E-01_JPRB,.886E-01_JPRB,.129E+00_JPRB,.204E+00_JPRB,.357E+00_JPRB,.388E+00_JPRB,.286E+00_JPRB,&
&.207E+00_JPRB,.173E+00_JPRB,.148E+00_JPRB,.135E+00_JPRB,.137E+00_JPRB,.164E+00_JPRB,.220E+00_JPRB,&
&.262E+00_JPRB,.295E+00_JPRB,.299E+00_JPRB,.299E+00_JPRB,.264E+00_JPRB,.197E+00_JPRB,.154E+00_JPRB,&
&.134E+00_JPRB,.120E+00_JPRB,.111E+00_JPRB,.101E+00_JPRB,.901E-01_JPRB,.830E-01_JPRB,.795E-01_JPRB,&
&.774E-01_JPRB,.751E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 36 -50.0
ZAER (:,36, 5) = (/&
&.678E-01_JPRB,.646E-01_JPRB,.593E-01_JPRB,.539E-01_JPRB,.485E-01_JPRB,.465E-01_JPRB,.443E-01_JPRB,&
&.424E-01_JPRB,.403E-01_JPRB,.377E-01_JPRB,.360E-01_JPRB,.364E-01_JPRB,.385E-01_JPRB,.395E-01_JPRB,&
&.402E-01_JPRB,.391E-01_JPRB,.366E-01_JPRB,.349E-01_JPRB,.337E-01_JPRB,.321E-01_JPRB,.316E-01_JPRB,&
&.308E-01_JPRB,.283E-01_JPRB,.265E-01_JPRB,.250E-01_JPRB,.240E-01_JPRB,.230E-01_JPRB,.225E-01_JPRB,&
&.222E-01_JPRB,.220E-01_JPRB,.224E-01_JPRB,.226E-01_JPRB,.219E-01_JPRB,.210E-01_JPRB,.204E-01_JPRB,&
&.219E-01_JPRB,.251E-01_JPRB,.310E-01_JPRB,.414E-01_JPRB,.577E-01_JPRB,.647E-01_JPRB,.645E-01_JPRB,&
&.651E-01_JPRB,.771E-01_JPRB,.104E+00_JPRB,.127E+00_JPRB,.187E+00_JPRB,.216E+00_JPRB,.196E+00_JPRB,&
&.169E+00_JPRB,.157E+00_JPRB,.141E+00_JPRB,.127E+00_JPRB,.120E+00_JPRB,.119E+00_JPRB,.129E+00_JPRB,&
&.141E+00_JPRB,.162E+00_JPRB,.165E+00_JPRB,.162E+00_JPRB,.161E+00_JPRB,.128E+00_JPRB,.109E+00_JPRB,&
&.997E-01_JPRB,.940E-01_JPRB,.864E-01_JPRB,.835E-01_JPRB,.812E-01_JPRB,.779E-01_JPRB,.749E-01_JPRB,&
&.723E-01_JPRB,.700E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 37 -54.0
ZAER (:,37, 5) = (/&
&.620E-01_JPRB,.594E-01_JPRB,.570E-01_JPRB,.537E-01_JPRB,.483E-01_JPRB,.469E-01_JPRB,.458E-01_JPRB,&
&.408E-01_JPRB,.369E-01_JPRB,.358E-01_JPRB,.336E-01_JPRB,.329E-01_JPRB,.342E-01_JPRB,.356E-01_JPRB,&
&.360E-01_JPRB,.341E-01_JPRB,.327E-01_JPRB,.326E-01_JPRB,.334E-01_JPRB,.325E-01_JPRB,.317E-01_JPRB,&
&.301E-01_JPRB,.276E-01_JPRB,.252E-01_JPRB,.228E-01_JPRB,.210E-01_JPRB,.203E-01_JPRB,.204E-01_JPRB,&
&.205E-01_JPRB,.202E-01_JPRB,.202E-01_JPRB,.201E-01_JPRB,.198E-01_JPRB,.199E-01_JPRB,.201E-01_JPRB,&
&.208E-01_JPRB,.216E-01_JPRB,.231E-01_JPRB,.273E-01_JPRB,.352E-01_JPRB,.461E-01_JPRB,.518E-01_JPRB,&
&.554E-01_JPRB,.625E-01_JPRB,.731E-01_JPRB,.823E-01_JPRB,.104E+00_JPRB,.130E+00_JPRB,.141E+00_JPRB,&
&.138E+00_JPRB,.128E+00_JPRB,.115E+00_JPRB,.105E+00_JPRB,.972E-01_JPRB,.894E-01_JPRB,.830E-01_JPRB,&
&.827E-01_JPRB,.887E-01_JPRB,.899E-01_JPRB,.888E-01_JPRB,.893E-01_JPRB,.920E-01_JPRB,.879E-01_JPRB,&
&.796E-01_JPRB,.710E-01_JPRB,.667E-01_JPRB,.654E-01_JPRB,.652E-01_JPRB,.646E-01_JPRB,.638E-01_JPRB,&
&.642E-01_JPRB,.637E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 38 -58.0
ZAER (:,38, 5) = (/&
&.555E-01_JPRB,.543E-01_JPRB,.542E-01_JPRB,.522E-01_JPRB,.508E-01_JPRB,.482E-01_JPRB,.418E-01_JPRB,&
&.373E-01_JPRB,.357E-01_JPRB,.359E-01_JPRB,.340E-01_JPRB,.319E-01_JPRB,.313E-01_JPRB,.330E-01_JPRB,&
&.345E-01_JPRB,.334E-01_JPRB,.329E-01_JPRB,.326E-01_JPRB,.333E-01_JPRB,.332E-01_JPRB,.328E-01_JPRB,&
&.310E-01_JPRB,.274E-01_JPRB,.232E-01_JPRB,.211E-01_JPRB,.189E-01_JPRB,.184E-01_JPRB,.186E-01_JPRB,&
&.182E-01_JPRB,.175E-01_JPRB,.170E-01_JPRB,.172E-01_JPRB,.177E-01_JPRB,.183E-01_JPRB,.186E-01_JPRB,&
&.193E-01_JPRB,.191E-01_JPRB,.191E-01_JPRB,.205E-01_JPRB,.231E-01_JPRB,.278E-01_JPRB,.354E-01_JPRB,&
&.410E-01_JPRB,.468E-01_JPRB,.507E-01_JPRB,.536E-01_JPRB,.617E-01_JPRB,.760E-01_JPRB,.840E-01_JPRB,&
&.841E-01_JPRB,.791E-01_JPRB,.753E-01_JPRB,.723E-01_JPRB,.682E-01_JPRB,.638E-01_JPRB,.594E-01_JPRB,&
&.586E-01_JPRB,.578E-01_JPRB,.571E-01_JPRB,.573E-01_JPRB,.657E-01_JPRB,.731E-01_JPRB,.712E-01_JPRB,&
&.642E-01_JPRB,.604E-01_JPRB,.609E-01_JPRB,.589E-01_JPRB,.558E-01_JPRB,.548E-01_JPRB,.547E-01_JPRB,&
&.558E-01_JPRB,.563E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 39 -62.0
ZAER (:,39, 5) = (/&
&.479E-01_JPRB,.480E-01_JPRB,.485E-01_JPRB,.482E-01_JPRB,.478E-01_JPRB,.441E-01_JPRB,.406E-01_JPRB,&
&.402E-01_JPRB,.386E-01_JPRB,.354E-01_JPRB,.327E-01_JPRB,.306E-01_JPRB,.294E-01_JPRB,.308E-01_JPRB,&
&.322E-01_JPRB,.325E-01_JPRB,.328E-01_JPRB,.326E-01_JPRB,.329E-01_JPRB,.336E-01_JPRB,.329E-01_JPRB,&
&.307E-01_JPRB,.277E-01_JPRB,.243E-01_JPRB,.206E-01_JPRB,.184E-01_JPRB,.175E-01_JPRB,.174E-01_JPRB,&
&.161E-01_JPRB,.156E-01_JPRB,.157E-01_JPRB,.164E-01_JPRB,.175E-01_JPRB,.180E-01_JPRB,.181E-01_JPRB,&
&.185E-01_JPRB,.180E-01_JPRB,.173E-01_JPRB,.176E-01_JPRB,.179E-01_JPRB,.184E-01_JPRB,.215E-01_JPRB,&
&.249E-01_JPRB,.294E-01_JPRB,.322E-01_JPRB,.341E-01_JPRB,.364E-01_JPRB,.387E-01_JPRB,.412E-01_JPRB,&
&.419E-01_JPRB,.413E-01_JPRB,.416E-01_JPRB,.424E-01_JPRB,.435E-01_JPRB,.434E-01_JPRB,.455E-01_JPRB,&
&.500E-01_JPRB,.529E-01_JPRB,.511E-01_JPRB,.517E-01_JPRB,.552E-01_JPRB,.613E-01_JPRB,.584E-01_JPRB,&
&.507E-01_JPRB,.538E-01_JPRB,.549E-01_JPRB,.536E-01_JPRB,.527E-01_JPRB,.508E-01_JPRB,.509E-01_JPRB,&
&.508E-01_JPRB,.494E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 40 -66.0
ZAER (:,40, 5) = (/&
&.427E-01_JPRB,.426E-01_JPRB,.427E-01_JPRB,.437E-01_JPRB,.452E-01_JPRB,.445E-01_JPRB,.431E-01_JPRB,&
&.435E-01_JPRB,.423E-01_JPRB,.381E-01_JPRB,.337E-01_JPRB,.305E-01_JPRB,.291E-01_JPRB,.291E-01_JPRB,&
&.296E-01_JPRB,.304E-01_JPRB,.314E-01_JPRB,.326E-01_JPRB,.338E-01_JPRB,.338E-01_JPRB,.323E-01_JPRB,&
&.300E-01_JPRB,.274E-01_JPRB,.251E-01_JPRB,.221E-01_JPRB,.188E-01_JPRB,.173E-01_JPRB,.175E-01_JPRB,&
&.165E-01_JPRB,.160E-01_JPRB,.157E-01_JPRB,.163E-01_JPRB,.169E-01_JPRB,.175E-01_JPRB,.174E-01_JPRB,&
&.176E-01_JPRB,.177E-01_JPRB,.181E-01_JPRB,.185E-01_JPRB,.183E-01_JPRB,.181E-01_JPRB,.191E-01_JPRB,&
&.206E-01_JPRB,.239E-01_JPRB,.262E-01_JPRB,.278E-01_JPRB,.287E-01_JPRB,.295E-01_JPRB,.308E-01_JPRB,&
&.315E-01_JPRB,.309E-01_JPRB,.307E-01_JPRB,.322E-01_JPRB,.330E-01_JPRB,.340E-01_JPRB,.378E-01_JPRB,&
&.434E-01_JPRB,.464E-01_JPRB,.453E-01_JPRB,.439E-01_JPRB,.441E-01_JPRB,.470E-01_JPRB,.466E-01_JPRB,&
&.444E-01_JPRB,.453E-01_JPRB,.463E-01_JPRB,.480E-01_JPRB,.486E-01_JPRB,.478E-01_JPRB,.465E-01_JPRB,&
&.454E-01_JPRB,.436E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 41 -70.0
ZAER (:,41, 5) = (/&
&.391E-01_JPRB,.402E-01_JPRB,.408E-01_JPRB,.417E-01_JPRB,.431E-01_JPRB,.431E-01_JPRB,.421E-01_JPRB,&
&.420E-01_JPRB,.414E-01_JPRB,.391E-01_JPRB,.355E-01_JPRB,.324E-01_JPRB,.309E-01_JPRB,.305E-01_JPRB,&
&.306E-01_JPRB,.310E-01_JPRB,.322E-01_JPRB,.337E-01_JPRB,.342E-01_JPRB,.331E-01_JPRB,.310E-01_JPRB,&
&.286E-01_JPRB,.264E-01_JPRB,.247E-01_JPRB,.229E-01_JPRB,.201E-01_JPRB,.183E-01_JPRB,.180E-01_JPRB,&
&.174E-01_JPRB,.172E-01_JPRB,.174E-01_JPRB,.169E-01_JPRB,.164E-01_JPRB,.165E-01_JPRB,.163E-01_JPRB,&
&.167E-01_JPRB,.176E-01_JPRB,.185E-01_JPRB,.191E-01_JPRB,.191E-01_JPRB,.195E-01_JPRB,.201E-01_JPRB,&
&.212E-01_JPRB,.227E-01_JPRB,.241E-01_JPRB,.257E-01_JPRB,.259E-01_JPRB,.260E-01_JPRB,.301E-01_JPRB,&
&.319E-01_JPRB,.310E-01_JPRB,.304E-01_JPRB,.303E-01_JPRB,.312E-01_JPRB,.338E-01_JPRB,.387E-01_JPRB,&
&.438E-01_JPRB,.457E-01_JPRB,.450E-01_JPRB,.446E-01_JPRB,.439E-01_JPRB,.431E-01_JPRB,.428E-01_JPRB,&
&.431E-01_JPRB,.420E-01_JPRB,.418E-01_JPRB,.419E-01_JPRB,.423E-01_JPRB,.424E-01_JPRB,.415E-01_JPRB,&
&.402E-01_JPRB,.390E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 42 -74.0
ZAER (:,42, 5) = (/&
&.387E-01_JPRB,.407E-01_JPRB,.417E-01_JPRB,.416E-01_JPRB,.414E-01_JPRB,.415E-01_JPRB,.413E-01_JPRB,&
&.401E-01_JPRB,.390E-01_JPRB,.379E-01_JPRB,.363E-01_JPRB,.345E-01_JPRB,.332E-01_JPRB,.325E-01_JPRB,&
&.324E-01_JPRB,.328E-01_JPRB,.332E-01_JPRB,.330E-01_JPRB,.320E-01_JPRB,.299E-01_JPRB,.277E-01_JPRB,&
&.257E-01_JPRB,.243E-01_JPRB,.232E-01_JPRB,.223E-01_JPRB,.212E-01_JPRB,.205E-01_JPRB,.202E-01_JPRB,&
&.199E-01_JPRB,.198E-01_JPRB,.198E-01_JPRB,.190E-01_JPRB,.174E-01_JPRB,.165E-01_JPRB,.162E-01_JPRB,&
&.166E-01_JPRB,.181E-01_JPRB,.191E-01_JPRB,.197E-01_JPRB,.200E-01_JPRB,.206E-01_JPRB,.216E-01_JPRB,&
&.231E-01_JPRB,.246E-01_JPRB,.259E-01_JPRB,.263E-01_JPRB,.262E-01_JPRB,.274E-01_JPRB,.289E-01_JPRB,&
&.302E-01_JPRB,.303E-01_JPRB,.302E-01_JPRB,.309E-01_JPRB,.322E-01_JPRB,.344E-01_JPRB,.388E-01_JPRB,&
&.435E-01_JPRB,.464E-01_JPRB,.467E-01_JPRB,.458E-01_JPRB,.441E-01_JPRB,.423E-01_JPRB,.412E-01_JPRB,&
&.406E-01_JPRB,.399E-01_JPRB,.395E-01_JPRB,.389E-01_JPRB,.379E-01_JPRB,.372E-01_JPRB,.366E-01_JPRB,&
&.368E-01_JPRB,.373E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 43 -78.0
ZAER (:,43, 5) = (/&
&.347E-01_JPRB,.355E-01_JPRB,.356E-01_JPRB,.353E-01_JPRB,.348E-01_JPRB,.344E-01_JPRB,.339E-01_JPRB,&
&.333E-01_JPRB,.327E-01_JPRB,.319E-01_JPRB,.313E-01_JPRB,.309E-01_JPRB,.305E-01_JPRB,.301E-01_JPRB,&
&.295E-01_JPRB,.287E-01_JPRB,.277E-01_JPRB,.262E-01_JPRB,.243E-01_JPRB,.225E-01_JPRB,.211E-01_JPRB,&
&.201E-01_JPRB,.198E-01_JPRB,.199E-01_JPRB,.201E-01_JPRB,.199E-01_JPRB,.201E-01_JPRB,.205E-01_JPRB,&
&.210E-01_JPRB,.212E-01_JPRB,.211E-01_JPRB,.206E-01_JPRB,.190E-01_JPRB,.172E-01_JPRB,.166E-01_JPRB,&
&.165E-01_JPRB,.161E-01_JPRB,.163E-01_JPRB,.170E-01_JPRB,.180E-01_JPRB,.197E-01_JPRB,.220E-01_JPRB,&
&.238E-01_JPRB,.250E-01_JPRB,.254E-01_JPRB,.252E-01_JPRB,.254E-01_JPRB,.262E-01_JPRB,.271E-01_JPRB,&
&.280E-01_JPRB,.286E-01_JPRB,.294E-01_JPRB,.303E-01_JPRB,.316E-01_JPRB,.335E-01_JPRB,.362E-01_JPRB,&
&.394E-01_JPRB,.418E-01_JPRB,.424E-01_JPRB,.411E-01_JPRB,.394E-01_JPRB,.381E-01_JPRB,.376E-01_JPRB,&
&.376E-01_JPRB,.374E-01_JPRB,.378E-01_JPRB,.386E-01_JPRB,.380E-01_JPRB,.371E-01_JPRB,.361E-01_JPRB,&
&.353E-01_JPRB,.347E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 44 -82.0
ZAER (:,44, 5) = (/&
&.274E-01_JPRB,.272E-01_JPRB,.270E-01_JPRB,.269E-01_JPRB,.269E-01_JPRB,.268E-01_JPRB,.266E-01_JPRB,&
&.261E-01_JPRB,.255E-01_JPRB,.250E-01_JPRB,.244E-01_JPRB,.237E-01_JPRB,.231E-01_JPRB,.223E-01_JPRB,&
&.216E-01_JPRB,.208E-01_JPRB,.200E-01_JPRB,.192E-01_JPRB,.185E-01_JPRB,.179E-01_JPRB,.177E-01_JPRB,&
&.176E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.177E-01_JPRB,.179E-01_JPRB,.184E-01_JPRB,.191E-01_JPRB,&
&.197E-01_JPRB,.200E-01_JPRB,.200E-01_JPRB,.196E-01_JPRB,.187E-01_JPRB,.174E-01_JPRB,.167E-01_JPRB,&
&.164E-01_JPRB,.163E-01_JPRB,.165E-01_JPRB,.170E-01_JPRB,.177E-01_JPRB,.186E-01_JPRB,.196E-01_JPRB,&
&.209E-01_JPRB,.220E-01_JPRB,.227E-01_JPRB,.233E-01_JPRB,.238E-01_JPRB,.242E-01_JPRB,.245E-01_JPRB,&
&.249E-01_JPRB,.254E-01_JPRB,.260E-01_JPRB,.268E-01_JPRB,.274E-01_JPRB,.279E-01_JPRB,.288E-01_JPRB,&
&.299E-01_JPRB,.310E-01_JPRB,.319E-01_JPRB,.321E-01_JPRB,.318E-01_JPRB,.313E-01_JPRB,.311E-01_JPRB,&
&.310E-01_JPRB,.310E-01_JPRB,.311E-01_JPRB,.315E-01_JPRB,.314E-01_JPRB,.308E-01_JPRB,.302E-01_JPRB,&
&.295E-01_JPRB,.284E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 45 -86.0
ZAER (:,45, 5) = (/&
&.226E-01_JPRB,.224E-01_JPRB,.222E-01_JPRB,.220E-01_JPRB,.218E-01_JPRB,.215E-01_JPRB,.209E-01_JPRB,&
&.204E-01_JPRB,.199E-01_JPRB,.194E-01_JPRB,.190E-01_JPRB,.187E-01_JPRB,.186E-01_JPRB,.184E-01_JPRB,&
&.184E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,&
&.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.184E-01_JPRB,.185E-01_JPRB,&
&.185E-01_JPRB,.185E-01_JPRB,.184E-01_JPRB,.183E-01_JPRB,.181E-01_JPRB,.179E-01_JPRB,.180E-01_JPRB,&
&.181E-01_JPRB,.182E-01_JPRB,.184E-01_JPRB,.187E-01_JPRB,.189E-01_JPRB,.192E-01_JPRB,.196E-01_JPRB,&
&.203E-01_JPRB,.209E-01_JPRB,.214E-01_JPRB,.218E-01_JPRB,.218E-01_JPRB,.219E-01_JPRB,.222E-01_JPRB,&
&.224E-01_JPRB,.225E-01_JPRB,.225E-01_JPRB,.225E-01_JPRB,.226E-01_JPRB,.227E-01_JPRB,.228E-01_JPRB,&
&.230E-01_JPRB,.231E-01_JPRB,.234E-01_JPRB,.236E-01_JPRB,.237E-01_JPRB,.237E-01_JPRB,.238E-01_JPRB,&
&.239E-01_JPRB,.240E-01_JPRB,.241E-01_JPRB,.242E-01_JPRB,.242E-01_JPRB,.241E-01_JPRB,.238E-01_JPRB,&
&.233E-01_JPRB,.228E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  5 --- lat: 46 -90.0
ZAER (:,46, 5) = (/&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,.204E-01_JPRB,&
&.204E-01_JPRB,.204E-01_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=5   
  DO JI=1,46
    DO JL=1,72
      RAERSD(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SOIL DUST AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESD_05
