SUBROUTINE SUOLW
!
!**** *SULW*   - INITIALIZE COMMON YOELW
!
!     PURPOSE.
!     --------
!           INITIALIZE YOELW, THE COMMON THAT CONTAINS COEFFICIENTS
!           NEEDED TO RUN THE ECMWF LONGWAVE RADIATION ROUTINES
!
!**   INTERFACE.
!     ----------
!        *CALL* *SULW
!
!        EXPLICIT ARGUMENTS :
!        --------------------
!        NONE
!
!        IMPLICIT ARGUMENTS :
!        --------------------
!        COMMON YOELW
!
!     METHOD.
!     -------
!        SEE DOCUMENTATION
!
!     EXTERNALS.
!     ----------
!
!     REFERENCE.
!     ----------
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE IFS
!
!     AUTHOR.
!     -------
!        JEAN-JACQUES MORCRETTE  *ECMWF*
!
!     MODIFICATIONS.
!     --------------
!        ORIGINAL : 88-12-15
!        J.-J. Morcrette ECMWF 951215: Pseudo-Voigt Line Profiles
!     ------------------------------------------------------------------
!      IMPLICIT LOGICAL (L)
!      
!#include "yomlun.h"
!#include "yoerad.h"
!#include "yoelw.h"

#include "tsmbkind.h"

USE YOEOLW   , ONLY : MXIXT    ,NISP     ,NIPD     ,NIPD2    ,&
            &NTR      ,NTRA     ,NUA      ,NG1      ,NG1P1    ,&
            &AT       ,BT       ,GA       ,GB     ,&
            &O1H      ,O2H      ,OCT      ,RPIALF0  ,&
            &RT1      ,TINTP    ,TREF     ,TSTAND   ,TSTP     ,&
            &WG1      ,XP       ,RVGCO2   ,RVGH2O   ,RVGO3


IMPLICIT NONE


!      ----------------------------------------------------------------
!
!*       1.    SET VALUES.
!              -----------
!
NG1=2
NG1P1=NG1+1
NISP=6
NIPD=8
NIPD2=2*NIPD
NTR=11
NTRA=15
NUA=24
!
!      
!--  COEFFICIENTS FOR THE PSEUDO-VOIGT LINE PROFILE (PA)
!
RVGCO2= 60.
RVGH2O= 30.
RVGO3 =400.
!
!
!-- REFERENCE TEMPERATURES FOR THE PLANCK FUNCTIONS ----- TSTAND
!          TEMPERATURE DEPENDENCE OF THE ABSORPTION ----- TREF
TSTAND= 250.00
TREF  = 250.00
!

!-- ROOTS AND WEIGHTS FOR THE 2-POINT GAUSSIAN QUADRATURE
RT1 = (/ -0.577350269, +0.577350269 /)
WG1 = (/  1.         ,  1.          /)

!-- TEMPERATURE STEP AND MAXIMUM INDEX FOR THE TRANSMISSIVITIES
TSTP  = 12.5
MXIXT = 10

!
!-- REFERENCE TEMPERATURE FOR THE TRANSMISSIVITIES

TINTP = (/ 187.5, 200., 212.5, 225., 237.5,  &
 &250.,&
           &262.5, 275., 287.5, 300., 312.5 /)
!
!-- COEFFICIENTS OF THE POLYNOMIALS GIVING THE PLANCK FUNCTIONS
!
XP( :, 1) = (/&
 &0.46430621E+02, 0.12928299E+03, 0.20732648E+03,&
 &0.31398411E+03, 0.18373177E+03,-0.11412303E+03/)
XP( :, 2) = (/&
 &0.73604774E+02, 0.27887914E+03, 0.27076947E+03,&
 &-.57322111E+02,-0.64742459E+02, 0.87238280E+02/)
XP( :, 3) = (/&
 &0.37050866E+02, 0.20498759E+03, 0.37558029E+03,&
 &0.17401171E+03,-0.13350302E+03,-0.37651795E+02/)
XP( :, 4) = (/&
 &0.14930141E+02, 0.89161160E+02, 0.17793062E+03,&
 &0.93433860E+02,-0.70646020E+02,-0.26373150E+02/)
XP( :, 5) = (/&
 &0.40386780E+02, 0.10855270E+03, 0.50755010E+02,&
&-0.31496190E+02, 0.12791300E+00, 0.18017770E+01/)
XP( :, 6) = (/&
 &0.90811926E+01, 0.75073923E+02, 0.24654438E+03,&
 &0.39332612E+03, 0.29385281E+03, 0.89107921E+02/)

!
!-- COEFFICIENTS OF THE POLYNOMIALS GIVING THE TEMPERATURE DEPENDENCE OF
!     THE ABSORPTION
!
!- from Zhong & Haigh 
!
!-- H2O --    0 - 350
AT(1,:)= (/ 0.298199E-02,-.394023E-03,0.319566E-04 /)
BT(1,:)= (/-0.106432E-04,0.660324E-06,0.174356E-06 /)
!
!-- H2O --  500 -  800
AT(2,:)= (/ 0.143676E-01,0.366501E-02,-.160822E-02 /)
BT(2,:)= (/-0.553979E-04,-.101701E-04,0.920868E-05 /)
!
!-- H2O --  800 - 970 + 1110 - 1250
AT(3,:)= (/ 0.197861E-01,0.315541E-02,-.174547E-02 /)
BT(3,:)= (/-0.877012E-04,0.513302E-04,0.523138E-06 /)
!
!-- H2O --  970 - 1110
AT(4,:)= (/ 0.289560E-01,-.208807E-02,-.121943E-02 /)
BT(4,:)= (/-0.165960E-03,0.157704E-03,-.146427E-04 /)
!
!-- H2O --  350 -  500
AT(5,:)= (/ 0.103800E-01,0.436296E-02,-.161431E-02 /)
BT(5,:)= (/ -.276744E-04,-.327381E-04,0.127646E-04 /)
!
!-- H2O -- 1250 - 1450 + 1880 - 2820
AT(6,:)= (/ 0.868859E-02,-.972752E-03,0.000000E-00 /)
BT(6,:)= (/ -.278412E-04,-.713940E-06,0.117469E-05 /)
!

!-------CO2

AT(7,:)= (/&
     & 0.250073E-03,0.455875E-03,0.109242E-03 /)
BT(7,:)= (/&
     & 0.199846E-05,-.216313E-05,0.175991E-06 /)
AT(8,:)= (/&
     & 0.307423E-01,0.110879E-02,-.322172E-03 /)
BT(8,:)= (/&
     &-0.108482E-03,0.258096E-05,-.814575E-06 /)
!
!--  COEFFICIENTS FOR OZONE ABSORPTION
!
O1H = 2230.
O2H =  100.
RPIALF0= 2.
OCT(1)= -.326E-03
OCT(2)= -.102E-05
OCT(3)=  .137E-02
OCT(4)= -.535E-05     
!
!--  COEFFICIENTS FOR H2O E-TYPE CONTINUUM ABSORPTION
!
!      DATA RNTNU /   70.0, 26.77, 8.45, 5.78  /
!      
!-----------------------------------------------------------------------
!  PADE APPROXIMANTS FOR THE TRANSMISSIVITIES
!  ==========================================
!-----------------------------------------------------------------------
!
!
!
!
!-----------------------------------------------------------------------
!  PADE APPROXIMANTS FOR THE TRANSMISSIVITIES
!
!- H2O  0-350 cm-1
!
!-- R.D. -- G = - 0.2 SLA
!
!
!----- INTERVAL = 1 ----- T =  187.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 1, 1, :) = (/&
     & 0.63499072E-02,-0.99506586E-03, 0.00000000E+00/)
GB( 1, 1, :) = (/&
     & 0.63499072E-02, 0.97222852E-01, 0.10000000E+01/)
GA( 1, 2, :) = (/&
     & 0.77266491E-02,-0.11661515E-02, 0.00000000E+00/)
GB( 1, 2, :) = (/&
     & 0.77266491E-02, 0.10681591E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  200.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 2, 1, :) = (/&
     & 0.65566348E-02,-0.10184169E-02, 0.00000000E+00/)
GB( 2, 1, :) = (/&
     & 0.65566348E-02, 0.98862238E-01, 0.10000000E+01/)
GA( 2, 2, :) = (/&
     & 0.81323287E-02,-0.11886130E-02, 0.00000000E+00/)
GB( 2, 2, :) = (/&
     & 0.81323287E-02, 0.10921298E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  212.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 3, 1, :) = (/&
     & 0.67849730E-02,-0.10404730E-02, 0.00000000E+00/)
GB( 3, 1, :) = (/&
     & 0.67849730E-02, 0.10061504E+00, 0.10000000E+01/)
GA( 3, 2, :) = (/&
     & 0.86507620E-02,-0.12139929E-02, 0.00000000E+00/)
GB( 3, 2, :) = (/&
     & 0.86507620E-02, 0.11198225E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  225.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 4, 1, :) = (/&
     & 0.70481947E-02,-0.10621792E-02, 0.00000000E+00/)
GB( 4, 1, :) = (/&
     & 0.70481947E-02, 0.10256222E+00, 0.10000000E+01/)
GA( 4, 2, :) = (/&
     & 0.92776391E-02,-0.12445811E-02, 0.00000000E+00/)
GB( 4, 2, :) = (/&
     & 0.92776391E-02, 0.11487826E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  237.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 5, 1, :) = (/&
     & 0.73585943E-02,-0.10847662E-02, 0.00000000E+00/)
GB( 5, 1, :) = (/&
     & 0.73585943E-02, 0.10475952E+00, 0.10000000E+01/)
GA( 5, 2, :) = (/&
     & 0.99806312E-02,-0.12807672E-02, 0.00000000E+00/)
GB( 5, 2, :) = (/&
     & 0.99806312E-02, 0.11751113E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  250.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 6, 1, :) = (/&
     & 0.77242818E-02,-0.11094726E-02, 0.00000000E+00/)
GB( 6, 1, :) = (/&
     & 0.77242818E-02, 0.10720986E+00, 0.10000000E+01/)
GA( 6, 2, :) = (/&
     & 0.10709803E-01,-0.13208251E-02, 0.00000000E+00/)
GB( 6, 2, :) = (/&
     & 0.10709803E-01, 0.11951535E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  262.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 7, 1, :) = (/&
     & 0.81472693E-02,-0.11372949E-02, 0.00000000E+00/)
GB( 7, 1, :) = (/&
     & 0.81472693E-02, 0.10985370E+00, 0.10000000E+01/)
GA( 7, 2, :) = (/&
     & 0.11414739E-01,-0.13619034E-02, 0.00000000E+00/)
GB( 7, 2, :) = (/&
     & 0.11414739E-01, 0.12069945E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  275.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 8, 1, :) = (/&
     & 0.86227527E-02,-0.11687683E-02, 0.00000000E+00/)
GB( 8, 1, :) = (/&
     & 0.86227527E-02, 0.11257633E+00, 0.10000000E+01/)
GA( 8, 2, :) = (/&
     & 0.12058772E-01,-0.14014165E-02, 0.00000000E+00/)
GB( 8, 2, :) = (/&
     & 0.12058772E-01, 0.12108524E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  287.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 9, 1, :) = (/&
     & 0.91396814E-02,-0.12038314E-02, 0.00000000E+00/)
GB( 9, 1, :) = (/&
     & 0.91396814E-02, 0.11522980E+00, 0.10000000E+01/)
GA( 9, 2, :) = (/&
     & 0.12623992E-01,-0.14378639E-02, 0.00000000E+00/)
GB( 9, 2, :) = (/&
     & 0.12623992E-01, 0.12084229E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  300.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA(10, 1, :) = (/&
     & 0.96825438E-02,-0.12418367E-02, 0.00000000E+00/)
GB(10, 1, :) = (/&
     & 0.96825438E-02, 0.11766343E+00, 0.10000000E+01/)
GA(10, 2, :) = (/&
     & 0.13108146E-01,-0.14708488E-02, 0.00000000E+00/)
GB(10, 2, :) = (/&
     & 0.13108146E-01, 0.12019005E+00, 0.10000000E+01/)
!
!----- INTERVAL = 1 ----- T =  312.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA(11, 1, :) = (/&
     & 0.10233955E-01,-0.12817135E-02, 0.00000000E+00/)
GB(11, 1, :) = (/&
     & 0.10233955E-01, 0.11975320E+00, 0.10000000E+01/)
GA(11, 2, :) = (/&
     & 0.13518390E-01,-0.15006791E-02, 0.00000000E+00/)
GB(11, 2, :) = (/&
     & 0.13518390E-01, 0.11932684E+00, 0.10000000E+01/)
!
!!
!- H2O  500-800 cm-1
!
!--- R.D.  ---  G = 0.02 + 0.50 / ( 1 + 4.5 U )
!
!
!----- INTERVAL = 2 ----- T =  187.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 1, 3, :) = (/&
     & 0.11644593E+01, 0.41243390E+00, 0.00000000E+00/)
GB( 1, 3, :) = (/&
     & 0.11644593E+01, 0.10346097E+01, 0.10000000E+01/)
GA( 1, 4, :) = (/&
     & 0.12006968E+01, 0.48318936E+00, 0.00000000E+00/)
GB( 1, 4, :) = (/&
     & 0.12006968E+01, 0.10626130E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  200.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 2, 3, :) = (/&
     & 0.11747203E+01, 0.43407282E+00, 0.00000000E+00/)
GB( 2, 3, :) = (/&
     & 0.11747203E+01, 0.10433655E+01, 0.10000000E+01/)
GA( 2, 4, :) = (/&
     & 0.12108196E+01, 0.50501827E+00, 0.00000000E+00/)
GB( 2, 4, :) = (/&
     & 0.12108196E+01, 0.10716026E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  212.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 3, 3, :) = (/&
     & 0.11837872E+01, 0.45331413E+00, 0.00000000E+00/)
GB( 3, 3, :) = (/&
     & 0.11837872E+01, 0.10511933E+01, 0.10000000E+01/)
GA( 3, 4, :) = (/&
     & 0.12196717E+01, 0.52409502E+00, 0.00000000E+00/)
GB( 3, 4, :) = (/&
     & 0.12196717E+01, 0.10795108E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  225.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 4, 3, :) = (/&
     & 0.11918561E+01, 0.47048604E+00, 0.00000000E+00/)
GB( 4, 3, :) = (/&
     & 0.11918561E+01, 0.10582150E+01, 0.10000000E+01/)
GA( 4, 4, :) = (/&
     & 0.12274493E+01, 0.54085277E+00, 0.00000000E+00/)
GB( 4, 4, :) = (/&
     & 0.12274493E+01, 0.10865006E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  237.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 5, 3, :) = (/&
     & 0.11990757E+01, 0.48586286E+00, 0.00000000E+00/)
GB( 5, 3, :) = (/&
     & 0.11990757E+01, 0.10645317E+01, 0.10000000E+01/)
GA( 5, 4, :) = (/&
     & 0.12343189E+01, 0.55565422E+00, 0.00000000E+00/)
GB( 5, 4, :) = (/&
     & 0.12343189E+01, 0.10927103E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  250.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 6, 3, :) = (/&
     & 0.12055643E+01, 0.49968044E+00, 0.00000000E+00/)
GB( 6, 3, :) = (/&
     & 0.12055643E+01, 0.10702313E+01, 0.10000000E+01/)
GA( 6, 4, :) = (/&
     & 0.12404147E+01, 0.56878618E+00, 0.00000000E+00/)
GB( 6, 4, :) = (/&
     & 0.12404147E+01, 0.10982489E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  262.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 7, 3, :) = (/&
     & 0.12114186E+01, 0.51214132E+00, 0.00000000E+00/)
GB( 7, 3, :) = (/&
     & 0.12114186E+01, 0.10753907E+01, 0.10000000E+01/)
GA( 7, 4, :) = (/&
     & 0.12458431E+01, 0.58047395E+00, 0.00000000E+00/)
GB( 7, 4, :) = (/&
     & 0.12458431E+01, 0.11032019E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  275.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 8, 3, :) = (/&
     & 0.12167192E+01, 0.52341830E+00, 0.00000000E+00/)
GB( 8, 3, :) = (/&
     & 0.12167192E+01, 0.10800762E+01, 0.10000000E+01/)
GA( 8, 4, :) = (/&
     & 0.12506907E+01, 0.59089894E+00, 0.00000000E+00/)
GB( 8, 4, :) = (/&
     & 0.12506907E+01, 0.11076379E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  287.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 9, 3, :) = (/&
     & 0.12215344E+01, 0.53365803E+00, 0.00000000E+00/)
GB( 9, 3, :) = (/&
     & 0.12215344E+01, 0.10843446E+01, 0.10000000E+01/)
GA( 9, 4, :) = (/&
     & 0.12550299E+01, 0.60021475E+00, 0.00000000E+00/)
GB( 9, 4, :) = (/&
     & 0.12550299E+01, 0.11116160E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  300.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA(10, 3, :) = (/&
     & 0.12259226E+01, 0.54298448E+00, 0.00000000E+00/)
GB(10, 3, :) = (/&
     & 0.12259226E+01, 0.10882439E+01, 0.10000000E+01/)
GA(10, 4, :) = (/&
     & 0.12589256E+01, 0.60856112E+00, 0.00000000E+00/)
GB(10, 4, :) = (/&
     & 0.12589256E+01, 0.11151910E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  312.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA(11, 3, :) = (/&
     & 0.12299344E+01, 0.55150227E+00, 0.00000000E+00/)
GB(11, 3, :) = (/&
     & 0.12299344E+01, 0.10918144E+01, 0.10000000E+01/)
GA(11, 4, :) = (/&
     & 0.12624402E+01, 0.61607594E+00, 0.00000000E+00/)
GB(11, 4, :) = (/&
     & 0.12624402E+01, 0.11184188E+01, 0.10000000E+01/)
!
!
!
!
!- H2O  350-500 cm-1
!
!-- G = - 0.2*SLA, 0.0 +0.5/(1+0.5U)
!
!----- INTERVAL = 5 ----- T =  187.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 1, 5, :) = (/&
     & 0.15750172E+00,-0.22159303E-01, 0.00000000E+00/)
GB( 1, 5, :) = (/&
     & 0.15750172E+00, 0.38103212E+00, 0.10000000E+01/)
GA( 1, 6, :) = (/&
     & 0.17770551E+00,-0.24972399E-01, 0.00000000E+00/)
GB( 1, 6, :) = (/&
     & 0.17770551E+00, 0.41646579E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  200.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 2, 5, :) = (/&
     & 0.16174076E+00,-0.22748917E-01, 0.00000000E+00/)
GB( 2, 5, :) = (/&
     & 0.16174076E+00, 0.38913800E+00, 0.10000000E+01/)
GA( 2, 6, :) = (/&
     & 0.18176757E+00,-0.25537247E-01, 0.00000000E+00/)
GB( 2, 6, :) = (/&
     & 0.18176757E+00, 0.42345095E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  212.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 3, 5, :) = (/&
     & 0.16548628E+00,-0.23269898E-01, 0.00000000E+00/)
GB( 3, 5, :) = (/&
     & 0.16548628E+00, 0.39613651E+00, 0.10000000E+01/)
GA( 3, 6, :) = (/&
     & 0.18527967E+00,-0.26025624E-01, 0.00000000E+00/)
GB( 3, 6, :) = (/&
     & 0.18527967E+00, 0.42937476E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  225.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 4, 5, :) = (/&
     & 0.16881124E+00,-0.23732392E-01, 0.00000000E+00/)
GB( 4, 5, :) = (/&
     & 0.16881124E+00, 0.40222421E+00, 0.10000000E+01/)
GA( 4, 6, :) = (/&
     & 0.18833348E+00,-0.26450280E-01, 0.00000000E+00/)
GB( 4, 6, :) = (/&
     & 0.18833348E+00, 0.43444062E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  237.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 5, 5, :) = (/&
     & 0.17177839E+00,-0.24145123E-01, 0.00000000E+00/)
GB( 5, 5, :) = (/&
     & 0.17177839E+00, 0.40756010E+00, 0.10000000E+01/)
GA( 5, 6, :) = (/&
     & 0.19100108E+00,-0.26821236E-01, 0.00000000E+00/)
GB( 5, 6, :) = (/&
     & 0.19100108E+00, 0.43880316E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  250.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 6, 5, :) = (/&
     & 0.17443933E+00,-0.24515269E-01, 0.00000000E+00/)
GB( 6, 5, :) = (/&
     & 0.17443933E+00, 0.41226954E+00, 0.10000000E+01/)
GA( 6, 6, :) = (/&
     & 0.19334122E+00,-0.27146657E-01, 0.00000000E+00/)
GB( 6, 6, :) = (/&
     & 0.19334122E+00, 0.44258354E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  262.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 7, 5, :) = (/&
     & 0.17683622E+00,-0.24848690E-01, 0.00000000E+00/)
GB( 7, 5, :) = (/&
     & 0.17683622E+00, 0.41645142E+00, 0.10000000E+01/)
GA( 7, 6, :) = (/&
     & 0.19540288E+00,-0.27433354E-01, 0.00000000E+00/)
GB( 7, 6, :) = (/&
     & 0.19540288E+00, 0.44587882E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  275.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 8, 5, :) = (/&
     & 0.17900375E+00,-0.25150210E-01, 0.00000000E+00/)
GB( 8, 5, :) = (/&
     & 0.17900375E+00, 0.42018474E+00, 0.10000000E+01/)
GA( 8, 6, :) = (/&
     & 0.19722732E+00,-0.27687065E-01, 0.00000000E+00/)
GB( 8, 6, :) = (/&
     & 0.19722732E+00, 0.44876776E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  287.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 9, 5, :) = (/&
     & 0.18097099E+00,-0.25423873E-01, 0.00000000E+00/)
GB( 9, 5, :) = (/&
     & 0.18097099E+00, 0.42353379E+00, 0.10000000E+01/)
GA( 9, 6, :) = (/&
     & 0.19884918E+00,-0.27912608E-01, 0.00000000E+00/)
GB( 9, 6, :) = (/&
     & 0.19884918E+00, 0.45131451E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  300.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA(10, 5, :) = (/&
     & 0.18276283E+00,-0.25673139E-01, 0.00000000E+00/)
GB(10, 5, :) = (/&
     & 0.18276283E+00, 0.42655211E+00, 0.10000000E+01/)
GA(10, 6, :) = (/&
     & 0.20029696E+00,-0.28113944E-01, 0.00000000E+00/)
GB(10, 6, :) = (/&
     & 0.20029696E+00, 0.45357095E+00, 0.10000000E+01/)
!
!----- INTERVAL = 5 ----- T =  312.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA(11, 5, :) = (/&
     & 0.18440117E+00,-0.25901055E-01, 0.00000000E+00/)
GB(11, 5, :) = (/&
     & 0.18440117E+00, 0.42928533E+00, 0.10000000E+01/)
GA(11, 6, :) = (/&
     & 0.20159300E+00,-0.28294180E-01, 0.00000000E+00/)
GB(11, 6, :) = (/&
     & 0.20159300E+00, 0.45557797E+00, 0.10000000E+01/)
     
     

!
!
!- H2O  800-970 + 1110-1250 cm-1
!
!--- G = 3.875E-03 ---------------
!
!----- INTERVAL = 3 ----- T =  187.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 1, 7, :) = (/&
     & 0.10192131E+02, 0.80737799E+01, 0.00000000E+00/)
GB( 1, 7, :) = (/&
     & 0.10192131E+02, 0.82623280E+01, 0.10000000E+01/)
GA( 1, 8, :) = (/&
     & 0.92439050E+01, 0.77425778E+01, 0.00000000E+00/)
GB( 1, 8, :) = (/&
     & 0.92439050E+01, 0.79342219E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  200.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 2, 7, :) = (/&
     & 0.97258602E+01, 0.79171158E+01, 0.00000000E+00/)
GB( 2, 7, :) = (/&
     & 0.97258602E+01, 0.81072291E+01, 0.10000000E+01/)
GA( 2, 8, :) = (/&
     & 0.87567422E+01, 0.75443460E+01, 0.00000000E+00/)
GB( 2, 8, :) = (/&
     & 0.87567422E+01, 0.77373458E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  212.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 3, 7, :) = (/&
     & 0.92992890E+01, 0.77609605E+01, 0.00000000E+00/)
GB( 3, 7, :) = (/&
     & 0.92992890E+01, 0.79523834E+01, 0.10000000E+01/)
GA( 3, 8, :) = (/&
     & 0.83270144E+01, 0.73526151E+01, 0.00000000E+00/)
GB( 3, 8, :) = (/&
     & 0.83270144E+01, 0.75467334E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  225.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 4, 7, :) = (/&
     & 0.89154021E+01, 0.76087371E+01, 0.00000000E+00/)
GB( 4, 7, :) = (/&
     & 0.89154021E+01, 0.78012527E+01, 0.10000000E+01/)
GA( 4, 8, :) = (/&
     & 0.79528337E+01, 0.71711188E+01, 0.00000000E+00/)
GB( 4, 8, :) = (/&
     & 0.79528337E+01, 0.73661786E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  237.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 5, 7, :) = (/&
     & 0.85730084E+01, 0.74627112E+01, 0.00000000E+00/)
GB( 5, 7, :) = (/&
     & 0.85730084E+01, 0.76561458E+01, 0.10000000E+01/)
GA( 5, 8, :) = (/&
     & 0.76286839E+01, 0.70015571E+01, 0.00000000E+00/)
GB( 5, 8, :) = (/&
     & 0.76286839E+01, 0.71974319E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  250.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 6, 7, :) = (/&
     & 0.82685838E+01, 0.73239981E+01, 0.00000000E+00/)
GB( 6, 7, :) = (/&
     & 0.82685838E+01, 0.75182174E+01, 0.10000000E+01/)
GA( 6, 8, :) = (/&
     & 0.73477879E+01, 0.68442532E+01, 0.00000000E+00/)
GB( 6, 8, :) = (/&
     & 0.73477879E+01, 0.70408543E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  262.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 7, 7, :) = (/&
     & 0.79978921E+01, 0.71929934E+01, 0.00000000E+00/)
GB( 7, 7, :) = (/&
     & 0.79978921E+01, 0.73878952E+01, 0.10000000E+01/)
GA( 7, 8, :) = (/&
     & 0.71035818E+01, 0.66987996E+01, 0.00000000E+00/)
GB( 7, 8, :) = (/&
     & 0.71035818E+01, 0.68960649E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  275.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 8, 7, :) = (/&
     & 0.77568055E+01, 0.70697065E+01, 0.00000000E+00/)
GB( 8, 7, :) = (/&
     & 0.77568055E+01, 0.72652133E+01, 0.10000000E+01/)
GA( 8, 8, :) = (/&
     & 0.68903312E+01, 0.65644820E+01, 0.00000000E+00/)
GB( 8, 8, :) = (/&
     & 0.68903312E+01, 0.67623672E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  287.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 9, 7, :) = (/&
     & 0.75416266E+01, 0.69539626E+01, 0.00000000E+00/)
GB( 9, 7, :) = (/&
     & 0.75416266E+01, 0.71500151E+01, 0.10000000E+01/)
GA( 9, 8, :) = (/&
     & 0.67032875E+01, 0.64405267E+01, 0.00000000E+00/)
GB( 9, 8, :) = (/&
     & 0.67032875E+01, 0.66389989E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  300.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA(10, 7, :) = (/&
     & 0.73491694E+01, 0.68455144E+01, 0.00000000E+00/)
GB(10, 7, :) = (/&
     & 0.73491694E+01, 0.70420667E+01, 0.10000000E+01/)
GA(10, 8, :) = (/&
     & 0.65386461E+01, 0.63262376E+01, 0.00000000E+00/)
GB(10, 8, :) = (/&
     & 0.65386461E+01, 0.65252707E+01, 0.10000000E+01/)
!
!----- INTERVAL = 3 ----- T =  312.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA(11, 7, :) = (/&
     & 0.71767400E+01, 0.67441020E+01, 0.00000000E+00/)
GB(11, 7, :) = (/&
     & 0.71767400E+01, 0.69411177E+01, 0.10000000E+01/)
GA(11, 8, :) = (/&
     & 0.63934377E+01, 0.62210701E+01, 0.00000000E+00/)
GB(11, 8, :) = (/&
     & 0.63934377E+01, 0.64206412E+01, 0.10000000E+01/)
!
!
!
!- H2O  970 - 1110 cm-1
!
!!-- G = 3.6E-03
!
!----- INTERVAL = 4 ----- T =  187.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 1, 9, :) = (/&
     & 0.24870635E+02, 0.10542131E+02, 0.00000000E+00/)
GB( 1, 9, :) = (/&
     & 0.24870635E+02, 0.10656640E+02, 0.10000000E+01/)
GA( 1,10, :) = (/&
     & 0.24586283E+02, 0.10490353E+02, 0.00000000E+00/)
GB( 1,10, :) = (/&
     & 0.24586283E+02, 0.10605856E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  200.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 2, 9, :) = (/&
     & 0.24725591E+02, 0.10515895E+02, 0.00000000E+00/)
GB( 2, 9, :) = (/&
     & 0.24725591E+02, 0.10630910E+02, 0.10000000E+01/)
GA( 2,10, :) = (/&
     & 0.24441465E+02, 0.10463512E+02, 0.00000000E+00/)
GB( 2,10, :) = (/&
     & 0.24441465E+02, 0.10579514E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  212.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 3, 9, :) = (/&
     & 0.24600320E+02, 0.10492949E+02, 0.00000000E+00/)
GB( 3, 9, :) = (/&
     & 0.24600320E+02, 0.10608399E+02, 0.10000000E+01/)
GA( 3,10, :) = (/&
     & 0.24311657E+02, 0.10439183E+02, 0.00000000E+00/)
GB( 3,10, :) = (/&
     & 0.24311657E+02, 0.10555632E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  225.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 4, 9, :) = (/&
     & 0.24487300E+02, 0.10472049E+02, 0.00000000E+00/)
GB( 4, 9, :) = (/&
     & 0.24487300E+02, 0.10587891E+02, 0.10000000E+01/)
GA( 4,10, :) = (/&
     & 0.24196167E+02, 0.10417324E+02, 0.00000000E+00/)
GB( 4,10, :) = (/&
     & 0.24196167E+02, 0.10534169E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  237.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 5, 9, :) = (/&
     & 0.24384935E+02, 0.10452961E+02, 0.00000000E+00/)
GB( 5, 9, :) = (/&
     & 0.24384935E+02, 0.10569156E+02, 0.10000000E+01/)
GA( 5,10, :) = (/&
     & 0.24093406E+02, 0.10397704E+02, 0.00000000E+00/)
GB( 5,10, :) = (/&
     & 0.24093406E+02, 0.10514900E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  250.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 6, 9, :) = (/&
     & 0.24292341E+02, 0.10435562E+02, 0.00000000E+00/)
GB( 6, 9, :) = (/&
     & 0.24292341E+02, 0.10552075E+02, 0.10000000E+01/)
GA( 6,10, :) = (/&
     & 0.24001597E+02, 0.10380038E+02, 0.00000000E+00/)
GB( 6,10, :) = (/&
     & 0.24001597E+02, 0.10497547E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  262.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 7, 9, :) = (/&
     & 0.24208572E+02, 0.10419710E+02, 0.00000000E+00/)
GB( 7, 9, :) = (/&
     & 0.24208572E+02, 0.10536510E+02, 0.10000000E+01/)
GA( 7,10, :) = (/&
     & 0.23919098E+02, 0.10364052E+02, 0.00000000E+00/)
GB( 7,10, :) = (/&
     & 0.23919098E+02, 0.10481842E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  275.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 8, 9, :) = (/&
     & 0.24132642E+02, 0.10405247E+02, 0.00000000E+00/)
GB( 8, 9, :) = (/&
     & 0.24132642E+02, 0.10522307E+02, 0.10000000E+01/)
GA( 8,10, :) = (/&
     & 0.23844511E+02, 0.10349509E+02, 0.00000000E+00/)
GB( 8,10, :) = (/&
     & 0.23844511E+02, 0.10467553E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  287.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA( 9, 9, :) = (/&
     & 0.24063614E+02, 0.10392022E+02, 0.00000000E+00/)
GB( 9, 9, :) = (/&
     & 0.24063614E+02, 0.10509317E+02, 0.10000000E+01/)
GA( 9,10, :) = (/&
     & 0.23776708E+02, 0.10336215E+02, 0.00000000E+00/)
GB( 9,10, :) = (/&
     & 0.23776708E+02, 0.10454488E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  300.0
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA(10, 9, :) = (/&
     & 0.24000649E+02, 0.10379892E+02, 0.00000000E+00/)
GB(10, 9, :) = (/&
     & 0.24000649E+02, 0.10497402E+02, 0.10000000E+01/)
GA(10,10, :) = (/&
     & 0.23714816E+02, 0.10324018E+02, 0.00000000E+00/)
GB(10,10, :) = (/&
     & 0.23714816E+02, 0.10442501E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  312.5
!
!-- INDICES FOR PADE APPROXIMATION     1   28   37   45
GA(11, 9, :) = (/&
     & 0.23943021E+02, 0.10368736E+02, 0.00000000E+00/)
GB(11, 9, :) = (/&
     & 0.23943021E+02, 0.10486443E+02, 0.10000000E+01/)
GA(11,10, :) = (/&
     & 0.23658197E+02, 0.10312808E+02, 0.00000000E+00/)
GB(11,10, :) = (/&
     & 0.23658197E+02, 0.10431483E+02, 0.10000000E+01/)
!
!
!
!- H2O  1250-1450 + 1880-2820 cm-1
!
!--- G = 0.0
!
!
!----- INTERVAL = 6 ----- T =  187.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 1,11, :) = (/&
     & 0.11990218E+02,-0.12823142E+01, 0.00000000E+00/)
GB( 1,11, :) = (/&
     & 0.11990218E+02, 0.26681588E+02, 0.10000000E+01/)
GA( 1,12, :) = (/&
     & 0.79709806E+01,-0.74805226E+00, 0.00000000E+00/)
GB( 1,12, :) = (/&
     & 0.79709806E+01, 0.18377807E+02, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  200.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 2,11, :) = (/&
     & 0.10904073E+02,-0.10571588E+01, 0.00000000E+00/)
GB( 2,11, :) = (/&
     & 0.10904073E+02, 0.24728346E+02, 0.10000000E+01/)
GA( 2,12, :) = (/&
     & 0.75400737E+01,-0.56252739E+00, 0.00000000E+00/)
GB( 2,12, :) = (/&
     & 0.75400737E+01, 0.17643148E+02, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  212.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 3,11, :) = (/&
     & 0.89126838E+01,-0.74864953E+00, 0.00000000E+00/)
GB( 3,11, :) = (/&
     & 0.89126838E+01, 0.20551342E+02, 0.10000000E+01/)
GA( 3,12, :) = (/&
     & 0.81804377E+01,-0.46188072E+00, 0.00000000E+00/)
GB( 3,12, :) = (/&
     & 0.81804377E+01, 0.19296161E+02, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  225.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 4,11, :) = (/&
     & 0.85622405E+01,-0.58705980E+00, 0.00000000E+00/)
GB( 4,11, :) = (/&
     & 0.85622405E+01, 0.19955244E+02, 0.10000000E+01/)
GA( 4,12, :) = (/&
     & 0.10564339E+02,-0.40712065E+00, 0.00000000E+00/)
GB( 4,12, :) = (/&
     & 0.10564339E+02, 0.24951120E+02, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  237.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 5,11, :) = (/&
     & 0.94892164E+01,-0.49305772E+00, 0.00000000E+00/)
GB( 5,11, :) = (/&
     & 0.94892164E+01, 0.22227100E+02, 0.10000000E+01/)
GA( 5,12, :) = (/&
     & 0.46896789E+02,-0.15295996E+01, 0.00000000E+00/)
GB( 5,12, :) = (/&
     & 0.46896789E+02, 0.10957372E+03, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  250.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 6,11, :) = (/&
     & 0.13580937E+02,-0.51461431E+00, 0.00000000E+00/)
GB( 6,11, :) = (/&
     & 0.13580937E+02, 0.31770288E+02, 0.10000000E+01/)
GA( 6,12, :) = (/&
     &-0.30926524E+01, 0.43555255E+00, 0.00000000E+00/)
GB( 6,12, :) = (/&
     &-0.30926524E+01,-0.67432659E+01, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  262.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 7,11, :) = (/&
     &-0.32050918E+03, 0.12373350E+02, 0.00000000E+00/)
GB( 7,11, :) = (/&
     &-0.32050918E+03,-0.74061287E+03, 0.10000000E+01/)
GA( 7,12, :) = (/&
     & 0.85742941E+00, 0.50380874E+00, 0.00000000E+00/)
GB( 7,12, :) = (/&
     & 0.85742941E+00, 0.24550746E+01, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  275.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 8,11, :) = (/&
     &-0.37133165E+01, 0.44809588E+00, 0.00000000E+00/)
GB( 8,11, :) = (/&
     &-0.37133165E+01,-0.81329826E+01, 0.10000000E+01/)
GA( 8,12, :) = (/&
     & 0.19164038E+01, 0.68537352E+00, 0.00000000E+00/)
GB( 8,12, :) = (/&
     & 0.19164038E+01, 0.49089917E+01, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  287.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA( 9,11, :) = (/&
     & 0.18890836E+00, 0.46548918E+00, 0.00000000E+00/)
GB( 9,11, :) = (/&
     & 0.18890836E+00, 0.90279822E+00, 0.10000000E+01/)
GA( 9,12, :) = (/&
     & 0.23513199E+01, 0.89437630E+00, 0.00000000E+00/)
GB( 9,12, :) = (/&
     & 0.23513199E+01, 0.59008712E+01, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  300.0
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA(10,11, :) = (/&
     & 0.14209226E+01, 0.59121475E+00, 0.00000000E+00/)
GB(10,11, :) = (/&
     & 0.14209226E+01, 0.37532746E+01, 0.10000000E+01/)
GA(10,12, :) = (/&
     & 0.25566644E+01, 0.11127003E+01, 0.00000000E+00/)
GB(10,12, :) = (/&
     & 0.25566644E+01, 0.63532616E+01, 0.10000000E+01/)
!
!----- INTERVAL = 6 ----- T =  312.5
!
!-- INDICES FOR PADE APPROXIMATION   1 35 40 45
GA(11,11, :) = (/&
     & 0.19817679E+01, 0.74676119E+00, 0.00000000E+00/)
GB(11,11, :) = (/&
     & 0.19817679E+01, 0.50437916E+01, 0.10000000E+01/)
GA(11,12, :) = (/&
     & 0.26555181E+01, 0.13329782E+01, 0.00000000E+00/)
GB(11,12, :) = (/&
     & 0.26555181E+01, 0.65558627E+01, 0.10000000E+01/)
!
!

!
!
!
!-- CO2 -- INT.2 -- 500-800 CM-1 --- FROM ABS225 ----------------------
!
!
!
!-- FIU = 0.8 + MAX(0.35,(7-IU)*0.9)  , X/T,  9
!
!----- INTERVAL = 2 ----- T =  187.5
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 1,13, :) = (/&
     & 0.87668459E-01, 0.13845511E+01, 0.00000000E+00/)
GB( 1,13, :) = (/&
     & 0.87668459E-01, 0.23203798E+01, 0.10000000E+01/)
GA( 1,14, :) = (/&
     & 0.74878820E-01, 0.11718758E+01, 0.00000000E+00/)
GB( 1,14, :) = (/&
     & 0.74878820E-01, 0.20206726E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  200.0
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 2,13, :) = (/&
     & 0.83754276E-01, 0.13187042E+01, 0.00000000E+00/)
GB( 2,13, :) = (/&
     & 0.83754276E-01, 0.22288925E+01, 0.10000000E+01/)
GA( 2,14, :) = (/&
     & 0.71650966E-01, 0.11216131E+01, 0.00000000E+00/)
GB( 2,14, :) = (/&
     & 0.71650966E-01, 0.19441824E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  212.5
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 3,13, :) = (/&
     & 0.80460283E-01, 0.12644396E+01, 0.00000000E+00/)
GB( 3,13, :) = (/&
     & 0.80460283E-01, 0.21515593E+01, 0.10000000E+01/)
GA( 3,14, :) = (/&
     & 0.68979615E-01, 0.10809473E+01, 0.00000000E+00/)
GB( 3,14, :) = (/&
     & 0.68979615E-01, 0.18807257E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  225.0
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 4,13, :) = (/&
     & 0.77659686E-01, 0.12191543E+01, 0.00000000E+00/)
GB( 4,13, :) = (/&
     & 0.77659686E-01, 0.20855896E+01, 0.10000000E+01/)
GA( 4,14, :) = (/&
     & 0.66745345E-01, 0.10476396E+01, 0.00000000E+00/)
GB( 4,14, :) = (/&
     & 0.66745345E-01, 0.18275618E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  237.5
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 5,13, :) = (/&
     & 0.75257056E-01, 0.11809511E+01, 0.00000000E+00/)
GB( 5,13, :) = (/&
     & 0.75257056E-01, 0.20288489E+01, 0.10000000E+01/)
GA( 5,14, :) = (/&
     & 0.64857571E-01, 0.10200373E+01, 0.00000000E+00/)
GB( 5,14, :) = (/&
     & 0.64857571E-01, 0.17825910E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  250.0
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 6,13, :) = (/&
     & 0.73179175E-01, 0.11484154E+01, 0.00000000E+00/)
GB( 6,13, :) = (/&
     & 0.73179175E-01, 0.19796791E+01, 0.10000000E+01/)
GA( 6,14, :) = (/&
     & 0.63248495E-01, 0.99692726E+00, 0.00000000E+00/)
GB( 6,14, :) = (/&
     & 0.63248495E-01, 0.17442308E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  262.5
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 7,13, :) = (/&
     & 0.71369063E-01, 0.11204723E+01, 0.00000000E+00/)
GB( 7,13, :) = (/&
     & 0.71369063E-01, 0.19367778E+01, 0.10000000E+01/)
GA( 7,14, :) = (/&
     & 0.61866970E-01, 0.97740923E+00, 0.00000000E+00/)
GB( 7,14, :) = (/&
     & 0.61866970E-01, 0.17112809E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  275.0
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 8,13, :) = (/&
     & 0.69781812E-01, 0.10962918E+01, 0.00000000E+00/)
GB( 8,13, :) = (/&
     & 0.69781812E-01, 0.18991112E+01, 0.10000000E+01/)
GA( 8,14, :) = (/&
     & 0.60673632E-01, 0.96080188E+00, 0.00000000E+00/)
GB( 8,14, :) = (/&
     & 0.60673632E-01, 0.16828137E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  287.5
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA( 9,13, :) = (/&
     & 0.68381606E-01, 0.10752229E+01, 0.00000000E+00/)
GB( 9,13, :) = (/&
     & 0.68381606E-01, 0.18658501E+01, 0.10000000E+01/)
GA( 9,14, :) = (/&
     & 0.59637277E-01, 0.94657562E+00, 0.00000000E+00/)
GB( 9,14, :) = (/&
     & 0.59637277E-01, 0.16580908E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  300.0
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA(10,13, :) = (/&
     & 0.67139539E-01, 0.10567474E+01, 0.00000000E+00/)
GB(10,13, :) = (/&
     & 0.67139539E-01, 0.18363226E+01, 0.10000000E+01/)
GA(10,14, :) = (/&
     & 0.58732178E-01, 0.93430511E+00, 0.00000000E+00/)
GB(10,14, :) = (/&
     & 0.58732178E-01, 0.16365014E+01, 0.10000000E+01/)
!
!----- INTERVAL = 2 ----- T =  312.5
!
!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
GA(11,13, :) = (/&
     & 0.66032012E-01, 0.10404465E+01, 0.00000000E+00/)
GB(11,13, :) = (/&
     & 0.66032012E-01, 0.18099779E+01, 0.10000000E+01/)
GA(11,14, :) = (/&
     & 0.57936092E-01, 0.92363528E+00, 0.00000000E+00/)
GB(11,14, :) = (/&
     & 0.57936092E-01, 0.16175164E+01, 0.10000000E+01/)
!
!
!
!
!
!
!
!
!
!
!-- CARBON DIOXIDE LINES IN THE WINDOW REGION (800-1250 CM-1)
!
!
!-- G = 0.0
!
!
!----- INTERVAL = 4 ----- T =  187.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 1,15, :) = (/&
     & 0.13230067E+02, 0.22042132E+02, 0.00000000E+00/)
GB( 1,15, :) = (/&
     & 0.13230067E+02, 0.22051750E+02, 0.10000000E+01/)
GA( 1,16, :) = (/&
     & 0.13183816E+02, 0.22169501E+02, 0.00000000E+00/)
GB( 1,16, :) = (/&
     & 0.13183816E+02, 0.22178972E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  200.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 2,15, :) = (/&
     & 0.13213564E+02, 0.22107298E+02, 0.00000000E+00/)
GB( 2,15, :) = (/&
     & 0.13213564E+02, 0.22116850E+02, 0.10000000E+01/)
GA( 2,16, :) = (/&
     & 0.13189991E+02, 0.22270075E+02, 0.00000000E+00/)
GB( 2,16, :) = (/&
     & 0.13189991E+02, 0.22279484E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  212.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 3,15, :) = (/&
     & 0.13209140E+02, 0.22180915E+02, 0.00000000E+00/)
GB( 3,15, :) = (/&
     & 0.13209140E+02, 0.22190410E+02, 0.10000000E+01/)
GA( 3,16, :) = (/&
     & 0.13209485E+02, 0.22379193E+02, 0.00000000E+00/)
GB( 3,16, :) = (/&
     & 0.13209485E+02, 0.22388551E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  225.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 4,15, :) = (/&
     & 0.13213894E+02, 0.22259478E+02, 0.00000000E+00/)
GB( 4,15, :) = (/&
     & 0.13213894E+02, 0.22268925E+02, 0.10000000E+01/)
GA( 4,16, :) = (/&
     & 0.13238789E+02, 0.22492992E+02, 0.00000000E+00/)
GB( 4,16, :) = (/&
     & 0.13238789E+02, 0.22502309E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  237.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 5,15, :) = (/&
     & 0.13225963E+02, 0.22341039E+02, 0.00000000E+00/)
GB( 5,15, :) = (/&
     & 0.13225963E+02, 0.22350445E+02, 0.10000000E+01/)
GA( 5,16, :) = (/&
     & 0.13275017E+02, 0.22608508E+02, 0.00000000E+00/)
GB( 5,16, :) = (/&
     & 0.13275017E+02, 0.22617792E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  250.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 6,15, :) = (/&
     & 0.13243806E+02, 0.22424247E+02, 0.00000000E+00/)
GB( 6,15, :) = (/&
     & 0.13243806E+02, 0.22433617E+02, 0.10000000E+01/)
GA( 6,16, :) = (/&
     & 0.13316096E+02, 0.22723843E+02, 0.00000000E+00/)
GB( 6,16, :) = (/&
     & 0.13316096E+02, 0.22733099E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  262.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 7,15, :) = (/&
     & 0.13266104E+02, 0.22508089E+02, 0.00000000E+00/)
GB( 7,15, :) = (/&
     & 0.13266104E+02, 0.22517429E+02, 0.10000000E+01/)
GA( 7,16, :) = (/&
     & 0.13360555E+02, 0.22837837E+02, 0.00000000E+00/)
GB( 7,16, :) = (/&
     & 0.13360555E+02, 0.22847071E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  275.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 8,15, :) = (/&
     & 0.13291782E+02, 0.22591771E+02, 0.00000000E+00/)
GB( 8,15, :) = (/&
     & 0.13291782E+02, 0.22601086E+02, 0.10000000E+01/)
GA( 8,16, :) = (/&
     & 0.13407324E+02, 0.22949751E+02, 0.00000000E+00/)
GB( 8,16, :) = (/&
     & 0.13407324E+02, 0.22958967E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  287.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA( 9,15, :) = (/&
     & 0.13319961E+02, 0.22674661E+02, 0.00000000E+00/)
GB( 9,15, :) = (/&
     & 0.13319961E+02, 0.22683956E+02, 0.10000000E+01/)
GA( 9,16, :) = (/&
     & 0.13455544E+02, 0.23059032E+02, 0.00000000E+00/)
GB( 9,16, :) = (/&
     & 0.13455544E+02, 0.23068234E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  300.0
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA(10,15, :) = (/&
     & 0.13349927E+02, 0.22756246E+02, 0.00000000E+00/)
GB(10,15, :) = (/&
     & 0.13349927E+02, 0.22765522E+02, 0.10000000E+01/)
GA(10,16, :) = (/&
     & 0.13504450E+02, 0.23165146E+02, 0.00000000E+00/)
GB(10,16, :) = (/&
     & 0.13504450E+02, 0.23174336E+02, 0.10000000E+01/)
!
!----- INTERVAL = 4 ----- T =  312.5
!
!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
GA(11,15, :) = (/&
     & 0.13381108E+02, 0.22836093E+02, 0.00000000E+00/)
GB(11,15, :) = (/&
     & 0.13381108E+02, 0.22845354E+02, 0.10000000E+01/)
GA(11,16, :) = (/&
     & 0.13553282E+02, 0.23267456E+02, 0.00000000E+00/)
GB(11,16, :) = (/&
     & 0.13553282E+02, 0.23276638E+02, 0.10000000E+01/)
!     
RETURN
END SUBROUTINE SUOLW
