SUBROUTINE SUECAESS

!**   OPTICAL THICKNESS OF AEROSOLS OF SEA-SALT ORIGIN

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESS* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSS


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,12)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Sea Salt Aerosol         month:  1 --- lat:  1  90.0
ZAER (:, 1, 1) = (/&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.103E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  2  86.0
ZAER (:, 2, 1) = (/&
&.330E-03_JPRB,.330E-03_JPRB,.376E-03_JPRB,.376E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.496E-03_JPRB,&
&.496E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,&
&.248E-03_JPRB,.248E-03_JPRB,.191E-03_JPRB,.191E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.108E-03_JPRB,&
&.108E-03_JPRB,.723E-04_JPRB,.723E-04_JPRB,.660E-04_JPRB,.660E-04_JPRB,.687E-04_JPRB,.687E-04_JPRB,&
&.753E-04_JPRB,.753E-04_JPRB,.817E-04_JPRB,.817E-04_JPRB,.816E-04_JPRB,.816E-04_JPRB,.774E-04_JPRB,&
&.774E-04_JPRB,.771E-04_JPRB,.771E-04_JPRB,.869E-04_JPRB,.869E-04_JPRB,.100E-03_JPRB,.100E-03_JPRB,&
&.111E-03_JPRB,.111E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.107E-03_JPRB,&
&.107E-03_JPRB,.881E-04_JPRB,.881E-04_JPRB,.787E-04_JPRB,.787E-04_JPRB,.722E-04_JPRB,.722E-04_JPRB,&
&.718E-04_JPRB,.718E-04_JPRB,.758E-04_JPRB,.758E-04_JPRB,.855E-04_JPRB,.855E-04_JPRB,.997E-04_JPRB,&
&.997E-04_JPRB,.119E-03_JPRB,.119E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,.195E-03_JPRB,.195E-03_JPRB,&
&.276E-03_JPRB,.276E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  3  82.0
ZAER (:, 3, 1) = (/&
&.330E-03_JPRB,.330E-03_JPRB,.376E-03_JPRB,.376E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.496E-03_JPRB,&
&.496E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,&
&.248E-03_JPRB,.248E-03_JPRB,.191E-03_JPRB,.191E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.108E-03_JPRB,&
&.108E-03_JPRB,.723E-04_JPRB,.723E-04_JPRB,.660E-04_JPRB,.660E-04_JPRB,.687E-04_JPRB,.687E-04_JPRB,&
&.753E-04_JPRB,.753E-04_JPRB,.817E-04_JPRB,.817E-04_JPRB,.816E-04_JPRB,.816E-04_JPRB,.774E-04_JPRB,&
&.774E-04_JPRB,.771E-04_JPRB,.771E-04_JPRB,.869E-04_JPRB,.869E-04_JPRB,.100E-03_JPRB,.100E-03_JPRB,&
&.111E-03_JPRB,.111E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.107E-03_JPRB,&
&.107E-03_JPRB,.881E-04_JPRB,.881E-04_JPRB,.787E-04_JPRB,.787E-04_JPRB,.722E-04_JPRB,.722E-04_JPRB,&
&.718E-04_JPRB,.718E-04_JPRB,.758E-04_JPRB,.758E-04_JPRB,.855E-04_JPRB,.855E-04_JPRB,.997E-04_JPRB,&
&.997E-04_JPRB,.119E-03_JPRB,.119E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,.195E-03_JPRB,.195E-03_JPRB,&
&.276E-03_JPRB,.276E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  4  78.0
ZAER (:, 4, 1) = (/&
&.673E-03_JPRB,.673E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.757E-03_JPRB,.757E-03_JPRB,.933E-03_JPRB,&
&.933E-03_JPRB,.872E-03_JPRB,.872E-03_JPRB,.630E-03_JPRB,.630E-03_JPRB,.445E-03_JPRB,.445E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.132E-03_JPRB,.132E-03_JPRB,.139E-03_JPRB,.139E-03_JPRB,&
&.163E-03_JPRB,.163E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.144E-03_JPRB,&
&.144E-03_JPRB,.992E-04_JPRB,.992E-04_JPRB,.138E-03_JPRB,.138E-03_JPRB,.209E-03_JPRB,.209E-03_JPRB,&
&.274E-03_JPRB,.274E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.267E-03_JPRB,.267E-03_JPRB,.327E-03_JPRB,&
&.327E-03_JPRB,.270E-03_JPRB,.270E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,.106E-03_JPRB,.106E-03_JPRB,&
&.809E-04_JPRB,.809E-04_JPRB,.105E-03_JPRB,.105E-03_JPRB,.129E-03_JPRB,.129E-03_JPRB,.123E-03_JPRB,&
&.123E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.321E-03_JPRB,.321E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  5  74.0
ZAER (:, 5, 1) = (/&
&.673E-03_JPRB,.673E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.757E-03_JPRB,.757E-03_JPRB,.933E-03_JPRB,&
&.933E-03_JPRB,.872E-03_JPRB,.872E-03_JPRB,.630E-03_JPRB,.630E-03_JPRB,.445E-03_JPRB,.445E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.132E-03_JPRB,.132E-03_JPRB,.139E-03_JPRB,.139E-03_JPRB,&
&.163E-03_JPRB,.163E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.144E-03_JPRB,&
&.144E-03_JPRB,.992E-04_JPRB,.992E-04_JPRB,.138E-03_JPRB,.138E-03_JPRB,.209E-03_JPRB,.209E-03_JPRB,&
&.274E-03_JPRB,.274E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.267E-03_JPRB,.267E-03_JPRB,.327E-03_JPRB,&
&.327E-03_JPRB,.270E-03_JPRB,.270E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,.106E-03_JPRB,.106E-03_JPRB,&
&.809E-04_JPRB,.809E-04_JPRB,.105E-03_JPRB,.105E-03_JPRB,.129E-03_JPRB,.129E-03_JPRB,.123E-03_JPRB,&
&.123E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.321E-03_JPRB,.321E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  6  70.0
ZAER (:, 6, 1) = (/&
&.306E-02_JPRB,.306E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.221E-02_JPRB,.221E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.230E-02_JPRB,&
&.230E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.743E-03_JPRB,.743E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,&
&.735E-03_JPRB,.735E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.113E-02_JPRB,.113E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.174E-02_JPRB,&
&.174E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.827E-03_JPRB,.827E-03_JPRB,.419E-03_JPRB,.419E-03_JPRB,&
&.263E-03_JPRB,.263E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,.120E-02_JPRB,.120E-02_JPRB,.101E-02_JPRB,&
&.101E-02_JPRB,.671E-03_JPRB,.671E-03_JPRB,.900E-03_JPRB,.900E-03_JPRB,.171E-02_JPRB,.171E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  7  66.0
ZAER (:, 7, 1) = (/&
&.306E-02_JPRB,.306E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.221E-02_JPRB,.221E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.230E-02_JPRB,&
&.230E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.743E-03_JPRB,.743E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,&
&.735E-03_JPRB,.735E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.113E-02_JPRB,.113E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.174E-02_JPRB,&
&.174E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.827E-03_JPRB,.827E-03_JPRB,.419E-03_JPRB,.419E-03_JPRB,&
&.263E-03_JPRB,.263E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,.120E-02_JPRB,.120E-02_JPRB,.101E-02_JPRB,&
&.101E-02_JPRB,.671E-03_JPRB,.671E-03_JPRB,.900E-03_JPRB,.900E-03_JPRB,.171E-02_JPRB,.171E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  8  62.0
ZAER (:, 8, 1) = (/&
&.729E-02_JPRB,.729E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.622E-02_JPRB,&
&.622E-02_JPRB,.602E-02_JPRB,.602E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.579E-02_JPRB,.579E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.634E-02_JPRB,&
&.634E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.338E-02_JPRB,&
&.338E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,&
&.465E-02_JPRB,.465E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.544E-02_JPRB,&
&.544E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,&
&.388E-02_JPRB,.388E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.371E-02_JPRB,.371E-02_JPRB,.404E-02_JPRB,&
&.404E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat:  9  58.0
ZAER (:, 9, 1) = (/&
&.729E-02_JPRB,.729E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.622E-02_JPRB,&
&.622E-02_JPRB,.602E-02_JPRB,.602E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.579E-02_JPRB,.579E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.634E-02_JPRB,&
&.634E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.338E-02_JPRB,&
&.338E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,&
&.465E-02_JPRB,.465E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.544E-02_JPRB,&
&.544E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,&
&.388E-02_JPRB,.388E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.371E-02_JPRB,.371E-02_JPRB,.404E-02_JPRB,&
&.404E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 10  54.0
ZAER (:,10, 1) = (/&
&.893E-02_JPRB,.893E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.717E-02_JPRB,.717E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,.761E-02_JPRB,&
&.761E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.636E-02_JPRB,&
&.636E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,&
&.719E-02_JPRB,.719E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.796E-02_JPRB,&
&.796E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.837E-02_JPRB,&
&.837E-02_JPRB,.837E-02_JPRB,.837E-02_JPRB,.875E-02_JPRB,.875E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.934E-02_JPRB,.934E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 11  50.0
ZAER (:,11, 1) = (/&
&.893E-02_JPRB,.893E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.717E-02_JPRB,.717E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,.761E-02_JPRB,&
&.761E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.636E-02_JPRB,&
&.636E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,&
&.719E-02_JPRB,.719E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.796E-02_JPRB,&
&.796E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.837E-02_JPRB,&
&.837E-02_JPRB,.837E-02_JPRB,.837E-02_JPRB,.875E-02_JPRB,.875E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.934E-02_JPRB,.934E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 12  46.0
ZAER (:,12, 1) = (/&
&.705E-02_JPRB,.705E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.798E-02_JPRB,&
&.798E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.550E-02_JPRB,.550E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.522E-02_JPRB,&
&.522E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,.846E-02_JPRB,.846E-02_JPRB,&
&.899E-02_JPRB,.899E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,&
&.708E-02_JPRB,.708E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.789E-02_JPRB,.789E-02_JPRB,&
&.828E-02_JPRB,.828E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,&
&.580E-02_JPRB,.580E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 13  42.0
ZAER (:,13, 1) = (/&
&.705E-02_JPRB,.705E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.798E-02_JPRB,&
&.798E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.550E-02_JPRB,.550E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.522E-02_JPRB,&
&.522E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,.846E-02_JPRB,.846E-02_JPRB,&
&.899E-02_JPRB,.899E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,&
&.708E-02_JPRB,.708E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.789E-02_JPRB,.789E-02_JPRB,&
&.828E-02_JPRB,.828E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,&
&.580E-02_JPRB,.580E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 14  38.0
ZAER (:,14, 1) = (/&
&.563E-02_JPRB,.563E-02_JPRB,.579E-02_JPRB,.579E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.563E-02_JPRB,&
&.563E-02_JPRB,.557E-02_JPRB,.557E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,&
&.568E-02_JPRB,.568E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.571E-02_JPRB,&
&.571E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,&
&.733E-02_JPRB,.733E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,.860E-02_JPRB,&
&.860E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,&
&.640E-02_JPRB,.640E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.646E-02_JPRB,&
&.646E-02_JPRB,.656E-02_JPRB,.656E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,&
&.601E-02_JPRB,.601E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.514E-02_JPRB,&
&.514E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.491E-02_JPRB,.491E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,&
&.553E-02_JPRB,.553E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 15  34.0
ZAER (:,15, 1) = (/&
&.563E-02_JPRB,.563E-02_JPRB,.579E-02_JPRB,.579E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.563E-02_JPRB,&
&.563E-02_JPRB,.557E-02_JPRB,.557E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,&
&.568E-02_JPRB,.568E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.571E-02_JPRB,&
&.571E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,&
&.733E-02_JPRB,.733E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,.860E-02_JPRB,&
&.860E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,&
&.640E-02_JPRB,.640E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.646E-02_JPRB,&
&.646E-02_JPRB,.656E-02_JPRB,.656E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,&
&.601E-02_JPRB,.601E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.514E-02_JPRB,&
&.514E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.491E-02_JPRB,.491E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,&
&.553E-02_JPRB,.553E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 16  30.0
ZAER (:,16, 1) = (/&
&.710E-02_JPRB,.710E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,.992E-02_JPRB,.992E-02_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.903E-02_JPRB,.903E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,&
&.597E-02_JPRB,.597E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,&
&.409E-02_JPRB,.409E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.738E-02_JPRB,&
&.738E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,&
&.869E-02_JPRB,.869E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.224E-02_JPRB,&
&.224E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.793E-02_JPRB,.793E-02_JPRB,&
&.699E-02_JPRB,.699E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 17  26.0
ZAER (:,17, 1) = (/&
&.710E-02_JPRB,.710E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,.992E-02_JPRB,.992E-02_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.903E-02_JPRB,.903E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,&
&.597E-02_JPRB,.597E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,&
&.409E-02_JPRB,.409E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.738E-02_JPRB,&
&.738E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,&
&.869E-02_JPRB,.869E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.224E-02_JPRB,&
&.224E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.793E-02_JPRB,.793E-02_JPRB,&
&.699E-02_JPRB,.699E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 18  22.0
ZAER (:,18, 1) = (/&
&.833E-02_JPRB,.833E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.817E-02_JPRB,&
&.817E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.916E-02_JPRB,.916E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.456E-02_JPRB,&
&.456E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.617E-03_JPRB,.617E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,&
&.569E-02_JPRB,.569E-02_JPRB,.883E-02_JPRB,.883E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.761E-02_JPRB,&
&.761E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.170E-02_JPRB,.170E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.782E-02_JPRB,&
&.782E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.768E-02_JPRB,.768E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.190E-02_JPRB,&
&.190E-02_JPRB,.373E-02_JPRB,.373E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,&
&.747E-02_JPRB,.747E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 19  18.0
ZAER (:,19, 1) = (/&
&.833E-02_JPRB,.833E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.817E-02_JPRB,&
&.817E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.916E-02_JPRB,.916E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.456E-02_JPRB,&
&.456E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.617E-03_JPRB,.617E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,&
&.569E-02_JPRB,.569E-02_JPRB,.883E-02_JPRB,.883E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.761E-02_JPRB,&
&.761E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.170E-02_JPRB,.170E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.782E-02_JPRB,&
&.782E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.768E-02_JPRB,.768E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.190E-02_JPRB,&
&.190E-02_JPRB,.373E-02_JPRB,.373E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,&
&.747E-02_JPRB,.747E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 20  14.0
ZAER (:,20, 1) = (/&
&.848E-02_JPRB,.848E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.839E-02_JPRB,.839E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.217E-02_JPRB,&
&.217E-02_JPRB,.341E-03_JPRB,.341E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.671E-02_JPRB,.671E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.875E-02_JPRB,.875E-02_JPRB,.607E-02_JPRB,&
&.607E-02_JPRB,.413E-02_JPRB,.413E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.343E-03_JPRB,.343E-03_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.679E-02_JPRB,&
&.679E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,&
&.699E-02_JPRB,.699E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.319E-02_JPRB,&
&.319E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,&
&.783E-02_JPRB,.783E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 21  10.0
ZAER (:,21, 1) = (/&
&.848E-02_JPRB,.848E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.839E-02_JPRB,.839E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.217E-02_JPRB,&
&.217E-02_JPRB,.341E-03_JPRB,.341E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.671E-02_JPRB,.671E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.875E-02_JPRB,.875E-02_JPRB,.607E-02_JPRB,&
&.607E-02_JPRB,.413E-02_JPRB,.413E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.343E-03_JPRB,.343E-03_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.679E-02_JPRB,&
&.679E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,&
&.699E-02_JPRB,.699E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.319E-02_JPRB,&
&.319E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,&
&.783E-02_JPRB,.783E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 22   6.0
ZAER (:,22, 1) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.803E-02_JPRB,.803E-02_JPRB,&
&.589E-02_JPRB,.589E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.861E-03_JPRB,&
&.861E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.294E-02_JPRB,.294E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.792E-02_JPRB,.792E-02_JPRB,.557E-02_JPRB,&
&.557E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.310E-02_JPRB,.310E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.562E-02_JPRB,&
&.562E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.474E-02_JPRB,.474E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,&
&.348E-02_JPRB,.348E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.460E-02_JPRB,&
&.460E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 23   2.0
ZAER (:,23, 1) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.803E-02_JPRB,.803E-02_JPRB,&
&.589E-02_JPRB,.589E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.861E-03_JPRB,&
&.861E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.294E-02_JPRB,.294E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.792E-02_JPRB,.792E-02_JPRB,.557E-02_JPRB,&
&.557E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.310E-02_JPRB,.310E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.562E-02_JPRB,&
&.562E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.474E-02_JPRB,.474E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,&
&.348E-02_JPRB,.348E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.460E-02_JPRB,&
&.460E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 24  -2.0
ZAER (:,24, 1) = (/&
&.121E-01_JPRB,.121E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.371E-02_JPRB,&
&.371E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.741E-02_JPRB,.741E-02_JPRB,.475E-02_JPRB,&
&.475E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.302E-02_JPRB,.302E-02_JPRB,&
&.455E-02_JPRB,.455E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.820E-02_JPRB,&
&.820E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,&
&.682E-02_JPRB,.682E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.931E-02_JPRB,&
&.931E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 25  -6.0
ZAER (:,25, 1) = (/&
&.121E-01_JPRB,.121E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.371E-02_JPRB,&
&.371E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.741E-02_JPRB,.741E-02_JPRB,.475E-02_JPRB,&
&.475E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.302E-02_JPRB,.302E-02_JPRB,&
&.455E-02_JPRB,.455E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.820E-02_JPRB,&
&.820E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,&
&.682E-02_JPRB,.682E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.931E-02_JPRB,&
&.931E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 26 -10.0
ZAER (:,26, 1) = (/&
&.125E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.974E-02_JPRB,.974E-02_JPRB,.914E-02_JPRB,.914E-02_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,&
&.135E-01_JPRB,.135E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.738E-02_JPRB,.738E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.290E-02_JPRB,.290E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,&
&.377E-02_JPRB,.377E-02_JPRB,.593E-02_JPRB,.593E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.920E-02_JPRB,&
&.920E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,&
&.828E-02_JPRB,.828E-02_JPRB,.128E-01_JPRB,.128E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.178E-01_JPRB,&
&.178E-01_JPRB,.190E-01_JPRB,.190E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 27 -14.0
ZAER (:,27, 1) = (/&
&.125E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.974E-02_JPRB,.974E-02_JPRB,.914E-02_JPRB,.914E-02_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,&
&.135E-01_JPRB,.135E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.738E-02_JPRB,.738E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.290E-02_JPRB,.290E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,&
&.377E-02_JPRB,.377E-02_JPRB,.593E-02_JPRB,.593E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.920E-02_JPRB,&
&.920E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,&
&.828E-02_JPRB,.828E-02_JPRB,.128E-01_JPRB,.128E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.178E-01_JPRB,&
&.178E-01_JPRB,.190E-01_JPRB,.190E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 28 -18.0
ZAER (:,28, 1) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,&
&.852E-02_JPRB,.852E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.343E-02_JPRB,&
&.343E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.260E-02_JPRB,.260E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.575E-02_JPRB,&
&.575E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,&
&.461E-02_JPRB,.461E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.171E-01_JPRB,.171E-01_JPRB,.211E-01_JPRB,&
&.211E-01_JPRB,.213E-01_JPRB,.213E-01_JPRB,.181E-01_JPRB,.181E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 29 -22.0
ZAER (:,29, 1) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,&
&.852E-02_JPRB,.852E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.343E-02_JPRB,&
&.343E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.260E-02_JPRB,.260E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.575E-02_JPRB,&
&.575E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,&
&.461E-02_JPRB,.461E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.171E-01_JPRB,.171E-01_JPRB,.211E-01_JPRB,&
&.211E-01_JPRB,.213E-01_JPRB,.213E-01_JPRB,.181E-01_JPRB,.181E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 30 -26.0
ZAER (:,30, 1) = (/&
&.134E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.909E-02_JPRB,.909E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.475E-02_JPRB,.475E-02_JPRB,&
&.353E-02_JPRB,.353E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.535E-02_JPRB,.535E-02_JPRB,.742E-02_JPRB,&
&.742E-02_JPRB,.980E-02_JPRB,.980E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.990E-02_JPRB,.990E-02_JPRB,&
&.961E-02_JPRB,.961E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.287E-02_JPRB,&
&.287E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.244E-02_JPRB,.244E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 31 -30.0
ZAER (:,31, 1) = (/&
&.134E-01_JPRB,.134E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.909E-02_JPRB,.909E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.475E-02_JPRB,.475E-02_JPRB,&
&.353E-02_JPRB,.353E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.535E-02_JPRB,.535E-02_JPRB,.742E-02_JPRB,&
&.742E-02_JPRB,.980E-02_JPRB,.980E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.990E-02_JPRB,.990E-02_JPRB,&
&.961E-02_JPRB,.961E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.287E-02_JPRB,&
&.287E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.244E-02_JPRB,.244E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 32 -34.0
ZAER (:,32, 1) = (/&
&.151E-01_JPRB,.151E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.312E-02_JPRB,&
&.312E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.961E-02_JPRB,.961E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.549E-02_JPRB,&
&.549E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.418E-02_JPRB,.418E-02_JPRB,&
&.269E-02_JPRB,.269E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.969E-03_JPRB,.969E-03_JPRB,.818E-03_JPRB,.818E-03_JPRB,&
&.733E-03_JPRB,.733E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.406E-02_JPRB,&
&.406E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 33 -38.0
ZAER (:,33, 1) = (/&
&.151E-01_JPRB,.151E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.312E-02_JPRB,&
&.312E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.961E-02_JPRB,.961E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.549E-02_JPRB,&
&.549E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.418E-02_JPRB,.418E-02_JPRB,&
&.269E-02_JPRB,.269E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.969E-03_JPRB,.969E-03_JPRB,.818E-03_JPRB,.818E-03_JPRB,&
&.733E-03_JPRB,.733E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.406E-02_JPRB,&
&.406E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 34 -42.0
ZAER (:,34, 1) = (/&
&.198E-01_JPRB,.198E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.842E-02_JPRB,.842E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,&
&.231E-02_JPRB,.231E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.166E-01_JPRB,.166E-01_JPRB,.174E-01_JPRB,.174E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.461E-02_JPRB,.461E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,&
&.290E-02_JPRB,.290E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.963E-03_JPRB,.963E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,&
&.606E-03_JPRB,.606E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.179E-01_JPRB,.179E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 35 -46.0
ZAER (:,35, 1) = (/&
&.198E-01_JPRB,.198E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.842E-02_JPRB,.842E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,&
&.231E-02_JPRB,.231E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.166E-01_JPRB,.166E-01_JPRB,.174E-01_JPRB,.174E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.461E-02_JPRB,.461E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,&
&.290E-02_JPRB,.290E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.963E-03_JPRB,.963E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,&
&.606E-03_JPRB,.606E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.179E-01_JPRB,.179E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 36 -50.0
ZAER (:,36, 1) = (/&
&.152E-01_JPRB,.152E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.652E-02_JPRB,.652E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.991E-03_JPRB,&
&.991E-03_JPRB,.968E-03_JPRB,.968E-03_JPRB,.340E-02_JPRB,.340E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.189E-01_JPRB,.189E-01_JPRB,.227E-01_JPRB,.227E-01_JPRB,.208E-01_JPRB,.208E-01_JPRB,.135E-01_JPRB,&
&.135E-01_JPRB,.814E-02_JPRB,.814E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.392E-02_JPRB,.392E-02_JPRB,&
&.313E-02_JPRB,.313E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.931E-03_JPRB,.931E-03_JPRB,&
&.857E-03_JPRB,.857E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.664E-03_JPRB,&
&.664E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.130E-02_JPRB,.130E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 37 -54.0
ZAER (:,37, 1) = (/&
&.152E-01_JPRB,.152E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.652E-02_JPRB,.652E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.991E-03_JPRB,&
&.991E-03_JPRB,.968E-03_JPRB,.968E-03_JPRB,.340E-02_JPRB,.340E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.189E-01_JPRB,.189E-01_JPRB,.227E-01_JPRB,.227E-01_JPRB,.208E-01_JPRB,.208E-01_JPRB,.135E-01_JPRB,&
&.135E-01_JPRB,.814E-02_JPRB,.814E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.392E-02_JPRB,.392E-02_JPRB,&
&.313E-02_JPRB,.313E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.931E-03_JPRB,.931E-03_JPRB,&
&.857E-03_JPRB,.857E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.664E-03_JPRB,&
&.664E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.130E-02_JPRB,.130E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 38 -58.0
ZAER (:,38, 1) = (/&
&.632E-02_JPRB,.632E-02_JPRB,.471E-02_JPRB,.471E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.556E-02_JPRB,&
&.556E-02_JPRB,.464E-02_JPRB,.464E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.683E-03_JPRB,.683E-03_JPRB,.582E-02_JPRB,.582E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.178E-01_JPRB,.178E-01_JPRB,.213E-01_JPRB,.213E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.186E-01_JPRB,&
&.186E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.860E-02_JPRB,.860E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,.209E-02_JPRB,&
&.209E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.909E-03_JPRB,.909E-03_JPRB,.815E-03_JPRB,.815E-03_JPRB,.709E-03_JPRB,&
&.709E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.162E-02_JPRB,.162E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 39 -62.0
ZAER (:,39, 1) = (/&
&.632E-02_JPRB,.632E-02_JPRB,.471E-02_JPRB,.471E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.556E-02_JPRB,&
&.556E-02_JPRB,.464E-02_JPRB,.464E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.683E-03_JPRB,.683E-03_JPRB,.582E-02_JPRB,.582E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.178E-01_JPRB,.178E-01_JPRB,.213E-01_JPRB,.213E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.186E-01_JPRB,&
&.186E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.860E-02_JPRB,.860E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,.209E-02_JPRB,&
&.209E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.909E-03_JPRB,.909E-03_JPRB,.815E-03_JPRB,.815E-03_JPRB,.709E-03_JPRB,&
&.709E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.162E-02_JPRB,.162E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 40 -66.0
ZAER (:,40, 1) = (/&
&.151E-02_JPRB,.151E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,&
&.158E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.969E-03_JPRB,.969E-03_JPRB,&
&.713E-03_JPRB,.713E-03_JPRB,.859E-03_JPRB,.859E-03_JPRB,.878E-03_JPRB,.878E-03_JPRB,.553E-03_JPRB,&
&.553E-03_JPRB,.358E-03_JPRB,.358E-03_JPRB,.136E-02_JPRB,.136E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.464E-02_JPRB,.464E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.621E-02_JPRB,.621E-02_JPRB,&
&.470E-02_JPRB,.470E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.895E-03_JPRB,.895E-03_JPRB,.805E-03_JPRB,.805E-03_JPRB,.735E-03_JPRB,.735E-03_JPRB,.749E-03_JPRB,&
&.749E-03_JPRB,.795E-03_JPRB,.795E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,.919E-03_JPRB,.919E-03_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 41 -70.0
ZAER (:,41, 1) = (/&
&.151E-02_JPRB,.151E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,&
&.158E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.969E-03_JPRB,.969E-03_JPRB,&
&.713E-03_JPRB,.713E-03_JPRB,.859E-03_JPRB,.859E-03_JPRB,.878E-03_JPRB,.878E-03_JPRB,.553E-03_JPRB,&
&.553E-03_JPRB,.358E-03_JPRB,.358E-03_JPRB,.136E-02_JPRB,.136E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.464E-02_JPRB,.464E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.621E-02_JPRB,.621E-02_JPRB,&
&.470E-02_JPRB,.470E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.331E-02_JPRB,.331E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.895E-03_JPRB,.895E-03_JPRB,.805E-03_JPRB,.805E-03_JPRB,.735E-03_JPRB,.735E-03_JPRB,.749E-03_JPRB,&
&.749E-03_JPRB,.795E-03_JPRB,.795E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,.919E-03_JPRB,.919E-03_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 42 -74.0
ZAER (:,42, 1) = (/&
&.558E-03_JPRB,.558E-03_JPRB,.601E-03_JPRB,.601E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.684E-03_JPRB,&
&.684E-03_JPRB,.648E-03_JPRB,.648E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.362E-03_JPRB,&
&.362E-03_JPRB,.331E-03_JPRB,.331E-03_JPRB,.511E-03_JPRB,.511E-03_JPRB,.939E-03_JPRB,.939E-03_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.214E-02_JPRB,&
&.214E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,&
&.562E-02_JPRB,.562E-02_JPRB,.325E-02_JPRB,.325E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.859E-03_JPRB,.859E-03_JPRB,.691E-03_JPRB,.691E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.671E-03_JPRB,&
&.671E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.659E-03_JPRB,.659E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,&
&.541E-03_JPRB,.541E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 43 -78.0
ZAER (:,43, 1) = (/&
&.558E-03_JPRB,.558E-03_JPRB,.601E-03_JPRB,.601E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.684E-03_JPRB,&
&.684E-03_JPRB,.648E-03_JPRB,.648E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.362E-03_JPRB,&
&.362E-03_JPRB,.331E-03_JPRB,.331E-03_JPRB,.511E-03_JPRB,.511E-03_JPRB,.939E-03_JPRB,.939E-03_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.214E-02_JPRB,&
&.214E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,&
&.562E-02_JPRB,.562E-02_JPRB,.325E-02_JPRB,.325E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.859E-03_JPRB,.859E-03_JPRB,.691E-03_JPRB,.691E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.671E-03_JPRB,&
&.671E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.659E-03_JPRB,.659E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,&
&.541E-03_JPRB,.541E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 44 -82.0
ZAER (:,44, 1) = (/&
&.559E-03_JPRB,.559E-03_JPRB,.545E-03_JPRB,.545E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,&
&.409E-03_JPRB,.409E-03_JPRB,.415E-03_JPRB,.415E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,.409E-03_JPRB,&
&.409E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,&
&.649E-03_JPRB,.649E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.786E-03_JPRB,.786E-03_JPRB,.893E-03_JPRB,&
&.893E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.995E-03_JPRB,.995E-03_JPRB,.880E-03_JPRB,.880E-03_JPRB,.779E-03_JPRB,.779E-03_JPRB,.686E-03_JPRB,&
&.686E-03_JPRB,.605E-03_JPRB,.605E-03_JPRB,.529E-03_JPRB,.529E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.494E-03_JPRB,.494E-03_JPRB,.538E-03_JPRB,&
&.538E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.611E-03_JPRB,.611E-03_JPRB,.592E-03_JPRB,.592E-03_JPRB,&
&.571E-03_JPRB,.571E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 45 -86.0
ZAER (:,45, 1) = (/&
&.559E-03_JPRB,.559E-03_JPRB,.545E-03_JPRB,.545E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.463E-03_JPRB,&
&.463E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,&
&.409E-03_JPRB,.409E-03_JPRB,.415E-03_JPRB,.415E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,.409E-03_JPRB,&
&.409E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,&
&.649E-03_JPRB,.649E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.786E-03_JPRB,.786E-03_JPRB,.893E-03_JPRB,&
&.893E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.995E-03_JPRB,.995E-03_JPRB,.880E-03_JPRB,.880E-03_JPRB,.779E-03_JPRB,.779E-03_JPRB,.686E-03_JPRB,&
&.686E-03_JPRB,.605E-03_JPRB,.605E-03_JPRB,.529E-03_JPRB,.529E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.494E-03_JPRB,.494E-03_JPRB,.538E-03_JPRB,&
&.538E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.611E-03_JPRB,.611E-03_JPRB,.592E-03_JPRB,.592E-03_JPRB,&
&.571E-03_JPRB,.571E-03_JPRB/)
!-- Sea Salt Aerosol         month:  1 --- lat: 46 -90.0
ZAER (:,46, 1) = (/&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  1  90.0
ZAER (:, 1, 2) = (/&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  2  86.0
ZAER (:, 2, 2) = (/&
&.337E-03_JPRB,.337E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.281E-03_JPRB,.281E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,&
&.329E-03_JPRB,.329E-03_JPRB,.379E-03_JPRB,.379E-03_JPRB,.446E-03_JPRB,.446E-03_JPRB,.454E-03_JPRB,&
&.454E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,&
&.216E-03_JPRB,.216E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.116E-03_JPRB,.116E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,&
&.155E-03_JPRB,.155E-03_JPRB,.161E-03_JPRB,.161E-03_JPRB,.173E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.142E-03_JPRB,.142E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,&
&.110E-03_JPRB,.110E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.118E-03_JPRB,.118E-03_JPRB,.121E-03_JPRB,&
&.121E-03_JPRB,.123E-03_JPRB,.123E-03_JPRB,.139E-03_JPRB,.139E-03_JPRB,.189E-03_JPRB,.189E-03_JPRB,&
&.270E-03_JPRB,.270E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  3  82.0
ZAER (:, 3, 2) = (/&
&.337E-03_JPRB,.337E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.281E-03_JPRB,.281E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,&
&.329E-03_JPRB,.329E-03_JPRB,.379E-03_JPRB,.379E-03_JPRB,.446E-03_JPRB,.446E-03_JPRB,.454E-03_JPRB,&
&.454E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,&
&.216E-03_JPRB,.216E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,.103E-03_JPRB,&
&.103E-03_JPRB,.116E-03_JPRB,.116E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,&
&.155E-03_JPRB,.155E-03_JPRB,.161E-03_JPRB,.161E-03_JPRB,.173E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.142E-03_JPRB,.142E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,&
&.110E-03_JPRB,.110E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.118E-03_JPRB,.118E-03_JPRB,.121E-03_JPRB,&
&.121E-03_JPRB,.123E-03_JPRB,.123E-03_JPRB,.139E-03_JPRB,.139E-03_JPRB,.189E-03_JPRB,.189E-03_JPRB,&
&.270E-03_JPRB,.270E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  4  78.0
ZAER (:, 4, 2) = (/&
&.806E-03_JPRB,.806E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,.674E-03_JPRB,.674E-03_JPRB,.601E-03_JPRB,&
&.601E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.347E-03_JPRB,.347E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,&
&.567E-03_JPRB,.567E-03_JPRB,.769E-03_JPRB,.769E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.713E-03_JPRB,.713E-03_JPRB,.559E-03_JPRB,.559E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,.256E-03_JPRB,.256E-03_JPRB,.170E-03_JPRB,&
&.170E-03_JPRB,.117E-03_JPRB,.117E-03_JPRB,.188E-03_JPRB,.188E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,&
&.316E-03_JPRB,.316E-03_JPRB,.258E-03_JPRB,.258E-03_JPRB,.279E-03_JPRB,.279E-03_JPRB,.341E-03_JPRB,&
&.341E-03_JPRB,.327E-03_JPRB,.327E-03_JPRB,.247E-03_JPRB,.247E-03_JPRB,.198E-03_JPRB,.198E-03_JPRB,&
&.158E-03_JPRB,.158E-03_JPRB,.194E-03_JPRB,.194E-03_JPRB,.253E-03_JPRB,.253E-03_JPRB,.251E-03_JPRB,&
&.251E-03_JPRB,.247E-03_JPRB,.247E-03_JPRB,.271E-03_JPRB,.271E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,&
&.793E-03_JPRB,.793E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  5  74.0
ZAER (:, 5, 2) = (/&
&.806E-03_JPRB,.806E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,.674E-03_JPRB,.674E-03_JPRB,.601E-03_JPRB,&
&.601E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.347E-03_JPRB,.347E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,&
&.567E-03_JPRB,.567E-03_JPRB,.769E-03_JPRB,.769E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.713E-03_JPRB,.713E-03_JPRB,.559E-03_JPRB,.559E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,.256E-03_JPRB,.256E-03_JPRB,.170E-03_JPRB,&
&.170E-03_JPRB,.117E-03_JPRB,.117E-03_JPRB,.188E-03_JPRB,.188E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,&
&.316E-03_JPRB,.316E-03_JPRB,.258E-03_JPRB,.258E-03_JPRB,.279E-03_JPRB,.279E-03_JPRB,.341E-03_JPRB,&
&.341E-03_JPRB,.327E-03_JPRB,.327E-03_JPRB,.247E-03_JPRB,.247E-03_JPRB,.198E-03_JPRB,.198E-03_JPRB,&
&.158E-03_JPRB,.158E-03_JPRB,.194E-03_JPRB,.194E-03_JPRB,.253E-03_JPRB,.253E-03_JPRB,.251E-03_JPRB,&
&.251E-03_JPRB,.247E-03_JPRB,.247E-03_JPRB,.271E-03_JPRB,.271E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,&
&.793E-03_JPRB,.793E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  6  70.0
ZAER (:, 6, 2) = (/&
&.437E-02_JPRB,.437E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.273E-02_JPRB,.273E-02_JPRB,&
&.378E-02_JPRB,.378E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.505E-02_JPRB,&
&.505E-02_JPRB,.421E-02_JPRB,.421E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,&
&.915E-03_JPRB,.915E-03_JPRB,.535E-03_JPRB,.535E-03_JPRB,.148E-02_JPRB,.148E-02_JPRB,.158E-02_JPRB,&
&.158E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,&
&.196E-02_JPRB,.196E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.942E-03_JPRB,.942E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,&
&.859E-03_JPRB,.859E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  7  66.0
ZAER (:, 7, 2) = (/&
&.437E-02_JPRB,.437E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.273E-02_JPRB,.273E-02_JPRB,&
&.378E-02_JPRB,.378E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.505E-02_JPRB,&
&.505E-02_JPRB,.421E-02_JPRB,.421E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,&
&.915E-03_JPRB,.915E-03_JPRB,.535E-03_JPRB,.535E-03_JPRB,.148E-02_JPRB,.148E-02_JPRB,.158E-02_JPRB,&
&.158E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,&
&.196E-02_JPRB,.196E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.942E-03_JPRB,.942E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,&
&.859E-03_JPRB,.859E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  8  62.0
ZAER (:, 8, 2) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.916E-02_JPRB,.916E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.665E-02_JPRB,&
&.665E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.970E-02_JPRB,.970E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,.452E-02_JPRB,&
&.452E-02_JPRB,.483E-02_JPRB,.483E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.694E-02_JPRB,.694E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,&
&.543E-02_JPRB,.543E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.985E-02_JPRB,.985E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat:  9  58.0
ZAER (:, 9, 2) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.916E-02_JPRB,.916E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.665E-02_JPRB,&
&.665E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.970E-02_JPRB,.970E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,&
&.441E-02_JPRB,.441E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,.452E-02_JPRB,&
&.452E-02_JPRB,.483E-02_JPRB,.483E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.694E-02_JPRB,.694E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,&
&.543E-02_JPRB,.543E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.985E-02_JPRB,.985E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 10  54.0
ZAER (:,10, 2) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.985E-02_JPRB,.985E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.822E-02_JPRB,&
&.822E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,&
&.781E-02_JPRB,.781E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.641E-02_JPRB,&
&.641E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.782E-02_JPRB,.782E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.889E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.891E-02_JPRB,.891E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.953E-02_JPRB,&
&.953E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 11  50.0
ZAER (:,11, 2) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.985E-02_JPRB,.985E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.822E-02_JPRB,&
&.822E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,&
&.781E-02_JPRB,.781E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.641E-02_JPRB,&
&.641E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.782E-02_JPRB,.782E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.889E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.891E-02_JPRB,.891E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.953E-02_JPRB,&
&.953E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 12  46.0
ZAER (:,12, 2) = (/&
&.694E-02_JPRB,.694E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.814E-02_JPRB,&
&.814E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,&
&.757E-02_JPRB,.757E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,.511E-02_JPRB,&
&.511E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.744E-02_JPRB,&
&.744E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.725E-02_JPRB,.725E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.810E-02_JPRB,&
&.810E-02_JPRB,.827E-02_JPRB,.827E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.735E-02_JPRB,&
&.735E-02_JPRB,.698E-02_JPRB,.698E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,&
&.614E-02_JPRB,.614E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 13  42.0
ZAER (:,13, 2) = (/&
&.694E-02_JPRB,.694E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.814E-02_JPRB,&
&.814E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,&
&.757E-02_JPRB,.757E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,.511E-02_JPRB,&
&.511E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.744E-02_JPRB,&
&.744E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.725E-02_JPRB,.725E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.810E-02_JPRB,&
&.810E-02_JPRB,.827E-02_JPRB,.827E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.735E-02_JPRB,&
&.735E-02_JPRB,.698E-02_JPRB,.698E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,&
&.614E-02_JPRB,.614E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 14  38.0
ZAER (:,14, 2) = (/&
&.671E-02_JPRB,.671E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.677E-02_JPRB,&
&.677E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.672E-02_JPRB,.672E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,&
&.790E-02_JPRB,.790E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.798E-02_JPRB,&
&.798E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,&
&.861E-02_JPRB,.861E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.747E-02_JPRB,&
&.747E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,&
&.756E-02_JPRB,.756E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,&
&.653E-02_JPRB,.653E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 15  34.0
ZAER (:,15, 2) = (/&
&.671E-02_JPRB,.671E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.677E-02_JPRB,&
&.677E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.672E-02_JPRB,.672E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,&
&.790E-02_JPRB,.790E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.798E-02_JPRB,&
&.798E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.632E-02_JPRB,.632E-02_JPRB,&
&.861E-02_JPRB,.861E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.747E-02_JPRB,&
&.747E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,&
&.756E-02_JPRB,.756E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,&
&.653E-02_JPRB,.653E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 16  30.0
ZAER (:,16, 2) = (/&
&.862E-02_JPRB,.862E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.817E-02_JPRB,&
&.817E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.928E-02_JPRB,.928E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.599E-02_JPRB,&
&.599E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,&
&.711E-02_JPRB,.711E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.946E-02_JPRB,.946E-02_JPRB,.944E-02_JPRB,&
&.944E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.479E-02_JPRB,.479E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.929E-02_JPRB,.929E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,&
&.821E-02_JPRB,.821E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,&
&.906E-02_JPRB,.906E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 17  26.0
ZAER (:,17, 2) = (/&
&.862E-02_JPRB,.862E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.817E-02_JPRB,&
&.817E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.928E-02_JPRB,.928E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.599E-02_JPRB,&
&.599E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,&
&.711E-02_JPRB,.711E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.946E-02_JPRB,.946E-02_JPRB,.944E-02_JPRB,&
&.944E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.479E-02_JPRB,.479E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.929E-02_JPRB,.929E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,&
&.821E-02_JPRB,.821E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,&
&.906E-02_JPRB,.906E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 18  22.0
ZAER (:,18, 2) = (/&
&.818E-02_JPRB,.818E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.937E-02_JPRB,.937E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.507E-03_JPRB,.507E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.728E-02_JPRB,.728E-02_JPRB,.956E-02_JPRB,.956E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.793E-02_JPRB,&
&.793E-02_JPRB,.577E-02_JPRB,.577E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,.681E-03_JPRB,.681E-03_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.694E-02_JPRB,.694E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.884E-02_JPRB,.884E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.291E-02_JPRB,&
&.291E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,&
&.709E-02_JPRB,.709E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 19  18.0
ZAER (:,19, 2) = (/&
&.818E-02_JPRB,.818E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.937E-02_JPRB,.937E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.507E-03_JPRB,.507E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.728E-02_JPRB,.728E-02_JPRB,.956E-02_JPRB,.956E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.793E-02_JPRB,&
&.793E-02_JPRB,.577E-02_JPRB,.577E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,.681E-03_JPRB,.681E-03_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.694E-02_JPRB,.694E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.884E-02_JPRB,.884E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.291E-02_JPRB,&
&.291E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,&
&.709E-02_JPRB,.709E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 20  14.0
ZAER (:,20, 2) = (/&
&.869E-02_JPRB,.869E-02_JPRB,.129E-01_JPRB,.129E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB,.711E-02_JPRB,.711E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,.290E-02_JPRB,&
&.290E-02_JPRB,.485E-03_JPRB,.485E-03_JPRB,.168E-03_JPRB,.168E-03_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.780E-02_JPRB,.780E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.544E-03_JPRB,.544E-03_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.875E-02_JPRB,&
&.875E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,&
&.792E-02_JPRB,.792E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,.361E-02_JPRB,&
&.361E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,&
&.559E-02_JPRB,.559E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 21  10.0
ZAER (:,21, 2) = (/&
&.869E-02_JPRB,.869E-02_JPRB,.129E-01_JPRB,.129E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB,.711E-02_JPRB,.711E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,.290E-02_JPRB,&
&.290E-02_JPRB,.485E-03_JPRB,.485E-03_JPRB,.168E-03_JPRB,.168E-03_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.780E-02_JPRB,.780E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.544E-03_JPRB,.544E-03_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.875E-02_JPRB,&
&.875E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,&
&.792E-02_JPRB,.792E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,.361E-02_JPRB,&
&.361E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,&
&.559E-02_JPRB,.559E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 22   6.0
ZAER (:,22, 2) = (/&
&.146E-01_JPRB,.146E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.149E-01_JPRB,&
&.149E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.445E-03_JPRB,.445E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,.217E-02_JPRB,.217E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.882E-02_JPRB,.882E-02_JPRB,.661E-02_JPRB,&
&.661E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.398E-02_JPRB,.398E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,.814E-02_JPRB,.814E-02_JPRB,.766E-02_JPRB,&
&.766E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.490E-02_JPRB,.490E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,&
&.302E-02_JPRB,.302E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.416E-02_JPRB,&
&.416E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 23   2.0
ZAER (:,23, 2) = (/&
&.146E-01_JPRB,.146E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.149E-01_JPRB,&
&.149E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.445E-03_JPRB,.445E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,.217E-02_JPRB,.217E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.882E-02_JPRB,.882E-02_JPRB,.661E-02_JPRB,&
&.661E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.398E-02_JPRB,.398E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,.814E-02_JPRB,.814E-02_JPRB,.766E-02_JPRB,&
&.766E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.490E-02_JPRB,.490E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,&
&.302E-02_JPRB,.302E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.416E-02_JPRB,&
&.416E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 24  -2.0
ZAER (:,24, 2) = (/&
&.148E-01_JPRB,.148E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.913E-02_JPRB,.913E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.655E-02_JPRB,.655E-02_JPRB,.421E-02_JPRB,&
&.421E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.929E-02_JPRB,.929E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.531E-02_JPRB,&
&.531E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,&
&.525E-02_JPRB,.525E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.963E-02_JPRB,&
&.963E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,&
&.549E-02_JPRB,.549E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,&
&.152E-01_JPRB,.152E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 25  -6.0
ZAER (:,25, 2) = (/&
&.148E-01_JPRB,.148E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.913E-02_JPRB,.913E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.655E-02_JPRB,.655E-02_JPRB,.421E-02_JPRB,&
&.421E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.929E-02_JPRB,.929E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.531E-02_JPRB,&
&.531E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,&
&.525E-02_JPRB,.525E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.963E-02_JPRB,&
&.963E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,&
&.549E-02_JPRB,.549E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,&
&.152E-01_JPRB,.152E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 26 -10.0
ZAER (:,26, 2) = (/&
&.146E-01_JPRB,.146E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.932E-02_JPRB,.932E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.931E-02_JPRB,.931E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.489E-02_JPRB,&
&.489E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,&
&.385E-02_JPRB,.385E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,&
&.673E-02_JPRB,.673E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.995E-02_JPRB,.995E-02_JPRB,.160E-01_JPRB,&
&.160E-01_JPRB,.176E-01_JPRB,.176E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,&
&.157E-01_JPRB,.157E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 27 -14.0
ZAER (:,27, 2) = (/&
&.146E-01_JPRB,.146E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.932E-02_JPRB,.932E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.931E-02_JPRB,.931E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.489E-02_JPRB,&
&.489E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,&
&.385E-02_JPRB,.385E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,&
&.673E-02_JPRB,.673E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.995E-02_JPRB,.995E-02_JPRB,.160E-01_JPRB,&
&.160E-01_JPRB,.176E-01_JPRB,.176E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,&
&.157E-01_JPRB,.157E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 28 -18.0
ZAER (:,28, 2) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.967E-02_JPRB,.967E-02_JPRB,.857E-02_JPRB,.857E-02_JPRB,&
&.857E-02_JPRB,.857E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.839E-02_JPRB,.839E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,.372E-02_JPRB,&
&.372E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,&
&.324E-02_JPRB,.324E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.345E-02_JPRB,.345E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.580E-02_JPRB,.580E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,&
&.458E-02_JPRB,.458E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.157E-01_JPRB,&
&.157E-01_JPRB,.193E-01_JPRB,.193E-01_JPRB,.189E-01_JPRB,.189E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,&
&.167E-01_JPRB,.167E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 29 -22.0
ZAER (:,29, 2) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.967E-02_JPRB,.967E-02_JPRB,.857E-02_JPRB,.857E-02_JPRB,&
&.857E-02_JPRB,.857E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.839E-02_JPRB,.839E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,.372E-02_JPRB,&
&.372E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,&
&.324E-02_JPRB,.324E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.345E-02_JPRB,.345E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.580E-02_JPRB,.580E-02_JPRB,.526E-02_JPRB,.526E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,&
&.458E-02_JPRB,.458E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.157E-01_JPRB,&
&.157E-01_JPRB,.193E-01_JPRB,.193E-01_JPRB,.189E-01_JPRB,.189E-01_JPRB,.178E-01_JPRB,.178E-01_JPRB,&
&.167E-01_JPRB,.167E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 30 -26.0
ZAER (:,30, 2) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.998E-02_JPRB,.998E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.849E-02_JPRB,&
&.849E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.394E-02_JPRB,&
&.394E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.257E-02_JPRB,.257E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.204E-02_JPRB,&
&.204E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.292E-02_JPRB,.292E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,&
&.196E-02_JPRB,.196E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.893E-02_JPRB,&
&.893E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 31 -30.0
ZAER (:,31, 2) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.998E-02_JPRB,.998E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.849E-02_JPRB,&
&.849E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.394E-02_JPRB,&
&.394E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.257E-02_JPRB,.257E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.204E-02_JPRB,&
&.204E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.292E-02_JPRB,.292E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,&
&.196E-02_JPRB,.196E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.893E-02_JPRB,&
&.893E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 32 -34.0
ZAER (:,32, 2) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.984E-02_JPRB,.984E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,&
&.183E-02_JPRB,.183E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.336E-02_JPRB,&
&.336E-02_JPRB,.894E-02_JPRB,.894E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.970E-03_JPRB,&
&.970E-03_JPRB,.947E-03_JPRB,.947E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,&
&.832E-03_JPRB,.832E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.243E-02_JPRB,.243E-02_JPRB,.337E-02_JPRB,&
&.337E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 33 -38.0
ZAER (:,33, 2) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.984E-02_JPRB,.984E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,&
&.183E-02_JPRB,.183E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.336E-02_JPRB,&
&.336E-02_JPRB,.894E-02_JPRB,.894E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.970E-03_JPRB,&
&.970E-03_JPRB,.947E-03_JPRB,.947E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,&
&.832E-03_JPRB,.832E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.243E-02_JPRB,.243E-02_JPRB,.337E-02_JPRB,&
&.337E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 34 -42.0
ZAER (:,34, 2) = (/&
&.143E-01_JPRB,.143E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.816E-02_JPRB,.816E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,&
&.195E-02_JPRB,.195E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.911E-03_JPRB,&
&.911E-03_JPRB,.286E-02_JPRB,.286E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.653E-02_JPRB,.653E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.301E-02_JPRB,.301E-02_JPRB,&
&.305E-02_JPRB,.305E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.787E-03_JPRB,.787E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.576E-03_JPRB,.576E-03_JPRB,&
&.512E-03_JPRB,.512E-03_JPRB,.472E-03_JPRB,.472E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.479E-02_JPRB,.479E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 35 -46.0
ZAER (:,35, 2) = (/&
&.143E-01_JPRB,.143E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.816E-02_JPRB,.816E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,&
&.195E-02_JPRB,.195E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.911E-03_JPRB,&
&.911E-03_JPRB,.286E-02_JPRB,.286E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.653E-02_JPRB,.653E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.301E-02_JPRB,.301E-02_JPRB,&
&.305E-02_JPRB,.305E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.787E-03_JPRB,.787E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.576E-03_JPRB,.576E-03_JPRB,&
&.512E-03_JPRB,.512E-03_JPRB,.472E-03_JPRB,.472E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.479E-02_JPRB,.479E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 36 -50.0
ZAER (:,36, 2) = (/&
&.138E-01_JPRB,.138E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.632E-02_JPRB,.632E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.102E-02_JPRB,&
&.102E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,.427E-02_JPRB,.427E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB,.192E-01_JPRB,.192E-01_JPRB,.234E-01_JPRB,.234E-01_JPRB,.174E-01_JPRB,&
&.174E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.222E-02_JPRB,.222E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.913E-03_JPRB,.913E-03_JPRB,.747E-03_JPRB,.747E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,&
&.548E-03_JPRB,.548E-03_JPRB,.624E-03_JPRB,.624E-03_JPRB,.822E-03_JPRB,.822E-03_JPRB,.928E-03_JPRB,&
&.928E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.209E-02_JPRB,.209E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 37 -54.0
ZAER (:,37, 2) = (/&
&.138E-01_JPRB,.138E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.632E-02_JPRB,.632E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.102E-02_JPRB,&
&.102E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,.427E-02_JPRB,.427E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB,.192E-01_JPRB,.192E-01_JPRB,.234E-01_JPRB,.234E-01_JPRB,.174E-01_JPRB,&
&.174E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.222E-02_JPRB,.222E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.913E-03_JPRB,.913E-03_JPRB,.747E-03_JPRB,.747E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,&
&.548E-03_JPRB,.548E-03_JPRB,.624E-03_JPRB,.624E-03_JPRB,.822E-03_JPRB,.822E-03_JPRB,.928E-03_JPRB,&
&.928E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.209E-02_JPRB,.209E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 38 -58.0
ZAER (:,38, 2) = (/&
&.645E-02_JPRB,.645E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,.822E-02_JPRB,&
&.822E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.312E-02_JPRB,.312E-02_JPRB,.206E-02_JPRB,&
&.206E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.174E-01_JPRB,.174E-01_JPRB,.162E-01_JPRB,&
&.162E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.605E-02_JPRB,.605E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.995E-03_JPRB,&
&.995E-03_JPRB,.856E-03_JPRB,.856E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,&
&.730E-03_JPRB,.730E-03_JPRB,.975E-03_JPRB,.975E-03_JPRB,.119E-02_JPRB,.119E-02_JPRB,.147E-02_JPRB,&
&.147E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 39 -62.0
ZAER (:,39, 2) = (/&
&.645E-02_JPRB,.645E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,.822E-02_JPRB,&
&.822E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.312E-02_JPRB,.312E-02_JPRB,.206E-02_JPRB,&
&.206E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.174E-01_JPRB,.174E-01_JPRB,.162E-01_JPRB,&
&.162E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.605E-02_JPRB,.605E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.995E-03_JPRB,&
&.995E-03_JPRB,.856E-03_JPRB,.856E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,&
&.730E-03_JPRB,.730E-03_JPRB,.975E-03_JPRB,.975E-03_JPRB,.119E-02_JPRB,.119E-02_JPRB,.147E-02_JPRB,&
&.147E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 40 -66.0
ZAER (:,40, 2) = (/&
&.193E-02_JPRB,.193E-02_JPRB,.268E-02_JPRB,.268E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.253E-02_JPRB,&
&.253E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.154E-02_JPRB,&
&.154E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.480E-02_JPRB,.480E-02_JPRB,&
&.426E-02_JPRB,.426E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.439E-02_JPRB,.439E-02_JPRB,&
&.325E-02_JPRB,.325E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.931E-03_JPRB,&
&.931E-03_JPRB,.651E-03_JPRB,.651E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.797E-03_JPRB,.797E-03_JPRB,&
&.944E-03_JPRB,.944E-03_JPRB,.117E-02_JPRB,.117E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.157E-02_JPRB,&
&.157E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.157E-02_JPRB,.157E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 41 -70.0
ZAER (:,41, 2) = (/&
&.193E-02_JPRB,.193E-02_JPRB,.268E-02_JPRB,.268E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.253E-02_JPRB,&
&.253E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.154E-02_JPRB,&
&.154E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.480E-02_JPRB,.480E-02_JPRB,&
&.426E-02_JPRB,.426E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.439E-02_JPRB,.439E-02_JPRB,&
&.325E-02_JPRB,.325E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.931E-03_JPRB,&
&.931E-03_JPRB,.651E-03_JPRB,.651E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.797E-03_JPRB,.797E-03_JPRB,&
&.944E-03_JPRB,.944E-03_JPRB,.117E-02_JPRB,.117E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.157E-02_JPRB,&
&.157E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.157E-02_JPRB,.157E-02_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 42 -74.0
ZAER (:,42, 2) = (/&
&.868E-03_JPRB,.868E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.951E-03_JPRB,&
&.951E-03_JPRB,.970E-03_JPRB,.970E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.104E-02_JPRB,.104E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.152E-02_JPRB,&
&.152E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.611E-02_JPRB,&
&.611E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.433E-02_JPRB,.433E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.912E-03_JPRB,.912E-03_JPRB,.667E-03_JPRB,&
&.667E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,&
&.752E-03_JPRB,.752E-03_JPRB,.842E-03_JPRB,.842E-03_JPRB,.942E-03_JPRB,.942E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.884E-03_JPRB,.884E-03_JPRB,.846E-03_JPRB,.846E-03_JPRB,.835E-03_JPRB,.835E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 43 -78.0
ZAER (:,43, 2) = (/&
&.868E-03_JPRB,.868E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.976E-03_JPRB,.951E-03_JPRB,&
&.951E-03_JPRB,.970E-03_JPRB,.970E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.104E-02_JPRB,.104E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.152E-02_JPRB,&
&.152E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.611E-02_JPRB,&
&.611E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,&
&.433E-02_JPRB,.433E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.912E-03_JPRB,.912E-03_JPRB,.667E-03_JPRB,&
&.667E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,&
&.752E-03_JPRB,.752E-03_JPRB,.842E-03_JPRB,.842E-03_JPRB,.942E-03_JPRB,.942E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.884E-03_JPRB,.884E-03_JPRB,.846E-03_JPRB,.846E-03_JPRB,.835E-03_JPRB,.835E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 44 -82.0
ZAER (:,44, 2) = (/&
&.808E-03_JPRB,.808E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,.874E-03_JPRB,.874E-03_JPRB,.926E-03_JPRB,&
&.926E-03_JPRB,.979E-03_JPRB,.979E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.128E-02_JPRB,&
&.128E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.989E-03_JPRB,.989E-03_JPRB,&
&.979E-03_JPRB,.979E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.840E-03_JPRB,.840E-03_JPRB,.715E-03_JPRB,.715E-03_JPRB,.664E-03_JPRB,.664E-03_JPRB,.638E-03_JPRB,&
&.638E-03_JPRB,.640E-03_JPRB,.640E-03_JPRB,.646E-03_JPRB,.646E-03_JPRB,.639E-03_JPRB,.639E-03_JPRB,&
&.646E-03_JPRB,.646E-03_JPRB,.649E-03_JPRB,.649E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.664E-03_JPRB,&
&.664E-03_JPRB,.688E-03_JPRB,.688E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.749E-03_JPRB,.749E-03_JPRB,&
&.786E-03_JPRB,.786E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 45 -86.0
ZAER (:,45, 2) = (/&
&.808E-03_JPRB,.808E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,.874E-03_JPRB,.874E-03_JPRB,.926E-03_JPRB,&
&.926E-03_JPRB,.979E-03_JPRB,.979E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.128E-02_JPRB,&
&.128E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.989E-03_JPRB,.989E-03_JPRB,&
&.979E-03_JPRB,.979E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.840E-03_JPRB,.840E-03_JPRB,.715E-03_JPRB,.715E-03_JPRB,.664E-03_JPRB,.664E-03_JPRB,.638E-03_JPRB,&
&.638E-03_JPRB,.640E-03_JPRB,.640E-03_JPRB,.646E-03_JPRB,.646E-03_JPRB,.639E-03_JPRB,.639E-03_JPRB,&
&.646E-03_JPRB,.646E-03_JPRB,.649E-03_JPRB,.649E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.664E-03_JPRB,&
&.664E-03_JPRB,.688E-03_JPRB,.688E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.749E-03_JPRB,.749E-03_JPRB,&
&.786E-03_JPRB,.786E-03_JPRB/)
!-- Sea Salt Aerosol         month:  2 --- lat: 46 -90.0
ZAER (:,46, 2) = (/&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.612E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  1  90.0
ZAER (:, 1, 3) = (/&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,&
&.240E-03_JPRB,.240E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  2  86.0
ZAER (:, 2, 3) = (/&
&.400E-03_JPRB,.400E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.486E-03_JPRB,.486E-03_JPRB,.523E-03_JPRB,&
&.523E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,&
&.585E-03_JPRB,.585E-03_JPRB,.555E-03_JPRB,.555E-03_JPRB,.534E-03_JPRB,.534E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.520E-03_JPRB,.520E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.488E-03_JPRB,.488E-03_JPRB,&
&.448E-03_JPRB,.448E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.251E-03_JPRB,&
&.251E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.169E-03_JPRB,.169E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,&
&.159E-03_JPRB,.159E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.158E-03_JPRB,&
&.158E-03_JPRB,.152E-03_JPRB,.152E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,&
&.173E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.184E-03_JPRB,.184E-03_JPRB,.199E-03_JPRB,&
&.199E-03_JPRB,.225E-03_JPRB,.225E-03_JPRB,.260E-03_JPRB,.260E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,&
&.355E-03_JPRB,.355E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  3  82.0
ZAER (:, 3, 3) = (/&
&.400E-03_JPRB,.400E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.486E-03_JPRB,.486E-03_JPRB,.523E-03_JPRB,&
&.523E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,&
&.585E-03_JPRB,.585E-03_JPRB,.555E-03_JPRB,.555E-03_JPRB,.534E-03_JPRB,.534E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.520E-03_JPRB,.520E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.488E-03_JPRB,.488E-03_JPRB,&
&.448E-03_JPRB,.448E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.251E-03_JPRB,&
&.251E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.169E-03_JPRB,.169E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,&
&.159E-03_JPRB,.159E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.158E-03_JPRB,&
&.158E-03_JPRB,.152E-03_JPRB,.152E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,&
&.173E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.184E-03_JPRB,.184E-03_JPRB,.199E-03_JPRB,&
&.199E-03_JPRB,.225E-03_JPRB,.225E-03_JPRB,.260E-03_JPRB,.260E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,&
&.355E-03_JPRB,.355E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  4  78.0
ZAER (:, 4, 3) = (/&
&.429E-03_JPRB,.429E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.860E-03_JPRB,.860E-03_JPRB,.777E-03_JPRB,&
&.777E-03_JPRB,.695E-03_JPRB,.695E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.751E-03_JPRB,.751E-03_JPRB,&
&.960E-03_JPRB,.960E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.962E-03_JPRB,.962E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.889E-03_JPRB,.889E-03_JPRB,.736E-03_JPRB,.736E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.400E-03_JPRB,&
&.400E-03_JPRB,.236E-03_JPRB,.236E-03_JPRB,.136E-03_JPRB,.136E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.178E-03_JPRB,.178E-03_JPRB,.193E-03_JPRB,.193E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.214E-03_JPRB,.214E-03_JPRB,.243E-03_JPRB,.243E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,&
&.270E-03_JPRB,.270E-03_JPRB,.244E-03_JPRB,.244E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.181E-03_JPRB,&
&.181E-03_JPRB,.183E-03_JPRB,.183E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.301E-03_JPRB,.301E-03_JPRB,&
&.348E-03_JPRB,.348E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  5  74.0
ZAER (:, 5, 3) = (/&
&.429E-03_JPRB,.429E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.860E-03_JPRB,.860E-03_JPRB,.777E-03_JPRB,&
&.777E-03_JPRB,.695E-03_JPRB,.695E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.751E-03_JPRB,.751E-03_JPRB,&
&.960E-03_JPRB,.960E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.962E-03_JPRB,.962E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.889E-03_JPRB,.889E-03_JPRB,.736E-03_JPRB,.736E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.400E-03_JPRB,&
&.400E-03_JPRB,.236E-03_JPRB,.236E-03_JPRB,.136E-03_JPRB,.136E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.178E-03_JPRB,.178E-03_JPRB,.193E-03_JPRB,.193E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.214E-03_JPRB,.214E-03_JPRB,.243E-03_JPRB,.243E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,&
&.270E-03_JPRB,.270E-03_JPRB,.244E-03_JPRB,.244E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.181E-03_JPRB,&
&.181E-03_JPRB,.183E-03_JPRB,.183E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.301E-03_JPRB,.301E-03_JPRB,&
&.348E-03_JPRB,.348E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  6  70.0
ZAER (:, 6, 3) = (/&
&.308E-02_JPRB,.308E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.224E-02_JPRB,&
&.224E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.268E-02_JPRB,.268E-02_JPRB,.269E-02_JPRB,&
&.269E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.941E-03_JPRB,.941E-03_JPRB,.764E-03_JPRB,.764E-03_JPRB,.564E-03_JPRB,&
&.564E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,&
&.299E-03_JPRB,.299E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,.543E-03_JPRB,&
&.543E-03_JPRB,.718E-03_JPRB,.718E-03_JPRB,.942E-03_JPRB,.942E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.768E-03_JPRB,&
&.768E-03_JPRB,.523E-03_JPRB,.523E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,.955E-03_JPRB,.955E-03_JPRB,&
&.185E-02_JPRB,.185E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  7  66.0
ZAER (:, 7, 3) = (/&
&.308E-02_JPRB,.308E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.224E-02_JPRB,&
&.224E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,&
&.265E-02_JPRB,.265E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.268E-02_JPRB,.268E-02_JPRB,.269E-02_JPRB,&
&.269E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.941E-03_JPRB,.941E-03_JPRB,.764E-03_JPRB,.764E-03_JPRB,.564E-03_JPRB,&
&.564E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,&
&.299E-03_JPRB,.299E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,.543E-03_JPRB,&
&.543E-03_JPRB,.718E-03_JPRB,.718E-03_JPRB,.942E-03_JPRB,.942E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.768E-03_JPRB,&
&.768E-03_JPRB,.523E-03_JPRB,.523E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,.955E-03_JPRB,.955E-03_JPRB,&
&.185E-02_JPRB,.185E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  8  62.0
ZAER (:, 8, 3) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.965E-02_JPRB,.965E-02_JPRB,.819E-02_JPRB,.819E-02_JPRB,.558E-02_JPRB,&
&.558E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.957E-02_JPRB,.957E-02_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.989E-02_JPRB,&
&.989E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,&
&.171E-02_JPRB,.171E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.949E-03_JPRB,.949E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,&
&.957E-03_JPRB,.957E-03_JPRB,.247E-02_JPRB,.247E-02_JPRB,.362E-02_JPRB,.362E-02_JPRB,.332E-02_JPRB,&
&.332E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,&
&.713E-02_JPRB,.713E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,&
&.964E-02_JPRB,.964E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat:  9  58.0
ZAER (:, 9, 3) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.965E-02_JPRB,.965E-02_JPRB,.819E-02_JPRB,.819E-02_JPRB,.558E-02_JPRB,&
&.558E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.957E-02_JPRB,.957E-02_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.989E-02_JPRB,&
&.989E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,&
&.171E-02_JPRB,.171E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.949E-03_JPRB,.949E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,&
&.957E-03_JPRB,.957E-03_JPRB,.247E-02_JPRB,.247E-02_JPRB,.362E-02_JPRB,.362E-02_JPRB,.332E-02_JPRB,&
&.332E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,&
&.713E-02_JPRB,.713E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,&
&.964E-02_JPRB,.964E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 10  54.0
ZAER (:,10, 3) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.939E-02_JPRB,.939E-02_JPRB,.882E-02_JPRB,&
&.882E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.938E-02_JPRB,.938E-02_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.971E-02_JPRB,&
&.971E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.771E-02_JPRB,.771E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,&
&.687E-02_JPRB,.687E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.878E-02_JPRB,.878E-02_JPRB,.876E-02_JPRB,&
&.876E-02_JPRB,.931E-02_JPRB,.931E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 11  50.0
ZAER (:,11, 3) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.939E-02_JPRB,.939E-02_JPRB,.882E-02_JPRB,&
&.882E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.938E-02_JPRB,.938E-02_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.971E-02_JPRB,&
&.971E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.771E-02_JPRB,.771E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,&
&.687E-02_JPRB,.687E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.878E-02_JPRB,.878E-02_JPRB,.876E-02_JPRB,&
&.876E-02_JPRB,.931E-02_JPRB,.931E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 12  46.0
ZAER (:,12, 3) = (/&
&.828E-02_JPRB,.828E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.743E-02_JPRB,&
&.743E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,&
&.786E-02_JPRB,.786E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.628E-02_JPRB,&
&.628E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,&
&.879E-02_JPRB,.879E-02_JPRB,.896E-02_JPRB,.896E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.821E-02_JPRB,&
&.821E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB,.699E-02_JPRB,.699E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.819E-02_JPRB,&
&.819E-02_JPRB,.898E-02_JPRB,.898E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.969E-02_JPRB,&
&.969E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,&
&.656E-02_JPRB,.656E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 13  42.0
ZAER (:,13, 3) = (/&
&.828E-02_JPRB,.828E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.743E-02_JPRB,&
&.743E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,&
&.786E-02_JPRB,.786E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.628E-02_JPRB,&
&.628E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,&
&.879E-02_JPRB,.879E-02_JPRB,.896E-02_JPRB,.896E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.821E-02_JPRB,&
&.821E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB,.699E-02_JPRB,.699E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.819E-02_JPRB,&
&.819E-02_JPRB,.898E-02_JPRB,.898E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.969E-02_JPRB,&
&.969E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,&
&.656E-02_JPRB,.656E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 14  38.0
ZAER (:,14, 3) = (/&
&.704E-02_JPRB,.704E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.756E-02_JPRB,&
&.756E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.745E-02_JPRB,.745E-02_JPRB,&
&.773E-02_JPRB,.773E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.425E-02_JPRB,.425E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,&
&.819E-02_JPRB,.819E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.845E-02_JPRB,&
&.845E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,&
&.802E-02_JPRB,.802E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.562E-02_JPRB,&
&.562E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 15  34.0
ZAER (:,15, 3) = (/&
&.704E-02_JPRB,.704E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.756E-02_JPRB,&
&.756E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.745E-02_JPRB,.745E-02_JPRB,&
&.773E-02_JPRB,.773E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.425E-02_JPRB,.425E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,&
&.819E-02_JPRB,.819E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.845E-02_JPRB,&
&.845E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,&
&.802E-02_JPRB,.802E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.562E-02_JPRB,&
&.562E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 16  30.0
ZAER (:,16, 3) = (/&
&.847E-02_JPRB,.847E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.771E-02_JPRB,&
&.771E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.942E-02_JPRB,.942E-02_JPRB,.782E-02_JPRB,&
&.782E-02_JPRB,.432E-02_JPRB,.432E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,&
&.752E-02_JPRB,.752E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,.906E-02_JPRB,&
&.906E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.289E-02_JPRB,.289E-02_JPRB,&
&.477E-02_JPRB,.477E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.904E-02_JPRB,.904E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.299E-02_JPRB,&
&.299E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 17  26.0
ZAER (:,17, 3) = (/&
&.847E-02_JPRB,.847E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.771E-02_JPRB,&
&.771E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.942E-02_JPRB,.942E-02_JPRB,.782E-02_JPRB,&
&.782E-02_JPRB,.432E-02_JPRB,.432E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,&
&.752E-02_JPRB,.752E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,.906E-02_JPRB,&
&.906E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.289E-02_JPRB,.289E-02_JPRB,&
&.477E-02_JPRB,.477E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.904E-02_JPRB,.904E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.299E-02_JPRB,&
&.299E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 18  22.0
ZAER (:,18, 3) = (/&
&.839E-02_JPRB,.839E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.851E-02_JPRB,&
&.851E-02_JPRB,.908E-02_JPRB,.908E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.715E-03_JPRB,.715E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.643E-02_JPRB,.643E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.272E-02_JPRB,.272E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.766E-02_JPRB,.766E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.329E-02_JPRB,&
&.329E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.953E-02_JPRB,.953E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 19  18.0
ZAER (:,19, 3) = (/&
&.839E-02_JPRB,.839E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.851E-02_JPRB,&
&.851E-02_JPRB,.908E-02_JPRB,.908E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.715E-03_JPRB,.715E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.643E-02_JPRB,.643E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.272E-02_JPRB,.272E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.766E-02_JPRB,.766E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.329E-02_JPRB,&
&.329E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.953E-02_JPRB,.953E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 20  14.0
ZAER (:,20, 3) = (/&
&.960E-02_JPRB,.960E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.845E-02_JPRB,.845E-02_JPRB,.653E-02_JPRB,.653E-02_JPRB,.368E-02_JPRB,&
&.368E-02_JPRB,.549E-03_JPRB,.549E-03_JPRB,.248E-03_JPRB,.248E-03_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.671E-02_JPRB,.671E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.802E-02_JPRB,&
&.802E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.262E-02_JPRB,.262E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.779E-02_JPRB,.779E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.979E-02_JPRB,.979E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 21  10.0
ZAER (:,21, 3) = (/&
&.960E-02_JPRB,.960E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.845E-02_JPRB,.845E-02_JPRB,.653E-02_JPRB,.653E-02_JPRB,.368E-02_JPRB,&
&.368E-02_JPRB,.549E-03_JPRB,.549E-03_JPRB,.248E-03_JPRB,.248E-03_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.671E-02_JPRB,.671E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.802E-02_JPRB,&
&.802E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.262E-02_JPRB,.262E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.779E-02_JPRB,.779E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.979E-02_JPRB,.979E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 22   6.0
ZAER (:,22, 3) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.134E-01_JPRB,&
&.134E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.882E-02_JPRB,.882E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.850E-03_JPRB,&
&.850E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.219E-02_JPRB,.219E-02_JPRB,&
&.818E-02_JPRB,.818E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.828E-02_JPRB,.828E-02_JPRB,.620E-02_JPRB,&
&.620E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.486E-02_JPRB,.486E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.953E-02_JPRB,.953E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,&
&.400E-02_JPRB,.400E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.546E-02_JPRB,&
&.546E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 23   2.0
ZAER (:,23, 3) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.134E-01_JPRB,&
&.134E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.882E-02_JPRB,.882E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.850E-03_JPRB,&
&.850E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.219E-02_JPRB,.219E-02_JPRB,&
&.818E-02_JPRB,.818E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.828E-02_JPRB,.828E-02_JPRB,.620E-02_JPRB,&
&.620E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.486E-02_JPRB,.486E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.953E-02_JPRB,.953E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,&
&.400E-02_JPRB,.400E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.546E-02_JPRB,&
&.546E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 24  -2.0
ZAER (:,24, 3) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.154E-01_JPRB,&
&.154E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.331E-02_JPRB,&
&.331E-02_JPRB,.219E-02_JPRB,.219E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.883E-02_JPRB,.883E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.380E-02_JPRB,&
&.380E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.460E-02_JPRB,.460E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.934E-02_JPRB,&
&.934E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,.562E-02_JPRB,.562E-02_JPRB,&
&.495E-02_JPRB,.495E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.947E-02_JPRB,&
&.947E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 25  -6.0
ZAER (:,25, 3) = (/&
&.142E-01_JPRB,.142E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.154E-01_JPRB,&
&.154E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.331E-02_JPRB,&
&.331E-02_JPRB,.219E-02_JPRB,.219E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.883E-02_JPRB,.883E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.380E-02_JPRB,&
&.380E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.460E-02_JPRB,.460E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.934E-02_JPRB,&
&.934E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,.562E-02_JPRB,.562E-02_JPRB,&
&.495E-02_JPRB,.495E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.947E-02_JPRB,&
&.947E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 26 -10.0
ZAER (:,26, 3) = (/&
&.141E-01_JPRB,.141E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.170E-01_JPRB,&
&.170E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.843E-02_JPRB,.843E-02_JPRB,.921E-02_JPRB,&
&.921E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.985E-02_JPRB,.985E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.371E-02_JPRB,&
&.371E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.271E-02_JPRB,.271E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 27 -14.0
ZAER (:,27, 3) = (/&
&.141E-01_JPRB,.141E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.170E-01_JPRB,&
&.170E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.843E-02_JPRB,.843E-02_JPRB,.921E-02_JPRB,&
&.921E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.985E-02_JPRB,.985E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.371E-02_JPRB,&
&.371E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.271E-02_JPRB,.271E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 28 -18.0
ZAER (:,28, 3) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.997E-02_JPRB,.997E-02_JPRB,.990E-02_JPRB,.990E-02_JPRB,.978E-02_JPRB,&
&.978E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.872E-02_JPRB,.872E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.383E-02_JPRB,&
&.383E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,&
&.281E-02_JPRB,.281E-02_JPRB,.314E-02_JPRB,.314E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.461E-02_JPRB,&
&.461E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.489E-02_JPRB,.489E-02_JPRB,&
&.485E-02_JPRB,.485E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.144E-01_JPRB,&
&.144E-01_JPRB,.158E-01_JPRB,.158E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 29 -22.0
ZAER (:,29, 3) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.997E-02_JPRB,.997E-02_JPRB,.990E-02_JPRB,.990E-02_JPRB,.978E-02_JPRB,&
&.978E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.872E-02_JPRB,.872E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.383E-02_JPRB,&
&.383E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,&
&.281E-02_JPRB,.281E-02_JPRB,.314E-02_JPRB,.314E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.461E-02_JPRB,&
&.461E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.489E-02_JPRB,.489E-02_JPRB,&
&.485E-02_JPRB,.485E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.144E-01_JPRB,&
&.144E-01_JPRB,.158E-01_JPRB,.158E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 30 -26.0
ZAER (:,30, 3) = (/&
&.918E-02_JPRB,.918E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.893E-02_JPRB,&
&.893E-02_JPRB,.748E-02_JPRB,.748E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,&
&.440E-02_JPRB,.440E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.814E-02_JPRB,.814E-02_JPRB,.856E-02_JPRB,&
&.856E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.932E-02_JPRB,.932E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.370E-02_JPRB,&
&.370E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,&
&.241E-02_JPRB,.241E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.199E-02_JPRB,&
&.199E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,&
&.189E-02_JPRB,.189E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.845E-02_JPRB,&
&.845E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 31 -30.0
ZAER (:,31, 3) = (/&
&.918E-02_JPRB,.918E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.893E-02_JPRB,&
&.893E-02_JPRB,.748E-02_JPRB,.748E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,&
&.440E-02_JPRB,.440E-02_JPRB,.608E-02_JPRB,.608E-02_JPRB,.814E-02_JPRB,.814E-02_JPRB,.856E-02_JPRB,&
&.856E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.932E-02_JPRB,.932E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,.370E-02_JPRB,&
&.370E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,&
&.241E-02_JPRB,.241E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.199E-02_JPRB,&
&.199E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,&
&.189E-02_JPRB,.189E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.845E-02_JPRB,&
&.845E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 32 -34.0
ZAER (:,32, 3) = (/&
&.131E-01_JPRB,.131E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.954E-02_JPRB,.954E-02_JPRB,.985E-02_JPRB,&
&.985E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.367E-02_JPRB,&
&.367E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,&
&.855E-02_JPRB,.855E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.464E-02_JPRB,&
&.464E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,&
&.270E-02_JPRB,.270E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.972E-03_JPRB,&
&.972E-03_JPRB,.813E-03_JPRB,.813E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,&
&.706E-03_JPRB,.706E-03_JPRB,.553E-03_JPRB,.553E-03_JPRB,.201E-02_JPRB,.201E-02_JPRB,.315E-02_JPRB,&
&.315E-02_JPRB,.589E-02_JPRB,.589E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 33 -38.0
ZAER (:,33, 3) = (/&
&.131E-01_JPRB,.131E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.954E-02_JPRB,.954E-02_JPRB,.985E-02_JPRB,&
&.985E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.367E-02_JPRB,&
&.367E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.800E-02_JPRB,.800E-02_JPRB,&
&.855E-02_JPRB,.855E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.464E-02_JPRB,&
&.464E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,&
&.270E-02_JPRB,.270E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.972E-03_JPRB,&
&.972E-03_JPRB,.813E-03_JPRB,.813E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,.862E-03_JPRB,&
&.706E-03_JPRB,.706E-03_JPRB,.553E-03_JPRB,.553E-03_JPRB,.201E-02_JPRB,.201E-02_JPRB,.315E-02_JPRB,&
&.315E-02_JPRB,.589E-02_JPRB,.589E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 34 -42.0
ZAER (:,34, 3) = (/&
&.149E-01_JPRB,.149E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.965E-02_JPRB,.965E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,&
&.857E-03_JPRB,.857E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.827E-03_JPRB,.827E-03_JPRB,.832E-03_JPRB,&
&.832E-03_JPRB,.259E-02_JPRB,.259E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,&
&.902E-02_JPRB,.902E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.606E-02_JPRB,&
&.606E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.719E-03_JPRB,&
&.719E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.427E-03_JPRB,.427E-03_JPRB,&
&.383E-03_JPRB,.383E-03_JPRB,.347E-03_JPRB,.347E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 35 -46.0
ZAER (:,35, 3) = (/&
&.149E-01_JPRB,.149E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.965E-02_JPRB,.965E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,&
&.857E-03_JPRB,.857E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.827E-03_JPRB,.827E-03_JPRB,.832E-03_JPRB,&
&.832E-03_JPRB,.259E-02_JPRB,.259E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,&
&.902E-02_JPRB,.902E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.606E-02_JPRB,&
&.606E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.719E-03_JPRB,&
&.719E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.427E-03_JPRB,.427E-03_JPRB,&
&.383E-03_JPRB,.383E-03_JPRB,.347E-03_JPRB,.347E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 36 -50.0
ZAER (:,36, 3) = (/&
&.141E-01_JPRB,.141E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.819E-02_JPRB,.819E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.732E-03_JPRB,.732E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.383E-02_JPRB,.383E-02_JPRB,.971E-02_JPRB,.971E-02_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.846E-03_JPRB,.846E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,.615E-03_JPRB,&
&.615E-03_JPRB,.545E-03_JPRB,.545E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.369E-03_JPRB,.369E-03_JPRB,&
&.348E-03_JPRB,.348E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.520E-03_JPRB,&
&.520E-03_JPRB,.239E-02_JPRB,.239E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.945E-02_JPRB,.945E-02_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 37 -54.0
ZAER (:,37, 3) = (/&
&.141E-01_JPRB,.141E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.819E-02_JPRB,.819E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.732E-03_JPRB,.732E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.383E-02_JPRB,.383E-02_JPRB,.971E-02_JPRB,.971E-02_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.846E-03_JPRB,.846E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,.615E-03_JPRB,&
&.615E-03_JPRB,.545E-03_JPRB,.545E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.369E-03_JPRB,.369E-03_JPRB,&
&.348E-03_JPRB,.348E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.520E-03_JPRB,&
&.520E-03_JPRB,.239E-02_JPRB,.239E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.945E-02_JPRB,.945E-02_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 38 -58.0
ZAER (:,38, 3) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.881E-02_JPRB,.881E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.645E-02_JPRB,&
&.645E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.916E-03_JPRB,.916E-03_JPRB,&
&.736E-03_JPRB,.736E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.179E-01_JPRB,.179E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.310E-02_JPRB,.310E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.931E-03_JPRB,.931E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.595E-03_JPRB,&
&.595E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.385E-03_JPRB,.385E-03_JPRB,&
&.455E-03_JPRB,.455E-03_JPRB,.520E-03_JPRB,.520E-03_JPRB,.557E-03_JPRB,.557E-03_JPRB,.740E-03_JPRB,&
&.740E-03_JPRB,.162E-02_JPRB,.162E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,&
&.814E-02_JPRB,.814E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 39 -62.0
ZAER (:,39, 3) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.881E-02_JPRB,.881E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.645E-02_JPRB,&
&.645E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.916E-03_JPRB,.916E-03_JPRB,&
&.736E-03_JPRB,.736E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.179E-01_JPRB,.179E-01_JPRB,.153E-01_JPRB,&
&.153E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.310E-02_JPRB,.310E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.931E-03_JPRB,.931E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.595E-03_JPRB,&
&.595E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.385E-03_JPRB,.385E-03_JPRB,&
&.455E-03_JPRB,.455E-03_JPRB,.520E-03_JPRB,.520E-03_JPRB,.557E-03_JPRB,.557E-03_JPRB,.740E-03_JPRB,&
&.740E-03_JPRB,.162E-02_JPRB,.162E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,&
&.814E-02_JPRB,.814E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 40 -66.0
ZAER (:,40, 3) = (/&
&.497E-02_JPRB,.497E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.270E-02_JPRB,&
&.270E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.982E-03_JPRB,.982E-03_JPRB,&
&.772E-03_JPRB,.772E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.152E-02_JPRB,&
&.152E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,&
&.275E-02_JPRB,.275E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.158E-01_JPRB,&
&.158E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.902E-02_JPRB,.902E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.291E-02_JPRB,.291E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.644E-03_JPRB,.644E-03_JPRB,.496E-03_JPRB,.496E-03_JPRB,.486E-03_JPRB,.486E-03_JPRB,&
&.581E-03_JPRB,.581E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,.849E-03_JPRB,.849E-03_JPRB,.988E-03_JPRB,&
&.988E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,&
&.382E-02_JPRB,.382E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 41 -70.0
ZAER (:,41, 3) = (/&
&.497E-02_JPRB,.497E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.270E-02_JPRB,&
&.270E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.982E-03_JPRB,.982E-03_JPRB,&
&.772E-03_JPRB,.772E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.152E-02_JPRB,&
&.152E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,&
&.275E-02_JPRB,.275E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.158E-01_JPRB,&
&.158E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.902E-02_JPRB,.902E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.291E-02_JPRB,.291E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.644E-03_JPRB,.644E-03_JPRB,.496E-03_JPRB,.496E-03_JPRB,.486E-03_JPRB,.486E-03_JPRB,&
&.581E-03_JPRB,.581E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,.849E-03_JPRB,.849E-03_JPRB,.988E-03_JPRB,&
&.988E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,&
&.382E-02_JPRB,.382E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 42 -74.0
ZAER (:,42, 3) = (/&
&.200E-02_JPRB,.200E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.626E-03_JPRB,.626E-03_JPRB,&
&.528E-03_JPRB,.528E-03_JPRB,.624E-03_JPRB,.624E-03_JPRB,.670E-03_JPRB,.670E-03_JPRB,.146E-02_JPRB,&
&.146E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.949E-02_JPRB,&
&.949E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.844E-02_JPRB,.844E-02_JPRB,.724E-02_JPRB,.724E-02_JPRB,&
&.690E-02_JPRB,.690E-02_JPRB,.569E-02_JPRB,.569E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.629E-03_JPRB,.629E-03_JPRB,&
&.649E-03_JPRB,.649E-03_JPRB,.911E-03_JPRB,.911E-03_JPRB,.227E-02_JPRB,.227E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.946E-03_JPRB,.946E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.186E-02_JPRB,.186E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 43 -78.0
ZAER (:,43, 3) = (/&
&.200E-02_JPRB,.200E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.626E-03_JPRB,.626E-03_JPRB,&
&.528E-03_JPRB,.528E-03_JPRB,.624E-03_JPRB,.624E-03_JPRB,.670E-03_JPRB,.670E-03_JPRB,.146E-02_JPRB,&
&.146E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.949E-02_JPRB,&
&.949E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.844E-02_JPRB,.844E-02_JPRB,.724E-02_JPRB,.724E-02_JPRB,&
&.690E-02_JPRB,.690E-02_JPRB,.569E-02_JPRB,.569E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.629E-03_JPRB,.629E-03_JPRB,&
&.649E-03_JPRB,.649E-03_JPRB,.911E-03_JPRB,.911E-03_JPRB,.227E-02_JPRB,.227E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.946E-03_JPRB,.946E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.186E-02_JPRB,.186E-02_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 44 -82.0
ZAER (:,44, 3) = (/&
&.476E-03_JPRB,.476E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,.558E-03_JPRB,&
&.558E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,.615E-03_JPRB,.615E-03_JPRB,.603E-03_JPRB,.603E-03_JPRB,&
&.642E-03_JPRB,.642E-03_JPRB,.725E-03_JPRB,.725E-03_JPRB,.833E-03_JPRB,.833E-03_JPRB,.947E-03_JPRB,&
&.947E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.239E-02_JPRB,&
&.239E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.252E-02_JPRB,.252E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,&
&.950E-03_JPRB,.950E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.660E-03_JPRB,&
&.660E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.622E-03_JPRB,.622E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,&
&.657E-03_JPRB,.657E-03_JPRB,.784E-03_JPRB,.784E-03_JPRB,.940E-03_JPRB,.940E-03_JPRB,.942E-03_JPRB,&
&.942E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.538E-03_JPRB,.538E-03_JPRB,&
&.515E-03_JPRB,.515E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 45 -86.0
ZAER (:,45, 3) = (/&
&.476E-03_JPRB,.476E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,.558E-03_JPRB,&
&.558E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,.615E-03_JPRB,.615E-03_JPRB,.603E-03_JPRB,.603E-03_JPRB,&
&.642E-03_JPRB,.642E-03_JPRB,.725E-03_JPRB,.725E-03_JPRB,.833E-03_JPRB,.833E-03_JPRB,.947E-03_JPRB,&
&.947E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.239E-02_JPRB,&
&.239E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.252E-02_JPRB,.252E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,&
&.950E-03_JPRB,.950E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.660E-03_JPRB,&
&.660E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.622E-03_JPRB,.622E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,&
&.657E-03_JPRB,.657E-03_JPRB,.784E-03_JPRB,.784E-03_JPRB,.940E-03_JPRB,.940E-03_JPRB,.942E-03_JPRB,&
&.942E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.538E-03_JPRB,.538E-03_JPRB,&
&.515E-03_JPRB,.515E-03_JPRB/)
!-- Sea Salt Aerosol         month:  3 --- lat: 46 -90.0
ZAER (:,46, 3) = (/&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,.531E-03_JPRB,&
&.531E-03_JPRB,.531E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  1  90.0
ZAER (:, 1, 4) = (/&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,&
&.257E-03_JPRB,.257E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  2  86.0
ZAER (:, 2, 4) = (/&
&.374E-03_JPRB,.374E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.442E-03_JPRB,&
&.442E-03_JPRB,.460E-03_JPRB,.460E-03_JPRB,.485E-03_JPRB,.485E-03_JPRB,.514E-03_JPRB,.514E-03_JPRB,&
&.537E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.532E-03_JPRB,.532E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,&
&.471E-03_JPRB,.471E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.365E-03_JPRB,.365E-03_JPRB,.285E-03_JPRB,&
&.285E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,.183E-03_JPRB,&
&.183E-03_JPRB,.186E-03_JPRB,.186E-03_JPRB,.187E-03_JPRB,.187E-03_JPRB,.188E-03_JPRB,.188E-03_JPRB,&
&.194E-03_JPRB,.194E-03_JPRB,.206E-03_JPRB,.206E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.242E-03_JPRB,&
&.242E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,.325E-03_JPRB,.325E-03_JPRB,&
&.351E-03_JPRB,.351E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  3  82.0
ZAER (:, 3, 4) = (/&
&.374E-03_JPRB,.374E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.442E-03_JPRB,&
&.442E-03_JPRB,.460E-03_JPRB,.460E-03_JPRB,.485E-03_JPRB,.485E-03_JPRB,.514E-03_JPRB,.514E-03_JPRB,&
&.537E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.532E-03_JPRB,.532E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,&
&.471E-03_JPRB,.471E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.365E-03_JPRB,.365E-03_JPRB,.285E-03_JPRB,&
&.285E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.144E-03_JPRB,.144E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,.183E-03_JPRB,&
&.183E-03_JPRB,.186E-03_JPRB,.186E-03_JPRB,.187E-03_JPRB,.187E-03_JPRB,.188E-03_JPRB,.188E-03_JPRB,&
&.194E-03_JPRB,.194E-03_JPRB,.206E-03_JPRB,.206E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.242E-03_JPRB,&
&.242E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,.325E-03_JPRB,.325E-03_JPRB,&
&.351E-03_JPRB,.351E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  4  78.0
ZAER (:, 4, 4) = (/&
&.560E-03_JPRB,.560E-03_JPRB,.990E-03_JPRB,.990E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,.863E-03_JPRB,&
&.863E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,.542E-03_JPRB,.542E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.715E-03_JPRB,.715E-03_JPRB,.802E-03_JPRB,.802E-03_JPRB,.864E-03_JPRB,&
&.864E-03_JPRB,.887E-03_JPRB,.887E-03_JPRB,.864E-03_JPRB,.864E-03_JPRB,.783E-03_JPRB,.783E-03_JPRB,&
&.666E-03_JPRB,.666E-03_JPRB,.599E-03_JPRB,.599E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.411E-03_JPRB,&
&.411E-03_JPRB,.293E-03_JPRB,.293E-03_JPRB,.174E-03_JPRB,.174E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,&
&.224E-03_JPRB,.224E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.352E-03_JPRB,&
&.352E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.322E-03_JPRB,.322E-03_JPRB,&
&.314E-03_JPRB,.314E-03_JPRB,.280E-03_JPRB,.280E-03_JPRB,.246E-03_JPRB,.246E-03_JPRB,.274E-03_JPRB,&
&.274E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,&
&.437E-03_JPRB,.437E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  5  74.0
ZAER (:, 5, 4) = (/&
&.560E-03_JPRB,.560E-03_JPRB,.990E-03_JPRB,.990E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,.863E-03_JPRB,&
&.863E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,.542E-03_JPRB,.542E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.715E-03_JPRB,.715E-03_JPRB,.802E-03_JPRB,.802E-03_JPRB,.864E-03_JPRB,&
&.864E-03_JPRB,.887E-03_JPRB,.887E-03_JPRB,.864E-03_JPRB,.864E-03_JPRB,.783E-03_JPRB,.783E-03_JPRB,&
&.666E-03_JPRB,.666E-03_JPRB,.599E-03_JPRB,.599E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.411E-03_JPRB,&
&.411E-03_JPRB,.293E-03_JPRB,.293E-03_JPRB,.174E-03_JPRB,.174E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,&
&.224E-03_JPRB,.224E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.352E-03_JPRB,&
&.352E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.322E-03_JPRB,.322E-03_JPRB,&
&.314E-03_JPRB,.314E-03_JPRB,.280E-03_JPRB,.280E-03_JPRB,.246E-03_JPRB,.246E-03_JPRB,.274E-03_JPRB,&
&.274E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,&
&.437E-03_JPRB,.437E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  6  70.0
ZAER (:, 6, 4) = (/&
&.270E-02_JPRB,.270E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.227E-02_JPRB,&
&.227E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.187E-02_JPRB,.187E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.201E-02_JPRB,.201E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,&
&.111E-02_JPRB,.111E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,.527E-03_JPRB,&
&.527E-03_JPRB,.412E-03_JPRB,.412E-03_JPRB,.306E-03_JPRB,.306E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,&
&.405E-03_JPRB,.405E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.811E-03_JPRB,.811E-03_JPRB,.867E-03_JPRB,&
&.867E-03_JPRB,.975E-03_JPRB,.975E-03_JPRB,.969E-03_JPRB,.969E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.175E-02_JPRB,.175E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  7  66.0
ZAER (:, 7, 4) = (/&
&.270E-02_JPRB,.270E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.227E-02_JPRB,&
&.227E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.187E-02_JPRB,.187E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.246E-02_JPRB,&
&.246E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.201E-02_JPRB,.201E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,&
&.111E-02_JPRB,.111E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,.527E-03_JPRB,&
&.527E-03_JPRB,.412E-03_JPRB,.412E-03_JPRB,.306E-03_JPRB,.306E-03_JPRB,.294E-03_JPRB,.294E-03_JPRB,&
&.405E-03_JPRB,.405E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.811E-03_JPRB,.811E-03_JPRB,.867E-03_JPRB,&
&.867E-03_JPRB,.975E-03_JPRB,.975E-03_JPRB,.969E-03_JPRB,.969E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.175E-02_JPRB,.175E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  8  62.0
ZAER (:, 8, 4) = (/&
&.871E-02_JPRB,.871E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.586E-02_JPRB,&
&.586E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.994E-02_JPRB,&
&.994E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,&
&.238E-02_JPRB,.238E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.397E-02_JPRB,&
&.397E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.330E-02_JPRB,.330E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,&
&.707E-02_JPRB,.707E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.781E-02_JPRB,&
&.781E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,&
&.841E-02_JPRB,.841E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat:  9  58.0
ZAER (:, 9, 4) = (/&
&.871E-02_JPRB,.871E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.586E-02_JPRB,&
&.586E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.994E-02_JPRB,&
&.994E-02_JPRB,.802E-02_JPRB,.802E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,&
&.238E-02_JPRB,.238E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.397E-02_JPRB,&
&.397E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.330E-02_JPRB,.330E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,&
&.707E-02_JPRB,.707E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.781E-02_JPRB,&
&.781E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,&
&.841E-02_JPRB,.841E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 10  54.0
ZAER (:,10, 4) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.845E-02_JPRB,.845E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,&
&.864E-02_JPRB,.864E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.821E-02_JPRB,.821E-02_JPRB,.937E-02_JPRB,.937E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.885E-02_JPRB,.885E-02_JPRB,.714E-02_JPRB,&
&.714E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.962E-02_JPRB,.962E-02_JPRB,.952E-02_JPRB,&
&.952E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,&
&.836E-02_JPRB,.836E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 11  50.0
ZAER (:,11, 4) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.845E-02_JPRB,.845E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,&
&.864E-02_JPRB,.864E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.821E-02_JPRB,.821E-02_JPRB,.937E-02_JPRB,.937E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.885E-02_JPRB,.885E-02_JPRB,.714E-02_JPRB,&
&.714E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,&
&.770E-02_JPRB,.770E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.962E-02_JPRB,.962E-02_JPRB,.952E-02_JPRB,&
&.952E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,&
&.836E-02_JPRB,.836E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 12  46.0
ZAER (:,12, 4) = (/&
&.995E-02_JPRB,.995E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.912E-02_JPRB,&
&.912E-02_JPRB,.857E-02_JPRB,.857E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,&
&.807E-02_JPRB,.807E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.136E-01_JPRB,.136E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.915E-02_JPRB,.915E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,&
&.921E-02_JPRB,.921E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.861E-02_JPRB,&
&.861E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,&
&.857E-02_JPRB,.857E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.930E-02_JPRB,&
&.930E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.788E-02_JPRB,.788E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 13  42.0
ZAER (:,13, 4) = (/&
&.995E-02_JPRB,.995E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.912E-02_JPRB,&
&.912E-02_JPRB,.857E-02_JPRB,.857E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,&
&.807E-02_JPRB,.807E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.136E-01_JPRB,.136E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.915E-02_JPRB,.915E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,&
&.921E-02_JPRB,.921E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.861E-02_JPRB,&
&.861E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,&
&.857E-02_JPRB,.857E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.930E-02_JPRB,&
&.930E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.788E-02_JPRB,.788E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 14  38.0
ZAER (:,14, 4) = (/&
&.829E-02_JPRB,.829E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.833E-02_JPRB,&
&.833E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,&
&.833E-02_JPRB,.833E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,.706E-02_JPRB,&
&.706E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.946E-02_JPRB,.946E-02_JPRB,.988E-02_JPRB,&
&.988E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB,.817E-02_JPRB,.817E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.652E-02_JPRB,&
&.652E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 15  34.0
ZAER (:,15, 4) = (/&
&.829E-02_JPRB,.829E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.833E-02_JPRB,&
&.833E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,&
&.833E-02_JPRB,.833E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,.706E-02_JPRB,&
&.706E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.946E-02_JPRB,.946E-02_JPRB,.988E-02_JPRB,&
&.988E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB,.817E-02_JPRB,.817E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.652E-02_JPRB,&
&.652E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 16  30.0
ZAER (:,16, 4) = (/&
&.816E-02_JPRB,.816E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.945E-02_JPRB,.945E-02_JPRB,&
&.993E-02_JPRB,.993E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.857E-02_JPRB,&
&.857E-02_JPRB,.527E-02_JPRB,.527E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.555E-02_JPRB,.555E-02_JPRB,&
&.802E-02_JPRB,.802E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.905E-02_JPRB,&
&.905E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.938E-02_JPRB,&
&.938E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.921E-02_JPRB,.921E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.395E-02_JPRB,.395E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 17  26.0
ZAER (:,17, 4) = (/&
&.816E-02_JPRB,.816E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.945E-02_JPRB,.945E-02_JPRB,&
&.993E-02_JPRB,.993E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.857E-02_JPRB,&
&.857E-02_JPRB,.527E-02_JPRB,.527E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.555E-02_JPRB,.555E-02_JPRB,&
&.802E-02_JPRB,.802E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.905E-02_JPRB,&
&.905E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.938E-02_JPRB,&
&.938E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.921E-02_JPRB,.921E-02_JPRB,.558E-02_JPRB,.558E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.395E-02_JPRB,.395E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 18  22.0
ZAER (:,18, 4) = (/&
&.887E-02_JPRB,.887E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.862E-02_JPRB,&
&.862E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.901E-02_JPRB,&
&.901E-02_JPRB,.487E-02_JPRB,.487E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.900E-02_JPRB,&
&.900E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.521E-02_JPRB,.521E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,&
&.429E-02_JPRB,.429E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.716E-02_JPRB,.716E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.889E-02_JPRB,.889E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 19  18.0
ZAER (:,19, 4) = (/&
&.887E-02_JPRB,.887E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.862E-02_JPRB,&
&.862E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.901E-02_JPRB,&
&.901E-02_JPRB,.487E-02_JPRB,.487E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.900E-02_JPRB,&
&.900E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.521E-02_JPRB,.521E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,&
&.429E-02_JPRB,.429E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.716E-02_JPRB,.716E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.889E-02_JPRB,.889E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 20  14.0
ZAER (:,20, 4) = (/&
&.925E-02_JPRB,.925E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.817E-02_JPRB,.817E-02_JPRB,.427E-02_JPRB,&
&.427E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.302E-02_JPRB,.302E-02_JPRB,&
&.756E-02_JPRB,.756E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.664E-02_JPRB,.664E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,&
&.284E-02_JPRB,.284E-02_JPRB,.639E-02_JPRB,.639E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.972E-02_JPRB,.972E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.727E-02_JPRB,.727E-02_JPRB,.542E-02_JPRB,&
&.542E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,&
&.859E-02_JPRB,.859E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 21  10.0
ZAER (:,21, 4) = (/&
&.925E-02_JPRB,.925E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.817E-02_JPRB,.817E-02_JPRB,.427E-02_JPRB,&
&.427E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.302E-02_JPRB,.302E-02_JPRB,&
&.756E-02_JPRB,.756E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.664E-02_JPRB,.664E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,&
&.284E-02_JPRB,.284E-02_JPRB,.639E-02_JPRB,.639E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.972E-02_JPRB,.972E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.727E-02_JPRB,.727E-02_JPRB,.542E-02_JPRB,&
&.542E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,&
&.859E-02_JPRB,.859E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 22   6.0
ZAER (:,22, 4) = (/&
&.111E-01_JPRB,.111E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.741E-02_JPRB,.741E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.969E-03_JPRB,&
&.969E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.627E-02_JPRB,.627E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.760E-02_JPRB,&
&.760E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.537E-02_JPRB,.537E-02_JPRB,.937E-02_JPRB,.937E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.935E-02_JPRB,&
&.935E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.521E-02_JPRB,.521E-02_JPRB,&
&.436E-02_JPRB,.436E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.397E-02_JPRB,&
&.397E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 23   2.0
ZAER (:,23, 4) = (/&
&.111E-01_JPRB,.111E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.741E-02_JPRB,.741E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.969E-03_JPRB,&
&.969E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.627E-02_JPRB,.627E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.760E-02_JPRB,&
&.760E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.537E-02_JPRB,.537E-02_JPRB,.937E-02_JPRB,.937E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.935E-02_JPRB,&
&.935E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.521E-02_JPRB,.521E-02_JPRB,&
&.436E-02_JPRB,.436E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.397E-02_JPRB,&
&.397E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 24  -2.0
ZAER (:,24, 4) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.876E-02_JPRB,.876E-02_JPRB,.696E-02_JPRB,.696E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,&
&.998E-02_JPRB,.998E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.327E-02_JPRB,&
&.327E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,&
&.420E-02_JPRB,.420E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.572E-02_JPRB,.572E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.773E-02_JPRB,&
&.773E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 25  -6.0
ZAER (:,25, 4) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.876E-02_JPRB,.876E-02_JPRB,.696E-02_JPRB,.696E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,&
&.998E-02_JPRB,.998E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.327E-02_JPRB,&
&.327E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,&
&.420E-02_JPRB,.420E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.572E-02_JPRB,.572E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.773E-02_JPRB,&
&.773E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 26 -10.0
ZAER (:,26, 4) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.145E-01_JPRB,&
&.145E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.835E-02_JPRB,.835E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.853E-02_JPRB,&
&.853E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.943E-02_JPRB,.943E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.253E-02_JPRB,&
&.253E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,&
&.572E-02_JPRB,.572E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 27 -14.0
ZAER (:,27, 4) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.145E-01_JPRB,&
&.145E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.835E-02_JPRB,.835E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.853E-02_JPRB,&
&.853E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.943E-02_JPRB,.943E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.253E-02_JPRB,&
&.253E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.579E-02_JPRB,&
&.579E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,&
&.572E-02_JPRB,.572E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 28 -18.0
ZAER (:,28, 4) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.988E-02_JPRB,.988E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,&
&.940E-02_JPRB,.940E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.909E-02_JPRB,&
&.909E-02_JPRB,.999E-02_JPRB,.999E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.966E-02_JPRB,.966E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,.274E-02_JPRB,&
&.274E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.222E-02_JPRB,.222E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.192E-02_JPRB,.192E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.432E-02_JPRB,&
&.432E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.352E-02_JPRB,.352E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,&
&.373E-02_JPRB,.373E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 29 -22.0
ZAER (:,29, 4) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.988E-02_JPRB,.988E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,&
&.940E-02_JPRB,.940E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.909E-02_JPRB,&
&.909E-02_JPRB,.999E-02_JPRB,.999E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.966E-02_JPRB,.966E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,.274E-02_JPRB,&
&.274E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.222E-02_JPRB,.222E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.192E-02_JPRB,.192E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.432E-02_JPRB,&
&.432E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.352E-02_JPRB,.352E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,&
&.373E-02_JPRB,.373E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 30 -26.0
ZAER (:,30, 4) = (/&
&.783E-02_JPRB,.783E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.640E-02_JPRB,.640E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,&
&.411E-02_JPRB,.411E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.754E-02_JPRB,&
&.754E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,&
&.953E-02_JPRB,.953E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.345E-02_JPRB,&
&.345E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.250E-02_JPRB,.250E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,&
&.222E-02_JPRB,.222E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.173E-02_JPRB,&
&.173E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.154E-02_JPRB,.154E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.721E-02_JPRB,&
&.721E-02_JPRB,.806E-02_JPRB,.806E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 31 -30.0
ZAER (:,31, 4) = (/&
&.783E-02_JPRB,.783E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.640E-02_JPRB,.640E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,&
&.411E-02_JPRB,.411E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.754E-02_JPRB,&
&.754E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,&
&.953E-02_JPRB,.953E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.345E-02_JPRB,&
&.345E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.250E-02_JPRB,.250E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,&
&.222E-02_JPRB,.222E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.173E-02_JPRB,&
&.173E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,&
&.154E-02_JPRB,.154E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.721E-02_JPRB,&
&.721E-02_JPRB,.806E-02_JPRB,.806E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.876E-02_JPRB,.876E-02_JPRB,&
&.845E-02_JPRB,.845E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 32 -34.0
ZAER (:,32, 4) = (/&
&.774E-02_JPRB,.774E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.789E-02_JPRB,&
&.789E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,&
&.111E-02_JPRB,.111E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.297E-02_JPRB,&
&.297E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,&
&.870E-02_JPRB,.870E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.500E-02_JPRB,&
&.500E-02_JPRB,.327E-02_JPRB,.327E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,&
&.295E-02_JPRB,.295E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.887E-03_JPRB,.887E-03_JPRB,.984E-03_JPRB,.984E-03_JPRB,.965E-03_JPRB,.965E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.674E-03_JPRB,.674E-03_JPRB,.206E-02_JPRB,.206E-02_JPRB,.349E-02_JPRB,&
&.349E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,&
&.825E-02_JPRB,.825E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 33 -38.0
ZAER (:,33, 4) = (/&
&.774E-02_JPRB,.774E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.789E-02_JPRB,&
&.789E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,&
&.111E-02_JPRB,.111E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.297E-02_JPRB,&
&.297E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,&
&.870E-02_JPRB,.870E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.500E-02_JPRB,&
&.500E-02_JPRB,.327E-02_JPRB,.327E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,&
&.295E-02_JPRB,.295E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.887E-03_JPRB,.887E-03_JPRB,.984E-03_JPRB,.984E-03_JPRB,.965E-03_JPRB,.965E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.674E-03_JPRB,.674E-03_JPRB,.206E-02_JPRB,.206E-02_JPRB,.349E-02_JPRB,&
&.349E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,&
&.825E-02_JPRB,.825E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 34 -42.0
ZAER (:,34, 4) = (/&
&.716E-02_JPRB,.716E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.864E-02_JPRB,&
&.864E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.738E-03_JPRB,.738E-03_JPRB,.451E-03_JPRB,.451E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,.588E-03_JPRB,&
&.588E-03_JPRB,.219E-02_JPRB,.219E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.934E-02_JPRB,.934E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.615E-02_JPRB,&
&.615E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,&
&.243E-02_JPRB,.243E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.924E-03_JPRB,&
&.924E-03_JPRB,.679E-03_JPRB,.679E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,&
&.518E-03_JPRB,.518E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.175E-02_JPRB,&
&.175E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,&
&.693E-02_JPRB,.693E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 35 -46.0
ZAER (:,35, 4) = (/&
&.716E-02_JPRB,.716E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,.864E-02_JPRB,&
&.864E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.738E-03_JPRB,.738E-03_JPRB,.451E-03_JPRB,.451E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,.588E-03_JPRB,&
&.588E-03_JPRB,.219E-02_JPRB,.219E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.934E-02_JPRB,.934E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.615E-02_JPRB,&
&.615E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,&
&.243E-02_JPRB,.243E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.924E-03_JPRB,&
&.924E-03_JPRB,.679E-03_JPRB,.679E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,&
&.518E-03_JPRB,.518E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.175E-02_JPRB,&
&.175E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,&
&.693E-02_JPRB,.693E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 36 -50.0
ZAER (:,36, 4) = (/&
&.646E-02_JPRB,.646E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.692E-02_JPRB,&
&.692E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,&
&.570E-03_JPRB,.570E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.816E-03_JPRB,.816E-03_JPRB,.727E-03_JPRB,&
&.727E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,.336E-02_JPRB,.336E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.999E-02_JPRB,.999E-02_JPRB,.724E-02_JPRB,&
&.724E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,&
&.989E-03_JPRB,.989E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.988E-03_JPRB,.988E-03_JPRB,.856E-03_JPRB,&
&.856E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.496E-03_JPRB,.496E-03_JPRB,&
&.418E-03_JPRB,.418E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.603E-03_JPRB,&
&.603E-03_JPRB,.236E-02_JPRB,.236E-02_JPRB,.457E-02_JPRB,.457E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,&
&.570E-02_JPRB,.570E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 37 -54.0
ZAER (:,37, 4) = (/&
&.646E-02_JPRB,.646E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.692E-02_JPRB,&
&.692E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,&
&.570E-03_JPRB,.570E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.816E-03_JPRB,.816E-03_JPRB,.727E-03_JPRB,&
&.727E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,.336E-02_JPRB,.336E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.999E-02_JPRB,.999E-02_JPRB,.724E-02_JPRB,&
&.724E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,&
&.989E-03_JPRB,.989E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.988E-03_JPRB,.988E-03_JPRB,.856E-03_JPRB,&
&.856E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.583E-03_JPRB,.583E-03_JPRB,.496E-03_JPRB,.496E-03_JPRB,&
&.418E-03_JPRB,.418E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.603E-03_JPRB,&
&.603E-03_JPRB,.236E-02_JPRB,.236E-02_JPRB,.457E-02_JPRB,.457E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,&
&.570E-02_JPRB,.570E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 38 -58.0
ZAER (:,38, 4) = (/&
&.432E-02_JPRB,.432E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.299E-02_JPRB,&
&.299E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.812E-03_JPRB,.812E-03_JPRB,&
&.570E-03_JPRB,.570E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.287E-02_JPRB,.287E-02_JPRB,.157E-02_JPRB,&
&.157E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.920E-02_JPRB,.920E-02_JPRB,.123E-01_JPRB,.123E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.990E-02_JPRB,&
&.990E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.934E-03_JPRB,&
&.934E-03_JPRB,.784E-03_JPRB,.784E-03_JPRB,.619E-03_JPRB,.619E-03_JPRB,.487E-03_JPRB,.487E-03_JPRB,&
&.409E-03_JPRB,.409E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.315E-03_JPRB,.315E-03_JPRB,.534E-03_JPRB,&
&.534E-03_JPRB,.150E-02_JPRB,.150E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.338E-02_JPRB,.338E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 39 -62.0
ZAER (:,39, 4) = (/&
&.432E-02_JPRB,.432E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.299E-02_JPRB,&
&.299E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.812E-03_JPRB,.812E-03_JPRB,&
&.570E-03_JPRB,.570E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.287E-02_JPRB,.287E-02_JPRB,.157E-02_JPRB,&
&.157E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.920E-02_JPRB,.920E-02_JPRB,.123E-01_JPRB,.123E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.990E-02_JPRB,&
&.990E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.934E-03_JPRB,&
&.934E-03_JPRB,.784E-03_JPRB,.784E-03_JPRB,.619E-03_JPRB,.619E-03_JPRB,.487E-03_JPRB,.487E-03_JPRB,&
&.409E-03_JPRB,.409E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.315E-03_JPRB,.315E-03_JPRB,.534E-03_JPRB,&
&.534E-03_JPRB,.150E-02_JPRB,.150E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.338E-02_JPRB,.338E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 40 -66.0
ZAER (:,40, 4) = (/&
&.169E-02_JPRB,.169E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.803E-03_JPRB,.803E-03_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.885E-03_JPRB,.885E-03_JPRB,&
&.645E-03_JPRB,.645E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.832E-03_JPRB,&
&.832E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,&
&.321E-02_JPRB,.321E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.974E-02_JPRB,&
&.974E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.667E-02_JPRB,.667E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,&
&.279E-02_JPRB,.279E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.147E-02_JPRB,&
&.147E-02_JPRB,.934E-03_JPRB,.934E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.424E-03_JPRB,.424E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.394E-03_JPRB,&
&.394E-03_JPRB,.457E-03_JPRB,.457E-03_JPRB,.574E-03_JPRB,.574E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 41 -70.0
ZAER (:,41, 4) = (/&
&.169E-02_JPRB,.169E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.803E-03_JPRB,.803E-03_JPRB,.108E-02_JPRB,&
&.108E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.885E-03_JPRB,.885E-03_JPRB,&
&.645E-03_JPRB,.645E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.832E-03_JPRB,&
&.832E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,&
&.321E-02_JPRB,.321E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.974E-02_JPRB,&
&.974E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.667E-02_JPRB,.667E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,&
&.279E-02_JPRB,.279E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.147E-02_JPRB,&
&.147E-02_JPRB,.934E-03_JPRB,.934E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.424E-03_JPRB,.424E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.394E-03_JPRB,&
&.394E-03_JPRB,.457E-03_JPRB,.457E-03_JPRB,.574E-03_JPRB,.574E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 42 -74.0
ZAER (:,42, 4) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.608E-03_JPRB,.608E-03_JPRB,.672E-03_JPRB,&
&.672E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.629E-03_JPRB,.629E-03_JPRB,&
&.565E-03_JPRB,.565E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,.565E-03_JPRB,.565E-03_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,&
&.521E-02_JPRB,.521E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,.176E-02_JPRB,&
&.176E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.485E-03_JPRB,.485E-03_JPRB,&
&.481E-03_JPRB,.481E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,.212E-02_JPRB,.212E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.556E-03_JPRB,.556E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.650E-03_JPRB,.650E-03_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 43 -78.0
ZAER (:,43, 4) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.608E-03_JPRB,.608E-03_JPRB,.672E-03_JPRB,&
&.672E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.629E-03_JPRB,.629E-03_JPRB,&
&.565E-03_JPRB,.565E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,.565E-03_JPRB,.565E-03_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,&
&.521E-02_JPRB,.521E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,.176E-02_JPRB,&
&.176E-02_JPRB,.262E-02_JPRB,.262E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,.485E-03_JPRB,.485E-03_JPRB,&
&.481E-03_JPRB,.481E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,.212E-02_JPRB,.212E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.556E-03_JPRB,.556E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.650E-03_JPRB,.650E-03_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 44 -82.0
ZAER (:,44, 4) = (/&
&.476E-03_JPRB,.476E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.490E-03_JPRB,.490E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.632E-03_JPRB,.632E-03_JPRB,.775E-03_JPRB,&
&.775E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.968E-03_JPRB,.968E-03_JPRB,.108E-02_JPRB,.108E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.212E-02_JPRB,&
&.212E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.824E-03_JPRB,.824E-03_JPRB,.717E-03_JPRB,.717E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.659E-03_JPRB,&
&.659E-03_JPRB,.691E-03_JPRB,.691E-03_JPRB,.634E-03_JPRB,.634E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,&
&.710E-03_JPRB,.710E-03_JPRB,.893E-03_JPRB,.893E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.940E-03_JPRB,&
&.940E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,&
&.476E-03_JPRB,.476E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 45 -86.0
ZAER (:,45, 4) = (/&
&.476E-03_JPRB,.476E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,&
&.490E-03_JPRB,.490E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.632E-03_JPRB,.632E-03_JPRB,.775E-03_JPRB,&
&.775E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.968E-03_JPRB,.968E-03_JPRB,.108E-02_JPRB,.108E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.212E-02_JPRB,&
&.212E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.824E-03_JPRB,.824E-03_JPRB,.717E-03_JPRB,.717E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.659E-03_JPRB,&
&.659E-03_JPRB,.691E-03_JPRB,.691E-03_JPRB,.634E-03_JPRB,.634E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,&
&.710E-03_JPRB,.710E-03_JPRB,.893E-03_JPRB,.893E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.940E-03_JPRB,&
&.940E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,&
&.476E-03_JPRB,.476E-03_JPRB/)
!-- Sea Salt Aerosol         month:  4 --- lat: 46 -90.0
ZAER (:,46, 4) = (/&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,.690E-03_JPRB,&
&.690E-03_JPRB,.690E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  1  90.0
ZAER (:, 1, 5) = (/&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,.320E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  2  86.0
ZAER (:, 2, 5) = (/&
&.505E-03_JPRB,.505E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.525E-03_JPRB,&
&.525E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.503E-03_JPRB,.503E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,&
&.494E-03_JPRB,.494E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.535E-03_JPRB,&
&.535E-03_JPRB,.602E-03_JPRB,.602E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,&
&.633E-03_JPRB,.633E-03_JPRB,.561E-03_JPRB,.561E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.387E-03_JPRB,&
&.387E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.348E-03_JPRB,.348E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,&
&.371E-03_JPRB,.371E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.398E-03_JPRB,&
&.398E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,&
&.357E-03_JPRB,.357E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.339E-03_JPRB,&
&.339E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.371E-03_JPRB,.371E-03_JPRB,.410E-03_JPRB,.410E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  3  82.0
ZAER (:, 3, 5) = (/&
&.505E-03_JPRB,.505E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.524E-03_JPRB,.525E-03_JPRB,&
&.525E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.503E-03_JPRB,.503E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,&
&.494E-03_JPRB,.494E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.535E-03_JPRB,&
&.535E-03_JPRB,.602E-03_JPRB,.602E-03_JPRB,.655E-03_JPRB,.655E-03_JPRB,.678E-03_JPRB,.678E-03_JPRB,&
&.633E-03_JPRB,.633E-03_JPRB,.561E-03_JPRB,.561E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.387E-03_JPRB,&
&.387E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.348E-03_JPRB,.348E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,&
&.371E-03_JPRB,.371E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.398E-03_JPRB,&
&.398E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,&
&.357E-03_JPRB,.357E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.339E-03_JPRB,&
&.339E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.371E-03_JPRB,.371E-03_JPRB,.410E-03_JPRB,.410E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  4  78.0
ZAER (:, 4, 5) = (/&
&.114E-02_JPRB,.114E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.909E-03_JPRB,.909E-03_JPRB,.848E-03_JPRB,&
&.848E-03_JPRB,.831E-03_JPRB,.831E-03_JPRB,.821E-03_JPRB,.821E-03_JPRB,.746E-03_JPRB,.746E-03_JPRB,&
&.671E-03_JPRB,.671E-03_JPRB,.639E-03_JPRB,.639E-03_JPRB,.604E-03_JPRB,.604E-03_JPRB,.760E-03_JPRB,&
&.760E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.126E-02_JPRB,.126E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.856E-03_JPRB,.856E-03_JPRB,.545E-03_JPRB,&
&.545E-03_JPRB,.348E-03_JPRB,.348E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.410E-03_JPRB,.410E-03_JPRB,&
&.526E-03_JPRB,.526E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.644E-03_JPRB,&
&.644E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,&
&.496E-03_JPRB,.496E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.491E-03_JPRB,&
&.491E-03_JPRB,.539E-03_JPRB,.539E-03_JPRB,.556E-03_JPRB,.556E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,&
&.757E-03_JPRB,.757E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  5  74.0
ZAER (:, 5, 5) = (/&
&.114E-02_JPRB,.114E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.909E-03_JPRB,.909E-03_JPRB,.848E-03_JPRB,&
&.848E-03_JPRB,.831E-03_JPRB,.831E-03_JPRB,.821E-03_JPRB,.821E-03_JPRB,.746E-03_JPRB,.746E-03_JPRB,&
&.671E-03_JPRB,.671E-03_JPRB,.639E-03_JPRB,.639E-03_JPRB,.604E-03_JPRB,.604E-03_JPRB,.760E-03_JPRB,&
&.760E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.126E-02_JPRB,.126E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.856E-03_JPRB,.856E-03_JPRB,.545E-03_JPRB,&
&.545E-03_JPRB,.348E-03_JPRB,.348E-03_JPRB,.349E-03_JPRB,.349E-03_JPRB,.410E-03_JPRB,.410E-03_JPRB,&
&.526E-03_JPRB,.526E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.644E-03_JPRB,&
&.644E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.530E-03_JPRB,.530E-03_JPRB,&
&.496E-03_JPRB,.496E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.491E-03_JPRB,&
&.491E-03_JPRB,.539E-03_JPRB,.539E-03_JPRB,.556E-03_JPRB,.556E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,&
&.757E-03_JPRB,.757E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  6  70.0
ZAER (:, 6, 5) = (/&
&.337E-02_JPRB,.337E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,&
&.167E-02_JPRB,.167E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,.990E-03_JPRB,&
&.990E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,&
&.180E-02_JPRB,.180E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.965E-03_JPRB,&
&.965E-03_JPRB,.649E-03_JPRB,.649E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,&
&.659E-03_JPRB,.659E-03_JPRB,.927E-03_JPRB,.927E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.142E-02_JPRB,&
&.142E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.138E-02_JPRB,&
&.138E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.194E-02_JPRB,.194E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  7  66.0
ZAER (:, 7, 5) = (/&
&.337E-02_JPRB,.337E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,&
&.167E-02_JPRB,.167E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,.990E-03_JPRB,&
&.990E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,&
&.180E-02_JPRB,.180E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.965E-03_JPRB,&
&.965E-03_JPRB,.649E-03_JPRB,.649E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,&
&.659E-03_JPRB,.659E-03_JPRB,.927E-03_JPRB,.927E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.142E-02_JPRB,&
&.142E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.138E-02_JPRB,&
&.138E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.194E-02_JPRB,.194E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  8  62.0
ZAER (:, 8, 5) = (/&
&.804E-02_JPRB,.804E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.664E-02_JPRB,.664E-02_JPRB,.472E-02_JPRB,&
&.472E-02_JPRB,.640E-02_JPRB,.640E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.929E-02_JPRB,.929E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.602E-02_JPRB,.602E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.362E-02_JPRB,.362E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.132E-02_JPRB,.132E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,&
&.791E-02_JPRB,.791E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,.709E-02_JPRB,&
&.709E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,&
&.813E-02_JPRB,.813E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat:  9  58.0
ZAER (:, 9, 5) = (/&
&.804E-02_JPRB,.804E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.664E-02_JPRB,.664E-02_JPRB,.472E-02_JPRB,&
&.472E-02_JPRB,.640E-02_JPRB,.640E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.929E-02_JPRB,.929E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.602E-02_JPRB,.602E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.362E-02_JPRB,.362E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.132E-02_JPRB,.132E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,&
&.791E-02_JPRB,.791E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.820E-02_JPRB,.820E-02_JPRB,.709E-02_JPRB,&
&.709E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,&
&.813E-02_JPRB,.813E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 10  54.0
ZAER (:,10, 5) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.963E-02_JPRB,.963E-02_JPRB,.872E-02_JPRB,&
&.872E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.826E-02_JPRB,.826E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.926E-02_JPRB,.926E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,&
&.872E-02_JPRB,.872E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.903E-02_JPRB,.903E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,&
&.947E-02_JPRB,.947E-02_JPRB,.912E-02_JPRB,.912E-02_JPRB,.983E-02_JPRB,.983E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 11  50.0
ZAER (:,11, 5) = (/&
&.123E-01_JPRB,.123E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.963E-02_JPRB,.963E-02_JPRB,.872E-02_JPRB,&
&.872E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.826E-02_JPRB,.826E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.926E-02_JPRB,.926E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.801E-02_JPRB,&
&.801E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,&
&.872E-02_JPRB,.872E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.903E-02_JPRB,.903E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,&
&.947E-02_JPRB,.947E-02_JPRB,.912E-02_JPRB,.912E-02_JPRB,.983E-02_JPRB,.983E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 12  46.0
ZAER (:,12, 5) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.925E-02_JPRB,.925E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.916E-02_JPRB,&
&.916E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,&
&.139E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.969E-02_JPRB,.969E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 13  42.0
ZAER (:,13, 5) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.925E-02_JPRB,.925E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.916E-02_JPRB,&
&.916E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,&
&.139E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.969E-02_JPRB,.969E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 14  38.0
ZAER (:,14, 5) = (/&
&.112E-01_JPRB,.112E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.987E-02_JPRB,.987E-02_JPRB,.928E-02_JPRB,&
&.928E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.750E-02_JPRB,&
&.750E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.913E-02_JPRB,.913E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,&
&.894E-02_JPRB,.894E-02_JPRB,.860E-02_JPRB,.860E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.667E-02_JPRB,&
&.667E-02_JPRB,.432E-02_JPRB,.432E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 15  34.0
ZAER (:,15, 5) = (/&
&.112E-01_JPRB,.112E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.987E-02_JPRB,.987E-02_JPRB,.928E-02_JPRB,&
&.928E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.750E-02_JPRB,&
&.750E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.119E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.913E-02_JPRB,.913E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,&
&.894E-02_JPRB,.894E-02_JPRB,.860E-02_JPRB,.860E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.667E-02_JPRB,&
&.667E-02_JPRB,.432E-02_JPRB,.432E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 16  30.0
ZAER (:,16, 5) = (/&
&.999E-02_JPRB,.999E-02_JPRB,.856E-02_JPRB,.856E-02_JPRB,.789E-02_JPRB,.789E-02_JPRB,.821E-02_JPRB,&
&.821E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.868E-02_JPRB,&
&.868E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,&
&.887E-02_JPRB,.887E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.967E-02_JPRB,.967E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,.433E-02_JPRB,.433E-02_JPRB,&
&.632E-02_JPRB,.632E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.953E-02_JPRB,.953E-02_JPRB,.972E-02_JPRB,&
&.972E-02_JPRB,.999E-02_JPRB,.999E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.826E-02_JPRB,.826E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.425E-02_JPRB,&
&.425E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 17  26.0
ZAER (:,17, 5) = (/&
&.999E-02_JPRB,.999E-02_JPRB,.856E-02_JPRB,.856E-02_JPRB,.789E-02_JPRB,.789E-02_JPRB,.821E-02_JPRB,&
&.821E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.955E-02_JPRB,.955E-02_JPRB,.868E-02_JPRB,&
&.868E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,&
&.887E-02_JPRB,.887E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.967E-02_JPRB,.967E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,.433E-02_JPRB,.433E-02_JPRB,&
&.632E-02_JPRB,.632E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.953E-02_JPRB,.953E-02_JPRB,.972E-02_JPRB,&
&.972E-02_JPRB,.999E-02_JPRB,.999E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.826E-02_JPRB,.826E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.425E-02_JPRB,&
&.425E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 18  22.0
ZAER (:,18, 5) = (/&
&.879E-02_JPRB,.879E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.993E-02_JPRB,&
&.993E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.879E-02_JPRB,&
&.879E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.345E-02_JPRB,.345E-02_JPRB,&
&.703E-02_JPRB,.703E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.894E-02_JPRB,&
&.894E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,&
&.457E-02_JPRB,.457E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.834E-02_JPRB,.834E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.711E-02_JPRB,.711E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.952E-02_JPRB,.952E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 19  18.0
ZAER (:,19, 5) = (/&
&.879E-02_JPRB,.879E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.993E-02_JPRB,&
&.993E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.879E-02_JPRB,&
&.879E-02_JPRB,.506E-02_JPRB,.506E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.345E-02_JPRB,.345E-02_JPRB,&
&.703E-02_JPRB,.703E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.894E-02_JPRB,&
&.894E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,&
&.457E-02_JPRB,.457E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.834E-02_JPRB,.834E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.711E-02_JPRB,.711E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.952E-02_JPRB,.952E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 20  14.0
ZAER (:,20, 5) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.829E-02_JPRB,.829E-02_JPRB,.519E-02_JPRB,&
&.519E-02_JPRB,.223E-02_JPRB,.223E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.433E-02_JPRB,.433E-02_JPRB,&
&.843E-02_JPRB,.843E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.830E-02_JPRB,&
&.830E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.375E-02_JPRB,.375E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.135E-01_JPRB,.135E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.974E-02_JPRB,.974E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 21  10.0
ZAER (:,21, 5) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.829E-02_JPRB,.829E-02_JPRB,.519E-02_JPRB,&
&.519E-02_JPRB,.223E-02_JPRB,.223E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.433E-02_JPRB,.433E-02_JPRB,&
&.843E-02_JPRB,.843E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.830E-02_JPRB,&
&.830E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,&
&.375E-02_JPRB,.375E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.135E-01_JPRB,.135E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.974E-02_JPRB,.974E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,&
&.958E-02_JPRB,.958E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 22   6.0
ZAER (:,22, 5) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB,.860E-02_JPRB,.860E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.827E-03_JPRB,.827E-03_JPRB,.131E-02_JPRB,.131E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.792E-02_JPRB,.792E-02_JPRB,.996E-02_JPRB,.996E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,.721E-02_JPRB,&
&.721E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.832E-02_JPRB,.832E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,&
&.568E-02_JPRB,.568E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,.591E-02_JPRB,&
&.591E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.120E-01_JPRB,.120E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 23   2.0
ZAER (:,23, 5) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB,.860E-02_JPRB,.860E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.827E-03_JPRB,.827E-03_JPRB,.131E-02_JPRB,.131E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.792E-02_JPRB,.792E-02_JPRB,.996E-02_JPRB,.996E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,.721E-02_JPRB,&
&.721E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.832E-02_JPRB,.832E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,&
&.568E-02_JPRB,.568E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,.591E-02_JPRB,&
&.591E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.120E-01_JPRB,.120E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 24  -2.0
ZAER (:,24, 5) = (/&
&.106E-01_JPRB,.106E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.233E-02_JPRB,&
&.233E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.267E-02_JPRB,&
&.267E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,&
&.422E-02_JPRB,.422E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.701E-02_JPRB,&
&.701E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.465E-02_JPRB,.465E-02_JPRB,&
&.399E-02_JPRB,.399E-02_JPRB,.536E-02_JPRB,.536E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.685E-02_JPRB,&
&.685E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,&
&.959E-02_JPRB,.959E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 25  -6.0
ZAER (:,25, 5) = (/&
&.106E-01_JPRB,.106E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.233E-02_JPRB,&
&.233E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,.376E-02_JPRB,.376E-02_JPRB,.267E-02_JPRB,&
&.267E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,&
&.422E-02_JPRB,.422E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.701E-02_JPRB,&
&.701E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.465E-02_JPRB,.465E-02_JPRB,&
&.399E-02_JPRB,.399E-02_JPRB,.536E-02_JPRB,.536E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.685E-02_JPRB,&
&.685E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,&
&.959E-02_JPRB,.959E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 26 -10.0
ZAER (:,26, 5) = (/&
&.126E-01_JPRB,.126E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.141E-01_JPRB,&
&.141E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.811E-02_JPRB,.811E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.689E-02_JPRB,&
&.689E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.962E-02_JPRB,.962E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,&
&.253E-02_JPRB,.253E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.864E-02_JPRB,&
&.864E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,&
&.381E-02_JPRB,.381E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.827E-02_JPRB,.827E-02_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 27 -14.0
ZAER (:,27, 5) = (/&
&.126E-01_JPRB,.126E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.141E-01_JPRB,&
&.141E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.811E-02_JPRB,.811E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.689E-02_JPRB,&
&.689E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.962E-02_JPRB,.962E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,&
&.253E-02_JPRB,.253E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,.852E-02_JPRB,.852E-02_JPRB,.864E-02_JPRB,&
&.864E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.617E-02_JPRB,.617E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,&
&.381E-02_JPRB,.381E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.827E-02_JPRB,.827E-02_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 28 -18.0
ZAER (:,28, 5) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.954E-02_JPRB,.954E-02_JPRB,&
&.762E-02_JPRB,.762E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.664E-02_JPRB,.664E-02_JPRB,.748E-02_JPRB,&
&.748E-02_JPRB,.988E-02_JPRB,.988E-02_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.977E-02_JPRB,.977E-02_JPRB,.812E-02_JPRB,.812E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.220E-02_JPRB,&
&.220E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,&
&.202E-02_JPRB,.202E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 29 -22.0
ZAER (:,29, 5) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.954E-02_JPRB,.954E-02_JPRB,&
&.762E-02_JPRB,.762E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.664E-02_JPRB,.664E-02_JPRB,.748E-02_JPRB,&
&.748E-02_JPRB,.988E-02_JPRB,.988E-02_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.977E-02_JPRB,.977E-02_JPRB,.812E-02_JPRB,.812E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.220E-02_JPRB,&
&.220E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,&
&.202E-02_JPRB,.202E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.583E-02_JPRB,&
&.583E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 30 -26.0
ZAER (:,30, 5) = (/&
&.548E-02_JPRB,.548E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,&
&.468E-02_JPRB,.468E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.612E-02_JPRB,&
&.612E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.349E-02_JPRB,&
&.349E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.352E-02_JPRB,.352E-02_JPRB,.524E-02_JPRB,&
&.524E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,&
&.617E-02_JPRB,.617E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 31 -30.0
ZAER (:,31, 5) = (/&
&.548E-02_JPRB,.548E-02_JPRB,.549E-02_JPRB,.549E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,&
&.468E-02_JPRB,.468E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.612E-02_JPRB,&
&.612E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.854E-02_JPRB,.854E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.349E-02_JPRB,&
&.349E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.231E-02_JPRB,.231E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.352E-02_JPRB,.352E-02_JPRB,.524E-02_JPRB,&
&.524E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,&
&.617E-02_JPRB,.617E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 32 -34.0
ZAER (:,32, 5) = (/&
&.539E-02_JPRB,.539E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.642E-02_JPRB,&
&.642E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.655E-02_JPRB,.655E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,&
&.173E-02_JPRB,.173E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.250E-02_JPRB,&
&.250E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,&
&.833E-02_JPRB,.833E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.412E-02_JPRB,&
&.412E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,&
&.261E-02_JPRB,.261E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.101E-02_JPRB,&
&.101E-02_JPRB,.920E-03_JPRB,.920E-03_JPRB,.948E-03_JPRB,.948E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,.171E-02_JPRB,.171E-02_JPRB,.260E-02_JPRB,&
&.260E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.732E-02_JPRB,.732E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 33 -38.0
ZAER (:,33, 5) = (/&
&.539E-02_JPRB,.539E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.642E-02_JPRB,&
&.642E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.655E-02_JPRB,.655E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,&
&.173E-02_JPRB,.173E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.250E-02_JPRB,&
&.250E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,&
&.833E-02_JPRB,.833E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.412E-02_JPRB,&
&.412E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,&
&.261E-02_JPRB,.261E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.101E-02_JPRB,&
&.101E-02_JPRB,.920E-03_JPRB,.920E-03_JPRB,.948E-03_JPRB,.948E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,.171E-02_JPRB,.171E-02_JPRB,.260E-02_JPRB,&
&.260E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.732E-02_JPRB,.732E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 34 -42.0
ZAER (:,34, 5) = (/&
&.748E-02_JPRB,.748E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,&
&.683E-03_JPRB,.683E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.560E-03_JPRB,.560E-03_JPRB,.472E-03_JPRB,&
&.472E-03_JPRB,.209E-02_JPRB,.209E-02_JPRB,.464E-02_JPRB,.464E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,&
&.789E-02_JPRB,.789E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,.419E-02_JPRB,&
&.419E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,&
&.219E-02_JPRB,.219E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.868E-03_JPRB,&
&.868E-03_JPRB,.734E-03_JPRB,.734E-03_JPRB,.647E-03_JPRB,.647E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,&
&.532E-03_JPRB,.532E-03_JPRB,.455E-03_JPRB,.455E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,&
&.809E-02_JPRB,.809E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 35 -46.0
ZAER (:,35, 5) = (/&
&.748E-02_JPRB,.748E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,&
&.683E-03_JPRB,.683E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,.560E-03_JPRB,.560E-03_JPRB,.472E-03_JPRB,&
&.472E-03_JPRB,.209E-02_JPRB,.209E-02_JPRB,.464E-02_JPRB,.464E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,&
&.789E-02_JPRB,.789E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,.419E-02_JPRB,&
&.419E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,&
&.219E-02_JPRB,.219E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.868E-03_JPRB,&
&.868E-03_JPRB,.734E-03_JPRB,.734E-03_JPRB,.647E-03_JPRB,.647E-03_JPRB,.598E-03_JPRB,.598E-03_JPRB,&
&.532E-03_JPRB,.532E-03_JPRB,.455E-03_JPRB,.455E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.115E-02_JPRB,&
&.115E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,.644E-02_JPRB,.644E-02_JPRB,&
&.809E-02_JPRB,.809E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 36 -50.0
ZAER (:,36, 5) = (/&
&.683E-02_JPRB,.683E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.480E-02_JPRB,&
&.480E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.882E-03_JPRB,.882E-03_JPRB,&
&.457E-03_JPRB,.457E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.620E-03_JPRB,.620E-03_JPRB,.696E-03_JPRB,&
&.696E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.271E-02_JPRB,.271E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,&
&.749E-02_JPRB,.749E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.404E-02_JPRB,&
&.404E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.816E-03_JPRB,&
&.816E-03_JPRB,.692E-03_JPRB,.692E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.491E-03_JPRB,.491E-03_JPRB,&
&.406E-03_JPRB,.406E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.276E-03_JPRB,.276E-03_JPRB,.356E-03_JPRB,&
&.356E-03_JPRB,.159E-02_JPRB,.159E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.641E-02_JPRB,.641E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 37 -54.0
ZAER (:,37, 5) = (/&
&.683E-02_JPRB,.683E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,.480E-02_JPRB,&
&.480E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.882E-03_JPRB,.882E-03_JPRB,&
&.457E-03_JPRB,.457E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.620E-03_JPRB,.620E-03_JPRB,.696E-03_JPRB,&
&.696E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.271E-02_JPRB,.271E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,&
&.749E-02_JPRB,.749E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.404E-02_JPRB,&
&.404E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.816E-03_JPRB,&
&.816E-03_JPRB,.692E-03_JPRB,.692E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.491E-03_JPRB,.491E-03_JPRB,&
&.406E-03_JPRB,.406E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.276E-03_JPRB,.276E-03_JPRB,.356E-03_JPRB,&
&.356E-03_JPRB,.159E-02_JPRB,.159E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.641E-02_JPRB,.641E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 38 -58.0
ZAER (:,38, 5) = (/&
&.464E-02_JPRB,.464E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.173E-02_JPRB,&
&.173E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.717E-03_JPRB,.717E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.279E-02_JPRB,.279E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,&
&.588E-02_JPRB,.588E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,.422E-02_JPRB,&
&.422E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,&
&.805E-03_JPRB,.805E-03_JPRB,.797E-03_JPRB,.797E-03_JPRB,.774E-03_JPRB,.774E-03_JPRB,.665E-03_JPRB,&
&.665E-03_JPRB,.527E-03_JPRB,.527E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,&
&.273E-03_JPRB,.273E-03_JPRB,.229E-03_JPRB,.229E-03_JPRB,.232E-03_JPRB,.232E-03_JPRB,.378E-03_JPRB,&
&.378E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,&
&.388E-02_JPRB,.388E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 39 -62.0
ZAER (:,39, 5) = (/&
&.464E-02_JPRB,.464E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.173E-02_JPRB,&
&.173E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.717E-03_JPRB,.717E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.279E-02_JPRB,.279E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,&
&.588E-02_JPRB,.588E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,.422E-02_JPRB,&
&.422E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,&
&.805E-03_JPRB,.805E-03_JPRB,.797E-03_JPRB,.797E-03_JPRB,.774E-03_JPRB,.774E-03_JPRB,.665E-03_JPRB,&
&.665E-03_JPRB,.527E-03_JPRB,.527E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,&
&.273E-03_JPRB,.273E-03_JPRB,.229E-03_JPRB,.229E-03_JPRB,.232E-03_JPRB,.232E-03_JPRB,.378E-03_JPRB,&
&.378E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,&
&.388E-02_JPRB,.388E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 40 -66.0
ZAER (:,40, 5) = (/&
&.188E-02_JPRB,.188E-02_JPRB,.223E-02_JPRB,.223E-02_JPRB,.621E-03_JPRB,.621E-03_JPRB,.506E-03_JPRB,&
&.506E-03_JPRB,.827E-03_JPRB,.827E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.491E-03_JPRB,.491E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.693E-03_JPRB,.693E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.691E-03_JPRB,&
&.691E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.371E-02_JPRB,.371E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.183E-02_JPRB,.183E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.673E-03_JPRB,.673E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.285E-03_JPRB,.285E-03_JPRB,&
&.246E-03_JPRB,.246E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.406E-03_JPRB,&
&.406E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,&
&.144E-02_JPRB,.144E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 41 -70.0
ZAER (:,41, 5) = (/&
&.188E-02_JPRB,.188E-02_JPRB,.223E-02_JPRB,.223E-02_JPRB,.621E-03_JPRB,.621E-03_JPRB,.506E-03_JPRB,&
&.506E-03_JPRB,.827E-03_JPRB,.827E-03_JPRB,.668E-03_JPRB,.668E-03_JPRB,.491E-03_JPRB,.491E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.693E-03_JPRB,.693E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.691E-03_JPRB,&
&.691E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.371E-02_JPRB,.371E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.183E-02_JPRB,.183E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.673E-03_JPRB,.673E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.285E-03_JPRB,.285E-03_JPRB,&
&.246E-03_JPRB,.246E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.406E-03_JPRB,&
&.406E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,&
&.144E-02_JPRB,.144E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 42 -74.0
ZAER (:,42, 5) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.576E-03_JPRB,.576E-03_JPRB,.446E-03_JPRB,&
&.446E-03_JPRB,.932E-03_JPRB,.932E-03_JPRB,.866E-03_JPRB,.866E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,&
&.334E-03_JPRB,.334E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.376E-03_JPRB,.376E-03_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.740E-03_JPRB,.740E-03_JPRB,&
&.647E-03_JPRB,.647E-03_JPRB,.644E-03_JPRB,.644E-03_JPRB,.157E-02_JPRB,.157E-02_JPRB,.298E-02_JPRB,&
&.298E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,&
&.391E-02_JPRB,.391E-02_JPRB,.295E-02_JPRB,.295E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.142E-02_JPRB,&
&.142E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.310E-03_JPRB,.310E-03_JPRB,&
&.345E-03_JPRB,.345E-03_JPRB,.673E-03_JPRB,.673E-03_JPRB,.253E-02_JPRB,.253E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.420E-03_JPRB,.420E-03_JPRB,.468E-03_JPRB,.468E-03_JPRB,.732E-03_JPRB,.732E-03_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 43 -78.0
ZAER (:,43, 5) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.576E-03_JPRB,.576E-03_JPRB,.446E-03_JPRB,&
&.446E-03_JPRB,.932E-03_JPRB,.932E-03_JPRB,.866E-03_JPRB,.866E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,&
&.334E-03_JPRB,.334E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,.376E-03_JPRB,.376E-03_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.740E-03_JPRB,.740E-03_JPRB,&
&.647E-03_JPRB,.647E-03_JPRB,.644E-03_JPRB,.644E-03_JPRB,.157E-02_JPRB,.157E-02_JPRB,.298E-02_JPRB,&
&.298E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,&
&.391E-02_JPRB,.391E-02_JPRB,.295E-02_JPRB,.295E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.142E-02_JPRB,&
&.142E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.310E-03_JPRB,.310E-03_JPRB,&
&.345E-03_JPRB,.345E-03_JPRB,.673E-03_JPRB,.673E-03_JPRB,.253E-02_JPRB,.253E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.420E-03_JPRB,.420E-03_JPRB,.468E-03_JPRB,.468E-03_JPRB,.732E-03_JPRB,.732E-03_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 44 -82.0
ZAER (:,44, 5) = (/&
&.421E-03_JPRB,.421E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.356E-03_JPRB,&
&.356E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.339E-03_JPRB,.339E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,&
&.332E-03_JPRB,.332E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.440E-03_JPRB,&
&.440E-03_JPRB,.485E-03_JPRB,.485E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.446E-03_JPRB,.446E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.947E-03_JPRB,&
&.947E-03_JPRB,.150E-02_JPRB,.150E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.488E-03_JPRB,.488E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,.330E-03_JPRB,&
&.330E-03_JPRB,.337E-03_JPRB,.337E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.610E-03_JPRB,.610E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.807E-03_JPRB,&
&.807E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.346E-03_JPRB,.346E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,&
&.415E-03_JPRB,.415E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 45 -86.0
ZAER (:,45, 5) = (/&
&.421E-03_JPRB,.421E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.356E-03_JPRB,&
&.356E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.339E-03_JPRB,.339E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,&
&.332E-03_JPRB,.332E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.440E-03_JPRB,&
&.440E-03_JPRB,.485E-03_JPRB,.485E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.446E-03_JPRB,.446E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.947E-03_JPRB,&
&.947E-03_JPRB,.150E-02_JPRB,.150E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.488E-03_JPRB,.488E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,.330E-03_JPRB,&
&.330E-03_JPRB,.337E-03_JPRB,.337E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.610E-03_JPRB,.610E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.807E-03_JPRB,&
&.807E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.346E-03_JPRB,.346E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,&
&.415E-03_JPRB,.415E-03_JPRB/)
!-- Sea Salt Aerosol         month:  5 --- lat: 46 -90.0
ZAER (:,46, 5) = (/&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.302E-03_JPRB,.302E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  1  90.0
ZAER (:, 1, 6) = (/&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.438E-03_JPRB,.438E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  2  86.0
ZAER (:, 2, 6) = (/&
&.548E-03_JPRB,.548E-03_JPRB,.550E-03_JPRB,.550E-03_JPRB,.584E-03_JPRB,.584E-03_JPRB,.644E-03_JPRB,&
&.644E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,&
&.829E-03_JPRB,.829E-03_JPRB,.832E-03_JPRB,.832E-03_JPRB,.817E-03_JPRB,.817E-03_JPRB,.796E-03_JPRB,&
&.796E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,.756E-03_JPRB,.756E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,&
&.693E-03_JPRB,.693E-03_JPRB,.615E-03_JPRB,.615E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.401E-03_JPRB,&
&.401E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,&
&.288E-03_JPRB,.288E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,.290E-03_JPRB,.290E-03_JPRB,.292E-03_JPRB,&
&.292E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,&
&.275E-03_JPRB,.275E-03_JPRB,.297E-03_JPRB,.297E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.364E-03_JPRB,&
&.364E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,&
&.541E-03_JPRB,.541E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  3  82.0
ZAER (:, 3, 6) = (/&
&.548E-03_JPRB,.548E-03_JPRB,.550E-03_JPRB,.550E-03_JPRB,.584E-03_JPRB,.584E-03_JPRB,.644E-03_JPRB,&
&.644E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,&
&.829E-03_JPRB,.829E-03_JPRB,.832E-03_JPRB,.832E-03_JPRB,.817E-03_JPRB,.817E-03_JPRB,.796E-03_JPRB,&
&.796E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,.756E-03_JPRB,.756E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,&
&.693E-03_JPRB,.693E-03_JPRB,.615E-03_JPRB,.615E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.401E-03_JPRB,&
&.401E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,&
&.288E-03_JPRB,.288E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,.290E-03_JPRB,.290E-03_JPRB,.292E-03_JPRB,&
&.292E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,&
&.275E-03_JPRB,.275E-03_JPRB,.297E-03_JPRB,.297E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.364E-03_JPRB,&
&.364E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,&
&.541E-03_JPRB,.541E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  4  78.0
ZAER (:, 4, 6) = (/&
&.648E-03_JPRB,.648E-03_JPRB,.640E-03_JPRB,.640E-03_JPRB,.620E-03_JPRB,.620E-03_JPRB,.643E-03_JPRB,&
&.643E-03_JPRB,.699E-03_JPRB,.699E-03_JPRB,.761E-03_JPRB,.761E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.125E-02_JPRB,&
&.125E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.989E-03_JPRB,.989E-03_JPRB,.744E-03_JPRB,&
&.744E-03_JPRB,.477E-03_JPRB,.477E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,.413E-03_JPRB,.413E-03_JPRB,&
&.549E-03_JPRB,.549E-03_JPRB,.653E-03_JPRB,.653E-03_JPRB,.667E-03_JPRB,.667E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.456E-03_JPRB,.456E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,&
&.301E-03_JPRB,.301E-03_JPRB,.311E-03_JPRB,.311E-03_JPRB,.341E-03_JPRB,.341E-03_JPRB,.369E-03_JPRB,&
&.369E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,.564E-03_JPRB,.564E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,&
&.664E-03_JPRB,.664E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  5  74.0
ZAER (:, 5, 6) = (/&
&.648E-03_JPRB,.648E-03_JPRB,.640E-03_JPRB,.640E-03_JPRB,.620E-03_JPRB,.620E-03_JPRB,.643E-03_JPRB,&
&.643E-03_JPRB,.699E-03_JPRB,.699E-03_JPRB,.761E-03_JPRB,.761E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.125E-02_JPRB,&
&.125E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.989E-03_JPRB,.989E-03_JPRB,.744E-03_JPRB,&
&.744E-03_JPRB,.477E-03_JPRB,.477E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,.413E-03_JPRB,.413E-03_JPRB,&
&.549E-03_JPRB,.549E-03_JPRB,.653E-03_JPRB,.653E-03_JPRB,.667E-03_JPRB,.667E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.456E-03_JPRB,.456E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,&
&.301E-03_JPRB,.301E-03_JPRB,.311E-03_JPRB,.311E-03_JPRB,.341E-03_JPRB,.341E-03_JPRB,.369E-03_JPRB,&
&.369E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,.564E-03_JPRB,.564E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,&
&.664E-03_JPRB,.664E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  6  70.0
ZAER (:, 6, 6) = (/&
&.147E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,&
&.272E-02_JPRB,.272E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.321E-02_JPRB,.321E-02_JPRB,.295E-02_JPRB,&
&.295E-02_JPRB,.229E-02_JPRB,.229E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.103E-02_JPRB,&
&.103E-02_JPRB,.721E-03_JPRB,.721E-03_JPRB,.559E-03_JPRB,.559E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,&
&.772E-03_JPRB,.772E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.767E-03_JPRB,.767E-03_JPRB,&
&.675E-03_JPRB,.675E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.934E-03_JPRB,&
&.934E-03_JPRB,.130E-02_JPRB,.130E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.181E-02_JPRB,.181E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  7  66.0
ZAER (:, 7, 6) = (/&
&.147E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,&
&.272E-02_JPRB,.272E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.321E-02_JPRB,.321E-02_JPRB,.295E-02_JPRB,&
&.295E-02_JPRB,.229E-02_JPRB,.229E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.103E-02_JPRB,&
&.103E-02_JPRB,.721E-03_JPRB,.721E-03_JPRB,.559E-03_JPRB,.559E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,&
&.772E-03_JPRB,.772E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.767E-03_JPRB,.767E-03_JPRB,&
&.675E-03_JPRB,.675E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.934E-03_JPRB,&
&.934E-03_JPRB,.130E-02_JPRB,.130E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,&
&.181E-02_JPRB,.181E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  8  62.0
ZAER (:, 8, 6) = (/&
&.855E-02_JPRB,.855E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.361E-02_JPRB,&
&.361E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.912E-02_JPRB,.912E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.981E-02_JPRB,&
&.981E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,&
&.333E-02_JPRB,.333E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.195E-02_JPRB,&
&.195E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.963E-03_JPRB,.963E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.439E-02_JPRB,&
&.439E-02_JPRB,.425E-02_JPRB,.425E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,.444E-02_JPRB,&
&.444E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,&
&.894E-02_JPRB,.894E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat:  9  58.0
ZAER (:, 9, 6) = (/&
&.855E-02_JPRB,.855E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.361E-02_JPRB,&
&.361E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.912E-02_JPRB,.912E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.981E-02_JPRB,&
&.981E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,&
&.333E-02_JPRB,.333E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.195E-02_JPRB,&
&.195E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.963E-03_JPRB,.963E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,&
&.114E-02_JPRB,.114E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.439E-02_JPRB,&
&.439E-02_JPRB,.425E-02_JPRB,.425E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,.444E-02_JPRB,&
&.444E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,&
&.894E-02_JPRB,.894E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 10  54.0
ZAER (:,10, 6) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.930E-02_JPRB,.930E-02_JPRB,.853E-02_JPRB,&
&.853E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,&
&.961E-02_JPRB,.961E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.804E-02_JPRB,.804E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.948E-02_JPRB,.948E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.596E-02_JPRB,&
&.596E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.468E-02_JPRB,.468E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,&
&.775E-02_JPRB,.775E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.135E-01_JPRB,&
&.135E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.930E-02_JPRB,.930E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 11  50.0
ZAER (:,11, 6) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.930E-02_JPRB,.930E-02_JPRB,.853E-02_JPRB,&
&.853E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,&
&.961E-02_JPRB,.961E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.804E-02_JPRB,.804E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.948E-02_JPRB,.948E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.596E-02_JPRB,&
&.596E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.468E-02_JPRB,.468E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,&
&.775E-02_JPRB,.775E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.135E-01_JPRB,&
&.135E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.930E-02_JPRB,.930E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.129E-01_JPRB,&
&.129E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 12  46.0
ZAER (:,12, 6) = (/&
&.947E-02_JPRB,.947E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.961E-02_JPRB,&
&.961E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.896E-02_JPRB,&
&.896E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.985E-02_JPRB,.985E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.157E-01_JPRB,.157E-01_JPRB,.172E-01_JPRB,&
&.172E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.139E-01_JPRB,&
&.139E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 13  42.0
ZAER (:,13, 6) = (/&
&.947E-02_JPRB,.947E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.961E-02_JPRB,&
&.961E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.896E-02_JPRB,&
&.896E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.985E-02_JPRB,.985E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.157E-01_JPRB,.157E-01_JPRB,.172E-01_JPRB,&
&.172E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.139E-01_JPRB,&
&.139E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.797E-02_JPRB,.797E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 14  38.0
ZAER (:,14, 6) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.935E-02_JPRB,.935E-02_JPRB,.760E-02_JPRB,&
&.760E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.950E-02_JPRB,.950E-02_JPRB,.980E-02_JPRB,&
&.980E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.975E-02_JPRB,.975E-02_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.125E-01_JPRB,&
&.125E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.620E-02_JPRB,.620E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 15  34.0
ZAER (:,15, 6) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.935E-02_JPRB,.935E-02_JPRB,.760E-02_JPRB,&
&.760E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.416E-02_JPRB,.416E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.950E-02_JPRB,.950E-02_JPRB,.980E-02_JPRB,&
&.980E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.975E-02_JPRB,.975E-02_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.125E-01_JPRB,&
&.125E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.620E-02_JPRB,.620E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 16  30.0
ZAER (:,16, 6) = (/&
&.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.968E-02_JPRB,.968E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.735E-02_JPRB,&
&.735E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.907E-02_JPRB,&
&.907E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,&
&.611E-02_JPRB,.611E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.903E-02_JPRB,.903E-02_JPRB,&
&.861E-02_JPRB,.861E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.492E-02_JPRB,.492E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 17  26.0
ZAER (:,17, 6) = (/&
&.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.968E-02_JPRB,.968E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.995E-02_JPRB,.995E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.735E-02_JPRB,&
&.735E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.348E-02_JPRB,.348E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.907E-02_JPRB,&
&.907E-02_JPRB,.904E-02_JPRB,.904E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,&
&.611E-02_JPRB,.611E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.903E-02_JPRB,.903E-02_JPRB,&
&.861E-02_JPRB,.861E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.492E-02_JPRB,.492E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 18  22.0
ZAER (:,18, 6) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.784E-02_JPRB,&
&.784E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,&
&.690E-02_JPRB,.690E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.961E-02_JPRB,.961E-02_JPRB,.923E-02_JPRB,&
&.923E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,&
&.358E-02_JPRB,.358E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,.806E-02_JPRB,.806E-02_JPRB,.114E-01_JPRB,&
&.114E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.799E-02_JPRB,.799E-02_JPRB,.694E-02_JPRB,&
&.694E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 19  18.0
ZAER (:,19, 6) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.784E-02_JPRB,&
&.784E-02_JPRB,.472E-02_JPRB,.472E-02_JPRB,.349E-02_JPRB,.349E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,&
&.690E-02_JPRB,.690E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.961E-02_JPRB,.961E-02_JPRB,.923E-02_JPRB,&
&.923E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.255E-02_JPRB,.255E-02_JPRB,&
&.358E-02_JPRB,.358E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,.806E-02_JPRB,.806E-02_JPRB,.114E-01_JPRB,&
&.114E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.799E-02_JPRB,.799E-02_JPRB,.694E-02_JPRB,&
&.694E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 20  14.0
ZAER (:,20, 6) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.151E-01_JPRB,&
&.151E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.841E-02_JPRB,.841E-02_JPRB,.550E-02_JPRB,&
&.550E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,&
&.806E-02_JPRB,.806E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.779E-02_JPRB,&
&.779E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,&
&.447E-02_JPRB,.447E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,.124E-01_JPRB,.124E-01_JPRB,.154E-01_JPRB,&
&.154E-01_JPRB,.170E-01_JPRB,.170E-01_JPRB,.171E-01_JPRB,.171E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 21  10.0
ZAER (:,21, 6) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.151E-01_JPRB,&
&.151E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.841E-02_JPRB,.841E-02_JPRB,.550E-02_JPRB,&
&.550E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.462E-02_JPRB,.462E-02_JPRB,&
&.806E-02_JPRB,.806E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.779E-02_JPRB,&
&.779E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,&
&.447E-02_JPRB,.447E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,.124E-01_JPRB,.124E-01_JPRB,.154E-01_JPRB,&
&.154E-01_JPRB,.170E-01_JPRB,.170E-01_JPRB,.171E-01_JPRB,.171E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,&
&.146E-01_JPRB,.146E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 22   6.0
ZAER (:,22, 6) = (/&
&.149E-01_JPRB,.149E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.159E-01_JPRB,&
&.159E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.847E-02_JPRB,.847E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.868E-02_JPRB,.868E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.387E-02_JPRB,.387E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,&
&.820E-02_JPRB,.820E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.900E-02_JPRB,.900E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,&
&.666E-02_JPRB,.666E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.736E-02_JPRB,&
&.736E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 23   2.0
ZAER (:,23, 6) = (/&
&.149E-01_JPRB,.149E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.159E-01_JPRB,&
&.159E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.847E-02_JPRB,.847E-02_JPRB,.537E-02_JPRB,.537E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.633E-02_JPRB,.633E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.868E-02_JPRB,.868E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.387E-02_JPRB,.387E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,&
&.820E-02_JPRB,.820E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.900E-02_JPRB,.900E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,&
&.666E-02_JPRB,.666E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.736E-02_JPRB,&
&.736E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 24  -2.0
ZAER (:,24, 6) = (/&
&.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.988E-02_JPRB,.988E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.208E-02_JPRB,&
&.208E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.801E-02_JPRB,.801E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.359E-02_JPRB,&
&.359E-02_JPRB,.292E-02_JPRB,.292E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,&
&.626E-02_JPRB,.626E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.132E-01_JPRB,.132E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.930E-02_JPRB,.930E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.667E-02_JPRB,.667E-02_JPRB,&
&.482E-02_JPRB,.482E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.753E-02_JPRB,&
&.753E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,.961E-02_JPRB,.961E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 25  -6.0
ZAER (:,25, 6) = (/&
&.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.988E-02_JPRB,.988E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.208E-02_JPRB,&
&.208E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,&
&.801E-02_JPRB,.801E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.482E-02_JPRB,.482E-02_JPRB,.359E-02_JPRB,&
&.359E-02_JPRB,.292E-02_JPRB,.292E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,&
&.626E-02_JPRB,.626E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.132E-01_JPRB,.132E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.930E-02_JPRB,.930E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.667E-02_JPRB,.667E-02_JPRB,&
&.482E-02_JPRB,.482E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.753E-02_JPRB,&
&.753E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.892E-02_JPRB,.892E-02_JPRB,.961E-02_JPRB,.961E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 26 -10.0
ZAER (:,26, 6) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.883E-02_JPRB,.883E-02_JPRB,&
&.664E-02_JPRB,.664E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.649E-02_JPRB,&
&.649E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.924E-02_JPRB,.924E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.913E-03_JPRB,.913E-03_JPRB,.908E-03_JPRB,.908E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.249E-02_JPRB,.249E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.143E-01_JPRB,.143E-01_JPRB,.134E-01_JPRB,&
&.134E-01_JPRB,.806E-02_JPRB,.806E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.988E-02_JPRB,&
&.988E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 27 -14.0
ZAER (:,27, 6) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.150E-01_JPRB,&
&.150E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.883E-02_JPRB,.883E-02_JPRB,&
&.664E-02_JPRB,.664E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.649E-02_JPRB,&
&.649E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.924E-02_JPRB,.924E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.913E-03_JPRB,.913E-03_JPRB,.908E-03_JPRB,.908E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.249E-02_JPRB,.249E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.143E-01_JPRB,.143E-01_JPRB,.134E-01_JPRB,&
&.134E-01_JPRB,.806E-02_JPRB,.806E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.988E-02_JPRB,&
&.988E-02_JPRB,.952E-02_JPRB,.952E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 28 -18.0
ZAER (:,28, 6) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.775E-02_JPRB,.775E-02_JPRB,&
&.550E-02_JPRB,.550E-02_JPRB,.412E-02_JPRB,.412E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.648E-02_JPRB,&
&.648E-02_JPRB,.963E-02_JPRB,.963E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.889E-02_JPRB,.889E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.144E-02_JPRB,.144E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.841E-02_JPRB,&
&.841E-02_JPRB,.504E-02_JPRB,.504E-02_JPRB,.283E-02_JPRB,.283E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,&
&.176E-02_JPRB,.176E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.714E-02_JPRB,&
&.714E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 29 -22.0
ZAER (:,29, 6) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.775E-02_JPRB,.775E-02_JPRB,&
&.550E-02_JPRB,.550E-02_JPRB,.412E-02_JPRB,.412E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.648E-02_JPRB,&
&.648E-02_JPRB,.963E-02_JPRB,.963E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.889E-02_JPRB,.889E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.144E-02_JPRB,.144E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.841E-02_JPRB,&
&.841E-02_JPRB,.504E-02_JPRB,.504E-02_JPRB,.283E-02_JPRB,.283E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,&
&.176E-02_JPRB,.176E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.714E-02_JPRB,&
&.714E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 30 -26.0
ZAER (:,30, 6) = (/&
&.904E-02_JPRB,.904E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.903E-02_JPRB,&
&.903E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.666E-02_JPRB,.666E-02_JPRB,&
&.443E-02_JPRB,.443E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.539E-02_JPRB,&
&.539E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.937E-02_JPRB,.937E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.340E-02_JPRB,&
&.340E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,&
&.184E-02_JPRB,.184E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.198E-02_JPRB,&
&.198E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,&
&.833E-03_JPRB,.833E-03_JPRB,.140E-02_JPRB,.140E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.468E-02_JPRB,&
&.468E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 31 -30.0
ZAER (:,31, 6) = (/&
&.904E-02_JPRB,.904E-02_JPRB,.889E-02_JPRB,.889E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.903E-02_JPRB,&
&.903E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.666E-02_JPRB,.666E-02_JPRB,&
&.443E-02_JPRB,.443E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.539E-02_JPRB,&
&.539E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.937E-02_JPRB,.937E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.340E-02_JPRB,&
&.340E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,&
&.184E-02_JPRB,.184E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.198E-02_JPRB,&
&.198E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,&
&.833E-03_JPRB,.833E-03_JPRB,.140E-02_JPRB,.140E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.468E-02_JPRB,&
&.468E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 32 -34.0
ZAER (:,32, 6) = (/&
&.563E-02_JPRB,.563E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.446E-02_JPRB,.446E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,&
&.244E-02_JPRB,.244E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.259E-02_JPRB,&
&.259E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.389E-02_JPRB,&
&.389E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,&
&.268E-02_JPRB,.268E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.848E-03_JPRB,.848E-03_JPRB,.760E-03_JPRB,.760E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,&
&.440E-03_JPRB,.440E-03_JPRB,.511E-03_JPRB,.511E-03_JPRB,.164E-02_JPRB,.164E-02_JPRB,.291E-02_JPRB,&
&.291E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,&
&.631E-02_JPRB,.631E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 33 -38.0
ZAER (:,33, 6) = (/&
&.563E-02_JPRB,.563E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.643E-02_JPRB,&
&.643E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.446E-02_JPRB,.446E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,&
&.244E-02_JPRB,.244E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.259E-02_JPRB,&
&.259E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.795E-02_JPRB,.795E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.389E-02_JPRB,&
&.389E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,&
&.268E-02_JPRB,.268E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.848E-03_JPRB,.848E-03_JPRB,.760E-03_JPRB,.760E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,&
&.440E-03_JPRB,.440E-03_JPRB,.511E-03_JPRB,.511E-03_JPRB,.164E-02_JPRB,.164E-02_JPRB,.291E-02_JPRB,&
&.291E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,&
&.631E-02_JPRB,.631E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 34 -42.0
ZAER (:,34, 6) = (/&
&.573E-02_JPRB,.573E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.742E-03_JPRB,.742E-03_JPRB,&
&.623E-03_JPRB,.623E-03_JPRB,.603E-03_JPRB,.603E-03_JPRB,.627E-03_JPRB,.627E-03_JPRB,.587E-03_JPRB,&
&.587E-03_JPRB,.237E-02_JPRB,.237E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.675E-02_JPRB,.675E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.367E-02_JPRB,&
&.367E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.924E-03_JPRB,&
&.924E-03_JPRB,.652E-03_JPRB,.652E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,&
&.456E-03_JPRB,.456E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.145E-02_JPRB,&
&.145E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,&
&.515E-02_JPRB,.515E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 35 -46.0
ZAER (:,35, 6) = (/&
&.573E-02_JPRB,.573E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.619E-02_JPRB,.619E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,.742E-03_JPRB,.742E-03_JPRB,&
&.623E-03_JPRB,.623E-03_JPRB,.603E-03_JPRB,.603E-03_JPRB,.627E-03_JPRB,.627E-03_JPRB,.587E-03_JPRB,&
&.587E-03_JPRB,.237E-02_JPRB,.237E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,&
&.675E-02_JPRB,.675E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.367E-02_JPRB,&
&.367E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.924E-03_JPRB,&
&.924E-03_JPRB,.652E-03_JPRB,.652E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,&
&.456E-03_JPRB,.456E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.145E-02_JPRB,&
&.145E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,&
&.515E-02_JPRB,.515E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 36 -50.0
ZAER (:,36, 6) = (/&
&.462E-02_JPRB,.462E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.495E-02_JPRB,.495E-02_JPRB,.538E-02_JPRB,&
&.538E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.595E-03_JPRB,.595E-03_JPRB,&
&.306E-03_JPRB,.306E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.624E-03_JPRB,&
&.624E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.213E-02_JPRB,.213E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,&
&.636E-02_JPRB,.636E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.978E-03_JPRB,.978E-03_JPRB,&
&.957E-03_JPRB,.957E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.887E-03_JPRB,.887E-03_JPRB,.693E-03_JPRB,&
&.693E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.492E-03_JPRB,.492E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,&
&.406E-03_JPRB,.406E-03_JPRB,.365E-03_JPRB,.365E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.390E-03_JPRB,&
&.390E-03_JPRB,.147E-02_JPRB,.147E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.424E-02_JPRB,.424E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 37 -54.0
ZAER (:,37, 6) = (/&
&.462E-02_JPRB,.462E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.495E-02_JPRB,.495E-02_JPRB,.538E-02_JPRB,&
&.538E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.595E-03_JPRB,.595E-03_JPRB,&
&.306E-03_JPRB,.306E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.624E-03_JPRB,&
&.624E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.213E-02_JPRB,.213E-02_JPRB,.497E-02_JPRB,.497E-02_JPRB,&
&.636E-02_JPRB,.636E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.978E-03_JPRB,.978E-03_JPRB,&
&.957E-03_JPRB,.957E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.887E-03_JPRB,.887E-03_JPRB,.693E-03_JPRB,&
&.693E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.492E-03_JPRB,.492E-03_JPRB,.448E-03_JPRB,.448E-03_JPRB,&
&.406E-03_JPRB,.406E-03_JPRB,.365E-03_JPRB,.365E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.390E-03_JPRB,&
&.390E-03_JPRB,.147E-02_JPRB,.147E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.424E-02_JPRB,.424E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 38 -58.0
ZAER (:,38, 6) = (/&
&.343E-02_JPRB,.343E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.231E-02_JPRB,&
&.231E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.647E-03_JPRB,.647E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,&
&.305E-03_JPRB,.305E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.233E-02_JPRB,.233E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,&
&.494E-02_JPRB,.494E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.485E-02_JPRB,&
&.485E-02_JPRB,.395E-02_JPRB,.395E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.830E-03_JPRB,.830E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,.576E-03_JPRB,&
&.576E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.337E-03_JPRB,.337E-03_JPRB,&
&.295E-03_JPRB,.295E-03_JPRB,.260E-03_JPRB,.260E-03_JPRB,.234E-03_JPRB,.234E-03_JPRB,.243E-03_JPRB,&
&.243E-03_JPRB,.878E-03_JPRB,.878E-03_JPRB,.157E-02_JPRB,.157E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.281E-02_JPRB,.281E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 39 -62.0
ZAER (:,39, 6) = (/&
&.343E-02_JPRB,.343E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.231E-02_JPRB,&
&.231E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.647E-03_JPRB,.647E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,&
&.305E-03_JPRB,.305E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.233E-02_JPRB,.233E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,&
&.494E-02_JPRB,.494E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.485E-02_JPRB,&
&.485E-02_JPRB,.395E-02_JPRB,.395E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.830E-03_JPRB,.830E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.738E-03_JPRB,.738E-03_JPRB,.576E-03_JPRB,&
&.576E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.337E-03_JPRB,.337E-03_JPRB,&
&.295E-03_JPRB,.295E-03_JPRB,.260E-03_JPRB,.260E-03_JPRB,.234E-03_JPRB,.234E-03_JPRB,.243E-03_JPRB,&
&.243E-03_JPRB,.878E-03_JPRB,.878E-03_JPRB,.157E-02_JPRB,.157E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.281E-02_JPRB,.281E-02_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 40 -66.0
ZAER (:,40, 6) = (/&
&.186E-02_JPRB,.186E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.988E-03_JPRB,.988E-03_JPRB,.830E-03_JPRB,&
&.830E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.823E-03_JPRB,.823E-03_JPRB,.699E-03_JPRB,.699E-03_JPRB,&
&.491E-03_JPRB,.491E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.689E-03_JPRB,.689E-03_JPRB,.928E-03_JPRB,&
&.928E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.484E-02_JPRB,&
&.484E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.383E-02_JPRB,.383E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.669E-03_JPRB,.669E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.259E-03_JPRB,.259E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.328E-03_JPRB,&
&.328E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.581E-03_JPRB,.581E-03_JPRB,&
&.903E-03_JPRB,.903E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 41 -70.0
ZAER (:,41, 6) = (/&
&.186E-02_JPRB,.186E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.988E-03_JPRB,.988E-03_JPRB,.830E-03_JPRB,&
&.830E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.823E-03_JPRB,.823E-03_JPRB,.699E-03_JPRB,.699E-03_JPRB,&
&.491E-03_JPRB,.491E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.689E-03_JPRB,.689E-03_JPRB,.928E-03_JPRB,&
&.928E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.263E-02_JPRB,.263E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.334E-02_JPRB,.334E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.484E-02_JPRB,&
&.484E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.383E-02_JPRB,.383E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.669E-03_JPRB,.669E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,&
&.259E-03_JPRB,.259E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,.328E-03_JPRB,&
&.328E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.581E-03_JPRB,.581E-03_JPRB,&
&.903E-03_JPRB,.903E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 42 -74.0
ZAER (:,42, 6) = (/&
&.818E-03_JPRB,.818E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.812E-03_JPRB,.812E-03_JPRB,.663E-03_JPRB,&
&.663E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.887E-03_JPRB,.887E-03_JPRB,.687E-03_JPRB,.687E-03_JPRB,&
&.596E-03_JPRB,.596E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.560E-03_JPRB,.560E-03_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.696E-03_JPRB,.696E-03_JPRB,&
&.516E-03_JPRB,.516E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,.359E-02_JPRB,&
&.359E-02_JPRB,.393E-02_JPRB,.393E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,&
&.320E-02_JPRB,.320E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.179E-02_JPRB,&
&.179E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.382E-03_JPRB,.382E-03_JPRB,&
&.346E-03_JPRB,.346E-03_JPRB,.553E-03_JPRB,.553E-03_JPRB,.138E-02_JPRB,.138E-02_JPRB,.128E-02_JPRB,&
&.128E-02_JPRB,.298E-03_JPRB,.298E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,&
&.535E-03_JPRB,.535E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 43 -78.0
ZAER (:,43, 6) = (/&
&.818E-03_JPRB,.818E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.812E-03_JPRB,.812E-03_JPRB,.663E-03_JPRB,&
&.663E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.887E-03_JPRB,.887E-03_JPRB,.687E-03_JPRB,.687E-03_JPRB,&
&.596E-03_JPRB,.596E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.560E-03_JPRB,.560E-03_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.696E-03_JPRB,.696E-03_JPRB,&
&.516E-03_JPRB,.516E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,.359E-02_JPRB,&
&.359E-02_JPRB,.393E-02_JPRB,.393E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,&
&.320E-02_JPRB,.320E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.179E-02_JPRB,&
&.179E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.382E-03_JPRB,.382E-03_JPRB,&
&.346E-03_JPRB,.346E-03_JPRB,.553E-03_JPRB,.553E-03_JPRB,.138E-02_JPRB,.138E-02_JPRB,.128E-02_JPRB,&
&.128E-02_JPRB,.298E-03_JPRB,.298E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,&
&.535E-03_JPRB,.535E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 44 -82.0
ZAER (:,44, 6) = (/&
&.421E-03_JPRB,.421E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.405E-03_JPRB,&
&.405E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,.525E-03_JPRB,.525E-03_JPRB,&
&.564E-03_JPRB,.564E-03_JPRB,.628E-03_JPRB,.628E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,.843E-03_JPRB,&
&.843E-03_JPRB,.845E-03_JPRB,.845E-03_JPRB,.684E-03_JPRB,.684E-03_JPRB,.626E-03_JPRB,.626E-03_JPRB,&
&.691E-03_JPRB,.691E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.911E-03_JPRB,.911E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.687E-03_JPRB,&
&.687E-03_JPRB,.582E-03_JPRB,.582E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,&
&.435E-03_JPRB,.435E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.383E-03_JPRB,&
&.383E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,&
&.394E-03_JPRB,.394E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 45 -86.0
ZAER (:,45, 6) = (/&
&.421E-03_JPRB,.421E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.405E-03_JPRB,&
&.405E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.489E-03_JPRB,.489E-03_JPRB,.525E-03_JPRB,.525E-03_JPRB,&
&.564E-03_JPRB,.564E-03_JPRB,.628E-03_JPRB,.628E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,.843E-03_JPRB,&
&.843E-03_JPRB,.845E-03_JPRB,.845E-03_JPRB,.684E-03_JPRB,.684E-03_JPRB,.626E-03_JPRB,.626E-03_JPRB,&
&.691E-03_JPRB,.691E-03_JPRB,.808E-03_JPRB,.808E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.176E-02_JPRB,.176E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.911E-03_JPRB,.911E-03_JPRB,.794E-03_JPRB,.794E-03_JPRB,.687E-03_JPRB,&
&.687E-03_JPRB,.582E-03_JPRB,.582E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.422E-03_JPRB,.422E-03_JPRB,&
&.435E-03_JPRB,.435E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.383E-03_JPRB,&
&.383E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,&
&.394E-03_JPRB,.394E-03_JPRB/)
!-- Sea Salt Aerosol         month:  6 --- lat: 46 -90.0
ZAER (:,46, 6) = (/&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  1  90.0
ZAER (:, 1, 7) = (/&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  2  86.0
ZAER (:, 2, 7) = (/&
&.782E-03_JPRB,.782E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,.948E-03_JPRB,&
&.948E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.977E-03_JPRB,.977E-03_JPRB,.963E-03_JPRB,.963E-03_JPRB,&
&.906E-03_JPRB,.906E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,.756E-03_JPRB,&
&.756E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,.708E-03_JPRB,.708E-03_JPRB,.694E-03_JPRB,.694E-03_JPRB,&
&.661E-03_JPRB,.661E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.331E-03_JPRB,&
&.331E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,&
&.217E-03_JPRB,.217E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.250E-03_JPRB,&
&.250E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,&
&.301E-03_JPRB,.301E-03_JPRB,.317E-03_JPRB,.317E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.345E-03_JPRB,&
&.345E-03_JPRB,.381E-03_JPRB,.381E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.517E-03_JPRB,.517E-03_JPRB,&
&.670E-03_JPRB,.670E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  3  82.0
ZAER (:, 3, 7) = (/&
&.782E-03_JPRB,.782E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,.948E-03_JPRB,&
&.948E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.977E-03_JPRB,.977E-03_JPRB,.963E-03_JPRB,.963E-03_JPRB,&
&.906E-03_JPRB,.906E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,.756E-03_JPRB,&
&.756E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,.708E-03_JPRB,.708E-03_JPRB,.694E-03_JPRB,.694E-03_JPRB,&
&.661E-03_JPRB,.661E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.331E-03_JPRB,&
&.331E-03_JPRB,.257E-03_JPRB,.257E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,&
&.217E-03_JPRB,.217E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.250E-03_JPRB,&
&.250E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,&
&.301E-03_JPRB,.301E-03_JPRB,.317E-03_JPRB,.317E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.345E-03_JPRB,&
&.345E-03_JPRB,.381E-03_JPRB,.381E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.517E-03_JPRB,.517E-03_JPRB,&
&.670E-03_JPRB,.670E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  4  78.0
ZAER (:, 4, 7) = (/&
&.113E-02_JPRB,.113E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.113E-02_JPRB,&
&.113E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,.999E-03_JPRB,.999E-03_JPRB,&
&.106E-02_JPRB,.106E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.994E-03_JPRB,.994E-03_JPRB,.904E-03_JPRB,&
&.904E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,.806E-03_JPRB,.806E-03_JPRB,.869E-03_JPRB,.869E-03_JPRB,&
&.889E-03_JPRB,.889E-03_JPRB,.840E-03_JPRB,.840E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,.499E-03_JPRB,&
&.499E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.245E-03_JPRB,.245E-03_JPRB,.283E-03_JPRB,.283E-03_JPRB,&
&.349E-03_JPRB,.349E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.369E-03_JPRB,.369E-03_JPRB,.352E-03_JPRB,&
&.352E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,&
&.396E-03_JPRB,.396E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.477E-03_JPRB,&
&.477E-03_JPRB,.534E-03_JPRB,.534E-03_JPRB,.617E-03_JPRB,.617E-03_JPRB,.778E-03_JPRB,.778E-03_JPRB,&
&.997E-03_JPRB,.997E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  5  74.0
ZAER (:, 5, 7) = (/&
&.113E-02_JPRB,.113E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.123E-02_JPRB,.123E-02_JPRB,.113E-02_JPRB,&
&.113E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,.999E-03_JPRB,.999E-03_JPRB,&
&.106E-02_JPRB,.106E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.994E-03_JPRB,.994E-03_JPRB,.904E-03_JPRB,&
&.904E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,.806E-03_JPRB,.806E-03_JPRB,.869E-03_JPRB,.869E-03_JPRB,&
&.889E-03_JPRB,.889E-03_JPRB,.840E-03_JPRB,.840E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,.499E-03_JPRB,&
&.499E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.245E-03_JPRB,.245E-03_JPRB,.283E-03_JPRB,.283E-03_JPRB,&
&.349E-03_JPRB,.349E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.369E-03_JPRB,.369E-03_JPRB,.352E-03_JPRB,&
&.352E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,&
&.396E-03_JPRB,.396E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.477E-03_JPRB,&
&.477E-03_JPRB,.534E-03_JPRB,.534E-03_JPRB,.617E-03_JPRB,.617E-03_JPRB,.778E-03_JPRB,.778E-03_JPRB,&
&.997E-03_JPRB,.997E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  6  70.0
ZAER (:, 6, 7) = (/&
&.210E-02_JPRB,.210E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.181E-02_JPRB,&
&.181E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.157E-02_JPRB,.157E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.960E-03_JPRB,.960E-03_JPRB,.818E-03_JPRB,.818E-03_JPRB,.707E-03_JPRB,&
&.707E-03_JPRB,.587E-03_JPRB,.587E-03_JPRB,.460E-03_JPRB,.460E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,&
&.685E-03_JPRB,.685E-03_JPRB,.853E-03_JPRB,.853E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,.638E-03_JPRB,&
&.638E-03_JPRB,.611E-03_JPRB,.611E-03_JPRB,.702E-03_JPRB,.702E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,&
&.743E-03_JPRB,.743E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.813E-03_JPRB,.813E-03_JPRB,.994E-03_JPRB,&
&.994E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.162E-02_JPRB,.162E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  7  66.0
ZAER (:, 7, 7) = (/&
&.210E-02_JPRB,.210E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.181E-02_JPRB,&
&.181E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.157E-02_JPRB,.157E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.210E-02_JPRB,&
&.210E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.100E-02_JPRB,.100E-02_JPRB,.960E-03_JPRB,.960E-03_JPRB,.818E-03_JPRB,.818E-03_JPRB,.707E-03_JPRB,&
&.707E-03_JPRB,.587E-03_JPRB,.587E-03_JPRB,.460E-03_JPRB,.460E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,&
&.685E-03_JPRB,.685E-03_JPRB,.853E-03_JPRB,.853E-03_JPRB,.829E-03_JPRB,.829E-03_JPRB,.638E-03_JPRB,&
&.638E-03_JPRB,.611E-03_JPRB,.611E-03_JPRB,.702E-03_JPRB,.702E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,&
&.743E-03_JPRB,.743E-03_JPRB,.716E-03_JPRB,.716E-03_JPRB,.813E-03_JPRB,.813E-03_JPRB,.994E-03_JPRB,&
&.994E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.162E-02_JPRB,.162E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  8  62.0
ZAER (:, 8, 7) = (/&
&.789E-02_JPRB,.789E-02_JPRB,.728E-02_JPRB,.728E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.387E-02_JPRB,&
&.387E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.850E-02_JPRB,&
&.850E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.197E-02_JPRB,.197E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.194E-02_JPRB,&
&.194E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.197E-02_JPRB,.197E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,.213E-02_JPRB,&
&.213E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.201E-02_JPRB,.201E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.406E-02_JPRB,&
&.406E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,&
&.743E-02_JPRB,.743E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat:  9  58.0
ZAER (:, 9, 7) = (/&
&.789E-02_JPRB,.789E-02_JPRB,.728E-02_JPRB,.728E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.387E-02_JPRB,&
&.387E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.850E-02_JPRB,&
&.850E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,&
&.197E-02_JPRB,.197E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.194E-02_JPRB,&
&.194E-02_JPRB,.193E-02_JPRB,.193E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,&
&.197E-02_JPRB,.197E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,.213E-02_JPRB,&
&.213E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.201E-02_JPRB,.201E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.406E-02_JPRB,&
&.406E-02_JPRB,.469E-02_JPRB,.469E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,&
&.743E-02_JPRB,.743E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 10  54.0
ZAER (:,10, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.941E-02_JPRB,.941E-02_JPRB,.939E-02_JPRB,&
&.939E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.155E-01_JPRB,.155E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.831E-02_JPRB,.831E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.835E-02_JPRB,.835E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.849E-02_JPRB,.849E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.944E-02_JPRB,&
&.944E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,&
&.881E-02_JPRB,.881E-02_JPRB,.979E-02_JPRB,.979E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.999E-02_JPRB,.999E-02_JPRB,&
&.983E-02_JPRB,.983E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 11  50.0
ZAER (:,11, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.941E-02_JPRB,.941E-02_JPRB,.939E-02_JPRB,&
&.939E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.155E-01_JPRB,.155E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.831E-02_JPRB,.831E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.835E-02_JPRB,.835E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.849E-02_JPRB,.849E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.944E-02_JPRB,&
&.944E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.895E-02_JPRB,.895E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,&
&.881E-02_JPRB,.881E-02_JPRB,.979E-02_JPRB,.979E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.999E-02_JPRB,.999E-02_JPRB,&
&.983E-02_JPRB,.983E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 12  46.0
ZAER (:,12, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.981E-02_JPRB,&
&.981E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.120E-01_JPRB,.120E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.138E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.822E-02_JPRB,.822E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 13  42.0
ZAER (:,13, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.144E-01_JPRB,.144E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.981E-02_JPRB,&
&.981E-02_JPRB,.629E-02_JPRB,.629E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.120E-01_JPRB,.120E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.138E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.822E-02_JPRB,.822E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 14  38.0
ZAER (:,14, 7) = (/&
&.106E-01_JPRB,.106E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.813E-02_JPRB,&
&.813E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.922E-02_JPRB,.922E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.956E-02_JPRB,.956E-02_JPRB,&
&.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.643E-02_JPRB,.643E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.974E-02_JPRB,.974E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 15  34.0
ZAER (:,15, 7) = (/&
&.106E-01_JPRB,.106E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.813E-02_JPRB,&
&.813E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,&
&.922E-02_JPRB,.922E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.956E-02_JPRB,.956E-02_JPRB,&
&.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.643E-02_JPRB,.643E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.974E-02_JPRB,.974E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 16  30.0
ZAER (:,16, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.970E-02_JPRB,.970E-02_JPRB,.789E-02_JPRB,&
&.789E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.541E-02_JPRB,.541E-02_JPRB,&
&.807E-02_JPRB,.807E-02_JPRB,.908E-02_JPRB,.908E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.942E-02_JPRB,&
&.942E-02_JPRB,.916E-02_JPRB,.916E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.600E-02_JPRB,.600E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,.106E-01_JPRB,&
&.106E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.823E-02_JPRB,.823E-02_JPRB,.489E-02_JPRB,.489E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,&
&.957E-02_JPRB,.957E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 17  26.0
ZAER (:,17, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.111E-01_JPRB,&
&.111E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.970E-02_JPRB,.970E-02_JPRB,.789E-02_JPRB,&
&.789E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.351E-02_JPRB,.351E-02_JPRB,.541E-02_JPRB,.541E-02_JPRB,&
&.807E-02_JPRB,.807E-02_JPRB,.908E-02_JPRB,.908E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.942E-02_JPRB,&
&.942E-02_JPRB,.916E-02_JPRB,.916E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.600E-02_JPRB,.600E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.966E-02_JPRB,.966E-02_JPRB,.106E-01_JPRB,&
&.106E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.823E-02_JPRB,.823E-02_JPRB,.489E-02_JPRB,.489E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,&
&.957E-02_JPRB,.957E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 18  22.0
ZAER (:,18, 7) = (/&
&.112E-01_JPRB,.112E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.793E-02_JPRB,&
&.793E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,&
&.703E-02_JPRB,.703E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.898E-02_JPRB,&
&.898E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.479E-02_JPRB,.479E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,&
&.331E-02_JPRB,.331E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.915E-02_JPRB,.915E-02_JPRB,.564E-02_JPRB,.564E-02_JPRB,.485E-02_JPRB,&
&.485E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.914E-02_JPRB,.914E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 19  18.0
ZAER (:,19, 7) = (/&
&.112E-01_JPRB,.112E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.793E-02_JPRB,&
&.793E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,&
&.703E-02_JPRB,.703E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.898E-02_JPRB,&
&.898E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.479E-02_JPRB,.479E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,&
&.331E-02_JPRB,.331E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.915E-02_JPRB,.915E-02_JPRB,.564E-02_JPRB,.564E-02_JPRB,.485E-02_JPRB,&
&.485E-02_JPRB,.560E-02_JPRB,.560E-02_JPRB,.914E-02_JPRB,.914E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 20  14.0
ZAER (:,20, 7) = (/&
&.145E-01_JPRB,.145E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.167E-01_JPRB,.167E-01_JPRB,.166E-01_JPRB,&
&.166E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.934E-02_JPRB,.934E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.571E-02_JPRB,&
&.571E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.726E-02_JPRB,&
&.726E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,&
&.371E-02_JPRB,.371E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.121E-01_JPRB,.121E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.850E-02_JPRB,.850E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,.123E-01_JPRB,.123E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 21  10.0
ZAER (:,21, 7) = (/&
&.145E-01_JPRB,.145E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.167E-01_JPRB,.167E-01_JPRB,.166E-01_JPRB,&
&.166E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.934E-02_JPRB,.934E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.571E-02_JPRB,&
&.571E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,&
&.863E-02_JPRB,.863E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.726E-02_JPRB,&
&.726E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,&
&.371E-02_JPRB,.371E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.121E-01_JPRB,.121E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.850E-02_JPRB,.850E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,.123E-01_JPRB,.123E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 22   6.0
ZAER (:,22, 7) = (/&
&.152E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.905E-02_JPRB,.905E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.314E-02_JPRB,&
&.314E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,&
&.945E-02_JPRB,.945E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,.488E-02_JPRB,&
&.488E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,&
&.642E-02_JPRB,.642E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 23   2.0
ZAER (:,23, 7) = (/&
&.152E-01_JPRB,.152E-01_JPRB,.155E-01_JPRB,.155E-01_JPRB,.154E-01_JPRB,.154E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.905E-02_JPRB,.905E-02_JPRB,.779E-02_JPRB,.779E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.314E-02_JPRB,&
&.314E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,&
&.945E-02_JPRB,.945E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,.488E-02_JPRB,&
&.488E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.303E-02_JPRB,.303E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,&
&.642E-02_JPRB,.642E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.149E-01_JPRB,.149E-01_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 24  -2.0
ZAER (:,24, 7) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.833E-02_JPRB,.833E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.327E-02_JPRB,&
&.327E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.939E-02_JPRB,.939E-02_JPRB,.680E-02_JPRB,.680E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.331E-02_JPRB,&
&.331E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,&
&.499E-02_JPRB,.499E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.850E-02_JPRB,&
&.850E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,&
&.484E-02_JPRB,.484E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.750E-02_JPRB,&
&.750E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 25  -6.0
ZAER (:,25, 7) = (/&
&.102E-01_JPRB,.102E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB,.833E-02_JPRB,.833E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.327E-02_JPRB,&
&.327E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.939E-02_JPRB,.939E-02_JPRB,.680E-02_JPRB,.680E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.331E-02_JPRB,&
&.331E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,&
&.499E-02_JPRB,.499E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.850E-02_JPRB,&
&.850E-02_JPRB,.767E-02_JPRB,.767E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,&
&.484E-02_JPRB,.484E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.750E-02_JPRB,&
&.750E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.982E-02_JPRB,.982E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 26 -10.0
ZAER (:,26, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.137E-01_JPRB,&
&.137E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.948E-02_JPRB,.948E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,&
&.730E-02_JPRB,.730E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.669E-02_JPRB,&
&.669E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,&
&.907E-02_JPRB,.907E-02_JPRB,.523E-02_JPRB,.523E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.107E-02_JPRB,&
&.107E-02_JPRB,.549E-03_JPRB,.549E-03_JPRB,.424E-03_JPRB,.424E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.703E-02_JPRB,.703E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,.658E-02_JPRB,.658E-02_JPRB,&
&.307E-02_JPRB,.307E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.556E-02_JPRB,&
&.556E-02_JPRB,.620E-02_JPRB,.620E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,&
&.943E-02_JPRB,.943E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 27 -14.0
ZAER (:,27, 7) = (/&
&.101E-01_JPRB,.101E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.137E-01_JPRB,&
&.137E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.948E-02_JPRB,.948E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,&
&.730E-02_JPRB,.730E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.669E-02_JPRB,&
&.669E-02_JPRB,.850E-02_JPRB,.850E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,&
&.907E-02_JPRB,.907E-02_JPRB,.523E-02_JPRB,.523E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.107E-02_JPRB,&
&.107E-02_JPRB,.549E-03_JPRB,.549E-03_JPRB,.424E-03_JPRB,.424E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.703E-02_JPRB,.703E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,.658E-02_JPRB,.658E-02_JPRB,&
&.307E-02_JPRB,.307E-02_JPRB,.561E-02_JPRB,.561E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.556E-02_JPRB,&
&.556E-02_JPRB,.620E-02_JPRB,.620E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,&
&.943E-02_JPRB,.943E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 28 -18.0
ZAER (:,28, 7) = (/&
&.116E-01_JPRB,.116E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,&
&.497E-02_JPRB,.497E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.752E-02_JPRB,&
&.752E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.692E-02_JPRB,.692E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.849E-03_JPRB,&
&.849E-03_JPRB,.789E-03_JPRB,.789E-03_JPRB,.819E-03_JPRB,.819E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.198E-02_JPRB,.198E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.920E-02_JPRB,&
&.920E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,&
&.149E-02_JPRB,.149E-02_JPRB,.269E-02_JPRB,.269E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 29 -22.0
ZAER (:,29, 7) = (/&
&.116E-01_JPRB,.116E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,&
&.497E-02_JPRB,.497E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.752E-02_JPRB,&
&.752E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.692E-02_JPRB,.692E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.849E-03_JPRB,&
&.849E-03_JPRB,.789E-03_JPRB,.789E-03_JPRB,.819E-03_JPRB,.819E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.198E-02_JPRB,.198E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.920E-02_JPRB,&
&.920E-02_JPRB,.543E-02_JPRB,.543E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,&
&.149E-02_JPRB,.149E-02_JPRB,.269E-02_JPRB,.269E-02_JPRB,.394E-02_JPRB,.394E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.926E-02_JPRB,.926E-02_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 30 -26.0
ZAER (:,30, 7) = (/&
&.996E-02_JPRB,.996E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.956E-02_JPRB,.956E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.284E-02_JPRB,.284E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.652E-02_JPRB,.652E-02_JPRB,.277E-02_JPRB,&
&.277E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.221E-02_JPRB,&
&.221E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.773E-03_JPRB,.773E-03_JPRB,.527E-03_JPRB,.527E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.273E-02_JPRB,.273E-02_JPRB,.424E-02_JPRB,&
&.424E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,&
&.888E-02_JPRB,.888E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 31 -30.0
ZAER (:,31, 7) = (/&
&.996E-02_JPRB,.996E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.956E-02_JPRB,.956E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.284E-02_JPRB,.284E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.485E-02_JPRB,.485E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.965E-02_JPRB,.965E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.652E-02_JPRB,.652E-02_JPRB,.277E-02_JPRB,&
&.277E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.221E-02_JPRB,&
&.221E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.773E-03_JPRB,.773E-03_JPRB,.527E-03_JPRB,.527E-03_JPRB,&
&.463E-03_JPRB,.463E-03_JPRB,.537E-03_JPRB,.537E-03_JPRB,.273E-02_JPRB,.273E-02_JPRB,.424E-02_JPRB,&
&.424E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,&
&.888E-02_JPRB,.888E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 32 -34.0
ZAER (:,32, 7) = (/&
&.519E-02_JPRB,.519E-02_JPRB,.555E-02_JPRB,.555E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.730E-02_JPRB,&
&.730E-02_JPRB,.679E-02_JPRB,.679E-02_JPRB,.562E-02_JPRB,.562E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,&
&.301E-02_JPRB,.301E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.307E-02_JPRB,&
&.307E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,&
&.747E-02_JPRB,.747E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.462E-02_JPRB,&
&.462E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,&
&.274E-02_JPRB,.274E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.781E-03_JPRB,.781E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,&
&.274E-03_JPRB,.274E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.186E-02_JPRB,.186E-02_JPRB,.292E-02_JPRB,&
&.292E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.579E-02_JPRB,.579E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,&
&.505E-02_JPRB,.505E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 33 -38.0
ZAER (:,33, 7) = (/&
&.519E-02_JPRB,.519E-02_JPRB,.555E-02_JPRB,.555E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.730E-02_JPRB,&
&.730E-02_JPRB,.679E-02_JPRB,.679E-02_JPRB,.562E-02_JPRB,.562E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,&
&.301E-02_JPRB,.301E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.307E-02_JPRB,&
&.307E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,&
&.747E-02_JPRB,.747E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.462E-02_JPRB,&
&.462E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,&
&.274E-02_JPRB,.274E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.781E-03_JPRB,.781E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,&
&.274E-03_JPRB,.274E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.186E-02_JPRB,.186E-02_JPRB,.292E-02_JPRB,&
&.292E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.579E-02_JPRB,.579E-02_JPRB,.636E-02_JPRB,.636E-02_JPRB,&
&.505E-02_JPRB,.505E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 34 -42.0
ZAER (:,34, 7) = (/&
&.488E-02_JPRB,.488E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.600E-02_JPRB,&
&.600E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,&
&.194E-02_JPRB,.194E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.887E-03_JPRB,&
&.887E-03_JPRB,.233E-02_JPRB,.233E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,&
&.677E-02_JPRB,.677E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.436E-02_JPRB,&
&.436E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,&
&.200E-02_JPRB,.200E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.870E-03_JPRB,&
&.870E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,&
&.287E-03_JPRB,.287E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.392E-02_JPRB,.392E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,&
&.430E-02_JPRB,.430E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 35 -46.0
ZAER (:,35, 7) = (/&
&.488E-02_JPRB,.488E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.600E-02_JPRB,&
&.600E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,&
&.194E-02_JPRB,.194E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.887E-03_JPRB,&
&.887E-03_JPRB,.233E-02_JPRB,.233E-02_JPRB,.447E-02_JPRB,.447E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,&
&.677E-02_JPRB,.677E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.436E-02_JPRB,&
&.436E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,&
&.200E-02_JPRB,.200E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.870E-03_JPRB,&
&.870E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.447E-03_JPRB,.447E-03_JPRB,&
&.287E-03_JPRB,.287E-03_JPRB,.274E-03_JPRB,.274E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,.122E-02_JPRB,&
&.122E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.392E-02_JPRB,.392E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,&
&.430E-02_JPRB,.430E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 36 -50.0
ZAER (:,36, 7) = (/&
&.428E-02_JPRB,.428E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.500E-02_JPRB,&
&.500E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.678E-03_JPRB,.678E-03_JPRB,&
&.576E-03_JPRB,.576E-03_JPRB,.588E-03_JPRB,.588E-03_JPRB,.805E-03_JPRB,.805E-03_JPRB,.904E-03_JPRB,&
&.904E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,.178E-02_JPRB,.178E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,&
&.566E-02_JPRB,.566E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.435E-02_JPRB,&
&.435E-02_JPRB,.258E-02_JPRB,.258E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.108E-02_JPRB,.108E-02_JPRB,.849E-03_JPRB,.849E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,.523E-03_JPRB,&
&.523E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.437E-03_JPRB,.437E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.341E-03_JPRB,&
&.341E-03_JPRB,.138E-02_JPRB,.138E-02_JPRB,.284E-02_JPRB,.284E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,&
&.370E-02_JPRB,.370E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 37 -54.0
ZAER (:,37, 7) = (/&
&.428E-02_JPRB,.428E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.500E-02_JPRB,&
&.500E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.678E-03_JPRB,.678E-03_JPRB,&
&.576E-03_JPRB,.576E-03_JPRB,.588E-03_JPRB,.588E-03_JPRB,.805E-03_JPRB,.805E-03_JPRB,.904E-03_JPRB,&
&.904E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,.178E-02_JPRB,.178E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,&
&.566E-02_JPRB,.566E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.435E-02_JPRB,&
&.435E-02_JPRB,.258E-02_JPRB,.258E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.108E-02_JPRB,.108E-02_JPRB,.849E-03_JPRB,.849E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,.523E-03_JPRB,&
&.523E-03_JPRB,.452E-03_JPRB,.452E-03_JPRB,.437E-03_JPRB,.437E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.341E-03_JPRB,&
&.341E-03_JPRB,.138E-02_JPRB,.138E-02_JPRB,.284E-02_JPRB,.284E-02_JPRB,.335E-02_JPRB,.335E-02_JPRB,&
&.370E-02_JPRB,.370E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 38 -58.0
ZAER (:,38, 7) = (/&
&.340E-02_JPRB,.340E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.219E-02_JPRB,&
&.219E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.684E-03_JPRB,.684E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.367E-03_JPRB,.367E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.246E-02_JPRB,.246E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,&
&.462E-02_JPRB,.462E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.486E-02_JPRB,&
&.486E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.945E-03_JPRB,.945E-03_JPRB,.739E-03_JPRB,.739E-03_JPRB,.578E-03_JPRB,.578E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.443E-03_JPRB,.443E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,&
&.350E-03_JPRB,.350E-03_JPRB,.321E-03_JPRB,.321E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.315E-03_JPRB,&
&.315E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.173E-02_JPRB,.173E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,&
&.271E-02_JPRB,.271E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 39 -62.0
ZAER (:,39, 7) = (/&
&.340E-02_JPRB,.340E-02_JPRB,.338E-02_JPRB,.338E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.219E-02_JPRB,&
&.219E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.684E-03_JPRB,.684E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.367E-03_JPRB,.367E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.246E-02_JPRB,.246E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,&
&.462E-02_JPRB,.462E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.486E-02_JPRB,&
&.486E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,&
&.945E-03_JPRB,.945E-03_JPRB,.739E-03_JPRB,.739E-03_JPRB,.578E-03_JPRB,.578E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.443E-03_JPRB,.443E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,&
&.350E-03_JPRB,.350E-03_JPRB,.321E-03_JPRB,.321E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.315E-03_JPRB,&
&.315E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.173E-02_JPRB,.173E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,&
&.271E-02_JPRB,.271E-02_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 40 -66.0
ZAER (:,40, 7) = (/&
&.165E-02_JPRB,.165E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.739E-03_JPRB,&
&.739E-03_JPRB,.933E-03_JPRB,.933E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,.617E-03_JPRB,.617E-03_JPRB,&
&.486E-03_JPRB,.486E-03_JPRB,.684E-03_JPRB,.684E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.912E-03_JPRB,.912E-03_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.284E-02_JPRB,.284E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.139E-02_JPRB,.139E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.675E-03_JPRB,.675E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,.391E-03_JPRB,.391E-03_JPRB,&
&.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.492E-03_JPRB,&
&.492E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,&
&.867E-03_JPRB,.867E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 41 -70.0
ZAER (:,41, 7) = (/&
&.165E-02_JPRB,.165E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.739E-03_JPRB,&
&.739E-03_JPRB,.933E-03_JPRB,.933E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,.617E-03_JPRB,.617E-03_JPRB,&
&.486E-03_JPRB,.486E-03_JPRB,.684E-03_JPRB,.684E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.104E-02_JPRB,&
&.104E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.912E-03_JPRB,.912E-03_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.284E-02_JPRB,.284E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,&
&.139E-02_JPRB,.139E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.675E-03_JPRB,.675E-03_JPRB,.516E-03_JPRB,.516E-03_JPRB,.391E-03_JPRB,.391E-03_JPRB,&
&.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.318E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.492E-03_JPRB,&
&.492E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,.504E-03_JPRB,.504E-03_JPRB,.703E-03_JPRB,.703E-03_JPRB,&
&.867E-03_JPRB,.867E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 42 -74.0
ZAER (:,42, 7) = (/&
&.766E-03_JPRB,.766E-03_JPRB,.113E-02_JPRB,.113E-02_JPRB,.800E-03_JPRB,.800E-03_JPRB,.613E-03_JPRB,&
&.613E-03_JPRB,.686E-03_JPRB,.686E-03_JPRB,.820E-03_JPRB,.820E-03_JPRB,.614E-03_JPRB,.614E-03_JPRB,&
&.543E-03_JPRB,.543E-03_JPRB,.535E-03_JPRB,.535E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.513E-03_JPRB,.513E-03_JPRB,&
&.427E-03_JPRB,.427E-03_JPRB,.442E-03_JPRB,.442E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,.251E-02_JPRB,&
&.251E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.248E-02_JPRB,.248E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,&
&.243E-02_JPRB,.243E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.555E-03_JPRB,.555E-03_JPRB,&
&.358E-03_JPRB,.358E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.140E-02_JPRB,&
&.140E-02_JPRB,.440E-03_JPRB,.440E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.456E-03_JPRB,.456E-03_JPRB,&
&.573E-03_JPRB,.573E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 43 -78.0
ZAER (:,43, 7) = (/&
&.766E-03_JPRB,.766E-03_JPRB,.113E-02_JPRB,.113E-02_JPRB,.800E-03_JPRB,.800E-03_JPRB,.613E-03_JPRB,&
&.613E-03_JPRB,.686E-03_JPRB,.686E-03_JPRB,.820E-03_JPRB,.820E-03_JPRB,.614E-03_JPRB,.614E-03_JPRB,&
&.543E-03_JPRB,.543E-03_JPRB,.535E-03_JPRB,.535E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.513E-03_JPRB,.513E-03_JPRB,&
&.427E-03_JPRB,.427E-03_JPRB,.442E-03_JPRB,.442E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,.251E-02_JPRB,&
&.251E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.248E-02_JPRB,.248E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,&
&.243E-02_JPRB,.243E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.555E-03_JPRB,.555E-03_JPRB,&
&.358E-03_JPRB,.358E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.140E-02_JPRB,&
&.140E-02_JPRB,.440E-03_JPRB,.440E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.456E-03_JPRB,.456E-03_JPRB,&
&.573E-03_JPRB,.573E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 44 -82.0
ZAER (:,44, 7) = (/&
&.398E-03_JPRB,.398E-03_JPRB,.378E-03_JPRB,.378E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.348E-03_JPRB,&
&.348E-03_JPRB,.356E-03_JPRB,.356E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,&
&.362E-03_JPRB,.362E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.383E-03_JPRB,.383E-03_JPRB,&
&.372E-03_JPRB,.372E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.622E-03_JPRB,.622E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB,.469E-03_JPRB,.469E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.421E-03_JPRB,&
&.421E-03_JPRB,.398E-03_JPRB,.398E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.405E-03_JPRB,.405E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.401E-03_JPRB,&
&.401E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,&
&.400E-03_JPRB,.400E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 45 -86.0
ZAER (:,45, 7) = (/&
&.398E-03_JPRB,.398E-03_JPRB,.378E-03_JPRB,.378E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.348E-03_JPRB,&
&.348E-03_JPRB,.356E-03_JPRB,.356E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,&
&.362E-03_JPRB,.362E-03_JPRB,.386E-03_JPRB,.386E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.504E-03_JPRB,&
&.504E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.383E-03_JPRB,.383E-03_JPRB,&
&.372E-03_JPRB,.372E-03_JPRB,.387E-03_JPRB,.387E-03_JPRB,.522E-03_JPRB,.522E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.918E-03_JPRB,.918E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.622E-03_JPRB,.622E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB,.469E-03_JPRB,.469E-03_JPRB,.431E-03_JPRB,.431E-03_JPRB,.421E-03_JPRB,&
&.421E-03_JPRB,.398E-03_JPRB,.398E-03_JPRB,.364E-03_JPRB,.364E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.405E-03_JPRB,.405E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.401E-03_JPRB,&
&.401E-03_JPRB,.377E-03_JPRB,.377E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,&
&.400E-03_JPRB,.400E-03_JPRB/)
!-- Sea Salt Aerosol         month:  7 --- lat: 46 -90.0
ZAER (:,46, 7) = (/&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,.265E-03_JPRB,&
&.265E-03_JPRB,.265E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  1  90.0
ZAER (:, 1, 8) = (/&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,.459E-03_JPRB,&
&.459E-03_JPRB,.459E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  2  86.0
ZAER (:, 2, 8) = (/&
&.876E-03_JPRB,.876E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,&
&.837E-03_JPRB,.837E-03_JPRB,.733E-03_JPRB,.733E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.503E-03_JPRB,&
&.503E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,&
&.410E-03_JPRB,.410E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.319E-03_JPRB,.319E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,&
&.359E-03_JPRB,.359E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.385E-03_JPRB,&
&.385E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.400E-03_JPRB,.400E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,&
&.375E-03_JPRB,.375E-03_JPRB,.382E-03_JPRB,.382E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.432E-03_JPRB,&
&.432E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,.532E-03_JPRB,.532E-03_JPRB,.636E-03_JPRB,.636E-03_JPRB,&
&.760E-03_JPRB,.760E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  3  82.0
ZAER (:, 3, 8) = (/&
&.876E-03_JPRB,.876E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,&
&.837E-03_JPRB,.837E-03_JPRB,.733E-03_JPRB,.733E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.503E-03_JPRB,&
&.503E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,&
&.410E-03_JPRB,.410E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.319E-03_JPRB,.319E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,&
&.359E-03_JPRB,.359E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,.385E-03_JPRB,&
&.385E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.400E-03_JPRB,.400E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,&
&.375E-03_JPRB,.375E-03_JPRB,.382E-03_JPRB,.382E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.432E-03_JPRB,&
&.432E-03_JPRB,.473E-03_JPRB,.473E-03_JPRB,.532E-03_JPRB,.532E-03_JPRB,.636E-03_JPRB,.636E-03_JPRB,&
&.760E-03_JPRB,.760E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  4  78.0
ZAER (:, 4, 8) = (/&
&.744E-03_JPRB,.744E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.139E-02_JPRB,.139E-02_JPRB,.170E-02_JPRB,&
&.170E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.112E-02_JPRB,&
&.112E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,&
&.841E-03_JPRB,.841E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.372E-03_JPRB,&
&.372E-03_JPRB,.310E-03_JPRB,.310E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.492E-03_JPRB,.492E-03_JPRB,.545E-03_JPRB,&
&.545E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,.361E-03_JPRB,&
&.361E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,.494E-03_JPRB,.494E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,&
&.698E-03_JPRB,.698E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  5  74.0
ZAER (:, 5, 8) = (/&
&.744E-03_JPRB,.744E-03_JPRB,.972E-03_JPRB,.972E-03_JPRB,.139E-02_JPRB,.139E-02_JPRB,.170E-02_JPRB,&
&.170E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.112E-02_JPRB,&
&.112E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,&
&.841E-03_JPRB,.841E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,.372E-03_JPRB,&
&.372E-03_JPRB,.310E-03_JPRB,.310E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,&
&.426E-03_JPRB,.426E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.492E-03_JPRB,.492E-03_JPRB,.545E-03_JPRB,&
&.545E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,.597E-03_JPRB,.597E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.307E-03_JPRB,.307E-03_JPRB,.361E-03_JPRB,&
&.361E-03_JPRB,.429E-03_JPRB,.429E-03_JPRB,.494E-03_JPRB,.494E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,&
&.698E-03_JPRB,.698E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  6  70.0
ZAER (:, 6, 8) = (/&
&.171E-02_JPRB,.171E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.256E-02_JPRB,&
&.256E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.233E-02_JPRB,.233E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.278E-02_JPRB,&
&.278E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.561E-03_JPRB,.561E-03_JPRB,.524E-03_JPRB,&
&.524E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,&
&.658E-03_JPRB,.658E-03_JPRB,.806E-03_JPRB,.806E-03_JPRB,.890E-03_JPRB,.890E-03_JPRB,.959E-03_JPRB,&
&.959E-03_JPRB,.108E-02_JPRB,.108E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.868E-03_JPRB,.868E-03_JPRB,.767E-03_JPRB,.767E-03_JPRB,.776E-03_JPRB,&
&.776E-03_JPRB,.864E-03_JPRB,.864E-03_JPRB,.996E-03_JPRB,.996E-03_JPRB,.125E-02_JPRB,.125E-02_JPRB,&
&.146E-02_JPRB,.146E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  7  66.0
ZAER (:, 7, 8) = (/&
&.171E-02_JPRB,.171E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.256E-02_JPRB,&
&.256E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.233E-02_JPRB,.233E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.278E-02_JPRB,&
&.278E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.561E-03_JPRB,.561E-03_JPRB,.524E-03_JPRB,&
&.524E-03_JPRB,.573E-03_JPRB,.573E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.606E-03_JPRB,.606E-03_JPRB,&
&.658E-03_JPRB,.658E-03_JPRB,.806E-03_JPRB,.806E-03_JPRB,.890E-03_JPRB,.890E-03_JPRB,.959E-03_JPRB,&
&.959E-03_JPRB,.108E-02_JPRB,.108E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.868E-03_JPRB,.868E-03_JPRB,.767E-03_JPRB,.767E-03_JPRB,.776E-03_JPRB,&
&.776E-03_JPRB,.864E-03_JPRB,.864E-03_JPRB,.996E-03_JPRB,.996E-03_JPRB,.125E-02_JPRB,.125E-02_JPRB,&
&.146E-02_JPRB,.146E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  8  62.0
ZAER (:, 8, 8) = (/&
&.781E-02_JPRB,.781E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.465E-02_JPRB,&
&.465E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.684E-02_JPRB,.684E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.785E-03_JPRB,.785E-03_JPRB,.900E-03_JPRB,&
&.900E-03_JPRB,.131E-02_JPRB,.131E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.171E-02_JPRB,.171E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.263E-02_JPRB,&
&.263E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,&
&.312E-02_JPRB,.312E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.354E-02_JPRB,&
&.354E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.360E-02_JPRB,.360E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,&
&.704E-02_JPRB,.704E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat:  9  58.0
ZAER (:, 9, 8) = (/&
&.781E-02_JPRB,.781E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.465E-02_JPRB,&
&.465E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.684E-02_JPRB,.684E-02_JPRB,.401E-02_JPRB,.401E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.785E-03_JPRB,.785E-03_JPRB,.900E-03_JPRB,&
&.900E-03_JPRB,.131E-02_JPRB,.131E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.171E-02_JPRB,.171E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.263E-02_JPRB,&
&.263E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,&
&.312E-02_JPRB,.312E-02_JPRB,.424E-02_JPRB,.424E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.354E-02_JPRB,&
&.354E-02_JPRB,.380E-02_JPRB,.380E-02_JPRB,.360E-02_JPRB,.360E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,&
&.704E-02_JPRB,.704E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 10  54.0
ZAER (:,10, 8) = (/&
&.926E-02_JPRB,.926E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,.618E-02_JPRB,&
&.618E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.724E-02_JPRB,.724E-02_JPRB,&
&.924E-02_JPRB,.924E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.994E-02_JPRB,&
&.994E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 11  50.0
ZAER (:,11, 8) = (/&
&.926E-02_JPRB,.926E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.993E-02_JPRB,.993E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.850E-02_JPRB,.850E-02_JPRB,.681E-02_JPRB,.681E-02_JPRB,.611E-02_JPRB,.611E-02_JPRB,.618E-02_JPRB,&
&.618E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.724E-02_JPRB,.724E-02_JPRB,&
&.924E-02_JPRB,.924E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.994E-02_JPRB,&
&.994E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 12  46.0
ZAER (:,12, 8) = (/&
&.979E-02_JPRB,.979E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.922E-02_JPRB,&
&.922E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.983E-02_JPRB,.983E-02_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.886E-02_JPRB,.886E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.759E-02_JPRB,.759E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 13  42.0
ZAER (:,13, 8) = (/&
&.979E-02_JPRB,.979E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.922E-02_JPRB,&
&.922E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.983E-02_JPRB,.983E-02_JPRB,.133E-01_JPRB,.133E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.130E-01_JPRB,.130E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.886E-02_JPRB,.886E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,&
&.759E-02_JPRB,.759E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 14  38.0
ZAER (:,14, 8) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.810E-02_JPRB,&
&.810E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,&
&.993E-02_JPRB,.993E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,.919E-02_JPRB,&
&.919E-02_JPRB,.898E-02_JPRB,.898E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.947E-02_JPRB,.947E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.963E-02_JPRB,.963E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,&
&.916E-02_JPRB,.916E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.763E-02_JPRB,&
&.763E-02_JPRB,.474E-02_JPRB,.474E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 15  34.0
ZAER (:,15, 8) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.112E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.810E-02_JPRB,&
&.810E-02_JPRB,.443E-02_JPRB,.443E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,&
&.993E-02_JPRB,.993E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,.919E-02_JPRB,&
&.919E-02_JPRB,.898E-02_JPRB,.898E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.947E-02_JPRB,.947E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.994E-02_JPRB,.994E-02_JPRB,.963E-02_JPRB,.963E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,&
&.916E-02_JPRB,.916E-02_JPRB,.870E-02_JPRB,.870E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.763E-02_JPRB,&
&.763E-02_JPRB,.474E-02_JPRB,.474E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 16  30.0
ZAER (:,16, 8) = (/&
&.113E-01_JPRB,.113E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,.997E-02_JPRB,.997E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.997E-02_JPRB,.997E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.824E-02_JPRB,&
&.824E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,&
&.768E-02_JPRB,.768E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.846E-02_JPRB,&
&.846E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.513E-02_JPRB,.513E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.123E-01_JPRB,.123E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 17  26.0
ZAER (:,17, 8) = (/&
&.113E-01_JPRB,.113E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.104E-01_JPRB,&
&.104E-01_JPRB,.996E-02_JPRB,.996E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,.997E-02_JPRB,.997E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.997E-02_JPRB,.997E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.824E-02_JPRB,&
&.824E-02_JPRB,.477E-02_JPRB,.477E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,.508E-02_JPRB,.508E-02_JPRB,&
&.768E-02_JPRB,.768E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.846E-02_JPRB,&
&.846E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.513E-02_JPRB,.513E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.913E-02_JPRB,.913E-02_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.973E-02_JPRB,.973E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,&
&.867E-02_JPRB,.867E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.309E-02_JPRB,.309E-02_JPRB,.600E-02_JPRB,.600E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,&
&.123E-01_JPRB,.123E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 18  22.0
ZAER (:,18, 8) = (/&
&.129E-01_JPRB,.129E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.928E-02_JPRB,.928E-02_JPRB,.764E-02_JPRB,&
&.764E-02_JPRB,.457E-02_JPRB,.457E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.312E-02_JPRB,.312E-02_JPRB,&
&.651E-02_JPRB,.651E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.791E-02_JPRB,&
&.791E-02_JPRB,.698E-02_JPRB,.698E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,&
&.314E-02_JPRB,.314E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.904E-02_JPRB,.904E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.457E-02_JPRB,&
&.457E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.123E-01_JPRB,.123E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 19  18.0
ZAER (:,19, 8) = (/&
&.129E-01_JPRB,.129E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.928E-02_JPRB,.928E-02_JPRB,.764E-02_JPRB,&
&.764E-02_JPRB,.457E-02_JPRB,.457E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.312E-02_JPRB,.312E-02_JPRB,&
&.651E-02_JPRB,.651E-02_JPRB,.942E-02_JPRB,.942E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.791E-02_JPRB,&
&.791E-02_JPRB,.698E-02_JPRB,.698E-02_JPRB,.473E-02_JPRB,.473E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,&
&.314E-02_JPRB,.314E-02_JPRB,.576E-02_JPRB,.576E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.904E-02_JPRB,.904E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.457E-02_JPRB,&
&.457E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.123E-01_JPRB,.123E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 20  14.0
ZAER (:,20, 8) = (/&
&.163E-01_JPRB,.163E-01_JPRB,.166E-01_JPRB,.166E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.752E-02_JPRB,.752E-02_JPRB,.988E-02_JPRB,.988E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.596E-02_JPRB,&
&.596E-02_JPRB,.451E-02_JPRB,.451E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,&
&.344E-02_JPRB,.344E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.877E-02_JPRB,.877E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.125E-01_JPRB,.125E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 21  10.0
ZAER (:,21, 8) = (/&
&.163E-01_JPRB,.163E-01_JPRB,.166E-01_JPRB,.166E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,&
&.752E-02_JPRB,.752E-02_JPRB,.988E-02_JPRB,.988E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.596E-02_JPRB,&
&.596E-02_JPRB,.451E-02_JPRB,.451E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,&
&.344E-02_JPRB,.344E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.877E-02_JPRB,.877E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.125E-01_JPRB,.125E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 22   6.0
ZAER (:,22, 8) = (/&
&.167E-01_JPRB,.167E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.900E-02_JPRB,.900E-02_JPRB,&
&.746E-02_JPRB,.746E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.465E-02_JPRB,.465E-02_JPRB,.234E-02_JPRB,&
&.234E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,&
&.851E-02_JPRB,.851E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.428E-02_JPRB,&
&.428E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,&
&.554E-02_JPRB,.554E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,&
&.700E-02_JPRB,.700E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 23   2.0
ZAER (:,23, 8) = (/&
&.167E-01_JPRB,.167E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.160E-01_JPRB,.160E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.900E-02_JPRB,.900E-02_JPRB,&
&.746E-02_JPRB,.746E-02_JPRB,.595E-02_JPRB,.595E-02_JPRB,.465E-02_JPRB,.465E-02_JPRB,.234E-02_JPRB,&
&.234E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,&
&.851E-02_JPRB,.851E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.428E-02_JPRB,&
&.428E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,&
&.554E-02_JPRB,.554E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.918E-02_JPRB,&
&.918E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,&
&.700E-02_JPRB,.700E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.156E-01_JPRB,.156E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 24  -2.0
ZAER (:,24, 8) = (/&
&.116E-01_JPRB,.116E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.143E-01_JPRB,&
&.143E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.839E-02_JPRB,.839E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,.326E-02_JPRB,&
&.326E-02_JPRB,.372E-02_JPRB,.372E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.908E-02_JPRB,.908E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,.319E-02_JPRB,&
&.319E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.927E-03_JPRB,.927E-03_JPRB,.193E-02_JPRB,.193E-02_JPRB,&
&.418E-02_JPRB,.418E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.766E-02_JPRB,&
&.766E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.596E-02_JPRB,.596E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.743E-02_JPRB,&
&.743E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 25  -6.0
ZAER (:,25, 8) = (/&
&.116E-01_JPRB,.116E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.143E-01_JPRB,&
&.143E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.839E-02_JPRB,.839E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,.326E-02_JPRB,&
&.326E-02_JPRB,.372E-02_JPRB,.372E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.908E-02_JPRB,.908E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,.319E-02_JPRB,&
&.319E-02_JPRB,.243E-02_JPRB,.243E-02_JPRB,.927E-03_JPRB,.927E-03_JPRB,.193E-02_JPRB,.193E-02_JPRB,&
&.418E-02_JPRB,.418E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.766E-02_JPRB,&
&.766E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.598E-02_JPRB,.598E-02_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.596E-02_JPRB,.596E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.743E-02_JPRB,&
&.743E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 26 -10.0
ZAER (:,26, 8) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.138E-01_JPRB,&
&.138E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.808E-02_JPRB,.808E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.699E-02_JPRB,&
&.699E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.832E-02_JPRB,.832E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.646E-03_JPRB,&
&.646E-03_JPRB,.371E-03_JPRB,.371E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,&
&.211E-02_JPRB,.211E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,&
&.334E-02_JPRB,.334E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.725E-02_JPRB,&
&.725E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 27 -14.0
ZAER (:,27, 8) = (/&
&.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.138E-01_JPRB,&
&.138E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.808E-02_JPRB,.808E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.699E-02_JPRB,&
&.699E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.109E-01_JPRB,.109E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.832E-02_JPRB,.832E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.646E-03_JPRB,&
&.646E-03_JPRB,.371E-03_JPRB,.371E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.895E-03_JPRB,.895E-03_JPRB,&
&.211E-02_JPRB,.211E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.946E-02_JPRB,&
&.946E-02_JPRB,.669E-02_JPRB,.669E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,&
&.334E-02_JPRB,.334E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.532E-02_JPRB,.532E-02_JPRB,.725E-02_JPRB,&
&.725E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,&
&.100E-01_JPRB,.100E-01_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 28 -18.0
ZAER (:,28, 8) = (/&
&.127E-01_JPRB,.127E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,&
&.438E-02_JPRB,.438E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.933E-02_JPRB,&
&.933E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.730E-02_JPRB,.730E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.755E-03_JPRB,&
&.755E-03_JPRB,.645E-03_JPRB,.645E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,.892E-03_JPRB,.892E-03_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.635E-02_JPRB,&
&.635E-02_JPRB,.378E-02_JPRB,.378E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.962E-02_JPRB,&
&.962E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.925E-02_JPRB,.925E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.997E-02_JPRB,.997E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 29 -22.0
ZAER (:,29, 8) = (/&
&.127E-01_JPRB,.127E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.989E-02_JPRB,.989E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,&
&.438E-02_JPRB,.438E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.933E-02_JPRB,&
&.933E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.730E-02_JPRB,.730E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.755E-03_JPRB,&
&.755E-03_JPRB,.645E-03_JPRB,.645E-03_JPRB,.754E-03_JPRB,.754E-03_JPRB,.892E-03_JPRB,.892E-03_JPRB,&
&.129E-02_JPRB,.129E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.635E-02_JPRB,&
&.635E-02_JPRB,.378E-02_JPRB,.378E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.962E-02_JPRB,&
&.962E-02_JPRB,.968E-02_JPRB,.968E-02_JPRB,.925E-02_JPRB,.925E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.997E-02_JPRB,.997E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 30 -26.0
ZAER (:,30, 8) = (/&
&.105E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.790E-02_JPRB,.790E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.236E-02_JPRB,.236E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.721E-02_JPRB,.721E-02_JPRB,.324E-02_JPRB,&
&.324E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,&
&.204E-02_JPRB,.204E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.187E-02_JPRB,&
&.187E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.702E-03_JPRB,.702E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,&
&.704E-03_JPRB,.704E-03_JPRB,.200E-02_JPRB,.200E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.675E-02_JPRB,&
&.675E-02_JPRB,.793E-02_JPRB,.793E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,&
&.937E-02_JPRB,.937E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 31 -30.0
ZAER (:,31, 8) = (/&
&.105E-01_JPRB,.105E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.790E-02_JPRB,.790E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,&
&.236E-02_JPRB,.236E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.449E-02_JPRB,.449E-02_JPRB,.605E-02_JPRB,&
&.605E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.721E-02_JPRB,.721E-02_JPRB,.324E-02_JPRB,&
&.324E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,&
&.204E-02_JPRB,.204E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.187E-02_JPRB,&
&.187E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.702E-03_JPRB,.702E-03_JPRB,.662E-03_JPRB,.662E-03_JPRB,&
&.704E-03_JPRB,.704E-03_JPRB,.200E-02_JPRB,.200E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,.675E-02_JPRB,&
&.675E-02_JPRB,.793E-02_JPRB,.793E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.835E-02_JPRB,.835E-02_JPRB,&
&.937E-02_JPRB,.937E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 32 -34.0
ZAER (:,32, 8) = (/&
&.754E-02_JPRB,.754E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,&
&.195E-02_JPRB,.195E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.273E-02_JPRB,&
&.273E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.951E-02_JPRB,.951E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.748E-02_JPRB,.748E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,&
&.339E-02_JPRB,.339E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.139E-02_JPRB,&
&.139E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.902E-03_JPRB,.902E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,&
&.495E-03_JPRB,.495E-03_JPRB,.847E-03_JPRB,.847E-03_JPRB,.232E-02_JPRB,.232E-02_JPRB,.267E-02_JPRB,&
&.267E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.764E-02_JPRB,.764E-02_JPRB,&
&.738E-02_JPRB,.738E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 33 -38.0
ZAER (:,33, 8) = (/&
&.754E-02_JPRB,.754E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.415E-02_JPRB,.415E-02_JPRB,&
&.195E-02_JPRB,.195E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.208E-02_JPRB,.208E-02_JPRB,.273E-02_JPRB,&
&.273E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,&
&.951E-02_JPRB,.951E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.748E-02_JPRB,.748E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.388E-02_JPRB,.388E-02_JPRB,.400E-02_JPRB,.400E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,&
&.339E-02_JPRB,.339E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.139E-02_JPRB,&
&.139E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.902E-03_JPRB,.902E-03_JPRB,.720E-03_JPRB,.720E-03_JPRB,&
&.495E-03_JPRB,.495E-03_JPRB,.847E-03_JPRB,.847E-03_JPRB,.232E-02_JPRB,.232E-02_JPRB,.267E-02_JPRB,&
&.267E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.764E-02_JPRB,.764E-02_JPRB,&
&.738E-02_JPRB,.738E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 34 -42.0
ZAER (:,34, 8) = (/&
&.556E-02_JPRB,.556E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.663E-02_JPRB,&
&.663E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,&
&.269E-02_JPRB,.269E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.113E-02_JPRB,&
&.113E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.672E-02_JPRB,.672E-02_JPRB,.465E-02_JPRB,&
&.465E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.250E-02_JPRB,.250E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.987E-03_JPRB,&
&.987E-03_JPRB,.816E-03_JPRB,.816E-03_JPRB,.752E-03_JPRB,.752E-03_JPRB,.644E-03_JPRB,.644E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,&
&.573E-02_JPRB,.573E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 35 -46.0
ZAER (:,35, 8) = (/&
&.556E-02_JPRB,.556E-02_JPRB,.529E-02_JPRB,.529E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.663E-02_JPRB,&
&.663E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,&
&.269E-02_JPRB,.269E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.113E-02_JPRB,&
&.113E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,&
&.760E-02_JPRB,.760E-02_JPRB,.730E-02_JPRB,.730E-02_JPRB,.672E-02_JPRB,.672E-02_JPRB,.465E-02_JPRB,&
&.465E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,&
&.250E-02_JPRB,.250E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.987E-03_JPRB,&
&.987E-03_JPRB,.816E-03_JPRB,.816E-03_JPRB,.752E-03_JPRB,.752E-03_JPRB,.644E-03_JPRB,.644E-03_JPRB,&
&.504E-03_JPRB,.504E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,&
&.573E-02_JPRB,.573E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 36 -50.0
ZAER (:,36, 8) = (/&
&.488E-02_JPRB,.488E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.508E-02_JPRB,&
&.508E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.842E-03_JPRB,.842E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,.871E-03_JPRB,&
&.871E-03_JPRB,.702E-03_JPRB,.702E-03_JPRB,.210E-02_JPRB,.210E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,&
&.631E-02_JPRB,.631E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.491E-02_JPRB,&
&.491E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,.677E-03_JPRB,.677E-03_JPRB,.609E-03_JPRB,&
&.609E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.546E-03_JPRB,.546E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,&
&.465E-03_JPRB,.465E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.565E-03_JPRB,&
&.565E-03_JPRB,.203E-02_JPRB,.203E-02_JPRB,.355E-02_JPRB,.355E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,&
&.526E-02_JPRB,.526E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 37 -54.0
ZAER (:,37, 8) = (/&
&.488E-02_JPRB,.488E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.508E-02_JPRB,&
&.508E-02_JPRB,.545E-02_JPRB,.545E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,&
&.105E-02_JPRB,.105E-02_JPRB,.842E-03_JPRB,.842E-03_JPRB,.904E-03_JPRB,.904E-03_JPRB,.871E-03_JPRB,&
&.871E-03_JPRB,.702E-03_JPRB,.702E-03_JPRB,.210E-02_JPRB,.210E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,&
&.631E-02_JPRB,.631E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.491E-02_JPRB,&
&.491E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,.677E-03_JPRB,.677E-03_JPRB,.609E-03_JPRB,&
&.609E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.546E-03_JPRB,.546E-03_JPRB,.515E-03_JPRB,.515E-03_JPRB,&
&.465E-03_JPRB,.465E-03_JPRB,.428E-03_JPRB,.428E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.565E-03_JPRB,&
&.565E-03_JPRB,.203E-02_JPRB,.203E-02_JPRB,.355E-02_JPRB,.355E-02_JPRB,.467E-02_JPRB,.467E-02_JPRB,&
&.526E-02_JPRB,.526E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 38 -58.0
ZAER (:,38, 8) = (/&
&.431E-02_JPRB,.431E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.560E-03_JPRB,.560E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.610E-03_JPRB,.610E-03_JPRB,.259E-02_JPRB,.259E-02_JPRB,.178E-02_JPRB,&
&.178E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.397E-02_JPRB,.397E-02_JPRB,&
&.595E-02_JPRB,.595E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,.695E-02_JPRB,.695E-02_JPRB,.581E-02_JPRB,&
&.581E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.956E-03_JPRB,.956E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,.689E-03_JPRB,&
&.689E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.488E-03_JPRB,.488E-03_JPRB,&
&.433E-03_JPRB,.433E-03_JPRB,.398E-03_JPRB,.398E-03_JPRB,.363E-03_JPRB,.363E-03_JPRB,.381E-03_JPRB,&
&.381E-03_JPRB,.111E-02_JPRB,.111E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,&
&.363E-02_JPRB,.363E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 39 -62.0
ZAER (:,39, 8) = (/&
&.431E-02_JPRB,.431E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.560E-03_JPRB,.560E-03_JPRB,&
&.425E-03_JPRB,.425E-03_JPRB,.610E-03_JPRB,.610E-03_JPRB,.259E-02_JPRB,.259E-02_JPRB,.178E-02_JPRB,&
&.178E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.397E-02_JPRB,.397E-02_JPRB,&
&.595E-02_JPRB,.595E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,.695E-02_JPRB,.695E-02_JPRB,.581E-02_JPRB,&
&.581E-02_JPRB,.505E-02_JPRB,.505E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,&
&.122E-02_JPRB,.122E-02_JPRB,.956E-03_JPRB,.956E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,.689E-03_JPRB,&
&.689E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,.567E-03_JPRB,.567E-03_JPRB,.488E-03_JPRB,.488E-03_JPRB,&
&.433E-03_JPRB,.433E-03_JPRB,.398E-03_JPRB,.398E-03_JPRB,.363E-03_JPRB,.363E-03_JPRB,.381E-03_JPRB,&
&.381E-03_JPRB,.111E-02_JPRB,.111E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,&
&.363E-02_JPRB,.363E-02_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 40 -66.0
ZAER (:,40, 8) = (/&
&.153E-02_JPRB,.153E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,.709E-03_JPRB,.709E-03_JPRB,.547E-03_JPRB,&
&.547E-03_JPRB,.834E-03_JPRB,.834E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.641E-03_JPRB,.641E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.111E-02_JPRB,&
&.111E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,&
&.133E-02_JPRB,.133E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.552E-02_JPRB,&
&.552E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.713E-03_JPRB,.713E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,&
&.398E-03_JPRB,.398E-03_JPRB,.356E-03_JPRB,.356E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.363E-03_JPRB,&
&.363E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.455E-03_JPRB,.455E-03_JPRB,.601E-03_JPRB,.601E-03_JPRB,&
&.749E-03_JPRB,.749E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 41 -70.0
ZAER (:,41, 8) = (/&
&.153E-02_JPRB,.153E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,.709E-03_JPRB,.709E-03_JPRB,.547E-03_JPRB,&
&.547E-03_JPRB,.834E-03_JPRB,.834E-03_JPRB,.710E-03_JPRB,.710E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,&
&.431E-03_JPRB,.431E-03_JPRB,.641E-03_JPRB,.641E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.111E-02_JPRB,&
&.111E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,&
&.133E-02_JPRB,.133E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.552E-02_JPRB,&
&.552E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.365E-02_JPRB,.365E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.144E-02_JPRB,&
&.144E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.713E-03_JPRB,.713E-03_JPRB,.505E-03_JPRB,.505E-03_JPRB,&
&.398E-03_JPRB,.398E-03_JPRB,.356E-03_JPRB,.356E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.363E-03_JPRB,&
&.363E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.455E-03_JPRB,.455E-03_JPRB,.601E-03_JPRB,.601E-03_JPRB,&
&.749E-03_JPRB,.749E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 42 -74.0
ZAER (:,42, 8) = (/&
&.546E-03_JPRB,.546E-03_JPRB,.905E-03_JPRB,.905E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.360E-03_JPRB,&
&.360E-03_JPRB,.518E-03_JPRB,.518E-03_JPRB,.687E-03_JPRB,.687E-03_JPRB,.498E-03_JPRB,.498E-03_JPRB,&
&.465E-03_JPRB,.465E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,.121E-02_JPRB,&
&.121E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.843E-03_JPRB,.843E-03_JPRB,&
&.575E-03_JPRB,.575E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.314E-02_JPRB,&
&.314E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.373E-02_JPRB,.373E-02_JPRB,.332E-02_JPRB,.332E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.566E-03_JPRB,.566E-03_JPRB,&
&.403E-03_JPRB,.403E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,.121E-02_JPRB,&
&.121E-02_JPRB,.361E-03_JPRB,.361E-03_JPRB,.299E-03_JPRB,.299E-03_JPRB,.322E-03_JPRB,.322E-03_JPRB,&
&.359E-03_JPRB,.359E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 43 -78.0
ZAER (:,43, 8) = (/&
&.546E-03_JPRB,.546E-03_JPRB,.905E-03_JPRB,.905E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.360E-03_JPRB,&
&.360E-03_JPRB,.518E-03_JPRB,.518E-03_JPRB,.687E-03_JPRB,.687E-03_JPRB,.498E-03_JPRB,.498E-03_JPRB,&
&.465E-03_JPRB,.465E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,.121E-02_JPRB,&
&.121E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.199E-02_JPRB,.199E-02_JPRB,.843E-03_JPRB,.843E-03_JPRB,&
&.575E-03_JPRB,.575E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.142E-02_JPRB,.142E-02_JPRB,.314E-02_JPRB,&
&.314E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.373E-02_JPRB,.373E-02_JPRB,.332E-02_JPRB,.332E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.566E-03_JPRB,.566E-03_JPRB,&
&.403E-03_JPRB,.403E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,.121E-02_JPRB,&
&.121E-02_JPRB,.361E-03_JPRB,.361E-03_JPRB,.299E-03_JPRB,.299E-03_JPRB,.322E-03_JPRB,.322E-03_JPRB,&
&.359E-03_JPRB,.359E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 44 -82.0
ZAER (:,44, 8) = (/&
&.354E-03_JPRB,.354E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.312E-03_JPRB,&
&.312E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.506E-03_JPRB,.506E-03_JPRB,.622E-03_JPRB,&
&.622E-03_JPRB,.828E-03_JPRB,.828E-03_JPRB,.830E-03_JPRB,.830E-03_JPRB,.680E-03_JPRB,.680E-03_JPRB,&
&.575E-03_JPRB,.575E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.923E-03_JPRB,.923E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.644E-03_JPRB,.644E-03_JPRB,&
&.482E-03_JPRB,.482E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.507E-03_JPRB,&
&.507E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,&
&.370E-03_JPRB,.370E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.391E-03_JPRB,.391E-03_JPRB,.338E-03_JPRB,&
&.338E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.282E-03_JPRB,.282E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 45 -86.0
ZAER (:,45, 8) = (/&
&.354E-03_JPRB,.354E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.312E-03_JPRB,&
&.312E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.353E-03_JPRB,.353E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.506E-03_JPRB,.506E-03_JPRB,.622E-03_JPRB,&
&.622E-03_JPRB,.828E-03_JPRB,.828E-03_JPRB,.830E-03_JPRB,.830E-03_JPRB,.680E-03_JPRB,.680E-03_JPRB,&
&.575E-03_JPRB,.575E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.923E-03_JPRB,.923E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.644E-03_JPRB,.644E-03_JPRB,&
&.482E-03_JPRB,.482E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.475E-03_JPRB,.475E-03_JPRB,.507E-03_JPRB,&
&.507E-03_JPRB,.500E-03_JPRB,.500E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,&
&.370E-03_JPRB,.370E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.391E-03_JPRB,.391E-03_JPRB,.338E-03_JPRB,&
&.338E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.282E-03_JPRB,.282E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,&
&.320E-03_JPRB,.320E-03_JPRB/)
!-- Sea Salt Aerosol         month:  8 --- lat: 46 -90.0
ZAER (:,46, 8) = (/&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,.261E-03_JPRB,&
&.261E-03_JPRB,.261E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  1  90.0
ZAER (:, 1, 9) = (/&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,.600E-03_JPRB,&
&.600E-03_JPRB,.600E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  2  86.0
ZAER (:, 2, 9) = (/&
&.749E-03_JPRB,.749E-03_JPRB,.750E-03_JPRB,.750E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.809E-03_JPRB,&
&.809E-03_JPRB,.867E-03_JPRB,.867E-03_JPRB,.944E-03_JPRB,.944E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.898E-03_JPRB,.898E-03_JPRB,&
&.758E-03_JPRB,.758E-03_JPRB,.604E-03_JPRB,.604E-03_JPRB,.465E-03_JPRB,.465E-03_JPRB,.357E-03_JPRB,&
&.357E-03_JPRB,.275E-03_JPRB,.275E-03_JPRB,.243E-03_JPRB,.243E-03_JPRB,.239E-03_JPRB,.239E-03_JPRB,&
&.255E-03_JPRB,.255E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,.289E-03_JPRB,&
&.289E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.341E-03_JPRB,.341E-03_JPRB,&
&.381E-03_JPRB,.381E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.439E-03_JPRB,.439E-03_JPRB,.465E-03_JPRB,&
&.465E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.682E-03_JPRB,.682E-03_JPRB,&
&.726E-03_JPRB,.726E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  3  82.0
ZAER (:, 3, 9) = (/&
&.749E-03_JPRB,.749E-03_JPRB,.750E-03_JPRB,.750E-03_JPRB,.775E-03_JPRB,.775E-03_JPRB,.809E-03_JPRB,&
&.809E-03_JPRB,.867E-03_JPRB,.867E-03_JPRB,.944E-03_JPRB,.944E-03_JPRB,.105E-02_JPRB,.105E-02_JPRB,&
&.118E-02_JPRB,.118E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.898E-03_JPRB,.898E-03_JPRB,&
&.758E-03_JPRB,.758E-03_JPRB,.604E-03_JPRB,.604E-03_JPRB,.465E-03_JPRB,.465E-03_JPRB,.357E-03_JPRB,&
&.357E-03_JPRB,.275E-03_JPRB,.275E-03_JPRB,.243E-03_JPRB,.243E-03_JPRB,.239E-03_JPRB,.239E-03_JPRB,&
&.255E-03_JPRB,.255E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.286E-03_JPRB,.286E-03_JPRB,.289E-03_JPRB,&
&.289E-03_JPRB,.300E-03_JPRB,.300E-03_JPRB,.312E-03_JPRB,.312E-03_JPRB,.341E-03_JPRB,.341E-03_JPRB,&
&.381E-03_JPRB,.381E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.439E-03_JPRB,.439E-03_JPRB,.465E-03_JPRB,&
&.465E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.682E-03_JPRB,.682E-03_JPRB,&
&.726E-03_JPRB,.726E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  4  78.0
ZAER (:, 4, 9) = (/&
&.738E-03_JPRB,.738E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.793E-03_JPRB,.793E-03_JPRB,.792E-03_JPRB,&
&.792E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,.936E-03_JPRB,.936E-03_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.104E-02_JPRB,.104E-02_JPRB,.885E-03_JPRB,.885E-03_JPRB,.799E-03_JPRB,.799E-03_JPRB,.728E-03_JPRB,&
&.728E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.326E-03_JPRB,.326E-03_JPRB,&
&.367E-03_JPRB,.367E-03_JPRB,.393E-03_JPRB,.393E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.511E-03_JPRB,&
&.511E-03_JPRB,.544E-03_JPRB,.544E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.379E-03_JPRB,.379E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.419E-03_JPRB,.419E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.421E-03_JPRB,&
&.421E-03_JPRB,.418E-03_JPRB,.418E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.557E-03_JPRB,.557E-03_JPRB,&
&.673E-03_JPRB,.673E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  5  74.0
ZAER (:, 5, 9) = (/&
&.738E-03_JPRB,.738E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.793E-03_JPRB,.793E-03_JPRB,.792E-03_JPRB,&
&.792E-03_JPRB,.791E-03_JPRB,.791E-03_JPRB,.798E-03_JPRB,.798E-03_JPRB,.936E-03_JPRB,.936E-03_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.104E-02_JPRB,.104E-02_JPRB,.885E-03_JPRB,.885E-03_JPRB,.799E-03_JPRB,.799E-03_JPRB,.728E-03_JPRB,&
&.728E-03_JPRB,.471E-03_JPRB,.471E-03_JPRB,.336E-03_JPRB,.336E-03_JPRB,.326E-03_JPRB,.326E-03_JPRB,&
&.367E-03_JPRB,.367E-03_JPRB,.393E-03_JPRB,.393E-03_JPRB,.403E-03_JPRB,.403E-03_JPRB,.511E-03_JPRB,&
&.511E-03_JPRB,.544E-03_JPRB,.544E-03_JPRB,.406E-03_JPRB,.406E-03_JPRB,.379E-03_JPRB,.379E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB,.419E-03_JPRB,.419E-03_JPRB,.425E-03_JPRB,.425E-03_JPRB,.421E-03_JPRB,&
&.421E-03_JPRB,.418E-03_JPRB,.418E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.557E-03_JPRB,.557E-03_JPRB,&
&.673E-03_JPRB,.673E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  6  70.0
ZAER (:, 6, 9) = (/&
&.196E-02_JPRB,.196E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.220E-02_JPRB,&
&.220E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.336E-02_JPRB,.336E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.392E-02_JPRB,&
&.392E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.865E-03_JPRB,.865E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.705E-03_JPRB,.705E-03_JPRB,.774E-03_JPRB,.774E-03_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.255E-02_JPRB,&
&.255E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,&
&.207E-02_JPRB,.207E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  7  66.0
ZAER (:, 7, 9) = (/&
&.196E-02_JPRB,.196E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,.230E-02_JPRB,.230E-02_JPRB,.220E-02_JPRB,&
&.220E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.336E-02_JPRB,.336E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.392E-02_JPRB,&
&.392E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.339E-02_JPRB,.339E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.865E-03_JPRB,.865E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.705E-03_JPRB,.705E-03_JPRB,.774E-03_JPRB,.774E-03_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.223E-02_JPRB,&
&.223E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,&
&.110E-02_JPRB,.110E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.255E-02_JPRB,&
&.255E-02_JPRB,.205E-02_JPRB,.205E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,&
&.207E-02_JPRB,.207E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  8  62.0
ZAER (:, 8, 9) = (/&
&.948E-02_JPRB,.948E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.965E-02_JPRB,&
&.965E-02_JPRB,.903E-02_JPRB,.903E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,&
&.278E-02_JPRB,.278E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.953E-03_JPRB,&
&.953E-03_JPRB,.146E-02_JPRB,.146E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,&
&.258E-02_JPRB,.258E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.796E-02_JPRB,&
&.796E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,&
&.667E-02_JPRB,.667E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat:  9  58.0
ZAER (:, 9, 9) = (/&
&.948E-02_JPRB,.948E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.979E-02_JPRB,.979E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.965E-02_JPRB,&
&.965E-02_JPRB,.903E-02_JPRB,.903E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,&
&.278E-02_JPRB,.278E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.953E-03_JPRB,&
&.953E-03_JPRB,.146E-02_JPRB,.146E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,&
&.258E-02_JPRB,.258E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,.796E-02_JPRB,&
&.796E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,&
&.667E-02_JPRB,.667E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.117E-01_JPRB,&
&.117E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.861E-02_JPRB,.861E-02_JPRB,.970E-02_JPRB,.970E-02_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 10  54.0
ZAER (:,10, 9) = (/&
&.916E-02_JPRB,.916E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.993E-02_JPRB,&
&.993E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,&
&.927E-02_JPRB,.927E-02_JPRB,.909E-02_JPRB,.909E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.835E-02_JPRB,&
&.835E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,&
&.878E-02_JPRB,.878E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 11  50.0
ZAER (:,11, 9) = (/&
&.916E-02_JPRB,.916E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.993E-02_JPRB,&
&.993E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.951E-02_JPRB,.951E-02_JPRB,&
&.927E-02_JPRB,.927E-02_JPRB,.909E-02_JPRB,.909E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.835E-02_JPRB,&
&.835E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,&
&.878E-02_JPRB,.878E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 12  46.0
ZAER (:,12, 9) = (/&
&.768E-02_JPRB,.768E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.908E-02_JPRB,&
&.908E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.982E-02_JPRB,.982E-02_JPRB,.984E-02_JPRB,&
&.984E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.953E-02_JPRB,.953E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.874E-02_JPRB,.874E-02_JPRB,.916E-02_JPRB,.916E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,&
&.649E-02_JPRB,.649E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 13  42.0
ZAER (:,13, 9) = (/&
&.768E-02_JPRB,.768E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.908E-02_JPRB,&
&.908E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.111E-01_JPRB,.111E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.982E-02_JPRB,.982E-02_JPRB,.984E-02_JPRB,&
&.984E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.953E-02_JPRB,.953E-02_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.150E-01_JPRB,.150E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.874E-02_JPRB,.874E-02_JPRB,.916E-02_JPRB,.916E-02_JPRB,.902E-02_JPRB,.902E-02_JPRB,&
&.649E-02_JPRB,.649E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 14  38.0
ZAER (:,14, 9) = (/&
&.759E-02_JPRB,.759E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.996E-02_JPRB,.996E-02_JPRB,.995E-02_JPRB,.995E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.792E-02_JPRB,&
&.792E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.438E-02_JPRB,.438E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,&
&.996E-02_JPRB,.996E-02_JPRB,.931E-02_JPRB,.931E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.804E-02_JPRB,&
&.804E-02_JPRB,.764E-02_JPRB,.764E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.801E-02_JPRB,.801E-02_JPRB,.928E-02_JPRB,.928E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.943E-02_JPRB,&
&.943E-02_JPRB,.978E-02_JPRB,.978E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.641E-02_JPRB,&
&.641E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 15  34.0
ZAER (:,15, 9) = (/&
&.759E-02_JPRB,.759E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.996E-02_JPRB,.996E-02_JPRB,.995E-02_JPRB,.995E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.792E-02_JPRB,&
&.792E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.438E-02_JPRB,.438E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,&
&.996E-02_JPRB,.996E-02_JPRB,.931E-02_JPRB,.931E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.804E-02_JPRB,&
&.804E-02_JPRB,.764E-02_JPRB,.764E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.654E-02_JPRB,.654E-02_JPRB,&
&.801E-02_JPRB,.801E-02_JPRB,.928E-02_JPRB,.928E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.943E-02_JPRB,&
&.943E-02_JPRB,.978E-02_JPRB,.978E-02_JPRB,.954E-02_JPRB,.954E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.652E-02_JPRB,.652E-02_JPRB,.641E-02_JPRB,&
&.641E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,&
&.715E-02_JPRB,.715E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 16  30.0
ZAER (:,16, 9) = (/&
&.797E-02_JPRB,.797E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.937E-02_JPRB,&
&.937E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.926E-02_JPRB,.926E-02_JPRB,.804E-02_JPRB,&
&.804E-02_JPRB,.434E-02_JPRB,.434E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,&
&.742E-02_JPRB,.742E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.778E-02_JPRB,&
&.778E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.314E-02_JPRB,.314E-02_JPRB,&
&.446E-02_JPRB,.446E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,&
&.741E-02_JPRB,.741E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.252E-02_JPRB,&
&.252E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.516E-02_JPRB,.516E-02_JPRB,.837E-02_JPRB,.837E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 17  26.0
ZAER (:,17, 9) = (/&
&.797E-02_JPRB,.797E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.910E-02_JPRB,.910E-02_JPRB,.937E-02_JPRB,&
&.937E-02_JPRB,.922E-02_JPRB,.922E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.926E-02_JPRB,.926E-02_JPRB,.804E-02_JPRB,&
&.804E-02_JPRB,.434E-02_JPRB,.434E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,&
&.742E-02_JPRB,.742E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.778E-02_JPRB,&
&.778E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.314E-02_JPRB,.314E-02_JPRB,&
&.446E-02_JPRB,.446E-02_JPRB,.685E-02_JPRB,.685E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,&
&.741E-02_JPRB,.741E-02_JPRB,.559E-02_JPRB,.559E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.252E-02_JPRB,&
&.252E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.516E-02_JPRB,.516E-02_JPRB,.837E-02_JPRB,.837E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 18  22.0
ZAER (:,18, 9) = (/&
&.961E-02_JPRB,.961E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,&
&.617E-02_JPRB,.617E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.754E-02_JPRB,&
&.754E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.889E-02_JPRB,&
&.889E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.816E-02_JPRB,.816E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.906E-02_JPRB,.906E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.978E-02_JPRB,.978E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 19  18.0
ZAER (:,19, 9) = (/&
&.961E-02_JPRB,.961E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.960E-02_JPRB,.960E-02_JPRB,.794E-02_JPRB,&
&.794E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,&
&.617E-02_JPRB,.617E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.858E-02_JPRB,.858E-02_JPRB,.754E-02_JPRB,&
&.754E-02_JPRB,.627E-02_JPRB,.627E-02_JPRB,.419E-02_JPRB,.419E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.514E-02_JPRB,.514E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.889E-02_JPRB,&
&.889E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.816E-02_JPRB,.816E-02_JPRB,.524E-02_JPRB,.524E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.906E-02_JPRB,.906E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.978E-02_JPRB,.978E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 20  14.0
ZAER (:,20, 9) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.472E-02_JPRB,&
&.472E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.673E-02_JPRB,.673E-02_JPRB,.919E-02_JPRB,.919E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.568E-02_JPRB,&
&.568E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.980E-02_JPRB,.980E-02_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 21  10.0
ZAER (:,21, 9) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.153E-01_JPRB,.153E-01_JPRB,.156E-01_JPRB,&
&.156E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.994E-02_JPRB,.994E-02_JPRB,.853E-02_JPRB,.853E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.472E-02_JPRB,&
&.472E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.673E-02_JPRB,.673E-02_JPRB,.919E-02_JPRB,.919E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.568E-02_JPRB,&
&.568E-02_JPRB,.420E-02_JPRB,.420E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.980E-02_JPRB,.980E-02_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.765E-02_JPRB,&
&.765E-02_JPRB,.935E-02_JPRB,.935E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.124E-01_JPRB,.124E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 22   6.0
ZAER (:,22, 9) = (/&
&.144E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.136E-01_JPRB,&
&.136E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.832E-02_JPRB,.832E-02_JPRB,&
&.653E-02_JPRB,.653E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.557E-02_JPRB,.557E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.436E-02_JPRB,&
&.436E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,&
&.380E-02_JPRB,.380E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.965E-02_JPRB,&
&.965E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,&
&.660E-02_JPRB,.660E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 23   2.0
ZAER (:,23, 9) = (/&
&.144E-01_JPRB,.144E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.136E-01_JPRB,&
&.136E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.832E-02_JPRB,.832E-02_JPRB,&
&.653E-02_JPRB,.653E-02_JPRB,.515E-02_JPRB,.515E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.557E-02_JPRB,.557E-02_JPRB,&
&.823E-02_JPRB,.823E-02_JPRB,.805E-02_JPRB,.805E-02_JPRB,.582E-02_JPRB,.582E-02_JPRB,.436E-02_JPRB,&
&.436E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,&
&.380E-02_JPRB,.380E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.965E-02_JPRB,&
&.965E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.637E-02_JPRB,.637E-02_JPRB,&
&.660E-02_JPRB,.660E-02_JPRB,.762E-02_JPRB,.762E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.772E-02_JPRB,&
&.772E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 24  -2.0
ZAER (:,24, 9) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.940E-02_JPRB,.940E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.770E-02_JPRB,.770E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.309E-02_JPRB,&
&.309E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.676E-03_JPRB,.676E-03_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.316E-02_JPRB,.316E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.733E-02_JPRB,&
&.733E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,&
&.395E-02_JPRB,.395E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.926E-02_JPRB,&
&.926E-02_JPRB,.909E-02_JPRB,.909E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 25  -6.0
ZAER (:,25, 9) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.130E-01_JPRB,&
&.130E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.940E-02_JPRB,.940E-02_JPRB,&
&.737E-02_JPRB,.737E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.770E-02_JPRB,.770E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.309E-02_JPRB,&
&.309E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.676E-03_JPRB,.676E-03_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.316E-02_JPRB,.316E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.733E-02_JPRB,&
&.733E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.590E-02_JPRB,.590E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,&
&.395E-02_JPRB,.395E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.926E-02_JPRB,&
&.926E-02_JPRB,.909E-02_JPRB,.909E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.930E-02_JPRB,.930E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 26 -10.0
ZAER (:,26, 9) = (/&
&.113E-01_JPRB,.113E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.804E-02_JPRB,.804E-02_JPRB,&
&.579E-02_JPRB,.579E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.510E-02_JPRB,&
&.510E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,&
&.965E-02_JPRB,.965E-02_JPRB,.670E-02_JPRB,.670E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.770E-03_JPRB,&
&.770E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.661E-02_JPRB,&
&.661E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,&
&.298E-02_JPRB,.298E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.854E-02_JPRB,&
&.854E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.956E-02_JPRB,.956E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 27 -14.0
ZAER (:,27, 9) = (/&
&.113E-01_JPRB,.113E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.116E-01_JPRB,&
&.116E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.804E-02_JPRB,.804E-02_JPRB,&
&.579E-02_JPRB,.579E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.510E-02_JPRB,&
&.510E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,&
&.965E-02_JPRB,.965E-02_JPRB,.670E-02_JPRB,.670E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.770E-03_JPRB,&
&.770E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.329E-03_JPRB,.329E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.661E-02_JPRB,&
&.661E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,&
&.298E-02_JPRB,.298E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.567E-02_JPRB,.567E-02_JPRB,.854E-02_JPRB,&
&.854E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.956E-02_JPRB,.956E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 28 -18.0
ZAER (:,28, 9) = (/&
&.119E-01_JPRB,.119E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.146E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.770E-02_JPRB,.770E-02_JPRB,&
&.475E-02_JPRB,.475E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.452E-02_JPRB,.452E-02_JPRB,.603E-02_JPRB,&
&.603E-02_JPRB,.834E-02_JPRB,.834E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.559E-02_JPRB,.559E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.862E-03_JPRB,.862E-03_JPRB,&
&.897E-03_JPRB,.897E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.429E-02_JPRB,&
&.429E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,&
&.151E-02_JPRB,.151E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 29 -22.0
ZAER (:,29, 9) = (/&
&.119E-01_JPRB,.119E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,&
&.146E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.770E-02_JPRB,.770E-02_JPRB,&
&.475E-02_JPRB,.475E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.452E-02_JPRB,.452E-02_JPRB,.603E-02_JPRB,&
&.603E-02_JPRB,.834E-02_JPRB,.834E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.559E-02_JPRB,.559E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.862E-03_JPRB,.862E-03_JPRB,&
&.897E-03_JPRB,.897E-03_JPRB,.163E-02_JPRB,.163E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.429E-02_JPRB,&
&.429E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,&
&.151E-02_JPRB,.151E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 30 -26.0
ZAER (:,30, 9) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.919E-02_JPRB,.919E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,&
&.374E-02_JPRB,.374E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.633E-02_JPRB,&
&.633E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,.502E-02_JPRB,&
&.502E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,&
&.208E-02_JPRB,.208E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.174E-02_JPRB,&
&.174E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.947E-03_JPRB,.947E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,&
&.907E-03_JPRB,.907E-03_JPRB,.166E-02_JPRB,.166E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,.666E-02_JPRB,&
&.666E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 31 -30.0
ZAER (:,31, 9) = (/&
&.120E-01_JPRB,.120E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.919E-02_JPRB,.919E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,&
&.374E-02_JPRB,.374E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.633E-02_JPRB,&
&.633E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.905E-02_JPRB,.905E-02_JPRB,.502E-02_JPRB,&
&.502E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,&
&.208E-02_JPRB,.208E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.174E-02_JPRB,&
&.174E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.947E-03_JPRB,.947E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,&
&.907E-03_JPRB,.907E-03_JPRB,.166E-02_JPRB,.166E-02_JPRB,.442E-02_JPRB,.442E-02_JPRB,.666E-02_JPRB,&
&.666E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 32 -34.0
ZAER (:,32, 9) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.936E-02_JPRB,.936E-02_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.878E-02_JPRB,.878E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.405E-02_JPRB,&
&.405E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.856E-02_JPRB,.856E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,&
&.878E-02_JPRB,.878E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.636E-02_JPRB,&
&.636E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,&
&.391E-02_JPRB,.391E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.162E-02_JPRB,&
&.162E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,&
&.635E-03_JPRB,.635E-03_JPRB,.891E-03_JPRB,.891E-03_JPRB,.252E-02_JPRB,.252E-02_JPRB,.351E-02_JPRB,&
&.351E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,&
&.984E-02_JPRB,.984E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 33 -38.0
ZAER (:,33, 9) = (/&
&.104E-01_JPRB,.104E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.936E-02_JPRB,.936E-02_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.878E-02_JPRB,.878E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.308E-02_JPRB,.308E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.405E-02_JPRB,&
&.405E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.856E-02_JPRB,.856E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,&
&.878E-02_JPRB,.878E-02_JPRB,.940E-02_JPRB,.940E-02_JPRB,.941E-02_JPRB,.941E-02_JPRB,.636E-02_JPRB,&
&.636E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.493E-02_JPRB,.493E-02_JPRB,&
&.391E-02_JPRB,.391E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.162E-02_JPRB,&
&.162E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,&
&.635E-03_JPRB,.635E-03_JPRB,.891E-03_JPRB,.891E-03_JPRB,.252E-02_JPRB,.252E-02_JPRB,.351E-02_JPRB,&
&.351E-02_JPRB,.592E-02_JPRB,.592E-02_JPRB,.865E-02_JPRB,.865E-02_JPRB,.881E-02_JPRB,.881E-02_JPRB,&
&.984E-02_JPRB,.984E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 34 -42.0
ZAER (:,34, 9) = (/&
&.837E-02_JPRB,.837E-02_JPRB,.845E-02_JPRB,.845E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.868E-02_JPRB,&
&.868E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,&
&.303E-02_JPRB,.303E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.167E-02_JPRB,&
&.167E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,&
&.721E-02_JPRB,.721E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.676E-02_JPRB,&
&.676E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,&
&.311E-02_JPRB,.311E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.859E-03_JPRB,.859E-03_JPRB,&
&.691E-03_JPRB,.691E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.756E-03_JPRB,.756E-03_JPRB,.168E-02_JPRB,&
&.168E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.606E-02_JPRB,.606E-02_JPRB,.696E-02_JPRB,.696E-02_JPRB,&
&.786E-02_JPRB,.786E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 35 -46.0
ZAER (:,35, 9) = (/&
&.837E-02_JPRB,.837E-02_JPRB,.845E-02_JPRB,.845E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.868E-02_JPRB,&
&.868E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,&
&.303E-02_JPRB,.303E-02_JPRB,.241E-02_JPRB,.241E-02_JPRB,.191E-02_JPRB,.191E-02_JPRB,.167E-02_JPRB,&
&.167E-02_JPRB,.315E-02_JPRB,.315E-02_JPRB,.542E-02_JPRB,.542E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,&
&.721E-02_JPRB,.721E-02_JPRB,.760E-02_JPRB,.760E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.676E-02_JPRB,&
&.676E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,&
&.311E-02_JPRB,.311E-02_JPRB,.215E-02_JPRB,.215E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.859E-03_JPRB,.859E-03_JPRB,&
&.691E-03_JPRB,.691E-03_JPRB,.585E-03_JPRB,.585E-03_JPRB,.756E-03_JPRB,.756E-03_JPRB,.168E-02_JPRB,&
&.168E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.606E-02_JPRB,.606E-02_JPRB,.696E-02_JPRB,.696E-02_JPRB,&
&.786E-02_JPRB,.786E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 36 -50.0
ZAER (:,36, 9) = (/&
&.561E-02_JPRB,.561E-02_JPRB,.650E-02_JPRB,.650E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.803E-02_JPRB,&
&.803E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.134E-02_JPRB,&
&.134E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,&
&.765E-02_JPRB,.765E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.664E-02_JPRB,&
&.664E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,&
&.225E-02_JPRB,.225E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.959E-03_JPRB,.959E-03_JPRB,.881E-03_JPRB,.881E-03_JPRB,&
&.791E-03_JPRB,.791E-03_JPRB,.718E-03_JPRB,.718E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.683E-03_JPRB,&
&.683E-03_JPRB,.225E-02_JPRB,.225E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,&
&.508E-02_JPRB,.508E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 37 -54.0
ZAER (:,37, 9) = (/&
&.561E-02_JPRB,.561E-02_JPRB,.650E-02_JPRB,.650E-02_JPRB,.720E-02_JPRB,.720E-02_JPRB,.803E-02_JPRB,&
&.803E-02_JPRB,.716E-02_JPRB,.716E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.134E-02_JPRB,&
&.134E-02_JPRB,.112E-02_JPRB,.112E-02_JPRB,.304E-02_JPRB,.304E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,&
&.765E-02_JPRB,.765E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.664E-02_JPRB,&
&.664E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,&
&.225E-02_JPRB,.225E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.959E-03_JPRB,.959E-03_JPRB,.881E-03_JPRB,.881E-03_JPRB,&
&.791E-03_JPRB,.791E-03_JPRB,.718E-03_JPRB,.718E-03_JPRB,.675E-03_JPRB,.675E-03_JPRB,.683E-03_JPRB,&
&.683E-03_JPRB,.225E-02_JPRB,.225E-02_JPRB,.402E-02_JPRB,.402E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,&
&.508E-02_JPRB,.508E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 38 -58.0
ZAER (:,38, 9) = (/&
&.287E-02_JPRB,.287E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.785E-03_JPRB,.785E-03_JPRB,&
&.558E-03_JPRB,.558E-03_JPRB,.648E-03_JPRB,.648E-03_JPRB,.354E-02_JPRB,.354E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,&
&.743E-02_JPRB,.743E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.984E-02_JPRB,&
&.984E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.970E-03_JPRB,.970E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,.788E-03_JPRB,.788E-03_JPRB,&
&.736E-03_JPRB,.736E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.516E-03_JPRB,&
&.516E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,&
&.238E-02_JPRB,.238E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 39 -62.0
ZAER (:,39, 9) = (/&
&.287E-02_JPRB,.287E-02_JPRB,.389E-02_JPRB,.389E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.245E-02_JPRB,.245E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.785E-03_JPRB,.785E-03_JPRB,&
&.558E-03_JPRB,.558E-03_JPRB,.648E-03_JPRB,.648E-03_JPRB,.354E-02_JPRB,.354E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.444E-02_JPRB,.444E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,&
&.743E-02_JPRB,.743E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.984E-02_JPRB,&
&.984E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,.427E-02_JPRB,.427E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.970E-03_JPRB,.970E-03_JPRB,.844E-03_JPRB,.844E-03_JPRB,.788E-03_JPRB,.788E-03_JPRB,&
&.736E-03_JPRB,.736E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.516E-03_JPRB,&
&.516E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.178E-02_JPRB,.178E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,&
&.238E-02_JPRB,.238E-02_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 40 -66.0
ZAER (:,40, 9) = (/&
&.722E-03_JPRB,.722E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.604E-03_JPRB,.604E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.743E-03_JPRB,.743E-03_JPRB,.657E-03_JPRB,.657E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.677E-03_JPRB,.677E-03_JPRB,.790E-03_JPRB,.790E-03_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.130E-02_JPRB,.130E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.690E-02_JPRB,&
&.690E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.228E-02_JPRB,.228E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.156E-02_JPRB,&
&.156E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,.619E-03_JPRB,.619E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,&
&.477E-03_JPRB,.477E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.424E-03_JPRB,&
&.424E-03_JPRB,.413E-03_JPRB,.413E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,&
&.527E-03_JPRB,.527E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 41 -70.0
ZAER (:,41, 9) = (/&
&.722E-03_JPRB,.722E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.604E-03_JPRB,.604E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.743E-03_JPRB,.743E-03_JPRB,.657E-03_JPRB,.657E-03_JPRB,.589E-03_JPRB,.589E-03_JPRB,&
&.386E-03_JPRB,.386E-03_JPRB,.677E-03_JPRB,.677E-03_JPRB,.790E-03_JPRB,.790E-03_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.130E-02_JPRB,.130E-02_JPRB,.346E-02_JPRB,.346E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.690E-02_JPRB,&
&.690E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,&
&.228E-02_JPRB,.228E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.156E-02_JPRB,&
&.156E-02_JPRB,.860E-03_JPRB,.860E-03_JPRB,.619E-03_JPRB,.619E-03_JPRB,.536E-03_JPRB,.536E-03_JPRB,&
&.477E-03_JPRB,.477E-03_JPRB,.436E-03_JPRB,.436E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.424E-03_JPRB,&
&.424E-03_JPRB,.413E-03_JPRB,.413E-03_JPRB,.397E-03_JPRB,.397E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,&
&.527E-03_JPRB,.527E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 42 -74.0
ZAER (:,42, 9) = (/&
&.405E-03_JPRB,.405E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.334E-03_JPRB,.334E-03_JPRB,.340E-03_JPRB,&
&.340E-03_JPRB,.407E-03_JPRB,.407E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.424E-03_JPRB,.424E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.416E-03_JPRB,.416E-03_JPRB,.491E-03_JPRB,&
&.491E-03_JPRB,.670E-03_JPRB,.670E-03_JPRB,.982E-03_JPRB,.982E-03_JPRB,.851E-03_JPRB,.851E-03_JPRB,&
&.627E-03_JPRB,.627E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.218E-02_JPRB,&
&.218E-02_JPRB,.434E-02_JPRB,.434E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.353E-02_JPRB,.353E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.801E-03_JPRB,.801E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,&
&.369E-03_JPRB,.369E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.871E-03_JPRB,&
&.871E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,.308E-03_JPRB,.308E-03_JPRB,&
&.337E-03_JPRB,.337E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 43 -78.0
ZAER (:,43, 9) = (/&
&.405E-03_JPRB,.405E-03_JPRB,.402E-03_JPRB,.402E-03_JPRB,.334E-03_JPRB,.334E-03_JPRB,.340E-03_JPRB,&
&.340E-03_JPRB,.407E-03_JPRB,.407E-03_JPRB,.507E-03_JPRB,.507E-03_JPRB,.424E-03_JPRB,.424E-03_JPRB,&
&.404E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.404E-03_JPRB,.416E-03_JPRB,.416E-03_JPRB,.491E-03_JPRB,&
&.491E-03_JPRB,.670E-03_JPRB,.670E-03_JPRB,.982E-03_JPRB,.982E-03_JPRB,.851E-03_JPRB,.851E-03_JPRB,&
&.627E-03_JPRB,.627E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.433E-03_JPRB,.433E-03_JPRB,.218E-02_JPRB,&
&.218E-02_JPRB,.434E-02_JPRB,.434E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.353E-02_JPRB,.353E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.155E-02_JPRB,&
&.155E-02_JPRB,.801E-03_JPRB,.801E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,&
&.369E-03_JPRB,.369E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.871E-03_JPRB,&
&.871E-03_JPRB,.350E-03_JPRB,.350E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,.308E-03_JPRB,.308E-03_JPRB,&
&.337E-03_JPRB,.337E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 44 -82.0
ZAER (:,44, 9) = (/&
&.341E-03_JPRB,.341E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.335E-03_JPRB,.335E-03_JPRB,.346E-03_JPRB,&
&.346E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.361E-03_JPRB,.361E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.442E-03_JPRB,&
&.442E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.533E-03_JPRB,.533E-03_JPRB,.446E-03_JPRB,.446E-03_JPRB,&
&.360E-03_JPRB,.360E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.365E-03_JPRB,&
&.365E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.708E-03_JPRB,.708E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,&
&.432E-03_JPRB,.432E-03_JPRB,.418E-03_JPRB,.418E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.358E-03_JPRB,&
&.358E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.326E-03_JPRB,.326E-03_JPRB,.316E-03_JPRB,.316E-03_JPRB,&
&.319E-03_JPRB,.319E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.339E-03_JPRB,.339E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.317E-03_JPRB,.317E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.331E-03_JPRB,.331E-03_JPRB,&
&.340E-03_JPRB,.340E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 45 -86.0
ZAER (:,45, 9) = (/&
&.341E-03_JPRB,.341E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.335E-03_JPRB,.335E-03_JPRB,.346E-03_JPRB,&
&.346E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.361E-03_JPRB,.361E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.414E-03_JPRB,.414E-03_JPRB,.442E-03_JPRB,&
&.442E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.533E-03_JPRB,.533E-03_JPRB,.446E-03_JPRB,.446E-03_JPRB,&
&.360E-03_JPRB,.360E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,.365E-03_JPRB,&
&.365E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.708E-03_JPRB,.708E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,&
&.432E-03_JPRB,.432E-03_JPRB,.418E-03_JPRB,.418E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.358E-03_JPRB,&
&.358E-03_JPRB,.340E-03_JPRB,.340E-03_JPRB,.326E-03_JPRB,.326E-03_JPRB,.316E-03_JPRB,.316E-03_JPRB,&
&.319E-03_JPRB,.319E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,.339E-03_JPRB,.339E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.317E-03_JPRB,.317E-03_JPRB,.323E-03_JPRB,.323E-03_JPRB,.331E-03_JPRB,.331E-03_JPRB,&
&.340E-03_JPRB,.340E-03_JPRB/)
!-- Sea Salt Aerosol         month:  9 --- lat: 46 -90.0
ZAER (:,46, 9) = (/&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,.298E-03_JPRB,&
&.298E-03_JPRB,.298E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  1  90.0
ZAER (:, 1,10) = (/&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,.462E-03_JPRB,&
&.462E-03_JPRB,.462E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  2  86.0
ZAER (:, 2,10) = (/&
&.512E-03_JPRB,.512E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,&
&.735E-03_JPRB,.735E-03_JPRB,.745E-03_JPRB,.745E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,.683E-03_JPRB,&
&.683E-03_JPRB,.605E-03_JPRB,.605E-03_JPRB,.539E-03_JPRB,.539E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,&
&.424E-03_JPRB,.424E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,.243E-03_JPRB,&
&.243E-03_JPRB,.212E-03_JPRB,.212E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.241E-03_JPRB,.241E-03_JPRB,&
&.268E-03_JPRB,.268E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.287E-03_JPRB,&
&.287E-03_JPRB,.287E-03_JPRB,.287E-03_JPRB,.280E-03_JPRB,.280E-03_JPRB,.289E-03_JPRB,.289E-03_JPRB,&
&.318E-03_JPRB,.318E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.434E-03_JPRB,&
&.434E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.525E-03_JPRB,.525E-03_JPRB,&
&.530E-03_JPRB,.530E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  3  82.0
ZAER (:, 3,10) = (/&
&.512E-03_JPRB,.512E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.543E-03_JPRB,.543E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.612E-03_JPRB,.612E-03_JPRB,.665E-03_JPRB,.665E-03_JPRB,.721E-03_JPRB,.721E-03_JPRB,&
&.735E-03_JPRB,.735E-03_JPRB,.745E-03_JPRB,.745E-03_JPRB,.724E-03_JPRB,.724E-03_JPRB,.683E-03_JPRB,&
&.683E-03_JPRB,.605E-03_JPRB,.605E-03_JPRB,.539E-03_JPRB,.539E-03_JPRB,.483E-03_JPRB,.483E-03_JPRB,&
&.424E-03_JPRB,.424E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.295E-03_JPRB,.295E-03_JPRB,.243E-03_JPRB,&
&.243E-03_JPRB,.212E-03_JPRB,.212E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.241E-03_JPRB,.241E-03_JPRB,&
&.268E-03_JPRB,.268E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.284E-03_JPRB,.287E-03_JPRB,&
&.287E-03_JPRB,.287E-03_JPRB,.287E-03_JPRB,.280E-03_JPRB,.280E-03_JPRB,.289E-03_JPRB,.289E-03_JPRB,&
&.318E-03_JPRB,.318E-03_JPRB,.355E-03_JPRB,.355E-03_JPRB,.396E-03_JPRB,.396E-03_JPRB,.434E-03_JPRB,&
&.434E-03_JPRB,.450E-03_JPRB,.450E-03_JPRB,.484E-03_JPRB,.484E-03_JPRB,.525E-03_JPRB,.525E-03_JPRB,&
&.530E-03_JPRB,.530E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  4  78.0
ZAER (:, 4,10) = (/&
&.434E-03_JPRB,.434E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.374E-03_JPRB,&
&.374E-03_JPRB,.383E-03_JPRB,.383E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,.641E-03_JPRB,.641E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.976E-03_JPRB,&
&.976E-03_JPRB,.883E-03_JPRB,.883E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.633E-03_JPRB,.633E-03_JPRB,&
&.485E-03_JPRB,.485E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.269E-03_JPRB,&
&.269E-03_JPRB,.199E-03_JPRB,.199E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.259E-03_JPRB,.259E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.407E-03_JPRB,&
&.407E-03_JPRB,.409E-03_JPRB,.409E-03_JPRB,.283E-03_JPRB,.283E-03_JPRB,.226E-03_JPRB,.226E-03_JPRB,&
&.191E-03_JPRB,.191E-03_JPRB,.185E-03_JPRB,.185E-03_JPRB,.205E-03_JPRB,.205E-03_JPRB,.300E-03_JPRB,&
&.300E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.385E-03_JPRB,.385E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,&
&.441E-03_JPRB,.441E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  5  74.0
ZAER (:, 5,10) = (/&
&.434E-03_JPRB,.434E-03_JPRB,.461E-03_JPRB,.461E-03_JPRB,.389E-03_JPRB,.389E-03_JPRB,.374E-03_JPRB,&
&.374E-03_JPRB,.383E-03_JPRB,.383E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,.641E-03_JPRB,.641E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.100E-02_JPRB,.100E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.976E-03_JPRB,&
&.976E-03_JPRB,.883E-03_JPRB,.883E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.633E-03_JPRB,.633E-03_JPRB,&
&.485E-03_JPRB,.485E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.269E-03_JPRB,&
&.269E-03_JPRB,.199E-03_JPRB,.199E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.259E-03_JPRB,.259E-03_JPRB,&
&.365E-03_JPRB,.365E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.407E-03_JPRB,&
&.407E-03_JPRB,.409E-03_JPRB,.409E-03_JPRB,.283E-03_JPRB,.283E-03_JPRB,.226E-03_JPRB,.226E-03_JPRB,&
&.191E-03_JPRB,.191E-03_JPRB,.185E-03_JPRB,.185E-03_JPRB,.205E-03_JPRB,.205E-03_JPRB,.300E-03_JPRB,&
&.300E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.385E-03_JPRB,.385E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,&
&.441E-03_JPRB,.441E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  6  70.0
ZAER (:, 6,10) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,&
&.559E-03_JPRB,.559E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.708E-03_JPRB,&
&.708E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.432E-03_JPRB,.432E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.891E-03_JPRB,.891E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.185E-02_JPRB,&
&.185E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.922E-03_JPRB,.922E-03_JPRB,&
&.940E-03_JPRB,.940E-03_JPRB,.937E-03_JPRB,.937E-03_JPRB,.127E-02_JPRB,.127E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  7  66.0
ZAER (:, 7,10) = (/&
&.157E-02_JPRB,.157E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,.131E-02_JPRB,&
&.131E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.294E-02_JPRB,.294E-02_JPRB,.323E-02_JPRB,.323E-02_JPRB,.282E-02_JPRB,&
&.282E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,&
&.559E-03_JPRB,.559E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.384E-03_JPRB,.384E-03_JPRB,.708E-03_JPRB,&
&.708E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.432E-03_JPRB,.432E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.891E-03_JPRB,.891E-03_JPRB,.115E-02_JPRB,.115E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.185E-02_JPRB,&
&.185E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.922E-03_JPRB,.922E-03_JPRB,&
&.940E-03_JPRB,.940E-03_JPRB,.937E-03_JPRB,.937E-03_JPRB,.127E-02_JPRB,.127E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  8  62.0
ZAER (:, 8,10) = (/&
&.911E-02_JPRB,.911E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.906E-02_JPRB,.906E-02_JPRB,.837E-02_JPRB,&
&.837E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.990E-02_JPRB,&
&.990E-02_JPRB,.819E-02_JPRB,.819E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.665E-03_JPRB,.665E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.162E-02_JPRB,&
&.162E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.198E-02_JPRB,.198E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.670E-02_JPRB,&
&.670E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,&
&.627E-02_JPRB,.627E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.778E-02_JPRB,&
&.778E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,&
&.877E-02_JPRB,.877E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat:  9  58.0
ZAER (:, 9,10) = (/&
&.911E-02_JPRB,.911E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,.906E-02_JPRB,.906E-02_JPRB,.837E-02_JPRB,&
&.837E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.836E-02_JPRB,.836E-02_JPRB,.917E-02_JPRB,.917E-02_JPRB,&
&.999E-02_JPRB,.999E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.990E-02_JPRB,&
&.990E-02_JPRB,.819E-02_JPRB,.819E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.665E-03_JPRB,.665E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.162E-02_JPRB,&
&.162E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.143E-02_JPRB,.143E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.198E-02_JPRB,.198E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.670E-02_JPRB,&
&.670E-02_JPRB,.678E-02_JPRB,.678E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,&
&.627E-02_JPRB,.627E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.778E-02_JPRB,&
&.778E-02_JPRB,.618E-02_JPRB,.618E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,&
&.877E-02_JPRB,.877E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 10  54.0
ZAER (:,10,10) = (/&
&.995E-02_JPRB,.995E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.722E-02_JPRB,.722E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.918E-02_JPRB,.918E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.913E-02_JPRB,.913E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,&
&.717E-02_JPRB,.717E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.930E-02_JPRB,&
&.930E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.919E-02_JPRB,.919E-02_JPRB,&
&.914E-02_JPRB,.914E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.884E-02_JPRB,&
&.884E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 11  50.0
ZAER (:,11,10) = (/&
&.995E-02_JPRB,.995E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.722E-02_JPRB,.722E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.918E-02_JPRB,.918E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.913E-02_JPRB,.913E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,&
&.717E-02_JPRB,.717E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.930E-02_JPRB,&
&.930E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.919E-02_JPRB,.919E-02_JPRB,&
&.914E-02_JPRB,.914E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.887E-02_JPRB,.887E-02_JPRB,.884E-02_JPRB,&
&.884E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.864E-02_JPRB,.864E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 12  46.0
ZAER (:,12,10) = (/&
&.763E-02_JPRB,.763E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.830E-02_JPRB,&
&.830E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,&
&.848E-02_JPRB,.848E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.723E-02_JPRB,&
&.723E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.981E-02_JPRB,.981E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.991E-02_JPRB,.991E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.932E-02_JPRB,.932E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.753E-02_JPRB,&
&.753E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.557E-02_JPRB,.557E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 13  42.0
ZAER (:,13,10) = (/&
&.763E-02_JPRB,.763E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.830E-02_JPRB,&
&.830E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,.781E-02_JPRB,.781E-02_JPRB,&
&.848E-02_JPRB,.848E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,.723E-02_JPRB,&
&.723E-02_JPRB,.456E-02_JPRB,.456E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.102E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.100E-01_JPRB,.981E-02_JPRB,.981E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.991E-02_JPRB,.991E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,&
&.932E-02_JPRB,.932E-02_JPRB,.890E-02_JPRB,.890E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.753E-02_JPRB,&
&.753E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.702E-02_JPRB,.702E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,&
&.557E-02_JPRB,.557E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 14  38.0
ZAER (:,14,10) = (/&
&.746E-02_JPRB,.746E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.726E-02_JPRB,&
&.726E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,&
&.748E-02_JPRB,.748E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.567E-02_JPRB,&
&.567E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,&
&.895E-02_JPRB,.895E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,&
&.912E-02_JPRB,.912E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,&
&.740E-02_JPRB,.740E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.626E-02_JPRB,&
&.626E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,&
&.714E-02_JPRB,.714E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 15  34.0
ZAER (:,15,10) = (/&
&.746E-02_JPRB,.746E-02_JPRB,.754E-02_JPRB,.754E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.726E-02_JPRB,&
&.726E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.714E-02_JPRB,.714E-02_JPRB,&
&.748E-02_JPRB,.748E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.567E-02_JPRB,&
&.567E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.739E-02_JPRB,.739E-02_JPRB,&
&.895E-02_JPRB,.895E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.882E-02_JPRB,.882E-02_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.772E-02_JPRB,.772E-02_JPRB,&
&.912E-02_JPRB,.912E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.877E-02_JPRB,&
&.877E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,&
&.740E-02_JPRB,.740E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.626E-02_JPRB,&
&.626E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.624E-02_JPRB,.624E-02_JPRB,.792E-02_JPRB,.792E-02_JPRB,&
&.714E-02_JPRB,.714E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 16  30.0
ZAER (:,16,10) = (/&
&.811E-02_JPRB,.811E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.787E-02_JPRB,&
&.787E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,&
&.862E-02_JPRB,.862E-02_JPRB,.928E-02_JPRB,.928E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,&
&.769E-02_JPRB,.769E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,&
&.491E-02_JPRB,.491E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,&
&.768E-02_JPRB,.768E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.337E-02_JPRB,&
&.337E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.451E-02_JPRB,.451E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,&
&.803E-02_JPRB,.803E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 17  26.0
ZAER (:,17,10) = (/&
&.811E-02_JPRB,.811E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.787E-02_JPRB,&
&.787E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.815E-02_JPRB,.815E-02_JPRB,.824E-02_JPRB,.824E-02_JPRB,&
&.862E-02_JPRB,.862E-02_JPRB,.928E-02_JPRB,.928E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.682E-02_JPRB,&
&.682E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,.253E-02_JPRB,.253E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,&
&.769E-02_JPRB,.769E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.712E-02_JPRB,.712E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,&
&.491E-02_JPRB,.491E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.738E-02_JPRB,.738E-02_JPRB,&
&.768E-02_JPRB,.768E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,.337E-02_JPRB,&
&.337E-02_JPRB,.270E-02_JPRB,.270E-02_JPRB,.451E-02_JPRB,.451E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,&
&.803E-02_JPRB,.803E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 18  22.0
ZAER (:,18,10) = (/&
&.963E-02_JPRB,.963E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.961E-02_JPRB,.961E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.366E-02_JPRB,.366E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,&
&.634E-02_JPRB,.634E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.619E-02_JPRB,&
&.619E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,&
&.270E-02_JPRB,.270E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,.728E-02_JPRB,.728E-02_JPRB,.902E-02_JPRB,&
&.902E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.458E-02_JPRB,&
&.458E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.667E-02_JPRB,.667E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,&
&.869E-02_JPRB,.869E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 19  18.0
ZAER (:,19,10) = (/&
&.963E-02_JPRB,.963E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.992E-02_JPRB,.992E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.961E-02_JPRB,.961E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.366E-02_JPRB,.366E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,&
&.634E-02_JPRB,.634E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.619E-02_JPRB,&
&.619E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,&
&.270E-02_JPRB,.270E-02_JPRB,.519E-02_JPRB,.519E-02_JPRB,.728E-02_JPRB,.728E-02_JPRB,.902E-02_JPRB,&
&.902E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.946E-02_JPRB,.946E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.458E-02_JPRB,&
&.458E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.667E-02_JPRB,.667E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,&
&.869E-02_JPRB,.869E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 20  14.0
ZAER (:,20,10) = (/&
&.118E-01_JPRB,.118E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.918E-02_JPRB,.918E-02_JPRB,.666E-02_JPRB,.666E-02_JPRB,.396E-02_JPRB,&
&.396E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,&
&.648E-02_JPRB,.648E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.499E-02_JPRB,&
&.499E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,&
&.241E-02_JPRB,.241E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.137E-01_JPRB,&
&.137E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.939E-02_JPRB,.939E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 21  10.0
ZAER (:,21,10) = (/&
&.118E-01_JPRB,.118E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.147E-01_JPRB,&
&.147E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.118E-01_JPRB,.118E-01_JPRB,.918E-02_JPRB,.918E-02_JPRB,.666E-02_JPRB,.666E-02_JPRB,.396E-02_JPRB,&
&.396E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,&
&.648E-02_JPRB,.648E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.499E-02_JPRB,&
&.499E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.121E-02_JPRB,.121E-02_JPRB,&
&.241E-02_JPRB,.241E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.137E-01_JPRB,&
&.137E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB,.939E-02_JPRB,.939E-02_JPRB,.759E-02_JPRB,.759E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.974E-02_JPRB,.974E-02_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 22   6.0
ZAER (:,22,10) = (/&
&.135E-01_JPRB,.135E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.886E-02_JPRB,.886E-02_JPRB,&
&.710E-02_JPRB,.710E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.151E-02_JPRB,&
&.151E-02_JPRB,.819E-03_JPRB,.819E-03_JPRB,.215E-02_JPRB,.215E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.687E-02_JPRB,.687E-02_JPRB,.480E-02_JPRB,&
&.480E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.914E-03_JPRB,.914E-03_JPRB,&
&.302E-02_JPRB,.302E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.925E-02_JPRB,.925E-02_JPRB,.986E-02_JPRB,&
&.986E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,&
&.470E-02_JPRB,.470E-02_JPRB,.492E-02_JPRB,.492E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,.487E-02_JPRB,&
&.487E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 23   2.0
ZAER (:,23,10) = (/&
&.135E-01_JPRB,.135E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.145E-01_JPRB,.145E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.886E-02_JPRB,.886E-02_JPRB,&
&.710E-02_JPRB,.710E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.435E-02_JPRB,.435E-02_JPRB,.151E-02_JPRB,&
&.151E-02_JPRB,.819E-03_JPRB,.819E-03_JPRB,.215E-02_JPRB,.215E-02_JPRB,.531E-02_JPRB,.531E-02_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.687E-02_JPRB,.687E-02_JPRB,.480E-02_JPRB,&
&.480E-02_JPRB,.353E-02_JPRB,.353E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.914E-03_JPRB,.914E-03_JPRB,&
&.302E-02_JPRB,.302E-02_JPRB,.689E-02_JPRB,.689E-02_JPRB,.925E-02_JPRB,.925E-02_JPRB,.986E-02_JPRB,&
&.986E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,&
&.470E-02_JPRB,.470E-02_JPRB,.492E-02_JPRB,.492E-02_JPRB,.578E-02_JPRB,.578E-02_JPRB,.487E-02_JPRB,&
&.487E-02_JPRB,.553E-02_JPRB,.553E-02_JPRB,.847E-02_JPRB,.847E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,&
&.129E-01_JPRB,.129E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 24  -2.0
ZAER (:,24,10) = (/&
&.949E-02_JPRB,.949E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.950E-02_JPRB,.950E-02_JPRB,&
&.748E-02_JPRB,.748E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.650E-02_JPRB,.650E-02_JPRB,.287E-02_JPRB,&
&.287E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,.415E-02_JPRB,&
&.415E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.643E-03_JPRB,.643E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.292E-02_JPRB,.292E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.849E-02_JPRB,&
&.849E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,&
&.306E-02_JPRB,.306E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.618E-02_JPRB,&
&.618E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,&
&.941E-02_JPRB,.941E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 25  -6.0
ZAER (:,25,10) = (/&
&.949E-02_JPRB,.949E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.950E-02_JPRB,.950E-02_JPRB,&
&.748E-02_JPRB,.748E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.650E-02_JPRB,.650E-02_JPRB,.287E-02_JPRB,&
&.287E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.993E-02_JPRB,.993E-02_JPRB,.705E-02_JPRB,.705E-02_JPRB,.415E-02_JPRB,&
&.415E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.643E-03_JPRB,.643E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.292E-02_JPRB,.292E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.849E-02_JPRB,&
&.849E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,&
&.306E-02_JPRB,.306E-02_JPRB,.454E-02_JPRB,.454E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.618E-02_JPRB,&
&.618E-02_JPRB,.687E-02_JPRB,.687E-02_JPRB,.788E-02_JPRB,.788E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,&
&.941E-02_JPRB,.941E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 26 -10.0
ZAER (:,26,10) = (/&
&.801E-02_JPRB,.801E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.471E-02_JPRB,.471E-02_JPRB,.528E-02_JPRB,&
&.528E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.992E-02_JPRB,.992E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.977E-02_JPRB,.977E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.961E-03_JPRB,.961E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.129E-02_JPRB,.129E-02_JPRB,&
&.216E-02_JPRB,.216E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,.701E-02_JPRB,&
&.701E-02_JPRB,.525E-02_JPRB,.525E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,&
&.347E-02_JPRB,.347E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,.819E-02_JPRB,&
&.819E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.894E-02_JPRB,.894E-02_JPRB,&
&.865E-02_JPRB,.865E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 27 -14.0
ZAER (:,27,10) = (/&
&.801E-02_JPRB,.801E-02_JPRB,.844E-02_JPRB,.844E-02_JPRB,.888E-02_JPRB,.888E-02_JPRB,.109E-01_JPRB,&
&.109E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.471E-02_JPRB,.471E-02_JPRB,.528E-02_JPRB,&
&.528E-02_JPRB,.697E-02_JPRB,.697E-02_JPRB,.992E-02_JPRB,.992E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB,.977E-02_JPRB,.977E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.961E-03_JPRB,.961E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.129E-02_JPRB,.129E-02_JPRB,&
&.216E-02_JPRB,.216E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,.701E-02_JPRB,&
&.701E-02_JPRB,.525E-02_JPRB,.525E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.414E-02_JPRB,.414E-02_JPRB,&
&.347E-02_JPRB,.347E-02_JPRB,.706E-02_JPRB,.706E-02_JPRB,.726E-02_JPRB,.726E-02_JPRB,.819E-02_JPRB,&
&.819E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.797E-02_JPRB,.797E-02_JPRB,.894E-02_JPRB,.894E-02_JPRB,&
&.865E-02_JPRB,.865E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 28 -18.0
ZAER (:,28,10) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.804E-02_JPRB,.804E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.900E-02_JPRB,&
&.900E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.812E-02_JPRB,.812E-02_JPRB,.444E-02_JPRB,&
&.444E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,&
&.249E-02_JPRB,.249E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,&
&.232E-02_JPRB,.232E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 29 -22.0
ZAER (:,29,10) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.110E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,&
&.804E-02_JPRB,.804E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.900E-02_JPRB,&
&.900E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.812E-02_JPRB,.812E-02_JPRB,.444E-02_JPRB,&
&.444E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,.239E-02_JPRB,.239E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,&
&.249E-02_JPRB,.249E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.453E-02_JPRB,&
&.453E-02_JPRB,.342E-02_JPRB,.342E-02_JPRB,.254E-02_JPRB,.254E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,&
&.232E-02_JPRB,.232E-02_JPRB,.630E-02_JPRB,.630E-02_JPRB,.981E-02_JPRB,.981E-02_JPRB,.107E-01_JPRB,&
&.107E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.122E-01_JPRB,.122E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 30 -26.0
ZAER (:,30,10) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.866E-02_JPRB,.866E-02_JPRB,&
&.632E-02_JPRB,.632E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.894E-02_JPRB,&
&.894E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.642E-02_JPRB,&
&.642E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,&
&.346E-02_JPRB,.346E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.237E-02_JPRB,&
&.237E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.785E-02_JPRB,&
&.785E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 31 -30.0
ZAER (:,31,10) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.102E-01_JPRB,.102E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.866E-02_JPRB,.866E-02_JPRB,&
&.632E-02_JPRB,.632E-02_JPRB,.621E-02_JPRB,.621E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.894E-02_JPRB,&
&.894E-02_JPRB,.114E-01_JPRB,.114E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.642E-02_JPRB,&
&.642E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.382E-02_JPRB,.382E-02_JPRB,.347E-02_JPRB,.347E-02_JPRB,&
&.346E-02_JPRB,.346E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.237E-02_JPRB,&
&.237E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,&
&.117E-02_JPRB,.117E-02_JPRB,.218E-02_JPRB,.218E-02_JPRB,.575E-02_JPRB,.575E-02_JPRB,.785E-02_JPRB,&
&.785E-02_JPRB,.886E-02_JPRB,.886E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 32 -34.0
ZAER (:,32,10) = (/&
&.999E-02_JPRB,.999E-02_JPRB,.896E-02_JPRB,.896E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.910E-02_JPRB,&
&.910E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.478E-02_JPRB,.478E-02_JPRB,&
&.394E-02_JPRB,.394E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.413E-02_JPRB,&
&.413E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.774E-02_JPRB,&
&.774E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,&
&.455E-02_JPRB,.455E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.953E-03_JPRB,.953E-03_JPRB,.247E-02_JPRB,.247E-02_JPRB,.352E-02_JPRB,&
&.352E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 33 -38.0
ZAER (:,33,10) = (/&
&.999E-02_JPRB,.999E-02_JPRB,.896E-02_JPRB,.896E-02_JPRB,.885E-02_JPRB,.885E-02_JPRB,.910E-02_JPRB,&
&.910E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.478E-02_JPRB,.478E-02_JPRB,&
&.394E-02_JPRB,.394E-02_JPRB,.363E-02_JPRB,.363E-02_JPRB,.307E-02_JPRB,.307E-02_JPRB,.413E-02_JPRB,&
&.413E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.774E-02_JPRB,&
&.774E-02_JPRB,.581E-02_JPRB,.581E-02_JPRB,.566E-02_JPRB,.566E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,&
&.455E-02_JPRB,.455E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.998E-03_JPRB,.998E-03_JPRB,&
&.807E-03_JPRB,.807E-03_JPRB,.953E-03_JPRB,.953E-03_JPRB,.247E-02_JPRB,.247E-02_JPRB,.352E-02_JPRB,&
&.352E-02_JPRB,.647E-02_JPRB,.647E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.115E-01_JPRB,.115E-01_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 34 -42.0
ZAER (:,34,10) = (/&
&.880E-02_JPRB,.880E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.713E-02_JPRB,.713E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.843E-02_JPRB,&
&.843E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,&
&.438E-02_JPRB,.438E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.290E-02_JPRB,.290E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.999E-03_JPRB,.999E-03_JPRB,.930E-03_JPRB,.930E-03_JPRB,.870E-03_JPRB,.870E-03_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,&
&.915E-02_JPRB,.915E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 35 -46.0
ZAER (:,35,10) = (/&
&.880E-02_JPRB,.880E-02_JPRB,.869E-02_JPRB,.869E-02_JPRB,.920E-02_JPRB,.920E-02_JPRB,.103E-01_JPRB,&
&.103E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.713E-02_JPRB,.713E-02_JPRB,.285E-02_JPRB,.285E-02_JPRB,&
&.205E-02_JPRB,.205E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.286E-02_JPRB,.286E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.871E-02_JPRB,.871E-02_JPRB,&
&.109E-01_JPRB,.109E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.843E-02_JPRB,&
&.843E-02_JPRB,.503E-02_JPRB,.503E-02_JPRB,.386E-02_JPRB,.386E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,&
&.438E-02_JPRB,.438E-02_JPRB,.324E-02_JPRB,.324E-02_JPRB,.290E-02_JPRB,.290E-02_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.999E-03_JPRB,.999E-03_JPRB,.930E-03_JPRB,.930E-03_JPRB,.870E-03_JPRB,.870E-03_JPRB,.192E-02_JPRB,&
&.192E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,&
&.915E-02_JPRB,.915E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 36 -50.0
ZAER (:,36,10) = (/&
&.794E-02_JPRB,.794E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.665E-02_JPRB,.665E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.332E-02_JPRB,.332E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.827E-02_JPRB,&
&.827E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.273E-02_JPRB,.273E-02_JPRB,&
&.251E-02_JPRB,.251E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.719E-03_JPRB,&
&.719E-03_JPRB,.301E-02_JPRB,.301E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,&
&.808E-02_JPRB,.808E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 37 -54.0
ZAER (:,37,10) = (/&
&.794E-02_JPRB,.794E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.825E-02_JPRB,.825E-02_JPRB,.105E-01_JPRB,&
&.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.665E-02_JPRB,.665E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.332E-02_JPRB,.332E-02_JPRB,.868E-02_JPRB,.868E-02_JPRB,&
&.113E-01_JPRB,.113E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.827E-02_JPRB,&
&.827E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.340E-02_JPRB,.340E-02_JPRB,.273E-02_JPRB,.273E-02_JPRB,&
&.251E-02_JPRB,.251E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.200E-02_JPRB,.200E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.935E-03_JPRB,.935E-03_JPRB,.772E-03_JPRB,.772E-03_JPRB,.719E-03_JPRB,&
&.719E-03_JPRB,.301E-02_JPRB,.301E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,&
&.808E-02_JPRB,.808E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 38 -58.0
ZAER (:,38,10) = (/&
&.461E-02_JPRB,.461E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.301E-02_JPRB,.301E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.989E-03_JPRB,.989E-03_JPRB,.104E-02_JPRB,.104E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,&
&.925E-02_JPRB,.925E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.359E-02_JPRB,.359E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.133E-02_JPRB,&
&.133E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.897E-03_JPRB,.897E-03_JPRB,.789E-03_JPRB,.789E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.170E-02_JPRB,.170E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 39 -62.0
ZAER (:,39,10) = (/&
&.461E-02_JPRB,.461E-02_JPRB,.546E-02_JPRB,.546E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.482E-02_JPRB,&
&.482E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.301E-02_JPRB,.301E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,&
&.989E-03_JPRB,.989E-03_JPRB,.104E-02_JPRB,.104E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.303E-02_JPRB,&
&.303E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,&
&.925E-02_JPRB,.925E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.929E-02_JPRB,&
&.929E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,.359E-02_JPRB,.359E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,&
&.193E-02_JPRB,.193E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.133E-02_JPRB,&
&.133E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,&
&.897E-03_JPRB,.897E-03_JPRB,.789E-03_JPRB,.789E-03_JPRB,.672E-03_JPRB,.672E-03_JPRB,.612E-03_JPRB,&
&.612E-03_JPRB,.170E-02_JPRB,.170E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 40 -66.0
ZAER (:,40,10) = (/&
&.117E-02_JPRB,.117E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.959E-03_JPRB,.959E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.685E-03_JPRB,.685E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,.136E-02_JPRB,&
&.136E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,&
&.267E-02_JPRB,.267E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.318E-02_JPRB,.318E-02_JPRB,.372E-02_JPRB,.372E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.184E-02_JPRB,&
&.184E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,&
&.633E-03_JPRB,.633E-03_JPRB,.587E-03_JPRB,.587E-03_JPRB,.548E-03_JPRB,.548E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,.548E-03_JPRB,.548E-03_JPRB,&
&.682E-03_JPRB,.682E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 41 -70.0
ZAER (:,41,10) = (/&
&.117E-02_JPRB,.117E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.959E-03_JPRB,.959E-03_JPRB,&
&.560E-03_JPRB,.560E-03_JPRB,.685E-03_JPRB,.685E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,.136E-02_JPRB,&
&.136E-02_JPRB,.198E-02_JPRB,.198E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,&
&.267E-02_JPRB,.267E-02_JPRB,.440E-02_JPRB,.440E-02_JPRB,.551E-02_JPRB,.551E-02_JPRB,.719E-02_JPRB,&
&.719E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,.657E-02_JPRB,.657E-02_JPRB,.350E-02_JPRB,.350E-02_JPRB,&
&.318E-02_JPRB,.318E-02_JPRB,.372E-02_JPRB,.372E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.184E-02_JPRB,&
&.184E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,&
&.633E-03_JPRB,.633E-03_JPRB,.587E-03_JPRB,.587E-03_JPRB,.548E-03_JPRB,.548E-03_JPRB,.470E-03_JPRB,&
&.470E-03_JPRB,.549E-03_JPRB,.549E-03_JPRB,.554E-03_JPRB,.554E-03_JPRB,.548E-03_JPRB,.548E-03_JPRB,&
&.682E-03_JPRB,.682E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 42 -74.0
ZAER (:,42,10) = (/&
&.439E-03_JPRB,.439E-03_JPRB,.503E-03_JPRB,.503E-03_JPRB,.556E-03_JPRB,.556E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.445E-03_JPRB,.445E-03_JPRB,.415E-03_JPRB,.415E-03_JPRB,.468E-03_JPRB,.468E-03_JPRB,.585E-03_JPRB,&
&.585E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,&
&.148E-02_JPRB,.148E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.527E-02_JPRB,.527E-02_JPRB,&
&.539E-02_JPRB,.539E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.678E-03_JPRB,.678E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,&
&.455E-03_JPRB,.455E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.954E-03_JPRB,&
&.954E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 43 -78.0
ZAER (:,43,10) = (/&
&.439E-03_JPRB,.439E-03_JPRB,.503E-03_JPRB,.503E-03_JPRB,.556E-03_JPRB,.556E-03_JPRB,.581E-03_JPRB,&
&.581E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.714E-03_JPRB,.714E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,&
&.445E-03_JPRB,.445E-03_JPRB,.415E-03_JPRB,.415E-03_JPRB,.468E-03_JPRB,.468E-03_JPRB,.585E-03_JPRB,&
&.585E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,.190E-02_JPRB,.190E-02_JPRB,.192E-02_JPRB,.192E-02_JPRB,&
&.148E-02_JPRB,.148E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.548E-02_JPRB,.548E-02_JPRB,.527E-02_JPRB,.527E-02_JPRB,&
&.539E-02_JPRB,.539E-02_JPRB,.439E-02_JPRB,.439E-02_JPRB,.298E-02_JPRB,.298E-02_JPRB,.205E-02_JPRB,&
&.205E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,.678E-03_JPRB,.678E-03_JPRB,.479E-03_JPRB,.479E-03_JPRB,&
&.455E-03_JPRB,.455E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.954E-03_JPRB,&
&.954E-03_JPRB,.373E-03_JPRB,.373E-03_JPRB,.357E-03_JPRB,.357E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,&
&.374E-03_JPRB,.374E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 44 -82.0
ZAER (:,44,10) = (/&
&.345E-03_JPRB,.345E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.416E-03_JPRB,&
&.416E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,&
&.433E-03_JPRB,.433E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.534E-03_JPRB,&
&.534E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,.857E-03_JPRB,.857E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.953E-03_JPRB,.953E-03_JPRB,.856E-03_JPRB,.856E-03_JPRB,.759E-03_JPRB,.759E-03_JPRB,.721E-03_JPRB,&
&.721E-03_JPRB,.740E-03_JPRB,.740E-03_JPRB,.917E-03_JPRB,.917E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,&
&.457E-03_JPRB,.457E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.428E-03_JPRB,&
&.428E-03_JPRB,.411E-03_JPRB,.411E-03_JPRB,.412E-03_JPRB,.412E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.471E-03_JPRB,.471E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.514E-03_JPRB,.514E-03_JPRB,.424E-03_JPRB,&
&.424E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.334E-03_JPRB,.334E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,&
&.345E-03_JPRB,.345E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 45 -86.0
ZAER (:,45,10) = (/&
&.345E-03_JPRB,.345E-03_JPRB,.362E-03_JPRB,.362E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.416E-03_JPRB,&
&.416E-03_JPRB,.430E-03_JPRB,.430E-03_JPRB,.426E-03_JPRB,.426E-03_JPRB,.423E-03_JPRB,.423E-03_JPRB,&
&.433E-03_JPRB,.433E-03_JPRB,.467E-03_JPRB,.467E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.534E-03_JPRB,&
&.534E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,.857E-03_JPRB,.857E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.953E-03_JPRB,.953E-03_JPRB,.856E-03_JPRB,.856E-03_JPRB,.759E-03_JPRB,.759E-03_JPRB,.721E-03_JPRB,&
&.721E-03_JPRB,.740E-03_JPRB,.740E-03_JPRB,.917E-03_JPRB,.917E-03_JPRB,.558E-03_JPRB,.558E-03_JPRB,&
&.457E-03_JPRB,.457E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.440E-03_JPRB,.440E-03_JPRB,.428E-03_JPRB,&
&.428E-03_JPRB,.411E-03_JPRB,.411E-03_JPRB,.412E-03_JPRB,.412E-03_JPRB,.438E-03_JPRB,.438E-03_JPRB,&
&.471E-03_JPRB,.471E-03_JPRB,.519E-03_JPRB,.519E-03_JPRB,.514E-03_JPRB,.514E-03_JPRB,.424E-03_JPRB,&
&.424E-03_JPRB,.343E-03_JPRB,.343E-03_JPRB,.334E-03_JPRB,.334E-03_JPRB,.345E-03_JPRB,.345E-03_JPRB,&
&.345E-03_JPRB,.345E-03_JPRB/)
!-- Sea Salt Aerosol         month: 10 --- lat: 46 -90.0
ZAER (:,46,10) = (/&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,.399E-03_JPRB,&
&.399E-03_JPRB,.399E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  1  90.0
ZAER (:, 1,11) = (/&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  2  86.0
ZAER (:, 2,11) = (/&
&.264E-03_JPRB,.264E-03_JPRB,.297E-03_JPRB,.297E-03_JPRB,.325E-03_JPRB,.325E-03_JPRB,.347E-03_JPRB,&
&.347E-03_JPRB,.375E-03_JPRB,.375E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,&
&.400E-03_JPRB,.400E-03_JPRB,.378E-03_JPRB,.378E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.306E-03_JPRB,.306E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,&
&.347E-03_JPRB,.347E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,.313E-03_JPRB,.313E-03_JPRB,.233E-03_JPRB,&
&.233E-03_JPRB,.168E-03_JPRB,.168E-03_JPRB,.149E-03_JPRB,.149E-03_JPRB,.150E-03_JPRB,.150E-03_JPRB,&
&.165E-03_JPRB,.165E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.182E-03_JPRB,.182E-03_JPRB,.165E-03_JPRB,&
&.165E-03_JPRB,.151E-03_JPRB,.151E-03_JPRB,.136E-03_JPRB,.136E-03_JPRB,.118E-03_JPRB,.118E-03_JPRB,&
&.997E-04_JPRB,.997E-04_JPRB,.905E-04_JPRB,.905E-04_JPRB,.938E-04_JPRB,.938E-04_JPRB,.985E-04_JPRB,&
&.985E-04_JPRB,.108E-03_JPRB,.108E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,.166E-03_JPRB,.166E-03_JPRB,&
&.220E-03_JPRB,.220E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  3  82.0
ZAER (:, 3,11) = (/&
&.264E-03_JPRB,.264E-03_JPRB,.297E-03_JPRB,.297E-03_JPRB,.325E-03_JPRB,.325E-03_JPRB,.347E-03_JPRB,&
&.347E-03_JPRB,.375E-03_JPRB,.375E-03_JPRB,.401E-03_JPRB,.401E-03_JPRB,.417E-03_JPRB,.417E-03_JPRB,&
&.400E-03_JPRB,.400E-03_JPRB,.378E-03_JPRB,.378E-03_JPRB,.344E-03_JPRB,.344E-03_JPRB,.322E-03_JPRB,&
&.322E-03_JPRB,.306E-03_JPRB,.306E-03_JPRB,.296E-03_JPRB,.296E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,&
&.347E-03_JPRB,.347E-03_JPRB,.352E-03_JPRB,.352E-03_JPRB,.313E-03_JPRB,.313E-03_JPRB,.233E-03_JPRB,&
&.233E-03_JPRB,.168E-03_JPRB,.168E-03_JPRB,.149E-03_JPRB,.149E-03_JPRB,.150E-03_JPRB,.150E-03_JPRB,&
&.165E-03_JPRB,.165E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.182E-03_JPRB,.182E-03_JPRB,.165E-03_JPRB,&
&.165E-03_JPRB,.151E-03_JPRB,.151E-03_JPRB,.136E-03_JPRB,.136E-03_JPRB,.118E-03_JPRB,.118E-03_JPRB,&
&.997E-04_JPRB,.997E-04_JPRB,.905E-04_JPRB,.905E-04_JPRB,.938E-04_JPRB,.938E-04_JPRB,.985E-04_JPRB,&
&.985E-04_JPRB,.108E-03_JPRB,.108E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,.166E-03_JPRB,.166E-03_JPRB,&
&.220E-03_JPRB,.220E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  4  78.0
ZAER (:, 4,11) = (/&
&.246E-03_JPRB,.246E-03_JPRB,.314E-03_JPRB,.314E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.476E-03_JPRB,.476E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.680E-03_JPRB,.680E-03_JPRB,&
&.777E-03_JPRB,.777E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.777E-03_JPRB,.777E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.576E-03_JPRB,.576E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,.613E-03_JPRB,.613E-03_JPRB,&
&.744E-03_JPRB,.744E-03_JPRB,.719E-03_JPRB,.719E-03_JPRB,.635E-03_JPRB,.635E-03_JPRB,.513E-03_JPRB,&
&.513E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.160E-03_JPRB,.160E-03_JPRB,.178E-03_JPRB,.178E-03_JPRB,&
&.238E-03_JPRB,.238E-03_JPRB,.278E-03_JPRB,.278E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.338E-03_JPRB,&
&.338E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.266E-03_JPRB,.266E-03_JPRB,.183E-03_JPRB,.183E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,.135E-03_JPRB,.135E-03_JPRB,.182E-03_JPRB,&
&.182E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,.170E-03_JPRB,.170E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,&
&.205E-03_JPRB,.205E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  5  74.0
ZAER (:, 5,11) = (/&
&.246E-03_JPRB,.246E-03_JPRB,.314E-03_JPRB,.314E-03_JPRB,.359E-03_JPRB,.359E-03_JPRB,.420E-03_JPRB,&
&.420E-03_JPRB,.476E-03_JPRB,.476E-03_JPRB,.563E-03_JPRB,.563E-03_JPRB,.680E-03_JPRB,.680E-03_JPRB,&
&.777E-03_JPRB,.777E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.777E-03_JPRB,.777E-03_JPRB,.640E-03_JPRB,&
&.640E-03_JPRB,.576E-03_JPRB,.576E-03_JPRB,.509E-03_JPRB,.509E-03_JPRB,.613E-03_JPRB,.613E-03_JPRB,&
&.744E-03_JPRB,.744E-03_JPRB,.719E-03_JPRB,.719E-03_JPRB,.635E-03_JPRB,.635E-03_JPRB,.513E-03_JPRB,&
&.513E-03_JPRB,.277E-03_JPRB,.277E-03_JPRB,.160E-03_JPRB,.160E-03_JPRB,.178E-03_JPRB,.178E-03_JPRB,&
&.238E-03_JPRB,.238E-03_JPRB,.278E-03_JPRB,.278E-03_JPRB,.305E-03_JPRB,.305E-03_JPRB,.338E-03_JPRB,&
&.338E-03_JPRB,.360E-03_JPRB,.360E-03_JPRB,.266E-03_JPRB,.266E-03_JPRB,.183E-03_JPRB,.183E-03_JPRB,&
&.138E-03_JPRB,.138E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,.135E-03_JPRB,.135E-03_JPRB,.182E-03_JPRB,&
&.182E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,.170E-03_JPRB,.170E-03_JPRB,.175E-03_JPRB,.175E-03_JPRB,&
&.205E-03_JPRB,.205E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  6  70.0
ZAER (:, 6,11) = (/&
&.732E-03_JPRB,.732E-03_JPRB,.174E-02_JPRB,.174E-02_JPRB,.976E-03_JPRB,.976E-03_JPRB,.894E-03_JPRB,&
&.894E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.297E-02_JPRB,.297E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,.189E-02_JPRB,&
&.189E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.992E-03_JPRB,.992E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.967E-03_JPRB,.967E-03_JPRB,.849E-03_JPRB,.849E-03_JPRB,.786E-03_JPRB,&
&.786E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,.325E-03_JPRB,.325E-03_JPRB,.263E-03_JPRB,.263E-03_JPRB,&
&.556E-03_JPRB,.556E-03_JPRB,.851E-03_JPRB,.851E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.861E-03_JPRB,.861E-03_JPRB,&
&.915E-03_JPRB,.915E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  7  66.0
ZAER (:, 7,11) = (/&
&.732E-03_JPRB,.732E-03_JPRB,.174E-02_JPRB,.174E-02_JPRB,.976E-03_JPRB,.976E-03_JPRB,.894E-03_JPRB,&
&.894E-03_JPRB,.116E-02_JPRB,.116E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,&
&.259E-02_JPRB,.259E-02_JPRB,.297E-02_JPRB,.297E-02_JPRB,.276E-02_JPRB,.276E-02_JPRB,.189E-02_JPRB,&
&.189E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.992E-03_JPRB,.992E-03_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.967E-03_JPRB,.967E-03_JPRB,.849E-03_JPRB,.849E-03_JPRB,.786E-03_JPRB,&
&.786E-03_JPRB,.107E-02_JPRB,.107E-02_JPRB,.325E-03_JPRB,.325E-03_JPRB,.263E-03_JPRB,.263E-03_JPRB,&
&.556E-03_JPRB,.556E-03_JPRB,.851E-03_JPRB,.851E-03_JPRB,.102E-02_JPRB,.102E-02_JPRB,.169E-02_JPRB,&
&.169E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.861E-03_JPRB,.861E-03_JPRB,&
&.915E-03_JPRB,.915E-03_JPRB,.850E-03_JPRB,.850E-03_JPRB,.121E-02_JPRB,.121E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  8  62.0
ZAER (:, 8,11) = (/&
&.744E-02_JPRB,.744E-02_JPRB,.653E-02_JPRB,.653E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.613E-02_JPRB,&
&.613E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,&
&.317E-02_JPRB,.317E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.546E-03_JPRB,.546E-03_JPRB,.713E-03_JPRB,.713E-03_JPRB,&
&.995E-03_JPRB,.995E-03_JPRB,.360E-02_JPRB,.360E-02_JPRB,.504E-02_JPRB,.504E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.535E-02_JPRB,.535E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,&
&.521E-02_JPRB,.521E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.593E-02_JPRB,&
&.593E-02_JPRB,.461E-02_JPRB,.461E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.811E-02_JPRB,.811E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat:  9  58.0
ZAER (:, 9,11) = (/&
&.744E-02_JPRB,.744E-02_JPRB,.653E-02_JPRB,.653E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.613E-02_JPRB,&
&.613E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,.751E-02_JPRB,.751E-02_JPRB,.872E-02_JPRB,.872E-02_JPRB,&
&.104E-01_JPRB,.104E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.966E-02_JPRB,.966E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,&
&.317E-02_JPRB,.317E-02_JPRB,.234E-02_JPRB,.234E-02_JPRB,.179E-02_JPRB,.179E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.100E-02_JPRB,.100E-02_JPRB,.546E-03_JPRB,.546E-03_JPRB,.713E-03_JPRB,.713E-03_JPRB,&
&.995E-03_JPRB,.995E-03_JPRB,.360E-02_JPRB,.360E-02_JPRB,.504E-02_JPRB,.504E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.535E-02_JPRB,.535E-02_JPRB,.533E-02_JPRB,.533E-02_JPRB,.520E-02_JPRB,.520E-02_JPRB,&
&.521E-02_JPRB,.521E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,.604E-02_JPRB,.604E-02_JPRB,.593E-02_JPRB,&
&.593E-02_JPRB,.461E-02_JPRB,.461E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.811E-02_JPRB,.811E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 10  54.0
ZAER (:,10,11) = (/&
&.739E-02_JPRB,.739E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.797E-02_JPRB,&
&.797E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.968E-02_JPRB,.968E-02_JPRB,.990E-02_JPRB,.990E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,&
&.895E-02_JPRB,.895E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.585E-02_JPRB,&
&.585E-02_JPRB,.518E-02_JPRB,.518E-02_JPRB,.502E-02_JPRB,.502E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,&
&.456E-02_JPRB,.456E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,&
&.874E-02_JPRB,.874E-02_JPRB,.918E-02_JPRB,.918E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.941E-02_JPRB,&
&.941E-02_JPRB,.879E-02_JPRB,.879E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 11  50.0
ZAER (:,11,11) = (/&
&.739E-02_JPRB,.739E-02_JPRB,.763E-02_JPRB,.763E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.797E-02_JPRB,&
&.797E-02_JPRB,.840E-02_JPRB,.840E-02_JPRB,.948E-02_JPRB,.948E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.131E-01_JPRB,&
&.131E-01_JPRB,.968E-02_JPRB,.968E-02_JPRB,.990E-02_JPRB,.990E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,&
&.895E-02_JPRB,.895E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.585E-02_JPRB,&
&.585E-02_JPRB,.518E-02_JPRB,.518E-02_JPRB,.502E-02_JPRB,.502E-02_JPRB,.398E-02_JPRB,.398E-02_JPRB,&
&.456E-02_JPRB,.456E-02_JPRB,.708E-02_JPRB,.708E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,&
&.770E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.774E-02_JPRB,.774E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,&
&.874E-02_JPRB,.874E-02_JPRB,.918E-02_JPRB,.918E-02_JPRB,.949E-02_JPRB,.949E-02_JPRB,.941E-02_JPRB,&
&.941E-02_JPRB,.879E-02_JPRB,.879E-02_JPRB,.874E-02_JPRB,.874E-02_JPRB,.832E-02_JPRB,.832E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 12  46.0
ZAER (:,12,11) = (/&
&.678E-02_JPRB,.678E-02_JPRB,.680E-02_JPRB,.680E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.695E-02_JPRB,&
&.695E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,&
&.666E-02_JPRB,.666E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.732E-02_JPRB,&
&.732E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,&
&.938E-02_JPRB,.938E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.757E-02_JPRB,&
&.757E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,&
&.678E-02_JPRB,.678E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.901E-02_JPRB,&
&.901E-02_JPRB,.994E-02_JPRB,.994E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.978E-02_JPRB,.978E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,.948E-02_JPRB,&
&.948E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.534E-02_JPRB,.534E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 13  42.0
ZAER (:,13,11) = (/&
&.678E-02_JPRB,.678E-02_JPRB,.680E-02_JPRB,.680E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.695E-02_JPRB,&
&.695E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.660E-02_JPRB,.660E-02_JPRB,&
&.666E-02_JPRB,.666E-02_JPRB,.718E-02_JPRB,.718E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.732E-02_JPRB,&
&.732E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.659E-02_JPRB,.659E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,&
&.938E-02_JPRB,.938E-02_JPRB,.866E-02_JPRB,.866E-02_JPRB,.833E-02_JPRB,.833E-02_JPRB,.757E-02_JPRB,&
&.757E-02_JPRB,.723E-02_JPRB,.723E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,&
&.678E-02_JPRB,.678E-02_JPRB,.719E-02_JPRB,.719E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.901E-02_JPRB,&
&.901E-02_JPRB,.994E-02_JPRB,.994E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.978E-02_JPRB,.978E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,.948E-02_JPRB,&
&.948E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.733E-02_JPRB,.733E-02_JPRB,&
&.534E-02_JPRB,.534E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 14  38.0
ZAER (:,14,11) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.580E-02_JPRB,.580E-02_JPRB,&
&.563E-02_JPRB,.563E-02_JPRB,.541E-02_JPRB,.541E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.511E-02_JPRB,&
&.511E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.723E-02_JPRB,.723E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.673E-02_JPRB,&
&.673E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,&
&.687E-02_JPRB,.687E-02_JPRB,.741E-02_JPRB,.741E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.797E-02_JPRB,&
&.797E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.846E-02_JPRB,.846E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,&
&.753E-02_JPRB,.753E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.524E-02_JPRB,&
&.524E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 15  34.0
ZAER (:,15,11) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,.680E-02_JPRB,&
&.680E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.580E-02_JPRB,.580E-02_JPRB,&
&.563E-02_JPRB,.563E-02_JPRB,.541E-02_JPRB,.541E-02_JPRB,.547E-02_JPRB,.547E-02_JPRB,.511E-02_JPRB,&
&.511E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.723E-02_JPRB,.723E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.747E-02_JPRB,.747E-02_JPRB,.673E-02_JPRB,&
&.673E-02_JPRB,.645E-02_JPRB,.645E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,.585E-02_JPRB,.585E-02_JPRB,&
&.687E-02_JPRB,.687E-02_JPRB,.741E-02_JPRB,.741E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,.797E-02_JPRB,&
&.797E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.846E-02_JPRB,.846E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,&
&.753E-02_JPRB,.753E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.538E-02_JPRB,.538E-02_JPRB,.524E-02_JPRB,&
&.524E-02_JPRB,.343E-02_JPRB,.343E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.690E-02_JPRB,.690E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 16  30.0
ZAER (:,16,11) = (/&
&.683E-02_JPRB,.683E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.762E-02_JPRB,&
&.762E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.838E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.565E-02_JPRB,&
&.565E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,&
&.630E-02_JPRB,.630E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.655E-02_JPRB,&
&.655E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,&
&.443E-02_JPRB,.443E-02_JPRB,.703E-02_JPRB,.703E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.732E-02_JPRB,&
&.732E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,&
&.729E-02_JPRB,.729E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.251E-02_JPRB,&
&.251E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,&
&.726E-02_JPRB,.726E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 17  26.0
ZAER (:,17,11) = (/&
&.683E-02_JPRB,.683E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.704E-02_JPRB,.704E-02_JPRB,.762E-02_JPRB,&
&.762E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.838E-02_JPRB,.838E-02_JPRB,&
&.838E-02_JPRB,.838E-02_JPRB,.731E-02_JPRB,.731E-02_JPRB,.668E-02_JPRB,.668E-02_JPRB,.565E-02_JPRB,&
&.565E-02_JPRB,.275E-02_JPRB,.275E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.417E-02_JPRB,.417E-02_JPRB,&
&.630E-02_JPRB,.630E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.655E-02_JPRB,&
&.655E-02_JPRB,.626E-02_JPRB,.626E-02_JPRB,.583E-02_JPRB,.583E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,&
&.443E-02_JPRB,.443E-02_JPRB,.703E-02_JPRB,.703E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,.732E-02_JPRB,&
&.732E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.776E-02_JPRB,.776E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,&
&.729E-02_JPRB,.729E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.316E-02_JPRB,.316E-02_JPRB,.251E-02_JPRB,&
&.251E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.384E-02_JPRB,.384E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,&
&.726E-02_JPRB,.726E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 18  22.0
ZAER (:,18,11) = (/&
&.977E-02_JPRB,.977E-02_JPRB,.987E-02_JPRB,.987E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.912E-02_JPRB,.912E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,.902E-03_JPRB,.902E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.457E-02_JPRB,.457E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.585E-02_JPRB,&
&.585E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.211E-02_JPRB,.211E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.938E-02_JPRB,&
&.938E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.402E-02_JPRB,&
&.402E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.930E-02_JPRB,.930E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 19  18.0
ZAER (:,19,11) = (/&
&.977E-02_JPRB,.977E-02_JPRB,.987E-02_JPRB,.987E-02_JPRB,.899E-02_JPRB,.899E-02_JPRB,.863E-02_JPRB,&
&.863E-02_JPRB,.950E-02_JPRB,.950E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,&
&.107E-01_JPRB,.107E-01_JPRB,.912E-02_JPRB,.912E-02_JPRB,.746E-02_JPRB,.746E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.211E-02_JPRB,.211E-02_JPRB,.902E-03_JPRB,.902E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.457E-02_JPRB,.457E-02_JPRB,.673E-02_JPRB,.673E-02_JPRB,.662E-02_JPRB,.662E-02_JPRB,.585E-02_JPRB,&
&.585E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,&
&.211E-02_JPRB,.211E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.808E-02_JPRB,.808E-02_JPRB,.938E-02_JPRB,&
&.938E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.991E-02_JPRB,.991E-02_JPRB,.877E-02_JPRB,.877E-02_JPRB,.544E-02_JPRB,.544E-02_JPRB,.402E-02_JPRB,&
&.402E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.771E-02_JPRB,.771E-02_JPRB,&
&.930E-02_JPRB,.930E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 20  14.0
ZAER (:,20,11) = (/&
&.970E-02_JPRB,.970E-02_JPRB,.944E-02_JPRB,.944E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.794E-02_JPRB,.794E-02_JPRB,.534E-02_JPRB,.534E-02_JPRB,.290E-02_JPRB,&
&.290E-02_JPRB,.462E-03_JPRB,.462E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.442E-02_JPRB,.442E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.539E-02_JPRB,&
&.539E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.982E-03_JPRB,.982E-03_JPRB,&
&.308E-02_JPRB,.308E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.850E-02_JPRB,.850E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.567E-02_JPRB,&
&.567E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,&
&.939E-02_JPRB,.939E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 21  10.0
ZAER (:,21,11) = (/&
&.970E-02_JPRB,.970E-02_JPRB,.944E-02_JPRB,.944E-02_JPRB,.986E-02_JPRB,.986E-02_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,&
&.103E-01_JPRB,.103E-01_JPRB,.794E-02_JPRB,.794E-02_JPRB,.534E-02_JPRB,.534E-02_JPRB,.290E-02_JPRB,&
&.290E-02_JPRB,.462E-03_JPRB,.462E-03_JPRB,.338E-03_JPRB,.338E-03_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.442E-02_JPRB,.442E-02_JPRB,.821E-02_JPRB,.821E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.539E-02_JPRB,&
&.539E-02_JPRB,.370E-02_JPRB,.370E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.982E-03_JPRB,.982E-03_JPRB,&
&.308E-02_JPRB,.308E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.112E-01_JPRB,.112E-01_JPRB,.124E-01_JPRB,&
&.124E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.850E-02_JPRB,.850E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.567E-02_JPRB,&
&.567E-02_JPRB,.631E-02_JPRB,.631E-02_JPRB,.849E-02_JPRB,.849E-02_JPRB,.927E-02_JPRB,.927E-02_JPRB,&
&.939E-02_JPRB,.939E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 22   6.0
ZAER (:,22,11) = (/&
&.107E-01_JPRB,.107E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.778E-02_JPRB,.778E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.444E-03_JPRB,.444E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,&
&.798E-02_JPRB,.798E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.799E-02_JPRB,.799E-02_JPRB,.536E-02_JPRB,&
&.536E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.999E-03_JPRB,.999E-03_JPRB,&
&.410E-02_JPRB,.410E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,.888E-02_JPRB,&
&.888E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,&
&.397E-02_JPRB,.397E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.477E-02_JPRB,&
&.477E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,&
&.907E-02_JPRB,.907E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 23   2.0
ZAER (:,23,11) = (/&
&.107E-01_JPRB,.107E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.127E-01_JPRB,.127E-01_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,&
&.778E-02_JPRB,.778E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.444E-03_JPRB,.444E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.368E-02_JPRB,.368E-02_JPRB,&
&.798E-02_JPRB,.798E-02_JPRB,.101E-01_JPRB,.101E-01_JPRB,.799E-02_JPRB,.799E-02_JPRB,.536E-02_JPRB,&
&.536E-02_JPRB,.381E-02_JPRB,.381E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.999E-03_JPRB,.999E-03_JPRB,&
&.410E-02_JPRB,.410E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.975E-02_JPRB,.975E-02_JPRB,.888E-02_JPRB,&
&.888E-02_JPRB,.727E-02_JPRB,.727E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,&
&.397E-02_JPRB,.397E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.594E-02_JPRB,.594E-02_JPRB,.477E-02_JPRB,&
&.477E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,.675E-02_JPRB,.675E-02_JPRB,.801E-02_JPRB,.801E-02_JPRB,&
&.907E-02_JPRB,.907E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 24  -2.0
ZAER (:,24,11) = (/&
&.922E-02_JPRB,.922E-02_JPRB,.997E-02_JPRB,.997E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.998E-02_JPRB,.998E-02_JPRB,&
&.814E-02_JPRB,.814E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.701E-02_JPRB,.701E-02_JPRB,.336E-02_JPRB,&
&.336E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.430E-02_JPRB,.430E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,&
&.975E-02_JPRB,.975E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.507E-02_JPRB,&
&.507E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,&
&.446E-02_JPRB,.446E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,.792E-02_JPRB,&
&.792E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.490E-02_JPRB,.490E-02_JPRB,&
&.421E-02_JPRB,.421E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.881E-02_JPRB,&
&.881E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 25  -6.0
ZAER (:,25,11) = (/&
&.922E-02_JPRB,.922E-02_JPRB,.997E-02_JPRB,.997E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,.998E-02_JPRB,.998E-02_JPRB,&
&.814E-02_JPRB,.814E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.701E-02_JPRB,.701E-02_JPRB,.336E-02_JPRB,&
&.336E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,.430E-02_JPRB,.430E-02_JPRB,.794E-02_JPRB,.794E-02_JPRB,&
&.975E-02_JPRB,.975E-02_JPRB,.960E-02_JPRB,.960E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.507E-02_JPRB,&
&.507E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.213E-02_JPRB,.213E-02_JPRB,&
&.446E-02_JPRB,.446E-02_JPRB,.729E-02_JPRB,.729E-02_JPRB,.907E-02_JPRB,.907E-02_JPRB,.792E-02_JPRB,&
&.792E-02_JPRB,.707E-02_JPRB,.707E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.490E-02_JPRB,.490E-02_JPRB,&
&.421E-02_JPRB,.421E-02_JPRB,.605E-02_JPRB,.605E-02_JPRB,.810E-02_JPRB,.810E-02_JPRB,.881E-02_JPRB,&
&.881E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.787E-02_JPRB,.787E-02_JPRB,.791E-02_JPRB,.791E-02_JPRB,&
&.842E-02_JPRB,.842E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 26 -10.0
ZAER (:,26,11) = (/&
&.902E-02_JPRB,.902E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.752E-02_JPRB,.752E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.658E-02_JPRB,.658E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,&
&.663E-02_JPRB,.663E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 27 -14.0
ZAER (:,27,11) = (/&
&.902E-02_JPRB,.902E-02_JPRB,.831E-02_JPRB,.831E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.128E-01_JPRB,&
&.128E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.936E-02_JPRB,.936E-02_JPRB,.790E-02_JPRB,.790E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,.751E-02_JPRB,&
&.751E-02_JPRB,.862E-02_JPRB,.862E-02_JPRB,.105E-01_JPRB,.105E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.752E-02_JPRB,.752E-02_JPRB,.414E-02_JPRB,&
&.414E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.173E-02_JPRB,.173E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB,.554E-02_JPRB,.554E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.932E-02_JPRB,&
&.932E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.658E-02_JPRB,.658E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,&
&.663E-02_JPRB,.663E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,&
&.106E-01_JPRB,.106E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 28 -18.0
ZAER (:,28,11) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.876E-02_JPRB,.876E-02_JPRB,.775E-02_JPRB,.775E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.912E-02_JPRB,&
&.912E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.794E-02_JPRB,.794E-02_JPRB,.502E-02_JPRB,&
&.502E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,&
&.291E-02_JPRB,.291E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.200E-01_JPRB,&
&.200E-01_JPRB,.196E-01_JPRB,.196E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 29 -22.0
ZAER (:,29,11) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,&
&.876E-02_JPRB,.876E-02_JPRB,.775E-02_JPRB,.775E-02_JPRB,.828E-02_JPRB,.828E-02_JPRB,.912E-02_JPRB,&
&.912E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.134E-01_JPRB,.134E-01_JPRB,&
&.131E-01_JPRB,.131E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.794E-02_JPRB,.794E-02_JPRB,.502E-02_JPRB,&
&.502E-02_JPRB,.437E-02_JPRB,.437E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,&
&.291E-02_JPRB,.291E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.385E-02_JPRB,.385E-02_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.496E-02_JPRB,.496E-02_JPRB,.408E-02_JPRB,.408E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,&
&.583E-02_JPRB,.583E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.200E-01_JPRB,&
&.200E-01_JPRB,.196E-01_JPRB,.196E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 30 -26.0
ZAER (:,30,11) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.945E-02_JPRB,.945E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,&
&.669E-02_JPRB,.669E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.840E-02_JPRB,&
&.840E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.501E-02_JPRB,.501E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.403E-02_JPRB,.403E-02_JPRB,&
&.355E-02_JPRB,.355E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,.263E-02_JPRB,&
&.263E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,&
&.209E-02_JPRB,.209E-02_JPRB,.360E-02_JPRB,.360E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 31 -30.0
ZAER (:,31,11) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.945E-02_JPRB,.945E-02_JPRB,.826E-02_JPRB,.826E-02_JPRB,&
&.669E-02_JPRB,.669E-02_JPRB,.700E-02_JPRB,.700E-02_JPRB,.778E-02_JPRB,.778E-02_JPRB,.840E-02_JPRB,&
&.840E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.121E-01_JPRB,.121E-01_JPRB,&
&.128E-01_JPRB,.128E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.653E-02_JPRB,&
&.653E-02_JPRB,.501E-02_JPRB,.501E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.403E-02_JPRB,.403E-02_JPRB,&
&.355E-02_JPRB,.355E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,.263E-02_JPRB,&
&.263E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,&
&.209E-02_JPRB,.209E-02_JPRB,.360E-02_JPRB,.360E-02_JPRB,.848E-02_JPRB,.848E-02_JPRB,.133E-01_JPRB,&
&.133E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.138E-01_JPRB,.138E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 32 -34.0
ZAER (:,32,11) = (/&
&.125E-01_JPRB,.125E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.843E-02_JPRB,.843E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,&
&.358E-02_JPRB,.358E-02_JPRB,.336E-02_JPRB,.336E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.352E-02_JPRB,&
&.352E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.823E-02_JPRB,&
&.823E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.589E-02_JPRB,.589E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,&
&.434E-02_JPRB,.434E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.219E-02_JPRB,&
&.219E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.279E-02_JPRB,.279E-02_JPRB,.427E-02_JPRB,&
&.427E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.976E-02_JPRB,.976E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 33 -38.0
ZAER (:,33,11) = (/&
&.125E-01_JPRB,.125E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.135E-01_JPRB,.135E-01_JPRB,.121E-01_JPRB,&
&.121E-01_JPRB,.103E-01_JPRB,.103E-01_JPRB,.843E-02_JPRB,.843E-02_JPRB,.455E-02_JPRB,.455E-02_JPRB,&
&.358E-02_JPRB,.358E-02_JPRB,.336E-02_JPRB,.336E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.352E-02_JPRB,&
&.352E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,&
&.141E-01_JPRB,.141E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.823E-02_JPRB,&
&.823E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.589E-02_JPRB,.589E-02_JPRB,.591E-02_JPRB,.591E-02_JPRB,&
&.434E-02_JPRB,.434E-02_JPRB,.282E-02_JPRB,.282E-02_JPRB,.265E-02_JPRB,.265E-02_JPRB,.219E-02_JPRB,&
&.219E-02_JPRB,.187E-02_JPRB,.187E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.109E-02_JPRB,.109E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.279E-02_JPRB,.279E-02_JPRB,.427E-02_JPRB,&
&.427E-02_JPRB,.674E-02_JPRB,.674E-02_JPRB,.976E-02_JPRB,.976E-02_JPRB,.126E-01_JPRB,.126E-01_JPRB,&
&.132E-01_JPRB,.132E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 34 -42.0
ZAER (:,34,11) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.792E-02_JPRB,.792E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,&
&.209E-02_JPRB,.209E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.657E-02_JPRB,.657E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,&
&.399E-02_JPRB,.399E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.956E-03_JPRB,.956E-03_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.126E-01_JPRB,.126E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 35 -46.0
ZAER (:,35,11) = (/&
&.117E-01_JPRB,.117E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.123E-01_JPRB,&
&.123E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.792E-02_JPRB,.792E-02_JPRB,.313E-02_JPRB,.313E-02_JPRB,&
&.209E-02_JPRB,.209E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.361E-02_JPRB,.361E-02_JPRB,.851E-02_JPRB,.851E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.657E-02_JPRB,.657E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,&
&.399E-02_JPRB,.399E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.200E-02_JPRB,&
&.200E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,&
&.128E-02_JPRB,.128E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.956E-03_JPRB,.956E-03_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.409E-02_JPRB,.409E-02_JPRB,.822E-02_JPRB,.822E-02_JPRB,.115E-01_JPRB,.115E-01_JPRB,&
&.126E-01_JPRB,.126E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 36 -50.0
ZAER (:,36,11) = (/&
&.121E-01_JPRB,.121E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.580E-02_JPRB,.580E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,&
&.178E-02_JPRB,.178E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.145E-02_JPRB,&
&.145E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.677E-02_JPRB,.677E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.253E-02_JPRB,.253E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.175E-02_JPRB,&
&.175E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,.831E-03_JPRB,.831E-03_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.396E-02_JPRB,.396E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 37 -54.0
ZAER (:,37,11) = (/&
&.121E-01_JPRB,.121E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.111E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.580E-02_JPRB,.580E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,&
&.178E-02_JPRB,.178E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.145E-02_JPRB,&
&.145E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.404E-02_JPRB,.404E-02_JPRB,.943E-02_JPRB,.943E-02_JPRB,&
&.114E-01_JPRB,.114E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,.140E-01_JPRB,.140E-01_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.677E-02_JPRB,.677E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,&
&.253E-02_JPRB,.253E-02_JPRB,.220E-02_JPRB,.220E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.175E-02_JPRB,&
&.175E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,.831E-03_JPRB,.831E-03_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.396E-02_JPRB,.396E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.107E-01_JPRB,.107E-01_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 38 -58.0
ZAER (:,38,11) = (/&
&.751E-02_JPRB,.751E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.656E-02_JPRB,&
&.656E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.278E-02_JPRB,.278E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,&
&.138E-02_JPRB,.138E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.259E-02_JPRB,&
&.259E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.614E-02_JPRB,.614E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.917E-02_JPRB,.917E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.171E-02_JPRB,&
&.171E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.995E-03_JPRB,.995E-03_JPRB,&
&.872E-03_JPRB,.872E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.777E-03_JPRB,.777E-03_JPRB,.977E-03_JPRB,&
&.977E-03_JPRB,.299E-02_JPRB,.299E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,&
&.847E-02_JPRB,.847E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 39 -62.0
ZAER (:,39,11) = (/&
&.751E-02_JPRB,.751E-02_JPRB,.818E-02_JPRB,.818E-02_JPRB,.550E-02_JPRB,.550E-02_JPRB,.656E-02_JPRB,&
&.656E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.278E-02_JPRB,.278E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,&
&.138E-02_JPRB,.138E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.470E-02_JPRB,.470E-02_JPRB,.259E-02_JPRB,&
&.259E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.614E-02_JPRB,.614E-02_JPRB,.798E-02_JPRB,.798E-02_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.126E-01_JPRB,.126E-01_JPRB,.110E-01_JPRB,&
&.110E-01_JPRB,.917E-02_JPRB,.917E-02_JPRB,.484E-02_JPRB,.484E-02_JPRB,.358E-02_JPRB,.358E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.209E-02_JPRB,.209E-02_JPRB,.196E-02_JPRB,.196E-02_JPRB,.171E-02_JPRB,&
&.171E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.995E-03_JPRB,.995E-03_JPRB,&
&.872E-03_JPRB,.872E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.777E-03_JPRB,.777E-03_JPRB,.977E-03_JPRB,&
&.977E-03_JPRB,.299E-02_JPRB,.299E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,&
&.847E-02_JPRB,.847E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 40 -66.0
ZAER (:,40,11) = (/&
&.250E-02_JPRB,.250E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.215E-02_JPRB,&
&.215E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,&
&.819E-03_JPRB,.819E-03_JPRB,.958E-03_JPRB,.958E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.820E-03_JPRB,.820E-03_JPRB,.324E-02_JPRB,.324E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,&
&.494E-02_JPRB,.494E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.979E-02_JPRB,.979E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.764E-02_JPRB,.764E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,&
&.370E-02_JPRB,.370E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,.197E-02_JPRB,&
&.197E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.828E-03_JPRB,.828E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,&
&.731E-03_JPRB,.731E-03_JPRB,.760E-03_JPRB,.760E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.262E-02_JPRB,.262E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 41 -70.0
ZAER (:,41,11) = (/&
&.250E-02_JPRB,.250E-02_JPRB,.291E-02_JPRB,.291E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.215E-02_JPRB,&
&.215E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,&
&.819E-03_JPRB,.819E-03_JPRB,.958E-03_JPRB,.958E-03_JPRB,.112E-02_JPRB,.112E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.820E-03_JPRB,.820E-03_JPRB,.324E-02_JPRB,.324E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,&
&.494E-02_JPRB,.494E-02_JPRB,.740E-02_JPRB,.740E-02_JPRB,.979E-02_JPRB,.979E-02_JPRB,.118E-01_JPRB,&
&.118E-01_JPRB,.109E-01_JPRB,.109E-01_JPRB,.764E-02_JPRB,.764E-02_JPRB,.411E-02_JPRB,.411E-02_JPRB,&
&.370E-02_JPRB,.370E-02_JPRB,.410E-02_JPRB,.410E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,.197E-02_JPRB,&
&.197E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.828E-03_JPRB,.828E-03_JPRB,.765E-03_JPRB,.765E-03_JPRB,&
&.731E-03_JPRB,.731E-03_JPRB,.760E-03_JPRB,.760E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.109E-02_JPRB,&
&.109E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.261E-02_JPRB,.261E-02_JPRB,&
&.262E-02_JPRB,.262E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 42 -74.0
ZAER (:,42,11) = (/&
&.954E-03_JPRB,.954E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,.590E-03_JPRB,&
&.590E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.518E-03_JPRB,.518E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.615E-03_JPRB,&
&.615E-03_JPRB,.800E-03_JPRB,.800E-03_JPRB,.176E-02_JPRB,.176E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,&
&.230E-02_JPRB,.230E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.279E-02_JPRB,.279E-02_JPRB,.463E-02_JPRB,&
&.463E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,&
&.528E-02_JPRB,.528E-02_JPRB,.397E-02_JPRB,.397E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.667E-03_JPRB,.667E-03_JPRB,&
&.636E-03_JPRB,.636E-03_JPRB,.752E-03_JPRB,.752E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,&
&.108E-02_JPRB,.108E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 43 -78.0
ZAER (:,43,11) = (/&
&.954E-03_JPRB,.954E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.700E-03_JPRB,.700E-03_JPRB,.590E-03_JPRB,&
&.590E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.577E-03_JPRB,.577E-03_JPRB,.518E-03_JPRB,.518E-03_JPRB,&
&.499E-03_JPRB,.499E-03_JPRB,.510E-03_JPRB,.510E-03_JPRB,.508E-03_JPRB,.508E-03_JPRB,.615E-03_JPRB,&
&.615E-03_JPRB,.800E-03_JPRB,.800E-03_JPRB,.176E-02_JPRB,.176E-02_JPRB,.244E-02_JPRB,.244E-02_JPRB,&
&.230E-02_JPRB,.230E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.279E-02_JPRB,.279E-02_JPRB,.463E-02_JPRB,&
&.463E-02_JPRB,.677E-02_JPRB,.677E-02_JPRB,.616E-02_JPRB,.616E-02_JPRB,.570E-02_JPRB,.570E-02_JPRB,&
&.528E-02_JPRB,.528E-02_JPRB,.397E-02_JPRB,.397E-02_JPRB,.228E-02_JPRB,.228E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.932E-03_JPRB,.932E-03_JPRB,.787E-03_JPRB,.787E-03_JPRB,.667E-03_JPRB,.667E-03_JPRB,&
&.636E-03_JPRB,.636E-03_JPRB,.752E-03_JPRB,.752E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,.122E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,&
&.108E-02_JPRB,.108E-02_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 44 -82.0
ZAER (:,44,11) = (/&
&.662E-03_JPRB,.662E-03_JPRB,.631E-03_JPRB,.631E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.572E-03_JPRB,&
&.572E-03_JPRB,.566E-03_JPRB,.566E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,&
&.660E-03_JPRB,.660E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.199E-02_JPRB,&
&.199E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,&
&.890E-03_JPRB,.890E-03_JPRB,.770E-03_JPRB,.770E-03_JPRB,.723E-03_JPRB,.723E-03_JPRB,.698E-03_JPRB,&
&.698E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,&
&.794E-03_JPRB,.794E-03_JPRB,.840E-03_JPRB,.840E-03_JPRB,.867E-03_JPRB,.867E-03_JPRB,.853E-03_JPRB,&
&.853E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.778E-03_JPRB,.778E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,&
&.689E-03_JPRB,.689E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 45 -86.0
ZAER (:,45,11) = (/&
&.662E-03_JPRB,.662E-03_JPRB,.631E-03_JPRB,.631E-03_JPRB,.595E-03_JPRB,.595E-03_JPRB,.572E-03_JPRB,&
&.572E-03_JPRB,.566E-03_JPRB,.566E-03_JPRB,.579E-03_JPRB,.579E-03_JPRB,.609E-03_JPRB,.609E-03_JPRB,&
&.660E-03_JPRB,.660E-03_JPRB,.731E-03_JPRB,.731E-03_JPRB,.854E-03_JPRB,.854E-03_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.168E-02_JPRB,.168E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,&
&.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.199E-02_JPRB,&
&.199E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,&
&.890E-03_JPRB,.890E-03_JPRB,.770E-03_JPRB,.770E-03_JPRB,.723E-03_JPRB,.723E-03_JPRB,.698E-03_JPRB,&
&.698E-03_JPRB,.704E-03_JPRB,.704E-03_JPRB,.741E-03_JPRB,.741E-03_JPRB,.768E-03_JPRB,.768E-03_JPRB,&
&.794E-03_JPRB,.794E-03_JPRB,.840E-03_JPRB,.840E-03_JPRB,.867E-03_JPRB,.867E-03_JPRB,.853E-03_JPRB,&
&.853E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.778E-03_JPRB,.778E-03_JPRB,.726E-03_JPRB,.726E-03_JPRB,&
&.689E-03_JPRB,.689E-03_JPRB/)
!-- Sea Salt Aerosol         month: 11 --- lat: 46 -90.0
ZAER (:,46,11) = (/&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.116E-02_JPRB,.116E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  1  90.0
ZAER (:, 1,12) = (/&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,.211E-03_JPRB,&
&.211E-03_JPRB,.211E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  2  86.0
ZAER (:, 2,12) = (/&
&.248E-03_JPRB,.248E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,.324E-03_JPRB,&
&.324E-03_JPRB,.358E-03_JPRB,.358E-03_JPRB,.368E-03_JPRB,.368E-03_JPRB,.381E-03_JPRB,.381E-03_JPRB,&
&.388E-03_JPRB,.388E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,&
&.394E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,&
&.285E-03_JPRB,.285E-03_JPRB,.250E-03_JPRB,.250E-03_JPRB,.212E-03_JPRB,.212E-03_JPRB,.165E-03_JPRB,&
&.165E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,.176E-03_JPRB,.176E-03_JPRB,.185E-03_JPRB,.185E-03_JPRB,&
&.189E-03_JPRB,.189E-03_JPRB,.182E-03_JPRB,.182E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.183E-03_JPRB,&
&.183E-03_JPRB,.181E-03_JPRB,.181E-03_JPRB,.171E-03_JPRB,.171E-03_JPRB,.160E-03_JPRB,.160E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.152E-03_JPRB,.152E-03_JPRB,.162E-03_JPRB,&
&.162E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.198E-03_JPRB,.198E-03_JPRB,.230E-03_JPRB,.230E-03_JPRB,&
&.264E-03_JPRB,.264E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  3  82.0
ZAER (:, 3,12) = (/&
&.248E-03_JPRB,.248E-03_JPRB,.240E-03_JPRB,.240E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,.324E-03_JPRB,&
&.324E-03_JPRB,.358E-03_JPRB,.358E-03_JPRB,.368E-03_JPRB,.368E-03_JPRB,.381E-03_JPRB,.381E-03_JPRB,&
&.388E-03_JPRB,.388E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,.394E-03_JPRB,&
&.394E-03_JPRB,.388E-03_JPRB,.388E-03_JPRB,.366E-03_JPRB,.366E-03_JPRB,.330E-03_JPRB,.330E-03_JPRB,&
&.285E-03_JPRB,.285E-03_JPRB,.250E-03_JPRB,.250E-03_JPRB,.212E-03_JPRB,.212E-03_JPRB,.165E-03_JPRB,&
&.165E-03_JPRB,.159E-03_JPRB,.159E-03_JPRB,.176E-03_JPRB,.176E-03_JPRB,.185E-03_JPRB,.185E-03_JPRB,&
&.189E-03_JPRB,.189E-03_JPRB,.182E-03_JPRB,.182E-03_JPRB,.180E-03_JPRB,.180E-03_JPRB,.183E-03_JPRB,&
&.183E-03_JPRB,.181E-03_JPRB,.181E-03_JPRB,.171E-03_JPRB,.171E-03_JPRB,.160E-03_JPRB,.160E-03_JPRB,&
&.152E-03_JPRB,.152E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.152E-03_JPRB,.152E-03_JPRB,.162E-03_JPRB,&
&.162E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.198E-03_JPRB,.198E-03_JPRB,.230E-03_JPRB,.230E-03_JPRB,&
&.264E-03_JPRB,.264E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  4  78.0
ZAER (:, 4,12) = (/&
&.535E-03_JPRB,.535E-03_JPRB,.437E-03_JPRB,.437E-03_JPRB,.368E-03_JPRB,.368E-03_JPRB,.406E-03_JPRB,&
&.406E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.528E-03_JPRB,.528E-03_JPRB,&
&.613E-03_JPRB,.613E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.627E-03_JPRB,.627E-03_JPRB,.641E-03_JPRB,&
&.641E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,&
&.332E-03_JPRB,.332E-03_JPRB,.390E-03_JPRB,.390E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.378E-03_JPRB,&
&.378E-03_JPRB,.228E-03_JPRB,.228E-03_JPRB,.205E-03_JPRB,.205E-03_JPRB,.279E-03_JPRB,.279E-03_JPRB,&
&.344E-03_JPRB,.344E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.397E-03_JPRB,&
&.397E-03_JPRB,.314E-03_JPRB,.314E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.147E-03_JPRB,.147E-03_JPRB,&
&.125E-03_JPRB,.125E-03_JPRB,.161E-03_JPRB,.161E-03_JPRB,.206E-03_JPRB,.206E-03_JPRB,.216E-03_JPRB,&
&.216E-03_JPRB,.263E-03_JPRB,.263E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.393E-03_JPRB,.393E-03_JPRB,&
&.584E-03_JPRB,.584E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  5  74.0
ZAER (:, 5,12) = (/&
&.535E-03_JPRB,.535E-03_JPRB,.437E-03_JPRB,.437E-03_JPRB,.368E-03_JPRB,.368E-03_JPRB,.406E-03_JPRB,&
&.406E-03_JPRB,.420E-03_JPRB,.420E-03_JPRB,.453E-03_JPRB,.453E-03_JPRB,.528E-03_JPRB,.528E-03_JPRB,&
&.613E-03_JPRB,.613E-03_JPRB,.590E-03_JPRB,.590E-03_JPRB,.627E-03_JPRB,.627E-03_JPRB,.641E-03_JPRB,&
&.641E-03_JPRB,.540E-03_JPRB,.540E-03_JPRB,.435E-03_JPRB,.435E-03_JPRB,.354E-03_JPRB,.354E-03_JPRB,&
&.332E-03_JPRB,.332E-03_JPRB,.390E-03_JPRB,.390E-03_JPRB,.463E-03_JPRB,.463E-03_JPRB,.378E-03_JPRB,&
&.378E-03_JPRB,.228E-03_JPRB,.228E-03_JPRB,.205E-03_JPRB,.205E-03_JPRB,.279E-03_JPRB,.279E-03_JPRB,&
&.344E-03_JPRB,.344E-03_JPRB,.370E-03_JPRB,.370E-03_JPRB,.372E-03_JPRB,.372E-03_JPRB,.397E-03_JPRB,&
&.397E-03_JPRB,.314E-03_JPRB,.314E-03_JPRB,.224E-03_JPRB,.224E-03_JPRB,.147E-03_JPRB,.147E-03_JPRB,&
&.125E-03_JPRB,.125E-03_JPRB,.161E-03_JPRB,.161E-03_JPRB,.206E-03_JPRB,.206E-03_JPRB,.216E-03_JPRB,&
&.216E-03_JPRB,.263E-03_JPRB,.263E-03_JPRB,.302E-03_JPRB,.302E-03_JPRB,.393E-03_JPRB,.393E-03_JPRB,&
&.584E-03_JPRB,.584E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  6  70.0
ZAER (:, 6,12) = (/&
&.314E-02_JPRB,.314E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.797E-03_JPRB,.797E-03_JPRB,.163E-02_JPRB,&
&.163E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,&
&.261E-02_JPRB,.261E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.240E-02_JPRB,&
&.240E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.921E-03_JPRB,.921E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,&
&.685E-03_JPRB,.685E-03_JPRB,.819E-03_JPRB,.819E-03_JPRB,.204E-02_JPRB,.204E-02_JPRB,.184E-02_JPRB,&
&.184E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.847E-03_JPRB,.847E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,&
&.562E-03_JPRB,.562E-03_JPRB,.993E-03_JPRB,.993E-03_JPRB,.172E-02_JPRB,.172E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,&
&.321E-02_JPRB,.321E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  7  66.0
ZAER (:, 7,12) = (/&
&.314E-02_JPRB,.314E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,.797E-03_JPRB,.797E-03_JPRB,.163E-02_JPRB,&
&.163E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,&
&.261E-02_JPRB,.261E-02_JPRB,.257E-02_JPRB,.257E-02_JPRB,.237E-02_JPRB,.237E-02_JPRB,.240E-02_JPRB,&
&.240E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.921E-03_JPRB,.921E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,&
&.685E-03_JPRB,.685E-03_JPRB,.819E-03_JPRB,.819E-03_JPRB,.204E-02_JPRB,.204E-02_JPRB,.184E-02_JPRB,&
&.184E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,&
&.124E-02_JPRB,.124E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.847E-03_JPRB,.847E-03_JPRB,.421E-03_JPRB,.421E-03_JPRB,&
&.562E-03_JPRB,.562E-03_JPRB,.993E-03_JPRB,.993E-03_JPRB,.172E-02_JPRB,.172E-02_JPRB,.148E-02_JPRB,&
&.148E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.156E-02_JPRB,.156E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,&
&.321E-02_JPRB,.321E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  8  62.0
ZAER (:, 8,12) = (/&
&.794E-02_JPRB,.794E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.587E-02_JPRB,.587E-02_JPRB,.582E-02_JPRB,&
&.582E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.638E-02_JPRB,.638E-02_JPRB,&
&.663E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,&
&.431E-02_JPRB,.431E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,.471E-02_JPRB,&
&.471E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.465E-02_JPRB,.465E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.502E-02_JPRB,.502E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.459E-02_JPRB,.459E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.540E-02_JPRB,&
&.540E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,&
&.815E-02_JPRB,.815E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat:  9  58.0
ZAER (:, 9,12) = (/&
&.794E-02_JPRB,.794E-02_JPRB,.691E-02_JPRB,.691E-02_JPRB,.587E-02_JPRB,.587E-02_JPRB,.582E-02_JPRB,&
&.582E-02_JPRB,.623E-02_JPRB,.623E-02_JPRB,.628E-02_JPRB,.628E-02_JPRB,.638E-02_JPRB,.638E-02_JPRB,&
&.663E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.663E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.630E-02_JPRB,&
&.630E-02_JPRB,.563E-02_JPRB,.563E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,&
&.431E-02_JPRB,.431E-02_JPRB,.441E-02_JPRB,.441E-02_JPRB,.510E-02_JPRB,.510E-02_JPRB,.471E-02_JPRB,&
&.471E-02_JPRB,.459E-02_JPRB,.459E-02_JPRB,.445E-02_JPRB,.445E-02_JPRB,.426E-02_JPRB,.426E-02_JPRB,&
&.465E-02_JPRB,.465E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.502E-02_JPRB,.502E-02_JPRB,.537E-02_JPRB,&
&.537E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.528E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.459E-02_JPRB,.459E-02_JPRB,.500E-02_JPRB,.500E-02_JPRB,.573E-02_JPRB,.573E-02_JPRB,.540E-02_JPRB,&
&.540E-02_JPRB,.522E-02_JPRB,.522E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,&
&.815E-02_JPRB,.815E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 10  54.0
ZAER (:,10,12) = (/&
&.975E-02_JPRB,.975E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.805E-02_JPRB,&
&.805E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,&
&.751E-02_JPRB,.751E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.648E-02_JPRB,&
&.648E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,&
&.711E-02_JPRB,.711E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.800E-02_JPRB,&
&.800E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,&
&.679E-02_JPRB,.679E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 11  50.0
ZAER (:,11,12) = (/&
&.975E-02_JPRB,.975E-02_JPRB,.880E-02_JPRB,.880E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.805E-02_JPRB,&
&.805E-02_JPRB,.803E-02_JPRB,.803E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.758E-02_JPRB,.758E-02_JPRB,&
&.751E-02_JPRB,.751E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,.736E-02_JPRB,.736E-02_JPRB,.648E-02_JPRB,&
&.648E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.613E-02_JPRB,.613E-02_JPRB,.742E-02_JPRB,.742E-02_JPRB,&
&.711E-02_JPRB,.711E-02_JPRB,.709E-02_JPRB,.709E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.686E-02_JPRB,&
&.686E-02_JPRB,.684E-02_JPRB,.684E-02_JPRB,.634E-02_JPRB,.634E-02_JPRB,.599E-02_JPRB,.599E-02_JPRB,&
&.646E-02_JPRB,.646E-02_JPRB,.686E-02_JPRB,.686E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.800E-02_JPRB,&
&.800E-02_JPRB,.809E-02_JPRB,.809E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.783E-02_JPRB,.783E-02_JPRB,&
&.679E-02_JPRB,.679E-02_JPRB,.682E-02_JPRB,.682E-02_JPRB,.786E-02_JPRB,.786E-02_JPRB,.883E-02_JPRB,&
&.883E-02_JPRB,.934E-02_JPRB,.934E-02_JPRB,.933E-02_JPRB,.933E-02_JPRB,.958E-02_JPRB,.958E-02_JPRB,&
&.973E-02_JPRB,.973E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 12  46.0
ZAER (:,12,12) = (/&
&.702E-02_JPRB,.702E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.692E-02_JPRB,&
&.692E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.596E-02_JPRB,.596E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.656E-02_JPRB,.656E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,&
&.884E-02_JPRB,.884E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.911E-02_JPRB,&
&.911E-02_JPRB,.891E-02_JPRB,.891E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,&
&.710E-02_JPRB,.710E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,&
&.783E-02_JPRB,.783E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.786E-02_JPRB,&
&.786E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,&
&.655E-02_JPRB,.655E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 13  42.0
ZAER (:,13,12) = (/&
&.702E-02_JPRB,.702E-02_JPRB,.735E-02_JPRB,.735E-02_JPRB,.717E-02_JPRB,.717E-02_JPRB,.692E-02_JPRB,&
&.692E-02_JPRB,.615E-02_JPRB,.615E-02_JPRB,.596E-02_JPRB,.596E-02_JPRB,.586E-02_JPRB,.586E-02_JPRB,&
&.604E-02_JPRB,.604E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.656E-02_JPRB,.656E-02_JPRB,.541E-02_JPRB,&
&.541E-02_JPRB,.310E-02_JPRB,.310E-02_JPRB,.597E-02_JPRB,.597E-02_JPRB,.830E-02_JPRB,.830E-02_JPRB,&
&.884E-02_JPRB,.884E-02_JPRB,.900E-02_JPRB,.900E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.911E-02_JPRB,&
&.911E-02_JPRB,.891E-02_JPRB,.891E-02_JPRB,.799E-02_JPRB,.799E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,&
&.710E-02_JPRB,.710E-02_JPRB,.770E-02_JPRB,.770E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.932E-02_JPRB,.932E-02_JPRB,.884E-02_JPRB,.884E-02_JPRB,.841E-02_JPRB,.841E-02_JPRB,&
&.783E-02_JPRB,.783E-02_JPRB,.769E-02_JPRB,.769E-02_JPRB,.755E-02_JPRB,.755E-02_JPRB,.786E-02_JPRB,&
&.786E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.813E-02_JPRB,.813E-02_JPRB,.867E-02_JPRB,.867E-02_JPRB,&
&.655E-02_JPRB,.655E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 14  38.0
ZAER (:,14,12) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.699E-02_JPRB,&
&.699E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,.620E-02_JPRB,.620E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,&
&.785E-02_JPRB,.785E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,&
&.694E-02_JPRB,.694E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.764E-02_JPRB,&
&.764E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.699E-02_JPRB,.699E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,&
&.660E-02_JPRB,.660E-02_JPRB,.614E-02_JPRB,.614E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.501E-02_JPRB,.501E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,&
&.569E-02_JPRB,.569E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 15  34.0
ZAER (:,15,12) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.721E-02_JPRB,.721E-02_JPRB,.715E-02_JPRB,.715E-02_JPRB,.699E-02_JPRB,&
&.699E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.607E-02_JPRB,.607E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,&
&.650E-02_JPRB,.650E-02_JPRB,.648E-02_JPRB,.648E-02_JPRB,.620E-02_JPRB,.620E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.203E-02_JPRB,.203E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,&
&.785E-02_JPRB,.785E-02_JPRB,.773E-02_JPRB,.773E-02_JPRB,.804E-02_JPRB,.804E-02_JPRB,.767E-02_JPRB,&
&.767E-02_JPRB,.710E-02_JPRB,.710E-02_JPRB,.688E-02_JPRB,.688E-02_JPRB,.584E-02_JPRB,.584E-02_JPRB,&
&.694E-02_JPRB,.694E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.761E-02_JPRB,.761E-02_JPRB,.764E-02_JPRB,&
&.764E-02_JPRB,.756E-02_JPRB,.756E-02_JPRB,.699E-02_JPRB,.699E-02_JPRB,.665E-02_JPRB,.665E-02_JPRB,&
&.660E-02_JPRB,.660E-02_JPRB,.614E-02_JPRB,.614E-02_JPRB,.509E-02_JPRB,.509E-02_JPRB,.521E-02_JPRB,&
&.521E-02_JPRB,.328E-02_JPRB,.328E-02_JPRB,.501E-02_JPRB,.501E-02_JPRB,.642E-02_JPRB,.642E-02_JPRB,&
&.569E-02_JPRB,.569E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 16  30.0
ZAER (:,16,12) = (/&
&.826E-02_JPRB,.826E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.736E-02_JPRB,&
&.736E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,&
&.908E-02_JPRB,.908E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.647E-02_JPRB,&
&.647E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,&
&.679E-02_JPRB,.679E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.713E-02_JPRB,&
&.713E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,&
&.411E-02_JPRB,.411E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.833E-02_JPRB,&
&.833E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,&
&.774E-02_JPRB,.774E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.258E-02_JPRB,&
&.258E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.639E-02_JPRB,.639E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 17  26.0
ZAER (:,17,12) = (/&
&.826E-02_JPRB,.826E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.855E-02_JPRB,.736E-02_JPRB,&
&.736E-02_JPRB,.683E-02_JPRB,.683E-02_JPRB,.784E-02_JPRB,.784E-02_JPRB,.893E-02_JPRB,.893E-02_JPRB,&
&.908E-02_JPRB,.908E-02_JPRB,.843E-02_JPRB,.843E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.647E-02_JPRB,&
&.647E-02_JPRB,.337E-02_JPRB,.337E-02_JPRB,.236E-02_JPRB,.236E-02_JPRB,.429E-02_JPRB,.429E-02_JPRB,&
&.679E-02_JPRB,.679E-02_JPRB,.744E-02_JPRB,.744E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.713E-02_JPRB,&
&.713E-02_JPRB,.661E-02_JPRB,.661E-02_JPRB,.565E-02_JPRB,.565E-02_JPRB,.251E-02_JPRB,.251E-02_JPRB,&
&.411E-02_JPRB,.411E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.749E-02_JPRB,.749E-02_JPRB,.833E-02_JPRB,&
&.833E-02_JPRB,.839E-02_JPRB,.839E-02_JPRB,.796E-02_JPRB,.796E-02_JPRB,.757E-02_JPRB,.757E-02_JPRB,&
&.774E-02_JPRB,.774E-02_JPRB,.625E-02_JPRB,.625E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.258E-02_JPRB,&
&.258E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.399E-02_JPRB,.399E-02_JPRB,.639E-02_JPRB,.639E-02_JPRB,&
&.705E-02_JPRB,.705E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 18  22.0
ZAER (:,18,12) = (/&
&.973E-02_JPRB,.973E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.806E-02_JPRB,&
&.806E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.544E-02_JPRB,&
&.544E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.938E-03_JPRB,.938E-03_JPRB,.859E-03_JPRB,.859E-03_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.652E-02_JPRB,&
&.652E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.169E-02_JPRB,.169E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.851E-02_JPRB,.851E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,.309E-02_JPRB,&
&.309E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.812E-02_JPRB,.812E-02_JPRB,&
&.969E-02_JPRB,.969E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 19  18.0
ZAER (:,19,12) = (/&
&.973E-02_JPRB,.973E-02_JPRB,.923E-02_JPRB,.923E-02_JPRB,.859E-02_JPRB,.859E-02_JPRB,.806E-02_JPRB,&
&.806E-02_JPRB,.816E-02_JPRB,.816E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.108E-01_JPRB,.108E-01_JPRB,.899E-02_JPRB,.899E-02_JPRB,.732E-02_JPRB,.732E-02_JPRB,.544E-02_JPRB,&
&.544E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.938E-03_JPRB,.938E-03_JPRB,.859E-03_JPRB,.859E-03_JPRB,&
&.478E-02_JPRB,.478E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.652E-02_JPRB,&
&.652E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.396E-02_JPRB,.396E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.169E-02_JPRB,.169E-02_JPRB,.344E-02_JPRB,.344E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.775E-02_JPRB,&
&.775E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.998E-02_JPRB,.998E-02_JPRB,.104E-01_JPRB,.104E-01_JPRB,&
&.101E-01_JPRB,.101E-01_JPRB,.851E-02_JPRB,.851E-02_JPRB,.460E-02_JPRB,.460E-02_JPRB,.309E-02_JPRB,&
&.309E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.768E-02_JPRB,.768E-02_JPRB,.812E-02_JPRB,.812E-02_JPRB,&
&.969E-02_JPRB,.969E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 20  14.0
ZAER (:,20,12) = (/&
&.802E-02_JPRB,.802E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.978E-02_JPRB,.978E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.254E-02_JPRB,&
&.254E-02_JPRB,.400E-03_JPRB,.400E-03_JPRB,.316E-03_JPRB,.316E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.525E-02_JPRB,.525E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.834E-02_JPRB,.834E-02_JPRB,.580E-02_JPRB,&
&.580E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.596E-03_JPRB,.596E-03_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,.841E-02_JPRB,&
&.841E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.940E-02_JPRB,.940E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.876E-02_JPRB,.876E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.780E-02_JPRB,.780E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 21  10.0
ZAER (:,21,12) = (/&
&.802E-02_JPRB,.802E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.823E-02_JPRB,.823E-02_JPRB,.101E-01_JPRB,&
&.101E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.131E-01_JPRB,.131E-01_JPRB,&
&.978E-02_JPRB,.978E-02_JPRB,.693E-02_JPRB,.693E-02_JPRB,.463E-02_JPRB,.463E-02_JPRB,.254E-02_JPRB,&
&.254E-02_JPRB,.400E-03_JPRB,.400E-03_JPRB,.316E-03_JPRB,.316E-03_JPRB,.133E-02_JPRB,.133E-02_JPRB,&
&.525E-02_JPRB,.525E-02_JPRB,.901E-02_JPRB,.901E-02_JPRB,.834E-02_JPRB,.834E-02_JPRB,.580E-02_JPRB,&
&.580E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,.197E-02_JPRB,.197E-02_JPRB,.596E-03_JPRB,.596E-03_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB,.539E-02_JPRB,.539E-02_JPRB,.671E-02_JPRB,.671E-02_JPRB,.841E-02_JPRB,&
&.841E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,.940E-02_JPRB,.940E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.105E-01_JPRB,.105E-01_JPRB,.876E-02_JPRB,.876E-02_JPRB,.641E-02_JPRB,.641E-02_JPRB,.440E-02_JPRB,&
&.440E-02_JPRB,.622E-02_JPRB,.622E-02_JPRB,.807E-02_JPRB,.807E-02_JPRB,.713E-02_JPRB,.713E-02_JPRB,&
&.780E-02_JPRB,.780E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 22   6.0
ZAER (:,22,12) = (/&
&.822E-02_JPRB,.822E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.127E-01_JPRB,.127E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.771E-02_JPRB,.771E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.392E-03_JPRB,.392E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.869E-02_JPRB,.869E-02_JPRB,.578E-02_JPRB,&
&.578E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.387E-02_JPRB,.387E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.745E-02_JPRB,.745E-02_JPRB,.730E-02_JPRB,&
&.730E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.518E-02_JPRB,.518E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,&
&.459E-02_JPRB,.459E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.459E-02_JPRB,&
&.459E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 23   2.0
ZAER (:,23,12) = (/&
&.822E-02_JPRB,.822E-02_JPRB,.991E-02_JPRB,.991E-02_JPRB,.127E-01_JPRB,.127E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,&
&.771E-02_JPRB,.771E-02_JPRB,.556E-02_JPRB,.556E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.392E-03_JPRB,.392E-03_JPRB,.109E-02_JPRB,.109E-02_JPRB,.341E-02_JPRB,.341E-02_JPRB,&
&.827E-02_JPRB,.827E-02_JPRB,.110E-01_JPRB,.110E-01_JPRB,.869E-02_JPRB,.869E-02_JPRB,.578E-02_JPRB,&
&.578E-02_JPRB,.374E-02_JPRB,.374E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.387E-02_JPRB,.387E-02_JPRB,.765E-02_JPRB,.765E-02_JPRB,.745E-02_JPRB,.745E-02_JPRB,.730E-02_JPRB,&
&.730E-02_JPRB,.725E-02_JPRB,.725E-02_JPRB,.518E-02_JPRB,.518E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,&
&.459E-02_JPRB,.459E-02_JPRB,.498E-02_JPRB,.498E-02_JPRB,.530E-02_JPRB,.530E-02_JPRB,.459E-02_JPRB,&
&.459E-02_JPRB,.481E-02_JPRB,.481E-02_JPRB,.601E-02_JPRB,.601E-02_JPRB,.651E-02_JPRB,.651E-02_JPRB,&
&.736E-02_JPRB,.736E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 24  -2.0
ZAER (:,24,12) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.151E-01_JPRB,&
&.151E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.923E-02_JPRB,.923E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.375E-02_JPRB,&
&.375E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,.512E-02_JPRB,.512E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.856E-02_JPRB,.856E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,&
&.487E-02_JPRB,.487E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.966E-02_JPRB,&
&.966E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.679E-02_JPRB,.679E-02_JPRB,.701E-02_JPRB,.701E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.952E-02_JPRB,.952E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 25  -6.0
ZAER (:,25,12) = (/&
&.128E-01_JPRB,.128E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.152E-01_JPRB,.152E-01_JPRB,.151E-01_JPRB,&
&.151E-01_JPRB,.144E-01_JPRB,.144E-01_JPRB,.129E-01_JPRB,.129E-01_JPRB,.108E-01_JPRB,.108E-01_JPRB,&
&.923E-02_JPRB,.923E-02_JPRB,.750E-02_JPRB,.750E-02_JPRB,.676E-02_JPRB,.676E-02_JPRB,.375E-02_JPRB,&
&.375E-02_JPRB,.299E-02_JPRB,.299E-02_JPRB,.512E-02_JPRB,.512E-02_JPRB,.977E-02_JPRB,.977E-02_JPRB,&
&.125E-01_JPRB,.125E-01_JPRB,.119E-01_JPRB,.119E-01_JPRB,.856E-02_JPRB,.856E-02_JPRB,.512E-02_JPRB,&
&.512E-02_JPRB,.317E-02_JPRB,.317E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,&
&.487E-02_JPRB,.487E-02_JPRB,.785E-02_JPRB,.785E-02_JPRB,.106E-01_JPRB,.106E-01_JPRB,.966E-02_JPRB,&
&.966E-02_JPRB,.780E-02_JPRB,.780E-02_JPRB,.679E-02_JPRB,.679E-02_JPRB,.701E-02_JPRB,.701E-02_JPRB,&
&.724E-02_JPRB,.724E-02_JPRB,.863E-02_JPRB,.863E-02_JPRB,.967E-02_JPRB,.967E-02_JPRB,.100E-01_JPRB,&
&.100E-01_JPRB,.952E-02_JPRB,.952E-02_JPRB,.936E-02_JPRB,.936E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.112E-01_JPRB,.112E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 26 -10.0
ZAER (:,26,12) = (/&
&.151E-01_JPRB,.151E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.166E-01_JPRB,.166E-01_JPRB,.155E-01_JPRB,&
&.155E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.805E-02_JPRB,.805E-02_JPRB,.991E-02_JPRB,&
&.991E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.165E-01_JPRB,.165E-01_JPRB,&
&.165E-01_JPRB,.165E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.896E-02_JPRB,.896E-02_JPRB,.474E-02_JPRB,&
&.474E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,&
&.375E-02_JPRB,.375E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.907E-02_JPRB,.907E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.938E-02_JPRB,.938E-02_JPRB,&
&.941E-02_JPRB,.941E-02_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.143E-01_JPRB,.143E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 27 -14.0
ZAER (:,27,12) = (/&
&.151E-01_JPRB,.151E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.166E-01_JPRB,.166E-01_JPRB,.155E-01_JPRB,&
&.155E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.133E-01_JPRB,.133E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,&
&.119E-01_JPRB,.119E-01_JPRB,.104E-01_JPRB,.104E-01_JPRB,.805E-02_JPRB,.805E-02_JPRB,.991E-02_JPRB,&
&.991E-02_JPRB,.103E-01_JPRB,.103E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.165E-01_JPRB,.165E-01_JPRB,&
&.165E-01_JPRB,.165E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.896E-02_JPRB,.896E-02_JPRB,.474E-02_JPRB,&
&.474E-02_JPRB,.305E-02_JPRB,.305E-02_JPRB,.238E-02_JPRB,.238E-02_JPRB,.281E-02_JPRB,.281E-02_JPRB,&
&.375E-02_JPRB,.375E-02_JPRB,.646E-02_JPRB,.646E-02_JPRB,.111E-01_JPRB,.111E-01_JPRB,.115E-01_JPRB,&
&.115E-01_JPRB,.907E-02_JPRB,.907E-02_JPRB,.955E-02_JPRB,.955E-02_JPRB,.938E-02_JPRB,.938E-02_JPRB,&
&.941E-02_JPRB,.941E-02_JPRB,.133E-01_JPRB,.133E-01_JPRB,.122E-01_JPRB,.122E-01_JPRB,.140E-01_JPRB,&
&.140E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,&
&.143E-01_JPRB,.143E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 28 -18.0
ZAER (:,28,12) = (/&
&.134E-01_JPRB,.134E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.981E-02_JPRB,.981E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,&
&.153E-01_JPRB,.153E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.927E-02_JPRB,.927E-02_JPRB,.614E-02_JPRB,&
&.614E-02_JPRB,.523E-02_JPRB,.523E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,&
&.340E-02_JPRB,.340E-02_JPRB,.362E-02_JPRB,.362E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.739E-02_JPRB,&
&.739E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.619E-02_JPRB,.619E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.182E-01_JPRB,&
&.182E-01_JPRB,.185E-01_JPRB,.185E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 29 -22.0
ZAER (:,29,12) = (/&
&.134E-01_JPRB,.134E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.142E-01_JPRB,&
&.142E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,&
&.981E-02_JPRB,.981E-02_JPRB,.921E-02_JPRB,.921E-02_JPRB,.924E-02_JPRB,.924E-02_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.123E-01_JPRB,.123E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.151E-01_JPRB,.151E-01_JPRB,&
&.153E-01_JPRB,.153E-01_JPRB,.138E-01_JPRB,.138E-01_JPRB,.927E-02_JPRB,.927E-02_JPRB,.614E-02_JPRB,&
&.614E-02_JPRB,.523E-02_JPRB,.523E-02_JPRB,.450E-02_JPRB,.450E-02_JPRB,.375E-02_JPRB,.375E-02_JPRB,&
&.340E-02_JPRB,.340E-02_JPRB,.362E-02_JPRB,.362E-02_JPRB,.488E-02_JPRB,.488E-02_JPRB,.739E-02_JPRB,&
&.739E-02_JPRB,.568E-02_JPRB,.568E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.619E-02_JPRB,.619E-02_JPRB,.116E-01_JPRB,.116E-01_JPRB,.156E-01_JPRB,.156E-01_JPRB,.182E-01_JPRB,&
&.182E-01_JPRB,.185E-01_JPRB,.185E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 30 -26.0
ZAER (:,30,12) = (/&
&.126E-01_JPRB,.126E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.983E-02_JPRB,.983E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,&
&.543E-02_JPRB,.543E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.587E-02_JPRB,&
&.587E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.452E-02_JPRB,.452E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,&
&.382E-02_JPRB,.382E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.302E-02_JPRB,&
&.302E-02_JPRB,.289E-02_JPRB,.289E-02_JPRB,.256E-02_JPRB,.256E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 31 -30.0
ZAER (:,31,12) = (/&
&.126E-01_JPRB,.126E-01_JPRB,.124E-01_JPRB,.124E-01_JPRB,.128E-01_JPRB,.128E-01_JPRB,.127E-01_JPRB,&
&.127E-01_JPRB,.115E-01_JPRB,.115E-01_JPRB,.983E-02_JPRB,.983E-02_JPRB,.734E-02_JPRB,.734E-02_JPRB,&
&.543E-02_JPRB,.543E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,.737E-02_JPRB,.737E-02_JPRB,.913E-02_JPRB,&
&.913E-02_JPRB,.113E-01_JPRB,.113E-01_JPRB,.125E-01_JPRB,.125E-01_JPRB,.137E-01_JPRB,.137E-01_JPRB,&
&.140E-01_JPRB,.140E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.587E-02_JPRB,&
&.587E-02_JPRB,.466E-02_JPRB,.466E-02_JPRB,.452E-02_JPRB,.452E-02_JPRB,.448E-02_JPRB,.448E-02_JPRB,&
&.382E-02_JPRB,.382E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,.302E-02_JPRB,&
&.302E-02_JPRB,.289E-02_JPRB,.289E-02_JPRB,.256E-02_JPRB,.256E-02_JPRB,.207E-02_JPRB,.207E-02_JPRB,&
&.223E-02_JPRB,.223E-02_JPRB,.407E-02_JPRB,.407E-02_JPRB,.829E-02_JPRB,.829E-02_JPRB,.126E-01_JPRB,&
&.126E-01_JPRB,.142E-01_JPRB,.142E-01_JPRB,.148E-01_JPRB,.148E-01_JPRB,.147E-01_JPRB,.147E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 32 -34.0
ZAER (:,32,12) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.976E-02_JPRB,.976E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,&
&.365E-02_JPRB,.365E-02_JPRB,.330E-02_JPRB,.330E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.670E-02_JPRB,&
&.670E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.207E-02_JPRB,&
&.207E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.905E-03_JPRB,.905E-03_JPRB,.933E-03_JPRB,.933E-03_JPRB,.289E-02_JPRB,.289E-02_JPRB,.492E-02_JPRB,&
&.492E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.152E-01_JPRB,.152E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 33 -38.0
ZAER (:,33,12) = (/&
&.130E-01_JPRB,.130E-01_JPRB,.118E-01_JPRB,.118E-01_JPRB,.112E-01_JPRB,.112E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.105E-01_JPRB,.105E-01_JPRB,.976E-02_JPRB,.976E-02_JPRB,.540E-02_JPRB,.540E-02_JPRB,&
&.365E-02_JPRB,.365E-02_JPRB,.330E-02_JPRB,.330E-02_JPRB,.300E-02_JPRB,.300E-02_JPRB,.430E-02_JPRB,&
&.430E-02_JPRB,.969E-02_JPRB,.969E-02_JPRB,.117E-01_JPRB,.117E-01_JPRB,.130E-01_JPRB,.130E-01_JPRB,&
&.127E-01_JPRB,.127E-01_JPRB,.120E-01_JPRB,.120E-01_JPRB,.107E-01_JPRB,.107E-01_JPRB,.670E-02_JPRB,&
&.670E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,.552E-02_JPRB,.552E-02_JPRB,.588E-02_JPRB,.588E-02_JPRB,&
&.404E-02_JPRB,.404E-02_JPRB,.259E-02_JPRB,.259E-02_JPRB,.260E-02_JPRB,.260E-02_JPRB,.207E-02_JPRB,&
&.207E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.147E-02_JPRB,.147E-02_JPRB,.116E-02_JPRB,.116E-02_JPRB,&
&.905E-03_JPRB,.905E-03_JPRB,.933E-03_JPRB,.933E-03_JPRB,.289E-02_JPRB,.289E-02_JPRB,.492E-02_JPRB,&
&.492E-02_JPRB,.766E-02_JPRB,.766E-02_JPRB,.119E-01_JPRB,.119E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,&
&.152E-01_JPRB,.152E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 34 -42.0
ZAER (:,34,12) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.980E-02_JPRB,.980E-02_JPRB,.569E-02_JPRB,.569E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.170E-02_JPRB,&
&.170E-02_JPRB,.403E-02_JPRB,.403E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.549E-02_JPRB,.549E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.345E-02_JPRB,.345E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.222E-02_JPRB,.222E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.773E-03_JPRB,.773E-03_JPRB,.739E-03_JPRB,.739E-03_JPRB,.181E-02_JPRB,&
&.181E-02_JPRB,.325E-02_JPRB,.325E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.151E-01_JPRB,.151E-01_JPRB,&
&.164E-01_JPRB,.164E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 35 -46.0
ZAER (:,35,12) = (/&
&.132E-01_JPRB,.132E-01_JPRB,.113E-01_JPRB,.113E-01_JPRB,.114E-01_JPRB,.114E-01_JPRB,.108E-01_JPRB,&
&.108E-01_JPRB,.106E-01_JPRB,.106E-01_JPRB,.980E-02_JPRB,.980E-02_JPRB,.569E-02_JPRB,.569E-02_JPRB,&
&.367E-02_JPRB,.367E-02_JPRB,.296E-02_JPRB,.296E-02_JPRB,.232E-02_JPRB,.232E-02_JPRB,.170E-02_JPRB,&
&.170E-02_JPRB,.403E-02_JPRB,.403E-02_JPRB,.752E-02_JPRB,.752E-02_JPRB,.972E-02_JPRB,.972E-02_JPRB,&
&.133E-01_JPRB,.133E-01_JPRB,.139E-01_JPRB,.139E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,.102E-01_JPRB,&
&.102E-01_JPRB,.549E-02_JPRB,.549E-02_JPRB,.406E-02_JPRB,.406E-02_JPRB,.326E-02_JPRB,.326E-02_JPRB,&
&.345E-02_JPRB,.345E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.222E-02_JPRB,.222E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.114E-02_JPRB,.114E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.773E-03_JPRB,.773E-03_JPRB,.739E-03_JPRB,.739E-03_JPRB,.181E-02_JPRB,&
&.181E-02_JPRB,.325E-02_JPRB,.325E-02_JPRB,.777E-02_JPRB,.777E-02_JPRB,.151E-01_JPRB,.151E-01_JPRB,&
&.164E-01_JPRB,.164E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 36 -50.0
ZAER (:,36,12) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.971E-02_JPRB,.971E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.967E-02_JPRB,&
&.967E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,&
&.247E-02_JPRB,.247E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.148E-01_JPRB,.148E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.732E-02_JPRB,.732E-02_JPRB,.461E-02_JPRB,.461E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,&
&.224E-02_JPRB,.224E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.132E-02_JPRB,&
&.132E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.965E-03_JPRB,.965E-03_JPRB,&
&.882E-03_JPRB,.882E-03_JPRB,.745E-03_JPRB,.745E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,.656E-03_JPRB,&
&.656E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 37 -54.0
ZAER (:,37,12) = (/&
&.110E-01_JPRB,.110E-01_JPRB,.971E-02_JPRB,.971E-02_JPRB,.897E-02_JPRB,.897E-02_JPRB,.967E-02_JPRB,&
&.967E-02_JPRB,.939E-02_JPRB,.939E-02_JPRB,.574E-02_JPRB,.574E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,&
&.247E-02_JPRB,.247E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.143E-02_JPRB,&
&.143E-02_JPRB,.146E-02_JPRB,.146E-02_JPRB,.356E-02_JPRB,.356E-02_JPRB,.100E-01_JPRB,.100E-01_JPRB,&
&.148E-01_JPRB,.148E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,.120E-01_JPRB,&
&.120E-01_JPRB,.732E-02_JPRB,.732E-02_JPRB,.461E-02_JPRB,.461E-02_JPRB,.311E-02_JPRB,.311E-02_JPRB,&
&.224E-02_JPRB,.224E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.132E-02_JPRB,&
&.132E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.965E-03_JPRB,.965E-03_JPRB,&
&.882E-03_JPRB,.882E-03_JPRB,.745E-03_JPRB,.745E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,.656E-03_JPRB,&
&.656E-03_JPRB,.103E-02_JPRB,.103E-02_JPRB,.322E-02_JPRB,.322E-02_JPRB,.102E-01_JPRB,.102E-01_JPRB,&
&.134E-01_JPRB,.134E-01_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 38 -58.0
ZAER (:,38,12) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.355E-02_JPRB,&
&.355E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.206E-02_JPRB,&
&.206E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.161E-01_JPRB,.161E-01_JPRB,.148E-01_JPRB,&
&.148E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.817E-02_JPRB,.817E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.294E-02_JPRB,.294E-02_JPRB,.219E-02_JPRB,.219E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.154E-02_JPRB,&
&.154E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,&
&.829E-03_JPRB,.829E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,.814E-03_JPRB,&
&.814E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,&
&.860E-02_JPRB,.860E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 39 -62.0
ZAER (:,39,12) = (/&
&.626E-02_JPRB,.626E-02_JPRB,.436E-02_JPRB,.436E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.355E-02_JPRB,&
&.355E-02_JPRB,.216E-02_JPRB,.216E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.135E-02_JPRB,.354E-02_JPRB,.354E-02_JPRB,.206E-02_JPRB,&
&.206E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.643E-02_JPRB,.643E-02_JPRB,.905E-02_JPRB,.905E-02_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.161E-01_JPRB,.161E-01_JPRB,.148E-01_JPRB,&
&.148E-01_JPRB,.143E-01_JPRB,.143E-01_JPRB,.817E-02_JPRB,.817E-02_JPRB,.513E-02_JPRB,.513E-02_JPRB,&
&.294E-02_JPRB,.294E-02_JPRB,.219E-02_JPRB,.219E-02_JPRB,.182E-02_JPRB,.182E-02_JPRB,.154E-02_JPRB,&
&.154E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.111E-02_JPRB,.111E-02_JPRB,.952E-03_JPRB,.952E-03_JPRB,&
&.829E-03_JPRB,.829E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,.638E-03_JPRB,.638E-03_JPRB,.814E-03_JPRB,&
&.814E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.507E-02_JPRB,.507E-02_JPRB,&
&.860E-02_JPRB,.860E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 40 -66.0
ZAER (:,40,12) = (/&
&.306E-02_JPRB,.306E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.117E-02_JPRB,&
&.117E-02_JPRB,.727E-03_JPRB,.727E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.900E-03_JPRB,.900E-03_JPRB,.185E-02_JPRB,.185E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.518E-02_JPRB,.518E-02_JPRB,&
&.409E-02_JPRB,.409E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.858E-03_JPRB,.858E-03_JPRB,&
&.738E-03_JPRB,.738E-03_JPRB,.647E-03_JPRB,.647E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.119E-02_JPRB,.119E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,&
&.324E-02_JPRB,.324E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 41 -70.0
ZAER (:,41,12) = (/&
&.306E-02_JPRB,.306E-02_JPRB,.329E-02_JPRB,.329E-02_JPRB,.189E-02_JPRB,.189E-02_JPRB,.117E-02_JPRB,&
&.117E-02_JPRB,.727E-03_JPRB,.727E-03_JPRB,.810E-03_JPRB,.810E-03_JPRB,.114E-02_JPRB,.114E-02_JPRB,&
&.113E-02_JPRB,.113E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,.114E-02_JPRB,&
&.114E-02_JPRB,.900E-03_JPRB,.900E-03_JPRB,.185E-02_JPRB,.185E-02_JPRB,.224E-02_JPRB,.224E-02_JPRB,&
&.327E-02_JPRB,.327E-02_JPRB,.571E-02_JPRB,.571E-02_JPRB,.609E-02_JPRB,.609E-02_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,.117E-01_JPRB,.117E-01_JPRB,.518E-02_JPRB,.518E-02_JPRB,&
&.409E-02_JPRB,.409E-02_JPRB,.476E-02_JPRB,.476E-02_JPRB,.364E-02_JPRB,.364E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.105E-02_JPRB,.105E-02_JPRB,.858E-03_JPRB,.858E-03_JPRB,&
&.738E-03_JPRB,.738E-03_JPRB,.647E-03_JPRB,.647E-03_JPRB,.707E-03_JPRB,.707E-03_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.119E-02_JPRB,.119E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.266E-02_JPRB,.266E-02_JPRB,&
&.324E-02_JPRB,.324E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 42 -74.0
ZAER (:,42,12) = (/&
&.149E-02_JPRB,.149E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.717E-03_JPRB,.717E-03_JPRB,.732E-03_JPRB,.732E-03_JPRB,.894E-03_JPRB,.894E-03_JPRB,&
&.959E-03_JPRB,.959E-03_JPRB,.999E-03_JPRB,.999E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.910E-03_JPRB,&
&.910E-03_JPRB,.804E-03_JPRB,.804E-03_JPRB,.803E-03_JPRB,.803E-03_JPRB,.870E-03_JPRB,.870E-03_JPRB,&
&.845E-03_JPRB,.845E-03_JPRB,.828E-03_JPRB,.828E-03_JPRB,.915E-03_JPRB,.915E-03_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.695E-02_JPRB,.695E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,&
&.590E-02_JPRB,.590E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.843E-03_JPRB,.843E-03_JPRB,.676E-03_JPRB,.676E-03_JPRB,&
&.610E-03_JPRB,.610E-03_JPRB,.592E-03_JPRB,.592E-03_JPRB,.657E-03_JPRB,.657E-03_JPRB,.825E-03_JPRB,&
&.825E-03_JPRB,.858E-03_JPRB,.858E-03_JPRB,.958E-03_JPRB,.958E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.146E-02_JPRB,.146E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 43 -78.0
ZAER (:,43,12) = (/&
&.149E-02_JPRB,.149E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.862E-03_JPRB,&
&.862E-03_JPRB,.717E-03_JPRB,.717E-03_JPRB,.732E-03_JPRB,.732E-03_JPRB,.894E-03_JPRB,.894E-03_JPRB,&
&.959E-03_JPRB,.959E-03_JPRB,.999E-03_JPRB,.999E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.910E-03_JPRB,&
&.910E-03_JPRB,.804E-03_JPRB,.804E-03_JPRB,.803E-03_JPRB,.803E-03_JPRB,.870E-03_JPRB,.870E-03_JPRB,&
&.845E-03_JPRB,.845E-03_JPRB,.828E-03_JPRB,.828E-03_JPRB,.915E-03_JPRB,.915E-03_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.695E-02_JPRB,.695E-02_JPRB,.811E-02_JPRB,.811E-02_JPRB,.692E-02_JPRB,.692E-02_JPRB,&
&.590E-02_JPRB,.590E-02_JPRB,.319E-02_JPRB,.319E-02_JPRB,.138E-02_JPRB,.138E-02_JPRB,.120E-02_JPRB,&
&.120E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.843E-03_JPRB,.843E-03_JPRB,.676E-03_JPRB,.676E-03_JPRB,&
&.610E-03_JPRB,.610E-03_JPRB,.592E-03_JPRB,.592E-03_JPRB,.657E-03_JPRB,.657E-03_JPRB,.825E-03_JPRB,&
&.825E-03_JPRB,.858E-03_JPRB,.858E-03_JPRB,.958E-03_JPRB,.958E-03_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.146E-02_JPRB,.146E-02_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 44 -82.0
ZAER (:,44,12) = (/&
&.714E-03_JPRB,.714E-03_JPRB,.740E-03_JPRB,.740E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.792E-03_JPRB,&
&.792E-03_JPRB,.812E-03_JPRB,.812E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,&
&.825E-03_JPRB,.825E-03_JPRB,.814E-03_JPRB,.814E-03_JPRB,.773E-03_JPRB,.773E-03_JPRB,.678E-03_JPRB,&
&.678E-03_JPRB,.631E-03_JPRB,.631E-03_JPRB,.632E-03_JPRB,.632E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,&
&.650E-03_JPRB,.650E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.652E-03_JPRB,&
&.652E-03_JPRB,.917E-03_JPRB,.917E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,&
&.623E-03_JPRB,.623E-03_JPRB,.547E-03_JPRB,.547E-03_JPRB,.533E-03_JPRB,.533E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,&
&.507E-03_JPRB,.507E-03_JPRB,.544E-03_JPRB,.544E-03_JPRB,.618E-03_JPRB,.618E-03_JPRB,.679E-03_JPRB,&
&.679E-03_JPRB,.686E-03_JPRB,.686E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,.725E-03_JPRB,.725E-03_JPRB,&
&.713E-03_JPRB,.713E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 45 -86.0
ZAER (:,45,12) = (/&
&.714E-03_JPRB,.714E-03_JPRB,.740E-03_JPRB,.740E-03_JPRB,.755E-03_JPRB,.755E-03_JPRB,.792E-03_JPRB,&
&.792E-03_JPRB,.812E-03_JPRB,.812E-03_JPRB,.825E-03_JPRB,.825E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,&
&.825E-03_JPRB,.825E-03_JPRB,.814E-03_JPRB,.814E-03_JPRB,.773E-03_JPRB,.773E-03_JPRB,.678E-03_JPRB,&
&.678E-03_JPRB,.631E-03_JPRB,.631E-03_JPRB,.632E-03_JPRB,.632E-03_JPRB,.660E-03_JPRB,.660E-03_JPRB,&
&.650E-03_JPRB,.650E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,.591E-03_JPRB,.591E-03_JPRB,.652E-03_JPRB,&
&.652E-03_JPRB,.917E-03_JPRB,.917E-03_JPRB,.122E-02_JPRB,.122E-02_JPRB,.839E-03_JPRB,.839E-03_JPRB,&
&.623E-03_JPRB,.623E-03_JPRB,.547E-03_JPRB,.547E-03_JPRB,.533E-03_JPRB,.533E-03_JPRB,.526E-03_JPRB,&
&.526E-03_JPRB,.512E-03_JPRB,.512E-03_JPRB,.499E-03_JPRB,.499E-03_JPRB,.497E-03_JPRB,.497E-03_JPRB,&
&.507E-03_JPRB,.507E-03_JPRB,.544E-03_JPRB,.544E-03_JPRB,.618E-03_JPRB,.618E-03_JPRB,.679E-03_JPRB,&
&.679E-03_JPRB,.686E-03_JPRB,.686E-03_JPRB,.696E-03_JPRB,.696E-03_JPRB,.725E-03_JPRB,.725E-03_JPRB,&
&.713E-03_JPRB,.713E-03_JPRB/)
!-- Sea Salt Aerosol         month: 12 --- lat: 46 -90.0
ZAER (:,46,12) = (/&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,.625E-03_JPRB,&
&.625E-03_JPRB,.625E-03_JPRB/)

!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
DO JM=1,12
  DO JI=1,46
    DO JL=1,72
      RAERSS(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO
ENDDO
!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SEA-SALT AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESS
