!OCL SCALAR
SUBROUTINE RRTM_KGB9_00

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 9:  1180-1390 cm-1 (low - H2O,CH4; high - CH4)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO9 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, ABSN2OO
USE YOERRTA9 , ONLY : N2OREF  ,H2OREF  ,CH4REF     ,ETAREF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
FRACREFBO( :) = (/&
!     From P = 0.071 mb.
    &0.20148601_JPRB,0.15252700_JPRB,0.13376500_JPRB,0.12184600_JPRB,&
    &0.10767800_JPRB,0.09307410_JPRB,0.07674570_JPRB,0.05876940_JPRB,&
    &0.04001480_JPRB,0.00424612_JPRB,0.00346896_JPRB,0.00269954_JPRB,&
    &0.00196864_JPRB,0.00122562_JPRB,0.00043628_JPRB,0.00004892_JPRB/)

N2OREF( :) = (/&
     &3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,&
     &3.19652E-07_JPRB,3.15324E-07_JPRB,3.03830E-07_JPRB,2.94221E-07_JPRB,2.84953E-07_JPRB,&
     &2.76714E-07_JPRB,2.64709E-07_JPRB,2.42847E-07_JPRB/)

H2OREF( :) = (/&
     &1.8759999E-02_JPRB, 1.2223309E-02_JPRB, 5.8908667E-03_JPRB, 2.7675382E-03_JPRB,  &
     &1.4065107E-03_JPRB, 7.5969833E-04_JPRB, 3.8875898E-04_JPRB, 1.6542293E-04_JPRB,  &
     &3.7189537E-05_JPRB, 7.4764857E-06_JPRB, 4.3081886E-06_JPRB, 3.3319423E-06_JPRB,  &
     &3.2039343E-06_JPRB/)

CH4REF( :) = (/&
     &1.7000001E-06_JPRB, 1.7000001E-06_JPRB, 1.6998713E-06_JPRB, 1.6904165E-06_JPRB,  &
     &1.6671424E-06_JPRB, 1.6350652E-06_JPRB, 1.6097551E-06_JPRB, 1.5590465E-06_JPRB,  &
     &1.5119849E-06_JPRB, 1.4741138E-06_JPRB, 1.4384609E-06_JPRB, 1.4002215E-06_JPRB,  &
     &1.3573376E-06_JPRB/)

ETAREF( :) = (/&
     &_ZERO_,0.125_JPRB,0.25_JPRB,0.375_JPRB,_HALF_,0.625_JPRB,0.75_JPRB,0.875_JPRB,0.96_JPRB,0.99_JPRB,_ONE_/)

ABSN2OO( :) = (/&
!     From P = 952.
     &3.26267E-01_JPRB,2.42869E-00_JPRB,1.15455E+01_JPRB,7.39478E-00_JPRB,&
     &5.16550E-00_JPRB,2.54474E-00_JPRB,3.53082E-00_JPRB,3.82278E-00_JPRB,&
     &1.81297E-00_JPRB,6.65313E-01_JPRB,1.23652E-01_JPRB,1.83895E-03_JPRB,&
     &1.70592E-03_JPRB,2.68434E-09_JPRB,_ZERO_,_ZERO_,&
!     From P = 620.
     &2.08632E-01_JPRB,1.11865E+00_JPRB,4.95975E+00_JPRB,8.10907E+00_JPRB,&
     &1.10408E+01_JPRB,5.45460E+00_JPRB,4.18611E+00_JPRB,3.53422E+00_JPRB,&
     &2.54164E+00_JPRB,3.65093E-01_JPRB,5.84480E-01_JPRB,2.26918E-01_JPRB,&
     &1.36230E-03_JPRB,5.54400E-10_JPRB,6.83703E-10_JPRB,_ZERO_,&
!     From P=313.
     &6.20022E-02_JPRB,2.69521E-01_JPRB,9.81928E-01_JPRB,1.65004E-00_JPRB,&
     &3.08089E-00_JPRB,5.38696E-00_JPRB,1.14600E+01_JPRB,2.41211E+01_JPRB,&
     &1.69655E+01_JPRB,1.37556E-00_JPRB,5.43254E-01_JPRB,3.52079E-01_JPRB,&
     &4.31888E-01_JPRB,4.82523E-06_JPRB,5.74747E-11_JPRB,_ZERO_/)

STRRAT = 21.6282_JPRB

!     ------------------------------------------------------------------

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&2.83413E-02_JPRB, 2.51443E-02_JPRB, 2.23078E-02_JPRB, 1.97914E-02_JPRB, 1.75588E-02_JPRB,&
&1.55780E-02_JPRB, 1.38207E-02_JPRB, 1.22617E-02_JPRB, 1.08785E-02_JPRB, 9.65132E-03_JPRB/)
SELFREFO( :, 2) = (/&
&3.01506E-02_JPRB, 2.69506E-02_JPRB, 2.40901E-02_JPRB, 2.15333E-02_JPRB, 1.92478E-02_JPRB,&
&1.72049E-02_JPRB, 1.53789E-02_JPRB, 1.37466E-02_JPRB, 1.22876E-02_JPRB, 1.09834E-02_JPRB/)
SELFREFO( :, 3) = (/&
&4.24899E-02_JPRB, 3.77138E-02_JPRB, 3.34745E-02_JPRB, 2.97118E-02_JPRB, 2.63720E-02_JPRB,&
&2.34077E-02_JPRB, 2.07765E-02_JPRB, 1.84411E-02_JPRB, 1.63682E-02_JPRB, 1.45283E-02_JPRB/)
SELFREFO( :, 4) = (/&
&5.78648E-02_JPRB, 5.16988E-02_JPRB, 4.61899E-02_JPRB, 4.12679E-02_JPRB, 3.68705E-02_JPRB,&
&3.29416E-02_JPRB, 2.94314E-02_JPRB, 2.62952E-02_JPRB, 2.34932E-02_JPRB, 2.09898E-02_JPRB/)
SELFREFO( :, 5) = (/&
&6.96367E-02_JPRB, 6.36716E-02_JPRB, 5.82175E-02_JPRB, 5.32306E-02_JPRB, 4.86709E-02_JPRB,&
&4.45018E-02_JPRB, 4.06898E-02_JPRB, 3.72043E-02_JPRB, 3.40174E-02_JPRB, 3.11034E-02_JPRB/)
SELFREFO( :, 6) = (/&
&6.04073E-02_JPRB, 5.90856E-02_JPRB, 5.77929E-02_JPRB, 5.65284E-02_JPRB, 5.52916E-02_JPRB,&
&5.40819E-02_JPRB, 5.28986E-02_JPRB, 5.17413E-02_JPRB, 5.06092E-02_JPRB, 4.95020E-02_JPRB/)
SELFREFO( :, 7) = (/&
&6.19460E-02_JPRB, 6.02812E-02_JPRB, 5.86612E-02_JPRB, 5.70847E-02_JPRB, 5.55506E-02_JPRB,&
&5.40577E-02_JPRB, 5.26049E-02_JPRB, 5.11912E-02_JPRB, 4.98155E-02_JPRB, 4.84767E-02_JPRB/)
SELFREFO( :, 8) = (/&
&6.86939E-02_JPRB, 6.58429E-02_JPRB, 6.31102E-02_JPRB, 6.04909E-02_JPRB, 5.79804E-02_JPRB,&
&5.55740E-02_JPRB, 5.32675E-02_JPRB, 5.10567E-02_JPRB, 4.89377E-02_JPRB, 4.69067E-02_JPRB/)
SELFREFO( :, 9) = (/&
&8.18828E-02_JPRB, 7.77172E-02_JPRB, 7.37635E-02_JPRB, 7.00110E-02_JPRB, 6.64494E-02_JPRB,&
&6.30689E-02_JPRB, 5.98604E-02_JPRB, 5.68152E-02_JPRB, 5.39248E-02_JPRB, 5.11815E-02_JPRB/)
SELFREFO( :,10) = (/&
&8.41953E-02_JPRB, 8.10610E-02_JPRB, 7.80434E-02_JPRB, 7.51381E-02_JPRB, 7.23409E-02_JPRB,&
&6.96479E-02_JPRB, 6.70551E-02_JPRB, 6.45589E-02_JPRB, 6.21556E-02_JPRB, 5.98417E-02_JPRB/)
SELFREFO( :,11) = (/&
&9.41304E-02_JPRB, 8.97275E-02_JPRB, 8.55305E-02_JPRB, 8.15299E-02_JPRB, 7.77164E-02_JPRB,&
&7.40812E-02_JPRB, 7.06161E-02_JPRB, 6.73131E-02_JPRB, 6.41646E-02_JPRB, 6.11633E-02_JPRB/)
SELFREFO( :,12) = (/&
&9.55404E-02_JPRB, 9.02311E-02_JPRB, 8.52169E-02_JPRB, 8.04813E-02_JPRB, 7.60089E-02_JPRB,&
&7.17850E-02_JPRB, 6.77958E-02_JPRB, 6.40284E-02_JPRB, 6.04703E-02_JPRB, 5.71099E-02_JPRB/)
SELFREFO( :,13) = (/&
&9.32377E-02_JPRB, 8.99082E-02_JPRB, 8.66977E-02_JPRB, 8.36018E-02_JPRB, 8.06164E-02_JPRB,&
&7.77376E-02_JPRB, 7.49617E-02_JPRB, 7.22848E-02_JPRB, 6.97036E-02_JPRB, 6.72145E-02_JPRB/)
SELFREFO( :,14) = (/&
&1.14746E-01_JPRB, 1.08112E-01_JPRB, 1.01861E-01_JPRB, 9.59719E-02_JPRB, 9.04232E-02_JPRB,&
&8.51952E-02_JPRB, 8.02695E-02_JPRB, 7.56285E-02_JPRB, 7.12559E-02_JPRB, 6.71361E-02_JPRB/)
SELFREFO( :,15) = (/&
&1.23517E-01_JPRB, 1.19527E-01_JPRB, 1.15666E-01_JPRB, 1.11929E-01_JPRB, 1.08313E-01_JPRB,&
&1.04814E-01_JPRB, 1.01428E-01_JPRB, 9.81512E-02_JPRB, 9.49803E-02_JPRB, 9.19119E-02_JPRB/)
SELFREFO( :,16) = (/&
&1.44086E-01_JPRB, 1.36396E-01_JPRB, 1.29117E-01_JPRB, 1.22226E-01_JPRB, 1.15703E-01_JPRB,&
&1.09528E-01_JPRB, 1.03683E-01_JPRB, 9.81497E-02_JPRB, 9.29116E-02_JPRB, 8.79530E-02_JPRB/)

FRACREFAO( :, 1) = (/&
!     From P = 1053.6 mb.
    &0.16898900_JPRB,0.15898301_JPRB,0.13575301_JPRB,0.12600900_JPRB,&
    &0.11545800_JPRB,0.09879170_JPRB,0.08106830_JPRB,0.06063440_JPRB,&
    &0.03988780_JPRB,0.00421760_JPRB,0.00346635_JPRB,0.00278779_JPRB,&
    &0.00206225_JPRB,0.00132324_JPRB,0.00050033_JPRB,0.00007038_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.18209399_JPRB,0.15315101_JPRB,0.13571000_JPRB,0.12504999_JPRB,&
    &0.11379100_JPRB,0.09680810_JPRB,0.08008570_JPRB,0.05970280_JPRB,&
    &0.03942860_JPRB,0.00413383_JPRB,0.00343186_JPRB,0.00275558_JPRB,&
    &0.00204657_JPRB,0.00130219_JPRB,0.00045454_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.18459500_JPRB,0.15512000_JPRB,0.13395500_JPRB,0.12576801_JPRB,&
    &0.11276800_JPRB,0.09645190_JPRB,0.07956650_JPRB,0.05903340_JPRB,&
    &0.03887050_JPRB,0.00412226_JPRB,0.00339453_JPRB,0.00273518_JPRB,&
    &0.00196922_JPRB,0.00119411_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.18458800_JPRB,0.15859900_JPRB,0.13278100_JPRB,0.12589300_JPRB,&
    &0.11272700_JPRB,0.09599660_JPRB,0.07903030_JPRB,0.05843600_JPRB,&
    &0.03843400_JPRB,0.00405181_JPRB,0.00337980_JPRB,0.00263818_JPRB,&
    &0.00186869_JPRB,0.00111807_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.18459301_JPRB,0.16176100_JPRB,0.13235000_JPRB,0.12528200_JPRB,&
    &0.11237100_JPRB,0.09618840_JPRB,0.07833760_JPRB,0.05800770_JPRB,&
    &0.03787610_JPRB,0.00408253_JPRB,0.00330363_JPRB,0.00250445_JPRB,&
    &0.00176725_JPRB,0.00111753_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.18454400_JPRB,0.16505300_JPRB,0.13221300_JPRB,0.12476600_JPRB,&
    &0.11158300_JPRB,0.09618120_JPRB,0.07797340_JPRB,0.05740380_JPRB,&
    &0.03742820_JPRB,0.00392691_JPRB,0.00312208_JPRB,0.00246306_JPRB,&
    &0.00176735_JPRB,0.00111721_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.18452001_JPRB,0.16697501_JPRB,0.13445500_JPRB,0.12391300_JPRB,&
    &0.11059100_JPRB,0.09596890_JPRB,0.07761050_JPRB,0.05643200_JPRB,&
    &0.03686520_JPRB,0.00377086_JPRB,0.00309351_JPRB,0.00246297_JPRB,&
    &0.00176765_JPRB,0.00111700_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.18460999_JPRB,0.16854499_JPRB,0.13922299_JPRB,0.12266400_JPRB,&
    &0.10962200_JPRB,0.09452030_JPRB,0.07653800_JPRB,0.05551340_JPRB,&
    &0.03609660_JPRB,0.00377043_JPRB,0.00309367_JPRB,0.00246304_JPRB,&
    &0.00176749_JPRB,0.00111689_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.18312500_JPRB,0.16787501_JPRB,0.14720701_JPRB,0.12766500_JPRB,&
    &0.10890900_JPRB,0.08935530_JPRB,0.07310870_JPRB,0.05443140_JPRB,&
    &0.03566380_JPRB,0.00376446_JPRB,0.00309521_JPRB,0.00246510_JPRB,&
    &0.00176139_JPRB,0.00111543_JPRB,0.00040263_JPRB,0.00005664_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB9_00
