!OCL SCALAR
SUBROUTINE RRTM_KGB5_B1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 5:  700-820 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO5 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, CCL4O
USE YOERRTA5 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KB contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of co2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 1) = (/&
&3.4470E-06_JPRB,2.6372E-04_JPRB,5.1063E-04_JPRB,7.5257E-04_JPRB,1.0534E-03_JPRB/)
KBO( :, 2,13, 1) = (/&
&4.0516E-06_JPRB,3.2949E-04_JPRB,6.3499E-04_JPRB,9.3141E-04_JPRB,1.3018E-03_JPRB/)
KBO( :, 3,13, 1) = (/&
&5.1108E-06_JPRB,3.9538E-04_JPRB,7.5778E-04_JPRB,1.1060E-03_JPRB,1.5459E-03_JPRB/)
KBO( :, 4,13, 1) = (/&
&6.7999E-06_JPRB,4.6001E-04_JPRB,8.7452E-04_JPRB,1.2718E-03_JPRB,1.7787E-03_JPRB/)
KBO( :, 5,13, 1) = (/&
&9.3241E-06_JPRB,5.2270E-04_JPRB,9.8350E-04_JPRB,1.4243E-03_JPRB,1.9970E-03_JPRB/)
KBO( :, 1,14, 1) = (/&
&2.8624E-06_JPRB,2.2203E-04_JPRB,4.2960E-04_JPRB,6.3242E-04_JPRB,8.7262E-04_JPRB/)
KBO( :, 2,14, 1) = (/&
&3.3872E-06_JPRB,2.7597E-04_JPRB,5.3199E-04_JPRB,7.7931E-04_JPRB,1.0726E-03_JPRB/)
KBO( :, 3,14, 1) = (/&
&4.3001E-06_JPRB,3.2993E-04_JPRB,6.3195E-04_JPRB,9.2225E-04_JPRB,1.2666E-03_JPRB/)
KBO( :, 4,14, 1) = (/&
&5.7406E-06_JPRB,3.8294E-04_JPRB,7.2707E-04_JPRB,1.0576E-03_JPRB,1.4495E-03_JPRB/)
KBO( :, 5,14, 1) = (/&
&7.8860E-06_JPRB,4.3459E-04_JPRB,8.1591E-04_JPRB,1.1810E-03_JPRB,1.6187E-03_JPRB/)
KBO( :, 1,15, 1) = (/&
&2.3825E-06_JPRB,1.8697E-04_JPRB,3.6183E-04_JPRB,5.3195E-04_JPRB,7.2587E-04_JPRB/)
KBO( :, 2,15, 1) = (/&
&2.8419E-06_JPRB,2.3121E-04_JPRB,4.4556E-04_JPRB,6.5240E-04_JPRB,8.8767E-04_JPRB/)
KBO( :, 3,15, 1) = (/&
&3.6307E-06_JPRB,2.7550E-04_JPRB,5.2710E-04_JPRB,7.6940E-04_JPRB,1.0435E-03_JPRB/)
KBO( :, 4,15, 1) = (/&
&4.8654E-06_JPRB,3.1911E-04_JPRB,6.0466E-04_JPRB,8.7922E-04_JPRB,1.1890E-03_JPRB/)
KBO( :, 5,15, 1) = (/&
&6.6952E-06_JPRB,3.6172E-04_JPRB,6.7720E-04_JPRB,9.7928E-04_JPRB,1.3218E-03_JPRB/)
KBO( :, 1,16, 1) = (/&
&1.9858E-06_JPRB,1.5742E-04_JPRB,3.0462E-04_JPRB,4.4743E-04_JPRB,6.0679E-04_JPRB/)
KBO( :, 2,16, 1) = (/&
&2.3893E-06_JPRB,1.9376E-04_JPRB,3.7303E-04_JPRB,5.4624E-04_JPRB,7.3818E-04_JPRB/)
KBO( :, 3,16, 1) = (/&
&3.0717E-06_JPRB,2.3016E-04_JPRB,4.3960E-04_JPRB,6.4157E-04_JPRB,8.6419E-04_JPRB/)
KBO( :, 4,16, 1) = (/&
&4.1308E-06_JPRB,2.6599E-04_JPRB,5.0281E-04_JPRB,7.3058E-04_JPRB,9.8120E-04_JPRB/)
KBO( :, 5,16, 1) = (/&
&5.6927E-06_JPRB,3.0109E-04_JPRB,5.6202E-04_JPRB,8.1155E-04_JPRB,1.0872E-03_JPRB/)
KBO( :, 1,17, 1) = (/&
&1.6559E-06_JPRB,1.3226E-04_JPRB,2.5580E-04_JPRB,3.7568E-04_JPRB,5.0686E-04_JPRB/)
KBO( :, 2,17, 1) = (/&
&2.0083E-06_JPRB,1.6212E-04_JPRB,3.1178E-04_JPRB,4.5651E-04_JPRB,6.1368E-04_JPRB/)
KBO( :, 3,17, 1) = (/&
&2.5968E-06_JPRB,1.9205E-04_JPRB,3.6613E-04_JPRB,5.3405E-04_JPRB,7.1563E-04_JPRB/)
KBO( :, 4,17, 1) = (/&
&3.5047E-06_JPRB,2.2153E-04_JPRB,4.1782E-04_JPRB,6.0641E-04_JPRB,8.1002E-04_JPRB/)
KBO( :, 5,17, 1) = (/&
&4.8351E-06_JPRB,2.5056E-04_JPRB,4.6632E-04_JPRB,6.7217E-04_JPRB,8.9508E-04_JPRB/)
KBO( :, 1,18, 1) = (/&
&1.3818E-06_JPRB,1.1100E-04_JPRB,2.1454E-04_JPRB,3.1506E-04_JPRB,4.2338E-04_JPRB/)
KBO( :, 2,18, 1) = (/&
&1.6887E-06_JPRB,1.3556E-04_JPRB,2.6035E-04_JPRB,3.8099E-04_JPRB,5.1025E-04_JPRB/)
KBO( :, 3,18, 1) = (/&
&2.1957E-06_JPRB,1.6016E-04_JPRB,3.0479E-04_JPRB,4.4417E-04_JPRB,5.9284E-04_JPRB/)
KBO( :, 4,18, 1) = (/&
&2.9733E-06_JPRB,1.8444E-04_JPRB,3.4704E-04_JPRB,5.0300E-04_JPRB,6.6896E-04_JPRB/)
KBO( :, 5,18, 1) = (/&
&4.1061E-06_JPRB,2.0846E-04_JPRB,3.8680E-04_JPRB,5.5649E-04_JPRB,7.3738E-04_JPRB/)
KBO( :, 1,19, 1) = (/&
&1.1530E-06_JPRB,9.3038E-05_JPRB,1.7970E-04_JPRB,2.6380E-04_JPRB,3.5309E-04_JPRB/)
KBO( :, 2,19, 1) = (/&
&1.4193E-06_JPRB,1.1326E-04_JPRB,2.1722E-04_JPRB,3.1768E-04_JPRB,4.2371E-04_JPRB/)
KBO( :, 3,19, 1) = (/&
&1.8551E-06_JPRB,1.3348E-04_JPRB,2.5355E-04_JPRB,3.6914E-04_JPRB,4.9054E-04_JPRB/)
KBO( :, 4,19, 1) = (/&
&2.5194E-06_JPRB,1.5356E-04_JPRB,2.8811E-04_JPRB,4.1698E-04_JPRB,5.5182E-04_JPRB/)
KBO( :, 5,19, 1) = (/&
&3.4823E-06_JPRB,1.7336E-04_JPRB,3.2068E-04_JPRB,4.6050E-04_JPRB,6.0663E-04_JPRB/)
KBO( :, 1,20, 1) = (/&
&9.6514E-07_JPRB,7.8220E-05_JPRB,1.5093E-04_JPRB,2.2146E-04_JPRB,2.9562E-04_JPRB/)
KBO( :, 2,20, 1) = (/&
&1.1977E-06_JPRB,9.4837E-05_JPRB,1.8160E-04_JPRB,2.6538E-04_JPRB,3.5295E-04_JPRB/)
KBO( :, 3,20, 1) = (/&
&1.5743E-06_JPRB,1.1151E-04_JPRB,2.1133E-04_JPRB,3.0732E-04_JPRB,4.0705E-04_JPRB/)
KBO( :, 4,20, 1) = (/&
&2.1452E-06_JPRB,1.2810E-04_JPRB,2.3959E-04_JPRB,3.4625E-04_JPRB,4.5647E-04_JPRB/)
KBO( :, 5,20, 1) = (/&
&2.9673E-06_JPRB,1.4434E-04_JPRB,2.6631E-04_JPRB,3.8162E-04_JPRB,5.0047E-04_JPRB/)
KBO( :, 1,21, 1) = (/&
&8.0884E-07_JPRB,6.5739E-05_JPRB,1.2670E-04_JPRB,1.8581E-04_JPRB,2.4748E-04_JPRB/)
KBO( :, 2,21, 1) = (/&
&1.0118E-06_JPRB,7.9430E-05_JPRB,1.5182E-04_JPRB,2.2166E-04_JPRB,2.9412E-04_JPRB/)
KBO( :, 3,21, 1) = (/&
&1.3370E-06_JPRB,9.3177E-05_JPRB,1.7611E-04_JPRB,2.5580E-04_JPRB,3.3790E-04_JPRB/)
KBO( :, 4,21, 1) = (/&
&1.8276E-06_JPRB,1.0684E-04_JPRB,1.9928E-04_JPRB,2.8745E-04_JPRB,3.7772E-04_JPRB/)
KBO( :, 5,21, 1) = (/&
&2.5289E-06_JPRB,1.2011E-04_JPRB,2.2122E-04_JPRB,3.1628E-04_JPRB,4.1308E-04_JPRB/)
KBO( :, 1,22, 1) = (/&
&6.8770E-07_JPRB,5.5977E-05_JPRB,1.0768E-04_JPRB,1.5779E-04_JPRB,2.0975E-04_JPRB/)
KBO( :, 2,22, 1) = (/&
&8.7051E-07_JPRB,6.7267E-05_JPRB,1.2822E-04_JPRB,1.8696E-04_JPRB,2.4752E-04_JPRB/)
KBO( :, 3,22, 1) = (/&
&1.1593E-06_JPRB,7.8612E-05_JPRB,1.4804E-04_JPRB,2.1465E-04_JPRB,2.8275E-04_JPRB/)
KBO( :, 4,22, 1) = (/&
&1.5914E-06_JPRB,8.9752E-05_JPRB,1.6700E-04_JPRB,2.4024E-04_JPRB,3.1462E-04_JPRB/)
KBO( :, 5,22, 1) = (/&
&2.2022E-06_JPRB,1.0055E-04_JPRB,1.8482E-04_JPRB,2.6358E-04_JPRB,3.4283E-04_JPRB/)
KBO( :, 1,23, 1) = (/&
&5.8681E-07_JPRB,4.7674E-05_JPRB,9.1507E-05_JPRB,1.3393E-04_JPRB,1.7770E-04_JPRB/)
KBO( :, 2,23, 1) = (/&
&7.5149E-07_JPRB,5.7003E-05_JPRB,1.0829E-04_JPRB,1.5767E-04_JPRB,2.0825E-04_JPRB/)
KBO( :, 3,23, 1) = (/&
&1.0080E-06_JPRB,6.6289E-05_JPRB,1.2450E-04_JPRB,1.8010E-04_JPRB,2.3658E-04_JPRB/)
KBO( :, 4,23, 1) = (/&
&1.3887E-06_JPRB,7.5365E-05_JPRB,1.3995E-04_JPRB,2.0079E-04_JPRB,2.6204E-04_JPRB/)
KBO( :, 5,23, 1) = (/&
&1.9208E-06_JPRB,8.4126E-05_JPRB,1.5435E-04_JPRB,2.1972E-04_JPRB,2.8449E-04_JPRB/)
KBO( :, 1,24, 1) = (/&
&5.0292E-07_JPRB,4.0632E-05_JPRB,7.7788E-05_JPRB,1.1370E-04_JPRB,1.5053E-04_JPRB/)
KBO( :, 2,24, 1) = (/&
&6.5118E-07_JPRB,4.8318E-05_JPRB,9.1504E-05_JPRB,1.3299E-04_JPRB,1.7517E-04_JPRB/)
KBO( :, 3,24, 1) = (/&
&8.7976E-07_JPRB,5.5886E-05_JPRB,1.0475E-04_JPRB,1.5115E-04_JPRB,1.9787E-04_JPRB/)
KBO( :, 4,24, 1) = (/&
&1.2151E-06_JPRB,6.3269E-05_JPRB,1.1727E-04_JPRB,1.6792E-04_JPRB,2.1820E-04_JPRB/)
KBO( :, 5,24, 1) = (/&
&1.6790E-06_JPRB,7.0361E-05_JPRB,1.2886E-04_JPRB,1.8317E-04_JPRB,2.3599E-04_JPRB/)
KBO( :, 1,25, 1) = (/&
&4.3320E-07_JPRB,3.4672E-05_JPRB,6.6172E-05_JPRB,9.6557E-05_JPRB,1.2755E-04_JPRB/)
KBO( :, 2,25, 1) = (/&
&5.6706E-07_JPRB,4.0954E-05_JPRB,7.7399E-05_JPRB,1.1224E-04_JPRB,1.4744E-04_JPRB/)
KBO( :, 3,25, 1) = (/&
&7.7121E-07_JPRB,4.7130E-05_JPRB,8.8173E-05_JPRB,1.2695E-04_JPRB,1.6559E-04_JPRB/)
KBO( :, 4,25, 1) = (/&
&1.0669E-06_JPRB,5.3117E-05_JPRB,9.8264E-05_JPRB,1.4052E-04_JPRB,1.8177E-04_JPRB/)
KBO( :, 5,25, 1) = (/&
&1.4722E-06_JPRB,5.8854E-05_JPRB,1.0754E-04_JPRB,1.5271E-04_JPRB,1.9584E-04_JPRB/)
KBO( :, 1,26, 1) = (/&
&3.7607E-07_JPRB,2.9637E-05_JPRB,5.6418E-05_JPRB,8.2160E-05_JPRB,1.0828E-04_JPRB/)
KBO( :, 2,26, 1) = (/&
&4.9757E-07_JPRB,3.4761E-05_JPRB,6.5581E-05_JPRB,9.4869E-05_JPRB,1.2424E-04_JPRB/)
KBO( :, 3,26, 1) = (/&
&6.8088E-07_JPRB,3.9782E-05_JPRB,7.4280E-05_JPRB,1.0678E-04_JPRB,1.3874E-04_JPRB/)
KBO( :, 4,26, 1) = (/&
&9.4259E-07_JPRB,4.4634E-05_JPRB,8.2385E-05_JPRB,1.1768E-04_JPRB,1.5157E-04_JPRB/)
KBO( :, 5,26, 1) = (/&
&1.2981E-06_JPRB,4.9274E-05_JPRB,8.9787E-05_JPRB,1.2735E-04_JPRB,1.6265E-04_JPRB/)
KBO( :, 1,27, 1) = (/&
&3.2783E-07_JPRB,2.5292E-05_JPRB,4.8063E-05_JPRB,6.9840E-05_JPRB,9.1852E-05_JPRB/)
KBO( :, 2,27, 1) = (/&
&4.3792E-07_JPRB,2.9476E-05_JPRB,5.5497E-05_JPRB,8.0152E-05_JPRB,1.0466E-04_JPRB/)
KBO( :, 3,27, 1) = (/&
&6.0227E-07_JPRB,3.3553E-05_JPRB,6.2514E-05_JPRB,8.9762E-05_JPRB,1.1621E-04_JPRB/)
KBO( :, 4,27, 1) = (/&
&8.3354E-07_JPRB,3.7479E-05_JPRB,6.9000E-05_JPRB,9.8462E-05_JPRB,1.2640E-04_JPRB/)
KBO( :, 5,27, 1) = (/&
&1.1448E-06_JPRB,4.1239E-05_JPRB,7.4917E-05_JPRB,1.0612E-04_JPRB,1.3514E-04_JPRB/)
KBO( :, 1,28, 1) = (/&
&2.8669E-07_JPRB,2.1556E-05_JPRB,4.0892E-05_JPRB,5.9304E-05_JPRB,7.7833E-05_JPRB/)
KBO( :, 2,28, 1) = (/&
&3.8635E-07_JPRB,2.4960E-05_JPRB,4.6902E-05_JPRB,6.7670E-05_JPRB,8.8103E-05_JPRB/)
KBO( :, 3,28, 1) = (/&
&5.3330E-07_JPRB,2.8270E-05_JPRB,5.2542E-05_JPRB,7.5364E-05_JPRB,9.7308E-05_JPRB/)
KBO( :, 4,28, 1) = (/&
&7.3734E-07_JPRB,3.1446E-05_JPRB,5.7727E-05_JPRB,8.2286E-05_JPRB,1.0537E-04_JPRB/)
KBO( :, 5,28, 1) = (/&
&1.0096E-06_JPRB,3.4495E-05_JPRB,6.2455E-05_JPRB,8.8340E-05_JPRB,1.1227E-04_JPRB/)
KBO( :, 1,29, 1) = (/&
&2.5201E-07_JPRB,1.8361E-05_JPRB,3.4763E-05_JPRB,5.0351E-05_JPRB,6.5987E-05_JPRB/)
KBO( :, 2,29, 1) = (/&
&3.4236E-07_JPRB,2.1129E-05_JPRB,3.9617E-05_JPRB,5.7095E-05_JPRB,7.4216E-05_JPRB/)
KBO( :, 3,29, 1) = (/&
&4.7361E-07_JPRB,2.3813E-05_JPRB,4.4138E-05_JPRB,6.3255E-05_JPRB,8.1563E-05_JPRB/)
KBO( :, 4,29, 1) = (/&
&6.5380E-07_JPRB,2.6387E-05_JPRB,4.8286E-05_JPRB,6.8730E-05_JPRB,8.7959E-05_JPRB/)
KBO( :, 5,29, 1) = (/&
&8.9193E-07_JPRB,2.8857E-05_JPRB,5.2062E-05_JPRB,7.3497E-05_JPRB,9.3411E-05_JPRB/)
KBO( :, 1,30, 1) = (/&
&2.2221E-07_JPRB,1.5617E-05_JPRB,2.9506E-05_JPRB,4.2701E-05_JPRB,5.5901E-05_JPRB/)
KBO( :, 2,30, 1) = (/&
&3.0397E-07_JPRB,1.7865E-05_JPRB,3.3414E-05_JPRB,4.8107E-05_JPRB,6.2491E-05_JPRB/)
KBO( :, 3,30, 1) = (/&
&4.2084E-07_JPRB,2.0038E-05_JPRB,3.7035E-05_JPRB,5.3015E-05_JPRB,6.8354E-05_JPRB/)
KBO( :, 4,30, 1) = (/&
&5.7974E-07_JPRB,2.2125E-05_JPRB,4.0351E-05_JPRB,5.7341E-05_JPRB,7.3435E-05_JPRB/)
KBO( :, 5,30, 1) = (/&
&7.8765E-07_JPRB,2.4127E-05_JPRB,4.3366E-05_JPRB,6.1092E-05_JPRB,7.7733E-05_JPRB/)
KBO( :, 1,31, 1) = (/&
&1.9681E-07_JPRB,1.3270E-05_JPRB,2.5018E-05_JPRB,3.6169E-05_JPRB,4.7371E-05_JPRB/)
KBO( :, 2,31, 1) = (/&
&2.7071E-07_JPRB,1.5097E-05_JPRB,2.8159E-05_JPRB,4.0500E-05_JPRB,5.2659E-05_JPRB/)
KBO( :, 3,31, 1) = (/&
&3.7475E-07_JPRB,1.6858E-05_JPRB,3.1057E-05_JPRB,4.4392E-05_JPRB,5.7349E-05_JPRB/)
KBO( :, 4,31, 1) = (/&
&5.1477E-07_JPRB,1.8547E-05_JPRB,3.3705E-05_JPRB,4.7805E-05_JPRB,6.1389E-05_JPRB/)
KBO( :, 5,31, 1) = (/&
&6.9625E-07_JPRB,2.0170E-05_JPRB,3.6118E-05_JPRB,5.0758E-05_JPRB,6.4797E-05_JPRB/)
KBO( :, 1,32, 1) = (/&
&1.7485E-07_JPRB,1.1265E-05_JPRB,2.1186E-05_JPRB,3.0600E-05_JPRB,4.0119E-05_JPRB/)
KBO( :, 2,32, 1) = (/&
&2.4148E-07_JPRB,1.2747E-05_JPRB,2.3704E-05_JPRB,3.4052E-05_JPRB,4.4364E-05_JPRB/)
KBO( :, 3,32, 1) = (/&
&3.3391E-07_JPRB,1.4173E-05_JPRB,2.6023E-05_JPRB,3.7134E-05_JPRB,4.8107E-05_JPRB/)
KBO( :, 4,32, 1) = (/&
&4.5712E-07_JPRB,1.5544E-05_JPRB,2.8139E-05_JPRB,3.9822E-05_JPRB,5.1320E-05_JPRB/)
KBO( :, 5,32, 1) = (/&
&6.1526E-07_JPRB,1.6857E-05_JPRB,3.0064E-05_JPRB,4.2147E-05_JPRB,5.4009E-05_JPRB/)
KBO( :, 1,33, 1) = (/&
&1.5570E-07_JPRB,9.5475E-06_JPRB,1.7911E-05_JPRB,2.5842E-05_JPRB,3.3957E-05_JPRB/)
KBO( :, 2,33, 1) = (/&
&2.1549E-07_JPRB,1.0751E-05_JPRB,1.9931E-05_JPRB,2.8592E-05_JPRB,3.7370E-05_JPRB/)
KBO( :, 3,33, 1) = (/&
&2.9746E-07_JPRB,1.1906E-05_JPRB,2.1783E-05_JPRB,3.1027E-05_JPRB,4.0353E-05_JPRB/)
KBO( :, 4,33, 1) = (/&
&4.0565E-07_JPRB,1.3019E-05_JPRB,2.3473E-05_JPRB,3.3146E-05_JPRB,4.2910E-05_JPRB/)
KBO( :, 5,33, 1) = (/&
&5.4308E-07_JPRB,1.4082E-05_JPRB,2.5010E-05_JPRB,3.4973E-05_JPRB,4.5040E-05_JPRB/)
KBO( :, 1,34, 1) = (/&
&1.3721E-07_JPRB,8.0465E-06_JPRB,1.5060E-05_JPRB,2.1707E-05_JPRB,2.8588E-05_JPRB/)
KBO( :, 2,34, 1) = (/&
&1.9002E-07_JPRB,9.0232E-06_JPRB,1.6681E-05_JPRB,2.3900E-05_JPRB,3.1327E-05_JPRB/)
KBO( :, 3,34, 1) = (/&
&2.6180E-07_JPRB,9.9630E-06_JPRB,1.8168E-05_JPRB,2.5833E-05_JPRB,3.3720E-05_JPRB/)
KBO( :, 4,34, 1) = (/&
&3.5566E-07_JPRB,1.0865E-05_JPRB,1.9523E-05_JPRB,2.7511E-05_JPRB,3.5767E-05_JPRB/)
KBO( :, 5,34, 1) = (/&
&4.7391E-07_JPRB,1.1726E-05_JPRB,2.0751E-05_JPRB,2.8954E-05_JPRB,3.7468E-05_JPRB/)
KBO( :, 1,35, 1) = (/&
&1.1723E-07_JPRB,6.6964E-06_JPRB,1.2516E-05_JPRB,1.8031E-05_JPRB,2.3821E-05_JPRB/)
KBO( :, 2,35, 1) = (/&
&1.6235E-07_JPRB,7.4927E-06_JPRB,1.3829E-05_JPRB,1.9800E-05_JPRB,2.6051E-05_JPRB/)
KBO( :, 3,35, 1) = (/&
&2.2335E-07_JPRB,8.2568E-06_JPRB,1.5029E-05_JPRB,2.1350E-05_JPRB,2.8000E-05_JPRB/)
KBO( :, 4,35, 1) = (/&
&3.0275E-07_JPRB,8.9930E-06_JPRB,1.6127E-05_JPRB,2.2699E-05_JPRB,2.9671E-05_JPRB/)
KBO( :, 5,35, 1) = (/&
&4.0236E-07_JPRB,9.6965E-06_JPRB,1.7121E-05_JPRB,2.3858E-05_JPRB,3.1064E-05_JPRB/)
KBO( :, 1,36, 1) = (/&
&9.6662E-08_JPRB,5.4982E-06_JPRB,1.0275E-05_JPRB,1.4804E-05_JPRB,1.9630E-05_JPRB/)
KBO( :, 2,36, 1) = (/&
&1.3386E-07_JPRB,6.1501E-06_JPRB,1.1348E-05_JPRB,1.6247E-05_JPRB,2.1474E-05_JPRB/)
KBO( :, 3,36, 1) = (/&
&1.8410E-07_JPRB,6.7756E-06_JPRB,1.2329E-05_JPRB,1.7513E-05_JPRB,2.3090E-05_JPRB/)
KBO( :, 4,36, 1) = (/&
&2.4947E-07_JPRB,7.3775E-06_JPRB,1.3225E-05_JPRB,1.8612E-05_JPRB,2.4479E-05_JPRB/)
KBO( :, 5,36, 1) = (/&
&3.3138E-07_JPRB,7.9539E-06_JPRB,1.4038E-05_JPRB,1.9559E-05_JPRB,2.5645E-05_JPRB/)
KBO( :, 1,37, 1) = (/&
&7.5833E-08_JPRB,4.4319E-06_JPRB,8.2961E-06_JPRB,1.1965E-05_JPRB,1.5922E-05_JPRB/)
KBO( :, 2,37, 1) = (/&
&1.0502E-07_JPRB,4.9674E-06_JPRB,9.1830E-06_JPRB,1.3164E-05_JPRB,1.7469E-05_JPRB/)
KBO( :, 3,37, 1) = (/&
&1.4465E-07_JPRB,5.4834E-06_JPRB,9.9967E-06_JPRB,1.4218E-05_JPRB,1.8834E-05_JPRB/)
KBO( :, 4,37, 1) = (/&
&1.9645E-07_JPRB,5.9788E-06_JPRB,1.0738E-05_JPRB,1.5133E-05_JPRB,2.0012E-05_JPRB/)
KBO( :, 5,37, 1) = (/&
&2.6166E-07_JPRB,6.4529E-06_JPRB,1.1414E-05_JPRB,1.5924E-05_JPRB,2.1010E-05_JPRB/)
KBO( :, 1,38, 1) = (/&
&5.9339E-08_JPRB,3.5670E-06_JPRB,6.6893E-06_JPRB,9.6566E-06_JPRB,1.2902E-05_JPRB/)
KBO( :, 2,38, 1) = (/&
&8.2155E-08_JPRB,4.0080E-06_JPRB,7.4233E-06_JPRB,1.0653E-05_JPRB,1.4205E-05_JPRB/)
KBO( :, 3,38, 1) = (/&
&1.1331E-07_JPRB,4.4325E-06_JPRB,8.0980E-06_JPRB,1.1532E-05_JPRB,1.5359E-05_JPRB/)
KBO( :, 4,38, 1) = (/&
&1.5427E-07_JPRB,4.8410E-06_JPRB,8.7132E-06_JPRB,1.2297E-05_JPRB,1.6364E-05_JPRB/)
KBO( :, 5,38, 1) = (/&
&2.0603E-07_JPRB,5.2310E-06_JPRB,9.2738E-06_JPRB,1.2957E-05_JPRB,1.7220E-05_JPRB/)
KBO( :, 1,39, 1) = (/&
&4.6457E-08_JPRB,2.8706E-06_JPRB,5.3922E-06_JPRB,7.7916E-06_JPRB,1.0463E-05_JPRB/)
KBO( :, 2,39, 1) = (/&
&6.4280E-08_JPRB,3.2335E-06_JPRB,5.9995E-06_JPRB,8.6193E-06_JPRB,1.1561E-05_JPRB/)
KBO( :, 3,39, 1) = (/&
&8.8753E-08_JPRB,3.5826E-06_JPRB,6.5580E-06_JPRB,9.3509E-06_JPRB,1.2539E-05_JPRB/)
KBO( :, 4,39, 1) = (/&
&1.2109E-07_JPRB,3.9186E-06_JPRB,7.0688E-06_JPRB,9.9899E-06_JPRB,1.3398E-05_JPRB/)
KBO( :, 5,39, 1) = (/&
&1.6221E-07_JPRB,4.2407E-06_JPRB,7.5350E-06_JPRB,1.0543E-05_JPRB,1.4137E-05_JPRB/)
KBO( :, 1,40, 1) = (/&
&3.5213E-08_JPRB,2.2779E-06_JPRB,4.2906E-06_JPRB,6.2087E-06_JPRB,8.3621E-06_JPRB/)
KBO( :, 2,40, 1) = (/&
&4.8621E-08_JPRB,2.5769E-06_JPRB,4.7967E-06_JPRB,6.9026E-06_JPRB,9.2884E-06_JPRB/)
KBO( :, 3,40, 1) = (/&
&6.7228E-08_JPRB,2.8656E-06_JPRB,5.2643E-06_JPRB,7.5217E-06_JPRB,1.0122E-05_JPRB/)
KBO( :, 4,40, 1) = (/&
&9.2051E-08_JPRB,3.1437E-06_JPRB,5.6919E-06_JPRB,8.0632E-06_JPRB,1.0858E-05_JPRB/)
KBO( :, 5,40, 1) = (/&
&1.2392E-07_JPRB,3.4099E-06_JPRB,6.0819E-06_JPRB,8.5318E-06_JPRB,1.1495E-05_JPRB/)
KBO( :, 1,41, 1) = (/&
&2.6618E-08_JPRB,1.8019E-06_JPRB,3.4036E-06_JPRB,4.9321E-06_JPRB,6.6614E-06_JPRB/)
KBO( :, 2,41, 1) = (/&
&3.6608E-08_JPRB,2.0487E-06_JPRB,3.8262E-06_JPRB,5.5154E-06_JPRB,7.4437E-06_JPRB/)
KBO( :, 3,41, 1) = (/&
&5.0672E-08_JPRB,2.2872E-06_JPRB,4.2170E-06_JPRB,6.0380E-06_JPRB,8.1516E-06_JPRB/)
KBO( :, 4,41, 1) = (/&
&6.9610E-08_JPRB,2.5171E-06_JPRB,4.5756E-06_JPRB,6.4977E-06_JPRB,8.7822E-06_JPRB/)
KBO( :, 5,41, 1) = (/&
&9.4152E-08_JPRB,2.7376E-06_JPRB,4.9025E-06_JPRB,6.8959E-06_JPRB,9.3313E-06_JPRB/)
KBO( :, 1,42, 1) = (/&
&2.0157E-08_JPRB,1.4234E-06_JPRB,2.6959E-06_JPRB,3.9114E-06_JPRB,5.2999E-06_JPRB/)
KBO( :, 2,42, 1) = (/&
&2.7569E-08_JPRB,1.6266E-06_JPRB,3.0478E-06_JPRB,4.4003E-06_JPRB,5.9585E-06_JPRB/)
KBO( :, 3,42, 1) = (/&
&3.8168E-08_JPRB,1.8237E-06_JPRB,3.3743E-06_JPRB,4.8412E-06_JPRB,6.5607E-06_JPRB/)
KBO( :, 4,42, 1) = (/&
&5.2578E-08_JPRB,2.0137E-06_JPRB,3.6751E-06_JPRB,5.2309E-06_JPRB,7.1001E-06_JPRB/)
KBO( :, 5,42, 1) = (/&
&7.1438E-08_JPRB,2.1965E-06_JPRB,3.9491E-06_JPRB,5.5693E-06_JPRB,7.5736E-06_JPRB/)
KBO( :, 1,43, 1) = (/&
&1.5048E-08_JPRB,1.1128E-06_JPRB,2.1143E-06_JPRB,3.0719E-06_JPRB,4.1759E-06_JPRB/)
KBO( :, 2,43, 1) = (/&
&2.0401E-08_JPRB,1.2805E-06_JPRB,2.4084E-06_JPRB,3.4833E-06_JPRB,4.7326E-06_JPRB/)
KBO( :, 3,43, 1) = (/&
&2.8205E-08_JPRB,1.4438E-06_JPRB,2.6828E-06_JPRB,3.8579E-06_JPRB,5.2466E-06_JPRB/)
KBO( :, 4,43, 1) = (/&
&3.8951E-08_JPRB,1.6012E-06_JPRB,2.9353E-06_JPRB,4.1897E-06_JPRB,5.7090E-06_JPRB/)
KBO( :, 5,43, 1) = (/&
&5.3191E-08_JPRB,1.7525E-06_JPRB,3.1662E-06_JPRB,4.4792E-06_JPRB,6.1200E-06_JPRB/)
KBO( :, 1,44, 1) = (/&
&1.1198E-08_JPRB,8.6431E-07_JPRB,1.6473E-06_JPRB,2.3969E-06_JPRB,3.2705E-06_JPRB/)
KBO( :, 2,44, 1) = (/&
&1.5007E-08_JPRB,1.0027E-06_JPRB,1.8931E-06_JPRB,2.7433E-06_JPRB,3.7404E-06_JPRB/)
KBO( :, 3,44, 1) = (/&
&2.0665E-08_JPRB,1.1376E-06_JPRB,2.1233E-06_JPRB,3.0602E-06_JPRB,4.1782E-06_JPRB/)
KBO( :, 4,44, 1) = (/&
&2.8586E-08_JPRB,1.2680E-06_JPRB,2.3363E-06_JPRB,3.3439E-06_JPRB,4.5764E-06_JPRB/)
KBO( :, 5,44, 1) = (/&
&3.9218E-08_JPRB,1.3937E-06_JPRB,2.5309E-06_JPRB,3.5921E-06_JPRB,4.9322E-06_JPRB/)
KBO( :, 1,45, 1) = (/&
&8.3759E-09_JPRB,6.6910E-07_JPRB,1.2788E-06_JPRB,1.8633E-06_JPRB,2.5541E-06_JPRB/)
KBO( :, 2,45, 1) = (/&
&1.1074E-08_JPRB,7.8311E-07_JPRB,1.4838E-06_JPRB,2.1538E-06_JPRB,2.9501E-06_JPRB/)
KBO( :, 3,45, 1) = (/&
&1.5144E-08_JPRB,8.9455E-07_JPRB,1.6769E-06_JPRB,2.4217E-06_JPRB,3.3225E-06_JPRB/)
KBO( :, 4,45, 1) = (/&
&2.0959E-08_JPRB,1.0028E-06_JPRB,1.8560E-06_JPRB,2.6635E-06_JPRB,3.6644E-06_JPRB/)
KBO( :, 5,45, 1) = (/&
&2.8861E-08_JPRB,1.1068E-06_JPRB,2.0205E-06_JPRB,2.8768E-06_JPRB,3.9736E-06_JPRB/)
KBO( :, 1,46, 1) = (/&
&6.2739E-09_JPRB,5.1407E-07_JPRB,9.8522E-07_JPRB,1.4377E-06_JPRB,1.9806E-06_JPRB/)
KBO( :, 2,46, 1) = (/&
&8.1529E-09_JPRB,6.0797E-07_JPRB,1.1561E-06_JPRB,1.6807E-06_JPRB,2.3136E-06_JPRB/)
KBO( :, 3,46, 1) = (/&
&1.1038E-08_JPRB,7.0008E-07_JPRB,1.3179E-06_JPRB,1.9073E-06_JPRB,2.6301E-06_JPRB/)
KBO( :, 4,46, 1) = (/&
&1.5249E-08_JPRB,7.8964E-07_JPRB,1.4688E-06_JPRB,2.1133E-06_JPRB,2.9239E-06_JPRB/)
KBO( :, 5,46, 1) = (/&
&2.1058E-08_JPRB,8.7606E-07_JPRB,1.6079E-06_JPRB,2.2965E-06_JPRB,3.1920E-06_JPRB/)
KBO( :, 1,47, 1) = (/&
&4.6949E-09_JPRB,3.8992E-07_JPRB,7.4927E-07_JPRB,1.0952E-06_JPRB,1.5159E-06_JPRB/)
KBO( :, 2,47, 1) = (/&
&5.9645E-09_JPRB,4.6716E-07_JPRB,8.9151E-07_JPRB,1.2982E-06_JPRB,1.7952E-06_JPRB/)
KBO( :, 3,47, 1) = (/&
&7.9612E-09_JPRB,5.4321E-07_JPRB,1.0272E-06_JPRB,1.4897E-06_JPRB,2.0633E-06_JPRB/)
KBO( :, 4,47, 1) = (/&
&1.0938E-08_JPRB,6.1746E-07_JPRB,1.1545E-06_JPRB,1.6654E-06_JPRB,2.3153E-06_JPRB/)
KBO( :, 5,47, 1) = (/&
&1.5132E-08_JPRB,6.8917E-07_JPRB,1.2721E-06_JPRB,1.8228E-06_JPRB,2.5468E-06_JPRB/)
KBO( :, 1,48, 1) = (/&
&3.5531E-09_JPRB,2.9393E-07_JPRB,5.6622E-07_JPRB,8.2884E-07_JPRB,1.1544E-06_JPRB/)
KBO( :, 2,48, 1) = (/&
&4.3982E-09_JPRB,3.5721E-07_JPRB,6.8388E-07_JPRB,9.9751E-07_JPRB,1.3878E-06_JPRB/)
KBO( :, 3,48, 1) = (/&
&5.7699E-09_JPRB,4.1995E-07_JPRB,7.9742E-07_JPRB,1.1586E-06_JPRB,1.6142E-06_JPRB/)
KBO( :, 4,48, 1) = (/&
&7.8542E-09_JPRB,4.8132E-07_JPRB,9.0450E-07_JPRB,1.3078E-06_JPRB,1.8297E-06_JPRB/)
KBO( :, 5,48, 1) = (/&
&1.0862E-08_JPRB,5.4098E-07_JPRB,1.0041E-06_JPRB,1.4432E-06_JPRB,2.0302E-06_JPRB/)
KBO( :, 1,49, 1) = (/&
&2.7223E-09_JPRB,2.2011E-07_JPRB,4.2480E-07_JPRB,6.2273E-07_JPRB,8.7522E-07_JPRB/)
KBO( :, 2,49, 1) = (/&
&3.2751E-09_JPRB,2.7175E-07_JPRB,5.2169E-07_JPRB,7.6216E-07_JPRB,1.0695E-06_JPRB/)
KBO( :, 3,49, 1) = (/&
&4.2074E-09_JPRB,3.2338E-07_JPRB,6.1638E-07_JPRB,8.9710E-07_JPRB,1.2605E-06_JPRB/)
KBO( :, 4,49, 1) = (/&
&5.6548E-09_JPRB,3.7408E-07_JPRB,7.0619E-07_JPRB,1.0234E-06_JPRB,1.4445E-06_JPRB/)
KBO( :, 5,49, 1) = (/&
&7.7931E-09_JPRB,4.2353E-07_JPRB,7.9036E-07_JPRB,1.1391E-06_JPRB,1.6183E-06_JPRB/)
KBO( :, 1,50, 1) = (/&
&2.1171E-09_JPRB,1.6461E-07_JPRB,3.1815E-07_JPRB,4.6707E-07_JPRB,6.6131E-07_JPRB/)
KBO( :, 2,50, 1) = (/&
&2.4767E-09_JPRB,2.0654E-07_JPRB,3.9751E-07_JPRB,5.8161E-07_JPRB,8.2129E-07_JPRB/)
KBO( :, 3,50, 1) = (/&
&3.1098E-09_JPRB,2.4898E-07_JPRB,4.7607E-07_JPRB,6.9397E-07_JPRB,9.8108E-07_JPRB/)
KBO( :, 4,50, 1) = (/&
&4.1196E-09_JPRB,2.9082E-07_JPRB,5.5125E-07_JPRB,8.0034E-07_JPRB,1.1364E-06_JPRB/)
KBO( :, 5,50, 1) = (/&
&5.6373E-09_JPRB,3.3169E-07_JPRB,6.2193E-07_JPRB,8.9844E-07_JPRB,1.2847E-06_JPRB/)
KBO( :, 1,51, 1) = (/&
&1.6645E-09_JPRB,1.2257E-07_JPRB,2.3718E-07_JPRB,3.4865E-07_JPRB,4.9717E-07_JPRB/)
KBO( :, 2,51, 1) = (/&
&1.8963E-09_JPRB,1.5653E-07_JPRB,3.0185E-07_JPRB,4.4222E-07_JPRB,6.2797E-07_JPRB/)
KBO( :, 3,51, 1) = (/&
&2.3235E-09_JPRB,1.9123E-07_JPRB,3.6667E-07_JPRB,5.3530E-07_JPRB,7.6057E-07_JPRB/)
KBO( :, 4,51, 1) = (/&
&3.0254E-09_JPRB,2.2572E-07_JPRB,4.2945E-07_JPRB,6.2453E-07_JPRB,8.9069E-07_JPRB/)
KBO( :, 5,51, 1) = (/&
&4.0995E-09_JPRB,2.5950E-07_JPRB,4.8873E-07_JPRB,7.0742E-07_JPRB,1.0163E-06_JPRB/)
KBO( :, 1,52, 1) = (/&
&1.3206E-09_JPRB,9.0571E-08_JPRB,1.7550E-07_JPRB,2.5829E-07_JPRB,3.7195E-07_JPRB/)
KBO( :, 2,52, 1) = (/&
&1.4670E-09_JPRB,1.1797E-07_JPRB,2.2784E-07_JPRB,3.3424E-07_JPRB,4.7844E-07_JPRB/)
KBO( :, 3,52, 1) = (/&
&1.7505E-09_JPRB,1.4623E-07_JPRB,2.8107E-07_JPRB,4.1094E-07_JPRB,5.8801E-07_JPRB/)
KBO( :, 4,52, 1) = (/&
&2.2339E-09_JPRB,1.7460E-07_JPRB,3.3329E-07_JPRB,4.8542E-07_JPRB,6.9695E-07_JPRB/)
KBO( :, 5,52, 1) = (/&
&2.9899E-09_JPRB,2.0250E-07_JPRB,3.8293E-07_JPRB,5.5538E-07_JPRB,8.0322E-07_JPRB/)
KBO( :, 1,53, 1) = (/&
&1.0570E-09_JPRB,6.6355E-08_JPRB,1.2871E-07_JPRB,1.8963E-07_JPRB,2.7719E-07_JPRB/)
KBO( :, 2,53, 1) = (/&
&1.1456E-09_JPRB,8.8306E-08_JPRB,1.7079E-07_JPRB,2.5086E-07_JPRB,3.6333E-07_JPRB/)
KBO( :, 3,53, 1) = (/&
&1.3304E-09_JPRB,1.1127E-07_JPRB,2.1434E-07_JPRB,3.1381E-07_JPRB,4.5369E-07_JPRB/)
KBO( :, 4,53, 1) = (/&
&1.6595E-09_JPRB,1.3454E-07_JPRB,2.5758E-07_JPRB,3.7572E-07_JPRB,5.4496E-07_JPRB/)
KBO( :, 5,53, 1) = (/&
&2.1883E-09_JPRB,1.5755E-07_JPRB,2.9906E-07_JPRB,4.3451E-07_JPRB,6.3482E-07_JPRB/)
KBO( :, 1,54, 1) = (/&
&8.5518E-10_JPRB,4.8675E-08_JPRB,9.4477E-08_JPRB,1.3931E-07_JPRB,2.0489E-07_JPRB/)
KBO( :, 2,54, 1) = (/&
&9.0530E-10_JPRB,6.6186E-08_JPRB,1.2814E-07_JPRB,1.8845E-07_JPRB,2.7365E-07_JPRB/)
KBO( :, 3,54, 1) = (/&
&1.0265E-09_JPRB,8.4782E-08_JPRB,1.6360E-07_JPRB,2.3982E-07_JPRB,3.4689E-07_JPRB/)
KBO( :, 4,54, 1) = (/&
&1.2515E-09_JPRB,1.0381E-07_JPRB,1.9922E-07_JPRB,2.9100E-07_JPRB,4.2180E-07_JPRB/)
KBO( :, 5,54, 1) = (/&
&1.6232E-09_JPRB,1.2276E-07_JPRB,2.3378E-07_JPRB,3.4015E-07_JPRB,4.9603E-07_JPRB/)
KBO( :, 1,55, 1) = (/&
&6.9700E-10_JPRB,3.5570E-08_JPRB,6.9080E-08_JPRB,1.0195E-07_JPRB,1.4991E-07_JPRB/)
KBO( :, 2,55, 1) = (/&
&7.2150E-10_JPRB,4.9476E-08_JPRB,9.5896E-08_JPRB,1.4119E-07_JPRB,2.0429E-07_JPRB/)
KBO( :, 3,55, 1) = (/&
&8.0028E-10_JPRB,6.4502E-08_JPRB,1.2464E-07_JPRB,1.8291E-07_JPRB,2.6311E-07_JPRB/)
KBO( :, 4,55, 1) = (/&
&9.5310E-10_JPRB,8.0013E-08_JPRB,1.5388E-07_JPRB,2.2506E-07_JPRB,3.2381E-07_JPRB/)
KBO( :, 5,55, 1) = (/&
&1.2140E-09_JPRB,9.5569E-08_JPRB,1.8254E-07_JPRB,2.6597E-07_JPRB,3.8428E-07_JPRB/)
KBO( :, 1,56, 1) = (/&
&5.7187E-10_JPRB,2.5788E-08_JPRB,5.0091E-08_JPRB,7.3976E-08_JPRB,1.0884E-07_JPRB/)
KBO( :, 2,56, 1) = (/&
&5.7915E-10_JPRB,3.6758E-08_JPRB,7.1316E-08_JPRB,1.0509E-07_JPRB,1.5165E-07_JPRB/)
KBO( :, 3,56, 1) = (/&
&6.2849E-10_JPRB,4.8831E-08_JPRB,9.4465E-08_JPRB,1.3879E-07_JPRB,1.9866E-07_JPRB/)
KBO( :, 4,56, 1) = (/&
&7.3094E-10_JPRB,6.1436E-08_JPRB,1.1839E-07_JPRB,1.7336E-07_JPRB,2.4772E-07_JPRB/)
KBO( :, 5,56, 1) = (/&
&9.1271E-10_JPRB,7.4209E-08_JPRB,1.4210E-07_JPRB,2.0734E-07_JPRB,2.9707E-07_JPRB/)
KBO( :, 1,57, 1) = (/&
&4.7220E-10_JPRB,1.8526E-08_JPRB,3.5969E-08_JPRB,5.3151E-08_JPRB,7.8305E-08_JPRB/)
KBO( :, 2,57, 1) = (/&
&4.6852E-10_JPRB,2.7111E-08_JPRB,5.2630E-08_JPRB,7.7619E-08_JPRB,1.1181E-07_JPRB/)
KBO( :, 3,57, 1) = (/&
&4.9708E-10_JPRB,3.6762E-08_JPRB,7.1191E-08_JPRB,1.0471E-07_JPRB,1.4926E-07_JPRB/)
KBO( :, 4,57, 1) = (/&
&5.6499E-10_JPRB,4.6985E-08_JPRB,9.0692E-08_JPRB,1.3297E-07_JPRB,1.8882E-07_JPRB/)
KBO( :, 5,57, 1) = (/&
&6.9035E-10_JPRB,5.7429E-08_JPRB,1.1024E-07_JPRB,1.6105E-07_JPRB,2.2899E-07_JPRB/)
KBO( :, 1,58, 1) = (/&
&3.9157E-10_JPRB,1.3270E-08_JPRB,2.5747E-08_JPRB,3.8061E-08_JPRB,5.5988E-08_JPRB/)
KBO( :, 2,58, 1) = (/&
&3.8162E-10_JPRB,1.9958E-08_JPRB,3.8768E-08_JPRB,5.7217E-08_JPRB,8.2152E-08_JPRB/)
KBO( :, 3,58, 1) = (/&
&3.9640E-10_JPRB,2.7646E-08_JPRB,5.3592E-08_JPRB,7.8902E-08_JPRB,1.1187E-07_JPRB/)
KBO( :, 4,58, 1) = (/&
&4.4118E-10_JPRB,3.5913E-08_JPRB,6.9407E-08_JPRB,1.0187E-07_JPRB,1.4365E-07_JPRB/)
KBO( :, 5,58, 1) = (/&
&5.2734E-10_JPRB,4.4431E-08_JPRB,8.5459E-08_JPRB,1.2500E-07_JPRB,1.7617E-07_JPRB/)
KBO( :, 1,59, 1) = (/&
&3.2257E-10_JPRB,1.0274E-08_JPRB,1.9927E-08_JPRB,2.9461E-08_JPRB,4.2293E-08_JPRB/)
KBO( :, 2,59, 1) = (/&
&3.1226E-10_JPRB,1.5633E-08_JPRB,3.0371E-08_JPRB,4.4840E-08_JPRB,6.3166E-08_JPRB/)
KBO( :, 3,59, 1) = (/&
&3.2148E-10_JPRB,2.1846E-08_JPRB,4.2369E-08_JPRB,6.2405E-08_JPRB,8.6964E-08_JPRB/)
KBO( :, 4,59, 1) = (/&
&3.5488E-10_JPRB,2.8579E-08_JPRB,5.5262E-08_JPRB,8.1150E-08_JPRB,1.1238E-07_JPRB/)
KBO( :, 5,59, 1) = (/&
&4.2035E-10_JPRB,3.5535E-08_JPRB,6.8411E-08_JPRB,1.0012E-07_JPRB,1.3828E-07_JPRB/)
KBO( :, 1,13, 2) = (/&
&8.0175E-06_JPRB,1.6125E-03_JPRB,3.1478E-03_JPRB,4.6753E-03_JPRB,6.4316E-03_JPRB/)
KBO( :, 2,13, 2) = (/&
&1.0426E-05_JPRB,1.8783E-03_JPRB,3.6140E-03_JPRB,5.3229E-03_JPRB,7.3431E-03_JPRB/)
KBO( :, 3,13, 2) = (/&
&1.4927E-05_JPRB,2.1311E-03_JPRB,4.0477E-03_JPRB,5.8993E-03_JPRB,8.1260E-03_JPRB/)
KBO( :, 4,13, 2) = (/&
&2.2809E-05_JPRB,2.3738E-03_JPRB,4.4493E-03_JPRB,6.4056E-03_JPRB,8.7767E-03_JPRB/)
KBO( :, 5,13, 2) = (/&
&3.5487E-05_JPRB,2.6072E-03_JPRB,4.8181E-03_JPRB,6.8488E-03_JPRB,9.2993E-03_JPRB/)
KBO( :, 1,14, 2) = (/&
&6.7524E-06_JPRB,1.3623E-03_JPRB,2.6470E-03_JPRB,3.9213E-03_JPRB,5.3373E-03_JPRB/)
KBO( :, 2,14, 2) = (/&
&8.8908E-06_JPRB,1.5796E-03_JPRB,3.0298E-03_JPRB,4.4457E-03_JPRB,6.0495E-03_JPRB/)
KBO( :, 3,14, 2) = (/&
&1.2884E-05_JPRB,1.7866E-03_JPRB,3.3866E-03_JPRB,4.9144E-03_JPRB,6.6539E-03_JPRB/)
KBO( :, 4,14, 2) = (/&
&1.9813E-05_JPRB,1.9855E-03_JPRB,3.7147E-03_JPRB,5.3297E-03_JPRB,7.1488E-03_JPRB/)
KBO( :, 5,14, 2) = (/&
&3.0910E-05_JPRB,2.1779E-03_JPRB,4.0162E-03_JPRB,5.6950E-03_JPRB,7.5412E-03_JPRB/)
KBO( :, 1,15, 2) = (/&
&5.7112E-06_JPRB,1.1474E-03_JPRB,2.2216E-03_JPRB,3.2811E-03_JPRB,4.4313E-03_JPRB/)
KBO( :, 2,15, 2) = (/&
&7.6208E-06_JPRB,1.3247E-03_JPRB,2.5364E-03_JPRB,3.7071E-03_JPRB,4.9919E-03_JPRB/)
KBO( :, 3,15, 2) = (/&
&1.1171E-05_JPRB,1.4944E-03_JPRB,2.8273E-03_JPRB,4.0906E-03_JPRB,5.4623E-03_JPRB/)
KBO( :, 4,15, 2) = (/&
&1.7286E-05_JPRB,1.6573E-03_JPRB,3.0948E-03_JPRB,4.4313E-03_JPRB,5.8428E-03_JPRB/)
KBO( :, 5,15, 2) = (/&
&2.7064E-05_JPRB,1.8170E-03_JPRB,3.3404E-03_JPRB,4.7290E-03_JPRB,6.1397E-03_JPRB/)
KBO( :, 1,16, 2) = (/&
&4.8419E-06_JPRB,9.6341E-04_JPRB,1.8620E-03_JPRB,2.7407E-03_JPRB,3.6858E-03_JPRB/)
KBO( :, 2,16, 2) = (/&
&6.5431E-06_JPRB,1.1085E-03_JPRB,2.1191E-03_JPRB,3.0886E-03_JPRB,4.1319E-03_JPRB/)
KBO( :, 3,16, 2) = (/&
&9.6991E-06_JPRB,1.2471E-03_JPRB,2.3556E-03_JPRB,3.4027E-03_JPRB,4.5021E-03_JPRB/)
KBO( :, 4,16, 2) = (/&
&1.5112E-05_JPRB,1.3813E-03_JPRB,2.5735E-03_JPRB,3.6791E-03_JPRB,4.7992E-03_JPRB/)
KBO( :, 5,16, 2) = (/&
&2.3687E-05_JPRB,1.5146E-03_JPRB,2.7739E-03_JPRB,3.9205E-03_JPRB,5.0294E-03_JPRB/)
KBO( :, 1,17, 2) = (/&
&4.1046E-06_JPRB,8.0658E-04_JPRB,1.5568E-03_JPRB,2.2850E-03_JPRB,3.0607E-03_JPRB/)
KBO( :, 2,17, 2) = (/&
&5.6128E-06_JPRB,9.2491E-04_JPRB,1.7657E-03_JPRB,2.5701E-03_JPRB,3.4165E-03_JPRB/)
KBO( :, 3,17, 2) = (/&
&8.4118E-06_JPRB,1.0386E-03_JPRB,1.9589E-03_JPRB,2.8258E-03_JPRB,3.7101E-03_JPRB/)
KBO( :, 4,17, 2) = (/&
&1.3163E-05_JPRB,1.1499E-03_JPRB,2.1360E-03_JPRB,3.0493E-03_JPRB,3.9433E-03_JPRB/)
KBO( :, 5,17, 2) = (/&
&2.0607E-05_JPRB,1.2605E-03_JPRB,2.3001E-03_JPRB,3.2445E-03_JPRB,4.1227E-03_JPRB/)
KBO( :, 1,18, 2) = (/&
&3.4787E-06_JPRB,6.7375E-04_JPRB,1.2987E-03_JPRB,1.9033E-03_JPRB,2.5394E-03_JPRB/)
KBO( :, 2,18, 2) = (/&
&4.8193E-06_JPRB,7.7048E-04_JPRB,1.4690E-03_JPRB,2.1362E-03_JPRB,2.8237E-03_JPRB/)
KBO( :, 3,18, 2) = (/&
&7.2913E-06_JPRB,8.6393E-04_JPRB,1.6256E-03_JPRB,2.3423E-03_JPRB,3.0558E-03_JPRB/)
KBO( :, 4,18, 2) = (/&
&1.1432E-05_JPRB,9.5623E-04_JPRB,1.7704E-03_JPRB,2.5237E-03_JPRB,3.2404E-03_JPRB/)
KBO( :, 5,18, 2) = (/&
&1.7868E-05_JPRB,1.0481E-03_JPRB,1.9053E-03_JPRB,2.6812E-03_JPRB,3.3808E-03_JPRB/)
KBO( :, 1,19, 2) = (/&
&2.9467E-06_JPRB,5.6177E-04_JPRB,1.0818E-03_JPRB,1.5840E-03_JPRB,2.1035E-03_JPRB/)
KBO( :, 2,19, 2) = (/&
&4.1364E-06_JPRB,6.4090E-04_JPRB,1.2199E-03_JPRB,1.7723E-03_JPRB,2.3300E-03_JPRB/)
KBO( :, 3,19, 2) = (/&
&6.2999E-06_JPRB,7.1829E-04_JPRB,1.3476E-03_JPRB,1.9398E-03_JPRB,2.5147E-03_JPRB/)
KBO( :, 4,19, 2) = (/&
&9.8879E-06_JPRB,7.9456E-04_JPRB,1.4667E-03_JPRB,2.0867E-03_JPRB,2.6608E-03_JPRB/)
KBO( :, 5,19, 2) = (/&
&1.5425E-05_JPRB,8.7102E-04_JPRB,1.5773E-03_JPRB,2.2143E-03_JPRB,2.7707E-03_JPRB/)
KBO( :, 1,20, 2) = (/&
&2.5100E-06_JPRB,4.6893E-04_JPRB,9.0169E-04_JPRB,1.3192E-03_JPRB,1.7452E-03_JPRB/)
KBO( :, 2,20, 2) = (/&
&3.5701E-06_JPRB,5.3398E-04_JPRB,1.0139E-03_JPRB,1.4717E-03_JPRB,1.9261E-03_JPRB/)
KBO( :, 3,20, 2) = (/&
&5.4715E-06_JPRB,5.9772E-04_JPRB,1.1181E-03_JPRB,1.6068E-03_JPRB,2.0724E-03_JPRB/)
KBO( :, 4,20, 2) = (/&
&8.5950E-06_JPRB,6.6090E-04_JPRB,1.2157E-03_JPRB,1.7253E-03_JPRB,2.1875E-03_JPRB/)
KBO( :, 5,20, 2) = (/&
&1.3366E-05_JPRB,7.2450E-04_JPRB,1.3064E-03_JPRB,1.8293E-03_JPRB,2.2741E-03_JPRB/)
KBO( :, 1,21, 2) = (/&
&2.1419E-06_JPRB,3.9129E-04_JPRB,7.5108E-04_JPRB,1.0978E-03_JPRB,1.4477E-03_JPRB/)
KBO( :, 2,21, 2) = (/&
&3.0823E-06_JPRB,4.4480E-04_JPRB,8.4226E-04_JPRB,1.2211E-03_JPRB,1.5919E-03_JPRB/)
KBO( :, 3,21, 2) = (/&
&4.7515E-06_JPRB,4.9734E-04_JPRB,9.2759E-04_JPRB,1.3300E-03_JPRB,1.7080E-03_JPRB/)
KBO( :, 4,21, 2) = (/&
&7.4611E-06_JPRB,5.4971E-04_JPRB,1.0075E-03_JPRB,1.4263E-03_JPRB,1.7988E-03_JPRB/)
KBO( :, 5,21, 2) = (/&
&1.1567E-05_JPRB,6.0267E-04_JPRB,1.0819E-03_JPRB,1.5108E-03_JPRB,1.8668E-03_JPRB/)
KBO( :, 1,22, 2) = (/&
&1.8692E-06_JPRB,3.2930E-04_JPRB,6.3020E-04_JPRB,9.1986E-04_JPRB,1.2087E-03_JPRB/)
KBO( :, 2,22, 2) = (/&
&2.7364E-06_JPRB,3.7324E-04_JPRB,7.0426E-04_JPRB,1.0187E-03_JPRB,1.3222E-03_JPRB/)
KBO( :, 3,22, 2) = (/&
&4.2483E-06_JPRB,4.1663E-04_JPRB,7.7378E-04_JPRB,1.1062E-03_JPRB,1.4133E-03_JPRB/)
KBO( :, 4,22, 2) = (/&
&6.6614E-06_JPRB,4.6001E-04_JPRB,8.3899E-04_JPRB,1.1837E-03_JPRB,1.4836E-03_JPRB/)
KBO( :, 5,22, 2) = (/&
&1.0283E-05_JPRB,5.0444E-04_JPRB,8.9986E-04_JPRB,1.2517E-03_JPRB,1.5358E-03_JPRB/)
KBO( :, 1,23, 2) = (/&
&1.6399E-06_JPRB,2.7719E-04_JPRB,5.2862E-04_JPRB,7.7027E-04_JPRB,1.0088E-03_JPRB/)
KBO( :, 2,23, 2) = (/&
&2.4391E-06_JPRB,3.1328E-04_JPRB,5.8895E-04_JPRB,8.4951E-04_JPRB,1.0980E-03_JPRB/)
KBO( :, 3,23, 2) = (/&
&3.8063E-06_JPRB,3.4908E-04_JPRB,6.4555E-04_JPRB,9.1997E-04_JPRB,1.1688E-03_JPRB/)
KBO( :, 4,23, 2) = (/&
&5.9548E-06_JPRB,3.8523E-04_JPRB,6.9879E-04_JPRB,9.8233E-04_JPRB,1.2233E-03_JPRB/)
KBO( :, 5,23, 2) = (/&
&9.1467E-06_JPRB,4.2262E-04_JPRB,7.4870E-04_JPRB,1.0371E-03_JPRB,1.2635E-03_JPRB/)
KBO( :, 1,24, 2) = (/&
&1.4486E-06_JPRB,2.3343E-04_JPRB,4.4362E-04_JPRB,6.4490E-04_JPRB,8.4150E-04_JPRB/)
KBO( :, 2,24, 2) = (/&
&2.1847E-06_JPRB,2.6312E-04_JPRB,4.9268E-04_JPRB,7.0858E-04_JPRB,9.1131E-04_JPRB/)
KBO( :, 3,24, 2) = (/&
&3.4199E-06_JPRB,2.9273E-04_JPRB,5.3880E-04_JPRB,7.6525E-04_JPRB,9.6646E-04_JPRB/)
KBO( :, 4,24, 2) = (/&
&5.3366E-06_JPRB,3.2305E-04_JPRB,5.8221E-04_JPRB,8.1539E-04_JPRB,1.0083E-03_JPRB/)
KBO( :, 5,24, 2) = (/&
&8.1557E-06_JPRB,3.5422E-04_JPRB,6.2350E-04_JPRB,8.5963E-04_JPRB,1.0390E-03_JPRB/)
KBO( :, 1,25, 2) = (/&
&1.2896E-06_JPRB,1.9674E-04_JPRB,3.7250E-04_JPRB,5.4009E-04_JPRB,7.0204E-04_JPRB/)
KBO( :, 2,25, 2) = (/&
&1.9685E-06_JPRB,2.2117E-04_JPRB,4.1236E-04_JPRB,5.9119E-04_JPRB,7.5627E-04_JPRB/)
KBO( :, 3,25, 2) = (/&
&3.0862E-06_JPRB,2.4587E-04_JPRB,4.4997E-04_JPRB,6.3678E-04_JPRB,7.9915E-04_JPRB/)
KBO( :, 4,25, 2) = (/&
&4.8005E-06_JPRB,2.7122E-04_JPRB,4.8550E-04_JPRB,6.7707E-04_JPRB,8.3122E-04_JPRB/)
KBO( :, 5,25, 2) = (/&
&7.2939E-06_JPRB,2.9701E-04_JPRB,5.1977E-04_JPRB,7.1279E-04_JPRB,8.5451E-04_JPRB/)
KBO( :, 1,26, 2) = (/&
&1.1608E-06_JPRB,1.6612E-04_JPRB,3.1323E-04_JPRB,4.5281E-04_JPRB,5.8594E-04_JPRB/)
KBO( :, 2,26, 2) = (/&
&1.7905E-06_JPRB,1.8633E-04_JPRB,3.4562E-04_JPRB,4.9378E-04_JPRB,6.2806E-04_JPRB/)
KBO( :, 3,26, 2) = (/&
&2.8083E-06_JPRB,2.0700E-04_JPRB,3.7628E-04_JPRB,5.3030E-04_JPRB,6.6095E-04_JPRB/)
KBO( :, 4,26, 2) = (/&
&4.3494E-06_JPRB,2.2796E-04_JPRB,4.0557E-04_JPRB,5.6268E-04_JPRB,6.8538E-04_JPRB/)
KBO( :, 5,26, 2) = (/&
&6.5643E-06_JPRB,2.4920E-04_JPRB,4.3382E-04_JPRB,5.9177E-04_JPRB,7.0285E-04_JPRB/)
KBO( :, 1,27, 2) = (/&
&1.0500E-06_JPRB,1.4026E-04_JPRB,2.6331E-04_JPRB,3.7943E-04_JPRB,4.8869E-04_JPRB/)
KBO( :, 2,27, 2) = (/&
&1.6326E-06_JPRB,1.5709E-04_JPRB,2.8964E-04_JPRB,4.1228E-04_JPRB,5.2142E-04_JPRB/)
KBO( :, 3,27, 2) = (/&
&2.5571E-06_JPRB,1.7422E-04_JPRB,3.1477E-04_JPRB,4.4154E-04_JPRB,5.4660E-04_JPRB/)
KBO( :, 4,27, 2) = (/&
&3.9402E-06_JPRB,1.9156E-04_JPRB,3.3894E-04_JPRB,4.6764E-04_JPRB,5.6523E-04_JPRB/)
KBO( :, 5,27, 2) = (/&
&5.9052E-06_JPRB,2.0883E-04_JPRB,3.6207E-04_JPRB,4.9151E-04_JPRB,5.7833E-04_JPRB/)
KBO( :, 1,28, 2) = (/&
&9.5343E-07_JPRB,1.1844E-04_JPRB,2.2122E-04_JPRB,3.1775E-04_JPRB,4.0735E-04_JPRB/)
KBO( :, 2,28, 2) = (/&
&1.4904E-06_JPRB,1.3245E-04_JPRB,2.4271E-04_JPRB,3.4408E-04_JPRB,4.3267E-04_JPRB/)
KBO( :, 3,28, 2) = (/&
&2.3285E-06_JPRB,1.4658E-04_JPRB,2.6343E-04_JPRB,3.6757E-04_JPRB,4.5198E-04_JPRB/)
KBO( :, 4,28, 2) = (/&
&3.5672E-06_JPRB,1.6074E-04_JPRB,2.8315E-04_JPRB,3.8877E-04_JPRB,4.6611E-04_JPRB/)
KBO( :, 5,28, 2) = (/&
&5.3086E-06_JPRB,1.7472E-04_JPRB,3.0190E-04_JPRB,4.0830E-04_JPRB,4.7586E-04_JPRB/)
KBO( :, 1,29, 2) = (/&
&8.7130E-07_JPRB,1.0013E-04_JPRB,1.8593E-04_JPRB,2.6607E-04_JPRB,3.3959E-04_JPRB/)
KBO( :, 2,29, 2) = (/&
&1.3662E-06_JPRB,1.1169E-04_JPRB,2.0357E-04_JPRB,2.8717E-04_JPRB,3.5915E-04_JPRB/)
KBO( :, 3,29, 2) = (/&
&2.1272E-06_JPRB,1.2329E-04_JPRB,2.2053E-04_JPRB,3.0613E-04_JPRB,3.7392E-04_JPRB/)
KBO( :, 4,29, 2) = (/&
&3.2367E-06_JPRB,1.3475E-04_JPRB,2.3655E-04_JPRB,3.2340E-04_JPRB,3.8475E-04_JPRB/)
KBO( :, 5,29, 2) = (/&
&4.7798E-06_JPRB,1.4613E-04_JPRB,2.5163E-04_JPRB,3.3924E-04_JPRB,3.9199E-04_JPRB/)
KBO( :, 1,30, 2) = (/&
&7.9857E-07_JPRB,8.4615E-05_JPRB,1.5625E-04_JPRB,2.2266E-04_JPRB,2.8295E-04_JPRB/)
KBO( :, 2,30, 2) = (/&
&1.2528E-06_JPRB,9.4125E-05_JPRB,1.7078E-04_JPRB,2.3961E-04_JPRB,2.9806E-04_JPRB/)
KBO( :, 3,30, 2) = (/&
&1.9419E-06_JPRB,1.0355E-04_JPRB,1.8452E-04_JPRB,2.5499E-04_JPRB,3.0943E-04_JPRB/)
KBO( :, 4,30, 2) = (/&
&2.9342E-06_JPRB,1.1289E-04_JPRB,1.9751E-04_JPRB,2.6906E-04_JPRB,3.1766E-04_JPRB/)
KBO( :, 5,30, 2) = (/&
&4.2987E-06_JPRB,1.2210E-04_JPRB,2.0947E-04_JPRB,2.8172E-04_JPRB,3.2307E-04_JPRB/)
KBO( :, 1,31, 2) = (/&
&7.3491E-07_JPRB,7.1470E-05_JPRB,1.3139E-04_JPRB,1.8630E-04_JPRB,2.3588E-04_JPRB/)
KBO( :, 2,31, 2) = (/&
&1.1514E-06_JPRB,7.9261E-05_JPRB,1.4322E-04_JPRB,1.9997E-04_JPRB,2.4758E-04_JPRB/)
KBO( :, 3,31, 2) = (/&
&1.7751E-06_JPRB,8.6934E-05_JPRB,1.5438E-04_JPRB,2.1250E-04_JPRB,2.5633E-04_JPRB/)
KBO( :, 4,31, 2) = (/&
&2.6619E-06_JPRB,9.4503E-05_JPRB,1.6470E-04_JPRB,2.2379E-04_JPRB,2.6262E-04_JPRB/)
KBO( :, 5,31, 2) = (/&
&3.8682E-06_JPRB,1.0203E-04_JPRB,1.7422E-04_JPRB,2.3379E-04_JPRB,2.6667E-04_JPRB/)
KBO( :, 1,32, 2) = (/&
&6.7761E-07_JPRB,6.0344E-05_JPRB,1.1046E-04_JPRB,1.5585E-04_JPRB,1.9661E-04_JPRB/)
KBO( :, 2,32, 2) = (/&
&1.0588E-06_JPRB,6.6689E-05_JPRB,1.2006E-04_JPRB,1.6697E-04_JPRB,2.0563E-04_JPRB/)
KBO( :, 3,32, 2) = (/&
&1.6222E-06_JPRB,7.2918E-05_JPRB,1.2900E-04_JPRB,1.7702E-04_JPRB,2.1238E-04_JPRB/)
KBO( :, 4,32, 2) = (/&
&2.4128E-06_JPRB,7.9073E-05_JPRB,1.3719E-04_JPRB,1.8602E-04_JPRB,2.1720E-04_JPRB/)
KBO( :, 5,32, 2) = (/&
&3.4779E-06_JPRB,8.5263E-05_JPRB,1.4481E-04_JPRB,1.9388E-04_JPRB,2.2025E-04_JPRB/)
KBO( :, 1,33, 2) = (/&
&6.2527E-07_JPRB,5.0902E-05_JPRB,9.2812E-05_JPRB,1.3037E-04_JPRB,1.6382E-04_JPRB/)
KBO( :, 2,33, 2) = (/&
&9.7334E-07_JPRB,5.6048E-05_JPRB,1.0055E-04_JPRB,1.3935E-04_JPRB,1.7082E-04_JPRB/)
KBO( :, 3,33, 2) = (/&
&1.4801E-06_JPRB,6.1101E-05_JPRB,1.0766E-04_JPRB,1.4740E-04_JPRB,1.7611E-04_JPRB/)
KBO( :, 4,33, 2) = (/&
&2.1838E-06_JPRB,6.6144E-05_JPRB,1.1420E-04_JPRB,1.5452E-04_JPRB,1.7978E-04_JPRB/)
KBO( :, 5,33, 2) = (/&
&3.1224E-06_JPRB,7.1225E-05_JPRB,1.2030E-04_JPRB,1.6062E-04_JPRB,1.8204E-04_JPRB/)
KBO( :, 1,34, 2) = (/&
&5.6731E-07_JPRB,4.2730E-05_JPRB,7.7685E-05_JPRB,1.0877E-04_JPRB,1.3615E-04_JPRB/)
KBO( :, 2,34, 2) = (/&
&8.7950E-07_JPRB,4.6905E-05_JPRB,8.3883E-05_JPRB,1.1598E-04_JPRB,1.4163E-04_JPRB/)
KBO( :, 3,34, 2) = (/&
&1.3287E-06_JPRB,5.1034E-05_JPRB,8.9565E-05_JPRB,1.2242E-04_JPRB,1.4574E-04_JPRB/)
KBO( :, 4,34, 2) = (/&
&1.9464E-06_JPRB,5.5143E-05_JPRB,9.4797E-05_JPRB,1.2801E-04_JPRB,1.4856E-04_JPRB/)
KBO( :, 5,34, 2) = (/&
&2.7640E-06_JPRB,5.9346E-05_JPRB,9.9732E-05_JPRB,1.3280E-04_JPRB,1.5030E-04_JPRB/)
KBO( :, 1,35, 2) = (/&
&4.9270E-07_JPRB,3.5501E-05_JPRB,6.4454E-05_JPRB,9.0102E-05_JPRB,1.1262E-04_JPRB/)
KBO( :, 2,35, 2) = (/&
&7.6173E-07_JPRB,3.8902E-05_JPRB,6.9450E-05_JPRB,9.5970E-05_JPRB,1.1707E-04_JPRB/)
KBO( :, 3,35, 2) = (/&
&1.1464E-06_JPRB,4.2272E-05_JPRB,7.4027E-05_JPRB,1.0112E-04_JPRB,1.2036E-04_JPRB/)
KBO( :, 4,35, 2) = (/&
&1.6726E-06_JPRB,4.5640E-05_JPRB,7.8266E-05_JPRB,1.0556E-04_JPRB,1.2264E-04_JPRB/)
KBO( :, 5,35, 2) = (/&
&2.3658E-06_JPRB,4.9091E-05_JPRB,8.2279E-05_JPRB,1.0938E-04_JPRB,1.2407E-04_JPRB/)
KBO( :, 1,36, 2) = (/&
&4.0753E-07_JPRB,2.9178E-05_JPRB,5.2991E-05_JPRB,7.4090E-05_JPRB,9.2739E-05_JPRB/)
KBO( :, 2,36, 2) = (/&
&6.2965E-07_JPRB,3.1953E-05_JPRB,5.7057E-05_JPRB,7.8888E-05_JPRB,9.6418E-05_JPRB/)
KBO( :, 3,36, 2) = (/&
&9.4705E-07_JPRB,3.4706E-05_JPRB,6.0784E-05_JPRB,8.3065E-05_JPRB,9.9161E-05_JPRB/)
KBO( :, 4,36, 2) = (/&
&1.3808E-06_JPRB,3.7469E-05_JPRB,6.4241E-05_JPRB,8.6658E-05_JPRB,1.0108E-04_JPRB/)
KBO( :, 5,36, 2) = (/&
&1.9520E-06_JPRB,4.0294E-05_JPRB,6.7509E-05_JPRB,8.9744E-05_JPRB,1.0229E-04_JPRB/)
KBO( :, 1,37, 2) = (/&
&3.1476E-07_JPRB,2.3629E-05_JPRB,4.3024E-05_JPRB,6.0274E-05_JPRB,7.5761E-05_JPRB/)
KBO( :, 2,37, 2) = (/&
&4.8773E-07_JPRB,2.5900E-05_JPRB,4.6378E-05_JPRB,6.4261E-05_JPRB,7.8929E-05_JPRB/)
KBO( :, 3,37, 2) = (/&
&7.3652E-07_JPRB,2.8152E-05_JPRB,4.9455E-05_JPRB,6.7730E-05_JPRB,8.1326E-05_JPRB/)
KBO( :, 4,37, 2) = (/&
&1.0783E-06_JPRB,3.0411E-05_JPRB,5.2306E-05_JPRB,7.0712E-05_JPRB,8.3006E-05_JPRB/)
KBO( :, 5,37, 2) = (/&
&1.5305E-06_JPRB,3.2717E-05_JPRB,5.4998E-05_JPRB,7.3285E-05_JPRB,8.4133E-05_JPRB/)
KBO( :, 1,38, 2) = (/&
&2.4210E-07_JPRB,1.9112E-05_JPRB,3.4895E-05_JPRB,4.8985E-05_JPRB,6.1887E-05_JPRB/)
KBO( :, 2,38, 2) = (/&
&3.7627E-07_JPRB,2.0975E-05_JPRB,3.7671E-05_JPRB,5.2313E-05_JPRB,6.4617E-05_JPRB/)
KBO( :, 3,38, 2) = (/&
&5.7052E-07_JPRB,2.2818E-05_JPRB,4.0210E-05_JPRB,5.5193E-05_JPRB,6.6701E-05_JPRB/)
KBO( :, 4,38, 2) = (/&
&8.3911E-07_JPRB,2.4669E-05_JPRB,4.2570E-05_JPRB,5.7682E-05_JPRB,6.8211E-05_JPRB/)
KBO( :, 5,38, 2) = (/&
&1.1958E-06_JPRB,2.6548E-05_JPRB,4.4784E-05_JPRB,5.9818E-05_JPRB,6.9237E-05_JPRB/)
KBO( :, 1,39, 2) = (/&
&1.8625E-07_JPRB,1.5459E-05_JPRB,2.8298E-05_JPRB,3.9805E-05_JPRB,5.0586E-05_JPRB/)
KBO( :, 2,39, 2) = (/&
&2.9016E-07_JPRB,1.6986E-05_JPRB,3.0594E-05_JPRB,4.2577E-05_JPRB,5.2943E-05_JPRB/)
KBO( :, 3,39, 2) = (/&
&4.4173E-07_JPRB,1.8495E-05_JPRB,3.2693E-05_JPRB,4.4970E-05_JPRB,5.4767E-05_JPRB/)
KBO( :, 4,39, 2) = (/&
&6.5253E-07_JPRB,2.0005E-05_JPRB,3.4636E-05_JPRB,4.7036E-05_JPRB,5.6106E-05_JPRB/)
KBO( :, 5,39, 2) = (/&
&9.3398E-07_JPRB,2.1545E-05_JPRB,3.6467E-05_JPRB,4.8821E-05_JPRB,5.7052E-05_JPRB/)
KBO( :, 1,40, 2) = (/&
&1.3668E-07_JPRB,1.2370E-05_JPRB,2.2736E-05_JPRB,3.2075E-05_JPRB,4.1000E-05_JPRB/)
KBO( :, 2,40, 2) = (/&
&2.1371E-07_JPRB,1.3625E-05_JPRB,2.4652E-05_JPRB,3.4419E-05_JPRB,4.3071E-05_JPRB/)
KBO( :, 3,40, 2) = (/&
&3.2755E-07_JPRB,1.4863E-05_JPRB,2.6404E-05_JPRB,3.6442E-05_JPRB,4.4686E-05_JPRB/)
KBO( :, 4,40, 2) = (/&
&4.8754E-07_JPRB,1.6102E-05_JPRB,2.8025E-05_JPRB,3.8191E-05_JPRB,4.5890E-05_JPRB/)
KBO( :, 5,40, 2) = (/&
&7.0305E-07_JPRB,1.7351E-05_JPRB,2.9541E-05_JPRB,3.9702E-05_JPRB,4.6757E-05_JPRB/)
KBO( :, 1,41, 2) = (/&
&9.9669E-08_JPRB,9.8770E-06_JPRB,1.8228E-05_JPRB,2.5797E-05_JPRB,3.3169E-05_JPRB/)
KBO( :, 2,41, 2) = (/&
&1.5628E-07_JPRB,1.0911E-05_JPRB,1.9833E-05_JPRB,2.7783E-05_JPRB,3.4989E-05_JPRB/)
KBO( :, 3,41, 2) = (/&
&2.4106E-07_JPRB,1.1926E-05_JPRB,2.1297E-05_JPRB,2.9495E-05_JPRB,3.6412E-05_JPRB/)
KBO( :, 4,41, 2) = (/&
&3.6163E-07_JPRB,1.2938E-05_JPRB,2.2645E-05_JPRB,3.0975E-05_JPRB,3.7495E-05_JPRB/)
KBO( :, 5,41, 2) = (/&
&5.2576E-07_JPRB,1.3959E-05_JPRB,2.3909E-05_JPRB,3.2258E-05_JPRB,3.8288E-05_JPRB/)
KBO( :, 1,42, 2) = (/&
&7.2678E-08_JPRB,7.8801E-06_JPRB,1.4600E-05_JPRB,2.0724E-05_JPRB,2.6808E-05_JPRB/)
KBO( :, 2,42, 2) = (/&
&1.1413E-07_JPRB,8.7322E-06_JPRB,1.5944E-05_JPRB,2.2404E-05_JPRB,2.8406E-05_JPRB/)
KBO( :, 3,42, 2) = (/&
&1.7705E-07_JPRB,9.5648E-06_JPRB,1.7165E-05_JPRB,2.3855E-05_JPRB,2.9660E-05_JPRB/)
KBO( :, 4,42, 2) = (/&
&2.6763E-07_JPRB,1.0394E-05_JPRB,1.8292E-05_JPRB,2.5108E-05_JPRB,3.0631E-05_JPRB/)
KBO( :, 5,42, 2) = (/&
&3.9231E-07_JPRB,1.1225E-05_JPRB,1.9340E-05_JPRB,2.6194E-05_JPRB,3.1357E-05_JPRB/)
KBO( :, 1,43, 2) = (/&
&5.1710E-08_JPRB,6.2405E-06_JPRB,1.1615E-05_JPRB,1.6545E-05_JPRB,2.1547E-05_JPRB/)
KBO( :, 2,43, 2) = (/&
&8.1128E-08_JPRB,6.9428E-06_JPRB,1.2742E-05_JPRB,1.7971E-05_JPRB,2.2964E-05_JPRB/)
KBO( :, 3,43, 2) = (/&
&1.2657E-07_JPRB,7.6287E-06_JPRB,1.3773E-05_JPRB,1.9217E-05_JPRB,2.4086E-05_JPRB/)
KBO( :, 4,43, 2) = (/&
&1.9308E-07_JPRB,8.3079E-06_JPRB,1.4717E-05_JPRB,2.0287E-05_JPRB,2.4962E-05_JPRB/)
KBO( :, 5,43, 2) = (/&
&2.8583E-07_JPRB,8.9896E-06_JPRB,1.5595E-05_JPRB,2.1216E-05_JPRB,2.5632E-05_JPRB/)
KBO( :, 1,44, 2) = (/&
&3.6495E-08_JPRB,4.9199E-06_JPRB,9.1989E-06_JPRB,1.3152E-05_JPRB,1.7255E-05_JPRB/)
KBO( :, 2,44, 2) = (/&
&5.6951E-08_JPRB,5.5005E-06_JPRB,1.0149E-05_JPRB,1.4368E-05_JPRB,1.8514E-05_JPRB/)
KBO( :, 3,44, 2) = (/&
&8.9239E-08_JPRB,6.0652E-06_JPRB,1.1016E-05_JPRB,1.5437E-05_JPRB,1.9519E-05_JPRB/)
KBO( :, 4,44, 2) = (/&
&1.3737E-07_JPRB,6.6226E-06_JPRB,1.1811E-05_JPRB,1.6355E-05_JPRB,2.0314E-05_JPRB/)
KBO( :, 5,44, 2) = (/&
&2.0554E-07_JPRB,7.1784E-06_JPRB,1.2547E-05_JPRB,1.7152E-05_JPRB,2.0929E-05_JPRB/)
KBO( :, 1,45, 2) = (/&
&2.5907E-08_JPRB,3.8721E-06_JPRB,7.2719E-06_JPRB,1.0434E-05_JPRB,1.3790E-05_JPRB/)
KBO( :, 2,45, 2) = (/&
&3.9986E-08_JPRB,4.3511E-06_JPRB,8.0697E-06_JPRB,1.1466E-05_JPRB,1.4905E-05_JPRB/)
KBO( :, 3,45, 2) = (/&
&6.2804E-08_JPRB,4.8176E-06_JPRB,8.8015E-06_JPRB,1.2382E-05_JPRB,1.5806E-05_JPRB/)
KBO( :, 4,45, 2) = (/&
&9.7423E-08_JPRB,5.2749E-06_JPRB,9.4698E-06_JPRB,1.3171E-05_JPRB,1.6523E-05_JPRB/)
KBO( :, 5,45, 2) = (/&
&1.4724E-07_JPRB,5.7306E-06_JPRB,1.0089E-05_JPRB,1.3855E-05_JPRB,1.7089E-05_JPRB/)
KBO( :, 1,46, 2) = (/&
&1.8373E-08_JPRB,3.0320E-06_JPRB,5.7197E-06_JPRB,8.2358E-06_JPRB,1.0971E-05_JPRB/)
KBO( :, 2,46, 2) = (/&
&2.7848E-08_JPRB,3.4277E-06_JPRB,6.3901E-06_JPRB,9.1142E-06_JPRB,1.1956E-05_JPRB/)
KBO( :, 3,46, 2) = (/&
&4.3687E-08_JPRB,3.8134E-06_JPRB,7.0085E-06_JPRB,9.9001E-06_JPRB,1.2766E-05_JPRB/)
KBO( :, 4,46, 2) = (/&
&6.8194E-08_JPRB,4.1901E-06_JPRB,7.5729E-06_JPRB,1.0581E-05_JPRB,1.3413E-05_JPRB/)
KBO( :, 5,46, 2) = (/&
&1.0416E-07_JPRB,4.5633E-06_JPRB,8.0938E-06_JPRB,1.1169E-05_JPRB,1.3933E-05_JPRB/)
KBO( :, 1,47, 2) = (/&
&1.2986E-08_JPRB,2.3533E-06_JPRB,4.4615E-06_JPRB,6.4491E-06_JPRB,8.6543E-06_JPRB/)
KBO( :, 2,47, 2) = (/&
&1.9128E-08_JPRB,2.6815E-06_JPRB,5.0257E-06_JPRB,7.1971E-06_JPRB,9.5261E-06_JPRB/)
KBO( :, 3,47, 2) = (/&
&2.9772E-08_JPRB,3.0001E-06_JPRB,5.5492E-06_JPRB,7.8735E-06_JPRB,1.0255E-05_JPRB/)
KBO( :, 4,47, 2) = (/&
&4.6702E-08_JPRB,3.3116E-06_JPRB,6.0282E-06_JPRB,8.4652E-06_JPRB,1.0843E-05_JPRB/)
KBO( :, 5,47, 2) = (/&
&7.2070E-08_JPRB,3.6175E-06_JPRB,6.4678E-06_JPRB,8.9726E-06_JPRB,1.1318E-05_JPRB/)
KBO( :, 1,48, 2) = (/&
&9.3416E-09_JPRB,1.8200E-06_JPRB,3.4670E-06_JPRB,5.0294E-06_JPRB,6.7990E-06_JPRB/)
KBO( :, 2,48, 2) = (/&
&1.3255E-08_JPRB,2.0919E-06_JPRB,3.9405E-06_JPRB,5.6643E-06_JPRB,7.5695E-06_JPRB/)
KBO( :, 3,48, 2) = (/&
&2.0305E-08_JPRB,2.3557E-06_JPRB,4.3829E-06_JPRB,6.2449E-06_JPRB,8.2237E-06_JPRB/)
KBO( :, 4,48, 2) = (/&
&3.1895E-08_JPRB,2.6129E-06_JPRB,4.7893E-06_JPRB,6.7563E-06_JPRB,8.7563E-06_JPRB/)
KBO( :, 5,48, 2) = (/&
&4.9634E-08_JPRB,2.8647E-06_JPRB,5.1614E-06_JPRB,7.1978E-06_JPRB,9.1908E-06_JPRB/)
KBO( :, 1,49, 2) = (/&
&6.8359E-09_JPRB,1.4019E-06_JPRB,2.6826E-06_JPRB,3.9057E-06_JPRB,5.3233E-06_JPRB/)
KBO( :, 2,49, 2) = (/&
&9.2996E-09_JPRB,1.6269E-06_JPRB,3.0793E-06_JPRB,4.4431E-06_JPRB,6.0005E-06_JPRB/)
KBO( :, 3,49, 2) = (/&
&1.3902E-08_JPRB,1.8452E-06_JPRB,3.4523E-06_JPRB,4.9386E-06_JPRB,6.5835E-06_JPRB/)
KBO( :, 4,49, 2) = (/&
&2.1742E-08_JPRB,2.0580E-06_JPRB,3.7970E-06_JPRB,5.3806E-06_JPRB,7.0678E-06_JPRB/)
KBO( :, 5,49, 2) = (/&
&3.4035E-08_JPRB,2.2660E-06_JPRB,4.1122E-06_JPRB,5.7639E-06_JPRB,7.4641E-06_JPRB/)
KBO( :, 1,50, 2) = (/&
&5.1178E-09_JPRB,1.0792E-06_JPRB,2.0739E-06_JPRB,3.0301E-06_JPRB,4.1532E-06_JPRB/)
KBO( :, 2,50, 2) = (/&
&6.6862E-09_JPRB,1.2653E-06_JPRB,2.4055E-06_JPRB,3.4823E-06_JPRB,4.7385E-06_JPRB/)
KBO( :, 3,50, 2) = (/&
&9.6897E-09_JPRB,1.4463E-06_JPRB,2.7192E-06_JPRB,3.9039E-06_JPRB,5.2519E-06_JPRB/)
KBO( :, 4,50, 2) = (/&
&1.4989E-08_JPRB,1.6221E-06_JPRB,3.0101E-06_JPRB,4.2829E-06_JPRB,5.6841E-06_JPRB/)
KBO( :, 5,50, 2) = (/&
&2.3540E-08_JPRB,1.7939E-06_JPRB,3.2769E-06_JPRB,4.6145E-06_JPRB,6.0402E-06_JPRB/)
KBO( :, 1,51, 2) = (/&
&3.8928E-09_JPRB,8.2870E-07_JPRB,1.5995E-06_JPRB,2.3444E-06_JPRB,3.2274E-06_JPRB/)
KBO( :, 2,51, 2) = (/&
&4.8976E-09_JPRB,9.8251E-07_JPRB,1.8756E-06_JPRB,2.7234E-06_JPRB,3.7274E-06_JPRB/)
KBO( :, 3,51, 2) = (/&
&6.8457E-09_JPRB,1.1323E-06_JPRB,2.1385E-06_JPRB,3.0800E-06_JPRB,4.1752E-06_JPRB/)
KBO( :, 4,51, 2) = (/&
&1.0404E-08_JPRB,1.2777E-06_JPRB,2.3837E-06_JPRB,3.4044E-06_JPRB,4.5574E-06_JPRB/)
KBO( :, 5,51, 2) = (/&
&1.6329E-08_JPRB,1.4195E-06_JPRB,2.6091E-06_JPRB,3.6893E-06_JPRB,4.8743E-06_JPRB/)
KBO( :, 1,52, 2) = (/&
&3.0020E-09_JPRB,6.3363E-07_JPRB,1.2279E-06_JPRB,1.8052E-06_JPRB,2.4975E-06_JPRB/)
KBO( :, 2,52, 2) = (/&
&3.6400E-09_JPRB,7.6019E-07_JPRB,1.4569E-06_JPRB,2.1220E-06_JPRB,2.9231E-06_JPRB/)
KBO( :, 3,52, 2) = (/&
&4.8925E-09_JPRB,8.8432E-07_JPRB,1.6773E-06_JPRB,2.4234E-06_JPRB,3.3127E-06_JPRB/)
KBO( :, 4,52, 2) = (/&
&7.2540E-09_JPRB,1.0045E-06_JPRB,1.8834E-06_JPRB,2.6996E-06_JPRB,3.6485E-06_JPRB/)
KBO( :, 5,52, 2) = (/&
&1.1316E-08_JPRB,1.1218E-06_JPRB,2.0739E-06_JPRB,2.9444E-06_JPRB,3.9318E-06_JPRB/)
KBO( :, 1,53, 2) = (/&
&2.3480E-09_JPRB,4.8194E-07_JPRB,9.3751E-07_JPRB,1.3817E-06_JPRB,1.9236E-06_JPRB/)
KBO( :, 2,53, 2) = (/&
&2.7431E-09_JPRB,5.8562E-07_JPRB,1.1268E-06_JPRB,1.6465E-06_JPRB,2.2857E-06_JPRB/)
KBO( :, 3,53, 2) = (/&
&3.5464E-09_JPRB,6.8845E-07_JPRB,1.3110E-06_JPRB,1.8999E-06_JPRB,2.6221E-06_JPRB/)
KBO( :, 4,53, 2) = (/&
&5.0907E-09_JPRB,7.8797E-07_JPRB,1.4844E-06_JPRB,2.1348E-06_JPRB,2.9184E-06_JPRB/)
KBO( :, 5,53, 2) = (/&
&7.8410E-09_JPRB,8.8479E-07_JPRB,1.6450E-06_JPRB,2.3447E-06_JPRB,3.1713E-06_JPRB/)
KBO( :, 1,54, 2) = (/&
&1.8594E-09_JPRB,3.6706E-07_JPRB,7.1625E-07_JPRB,1.0575E-06_JPRB,1.4721E-06_JPRB/)
KBO( :, 2,54, 2) = (/&
&2.1055E-09_JPRB,4.5181E-07_JPRB,8.7256E-07_JPRB,1.2786E-06_JPRB,1.7762E-06_JPRB/)
KBO( :, 3,54, 2) = (/&
&2.6291E-09_JPRB,5.3666E-07_JPRB,1.0257E-06_JPRB,1.4904E-06_JPRB,2.0598E-06_JPRB/)
KBO( :, 4,54, 2) = (/&
&3.6482E-09_JPRB,6.1906E-07_JPRB,1.1709E-06_JPRB,1.6887E-06_JPRB,2.3147E-06_JPRB/)
KBO( :, 5,54, 2) = (/&
&5.5210E-09_JPRB,6.9901E-07_JPRB,1.3059E-06_JPRB,1.8680E-06_JPRB,2.5342E-06_JPRB/)
KBO( :, 1,55, 2) = (/&
&1.4849E-09_JPRB,2.7894E-07_JPRB,5.4560E-07_JPRB,8.0660E-07_JPRB,1.1188E-06_JPRB/)
KBO( :, 2,55, 2) = (/&
&1.6383E-09_JPRB,3.4819E-07_JPRB,6.7462E-07_JPRB,9.9127E-07_JPRB,1.3721E-06_JPRB/)
KBO( :, 3,55, 2) = (/&
&1.9800E-09_JPRB,4.1799E-07_JPRB,8.0161E-07_JPRB,1.1677E-06_JPRB,1.6084E-06_JPRB/)
KBO( :, 4,55, 2) = (/&
&2.6536E-09_JPRB,4.8615E-07_JPRB,9.2306E-07_JPRB,1.3349E-06_JPRB,1.8249E-06_JPRB/)
KBO( :, 5,55, 2) = (/&
&3.9260E-09_JPRB,5.5226E-07_JPRB,1.0363E-06_JPRB,1.4870E-06_JPRB,2.0117E-06_JPRB/)
KBO( :, 1,56, 2) = (/&
&1.1936E-09_JPRB,2.1075E-07_JPRB,4.1302E-07_JPRB,6.1132E-07_JPRB,8.4513E-07_JPRB/)
KBO( :, 2,56, 2) = (/&
&1.2886E-09_JPRB,2.6729E-07_JPRB,5.1942E-07_JPRB,7.6519E-07_JPRB,1.0555E-06_JPRB/)
KBO( :, 3,56, 2) = (/&
&1.5077E-09_JPRB,3.2455E-07_JPRB,6.2452E-07_JPRB,9.1202E-07_JPRB,1.2523E-06_JPRB/)
KBO( :, 4,56, 2) = (/&
&1.9525E-09_JPRB,3.8098E-07_JPRB,7.2592E-07_JPRB,1.0524E-06_JPRB,1.4345E-06_JPRB/)
KBO( :, 5,56, 2) = (/&
&2.8077E-09_JPRB,4.3561E-07_JPRB,8.2084E-07_JPRB,1.1815E-06_JPRB,1.5940E-06_JPRB/)
KBO( :, 1,57, 2) = (/&
&9.6583E-10_JPRB,1.5815E-07_JPRB,3.1044E-07_JPRB,4.6005E-07_JPRB,6.3408E-07_JPRB/)
KBO( :, 2,57, 2) = (/&
&1.0215E-09_JPRB,2.0426E-07_JPRB,3.9810E-07_JPRB,5.8767E-07_JPRB,8.0766E-07_JPRB/)
KBO( :, 3,57, 2) = (/&
&1.1597E-09_JPRB,2.5112E-07_JPRB,4.8491E-07_JPRB,7.0984E-07_JPRB,9.7174E-07_JPRB/)
KBO( :, 4,57, 2) = (/&
&1.4523E-09_JPRB,2.9779E-07_JPRB,5.6934E-07_JPRB,8.2739E-07_JPRB,1.1242E-06_JPRB/)
KBO( :, 5,57, 2) = (/&
&2.0219E-09_JPRB,3.4296E-07_JPRB,6.4886E-07_JPRB,9.3651E-07_JPRB,1.2602E-06_JPRB/)
KBO( :, 1,58, 2) = (/&
&7.8662E-10_JPRB,1.1835E-07_JPRB,2.3255E-07_JPRB,3.4498E-07_JPRB,4.7381E-07_JPRB/)
KBO( :, 2,58, 2) = (/&
&8.1625E-10_JPRB,1.5593E-07_JPRB,3.0466E-07_JPRB,4.5040E-07_JPRB,6.1632E-07_JPRB/)
KBO( :, 3,58, 2) = (/&
&9.0341E-10_JPRB,1.9427E-07_JPRB,3.7628E-07_JPRB,5.5215E-07_JPRB,7.5284E-07_JPRB/)
KBO( :, 4,58, 2) = (/&
&1.0971E-09_JPRB,2.3273E-07_JPRB,4.4632E-07_JPRB,6.5008E-07_JPRB,8.7941E-07_JPRB/)
KBO( :, 5,58, 2) = (/&
&1.4779E-09_JPRB,2.7004E-07_JPRB,5.1274E-07_JPRB,7.4188E-07_JPRB,9.9429E-07_JPRB/)
KBO( :, 1,59, 2) = (/&
&6.4355E-10_JPRB,9.3344E-08_JPRB,1.8349E-07_JPRB,2.7230E-07_JPRB,3.7011E-07_JPRB/)
KBO( :, 2,59, 2) = (/&
&6.6262E-10_JPRB,1.2407E-07_JPRB,2.4261E-07_JPRB,3.5886E-07_JPRB,4.8556E-07_JPRB/)
KBO( :, 3,59, 2) = (/&
&7.2712E-10_JPRB,1.5550E-07_JPRB,3.0153E-07_JPRB,4.4284E-07_JPRB,5.9628E-07_JPRB/)
KBO( :, 4,59, 2) = (/&
&8.7156E-10_JPRB,1.8704E-07_JPRB,3.5919E-07_JPRB,5.2368E-07_JPRB,6.9842E-07_JPRB/)
KBO( :, 5,59, 2) = (/&
&1.1587E-09_JPRB,2.1775E-07_JPRB,4.1408E-07_JPRB,5.9979E-07_JPRB,7.9133E-07_JPRB/)
KBO( :, 1,13, 3) = (/&
&2.0353E-05_JPRB,5.6795E-03_JPRB,1.0879E-02_JPRB,1.5836E-02_JPRB,2.0631E-02_JPRB/)
KBO( :, 2,13, 3) = (/&
&3.3777E-05_JPRB,6.5066E-03_JPRB,1.2221E-02_JPRB,1.7564E-02_JPRB,2.2630E-02_JPRB/)
KBO( :, 3,13, 3) = (/&
&5.9522E-05_JPRB,7.3512E-03_JPRB,1.3499E-02_JPRB,1.9109E-02_JPRB,2.4328E-02_JPRB/)
KBO( :, 4,13, 3) = (/&
&1.0349E-04_JPRB,8.2028E-03_JPRB,1.4689E-02_JPRB,2.0461E-02_JPRB,2.5718E-02_JPRB/)
KBO( :, 5,13, 3) = (/&
&1.7303E-04_JPRB,9.0516E-03_JPRB,1.5806E-02_JPRB,2.1651E-02_JPRB,2.6820E-02_JPRB/)
KBO( :, 1,14, 3) = (/&
&1.7783E-05_JPRB,4.9056E-03_JPRB,9.3358E-03_JPRB,1.3535E-02_JPRB,1.7457E-02_JPRB/)
KBO( :, 2,14, 3) = (/&
&3.0011E-05_JPRB,5.5977E-03_JPRB,1.0428E-02_JPRB,1.4906E-02_JPRB,1.8958E-02_JPRB/)
KBO( :, 3,14, 3) = (/&
&5.3112E-05_JPRB,6.2970E-03_JPRB,1.1454E-02_JPRB,1.6118E-02_JPRB,2.0210E-02_JPRB/)
KBO( :, 4,14, 3) = (/&
&9.2284E-05_JPRB,6.9980E-03_JPRB,1.2425E-02_JPRB,1.7194E-02_JPRB,2.1221E-02_JPRB/)
KBO( :, 5,14, 3) = (/&
&1.5395E-04_JPRB,7.6990E-03_JPRB,1.3352E-02_JPRB,1.8155E-02_JPRB,2.2006E-02_JPRB/)
KBO( :, 1,15, 3) = (/&
&1.5619E-05_JPRB,4.1987E-03_JPRB,7.9342E-03_JPRB,1.1456E-02_JPRB,1.4646E-02_JPRB/)
KBO( :, 2,15, 3) = (/&
&2.6774E-05_JPRB,4.7704E-03_JPRB,8.8150E-03_JPRB,1.2537E-02_JPRB,1.5771E-02_JPRB/)
KBO( :, 3,15, 3) = (/&
&4.7563E-05_JPRB,5.3462E-03_JPRB,9.6501E-03_JPRB,1.3503E-02_JPRB,1.6713E-02_JPRB/)
KBO( :, 4,15, 3) = (/&
&8.2516E-05_JPRB,5.9238E-03_JPRB,1.0452E-02_JPRB,1.4374E-02_JPRB,1.7466E-02_JPRB/)
KBO( :, 5,15, 3) = (/&
&1.3728E-04_JPRB,6.5026E-03_JPRB,1.1222E-02_JPRB,1.5161E-02_JPRB,1.8044E-02_JPRB/)
KBO( :, 1,16, 3) = (/&
&1.3779E-05_JPRB,3.5660E-03_JPRB,6.6881E-03_JPRB,9.6171E-03_JPRB,1.2220E-02_JPRB/)
KBO( :, 2,16, 3) = (/&
&2.3944E-05_JPRB,4.0358E-03_JPRB,7.4057E-03_JPRB,1.0483E-02_JPRB,1.3089E-02_JPRB/)
KBO( :, 3,16, 3) = (/&
&4.2620E-05_JPRB,4.5089E-03_JPRB,8.0943E-03_JPRB,1.1266E-02_JPRB,1.3818E-02_JPRB/)
KBO( :, 4,16, 3) = (/&
&7.3893E-05_JPRB,4.9861E-03_JPRB,8.7577E-03_JPRB,1.1978E-02_JPRB,1.4391E-02_JPRB/)
KBO( :, 5,16, 3) = (/&
&1.2258E-04_JPRB,5.4637E-03_JPRB,9.3940E-03_JPRB,1.2628E-02_JPRB,1.4828E-02_JPRB/)
KBO( :, 1,17, 3) = (/&
&1.2160E-05_JPRB,3.0074E-03_JPRB,5.6060E-03_JPRB,8.0296E-03_JPRB,1.0147E-02_JPRB/)
KBO( :, 2,17, 3) = (/&
&2.1375E-05_JPRB,3.3935E-03_JPRB,6.1972E-03_JPRB,8.7313E-03_JPRB,1.0830E-02_JPRB/)
KBO( :, 3,17, 3) = (/&
&3.8127E-05_JPRB,3.7835E-03_JPRB,6.7643E-03_JPRB,9.3718E-03_JPRB,1.1398E-02_JPRB/)
KBO( :, 4,17, 3) = (/&
&6.6011E-05_JPRB,4.1770E-03_JPRB,7.3104E-03_JPRB,9.9575E-03_JPRB,1.1840E-02_JPRB/)
KBO( :, 5,17, 3) = (/&
&1.0918E-04_JPRB,4.5738E-03_JPRB,7.8339E-03_JPRB,1.0495E-02_JPRB,1.2173E-02_JPRB/)
KBO( :, 1,18, 3) = (/&
&1.0748E-05_JPRB,2.5245E-03_JPRB,4.6847E-03_JPRB,6.6825E-03_JPRB,8.4030E-03_JPRB/)
KBO( :, 2,18, 3) = (/&
&1.9076E-05_JPRB,2.8417E-03_JPRB,5.1713E-03_JPRB,7.2560E-03_JPRB,8.9449E-03_JPRB/)
KBO( :, 3,18, 3) = (/&
&3.4073E-05_JPRB,3.1636E-03_JPRB,5.6356E-03_JPRB,7.7811E-03_JPRB,9.3891E-03_JPRB/)
KBO( :, 4,18, 3) = (/&
&5.8868E-05_JPRB,3.4883E-03_JPRB,6.0850E-03_JPRB,8.2633E-03_JPRB,9.7334E-03_JPRB/)
KBO( :, 5,18, 3) = (/&
&9.7060E-05_JPRB,3.8208E-03_JPRB,6.5140E-03_JPRB,8.7058E-03_JPRB,9.9894E-03_JPRB/)
KBO( :, 1,19, 3) = (/&
&9.4932E-06_JPRB,2.1111E-03_JPRB,3.9060E-03_JPRB,5.5505E-03_JPRB,6.9419E-03_JPRB/)
KBO( :, 2,19, 3) = (/&
&1.6990E-05_JPRB,2.3724E-03_JPRB,4.3041E-03_JPRB,6.0210E-03_JPRB,7.3719E-03_JPRB/)
KBO( :, 3,19, 3) = (/&
&3.0379E-05_JPRB,2.6375E-03_JPRB,4.6850E-03_JPRB,6.4526E-03_JPRB,7.7206E-03_JPRB/)
KBO( :, 4,19, 3) = (/&
&5.2318E-05_JPRB,2.9073E-03_JPRB,5.0535E-03_JPRB,6.8468E-03_JPRB,7.9880E-03_JPRB/)
KBO( :, 5,19, 3) = (/&
&8.5851E-05_JPRB,3.1863E-03_JPRB,5.4069E-03_JPRB,7.2090E-03_JPRB,8.1842E-03_JPRB/)
KBO( :, 1,20, 3) = (/&
&8.4621E-06_JPRB,1.7648E-03_JPRB,3.2563E-03_JPRB,4.6122E-03_JPRB,5.7360E-03_JPRB/)
KBO( :, 2,20, 3) = (/&
&1.5250E-05_JPRB,1.9802E-03_JPRB,3.5810E-03_JPRB,4.9972E-03_JPRB,6.0779E-03_JPRB/)
KBO( :, 3,20, 3) = (/&
&2.7245E-05_JPRB,2.1990E-03_JPRB,3.8932E-03_JPRB,5.3488E-03_JPRB,6.3511E-03_JPRB/)
KBO( :, 4,20, 3) = (/&
&4.6707E-05_JPRB,2.4242E-03_JPRB,4.1953E-03_JPRB,5.6710E-03_JPRB,6.5600E-03_JPRB/)
KBO( :, 5,20, 3) = (/&
&7.6165E-05_JPRB,2.6575E-03_JPRB,4.4893E-03_JPRB,5.9661E-03_JPRB,6.7108E-03_JPRB/)
KBO( :, 1,21, 3) = (/&
&7.5453E-06_JPRB,1.4733E-03_JPRB,2.7104E-03_JPRB,3.8302E-03_JPRB,4.7372E-03_JPRB/)
KBO( :, 2,21, 3) = (/&
&1.3660E-05_JPRB,1.6505E-03_JPRB,2.9759E-03_JPRB,4.1434E-03_JPRB,5.0081E-03_JPRB/)
KBO( :, 3,21, 3) = (/&
&2.4360E-05_JPRB,1.8325E-03_JPRB,3.2316E-03_JPRB,4.4300E-03_JPRB,5.2232E-03_JPRB/)
KBO( :, 4,21, 3) = (/&
&4.1539E-05_JPRB,2.0202E-03_JPRB,3.4804E-03_JPRB,4.6921E-03_JPRB,5.3862E-03_JPRB/)
KBO( :, 5,21, 3) = (/&
&6.7226E-05_JPRB,2.2135E-03_JPRB,3.7240E-03_JPRB,4.9321E-03_JPRB,5.5010E-03_JPRB/)
KBO( :, 1,22, 3) = (/&
&6.9875E-06_JPRB,1.2377E-03_JPRB,2.2680E-03_JPRB,3.1957E-03_JPRB,3.9253E-03_JPRB/)
KBO( :, 2,22, 3) = (/&
&1.2689E-05_JPRB,1.3846E-03_JPRB,2.4844E-03_JPRB,3.4484E-03_JPRB,4.1374E-03_JPRB/)
KBO( :, 3,22, 3) = (/&
&2.2485E-05_JPRB,1.5363E-03_JPRB,2.6941E-03_JPRB,3.6801E-03_JPRB,4.3039E-03_JPRB/)
KBO( :, 4,22, 3) = (/&
&3.7954E-05_JPRB,1.6925E-03_JPRB,2.8992E-03_JPRB,3.8918E-03_JPRB,4.4280E-03_JPRB/)
KBO( :, 5,22, 3) = (/&
&6.0729E-05_JPRB,1.8529E-03_JPRB,3.1002E-03_JPRB,4.0883E-03_JPRB,4.5144E-03_JPRB/)
KBO( :, 1,23, 3) = (/&
&6.4953E-06_JPRB,1.0396E-03_JPRB,1.8968E-03_JPRB,2.6642E-03_JPRB,3.2502E-03_JPRB/)
KBO( :, 2,23, 3) = (/&
&1.1793E-05_JPRB,1.1619E-03_JPRB,2.0732E-03_JPRB,2.8684E-03_JPRB,3.4159E-03_JPRB/)
KBO( :, 3,23, 3) = (/&
&2.0715E-05_JPRB,1.2879E-03_JPRB,2.2459E-03_JPRB,3.0558E-03_JPRB,3.5445E-03_JPRB/)
KBO( :, 4,23, 3) = (/&
&3.4551E-05_JPRB,1.4176E-03_JPRB,2.4147E-03_JPRB,3.2275E-03_JPRB,3.6395E-03_JPRB/)
KBO( :, 5,23, 3) = (/&
&5.4641E-05_JPRB,1.5512E-03_JPRB,2.5804E-03_JPRB,3.3885E-03_JPRB,3.7034E-03_JPRB/)
KBO( :, 1,24, 3) = (/&
&6.0670E-06_JPRB,8.7365E-04_JPRB,1.5859E-03_JPRB,2.2204E-03_JPRB,2.6897E-03_JPRB/)
KBO( :, 2,24, 3) = (/&
&1.0981E-05_JPRB,9.7532E-04_JPRB,1.7303E-03_JPRB,2.3852E-03_JPRB,2.8188E-03_JPRB/)
KBO( :, 3,24, 3) = (/&
&1.9078E-05_JPRB,1.0799E-03_JPRB,1.8727E-03_JPRB,2.5367E-03_JPRB,2.9175E-03_JPRB/)
KBO( :, 4,24, 3) = (/&
&3.1407E-05_JPRB,1.1876E-03_JPRB,2.0114E-03_JPRB,2.6770E-03_JPRB,2.9899E-03_JPRB/)
KBO( :, 5,24, 3) = (/&
&4.9067E-05_JPRB,1.2997E-03_JPRB,2.1481E-03_JPRB,2.8086E-03_JPRB,3.0371E-03_JPRB/)
KBO( :, 1,25, 3) = (/&
&5.6989E-06_JPRB,7.3485E-04_JPRB,1.3264E-03_JPRB,1.8506E-03_JPRB,2.2259E-03_JPRB/)
KBO( :, 2,25, 3) = (/&
&1.0240E-05_JPRB,8.1910E-04_JPRB,1.4452E-03_JPRB,1.9836E-03_JPRB,2.3255E-03_JPRB/)
KBO( :, 3,25, 3) = (/&
&1.7580E-05_JPRB,9.0587E-04_JPRB,1.5621E-03_JPRB,2.1066E-03_JPRB,2.4014E-03_JPRB/)
KBO( :, 4,25, 3) = (/&
&2.8572E-05_JPRB,9.9581E-04_JPRB,1.6762E-03_JPRB,2.2210E-03_JPRB,2.4559E-03_JPRB/)
KBO( :, 5,25, 3) = (/&
&4.4075E-05_JPRB,1.0904E-03_JPRB,1.7895E-03_JPRB,2.3285E-03_JPRB,2.4904E-03_JPRB/)
KBO( :, 1,26, 3) = (/&
&5.4044E-06_JPRB,6.1917E-04_JPRB,1.1109E-03_JPRB,1.5435E-03_JPRB,1.8428E-03_JPRB/)
KBO( :, 2,26, 3) = (/&
&9.6129E-06_JPRB,6.8903E-04_JPRB,1.2086E-03_JPRB,1.6510E-03_JPRB,1.9194E-03_JPRB/)
KBO( :, 3,26, 3) = (/&
&1.6279E-05_JPRB,7.6112E-04_JPRB,1.3044E-03_JPRB,1.7509E-03_JPRB,1.9770E-03_JPRB/)
KBO( :, 4,26, 3) = (/&
&2.6098E-05_JPRB,8.3688E-04_JPRB,1.3985E-03_JPRB,1.8442E-03_JPRB,2.0178E-03_JPRB/)
KBO( :, 5,26, 3) = (/&
&3.9757E-05_JPRB,9.1748E-04_JPRB,1.4931E-03_JPRB,1.9319E-03_JPRB,2.0426E-03_JPRB/)
KBO( :, 1,27, 3) = (/&
&5.1208E-06_JPRB,5.2155E-04_JPRB,9.3033E-04_JPRB,1.2869E-03_JPRB,1.5252E-03_JPRB/)
KBO( :, 2,27, 3) = (/&
&9.0050E-06_JPRB,5.7947E-04_JPRB,1.0106E-03_JPRB,1.3741E-03_JPRB,1.5841E-03_JPRB/)
KBO( :, 3,27, 3) = (/&
&1.5028E-05_JPRB,6.3999E-04_JPRB,1.0891E-03_JPRB,1.4551E-03_JPRB,1.6279E-03_JPRB/)
KBO( :, 4,27, 3) = (/&
&2.3771E-05_JPRB,7.0422E-04_JPRB,1.1674E-03_JPRB,1.5313E-03_JPRB,1.6583E-03_JPRB/)
KBO( :, 5,27, 3) = (/&
&3.5789E-05_JPRB,7.7220E-04_JPRB,1.2465E-03_JPRB,1.6033E-03_JPRB,1.6759E-03_JPRB/)
KBO( :, 1,28, 3) = (/&
&4.8426E-06_JPRB,4.3932E-04_JPRB,7.7909E-04_JPRB,1.0728E-03_JPRB,1.2619E-03_JPRB/)
KBO( :, 2,28, 3) = (/&
&8.4123E-06_JPRB,4.8757E-04_JPRB,8.4493E-04_JPRB,1.1435E-03_JPRB,1.3071E-03_JPRB/)
KBO( :, 3,28, 3) = (/&
&1.3833E-05_JPRB,5.3874E-04_JPRB,9.0955E-04_JPRB,1.2094E-03_JPRB,1.3406E-03_JPRB/)
KBO( :, 4,28, 3) = (/&
&2.1607E-05_JPRB,5.9328E-04_JPRB,9.7513E-04_JPRB,1.2716E-03_JPRB,1.3629E-03_JPRB/)
KBO( :, 5,28, 3) = (/&
&3.2146E-05_JPRB,6.4978E-04_JPRB,1.0416E-03_JPRB,1.3310E-03_JPRB,1.3752E-03_JPRB/)
KBO( :, 1,29, 3) = (/&
&4.5849E-06_JPRB,3.7023E-04_JPRB,6.5264E-04_JPRB,8.9457E-04_JPRB,1.0445E-03_JPRB/)
KBO( :, 2,29, 3) = (/&
&7.8572E-06_JPRB,4.1089E-04_JPRB,7.0665E-04_JPRB,9.5187E-04_JPRB,1.0793E-03_JPRB/)
KBO( :, 3,29, 3) = (/&
&1.2741E-05_JPRB,4.5436E-04_JPRB,7.6034E-04_JPRB,1.0055E-03_JPRB,1.1048E-03_JPRB/)
KBO( :, 4,29, 3) = (/&
&1.9649E-05_JPRB,4.9998E-04_JPRB,8.1550E-04_JPRB,1.0566E-03_JPRB,1.1213E-03_JPRB/)
KBO( :, 5,29, 3) = (/&
&2.8896E-05_JPRB,5.4682E-04_JPRB,8.7093E-04_JPRB,1.1060E-03_JPRB,1.1298E-03_JPRB/)
KBO( :, 1,30, 3) = (/&
&4.3297E-06_JPRB,3.1217E-04_JPRB,5.4663E-04_JPRB,7.4580E-04_JPRB,8.6464E-04_JPRB/)
KBO( :, 2,30, 3) = (/&
&7.3120E-06_JPRB,3.4668E-04_JPRB,5.9106E-04_JPRB,7.9232E-04_JPRB,8.9143E-04_JPRB/)
KBO( :, 3,30, 3) = (/&
&1.1705E-05_JPRB,3.8338E-04_JPRB,6.3627E-04_JPRB,8.3604E-04_JPRB,9.1074E-04_JPRB/)
KBO( :, 4,30, 3) = (/&
&1.7828E-05_JPRB,4.2125E-04_JPRB,6.8249E-04_JPRB,8.7824E-04_JPRB,9.2283E-04_JPRB/)
KBO( :, 5,30, 3) = (/&
&2.5924E-05_JPRB,4.5966E-04_JPRB,7.2827E-04_JPRB,9.1964E-04_JPRB,9.2875E-04_JPRB/)
KBO( :, 1,31, 3) = (/&
&4.0874E-06_JPRB,2.6368E-04_JPRB,4.5791E-04_JPRB,6.2183E-04_JPRB,7.1613E-04_JPRB/)
KBO( :, 2,31, 3) = (/&
&6.8015E-06_JPRB,2.9293E-04_JPRB,4.9490E-04_JPRB,6.5949E-04_JPRB,7.3687E-04_JPRB/)
KBO( :, 3,31, 3) = (/&
&1.0746E-05_JPRB,3.2348E-04_JPRB,5.3298E-04_JPRB,6.9547E-04_JPRB,7.5159E-04_JPRB/)
KBO( :, 4,31, 3) = (/&
&1.6163E-05_JPRB,3.5480E-04_JPRB,5.7136E-04_JPRB,7.3073E-04_JPRB,7.6056E-04_JPRB/)
KBO( :, 5,31, 3) = (/&
&2.3251E-05_JPRB,3.8597E-04_JPRB,6.0897E-04_JPRB,7.6515E-04_JPRB,7.6467E-04_JPRB/)
KBO( :, 1,32, 3) = (/&
&3.8514E-06_JPRB,2.2297E-04_JPRB,3.8374E-04_JPRB,5.1829E-04_JPRB,5.9305E-04_JPRB/)
KBO( :, 2,32, 3) = (/&
&6.3168E-06_JPRB,2.4754E-04_JPRB,4.1485E-04_JPRB,5.4904E-04_JPRB,6.0924E-04_JPRB/)
KBO( :, 3,32, 3) = (/&
&9.8501E-06_JPRB,2.7292E-04_JPRB,4.4681E-04_JPRB,5.7897E-04_JPRB,6.2044E-04_JPRB/)
KBO( :, 4,32, 3) = (/&
&1.4638E-05_JPRB,2.9846E-04_JPRB,4.7840E-04_JPRB,6.0852E-04_JPRB,6.2707E-04_JPRB/)
KBO( :, 5,32, 3) = (/&
&2.0831E-05_JPRB,3.2361E-04_JPRB,5.0883E-04_JPRB,6.3658E-04_JPRB,6.2999E-04_JPRB/)
KBO( :, 1,33, 3) = (/&
&3.6163E-06_JPRB,1.8866E-04_JPRB,3.2190E-04_JPRB,4.3205E-04_JPRB,4.9144E-04_JPRB/)
KBO( :, 2,33, 3) = (/&
&5.8503E-06_JPRB,2.0912E-04_JPRB,3.4811E-04_JPRB,4.5736E-04_JPRB,5.0397E-04_JPRB/)
KBO( :, 3,33, 3) = (/&
&9.0067E-06_JPRB,2.2999E-04_JPRB,3.7456E-04_JPRB,4.8239E-04_JPRB,5.1238E-04_JPRB/)
KBO( :, 4,33, 3) = (/&
&1.3226E-05_JPRB,2.5067E-04_JPRB,4.0039E-04_JPRB,5.0676E-04_JPRB,5.1732E-04_JPRB/)
KBO( :, 5,33, 3) = (/&
&1.8631E-05_JPRB,2.7107E-04_JPRB,4.2476E-04_JPRB,5.2963E-04_JPRB,5.1944E-04_JPRB/)
KBO( :, 1,34, 3) = (/&
&3.3238E-06_JPRB,1.5902E-04_JPRB,2.6946E-04_JPRB,3.5933E-04_JPRB,4.0648E-04_JPRB/)
KBO( :, 2,34, 3) = (/&
&5.3166E-06_JPRB,1.7590E-04_JPRB,2.9135E-04_JPRB,3.8047E-04_JPRB,4.1623E-04_JPRB/)
KBO( :, 3,34, 3) = (/&
&8.0935E-06_JPRB,1.9289E-04_JPRB,3.1309E-04_JPRB,4.0135E-04_JPRB,4.2273E-04_JPRB/)
KBO( :, 4,34, 3) = (/&
&1.1767E-05_JPRB,2.0963E-04_JPRB,3.3398E-04_JPRB,4.2136E-04_JPRB,4.2646E-04_JPRB/)
KBO( :, 5,34, 3) = (/&
&1.6441E-05_JPRB,2.2628E-04_JPRB,3.5340E-04_JPRB,4.3976E-04_JPRB,4.2791E-04_JPRB/)
KBO( :, 1,35, 3) = (/&
&2.9067E-06_JPRB,1.3259E-04_JPRB,2.2393E-04_JPRB,2.9733E-04_JPRB,3.3540E-04_JPRB/)
KBO( :, 2,35, 3) = (/&
&4.6187E-06_JPRB,1.4644E-04_JPRB,2.4206E-04_JPRB,3.1503E-04_JPRB,3.4321E-04_JPRB/)
KBO( :, 3,35, 3) = (/&
&6.9869E-06_JPRB,1.6027E-04_JPRB,2.5990E-04_JPRB,3.3236E-04_JPRB,3.4842E-04_JPRB/)
KBO( :, 4,35, 3) = (/&
&1.0104E-05_JPRB,1.7387E-04_JPRB,2.7672E-04_JPRB,3.4881E-04_JPRB,3.5145E-04_JPRB/)
KBO( :, 5,35, 3) = (/&
&1.4052E-05_JPRB,1.8746E-04_JPRB,2.9226E-04_JPRB,3.6359E-04_JPRB,3.5262E-04_JPRB/)
KBO( :, 1,36, 3) = (/&
&2.4089E-06_JPRB,1.0927E-04_JPRB,1.8451E-04_JPRB,2.4455E-04_JPRB,2.7594E-04_JPRB/)
KBO( :, 2,36, 3) = (/&
&3.8233E-06_JPRB,1.2060E-04_JPRB,1.9949E-04_JPRB,2.5938E-04_JPRB,2.8242E-04_JPRB/)
KBO( :, 3,36, 3) = (/&
&5.7778E-06_JPRB,1.3185E-04_JPRB,2.1404E-04_JPRB,2.7372E-04_JPRB,2.8680E-04_JPRB/)
KBO( :, 4,36, 3) = (/&
&8.3484E-06_JPRB,1.4295E-04_JPRB,2.2765E-04_JPRB,2.8727E-04_JPRB,2.8945E-04_JPRB/)
KBO( :, 5,36, 3) = (/&
&1.1603E-05_JPRB,1.5407E-04_JPRB,2.4022E-04_JPRB,2.9918E-04_JPRB,2.9054E-04_JPRB/)
KBO( :, 1,37, 3) = (/&
&1.8525E-06_JPRB,8.8636E-05_JPRB,1.5015E-04_JPRB,1.9932E-04_JPRB,2.2585E-04_JPRB/)
KBO( :, 2,37, 3) = (/&
&2.9593E-06_JPRB,9.7894E-05_JPRB,1.6249E-04_JPRB,2.1170E-04_JPRB,2.3148E-04_JPRB/)
KBO( :, 3,37, 3) = (/&
&4.5018E-06_JPRB,1.0706E-04_JPRB,1.7444E-04_JPRB,2.2370E-04_JPRB,2.3543E-04_JPRB/)
KBO( :, 4,37, 3) = (/&
&6.5383E-06_JPRB,1.1615E-04_JPRB,1.8559E-04_JPRB,2.3492E-04_JPRB,2.3791E-04_JPRB/)
KBO( :, 5,37, 3) = (/&
&9.1296E-06_JPRB,1.2523E-04_JPRB,1.9593E-04_JPRB,2.4478E-04_JPRB,2.3911E-04_JPRB/)
KBO( :, 1,38, 3) = (/&
&1.4171E-06_JPRB,7.1807E-05_JPRB,1.2206E-04_JPRB,1.6233E-04_JPRB,1.8481E-04_JPRB/)
KBO( :, 2,38, 3) = (/&
&2.2804E-06_JPRB,7.9379E-05_JPRB,1.3224E-04_JPRB,1.7271E-04_JPRB,1.8979E-04_JPRB/)
KBO( :, 3,38, 3) = (/&
&3.4913E-06_JPRB,8.6867E-05_JPRB,1.4204E-04_JPRB,1.8270E-04_JPRB,1.9335E-04_JPRB/)
KBO( :, 4,38, 3) = (/&
&5.1024E-06_JPRB,9.4294E-05_JPRB,1.5119E-04_JPRB,1.9201E-04_JPRB,1.9566E-04_JPRB/)
KBO( :, 5,38, 3) = (/&
&7.1603E-06_JPRB,1.0172E-04_JPRB,1.5970E-04_JPRB,2.0015E-04_JPRB,1.9689E-04_JPRB/)
KBO( :, 1,39, 3) = (/&
&1.0836E-06_JPRB,5.8166E-05_JPRB,9.9215E-05_JPRB,1.3222E-04_JPRB,1.5133E-04_JPRB/)
KBO( :, 2,39, 3) = (/&
&1.7555E-06_JPRB,6.4345E-05_JPRB,1.0758E-04_JPRB,1.4088E-04_JPRB,1.5570E-04_JPRB/)
KBO( :, 3,39, 3) = (/&
&2.7062E-06_JPRB,7.0477E-05_JPRB,1.1564E-04_JPRB,1.4921E-04_JPRB,1.5890E-04_JPRB/)
KBO( :, 4,39, 3) = (/&
&3.9795E-06_JPRB,7.6546E-05_JPRB,1.2316E-04_JPRB,1.5693E-04_JPRB,1.6103E-04_JPRB/)
KBO( :, 5,39, 3) = (/&
&5.6128E-06_JPRB,8.2626E-05_JPRB,1.3018E-04_JPRB,1.6363E-04_JPRB,1.6230E-04_JPRB/)
KBO( :, 1,40, 3) = (/&
&7.8445E-07_JPRB,4.6585E-05_JPRB,7.9902E-05_JPRB,1.0692E-04_JPRB,1.2321E-04_JPRB/)
KBO( :, 2,40, 3) = (/&
&1.2866E-06_JPRB,5.1634E-05_JPRB,8.6802E-05_JPRB,1.1417E-04_JPRB,1.2708E-04_JPRB/)
KBO( :, 3,40, 3) = (/&
&2.0073E-06_JPRB,5.6656E-05_JPRB,9.3478E-05_JPRB,1.2114E-04_JPRB,1.2998E-04_JPRB/)
KBO( :, 4,40, 3) = (/&
&2.9837E-06_JPRB,6.1628E-05_JPRB,9.9689E-05_JPRB,1.2758E-04_JPRB,1.3201E-04_JPRB/)
KBO( :, 5,40, 3) = (/&
&4.2474E-06_JPRB,6.6601E-05_JPRB,1.0552E-04_JPRB,1.3318E-04_JPRB,1.3326E-04_JPRB/)
KBO( :, 1,41, 3) = (/&
&5.6200E-07_JPRB,3.7239E-05_JPRB,6.4245E-05_JPRB,8.6338E-05_JPRB,1.0021E-04_JPRB/)
KBO( :, 2,41, 3) = (/&
&9.3423E-07_JPRB,4.1365E-05_JPRB,6.9922E-05_JPRB,9.2387E-05_JPRB,1.0362E-04_JPRB/)
KBO( :, 3,41, 3) = (/&
&1.4759E-06_JPRB,4.5473E-05_JPRB,7.5442E-05_JPRB,9.8211E-05_JPRB,1.0623E-04_JPRB/)
KBO( :, 4,41, 3) = (/&
&2.2204E-06_JPRB,4.9548E-05_JPRB,8.0603E-05_JPRB,1.0362E-04_JPRB,1.0811E-04_JPRB/)
KBO( :, 5,41, 3) = (/&
&3.1941E-06_JPRB,5.3616E-05_JPRB,8.5442E-05_JPRB,1.0831E-04_JPRB,1.0933E-04_JPRB/)
KBO( :, 1,42, 3) = (/&
&4.0111E-07_JPRB,2.9743E-05_JPRB,5.1608E-05_JPRB,6.9660E-05_JPRB,8.1453E-05_JPRB/)
KBO( :, 2,42, 3) = (/&
&6.7588E-07_JPRB,3.3120E-05_JPRB,5.6295E-05_JPRB,7.4726E-05_JPRB,8.4452E-05_JPRB/)
KBO( :, 3,42, 3) = (/&
&1.0815E-06_JPRB,3.6481E-05_JPRB,6.0861E-05_JPRB,7.9587E-05_JPRB,8.6802E-05_JPRB/)
KBO( :, 4,42, 3) = (/&
&1.6472E-06_JPRB,3.9818E-05_JPRB,6.5135E-05_JPRB,8.4095E-05_JPRB,8.8535E-05_JPRB/)
KBO( :, 5,42, 3) = (/&
&2.3953E-06_JPRB,4.3150E-05_JPRB,6.9163E-05_JPRB,8.8053E-05_JPRB,8.9707E-05_JPRB/)
KBO( :, 1,43, 3) = (/&
&2.7634E-07_JPRB,2.3586E-05_JPRB,4.1208E-05_JPRB,5.5916E-05_JPRB,6.5980E-05_JPRB/)
KBO( :, 2,43, 3) = (/&
&4.7339E-07_JPRB,2.6349E-05_JPRB,4.5082E-05_JPRB,6.0171E-05_JPRB,6.8655E-05_JPRB/)
KBO( :, 3,43, 3) = (/&
&7.6946E-07_JPRB,2.9095E-05_JPRB,4.8858E-05_JPRB,6.4228E-05_JPRB,7.0769E-05_JPRB/)
KBO( :, 4,43, 3) = (/&
&1.1899E-06_JPRB,3.1831E-05_JPRB,5.2419E-05_JPRB,6.8020E-05_JPRB,7.2392E-05_JPRB/)
KBO( :, 5,43, 3) = (/&
&1.7542E-06_JPRB,3.4560E-05_JPRB,5.5769E-05_JPRB,7.1373E-05_JPRB,7.3520E-05_JPRB/)
KBO( :, 1,44, 3) = (/&
&1.8677E-07_JPRB,1.8630E-05_JPRB,3.2790E-05_JPRB,4.4748E-05_JPRB,5.3325E-05_JPRB/)
KBO( :, 2,44, 3) = (/&
&3.2545E-07_JPRB,2.0878E-05_JPRB,3.5981E-05_JPRB,4.8304E-05_JPRB,5.5702E-05_JPRB/)
KBO( :, 3,44, 3) = (/&
&5.3812E-07_JPRB,2.3132E-05_JPRB,3.9119E-05_JPRB,5.1707E-05_JPRB,5.7625E-05_JPRB/)
KBO( :, 4,44, 3) = (/&
&8.4624E-07_JPRB,2.5378E-05_JPRB,4.2094E-05_JPRB,5.4904E-05_JPRB,5.9117E-05_JPRB/)
KBO( :, 5,44, 3) = (/&
&1.2670E-06_JPRB,2.7605E-05_JPRB,4.4873E-05_JPRB,5.7740E-05_JPRB,6.0210E-05_JPRB/)
KBO( :, 1,45, 3) = (/&
&1.2570E-07_JPRB,1.4697E-05_JPRB,2.6055E-05_JPRB,3.5757E-05_JPRB,4.3043E-05_JPRB/)
KBO( :, 2,45, 3) = (/&
&2.2228E-07_JPRB,1.6531E-05_JPRB,2.8696E-05_JPRB,3.8740E-05_JPRB,4.5168E-05_JPRB/)
KBO( :, 3,45, 3) = (/&
&3.7425E-07_JPRB,1.8375E-05_JPRB,3.1286E-05_JPRB,4.1584E-05_JPRB,4.6892E-05_JPRB/)
KBO( :, 4,45, 3) = (/&
&5.9851E-07_JPRB,2.0210E-05_JPRB,3.3765E-05_JPRB,4.4275E-05_JPRB,4.8273E-05_JPRB/)
KBO( :, 5,45, 3) = (/&
&9.1064E-07_JPRB,2.2043E-05_JPRB,3.6086E-05_JPRB,4.6686E-05_JPRB,4.9306E-05_JPRB/)
KBO( :, 1,46, 3) = (/&
&8.3151E-08_JPRB,1.1545E-05_JPRB,2.0622E-05_JPRB,2.8475E-05_JPRB,3.4643E-05_JPRB/)
KBO( :, 2,46, 3) = (/&
&1.4909E-07_JPRB,1.3038E-05_JPRB,2.2804E-05_JPRB,3.0968E-05_JPRB,3.6538E-05_JPRB/)
KBO( :, 3,46, 3) = (/&
&2.5589E-07_JPRB,1.4552E-05_JPRB,2.4958E-05_JPRB,3.3368E-05_JPRB,3.8096E-05_JPRB/)
KBO( :, 4,46, 3) = (/&
&4.1668E-07_JPRB,1.6050E-05_JPRB,2.7017E-05_JPRB,3.5626E-05_JPRB,3.9358E-05_JPRB/)
KBO( :, 5,46, 3) = (/&
&6.4518E-07_JPRB,1.7554E-05_JPRB,2.8957E-05_JPRB,3.7672E-05_JPRB,4.0331E-05_JPRB/)
KBO( :, 1,47, 3) = (/&
&5.3540E-08_JPRB,9.0044E-06_JPRB,1.6219E-05_JPRB,2.2547E-05_JPRB,2.7739E-05_JPRB/)
KBO( :, 2,47, 3) = (/&
&9.7029E-08_JPRB,1.0218E-05_JPRB,1.8025E-05_JPRB,2.4635E-05_JPRB,2.9430E-05_JPRB/)
KBO( :, 3,47, 3) = (/&
&1.6982E-07_JPRB,1.1454E-05_JPRB,1.9806E-05_JPRB,2.6651E-05_JPRB,3.0836E-05_JPRB/)
KBO( :, 4,47, 3) = (/&
&2.8228E-07_JPRB,1.2681E-05_JPRB,2.1522E-05_JPRB,2.8552E-05_JPRB,3.1984E-05_JPRB/)
KBO( :, 5,47, 3) = (/&
&4.4593E-07_JPRB,1.3911E-05_JPRB,2.3146E-05_JPRB,3.0298E-05_JPRB,3.2902E-05_JPRB/)
KBO( :, 1,48, 3) = (/&
&3.4557E-08_JPRB,7.0084E-06_JPRB,1.2731E-05_JPRB,1.7817E-05_JPRB,2.2170E-05_JPRB/)
KBO( :, 2,48, 3) = (/&
&6.2743E-08_JPRB,7.9919E-06_JPRB,1.4216E-05_JPRB,1.9554E-05_JPRB,2.3663E-05_JPRB/)
KBO( :, 3,48, 3) = (/&
&1.1169E-07_JPRB,8.9994E-06_JPRB,1.5688E-05_JPRB,2.1246E-05_JPRB,2.4930E-05_JPRB/)
KBO( :, 4,48, 3) = (/&
&1.8970E-07_JPRB,1.0009E-05_JPRB,1.7121E-05_JPRB,2.2855E-05_JPRB,2.5977E-05_JPRB/)
KBO( :, 5,48, 3) = (/&
&3.0578E-07_JPRB,1.1013E-05_JPRB,1.8479E-05_JPRB,2.4337E-05_JPRB,2.6830E-05_JPRB/)
KBO( :, 1,49, 3) = (/&
&2.2502E-08_JPRB,5.4403E-06_JPRB,9.9701E-06_JPRB,1.4043E-05_JPRB,1.7685E-05_JPRB/)
KBO( :, 2,49, 3) = (/&
&4.0407E-08_JPRB,6.2386E-06_JPRB,1.1187E-05_JPRB,1.5489E-05_JPRB,1.8999E-05_JPRB/)
KBO( :, 3,49, 3) = (/&
&7.2903E-08_JPRB,7.0592E-06_JPRB,1.2408E-05_JPRB,1.6909E-05_JPRB,2.0138E-05_JPRB/)
KBO( :, 4,49, 3) = (/&
&1.2643E-07_JPRB,7.8874E-06_JPRB,1.3602E-05_JPRB,1.8265E-05_JPRB,2.1093E-05_JPRB/)
KBO( :, 5,49, 3) = (/&
&2.0803E-07_JPRB,8.7090E-06_JPRB,1.4734E-05_JPRB,1.9523E-05_JPRB,2.1885E-05_JPRB/)
KBO( :, 1,50, 3) = (/&
&1.5095E-08_JPRB,4.2287E-06_JPRB,7.8121E-06_JPRB,1.1070E-05_JPRB,1.4078E-05_JPRB/)
KBO( :, 2,50, 3) = (/&
&2.6427E-08_JPRB,4.8766E-06_JPRB,8.8105E-06_JPRB,1.2276E-05_JPRB,1.5222E-05_JPRB/)
KBO( :, 3,50, 3) = (/&
&4.7991E-08_JPRB,5.5443E-06_JPRB,9.8192E-06_JPRB,1.3460E-05_JPRB,1.6227E-05_JPRB/)
KBO( :, 4,50, 3) = (/&
&8.4675E-08_JPRB,6.2215E-06_JPRB,1.0811E-05_JPRB,1.4600E-05_JPRB,1.7078E-05_JPRB/)
KBO( :, 5,50, 3) = (/&
&1.4213E-07_JPRB,6.8957E-06_JPRB,1.1757E-05_JPRB,1.5668E-05_JPRB,1.7797E-05_JPRB/)
KBO( :, 1,51, 3) = (/&
&1.0409E-08_JPRB,3.2863E-06_JPRB,6.1164E-06_JPRB,8.7177E-06_JPRB,1.1179E-05_JPRB/)
KBO( :, 2,51, 3) = (/&
&1.7475E-08_JPRB,3.8101E-06_JPRB,6.9343E-06_JPRB,9.7209E-06_JPRB,1.2172E-05_JPRB/)
KBO( :, 3,51, 3) = (/&
&3.1652E-08_JPRB,4.3546E-06_JPRB,7.7683E-06_JPRB,1.0708E-05_JPRB,1.3048E-05_JPRB/)
KBO( :, 4,51, 3) = (/&
&5.6664E-08_JPRB,4.9075E-06_JPRB,8.5891E-06_JPRB,1.1663E-05_JPRB,1.3802E-05_JPRB/)
KBO( :, 5,51, 3) = (/&
&9.6978E-08_JPRB,5.4606E-06_JPRB,9.3785E-06_JPRB,1.2566E-05_JPRB,1.4438E-05_JPRB/)
KBO( :, 1,52, 3) = (/&
&7.3730E-09_JPRB,2.5481E-06_JPRB,4.7781E-06_JPRB,6.8480E-06_JPRB,8.8551E-06_JPRB/)
KBO( :, 2,52, 3) = (/&
&1.1665E-08_JPRB,2.9707E-06_JPRB,5.4480E-06_JPRB,7.6826E-06_JPRB,9.7180E-06_JPRB/)
KBO( :, 3,52, 3) = (/&
&2.0839E-08_JPRB,3.4136E-06_JPRB,6.1334E-06_JPRB,8.5017E-06_JPRB,1.0476E-05_JPRB/)
KBO( :, 4,52, 3) = (/&
&3.7702E-08_JPRB,3.8651E-06_JPRB,6.8133E-06_JPRB,9.3029E-06_JPRB,1.1144E-05_JPRB/)
KBO( :, 5,52, 3) = (/&
&6.5719E-08_JPRB,4.3178E-06_JPRB,7.4715E-06_JPRB,1.0064E-05_JPRB,1.1709E-05_JPRB/)
KBO( :, 1,53, 3) = (/&
&5.3750E-09_JPRB,1.9710E-06_JPRB,3.7222E-06_JPRB,5.3652E-06_JPRB,6.9985E-06_JPRB/)
KBO( :, 2,53, 3) = (/&
&7.9112E-09_JPRB,2.3105E-06_JPRB,4.2696E-06_JPRB,6.0569E-06_JPRB,7.7450E-06_JPRB/)
KBO( :, 3,53, 3) = (/&
&1.3727E-08_JPRB,2.6711E-06_JPRB,4.8332E-06_JPRB,6.7376E-06_JPRB,8.4040E-06_JPRB/)
KBO( :, 4,53, 3) = (/&
&2.4945E-08_JPRB,3.0391E-06_JPRB,5.3954E-06_JPRB,7.4078E-06_JPRB,8.9922E-06_JPRB/)
KBO( :, 5,53, 3) = (/&
&4.4184E-08_JPRB,3.4095E-06_JPRB,5.9433E-06_JPRB,8.0475E-06_JPRB,9.4957E-06_JPRB/)
KBO( :, 1,54, 3) = (/&
&4.0653E-09_JPRB,1.5287E-06_JPRB,2.9053E-06_JPRB,4.2078E-06_JPRB,5.5137E-06_JPRB/)
KBO( :, 2,54, 3) = (/&
&5.5613E-09_JPRB,1.8017E-06_JPRB,3.3529E-06_JPRB,4.7820E-06_JPRB,6.1506E-06_JPRB/)
KBO( :, 3,54, 3) = (/&
&9.2526E-09_JPRB,2.0941E-06_JPRB,3.8143E-06_JPRB,5.3462E-06_JPRB,6.7127E-06_JPRB/)
KBO( :, 4,54, 3) = (/&
&1.6740E-08_JPRB,2.3952E-06_JPRB,4.2796E-06_JPRB,5.9051E-06_JPRB,7.2164E-06_JPRB/)
KBO( :, 5,54, 3) = (/&
&3.0031E-08_JPRB,2.6979E-06_JPRB,4.7338E-06_JPRB,6.4403E-06_JPRB,7.6524E-06_JPRB/)
KBO( :, 1,55, 3) = (/&
&3.1540E-09_JPRB,1.1858E-06_JPRB,2.2670E-06_JPRB,3.2967E-06_JPRB,4.3283E-06_JPRB/)
KBO( :, 2,55, 3) = (/&
&4.0196E-09_JPRB,1.4051E-06_JPRB,2.6332E-06_JPRB,3.7741E-06_JPRB,4.8678E-06_JPRB/)
KBO( :, 3,55, 3) = (/&
&6.3379E-09_JPRB,1.6423E-06_JPRB,3.0104E-06_JPRB,4.2413E-06_JPRB,5.3455E-06_JPRB/)
KBO( :, 4,55, 3) = (/&
&1.1312E-08_JPRB,1.8877E-06_JPRB,3.3935E-06_JPRB,4.7052E-06_JPRB,5.7689E-06_JPRB/)
KBO( :, 5,55, 3) = (/&
&2.0477E-08_JPRB,2.1358E-06_JPRB,3.7709E-06_JPRB,5.1537E-06_JPRB,6.1417E-06_JPRB/)
KBO( :, 1,56, 3) = (/&
&2.4885E-09_JPRB,9.1751E-07_JPRB,1.7642E-06_JPRB,2.5751E-06_JPRB,3.3880E-06_JPRB/)
KBO( :, 2,56, 3) = (/&
&2.9720E-09_JPRB,1.0942E-06_JPRB,2.0641E-06_JPRB,2.9723E-06_JPRB,3.8440E-06_JPRB/)
KBO( :, 3,56, 3) = (/&
&4.3988E-09_JPRB,1.2857E-06_JPRB,2.3716E-06_JPRB,3.3596E-06_JPRB,4.2506E-06_JPRB/)
KBO( :, 4,56, 3) = (/&
&7.6547E-09_JPRB,1.4859E-06_JPRB,2.6877E-06_JPRB,3.7438E-06_JPRB,4.6065E-06_JPRB/)
KBO( :, 5,56, 3) = (/&
&1.3911E-08_JPRB,1.6888E-06_JPRB,2.9997E-06_JPRB,4.1185E-06_JPRB,4.9232E-06_JPRB/)
KBO( :, 1,57, 3) = (/&
&1.9886E-09_JPRB,7.0763E-07_JPRB,1.3683E-06_JPRB,2.0041E-06_JPRB,2.6428E-06_JPRB/)
KBO( :, 2,57, 3) = (/&
&2.2504E-09_JPRB,8.5035E-07_JPRB,1.6145E-06_JPRB,2.3353E-06_JPRB,3.0283E-06_JPRB/)
KBO( :, 3,57, 3) = (/&
&3.1057E-09_JPRB,1.0047E-06_JPRB,1.8650E-06_JPRB,2.6564E-06_JPRB,3.3731E-06_JPRB/)
KBO( :, 4,57, 3) = (/&
&5.1987E-09_JPRB,1.1674E-06_JPRB,2.1248E-06_JPRB,2.9740E-06_JPRB,3.6745E-06_JPRB/)
KBO( :, 5,57, 3) = (/&
&9.4155E-09_JPRB,1.3335E-06_JPRB,2.3825E-06_JPRB,3.2869E-06_JPRB,3.9424E-06_JPRB/)
KBO( :, 1,58, 3) = (/&
&1.6068E-09_JPRB,5.4596E-07_JPRB,1.0610E-06_JPRB,1.5587E-06_JPRB,2.0582E-06_JPRB/)
KBO( :, 2,58, 3) = (/&
&1.7459E-09_JPRB,6.6156E-07_JPRB,1.2631E-06_JPRB,1.8343E-06_JPRB,2.3824E-06_JPRB/)
KBO( :, 3,58, 3) = (/&
&2.2524E-09_JPRB,7.8545E-07_JPRB,1.4674E-06_JPRB,2.1005E-06_JPRB,2.6733E-06_JPRB/)
KBO( :, 4,58, 3) = (/&
&3.5899E-09_JPRB,9.1799E-07_JPRB,1.6806E-06_JPRB,2.3630E-06_JPRB,2.9296E-06_JPRB/)
KBO( :, 5,58, 3) = (/&
&6.4281E-09_JPRB,1.0538E-06_JPRB,1.8933E-06_JPRB,2.6237E-06_JPRB,3.1542E-06_JPRB/)
KBO( :, 1,59, 3) = (/&
&1.3115E-09_JPRB,4.3655E-07_JPRB,8.4995E-07_JPRB,1.2498E-06_JPRB,1.6427E-06_JPRB/)
KBO( :, 2,59, 3) = (/&
&1.4063E-09_JPRB,5.3104E-07_JPRB,1.0161E-06_JPRB,1.4776E-06_JPRB,1.9087E-06_JPRB/)
KBO( :, 3,59, 3) = (/&
&1.7670E-09_JPRB,6.3221E-07_JPRB,1.1839E-06_JPRB,1.6975E-06_JPRB,2.1469E-06_JPRB/)
KBO( :, 4,59, 3) = (/&
&2.7538E-09_JPRB,7.4064E-07_JPRB,1.3591E-06_JPRB,1.9143E-06_JPRB,2.3563E-06_JPRB/)
KBO( :, 5,59, 3) = (/&
&4.8966E-09_JPRB,8.5194E-07_JPRB,1.5343E-06_JPRB,2.1300E-06_JPRB,2.5372E-06_JPRB/)
KBO( :, 1,13, 4) = (/&
&1.4832E-04_JPRB,1.5698E-02_JPRB,2.8434E-02_JPRB,4.0000E-02_JPRB,5.0535E-02_JPRB/)
KBO( :, 2,13, 4) = (/&
&2.7354E-04_JPRB,1.7679E-02_JPRB,3.1476E-02_JPRB,4.3634E-02_JPRB,5.4373E-02_JPRB/)
KBO( :, 3,13, 4) = (/&
&4.7514E-04_JPRB,1.9768E-02_JPRB,3.4498E-02_JPRB,4.7113E-02_JPRB,5.7896E-02_JPRB/)
KBO( :, 4,13, 4) = (/&
&7.6575E-04_JPRB,2.1934E-02_JPRB,3.7431E-02_JPRB,5.0364E-02_JPRB,6.0901E-02_JPRB/)
KBO( :, 5,13, 4) = (/&
&1.1458E-03_JPRB,2.4148E-02_JPRB,4.0264E-02_JPRB,5.3231E-02_JPRB,6.3251E-02_JPRB/)
KBO( :, 1,14, 4) = (/&
&1.3350E-04_JPRB,1.3782E-02_JPRB,2.4857E-02_JPRB,3.4870E-02_JPRB,4.3573E-02_JPRB/)
KBO( :, 2,14, 4) = (/&
&2.4593E-04_JPRB,1.5547E-02_JPRB,2.7509E-02_JPRB,3.8001E-02_JPRB,4.6776E-02_JPRB/)
KBO( :, 3,14, 4) = (/&
&4.2506E-04_JPRB,1.7409E-02_JPRB,3.0122E-02_JPRB,4.0944E-02_JPRB,4.9474E-02_JPRB/)
KBO( :, 4,14, 4) = (/&
&6.7927E-04_JPRB,1.9326E-02_JPRB,3.2594E-02_JPRB,4.3519E-02_JPRB,5.1527E-02_JPRB/)
KBO( :, 5,14, 4) = (/&
&1.0076E-03_JPRB,2.1255E-02_JPRB,3.4899E-02_JPRB,4.5670E-02_JPRB,5.2951E-02_JPRB/)
KBO( :, 1,15, 4) = (/&
&1.2065E-04_JPRB,1.2024E-02_JPRB,2.1582E-02_JPRB,3.0176E-02_JPRB,3.7371E-02_JPRB/)
KBO( :, 2,15, 4) = (/&
&2.2207E-04_JPRB,1.3580E-02_JPRB,2.3845E-02_JPRB,3.2795E-02_JPRB,3.9887E-02_JPRB/)
KBO( :, 3,15, 4) = (/&
&3.8077E-04_JPRB,1.5191E-02_JPRB,2.6000E-02_JPRB,3.5116E-02_JPRB,4.1764E-02_JPRB/)
KBO( :, 4,15, 4) = (/&
&6.0257E-04_JPRB,1.6816E-02_JPRB,2.7979E-02_JPRB,3.7046E-02_JPRB,4.3070E-02_JPRB/)
KBO( :, 5,15, 4) = (/&
&8.8599E-04_JPRB,1.8418E-02_JPRB,2.9799E-02_JPRB,3.8653E-02_JPRB,4.3914E-02_JPRB/)
KBO( :, 1,16, 4) = (/&
&1.0931E-04_JPRB,1.0419E-02_JPRB,1.8587E-02_JPRB,2.5887E-02_JPRB,3.1833E-02_JPRB/)
KBO( :, 2,16, 4) = (/&
&2.0062E-04_JPRB,1.1752E-02_JPRB,2.0443E-02_JPRB,2.7962E-02_JPRB,3.3659E-02_JPRB/)
KBO( :, 3,16, 4) = (/&
&3.4061E-04_JPRB,1.3095E-02_JPRB,2.2148E-02_JPRB,2.9721E-02_JPRB,3.4939E-02_JPRB/)
KBO( :, 4,16, 4) = (/&
&5.3341E-04_JPRB,1.4426E-02_JPRB,2.3724E-02_JPRB,3.1189E-02_JPRB,3.5807E-02_JPRB/)
KBO( :, 5,16, 4) = (/&
&7.7707E-04_JPRB,1.5740E-02_JPRB,2.5194E-02_JPRB,3.2443E-02_JPRB,3.6342E-02_JPRB/)
KBO( :, 1,17, 4) = (/&
&9.8787E-05_JPRB,8.9488E-03_JPRB,1.5843E-02_JPRB,2.1968E-02_JPRB,2.6812E-02_JPRB/)
KBO( :, 2,17, 4) = (/&
&1.8034E-04_JPRB,1.0053E-02_JPRB,1.7312E-02_JPRB,2.3563E-02_JPRB,2.8105E-02_JPRB/)
KBO( :, 3,17, 4) = (/&
&3.0330E-04_JPRB,1.1150E-02_JPRB,1.8677E-02_JPRB,2.4918E-02_JPRB,2.9010E-02_JPRB/)
KBO( :, 4,17, 4) = (/&
&4.6915E-04_JPRB,1.2239E-02_JPRB,1.9960E-02_JPRB,2.6083E-02_JPRB,2.9616E-02_JPRB/)
KBO( :, 5,17, 4) = (/&
&6.7860E-04_JPRB,1.3325E-02_JPRB,2.1171E-02_JPRB,2.7089E-02_JPRB,2.9962E-02_JPRB/)
KBO( :, 1,18, 4) = (/&
&8.9115E-05_JPRB,7.6114E-03_JPRB,1.3364E-02_JPRB,1.8461E-02_JPRB,2.2371E-02_JPRB/)
KBO( :, 2,18, 4) = (/&
&1.6151E-04_JPRB,8.5146E-03_JPRB,1.4542E-02_JPRB,1.9706E-02_JPRB,2.3318E-02_JPRB/)
KBO( :, 3,18, 4) = (/&
&2.6853E-04_JPRB,9.4157E-03_JPRB,1.5660E-02_JPRB,2.0781E-02_JPRB,2.3982E-02_JPRB/)
KBO( :, 4,18, 4) = (/&
&4.1020E-04_JPRB,1.0310E-02_JPRB,1.6712E-02_JPRB,2.1721E-02_JPRB,2.4416E-02_JPRB/)
KBO( :, 5,18, 4) = (/&
&5.9029E-04_JPRB,1.1212E-02_JPRB,1.7715E-02_JPRB,2.2537E-02_JPRB,2.4643E-02_JPRB/)
KBO( :, 1,19, 4) = (/&
&8.0095E-05_JPRB,6.4231E-03_JPRB,1.1196E-02_JPRB,1.5414E-02_JPRB,1.8549E-02_JPRB/)
KBO( :, 2,19, 4) = (/&
&1.4382E-04_JPRB,7.1662E-03_JPRB,1.2159E-02_JPRB,1.6403E-02_JPRB,1.9259E-02_JPRB/)
KBO( :, 3,19, 4) = (/&
&2.3623E-04_JPRB,7.9047E-03_JPRB,1.3080E-02_JPRB,1.7271E-02_JPRB,1.9754E-02_JPRB/)
KBO( :, 4,19, 4) = (/&
&3.5687E-04_JPRB,8.6444E-03_JPRB,1.3944E-02_JPRB,1.8036E-02_JPRB,2.0065E-02_JPRB/)
KBO( :, 5,19, 4) = (/&
&5.1169E-04_JPRB,9.3924E-03_JPRB,1.4772E-02_JPRB,1.8710E-02_JPRB,2.0213E-02_JPRB/)
KBO( :, 1,20, 4) = (/&
&7.2492E-05_JPRB,5.4035E-03_JPRB,9.3587E-03_JPRB,1.2831E-02_JPRB,1.5342E-02_JPRB/)
KBO( :, 2,20, 4) = (/&
&1.2843E-04_JPRB,6.0138E-03_JPRB,1.0150E-02_JPRB,1.3627E-02_JPRB,1.5882E-02_JPRB/)
KBO( :, 3,20, 4) = (/&
&2.0800E-04_JPRB,6.6212E-03_JPRB,1.0905E-02_JPRB,1.4334E-02_JPRB,1.6254E-02_JPRB/)
KBO( :, 4,20, 4) = (/&
&3.1139E-04_JPRB,7.2334E-03_JPRB,1.1615E-02_JPRB,1.4959E-02_JPRB,1.6478E-02_JPRB/)
KBO( :, 5,20, 4) = (/&
&4.4561E-04_JPRB,7.8568E-03_JPRB,1.2299E-02_JPRB,1.5516E-02_JPRB,1.6574E-02_JPRB/)
KBO( :, 1,21, 4) = (/&
&6.5335E-05_JPRB,4.5290E-03_JPRB,7.8063E-03_JPRB,1.0655E-02_JPRB,1.2662E-02_JPRB/)
KBO( :, 2,21, 4) = (/&
&1.1419E-04_JPRB,5.0316E-03_JPRB,8.4549E-03_JPRB,1.1302E-02_JPRB,1.3077E-02_JPRB/)
KBO( :, 3,21, 4) = (/&
&1.8257E-04_JPRB,5.5323E-03_JPRB,9.0718E-03_JPRB,1.1880E-02_JPRB,1.3357E-02_JPRB/)
KBO( :, 4,21, 4) = (/&
&2.7150E-04_JPRB,6.0382E-03_JPRB,9.6571E-03_JPRB,1.2392E-02_JPRB,1.3520E-02_JPRB/)
KBO( :, 5,21, 4) = (/&
&3.8801E-04_JPRB,6.5620E-03_JPRB,1.0220E-02_JPRB,1.2849E-02_JPRB,1.3582E-02_JPRB/)
KBO( :, 1,22, 4) = (/&
&6.0922E-05_JPRB,3.8139E-03_JPRB,6.5357E-03_JPRB,8.8714E-03_JPRB,1.0461E-02_JPRB/)
KBO( :, 2,22, 4) = (/&
&1.0454E-04_JPRB,4.2277E-03_JPRB,7.0637E-03_JPRB,9.3969E-03_JPRB,1.0774E-02_JPRB/)
KBO( :, 3,22, 4) = (/&
&1.6444E-04_JPRB,4.6414E-03_JPRB,7.5689E-03_JPRB,9.8658E-03_JPRB,1.0980E-02_JPRB/)
KBO( :, 4,22, 4) = (/&
&2.4255E-04_JPRB,5.0640E-03_JPRB,8.0491E-03_JPRB,1.0279E-02_JPRB,1.1093E-02_JPRB/)
KBO( :, 5,22, 4) = (/&
&3.4545E-04_JPRB,5.5019E-03_JPRB,8.5122E-03_JPRB,1.0654E-02_JPRB,1.1125E-02_JPRB/)
KBO( :, 1,23, 4) = (/&
&5.6689E-05_JPRB,3.2067E-03_JPRB,5.4634E-03_JPRB,7.3826E-03_JPRB,8.6316E-03_JPRB/)
KBO( :, 2,23, 4) = (/&
&9.5550E-05_JPRB,3.5483E-03_JPRB,5.8959E-03_JPRB,7.8077E-03_JPRB,8.8675E-03_JPRB/)
KBO( :, 3,23, 4) = (/&
&1.4822E-04_JPRB,3.8901E-03_JPRB,6.3080E-03_JPRB,8.1829E-03_JPRB,9.0160E-03_JPRB/)
KBO( :, 4,23, 4) = (/&
&2.1693E-04_JPRB,4.2438E-03_JPRB,6.7020E-03_JPRB,8.5212E-03_JPRB,9.0932E-03_JPRB/)
KBO( :, 5,23, 4) = (/&
&3.0734E-04_JPRB,4.6091E-03_JPRB,7.0873E-03_JPRB,8.8256E-03_JPRB,9.1050E-03_JPRB/)
KBO( :, 1,24, 4) = (/&
&5.2736E-05_JPRB,2.6949E-03_JPRB,4.5641E-03_JPRB,6.1416E-03_JPRB,7.1164E-03_JPRB/)
KBO( :, 2,24, 4) = (/&
&8.7372E-05_JPRB,2.9764E-03_JPRB,4.9186E-03_JPRB,6.4817E-03_JPRB,7.2904E-03_JPRB/)
KBO( :, 3,24, 4) = (/&
&1.3390E-04_JPRB,3.2620E-03_JPRB,5.2557E-03_JPRB,6.7856E-03_JPRB,7.3982E-03_JPRB/)
KBO( :, 4,24, 4) = (/&
&1.9446E-04_JPRB,3.5561E-03_JPRB,5.5797E-03_JPRB,7.0599E-03_JPRB,7.4464E-03_JPRB/)
KBO( :, 5,24, 4) = (/&
&2.7345E-04_JPRB,3.8596E-03_JPRB,5.8982E-03_JPRB,7.3057E-03_JPRB,7.4438E-03_JPRB/)
KBO( :, 1,25, 4) = (/&
&4.9165E-05_JPRB,2.2652E-03_JPRB,3.8124E-03_JPRB,5.1055E-03_JPRB,5.8623E-03_JPRB/)
KBO( :, 2,25, 4) = (/&
&8.0068E-05_JPRB,2.4983E-03_JPRB,4.1027E-03_JPRB,5.3800E-03_JPRB,5.9915E-03_JPRB/)
KBO( :, 3,25, 4) = (/&
&1.2114E-04_JPRB,2.7360E-03_JPRB,4.3785E-03_JPRB,5.6255E-03_JPRB,6.0673E-03_JPRB/)
KBO( :, 4,25, 4) = (/&
&1.7452E-04_JPRB,2.9807E-03_JPRB,4.6460E-03_JPRB,5.8473E-03_JPRB,6.0957E-03_JPRB/)
KBO( :, 5,25, 4) = (/&
&2.4297E-04_JPRB,3.2336E-03_JPRB,4.9074E-03_JPRB,6.0470E-03_JPRB,6.0845E-03_JPRB/)
KBO( :, 1,26, 4) = (/&
&4.6134E-05_JPRB,1.9065E-03_JPRB,3.1876E-03_JPRB,4.2457E-03_JPRB,4.8285E-03_JPRB/)
KBO( :, 2,26, 4) = (/&
&7.3723E-05_JPRB,2.0998E-03_JPRB,3.4240E-03_JPRB,4.4668E-03_JPRB,4.9227E-03_JPRB/)
KBO( :, 3,26, 4) = (/&
&1.0992E-04_JPRB,2.2971E-03_JPRB,3.6508E-03_JPRB,4.6650E-03_JPRB,4.9747E-03_JPRB/)
KBO( :, 4,26, 4) = (/&
&1.5687E-04_JPRB,2.5009E-03_JPRB,3.8701E-03_JPRB,4.8439E-03_JPRB,4.9884E-03_JPRB/)
KBO( :, 5,26, 4) = (/&
&2.1597E-04_JPRB,2.7132E-03_JPRB,4.0857E-03_JPRB,5.0072E-03_JPRB,4.9727E-03_JPRB/)
KBO( :, 1,27, 4) = (/&
&4.3156E-05_JPRB,1.6045E-03_JPRB,2.6642E-03_JPRB,3.5293E-03_JPRB,3.9753E-03_JPRB/)
KBO( :, 2,27, 4) = (/&
&6.7610E-05_JPRB,1.7645E-03_JPRB,2.8577E-03_JPRB,3.7073E-03_JPRB,4.0435E-03_JPRB/)
KBO( :, 3,27, 4) = (/&
&9.9302E-05_JPRB,1.9283E-03_JPRB,3.0434E-03_JPRB,3.8675E-03_JPRB,4.0783E-03_JPRB/)
KBO( :, 4,27, 4) = (/&
&1.4035E-04_JPRB,2.0987E-03_JPRB,3.2238E-03_JPRB,4.0126E-03_JPRB,4.0827E-03_JPRB/)
KBO( :, 5,27, 4) = (/&
&1.9112E-04_JPRB,2.2790E-03_JPRB,3.4026E-03_JPRB,4.1445E-03_JPRB,4.0645E-03_JPRB/)
KBO( :, 1,28, 4) = (/&
&4.0151E-05_JPRB,1.3496E-03_JPRB,2.2256E-03_JPRB,2.9318E-03_JPRB,3.2709E-03_JPRB/)
KBO( :, 2,28, 4) = (/&
&6.1693E-05_JPRB,1.4821E-03_JPRB,2.3842E-03_JPRB,3.0756E-03_JPRB,3.3203E-03_JPRB/)
KBO( :, 3,28, 4) = (/&
&8.9314E-05_JPRB,1.6183E-03_JPRB,2.5363E-03_JPRB,3.2052E-03_JPRB,3.3423E-03_JPRB/)
KBO( :, 4,28, 4) = (/&
&1.2503E-04_JPRB,1.7621E-03_JPRB,2.6850E-03_JPRB,3.3229E-03_JPRB,3.3419E-03_JPRB/)
KBO( :, 5,28, 4) = (/&
&1.6847E-04_JPRB,1.9159E-03_JPRB,2.8346E-03_JPRB,3.4298E-03_JPRB,3.3234E-03_JPRB/)
KBO( :, 1,29, 4) = (/&
&3.7204E-05_JPRB,1.1357E-03_JPRB,1.8605E-03_JPRB,2.4364E-03_JPRB,2.6925E-03_JPRB/)
KBO( :, 2,29, 4) = (/&
&5.6126E-05_JPRB,1.2453E-03_JPRB,1.9896E-03_JPRB,2.5519E-03_JPRB,2.7276E-03_JPRB/)
KBO( :, 3,29, 4) = (/&
&8.0329E-05_JPRB,1.3596E-03_JPRB,2.1150E-03_JPRB,2.6576E-03_JPRB,2.7417E-03_JPRB/)
KBO( :, 4,29, 4) = (/&
&1.1119E-04_JPRB,1.4821E-03_JPRB,2.2379E-03_JPRB,2.7526E-03_JPRB,2.7376E-03_JPRB/)
KBO( :, 5,29, 4) = (/&
&1.4835E-04_JPRB,1.6135E-03_JPRB,2.3653E-03_JPRB,2.8402E-03_JPRB,2.7209E-03_JPRB/)
KBO( :, 1,30, 4) = (/&
&3.4278E-05_JPRB,9.5541E-04_JPRB,1.5548E-03_JPRB,2.0242E-03_JPRB,2.2164E-03_JPRB/)
KBO( :, 2,30, 4) = (/&
&5.0802E-05_JPRB,1.0465E-03_JPRB,1.6607E-03_JPRB,2.1179E-03_JPRB,2.2411E-03_JPRB/)
KBO( :, 3,30, 4) = (/&
&7.2016E-05_JPRB,1.1433E-03_JPRB,1.7631E-03_JPRB,2.2027E-03_JPRB,2.2491E-03_JPRB/)
KBO( :, 4,30, 4) = (/&
&9.8522E-05_JPRB,1.2484E-03_JPRB,1.8671E-03_JPRB,2.2807E-03_JPRB,2.2444E-03_JPRB/)
KBO( :, 5,30, 4) = (/&
&1.3037E-04_JPRB,1.3590E-03_JPRB,1.9752E-03_JPRB,2.3528E-03_JPRB,2.2289E-03_JPRB/)
KBO( :, 1,31, 4) = (/&
&3.1460E-05_JPRB,8.0377E-04_JPRB,1.2994E-03_JPRB,1.6818E-03_JPRB,1.8252E-03_JPRB/)
KBO( :, 2,31, 4) = (/&
&4.5877E-05_JPRB,8.8014E-04_JPRB,1.3859E-03_JPRB,1.7575E-03_JPRB,1.8427E-03_JPRB/)
KBO( :, 3,31, 4) = (/&
&6.4417E-05_JPRB,9.6356E-04_JPRB,1.4714E-03_JPRB,1.8269E-03_JPRB,1.8476E-03_JPRB/)
KBO( :, 4,31, 4) = (/&
&8.7181E-05_JPRB,1.0525E-03_JPRB,1.5596E-03_JPRB,1.8902E-03_JPRB,1.8422E-03_JPRB/)
KBO( :, 5,31, 4) = (/&
&1.1453E-04_JPRB,1.1450E-03_JPRB,1.6516E-03_JPRB,1.9513E-03_JPRB,1.8286E-03_JPRB/)
KBO( :, 1,32, 4) = (/&
&2.8746E-05_JPRB,6.7650E-04_JPRB,1.0860E-03_JPRB,1.3976E-03_JPRB,1.5036E-03_JPRB/)
KBO( :, 2,32, 4) = (/&
&4.1322E-05_JPRB,7.4162E-04_JPRB,1.1570E-03_JPRB,1.4588E-03_JPRB,1.5157E-03_JPRB/)
KBO( :, 3,32, 4) = (/&
&5.7453E-05_JPRB,8.1295E-04_JPRB,1.2291E-03_JPRB,1.5152E-03_JPRB,1.5184E-03_JPRB/)
KBO( :, 4,32, 4) = (/&
&7.7060E-05_JPRB,8.8760E-04_JPRB,1.3041E-03_JPRB,1.5676E-03_JPRB,1.5130E-03_JPRB/)
KBO( :, 5,32, 4) = (/&
&1.0055E-04_JPRB,9.6447E-04_JPRB,1.3816E-03_JPRB,1.6201E-03_JPRB,1.5011E-03_JPRB/)
KBO( :, 1,33, 4) = (/&
&2.6149E-05_JPRB,5.6986E-04_JPRB,9.0744E-04_JPRB,1.1611E-03_JPRB,1.2388E-03_JPRB/)
KBO( :, 2,33, 4) = (/&
&3.7187E-05_JPRB,6.2590E-04_JPRB,9.6645E-04_JPRB,1.2109E-03_JPRB,1.2475E-03_JPRB/)
KBO( :, 3,33, 4) = (/&
&5.1122E-05_JPRB,6.8620E-04_JPRB,1.0278E-03_JPRB,1.2567E-03_JPRB,1.2488E-03_JPRB/)
KBO( :, 4,33, 4) = (/&
&6.7992E-05_JPRB,7.4863E-04_JPRB,1.0916E-03_JPRB,1.3015E-03_JPRB,1.2439E-03_JPRB/)
KBO( :, 5,33, 4) = (/&
&8.8264E-05_JPRB,8.1165E-04_JPRB,1.1560E-03_JPRB,1.3467E-03_JPRB,1.2339E-03_JPRB/)
KBO( :, 1,34, 4) = (/&
&2.3383E-05_JPRB,4.7914E-04_JPRB,7.5656E-04_JPRB,9.6327E-04_JPRB,1.0201E-03_JPRB/)
KBO( :, 2,34, 4) = (/&
&3.2952E-05_JPRB,5.2698E-04_JPRB,8.0647E-04_JPRB,1.0038E-03_JPRB,1.0263E-03_JPRB/)
KBO( :, 3,34, 4) = (/&
&4.4898E-05_JPRB,5.7759E-04_JPRB,8.5874E-04_JPRB,1.0423E-03_JPRB,1.0268E-03_JPRB/)
KBO( :, 4,34, 4) = (/&
&5.9304E-05_JPRB,6.2906E-04_JPRB,9.1184E-04_JPRB,1.0803E-03_JPRB,1.0223E-03_JPRB/)
KBO( :, 5,34, 4) = (/&
&7.6697E-05_JPRB,6.8025E-04_JPRB,9.6511E-04_JPRB,1.1186E-03_JPRB,1.0139E-03_JPRB/)
KBO( :, 1,35, 4) = (/&
&2.0135E-05_JPRB,3.9961E-04_JPRB,6.2708E-04_JPRB,7.9562E-04_JPRB,8.3915E-04_JPRB/)
KBO( :, 2,35, 4) = (/&
&2.8240E-05_JPRB,4.3984E-04_JPRB,6.6953E-04_JPRB,8.2921E-04_JPRB,8.4431E-04_JPRB/)
KBO( :, 3,35, 4) = (/&
&3.8284E-05_JPRB,4.8179E-04_JPRB,7.1336E-04_JPRB,8.6176E-04_JPRB,8.4473E-04_JPRB/)
KBO( :, 4,35, 4) = (/&
&5.0380E-05_JPRB,5.2399E-04_JPRB,7.5755E-04_JPRB,8.9436E-04_JPRB,8.4105E-04_JPRB/)
KBO( :, 5,35, 4) = (/&
&6.4985E-05_JPRB,5.6538E-04_JPRB,8.0096E-04_JPRB,9.2613E-04_JPRB,8.3390E-04_JPRB/)
KBO( :, 1,36, 4) = (/&
&1.6672E-05_JPRB,3.3001E-04_JPRB,5.1652E-04_JPRB,6.5429E-04_JPRB,6.8995E-04_JPRB/)
KBO( :, 2,36, 4) = (/&
&2.3356E-05_JPRB,3.6341E-04_JPRB,5.5227E-04_JPRB,6.8236E-04_JPRB,6.9447E-04_JPRB/)
KBO( :, 3,36, 4) = (/&
&3.1620E-05_JPRB,3.9798E-04_JPRB,5.8880E-04_JPRB,7.1017E-04_JPRB,6.9516E-04_JPRB/)
KBO( :, 4,36, 4) = (/&
&4.1586E-05_JPRB,4.3228E-04_JPRB,6.2537E-04_JPRB,7.3771E-04_JPRB,6.9235E-04_JPRB/)
KBO( :, 5,36, 4) = (/&
&5.3612E-05_JPRB,4.6581E-04_JPRB,6.6082E-04_JPRB,7.6427E-04_JPRB,6.8669E-04_JPRB/)
KBO( :, 1,37, 4) = (/&
&1.3087E-05_JPRB,2.6849E-04_JPRB,4.2115E-04_JPRB,5.3442E-04_JPRB,5.6613E-04_JPRB/)
KBO( :, 2,37, 4) = (/&
&1.8389E-05_JPRB,2.9596E-04_JPRB,4.5110E-04_JPRB,5.5819E-04_JPRB,5.7060E-04_JPRB/)
KBO( :, 3,37, 4) = (/&
&2.4989E-05_JPRB,3.2427E-04_JPRB,4.8144E-04_JPRB,5.8191E-04_JPRB,5.7172E-04_JPRB/)
KBO( :, 4,37, 4) = (/&
&3.2975E-05_JPRB,3.5221E-04_JPRB,5.1177E-04_JPRB,6.0525E-04_JPRB,5.6998E-04_JPRB/)
KBO( :, 5,37, 4) = (/&
&4.2603E-05_JPRB,3.7949E-04_JPRB,5.4072E-04_JPRB,6.2738E-04_JPRB,5.6571E-04_JPRB/)
KBO( :, 1,38, 4) = (/&
&1.0230E-05_JPRB,2.1818E-04_JPRB,3.4316E-04_JPRB,4.3622E-04_JPRB,4.6452E-04_JPRB/)
KBO( :, 2,38, 4) = (/&
&1.4428E-05_JPRB,2.4074E-04_JPRB,3.6819E-04_JPRB,4.5640E-04_JPRB,4.6888E-04_JPRB/)
KBO( :, 3,38, 4) = (/&
&1.9697E-05_JPRB,2.6389E-04_JPRB,3.9346E-04_JPRB,4.7668E-04_JPRB,4.7037E-04_JPRB/)
KBO( :, 4,38, 4) = (/&
&2.6076E-05_JPRB,2.8667E-04_JPRB,4.1847E-04_JPRB,4.9632E-04_JPRB,4.6943E-04_JPRB/)
KBO( :, 5,38, 4) = (/&
&3.3772E-05_JPRB,3.0890E-04_JPRB,4.4212E-04_JPRB,5.1488E-04_JPRB,4.6632E-04_JPRB/)
KBO( :, 1,39, 4) = (/&
&7.9957E-06_JPRB,1.7734E-04_JPRB,2.7964E-04_JPRB,3.5608E-04_JPRB,3.8137E-04_JPRB/)
KBO( :, 2,39, 4) = (/&
&1.1315E-05_JPRB,1.9578E-04_JPRB,3.0056E-04_JPRB,3.7320E-04_JPRB,3.8548E-04_JPRB/)
KBO( :, 3,39, 4) = (/&
&1.5521E-05_JPRB,2.1469E-04_JPRB,3.2152E-04_JPRB,3.9044E-04_JPRB,3.8726E-04_JPRB/)
KBO( :, 4,39, 4) = (/&
&2.0623E-05_JPRB,2.3327E-04_JPRB,3.4211E-04_JPRB,4.0694E-04_JPRB,3.8696E-04_JPRB/)
KBO( :, 5,39, 4) = (/&
&2.6775E-05_JPRB,2.5145E-04_JPRB,3.6146E-04_JPRB,4.2258E-04_JPRB,3.8472E-04_JPRB/)
KBO( :, 1,40, 4) = (/&
&6.0059E-06_JPRB,1.4255E-04_JPRB,2.2608E-04_JPRB,2.8913E-04_JPRB,3.1195E-04_JPRB/)
KBO( :, 2,40, 4) = (/&
&8.5603E-06_JPRB,1.5759E-04_JPRB,2.4350E-04_JPRB,3.0367E-04_JPRB,3.1602E-04_JPRB/)
KBO( :, 3,40, 4) = (/&
&1.1848E-05_JPRB,1.7303E-04_JPRB,2.6092E-04_JPRB,3.1829E-04_JPRB,3.1800E-04_JPRB/)
KBO( :, 4,40, 4) = (/&
&1.5848E-05_JPRB,1.8824E-04_JPRB,2.7792E-04_JPRB,3.3233E-04_JPRB,3.1813E-04_JPRB/)
KBO( :, 5,40, 4) = (/&
&2.0655E-05_JPRB,2.0317E-04_JPRB,2.9386E-04_JPRB,3.4558E-04_JPRB,3.1680E-04_JPRB/)
KBO( :, 1,41, 4) = (/&
&4.4737E-06_JPRB,1.1440E-04_JPRB,1.8254E-04_JPRB,2.3457E-04_JPRB,2.5497E-04_JPRB/)
KBO( :, 2,41, 4) = (/&
&6.4501E-06_JPRB,1.2664E-04_JPRB,1.9704E-04_JPRB,2.4685E-04_JPRB,2.5884E-04_JPRB/)
KBO( :, 3,41, 4) = (/&
&8.9908E-06_JPRB,1.3923E-04_JPRB,2.1149E-04_JPRB,2.5926E-04_JPRB,2.6097E-04_JPRB/)
KBO( :, 4,41, 4) = (/&
&1.2113E-05_JPRB,1.5171E-04_JPRB,2.2552E-04_JPRB,2.7117E-04_JPRB,2.6150E-04_JPRB/)
KBO( :, 5,41, 4) = (/&
&1.5882E-05_JPRB,1.6391E-04_JPRB,2.3860E-04_JPRB,2.8232E-04_JPRB,2.6072E-04_JPRB/)
KBO( :, 1,42, 4) = (/&
&3.3198E-06_JPRB,9.1718E-05_JPRB,1.4723E-04_JPRB,1.9011E-04_JPRB,2.0829E-04_JPRB/)
KBO( :, 2,42, 4) = (/&
&4.8502E-06_JPRB,1.0170E-04_JPRB,1.5931E-04_JPRB,2.0051E-04_JPRB,2.1195E-04_JPRB/)
KBO( :, 3,42, 4) = (/&
&6.8039E-06_JPRB,1.1200E-04_JPRB,1.7132E-04_JPRB,2.1108E-04_JPRB,2.1414E-04_JPRB/)
KBO( :, 4,42, 4) = (/&
&9.2426E-06_JPRB,1.2222E-04_JPRB,1.8289E-04_JPRB,2.2117E-04_JPRB,2.1495E-04_JPRB/)
KBO( :, 5,42, 4) = (/&
&1.2195E-05_JPRB,1.3221E-04_JPRB,1.9367E-04_JPRB,2.3056E-04_JPRB,2.1462E-04_JPRB/)
KBO( :, 1,43, 4) = (/&
&2.3953E-06_JPRB,7.3035E-05_JPRB,1.1812E-04_JPRB,1.5350E-04_JPRB,1.6984E-04_JPRB/)
KBO( :, 2,43, 4) = (/&
&3.5612E-06_JPRB,8.1187E-05_JPRB,1.2819E-04_JPRB,1.6232E-04_JPRB,1.7330E-04_JPRB/)
KBO( :, 3,43, 4) = (/&
&5.0399E-06_JPRB,8.9542E-05_JPRB,1.3813E-04_JPRB,1.7126E-04_JPRB,1.7552E-04_JPRB/)
KBO( :, 4,43, 4) = (/&
&6.9214E-06_JPRB,9.7944E-05_JPRB,1.4772E-04_JPRB,1.7984E-04_JPRB,1.7653E-04_JPRB/)
KBO( :, 5,43, 4) = (/&
&9.2081E-06_JPRB,1.0615E-04_JPRB,1.5668E-04_JPRB,1.8781E-04_JPRB,1.7659E-04_JPRB/)
KBO( :, 1,44, 4) = (/&
&1.6976E-06_JPRB,5.7928E-05_JPRB,9.4481E-05_JPRB,1.2365E-04_JPRB,1.3829E-04_JPRB/)
KBO( :, 2,44, 4) = (/&
&2.5776E-06_JPRB,6.4569E-05_JPRB,1.0281E-04_JPRB,1.3107E-04_JPRB,1.4154E-04_JPRB/)
KBO( :, 3,44, 4) = (/&
&3.6914E-06_JPRB,7.1395E-05_JPRB,1.1108E-04_JPRB,1.3867E-04_JPRB,1.4376E-04_JPRB/)
KBO( :, 4,44, 4) = (/&
&5.1284E-06_JPRB,7.8255E-05_JPRB,1.1905E-04_JPRB,1.4597E-04_JPRB,1.4496E-04_JPRB/)
KBO( :, 5,44, 4) = (/&
&6.8839E-06_JPRB,8.5009E-05_JPRB,1.2651E-04_JPRB,1.5274E-04_JPRB,1.4528E-04_JPRB/)
KBO( :, 1,45, 4) = (/&
&1.1934E-06_JPRB,4.5877E-05_JPRB,7.5459E-05_JPRB,9.9465E-05_JPRB,1.1252E-04_JPRB/)
KBO( :, 2,45, 4) = (/&
&1.8535E-06_JPRB,5.1319E-05_JPRB,8.2366E-05_JPRB,1.0575E-04_JPRB,1.1552E-04_JPRB/)
KBO( :, 3,45, 4) = (/&
&2.7008E-06_JPRB,5.6880E-05_JPRB,8.9246E-05_JPRB,1.1216E-04_JPRB,1.1771E-04_JPRB/)
KBO( :, 4,45, 4) = (/&
&3.7837E-06_JPRB,6.2494E-05_JPRB,9.5875E-05_JPRB,1.1839E-04_JPRB,1.1899E-04_JPRB/)
KBO( :, 5,45, 4) = (/&
&5.1348E-06_JPRB,6.8027E-05_JPRB,1.0210E-04_JPRB,1.2412E-04_JPRB,1.1954E-04_JPRB/)
KBO( :, 1,46, 4) = (/&
&8.2182E-07_JPRB,3.6187E-05_JPRB,6.0090E-05_JPRB,7.9818E-05_JPRB,9.1376E-05_JPRB/)
KBO( :, 2,46, 4) = (/&
&1.3116E-06_JPRB,4.0642E-05_JPRB,6.5780E-05_JPRB,8.5120E-05_JPRB,9.4184E-05_JPRB/)
KBO( :, 3,46, 4) = (/&
&1.9501E-06_JPRB,4.5184E-05_JPRB,7.1520E-05_JPRB,9.0515E-05_JPRB,9.6278E-05_JPRB/)
KBO( :, 4,46, 4) = (/&
&2.7596E-06_JPRB,4.9774E-05_JPRB,7.7042E-05_JPRB,9.5816E-05_JPRB,9.7611E-05_JPRB/)
KBO( :, 5,46, 4) = (/&
&3.7920E-06_JPRB,5.4316E-05_JPRB,8.2245E-05_JPRB,1.0070E-04_JPRB,9.8321E-05_JPRB/)
KBO( :, 1,47, 4) = (/&
&5.4572E-07_JPRB,2.8352E-05_JPRB,4.7590E-05_JPRB,6.3770E-05_JPRB,7.3936E-05_JPRB/)
KBO( :, 2,47, 4) = (/&
&9.0249E-07_JPRB,3.1986E-05_JPRB,5.2255E-05_JPRB,6.8238E-05_JPRB,7.6557E-05_JPRB/)
KBO( :, 3,47, 4) = (/&
&1.3764E-06_JPRB,3.5691E-05_JPRB,5.7035E-05_JPRB,7.2769E-05_JPRB,7.8547E-05_JPRB/)
KBO( :, 4,47, 4) = (/&
&1.9784E-06_JPRB,3.9441E-05_JPRB,6.1643E-05_JPRB,7.7278E-05_JPRB,7.9920E-05_JPRB/)
KBO( :, 5,47, 4) = (/&
&2.7518E-06_JPRB,4.3171E-05_JPRB,6.6014E-05_JPRB,8.1443E-05_JPRB,8.0725E-05_JPRB/)
KBO( :, 1,48, 4) = (/&
&3.5613E-07_JPRB,2.2167E-05_JPRB,3.7637E-05_JPRB,5.0854E-05_JPRB,5.9741E-05_JPRB/)
KBO( :, 2,48, 4) = (/&
&6.1385E-07_JPRB,2.5120E-05_JPRB,4.1451E-05_JPRB,5.4622E-05_JPRB,6.2174E-05_JPRB/)
KBO( :, 3,48, 4) = (/&
&9.6245E-07_JPRB,2.8151E-05_JPRB,4.5401E-05_JPRB,5.8409E-05_JPRB,6.4024E-05_JPRB/)
KBO( :, 4,48, 4) = (/&
&1.4130E-06_JPRB,3.1220E-05_JPRB,4.9258E-05_JPRB,6.2234E-05_JPRB,6.5397E-05_JPRB/)
KBO( :, 5,48, 4) = (/&
&1.9862E-06_JPRB,3.4268E-05_JPRB,5.2922E-05_JPRB,6.5784E-05_JPRB,6.6274E-05_JPRB/)
KBO( :, 1,49, 4) = (/&
&2.2854E-07_JPRB,1.7300E-05_JPRB,2.9705E-05_JPRB,4.0466E-05_JPRB,4.8198E-05_JPRB/)
KBO( :, 2,49, 4) = (/&
&4.1152E-07_JPRB,1.9683E-05_JPRB,3.2825E-05_JPRB,4.3649E-05_JPRB,5.0447E-05_JPRB/)
KBO( :, 3,49, 4) = (/&
&6.6605E-07_JPRB,2.2175E-05_JPRB,3.6088E-05_JPRB,4.6825E-05_JPRB,5.2181E-05_JPRB/)
KBO( :, 4,49, 4) = (/&
&1.0015E-06_JPRB,2.4680E-05_JPRB,3.9305E-05_JPRB,5.0044E-05_JPRB,5.3514E-05_JPRB/)
KBO( :, 5,49, 4) = (/&
&1.4253E-06_JPRB,2.7183E-05_JPRB,4.2380E-05_JPRB,5.3073E-05_JPRB,5.4435E-05_JPRB/)
KBO( :, 1,50, 4) = (/&
&1.4675E-07_JPRB,1.3524E-05_JPRB,2.3463E-05_JPRB,3.2195E-05_JPRB,3.8796E-05_JPRB/)
KBO( :, 2,50, 4) = (/&
&2.7518E-07_JPRB,1.5442E-05_JPRB,2.6020E-05_JPRB,3.4887E-05_JPRB,4.0832E-05_JPRB/)
KBO( :, 3,50, 4) = (/&
&4.6153E-07_JPRB,1.7480E-05_JPRB,2.8694E-05_JPRB,3.7541E-05_JPRB,4.2427E-05_JPRB/)
KBO( :, 4,50, 4) = (/&
&7.1099E-07_JPRB,1.9535E-05_JPRB,3.1383E-05_JPRB,4.0252E-05_JPRB,4.3676E-05_JPRB/)
KBO( :, 5,50, 4) = (/&
&1.0304E-06_JPRB,2.1596E-05_JPRB,3.3959E-05_JPRB,4.2830E-05_JPRB,4.4585E-05_JPRB/)
KBO( :, 1,51, 4) = (/&
&9.3830E-08_JPRB,1.0573E-05_JPRB,1.8529E-05_JPRB,2.5594E-05_JPRB,3.1167E-05_JPRB/)
KBO( :, 2,51, 4) = (/&
&1.8257E-07_JPRB,1.2113E-05_JPRB,2.0626E-05_JPRB,2.7865E-05_JPRB,3.2983E-05_JPRB/)
KBO( :, 3,51, 4) = (/&
&3.1815E-07_JPRB,1.3777E-05_JPRB,2.2807E-05_JPRB,3.0085E-05_JPRB,3.4435E-05_JPRB/)
KBO( :, 4,51, 4) = (/&
&5.0296E-07_JPRB,1.5465E-05_JPRB,2.5047E-05_JPRB,3.2352E-05_JPRB,3.5572E-05_JPRB/)
KBO( :, 5,51, 4) = (/&
&7.4372E-07_JPRB,1.7150E-05_JPRB,2.7196E-05_JPRB,3.4538E-05_JPRB,3.6442E-05_JPRB/)
KBO( :, 1,52, 4) = (/&
&5.9402E-08_JPRB,8.2536E-06_JPRB,1.4613E-05_JPRB,2.0313E-05_JPRB,2.4997E-05_JPRB/)
KBO( :, 2,52, 4) = (/&
&1.1950E-07_JPRB,9.4874E-06_JPRB,1.6325E-05_JPRB,2.2218E-05_JPRB,2.6608E-05_JPRB/)
KBO( :, 3,52, 4) = (/&
&2.1668E-07_JPRB,1.0839E-05_JPRB,1.8107E-05_JPRB,2.4086E-05_JPRB,2.7927E-05_JPRB/)
KBO( :, 4,52, 4) = (/&
&3.5284E-07_JPRB,1.2223E-05_JPRB,1.9960E-05_JPRB,2.5966E-05_JPRB,2.8965E-05_JPRB/)
KBO( :, 5,52, 4) = (/&
&5.3348E-07_JPRB,1.3609E-05_JPRB,2.1758E-05_JPRB,2.7822E-05_JPRB,2.9780E-05_JPRB/)
KBO( :, 1,53, 4) = (/&
&3.7345E-08_JPRB,6.4324E-06_JPRB,1.1502E-05_JPRB,1.6089E-05_JPRB,2.0014E-05_JPRB/)
KBO( :, 2,53, 4) = (/&
&7.7125E-08_JPRB,7.4212E-06_JPRB,1.2900E-05_JPRB,1.7682E-05_JPRB,2.1442E-05_JPRB/)
KBO( :, 3,53, 4) = (/&
&1.4542E-07_JPRB,8.5076E-06_JPRB,1.4352E-05_JPRB,1.9246E-05_JPRB,2.2631E-05_JPRB/)
KBO( :, 4,53, 4) = (/&
&2.4523E-07_JPRB,9.6460E-06_JPRB,1.5883E-05_JPRB,2.0812E-05_JPRB,2.3585E-05_JPRB/)
KBO( :, 5,53, 4) = (/&
&3.7962E-07_JPRB,1.0784E-05_JPRB,1.7382E-05_JPRB,2.2378E-05_JPRB,2.4349E-05_JPRB/)
KBO( :, 1,54, 4) = (/&
&2.4018E-08_JPRB,5.0298E-06_JPRB,9.0727E-06_JPRB,1.2757E-05_JPRB,1.5972E-05_JPRB/)
KBO( :, 2,54, 4) = (/&
&5.0282E-08_JPRB,5.8191E-06_JPRB,1.0210E-05_JPRB,1.4083E-05_JPRB,1.7202E-05_JPRB/)
KBO( :, 3,54, 4) = (/&
&9.8093E-08_JPRB,6.6934E-06_JPRB,1.1398E-05_JPRB,1.5393E-05_JPRB,1.8246E-05_JPRB/)
KBO( :, 4,54, 4) = (/&
&1.7136E-07_JPRB,7.6261E-06_JPRB,1.2653E-05_JPRB,1.6695E-05_JPRB,1.9090E-05_JPRB/)
KBO( :, 5,54, 4) = (/&
&2.7159E-07_JPRB,8.5620E-06_JPRB,1.3903E-05_JPRB,1.8013E-05_JPRB,1.9768E-05_JPRB/)
KBO( :, 1,55, 4) = (/&
&1.5705E-08_JPRB,3.9361E-06_JPRB,7.1560E-06_JPRB,1.0111E-05_JPRB,1.2713E-05_JPRB/)
KBO( :, 2,55, 4) = (/&
&3.2852E-08_JPRB,4.5671E-06_JPRB,8.0833E-06_JPRB,1.1215E-05_JPRB,1.3756E-05_JPRB/)
KBO( :, 3,55, 4) = (/&
&6.5995E-08_JPRB,5.2691E-06_JPRB,9.0558E-06_JPRB,1.2309E-05_JPRB,1.4658E-05_JPRB/)
KBO( :, 4,55, 4) = (/&
&1.1933E-07_JPRB,6.0307E-06_JPRB,1.0082E-05_JPRB,1.3396E-05_JPRB,1.5392E-05_JPRB/)
KBO( :, 5,55, 4) = (/&
&1.9407E-07_JPRB,6.7994E-06_JPRB,1.1122E-05_JPRB,1.4497E-05_JPRB,1.5981E-05_JPRB/)
KBO( :, 1,56, 4) = (/&
&1.0423E-08_JPRB,3.0764E-06_JPRB,5.6365E-06_JPRB,8.0036E-06_JPRB,1.0107E-05_JPRB/)
KBO( :, 2,56, 4) = (/&
&2.1352E-08_JPRB,3.5821E-06_JPRB,6.3947E-06_JPRB,8.9204E-06_JPRB,1.0989E-05_JPRB/)
KBO( :, 3,56, 4) = (/&
&4.3941E-08_JPRB,4.1425E-06_JPRB,7.1860E-06_JPRB,9.8275E-06_JPRB,1.1759E-05_JPRB/)
KBO( :, 4,56, 4) = (/&
&8.2219E-08_JPRB,4.7612E-06_JPRB,8.0218E-06_JPRB,1.0735E-05_JPRB,1.2399E-05_JPRB/)
KBO( :, 5,56, 4) = (/&
&1.3782E-07_JPRB,5.3933E-06_JPRB,8.8859E-06_JPRB,1.1651E-05_JPRB,1.2911E-05_JPRB/)
KBO( :, 1,57, 4) = (/&
&7.0716E-09_JPRB,2.4016E-06_JPRB,4.4336E-06_JPRB,6.3273E-06_JPRB,8.0236E-06_JPRB/)
KBO( :, 2,57, 4) = (/&
&1.3864E-08_JPRB,2.8058E-06_JPRB,5.0502E-06_JPRB,7.0825E-06_JPRB,8.7616E-06_JPRB/)
KBO( :, 3,57, 4) = (/&
&2.8989E-08_JPRB,3.2523E-06_JPRB,5.6949E-06_JPRB,7.8345E-06_JPRB,9.4204E-06_JPRB/)
KBO( :, 4,57, 4) = (/&
&5.6049E-08_JPRB,3.7535E-06_JPRB,6.3764E-06_JPRB,8.5926E-06_JPRB,9.9758E-06_JPRB/)
KBO( :, 5,57, 4) = (/&
&9.7119E-08_JPRB,4.2717E-06_JPRB,7.0902E-06_JPRB,9.3510E-06_JPRB,1.0422E-05_JPRB/)
KBO( :, 1,58, 4) = (/&
&4.9738E-09_JPRB,1.8772E-06_JPRB,3.4889E-06_JPRB,5.0033E-06_JPRB,6.3670E-06_JPRB/)
KBO( :, 2,58, 4) = (/&
&9.1491E-09_JPRB,2.2003E-06_JPRB,3.9908E-06_JPRB,5.6234E-06_JPRB,6.9822E-06_JPRB/)
KBO( :, 3,58, 4) = (/&
&1.9204E-08_JPRB,2.5577E-06_JPRB,4.5175E-06_JPRB,6.2482E-06_JPRB,7.5411E-06_JPRB/)
KBO( :, 4,58, 4) = (/&
&3.8223E-08_JPRB,2.9606E-06_JPRB,5.0708E-06_JPRB,6.8776E-06_JPRB,8.0170E-06_JPRB/)
KBO( :, 5,58, 4) = (/&
&6.8398E-08_JPRB,3.3850E-06_JPRB,5.6590E-06_JPRB,7.5062E-06_JPRB,8.4029E-06_JPRB/)
KBO( :, 1,59, 4) = (/&
&3.8735E-09_JPRB,1.5107E-06_JPRB,2.8146E-06_JPRB,4.0428E-06_JPRB,5.1269E-06_JPRB/)
KBO( :, 2,59, 4) = (/&
&6.9185E-09_JPRB,1.7736E-06_JPRB,3.2266E-06_JPRB,4.5533E-06_JPRB,5.6260E-06_JPRB/)
KBO( :, 3,59, 4) = (/&
&1.4484E-08_JPRB,2.0648E-06_JPRB,3.6588E-06_JPRB,5.0704E-06_JPRB,6.0775E-06_JPRB/)
KBO( :, 4,59, 4) = (/&
&2.9105E-08_JPRB,2.3952E-06_JPRB,4.1152E-06_JPRB,5.5930E-06_JPRB,6.4648E-06_JPRB/)
KBO( :, 5,59, 4) = (/&
&5.2712E-08_JPRB,2.7434E-06_JPRB,4.6004E-06_JPRB,6.1168E-06_JPRB,6.7765E-06_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB5_B1
