!OCL SCALAR
SUBROUTINE RRTM_KGB5_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 5:  700-820 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO5 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, CCL4O
USE YOERRTA5 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 9 and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 9 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature TREF-15, 
!     JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 9) = (/&
&1.0292E-02_JPRB,1.0074E-02_JPRB,1.0433E-02_JPRB,1.0920E-02_JPRB,1.1239E-02_JPRB,1.1304E-02_JPRB,&
&1.1018E-02_JPRB,9.9412E-03_JPRB,1.0267E-02_JPRB/)
KAO( :, 2, 1, 9) = (/&
&1.2495E-02_JPRB,1.2453E-02_JPRB,1.3049E-02_JPRB,1.3792E-02_JPRB,1.4278E-02_JPRB,1.4496E-02_JPRB,&
&1.4236E-02_JPRB,1.3361E-02_JPRB,1.3925E-02_JPRB/)
KAO( :, 3, 1, 9) = (/&
&1.4859E-02_JPRB,1.5091E-02_JPRB,1.6017E-02_JPRB,1.7045E-02_JPRB,1.7806E-02_JPRB,1.8195E-02_JPRB,&
&1.7952E-02_JPRB,1.7365E-02_JPRB,1.8464E-02_JPRB/)
KAO( :, 4, 1, 9) = (/&
&1.7363E-02_JPRB,1.7942E-02_JPRB,1.9281E-02_JPRB,2.0718E-02_JPRB,2.1801E-02_JPRB,2.2424E-02_JPRB,&
&2.2300E-02_JPRB,2.2092E-02_JPRB,2.3948E-02_JPRB/)
KAO( :, 5, 1, 9) = (/&
&1.9984E-02_JPRB,2.1018E-02_JPRB,2.2868E-02_JPRB,2.4808E-02_JPRB,2.6324E-02_JPRB,2.7242E-02_JPRB,&
&2.7276E-02_JPRB,2.7701E-02_JPRB,3.0488E-02_JPRB/)
KAO( :, 1, 2, 9) = (/&
&9.5128E-03_JPRB,9.2867E-03_JPRB,9.5490E-03_JPRB,9.8633E-03_JPRB,1.0027E-02_JPRB,1.0058E-02_JPRB,&
&9.7636E-03_JPRB,8.7994E-03_JPRB,8.5570E-03_JPRB/)
KAO( :, 2, 2, 9) = (/&
&1.1668E-02_JPRB,1.1584E-02_JPRB,1.2077E-02_JPRB,1.2559E-02_JPRB,1.2920E-02_JPRB,1.3060E-02_JPRB,&
&1.2825E-02_JPRB,1.1983E-02_JPRB,1.1751E-02_JPRB/)
KAO( :, 3, 2, 9) = (/&
&1.4011E-02_JPRB,1.4151E-02_JPRB,1.4940E-02_JPRB,1.5660E-02_JPRB,1.6284E-02_JPRB,1.6579E-02_JPRB,&
&1.6367E-02_JPRB,1.5804E-02_JPRB,1.5742E-02_JPRB/)
KAO( :, 4, 2, 9) = (/&
&1.6508E-02_JPRB,1.6961E-02_JPRB,1.8102E-02_JPRB,1.9197E-02_JPRB,2.0137E-02_JPRB,2.0668E-02_JPRB,&
&2.0505E-02_JPRB,2.0318E-02_JPRB,2.0610E-02_JPRB/)
KAO( :, 5, 2, 9) = (/&
&1.9122E-02_JPRB,2.0006E-02_JPRB,2.1590E-02_JPRB,2.3174E-02_JPRB,2.4520E-02_JPRB,2.5288E-02_JPRB,&
&2.5261E-02_JPRB,2.5631E-02_JPRB,2.6467E-02_JPRB/)
KAO( :, 1, 3, 9) = (/&
&8.4316E-03_JPRB,8.1842E-03_JPRB,8.3414E-03_JPRB,8.4601E-03_JPRB,8.4527E-03_JPRB,8.3467E-03_JPRB,&
&8.0420E-03_JPRB,7.1142E-03_JPRB,6.5461E-03_JPRB/)
KAO( :, 2, 3, 9) = (/&
&1.0508E-02_JPRB,1.0365E-02_JPRB,1.0700E-02_JPRB,1.0941E-02_JPRB,1.1049E-02_JPRB,1.1031E-02_JPRB,&
&1.0751E-02_JPRB,9.9386E-03_JPRB,9.1449E-03_JPRB/)
KAO( :, 3, 3, 9) = (/&
&1.2785E-02_JPRB,1.2829E-02_JPRB,1.3389E-02_JPRB,1.3825E-02_JPRB,1.4105E-02_JPRB,1.4232E-02_JPRB,&
&1.3991E-02_JPRB,1.3420E-02_JPRB,1.2428E-02_JPRB/)
KAO( :, 4, 3, 9) = (/&
&1.5245E-02_JPRB,1.5545E-02_JPRB,1.6390E-02_JPRB,1.7132E-02_JPRB,1.7666E-02_JPRB,1.7977E-02_JPRB,&
&1.7716E-02_JPRB,1.7486E-02_JPRB,1.6472E-02_JPRB/)
KAO( :, 5, 3, 9) = (/&
&1.7859E-02_JPRB,1.8505E-02_JPRB,1.9736E-02_JPRB,2.0852E-02_JPRB,2.1757E-02_JPRB,2.2224E-02_JPRB,&
&2.2056E-02_JPRB,2.2280E-02_JPRB,2.1403E-02_JPRB/)
KAO( :, 1, 4, 9) = (/&
&7.3484E-03_JPRB,7.0902E-03_JPRB,7.1380E-03_JPRB,7.1024E-03_JPRB,6.9776E-03_JPRB,6.7400E-03_JPRB,&
&6.3521E-03_JPRB,5.4673E-03_JPRB,4.8295E-03_JPRB/)
KAO( :, 2, 4, 9) = (/&
&9.3310E-03_JPRB,9.1397E-03_JPRB,9.3159E-03_JPRB,9.3538E-03_JPRB,9.2681E-03_JPRB,9.0554E-03_JPRB,&
&8.7344E-03_JPRB,7.9076E-03_JPRB,6.8828E-03_JPRB/)
KAO( :, 3, 4, 9) = (/&
&1.1534E-02_JPRB,1.1475E-02_JPRB,1.1819E-02_JPRB,1.1988E-02_JPRB,1.2000E-02_JPRB,1.1864E-02_JPRB,&
&1.1575E-02_JPRB,1.0994E-02_JPRB,9.4901E-03_JPRB/)
KAO( :, 4, 4, 9) = (/&
&1.3943E-02_JPRB,1.4087E-02_JPRB,1.4649E-02_JPRB,1.5032E-02_JPRB,1.5214E-02_JPRB,1.5176E-02_JPRB,&
&1.4865E-02_JPRB,1.4524E-02_JPRB,1.2777E-02_JPRB/)
KAO( :, 5, 4, 9) = (/&
&1.6517E-02_JPRB,1.6976E-02_JPRB,1.7827E-02_JPRB,1.8519E-02_JPRB,1.8920E-02_JPRB,1.9000E-02_JPRB,&
&1.8720E-02_JPRB,1.8746E-02_JPRB,1.6804E-02_JPRB/)
KAO( :, 1, 5, 9) = (/&
&6.3624E-03_JPRB,6.1133E-03_JPRB,6.0634E-03_JPRB,5.9330E-03_JPRB,5.7181E-03_JPRB,5.4022E-03_JPRB,&
&4.9483E-03_JPRB,4.1022E-03_JPRB,3.4892E-03_JPRB/)
KAO( :, 2, 5, 9) = (/&
&8.2407E-03_JPRB,8.0303E-03_JPRB,8.0632E-03_JPRB,7.9504E-03_JPRB,7.7253E-03_JPRB,7.3962E-03_JPRB,&
&6.9698E-03_JPRB,6.1767E-03_JPRB,5.0748E-03_JPRB/)
KAO( :, 3, 5, 9) = (/&
&1.0363E-02_JPRB,1.0246E-02_JPRB,1.0387E-02_JPRB,1.0335E-02_JPRB,1.0149E-02_JPRB,9.8386E-03_JPRB,&
&9.4225E-03_JPRB,8.8118E-03_JPRB,7.1402E-03_JPRB/)
KAO( :, 4, 5, 9) = (/&
&1.2695E-02_JPRB,1.2755E-02_JPRB,1.3046E-02_JPRB,1.3138E-02_JPRB,1.3029E-02_JPRB,1.2750E-02_JPRB,&
&1.2327E-02_JPRB,1.1882E-02_JPRB,9.7414E-03_JPRB/)
KAO( :, 5, 5, 9) = (/&
&1.5221E-02_JPRB,1.5544E-02_JPRB,1.6067E-02_JPRB,1.6367E-02_JPRB,1.6363E-02_JPRB,1.6145E-02_JPRB,&
&1.5702E-02_JPRB,1.5530E-02_JPRB,1.2966E-02_JPRB/)
KAO( :, 1, 6, 9) = (/&
&5.3819E-03_JPRB,5.1682E-03_JPRB,5.0489E-03_JPRB,4.8682E-03_JPRB,4.6033E-03_JPRB,4.2570E-03_JPRB,&
&3.7892E-03_JPRB,2.8608E-03_JPRB,2.4512E-03_JPRB/)
KAO( :, 2, 6, 9) = (/&
&7.1280E-03_JPRB,6.9367E-03_JPRB,6.8489E-03_JPRB,6.6487E-03_JPRB,6.3384E-03_JPRB,5.9570E-03_JPRB,&
&5.4784E-03_JPRB,4.6646E-03_JPRB,3.6355E-03_JPRB/)
KAO( :, 3, 6, 9) = (/&
&9.1302E-03_JPRB,9.0145E-03_JPRB,8.9822E-03_JPRB,8.7868E-03_JPRB,8.4616E-03_JPRB,8.0561E-03_JPRB,&
&7.5662E-03_JPRB,6.8605E-03_JPRB,5.2018E-03_JPRB/)
KAO( :, 4, 6, 9) = (/&
&1.1358E-02_JPRB,1.1388E-02_JPRB,1.1456E-02_JPRB,1.1318E-02_JPRB,1.1012E-02_JPRB,1.0595E-02_JPRB,&
&1.0058E-02_JPRB,9.4902E-03_JPRB,7.2223E-03_JPRB/)
KAO( :, 5, 6, 9) = (/&
&1.3798E-02_JPRB,1.4041E-02_JPRB,1.4287E-02_JPRB,1.4257E-02_JPRB,1.3997E-02_JPRB,1.3586E-02_JPRB,&
&1.2991E-02_JPRB,1.2596E-02_JPRB,9.7278E-03_JPRB/)
KAO( :, 1, 7, 9) = (/&
&4.4201E-03_JPRB,4.2655E-03_JPRB,4.1450E-03_JPRB,3.9476E-03_JPRB,3.6722E-03_JPRB,3.3249E-03_JPRB,&
&2.8458E-03_JPRB,1.9671E-03_JPRB,1.7803E-03_JPRB/)
KAO( :, 2, 7, 9) = (/&
&5.9991E-03_JPRB,5.8588E-03_JPRB,5.7556E-03_JPRB,5.5028E-03_JPRB,5.1661E-03_JPRB,4.7702E-03_JPRB,&
&4.2756E-03_JPRB,3.4608E-03_JPRB,2.6084E-03_JPRB/)
KAO( :, 3, 7, 9) = (/&
&7.8395E-03_JPRB,7.7643E-03_JPRB,7.6944E-03_JPRB,7.4017E-03_JPRB,7.0170E-03_JPRB,6.5646E-03_JPRB,&
&6.0423E-03_JPRB,5.2630E-03_JPRB,3.7628E-03_JPRB/)
KAO( :, 4, 7, 9) = (/&
&9.9189E-03_JPRB,9.9815E-03_JPRB,9.9658E-03_JPRB,9.6723E-03_JPRB,9.2685E-03_JPRB,8.7611E-03_JPRB,&
&8.1722E-03_JPRB,7.4723E-03_JPRB,5.2872E-03_JPRB/)
KAO( :, 5, 7, 9) = (/&
&1.2224E-02_JPRB,1.2487E-02_JPRB,1.2587E-02_JPRB,1.2338E-02_JPRB,1.1918E-02_JPRB,1.1379E-02_JPRB,&
&1.0715E-02_JPRB,1.0101E-02_JPRB,7.2253E-03_JPRB/)
KAO( :, 1, 8, 9) = (/&
&3.5350E-03_JPRB,3.4325E-03_JPRB,3.3275E-03_JPRB,3.1605E-03_JPRB,2.8988E-03_JPRB,2.5686E-03_JPRB,&
&2.1091E-03_JPRB,1.2955E-03_JPRB,2.2677E-03_JPRB/)
KAO( :, 2, 8, 9) = (/&
&4.9245E-03_JPRB,4.8341E-03_JPRB,4.7376E-03_JPRB,4.5164E-03_JPRB,4.1844E-03_JPRB,3.7894E-03_JPRB,&
&3.3070E-03_JPRB,2.4762E-03_JPRB,2.6602E-03_JPRB/)
KAO( :, 3, 8, 9) = (/&
&6.5727E-03_JPRB,6.5413E-03_JPRB,6.4715E-03_JPRB,6.1921E-03_JPRB,5.7948E-03_JPRB,5.3290E-03_JPRB,&
&4.7963E-03_JPRB,4.0123E-03_JPRB,3.3053E-03_JPRB/)
KAO( :, 4, 8, 9) = (/&
&8.4673E-03_JPRB,8.5585E-03_JPRB,8.5340E-03_JPRB,8.2251E-03_JPRB,7.7660E-03_JPRB,7.2331E-03_JPRB,&
&6.6181E-03_JPRB,5.8537E-03_JPRB,4.2835E-03_JPRB/)
KAO( :, 5, 8, 9) = (/&
&1.0594E-02_JPRB,1.0877E-02_JPRB,1.0934E-02_JPRB,1.0630E-02_JPRB,1.0118E-02_JPRB,9.5083E-03_JPRB,&
&8.7956E-03_JPRB,8.0306E-03_JPRB,5.6393E-03_JPRB/)
KAO( :, 1, 9, 9) = (/&
&2.7403E-03_JPRB,2.6787E-03_JPRB,2.5973E-03_JPRB,2.4570E-03_JPRB,2.2443E-03_JPRB,1.9562E-03_JPRB,&
&1.5185E-03_JPRB,8.3616E-04_JPRB,1.0274E-02_JPRB/)
KAO( :, 2, 9, 9) = (/&
&3.9274E-03_JPRB,3.8796E-03_JPRB,3.7992E-03_JPRB,3.6140E-03_JPRB,3.3367E-03_JPRB,2.9763E-03_JPRB,&
&2.5173E-03_JPRB,1.7223E-03_JPRB,1.0390E-02_JPRB/)
KAO( :, 3, 9, 9) = (/&
&5.3634E-03_JPRB,5.3721E-03_JPRB,5.3082E-03_JPRB,5.0709E-03_JPRB,4.7250E-03_JPRB,4.2829E-03_JPRB,&
&3.7573E-03_JPRB,2.9940E-03_JPRB,1.0638E-02_JPRB/)
KAO( :, 4, 9, 9) = (/&
&7.0458E-03_JPRB,7.1640E-03_JPRB,7.1301E-03_JPRB,6.8617E-03_JPRB,6.4511E-03_JPRB,5.9118E-03_JPRB,&
&5.2974E-03_JPRB,4.5531E-03_JPRB,1.1091E-02_JPRB/)
KAO( :, 5, 9, 9) = (/&
&8.9617E-03_JPRB,9.2589E-03_JPRB,9.2849E-03_JPRB,9.0088E-03_JPRB,8.5345E-03_JPRB,7.8845E-03_JPRB,&
&7.1544E-03_JPRB,6.3553E-03_JPRB,1.1709E-02_JPRB/)
KAO( :, 1,10, 9) = (/&
&2.1319E-03_JPRB,2.1004E-03_JPRB,2.0372E-03_JPRB,1.9210E-03_JPRB,1.7497E-03_JPRB,1.5111E-03_JPRB,&
&1.1301E-03_JPRB,5.5756E-04_JPRB,7.5283E-02_JPRB/)
KAO( :, 2,10, 9) = (/&
&3.1363E-03_JPRB,3.1212E-03_JPRB,3.0574E-03_JPRB,2.9015E-03_JPRB,2.6722E-03_JPRB,2.3756E-03_JPRB,&
&1.9576E-03_JPRB,1.2195E-03_JPRB,7.4064E-02_JPRB/)
KAO( :, 3,10, 9) = (/&
&4.3731E-03_JPRB,4.4117E-03_JPRB,4.3602E-03_JPRB,4.1608E-03_JPRB,3.8669E-03_JPRB,3.4927E-03_JPRB,&
&3.0050E-03_JPRB,2.2902E-03_JPRB,7.3035E-02_JPRB/)
KAO( :, 4,10, 9) = (/&
&5.8455E-03_JPRB,5.9881E-03_JPRB,5.9565E-03_JPRB,5.7270E-03_JPRB,5.3754E-03_JPRB,4.9035E-03_JPRB,&
&4.3124E-03_JPRB,3.6091E-03_JPRB,7.2537E-02_JPRB/)
KAO( :, 5,10, 9) = (/&
&7.5468E-03_JPRB,7.8566E-03_JPRB,7.8695E-03_JPRB,7.6289E-03_JPRB,7.2133E-03_JPRB,6.6234E-03_JPRB,&
&5.9025E-03_JPRB,5.1322E-03_JPRB,7.2257E-02_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.9745E-03_JPRB,1.9703E-03_JPRB,1.9199E-03_JPRB,1.8121E-03_JPRB,1.6559E-03_JPRB,1.4431E-03_JPRB,&
&1.1163E-03_JPRB,5.3500E-04_JPRB,1.9757E-01_JPRB/)
KAO( :, 2,11, 9) = (/&
&2.8999E-03_JPRB,2.9279E-03_JPRB,2.8819E-03_JPRB,2.7350E-03_JPRB,2.5277E-03_JPRB,2.2543E-03_JPRB,&
&1.8746E-03_JPRB,1.2124E-03_JPRB,1.9384E-01_JPRB/)
KAO( :, 3,11, 9) = (/&
&4.0444E-03_JPRB,4.1420E-03_JPRB,4.1037E-03_JPRB,3.9240E-03_JPRB,3.6578E-03_JPRB,3.3096E-03_JPRB,&
&2.8567E-03_JPRB,2.1998E-03_JPRB,1.9071E-01_JPRB/)
KAO( :, 4,11, 9) = (/&
&5.4085E-03_JPRB,5.6287E-03_JPRB,5.6077E-03_JPRB,5.4059E-03_JPRB,5.0834E-03_JPRB,4.6413E-03_JPRB,&
&4.0709E-03_JPRB,3.3776E-03_JPRB,1.8809E-01_JPRB/)
KAO( :, 5,11, 9) = (/&
&6.9941E-03_JPRB,7.3880E-03_JPRB,7.4108E-03_JPRB,7.2046E-03_JPRB,6.8126E-03_JPRB,6.2573E-03_JPRB,&
&5.5477E-03_JPRB,4.7861E-03_JPRB,1.8600E-01_JPRB/)
KAO( :, 1,12, 9) = (/&
&1.7996E-03_JPRB,1.8206E-03_JPRB,1.7805E-03_JPRB,1.6829E-03_JPRB,1.5433E-03_JPRB,1.3501E-03_JPRB,&
&1.0572E-03_JPRB,5.4808E-04_JPRB,3.2846E-01_JPRB/)
KAO( :, 2,12, 9) = (/&
&2.6426E-03_JPRB,2.7068E-03_JPRB,2.6687E-03_JPRB,2.5393E-03_JPRB,2.3520E-03_JPRB,2.1038E-03_JPRB,&
&1.7678E-03_JPRB,1.1889E-03_JPRB,3.2273E-01_JPRB/)
KAO( :, 3,12, 9) = (/&
&3.6853E-03_JPRB,3.8343E-03_JPRB,3.8028E-03_JPRB,3.6418E-03_JPRB,3.4031E-03_JPRB,3.0855E-03_JPRB,&
&2.6713E-03_JPRB,2.0755E-03_JPRB,3.1779E-01_JPRB/)
KAO( :, 4,12, 9) = (/&
&4.9356E-03_JPRB,5.2142E-03_JPRB,5.1981E-03_JPRB,5.0221E-03_JPRB,4.7252E-03_JPRB,4.3142E-03_JPRB,&
&3.7960E-03_JPRB,3.1444E-03_JPRB,3.1325E-01_JPRB/)
KAO( :, 5,12, 9) = (/&
&6.3947E-03_JPRB,6.8520E-03_JPRB,6.8760E-03_JPRB,6.6872E-03_JPRB,6.3222E-03_JPRB,5.8083E-03_JPRB,&
&5.1616E-03_JPRB,4.4214E-03_JPRB,3.0903E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&1.6151E-03_JPRB,1.6567E-03_JPRB,1.6234E-03_JPRB,1.5373E-03_JPRB,1.4124E-03_JPRB,1.2394E-03_JPRB,&
&9.8564E-04_JPRB,5.5616E-04_JPRB,4.3871E-01_JPRB/)
KAO( :, 2,13, 9) = (/&
&2.3710E-03_JPRB,2.4678E-03_JPRB,2.4327E-03_JPRB,2.3183E-03_JPRB,2.1495E-03_JPRB,1.9302E-03_JPRB,&
&1.6336E-03_JPRB,1.1398E-03_JPRB,4.3206E-01_JPRB/)
KAO( :, 3,13, 9) = (/&
&3.3121E-03_JPRB,3.4978E-03_JPRB,3.4669E-03_JPRB,3.3267E-03_JPRB,3.1113E-03_JPRB,2.8243E-03_JPRB,&
&2.4585E-03_JPRB,1.9402E-03_JPRB,4.2585E-01_JPRB/)
KAO( :, 4,13, 9) = (/&
&4.4457E-03_JPRB,4.7587E-03_JPRB,4.7468E-03_JPRB,4.5875E-03_JPRB,4.3110E-03_JPRB,3.9394E-03_JPRB,&
&3.4774E-03_JPRB,2.8993E-03_JPRB,4.1993E-01_JPRB/)
KAO( :, 5,13, 9) = (/&
&5.7689E-03_JPRB,6.2589E-03_JPRB,6.2951E-03_JPRB,6.1057E-03_JPRB,5.7619E-03_JPRB,5.2957E-03_JPRB,&
&4.7230E-03_JPRB,4.0528E-03_JPRB,4.1400E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&2.8341E-02_JPRB,2.4949E-02_JPRB,2.4794E-02_JPRB,2.3987E-02_JPRB,2.3812E-02_JPRB,2.2586E-02_JPRB,&
&2.0187E-02_JPRB,1.9376E-02_JPRB,2.5381E-02_JPRB/)
KAO( :, 2, 1,10) = (/&
&3.3991E-02_JPRB,3.0192E-02_JPRB,3.0574E-02_JPRB,3.0065E-02_JPRB,2.9840E-02_JPRB,2.8013E-02_JPRB,&
&2.5566E-02_JPRB,2.6044E-02_JPRB,3.3447E-02_JPRB/)
KAO( :, 3, 1,10) = (/&
&3.9910E-02_JPRB,3.6271E-02_JPRB,3.6774E-02_JPRB,3.6789E-02_JPRB,3.6160E-02_JPRB,3.4328E-02_JPRB,&
&3.2309E-02_JPRB,3.3900E-02_JPRB,4.2891E-02_JPRB/)
KAO( :, 4, 1,10) = (/&
&4.5950E-02_JPRB,4.3254E-02_JPRB,4.3515E-02_JPRB,4.3816E-02_JPRB,4.3274E-02_JPRB,4.0958E-02_JPRB,&
&3.9828E-02_JPRB,4.3039E-02_JPRB,5.4536E-02_JPRB/)
KAO( :, 5, 1,10) = (/&
&5.2074E-02_JPRB,5.0170E-02_JPRB,5.0735E-02_JPRB,5.1340E-02_JPRB,5.0699E-02_JPRB,4.7916E-02_JPRB,&
&4.9158E-02_JPRB,5.3574E-02_JPRB,6.8520E-02_JPRB/)
KAO( :, 1, 2,10) = (/&
&2.6184E-02_JPRB,2.3296E-02_JPRB,2.3226E-02_JPRB,2.2714E-02_JPRB,2.2514E-02_JPRB,2.1363E-02_JPRB,&
&1.9364E-02_JPRB,1.8250E-02_JPRB,2.2856E-02_JPRB/)
KAO( :, 2, 2,10) = (/&
&3.1743E-02_JPRB,2.8597E-02_JPRB,2.8854E-02_JPRB,2.8835E-02_JPRB,2.8199E-02_JPRB,2.7046E-02_JPRB,&
&2.4544E-02_JPRB,2.4456E-02_JPRB,3.0699E-02_JPRB/)
KAO( :, 3, 2,10) = (/&
&3.7600E-02_JPRB,3.4758E-02_JPRB,3.5112E-02_JPRB,3.5357E-02_JPRB,3.4504E-02_JPRB,3.3441E-02_JPRB,&
&3.1117E-02_JPRB,3.2055E-02_JPRB,4.0509E-02_JPRB/)
KAO( :, 4, 2,10) = (/&
&4.3772E-02_JPRB,4.1496E-02_JPRB,4.2012E-02_JPRB,4.2309E-02_JPRB,4.1696E-02_JPRB,3.9959E-02_JPRB,&
&3.8762E-02_JPRB,4.0415E-02_JPRB,5.2629E-02_JPRB/)
KAO( :, 5, 2,10) = (/&
&5.0069E-02_JPRB,4.8330E-02_JPRB,4.9427E-02_JPRB,4.9767E-02_JPRB,4.9310E-02_JPRB,4.7260E-02_JPRB,&
&4.8222E-02_JPRB,5.0586E-02_JPRB,6.6929E-02_JPRB/)
KAO( :, 1, 3,10) = (/&
&2.2843E-02_JPRB,2.0821E-02_JPRB,2.0350E-02_JPRB,2.0283E-02_JPRB,1.9897E-02_JPRB,1.9120E-02_JPRB,&
&1.7384E-02_JPRB,1.6170E-02_JPRB,1.8446E-02_JPRB/)
KAO( :, 2, 3,10) = (/&
&2.8199E-02_JPRB,2.6062E-02_JPRB,2.5776E-02_JPRB,2.5997E-02_JPRB,2.5440E-02_JPRB,2.4723E-02_JPRB,&
&2.2441E-02_JPRB,2.1717E-02_JPRB,2.5483E-02_JPRB/)
KAO( :, 3, 3,10) = (/&
&3.3953E-02_JPRB,3.1919E-02_JPRB,3.1941E-02_JPRB,3.2157E-02_JPRB,3.1747E-02_JPRB,3.0922E-02_JPRB,&
&2.8559E-02_JPRB,2.8709E-02_JPRB,3.4439E-02_JPRB/)
KAO( :, 4, 3,10) = (/&
&4.0002E-02_JPRB,3.8423E-02_JPRB,3.8902E-02_JPRB,3.8911E-02_JPRB,3.8820E-02_JPRB,3.7594E-02_JPRB,&
&3.6351E-02_JPRB,3.6718E-02_JPRB,4.5775E-02_JPRB/)
KAO( :, 5, 3,10) = (/&
&4.6219E-02_JPRB,4.5155E-02_JPRB,4.6197E-02_JPRB,4.6387E-02_JPRB,4.6153E-02_JPRB,4.5334E-02_JPRB,&
&4.5834E-02_JPRB,4.6534E-02_JPRB,5.9401E-02_JPRB/)
KAO( :, 1, 4,10) = (/&
&1.9312E-02_JPRB,1.7992E-02_JPRB,1.7480E-02_JPRB,1.7446E-02_JPRB,1.7111E-02_JPRB,1.6477E-02_JPRB,&
&1.5243E-02_JPRB,1.3399E-02_JPRB,1.4121E-02_JPRB/)
KAO( :, 2, 4,10) = (/&
&2.4344E-02_JPRB,2.2955E-02_JPRB,2.2617E-02_JPRB,2.2783E-02_JPRB,2.2496E-02_JPRB,2.1867E-02_JPRB,&
&1.9808E-02_JPRB,1.8936E-02_JPRB,1.9938E-02_JPRB/)
KAO( :, 3, 4,10) = (/&
&2.9801E-02_JPRB,2.8523E-02_JPRB,2.8566E-02_JPRB,2.8709E-02_JPRB,2.8682E-02_JPRB,2.7725E-02_JPRB,&
&2.5334E-02_JPRB,2.5284E-02_JPRB,2.7743E-02_JPRB/)
KAO( :, 4, 4,10) = (/&
&3.5620E-02_JPRB,3.4742E-02_JPRB,3.5299E-02_JPRB,3.5308E-02_JPRB,3.5457E-02_JPRB,3.4419E-02_JPRB,&
&3.2604E-02_JPRB,3.3013E-02_JPRB,3.7587E-02_JPRB/)
KAO( :, 5, 4,10) = (/&
&4.1887E-02_JPRB,4.1321E-02_JPRB,4.2274E-02_JPRB,4.2660E-02_JPRB,4.2937E-02_JPRB,4.2081E-02_JPRB,&
&4.1593E-02_JPRB,4.2622E-02_JPRB,4.9653E-02_JPRB/)
KAO( :, 1, 5,10) = (/&
&1.5962E-02_JPRB,1.5091E-02_JPRB,1.4926E-02_JPRB,1.4725E-02_JPRB,1.4471E-02_JPRB,1.4016E-02_JPRB,&
&1.2941E-02_JPRB,1.0781E-02_JPRB,1.0820E-02_JPRB/)
KAO( :, 2, 5,10) = (/&
&2.0561E-02_JPRB,1.9656E-02_JPRB,1.9606E-02_JPRB,1.9723E-02_JPRB,1.9597E-02_JPRB,1.8959E-02_JPRB,&
&1.7070E-02_JPRB,1.5994E-02_JPRB,1.5507E-02_JPRB/)
KAO( :, 3, 5,10) = (/&
&2.5675E-02_JPRB,2.4818E-02_JPRB,2.5196E-02_JPRB,2.5517E-02_JPRB,2.5439E-02_JPRB,2.4412E-02_JPRB,&
&2.1991E-02_JPRB,2.1552E-02_JPRB,2.1888E-02_JPRB/)
KAO( :, 4, 5,10) = (/&
&3.1284E-02_JPRB,3.0688E-02_JPRB,3.1452E-02_JPRB,3.1913E-02_JPRB,3.1938E-02_JPRB,3.0781E-02_JPRB,&
&2.8330E-02_JPRB,2.8796E-02_JPRB,3.0247E-02_JPRB/)
KAO( :, 5, 5,10) = (/&
&3.7244E-02_JPRB,3.7039E-02_JPRB,3.8113E-02_JPRB,3.9041E-02_JPRB,3.9409E-02_JPRB,3.8138E-02_JPRB,&
&3.6567E-02_JPRB,3.7730E-02_JPRB,4.0679E-02_JPRB/)
KAO( :, 1, 6,10) = (/&
&1.2975E-02_JPRB,1.2256E-02_JPRB,1.2340E-02_JPRB,1.2080E-02_JPRB,1.1895E-02_JPRB,1.1506E-02_JPRB,&
&1.0365E-02_JPRB,8.5383E-03_JPRB,8.0172E-03_JPRB/)
KAO( :, 2, 6,10) = (/&
&1.7187E-02_JPRB,1.6321E-02_JPRB,1.6561E-02_JPRB,1.6669E-02_JPRB,1.6611E-02_JPRB,1.5858E-02_JPRB,&
&1.4206E-02_JPRB,1.2638E-02_JPRB,1.1866E-02_JPRB/)
KAO( :, 3, 6,10) = (/&
&2.1950E-02_JPRB,2.1039E-02_JPRB,2.1721E-02_JPRB,2.2100E-02_JPRB,2.1989E-02_JPRB,2.0834E-02_JPRB,&
&1.8607E-02_JPRB,1.7648E-02_JPRB,1.7187E-02_JPRB/)
KAO( :, 4, 6,10) = (/&
&2.7221E-02_JPRB,2.6492E-02_JPRB,2.7582E-02_JPRB,2.8232E-02_JPRB,2.8034E-02_JPRB,2.6720E-02_JPRB,&
&2.4048E-02_JPRB,2.4099E-02_JPRB,2.3975E-02_JPRB/)
KAO( :, 5, 6,10) = (/&
&3.2966E-02_JPRB,3.2596E-02_JPRB,3.4013E-02_JPRB,3.5128E-02_JPRB,3.5174E-02_JPRB,3.3585E-02_JPRB,&
&3.0966E-02_JPRB,3.2147E-02_JPRB,3.2714E-02_JPRB/)
KAO( :, 1, 7,10) = (/&
&1.1003E-02_JPRB,1.0172E-02_JPRB,9.9689E-03_JPRB,9.7030E-03_JPRB,9.5816E-03_JPRB,9.1864E-03_JPRB,&
&8.3157E-03_JPRB,6.5477E-03_JPRB,5.8584E-03_JPRB/)
KAO( :, 2, 7,10) = (/&
&1.4954E-02_JPRB,1.3915E-02_JPRB,1.3705E-02_JPRB,1.3805E-02_JPRB,1.3711E-02_JPRB,1.2918E-02_JPRB,&
&1.1613E-02_JPRB,9.7524E-03_JPRB,8.8921E-03_JPRB/)
KAO( :, 3, 7,10) = (/&
&1.9525E-02_JPRB,1.8286E-02_JPRB,1.8359E-02_JPRB,1.8803E-02_JPRB,1.8505E-02_JPRB,1.7397E-02_JPRB,&
&1.5545E-02_JPRB,1.4074E-02_JPRB,1.3147E-02_JPRB/)
KAO( :, 4, 7,10) = (/&
&2.4765E-02_JPRB,2.3347E-02_JPRB,2.3852E-02_JPRB,2.4521E-02_JPRB,2.4046E-02_JPRB,2.2746E-02_JPRB,&
&2.0338E-02_JPRB,1.9593E-02_JPRB,1.8718E-02_JPRB/)
KAO( :, 5, 7,10) = (/&
&3.0444E-02_JPRB,2.9114E-02_JPRB,2.9981E-02_JPRB,3.1001E-02_JPRB,3.0659E-02_JPRB,2.9115E-02_JPRB,&
&2.6153E-02_JPRB,2.6663E-02_JPRB,2.5778E-02_JPRB/)
KAO( :, 1, 8,10) = (/&
&9.5903E-03_JPRB,8.7677E-03_JPRB,8.2751E-03_JPRB,7.7628E-03_JPRB,7.6194E-03_JPRB,7.2194E-03_JPRB,&
&6.4757E-03_JPRB,5.1626E-03_JPRB,4.5446E-03_JPRB/)
KAO( :, 2, 8,10) = (/&
&1.3386E-02_JPRB,1.2290E-02_JPRB,1.1661E-02_JPRB,1.1306E-02_JPRB,1.1055E-02_JPRB,1.0454E-02_JPRB,&
&9.3918E-03_JPRB,7.5740E-03_JPRB,6.6212E-03_JPRB/)
KAO( :, 3, 8,10) = (/&
&1.7895E-02_JPRB,1.6495E-02_JPRB,1.5871E-02_JPRB,1.5730E-02_JPRB,1.5237E-02_JPRB,1.4347E-02_JPRB,&
&1.2880E-02_JPRB,1.1121E-02_JPRB,9.9657E-03_JPRB/)
KAO( :, 4, 8,10) = (/&
&2.3088E-02_JPRB,2.1460E-02_JPRB,2.0931E-02_JPRB,2.0828E-02_JPRB,2.0243E-02_JPRB,1.9039E-02_JPRB,&
&1.7178E-02_JPRB,1.5707E-02_JPRB,1.4369E-02_JPRB/)
KAO( :, 5, 8,10) = (/&
&2.8768E-02_JPRB,2.7065E-02_JPRB,2.6736E-02_JPRB,2.6678E-02_JPRB,2.6248E-02_JPRB,2.4878E-02_JPRB,&
&2.2359E-02_JPRB,2.1798E-02_JPRB,1.9974E-02_JPRB/)
KAO( :, 1, 9,10) = (/&
&8.1489E-03_JPRB,7.4648E-03_JPRB,6.9804E-03_JPRB,6.4191E-03_JPRB,5.9636E-03_JPRB,5.4909E-03_JPRB,&
&4.8784E-03_JPRB,3.8347E-03_JPRB,1.5314E-02_JPRB/)
KAO( :, 2, 9,10) = (/&
&1.1712E-02_JPRB,1.0789E-02_JPRB,1.0109E-02_JPRB,9.4829E-03_JPRB,8.8584E-03_JPRB,8.2278E-03_JPRB,&
&7.3764E-03_JPRB,5.7877E-03_JPRB,1.6244E-02_JPRB/)
KAO( :, 3, 9,10) = (/&
&1.6046E-02_JPRB,1.4820E-02_JPRB,1.4055E-02_JPRB,1.3332E-02_JPRB,1.2456E-02_JPRB,1.1636E-02_JPRB,&
&1.0489E-02_JPRB,8.6873E-03_JPRB,1.7494E-02_JPRB/)
KAO( :, 4, 9,10) = (/&
&2.1066E-02_JPRB,1.9610E-02_JPRB,1.8931E-02_JPRB,1.7888E-02_JPRB,1.6756E-02_JPRB,1.5784E-02_JPRB,&
&1.4417E-02_JPRB,1.2557E-02_JPRB,1.9326E-02_JPRB/)
KAO( :, 5, 9,10) = (/&
&2.6667E-02_JPRB,2.5074E-02_JPRB,2.4522E-02_JPRB,2.3189E-02_JPRB,2.2008E-02_JPRB,2.0995E-02_JPRB,&
&1.9281E-02_JPRB,1.7791E-02_JPRB,2.1654E-02_JPRB/)
KAO( :, 1,10,10) = (/&
&6.9366E-03_JPRB,6.3789E-03_JPRB,5.9595E-03_JPRB,5.4852E-03_JPRB,4.9360E-03_JPRB,4.3201E-03_JPRB,&
&3.7060E-03_JPRB,2.8411E-03_JPRB,1.0865E-01_JPRB/)
KAO( :, 2,10,10) = (/&
&1.0236E-02_JPRB,9.4750E-03_JPRB,8.8501E-03_JPRB,8.3036E-03_JPRB,7.4880E-03_JPRB,6.6146E-03_JPRB,&
&5.8580E-03_JPRB,4.5793E-03_JPRB,1.0627E-01_JPRB/)
KAO( :, 3,10,10) = (/&
&1.4332E-02_JPRB,1.3324E-02_JPRB,1.2604E-02_JPRB,1.1845E-02_JPRB,1.0730E-02_JPRB,9.5741E-03_JPRB,&
&8.5876E-03_JPRB,7.0236E-03_JPRB,1.0490E-01_JPRB/)
KAO( :, 4,10,10) = (/&
&1.9120E-02_JPRB,1.7914E-02_JPRB,1.7311E-02_JPRB,1.6108E-02_JPRB,1.4592E-02_JPRB,1.3253E-02_JPRB,&
&1.2097E-02_JPRB,1.0165E-02_JPRB,1.0426E-01_JPRB/)
KAO( :, 5,10,10) = (/&
&2.4561E-02_JPRB,2.3221E-02_JPRB,2.2646E-02_JPRB,2.1122E-02_JPRB,1.9334E-02_JPRB,1.7961E-02_JPRB,&
&1.6559E-02_JPRB,1.4610E-02_JPRB,1.0510E-01_JPRB/)
KAO( :, 1,11,10) = (/&
&7.0237E-03_JPRB,6.5225E-03_JPRB,6.1043E-03_JPRB,5.6444E-03_JPRB,5.0633E-03_JPRB,4.3399E-03_JPRB,&
&3.5607E-03_JPRB,2.6850E-03_JPRB,2.8892E-01_JPRB/)
KAO( :, 2,11,10) = (/&
&1.0384E-02_JPRB,9.6831E-03_JPRB,9.0835E-03_JPRB,8.5192E-03_JPRB,7.6404E-03_JPRB,6.6528E-03_JPRB,&
&5.6514E-03_JPRB,4.5273E-03_JPRB,2.8169E-01_JPRB/)
KAO( :, 3,11,10) = (/&
&1.4456E-02_JPRB,1.3566E-02_JPRB,1.2997E-02_JPRB,1.2107E-02_JPRB,1.0901E-02_JPRB,9.5425E-03_JPRB,&
&8.2374E-03_JPRB,6.8400E-03_JPRB,2.7734E-01_JPRB/)
KAO( :, 4,11,10) = (/&
&1.9195E-02_JPRB,1.8156E-02_JPRB,1.7656E-02_JPRB,1.6419E-02_JPRB,1.4881E-02_JPRB,1.3205E-02_JPRB,&
&1.1741E-02_JPRB,9.9915E-03_JPRB,2.7331E-01_JPRB/)
KAO( :, 5,11,10) = (/&
&2.4521E-02_JPRB,2.3536E-02_JPRB,2.2979E-02_JPRB,2.1464E-02_JPRB,1.9799E-02_JPRB,1.7771E-02_JPRB,&
&1.6045E-02_JPRB,1.4047E-02_JPRB,2.7061E-01_JPRB/)
KAO( :, 1,12,10) = (/&
&6.9801E-03_JPRB,6.5414E-03_JPRB,6.1464E-03_JPRB,5.6988E-03_JPRB,5.0902E-03_JPRB,4.4198E-03_JPRB,&
&3.6370E-03_JPRB,2.5506E-03_JPRB,4.9609E-01_JPRB/)
KAO( :, 2,12,10) = (/&
&1.0252E-02_JPRB,9.6631E-03_JPRB,9.2104E-03_JPRB,8.5451E-03_JPRB,7.6724E-03_JPRB,6.7086E-03_JPRB,&
&5.5412E-03_JPRB,4.4277E-03_JPRB,4.8672E-01_JPRB/)
KAO( :, 3,12,10) = (/&
&1.4194E-02_JPRB,1.3473E-02_JPRB,1.3019E-02_JPRB,1.2130E-02_JPRB,1.0940E-02_JPRB,9.6059E-03_JPRB,&
&8.1091E-03_JPRB,6.7337E-03_JPRB,4.7779E-01_JPRB/)
KAO( :, 4,12,10) = (/&
&1.8764E-02_JPRB,1.7996E-02_JPRB,1.7549E-02_JPRB,1.6391E-02_JPRB,1.4970E-02_JPRB,1.3362E-02_JPRB,&
&1.1424E-02_JPRB,9.7371E-03_JPRB,4.7094E-01_JPRB/)
KAO( :, 5,12,10) = (/&
&2.3822E-02_JPRB,2.3255E-02_JPRB,2.2798E-02_JPRB,2.1487E-02_JPRB,1.9935E-02_JPRB,1.7893E-02_JPRB,&
&1.5477E-02_JPRB,1.3501E-02_JPRB,4.6404E-01_JPRB/)
KAO( :, 1,13,10) = (/&
&6.7570E-03_JPRB,6.3985E-03_JPRB,6.0648E-03_JPRB,5.6090E-03_JPRB,5.0372E-03_JPRB,4.3896E-03_JPRB,&
&3.5984E-03_JPRB,2.5612E-03_JPRB,7.0129E-01_JPRB/)
KAO( :, 2,13,10) = (/&
&9.8516E-03_JPRB,9.3610E-03_JPRB,9.0380E-03_JPRB,8.3857E-03_JPRB,7.5801E-03_JPRB,6.6037E-03_JPRB,&
&5.4660E-03_JPRB,4.1572E-03_JPRB,6.8624E-01_JPRB/)
KAO( :, 3,13,10) = (/&
&1.3565E-02_JPRB,1.3023E-02_JPRB,1.2697E-02_JPRB,1.1845E-02_JPRB,1.0771E-02_JPRB,9.5129E-03_JPRB,&
&8.0355E-03_JPRB,6.4068E-03_JPRB,6.7348E-01_JPRB/)
KAO( :, 4,13,10) = (/&
&1.7823E-02_JPRB,1.7451E-02_JPRB,1.7031E-02_JPRB,1.6025E-02_JPRB,1.4810E-02_JPRB,1.3226E-02_JPRB,&
&1.1248E-02_JPRB,9.2627E-03_JPRB,6.6252E-01_JPRB/)
KAO( :, 5,13,10) = (/&
&2.2635E-02_JPRB,2.2570E-02_JPRB,2.2029E-02_JPRB,2.1116E-02_JPRB,1.9648E-02_JPRB,1.7648E-02_JPRB,&
&1.5125E-02_JPRB,1.2814E-02_JPRB,6.5224E-01_JPRB/)
KAO( :, 1, 1,11) = (/&
&4.0423E-02_JPRB,3.5511E-02_JPRB,3.2385E-02_JPRB,3.1302E-02_JPRB,2.9329E-02_JPRB,2.7493E-02_JPRB,&
&2.5237E-02_JPRB,2.6262E-02_JPRB,3.3335E-02_JPRB/)
KAO( :, 2, 1,11) = (/&
&4.8068E-02_JPRB,4.2224E-02_JPRB,3.9790E-02_JPRB,3.8473E-02_JPRB,3.6916E-02_JPRB,3.3889E-02_JPRB,&
&3.2387E-02_JPRB,3.4784E-02_JPRB,4.3954E-02_JPRB/)
KAO( :, 3, 1,11) = (/&
&5.5962E-02_JPRB,4.9147E-02_JPRB,4.7932E-02_JPRB,4.6498E-02_JPRB,4.4808E-02_JPRB,4.0788E-02_JPRB,&
&4.1145E-02_JPRB,4.4752E-02_JPRB,5.6848E-02_JPRB/)
KAO( :, 4, 1,11) = (/&
&6.3927E-02_JPRB,5.6554E-02_JPRB,5.6496E-02_JPRB,5.5146E-02_JPRB,5.2972E-02_JPRB,4.9275E-02_JPRB,&
&5.2218E-02_JPRB,5.7028E-02_JPRB,7.1593E-02_JPRB/)
KAO( :, 5, 1,11) = (/&
&7.1900E-02_JPRB,6.5533E-02_JPRB,6.5482E-02_JPRB,6.4060E-02_JPRB,6.1054E-02_JPRB,5.9498E-02_JPRB,&
&6.4850E-02_JPRB,7.0769E-02_JPRB,8.8897E-02_JPRB/)
KAO( :, 1, 2,11) = (/&
&3.8292E-02_JPRB,3.3588E-02_JPRB,3.1358E-02_JPRB,2.9906E-02_JPRB,2.8447E-02_JPRB,2.6569E-02_JPRB,&
&2.3944E-02_JPRB,2.4132E-02_JPRB,3.1513E-02_JPRB/)
KAO( :, 2, 2,11) = (/&
&4.5994E-02_JPRB,4.0345E-02_JPRB,3.8650E-02_JPRB,3.7178E-02_JPRB,3.6077E-02_JPRB,3.2811E-02_JPRB,&
&3.1189E-02_JPRB,3.2232E-02_JPRB,4.1849E-02_JPRB/)
KAO( :, 3, 2,11) = (/&
&5.3984E-02_JPRB,4.7456E-02_JPRB,4.6641E-02_JPRB,4.5568E-02_JPRB,4.3973E-02_JPRB,3.9559E-02_JPRB,&
&3.9776E-02_JPRB,4.1895E-02_JPRB,5.4339E-02_JPRB/)
KAO( :, 4, 2,11) = (/&
&6.2153E-02_JPRB,5.5541E-02_JPRB,5.5147E-02_JPRB,5.4419E-02_JPRB,5.2145E-02_JPRB,4.8212E-02_JPRB,&
&5.0049E-02_JPRB,5.4211E-02_JPRB,6.8573E-02_JPRB/)
KAO( :, 5, 2,11) = (/&
&7.0498E-02_JPRB,6.4912E-02_JPRB,6.4005E-02_JPRB,6.3675E-02_JPRB,6.0340E-02_JPRB,5.8471E-02_JPRB,&
&6.1765E-02_JPRB,6.8106E-02_JPRB,8.5795E-02_JPRB/)
KAO( :, 1, 3,11) = (/&
&3.4351E-02_JPRB,3.0114E-02_JPRB,2.8690E-02_JPRB,2.7033E-02_JPRB,2.5922E-02_JPRB,2.4043E-02_JPRB,&
&2.1412E-02_JPRB,2.0519E-02_JPRB,2.7411E-02_JPRB/)
KAO( :, 2, 3,11) = (/&
&4.1940E-02_JPRB,3.6767E-02_JPRB,3.5782E-02_JPRB,3.4187E-02_JPRB,3.3188E-02_JPRB,3.0297E-02_JPRB,&
&2.8550E-02_JPRB,2.8551E-02_JPRB,3.7044E-02_JPRB/)
KAO( :, 3, 3,11) = (/&
&5.0028E-02_JPRB,4.4118E-02_JPRB,4.3712E-02_JPRB,4.2513E-02_JPRB,4.0818E-02_JPRB,3.7223E-02_JPRB,&
&3.6892E-02_JPRB,3.7585E-02_JPRB,4.9025E-02_JPRB/)
KAO( :, 4, 3,11) = (/&
&5.8382E-02_JPRB,5.2350E-02_JPRB,5.2192E-02_JPRB,5.1365E-02_JPRB,4.8840E-02_JPRB,4.5605E-02_JPRB,&
&4.6688E-02_JPRB,4.8795E-02_JPRB,6.3308E-02_JPRB/)
KAO( :, 5, 3,11) = (/&
&6.6855E-02_JPRB,6.1851E-02_JPRB,6.1319E-02_JPRB,6.0440E-02_JPRB,5.7553E-02_JPRB,5.5141E-02_JPRB,&
&5.7507E-02_JPRB,6.1726E-02_JPRB,8.0747E-02_JPRB/)
KAO( :, 1, 4,11) = (/&
&2.9914E-02_JPRB,2.6434E-02_JPRB,2.5229E-02_JPRB,2.3960E-02_JPRB,2.2872E-02_JPRB,2.1167E-02_JPRB,&
&1.8618E-02_JPRB,1.7654E-02_JPRB,2.2206E-02_JPRB/)
KAO( :, 2, 4,11) = (/&
&3.7311E-02_JPRB,3.2955E-02_JPRB,3.1987E-02_JPRB,3.0816E-02_JPRB,2.9746E-02_JPRB,2.7451E-02_JPRB,&
&2.5496E-02_JPRB,2.4816E-02_JPRB,3.0769E-02_JPRB/)
KAO( :, 3, 4,11) = (/&
&4.5214E-02_JPRB,4.0225E-02_JPRB,3.9665E-02_JPRB,3.8830E-02_JPRB,3.7073E-02_JPRB,3.4317E-02_JPRB,&
&3.3498E-02_JPRB,3.3259E-02_JPRB,4.1672E-02_JPRB/)
KAO( :, 4, 4,11) = (/&
&5.3522E-02_JPRB,4.8440E-02_JPRB,4.8077E-02_JPRB,4.7499E-02_JPRB,4.5060E-02_JPRB,4.2198E-02_JPRB,&
&4.2877E-02_JPRB,4.3659E-02_JPRB,5.5415E-02_JPRB/)
KAO( :, 5, 4,11) = (/&
&6.2112E-02_JPRB,5.7637E-02_JPRB,5.7355E-02_JPRB,5.6365E-02_JPRB,5.3831E-02_JPRB,5.1483E-02_JPRB,&
&5.3578E-02_JPRB,5.5548E-02_JPRB,7.2397E-02_JPRB/)
KAO( :, 1, 5,11) = (/&
&2.5525E-02_JPRB,2.2961E-02_JPRB,2.1743E-02_JPRB,2.1045E-02_JPRB,1.9762E-02_JPRB,1.8313E-02_JPRB,&
&1.6006E-02_JPRB,1.4928E-02_JPRB,1.7243E-02_JPRB/)
KAO( :, 2, 5,11) = (/&
&3.2562E-02_JPRB,2.9297E-02_JPRB,2.8118E-02_JPRB,2.7378E-02_JPRB,2.6219E-02_JPRB,2.4429E-02_JPRB,&
&2.2374E-02_JPRB,2.1608E-02_JPRB,2.4409E-02_JPRB/)
KAO( :, 3, 5,11) = (/&
&4.0237E-02_JPRB,3.6530E-02_JPRB,3.5529E-02_JPRB,3.4947E-02_JPRB,3.3507E-02_JPRB,3.1205E-02_JPRB,&
&2.9865E-02_JPRB,2.9668E-02_JPRB,3.3965E-02_JPRB/)
KAO( :, 4, 5,11) = (/&
&4.8489E-02_JPRB,4.4640E-02_JPRB,4.3882E-02_JPRB,4.3184E-02_JPRB,4.1466E-02_JPRB,3.8716E-02_JPRB,&
&3.8839E-02_JPRB,3.9053E-02_JPRB,4.6193E-02_JPRB/)
KAO( :, 5, 5,11) = (/&
&5.7075E-02_JPRB,5.3520E-02_JPRB,5.3151E-02_JPRB,5.1813E-02_JPRB,5.0143E-02_JPRB,4.7699E-02_JPRB,&
&4.9575E-02_JPRB,5.0287E-02_JPRB,6.1844E-02_JPRB/)
KAO( :, 1, 6,11) = (/&
&2.1185E-02_JPRB,1.9366E-02_JPRB,1.8345E-02_JPRB,1.7861E-02_JPRB,1.6696E-02_JPRB,1.5286E-02_JPRB,&
&1.3538E-02_JPRB,1.2110E-02_JPRB,1.3050E-02_JPRB/)
KAO( :, 2, 6,11) = (/&
&2.7736E-02_JPRB,2.5421E-02_JPRB,2.4344E-02_JPRB,2.3686E-02_JPRB,2.2632E-02_JPRB,2.1167E-02_JPRB,&
&1.8994E-02_JPRB,1.8327E-02_JPRB,1.8722E-02_JPRB/)
KAO( :, 3, 6,11) = (/&
&3.5098E-02_JPRB,3.2433E-02_JPRB,3.1346E-02_JPRB,3.0890E-02_JPRB,2.9717E-02_JPRB,2.7709E-02_JPRB,&
&2.5626E-02_JPRB,2.5639E-02_JPRB,2.6411E-02_JPRB/)
KAO( :, 4, 6,11) = (/&
&4.3033E-02_JPRB,4.0261E-02_JPRB,3.9466E-02_JPRB,3.8845E-02_JPRB,3.7545E-02_JPRB,3.4640E-02_JPRB,&
&3.3862E-02_JPRB,3.4287E-02_JPRB,3.6956E-02_JPRB/)
KAO( :, 5, 6,11) = (/&
&5.1415E-02_JPRB,4.8889E-02_JPRB,4.8524E-02_JPRB,4.7406E-02_JPRB,4.5977E-02_JPRB,4.3021E-02_JPRB,&
&4.4126E-02_JPRB,4.4906E-02_JPRB,5.0432E-02_JPRB/)
KAO( :, 1, 7,11) = (/&
&1.7209E-02_JPRB,1.5911E-02_JPRB,1.5312E-02_JPRB,1.4785E-02_JPRB,1.3788E-02_JPRB,1.2644E-02_JPRB,&
&1.1178E-02_JPRB,9.4262E-03_JPRB,9.6250E-03_JPRB/)
KAO( :, 2, 7,11) = (/&
&2.3204E-02_JPRB,2.1530E-02_JPRB,2.0850E-02_JPRB,2.0150E-02_JPRB,1.9195E-02_JPRB,1.8013E-02_JPRB,&
&1.5715E-02_JPRB,1.4967E-02_JPRB,1.4283E-02_JPRB/)
KAO( :, 3, 7,11) = (/&
&3.0021E-02_JPRB,2.8103E-02_JPRB,2.7384E-02_JPRB,2.6841E-02_JPRB,2.5917E-02_JPRB,2.4071E-02_JPRB,&
&2.1339E-02_JPRB,2.1364E-02_JPRB,2.0562E-02_JPRB/)
KAO( :, 4, 7,11) = (/&
&3.7516E-02_JPRB,3.5493E-02_JPRB,3.5022E-02_JPRB,3.4550E-02_JPRB,3.3425E-02_JPRB,3.0562E-02_JPRB,&
&2.8485E-02_JPRB,2.9108E-02_JPRB,2.9186E-02_JPRB/)
KAO( :, 5, 7,11) = (/&
&4.5622E-02_JPRB,4.3704E-02_JPRB,4.3641E-02_JPRB,4.3057E-02_JPRB,4.1664E-02_JPRB,3.8186E-02_JPRB,&
&3.7831E-02_JPRB,3.8897E-02_JPRB,4.0505E-02_JPRB/)
KAO( :, 1, 8,11) = (/&
&1.3818E-02_JPRB,1.2820E-02_JPRB,1.2555E-02_JPRB,1.2034E-02_JPRB,1.1176E-02_JPRB,1.0359E-02_JPRB,&
&9.1227E-03_JPRB,7.1909E-03_JPRB,7.1385E-03_JPRB/)
KAO( :, 2, 8,11) = (/&
&1.9199E-02_JPRB,1.7868E-02_JPRB,1.7585E-02_JPRB,1.6871E-02_JPRB,1.6078E-02_JPRB,1.5016E-02_JPRB,&
&1.2893E-02_JPRB,1.1875E-02_JPRB,1.0811E-02_JPRB/)
KAO( :, 3, 8,11) = (/&
&2.5464E-02_JPRB,2.3910E-02_JPRB,2.3566E-02_JPRB,2.3034E-02_JPRB,2.2314E-02_JPRB,2.0472E-02_JPRB,&
&1.7635E-02_JPRB,1.7256E-02_JPRB,1.5992E-02_JPRB/)
KAO( :, 4, 8,11) = (/&
&3.2551E-02_JPRB,3.0722E-02_JPRB,3.0704E-02_JPRB,3.0409E-02_JPRB,2.9339E-02_JPRB,2.6650E-02_JPRB,&
&2.3599E-02_JPRB,2.4044E-02_JPRB,2.3236E-02_JPRB/)
KAO( :, 5, 8,11) = (/&
&4.0250E-02_JPRB,3.8454E-02_JPRB,3.8842E-02_JPRB,3.8675E-02_JPRB,3.7147E-02_JPRB,3.3647E-02_JPRB,&
&3.1602E-02_JPRB,3.2839E-02_JPRB,3.2581E-02_JPRB/)
KAO( :, 1, 9,11) = (/&
&1.1316E-02_JPRB,1.0378E-02_JPRB,1.0058E-02_JPRB,9.5388E-03_JPRB,8.9583E-03_JPRB,8.3215E-03_JPRB,&
&7.2172E-03_JPRB,5.3794E-03_JPRB,1.8355E-02_JPRB/)
KAO( :, 2, 9,11) = (/&
&1.6231E-02_JPRB,1.4928E-02_JPRB,1.4498E-02_JPRB,1.3829E-02_JPRB,1.3241E-02_JPRB,1.2313E-02_JPRB,&
&1.0614E-02_JPRB,9.2668E-03_JPRB,1.9770E-02_JPRB/)
KAO( :, 3, 9,11) = (/&
&2.2130E-02_JPRB,2.0494E-02_JPRB,1.9903E-02_JPRB,1.9411E-02_JPRB,1.8773E-02_JPRB,1.7143E-02_JPRB,&
&1.4703E-02_JPRB,1.3790E-02_JPRB,2.1581E-02_JPRB/)
KAO( :, 4, 9,11) = (/&
&2.8872E-02_JPRB,2.6893E-02_JPRB,2.6410E-02_JPRB,2.6293E-02_JPRB,2.5184E-02_JPRB,2.2875E-02_JPRB,&
&1.9599E-02_JPRB,1.9453E-02_JPRB,2.4207E-02_JPRB/)
KAO( :, 5, 9,11) = (/&
&3.6434E-02_JPRB,3.4163E-02_JPRB,3.4039E-02_JPRB,3.4059E-02_JPRB,3.2485E-02_JPRB,2.9558E-02_JPRB,&
&2.6124E-02_JPRB,2.6908E-02_JPRB,2.8766E-02_JPRB/)
KAO( :, 1,10,11) = (/&
&9.7526E-03_JPRB,8.8471E-03_JPRB,8.4095E-03_JPRB,7.7992E-03_JPRB,7.2733E-03_JPRB,6.6861E-03_JPRB,&
&5.7804E-03_JPRB,4.0724E-03_JPRB,1.2763E-01_JPRB/)
KAO( :, 2,10,11) = (/&
&1.4441E-02_JPRB,1.3149E-02_JPRB,1.2436E-02_JPRB,1.1554E-02_JPRB,1.1049E-02_JPRB,1.0173E-02_JPRB,&
&8.7698E-03_JPRB,7.1450E-03_JPRB,1.2600E-01_JPRB/)
KAO( :, 3,10,11) = (/&
&2.0155E-02_JPRB,1.8437E-02_JPRB,1.7426E-02_JPRB,1.6603E-02_JPRB,1.5853E-02_JPRB,1.4561E-02_JPRB,&
&1.2511E-02_JPRB,1.1073E-02_JPRB,1.2528E-01_JPRB/)
KAO( :, 4,10,11) = (/&
&2.6846E-02_JPRB,2.4609E-02_JPRB,2.3486E-02_JPRB,2.2854E-02_JPRB,2.1623E-02_JPRB,1.9796E-02_JPRB,&
&1.6929E-02_JPRB,1.5991E-02_JPRB,1.2447E-01_JPRB/)
KAO( :, 5,10,11) = (/&
&3.4410E-02_JPRB,3.1744E-02_JPRB,3.0750E-02_JPRB,2.9972E-02_JPRB,2.8397E-02_JPRB,2.5966E-02_JPRB,&
&2.2616E-02_JPRB,2.2449E-02_JPRB,1.2610E-01_JPRB/)
KAO( :, 1,11,11) = (/&
&1.0324E-02_JPRB,9.3720E-03_JPRB,8.7252E-03_JPRB,7.9450E-03_JPRB,7.2482E-03_JPRB,6.5147E-03_JPRB,&
&5.6100E-03_JPRB,4.1662E-03_JPRB,3.4329E-01_JPRB/)
KAO( :, 2,11,11) = (/&
&1.5204E-02_JPRB,1.3885E-02_JPRB,1.2891E-02_JPRB,1.1869E-02_JPRB,1.0956E-02_JPRB,9.8826E-03_JPRB,&
&8.5703E-03_JPRB,6.8061E-03_JPRB,3.3565E-01_JPRB/)
KAO( :, 3,11,11) = (/&
&2.1115E-02_JPRB,1.9367E-02_JPRB,1.8058E-02_JPRB,1.6962E-02_JPRB,1.5612E-02_JPRB,1.4165E-02_JPRB,&
&1.2308E-02_JPRB,1.0528E-02_JPRB,3.2746E-01_JPRB/)
KAO( :, 4,11,11) = (/&
&2.8056E-02_JPRB,2.5869E-02_JPRB,2.4495E-02_JPRB,2.3019E-02_JPRB,2.1190E-02_JPRB,1.9340E-02_JPRB,&
&1.6909E-02_JPRB,1.5353E-02_JPRB,3.2105E-01_JPRB/)
KAO( :, 5,11,11) = (/&
&3.5830E-02_JPRB,3.3269E-02_JPRB,3.2053E-02_JPRB,3.0019E-02_JPRB,2.7764E-02_JPRB,2.5746E-02_JPRB,&
&2.2821E-02_JPRB,2.2018E-02_JPRB,3.1597E-01_JPRB/)
KAO( :, 1,12,11) = (/&
&1.0672E-02_JPRB,9.7549E-03_JPRB,9.0561E-03_JPRB,8.2466E-03_JPRB,7.3613E-03_JPRB,6.3875E-03_JPRB,&
&5.3947E-03_JPRB,4.0883E-03_JPRB,5.8394E-01_JPRB/)
KAO( :, 2,12,11) = (/&
&1.5642E-02_JPRB,1.4385E-02_JPRB,1.3307E-02_JPRB,1.2366E-02_JPRB,1.1058E-02_JPRB,9.6585E-03_JPRB,&
&8.3795E-03_JPRB,6.6353E-03_JPRB,5.6769E-01_JPRB/)
KAO( :, 3,12,11) = (/&
&2.1675E-02_JPRB,2.0001E-02_JPRB,1.8764E-02_JPRB,1.7488E-02_JPRB,1.5704E-02_JPRB,1.3828E-02_JPRB,&
&1.2045E-02_JPRB,1.0080E-02_JPRB,5.5255E-01_JPRB/)
KAO( :, 4,12,11) = (/&
&2.8647E-02_JPRB,2.6665E-02_JPRB,2.5514E-02_JPRB,2.3603E-02_JPRB,2.1257E-02_JPRB,1.8966E-02_JPRB,&
&1.6778E-02_JPRB,1.4837E-02_JPRB,5.4088E-01_JPRB/)
KAO( :, 5,12,11) = (/&
&3.6513E-02_JPRB,3.4282E-02_JPRB,3.3140E-02_JPRB,3.0751E-02_JPRB,2.7941E-02_JPRB,2.5430E-02_JPRB,&
&2.2803E-02_JPRB,2.1312E-02_JPRB,5.3155E-01_JPRB/)
KAO( :, 1,13,11) = (/&
&1.0760E-02_JPRB,9.9165E-03_JPRB,9.2107E-03_JPRB,8.4431E-03_JPRB,7.5043E-03_JPRB,6.4219E-03_JPRB,&
&5.3322E-03_JPRB,3.9942E-03_JPRB,8.0574E-01_JPRB/)
KAO( :, 2,13,11) = (/&
&1.5718E-02_JPRB,1.4579E-02_JPRB,1.3580E-02_JPRB,1.2603E-02_JPRB,1.1240E-02_JPRB,9.7118E-03_JPRB,&
&8.1489E-03_JPRB,6.5540E-03_JPRB,7.8546E-01_JPRB/)
KAO( :, 3,13,11) = (/&
&2.1709E-02_JPRB,2.0244E-02_JPRB,1.9196E-02_JPRB,1.7788E-02_JPRB,1.5932E-02_JPRB,1.3847E-02_JPRB,&
&1.1724E-02_JPRB,9.8122E-03_JPRB,7.6747E-01_JPRB/)
KAO( :, 4,13,11) = (/&
&2.8590E-02_JPRB,2.6855E-02_JPRB,2.5888E-02_JPRB,2.3974E-02_JPRB,2.1610E-02_JPRB,1.9031E-02_JPRB,&
&1.6481E-02_JPRB,1.4419E-02_JPRB,7.5290E-01_JPRB/)
KAO( :, 5,13,11) = (/&
&3.6243E-02_JPRB,3.4524E-02_JPRB,3.3518E-02_JPRB,3.1146E-02_JPRB,2.8589E-02_JPRB,2.5416E-02_JPRB,&
&2.2358E-02_JPRB,2.0400E-02_JPRB,7.4359E-01_JPRB/)
KAO( :, 1, 1,12) = (/&
&5.6231E-02_JPRB,4.9245E-02_JPRB,4.2437E-02_JPRB,3.9377E-02_JPRB,3.6183E-02_JPRB,3.2140E-02_JPRB,&
&3.2423E-02_JPRB,3.1523E-02_JPRB,4.6750E-02_JPRB/)
KAO( :, 2, 1,12) = (/&
&6.6148E-02_JPRB,5.7978E-02_JPRB,5.1041E-02_JPRB,4.8104E-02_JPRB,4.3912E-02_JPRB,4.1677E-02_JPRB,&
&4.3817E-02_JPRB,4.4437E-02_JPRB,6.2584E-02_JPRB/)
KAO( :, 3, 1,12) = (/&
&7.6244E-02_JPRB,6.6854E-02_JPRB,6.1488E-02_JPRB,5.7173E-02_JPRB,5.2540E-02_JPRB,5.2875E-02_JPRB,&
&5.7103E-02_JPRB,5.8708E-02_JPRB,8.0763E-02_JPRB/)
KAO( :, 4, 1,12) = (/&
&8.6310E-02_JPRB,7.5728E-02_JPRB,7.2130E-02_JPRB,6.6817E-02_JPRB,6.2530E-02_JPRB,6.5257E-02_JPRB,&
&7.2354E-02_JPRB,7.4823E-02_JPRB,1.0291E-01_JPRB/)
KAO( :, 5, 1,12) = (/&
&9.6172E-02_JPRB,8.4532E-02_JPRB,8.2586E-02_JPRB,7.6624E-02_JPRB,7.4096E-02_JPRB,7.9889E-02_JPRB,&
&9.0215E-02_JPRB,9.5892E-02_JPRB,1.2765E-01_JPRB/)
KAO( :, 1, 2,12) = (/&
&5.4471E-02_JPRB,4.7727E-02_JPRB,4.1337E-02_JPRB,3.9056E-02_JPRB,3.5201E-02_JPRB,3.1688E-02_JPRB,&
&3.1483E-02_JPRB,3.1390E-02_JPRB,4.4121E-02_JPRB/)
KAO( :, 2, 2,12) = (/&
&6.4761E-02_JPRB,5.6767E-02_JPRB,5.0472E-02_JPRB,4.7843E-02_JPRB,4.3316E-02_JPRB,4.1425E-02_JPRB,&
&4.2288E-02_JPRB,4.3887E-02_JPRB,5.9020E-02_JPRB/)
KAO( :, 3, 2,12) = (/&
&7.5278E-02_JPRB,6.6006E-02_JPRB,6.0892E-02_JPRB,5.7036E-02_JPRB,5.2510E-02_JPRB,5.2589E-02_JPRB,&
&5.4973E-02_JPRB,5.8082E-02_JPRB,7.6747E-02_JPRB/)
KAO( :, 4, 2,12) = (/&
&8.5814E-02_JPRB,7.5272E-02_JPRB,7.1653E-02_JPRB,6.6752E-02_JPRB,6.2771E-02_JPRB,6.5169E-02_JPRB,&
&7.0350E-02_JPRB,7.4345E-02_JPRB,9.8748E-02_JPRB/)
KAO( :, 5, 2,12) = (/&
&9.6214E-02_JPRB,8.4711E-02_JPRB,8.2534E-02_JPRB,7.6688E-02_JPRB,7.5320E-02_JPRB,7.9513E-02_JPRB,&
&8.8443E-02_JPRB,9.3326E-02_JPRB,1.2393E-01_JPRB/)
KAO( :, 1, 3,12) = (/&
&5.0240E-02_JPRB,4.4018E-02_JPRB,3.8537E-02_JPRB,3.6190E-02_JPRB,3.2727E-02_JPRB,2.9265E-02_JPRB,&
&2.8718E-02_JPRB,2.8539E-02_JPRB,3.8545E-02_JPRB/)
KAO( :, 2, 3,12) = (/&
&6.0700E-02_JPRB,5.3194E-02_JPRB,4.7696E-02_JPRB,4.4849E-02_JPRB,4.0923E-02_JPRB,3.8400E-02_JPRB,&
&3.8699E-02_JPRB,3.9635E-02_JPRB,5.2691E-02_JPRB/)
KAO( :, 3, 3,12) = (/&
&7.1446E-02_JPRB,6.2599E-02_JPRB,5.7763E-02_JPRB,5.4243E-02_JPRB,5.0207E-02_JPRB,4.9187E-02_JPRB,&
&5.0052E-02_JPRB,5.3471E-02_JPRB,6.9258E-02_JPRB/)
KAO( :, 4, 3,12) = (/&
&8.2289E-02_JPRB,7.2095E-02_JPRB,6.8416E-02_JPRB,6.4344E-02_JPRB,6.0447E-02_JPRB,6.1241E-02_JPRB,&
&6.3891E-02_JPRB,6.9264E-02_JPRB,8.9560E-02_JPRB/)
KAO( :, 5, 3,12) = (/&
&9.3052E-02_JPRB,8.1807E-02_JPRB,7.9129E-02_JPRB,7.4686E-02_JPRB,7.2461E-02_JPRB,7.5879E-02_JPRB,&
&8.1262E-02_JPRB,8.8197E-02_JPRB,1.1309E-01_JPRB/)
KAO( :, 1, 4,12) = (/&
&4.5028E-02_JPRB,3.9435E-02_JPRB,3.5334E-02_JPRB,3.2580E-02_JPRB,2.9727E-02_JPRB,2.6383E-02_JPRB,&
&2.5279E-02_JPRB,2.4249E-02_JPRB,3.2836E-02_JPRB/)
KAO( :, 2, 4,12) = (/&
&5.5340E-02_JPRB,4.8463E-02_JPRB,4.4234E-02_JPRB,4.0965E-02_JPRB,3.7511E-02_JPRB,3.4709E-02_JPRB,&
&3.4617E-02_JPRB,3.4578E-02_JPRB,4.5997E-02_JPRB/)
KAO( :, 3, 4,12) = (/&
&6.6183E-02_JPRB,5.7963E-02_JPRB,5.3924E-02_JPRB,5.0425E-02_JPRB,4.6576E-02_JPRB,4.4933E-02_JPRB,&
&4.5427E-02_JPRB,4.7054E-02_JPRB,6.1726E-02_JPRB/)
KAO( :, 4, 4,12) = (/&
&7.7283E-02_JPRB,6.7685E-02_JPRB,6.4408E-02_JPRB,6.0620E-02_JPRB,5.6689E-02_JPRB,5.6675E-02_JPRB,&
&5.7994E-02_JPRB,6.1679E-02_JPRB,8.0866E-02_JPRB/)
KAO( :, 5, 4,12) = (/&
&8.8418E-02_JPRB,7.8061E-02_JPRB,7.5140E-02_JPRB,7.1155E-02_JPRB,6.8119E-02_JPRB,7.0861E-02_JPRB,&
&7.3683E-02_JPRB,7.9503E-02_JPRB,1.0285E-01_JPRB/)
KAO( :, 1, 5,12) = (/&
&3.9662E-02_JPRB,3.4731E-02_JPRB,3.1644E-02_JPRB,2.8938E-02_JPRB,2.6745E-02_JPRB,2.3268E-02_JPRB,&
&2.1825E-02_JPRB,2.0476E-02_JPRB,2.7392E-02_JPRB/)
KAO( :, 2, 5,12) = (/&
&4.9795E-02_JPRB,4.3597E-02_JPRB,4.0424E-02_JPRB,3.7076E-02_JPRB,3.4194E-02_JPRB,3.1021E-02_JPRB,&
&3.0623E-02_JPRB,2.9562E-02_JPRB,3.9492E-02_JPRB/)
KAO( :, 3, 5,12) = (/&
&6.0584E-02_JPRB,5.3042E-02_JPRB,4.9894E-02_JPRB,4.6289E-02_JPRB,4.2817E-02_JPRB,4.0884E-02_JPRB,&
&4.1181E-02_JPRB,4.1314E-02_JPRB,5.4083E-02_JPRB/)
KAO( :, 4, 5,12) = (/&
&7.1810E-02_JPRB,6.2970E-02_JPRB,6.0288E-02_JPRB,5.6611E-02_JPRB,5.2417E-02_JPRB,5.2364E-02_JPRB,&
&5.3447E-02_JPRB,5.4733E-02_JPRB,7.1895E-02_JPRB/)
KAO( :, 5, 5,12) = (/&
&8.3191E-02_JPRB,7.3693E-02_JPRB,7.1136E-02_JPRB,6.7175E-02_JPRB,6.3303E-02_JPRB,6.5794E-02_JPRB,&
&6.8047E-02_JPRB,7.1167E-02_JPRB,9.3099E-02_JPRB/)
KAO( :, 1, 6,12) = (/&
&3.4073E-02_JPRB,2.9970E-02_JPRB,2.7448E-02_JPRB,2.5187E-02_JPRB,2.3238E-02_JPRB,2.0151E-02_JPRB,&
&1.8356E-02_JPRB,1.7087E-02_JPRB,2.1825E-02_JPRB/)
KAO( :, 2, 6,12) = (/&
&4.3805E-02_JPRB,3.8540E-02_JPRB,3.5809E-02_JPRB,3.2989E-02_JPRB,3.0183E-02_JPRB,2.7066E-02_JPRB,&
&2.6460E-02_JPRB,2.5241E-02_JPRB,3.2266E-02_JPRB/)
KAO( :, 3, 6,12) = (/&
&5.4408E-02_JPRB,4.7827E-02_JPRB,4.4959E-02_JPRB,4.1832E-02_JPRB,3.8412E-02_JPRB,3.6156E-02_JPRB,&
&3.6616E-02_JPRB,3.5630E-02_JPRB,4.5299E-02_JPRB/)
KAO( :, 4, 6,12) = (/&
&6.5566E-02_JPRB,5.7738E-02_JPRB,5.4996E-02_JPRB,5.1938E-02_JPRB,4.7753E-02_JPRB,4.7435E-02_JPRB,&
&4.8559E-02_JPRB,4.8244E-02_JPRB,6.1467E-02_JPRB/)
KAO( :, 5, 6,12) = (/&
&7.7055E-02_JPRB,6.8635E-02_JPRB,6.5830E-02_JPRB,6.2404E-02_JPRB,5.8371E-02_JPRB,6.0640E-02_JPRB,&
&6.2553E-02_JPRB,6.3410E-02_JPRB,8.1734E-02_JPRB/)
KAO( :, 1, 7,12) = (/&
&2.8703E-02_JPRB,2.5583E-02_JPRB,2.3276E-02_JPRB,2.1697E-02_JPRB,1.9747E-02_JPRB,1.7089E-02_JPRB,&
&1.5072E-02_JPRB,1.3835E-02_JPRB,1.6883E-02_JPRB/)
KAO( :, 2, 7,12) = (/&
&3.7935E-02_JPRB,3.3728E-02_JPRB,3.1173E-02_JPRB,2.9047E-02_JPRB,2.6304E-02_JPRB,2.3254E-02_JPRB,&
&2.2495E-02_JPRB,2.1233E-02_JPRB,2.5258E-02_JPRB/)
KAO( :, 3, 7,12) = (/&
&4.8109E-02_JPRB,4.2733E-02_JPRB,3.9875E-02_JPRB,3.7411E-02_JPRB,3.4221E-02_JPRB,3.1727E-02_JPRB,&
&3.2013E-02_JPRB,3.0954E-02_JPRB,3.6228E-02_JPRB/)
KAO( :, 4, 7,12) = (/&
&5.9015E-02_JPRB,5.2712E-02_JPRB,4.9724E-02_JPRB,4.7098E-02_JPRB,4.3201E-02_JPRB,4.2396E-02_JPRB,&
&4.3420E-02_JPRB,4.2821E-02_JPRB,5.0322E-02_JPRB/)
KAO( :, 5, 7,12) = (/&
&7.0562E-02_JPRB,6.3765E-02_JPRB,6.0647E-02_JPRB,5.7324E-02_JPRB,5.3581E-02_JPRB,5.4932E-02_JPRB,&
&5.6750E-02_JPRB,5.6861E-02_JPRB,6.8648E-02_JPRB/)
KAO( :, 1, 8,12) = (/&
&2.3797E-02_JPRB,2.1507E-02_JPRB,1.9481E-02_JPRB,1.8328E-02_JPRB,1.6567E-02_JPRB,1.4195E-02_JPRB,&
&1.2226E-02_JPRB,1.1084E-02_JPRB,1.2769E-02_JPRB/)
KAO( :, 2, 8,12) = (/&
&3.2290E-02_JPRB,2.9132E-02_JPRB,2.6787E-02_JPRB,2.5154E-02_JPRB,2.2698E-02_JPRB,1.9789E-02_JPRB,&
&1.8738E-02_JPRB,1.7668E-02_JPRB,1.9523E-02_JPRB/)
KAO( :, 3, 8,12) = (/&
&4.1971E-02_JPRB,3.7809E-02_JPRB,3.5153E-02_JPRB,3.3039E-02_JPRB,3.0227E-02_JPRB,2.7550E-02_JPRB,&
&2.7403E-02_JPRB,2.6633E-02_JPRB,2.8356E-02_JPRB/)
KAO( :, 4, 8,12) = (/&
&5.2643E-02_JPRB,4.7711E-02_JPRB,4.4776E-02_JPRB,4.2382E-02_JPRB,3.8941E-02_JPRB,3.7160E-02_JPRB,&
&3.7962E-02_JPRB,3.7660E-02_JPRB,4.0067E-02_JPRB/)
KAO( :, 5, 8,12) = (/&
&6.4120E-02_JPRB,5.8657E-02_JPRB,5.5707E-02_JPRB,5.2735E-02_JPRB,4.8989E-02_JPRB,4.8789E-02_JPRB,&
&5.0472E-02_JPRB,5.0598E-02_JPRB,5.5953E-02_JPRB/)
KAO( :, 1, 9,12) = (/&
&1.9250E-02_JPRB,1.7588E-02_JPRB,1.6042E-02_JPRB,1.5146E-02_JPRB,1.3631E-02_JPRB,1.1686E-02_JPRB,&
&9.9858E-03_JPRB,8.6677E-03_JPRB,2.1707E-02_JPRB/)
KAO( :, 2, 9,12) = (/&
&2.7012E-02_JPRB,2.4595E-02_JPRB,2.2809E-02_JPRB,2.1369E-02_JPRB,1.9226E-02_JPRB,1.6776E-02_JPRB,&
&1.5292E-02_JPRB,1.4425E-02_JPRB,2.4366E-02_JPRB/)
KAO( :, 3, 9,12) = (/&
&3.6057E-02_JPRB,3.2810E-02_JPRB,3.0756E-02_JPRB,2.8820E-02_JPRB,2.6287E-02_JPRB,2.3677E-02_JPRB,&
&2.2692E-02_JPRB,2.2334E-02_JPRB,2.7809E-02_JPRB/)
KAO( :, 4, 9,12) = (/&
&4.6276E-02_JPRB,4.2323E-02_JPRB,4.0041E-02_JPRB,3.7778E-02_JPRB,3.4895E-02_JPRB,3.2122E-02_JPRB,&
&3.2057E-02_JPRB,3.2163E-02_JPRB,3.3773E-02_JPRB/)
KAO( :, 5, 9,12) = (/&
&5.7287E-02_JPRB,5.2928E-02_JPRB,5.0545E-02_JPRB,4.8124E-02_JPRB,4.4442E-02_JPRB,4.2249E-02_JPRB,&
&4.3334E-02_JPRB,4.4067E-02_JPRB,4.5714E-02_JPRB/)
KAO( :, 1,10,12) = (/&
&1.5724E-02_JPRB,1.4480E-02_JPRB,1.3399E-02_JPRB,1.2607E-02_JPRB,1.1371E-02_JPRB,9.8756E-03_JPRB,&
&8.2202E-03_JPRB,7.0920E-03_JPRB,1.5327E-01_JPRB/)
KAO( :, 2,10,12) = (/&
&2.2742E-02_JPRB,2.0839E-02_JPRB,1.9648E-02_JPRB,1.8330E-02_JPRB,1.6472E-02_JPRB,1.4615E-02_JPRB,&
&1.2794E-02_JPRB,1.2185E-02_JPRB,1.5107E-01_JPRB/)
KAO( :, 3,10,12) = (/&
&3.1111E-02_JPRB,2.8526E-02_JPRB,2.7137E-02_JPRB,2.5313E-02_JPRB,2.3236E-02_JPRB,2.0664E-02_JPRB,&
&1.8952E-02_JPRB,1.8782E-02_JPRB,1.5057E-01_JPRB/)
KAO( :, 4,10,12) = (/&
&4.0637E-02_JPRB,3.7549E-02_JPRB,3.5922E-02_JPRB,3.3978E-02_JPRB,3.1652E-02_JPRB,2.8132E-02_JPRB,&
&2.7006E-02_JPRB,2.7319E-02_JPRB,1.5207E-01_JPRB/)
KAO( :, 5,10,12) = (/&
&5.1227E-02_JPRB,4.7699E-02_JPRB,4.6069E-02_JPRB,4.4170E-02_JPRB,4.0891E-02_JPRB,3.7225E-02_JPRB,&
&3.7060E-02_JPRB,3.8071E-02_JPRB,1.5409E-01_JPRB/)
KAO( :, 1,11,12) = (/&
&1.5555E-02_JPRB,1.4241E-02_JPRB,1.3404E-02_JPRB,1.2541E-02_JPRB,1.1360E-02_JPRB,1.0012E-02_JPRB,&
&8.3342E-03_JPRB,7.3523E-03_JPRB,4.1658E-01_JPRB/)
KAO( :, 2,11,12) = (/&
&2.2569E-02_JPRB,2.0619E-02_JPRB,1.9629E-02_JPRB,1.8217E-02_JPRB,1.6713E-02_JPRB,1.4923E-02_JPRB,&
&1.2799E-02_JPRB,1.2337E-02_JPRB,4.0531E-01_JPRB/)
KAO( :, 3,11,12) = (/&
&3.1003E-02_JPRB,2.8414E-02_JPRB,2.7101E-02_JPRB,2.5438E-02_JPRB,2.3803E-02_JPRB,2.0993E-02_JPRB,&
&1.8716E-02_JPRB,1.8686E-02_JPRB,3.9474E-01_JPRB/)
KAO( :, 4,11,12) = (/&
&4.0722E-02_JPRB,3.7543E-02_JPRB,3.5908E-02_JPRB,3.4570E-02_JPRB,3.2168E-02_JPRB,2.8356E-02_JPRB,&
&2.6227E-02_JPRB,2.6848E-02_JPRB,3.8831E-01_JPRB/)
KAO( :, 5,11,12) = (/&
&5.1560E-02_JPRB,4.7783E-02_JPRB,4.6376E-02_JPRB,4.5061E-02_JPRB,4.1670E-02_JPRB,3.7328E-02_JPRB,&
&3.5965E-02_JPRB,3.7251E-02_JPRB,3.8125E-01_JPRB/)
KAO( :, 1,12,12) = (/&
&1.5830E-02_JPRB,1.4387E-02_JPRB,1.3516E-02_JPRB,1.2418E-02_JPRB,1.1346E-02_JPRB,1.0079E-02_JPRB,&
&8.3729E-03_JPRB,7.3472E-03_JPRB,7.1942E-01_JPRB/)
KAO( :, 2,12,12) = (/&
&2.3055E-02_JPRB,2.0962E-02_JPRB,1.9738E-02_JPRB,1.8144E-02_JPRB,1.6929E-02_JPRB,1.5067E-02_JPRB,&
&1.2702E-02_JPRB,1.1955E-02_JPRB,6.9772E-01_JPRB/)
KAO( :, 3,12,12) = (/&
&3.1847E-02_JPRB,2.9081E-02_JPRB,2.7322E-02_JPRB,2.5612E-02_JPRB,2.3940E-02_JPRB,2.1303E-02_JPRB,&
&1.8481E-02_JPRB,1.8181E-02_JPRB,6.7687E-01_JPRB/)
KAO( :, 4,12,12) = (/&
&4.1961E-02_JPRB,3.8413E-02_JPRB,3.6388E-02_JPRB,3.4886E-02_JPRB,3.2236E-02_JPRB,2.8808E-02_JPRB,&
&2.5797E-02_JPRB,2.6077E-02_JPRB,6.5603E-01_JPRB/)
KAO( :, 5,12,12) = (/&
&5.3319E-02_JPRB,4.9117E-02_JPRB,4.7169E-02_JPRB,4.5236E-02_JPRB,4.1943E-02_JPRB,3.7873E-02_JPRB,&
&3.5355E-02_JPRB,3.6412E-02_JPRB,6.4190E-01_JPRB/)
KAO( :, 1,13,12) = (/&
&1.6495E-02_JPRB,1.4909E-02_JPRB,1.3825E-02_JPRB,1.2544E-02_JPRB,1.1340E-02_JPRB,9.9975E-03_JPRB,&
&8.3433E-03_JPRB,7.0546E-03_JPRB,9.9911E-01_JPRB/)
KAO( :, 2,13,12) = (/&
&2.4109E-02_JPRB,2.1885E-02_JPRB,2.0210E-02_JPRB,1.8488E-02_JPRB,1.6936E-02_JPRB,1.4953E-02_JPRB,&
&1.2660E-02_JPRB,1.1467E-02_JPRB,9.6984E-01_JPRB/)
KAO( :, 3,13,12) = (/&
&3.3220E-02_JPRB,3.0296E-02_JPRB,2.8083E-02_JPRB,2.6185E-02_JPRB,2.3860E-02_JPRB,2.1223E-02_JPRB,&
&1.8346E-02_JPRB,1.7437E-02_JPRB,9.3888E-01_JPRB/)
KAO( :, 4,13,12) = (/&
&4.3831E-02_JPRB,4.0158E-02_JPRB,3.7697E-02_JPRB,3.5285E-02_JPRB,3.2116E-02_JPRB,2.8881E-02_JPRB,&
&2.5602E-02_JPRB,2.5164E-02_JPRB,9.0808E-01_JPRB/)
KAO( :, 5,13,12) = (/&
&5.5677E-02_JPRB,5.1368E-02_JPRB,4.8923E-02_JPRB,4.5702E-02_JPRB,4.1832E-02_JPRB,3.8470E-02_JPRB,&
&3.5318E-02_JPRB,3.5646E-02_JPRB,8.8465E-01_JPRB/)
KAO( :, 1, 1,13) = (/&
&7.2506E-02_JPRB,6.3446E-02_JPRB,5.4408E-02_JPRB,4.7483E-02_JPRB,4.2382E-02_JPRB,4.1239E-02_JPRB,&
&4.3386E-02_JPRB,4.4074E-02_JPRB,6.4271E-02_JPRB/)
KAO( :, 2, 1,13) = (/&
&8.4465E-02_JPRB,7.3953E-02_JPRB,6.3427E-02_JPRB,5.6900E-02_JPRB,5.2376E-02_JPRB,5.3648E-02_JPRB,&
&5.8354E-02_JPRB,5.9101E-02_JPRB,8.6583E-02_JPRB/)
KAO( :, 3, 1,13) = (/&
&9.6444E-02_JPRB,8.4439E-02_JPRB,7.3063E-02_JPRB,6.7601E-02_JPRB,6.5429E-02_JPRB,6.9474E-02_JPRB,&
&7.7817E-02_JPRB,8.1204E-02_JPRB,1.1413E-01_JPRB/)
KAO( :, 4, 1,13) = (/&
&1.0833E-01_JPRB,9.4864E-02_JPRB,8.5278E-02_JPRB,7.9673E-02_JPRB,8.1089E-02_JPRB,9.1367E-02_JPRB,&
&1.0434E-01_JPRB,1.1177E-01_JPRB,1.4904E-01_JPRB/)
KAO( :, 5, 1,13) = (/&
&1.1980E-01_JPRB,1.0493E-01_JPRB,9.6406E-02_JPRB,9.4783E-02_JPRB,1.0132E-01_JPRB,1.1971E-01_JPRB,&
&1.3809E-01_JPRB,1.4964E-01_JPRB,1.9375E-01_JPRB/)
KAO( :, 1, 2,13) = (/&
&7.1478E-02_JPRB,6.2570E-02_JPRB,5.3664E-02_JPRB,4.6754E-02_JPRB,4.2681E-02_JPRB,4.1156E-02_JPRB,&
&4.2008E-02_JPRB,4.2483E-02_JPRB,6.2959E-02_JPRB/)
KAO( :, 2, 2,13) = (/&
&8.4247E-02_JPRB,7.3747E-02_JPRB,6.3249E-02_JPRB,5.6233E-02_JPRB,5.3534E-02_JPRB,5.3727E-02_JPRB,&
&5.7468E-02_JPRB,5.8178E-02_JPRB,8.6328E-02_JPRB/)
KAO( :, 3, 2,13) = (/&
&9.6812E-02_JPRB,8.4747E-02_JPRB,7.4116E-02_JPRB,6.7508E-02_JPRB,6.6781E-02_JPRB,6.9983E-02_JPRB,&
&7.6767E-02_JPRB,7.7852E-02_JPRB,1.1485E-01_JPRB/)
KAO( :, 4, 2,13) = (/&
&1.0887E-01_JPRB,9.5297E-02_JPRB,8.6108E-02_JPRB,8.0754E-02_JPRB,8.2919E-02_JPRB,8.8967E-02_JPRB,&
&1.0013E-01_JPRB,1.0496E-01_JPRB,1.4738E-01_JPRB/)
KAO( :, 5, 2,13) = (/&
&1.2040E-01_JPRB,1.0544E-01_JPRB,9.8262E-02_JPRB,9.7024E-02_JPRB,1.0128E-01_JPRB,1.1389E-01_JPRB,&
&1.3047E-01_JPRB,1.4126E-01_JPRB,1.8810E-01_JPRB/)
KAO( :, 1, 3,13) = (/&
&6.7428E-02_JPRB,5.9012E-02_JPRB,5.0600E-02_JPRB,4.4820E-02_JPRB,4.0284E-02_JPRB,3.8905E-02_JPRB,&
&3.8433E-02_JPRB,3.8221E-02_JPRB,5.7695E-02_JPRB/)
KAO( :, 2, 3,13) = (/&
&8.0097E-02_JPRB,7.0092E-02_JPRB,6.0231E-02_JPRB,5.4560E-02_JPRB,5.1238E-02_JPRB,5.1427E-02_JPRB,&
&5.2635E-02_JPRB,5.3599E-02_JPRB,7.9873E-02_JPRB/)
KAO( :, 3, 3,13) = (/&
&9.2835E-02_JPRB,8.1288E-02_JPRB,7.1303E-02_JPRB,6.5788E-02_JPRB,6.5168E-02_JPRB,6.7196E-02_JPRB,&
&7.1689E-02_JPRB,7.2641E-02_JPRB,1.0771E-01_JPRB/)
KAO( :, 4, 3,13) = (/&
&1.0559E-01_JPRB,9.2480E-02_JPRB,8.3299E-02_JPRB,7.8616E-02_JPRB,8.1678E-02_JPRB,8.5882E-02_JPRB,&
&9.4318E-02_JPRB,9.6259E-02_JPRB,1.4043E-01_JPRB/)
KAO( :, 5, 3,13) = (/&
&1.1824E-01_JPRB,1.0358E-01_JPRB,9.6455E-02_JPRB,9.5066E-02_JPRB,9.9972E-02_JPRB,1.0747E-01_JPRB,&
&1.2012E-01_JPRB,1.2676E-01_JPRB,1.7816E-01_JPRB/)
KAO( :, 1, 4,13) = (/&
&6.1574E-02_JPRB,5.3893E-02_JPRB,4.6221E-02_JPRB,4.1581E-02_JPRB,3.7011E-02_JPRB,3.6135E-02_JPRB,&
&3.5573E-02_JPRB,3.4371E-02_JPRB,5.0320E-02_JPRB/)
KAO( :, 2, 4,13) = (/&
&7.4469E-02_JPRB,6.5196E-02_JPRB,5.6073E-02_JPRB,5.1353E-02_JPRB,4.7821E-02_JPRB,4.7971E-02_JPRB,&
&4.8104E-02_JPRB,4.8151E-02_JPRB,7.0598E-02_JPRB/)
KAO( :, 3, 4,13) = (/&
&8.7893E-02_JPRB,7.6969E-02_JPRB,6.7380E-02_JPRB,6.2778E-02_JPRB,6.1745E-02_JPRB,6.3327E-02_JPRB,&
&6.5251E-02_JPRB,6.6605E-02_JPRB,9.6688E-02_JPRB/)
KAO( :, 4, 4,13) = (/&
&1.0128E-01_JPRB,8.8666E-02_JPRB,7.9558E-02_JPRB,7.6113E-02_JPRB,7.8711E-02_JPRB,8.2067E-02_JPRB,&
&8.7118E-02_JPRB,8.9685E-02_JPRB,1.2734E-01_JPRB/)
KAO( :, 5, 4,13) = (/&
&1.1397E-01_JPRB,9.9791E-02_JPRB,9.3095E-02_JPRB,9.2358E-02_JPRB,9.7817E-02_JPRB,1.0283E-01_JPRB,&
&1.1271E-01_JPRB,1.1615E-01_JPRB,1.6394E-01_JPRB/)
KAO( :, 1, 5,13) = (/&
&5.5644E-02_JPRB,4.8706E-02_JPRB,4.2042E-02_JPRB,3.7730E-02_JPRB,3.3816E-02_JPRB,3.3296E-02_JPRB,&
&3.2567E-02_JPRB,3.1307E-02_JPRB,4.2852E-02_JPRB/)
KAO( :, 2, 5,13) = (/&
&6.8700E-02_JPRB,6.0145E-02_JPRB,5.2078E-02_JPRB,4.7465E-02_JPRB,4.4257E-02_JPRB,4.4542E-02_JPRB,&
&4.3904E-02_JPRB,4.3555E-02_JPRB,6.1397E-02_JPRB/)
KAO( :, 3, 5,13) = (/&
&8.2079E-02_JPRB,7.1842E-02_JPRB,6.3336E-02_JPRB,5.8826E-02_JPRB,5.7771E-02_JPRB,5.9150E-02_JPRB,&
&5.9615E-02_JPRB,6.0276E-02_JPRB,8.5213E-02_JPRB/)
KAO( :, 4, 5,13) = (/&
&9.5395E-02_JPRB,8.3509E-02_JPRB,7.5491E-02_JPRB,7.2428E-02_JPRB,7.4615E-02_JPRB,7.7323E-02_JPRB,&
&7.9697E-02_JPRB,8.2375E-02_JPRB,1.1408E-01_JPRB/)
KAO( :, 5, 5,13) = (/&
&1.0879E-01_JPRB,9.5224E-02_JPRB,8.9008E-02_JPRB,8.9139E-02_JPRB,9.4277E-02_JPRB,9.8162E-02_JPRB,&
&1.0347E-01_JPRB,1.0938E-01_JPRB,1.4850E-01_JPRB/)
KAO( :, 1, 6,13) = (/&
&4.9166E-02_JPRB,4.3032E-02_JPRB,3.7697E-02_JPRB,3.3418E-02_JPRB,3.0271E-02_JPRB,2.9707E-02_JPRB,&
&2.8739E-02_JPRB,2.7107E-02_JPRB,3.5180E-02_JPRB/)
KAO( :, 2, 6,13) = (/&
&6.1802E-02_JPRB,5.4091E-02_JPRB,4.7585E-02_JPRB,4.2912E-02_JPRB,4.0335E-02_JPRB,4.0310E-02_JPRB,&
&3.9360E-02_JPRB,3.8194E-02_JPRB,5.1590E-02_JPRB/)
KAO( :, 3, 6,13) = (/&
&7.4933E-02_JPRB,6.5583E-02_JPRB,5.8743E-02_JPRB,5.3925E-02_JPRB,5.3041E-02_JPRB,5.4106E-02_JPRB,&
&5.3825E-02_JPRB,5.3725E-02_JPRB,7.3865E-02_JPRB/)
KAO( :, 4, 6,13) = (/&
&8.8794E-02_JPRB,7.7714E-02_JPRB,7.0892E-02_JPRB,6.7266E-02_JPRB,6.9411E-02_JPRB,7.1602E-02_JPRB,&
&7.2167E-02_JPRB,7.4198E-02_JPRB,1.0072E-01_JPRB/)
KAO( :, 5, 6,13) = (/&
&1.0284E-01_JPRB,9.0019E-02_JPRB,8.4346E-02_JPRB,8.3697E-02_JPRB,8.8853E-02_JPRB,9.1618E-02_JPRB,&
&9.4095E-02_JPRB,9.9493E-02_JPRB,1.3200E-01_JPRB/)
KAO( :, 1, 7,13) = (/&
&4.2481E-02_JPRB,3.7182E-02_JPRB,3.2941E-02_JPRB,2.9053E-02_JPRB,2.6729E-02_JPRB,2.5857E-02_JPRB,&
&2.4817E-02_JPRB,2.3036E-02_JPRB,2.8513E-02_JPRB/)
KAO( :, 2, 7,13) = (/&
&5.4646E-02_JPRB,4.7829E-02_JPRB,4.2493E-02_JPRB,3.8260E-02_JPRB,3.6179E-02_JPRB,3.5843E-02_JPRB,&
&3.4675E-02_JPRB,3.3090E-02_JPRB,4.3061E-02_JPRB/)
KAO( :, 3, 7,13) = (/&
&6.7949E-02_JPRB,5.9473E-02_JPRB,5.3629E-02_JPRB,4.8997E-02_JPRB,4.7960E-02_JPRB,4.8517E-02_JPRB,&
&4.7980E-02_JPRB,4.6686E-02_JPRB,6.3225E-02_JPRB/)
KAO( :, 4, 7,13) = (/&
&8.2011E-02_JPRB,7.1775E-02_JPRB,6.5638E-02_JPRB,6.1779E-02_JPRB,6.3457E-02_JPRB,6.4989E-02_JPRB,&
&6.5420E-02_JPRB,6.5338E-02_JPRB,8.8114E-02_JPRB/)
KAO( :, 5, 7,13) = (/&
&9.6121E-02_JPRB,8.4118E-02_JPRB,7.9080E-02_JPRB,7.7840E-02_JPRB,8.2099E-02_JPRB,8.4733E-02_JPRB,&
&8.6013E-02_JPRB,8.9165E-02_JPRB,1.1782E-01_JPRB/)
KAO( :, 1, 8,13) = (/&
&3.6137E-02_JPRB,3.1658E-02_JPRB,2.8232E-02_JPRB,2.4974E-02_JPRB,2.3118E-02_JPRB,2.2088E-02_JPRB,&
&2.1064E-02_JPRB,1.9376E-02_JPRB,2.2745E-02_JPRB/)
KAO( :, 2, 8,13) = (/&
&4.8016E-02_JPRB,4.2076E-02_JPRB,3.7504E-02_JPRB,3.3789E-02_JPRB,3.1931E-02_JPRB,3.1218E-02_JPRB,&
&3.0077E-02_JPRB,2.8144E-02_JPRB,3.5232E-02_JPRB/)
KAO( :, 3, 8,13) = (/&
&6.1205E-02_JPRB,5.3668E-02_JPRB,4.8373E-02_JPRB,4.4145E-02_JPRB,4.2766E-02_JPRB,4.3001E-02_JPRB,&
&4.2234E-02_JPRB,4.0332E-02_JPRB,5.3276E-02_JPRB/)
KAO( :, 4, 8,13) = (/&
&7.5025E-02_JPRB,6.5801E-02_JPRB,6.0176E-02_JPRB,5.6410E-02_JPRB,5.7125E-02_JPRB,5.8703E-02_JPRB,&
&5.8721E-02_JPRB,5.7394E-02_JPRB,7.6141E-02_JPRB/)
KAO( :, 5, 8,13) = (/&
&8.9588E-02_JPRB,7.8614E-02_JPRB,7.3265E-02_JPRB,7.1609E-02_JPRB,7.4944E-02_JPRB,7.7845E-02_JPRB,&
&7.8817E-02_JPRB,7.9234E-02_JPRB,1.0406E-01_JPRB/)
KAO( :, 1, 9,13) = (/&
&3.0354E-02_JPRB,2.6812E-02_JPRB,2.3806E-02_JPRB,2.1190E-02_JPRB,1.9445E-02_JPRB,1.8240E-02_JPRB,&
&1.7300E-02_JPRB,1.5970E-02_JPRB,2.7469E-02_JPRB/)
KAO( :, 2, 9,13) = (/&
&4.1683E-02_JPRB,3.6828E-02_JPRB,3.2679E-02_JPRB,2.9622E-02_JPRB,2.7586E-02_JPRB,2.6377E-02_JPRB,&
&2.5396E-02_JPRB,2.3781E-02_JPRB,3.1985E-02_JPRB/)
KAO( :, 3, 9,13) = (/&
&5.4431E-02_JPRB,4.8107E-02_JPRB,4.3192E-02_JPRB,3.9529E-02_JPRB,3.7624E-02_JPRB,3.7195E-02_JPRB,&
&3.6607E-02_JPRB,3.4524E-02_JPRB,4.4340E-02_JPRB/)
KAO( :, 4, 9,13) = (/&
&6.8321E-02_JPRB,6.0391E-02_JPRB,5.4610E-02_JPRB,5.1211E-02_JPRB,5.0615E-02_JPRB,5.1938E-02_JPRB,&
&5.2206E-02_JPRB,5.0002E-02_JPRB,6.4376E-02_JPRB/)
KAO( :, 5, 9,13) = (/&
&8.3382E-02_JPRB,7.3864E-02_JPRB,6.7608E-02_JPRB,6.5416E-02_JPRB,6.7796E-02_JPRB,7.0544E-02_JPRB,&
&7.1581E-02_JPRB,7.0367E-02_JPRB,8.9820E-02_JPRB/)
KAO( :, 1,10,13) = (/&
&2.5866E-02_JPRB,2.3096E-02_JPRB,2.0359E-02_JPRB,1.8244E-02_JPRB,1.6555E-02_JPRB,1.5241E-02_JPRB,&
&1.4537E-02_JPRB,1.3197E-02_JPRB,1.8207E-01_JPRB/)
KAO( :, 2,10,13) = (/&
&3.6597E-02_JPRB,3.2659E-02_JPRB,2.8899E-02_JPRB,2.6262E-02_JPRB,2.4046E-02_JPRB,2.2449E-02_JPRB,&
&2.1774E-02_JPRB,2.0251E-02_JPRB,1.8269E-01_JPRB/)
KAO( :, 3,10,13) = (/&
&4.8990E-02_JPRB,4.3688E-02_JPRB,3.9094E-02_JPRB,3.5827E-02_JPRB,3.3277E-02_JPRB,3.2592E-02_JPRB,&
&3.2234E-02_JPRB,3.0480E-02_JPRB,1.8337E-01_JPRB/)
KAO( :, 4,10,13) = (/&
&6.3031E-02_JPRB,5.6150E-02_JPRB,5.0614E-02_JPRB,4.7098E-02_JPRB,4.5295E-02_JPRB,4.6573E-02_JPRB,&
&4.6974E-02_JPRB,4.5107E-02_JPRB,1.8526E-01_JPRB/)
KAO( :, 5,10,13) = (/&
&7.8337E-02_JPRB,7.0036E-02_JPRB,6.3907E-02_JPRB,6.0875E-02_JPRB,6.1588E-02_JPRB,6.4404E-02_JPRB,&
&6.5574E-02_JPRB,6.4038E-02_JPRB,1.9009E-01_JPRB/)
KAO( :, 1,11,13) = (/&
&2.6170E-02_JPRB,2.3547E-02_JPRB,2.0835E-02_JPRB,1.8825E-02_JPRB,1.6889E-02_JPRB,1.5401E-02_JPRB,&
&1.4727E-02_JPRB,1.3614E-02_JPRB,5.0818E-01_JPRB/)
KAO( :, 2,11,13) = (/&
&3.7087E-02_JPRB,3.3315E-02_JPRB,2.9858E-02_JPRB,2.7151E-02_JPRB,2.4450E-02_JPRB,2.2833E-02_JPRB,&
&2.2404E-02_JPRB,2.1001E-02_JPRB,5.0103E-01_JPRB/)
KAO( :, 3,11,13) = (/&
&4.9963E-02_JPRB,4.4837E-02_JPRB,4.0625E-02_JPRB,3.7044E-02_JPRB,3.4135E-02_JPRB,3.3574E-02_JPRB,&
&3.3602E-02_JPRB,3.2090E-02_JPRB,4.9194E-01_JPRB/)
KAO( :, 4,11,13) = (/&
&6.4516E-02_JPRB,5.7977E-02_JPRB,5.3206E-02_JPRB,4.8937E-02_JPRB,4.7272E-02_JPRB,4.8448E-02_JPRB,&
&4.9192E-02_JPRB,4.7870E-02_JPRB,4.8323E-01_JPRB/)
KAO( :, 5,11,13) = (/&
&8.0357E-02_JPRB,7.2810E-02_JPRB,6.7423E-02_JPRB,6.3846E-02_JPRB,6.4063E-02_JPRB,6.6805E-02_JPRB,&
&6.8458E-02_JPRB,6.7693E-02_JPRB,4.8224E-01_JPRB/)
KAO( :, 1,12,13) = (/&
&2.6382E-02_JPRB,2.3869E-02_JPRB,2.1423E-02_JPRB,1.9530E-02_JPRB,1.7276E-02_JPRB,1.5597E-02_JPRB,&
&1.4852E-02_JPRB,1.3926E-02_JPRB,8.8613E-01_JPRB/)
KAO( :, 2,12,13) = (/&
&3.7554E-02_JPRB,3.3911E-02_JPRB,3.0989E-02_JPRB,2.8114E-02_JPRB,2.5051E-02_JPRB,2.3359E-02_JPRB,&
&2.2994E-02_JPRB,2.2005E-02_JPRB,8.7122E-01_JPRB/)
KAO( :, 3,12,13) = (/&
&5.0689E-02_JPRB,4.5835E-02_JPRB,4.2372E-02_JPRB,3.8639E-02_JPRB,3.5524E-02_JPRB,3.4470E-02_JPRB,&
&3.4752E-02_JPRB,3.3789E-02_JPRB,8.5297E-01_JPRB/)
KAO( :, 4,12,13) = (/&
&6.5611E-02_JPRB,5.9692E-02_JPRB,5.5677E-02_JPRB,5.1555E-02_JPRB,4.9587E-02_JPRB,4.9441E-02_JPRB,&
&5.0436E-02_JPRB,4.9926E-02_JPRB,8.3445E-01_JPRB/)
KAO( :, 5,12,13) = (/&
&8.2012E-02_JPRB,7.5239E-02_JPRB,7.1004E-02_JPRB,6.7701E-02_JPRB,6.6707E-02_JPRB,6.7915E-02_JPRB,&
&6.9915E-02_JPRB,7.0294E-02_JPRB,8.1920E-01_JPRB/)
KAO( :, 1,13,13) = (/&
&2.6411E-02_JPRB,2.4001E-02_JPRB,2.2003E-02_JPRB,2.0098E-02_JPRB,1.7783E-02_JPRB,1.5910E-02_JPRB,&
&1.4921E-02_JPRB,1.4266E-02_JPRB,1.2499E+00_JPRB/)
KAO( :, 2,13,13) = (/&
&3.7728E-02_JPRB,3.4235E-02_JPRB,3.1890E-02_JPRB,2.9069E-02_JPRB,2.6051E-02_JPRB,2.4137E-02_JPRB,&
&2.3431E-02_JPRB,2.2763E-02_JPRB,1.2233E+00_JPRB/)
KAO( :, 3,13,13) = (/&
&5.1168E-02_JPRB,4.6582E-02_JPRB,4.3725E-02_JPRB,4.0296E-02_JPRB,3.7356E-02_JPRB,3.5542E-02_JPRB,&
&3.5231E-02_JPRB,3.4850E-02_JPRB,1.1970E+00_JPRB/)
KAO( :, 4,13,13) = (/&
&6.6532E-02_JPRB,6.1023E-02_JPRB,5.7678E-02_JPRB,5.4658E-02_JPRB,5.1906E-02_JPRB,5.0202E-02_JPRB,&
&5.0477E-02_JPRB,5.0911E-02_JPRB,1.1702E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&8.3713E-02_JPRB,7.7246E-02_JPRB,7.4186E-02_JPRB,7.1956E-02_JPRB,6.9311E-02_JPRB,6.8138E-02_JPRB,&
&6.9472E-02_JPRB,7.1080E-02_JPRB,1.1427E+00_JPRB/)
KAO( :, 1, 1,14) = (/&
&8.4406E-02_JPRB,7.3923E-02_JPRB,6.3390E-02_JPRB,5.3666E-02_JPRB,5.2956E-02_JPRB,5.5472E-02_JPRB,&
&6.0634E-02_JPRB,5.8813E-02_JPRB,9.2877E-02_JPRB/)
KAO( :, 2, 1,14) = (/&
&9.8373E-02_JPRB,8.6109E-02_JPRB,7.3836E-02_JPRB,6.7549E-02_JPRB,6.9431E-02_JPRB,7.7739E-02_JPRB,&
&8.6438E-02_JPRB,8.5388E-02_JPRB,1.3005E-01_JPRB/)
KAO( :, 3, 1,14) = (/&
&1.1220E-01_JPRB,9.8227E-02_JPRB,8.4237E-02_JPRB,8.6127E-02_JPRB,9.3558E-02_JPRB,1.1007E-01_JPRB,&
&1.2298E-01_JPRB,1.2120E-01_JPRB,1.8519E-01_JPRB/)
KAO( :, 4, 1,14) = (/&
&1.2589E-01_JPRB,1.1021E-01_JPRB,9.7341E-02_JPRB,1.0805E-01_JPRB,1.2702E-01_JPRB,1.5181E-01_JPRB,&
&1.6898E-01_JPRB,1.6664E-01_JPRB,2.5570E-01_JPRB/)
KAO( :, 5, 1,14) = (/&
&1.3898E-01_JPRB,1.2167E-01_JPRB,1.1790E-01_JPRB,1.3538E-01_JPRB,1.6936E-01_JPRB,2.0147E-01_JPRB,&
&2.2468E-01_JPRB,2.1901E-01_JPRB,3.4200E-01_JPRB/)
KAO( :, 1, 2,14) = (/&
&8.6965E-02_JPRB,7.6122E-02_JPRB,6.5271E-02_JPRB,5.5929E-02_JPRB,5.5266E-02_JPRB,5.6412E-02_JPRB,&
&6.1162E-02_JPRB,5.9084E-02_JPRB,9.4145E-02_JPRB/)
KAO( :, 2, 2,14) = (/&
&1.0214E-01_JPRB,8.9404E-02_JPRB,7.6670E-02_JPRB,7.1026E-02_JPRB,7.1152E-02_JPRB,7.6438E-02_JPRB,&
&8.4319E-02_JPRB,8.3198E-02_JPRB,1.2897E-01_JPRB/)
KAO( :, 3, 2,14) = (/&
&1.1758E-01_JPRB,1.0294E-01_JPRB,8.8300E-02_JPRB,9.0301E-02_JPRB,9.3552E-02_JPRB,1.0592E-01_JPRB,&
&1.1887E-01_JPRB,1.2017E-01_JPRB,1.7974E-01_JPRB/)
KAO( :, 4, 2,14) = (/&
&1.3321E-01_JPRB,1.1665E-01_JPRB,1.0423E-01_JPRB,1.1370E-01_JPRB,1.2505E-01_JPRB,1.4860E-01_JPRB,&
&1.6715E-01_JPRB,1.6784E-01_JPRB,2.5046E-01_JPRB/)
KAO( :, 5, 2,14) = (/&
&1.4865E-01_JPRB,1.3020E-01_JPRB,1.2666E-01_JPRB,1.3953E-01_JPRB,1.6682E-01_JPRB,2.0058E-01_JPRB,&
&2.2553E-01_JPRB,2.2565E-01_JPRB,3.3899E-01_JPRB/)
KAO( :, 1, 3,14) = (/&
&8.6079E-02_JPRB,7.5340E-02_JPRB,6.4607E-02_JPRB,5.5456E-02_JPRB,5.5272E-02_JPRB,5.5233E-02_JPRB,&
&5.8267E-02_JPRB,5.6783E-02_JPRB,8.9464E-02_JPRB/)
KAO( :, 2, 3,14) = (/&
&1.0304E-01_JPRB,9.0205E-02_JPRB,7.7348E-02_JPRB,7.0519E-02_JPRB,7.0862E-02_JPRB,7.2390E-02_JPRB,&
&7.8791E-02_JPRB,7.7229E-02_JPRB,1.2132E-01_JPRB/)
KAO( :, 3, 3,14) = (/&
&1.2050E-01_JPRB,1.0550E-01_JPRB,9.0628E-02_JPRB,8.9686E-02_JPRB,9.0578E-02_JPRB,9.7251E-02_JPRB,&
&1.0832E-01_JPRB,1.0857E-01_JPRB,1.6570E-01_JPRB/)
KAO( :, 4, 3,14) = (/&
&1.3798E-01_JPRB,1.2081E-01_JPRB,1.0757E-01_JPRB,1.1366E-01_JPRB,1.1771E-01_JPRB,1.3404E-01_JPRB,&
&1.5114E-01_JPRB,1.5446E-01_JPRB,2.2779E-01_JPRB/)
KAO( :, 5, 3,14) = (/&
&1.5527E-01_JPRB,1.3594E-01_JPRB,1.3049E-01_JPRB,1.4065E-01_JPRB,1.5498E-01_JPRB,1.8347E-01_JPRB,&
&2.0928E-01_JPRB,2.1357E-01_JPRB,3.1056E-01_JPRB/)
KAO( :, 1, 4,14) = (/&
&8.3658E-02_JPRB,7.3219E-02_JPRB,6.2782E-02_JPRB,5.4421E-02_JPRB,5.4252E-02_JPRB,5.2373E-02_JPRB,&
&5.2872E-02_JPRB,5.3249E-02_JPRB,8.1760E-02_JPRB/)
KAO( :, 2, 4,14) = (/&
&1.0179E-01_JPRB,8.9084E-02_JPRB,7.6372E-02_JPRB,6.9322E-02_JPRB,6.9646E-02_JPRB,6.9291E-02_JPRB,&
&7.2799E-02_JPRB,7.2370E-02_JPRB,1.1302E-01_JPRB/)
KAO( :, 3, 4,14) = (/&
&1.2055E-01_JPRB,1.0553E-01_JPRB,9.0925E-02_JPRB,8.8158E-02_JPRB,8.8997E-02_JPRB,9.0835E-02_JPRB,&
&9.8776E-02_JPRB,9.8752E-02_JPRB,1.5269E-01_JPRB/)
KAO( :, 4, 4,14) = (/&
&1.3976E-01_JPRB,1.2239E-01_JPRB,1.0872E-01_JPRB,1.1120E-01_JPRB,1.1304E-01_JPRB,1.2136E-01_JPRB,&
&1.3545E-01_JPRB,1.3720E-01_JPRB,2.0650E-01_JPRB/)
KAO( :, 5, 4,14) = (/&
&1.5964E-01_JPRB,1.3984E-01_JPRB,1.3154E-01_JPRB,1.3870E-01_JPRB,1.4428E-01_JPRB,1.6405E-01_JPRB,&
&1.8578E-01_JPRB,1.9371E-01_JPRB,2.7910E-01_JPRB/)
KAO( :, 1, 5,14) = (/&
&7.9613E-02_JPRB,6.9667E-02_JPRB,5.9735E-02_JPRB,5.2890E-02_JPRB,5.1672E-02_JPRB,4.9631E-02_JPRB,&
&4.7983E-02_JPRB,4.7891E-02_JPRB,7.3721E-02_JPRB/)
KAO( :, 2, 5,14) = (/&
&9.8444E-02_JPRB,8.6165E-02_JPRB,7.3879E-02_JPRB,6.8004E-02_JPRB,6.7906E-02_JPRB,6.5760E-02_JPRB,&
&6.6820E-02_JPRB,6.7095E-02_JPRB,1.0263E-01_JPRB/)
KAO( :, 3, 5,14) = (/&
&1.1874E-01_JPRB,1.0393E-01_JPRB,8.9653E-02_JPRB,8.6769E-02_JPRB,8.7048E-02_JPRB,8.6781E-02_JPRB,&
&9.1705E-02_JPRB,9.1503E-02_JPRB,1.4159E-01_JPRB/)
KAO( :, 4, 5,14) = (/&
&1.4009E-01_JPRB,1.2266E-01_JPRB,1.0834E-01_JPRB,1.0954E-01_JPRB,1.1083E-01_JPRB,1.1372E-01_JPRB,&
&1.2361E-01_JPRB,1.2496E-01_JPRB,1.9192E-01_JPRB/)
KAO( :, 5, 5,14) = (/&
&1.6191E-01_JPRB,1.4179E-01_JPRB,1.3132E-01_JPRB,1.3664E-01_JPRB,1.3962E-01_JPRB,1.5009E-01_JPRB,&
&1.6802E-01_JPRB,1.7246E-01_JPRB,2.5602E-01_JPRB/)
KAO( :, 1, 6,14) = (/&
&7.3321E-02_JPRB,6.4173E-02_JPRB,5.5115E-02_JPRB,5.0047E-02_JPRB,4.8003E-02_JPRB,4.5729E-02_JPRB,&
&4.3413E-02_JPRB,4.2157E-02_JPRB,6.5110E-02_JPRB/)
KAO( :, 2, 6,14) = (/&
&9.2952E-02_JPRB,8.1355E-02_JPRB,6.9976E-02_JPRB,6.5257E-02_JPRB,6.4561E-02_JPRB,6.2014E-02_JPRB,&
&6.0594E-02_JPRB,6.0655E-02_JPRB,9.1731E-02_JPRB/)
KAO( :, 3, 6,14) = (/&
&1.1439E-01_JPRB,1.0014E-01_JPRB,8.6575E-02_JPRB,8.3912E-02_JPRB,8.3786E-02_JPRB,8.2279E-02_JPRB,&
&8.3550E-02_JPRB,8.4201E-02_JPRB,1.2740E-01_JPRB/)
KAO( :, 4, 6,14) = (/&
&1.3703E-01_JPRB,1.1997E-01_JPRB,1.0601E-01_JPRB,1.0652E-01_JPRB,1.0715E-01_JPRB,1.0792E-01_JPRB,&
&1.1407E-01_JPRB,1.1447E-01_JPRB,1.7570E-01_JPRB/)
KAO( :, 5, 6,14) = (/&
&1.6047E-01_JPRB,1.4048E-01_JPRB,1.2948E-01_JPRB,1.3382E-01_JPRB,1.3571E-01_JPRB,1.4072E-01_JPRB,&
&1.5346E-01_JPRB,1.5557E-01_JPRB,2.3674E-01_JPRB/)
KAO( :, 1, 7,14) = (/&
&6.6096E-02_JPRB,5.7840E-02_JPRB,5.0291E-02_JPRB,4.6255E-02_JPRB,4.3749E-02_JPRB,4.1346E-02_JPRB,&
&3.9237E-02_JPRB,3.7187E-02_JPRB,5.6581E-02_JPRB/)
KAO( :, 2, 7,14) = (/&
&8.5997E-02_JPRB,7.5272E-02_JPRB,6.5564E-02_JPRB,6.1464E-02_JPRB,6.0084E-02_JPRB,5.7566E-02_JPRB,&
&5.5305E-02_JPRB,5.4415E-02_JPRB,8.1052E-02_JPRB/)
KAO( :, 3, 7,14) = (/&
&1.0792E-01_JPRB,9.4463E-02_JPRB,8.2746E-02_JPRB,8.0231E-02_JPRB,7.9656E-02_JPRB,7.7519E-02_JPRB,&
&7.6243E-02_JPRB,7.6636E-02_JPRB,1.1376E-01_JPRB/)
KAO( :, 4, 7,14) = (/&
&1.3147E-01_JPRB,1.1508E-01_JPRB,1.0289E-01_JPRB,1.0281E-01_JPRB,1.0321E-01_JPRB,1.0267E-01_JPRB,&
&1.0428E-01_JPRB,1.0618E-01_JPRB,1.5831E-01_JPRB/)
KAO( :, 5, 7,14) = (/&
&1.5658E-01_JPRB,1.3709E-01_JPRB,1.2648E-01_JPRB,1.2964E-01_JPRB,1.3186E-01_JPRB,1.3458E-01_JPRB,&
&1.4246E-01_JPRB,1.4352E-01_JPRB,2.1656E-01_JPRB/)
KAO( :, 1, 8,14) = (/&
&5.8400E-02_JPRB,5.1103E-02_JPRB,4.5168E-02_JPRB,4.1948E-02_JPRB,3.9253E-02_JPRB,3.7020E-02_JPRB,&
&3.5370E-02_JPRB,3.2290E-02_JPRB,4.8663E-02_JPRB/)
KAO( :, 2, 8,14) = (/&
&7.8005E-02_JPRB,6.8268E-02_JPRB,6.0453E-02_JPRB,5.7096E-02_JPRB,5.4905E-02_JPRB,5.3117E-02_JPRB,&
&5.0732E-02_JPRB,4.8891E-02_JPRB,7.1101E-02_JPRB/)
KAO( :, 3, 8,14) = (/&
&9.9991E-02_JPRB,8.7516E-02_JPRB,7.8019E-02_JPRB,7.5868E-02_JPRB,7.4621E-02_JPRB,7.2463E-02_JPRB,&
&7.0304E-02_JPRB,6.9569E-02_JPRB,1.0104E-01_JPRB/)
KAO( :, 4, 8,14) = (/&
&1.2410E-01_JPRB,1.0864E-01_JPRB,9.8489E-02_JPRB,9.8564E-02_JPRB,9.8094E-02_JPRB,9.6833E-02_JPRB,&
&9.6022E-02_JPRB,9.6830E-02_JPRB,1.4193E-01_JPRB/)
KAO( :, 5, 8,14) = (/&
&1.4968E-01_JPRB,1.3103E-01_JPRB,1.2227E-01_JPRB,1.2491E-01_JPRB,1.2710E-01_JPRB,1.2811E-01_JPRB,&
&1.3093E-01_JPRB,1.3351E-01_JPRB,1.9610E-01_JPRB/)
KAO( :, 1, 9,14) = (/&
&5.0397E-02_JPRB,4.4093E-02_JPRB,3.9683E-02_JPRB,3.6946E-02_JPRB,3.4574E-02_JPRB,3.2784E-02_JPRB,&
&3.1190E-02_JPRB,2.7785E-02_JPRB,4.2938E-02_JPRB/)
KAO( :, 2, 9,14) = (/&
&6.9192E-02_JPRB,6.0558E-02_JPRB,5.4594E-02_JPRB,5.1616E-02_JPRB,4.9513E-02_JPRB,4.8432E-02_JPRB,&
&4.6308E-02_JPRB,4.3232E-02_JPRB,6.1150E-02_JPRB/)
KAO( :, 3, 9,14) = (/&
&9.0684E-02_JPRB,7.9364E-02_JPRB,7.1928E-02_JPRB,7.0062E-02_JPRB,6.8840E-02_JPRB,6.7293E-02_JPRB,&
&6.5005E-02_JPRB,6.2608E-02_JPRB,8.8443E-02_JPRB/)
KAO( :, 4, 9,14) = (/&
&1.1460E-01_JPRB,1.0028E-01_JPRB,9.2569E-02_JPRB,9.2695E-02_JPRB,9.1960E-02_JPRB,9.0808E-02_JPRB,&
&8.8903E-02_JPRB,8.7875E-02_JPRB,1.2618E-01_JPRB/)
KAO( :, 5, 9,14) = (/&
&1.4029E-01_JPRB,1.2278E-01_JPRB,1.1658E-01_JPRB,1.1927E-01_JPRB,1.2033E-01_JPRB,1.2086E-01_JPRB,&
&1.2101E-01_JPRB,1.2214E-01_JPRB,1.7683E-01_JPRB/)
KAO( :, 1,10,14) = (/&
&4.3717E-02_JPRB,3.8278E-02_JPRB,3.5080E-02_JPRB,3.2701E-02_JPRB,3.0716E-02_JPRB,2.9342E-02_JPRB,&
&2.7684E-02_JPRB,2.4470E-02_JPRB,2.2009E-01_JPRB/)
KAO( :, 2,10,14) = (/&
&6.1476E-02_JPRB,5.3866E-02_JPRB,4.9319E-02_JPRB,4.6960E-02_JPRB,4.5259E-02_JPRB,4.4478E-02_JPRB,&
&4.2577E-02_JPRB,3.9251E-02_JPRB,2.1963E-01_JPRB/)
KAO( :, 3,10,14) = (/&
&8.2385E-02_JPRB,7.2234E-02_JPRB,6.6445E-02_JPRB,6.4962E-02_JPRB,6.4371E-02_JPRB,6.3180E-02_JPRB,&
&6.0931E-02_JPRB,5.7438E-02_JPRB,2.2242E-01_JPRB/)
KAO( :, 4,10,14) = (/&
&1.0599E-01_JPRB,9.3000E-02_JPRB,8.7065E-02_JPRB,8.7339E-02_JPRB,8.7286E-02_JPRB,8.6396E-02_JPRB,&
&8.4334E-02_JPRB,8.1297E-02_JPRB,2.2730E-01_JPRB/)
KAO( :, 5,10,14) = (/&
&1.3194E-01_JPRB,1.1580E-01_JPRB,1.1124E-01_JPRB,1.1411E-01_JPRB,1.1533E-01_JPRB,1.1612E-01_JPRB,&
&1.1515E-01_JPRB,1.1414E-01_JPRB,2.3906E-01_JPRB/)
KAO( :, 1,11,14) = (/&
&4.4414E-02_JPRB,3.9124E-02_JPRB,3.6276E-02_JPRB,3.4192E-02_JPRB,3.2709E-02_JPRB,3.1757E-02_JPRB,&
&3.0272E-02_JPRB,2.7274E-02_JPRB,6.0923E-01_JPRB/)
KAO( :, 2,11,14) = (/&
&6.2792E-02_JPRB,5.5349E-02_JPRB,5.1175E-02_JPRB,4.9442E-02_JPRB,4.8780E-02_JPRB,4.8068E-02_JPRB,&
&4.6106E-02_JPRB,4.2789E-02_JPRB,6.0862E-01_JPRB/)
KAO( :, 3,11,14) = (/&
&8.4498E-02_JPRB,7.4522E-02_JPRB,6.9553E-02_JPRB,6.8963E-02_JPRB,6.9106E-02_JPRB,6.8253E-02_JPRB,&
&6.6044E-02_JPRB,6.2338E-02_JPRB,6.0545E-01_JPRB/)
KAO( :, 4,11,14) = (/&
&1.0929E-01_JPRB,9.6406E-02_JPRB,9.1543E-02_JPRB,9.3189E-02_JPRB,9.3647E-02_JPRB,9.3574E-02_JPRB,&
&9.1735E-02_JPRB,8.8253E-02_JPRB,5.9922E-01_JPRB/)
KAO( :, 5,11,14) = (/&
&1.3686E-01_JPRB,1.2067E-01_JPRB,1.1766E-01_JPRB,1.2167E-01_JPRB,1.2456E-01_JPRB,1.2652E-01_JPRB,&
&1.2561E-01_JPRB,1.2397E-01_JPRB,5.9856E-01_JPRB/)
KAO( :, 1,12,14) = (/&
&4.5286E-02_JPRB,4.0194E-02_JPRB,3.7498E-02_JPRB,3.5426E-02_JPRB,3.4720E-02_JPRB,3.4064E-02_JPRB,&
&3.2556E-02_JPRB,2.9605E-02_JPRB,1.0899E+00_JPRB/)
KAO( :, 2,12,14) = (/&
&6.4484E-02_JPRB,5.7256E-02_JPRB,5.3321E-02_JPRB,5.1760E-02_JPRB,5.1954E-02_JPRB,5.1386E-02_JPRB,&
&4.9166E-02_JPRB,4.5588E-02_JPRB,1.0909E+00_JPRB/)
KAO( :, 3,12,14) = (/&
&8.7239E-02_JPRB,7.7409E-02_JPRB,7.3021E-02_JPRB,7.2641E-02_JPRB,7.3363E-02_JPRB,7.2923E-02_JPRB,&
&7.0510E-02_JPRB,6.6538E-02_JPRB,1.0837E+00_JPRB/)
KAO( :, 4,12,14) = (/&
&1.1325E-01_JPRB,1.0044E-01_JPRB,9.6532E-02_JPRB,9.7960E-02_JPRB,9.9715E-02_JPRB,1.0061E-01_JPRB,&
&9.8953E-02_JPRB,9.5070E-02_JPRB,1.0714E+00_JPRB/)
KAO( :, 5,12,14) = (/&
&1.4215E-01_JPRB,1.2620E-01_JPRB,1.2476E-01_JPRB,1.2858E-01_JPRB,1.3345E-01_JPRB,1.3645E-01_JPRB,&
&1.3637E-01_JPRB,1.3374E-01_JPRB,1.0563E+00_JPRB/)
KAO( :, 1,13,14) = (/&
&4.6570E-02_JPRB,4.1678E-02_JPRB,3.8725E-02_JPRB,3.6717E-02_JPRB,3.6394E-02_JPRB,3.5946E-02_JPRB,&
&3.4376E-02_JPRB,3.1454E-02_JPRB,1.5895E+00_JPRB/)
KAO( :, 2,13,14) = (/&
&6.6498E-02_JPRB,5.9462E-02_JPRB,5.5660E-02_JPRB,5.4101E-02_JPRB,5.4467E-02_JPRB,5.3788E-02_JPRB,&
&5.1648E-02_JPRB,4.8046E-02_JPRB,1.5849E+00_JPRB/)
KAO( :, 3,13,14) = (/&
&9.0364E-02_JPRB,8.0700E-02_JPRB,7.6577E-02_JPRB,7.6135E-02_JPRB,7.6849E-02_JPRB,7.6753E-02_JPRB,&
&7.4630E-02_JPRB,7.0420E-02_JPRB,1.5698E+00_JPRB/)
KAO( :, 4,13,14) = (/&
&1.1790E-01_JPRB,1.0519E-01_JPRB,1.0195E-01_JPRB,1.0248E-01_JPRB,1.0532E-01_JPRB,1.0714E-01_JPRB,&
&1.0603E-01_JPRB,1.0171E-01_JPRB,1.5492E+00_JPRB/)
KAO( :, 5,13,14) = (/&
&1.4874E-01_JPRB,1.3321E-01_JPRB,1.3189E-01_JPRB,1.3520E-01_JPRB,1.4175E-01_JPRB,1.4629E-01_JPRB,&
&1.4735E-01_JPRB,1.4395E-01_JPRB,1.5228E+00_JPRB/)
KAO( :, 1, 1,15) = (/&
&1.1131E-01_JPRB,9.7434E-02_JPRB,8.3539E-02_JPRB,6.9673E-02_JPRB,6.4542E-02_JPRB,7.4907E-02_JPRB,&
&8.0610E-02_JPRB,7.4592E-02_JPRB,1.2983E-01_JPRB/)
KAO( :, 2, 1,15) = (/&
&1.2948E-01_JPRB,1.1334E-01_JPRB,9.7201E-02_JPRB,8.1647E-02_JPRB,9.0214E-02_JPRB,1.0535E-01_JPRB,&
&1.1308E-01_JPRB,1.0399E-01_JPRB,1.8473E-01_JPRB/)
KAO( :, 3, 1,15) = (/&
&1.4765E-01_JPRB,1.2925E-01_JPRB,1.1103E-01_JPRB,1.0059E-01_JPRB,1.2467E-01_JPRB,1.4566E-01_JPRB,&
&1.5615E-01_JPRB,1.4358E-01_JPRB,2.5548E-01_JPRB/)
KAO( :, 4, 1,15) = (/&
&1.6551E-01_JPRB,1.4490E-01_JPRB,1.2421E-01_JPRB,1.3376E-01_JPRB,1.6988E-01_JPRB,1.9836E-01_JPRB,&
&2.1296E-01_JPRB,1.9754E-01_JPRB,3.4830E-01_JPRB/)
KAO( :, 5, 1,15) = (/&
&1.8295E-01_JPRB,1.6015E-01_JPRB,1.4430E-01_JPRB,1.8250E-01_JPRB,2.3252E-01_JPRB,2.7304E-01_JPRB,&
&2.9658E-01_JPRB,2.7983E-01_JPRB,4.7759E-01_JPRB/)
KAO( :, 1, 2,15) = (/&
&1.2229E-01_JPRB,1.0698E-01_JPRB,9.1752E-02_JPRB,7.6480E-02_JPRB,6.8179E-02_JPRB,7.6324E-02_JPRB,&
&8.2595E-02_JPRB,7.6957E-02_JPRB,1.3490E-01_JPRB/)
KAO( :, 2, 2,15) = (/&
&1.4324E-01_JPRB,1.2538E-01_JPRB,1.0747E-01_JPRB,9.0191E-02_JPRB,9.3013E-02_JPRB,1.0900E-01_JPRB,&
&1.1749E-01_JPRB,1.0918E-01_JPRB,1.9459E-01_JPRB/)
KAO( :, 3, 2,15) = (/&
&1.6466E-01_JPRB,1.4413E-01_JPRB,1.2359E-01_JPRB,1.1001E-01_JPRB,1.3054E-01_JPRB,1.5305E-01_JPRB,&
&1.6497E-01_JPRB,1.5263E-01_JPRB,2.7373E-01_JPRB/)
KAO( :, 4, 2,15) = (/&
&1.8622E-01_JPRB,1.6296E-01_JPRB,1.3975E-01_JPRB,1.4019E-01_JPRB,1.7799E-01_JPRB,2.0816E-01_JPRB,&
&2.2421E-01_JPRB,2.0784E-01_JPRB,3.7366E-01_JPRB/)
KAO( :, 5, 2,15) = (/&
&2.0755E-01_JPRB,1.8167E-01_JPRB,1.5934E-01_JPRB,1.9033E-01_JPRB,2.4247E-01_JPRB,2.8472E-01_JPRB,&
&3.0675E-01_JPRB,2.8798E-01_JPRB,5.0930E-01_JPRB/)
KAO( :, 1, 3,15) = (/&
&1.2835E-01_JPRB,1.1233E-01_JPRB,9.6332E-02_JPRB,8.0294E-02_JPRB,6.8892E-02_JPRB,7.2388E-02_JPRB,&
&7.7841E-02_JPRB,7.2996E-02_JPRB,1.3009E-01_JPRB/)
KAO( :, 2, 3,15) = (/&
&1.5296E-01_JPRB,1.3385E-01_JPRB,1.1480E-01_JPRB,9.5678E-02_JPRB,9.1260E-02_JPRB,1.0384E-01_JPRB,&
&1.1265E-01_JPRB,1.0600E-01_JPRB,1.8774E-01_JPRB/)
KAO( :, 3, 3,15) = (/&
&1.7841E-01_JPRB,1.5614E-01_JPRB,1.3387E-01_JPRB,1.1551E-01_JPRB,1.2609E-01_JPRB,1.4839E-01_JPRB,&
&1.6074E-01_JPRB,1.4978E-01_JPRB,2.6916E-01_JPRB/)
KAO( :, 4, 3,15) = (/&
&2.0421E-01_JPRB,1.7872E-01_JPRB,1.5328E-01_JPRB,1.4514E-01_JPRB,1.7532E-01_JPRB,2.0570E-01_JPRB,&
&2.2217E-01_JPRB,2.0725E-01_JPRB,3.7502E-01_JPRB/)
KAO( :, 5, 3,15) = (/&
&2.2993E-01_JPRB,2.0124E-01_JPRB,1.7291E-01_JPRB,1.8782E-01_JPRB,2.3935E-01_JPRB,2.8099E-01_JPRB,&
&3.0349E-01_JPRB,2.8229E-01_JPRB,5.1274E-01_JPRB/)
KAO( :, 1, 4,15) = (/&
&1.3220E-01_JPRB,1.1572E-01_JPRB,9.9179E-02_JPRB,8.2676E-02_JPRB,6.8587E-02_JPRB,6.9929E-02_JPRB,&
&7.4555E-02_JPRB,6.8313E-02_JPRB,1.2618E-01_JPRB/)
KAO( :, 2, 4,15) = (/&
&1.6060E-01_JPRB,1.4053E-01_JPRB,1.2046E-01_JPRB,1.0042E-01_JPRB,9.1232E-02_JPRB,9.6578E-02_JPRB,&
&1.0443E-01_JPRB,9.9068E-02_JPRB,1.7466E-01_JPRB/)
KAO( :, 3, 4,15) = (/&
&1.9027E-01_JPRB,1.6651E-01_JPRB,1.4275E-01_JPRB,1.1998E-01_JPRB,1.2056E-01_JPRB,1.3873E-01_JPRB,&
&1.5129E-01_JPRB,1.4272E-01_JPRB,2.5148E-01_JPRB/)
KAO( :, 4, 4,15) = (/&
&2.2066E-01_JPRB,1.9311E-01_JPRB,1.6558E-01_JPRB,1.4877E-01_JPRB,1.6676E-01_JPRB,1.9681E-01_JPRB,&
&2.1452E-01_JPRB,2.0223E-01_JPRB,3.5884E-01_JPRB/)
KAO( :, 5, 4,15) = (/&
&2.5122E-01_JPRB,2.1983E-01_JPRB,1.8845E-01_JPRB,1.8829E-01_JPRB,2.3159E-01_JPRB,2.7258E-01_JPRB,&
&2.9545E-01_JPRB,2.7646E-01_JPRB,4.9974E-01_JPRB/)
KAO( :, 1, 5,15) = (/&
&1.3465E-01_JPRB,1.1783E-01_JPRB,1.0104E-01_JPRB,8.4191E-02_JPRB,7.0181E-02_JPRB,6.7764E-02_JPRB,&
&7.2349E-02_JPRB,6.6738E-02_JPRB,1.2182E-01_JPRB/)
KAO( :, 2, 5,15) = (/&
&1.6678E-01_JPRB,1.4597E-01_JPRB,1.2512E-01_JPRB,1.0428E-01_JPRB,9.0356E-02_JPRB,9.3548E-02_JPRB,&
&1.0047E-01_JPRB,9.3395E-02_JPRB,1.6838E-01_JPRB/)
KAO( :, 3, 5,15) = (/&
&2.0080E-01_JPRB,1.7573E-01_JPRB,1.5067E-01_JPRB,1.2564E-01_JPRB,1.1939E-01_JPRB,1.2897E-01_JPRB,&
&1.4021E-01_JPRB,1.3389E-01_JPRB,2.3367E-01_JPRB/)
KAO( :, 4, 5,15) = (/&
&2.3601E-01_JPRB,2.0651E-01_JPRB,1.7705E-01_JPRB,1.5299E-01_JPRB,1.5971E-01_JPRB,1.8409E-01_JPRB,&
&2.0223E-01_JPRB,1.9297E-01_JPRB,3.3364E-01_JPRB/)
KAO( :, 5, 5,15) = (/&
&2.7164E-01_JPRB,2.3767E-01_JPRB,2.0377E-01_JPRB,1.9351E-01_JPRB,2.2099E-01_JPRB,2.6145E-01_JPRB,&
&2.8569E-01_JPRB,2.7068E-01_JPRB,4.7598E-01_JPRB/)
KAO( :, 1, 6,15) = (/&
&1.3406E-01_JPRB,1.1731E-01_JPRB,1.0056E-01_JPRB,8.3806E-02_JPRB,7.0762E-02_JPRB,6.6238E-02_JPRB,&
&6.8971E-02_JPRB,6.4722E-02_JPRB,1.1369E-01_JPRB/)
KAO( :, 2, 6,15) = (/&
&1.6963E-01_JPRB,1.4845E-01_JPRB,1.2729E-01_JPRB,1.0606E-01_JPRB,9.0231E-02_JPRB,9.0723E-02_JPRB,&
&9.7199E-02_JPRB,9.0437E-02_JPRB,1.6138E-01_JPRB/)
KAO( :, 3, 6,15) = (/&
&2.0786E-01_JPRB,1.8191E-01_JPRB,1.5592E-01_JPRB,1.2995E-01_JPRB,1.1861E-01_JPRB,1.2279E-01_JPRB,&
&1.3287E-01_JPRB,1.2524E-01_JPRB,2.2069E-01_JPRB/)
KAO( :, 4, 6,15) = (/&
&2.4779E-01_JPRB,2.1681E-01_JPRB,1.8585E-01_JPRB,1.5823E-01_JPRB,1.5558E-01_JPRB,1.7012E-01_JPRB,&
&1.8594E-01_JPRB,1.7956E-01_JPRB,3.0607E-01_JPRB/)
KAO( :, 5, 6,15) = (/&
&2.8850E-01_JPRB,2.5250E-01_JPRB,2.1644E-01_JPRB,1.9593E-01_JPRB,2.0861E-01_JPRB,2.4203E-01_JPRB,&
&2.6660E-01_JPRB,2.5670E-01_JPRB,4.3563E-01_JPRB/)
KAO( :, 1, 7,15) = (/&
&1.3101E-01_JPRB,1.1464E-01_JPRB,9.8272E-02_JPRB,8.1907E-02_JPRB,7.0350E-02_JPRB,6.5243E-02_JPRB,&
&6.4994E-02_JPRB,6.2397E-02_JPRB,1.0427E-01_JPRB/)
KAO( :, 2, 7,15) = (/&
&1.6960E-01_JPRB,1.4841E-01_JPRB,1.2720E-01_JPRB,1.0602E-01_JPRB,9.1007E-02_JPRB,8.8046E-02_JPRB,&
&9.1985E-02_JPRB,8.6734E-02_JPRB,1.5008E-01_JPRB/)
KAO( :, 3, 7,15) = (/&
&2.1159E-01_JPRB,1.8512E-01_JPRB,1.5869E-01_JPRB,1.3227E-01_JPRB,1.1799E-01_JPRB,1.2016E-01_JPRB,&
&1.2848E-01_JPRB,1.2123E-01_JPRB,2.0928E-01_JPRB/)
KAO( :, 4, 7,15) = (/&
&2.5591E-01_JPRB,2.2393E-01_JPRB,1.9196E-01_JPRB,1.6246E-01_JPRB,1.5474E-01_JPRB,1.6150E-01_JPRB,&
&1.7579E-01_JPRB,1.6710E-01_JPRB,2.8812E-01_JPRB/)
KAO( :, 5, 7,15) = (/&
&3.0213E-01_JPRB,2.6429E-01_JPRB,2.2656E-01_JPRB,2.0075E-01_JPRB,2.0206E-01_JPRB,2.2299E-01_JPRB,&
&2.4482E-01_JPRB,2.3852E-01_JPRB,4.0014E-01_JPRB/)
KAO( :, 1, 8,15) = (/&
&1.2571E-01_JPRB,1.1002E-01_JPRB,9.4301E-02_JPRB,7.8660E-02_JPRB,6.9028E-02_JPRB,6.3512E-02_JPRB,&
&6.0386E-02_JPRB,5.9283E-02_JPRB,9.4594E-02_JPRB/)
KAO( :, 2, 8,15) = (/&
&1.6658E-01_JPRB,1.4578E-01_JPRB,1.2499E-01_JPRB,1.0438E-01_JPRB,9.1618E-02_JPRB,8.5835E-02_JPRB,&
&8.6312E-02_JPRB,8.2954E-02_JPRB,1.3781E-01_JPRB/)
KAO( :, 3, 8,15) = (/&
&2.1185E-01_JPRB,1.8540E-01_JPRB,1.5894E-01_JPRB,1.3292E-01_JPRB,1.1859E-01_JPRB,1.1793E-01_JPRB,&
&1.2293E-01_JPRB,1.1767E-01_JPRB,1.9732E-01_JPRB/)
KAO( :, 4, 8,15) = (/&
&2.6124E-01_JPRB,2.2860E-01_JPRB,1.9595E-01_JPRB,1.6484E-01_JPRB,1.5535E-01_JPRB,1.5770E-01_JPRB,&
&1.6881E-01_JPRB,1.6159E-01_JPRB,2.7186E-01_JPRB/)
KAO( :, 5, 8,15) = (/&
&3.1377E-01_JPRB,2.7455E-01_JPRB,2.3536E-01_JPRB,2.0526E-01_JPRB,2.0139E-01_JPRB,2.1210E-01_JPRB,&
&2.3209E-01_JPRB,2.2418E-01_JPRB,3.7448E-01_JPRB/)
KAO( :, 1, 9,15) = (/&
&1.1779E-01_JPRB,1.0307E-01_JPRB,8.8332E-02_JPRB,7.4504E-02_JPRB,6.6446E-02_JPRB,6.0468E-02_JPRB,&
&5.6136E-02_JPRB,5.4947E-02_JPRB,8.6169E-02_JPRB/)
KAO( :, 2, 9,15) = (/&
&1.6035E-01_JPRB,1.4031E-01_JPRB,1.2024E-01_JPRB,1.0163E-01_JPRB,9.0617E-02_JPRB,8.2714E-02_JPRB,&
&7.9922E-02_JPRB,7.8110E-02_JPRB,1.2654E-01_JPRB/)
KAO( :, 3, 9,15) = (/&
&2.0927E-01_JPRB,1.8312E-01_JPRB,1.5698E-01_JPRB,1.3222E-01_JPRB,1.1873E-01_JPRB,1.1424E-01_JPRB,&
&1.1454E-01_JPRB,1.1174E-01_JPRB,1.8302E-01_JPRB/)
KAO( :, 4, 9,15) = (/&
&2.6349E-01_JPRB,2.3054E-01_JPRB,1.9763E-01_JPRB,1.6626E-01_JPRB,1.5598E-01_JPRB,1.5598E-01_JPRB,&
&1.6166E-01_JPRB,1.5736E-01_JPRB,2.5852E-01_JPRB/)
KAO( :, 5, 9,15) = (/&
&3.2165E-01_JPRB,2.8148E-01_JPRB,2.4130E-01_JPRB,2.0798E-01_JPRB,2.0349E-01_JPRB,2.0671E-01_JPRB,&
&2.2142E-01_JPRB,2.1528E-01_JPRB,3.5292E-01_JPRB/)
KAO( :, 1,10,15) = (/&
&1.1095E-01_JPRB,9.7087E-02_JPRB,8.3232E-02_JPRB,7.1375E-02_JPRB,6.4431E-02_JPRB,5.8222E-02_JPRB,&
&5.3438E-02_JPRB,5.1856E-02_JPRB,2.8234E-01_JPRB/)
KAO( :, 2,10,15) = (/&
&1.5568E-01_JPRB,1.3623E-01_JPRB,1.1675E-01_JPRB,9.9778E-02_JPRB,9.0053E-02_JPRB,8.1186E-02_JPRB,&
&7.6199E-02_JPRB,7.4185E-02_JPRB,2.7084E-01_JPRB/)
KAO( :, 3,10,15) = (/&
&2.0787E-01_JPRB,1.8189E-01_JPRB,1.5590E-01_JPRB,1.3290E-01_JPRB,1.2001E-01_JPRB,1.1270E-01_JPRB,&
&1.0975E-01_JPRB,1.0759E-01_JPRB,2.7158E-01_JPRB/)
KAO( :, 4,10,15) = (/&
&2.6636E-01_JPRB,2.3306E-01_JPRB,1.9979E-01_JPRB,1.7021E-01_JPRB,1.5900E-01_JPRB,1.5510E-01_JPRB,&
&1.5611E-01_JPRB,1.5403E-01_JPRB,2.9598E-01_JPRB/)
KAO( :, 5,10,15) = (/&
&3.2972E-01_JPRB,2.8850E-01_JPRB,2.4729E-01_JPRB,2.1458E-01_JPRB,2.0828E-01_JPRB,2.0718E-01_JPRB,&
&2.1605E-01_JPRB,2.1269E-01_JPRB,3.5425E-01_JPRB/)
KAO( :, 1,11,15) = (/&
&1.2309E-01_JPRB,1.0770E-01_JPRB,9.2318E-02_JPRB,8.0169E-02_JPRB,7.2987E-02_JPRB,6.5556E-02_JPRB,&
&5.9599E-02_JPRB,5.7207E-02_JPRB,7.8086E-01_JPRB/)
KAO( :, 2,11,15) = (/&
&1.7300E-01_JPRB,1.5138E-01_JPRB,1.2976E-01_JPRB,1.1252E-01_JPRB,1.0172E-01_JPRB,9.2390E-02_JPRB,&
&8.6481E-02_JPRB,8.3441E-02_JPRB,7.5756E-01_JPRB/)
KAO( :, 3,11,15) = (/&
&2.3096E-01_JPRB,2.0210E-01_JPRB,1.7324E-01_JPRB,1.5024E-01_JPRB,1.3705E-01_JPRB,1.2915E-01_JPRB,&
&1.2474E-01_JPRB,1.2191E-01_JPRB,7.4457E-01_JPRB/)
KAO( :, 4,11,15) = (/&
&2.9558E-01_JPRB,2.5867E-01_JPRB,2.2168E-01_JPRB,1.9321E-01_JPRB,1.8253E-01_JPRB,1.7759E-01_JPRB,&
&1.7734E-01_JPRB,1.7484E-01_JPRB,7.3821E-01_JPRB/)
KAO( :, 5,11,15) = (/&
&3.6617E-01_JPRB,3.2039E-01_JPRB,2.7464E-01_JPRB,2.4544E-01_JPRB,2.3942E-01_JPRB,2.3664E-01_JPRB,&
&2.4480E-01_JPRB,2.4186E-01_JPRB,7.3136E-01_JPRB/)
KAO( :, 1,12,15) = (/&
&1.3535E-01_JPRB,1.1843E-01_JPRB,1.0165E-01_JPRB,8.9837E-02_JPRB,8.1690E-02_JPRB,7.3571E-02_JPRB,&
&6.6791E-02_JPRB,6.3661E-02_JPRB,1.3757E+00_JPRB/)
KAO( :, 2,12,15) = (/&
&1.8999E-01_JPRB,1.6623E-01_JPRB,1.4287E-01_JPRB,1.2620E-01_JPRB,1.1425E-01_JPRB,1.0484E-01_JPRB,&
&9.8183E-02_JPRB,9.4523E-02_JPRB,1.3459E+00_JPRB/)
KAO( :, 3,12,15) = (/&
&2.5368E-01_JPRB,2.2195E-01_JPRB,1.9057E-01_JPRB,1.6840E-01_JPRB,1.5584E-01_JPRB,1.4733E-01_JPRB,&
&1.4186E-01_JPRB,1.3807E-01_JPRB,1.3315E+00_JPRB/)
KAO( :, 4,12,15) = (/&
&3.2577E-01_JPRB,2.8506E-01_JPRB,2.4459E-01_JPRB,2.1851E-01_JPRB,2.0824E-01_JPRB,2.0259E-01_JPRB,&
&2.0145E-01_JPRB,1.9850E-01_JPRB,1.3194E+00_JPRB/)
KAO( :, 5,12,15) = (/&
&4.0459E-01_JPRB,3.5405E-01_JPRB,3.0385E-01_JPRB,2.7860E-01_JPRB,2.7319E-01_JPRB,2.7033E-01_JPRB,&
&2.7684E-01_JPRB,2.7490E-01_JPRB,1.2999E+00_JPRB/)
KAO( :, 1,13,15) = (/&
&1.4666E-01_JPRB,1.2832E-01_JPRB,1.1128E-01_JPRB,9.9675E-02_JPRB,9.0808E-02_JPRB,8.2287E-02_JPRB,&
&7.4732E-02_JPRB,7.0894E-02_JPRB,1.9726E+00_JPRB/)
KAO( :, 2,13,15) = (/&
&2.0655E-01_JPRB,1.8072E-01_JPRB,1.5634E-01_JPRB,1.3981E-01_JPRB,1.2800E-01_JPRB,1.1883E-01_JPRB,&
&1.1080E-01_JPRB,1.0633E-01_JPRB,1.9427E+00_JPRB/)
KAO( :, 3,13,15) = (/&
&2.7678E-01_JPRB,2.4218E-01_JPRB,2.0938E-01_JPRB,1.8714E-01_JPRB,1.7583E-01_JPRB,1.6736E-01_JPRB,&
&1.6095E-01_JPRB,1.5626E-01_JPRB,1.9257E+00_JPRB/)
KAO( :, 4,13,15) = (/&
&3.5575E-01_JPRB,3.1133E-01_JPRB,2.6913E-01_JPRB,2.4484E-01_JPRB,2.3543E-01_JPRB,2.2998E-01_JPRB,&
&2.2795E-01_JPRB,2.2454E-01_JPRB,1.9087E+00_JPRB/)
KAO( :, 5,13,15) = (/&
&4.4176E-01_JPRB,3.8657E-01_JPRB,3.3600E-01_JPRB,3.1312E-01_JPRB,3.0900E-01_JPRB,3.0654E-01_JPRB,&
&3.1167E-01_JPRB,3.1059E-01_JPRB,1.8847E+00_JPRB/)
KAO( :, 1, 1,16) = (/&
&1.2027E-01_JPRB,1.0526E-01_JPRB,9.0268E-02_JPRB,7.5271E-02_JPRB,6.8242E-02_JPRB,7.9946E-02_JPRB,&
&8.4979E-02_JPRB,7.6217E-02_JPRB,1.4103E-01_JPRB/)
KAO( :, 2, 1,16) = (/&
&1.4080E-01_JPRB,1.2324E-01_JPRB,1.0567E-01_JPRB,8.8126E-02_JPRB,9.6089E-02_JPRB,1.1140E-01_JPRB,&
&1.1849E-01_JPRB,1.0627E-01_JPRB,1.9684E-01_JPRB/)
KAO( :, 3, 1,16) = (/&
&1.6158E-01_JPRB,1.4144E-01_JPRB,1.1993E-01_JPRB,1.0577E-01_JPRB,1.3446E-01_JPRB,1.5713E-01_JPRB,&
&1.6954E-01_JPRB,1.5459E-01_JPRB,2.8205E-01_JPRB/)
KAO( :, 4, 1,16) = (/&
&1.8229E-01_JPRB,1.5953E-01_JPRB,1.3683E-01_JPRB,1.5400E-01_JPRB,1.9491E-01_JPRB,2.2859E-01_JPRB,&
&2.4701E-01_JPRB,2.2397E-01_JPRB,4.1109E-01_JPRB/)
KAO( :, 5, 1,16) = (/&
&2.0257E-01_JPRB,1.7732E-01_JPRB,1.5205E-01_JPRB,2.1653E-01_JPRB,2.7743E-01_JPRB,3.2485E-01_JPRB,&
&3.4587E-01_JPRB,3.1685E-01_JPRB,5.7776E-01_JPRB/)
KAO( :, 1, 2,16) = (/&
&1.3618E-01_JPRB,1.1918E-01_JPRB,1.0218E-01_JPRB,8.5185E-02_JPRB,7.2061E-02_JPRB,8.3641E-02_JPRB,&
&8.9007E-02_JPRB,8.0776E-02_JPRB,1.5158E-01_JPRB/)
KAO( :, 2, 2,16) = (/&
&1.6091E-01_JPRB,1.4083E-01_JPRB,1.2073E-01_JPRB,1.0065E-01_JPRB,1.0215E-01_JPRB,1.1864E-01_JPRB,&
&1.2628E-01_JPRB,1.1335E-01_JPRB,2.1521E-01_JPRB/)
KAO( :, 3, 2,16) = (/&
&1.8613E-01_JPRB,1.6291E-01_JPRB,1.3967E-01_JPRB,1.1644E-01_JPRB,1.3974E-01_JPRB,1.6244E-01_JPRB,&
&1.7346E-01_JPRB,1.5531E-01_JPRB,2.9678E-01_JPRB/)
KAO( :, 4, 2,16) = (/&
&2.1139E-01_JPRB,1.8501E-01_JPRB,1.5862E-01_JPRB,1.6081E-01_JPRB,2.0532E-01_JPRB,2.4099E-01_JPRB,&
&2.5759E-01_JPRB,2.3243E-01_JPRB,4.4014E-01_JPRB/)
KAO( :, 5, 2,16) = (/&
&2.3633E-01_JPRB,2.0681E-01_JPRB,1.7734E-01_JPRB,2.3037E-01_JPRB,2.9357E-01_JPRB,3.4250E-01_JPRB,&
&3.6944E-01_JPRB,3.3497E-01_JPRB,6.2683E-01_JPRB/)
KAO( :, 1, 3,16) = (/&
&1.4816E-01_JPRB,1.2967E-01_JPRB,1.1115E-01_JPRB,9.2659E-02_JPRB,7.4159E-02_JPRB,8.0583E-02_JPRB,&
&8.5826E-02_JPRB,7.7925E-02_JPRB,1.4987E-01_JPRB/)
KAO( :, 2, 3,16) = (/&
&1.7766E-01_JPRB,1.5547E-01_JPRB,1.3328E-01_JPRB,1.1109E-01_JPRB,1.0104E-01_JPRB,1.1748E-01_JPRB,&
&1.2514E-01_JPRB,1.1367E-01_JPRB,2.1867E-01_JPRB/)
KAO( :, 3, 3,16) = (/&
&2.0806E-01_JPRB,1.8208E-01_JPRB,1.5612E-01_JPRB,1.3012E-01_JPRB,1.4100E-01_JPRB,1.6398E-01_JPRB,&
&1.7474E-01_JPRB,1.5873E-01_JPRB,3.0539E-01_JPRB/)
KAO( :, 4, 3,16) = (/&
&2.3885E-01_JPRB,2.0905E-01_JPRB,1.7920E-01_JPRB,1.5462E-01_JPRB,1.9704E-01_JPRB,2.3104E-01_JPRB,&
&2.4836E-01_JPRB,2.2742E-01_JPRB,4.3187E-01_JPRB/)
KAO( :, 5, 3,16) = (/&
&2.6947E-01_JPRB,2.3583E-01_JPRB,2.0218E-01_JPRB,2.2565E-01_JPRB,2.8814E-01_JPRB,3.3769E-01_JPRB,&
&3.6257E-01_JPRB,3.3019E-01_JPRB,6.3080E-01_JPRB/)
KAO( :, 1, 4,16) = (/&
&1.5818E-01_JPRB,1.3843E-01_JPRB,1.1868E-01_JPRB,9.8906E-02_JPRB,7.9147E-02_JPRB,7.4782E-02_JPRB,&
&7.9730E-02_JPRB,7.2448E-02_JPRB,1.4101E-01_JPRB/)
KAO( :, 2, 4,16) = (/&
&1.9302E-01_JPRB,1.6890E-01_JPRB,1.4479E-01_JPRB,1.2067E-01_JPRB,9.6946E-02_JPRB,1.1266E-01_JPRB,&
&1.2012E-01_JPRB,1.0916E-01_JPRB,2.1249E-01_JPRB/)
KAO( :, 3, 4,16) = (/&
&2.2940E-01_JPRB,2.0076E-01_JPRB,1.7206E-01_JPRB,1.4345E-01_JPRB,1.3883E-01_JPRB,1.6162E-01_JPRB,&
&1.7237E-01_JPRB,1.5669E-01_JPRB,3.0501E-01_JPRB/)
KAO( :, 4, 4,16) = (/&
&2.6665E-01_JPRB,2.3335E-01_JPRB,2.0002E-01_JPRB,1.6674E-01_JPRB,1.9115E-01_JPRB,2.2258E-01_JPRB,&
&2.3743E-01_JPRB,2.1581E-01_JPRB,4.2004E-01_JPRB/)
KAO( :, 5, 4,16) = (/&
&3.0410E-01_JPRB,2.6615E-01_JPRB,2.2811E-01_JPRB,2.1285E-01_JPRB,2.7372E-01_JPRB,3.2083E-01_JPRB,&
&3.4541E-01_JPRB,3.1599E-01_JPRB,6.0405E-01_JPRB/)
KAO( :, 1, 5,16) = (/&
&1.6744E-01_JPRB,1.4653E-01_JPRB,1.2561E-01_JPRB,1.0468E-01_JPRB,8.3763E-02_JPRB,7.6430E-02_JPRB,&
&8.0078E-02_JPRB,7.1821E-02_JPRB,1.3817E-01_JPRB/)
KAO( :, 2, 5,16) = (/&
&2.0817E-01_JPRB,1.8217E-01_JPRB,1.5617E-01_JPRB,1.3014E-01_JPRB,1.0413E-01_JPRB,1.0666E-01_JPRB,&
&1.1380E-01_JPRB,1.0350E-01_JPRB,2.0245E-01_JPRB/)
KAO( :, 3, 5,16) = (/&
&2.5135E-01_JPRB,2.1998E-01_JPRB,1.8857E-01_JPRB,1.5714E-01_JPRB,1.3525E-01_JPRB,1.5761E-01_JPRB,&
&1.6824E-01_JPRB,1.5302E-01_JPRB,2.9921E-01_JPRB/)
KAO( :, 4, 5,16) = (/&
&2.9614E-01_JPRB,2.5913E-01_JPRB,2.2214E-01_JPRB,1.8514E-01_JPRB,1.9095E-01_JPRB,2.2256E-01_JPRB,&
&2.3757E-01_JPRB,2.1609E-01_JPRB,4.2253E-01_JPRB/)
KAO( :, 5, 5,16) = (/&
&3.4165E-01_JPRB,2.9890E-01_JPRB,2.5626E-01_JPRB,2.1358E-01_JPRB,2.6276E-01_JPRB,3.0710E-01_JPRB,&
&3.2753E-01_JPRB,2.9875E-01_JPRB,5.8403E-01_JPRB/)
KAO( :, 1, 6,16) = (/&
&1.7406E-01_JPRB,1.5231E-01_JPRB,1.3056E-01_JPRB,1.0879E-01_JPRB,8.7033E-02_JPRB,7.9557E-02_JPRB,&
&8.3495E-02_JPRB,7.4970E-02_JPRB,1.4461E-01_JPRB/)
KAO( :, 2, 6,16) = (/&
&2.2115E-01_JPRB,1.9353E-01_JPRB,1.6587E-01_JPRB,1.3825E-01_JPRB,1.1058E-01_JPRB,1.0079E-01_JPRB,&
&1.0571E-01_JPRB,9.5354E-02_JPRB,1.8669E-01_JPRB/)
KAO( :, 3, 6,16) = (/&
&2.7185E-01_JPRB,2.3789E-01_JPRB,2.0389E-01_JPRB,1.6994E-01_JPRB,1.3598E-01_JPRB,1.4993E-01_JPRB,&
&1.6017E-01_JPRB,1.4582E-01_JPRB,2.8546E-01_JPRB/)
KAO( :, 4, 6,16) = (/&
&3.2519E-01_JPRB,2.8454E-01_JPRB,2.4391E-01_JPRB,2.0327E-01_JPRB,1.8667E-01_JPRB,2.1780E-01_JPRB,&
&2.3273E-01_JPRB,2.1193E-01_JPRB,4.1454E-01_JPRB/)
KAO( :, 5, 6,16) = (/&
&3.7997E-01_JPRB,3.3252E-01_JPRB,2.8502E-01_JPRB,2.3749E-01_JPRB,2.5973E-01_JPRB,3.0308E-01_JPRB,&
&3.2386E-01_JPRB,2.9502E-01_JPRB,5.7680E-01_JPRB/)
KAO( :, 1, 7,16) = (/&
&1.7875E-01_JPRB,1.5642E-01_JPRB,1.3408E-01_JPRB,1.1175E-01_JPRB,8.9415E-02_JPRB,8.1831E-02_JPRB,&
&8.6005E-02_JPRB,7.7323E-02_JPRB,1.4922E-01_JPRB/)
KAO( :, 2, 7,16) = (/&
&2.3257E-01_JPRB,2.0349E-01_JPRB,1.7445E-01_JPRB,1.4538E-01_JPRB,1.1631E-01_JPRB,1.0616E-01_JPRB,&
&1.1147E-01_JPRB,1.0017E-01_JPRB,1.9290E-01_JPRB/)
KAO( :, 3, 7,16) = (/&
&2.9155E-01_JPRB,2.5511E-01_JPRB,2.1872E-01_JPRB,1.8226E-01_JPRB,1.4581E-01_JPRB,1.4057E-01_JPRB,&
&1.5032E-01_JPRB,1.3703E-01_JPRB,2.6795E-01_JPRB/)
KAO( :, 4, 7,16) = (/&
&3.5453E-01_JPRB,3.1018E-01_JPRB,2.6586E-01_JPRB,2.2158E-01_JPRB,1.8072E-01_JPRB,2.1059E-01_JPRB,&
&2.2528E-01_JPRB,2.0539E-01_JPRB,4.0134E-01_JPRB/)
KAO( :, 5, 7,16) = (/&
&4.2001E-01_JPRB,3.6750E-01_JPRB,3.1500E-01_JPRB,2.6252E-01_JPRB,2.5742E-01_JPRB,3.0072E-01_JPRB,&
&3.2172E-01_JPRB,2.9345E-01_JPRB,5.7279E-01_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.8184E-01_JPRB,1.5912E-01_JPRB,1.3638E-01_JPRB,1.1367E-01_JPRB,9.0918E-02_JPRB,8.3330E-02_JPRB,&
&8.7708E-02_JPRB,7.9039E-02_JPRB,1.5236E-01_JPRB/)
KAO( :, 2, 8,16) = (/&
&2.4266E-01_JPRB,2.1231E-01_JPRB,1.8198E-01_JPRB,1.5168E-01_JPRB,1.2132E-01_JPRB,1.1090E-01_JPRB,&
&1.1664E-01_JPRB,1.0501E-01_JPRB,2.0199E-01_JPRB/)
KAO( :, 3, 8,16) = (/&
&3.1060E-01_JPRB,2.7177E-01_JPRB,2.3297E-01_JPRB,1.9411E-01_JPRB,1.5532E-01_JPRB,1.4153E-01_JPRB,&
&1.4874E-01_JPRB,1.3387E-01_JPRB,2.5753E-01_JPRB/)
KAO( :, 4, 8,16) = (/&
&3.8422E-01_JPRB,3.3618E-01_JPRB,2.8820E-01_JPRB,2.4017E-01_JPRB,1.9212E-01_JPRB,2.0191E-01_JPRB,&
&2.1622E-01_JPRB,1.9751E-01_JPRB,3.8483E-01_JPRB/)
KAO( :, 5, 8,16) = (/&
&4.6183E-01_JPRB,4.0412E-01_JPRB,3.4637E-01_JPRB,2.8861E-01_JPRB,2.5332E-01_JPRB,2.9628E-01_JPRB,&
&3.1743E-01_JPRB,2.9007E-01_JPRB,5.6429E-01_JPRB/)
KAO( :, 1, 9,16) = (/&
&1.8242E-01_JPRB,1.5964E-01_JPRB,1.3685E-01_JPRB,1.1403E-01_JPRB,9.1238E-02_JPRB,8.3650E-02_JPRB,&
&8.8221E-02_JPRB,7.9647E-02_JPRB,1.5343E-01_JPRB/)
KAO( :, 2, 9,16) = (/&
&2.5031E-01_JPRB,2.1903E-01_JPRB,1.8774E-01_JPRB,1.5645E-01_JPRB,1.2518E-01_JPRB,1.1450E-01_JPRB,&
&1.2069E-01_JPRB,1.0894E-01_JPRB,2.0909E-01_JPRB/)
KAO( :, 3, 9,16) = (/&
&3.2780E-01_JPRB,2.8681E-01_JPRB,2.4582E-01_JPRB,2.0484E-01_JPRB,1.6390E-01_JPRB,1.4947E-01_JPRB,&
&1.5744E-01_JPRB,1.4207E-01_JPRB,2.7178E-01_JPRB/)
KAO( :, 4, 9,16) = (/&
&4.1288E-01_JPRB,3.6136E-01_JPRB,3.0972E-01_JPRB,2.5810E-01_JPRB,2.0648E-01_JPRB,1.9240E-01_JPRB,&
&2.0499E-01_JPRB,1.8750E-01_JPRB,3.6520E-01_JPRB/)
KAO( :, 5, 9,16) = (/&
&5.0401E-01_JPRB,4.4105E-01_JPRB,3.7793E-01_JPRB,3.1504E-01_JPRB,2.5430E-01_JPRB,2.8859E-01_JPRB,&
&3.0964E-01_JPRB,2.8367E-01_JPRB,5.5002E-01_JPRB/)
KAO( :, 1,10,16) = (/&
&1.8581E-01_JPRB,1.6259E-01_JPRB,1.3934E-01_JPRB,1.1613E-01_JPRB,9.2903E-02_JPRB,8.5148E-02_JPRB,&
&9.0034E-02_JPRB,8.1540E-02_JPRB,3.4590E-01_JPRB/)
KAO( :, 2,10,16) = (/&
&2.6163E-01_JPRB,2.2890E-01_JPRB,1.9618E-01_JPRB,1.6349E-01_JPRB,1.3077E-01_JPRB,1.1965E-01_JPRB,&
&1.2644E-01_JPRB,1.1450E-01_JPRB,3.2865E-01_JPRB/)
KAO( :, 3,10,16) = (/&
&3.4958E-01_JPRB,3.0586E-01_JPRB,2.6220E-01_JPRB,2.1849E-01_JPRB,1.7478E-01_JPRB,1.5951E-01_JPRB,&
&1.6845E-01_JPRB,1.5252E-01_JPRB,3.1204E-01_JPRB/)
KAO( :, 4,10,16) = (/&
&4.4787E-01_JPRB,3.9191E-01_JPRB,3.3594E-01_JPRB,2.7989E-01_JPRB,2.2397E-01_JPRB,2.0376E-01_JPRB,&
&2.1506E-01_JPRB,1.9478E-01_JPRB,3.7906E-01_JPRB/)
KAO( :, 5,10,16) = (/&
&5.5414E-01_JPRB,4.8494E-01_JPRB,4.1561E-01_JPRB,3.4636E-01_JPRB,2.7711E-01_JPRB,2.8690E-01_JPRB,&
&3.0857E-01_JPRB,2.8362E-01_JPRB,5.5736E-01_JPRB/)
KAO( :, 1,11,16) = (/&
&2.2387E-01_JPRB,1.9590E-01_JPRB,1.6793E-01_JPRB,1.3995E-01_JPRB,1.1196E-01_JPRB,1.0248E-01_JPRB,&
&1.0866E-01_JPRB,9.8759E-02_JPRB,9.7232E-01_JPRB/)
KAO( :, 2,11,16) = (/&
&3.1487E-01_JPRB,2.7553E-01_JPRB,2.3616E-01_JPRB,1.9682E-01_JPRB,1.5747E-01_JPRB,1.4389E-01_JPRB,&
&1.5251E-01_JPRB,1.3868E-01_JPRB,9.2352E-01_JPRB/)
KAO( :, 3,11,16) = (/&
&4.2034E-01_JPRB,3.6781E-01_JPRB,3.1526E-01_JPRB,2.6274E-01_JPRB,2.1020E-01_JPRB,1.9156E-01_JPRB,&
&2.0295E-01_JPRB,1.8465E-01_JPRB,8.7619E-01_JPRB/)
KAO( :, 4,11,16) = (/&
&5.3783E-01_JPRB,4.7062E-01_JPRB,4.0338E-01_JPRB,3.3619E-01_JPRB,2.6900E-01_JPRB,2.4463E-01_JPRB,&
&2.5910E-01_JPRB,2.3556E-01_JPRB,8.3528E-01_JPRB/)
KAO( :, 5,11,16) = (/&
&6.6465E-01_JPRB,5.8160E-01_JPRB,4.9850E-01_JPRB,4.1545E-01_JPRB,3.3262E-01_JPRB,3.4381E-01_JPRB,&
&3.7087E-01_JPRB,3.4266E-01_JPRB,8.3608E-01_JPRB/)
KAO( :, 1,12,16) = (/&
&2.6898E-01_JPRB,2.3539E-01_JPRB,2.0175E-01_JPRB,1.6812E-01_JPRB,1.3451E-01_JPRB,1.2295E-01_JPRB,&
&1.3082E-01_JPRB,1.1955E-01_JPRB,1.7254E+00_JPRB/)
KAO( :, 2,12,16) = (/&
&3.7759E-01_JPRB,3.3035E-01_JPRB,2.8322E-01_JPRB,2.3602E-01_JPRB,1.8879E-01_JPRB,1.7231E-01_JPRB,&
&1.8335E-01_JPRB,1.6769E-01_JPRB,1.6364E+00_JPRB/)
KAO( :, 3,12,16) = (/&
&5.0302E-01_JPRB,4.4026E-01_JPRB,3.7736E-01_JPRB,3.1440E-01_JPRB,2.5155E-01_JPRB,2.2898E-01_JPRB,&
&2.4369E-01_JPRB,2.2307E-01_JPRB,1.5678E+00_JPRB/)
KAO( :, 4,12,16) = (/&
&6.4249E-01_JPRB,5.6214E-01_JPRB,4.8190E-01_JPRB,4.0154E-01_JPRB,3.2127E-01_JPRB,2.9402E-01_JPRB,&
&3.1247E-01_JPRB,2.8485E-01_JPRB,1.5255E+00_JPRB/)
KAO( :, 5,12,16) = (/&
&7.9248E-01_JPRB,6.9340E-01_JPRB,5.9438E-01_JPRB,4.9520E-01_JPRB,3.9963E-01_JPRB,4.1148E-01_JPRB,&
&4.4433E-01_JPRB,4.1322E-01_JPRB,1.5412E+00_JPRB/)
KAO( :, 1,13,16) = (/&
&3.2111E-01_JPRB,2.8086E-01_JPRB,2.4080E-01_JPRB,2.0063E-01_JPRB,1.6053E-01_JPRB,1.4645E-01_JPRB,&
&1.5663E-01_JPRB,1.4415E-01_JPRB,2.4681E+00_JPRB/)
KAO( :, 2,13,16) = (/&
&4.4952E-01_JPRB,3.9337E-01_JPRB,3.3709E-01_JPRB,2.8095E-01_JPRB,2.2474E-01_JPRB,2.0495E-01_JPRB,&
&2.1909E-01_JPRB,2.0198E-01_JPRB,2.3822E+00_JPRB/)
KAO( :, 3,13,16) = (/&
&5.9739E-01_JPRB,5.2281E-01_JPRB,4.4809E-01_JPRB,3.7333E-01_JPRB,2.9881E-01_JPRB,2.7217E-01_JPRB,&
&2.9063E-01_JPRB,2.6832E-01_JPRB,2.3232E+00_JPRB/)
KAO( :, 4,13,16) = (/&
&7.6112E-01_JPRB,6.6586E-01_JPRB,5.7079E-01_JPRB,4.7570E-01_JPRB,3.8102E-01_JPRB,3.5288E-01_JPRB,&
&3.7640E-01_JPRB,3.4431E-01_JPRB,2.2950E+00_JPRB/)
KAO( :, 5,13,16) = (/&
&9.3631E-01_JPRB,8.1920E-01_JPRB,7.0224E-01_JPRB,5.8508E-01_JPRB,4.7927E-01_JPRB,4.9193E-01_JPRB,&
&5.3062E-01_JPRB,4.9592E-01_JPRB,2.3135E+00_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB5_A2
