!OCL SCALAR
SUBROUTINE RRTM_KGB4_B4

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 4:  630-700 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)


!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO4 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,FRACREFBO
USE YOERRTA4 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 6, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*H2O), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13,13) = (/&
&2.1392E+01_JPRB,2.1380E+01_JPRB,1.6377E+01_JPRB,1.1373E+01_JPRB,6.6382E+00_JPRB,5.4072E+00_JPRB/)
KBO( :, 2,13,13) = (/&
&2.0984E+01_JPRB,2.0973E+01_JPRB,1.6065E+01_JPRB,1.1155E+01_JPRB,6.4809E+00_JPRB,5.2816E+00_JPRB/)
KBO( :, 3,13,13) = (/&
&2.0571E+01_JPRB,2.0560E+01_JPRB,1.5742E+01_JPRB,1.0918E+01_JPRB,6.3142E+00_JPRB,5.1399E+00_JPRB/)
KBO( :, 4,13,13) = (/&
&2.0116E+01_JPRB,2.0104E+01_JPRB,1.5385E+01_JPRB,1.0661E+01_JPRB,6.1353E+00_JPRB,5.0342E+00_JPRB/)
KBO( :, 5,13,13) = (/&
&1.9665E+01_JPRB,1.9654E+01_JPRB,1.5041E+01_JPRB,1.0410E+01_JPRB,5.9659E+00_JPRB,5.1046E+00_JPRB/)
KBO( :, 1,14,13) = (/&
&2.2611E+01_JPRB,2.2598E+01_JPRB,1.7286E+01_JPRB,1.1979E+01_JPRB,6.9848E+00_JPRB,5.8003E+00_JPRB/)
KBO( :, 2,14,13) = (/&
&2.2235E+01_JPRB,2.2222E+01_JPRB,1.6999E+01_JPRB,1.1763E+01_JPRB,6.8307E+00_JPRB,5.6143E+00_JPRB/)
KBO( :, 3,14,13) = (/&
&2.1845E+01_JPRB,2.1832E+01_JPRB,1.6684E+01_JPRB,1.1532E+01_JPRB,6.6725E+00_JPRB,5.4768E+00_JPRB/)
KBO( :, 4,14,13) = (/&
&2.1455E+01_JPRB,2.1442E+01_JPRB,1.6377E+01_JPRB,1.1313E+01_JPRB,6.5206E+00_JPRB,5.3624E+00_JPRB/)
KBO( :, 5,14,13) = (/&
&2.1081E+01_JPRB,2.1069E+01_JPRB,1.6078E+01_JPRB,1.1090E+01_JPRB,6.3823E+00_JPRB,5.2307E+00_JPRB/)
KBO( :, 1,15,13) = (/&
&2.4085E+01_JPRB,2.4071E+01_JPRB,1.8394E+01_JPRB,1.2709E+01_JPRB,7.4960E+00_JPRB,6.3317E+00_JPRB/)
KBO( :, 2,15,13) = (/&
&2.3744E+01_JPRB,2.3731E+01_JPRB,1.8118E+01_JPRB,1.2499E+01_JPRB,7.3422E+00_JPRB,6.1431E+00_JPRB/)
KBO( :, 3,15,13) = (/&
&2.3384E+01_JPRB,2.3371E+01_JPRB,1.7836E+01_JPRB,1.2301E+01_JPRB,7.1895E+00_JPRB,5.9905E+00_JPRB/)
KBO( :, 4,15,13) = (/&
&2.3079E+01_JPRB,2.3065E+01_JPRB,1.7598E+01_JPRB,1.2125E+01_JPRB,7.0485E+00_JPRB,5.8455E+00_JPRB/)
KBO( :, 5,15,13) = (/&
&2.2790E+01_JPRB,2.2777E+01_JPRB,1.7354E+01_JPRB,1.1938E+01_JPRB,6.8999E+00_JPRB,5.7410E+00_JPRB/)
KBO( :, 1,16,13) = (/&
&2.5695E+01_JPRB,2.5680E+01_JPRB,1.9581E+01_JPRB,1.3479E+01_JPRB,8.1349E+00_JPRB,7.0625E+00_JPRB/)
KBO( :, 2,16,13) = (/&
&2.5421E+01_JPRB,2.5406E+01_JPRB,1.9374E+01_JPRB,1.3336E+01_JPRB,7.9760E+00_JPRB,6.8886E+00_JPRB/)
KBO( :, 3,16,13) = (/&
&2.5170E+01_JPRB,2.5155E+01_JPRB,1.9169E+01_JPRB,1.3185E+01_JPRB,7.8208E+00_JPRB,6.7331E+00_JPRB/)
KBO( :, 4,16,13) = (/&
&2.4917E+01_JPRB,2.4902E+01_JPRB,1.8958E+01_JPRB,1.3021E+01_JPRB,7.6613E+00_JPRB,6.5695E+00_JPRB/)
KBO( :, 5,16,13) = (/&
&2.4671E+01_JPRB,2.4656E+01_JPRB,1.8755E+01_JPRB,1.2857E+01_JPRB,7.5038E+00_JPRB,6.4414E+00_JPRB/)
KBO( :, 1,17,13) = (/&
&2.7485E+01_JPRB,2.7469E+01_JPRB,2.0920E+01_JPRB,1.4359E+01_JPRB,8.8403E+00_JPRB,7.9625E+00_JPRB/)
KBO( :, 2,17,13) = (/&
&2.7261E+01_JPRB,2.7245E+01_JPRB,2.0734E+01_JPRB,1.4221E+01_JPRB,8.6752E+00_JPRB,7.7696E+00_JPRB/)
KBO( :, 3,17,13) = (/&
&2.7019E+01_JPRB,2.7003E+01_JPRB,2.0538E+01_JPRB,1.4067E+01_JPRB,8.5095E+00_JPRB,7.5869E+00_JPRB/)
KBO( :, 4,17,13) = (/&
&2.6774E+01_JPRB,2.6758E+01_JPRB,2.0340E+01_JPRB,1.3916E+01_JPRB,8.3433E+00_JPRB,7.4093E+00_JPRB/)
KBO( :, 5,17,13) = (/&
&2.6489E+01_JPRB,2.6473E+01_JPRB,2.0113E+01_JPRB,1.3747E+01_JPRB,8.1757E+00_JPRB,7.2580E+00_JPRB/)
KBO( :, 1,18,13) = (/&
&2.9073E+01_JPRB,2.9056E+01_JPRB,2.2090E+01_JPRB,1.5130E+01_JPRB,9.6108E+00_JPRB,8.9667E+00_JPRB/)
KBO( :, 2,18,13) = (/&
&2.8847E+01_JPRB,2.8830E+01_JPRB,2.1906E+01_JPRB,1.4984E+01_JPRB,9.4415E+00_JPRB,8.7341E+00_JPRB/)
KBO( :, 3,18,13) = (/&
&2.8614E+01_JPRB,2.8597E+01_JPRB,2.1721E+01_JPRB,1.4840E+01_JPRB,9.2727E+00_JPRB,8.5308E+00_JPRB/)
KBO( :, 4,18,13) = (/&
&2.8333E+01_JPRB,2.8317E+01_JPRB,2.1498E+01_JPRB,1.4677E+01_JPRB,9.0956E+00_JPRB,8.3322E+00_JPRB/)
KBO( :, 5,18,13) = (/&
&2.8019E+01_JPRB,2.8003E+01_JPRB,2.1254E+01_JPRB,1.4499E+01_JPRB,8.9142E+00_JPRB,8.1468E+00_JPRB/)
KBO( :, 1,19,13) = (/&
&3.0315E+01_JPRB,3.0297E+01_JPRB,2.3006E+01_JPRB,1.5724E+01_JPRB,1.0512E+01_JPRB,1.0019E+01_JPRB/)
KBO( :, 2,19,13) = (/&
&3.0061E+01_JPRB,3.0044E+01_JPRB,2.2808E+01_JPRB,1.5577E+01_JPRB,1.0342E+01_JPRB,9.7644E+00_JPRB/)
KBO( :, 3,19,13) = (/&
&2.9787E+01_JPRB,2.9769E+01_JPRB,2.2595E+01_JPRB,1.5419E+01_JPRB,1.0163E+01_JPRB,9.5327E+00_JPRB/)
KBO( :, 4,19,13) = (/&
&2.9464E+01_JPRB,2.9447E+01_JPRB,2.2343E+01_JPRB,1.5239E+01_JPRB,9.9795E+00_JPRB,9.3290E+00_JPRB/)
KBO( :, 5,19,13) = (/&
&2.9104E+01_JPRB,2.9087E+01_JPRB,2.2065E+01_JPRB,1.5039E+01_JPRB,9.7881E+00_JPRB,9.1292E+00_JPRB/)
KBO( :, 1,20,13) = (/&
&3.1036E+01_JPRB,3.1018E+01_JPRB,2.3548E+01_JPRB,1.6113E+01_JPRB,1.1579E+01_JPRB,1.1154E+01_JPRB/)
KBO( :, 2,20,13) = (/&
&3.0755E+01_JPRB,3.0737E+01_JPRB,2.3334E+01_JPRB,1.5957E+01_JPRB,1.1393E+01_JPRB,1.0893E+01_JPRB/)
KBO( :, 3,20,13) = (/&
&3.0452E+01_JPRB,3.0434E+01_JPRB,2.3095E+01_JPRB,1.5780E+01_JPRB,1.1192E+01_JPRB,1.0651E+01_JPRB/)
KBO( :, 4,20,13) = (/&
&3.0086E+01_JPRB,3.0068E+01_JPRB,2.2811E+01_JPRB,1.5577E+01_JPRB,1.0976E+01_JPRB,1.0441E+01_JPRB/)
KBO( :, 5,20,13) = (/&
&2.9696E+01_JPRB,2.9679E+01_JPRB,2.2510E+01_JPRB,1.5363E+01_JPRB,1.0748E+01_JPRB,1.0213E+01_JPRB/)
KBO( :, 1,21,13) = (/&
&3.1144E+01_JPRB,3.1126E+01_JPRB,2.3635E+01_JPRB,1.6360E+01_JPRB,1.2781E+01_JPRB,1.2415E+01_JPRB/)
KBO( :, 2,21,13) = (/&
&3.0844E+01_JPRB,3.0826E+01_JPRB,2.3403E+01_JPRB,1.6172E+01_JPRB,1.2549E+01_JPRB,1.2147E+01_JPRB/)
KBO( :, 3,21,13) = (/&
&3.0498E+01_JPRB,3.0480E+01_JPRB,2.3133E+01_JPRB,1.5960E+01_JPRB,1.2302E+01_JPRB,1.1885E+01_JPRB/)
KBO( :, 4,21,13) = (/&
&3.0111E+01_JPRB,3.0093E+01_JPRB,2.2836E+01_JPRB,1.5742E+01_JPRB,1.2041E+01_JPRB,1.1642E+01_JPRB/)
KBO( :, 5,21,13) = (/&
&2.9700E+01_JPRB,2.9683E+01_JPRB,2.2517E+01_JPRB,1.5496E+01_JPRB,1.1766E+01_JPRB,1.1381E+01_JPRB/)
KBO( :, 1,22,13) = (/&
&3.0579E+01_JPRB,3.0561E+01_JPRB,2.3219E+01_JPRB,1.6510E+01_JPRB,1.4016E+01_JPRB,1.3791E+01_JPRB/)
KBO( :, 2,22,13) = (/&
&3.0252E+01_JPRB,3.0234E+01_JPRB,2.2968E+01_JPRB,1.6283E+01_JPRB,1.3741E+01_JPRB,1.3488E+01_JPRB/)
KBO( :, 3,22,13) = (/&
&2.9906E+01_JPRB,2.9889E+01_JPRB,2.2700E+01_JPRB,1.6051E+01_JPRB,1.3445E+01_JPRB,1.3187E+01_JPRB/)
KBO( :, 4,22,13) = (/&
&2.9523E+01_JPRB,2.9506E+01_JPRB,2.2405E+01_JPRB,1.5794E+01_JPRB,1.3135E+01_JPRB,1.2905E+01_JPRB/)
KBO( :, 5,22,13) = (/&
&2.9116E+01_JPRB,2.9100E+01_JPRB,2.2090E+01_JPRB,1.5521E+01_JPRB,1.2819E+01_JPRB,1.2597E+01_JPRB/)
KBO( :, 1,23,13) = (/&
&2.9397E+01_JPRB,2.9380E+01_JPRB,2.2345E+01_JPRB,1.6640E+01_JPRB,1.5241E+01_JPRB,1.5271E+01_JPRB/)
KBO( :, 2,23,13) = (/&
&2.9096E+01_JPRB,2.9079E+01_JPRB,2.2113E+01_JPRB,1.6382E+01_JPRB,1.4921E+01_JPRB,1.4908E+01_JPRB/)
KBO( :, 3,23,13) = (/&
&2.8759E+01_JPRB,2.8742E+01_JPRB,2.1850E+01_JPRB,1.6098E+01_JPRB,1.4591E+01_JPRB,1.4553E+01_JPRB/)
KBO( :, 4,23,13) = (/&
&2.8405E+01_JPRB,2.8388E+01_JPRB,2.1576E+01_JPRB,1.5810E+01_JPRB,1.4244E+01_JPRB,1.4213E+01_JPRB/)
KBO( :, 5,23,13) = (/&
&2.8010E+01_JPRB,2.7994E+01_JPRB,2.1268E+01_JPRB,1.5508E+01_JPRB,1.3883E+01_JPRB,1.3842E+01_JPRB/)
KBO( :, 1,24,13) = (/&
&2.7736E+01_JPRB,2.7720E+01_JPRB,2.1114E+01_JPRB,1.6904E+01_JPRB,1.6493E+01_JPRB,1.6795E+01_JPRB/)
KBO( :, 2,24,13) = (/&
&2.7462E+01_JPRB,2.7446E+01_JPRB,2.0900E+01_JPRB,1.6582E+01_JPRB,1.6130E+01_JPRB,1.6394E+01_JPRB/)
KBO( :, 3,24,13) = (/&
&2.7151E+01_JPRB,2.7136E+01_JPRB,2.0660E+01_JPRB,1.6247E+01_JPRB,1.5745E+01_JPRB,1.5974E+01_JPRB/)
KBO( :, 4,24,13) = (/&
&2.6831E+01_JPRB,2.6816E+01_JPRB,2.0409E+01_JPRB,1.5908E+01_JPRB,1.5345E+01_JPRB,1.5569E+01_JPRB/)
KBO( :, 5,24,13) = (/&
&2.6459E+01_JPRB,2.6444E+01_JPRB,2.0122E+01_JPRB,1.5560E+01_JPRB,1.4934E+01_JPRB,1.5132E+01_JPRB/)
KBO( :, 1,25,13) = (/&
&2.5741E+01_JPRB,2.5726E+01_JPRB,1.9691E+01_JPRB,1.7263E+01_JPRB,1.7747E+01_JPRB,1.8359E+01_JPRB/)
KBO( :, 2,25,13) = (/&
&2.5497E+01_JPRB,2.5482E+01_JPRB,1.9486E+01_JPRB,1.6895E+01_JPRB,1.7326E+01_JPRB,1.7886E+01_JPRB/)
KBO( :, 3,25,13) = (/&
&2.5241E+01_JPRB,2.5227E+01_JPRB,1.9275E+01_JPRB,1.6517E+01_JPRB,1.6889E+01_JPRB,1.7399E+01_JPRB/)
KBO( :, 4,25,13) = (/&
&2.4941E+01_JPRB,2.4927E+01_JPRB,1.9033E+01_JPRB,1.6125E+01_JPRB,1.6436E+01_JPRB,1.6925E+01_JPRB/)
KBO( :, 5,25,13) = (/&
&2.4625E+01_JPRB,2.4611E+01_JPRB,1.8780E+01_JPRB,1.5723E+01_JPRB,1.5971E+01_JPRB,1.6420E+01_JPRB/)
KBO( :, 1,26,13) = (/&
&2.3543E+01_JPRB,2.3530E+01_JPRB,1.8282E+01_JPRB,1.7640E+01_JPRB,1.9000E+01_JPRB,1.9879E+01_JPRB/)
KBO( :, 2,26,13) = (/&
&2.3344E+01_JPRB,2.3330E+01_JPRB,1.8083E+01_JPRB,1.7232E+01_JPRB,1.8508E+01_JPRB,1.9336E+01_JPRB/)
KBO( :, 3,26,13) = (/&
&2.3131E+01_JPRB,2.3118E+01_JPRB,1.7881E+01_JPRB,1.6809E+01_JPRB,1.8012E+01_JPRB,1.8780E+01_JPRB/)
KBO( :, 4,26,13) = (/&
&2.2891E+01_JPRB,2.2878E+01_JPRB,1.7660E+01_JPRB,1.6381E+01_JPRB,1.7496E+01_JPRB,1.8235E+01_JPRB/)
KBO( :, 5,26,13) = (/&
&2.2635E+01_JPRB,2.2623E+01_JPRB,1.7424E+01_JPRB,1.5941E+01_JPRB,1.6965E+01_JPRB,1.7649E+01_JPRB/)
KBO( :, 1,27,13) = (/&
&2.1263E+01_JPRB,2.1251E+01_JPRB,1.6999E+01_JPRB,1.8073E+01_JPRB,2.0218E+01_JPRB,2.1326E+01_JPRB/)
KBO( :, 2,27,13) = (/&
&2.1130E+01_JPRB,2.1118E+01_JPRB,1.6805E+01_JPRB,1.7603E+01_JPRB,1.9655E+01_JPRB,2.0714E+01_JPRB/)
KBO( :, 3,27,13) = (/&
&2.0964E+01_JPRB,2.0953E+01_JPRB,1.6591E+01_JPRB,1.7141E+01_JPRB,1.9068E+01_JPRB,2.0084E+01_JPRB/)
KBO( :, 4,27,13) = (/&
&2.0811E+01_JPRB,2.0800E+01_JPRB,1.6383E+01_JPRB,1.6665E+01_JPRB,1.8477E+01_JPRB,1.9460E+01_JPRB/)
KBO( :, 5,27,13) = (/&
&2.0671E+01_JPRB,2.0659E+01_JPRB,1.6163E+01_JPRB,1.6182E+01_JPRB,1.7875E+01_JPRB,1.8801E+01_JPRB/)
KBO( :, 1,28,13) = (/&
&1.9006E+01_JPRB,1.8995E+01_JPRB,1.5933E+01_JPRB,1.8511E+01_JPRB,2.1355E+01_JPRB,2.2683E+01_JPRB/)
KBO( :, 2,28,13) = (/&
&1.8934E+01_JPRB,1.8923E+01_JPRB,1.5716E+01_JPRB,1.8009E+01_JPRB,2.0708E+01_JPRB,2.1993E+01_JPRB/)
KBO( :, 3,28,13) = (/&
&1.8875E+01_JPRB,1.8864E+01_JPRB,1.5505E+01_JPRB,1.7487E+01_JPRB,2.0041E+01_JPRB,2.1291E+01_JPRB/)
KBO( :, 4,28,13) = (/&
&1.8867E+01_JPRB,1.8856E+01_JPRB,1.5292E+01_JPRB,1.6969E+01_JPRB,1.9370E+01_JPRB,2.0578E+01_JPRB/)
KBO( :, 5,28,13) = (/&
&1.8926E+01_JPRB,1.8916E+01_JPRB,1.5114E+01_JPRB,1.6444E+01_JPRB,1.8700E+01_JPRB,1.9834E+01_JPRB/)
KBO( :, 1,29,13) = (/&
&1.6866E+01_JPRB,1.6856E+01_JPRB,1.5090E+01_JPRB,1.8932E+01_JPRB,2.2378E+01_JPRB,2.3900E+01_JPRB/)
KBO( :, 2,29,13) = (/&
&1.6895E+01_JPRB,1.6885E+01_JPRB,1.4848E+01_JPRB,1.8394E+01_JPRB,2.1642E+01_JPRB,2.3131E+01_JPRB/)
KBO( :, 3,29,13) = (/&
&1.7005E+01_JPRB,1.6996E+01_JPRB,1.4617E+01_JPRB,1.7836E+01_JPRB,2.0899E+01_JPRB,2.2368E+01_JPRB/)
KBO( :, 4,29,13) = (/&
&1.7186E+01_JPRB,1.7177E+01_JPRB,1.4419E+01_JPRB,1.7274E+01_JPRB,2.0148E+01_JPRB,2.1559E+01_JPRB/)
KBO( :, 5,29,13) = (/&
&1.7419E+01_JPRB,1.7409E+01_JPRB,1.4291E+01_JPRB,1.6708E+01_JPRB,1.9414E+01_JPRB,2.0739E+01_JPRB/)
KBO( :, 1,30,13) = (/&
&1.4953E+01_JPRB,1.4945E+01_JPRB,1.4448E+01_JPRB,1.9321E+01_JPRB,2.3266E+01_JPRB,2.4961E+01_JPRB/)
KBO( :, 2,30,13) = (/&
&1.5147E+01_JPRB,1.5138E+01_JPRB,1.4172E+01_JPRB,1.8728E+01_JPRB,2.2451E+01_JPRB,2.4136E+01_JPRB/)
KBO( :, 3,30,13) = (/&
&1.5423E+01_JPRB,1.5415E+01_JPRB,1.3932E+01_JPRB,1.8138E+01_JPRB,2.1636E+01_JPRB,2.3296E+01_JPRB/)
KBO( :, 4,30,13) = (/&
&1.5783E+01_JPRB,1.5774E+01_JPRB,1.3754E+01_JPRB,1.7532E+01_JPRB,2.0815E+01_JPRB,2.2402E+01_JPRB/)
KBO( :, 5,30,13) = (/&
&1.6221E+01_JPRB,1.6212E+01_JPRB,1.3682E+01_JPRB,1.6932E+01_JPRB,2.0014E+01_JPRB,2.1530E+01_JPRB/)
KBO( :, 1,31,13) = (/&
&1.3343E+01_JPRB,1.3335E+01_JPRB,1.3979E+01_JPRB,1.9651E+01_JPRB,2.4006E+01_JPRB,2.5869E+01_JPRB/)
KBO( :, 2,31,13) = (/&
&1.3698E+01_JPRB,1.3690E+01_JPRB,1.3675E+01_JPRB,1.9009E+01_JPRB,2.3133E+01_JPRB,2.5002E+01_JPRB/)
KBO( :, 3,31,13) = (/&
&1.4163E+01_JPRB,1.4155E+01_JPRB,1.3429E+01_JPRB,1.8375E+01_JPRB,2.2243E+01_JPRB,2.4068E+01_JPRB/)
KBO( :, 4,31,13) = (/&
&1.4712E+01_JPRB,1.4703E+01_JPRB,1.3295E+01_JPRB,1.7748E+01_JPRB,2.1362E+01_JPRB,2.3103E+01_JPRB/)
KBO( :, 5,31,13) = (/&
&1.5311E+01_JPRB,1.5303E+01_JPRB,1.3250E+01_JPRB,1.7114E+01_JPRB,2.0500E+01_JPRB,2.2261E+01_JPRB/)
KBO( :, 1,32,13) = (/&
&1.2052E+01_JPRB,1.2045E+01_JPRB,1.3628E+01_JPRB,1.9911E+01_JPRB,2.4618E+01_JPRB,2.6646E+01_JPRB/)
KBO( :, 2,32,13) = (/&
&1.2587E+01_JPRB,1.2580E+01_JPRB,1.3324E+01_JPRB,1.9233E+01_JPRB,2.3679E+01_JPRB,2.5689E+01_JPRB/)
KBO( :, 3,32,13) = (/&
&1.3218E+01_JPRB,1.3210E+01_JPRB,1.3094E+01_JPRB,1.8557E+01_JPRB,2.2722E+01_JPRB,2.4678E+01_JPRB/)
KBO( :, 4,32,13) = (/&
&1.3914E+01_JPRB,1.3907E+01_JPRB,1.2978E+01_JPRB,1.7906E+01_JPRB,2.1782E+01_JPRB,2.3743E+01_JPRB/)
KBO( :, 5,32,13) = (/&
&1.4655E+01_JPRB,1.4646E+01_JPRB,1.2957E+01_JPRB,1.7249E+01_JPRB,2.0874E+01_JPRB,2.2925E+01_JPRB/)
KBO( :, 1,33,13) = (/&
&1.1069E+01_JPRB,1.1063E+01_JPRB,1.3365E+01_JPRB,2.0106E+01_JPRB,2.5097E+01_JPRB,2.7267E+01_JPRB/)
KBO( :, 2,33,13) = (/&
&1.1756E+01_JPRB,1.1750E+01_JPRB,1.3070E+01_JPRB,1.9396E+01_JPRB,2.4095E+01_JPRB,2.6242E+01_JPRB/)
KBO( :, 3,33,13) = (/&
&1.2532E+01_JPRB,1.2525E+01_JPRB,1.2868E+01_JPRB,1.8687E+01_JPRB,2.3087E+01_JPRB,2.5240E+01_JPRB/)
KBO( :, 4,33,13) = (/&
&1.3360E+01_JPRB,1.3352E+01_JPRB,1.2765E+01_JPRB,1.8010E+01_JPRB,2.2099E+01_JPRB,2.4405E+01_JPRB/)
KBO( :, 5,33,13) = (/&
&1.4221E+01_JPRB,1.4213E+01_JPRB,1.2776E+01_JPRB,1.7337E+01_JPRB,2.1144E+01_JPRB,2.3571E+01_JPRB/)
KBO( :, 1,34,13) = (/&
&1.0330E+01_JPRB,1.0325E+01_JPRB,1.3170E+01_JPRB,2.0275E+01_JPRB,2.5492E+01_JPRB,2.7791E+01_JPRB/)
KBO( :, 2,34,13) = (/&
&1.1144E+01_JPRB,1.1137E+01_JPRB,1.2897E+01_JPRB,1.9532E+01_JPRB,2.4430E+01_JPRB,2.6740E+01_JPRB/)
KBO( :, 3,34,13) = (/&
&1.2039E+01_JPRB,1.2032E+01_JPRB,1.2723E+01_JPRB,1.8800E+01_JPRB,2.3383E+01_JPRB,2.5842E+01_JPRB/)
KBO( :, 4,34,13) = (/&
&1.2978E+01_JPRB,1.2971E+01_JPRB,1.2635E+01_JPRB,1.8099E+01_JPRB,2.2352E+01_JPRB,2.4982E+01_JPRB/)
KBO( :, 5,34,13) = (/&
&1.3934E+01_JPRB,1.3926E+01_JPRB,1.2668E+01_JPRB,1.7413E+01_JPRB,2.1361E+01_JPRB,2.4094E+01_JPRB/)
KBO( :, 1,35,13) = (/&
&9.7254E+00_JPRB,9.7201E+00_JPRB,1.3055E+01_JPRB,2.0467E+01_JPRB,2.5890E+01_JPRB,2.8316E+01_JPRB/)
KBO( :, 2,35,13) = (/&
&1.0642E+01_JPRB,1.0636E+01_JPRB,1.2799E+01_JPRB,1.9691E+01_JPRB,2.4776E+01_JPRB,2.7321E+01_JPRB/)
KBO( :, 3,35,13) = (/&
&1.1630E+01_JPRB,1.1624E+01_JPRB,1.2635E+01_JPRB,1.8939E+01_JPRB,2.3691E+01_JPRB,2.6463E+01_JPRB/)
KBO( :, 4,35,13) = (/&
&1.2660E+01_JPRB,1.2653E+01_JPRB,1.2560E+01_JPRB,1.8216E+01_JPRB,2.2621E+01_JPRB,2.5557E+01_JPRB/)
KBO( :, 5,35,13) = (/&
&1.3686E+01_JPRB,1.3678E+01_JPRB,1.2601E+01_JPRB,1.7514E+01_JPRB,2.1598E+01_JPRB,2.4647E+01_JPRB/)
KBO( :, 1,36,13) = (/&
&9.1824E+00_JPRB,9.1775E+00_JPRB,1.3014E+01_JPRB,2.0702E+01_JPRB,2.6319E+01_JPRB,2.8897E+01_JPRB/)
KBO( :, 2,36,13) = (/&
&1.0178E+01_JPRB,1.0173E+01_JPRB,1.2753E+01_JPRB,1.9897E+01_JPRB,2.5164E+01_JPRB,2.7977E+01_JPRB/)
KBO( :, 3,36,13) = (/&
&1.1240E+01_JPRB,1.1234E+01_JPRB,1.2589E+01_JPRB,1.9121E+01_JPRB,2.4043E+01_JPRB,2.7098E+01_JPRB/)
KBO( :, 4,36,13) = (/&
&1.2332E+01_JPRB,1.2325E+01_JPRB,1.2520E+01_JPRB,1.8377E+01_JPRB,2.2938E+01_JPRB,2.6162E+01_JPRB/)
KBO( :, 5,36,13) = (/&
&1.3423E+01_JPRB,1.3415E+01_JPRB,1.2563E+01_JPRB,1.7662E+01_JPRB,2.1883E+01_JPRB,2.5220E+01_JPRB/)
KBO( :, 1,37,13) = (/&
&8.6099E+00_JPRB,8.6053E+00_JPRB,1.3043E+01_JPRB,2.1019E+01_JPRB,2.6856E+01_JPRB,2.9568E+01_JPRB/)
KBO( :, 2,37,13) = (/&
&9.6546E+00_JPRB,9.6493E+00_JPRB,1.2762E+01_JPRB,2.0197E+01_JPRB,2.5667E+01_JPRB,2.8665E+01_JPRB/)
KBO( :, 3,37,13) = (/&
&1.0769E+01_JPRB,1.0763E+01_JPRB,1.2583E+01_JPRB,1.9394E+01_JPRB,2.4509E+01_JPRB,2.7775E+01_JPRB/)
KBO( :, 4,37,13) = (/&
&1.1910E+01_JPRB,1.1903E+01_JPRB,1.2502E+01_JPRB,1.8624E+01_JPRB,2.3371E+01_JPRB,2.6796E+01_JPRB/)
KBO( :, 5,37,13) = (/&
&1.3054E+01_JPRB,1.3047E+01_JPRB,1.2531E+01_JPRB,1.7890E+01_JPRB,2.2279E+01_JPRB,2.5830E+01_JPRB/)
KBO( :, 1,38,13) = (/&
&8.1124E+00_JPRB,8.1081E+00_JPRB,1.3090E+01_JPRB,2.1323E+01_JPRB,2.7354E+01_JPRB,3.0221E+01_JPRB/)
KBO( :, 2,38,13) = (/&
&9.1955E+00_JPRB,9.1905E+00_JPRB,1.2789E+01_JPRB,2.0480E+01_JPRB,2.6132E+01_JPRB,2.9338E+01_JPRB/)
KBO( :, 3,38,13) = (/&
&1.0346E+01_JPRB,1.0340E+01_JPRB,1.2594E+01_JPRB,1.9657E+01_JPRB,2.4940E+01_JPRB,2.8430E+01_JPRB/)
KBO( :, 4,38,13) = (/&
&1.1526E+01_JPRB,1.1520E+01_JPRB,1.2499E+01_JPRB,1.8864E+01_JPRB,2.3774E+01_JPRB,2.7417E+01_JPRB/)
KBO( :, 5,38,13) = (/&
&1.2710E+01_JPRB,1.2703E+01_JPRB,1.2513E+01_JPRB,1.8110E+01_JPRB,2.2651E+01_JPRB,2.6428E+01_JPRB/)
KBO( :, 1,39,13) = (/&
&7.6875E+00_JPRB,7.6835E+00_JPRB,1.3146E+01_JPRB,2.1600E+01_JPRB,2.7801E+01_JPRB,3.0872E+01_JPRB/)
KBO( :, 2,39,13) = (/&
&8.7929E+00_JPRB,8.7882E+00_JPRB,1.2830E+01_JPRB,2.0739E+01_JPRB,2.6556E+01_JPRB,3.0007E+01_JPRB/)
KBO( :, 3,39,13) = (/&
&9.9744E+00_JPRB,9.9689E+00_JPRB,1.2617E+01_JPRB,1.9901E+01_JPRB,2.5334E+01_JPRB,2.9071E+01_JPRB/)
KBO( :, 4,39,13) = (/&
&1.1184E+01_JPRB,1.1178E+01_JPRB,1.2503E+01_JPRB,1.9085E+01_JPRB,2.4144E+01_JPRB,2.8025E+01_JPRB/)
KBO( :, 5,39,13) = (/&
&1.2397E+01_JPRB,1.2390E+01_JPRB,1.2501E+01_JPRB,1.8314E+01_JPRB,2.2991E+01_JPRB,2.7022E+01_JPRB/)
KBO( :, 1,40,13) = (/&
&7.2073E+00_JPRB,7.2036E+00_JPRB,1.3244E+01_JPRB,2.1941E+01_JPRB,2.8335E+01_JPRB,3.1477E+01_JPRB/)
KBO( :, 2,40,13) = (/&
&8.3183E+00_JPRB,8.3138E+00_JPRB,1.2905E+01_JPRB,2.1071E+01_JPRB,2.7076E+01_JPRB,3.0598E+01_JPRB/)
KBO( :, 3,40,13) = (/&
&9.5140E+00_JPRB,9.5088E+00_JPRB,1.2663E+01_JPRB,2.0213E+01_JPRB,2.5823E+01_JPRB,2.9671E+01_JPRB/)
KBO( :, 4,40,13) = (/&
&1.0744E+01_JPRB,1.0738E+01_JPRB,1.2520E+01_JPRB,1.9377E+01_JPRB,2.4607E+01_JPRB,2.8610E+01_JPRB/)
KBO( :, 5,40,13) = (/&
&1.1983E+01_JPRB,1.1976E+01_JPRB,1.2493E+01_JPRB,1.8588E+01_JPRB,2.3425E+01_JPRB,2.7600E+01_JPRB/)
KBO( :, 1,41,13) = (/&
&6.7611E+00_JPRB,6.7576E+00_JPRB,1.3349E+01_JPRB,2.2280E+01_JPRB,2.8859E+01_JPRB,3.2049E+01_JPRB/)
KBO( :, 2,41,13) = (/&
&7.8674E+00_JPRB,7.8632E+00_JPRB,1.2993E+01_JPRB,2.1395E+01_JPRB,2.7586E+01_JPRB,3.1155E+01_JPRB/)
KBO( :, 3,41,13) = (/&
&9.0665E+00_JPRB,9.0616E+00_JPRB,1.2725E+01_JPRB,2.0522E+01_JPRB,2.6310E+01_JPRB,3.0246E+01_JPRB/)
KBO( :, 4,41,13) = (/&
&1.0311E+01_JPRB,1.0306E+01_JPRB,1.2549E+01_JPRB,1.9674E+01_JPRB,2.5066E+01_JPRB,2.9176E+01_JPRB/)
KBO( :, 5,41,13) = (/&
&1.1568E+01_JPRB,1.1562E+01_JPRB,1.2494E+01_JPRB,1.8859E+01_JPRB,2.3856E+01_JPRB,2.8161E+01_JPRB/)
KBO( :, 1,42,13) = (/&
&6.3548E+00_JPRB,6.3515E+00_JPRB,1.3456E+01_JPRB,2.2608E+01_JPRB,2.9366E+01_JPRB,3.2606E+01_JPRB/)
KBO( :, 2,42,13) = (/&
&7.4451E+00_JPRB,7.4412E+00_JPRB,1.3085E+01_JPRB,2.1711E+01_JPRB,2.8070E+01_JPRB,3.1692E+01_JPRB/)
KBO( :, 3,42,13) = (/&
&8.6411E+00_JPRB,8.6364E+00_JPRB,1.2793E+01_JPRB,2.0822E+01_JPRB,2.6779E+01_JPRB,3.0806E+01_JPRB/)
KBO( :, 4,42,13) = (/&
&9.8929E+00_JPRB,9.8874E+00_JPRB,1.2589E+01_JPRB,1.9962E+01_JPRB,2.5511E+01_JPRB,2.9730E+01_JPRB/)
KBO( :, 5,42,13) = (/&
&1.1166E+01_JPRB,1.1160E+01_JPRB,1.2501E+01_JPRB,1.9127E+01_JPRB,2.4277E+01_JPRB,2.8718E+01_JPRB/)
KBO( :, 1,43,13) = (/&
&5.9236E+00_JPRB,5.9206E+00_JPRB,1.3597E+01_JPRB,2.2980E+01_JPRB,2.9923E+01_JPRB,3.3179E+01_JPRB/)
KBO( :, 2,43,13) = (/&
&6.9885E+00_JPRB,6.9848E+00_JPRB,1.3206E+01_JPRB,2.2070E+01_JPRB,2.8607E+01_JPRB,3.2249E+01_JPRB/)
KBO( :, 3,43,13) = (/&
&8.1682E+00_JPRB,8.1638E+00_JPRB,1.2880E+01_JPRB,2.1165E+01_JPRB,2.7304E+01_JPRB,3.1388E+01_JPRB/)
KBO( :, 4,43,13) = (/&
&9.4211E+00_JPRB,9.4159E+00_JPRB,1.2650E+01_JPRB,2.0290E+01_JPRB,2.6012E+01_JPRB,3.0330E+01_JPRB/)
KBO( :, 5,43,13) = (/&
&1.0699E+01_JPRB,1.0693E+01_JPRB,1.2520E+01_JPRB,1.9438E+01_JPRB,2.4759E+01_JPRB,2.9317E+01_JPRB/)
KBO( :, 1,44,13) = (/&
&5.4998E+00_JPRB,5.4970E+00_JPRB,1.3748E+01_JPRB,2.3364E+01_JPRB,3.0492E+01_JPRB,3.3756E+01_JPRB/)
KBO( :, 2,44,13) = (/&
&6.5311E+00_JPRB,6.5277E+00_JPRB,1.3340E+01_JPRB,2.2442E+01_JPRB,2.9167E+01_JPRB,3.2820E+01_JPRB/)
KBO( :, 3,44,13) = (/&
&7.6857E+00_JPRB,7.6816E+00_JPRB,1.2985E+01_JPRB,2.1531E+01_JPRB,2.7848E+01_JPRB,3.1979E+01_JPRB/)
KBO( :, 4,44,13) = (/&
&8.9256E+00_JPRB,8.9207E+00_JPRB,1.2724E+01_JPRB,2.0635E+01_JPRB,2.6540E+01_JPRB,3.0955E+01_JPRB/)
KBO( :, 5,44,13) = (/&
&1.0209E+01_JPRB,1.0203E+01_JPRB,1.2556E+01_JPRB,1.9768E+01_JPRB,2.5264E+01_JPRB,2.9937E+01_JPRB/)
KBO( :, 1,45,13) = (/&
&5.1066E+00_JPRB,5.1040E+00_JPRB,1.3894E+01_JPRB,2.3735E+01_JPRB,3.1041E+01_JPRB,3.4324E+01_JPRB/)
KBO( :, 2,45,13) = (/&
&6.1015E+00_JPRB,6.0983E+00_JPRB,1.3484E+01_JPRB,2.2813E+01_JPRB,2.9715E+01_JPRB,3.3401E+01_JPRB/)
KBO( :, 3,45,13) = (/&
&7.2220E+00_JPRB,7.2182E+00_JPRB,1.3105E+01_JPRB,2.1889E+01_JPRB,2.8383E+01_JPRB,3.2574E+01_JPRB/)
KBO( :, 4,45,13) = (/&
&8.4438E+00_JPRB,8.4392E+00_JPRB,1.2807E+01_JPRB,2.0975E+01_JPRB,2.7061E+01_JPRB,3.1594E+01_JPRB/)
KBO( :, 5,45,13) = (/&
&9.7243E+00_JPRB,9.7189E+00_JPRB,1.2602E+01_JPRB,2.0098E+01_JPRB,2.5763E+01_JPRB,3.0584E+01_JPRB/)
KBO( :, 1,46,13) = (/&
&4.7235E+00_JPRB,4.7212E+00_JPRB,1.4046E+01_JPRB,2.4121E+01_JPRB,3.1588E+01_JPRB,3.4885E+01_JPRB/)
KBO( :, 2,46,13) = (/&
&5.6742E+00_JPRB,5.6713E+00_JPRB,1.3640E+01_JPRB,2.3201E+01_JPRB,3.0277E+01_JPRB,3.3993E+01_JPRB/)
KBO( :, 3,46,13) = (/&
&6.7562E+00_JPRB,6.7526E+00_JPRB,1.3243E+01_JPRB,2.2266E+01_JPRB,2.8936E+01_JPRB,3.3171E+01_JPRB/)
KBO( :, 4,46,13) = (/&
&7.9500E+00_JPRB,7.9457E+00_JPRB,1.2906E+01_JPRB,2.1341E+01_JPRB,2.7604E+01_JPRB,3.2255E+01_JPRB/)
KBO( :, 5,46,13) = (/&
&9.2204E+00_JPRB,9.2153E+00_JPRB,1.2671E+01_JPRB,2.0448E+01_JPRB,2.6287E+01_JPRB,3.1265E+01_JPRB/)
KBO( :, 1,47,13) = (/&
&4.3300E+00_JPRB,4.3280E+00_JPRB,1.4218E+01_JPRB,2.4532E+01_JPRB,3.2164E+01_JPRB,3.5437E+01_JPRB/)
KBO( :, 2,47,13) = (/&
&5.2306E+00_JPRB,5.2279E+00_JPRB,1.3812E+01_JPRB,2.3616E+01_JPRB,3.0887E+01_JPRB,3.4582E+01_JPRB/)
KBO( :, 3,47,13) = (/&
&6.2646E+00_JPRB,6.2614E+00_JPRB,1.3402E+01_JPRB,2.2678E+01_JPRB,2.9542E+01_JPRB,3.3739E+01_JPRB/)
KBO( :, 4,47,13) = (/&
&7.4192E+00_JPRB,7.4152E+00_JPRB,1.3037E+01_JPRB,2.1748E+01_JPRB,2.8196E+01_JPRB,3.2920E+01_JPRB/)
KBO( :, 5,47,13) = (/&
&8.6683E+00_JPRB,8.6636E+00_JPRB,1.2760E+01_JPRB,2.0830E+01_JPRB,2.6867E+01_JPRB,3.1949E+01_JPRB/)
KBO( :, 1,48,13) = (/&
&3.9563E+00_JPRB,3.9545E+00_JPRB,1.4390E+01_JPRB,2.4924E+01_JPRB,3.2712E+01_JPRB,3.5975E+01_JPRB/)
KBO( :, 2,48,13) = (/&
&4.8163E+00_JPRB,4.8139E+00_JPRB,1.3982E+01_JPRB,2.4022E+01_JPRB,3.1475E+01_JPRB,3.5176E+01_JPRB/)
KBO( :, 3,48,13) = (/&
&5.7995E+00_JPRB,5.7966E+00_JPRB,1.3571E+01_JPRB,2.3093E+01_JPRB,3.0140E+01_JPRB,3.4333E+01_JPRB/)
KBO( :, 4,48,13) = (/&
&6.9101E+00_JPRB,6.9064E+00_JPRB,1.3183E+01_JPRB,2.2151E+01_JPRB,2.8787E+01_JPRB,3.3609E+01_JPRB/)
KBO( :, 5,48,13) = (/&
&8.1290E+00_JPRB,8.1246E+00_JPRB,1.2862E+01_JPRB,2.1218E+01_JPRB,2.7446E+01_JPRB,3.2685E+01_JPRB/)
KBO( :, 1,49,13) = (/&
&3.6095E+00_JPRB,3.6078E+00_JPRB,1.4558E+01_JPRB,2.5296E+01_JPRB,3.3234E+01_JPRB,3.6504E+01_JPRB/)
KBO( :, 2,49,13) = (/&
&4.4271E+00_JPRB,4.4249E+00_JPRB,1.4150E+01_JPRB,2.4423E+01_JPRB,3.2036E+01_JPRB,3.5772E+01_JPRB/)
KBO( :, 3,49,13) = (/&
&5.3603E+00_JPRB,5.3576E+00_JPRB,1.3742E+01_JPRB,2.3500E+01_JPRB,3.0731E+01_JPRB,3.4966E+01_JPRB/)
KBO( :, 4,49,13) = (/&
&6.4234E+00_JPRB,6.4201E+00_JPRB,1.3335E+01_JPRB,2.2553E+01_JPRB,2.9376E+01_JPRB,3.4358E+01_JPRB/)
KBO( :, 5,49,13) = (/&
&7.6032E+00_JPRB,7.5991E+00_JPRB,1.2984E+01_JPRB,2.1616E+01_JPRB,2.8020E+01_JPRB,3.3502E+01_JPRB/)
KBO( :, 1,50,13) = (/&
&3.3075E+00_JPRB,3.3060E+00_JPRB,1.4713E+01_JPRB,2.5635E+01_JPRB,3.3698E+01_JPRB,3.6916E+01_JPRB/)
KBO( :, 2,50,13) = (/&
&4.0785E+00_JPRB,4.0766E+00_JPRB,1.4310E+01_JPRB,2.4788E+01_JPRB,3.2546E+01_JPRB,3.6251E+01_JPRB/)
KBO( :, 3,50,13) = (/&
&4.9697E+00_JPRB,4.9672E+00_JPRB,1.3904E+01_JPRB,2.3873E+01_JPRB,3.1275E+01_JPRB,3.5481E+01_JPRB/)
KBO( :, 4,50,13) = (/&
&5.9880E+00_JPRB,5.9849E+00_JPRB,1.3488E+01_JPRB,2.2931E+01_JPRB,2.9923E+01_JPRB,3.4946E+01_JPRB/)
KBO( :, 5,50,13) = (/&
&7.1253E+00_JPRB,7.1215E+00_JPRB,1.3112E+01_JPRB,2.1989E+01_JPRB,2.8565E+01_JPRB,3.4166E+01_JPRB/)
KBO( :, 1,51,13) = (/&
&3.0350E+00_JPRB,3.0337E+00_JPRB,1.4851E+01_JPRB,2.5935E+01_JPRB,3.4107E+01_JPRB,3.7237E+01_JPRB/)
KBO( :, 2,51,13) = (/&
&3.7587E+00_JPRB,3.7569E+00_JPRB,1.4465E+01_JPRB,2.5129E+01_JPRB,3.3019E+01_JPRB,3.6650E+01_JPRB/)
KBO( :, 3,51,13) = (/&
&4.6142E+00_JPRB,4.6119E+00_JPRB,1.4053E+01_JPRB,2.4233E+01_JPRB,3.1785E+01_JPRB,3.5945E+01_JPRB/)
KBO( :, 4,51,13) = (/&
&5.5848E+00_JPRB,5.5820E+00_JPRB,1.3644E+01_JPRB,2.3300E+01_JPRB,3.0450E+01_JPRB,3.5428E+01_JPRB/)
KBO( :, 5,51,13) = (/&
&6.6798E+00_JPRB,6.6762E+00_JPRB,1.3245E+01_JPRB,2.2350E+01_JPRB,2.9088E+01_JPRB,3.4747E+01_JPRB/)
KBO( :, 1,52,13) = (/&
&2.7825E+00_JPRB,2.7814E+00_JPRB,1.4975E+01_JPRB,2.6195E+01_JPRB,3.4492E+01_JPRB,3.7510E+01_JPRB/)
KBO( :, 2,52,13) = (/&
&3.4605E+00_JPRB,3.4589E+00_JPRB,1.4616E+01_JPRB,2.5455E+01_JPRB,3.3469E+01_JPRB,3.7042E+01_JPRB/)
KBO( :, 3,52,13) = (/&
&4.2744E+00_JPRB,4.2723E+00_JPRB,1.4207E+01_JPRB,2.4585E+01_JPRB,3.2279E+01_JPRB,3.6429E+01_JPRB/)
KBO( :, 4,52,13) = (/&
&5.1994E+00_JPRB,5.1968E+00_JPRB,1.3797E+01_JPRB,2.3661E+01_JPRB,3.0975E+01_JPRB,3.5933E+01_JPRB/)
KBO( :, 5,52,13) = (/&
&6.2531E+00_JPRB,6.2499E+00_JPRB,1.3386E+01_JPRB,2.2706E+01_JPRB,2.9608E+01_JPRB,3.5360E+01_JPRB/)
KBO( :, 1,53,13) = (/&
&2.5462E+00_JPRB,2.5451E+00_JPRB,1.5076E+01_JPRB,2.6414E+01_JPRB,3.4840E+01_JPRB,3.7769E+01_JPRB/)
KBO( :, 2,53,13) = (/&
&3.1815E+00_JPRB,3.1801E+00_JPRB,1.4759E+01_JPRB,2.5766E+01_JPRB,3.3894E+01_JPRB,3.7437E+01_JPRB/)
KBO( :, 3,53,13) = (/&
&3.9476E+00_JPRB,3.9457E+00_JPRB,1.4361E+01_JPRB,2.4924E+01_JPRB,3.2751E+01_JPRB,3.6936E+01_JPRB/)
KBO( :, 4,53,13) = (/&
&4.8360E+00_JPRB,4.8336E+00_JPRB,1.3950E+01_JPRB,2.4012E+01_JPRB,3.1482E+01_JPRB,3.6505E+01_JPRB/)
KBO( :, 5,53,13) = (/&
&5.8444E+00_JPRB,5.8414E+00_JPRB,1.3535E+01_JPRB,2.3068E+01_JPRB,3.0128E+01_JPRB,3.6046E+01_JPRB/)
KBO( :, 1,54,13) = (/&
&2.3476E+00_JPRB,2.3467E+00_JPRB,1.5163E+01_JPRB,2.6598E+01_JPRB,3.5117E+01_JPRB,3.7852E+01_JPRB/)
KBO( :, 2,54,13) = (/&
&2.9439E+00_JPRB,2.9426E+00_JPRB,1.4884E+01_JPRB,2.6029E+01_JPRB,3.4253E+01_JPRB,3.7637E+01_JPRB/)
KBO( :, 3,54,13) = (/&
&3.6641E+00_JPRB,3.6624E+00_JPRB,1.4503E+01_JPRB,2.5231E+01_JPRB,3.3172E+01_JPRB,3.7161E+01_JPRB/)
KBO( :, 4,54,13) = (/&
&4.5193E+00_JPRB,4.5171E+00_JPRB,1.4088E+01_JPRB,2.4334E+01_JPRB,3.1938E+01_JPRB,3.6656E+01_JPRB/)
KBO( :, 5,54,13) = (/&
&5.4838E+00_JPRB,5.4810E+00_JPRB,1.3677E+01_JPRB,2.3400E+01_JPRB,3.0603E+01_JPRB,3.6329E+01_JPRB/)
KBO( :, 1,55,13) = (/&
&2.1710E+00_JPRB,2.1701E+00_JPRB,1.5234E+01_JPRB,2.6747E+01_JPRB,3.5339E+01_JPRB,3.7885E+01_JPRB/)
KBO( :, 2,55,13) = (/&
&2.7278E+00_JPRB,2.7266E+00_JPRB,1.4989E+01_JPRB,2.6245E+01_JPRB,3.4579E+01_JPRB,3.7689E+01_JPRB/)
KBO( :, 3,55,13) = (/&
&3.4082E+00_JPRB,3.4067E+00_JPRB,1.4633E+01_JPRB,2.5510E+01_JPRB,3.3556E+01_JPRB,3.7242E+01_JPRB/)
KBO( :, 4,55,13) = (/&
&4.2238E+00_JPRB,4.2218E+00_JPRB,1.4223E+01_JPRB,2.4639E+01_JPRB,3.2363E+01_JPRB,3.6666E+01_JPRB/)
KBO( :, 5,55,13) = (/&
&5.1513E+00_JPRB,5.1487E+00_JPRB,1.3812E+01_JPRB,2.3712E+01_JPRB,3.1057E+01_JPRB,3.6276E+01_JPRB/)
KBO( :, 1,56,13) = (/&
&2.0079E+00_JPRB,2.0070E+00_JPRB,1.5283E+01_JPRB,2.6864E+01_JPRB,3.5527E+01_JPRB,3.7901E+01_JPRB/)
KBO( :, 2,56,13) = (/&
&2.5254E+00_JPRB,2.5243E+00_JPRB,1.5077E+01_JPRB,2.6433E+01_JPRB,3.4877E+01_JPRB,3.7697E+01_JPRB/)
KBO( :, 3,56,13) = (/&
&3.1684E+00_JPRB,3.1669E+00_JPRB,1.4757E+01_JPRB,2.5780E+01_JPRB,3.3923E+01_JPRB,3.7342E+01_JPRB/)
KBO( :, 4,56,13) = (/&
&3.9407E+00_JPRB,3.9388E+00_JPRB,1.4357E+01_JPRB,2.4934E+01_JPRB,3.2773E+01_JPRB,3.6769E+01_JPRB/)
KBO( :, 5,56,13) = (/&
&4.8364E+00_JPRB,4.8339E+00_JPRB,1.3945E+01_JPRB,2.4018E+01_JPRB,3.1497E+01_JPRB,3.6172E+01_JPRB/)
KBO( :, 1,57,13) = (/&
&1.8578E+00_JPRB,1.8569E+00_JPRB,1.5303E+01_JPRB,2.6949E+01_JPRB,3.5653E+01_JPRB,3.7877E+01_JPRB/)
KBO( :, 2,57,13) = (/&
&2.3391E+00_JPRB,2.3382E+00_JPRB,1.5160E+01_JPRB,2.6604E+01_JPRB,3.5134E+01_JPRB,3.7763E+01_JPRB/)
KBO( :, 3,57,13) = (/&
&2.9439E+00_JPRB,2.9426E+00_JPRB,1.4876E+01_JPRB,2.6028E+01_JPRB,3.4258E+01_JPRB,3.7439E+01_JPRB/)
KBO( :, 4,57,13) = (/&
&3.6722E+00_JPRB,3.6705E+00_JPRB,1.4492E+01_JPRB,2.5221E+01_JPRB,3.3167E+01_JPRB,3.6862E+01_JPRB/)
KBO( :, 5,57,13) = (/&
&4.5340E+00_JPRB,4.5318E+00_JPRB,1.4076E+01_JPRB,2.4322E+01_JPRB,3.1926E+01_JPRB,3.6169E+01_JPRB/)
KBO( :, 1,58,13) = (/&
&1.7257E+00_JPRB,1.7249E+00_JPRB,1.5300E+01_JPRB,2.6987E+01_JPRB,3.5715E+01_JPRB,3.7771E+01_JPRB/)
KBO( :, 2,58,13) = (/&
&2.1747E+00_JPRB,2.1738E+00_JPRB,1.5228E+01_JPRB,2.6747E+01_JPRB,3.5343E+01_JPRB,3.7835E+01_JPRB/)
KBO( :, 3,58,13) = (/&
&2.7413E+00_JPRB,2.7402E+00_JPRB,1.4977E+01_JPRB,2.6232E+01_JPRB,3.4563E+01_JPRB,3.7436E+01_JPRB/)
KBO( :, 4,58,13) = (/&
&3.4316E+00_JPRB,3.4300E+00_JPRB,1.4616E+01_JPRB,2.5484E+01_JPRB,3.3527E+01_JPRB,3.6930E+01_JPRB/)
KBO( :, 5,58,13) = (/&
&4.2563E+00_JPRB,4.2542E+00_JPRB,1.4203E+01_JPRB,2.4608E+01_JPRB,3.2326E+01_JPRB,3.6245E+01_JPRB/)
KBO( :, 1,59,13) = (/&
&1.6718E+00_JPRB,1.6710E+00_JPRB,1.5295E+01_JPRB,2.6993E+01_JPRB,3.5730E+01_JPRB,3.7608E+01_JPRB/)
KBO( :, 2,59,13) = (/&
&2.1089E+00_JPRB,2.1080E+00_JPRB,1.5254E+01_JPRB,2.6799E+01_JPRB,3.5425E+01_JPRB,3.7786E+01_JPRB/)
KBO( :, 3,59,13) = (/&
&2.6604E+00_JPRB,2.6594E+00_JPRB,1.5013E+01_JPRB,2.6309E+01_JPRB,3.4684E+01_JPRB,3.7341E+01_JPRB/)
KBO( :, 4,59,13) = (/&
&3.3364E+00_JPRB,3.3349E+00_JPRB,1.4664E+01_JPRB,2.5591E+01_JPRB,3.3675E+01_JPRB,3.6669E+01_JPRB/)
KBO( :, 5,59,13) = (/&
&4.1451E+00_JPRB,4.1431E+00_JPRB,1.4254E+01_JPRB,2.4723E+01_JPRB,3.2485E+01_JPRB,3.5871E+01_JPRB/)
KBO( :, 1,13,14) = (/&
&2.9867E+01_JPRB,2.9850E+01_JPRB,2.2813E+01_JPRB,1.5747E+01_JPRB,8.6461E+00_JPRB,6.6277E+00_JPRB/)
KBO( :, 2,13,14) = (/&
&2.8970E+01_JPRB,2.8953E+01_JPRB,2.2112E+01_JPRB,1.5258E+01_JPRB,8.4453E+00_JPRB,6.4752E+00_JPRB/)
KBO( :, 3,13,14) = (/&
&2.8231E+01_JPRB,2.8215E+01_JPRB,2.1546E+01_JPRB,1.4872E+01_JPRB,8.2664E+00_JPRB,6.3900E+00_JPRB/)
KBO( :, 4,13,14) = (/&
&2.7643E+01_JPRB,2.7627E+01_JPRB,2.1093E+01_JPRB,1.4551E+01_JPRB,8.1037E+00_JPRB,6.4058E+00_JPRB/)
KBO( :, 5,13,14) = (/&
&2.7121E+01_JPRB,2.7106E+01_JPRB,2.0679E+01_JPRB,1.4264E+01_JPRB,7.9370E+00_JPRB,6.4632E+00_JPRB/)
KBO( :, 1,14,14) = (/&
&3.1721E+01_JPRB,3.1703E+01_JPRB,2.4198E+01_JPRB,1.6672E+01_JPRB,9.2683E+00_JPRB,7.3049E+00_JPRB/)
KBO( :, 2,14,14) = (/&
&3.1076E+01_JPRB,3.1058E+01_JPRB,2.3689E+01_JPRB,1.6337E+01_JPRB,9.1193E+00_JPRB,7.0508E+00_JPRB/)
KBO( :, 3,14,14) = (/&
&3.0563E+01_JPRB,3.0546E+01_JPRB,2.3305E+01_JPRB,1.6071E+01_JPRB,8.9743E+00_JPRB,6.8812E+00_JPRB/)
KBO( :, 4,14,14) = (/&
&3.0148E+01_JPRB,3.0131E+01_JPRB,2.2977E+01_JPRB,1.5835E+01_JPRB,8.8320E+00_JPRB,6.7605E+00_JPRB/)
KBO( :, 5,14,14) = (/&
&2.9764E+01_JPRB,2.9747E+01_JPRB,2.2687E+01_JPRB,1.5631E+01_JPRB,8.6858E+00_JPRB,6.7365E+00_JPRB/)
KBO( :, 1,15,14) = (/&
&3.4331E+01_JPRB,3.4311E+01_JPRB,2.6139E+01_JPRB,1.7967E+01_JPRB,1.0028E+01_JPRB,8.1321E+00_JPRB/)
KBO( :, 2,15,14) = (/&
&3.3952E+01_JPRB,3.3933E+01_JPRB,2.5854E+01_JPRB,1.7780E+01_JPRB,9.9136E+00_JPRB,7.8472E+00_JPRB/)
KBO( :, 3,15,14) = (/&
&3.3650E+01_JPRB,3.3631E+01_JPRB,2.5615E+01_JPRB,1.7601E+01_JPRB,9.7954E+00_JPRB,7.6157E+00_JPRB/)
KBO( :, 4,15,14) = (/&
&3.3344E+01_JPRB,3.3325E+01_JPRB,2.5376E+01_JPRB,1.7433E+01_JPRB,9.6656E+00_JPRB,7.3952E+00_JPRB/)
KBO( :, 5,15,14) = (/&
&3.3055E+01_JPRB,3.3036E+01_JPRB,2.5149E+01_JPRB,1.7257E+01_JPRB,9.5339E+00_JPRB,7.2585E+00_JPRB/)
KBO( :, 1,16,14) = (/&
&3.7768E+01_JPRB,3.7746E+01_JPRB,2.8736E+01_JPRB,1.9717E+01_JPRB,1.0946E+01_JPRB,9.0577E+00_JPRB/)
KBO( :, 2,16,14) = (/&
&3.7568E+01_JPRB,3.7546E+01_JPRB,2.8561E+01_JPRB,1.9575E+01_JPRB,1.0848E+01_JPRB,8.7437E+00_JPRB/)
KBO( :, 3,16,14) = (/&
&3.7327E+01_JPRB,3.7305E+01_JPRB,2.8371E+01_JPRB,1.9439E+01_JPRB,1.0735E+01_JPRB,8.4668E+00_JPRB/)
KBO( :, 4,16,14) = (/&
&3.7089E+01_JPRB,3.7067E+01_JPRB,2.8181E+01_JPRB,1.9291E+01_JPRB,1.0617E+01_JPRB,8.2419E+00_JPRB/)
KBO( :, 5,16,14) = (/&
&3.6772E+01_JPRB,3.6751E+01_JPRB,2.7932E+01_JPRB,1.9114E+01_JPRB,1.0484E+01_JPRB,8.0316E+00_JPRB/)
KBO( :, 1,17,14) = (/&
&4.1800E+01_JPRB,4.1776E+01_JPRB,3.1755E+01_JPRB,2.1740E+01_JPRB,1.2078E+01_JPRB,1.0093E+01_JPRB/)
KBO( :, 2,17,14) = (/&
&4.1678E+01_JPRB,4.1653E+01_JPRB,3.1650E+01_JPRB,2.1659E+01_JPRB,1.1979E+01_JPRB,9.7654E+00_JPRB/)
KBO( :, 3,17,14) = (/&
&4.1542E+01_JPRB,4.1518E+01_JPRB,3.1528E+01_JPRB,2.1552E+01_JPRB,1.1863E+01_JPRB,9.4632E+00_JPRB/)
KBO( :, 4,17,14) = (/&
&4.1281E+01_JPRB,4.1257E+01_JPRB,3.1316E+01_JPRB,2.1389E+01_JPRB,1.1731E+01_JPRB,9.2257E+00_JPRB/)
KBO( :, 5,17,14) = (/&
&4.1001E+01_JPRB,4.0977E+01_JPRB,3.1090E+01_JPRB,2.1207E+01_JPRB,1.1579E+01_JPRB,8.9705E+00_JPRB/)
KBO( :, 1,18,14) = (/&
&4.6476E+01_JPRB,4.6449E+01_JPRB,3.5262E+01_JPRB,2.4079E+01_JPRB,1.3398E+01_JPRB,1.1310E+01_JPRB/)
KBO( :, 2,18,14) = (/&
&4.6434E+01_JPRB,4.6407E+01_JPRB,3.5219E+01_JPRB,2.4028E+01_JPRB,1.3279E+01_JPRB,1.0988E+01_JPRB/)
KBO( :, 3,18,14) = (/&
&4.6265E+01_JPRB,4.6238E+01_JPRB,3.5074E+01_JPRB,2.3903E+01_JPRB,1.3136E+01_JPRB,1.0670E+01_JPRB/)
KBO( :, 4,18,14) = (/&
&4.6056E+01_JPRB,4.6029E+01_JPRB,3.4898E+01_JPRB,2.3749E+01_JPRB,1.2970E+01_JPRB,1.0429E+01_JPRB/)
KBO( :, 5,18,14) = (/&
&4.5721E+01_JPRB,4.5694E+01_JPRB,3.4620E+01_JPRB,2.3533E+01_JPRB,1.2786E+01_JPRB,1.0167E+01_JPRB/)
KBO( :, 1,19,14) = (/&
&5.1627E+01_JPRB,5.1597E+01_JPRB,3.9121E+01_JPRB,2.6626E+01_JPRB,1.4901E+01_JPRB,1.2801E+01_JPRB/)
KBO( :, 2,19,14) = (/&
&5.1560E+01_JPRB,5.1530E+01_JPRB,3.9050E+01_JPRB,2.6558E+01_JPRB,1.4739E+01_JPRB,1.2472E+01_JPRB/)
KBO( :, 3,19,14) = (/&
&5.1413E+01_JPRB,5.1383E+01_JPRB,3.8915E+01_JPRB,2.6432E+01_JPRB,1.4553E+01_JPRB,1.2141E+01_JPRB/)
KBO( :, 4,19,14) = (/&
&5.1136E+01_JPRB,5.1106E+01_JPRB,3.8684E+01_JPRB,2.6245E+01_JPRB,1.4345E+01_JPRB,1.1879E+01_JPRB/)
KBO( :, 5,19,14) = (/&
&5.0773E+01_JPRB,5.0743E+01_JPRB,3.8384E+01_JPRB,2.6014E+01_JPRB,1.4118E+01_JPRB,1.1591E+01_JPRB/)
KBO( :, 1,20,14) = (/&
&5.6884E+01_JPRB,5.6851E+01_JPRB,4.3042E+01_JPRB,2.9216E+01_JPRB,1.6557E+01_JPRB,1.4595E+01_JPRB/)
KBO( :, 2,20,14) = (/&
&5.6797E+01_JPRB,5.6764E+01_JPRB,4.2946E+01_JPRB,2.9117E+01_JPRB,1.6341E+01_JPRB,1.4232E+01_JPRB/)
KBO( :, 3,20,14) = (/&
&5.6571E+01_JPRB,5.6538E+01_JPRB,4.2757E+01_JPRB,2.8963E+01_JPRB,1.6110E+01_JPRB,1.3871E+01_JPRB/)
KBO( :, 4,20,14) = (/&
&5.6241E+01_JPRB,5.6208E+01_JPRB,4.2485E+01_JPRB,2.8752E+01_JPRB,1.5861E+01_JPRB,1.3552E+01_JPRB/)
KBO( :, 5,20,14) = (/&
&5.5778E+01_JPRB,5.5746E+01_JPRB,4.2122E+01_JPRB,2.8488E+01_JPRB,1.5601E+01_JPRB,1.3221E+01_JPRB/)
KBO( :, 1,21,14) = (/&
&6.2117E+01_JPRB,6.2081E+01_JPRB,4.6932E+01_JPRB,3.1772E+01_JPRB,1.8332E+01_JPRB,1.6634E+01_JPRB/)
KBO( :, 2,21,14) = (/&
&6.1948E+01_JPRB,6.1912E+01_JPRB,4.6785E+01_JPRB,3.1648E+01_JPRB,1.8084E+01_JPRB,1.6213E+01_JPRB/)
KBO( :, 3,21,14) = (/&
&6.1644E+01_JPRB,6.1608E+01_JPRB,4.6541E+01_JPRB,3.1461E+01_JPRB,1.7808E+01_JPRB,1.5772E+01_JPRB/)
KBO( :, 4,21,14) = (/&
&6.1212E+01_JPRB,6.1176E+01_JPRB,4.6198E+01_JPRB,3.1208E+01_JPRB,1.7516E+01_JPRB,1.5375E+01_JPRB/)
KBO( :, 5,21,14) = (/&
&6.0660E+01_JPRB,6.0625E+01_JPRB,4.5764E+01_JPRB,3.0893E+01_JPRB,1.7197E+01_JPRB,1.4982E+01_JPRB/)
KBO( :, 1,22,14) = (/&
&6.7064E+01_JPRB,6.7024E+01_JPRB,5.0622E+01_JPRB,3.4206E+01_JPRB,2.0283E+01_JPRB,1.8773E+01_JPRB/)
KBO( :, 2,22,14) = (/&
&6.6814E+01_JPRB,6.6775E+01_JPRB,5.0411E+01_JPRB,3.4038E+01_JPRB,1.9964E+01_JPRB,1.8268E+01_JPRB/)
KBO( :, 3,22,14) = (/&
&6.6405E+01_JPRB,6.6365E+01_JPRB,5.0089E+01_JPRB,3.3800E+01_JPRB,1.9618E+01_JPRB,1.7753E+01_JPRB/)
KBO( :, 4,22,14) = (/&
&6.5854E+01_JPRB,6.5815E+01_JPRB,4.9659E+01_JPRB,3.3490E+01_JPRB,1.9247E+01_JPRB,1.7292E+01_JPRB/)
KBO( :, 5,22,14) = (/&
&6.5177E+01_JPRB,6.5139E+01_JPRB,4.9133E+01_JPRB,3.3115E+01_JPRB,1.8852E+01_JPRB,1.6841E+01_JPRB/)
KBO( :, 1,23,14) = (/&
&7.1524E+01_JPRB,7.1482E+01_JPRB,5.3943E+01_JPRB,3.6394E+01_JPRB,2.2409E+01_JPRB,2.1034E+01_JPRB/)
KBO( :, 2,23,14) = (/&
&7.1180E+01_JPRB,7.1138E+01_JPRB,5.3667E+01_JPRB,3.6188E+01_JPRB,2.2011E+01_JPRB,2.0463E+01_JPRB/)
KBO( :, 3,23,14) = (/&
&7.0675E+01_JPRB,7.0634E+01_JPRB,5.3273E+01_JPRB,3.5900E+01_JPRB,2.1570E+01_JPRB,1.9880E+01_JPRB/)
KBO( :, 4,23,14) = (/&
&7.0044E+01_JPRB,7.0003E+01_JPRB,5.2781E+01_JPRB,3.5547E+01_JPRB,2.1106E+01_JPRB,1.9340E+01_JPRB/)
KBO( :, 5,23,14) = (/&
&6.9258E+01_JPRB,6.9217E+01_JPRB,5.2177E+01_JPRB,3.5122E+01_JPRB,2.0624E+01_JPRB,1.8817E+01_JPRB/)
KBO( :, 1,24,14) = (/&
&7.5188E+01_JPRB,7.5144E+01_JPRB,5.6672E+01_JPRB,3.8194E+01_JPRB,2.4653E+01_JPRB,2.3438E+01_JPRB/)
KBO( :, 2,24,14) = (/&
&7.4771E+01_JPRB,7.4727E+01_JPRB,5.6346E+01_JPRB,3.7956E+01_JPRB,2.4153E+01_JPRB,2.2769E+01_JPRB/)
KBO( :, 3,24,14) = (/&
&7.4256E+01_JPRB,7.4212E+01_JPRB,5.5942E+01_JPRB,3.7664E+01_JPRB,2.3612E+01_JPRB,2.2098E+01_JPRB/)
KBO( :, 4,24,14) = (/&
&7.3533E+01_JPRB,7.3489E+01_JPRB,5.5386E+01_JPRB,3.7269E+01_JPRB,2.3047E+01_JPRB,2.1446E+01_JPRB/)
KBO( :, 5,24,14) = (/&
&7.2712E+01_JPRB,7.2669E+01_JPRB,5.4752E+01_JPRB,3.6822E+01_JPRB,2.2450E+01_JPRB,2.0823E+01_JPRB/)
KBO( :, 1,25,14) = (/&
&7.7905E+01_JPRB,7.7859E+01_JPRB,5.8695E+01_JPRB,3.9643E+01_JPRB,2.6946E+01_JPRB,2.5911E+01_JPRB/)
KBO( :, 2,25,14) = (/&
&7.7541E+01_JPRB,7.7495E+01_JPRB,5.8407E+01_JPRB,3.9379E+01_JPRB,2.6314E+01_JPRB,2.5120E+01_JPRB/)
KBO( :, 3,25,14) = (/&
&7.6964E+01_JPRB,7.6919E+01_JPRB,5.7957E+01_JPRB,3.9027E+01_JPRB,2.5656E+01_JPRB,2.4314E+01_JPRB/)
KBO( :, 4,25,14) = (/&
&7.6272E+01_JPRB,7.6227E+01_JPRB,5.7424E+01_JPRB,3.8630E+01_JPRB,2.4965E+01_JPRB,2.3534E+01_JPRB/)
KBO( :, 5,25,14) = (/&
&7.5432E+01_JPRB,7.5387E+01_JPRB,5.6779E+01_JPRB,3.8173E+01_JPRB,2.4252E+01_JPRB,2.2796E+01_JPRB/)
KBO( :, 1,26,14) = (/&
&7.9766E+01_JPRB,7.9719E+01_JPRB,6.0079E+01_JPRB,4.0881E+01_JPRB,2.9223E+01_JPRB,2.8381E+01_JPRB/)
KBO( :, 2,26,14) = (/&
&7.9434E+01_JPRB,7.9387E+01_JPRB,5.9813E+01_JPRB,4.0549E+01_JPRB,2.8445E+01_JPRB,2.7433E+01_JPRB/)
KBO( :, 3,26,14) = (/&
&7.8929E+01_JPRB,7.8882E+01_JPRB,5.9418E+01_JPRB,4.0176E+01_JPRB,2.7639E+01_JPRB,2.6466E+01_JPRB/)
KBO( :, 4,26,14) = (/&
&7.8299E+01_JPRB,7.8253E+01_JPRB,5.8927E+01_JPRB,3.9741E+01_JPRB,2.6813E+01_JPRB,2.5543E+01_JPRB/)
KBO( :, 5,26,14) = (/&
&7.7472E+01_JPRB,7.7426E+01_JPRB,5.8300E+01_JPRB,3.9244E+01_JPRB,2.5976E+01_JPRB,2.4671E+01_JPRB/)
KBO( :, 1,27,14) = (/&
&8.0841E+01_JPRB,8.0794E+01_JPRB,6.0873E+01_JPRB,4.1874E+01_JPRB,3.1425E+01_JPRB,3.0772E+01_JPRB/)
KBO( :, 2,27,14) = (/&
&8.0592E+01_JPRB,8.0544E+01_JPRB,6.0668E+01_JPRB,4.1525E+01_JPRB,3.0489E+01_JPRB,2.9641E+01_JPRB/)
KBO( :, 3,27,14) = (/&
&8.0232E+01_JPRB,8.0184E+01_JPRB,6.0383E+01_JPRB,4.1112E+01_JPRB,2.9523E+01_JPRB,2.8513E+01_JPRB/)
KBO( :, 4,27,14) = (/&
&7.9648E+01_JPRB,7.9600E+01_JPRB,5.9935E+01_JPRB,4.0653E+01_JPRB,2.8551E+01_JPRB,2.7444E+01_JPRB/)
KBO( :, 5,27,14) = (/&
&7.8924E+01_JPRB,7.8877E+01_JPRB,5.9378E+01_JPRB,4.0128E+01_JPRB,2.7582E+01_JPRB,2.6425E+01_JPRB/)
KBO( :, 1,28,14) = (/&
&8.1302E+01_JPRB,8.1254E+01_JPRB,6.1208E+01_JPRB,4.2732E+01_JPRB,3.3493E+01_JPRB,3.3014E+01_JPRB/)
KBO( :, 2,28,14) = (/&
&8.1246E+01_JPRB,8.1198E+01_JPRB,6.1149E+01_JPRB,4.2327E+01_JPRB,3.2380E+01_JPRB,3.1684E+01_JPRB/)
KBO( :, 3,28,14) = (/&
&8.0968E+01_JPRB,8.0920E+01_JPRB,6.0927E+01_JPRB,4.1887E+01_JPRB,3.1259E+01_JPRB,3.0389E+01_JPRB/)
KBO( :, 4,28,14) = (/&
&8.0565E+01_JPRB,8.0517E+01_JPRB,6.0611E+01_JPRB,4.1407E+01_JPRB,3.0143E+01_JPRB,2.9193E+01_JPRB/)
KBO( :, 5,28,14) = (/&
&7.9942E+01_JPRB,7.9894E+01_JPRB,6.0131E+01_JPRB,4.0878E+01_JPRB,2.9022E+01_JPRB,2.8027E+01_JPRB/)
KBO( :, 1,29,14) = (/&
&8.1307E+01_JPRB,8.1259E+01_JPRB,6.1205E+01_JPRB,4.3500E+01_JPRB,3.5359E+01_JPRB,3.5050E+01_JPRB/)
KBO( :, 2,29,14) = (/&
&8.1478E+01_JPRB,8.1430E+01_JPRB,6.1314E+01_JPRB,4.3042E+01_JPRB,3.4075E+01_JPRB,3.3533E+01_JPRB/)
KBO( :, 3,29,14) = (/&
&8.1374E+01_JPRB,8.1326E+01_JPRB,6.1221E+01_JPRB,4.2543E+01_JPRB,3.2801E+01_JPRB,3.2073E+01_JPRB/)
KBO( :, 4,29,14) = (/&
&8.1081E+01_JPRB,8.1032E+01_JPRB,6.0988E+01_JPRB,4.2019E+01_JPRB,3.1534E+01_JPRB,3.0765E+01_JPRB/)
KBO( :, 5,29,14) = (/&
&8.0577E+01_JPRB,8.0529E+01_JPRB,6.0599E+01_JPRB,4.1461E+01_JPRB,3.0285E+01_JPRB,2.9423E+01_JPRB/)
KBO( :, 1,30,14) = (/&
&8.1051E+01_JPRB,8.1003E+01_JPRB,6.1003E+01_JPRB,4.4185E+01_JPRB,3.7000E+01_JPRB,3.6850E+01_JPRB/)
KBO( :, 2,30,14) = (/&
&8.1462E+01_JPRB,8.1414E+01_JPRB,6.1293E+01_JPRB,4.3687E+01_JPRB,3.5552E+01_JPRB,3.5134E+01_JPRB/)
KBO( :, 3,30,14) = (/&
&8.1539E+01_JPRB,8.1490E+01_JPRB,6.1337E+01_JPRB,4.3125E+01_JPRB,3.4127E+01_JPRB,3.3561E+01_JPRB/)
KBO( :, 4,30,14) = (/&
&8.1391E+01_JPRB,8.1342E+01_JPRB,6.1214E+01_JPRB,4.2562E+01_JPRB,3.2726E+01_JPRB,3.2101E+01_JPRB/)
KBO( :, 5,30,14) = (/&
&8.0955E+01_JPRB,8.0906E+01_JPRB,6.0875E+01_JPRB,4.1945E+01_JPRB,3.1354E+01_JPRB,3.0606E+01_JPRB/)
KBO( :, 1,31,14) = (/&
&8.0671E+01_JPRB,8.0623E+01_JPRB,6.0709E+01_JPRB,4.4790E+01_JPRB,3.8398E+01_JPRB,3.8352E+01_JPRB/)
KBO( :, 2,31,14) = (/&
&8.1282E+01_JPRB,8.1234E+01_JPRB,6.1149E+01_JPRB,4.4230E+01_JPRB,3.6789E+01_JPRB,3.6501E+01_JPRB/)
KBO( :, 3,31,14) = (/&
&8.1574E+01_JPRB,8.1525E+01_JPRB,6.1354E+01_JPRB,4.3641E+01_JPRB,3.5216E+01_JPRB,3.4852E+01_JPRB/)
KBO( :, 4,31,14) = (/&
&8.1529E+01_JPRB,8.1481E+01_JPRB,6.1310E+01_JPRB,4.3014E+01_JPRB,3.3693E+01_JPRB,3.3201E+01_JPRB/)
KBO( :, 5,31,14) = (/&
&8.1189E+01_JPRB,8.1141E+01_JPRB,6.1044E+01_JPRB,4.2350E+01_JPRB,3.2213E+01_JPRB,3.1581E+01_JPRB/)
KBO( :, 1,32,14) = (/&
&8.0273E+01_JPRB,8.0225E+01_JPRB,6.0440E+01_JPRB,4.5305E+01_JPRB,3.9524E+01_JPRB,3.9577E+01_JPRB/)
KBO( :, 2,32,14) = (/&
&8.1061E+01_JPRB,8.1013E+01_JPRB,6.0977E+01_JPRB,4.4682E+01_JPRB,3.7774E+01_JPRB,3.7685E+01_JPRB/)
KBO( :, 3,32,14) = (/&
&8.1507E+01_JPRB,8.1459E+01_JPRB,6.1299E+01_JPRB,4.4057E+01_JPRB,3.6074E+01_JPRB,3.5862E+01_JPRB/)
KBO( :, 4,32,14) = (/&
&8.1572E+01_JPRB,8.1523E+01_JPRB,6.1336E+01_JPRB,4.3367E+01_JPRB,3.4447E+01_JPRB,3.4068E+01_JPRB/)
KBO( :, 5,32,14) = (/&
&8.1328E+01_JPRB,8.1279E+01_JPRB,6.1143E+01_JPRB,4.2670E+01_JPRB,3.2874E+01_JPRB,3.2515E+01_JPRB/)
KBO( :, 1,33,14) = (/&
&7.9947E+01_JPRB,7.9899E+01_JPRB,6.0245E+01_JPRB,4.5734E+01_JPRB,4.0389E+01_JPRB,4.0600E+01_JPRB/)
KBO( :, 2,33,14) = (/&
&8.0885E+01_JPRB,8.0836E+01_JPRB,6.0856E+01_JPRB,4.5062E+01_JPRB,3.8518E+01_JPRB,3.8594E+01_JPRB/)
KBO( :, 3,33,14) = (/&
&8.1444E+01_JPRB,8.1395E+01_JPRB,6.1246E+01_JPRB,4.4394E+01_JPRB,3.6721E+01_JPRB,3.6614E+01_JPRB/)
KBO( :, 4,33,14) = (/&
&8.1576E+01_JPRB,8.1528E+01_JPRB,6.1332E+01_JPRB,4.3653E+01_JPRB,3.5005E+01_JPRB,3.4830E+01_JPRB/)
KBO( :, 5,33,14) = (/&
&8.1383E+01_JPRB,8.1335E+01_JPRB,6.1178E+01_JPRB,4.2909E+01_JPRB,3.3354E+01_JPRB,3.3470E+01_JPRB/)
KBO( :, 1,34,14) = (/&
&7.9662E+01_JPRB,7.9614E+01_JPRB,6.0102E+01_JPRB,4.6098E+01_JPRB,4.1095E+01_JPRB,4.1483E+01_JPRB/)
KBO( :, 2,34,14) = (/&
&8.0738E+01_JPRB,8.0690E+01_JPRB,6.0775E+01_JPRB,4.5387E+01_JPRB,3.9122E+01_JPRB,3.9299E+01_JPRB/)
KBO( :, 3,34,14) = (/&
&8.1366E+01_JPRB,8.1318E+01_JPRB,6.1186E+01_JPRB,4.4659E+01_JPRB,3.7233E+01_JPRB,3.7257E+01_JPRB/)
KBO( :, 4,34,14) = (/&
&8.1568E+01_JPRB,8.1519E+01_JPRB,6.1321E+01_JPRB,4.3886E+01_JPRB,3.5446E+01_JPRB,3.5711E+01_JPRB/)
KBO( :, 5,34,14) = (/&
&8.1413E+01_JPRB,8.1365E+01_JPRB,6.1195E+01_JPRB,4.3093E+01_JPRB,3.3726E+01_JPRB,3.4415E+01_JPRB/)
KBO( :, 1,35,14) = (/&
&7.9337E+01_JPRB,7.9289E+01_JPRB,5.9949E+01_JPRB,4.6449E+01_JPRB,4.1796E+01_JPRB,4.2326E+01_JPRB/)
KBO( :, 2,35,14) = (/&
&8.0544E+01_JPRB,8.0496E+01_JPRB,6.0670E+01_JPRB,4.5697E+01_JPRB,3.9737E+01_JPRB,4.0033E+01_JPRB/)
KBO( :, 3,35,14) = (/&
&8.1258E+01_JPRB,8.1209E+01_JPRB,6.1112E+01_JPRB,4.4918E+01_JPRB,3.7765E+01_JPRB,3.8111E+01_JPRB/)
KBO( :, 4,35,14) = (/&
&8.1537E+01_JPRB,8.1488E+01_JPRB,6.1295E+01_JPRB,4.4118E+01_JPRB,3.5911E+01_JPRB,3.6760E+01_JPRB/)
KBO( :, 5,35,14) = (/&
&8.1445E+01_JPRB,8.1397E+01_JPRB,6.1217E+01_JPRB,4.3296E+01_JPRB,3.4131E+01_JPRB,3.5503E+01_JPRB/)
KBO( :, 1,36,14) = (/&
&7.8929E+01_JPRB,7.8882E+01_JPRB,5.9746E+01_JPRB,4.6822E+01_JPRB,4.2579E+01_JPRB,4.3271E+01_JPRB/)
KBO( :, 2,36,14) = (/&
&8.0271E+01_JPRB,8.0223E+01_JPRB,6.0527E+01_JPRB,4.6026E+01_JPRB,4.0432E+01_JPRB,4.0931E+01_JPRB/)
KBO( :, 3,36,14) = (/&
&8.1107E+01_JPRB,8.1058E+01_JPRB,6.1024E+01_JPRB,4.5215E+01_JPRB,3.8381E+01_JPRB,3.9211E+01_JPRB/)
KBO( :, 4,36,14) = (/&
&8.1508E+01_JPRB,8.1459E+01_JPRB,6.1272E+01_JPRB,4.4394E+01_JPRB,3.6464E+01_JPRB,3.7915E+01_JPRB/)
KBO( :, 5,36,14) = (/&
&8.1479E+01_JPRB,8.1431E+01_JPRB,6.1242E+01_JPRB,4.3542E+01_JPRB,3.4625E+01_JPRB,3.6634E+01_JPRB/)
KBO( :, 1,37,14) = (/&
&7.8277E+01_JPRB,7.8230E+01_JPRB,5.9419E+01_JPRB,4.7267E+01_JPRB,4.3580E+01_JPRB,4.4454E+01_JPRB/)
KBO( :, 2,37,14) = (/&
&7.9839E+01_JPRB,7.9792E+01_JPRB,6.0300E+01_JPRB,4.6427E+01_JPRB,4.1343E+01_JPRB,4.2071E+01_JPRB/)
KBO( :, 3,37,14) = (/&
&8.0875E+01_JPRB,8.0827E+01_JPRB,6.0897E+01_JPRB,4.5598E+01_JPRB,3.9207E+01_JPRB,4.0399E+01_JPRB/)
KBO( :, 4,37,14) = (/&
&8.1407E+01_JPRB,8.1359E+01_JPRB,6.1209E+01_JPRB,4.4745E+01_JPRB,3.7210E+01_JPRB,3.9084E+01_JPRB/)
KBO( :, 5,37,14) = (/&
&8.1511E+01_JPRB,8.1463E+01_JPRB,6.1267E+01_JPRB,4.3885E+01_JPRB,3.5313E+01_JPRB,3.7757E+01_JPRB/)
KBO( :, 1,38,14) = (/&
&7.7604E+01_JPRB,7.7558E+01_JPRB,5.9100E+01_JPRB,4.7673E+01_JPRB,4.4519E+01_JPRB,4.5590E+01_JPRB/)
KBO( :, 2,38,14) = (/&
&7.9387E+01_JPRB,7.9340E+01_JPRB,6.0071E+01_JPRB,4.6807E+01_JPRB,4.2192E+01_JPRB,4.3208E+01_JPRB/)
KBO( :, 3,38,14) = (/&
&8.0600E+01_JPRB,8.0552E+01_JPRB,6.0751E+01_JPRB,4.5947E+01_JPRB,3.9982E+01_JPRB,4.1623E+01_JPRB/)
KBO( :, 4,38,14) = (/&
&8.1297E+01_JPRB,8.1248E+01_JPRB,6.1150E+01_JPRB,4.5081E+01_JPRB,3.7909E+01_JPRB,4.0273E+01_JPRB/)
KBO( :, 5,38,14) = (/&
&8.1523E+01_JPRB,8.1474E+01_JPRB,6.1279E+01_JPRB,4.4207E+01_JPRB,3.5960E+01_JPRB,3.8923E+01_JPRB/)
KBO( :, 1,39,14) = (/&
&7.6924E+01_JPRB,7.6879E+01_JPRB,5.8785E+01_JPRB,4.8037E+01_JPRB,4.5384E+01_JPRB,4.6696E+01_JPRB/)
KBO( :, 2,39,14) = (/&
&7.8919E+01_JPRB,7.8872E+01_JPRB,5.9835E+01_JPRB,4.7151E+01_JPRB,4.2965E+01_JPRB,4.4375E+01_JPRB/)
KBO( :, 3,39,14) = (/&
&8.0301E+01_JPRB,8.0253E+01_JPRB,6.0596E+01_JPRB,4.6264E+01_JPRB,4.0694E+01_JPRB,4.2894E+01_JPRB/)
KBO( :, 4,39,14) = (/&
&8.1135E+01_JPRB,8.1087E+01_JPRB,6.1060E+01_JPRB,4.5380E+01_JPRB,3.8551E+01_JPRB,4.1533E+01_JPRB/)
KBO( :, 5,39,14) = (/&
&8.1498E+01_JPRB,8.1449E+01_JPRB,6.1268E+01_JPRB,4.4494E+01_JPRB,3.6550E+01_JPRB,4.0180E+01_JPRB/)
KBO( :, 1,40,14) = (/&
&7.6003E+01_JPRB,7.5957E+01_JPRB,5.8367E+01_JPRB,4.8484E+01_JPRB,4.6448E+01_JPRB,4.7942E+01_JPRB/)
KBO( :, 2,40,14) = (/&
&7.8250E+01_JPRB,7.8203E+01_JPRB,5.9505E+01_JPRB,4.7557E+01_JPRB,4.3937E+01_JPRB,4.5516E+01_JPRB/)
KBO( :, 3,40,14) = (/&
&7.9849E+01_JPRB,7.9801E+01_JPRB,6.0362E+01_JPRB,4.6641E+01_JPRB,4.1586E+01_JPRB,4.3950E+01_JPRB/)
KBO( :, 4,40,14) = (/&
&8.0899E+01_JPRB,8.0851E+01_JPRB,6.0936E+01_JPRB,4.5752E+01_JPRB,3.9370E+01_JPRB,4.2576E+01_JPRB/)
KBO( :, 5,40,14) = (/&
&8.1420E+01_JPRB,8.1371E+01_JPRB,6.1226E+01_JPRB,4.4847E+01_JPRB,3.7301E+01_JPRB,4.1187E+01_JPRB/)
KBO( :, 1,41,14) = (/&
&7.5005E+01_JPRB,7.4960E+01_JPRB,5.7923E+01_JPRB,4.8919E+01_JPRB,4.7504E+01_JPRB,4.9183E+01_JPRB/)
KBO( :, 2,41,14) = (/&
&7.7512E+01_JPRB,7.7466E+01_JPRB,5.9150E+01_JPRB,4.7955E+01_JPRB,4.4905E+01_JPRB,4.6631E+01_JPRB/)
KBO( :, 3,41,14) = (/&
&7.9348E+01_JPRB,7.9301E+01_JPRB,6.0108E+01_JPRB,4.7025E+01_JPRB,4.2473E+01_JPRB,4.4967E+01_JPRB/)
KBO( :, 4,41,14) = (/&
&8.0591E+01_JPRB,8.0543E+01_JPRB,6.0779E+01_JPRB,4.6109E+01_JPRB,4.0189E+01_JPRB,4.3586E+01_JPRB/)
KBO( :, 5,41,14) = (/&
&8.1296E+01_JPRB,8.1247E+01_JPRB,6.1167E+01_JPRB,4.5201E+01_JPRB,3.8056E+01_JPRB,4.2157E+01_JPRB/)
KBO( :, 1,42,14) = (/&
&7.3966E+01_JPRB,7.3922E+01_JPRB,5.7469E+01_JPRB,4.9337E+01_JPRB,4.8525E+01_JPRB,5.0393E+01_JPRB/)
KBO( :, 2,42,14) = (/&
&7.6721E+01_JPRB,7.6675E+01_JPRB,5.8783E+01_JPRB,4.8336E+01_JPRB,4.5846E+01_JPRB,4.7757E+01_JPRB/)
KBO( :, 3,42,14) = (/&
&7.8788E+01_JPRB,7.8741E+01_JPRB,5.9830E+01_JPRB,4.7390E+01_JPRB,4.3338E+01_JPRB,4.6001E+01_JPRB/)
KBO( :, 4,42,14) = (/&
&8.0252E+01_JPRB,8.0204E+01_JPRB,6.0610E+01_JPRB,4.6463E+01_JPRB,4.0990E+01_JPRB,4.4619E+01_JPRB/)
KBO( :, 5,42,14) = (/&
&8.1117E+01_JPRB,8.1069E+01_JPRB,6.1079E+01_JPRB,4.5535E+01_JPRB,3.8790E+01_JPRB,4.3153E+01_JPRB/)
KBO( :, 1,43,14) = (/&
&7.2705E+01_JPRB,7.2662E+01_JPRB,5.6918E+01_JPRB,4.9800E+01_JPRB,4.9669E+01_JPRB,5.1746E+01_JPRB/)
KBO( :, 2,43,14) = (/&
&7.5730E+01_JPRB,7.5685E+01_JPRB,5.8326E+01_JPRB,4.8759E+01_JPRB,4.6917E+01_JPRB,4.8987E+01_JPRB/)
KBO( :, 3,43,14) = (/&
&7.8083E+01_JPRB,7.8037E+01_JPRB,5.9488E+01_JPRB,4.7800E+01_JPRB,4.4326E+01_JPRB,4.7090E+01_JPRB/)
KBO( :, 4,43,14) = (/&
&7.9761E+01_JPRB,7.9714E+01_JPRB,6.0355E+01_JPRB,4.6841E+01_JPRB,4.1904E+01_JPRB,4.5691E+01_JPRB/)
KBO( :, 5,43,14) = (/&
&8.0847E+01_JPRB,8.0799E+01_JPRB,6.0937E+01_JPRB,4.5910E+01_JPRB,3.9634E+01_JPRB,4.4206E+01_JPRB/)
KBO( :, 1,44,14) = (/&
&7.1287E+01_JPRB,7.1245E+01_JPRB,5.6316E+01_JPRB,5.0292E+01_JPRB,5.0887E+01_JPRB,5.3170E+01_JPRB/)
KBO( :, 2,44,14) = (/&
&7.4599E+01_JPRB,7.4555E+01_JPRB,5.7821E+01_JPRB,4.9215E+01_JPRB,4.8047E+01_JPRB,5.0291E+01_JPRB/)
KBO( :, 3,44,14) = (/&
&7.7237E+01_JPRB,7.7191E+01_JPRB,5.9077E+01_JPRB,4.8209E+01_JPRB,4.5375E+01_JPRB,4.8245E+01_JPRB/)
KBO( :, 4,44,14) = (/&
&7.9186E+01_JPRB,7.9139E+01_JPRB,6.0066E+01_JPRB,4.7254E+01_JPRB,4.2877E+01_JPRB,4.6818E+01_JPRB/)
KBO( :, 5,44,14) = (/&
&8.0509E+01_JPRB,8.0461E+01_JPRB,6.0765E+01_JPRB,4.6310E+01_JPRB,4.0533E+01_JPRB,4.5323E+01_JPRB/)
KBO( :, 1,45,14) = (/&
&6.9761E+01_JPRB,6.9720E+01_JPRB,5.5680E+01_JPRB,5.0779E+01_JPRB,5.2112E+01_JPRB,5.4609E+01_JPRB/)
KBO( :, 2,45,14) = (/&
&7.3387E+01_JPRB,7.3344E+01_JPRB,5.7284E+01_JPRB,4.9658E+01_JPRB,4.9177E+01_JPRB,5.1651E+01_JPRB/)
KBO( :, 3,45,14) = (/&
&7.6302E+01_JPRB,7.6257E+01_JPRB,5.8639E+01_JPRB,4.8623E+01_JPRB,4.6419E+01_JPRB,4.9491E+01_JPRB/)
KBO( :, 4,45,14) = (/&
&7.8515E+01_JPRB,7.8468E+01_JPRB,5.9732E+01_JPRB,4.7651E+01_JPRB,4.3843E+01_JPRB,4.8016E+01_JPRB/)
KBO( :, 5,45,14) = (/&
&8.0070E+01_JPRB,8.0022E+01_JPRB,6.0538E+01_JPRB,4.6688E+01_JPRB,4.1436E+01_JPRB,4.6520E+01_JPRB/)
KBO( :, 1,46,14) = (/&
&6.8043E+01_JPRB,6.8003E+01_JPRB,5.4978E+01_JPRB,5.1296E+01_JPRB,5.3415E+01_JPRB,5.6131E+01_JPRB/)
KBO( :, 2,46,14) = (/&
&7.2020E+01_JPRB,7.1978E+01_JPRB,5.6693E+01_JPRB,5.0128E+01_JPRB,5.0366E+01_JPRB,5.3081E+01_JPRB/)
KBO( :, 3,46,14) = (/&
&7.5220E+01_JPRB,7.5175E+01_JPRB,5.8142E+01_JPRB,4.9054E+01_JPRB,4.7529E+01_JPRB,5.0825E+01_JPRB/)
KBO( :, 4,46,14) = (/&
&7.7714E+01_JPRB,7.7668E+01_JPRB,5.9339E+01_JPRB,4.8058E+01_JPRB,4.4874E+01_JPRB,4.9267E+01_JPRB/)
KBO( :, 5,46,14) = (/&
&7.9534E+01_JPRB,7.9486E+01_JPRB,6.0264E+01_JPRB,4.7084E+01_JPRB,4.2395E+01_JPRB,4.7792E+01_JPRB/)
KBO( :, 1,47,14) = (/&
&6.6054E+01_JPRB,6.6015E+01_JPRB,5.4183E+01_JPRB,5.1903E+01_JPRB,5.4894E+01_JPRB,5.7778E+01_JPRB/)
KBO( :, 2,47,14) = (/&
&7.0378E+01_JPRB,7.0336E+01_JPRB,5.5996E+01_JPRB,5.0654E+01_JPRB,5.1707E+01_JPRB,5.4608E+01_JPRB/)
KBO( :, 3,47,14) = (/&
&7.3908E+01_JPRB,7.3864E+01_JPRB,5.7556E+01_JPRB,4.9537E+01_JPRB,4.8774E+01_JPRB,5.2210E+01_JPRB/)
KBO( :, 4,47,14) = (/&
&7.6726E+01_JPRB,7.6681E+01_JPRB,5.8866E+01_JPRB,4.8503E+01_JPRB,4.6033E+01_JPRB,5.0483E+01_JPRB/)
KBO( :, 5,47,14) = (/&
&7.8817E+01_JPRB,7.8770E+01_JPRB,5.9899E+01_JPRB,4.7521E+01_JPRB,4.3467E+01_JPRB,4.9057E+01_JPRB/)
KBO( :, 1,48,14) = (/&
&6.3955E+01_JPRB,6.3917E+01_JPRB,5.3354E+01_JPRB,5.2548E+01_JPRB,5.6389E+01_JPRB,5.9437E+01_JPRB/)
KBO( :, 2,48,14) = (/&
&6.8594E+01_JPRB,6.8553E+01_JPRB,5.5256E+01_JPRB,5.1194E+01_JPRB,5.3073E+01_JPRB,5.6223E+01_JPRB/)
KBO( :, 3,48,14) = (/&
&7.2478E+01_JPRB,7.2435E+01_JPRB,5.6928E+01_JPRB,5.0025E+01_JPRB,5.0034E+01_JPRB,5.3708E+01_JPRB/)
KBO( :, 4,48,14) = (/&
&7.5613E+01_JPRB,7.5568E+01_JPRB,5.8350E+01_JPRB,4.8962E+01_JPRB,4.7206E+01_JPRB,5.1823E+01_JPRB/)
KBO( :, 5,48,14) = (/&
&7.8004E+01_JPRB,7.7958E+01_JPRB,5.9498E+01_JPRB,4.7959E+01_JPRB,4.4557E+01_JPRB,5.0435E+01_JPRB/)
KBO( :, 1,49,14) = (/&
&6.1733E+01_JPRB,6.1696E+01_JPRB,5.2490E+01_JPRB,5.3233E+01_JPRB,5.7911E+01_JPRB,6.1164E+01_JPRB/)
KBO( :, 2,49,14) = (/&
&6.6686E+01_JPRB,6.6647E+01_JPRB,5.4483E+01_JPRB,5.1761E+01_JPRB,5.4482E+01_JPRB,5.7948E+01_JPRB/)
KBO( :, 3,49,14) = (/&
&7.0933E+01_JPRB,7.0891E+01_JPRB,5.6270E+01_JPRB,5.0531E+01_JPRB,5.1319E+01_JPRB,5.5363E+01_JPRB/)
KBO( :, 4,49,14) = (/&
&7.4366E+01_JPRB,7.4322E+01_JPRB,5.7787E+01_JPRB,4.9421E+01_JPRB,4.8403E+01_JPRB,5.3357E+01_JPRB/)
KBO( :, 5,49,14) = (/&
&7.7078E+01_JPRB,7.7033E+01_JPRB,5.9049E+01_JPRB,4.8386E+01_JPRB,4.5673E+01_JPRB,5.2019E+01_JPRB/)
KBO( :, 1,50,14) = (/&
&5.9556E+01_JPRB,5.9521E+01_JPRB,5.1669E+01_JPRB,5.3919E+01_JPRB,5.9382E+01_JPRB,6.2781E+01_JPRB/)
KBO( :, 2,50,14) = (/&
&6.4814E+01_JPRB,6.4775E+01_JPRB,5.3744E+01_JPRB,5.2339E+01_JPRB,5.5844E+01_JPRB,5.9493E+01_JPRB/)
KBO( :, 3,50,14) = (/&
&6.9336E+01_JPRB,6.9295E+01_JPRB,5.5596E+01_JPRB,5.1013E+01_JPRB,5.2559E+01_JPRB,5.6778E+01_JPRB/)
KBO( :, 4,50,14) = (/&
&7.3091E+01_JPRB,7.3048E+01_JPRB,5.7225E+01_JPRB,4.9862E+01_JPRB,4.9551E+01_JPRB,5.4617E+01_JPRB/)
KBO( :, 5,50,14) = (/&
&7.6098E+01_JPRB,7.6053E+01_JPRB,5.8589E+01_JPRB,4.8799E+01_JPRB,4.6739E+01_JPRB,5.3303E+01_JPRB/)
KBO( :, 1,51,14) = (/&
&5.7367E+01_JPRB,5.7333E+01_JPRB,5.0871E+01_JPRB,5.4612E+01_JPRB,6.0840E+01_JPRB,6.4373E+01_JPRB/)
KBO( :, 2,51,14) = (/&
&6.2885E+01_JPRB,6.2848E+01_JPRB,5.2984E+01_JPRB,5.2932E+01_JPRB,5.7187E+01_JPRB,6.0966E+01_JPRB/)
KBO( :, 3,51,14) = (/&
&6.7687E+01_JPRB,6.7647E+01_JPRB,5.4925E+01_JPRB,5.1505E+01_JPRB,5.3793E+01_JPRB,5.8080E+01_JPRB/)
KBO( :, 4,51,14) = (/&
&7.1761E+01_JPRB,7.1718E+01_JPRB,5.6647E+01_JPRB,5.0300E+01_JPRB,5.0681E+01_JPRB,5.5789E+01_JPRB/)
KBO( :, 5,51,14) = (/&
&7.5046E+01_JPRB,7.5001E+01_JPRB,5.8108E+01_JPRB,4.9204E+01_JPRB,4.7793E+01_JPRB,5.4431E+01_JPRB/)
KBO( :, 1,52,14) = (/&
&5.5098E+01_JPRB,5.5065E+01_JPRB,5.0074E+01_JPRB,5.5358E+01_JPRB,6.2317E+01_JPRB,6.6056E+01_JPRB/)
KBO( :, 2,52,14) = (/&
&6.0852E+01_JPRB,6.0816E+01_JPRB,5.2195E+01_JPRB,5.3549E+01_JPRB,5.8551E+01_JPRB,6.2483E+01_JPRB/)
KBO( :, 3,52,14) = (/&
&6.5953E+01_JPRB,6.5914E+01_JPRB,5.4229E+01_JPRB,5.2028E+01_JPRB,5.5063E+01_JPRB,5.9490E+01_JPRB/)
KBO( :, 4,52,14) = (/&
&7.0320E+01_JPRB,7.0278E+01_JPRB,5.6036E+01_JPRB,5.0747E+01_JPRB,5.1835E+01_JPRB,5.7114E+01_JPRB/)
KBO( :, 5,52,14) = (/&
&7.3892E+01_JPRB,7.3848E+01_JPRB,5.7595E+01_JPRB,4.9618E+01_JPRB,4.8874E+01_JPRB,5.5672E+01_JPRB/)
KBO( :, 1,53,14) = (/&
&5.2721E+01_JPRB,5.2690E+01_JPRB,4.9263E+01_JPRB,5.6120E+01_JPRB,6.3814E+01_JPRB,6.7766E+01_JPRB/)
KBO( :, 2,53,14) = (/&
&5.8756E+01_JPRB,5.8721E+01_JPRB,5.1411E+01_JPRB,5.4211E+01_JPRB,5.9956E+01_JPRB,6.4072E+01_JPRB/)
KBO( :, 3,53,14) = (/&
&6.4126E+01_JPRB,6.4088E+01_JPRB,5.3502E+01_JPRB,5.2588E+01_JPRB,5.6365E+01_JPRB,6.1039E+01_JPRB/)
KBO( :, 4,53,14) = (/&
&6.8738E+01_JPRB,6.8697E+01_JPRB,5.5371E+01_JPRB,5.1205E+01_JPRB,5.3025E+01_JPRB,5.8602E+01_JPRB/)
KBO( :, 5,53,14) = (/&
&7.2636E+01_JPRB,7.2593E+01_JPRB,5.7041E+01_JPRB,5.0037E+01_JPRB,4.9973E+01_JPRB,5.7127E+01_JPRB/)
KBO( :, 1,54,14) = (/&
&5.0488E+01_JPRB,5.0458E+01_JPRB,4.8529E+01_JPRB,5.6862E+01_JPRB,6.5226E+01_JPRB,6.9287E+01_JPRB/)
KBO( :, 2,54,14) = (/&
&5.6752E+01_JPRB,5.6718E+01_JPRB,5.0683E+01_JPRB,5.4841E+01_JPRB,6.1279E+01_JPRB,6.5223E+01_JPRB/)
KBO( :, 3,54,14) = (/&
&6.2359E+01_JPRB,6.2322E+01_JPRB,5.2805E+01_JPRB,5.3124E+01_JPRB,5.7582E+01_JPRB,6.2132E+01_JPRB/)
KBO( :, 4,54,14) = (/&
&6.7239E+01_JPRB,6.7199E+01_JPRB,5.4766E+01_JPRB,5.1664E+01_JPRB,5.4149E+01_JPRB,5.9478E+01_JPRB/)
KBO( :, 5,54,14) = (/&
&7.1401E+01_JPRB,7.1358E+01_JPRB,5.6510E+01_JPRB,5.0433E+01_JPRB,5.0999E+01_JPRB,5.7575E+01_JPRB/)
KBO( :, 1,55,14) = (/&
&4.8301E+01_JPRB,4.8272E+01_JPRB,4.7833E+01_JPRB,5.7595E+01_JPRB,6.6585E+01_JPRB,7.0689E+01_JPRB/)
KBO( :, 2,55,14) = (/&
&5.4769E+01_JPRB,5.4736E+01_JPRB,4.9988E+01_JPRB,5.5495E+01_JPRB,6.2560E+01_JPRB,6.6385E+01_JPRB/)
KBO( :, 3,55,14) = (/&
&6.0573E+01_JPRB,6.0537E+01_JPRB,5.2112E+01_JPRB,5.3664E+01_JPRB,5.8770E+01_JPRB,6.2943E+01_JPRB/)
KBO( :, 4,55,14) = (/&
&6.5713E+01_JPRB,6.5674E+01_JPRB,5.4151E+01_JPRB,5.2119E+01_JPRB,5.5258E+01_JPRB,6.0010E+01_JPRB/)
KBO( :, 5,55,14) = (/&
&7.0126E+01_JPRB,7.0084E+01_JPRB,5.5970E+01_JPRB,5.0826E+01_JPRB,5.2008E+01_JPRB,5.7678E+01_JPRB/)
KBO( :, 1,56,14) = (/&
&4.6079E+01_JPRB,4.6051E+01_JPRB,4.7176E+01_JPRB,5.8356E+01_JPRB,6.7969E+01_JPRB,7.2050E+01_JPRB/)
KBO( :, 2,56,14) = (/&
&5.2701E+01_JPRB,5.2670E+01_JPRB,4.9282E+01_JPRB,5.6152E+01_JPRB,6.3857E+01_JPRB,6.7749E+01_JPRB/)
KBO( :, 3,56,14) = (/&
&5.8754E+01_JPRB,5.8720E+01_JPRB,5.1436E+01_JPRB,5.4239E+01_JPRB,5.9985E+01_JPRB,6.3792E+01_JPRB/)
KBO( :, 4,56,14) = (/&
&6.4130E+01_JPRB,6.4092E+01_JPRB,5.3523E+01_JPRB,5.2605E+01_JPRB,5.6386E+01_JPRB,6.0677E+01_JPRB/)
KBO( :, 5,56,14) = (/&
&6.8768E+01_JPRB,6.8727E+01_JPRB,5.5406E+01_JPRB,5.1229E+01_JPRB,5.3042E+01_JPRB,5.8111E+01_JPRB/)
KBO( :, 1,57,14) = (/&
&4.3796E+01_JPRB,4.3770E+01_JPRB,4.6545E+01_JPRB,5.9133E+01_JPRB,6.9380E+01_JPRB,7.3404E+01_JPRB/)
KBO( :, 2,57,14) = (/&
&5.0589E+01_JPRB,5.0559E+01_JPRB,4.8583E+01_JPRB,5.6850E+01_JPRB,6.5189E+01_JPRB,6.9103E+01_JPRB/)
KBO( :, 3,57,14) = (/&
&5.6860E+01_JPRB,5.6826E+01_JPRB,5.0745E+01_JPRB,5.4829E+01_JPRB,6.1234E+01_JPRB,6.4852E+01_JPRB/)
KBO( :, 4,57,14) = (/&
&6.2462E+01_JPRB,6.2424E+01_JPRB,5.2862E+01_JPRB,5.3112E+01_JPRB,5.7531E+01_JPRB,6.1451E+01_JPRB/)
KBO( :, 5,57,14) = (/&
&6.7340E+01_JPRB,6.7300E+01_JPRB,5.4823E+01_JPRB,5.1656E+01_JPRB,5.4098E+01_JPRB,5.8580E+01_JPRB/)
KBO( :, 1,58,14) = (/&
&4.1597E+01_JPRB,4.1573E+01_JPRB,4.5980E+01_JPRB,5.9890E+01_JPRB,7.0733E+01_JPRB,7.4721E+01_JPRB/)
KBO( :, 2,58,14) = (/&
&4.8541E+01_JPRB,4.8512E+01_JPRB,4.7924E+01_JPRB,5.7530E+01_JPRB,6.6457E+01_JPRB,7.0297E+01_JPRB/)
KBO( :, 3,58,14) = (/&
&5.5001E+01_JPRB,5.4968E+01_JPRB,5.0085E+01_JPRB,5.5434E+01_JPRB,6.2433E+01_JPRB,6.6096E+01_JPRB/)
KBO( :, 4,58,14) = (/&
&6.0796E+01_JPRB,6.0760E+01_JPRB,5.2213E+01_JPRB,5.3615E+01_JPRB,5.8644E+01_JPRB,6.2188E+01_JPRB/)
KBO( :, 5,58,14) = (/&
&6.5915E+01_JPRB,6.5876E+01_JPRB,5.4248E+01_JPRB,5.2078E+01_JPRB,5.5135E+01_JPRB,5.9028E+01_JPRB/)
KBO( :, 1,59,14) = (/&
&4.0694E+01_JPRB,4.0670E+01_JPRB,4.5769E+01_JPRB,6.0220E+01_JPRB,7.1303E+01_JPRB,7.5294E+01_JPRB/)
KBO( :, 2,59,14) = (/&
&4.7704E+01_JPRB,4.7676E+01_JPRB,4.7670E+01_JPRB,5.7820E+01_JPRB,6.6989E+01_JPRB,7.0669E+01_JPRB/)
KBO( :, 3,59,14) = (/&
&5.4223E+01_JPRB,5.4191E+01_JPRB,4.9817E+01_JPRB,5.5687E+01_JPRB,6.2924E+01_JPRB,6.6331E+01_JPRB/)
KBO( :, 4,59,14) = (/&
&6.0110E+01_JPRB,6.0074E+01_JPRB,5.1957E+01_JPRB,5.3831E+01_JPRB,5.9105E+01_JPRB,6.2224E+01_JPRB/)
KBO( :, 5,59,14) = (/&
&6.5318E+01_JPRB,6.5279E+01_JPRB,5.4011E+01_JPRB,5.2258E+01_JPRB,5.5565E+01_JPRB,5.8638E+01_JPRB/)
KBO( :, 1,13,15) = (/&
&3.6131E+01_JPRB,3.6111E+01_JPRB,2.7504E+01_JPRB,1.8893E+01_JPRB,1.0455E+01_JPRB,8.3589E+00_JPRB/)
KBO( :, 2,13,15) = (/&
&3.5587E+01_JPRB,3.5567E+01_JPRB,2.7173E+01_JPRB,1.8796E+01_JPRB,1.0430E+01_JPRB,8.1741E+00_JPRB/)
KBO( :, 3,13,15) = (/&
&3.5232E+01_JPRB,3.5212E+01_JPRB,2.6920E+01_JPRB,1.8645E+01_JPRB,1.0345E+01_JPRB,8.4671E+00_JPRB/)
KBO( :, 4,13,15) = (/&
&3.5001E+01_JPRB,3.4981E+01_JPRB,2.6729E+01_JPRB,1.8467E+01_JPRB,1.0232E+01_JPRB,9.0834E+00_JPRB/)
KBO( :, 5,13,15) = (/&
&3.4785E+01_JPRB,3.4765E+01_JPRB,2.6543E+01_JPRB,1.8302E+01_JPRB,1.0125E+01_JPRB,1.1028E+01_JPRB/)
KBO( :, 1,14,15) = (/&
&4.1079E+01_JPRB,4.1055E+01_JPRB,3.1300E+01_JPRB,2.1582E+01_JPRB,1.1853E+01_JPRB,9.3349E+00_JPRB/)
KBO( :, 2,14,15) = (/&
&4.0876E+01_JPRB,4.0852E+01_JPRB,3.1181E+01_JPRB,2.1527E+01_JPRB,1.1831E+01_JPRB,9.0870E+00_JPRB/)
KBO( :, 3,14,15) = (/&
&4.0794E+01_JPRB,4.0770E+01_JPRB,3.1110E+01_JPRB,2.1447E+01_JPRB,1.1767E+01_JPRB,9.0396E+00_JPRB/)
KBO( :, 4,14,15) = (/&
&4.0674E+01_JPRB,4.0650E+01_JPRB,3.1006E+01_JPRB,2.1331E+01_JPRB,1.1685E+01_JPRB,9.1026E+00_JPRB/)
KBO( :, 5,14,15) = (/&
&4.0556E+01_JPRB,4.0533E+01_JPRB,3.0850E+01_JPRB,2.1168E+01_JPRB,1.1577E+01_JPRB,9.5160E+00_JPRB/)
KBO( :, 1,15,15) = (/&
&4.7326E+01_JPRB,4.7299E+01_JPRB,3.6027E+01_JPRB,2.4785E+01_JPRB,1.3503E+01_JPRB,1.0407E+01_JPRB/)
KBO( :, 2,15,15) = (/&
&4.7413E+01_JPRB,4.7386E+01_JPRB,3.6106E+01_JPRB,2.4831E+01_JPRB,1.3509E+01_JPRB,1.0116E+01_JPRB/)
KBO( :, 3,15,15) = (/&
&4.7425E+01_JPRB,4.7398E+01_JPRB,3.6101E+01_JPRB,2.4790E+01_JPRB,1.3473E+01_JPRB,9.8259E+00_JPRB/)
KBO( :, 4,15,15) = (/&
&4.7432E+01_JPRB,4.7405E+01_JPRB,3.6056E+01_JPRB,2.4680E+01_JPRB,1.3388E+01_JPRB,9.8639E+00_JPRB/)
KBO( :, 5,15,15) = (/&
&4.7370E+01_JPRB,4.7342E+01_JPRB,3.5942E+01_JPRB,2.4552E+01_JPRB,1.3257E+01_JPRB,9.8173E+00_JPRB/)
KBO( :, 1,16,15) = (/&
&5.4875E+01_JPRB,5.4844E+01_JPRB,4.1702E+01_JPRB,2.8578E+01_JPRB,1.5437E+01_JPRB,1.1664E+01_JPRB/)
KBO( :, 2,16,15) = (/&
&5.5032E+01_JPRB,5.5000E+01_JPRB,4.1823E+01_JPRB,2.8656E+01_JPRB,1.5467E+01_JPRB,1.1353E+01_JPRB/)
KBO( :, 3,16,15) = (/&
&5.5199E+01_JPRB,5.5167E+01_JPRB,4.1916E+01_JPRB,2.8637E+01_JPRB,1.5432E+01_JPRB,1.1037E+01_JPRB/)
KBO( :, 4,16,15) = (/&
&5.5276E+01_JPRB,5.5244E+01_JPRB,4.1910E+01_JPRB,2.8561E+01_JPRB,1.5341E+01_JPRB,1.0976E+01_JPRB/)
KBO( :, 5,16,15) = (/&
&5.5278E+01_JPRB,5.5245E+01_JPRB,4.1857E+01_JPRB,2.8461E+01_JPRB,1.5222E+01_JPRB,1.0876E+01_JPRB/)
KBO( :, 1,17,15) = (/&
&6.3573E+01_JPRB,6.3536E+01_JPRB,4.8216E+01_JPRB,3.2905E+01_JPRB,1.7651E+01_JPRB,1.3317E+01_JPRB/)
KBO( :, 2,17,15) = (/&
&6.3845E+01_JPRB,6.3808E+01_JPRB,4.8400E+01_JPRB,3.2984E+01_JPRB,1.7690E+01_JPRB,1.2970E+01_JPRB/)
KBO( :, 3,17,15) = (/&
&6.4023E+01_JPRB,6.3985E+01_JPRB,4.8498E+01_JPRB,3.2989E+01_JPRB,1.7656E+01_JPRB,1.2620E+01_JPRB/)
KBO( :, 4,17,15) = (/&
&6.4166E+01_JPRB,6.4129E+01_JPRB,4.8557E+01_JPRB,3.2962E+01_JPRB,1.7567E+01_JPRB,1.2436E+01_JPRB/)
KBO( :, 5,17,15) = (/&
&6.4111E+01_JPRB,6.4073E+01_JPRB,4.8467E+01_JPRB,3.2855E+01_JPRB,1.7451E+01_JPRB,1.2281E+01_JPRB/)
KBO( :, 1,18,15) = (/&
&7.3440E+01_JPRB,7.3397E+01_JPRB,5.5592E+01_JPRB,3.7776E+01_JPRB,2.0119E+01_JPRB,1.5329E+01_JPRB/)
KBO( :, 2,18,15) = (/&
&7.3743E+01_JPRB,7.3700E+01_JPRB,5.5787E+01_JPRB,3.7865E+01_JPRB,2.0169E+01_JPRB,1.4924E+01_JPRB/)
KBO( :, 3,18,15) = (/&
&7.3962E+01_JPRB,7.3919E+01_JPRB,5.5904E+01_JPRB,3.7908E+01_JPRB,2.0135E+01_JPRB,1.4518E+01_JPRB/)
KBO( :, 4,18,15) = (/&
&7.3953E+01_JPRB,7.3909E+01_JPRB,5.5863E+01_JPRB,3.7855E+01_JPRB,2.0062E+01_JPRB,1.4197E+01_JPRB/)
KBO( :, 5,18,15) = (/&
&7.3825E+01_JPRB,7.3781E+01_JPRB,5.5741E+01_JPRB,3.7729E+01_JPRB,1.9926E+01_JPRB,1.3956E+01_JPRB/)
KBO( :, 1,19,15) = (/&
&8.4462E+01_JPRB,8.4413E+01_JPRB,6.3820E+01_JPRB,4.3253E+01_JPRB,2.2902E+01_JPRB,1.7600E+01_JPRB/)
KBO( :, 2,19,15) = (/&
&8.4860E+01_JPRB,8.4810E+01_JPRB,6.4094E+01_JPRB,4.3382E+01_JPRB,2.2923E+01_JPRB,1.7125E+01_JPRB/)
KBO( :, 3,19,15) = (/&
&8.4963E+01_JPRB,8.4913E+01_JPRB,6.4146E+01_JPRB,4.3401E+01_JPRB,2.2894E+01_JPRB,1.6619E+01_JPRB/)
KBO( :, 4,19,15) = (/&
&8.4919E+01_JPRB,8.4869E+01_JPRB,6.4089E+01_JPRB,4.3332E+01_JPRB,2.2791E+01_JPRB,1.6133E+01_JPRB/)
KBO( :, 5,19,15) = (/&
&8.4612E+01_JPRB,8.4563E+01_JPRB,6.3846E+01_JPRB,4.3142E+01_JPRB,2.2633E+01_JPRB,1.5830E+01_JPRB/)
KBO( :, 1,20,15) = (/&
&9.7043E+01_JPRB,9.6986E+01_JPRB,7.3234E+01_JPRB,4.9485E+01_JPRB,2.5962E+01_JPRB,2.0077E+01_JPRB/)
KBO( :, 2,20,15) = (/&
&9.7332E+01_JPRB,9.7275E+01_JPRB,7.3444E+01_JPRB,4.9611E+01_JPRB,2.5984E+01_JPRB,1.9505E+01_JPRB/)
KBO( :, 3,20,15) = (/&
&9.7370E+01_JPRB,9.7313E+01_JPRB,7.3448E+01_JPRB,4.9583E+01_JPRB,2.5915E+01_JPRB,1.8890E+01_JPRB/)
KBO( :, 4,20,15) = (/&
&9.7125E+01_JPRB,9.7068E+01_JPRB,7.3251E+01_JPRB,4.9424E+01_JPRB,2.5774E+01_JPRB,1.8285E+01_JPRB/)
KBO( :, 5,20,15) = (/&
&9.6643E+01_JPRB,9.6586E+01_JPRB,7.2853E+01_JPRB,4.9111E+01_JPRB,2.5548E+01_JPRB,1.7915E+01_JPRB/)
KBO( :, 1,21,15) = (/&
&1.1092E+02_JPRB,1.1085E+02_JPRB,8.3649E+01_JPRB,5.6418E+01_JPRB,2.9378E+01_JPRB,2.2812E+01_JPRB/)
KBO( :, 2,21,15) = (/&
&1.1109E+02_JPRB,1.1103E+02_JPRB,8.3756E+01_JPRB,5.6460E+01_JPRB,2.9344E+01_JPRB,2.2156E+01_JPRB/)
KBO( :, 3,21,15) = (/&
&1.1096E+02_JPRB,1.1089E+02_JPRB,8.3624E+01_JPRB,5.6337E+01_JPRB,2.9225E+01_JPRB,2.1484E+01_JPRB/)
KBO( :, 4,21,15) = (/&
&1.1048E+02_JPRB,1.1042E+02_JPRB,8.3238E+01_JPRB,5.6034E+01_JPRB,2.9000E+01_JPRB,2.0793E+01_JPRB/)
KBO( :, 5,21,15) = (/&
&1.0971E+02_JPRB,1.0964E+02_JPRB,8.2635E+01_JPRB,5.5599E+01_JPRB,2.8723E+01_JPRB,2.0338E+01_JPRB/)
KBO( :, 1,22,15) = (/&
&1.2596E+02_JPRB,1.2589E+02_JPRB,9.4893E+01_JPRB,6.3871E+01_JPRB,3.3059E+01_JPRB,2.5998E+01_JPRB/)
KBO( :, 2,22,15) = (/&
&1.2587E+02_JPRB,1.2580E+02_JPRB,9.4816E+01_JPRB,6.3793E+01_JPRB,3.2943E+01_JPRB,2.5227E+01_JPRB/)
KBO( :, 3,22,15) = (/&
&1.2541E+02_JPRB,1.2533E+02_JPRB,9.4434E+01_JPRB,6.3497E+01_JPRB,3.2730E+01_JPRB,2.4435E+01_JPRB/)
KBO( :, 4,22,15) = (/&
&1.2461E+02_JPRB,1.2453E+02_JPRB,9.3802E+01_JPRB,6.3040E+01_JPRB,3.2441E+01_JPRB,2.3619E+01_JPRB/)
KBO( :, 5,22,15) = (/&
&1.2345E+02_JPRB,1.2338E+02_JPRB,9.2915E+01_JPRB,6.2412E+01_JPRB,3.2063E+01_JPRB,2.3036E+01_JPRB/)
KBO( :, 1,23,15) = (/&
&1.4197E+02_JPRB,1.4188E+02_JPRB,1.0687E+02_JPRB,7.1809E+01_JPRB,3.7052E+01_JPRB,2.9587E+01_JPRB/)
KBO( :, 2,23,15) = (/&
&1.4145E+02_JPRB,1.4137E+02_JPRB,1.0646E+02_JPRB,7.1497E+01_JPRB,3.6788E+01_JPRB,2.8648E+01_JPRB/)
KBO( :, 3,23,15) = (/&
&1.4055E+02_JPRB,1.4047E+02_JPRB,1.0576E+02_JPRB,7.1003E+01_JPRB,3.6445E+01_JPRB,2.7684E+01_JPRB/)
KBO( :, 4,23,15) = (/&
&1.3924E+02_JPRB,1.3916E+02_JPRB,1.0475E+02_JPRB,7.0305E+01_JPRB,3.6030E+01_JPRB,2.6707E+01_JPRB/)
KBO( :, 5,23,15) = (/&
&1.3763E+02_JPRB,1.3754E+02_JPRB,1.0352E+02_JPRB,6.9448E+01_JPRB,3.5536E+01_JPRB,2.5941E+01_JPRB/)
KBO( :, 1,24,15) = (/&
&1.5875E+02_JPRB,1.5866E+02_JPRB,1.1943E+02_JPRB,8.0138E+01_JPRB,4.1339E+01_JPRB,3.3488E+01_JPRB/)
KBO( :, 2,24,15) = (/&
&1.5772E+02_JPRB,1.5762E+02_JPRB,1.1862E+02_JPRB,7.9566E+01_JPRB,4.0871E+01_JPRB,3.2326E+01_JPRB/)
KBO( :, 3,24,15) = (/&
&1.5618E+02_JPRB,1.5608E+02_JPRB,1.1744E+02_JPRB,7.8741E+01_JPRB,4.0347E+01_JPRB,3.1135E+01_JPRB/)
KBO( :, 4,24,15) = (/&
&1.5432E+02_JPRB,1.5423E+02_JPRB,1.1603E+02_JPRB,7.7772E+01_JPRB,3.9739E+01_JPRB,2.9970E+01_JPRB/)
KBO( :, 5,24,15) = (/&
&1.5201E+02_JPRB,1.5192E+02_JPRB,1.1428E+02_JPRB,7.6577E+01_JPRB,3.9078E+01_JPRB,2.8958E+01_JPRB/)
KBO( :, 1,25,15) = (/&
&1.7605E+02_JPRB,1.7595E+02_JPRB,1.3237E+02_JPRB,8.8710E+01_JPRB,4.5816E+01_JPRB,3.7592E+01_JPRB/)
KBO( :, 2,25,15) = (/&
&1.7422E+02_JPRB,1.7412E+02_JPRB,1.3097E+02_JPRB,8.7758E+01_JPRB,4.5131E+01_JPRB,3.6159E+01_JPRB/)
KBO( :, 3,25,15) = (/&
&1.7201E+02_JPRB,1.7191E+02_JPRB,1.2929E+02_JPRB,8.6602E+01_JPRB,4.4346E+01_JPRB,3.4734E+01_JPRB/)
KBO( :, 4,25,15) = (/&
&1.6938E+02_JPRB,1.6928E+02_JPRB,1.2730E+02_JPRB,8.5245E+01_JPRB,4.3518E+01_JPRB,3.3295E+01_JPRB/)
KBO( :, 5,25,15) = (/&
&1.6630E+02_JPRB,1.6620E+02_JPRB,1.2498E+02_JPRB,8.3665E+01_JPRB,4.2629E+01_JPRB,3.2020E+01_JPRB/)
KBO( :, 1,26,15) = (/&
&1.9312E+02_JPRB,1.9300E+02_JPRB,1.4513E+02_JPRB,9.7167E+01_JPRB,5.0350E+01_JPRB,4.1741E+01_JPRB/)
KBO( :, 2,26,15) = (/&
&1.9055E+02_JPRB,1.9044E+02_JPRB,1.4319E+02_JPRB,9.5848E+01_JPRB,4.9379E+01_JPRB,3.9996E+01_JPRB/)
KBO( :, 3,26,15) = (/&
&1.8750E+02_JPRB,1.8738E+02_JPRB,1.4088E+02_JPRB,9.4283E+01_JPRB,4.8328E+01_JPRB,3.8277E+01_JPRB/)
KBO( :, 4,26,15) = (/&
&1.8390E+02_JPRB,1.8379E+02_JPRB,1.3817E+02_JPRB,9.2456E+01_JPRB,4.7225E+01_JPRB,3.6567E+01_JPRB/)
KBO( :, 5,26,15) = (/&
&1.8004E+02_JPRB,1.7993E+02_JPRB,1.3525E+02_JPRB,9.0479E+01_JPRB,4.6075E+01_JPRB,3.5023E+01_JPRB/)
KBO( :, 1,27,15) = (/&
&2.0962E+02_JPRB,2.0950E+02_JPRB,1.5747E+02_JPRB,1.0535E+02_JPRB,5.4802E+01_JPRB,4.5812E+01_JPRB/)
KBO( :, 2,27,15) = (/&
&2.0617E+02_JPRB,2.0605E+02_JPRB,1.5487E+02_JPRB,1.0359E+02_JPRB,5.3500E+01_JPRB,4.3722E+01_JPRB/)
KBO( :, 3,27,15) = (/&
&2.0210E+02_JPRB,2.0198E+02_JPRB,1.5180E+02_JPRB,1.0153E+02_JPRB,5.2160E+01_JPRB,4.1668E+01_JPRB/)
KBO( :, 4,27,15) = (/&
&1.9765E+02_JPRB,1.9753E+02_JPRB,1.4844E+02_JPRB,9.9264E+01_JPRB,5.0764E+01_JPRB,3.9657E+01_JPRB/)
KBO( :, 5,27,15) = (/&
&1.9285E+02_JPRB,1.9273E+02_JPRB,1.4483E+02_JPRB,9.6837E+01_JPRB,4.9332E+01_JPRB,3.7870E+01_JPRB/)
KBO( :, 1,28,15) = (/&
&2.2504E+02_JPRB,2.2491E+02_JPRB,1.6900E+02_JPRB,1.1299E+02_JPRB,5.9023E+01_JPRB,4.9671E+01_JPRB/)
KBO( :, 2,28,15) = (/&
&2.2060E+02_JPRB,2.2047E+02_JPRB,1.6566E+02_JPRB,1.1075E+02_JPRB,5.7389E+01_JPRB,4.7215E+01_JPRB/)
KBO( :, 3,28,15) = (/&
&2.1560E+02_JPRB,2.1547E+02_JPRB,1.6190E+02_JPRB,1.0822E+02_JPRB,5.5706E+01_JPRB,4.4816E+01_JPRB/)
KBO( :, 4,28,15) = (/&
&2.1015E+02_JPRB,2.1002E+02_JPRB,1.5779E+02_JPRB,1.0547E+02_JPRB,5.4003E+01_JPRB,4.2483E+01_JPRB/)
KBO( :, 5,28,15) = (/&
&2.0436E+02_JPRB,2.0424E+02_JPRB,1.5344E+02_JPRB,1.0255E+02_JPRB,5.2316E+01_JPRB,4.0478E+01_JPRB/)
KBO( :, 1,29,15) = (/&
&2.3909E+02_JPRB,2.3895E+02_JPRB,1.7950E+02_JPRB,1.1994E+02_JPRB,6.2884E+01_JPRB,5.3166E+01_JPRB/)
KBO( :, 2,29,15) = (/&
&2.3356E+02_JPRB,2.3342E+02_JPRB,1.7535E+02_JPRB,1.1717E+02_JPRB,6.0903E+01_JPRB,5.0319E+01_JPRB/)
KBO( :, 3,29,15) = (/&
&2.2760E+02_JPRB,2.2747E+02_JPRB,1.7088E+02_JPRB,1.1417E+02_JPRB,5.8870E+01_JPRB,4.7588E+01_JPRB/)
KBO( :, 4,29,15) = (/&
&2.2117E+02_JPRB,2.2104E+02_JPRB,1.6604E+02_JPRB,1.1094E+02_JPRB,5.6871E+01_JPRB,4.4984E+01_JPRB/)
KBO( :, 5,29,15) = (/&
&2.1449E+02_JPRB,2.1436E+02_JPRB,1.6102E+02_JPRB,1.0757E+02_JPRB,5.4912E+01_JPRB,4.2890E+01_JPRB/)
KBO( :, 1,30,15) = (/&
&2.5146E+02_JPRB,2.5131E+02_JPRB,1.8876E+02_JPRB,1.2608E+02_JPRB,6.6304E+01_JPRB,5.6220E+01_JPRB/)
KBO( :, 2,30,15) = (/&
&2.4482E+02_JPRB,2.4467E+02_JPRB,1.8377E+02_JPRB,1.2275E+02_JPRB,6.3959E+01_JPRB,5.3007E+01_JPRB/)
KBO( :, 3,30,15) = (/&
&2.3792E+02_JPRB,2.3777E+02_JPRB,1.7859E+02_JPRB,1.1929E+02_JPRB,6.1625E+01_JPRB,4.9952E+01_JPRB/)
KBO( :, 4,30,15) = (/&
&2.3061E+02_JPRB,2.3047E+02_JPRB,1.7311E+02_JPRB,1.1562E+02_JPRB,5.9353E+01_JPRB,4.7238E+01_JPRB/)
KBO( :, 5,30,15) = (/&
&2.2308E+02_JPRB,2.2295E+02_JPRB,1.6746E+02_JPRB,1.1184E+02_JPRB,5.7116E+01_JPRB,4.4978E+01_JPRB/)
KBO( :, 1,31,15) = (/&
&2.6202E+02_JPRB,2.6186E+02_JPRB,1.9666E+02_JPRB,1.3132E+02_JPRB,6.9199E+01_JPRB,5.8789E+01_JPRB/)
KBO( :, 2,31,15) = (/&
&2.5437E+02_JPRB,2.5422E+02_JPRB,1.9092E+02_JPRB,1.2749E+02_JPRB,6.6513E+01_JPRB,5.5233E+01_JPRB/)
KBO( :, 3,31,15) = (/&
&2.4648E+02_JPRB,2.4634E+02_JPRB,1.8501E+02_JPRB,1.2354E+02_JPRB,6.3925E+01_JPRB,5.1946E+01_JPRB/)
KBO( :, 4,31,15) = (/&
&2.3838E+02_JPRB,2.3824E+02_JPRB,1.7892E+02_JPRB,1.1948E+02_JPRB,6.1400E+01_JPRB,4.9329E+01_JPRB/)
KBO( :, 5,31,15) = (/&
&2.3010E+02_JPRB,2.2996E+02_JPRB,1.7271E+02_JPRB,1.1532E+02_JPRB,5.8925E+01_JPRB,4.6712E+01_JPRB/)
KBO( :, 1,32,15) = (/&
&2.7074E+02_JPRB,2.7057E+02_JPRB,2.0319E+02_JPRB,1.3565E+02_JPRB,7.1571E+01_JPRB,6.0821E+01_JPRB/)
KBO( :, 2,32,15) = (/&
&2.6218E+02_JPRB,2.6203E+02_JPRB,1.9677E+02_JPRB,1.3137E+02_JPRB,6.8590E+01_JPRB,5.6967E+01_JPRB/)
KBO( :, 3,32,15) = (/&
&2.5343E+02_JPRB,2.5328E+02_JPRB,1.9020E+02_JPRB,1.2698E+02_JPRB,6.5765E+01_JPRB,5.3801E+01_JPRB/)
KBO( :, 4,32,15) = (/&
&2.4457E+02_JPRB,2.4443E+02_JPRB,1.8356E+02_JPRB,1.2255E+02_JPRB,6.3014E+01_JPRB,5.0945E+01_JPRB/)
KBO( :, 5,32,15) = (/&
&2.3559E+02_JPRB,2.3545E+02_JPRB,1.7681E+02_JPRB,1.1805E+02_JPRB,6.0339E+01_JPRB,4.8062E+01_JPRB/)
KBO( :, 1,33,15) = (/&
&2.7764E+02_JPRB,2.7748E+02_JPRB,2.0836E+02_JPRB,1.3907E+02_JPRB,7.3436E+01_JPRB,6.2345E+01_JPRB/)
KBO( :, 2,33,15) = (/&
&2.6829E+02_JPRB,2.6813E+02_JPRB,2.0135E+02_JPRB,1.3440E+02_JPRB,7.0216E+01_JPRB,5.8526E+01_JPRB/)
KBO( :, 3,33,15) = (/&
&2.5890E+02_JPRB,2.5874E+02_JPRB,1.9430E+02_JPRB,1.2970E+02_JPRB,6.7179E+01_JPRB,5.5377E+01_JPRB/)
KBO( :, 4,33,15) = (/&
&2.4933E+02_JPRB,2.4918E+02_JPRB,1.8712E+02_JPRB,1.2490E+02_JPRB,6.4220E+01_JPRB,5.2156E+01_JPRB/)
KBO( :, 5,33,15) = (/&
&2.3975E+02_JPRB,2.3960E+02_JPRB,1.7993E+02_JPRB,1.2011E+02_JPRB,6.1401E+01_JPRB,4.9280E+01_JPRB/)
KBO( :, 1,34,15) = (/&
&2.8330E+02_JPRB,2.8313E+02_JPRB,2.1259E+02_JPRB,1.4188E+02_JPRB,7.4943E+01_JPRB,6.3611E+01_JPRB/)
KBO( :, 2,34,15) = (/&
&2.7328E+02_JPRB,2.7312E+02_JPRB,2.0508E+02_JPRB,1.3687E+02_JPRB,7.1539E+01_JPRB,6.0040E+01_JPRB/)
KBO( :, 3,34,15) = (/&
&2.6322E+02_JPRB,2.6306E+02_JPRB,1.9753E+02_JPRB,1.3184E+02_JPRB,6.8302E+01_JPRB,5.6531E+01_JPRB/)
KBO( :, 4,34,15) = (/&
&2.5315E+02_JPRB,2.5300E+02_JPRB,1.8997E+02_JPRB,1.2680E+02_JPRB,6.5194E+01_JPRB,5.3134E+01_JPRB/)
KBO( :, 5,34,15) = (/&
&2.4305E+02_JPRB,2.4290E+02_JPRB,1.8239E+02_JPRB,1.2174E+02_JPRB,6.2238E+01_JPRB,5.0964E+01_JPRB/)
KBO( :, 1,35,15) = (/&
&2.8856E+02_JPRB,2.8838E+02_JPRB,2.1653E+02_JPRB,1.4450E+02_JPRB,7.6402E+01_JPRB,6.5174E+01_JPRB/)
KBO( :, 2,35,15) = (/&
&2.7804E+02_JPRB,2.7787E+02_JPRB,2.0864E+02_JPRB,1.3924E+02_JPRB,7.2828E+01_JPRB,6.1468E+01_JPRB/)
KBO( :, 3,35,15) = (/&
&2.6749E+02_JPRB,2.6733E+02_JPRB,2.0072E+02_JPRB,1.3396E+02_JPRB,6.9428E+01_JPRB,5.7687E+01_JPRB/)
KBO( :, 4,35,15) = (/&
&2.5691E+02_JPRB,2.5675E+02_JPRB,1.9278E+02_JPRB,1.2866E+02_JPRB,6.6172E+01_JPRB,5.4537E+01_JPRB/)
KBO( :, 5,35,15) = (/&
&2.4636E+02_JPRB,2.4621E+02_JPRB,1.8487E+02_JPRB,1.2339E+02_JPRB,6.3093E+01_JPRB,5.3102E+01_JPRB/)
KBO( :, 1,36,15) = (/&
&2.9394E+02_JPRB,2.9376E+02_JPRB,2.2055E+02_JPRB,1.4717E+02_JPRB,7.7976E+01_JPRB,6.6997E+01_JPRB/)
KBO( :, 2,36,15) = (/&
&2.8294E+02_JPRB,2.8277E+02_JPRB,2.1230E+02_JPRB,1.4167E+02_JPRB,7.4208E+01_JPRB,6.2977E+01_JPRB/)
KBO( :, 3,36,15) = (/&
&2.7194E+02_JPRB,2.7178E+02_JPRB,2.0405E+02_JPRB,1.3617E+02_JPRB,7.0657E+01_JPRB,5.9032E+01_JPRB/)
KBO( :, 4,36,15) = (/&
&2.6092E+02_JPRB,2.6077E+02_JPRB,1.9579E+02_JPRB,1.3066E+02_JPRB,6.7258E+01_JPRB,5.6406E+01_JPRB/)
KBO( :, 5,36,15) = (/&
&2.5003E+02_JPRB,2.4988E+02_JPRB,1.8762E+02_JPRB,1.2521E+02_JPRB,6.4068E+01_JPRB,5.5624E+01_JPRB/)
KBO( :, 1,37,15) = (/&
&3.0017E+02_JPRB,2.9999E+02_JPRB,2.2523E+02_JPRB,1.5028E+02_JPRB,7.9918E+01_JPRB,6.9171E+01_JPRB/)
KBO( :, 2,37,15) = (/&
&2.8870E+02_JPRB,2.8853E+02_JPRB,2.1662E+02_JPRB,1.4454E+02_JPRB,7.5932E+01_JPRB,6.4872E+01_JPRB/)
KBO( :, 3,37,15) = (/&
&2.7736E+02_JPRB,2.7719E+02_JPRB,2.0811E+02_JPRB,1.3887E+02_JPRB,7.2229E+01_JPRB,6.0792E+01_JPRB/)
KBO( :, 4,37,15) = (/&
&2.6599E+02_JPRB,2.6584E+02_JPRB,1.9958E+02_JPRB,1.3319E+02_JPRB,6.8687E+01_JPRB,5.8518E+01_JPRB/)
KBO( :, 5,37,15) = (/&
&2.5476E+02_JPRB,2.5461E+02_JPRB,1.9116E+02_JPRB,1.2757E+02_JPRB,6.5367E+01_JPRB,5.8059E+01_JPRB/)
KBO( :, 1,38,15) = (/&
&3.0587E+02_JPRB,3.0569E+02_JPRB,2.2949E+02_JPRB,1.5312E+02_JPRB,8.1725E+01_JPRB,7.1248E+01_JPRB/)
KBO( :, 2,38,15) = (/&
&2.9408E+02_JPRB,2.9390E+02_JPRB,2.2065E+02_JPRB,1.4722E+02_JPRB,7.7560E+01_JPRB,6.6691E+01_JPRB/)
KBO( :, 3,38,15) = (/&
&2.8234E+02_JPRB,2.8218E+02_JPRB,2.1184E+02_JPRB,1.4135E+02_JPRB,7.3693E+01_JPRB,6.2607E+01_JPRB/)
KBO( :, 4,38,15) = (/&
&2.7064E+02_JPRB,2.7048E+02_JPRB,2.0306E+02_JPRB,1.3550E+02_JPRB,7.0023E+01_JPRB,6.0914E+01_JPRB/)
KBO( :, 5,38,15) = (/&
&2.5911E+02_JPRB,2.5896E+02_JPRB,1.9442E+02_JPRB,1.2974E+02_JPRB,6.6580E+01_JPRB,6.0840E+01_JPRB/)
KBO( :, 1,39,15) = (/&
&3.1101E+02_JPRB,3.1082E+02_JPRB,2.3334E+02_JPRB,1.5567E+02_JPRB,8.3378E+01_JPRB,7.3218E+01_JPRB/)
KBO( :, 2,39,15) = (/&
&2.9887E+02_JPRB,2.9869E+02_JPRB,2.2423E+02_JPRB,1.4960E+02_JPRB,7.9045E+01_JPRB,6.8519E+01_JPRB/)
KBO( :, 3,39,15) = (/&
&2.8683E+02_JPRB,2.8666E+02_JPRB,2.1520E+02_JPRB,1.4359E+02_JPRB,7.5024E+01_JPRB,6.4735E+01_JPRB/)
KBO( :, 4,39,15) = (/&
&2.7487E+02_JPRB,2.7471E+02_JPRB,2.0623E+02_JPRB,1.3761E+02_JPRB,7.1242E+01_JPRB,6.3858E+01_JPRB/)
KBO( :, 5,39,15) = (/&
&2.6303E+02_JPRB,2.6287E+02_JPRB,1.9735E+02_JPRB,1.3169E+02_JPRB,6.7680E+01_JPRB,6.4377E+01_JPRB/)
KBO( :, 1,40,15) = (/&
&3.1694E+02_JPRB,3.1675E+02_JPRB,2.3777E+02_JPRB,1.5862E+02_JPRB,8.5396E+01_JPRB,7.5421E+01_JPRB/)
KBO( :, 2,40,15) = (/&
&3.0448E+02_JPRB,3.0430E+02_JPRB,2.2843E+02_JPRB,1.5240E+02_JPRB,8.0839E+01_JPRB,7.0612E+01_JPRB/)
KBO( :, 3,40,15) = (/&
&2.9221E+02_JPRB,2.9204E+02_JPRB,2.1923E+02_JPRB,1.4627E+02_JPRB,7.6677E+01_JPRB,6.6660E+01_JPRB/)
KBO( :, 4,40,15) = (/&
&2.8000E+02_JPRB,2.7983E+02_JPRB,2.1007E+02_JPRB,1.4017E+02_JPRB,7.2757E+01_JPRB,6.5710E+01_JPRB/)
KBO( :, 5,40,15) = (/&
&2.6789E+02_JPRB,2.6773E+02_JPRB,2.0099E+02_JPRB,1.3412E+02_JPRB,6.9075E+01_JPRB,6.6414E+01_JPRB/)
KBO( :, 1,41,15) = (/&
&3.2263E+02_JPRB,3.2244E+02_JPRB,2.4204E+02_JPRB,1.6146E+02_JPRB,8.7409E+01_JPRB,7.7606E+01_JPRB/)
KBO( :, 2,41,15) = (/&
&3.0995E+02_JPRB,3.0976E+02_JPRB,2.3253E+02_JPRB,1.5513E+02_JPRB,8.2644E+01_JPRB,7.2713E+01_JPRB/)
KBO( :, 3,41,15) = (/&
&2.9738E+02_JPRB,2.9720E+02_JPRB,2.2311E+02_JPRB,1.4885E+02_JPRB,7.8306E+01_JPRB,6.8571E+01_JPRB/)
KBO( :, 4,41,15) = (/&
&2.8499E+02_JPRB,2.8482E+02_JPRB,2.1382E+02_JPRB,1.4266E+02_JPRB,7.4270E+01_JPRB,6.7462E+01_JPRB/)
KBO( :, 5,41,15) = (/&
&2.7266E+02_JPRB,2.7250E+02_JPRB,2.0456E+02_JPRB,1.3649E+02_JPRB,7.0464E+01_JPRB,6.8326E+01_JPRB/)
KBO( :, 1,42,15) = (/&
&3.2806E+02_JPRB,3.2786E+02_JPRB,2.4610E+02_JPRB,1.6416E+02_JPRB,8.9382E+01_JPRB,7.9783E+01_JPRB/)
KBO( :, 2,42,15) = (/&
&3.1513E+02_JPRB,3.1494E+02_JPRB,2.3641E+02_JPRB,1.5771E+02_JPRB,8.4411E+01_JPRB,7.4828E+01_JPRB/)
KBO( :, 3,42,15) = (/&
&3.0236E+02_JPRB,3.0217E+02_JPRB,2.2683E+02_JPRB,1.5133E+02_JPRB,7.9899E+01_JPRB,7.0566E+01_JPRB/)
KBO( :, 4,42,15) = (/&
&2.8974E+02_JPRB,2.8956E+02_JPRB,2.1737E+02_JPRB,1.4502E+02_JPRB,7.5728E+01_JPRB,6.9377E+01_JPRB/)
KBO( :, 5,42,15) = (/&
&2.7725E+02_JPRB,2.7708E+02_JPRB,2.0800E+02_JPRB,1.3878E+02_JPRB,7.1813E+01_JPRB,7.0507E+01_JPRB/)
KBO( :, 1,43,15) = (/&
&3.3393E+02_JPRB,3.3373E+02_JPRB,2.5050E+02_JPRB,1.6709E+02_JPRB,9.1659E+01_JPRB,8.2181E+01_JPRB/)
KBO( :, 2,43,15) = (/&
&3.2087E+02_JPRB,3.2068E+02_JPRB,2.4071E+02_JPRB,1.6058E+02_JPRB,8.6435E+01_JPRB,7.7203E+01_JPRB/)
KBO( :, 3,43,15) = (/&
&3.0784E+02_JPRB,3.0766E+02_JPRB,2.3094E+02_JPRB,1.5407E+02_JPRB,8.1705E+01_JPRB,7.2734E+01_JPRB/)
KBO( :, 4,43,15) = (/&
&2.9498E+02_JPRB,2.9480E+02_JPRB,2.2130E+02_JPRB,1.4764E+02_JPRB,7.7383E+01_JPRB,7.1244E+01_JPRB/)
KBO( :, 5,43,15) = (/&
&2.8236E+02_JPRB,2.8219E+02_JPRB,2.1184E+02_JPRB,1.4134E+02_JPRB,7.3355E+01_JPRB,7.2525E+01_JPRB/)
KBO( :, 1,44,15) = (/&
&3.3993E+02_JPRB,3.3973E+02_JPRB,2.5500E+02_JPRB,1.7009E+02_JPRB,9.4079E+01_JPRB,8.4777E+01_JPRB/)
KBO( :, 2,44,15) = (/&
&3.2668E+02_JPRB,3.2648E+02_JPRB,2.4506E+02_JPRB,1.6347E+02_JPRB,8.8568E+01_JPRB,7.9722E+01_JPRB/)
KBO( :, 3,44,15) = (/&
&3.1350E+02_JPRB,3.1331E+02_JPRB,2.3519E+02_JPRB,1.5690E+02_JPRB,8.3629E+01_JPRB,7.5073E+01_JPRB/)
KBO( :, 4,44,15) = (/&
&3.0048E+02_JPRB,3.0030E+02_JPRB,2.2542E+02_JPRB,1.5039E+02_JPRB,7.9147E+01_JPRB,7.3210E+01_JPRB/)
KBO( :, 5,44,15) = (/&
&2.8768E+02_JPRB,2.8750E+02_JPRB,2.1582E+02_JPRB,1.4399E+02_JPRB,7.4989E+01_JPRB,7.4615E+01_JPRB/)
KBO( :, 1,45,15) = (/&
&3.4570E+02_JPRB,3.4549E+02_JPRB,2.5932E+02_JPRB,1.7296E+02_JPRB,9.6495E+01_JPRB,8.7516E+01_JPRB/)
KBO( :, 2,45,15) = (/&
&3.3235E+02_JPRB,3.3215E+02_JPRB,2.4931E+02_JPRB,1.6630E+02_JPRB,9.0736E+01_JPRB,8.2360E+01_JPRB/)
KBO( :, 3,45,15) = (/&
&3.1903E+02_JPRB,3.1884E+02_JPRB,2.3933E+02_JPRB,1.5965E+02_JPRB,8.5580E+01_JPRB,7.7592E+01_JPRB/)
KBO( :, 4,45,15) = (/&
&3.0583E+02_JPRB,3.0564E+02_JPRB,2.2943E+02_JPRB,1.5306E+02_JPRB,8.0904E+01_JPRB,7.5512E+01_JPRB/)
KBO( :, 5,45,15) = (/&
&2.9285E+02_JPRB,2.9267E+02_JPRB,2.1969E+02_JPRB,1.4657E+02_JPRB,7.6606E+01_JPRB,7.7136E+01_JPRB/)
KBO( :, 1,46,15) = (/&
&3.5162E+02_JPRB,3.5141E+02_JPRB,2.6376E+02_JPRB,1.7592E+02_JPRB,9.9116E+01_JPRB,9.0486E+01_JPRB/)
KBO( :, 2,46,15) = (/&
&3.3821E+02_JPRB,3.3800E+02_JPRB,2.5370E+02_JPRB,1.6922E+02_JPRB,9.3089E+01_JPRB,8.5193E+01_JPRB/)
KBO( :, 3,46,15) = (/&
&3.2475E+02_JPRB,3.2455E+02_JPRB,2.4361E+02_JPRB,1.6250E+02_JPRB,8.7670E+01_JPRB,8.0271E+01_JPRB/)
KBO( :, 4,46,15) = (/&
&3.1144E+02_JPRB,3.1126E+02_JPRB,2.3364E+02_JPRB,1.5586E+02_JPRB,8.2789E+01_JPRB,7.7967E+01_JPRB/)
KBO( :, 5,46,15) = (/&
&2.9826E+02_JPRB,2.9808E+02_JPRB,2.2376E+02_JPRB,1.4928E+02_JPRB,7.8339E+01_JPRB,7.9667E+01_JPRB/)
KBO( :, 1,47,15) = (/&
&3.5795E+02_JPRB,3.5773E+02_JPRB,2.6850E+02_JPRB,1.7907E+02_JPRB,1.0208E+02_JPRB,9.3825E+01_JPRB/)
KBO( :, 2,47,15) = (/&
&3.4453E+02_JPRB,3.4432E+02_JPRB,2.5844E+02_JPRB,1.7237E+02_JPRB,9.5731E+01_JPRB,8.8246E+01_JPRB/)
KBO( :, 3,47,15) = (/&
&3.3096E+02_JPRB,3.3076E+02_JPRB,2.4827E+02_JPRB,1.6560E+02_JPRB,9.0023E+01_JPRB,8.3072E+01_JPRB/)
KBO( :, 4,47,15) = (/&
&3.1751E+02_JPRB,3.1732E+02_JPRB,2.3819E+02_JPRB,1.5889E+02_JPRB,8.4913E+01_JPRB,8.0301E+01_JPRB/)
KBO( :, 5,47,15) = (/&
&3.0419E+02_JPRB,3.0401E+02_JPRB,2.2820E+02_JPRB,1.5224E+02_JPRB,8.0275E+01_JPRB,8.1585E+01_JPRB/)
KBO( :, 1,48,15) = (/&
&3.6405E+02_JPRB,3.6383E+02_JPRB,2.7307E+02_JPRB,1.8212E+02_JPRB,1.0516E+02_JPRB,9.7509E+01_JPRB/)
KBO( :, 2,48,15) = (/&
&3.5068E+02_JPRB,3.5047E+02_JPRB,2.6305E+02_JPRB,1.7544E+02_JPRB,9.8444E+01_JPRB,9.1443E+01_JPRB/)
KBO( :, 3,48,15) = (/&
&3.3709E+02_JPRB,3.3688E+02_JPRB,2.5286E+02_JPRB,1.6866E+02_JPRB,9.2465E+01_JPRB,8.6144E+01_JPRB/)
KBO( :, 4,48,15) = (/&
&3.2352E+02_JPRB,3.2332E+02_JPRB,2.4269E+02_JPRB,1.6188E+02_JPRB,8.7099E+01_JPRB,8.3145E+01_JPRB/)
KBO( :, 5,48,15) = (/&
&3.1006E+02_JPRB,3.0987E+02_JPRB,2.3260E+02_JPRB,1.5516E+02_JPRB,8.2249E+01_JPRB,8.4244E+01_JPRB/)
KBO( :, 1,49,15) = (/&
&3.7003E+02_JPRB,3.6981E+02_JPRB,2.7756E+02_JPRB,1.8510E+02_JPRB,1.0838E+02_JPRB,1.0148E+02_JPRB/)
KBO( :, 2,49,15) = (/&
&3.5675E+02_JPRB,3.5654E+02_JPRB,2.6761E+02_JPRB,1.7847E+02_JPRB,1.0127E+02_JPRB,9.4886E+01_JPRB/)
KBO( :, 3,49,15) = (/&
&3.4318E+02_JPRB,3.4298E+02_JPRB,2.5743E+02_JPRB,1.7170E+02_JPRB,9.5003E+01_JPRB,8.9591E+01_JPRB/)
KBO( :, 4,49,15) = (/&
&3.2947E+02_JPRB,3.2927E+02_JPRB,2.4715E+02_JPRB,1.6485E+02_JPRB,8.9342E+01_JPRB,8.6726E+01_JPRB/)
KBO( :, 5,49,15) = (/&
&3.1591E+02_JPRB,3.1572E+02_JPRB,2.3699E+02_JPRB,1.5809E+02_JPRB,8.4278E+01_JPRB,8.8051E+01_JPRB/)
KBO( :, 1,50,15) = (/&
&3.7556E+02_JPRB,3.7534E+02_JPRB,2.8170E+02_JPRB,1.8786E+02_JPRB,1.1154E+02_JPRB,1.0526E+02_JPRB/)
KBO( :, 2,50,15) = (/&
&3.6235E+02_JPRB,3.6213E+02_JPRB,2.7180E+02_JPRB,1.8127E+02_JPRB,1.0404E+02_JPRB,9.7933E+01_JPRB/)
KBO( :, 3,50,15) = (/&
&3.4884E+02_JPRB,3.4863E+02_JPRB,2.6167E+02_JPRB,1.7452E+02_JPRB,9.7449E+01_JPRB,9.2614E+01_JPRB/)
KBO( :, 4,50,15) = (/&
&3.3508E+02_JPRB,3.3488E+02_JPRB,2.5136E+02_JPRB,1.6766E+02_JPRB,9.1542E+01_JPRB,8.9470E+01_JPRB/)
KBO( :, 5,50,15) = (/&
&3.2141E+02_JPRB,3.2122E+02_JPRB,2.4111E+02_JPRB,1.6083E+02_JPRB,8.6254E+01_JPRB,9.0426E+01_JPRB/)
KBO( :, 1,51,15) = (/&
&3.8078E+02_JPRB,3.8056E+02_JPRB,2.8562E+02_JPRB,1.9055E+02_JPRB,1.1479E+02_JPRB,1.0898E+02_JPRB/)
KBO( :, 2,51,15) = (/&
&3.6766E+02_JPRB,3.6744E+02_JPRB,2.7578E+02_JPRB,1.8392E+02_JPRB,1.0684E+02_JPRB,1.0093E+02_JPRB/)
KBO( :, 3,51,15) = (/&
&3.5420E+02_JPRB,3.5398E+02_JPRB,2.6569E+02_JPRB,1.7719E+02_JPRB,9.9903E+01_JPRB,9.5407E+01_JPRB/)
KBO( :, 4,51,15) = (/&
&3.4048E+02_JPRB,3.4027E+02_JPRB,2.5540E+02_JPRB,1.7035E+02_JPRB,9.3766E+01_JPRB,9.1798E+01_JPRB/)
KBO( :, 5,51,15) = (/&
&3.2673E+02_JPRB,3.2653E+02_JPRB,2.4509E+02_JPRB,1.6348E+02_JPRB,8.8237E+01_JPRB,9.2138E+01_JPRB/)
KBO( :, 1,52,15) = (/&
&3.8584E+02_JPRB,3.8560E+02_JPRB,2.8941E+02_JPRB,1.9322E+02_JPRB,1.1816E+02_JPRB,1.1293E+02_JPRB/)
KBO( :, 2,52,15) = (/&
&3.7294E+02_JPRB,3.7271E+02_JPRB,2.7974E+02_JPRB,1.8654E+02_JPRB,1.0976E+02_JPRB,1.0425E+02_JPRB/)
KBO( :, 3,52,15) = (/&
&3.5951E+02_JPRB,3.5930E+02_JPRB,2.6967E+02_JPRB,1.7985E+02_JPRB,1.0246E+02_JPRB,9.8398E+01_JPRB/)
KBO( :, 4,52,15) = (/&
&3.4582E+02_JPRB,3.4561E+02_JPRB,2.5941E+02_JPRB,1.7301E+02_JPRB,9.6032E+01_JPRB,9.4572E+01_JPRB/)
KBO( :, 5,52,15) = (/&
&3.3204E+02_JPRB,3.3185E+02_JPRB,2.4908E+02_JPRB,1.6614E+02_JPRB,9.0266E+01_JPRB,9.4675E+01_JPRB/)
KBO( :, 1,53,15) = (/&
&3.9087E+02_JPRB,3.9063E+02_JPRB,2.9318E+02_JPRB,1.9599E+02_JPRB,1.2171E+02_JPRB,1.1718E+02_JPRB/)
KBO( :, 2,53,15) = (/&
&3.7802E+02_JPRB,3.7780E+02_JPRB,2.8355E+02_JPRB,1.8910E+02_JPRB,1.1281E+02_JPRB,1.0800E+02_JPRB/)
KBO( :, 3,53,15) = (/&
&3.6473E+02_JPRB,3.6451E+02_JPRB,2.7359E+02_JPRB,1.8245E+02_JPRB,1.0513E+02_JPRB,1.0177E+02_JPRB/)
KBO( :, 4,53,15) = (/&
&3.5112E+02_JPRB,3.5091E+02_JPRB,2.6338E+02_JPRB,1.7566E+02_JPRB,9.8387E+01_JPRB,9.7989E+01_JPRB/)
KBO( :, 5,53,15) = (/&
&3.3733E+02_JPRB,3.3713E+02_JPRB,2.5304E+02_JPRB,1.6878E+02_JPRB,9.2381E+01_JPRB,9.8180E+01_JPRB/)
KBO( :, 1,54,15) = (/&
&3.9531E+02_JPRB,3.9507E+02_JPRB,2.9651E+02_JPRB,1.9853E+02_JPRB,1.2515E+02_JPRB,1.2078E+02_JPRB/)
KBO( :, 2,54,15) = (/&
&3.8263E+02_JPRB,3.8240E+02_JPRB,2.8700E+02_JPRB,1.9150E+02_JPRB,1.1577E+02_JPRB,1.1118E+02_JPRB/)
KBO( :, 3,54,15) = (/&
&3.6948E+02_JPRB,3.6926E+02_JPRB,2.7715E+02_JPRB,1.8482E+02_JPRB,1.0769E+02_JPRB,1.0351E+02_JPRB/)
KBO( :, 4,54,15) = (/&
&3.5596E+02_JPRB,3.5575E+02_JPRB,2.6701E+02_JPRB,1.7807E+02_JPRB,1.0063E+02_JPRB,9.9143E+01_JPRB/)
KBO( :, 5,54,15) = (/&
&3.4214E+02_JPRB,3.4194E+02_JPRB,2.5665E+02_JPRB,1.7118E+02_JPRB,9.4395E+01_JPRB,9.8105E+01_JPRB/)
KBO( :, 1,55,15) = (/&
&3.9946E+02_JPRB,3.9922E+02_JPRB,2.9962E+02_JPRB,2.0102E+02_JPRB,1.2867E+02_JPRB,1.2425E+02_JPRB/)
KBO( :, 2,55,15) = (/&
&3.8700E+02_JPRB,3.8677E+02_JPRB,2.9028E+02_JPRB,1.9382E+02_JPRB,1.1872E+02_JPRB,1.1387E+02_JPRB/)
KBO( :, 3,55,15) = (/&
&3.7399E+02_JPRB,3.7376E+02_JPRB,2.8052E+02_JPRB,1.8707E+02_JPRB,1.1023E+02_JPRB,1.0518E+02_JPRB/)
KBO( :, 4,55,15) = (/&
&3.6056E+02_JPRB,3.6034E+02_JPRB,2.7046E+02_JPRB,1.8037E+02_JPRB,1.0287E+02_JPRB,9.9691E+01_JPRB/)
KBO( :, 5,55,15) = (/&
&3.4681E+02_JPRB,3.4660E+02_JPRB,2.6015E+02_JPRB,1.7350E+02_JPRB,9.6390E+01_JPRB,9.6621E+01_JPRB/)
KBO( :, 1,56,15) = (/&
&4.0345E+02_JPRB,4.0321E+02_JPRB,3.0261E+02_JPRB,2.0354E+02_JPRB,1.3232E+02_JPRB,1.2822E+02_JPRB/)
KBO( :, 2,56,15) = (/&
&3.9129E+02_JPRB,3.9105E+02_JPRB,2.9349E+02_JPRB,1.9619E+02_JPRB,1.2179E+02_JPRB,1.1677E+02_JPRB/)
KBO( :, 3,56,15) = (/&
&3.7839E+02_JPRB,3.7816E+02_JPRB,2.8382E+02_JPRB,1.8928E+02_JPRB,1.1288E+02_JPRB,1.0755E+02_JPRB/)
KBO( :, 4,56,15) = (/&
&3.6503E+02_JPRB,3.6481E+02_JPRB,2.7381E+02_JPRB,1.8260E+02_JPRB,1.0518E+02_JPRB,1.0056E+02_JPRB/)
KBO( :, 5,56,15) = (/&
&3.5139E+02_JPRB,3.5118E+02_JPRB,2.6358E+02_JPRB,1.7579E+02_JPRB,9.8426E+01_JPRB,9.5940E+01_JPRB/)
KBO( :, 1,57,15) = (/&
&4.0732E+02_JPRB,4.0708E+02_JPRB,3.0551E+02_JPRB,2.0612E+02_JPRB,1.3611E+02_JPRB,1.3253E+02_JPRB/)
KBO( :, 2,57,15) = (/&
&3.9551E+02_JPRB,3.9527E+02_JPRB,2.9666E+02_JPRB,1.9860E+02_JPRB,1.2505E+02_JPRB,1.2007E+02_JPRB/)
KBO( :, 3,57,15) = (/&
&3.8272E+02_JPRB,3.8249E+02_JPRB,2.8707E+02_JPRB,1.9154E+02_JPRB,1.1567E+02_JPRB,1.1005E+02_JPRB/)
KBO( :, 4,57,15) = (/&
&3.6944E+02_JPRB,3.6922E+02_JPRB,2.7712E+02_JPRB,1.8480E+02_JPRB,1.0758E+02_JPRB,1.0192E+02_JPRB/)
KBO( :, 5,57,15) = (/&
&3.5592E+02_JPRB,3.5571E+02_JPRB,2.6698E+02_JPRB,1.7805E+02_JPRB,1.0054E+02_JPRB,9.6453E+01_JPRB/)
KBO( :, 1,58,15) = (/&
&4.1059E+02_JPRB,4.1035E+02_JPRB,3.0796E+02_JPRB,2.0852E+02_JPRB,1.3980E+02_JPRB,1.3680E+02_JPRB/)
KBO( :, 2,58,15) = (/&
&3.9929E+02_JPRB,3.9905E+02_JPRB,2.9949E+02_JPRB,2.0087E+02_JPRB,1.2831E+02_JPRB,1.2369E+02_JPRB/)
KBO( :, 3,58,15) = (/&
&3.8677E+02_JPRB,3.8654E+02_JPRB,2.9010E+02_JPRB,1.9368E+02_JPRB,1.1842E+02_JPRB,1.1258E+02_JPRB/)
KBO( :, 4,58,15) = (/&
&3.7367E+02_JPRB,3.7345E+02_JPRB,2.8029E+02_JPRB,1.8691E+02_JPRB,1.0996E+02_JPRB,1.0363E+02_JPRB/)
KBO( :, 5,58,15) = (/&
&3.6017E+02_JPRB,3.5995E+02_JPRB,2.7016E+02_JPRB,1.8017E+02_JPRB,1.0261E+02_JPRB,9.7140E+01_JPRB/)
KBO( :, 1,59,15) = (/&
&4.1203E+02_JPRB,4.1178E+02_JPRB,3.0904E+02_JPRB,2.0958E+02_JPRB,1.4140E+02_JPRB,1.3865E+02_JPRB/)
KBO( :, 2,59,15) = (/&
&4.0086E+02_JPRB,4.0061E+02_JPRB,3.0066E+02_JPRB,2.0184E+02_JPRB,1.2968E+02_JPRB,1.2523E+02_JPRB/)
KBO( :, 3,59,15) = (/&
&3.8845E+02_JPRB,3.8822E+02_JPRB,2.9137E+02_JPRB,1.9459E+02_JPRB,1.1957E+02_JPRB,1.1363E+02_JPRB/)
KBO( :, 4,59,15) = (/&
&3.7538E+02_JPRB,3.7516E+02_JPRB,2.8157E+02_JPRB,1.8776E+02_JPRB,1.1095E+02_JPRB,1.0368E+02_JPRB/)
KBO( :, 5,59,15) = (/&
&3.6194E+02_JPRB,3.6172E+02_JPRB,2.7149E+02_JPRB,1.8106E+02_JPRB,1.0349E+02_JPRB,9.5485E+01_JPRB/)
KBO( :, 1,13,16) = (/&
&3.8689E+01_JPRB,3.8666E+01_JPRB,2.9260E+01_JPRB,2.0209E+01_JPRB,1.1782E+01_JPRB,1.0583E+01_JPRB/)
KBO( :, 2,13,16) = (/&
&3.8299E+01_JPRB,3.8276E+01_JPRB,2.8975E+01_JPRB,1.9748E+01_JPRB,1.1593E+01_JPRB,1.0462E+01_JPRB/)
KBO( :, 3,13,16) = (/&
&3.8145E+01_JPRB,3.8122E+01_JPRB,2.8865E+01_JPRB,1.9633E+01_JPRB,1.1641E+01_JPRB,1.2633E+01_JPRB/)
KBO( :, 4,13,16) = (/&
&3.7920E+01_JPRB,3.7898E+01_JPRB,2.8722E+01_JPRB,1.9787E+01_JPRB,1.1762E+01_JPRB,2.0692E+01_JPRB/)
KBO( :, 5,13,16) = (/&
&3.7770E+01_JPRB,3.7748E+01_JPRB,2.8670E+01_JPRB,1.9920E+01_JPRB,1.1827E+01_JPRB,3.1866E+01_JPRB/)
KBO( :, 1,14,16) = (/&
&4.5054E+01_JPRB,4.5027E+01_JPRB,3.4026E+01_JPRB,2.3071E+01_JPRB,1.3319E+01_JPRB,1.2073E+01_JPRB/)
KBO( :, 2,14,16) = (/&
&4.5133E+01_JPRB,4.5106E+01_JPRB,3.4091E+01_JPRB,2.3057E+01_JPRB,1.3364E+01_JPRB,1.1925E+01_JPRB/)
KBO( :, 3,14,16) = (/&
&4.5119E+01_JPRB,4.5092E+01_JPRB,3.4098E+01_JPRB,2.3216E+01_JPRB,1.3503E+01_JPRB,1.1702E+01_JPRB/)
KBO( :, 4,14,16) = (/&
&4.5115E+01_JPRB,4.5088E+01_JPRB,3.4119E+01_JPRB,2.3467E+01_JPRB,1.3637E+01_JPRB,1.5244E+01_JPRB/)
KBO( :, 5,14,16) = (/&
&4.5059E+01_JPRB,4.5033E+01_JPRB,3.4214E+01_JPRB,2.3627E+01_JPRB,1.3694E+01_JPRB,2.3098E+01_JPRB/)
KBO( :, 1,15,16) = (/&
&5.3422E+01_JPRB,5.3390E+01_JPRB,4.0289E+01_JPRB,2.7161E+01_JPRB,1.5356E+01_JPRB,1.3721E+01_JPRB/)
KBO( :, 2,15,16) = (/&
&5.3696E+01_JPRB,5.3664E+01_JPRB,4.0505E+01_JPRB,2.7340E+01_JPRB,1.5494E+01_JPRB,1.3518E+01_JPRB/)
KBO( :, 3,15,16) = (/&
&5.3925E+01_JPRB,5.3893E+01_JPRB,4.0694E+01_JPRB,2.7658E+01_JPRB,1.5638E+01_JPRB,1.3237E+01_JPRB/)
KBO( :, 4,15,16) = (/&
&5.4035E+01_JPRB,5.4003E+01_JPRB,4.0835E+01_JPRB,2.7959E+01_JPRB,1.5745E+01_JPRB,1.3582E+01_JPRB/)
KBO( :, 5,15,16) = (/&
&5.4075E+01_JPRB,5.4044E+01_JPRB,4.1021E+01_JPRB,2.8130E+01_JPRB,1.5788E+01_JPRB,1.7824E+01_JPRB/)
KBO( :, 1,16,16) = (/&
&6.3798E+01_JPRB,6.3761E+01_JPRB,4.8055E+01_JPRB,3.2321E+01_JPRB,1.7804E+01_JPRB,1.5476E+01_JPRB/)
KBO( :, 2,16,16) = (/&
&6.4371E+01_JPRB,6.4333E+01_JPRB,4.8500E+01_JPRB,3.2671E+01_JPRB,1.7962E+01_JPRB,1.5197E+01_JPRB/)
KBO( :, 3,16,16) = (/&
&6.4762E+01_JPRB,6.4724E+01_JPRB,4.8796E+01_JPRB,3.3069E+01_JPRB,1.8081E+01_JPRB,1.4836E+01_JPRB/)
KBO( :, 4,16,16) = (/&
&6.4916E+01_JPRB,6.4878E+01_JPRB,4.9055E+01_JPRB,3.3403E+01_JPRB,1.8207E+01_JPRB,1.4562E+01_JPRB/)
KBO( :, 5,16,16) = (/&
&6.5062E+01_JPRB,6.5024E+01_JPRB,4.9265E+01_JPRB,3.3568E+01_JPRB,1.8256E+01_JPRB,1.7370E+01_JPRB/)
KBO( :, 1,17,16) = (/&
&7.6610E+01_JPRB,7.6564E+01_JPRB,5.7652E+01_JPRB,3.8697E+01_JPRB,2.0672E+01_JPRB,1.7278E+01_JPRB/)
KBO( :, 2,17,16) = (/&
&7.7427E+01_JPRB,7.7381E+01_JPRB,5.8265E+01_JPRB,3.9185E+01_JPRB,2.0866E+01_JPRB,1.6909E+01_JPRB/)
KBO( :, 3,17,16) = (/&
&7.7882E+01_JPRB,7.7836E+01_JPRB,5.8659E+01_JPRB,3.9624E+01_JPRB,2.1079E+01_JPRB,1.6452E+01_JPRB/)
KBO( :, 4,17,16) = (/&
&7.8153E+01_JPRB,7.8107E+01_JPRB,5.8983E+01_JPRB,3.9939E+01_JPRB,2.1227E+01_JPRB,1.5935E+01_JPRB/)
KBO( :, 5,17,16) = (/&
&7.8285E+01_JPRB,7.8239E+01_JPRB,5.9159E+01_JPRB,4.0098E+01_JPRB,2.1284E+01_JPRB,1.7883E+01_JPRB/)
KBO( :, 1,18,16) = (/&
&9.2189E+01_JPRB,9.2134E+01_JPRB,6.9312E+01_JPRB,4.6439E+01_JPRB,2.4197E+01_JPRB,1.9120E+01_JPRB/)
KBO( :, 2,18,16) = (/&
&9.3127E+01_JPRB,9.3071E+01_JPRB,7.0021E+01_JPRB,4.7049E+01_JPRB,2.4478E+01_JPRB,1.8615E+01_JPRB/)
KBO( :, 3,18,16) = (/&
&9.3687E+01_JPRB,9.3631E+01_JPRB,7.0554E+01_JPRB,4.7512E+01_JPRB,2.4757E+01_JPRB,1.8049E+01_JPRB/)
KBO( :, 4,18,16) = (/&
&9.4033E+01_JPRB,9.3977E+01_JPRB,7.0871E+01_JPRB,4.7767E+01_JPRB,2.4905E+01_JPRB,1.7594E+01_JPRB/)
KBO( :, 5,18,16) = (/&
&9.4115E+01_JPRB,9.4059E+01_JPRB,7.0982E+01_JPRB,4.7909E+01_JPRB,2.4988E+01_JPRB,1.9077E+01_JPRB/)
KBO( :, 1,19,16) = (/&
&1.1088E+02_JPRB,1.1082E+02_JPRB,8.3307E+01_JPRB,5.5744E+01_JPRB,2.8599E+01_JPRB,2.1582E+01_JPRB/)
KBO( :, 2,19,16) = (/&
&1.1182E+02_JPRB,1.1175E+02_JPRB,8.4097E+01_JPRB,5.6442E+01_JPRB,2.8984E+01_JPRB,2.0983E+01_JPRB/)
KBO( :, 3,19,16) = (/&
&1.1254E+02_JPRB,1.1247E+02_JPRB,8.4694E+01_JPRB,5.6884E+01_JPRB,2.9231E+01_JPRB,2.0488E+01_JPRB/)
KBO( :, 4,19,16) = (/&
&1.1281E+02_JPRB,1.1274E+02_JPRB,8.4918E+01_JPRB,5.7062E+01_JPRB,2.9345E+01_JPRB,2.0019E+01_JPRB/)
KBO( :, 5,19,16) = (/&
&1.1284E+02_JPRB,1.1277E+02_JPRB,8.4969E+01_JPRB,5.7133E+01_JPRB,2.9423E+01_JPRB,2.0552E+01_JPRB/)
KBO( :, 1,20,16) = (/&
&1.3304E+02_JPRB,1.3296E+02_JPRB,9.9902E+01_JPRB,6.6832E+01_JPRB,3.3983E+01_JPRB,2.4788E+01_JPRB/)
KBO( :, 2,20,16) = (/&
&1.3397E+02_JPRB,1.3389E+02_JPRB,1.0072E+02_JPRB,6.7494E+01_JPRB,3.4377E+01_JPRB,2.4125E+01_JPRB/)
KBO( :, 3,20,16) = (/&
&1.3463E+02_JPRB,1.3455E+02_JPRB,1.0123E+02_JPRB,6.7864E+01_JPRB,3.4571E+01_JPRB,2.3603E+01_JPRB/)
KBO( :, 4,20,16) = (/&
&1.3476E+02_JPRB,1.3468E+02_JPRB,1.0135E+02_JPRB,6.7962E+01_JPRB,3.4649E+01_JPRB,2.3098E+01_JPRB/)
KBO( :, 5,20,16) = (/&
&1.3461E+02_JPRB,1.3453E+02_JPRB,1.0126E+02_JPRB,6.7912E+01_JPRB,3.4631E+01_JPRB,2.3014E+01_JPRB/)
KBO( :, 1,21,16) = (/&
&1.5902E+02_JPRB,1.5892E+02_JPRB,1.1942E+02_JPRB,7.9855E+01_JPRB,4.0380E+01_JPRB,2.8857E+01_JPRB/)
KBO( :, 2,21,16) = (/&
&1.5986E+02_JPRB,1.5976E+02_JPRB,1.2010E+02_JPRB,8.0360E+01_JPRB,4.0679E+01_JPRB,2.8064E+01_JPRB/)
KBO( :, 3,21,16) = (/&
&1.6009E+02_JPRB,1.5999E+02_JPRB,1.2030E+02_JPRB,8.0530E+01_JPRB,4.0801E+01_JPRB,2.7409E+01_JPRB/)
KBO( :, 4,21,16) = (/&
&1.6003E+02_JPRB,1.5993E+02_JPRB,1.2027E+02_JPRB,8.0522E+01_JPRB,4.0812E+01_JPRB,2.6783E+01_JPRB/)
KBO( :, 5,21,16) = (/&
&1.5940E+02_JPRB,1.5931E+02_JPRB,1.1980E+02_JPRB,8.0213E+01_JPRB,4.0653E+01_JPRB,2.6207E+01_JPRB/)
KBO( :, 1,22,16) = (/&
&1.8914E+02_JPRB,1.8903E+02_JPRB,1.4202E+02_JPRB,9.4911E+01_JPRB,4.7837E+01_JPRB,3.3682E+01_JPRB/)
KBO( :, 2,22,16) = (/&
&1.8942E+02_JPRB,1.8931E+02_JPRB,1.4225E+02_JPRB,9.5082E+01_JPRB,4.7944E+01_JPRB,3.2660E+01_JPRB/)
KBO( :, 3,22,16) = (/&
&1.8906E+02_JPRB,1.8895E+02_JPRB,1.4200E+02_JPRB,9.4945E+01_JPRB,4.7916E+01_JPRB,3.1774E+01_JPRB/)
KBO( :, 4,22,16) = (/&
&1.8832E+02_JPRB,1.8821E+02_JPRB,1.4146E+02_JPRB,9.4597E+01_JPRB,4.7752E+01_JPRB,3.0917E+01_JPRB/)
KBO( :, 5,22,16) = (/&
&1.8683E+02_JPRB,1.8672E+02_JPRB,1.4034E+02_JPRB,9.3850E+01_JPRB,4.7374E+01_JPRB,3.0042E+01_JPRB/)
KBO( :, 1,23,16) = (/&
&2.2303E+02_JPRB,2.2290E+02_JPRB,1.6742E+02_JPRB,1.1182E+02_JPRB,5.6236E+01_JPRB,3.9223E+01_JPRB/)
KBO( :, 2,23,16) = (/&
&2.2245E+02_JPRB,2.2232E+02_JPRB,1.6700E+02_JPRB,1.1156E+02_JPRB,5.6122E+01_JPRB,3.7879E+01_JPRB/)
KBO( :, 3,23,16) = (/&
&2.2122E+02_JPRB,2.2109E+02_JPRB,1.6608E+02_JPRB,1.1095E+02_JPRB,5.5829E+01_JPRB,3.6659E+01_JPRB/)
KBO( :, 4,23,16) = (/&
&2.1922E+02_JPRB,2.1909E+02_JPRB,1.6458E+02_JPRB,1.0995E+02_JPRB,5.5344E+01_JPRB,3.5458E+01_JPRB/)
KBO( :, 5,23,16) = (/&
&2.1646E+02_JPRB,2.1633E+02_JPRB,1.6251E+02_JPRB,1.0858E+02_JPRB,5.4654E+01_JPRB,3.4278E+01_JPRB/)
KBO( :, 1,24,16) = (/&
&2.6009E+02_JPRB,2.5994E+02_JPRB,1.9520E+02_JPRB,1.3031E+02_JPRB,6.5430E+01_JPRB,4.5390E+01_JPRB/)
KBO( :, 2,24,16) = (/&
&2.5840E+02_JPRB,2.5824E+02_JPRB,1.9393E+02_JPRB,1.2948E+02_JPRB,6.5031E+01_JPRB,4.3599E+01_JPRB/)
KBO( :, 3,24,16) = (/&
&2.5582E+02_JPRB,2.5567E+02_JPRB,1.9201E+02_JPRB,1.2820E+02_JPRB,6.4398E+01_JPRB,4.1930E+01_JPRB/)
KBO( :, 4,24,16) = (/&
&2.5214E+02_JPRB,2.5199E+02_JPRB,1.8925E+02_JPRB,1.2636E+02_JPRB,6.3477E+01_JPRB,4.0299E+01_JPRB/)
KBO( :, 5,24,16) = (/&
&2.4775E+02_JPRB,2.4761E+02_JPRB,1.8596E+02_JPRB,1.2416E+02_JPRB,6.2364E+01_JPRB,3.8770E+01_JPRB/)
KBO( :, 1,25,16) = (/&
&2.9961E+02_JPRB,2.9943E+02_JPRB,2.2482E+02_JPRB,1.5004E+02_JPRB,7.5282E+01_JPRB,5.1967E+01_JPRB/)
KBO( :, 2,25,16) = (/&
&2.9633E+02_JPRB,2.9616E+02_JPRB,2.2237E+02_JPRB,1.4840E+02_JPRB,7.4441E+01_JPRB,4.9689E+01_JPRB/)
KBO( :, 3,25,16) = (/&
&2.9175E+02_JPRB,2.9157E+02_JPRB,2.1893E+02_JPRB,1.4611E+02_JPRB,7.3302E+01_JPRB,4.7422E+01_JPRB/)
KBO( :, 4,25,16) = (/&
&2.8609E+02_JPRB,2.8592E+02_JPRB,2.1467E+02_JPRB,1.4326E+02_JPRB,7.1858E+01_JPRB,4.5354E+01_JPRB/)
KBO( :, 5,25,16) = (/&
&2.7979E+02_JPRB,2.7962E+02_JPRB,2.0995E+02_JPRB,1.4011E+02_JPRB,7.0273E+01_JPRB,4.3371E+01_JPRB/)
KBO( :, 1,26,16) = (/&
&3.4064E+02_JPRB,3.4044E+02_JPRB,2.5559E+02_JPRB,1.7054E+02_JPRB,8.5509E+01_JPRB,5.8664E+01_JPRB/)
KBO( :, 2,26,16) = (/&
&3.3479E+02_JPRB,3.3459E+02_JPRB,2.5118E+02_JPRB,1.6758E+02_JPRB,8.3998E+01_JPRB,5.5796E+01_JPRB/)
KBO( :, 3,26,16) = (/&
&3.2781E+02_JPRB,3.2761E+02_JPRB,2.4595E+02_JPRB,1.6410E+02_JPRB,8.2241E+01_JPRB,5.2997E+01_JPRB/)
KBO( :, 4,26,16) = (/&
&3.1991E+02_JPRB,3.1971E+02_JPRB,2.4002E+02_JPRB,1.6013E+02_JPRB,8.0246E+01_JPRB,5.0365E+01_JPRB/)
KBO( :, 5,26,16) = (/&
&3.1125E+02_JPRB,3.1106E+02_JPRB,2.3353E+02_JPRB,1.5580E+02_JPRB,7.8078E+01_JPRB,4.7882E+01_JPRB/)
KBO( :, 1,27,16) = (/&
&3.8151E+02_JPRB,3.8128E+02_JPRB,2.8624E+02_JPRB,1.9097E+02_JPRB,9.5695E+01_JPRB,6.5294E+01_JPRB/)
KBO( :, 2,27,16) = (/&
&3.7246E+02_JPRB,3.7224E+02_JPRB,2.7942E+02_JPRB,1.8640E+02_JPRB,9.3380E+01_JPRB,6.1731E+01_JPRB/)
KBO( :, 3,27,16) = (/&
&3.6293E+02_JPRB,3.6271E+02_JPRB,2.7227E+02_JPRB,1.8161E+02_JPRB,9.0959E+01_JPRB,5.8403E+01_JPRB/)
KBO( :, 4,27,16) = (/&
&3.5247E+02_JPRB,3.5226E+02_JPRB,2.6442E+02_JPRB,1.7637E+02_JPRB,8.8327E+01_JPRB,5.5221E+01_JPRB/)
KBO( :, 5,27,16) = (/&
&3.4112E+02_JPRB,3.4092E+02_JPRB,2.5591E+02_JPRB,1.7070E+02_JPRB,8.5490E+01_JPRB,5.2167E+01_JPRB/)
KBO( :, 1,28,16) = (/&
&4.2083E+02_JPRB,4.2057E+02_JPRB,3.1571E+02_JPRB,2.1058E+02_JPRB,1.0546E+02_JPRB,7.1596E+01_JPRB/)
KBO( :, 2,28,16) = (/&
&4.0846E+02_JPRB,4.0821E+02_JPRB,3.0641E+02_JPRB,2.0435E+02_JPRB,1.0232E+02_JPRB,6.7371E+01_JPRB/)
KBO( :, 3,28,16) = (/&
&3.9603E+02_JPRB,3.9579E+02_JPRB,2.9708E+02_JPRB,1.9813E+02_JPRB,9.9186E+01_JPRB,6.3413E+01_JPRB/)
KBO( :, 4,28,16) = (/&
&3.8255E+02_JPRB,3.8232E+02_JPRB,2.8697E+02_JPRB,1.9139E+02_JPRB,9.5812E+01_JPRB,5.9684E+01_JPRB/)
KBO( :, 5,28,16) = (/&
&3.6876E+02_JPRB,3.6854E+02_JPRB,2.7662E+02_JPRB,1.8449E+02_JPRB,9.2357E+01_JPRB,5.6128E+01_JPRB/)
KBO( :, 1,29,16) = (/&
&4.5696E+02_JPRB,4.5668E+02_JPRB,3.4279E+02_JPRB,2.2863E+02_JPRB,1.1447E+02_JPRB,7.7353E+01_JPRB/)
KBO( :, 2,29,16) = (/&
&4.4141E+02_JPRB,4.4115E+02_JPRB,3.3112E+02_JPRB,2.2083E+02_JPRB,1.1054E+02_JPRB,7.2448E+01_JPRB/)
KBO( :, 3,29,16) = (/&
&4.2589E+02_JPRB,4.2564E+02_JPRB,3.1947E+02_JPRB,2.1304E+02_JPRB,1.0662E+02_JPRB,6.7886E+01_JPRB/)
KBO( :, 4,29,16) = (/&
&4.0969E+02_JPRB,4.0945E+02_JPRB,3.0731E+02_JPRB,2.0494E+02_JPRB,1.0256E+02_JPRB,6.3607E+01_JPRB/)
KBO( :, 5,29,16) = (/&
&3.9310E+02_JPRB,3.9286E+02_JPRB,2.9486E+02_JPRB,1.9663E+02_JPRB,9.8402E+01_JPRB,5.9577E+01_JPRB/)
KBO( :, 1,30,16) = (/&
&4.8959E+02_JPRB,4.8930E+02_JPRB,3.6726E+02_JPRB,2.4492E+02_JPRB,1.2259E+02_JPRB,8.2395E+01_JPRB/)
KBO( :, 2,30,16) = (/&
&4.7092E+02_JPRB,4.7063E+02_JPRB,3.5324E+02_JPRB,2.3556E+02_JPRB,1.1788E+02_JPRB,7.6844E+01_JPRB/)
KBO( :, 3,30,16) = (/&
&4.5203E+02_JPRB,4.5176E+02_JPRB,3.3907E+02_JPRB,2.2611E+02_JPRB,1.1315E+02_JPRB,7.1734E+01_JPRB/)
KBO( :, 4,30,16) = (/&
&4.3310E+02_JPRB,4.3284E+02_JPRB,3.2486E+02_JPRB,2.1662E+02_JPRB,1.0839E+02_JPRB,6.6928E+01_JPRB/)
KBO( :, 5,30,16) = (/&
&4.1412E+02_JPRB,4.1387E+02_JPRB,3.1062E+02_JPRB,2.0713E+02_JPRB,1.0363E+02_JPRB,6.3289E+01_JPRB/)
KBO( :, 1,31,16) = (/&
&5.1786E+02_JPRB,5.1755E+02_JPRB,3.8845E+02_JPRB,2.5903E+02_JPRB,1.2962E+02_JPRB,8.6621E+01_JPRB/)
KBO( :, 2,31,16) = (/&
&4.9597E+02_JPRB,4.9567E+02_JPRB,3.7202E+02_JPRB,2.4806E+02_JPRB,1.2412E+02_JPRB,8.0470E+01_JPRB/)
KBO( :, 3,31,16) = (/&
&4.7405E+02_JPRB,4.7377E+02_JPRB,3.5558E+02_JPRB,2.3710E+02_JPRB,1.1862E+02_JPRB,7.4852E+01_JPRB/)
KBO( :, 4,31,16) = (/&
&4.5255E+02_JPRB,4.5228E+02_JPRB,3.3944E+02_JPRB,2.2633E+02_JPRB,1.1323E+02_JPRB,6.9726E+01_JPRB/)
KBO( :, 5,31,16) = (/&
&4.3142E+02_JPRB,4.3116E+02_JPRB,3.2359E+02_JPRB,2.1576E+02_JPRB,1.0794E+02_JPRB,6.8706E+01_JPRB/)
KBO( :, 1,32,16) = (/&
&5.4131E+02_JPRB,5.4099E+02_JPRB,4.0602E+02_JPRB,2.7073E+02_JPRB,1.3545E+02_JPRB,8.9958E+01_JPRB/)
KBO( :, 2,32,16) = (/&
&5.1653E+02_JPRB,5.1622E+02_JPRB,3.8743E+02_JPRB,2.5834E+02_JPRB,1.2924E+02_JPRB,8.3331E+01_JPRB/)
KBO( :, 3,32,16) = (/&
&4.9189E+02_JPRB,4.9160E+02_JPRB,3.6895E+02_JPRB,2.4600E+02_JPRB,1.2306E+02_JPRB,7.7256E+01_JPRB/)
KBO( :, 4,32,16) = (/&
&4.6812E+02_JPRB,4.6784E+02_JPRB,3.5111E+02_JPRB,2.3411E+02_JPRB,1.1710E+02_JPRB,7.4368E+01_JPRB/)
KBO( :, 5,32,16) = (/&
&4.4507E+02_JPRB,4.4480E+02_JPRB,3.3382E+02_JPRB,2.2258E+02_JPRB,1.1133E+02_JPRB,7.6072E+01_JPRB/)
KBO( :, 1,33,16) = (/&
&5.6013E+02_JPRB,5.5980E+02_JPRB,4.2013E+02_JPRB,2.8013E+02_JPRB,1.4013E+02_JPRB,9.2452E+01_JPRB/)
KBO( :, 2,33,16) = (/&
&5.3265E+02_JPRB,5.3233E+02_JPRB,3.9951E+02_JPRB,2.6638E+02_JPRB,1.3325E+02_JPRB,8.5421E+01_JPRB/)
KBO( :, 3,33,16) = (/&
&5.0565E+02_JPRB,5.0535E+02_JPRB,3.7926E+02_JPRB,2.5287E+02_JPRB,1.2648E+02_JPRB,8.0582E+01_JPRB/)
KBO( :, 4,33,16) = (/&
&4.8012E+02_JPRB,4.7983E+02_JPRB,3.6011E+02_JPRB,2.4010E+02_JPRB,1.2009E+02_JPRB,8.1630E+01_JPRB/)
KBO( :, 5,33,16) = (/&
&4.5545E+02_JPRB,4.5518E+02_JPRB,3.4161E+02_JPRB,2.2776E+02_JPRB,1.1392E+02_JPRB,8.6476E+01_JPRB/)
KBO( :, 1,34,16) = (/&
&5.7564E+02_JPRB,5.7530E+02_JPRB,4.3176E+02_JPRB,2.8787E+02_JPRB,1.4399E+02_JPRB,9.4439E+01_JPRB/)
KBO( :, 2,34,16) = (/&
&5.4576E+02_JPRB,5.4543E+02_JPRB,4.0934E+02_JPRB,2.7293E+02_JPRB,1.3651E+02_JPRB,8.7181E+01_JPRB/)
KBO( :, 3,34,16) = (/&
&5.1688E+02_JPRB,5.1657E+02_JPRB,3.8768E+02_JPRB,2.5848E+02_JPRB,1.2927E+02_JPRB,8.6122E+01_JPRB/)
KBO( :, 4,34,16) = (/&
&4.8984E+02_JPRB,4.8955E+02_JPRB,3.6740E+02_JPRB,2.4495E+02_JPRB,1.2251E+02_JPRB,9.0125E+01_JPRB/)
KBO( :, 5,34,16) = (/&
&4.6368E+02_JPRB,4.6340E+02_JPRB,3.4777E+02_JPRB,2.3187E+02_JPRB,1.1596E+02_JPRB,9.7964E+01_JPRB/)
KBO( :, 1,35,16) = (/&
&5.9022E+02_JPRB,5.8986E+02_JPRB,4.4268E+02_JPRB,2.9515E+02_JPRB,1.4762E+02_JPRB,9.6547E+01_JPRB/)
KBO( :, 2,35,16) = (/&
&5.5830E+02_JPRB,5.5796E+02_JPRB,4.1874E+02_JPRB,2.7919E+02_JPRB,1.3963E+02_JPRB,9.1112E+01_JPRB/)
KBO( :, 3,35,16) = (/&
&5.2772E+02_JPRB,5.2741E+02_JPRB,3.9581E+02_JPRB,2.6389E+02_JPRB,1.3198E+02_JPRB,9.3202E+01_JPRB/)
KBO( :, 4,35,16) = (/&
&4.9925E+02_JPRB,4.9895E+02_JPRB,3.7445E+02_JPRB,2.4965E+02_JPRB,1.2485E+02_JPRB,1.0012E+02_JPRB/)
KBO( :, 5,35,16) = (/&
&4.7190E+02_JPRB,4.7162E+02_JPRB,3.5394E+02_JPRB,2.3598E+02_JPRB,1.1801E+02_JPRB,1.1144E+02_JPRB/)
KBO( :, 1,36,16) = (/&
&6.0541E+02_JPRB,6.0504E+02_JPRB,4.5407E+02_JPRB,3.0274E+02_JPRB,1.5140E+02_JPRB,9.9056E+01_JPRB/)
KBO( :, 2,36,16) = (/&
&5.7172E+02_JPRB,5.7138E+02_JPRB,4.2880E+02_JPRB,2.8589E+02_JPRB,1.4298E+02_JPRB,9.6302E+01_JPRB/)
KBO( :, 3,36,16) = (/&
&5.3964E+02_JPRB,5.3931E+02_JPRB,4.0474E+02_JPRB,2.6984E+02_JPRB,1.3495E+02_JPRB,1.0085E+02_JPRB/)
KBO( :, 4,36,16) = (/&
&5.0967E+02_JPRB,5.0936E+02_JPRB,3.8226E+02_JPRB,2.5485E+02_JPRB,1.2745E+02_JPRB,1.1048E+02_JPRB/)
KBO( :, 5,36,16) = (/&
&4.8120E+02_JPRB,4.8091E+02_JPRB,3.6091E+02_JPRB,2.4062E+02_JPRB,1.2033E+02_JPRB,1.2766E+02_JPRB/)
KBO( :, 1,37,16) = (/&
&6.2365E+02_JPRB,6.2328E+02_JPRB,4.6775E+02_JPRB,3.1185E+02_JPRB,1.5596E+02_JPRB,1.0253E+02_JPRB/)
KBO( :, 2,37,16) = (/&
&5.8812E+02_JPRB,5.8777E+02_JPRB,4.4110E+02_JPRB,2.9409E+02_JPRB,1.4707E+02_JPRB,1.0086E+02_JPRB/)
KBO( :, 3,37,16) = (/&
&5.5432E+02_JPRB,5.5398E+02_JPRB,4.1575E+02_JPRB,2.7718E+02_JPRB,1.3861E+02_JPRB,1.0660E+02_JPRB/)
KBO( :, 4,37,16) = (/&
&5.2295E+02_JPRB,5.2264E+02_JPRB,3.9222E+02_JPRB,2.6149E+02_JPRB,1.3076E+02_JPRB,1.1783E+02_JPRB/)
KBO( :, 5,37,16) = (/&
&4.9325E+02_JPRB,4.9295E+02_JPRB,3.6994E+02_JPRB,2.4664E+02_JPRB,1.2334E+02_JPRB,1.3920E+02_JPRB/)
KBO( :, 1,38,16) = (/&
&6.4066E+02_JPRB,6.4028E+02_JPRB,4.8051E+02_JPRB,3.2036E+02_JPRB,1.6020E+02_JPRB,1.0610E+02_JPRB/)
KBO( :, 2,38,16) = (/&
&6.0334E+02_JPRB,6.0298E+02_JPRB,4.5252E+02_JPRB,3.0169E+02_JPRB,1.5087E+02_JPRB,1.0585E+02_JPRB/)
KBO( :, 3,38,16) = (/&
&5.6803E+02_JPRB,5.6769E+02_JPRB,4.2603E+02_JPRB,2.8403E+02_JPRB,1.4204E+02_JPRB,1.1325E+02_JPRB/)
KBO( :, 4,38,16) = (/&
&5.3536E+02_JPRB,5.3504E+02_JPRB,4.0152E+02_JPRB,2.6769E+02_JPRB,1.3386E+02_JPRB,1.2673E+02_JPRB/)
KBO( :, 5,38,16) = (/&
&5.0450E+02_JPRB,5.0419E+02_JPRB,3.7838E+02_JPRB,2.5226E+02_JPRB,1.2614E+02_JPRB,1.5384E+02_JPRB/)
KBO( :, 1,39,16) = (/&
&6.5607E+02_JPRB,6.5567E+02_JPRB,4.9206E+02_JPRB,3.2805E+02_JPRB,1.6405E+02_JPRB,1.1010E+02_JPRB/)
KBO( :, 2,39,16) = (/&
&6.1741E+02_JPRB,6.1704E+02_JPRB,4.6306E+02_JPRB,3.0872E+02_JPRB,1.5438E+02_JPRB,1.1190E+02_JPRB/)
KBO( :, 3,39,16) = (/&
&5.8064E+02_JPRB,5.8030E+02_JPRB,4.3549E+02_JPRB,2.9034E+02_JPRB,1.4519E+02_JPRB,1.2173E+02_JPRB/)
KBO( :, 4,39,16) = (/&
&5.4667E+02_JPRB,5.4634E+02_JPRB,4.1001E+02_JPRB,2.7335E+02_JPRB,1.3668E+02_JPRB,1.3901E+02_JPRB/)
KBO( :, 5,39,16) = (/&
&5.1480E+02_JPRB,5.1449E+02_JPRB,3.8610E+02_JPRB,2.5741E+02_JPRB,1.2872E+02_JPRB,1.7411E+02_JPRB/)
KBO( :, 1,40,16) = (/&
&6.7476E+02_JPRB,6.7436E+02_JPRB,5.0608E+02_JPRB,3.3740E+02_JPRB,1.6871E+02_JPRB,1.1362E+02_JPRB/)
KBO( :, 2,40,16) = (/&
&6.3434E+02_JPRB,6.3396E+02_JPRB,4.7576E+02_JPRB,3.1718E+02_JPRB,1.5861E+02_JPRB,1.1463E+02_JPRB/)
KBO( :, 3,40,16) = (/&
&5.9602E+02_JPRB,5.9566E+02_JPRB,4.4702E+02_JPRB,2.9802E+02_JPRB,1.4902E+02_JPRB,1.2450E+02_JPRB/)
KBO( :, 4,40,16) = (/&
&5.6052E+02_JPRB,5.6019E+02_JPRB,4.2040E+02_JPRB,2.8027E+02_JPRB,1.4015E+02_JPRB,1.4231E+02_JPRB/)
KBO( :, 5,40,16) = (/&
&5.2757E+02_JPRB,5.2726E+02_JPRB,3.9569E+02_JPRB,2.6380E+02_JPRB,1.3191E+02_JPRB,1.7853E+02_JPRB/)
KBO( :, 1,41,16) = (/&
&6.9313E+02_JPRB,6.9271E+02_JPRB,5.1985E+02_JPRB,3.4658E+02_JPRB,1.7330E+02_JPRB,1.1720E+02_JPRB/)
KBO( :, 2,41,16) = (/&
&6.5096E+02_JPRB,6.5057E+02_JPRB,4.8822E+02_JPRB,3.2549E+02_JPRB,1.6276E+02_JPRB,1.1702E+02_JPRB/)
KBO( :, 3,41,16) = (/&
&6.1137E+02_JPRB,6.1101E+02_JPRB,4.5853E+02_JPRB,3.0570E+02_JPRB,1.5286E+02_JPRB,1.2672E+02_JPRB/)
KBO( :, 4,41,16) = (/&
&5.7432E+02_JPRB,5.7398E+02_JPRB,4.3074E+02_JPRB,2.8717E+02_JPRB,1.4359E+02_JPRB,1.4478E+02_JPRB/)
KBO( :, 5,41,16) = (/&
&5.4017E+02_JPRB,5.3985E+02_JPRB,4.0513E+02_JPRB,2.7009E+02_JPRB,1.3505E+02_JPRB,1.8129E+02_JPRB/)
KBO( :, 1,42,16) = (/&
&7.1087E+02_JPRB,7.1044E+02_JPRB,5.3316E+02_JPRB,3.5544E+02_JPRB,1.7773E+02_JPRB,1.2104E+02_JPRB/)
KBO( :, 2,42,16) = (/&
&6.6722E+02_JPRB,6.6682E+02_JPRB,5.0042E+02_JPRB,3.3362E+02_JPRB,1.6682E+02_JPRB,1.1969E+02_JPRB/)
KBO( :, 3,42,16) = (/&
&6.2628E+02_JPRB,6.2590E+02_JPRB,4.6971E+02_JPRB,3.1315E+02_JPRB,1.5658E+02_JPRB,1.2937E+02_JPRB/)
KBO( :, 4,42,16) = (/&
&5.8799E+02_JPRB,5.8763E+02_JPRB,4.4099E+02_JPRB,2.9400E+02_JPRB,1.4701E+02_JPRB,1.4803E+02_JPRB/)
KBO( :, 5,42,16) = (/&
&5.5259E+02_JPRB,5.5226E+02_JPRB,4.1445E+02_JPRB,2.7630E+02_JPRB,1.3816E+02_JPRB,1.8567E+02_JPRB/)
KBO( :, 1,43,16) = (/&
&7.3062E+02_JPRB,7.3018E+02_JPRB,5.4797E+02_JPRB,3.6532E+02_JPRB,1.8267E+02_JPRB,1.2580E+02_JPRB/)
KBO( :, 2,43,16) = (/&
&6.8544E+02_JPRB,6.8503E+02_JPRB,5.1409E+02_JPRB,3.4273E+02_JPRB,1.7137E+02_JPRB,1.2199E+02_JPRB/)
KBO( :, 3,43,16) = (/&
&6.4317E+02_JPRB,6.4278E+02_JPRB,4.8238E+02_JPRB,3.2159E+02_JPRB,1.6080E+02_JPRB,1.3097E+02_JPRB/)
KBO( :, 4,43,16) = (/&
&6.0333E+02_JPRB,6.0297E+02_JPRB,4.5250E+02_JPRB,3.0167E+02_JPRB,1.5084E+02_JPRB,1.4959E+02_JPRB/)
KBO( :, 5,43,16) = (/&
&5.6660E+02_JPRB,5.6626E+02_JPRB,4.2495E+02_JPRB,2.8331E+02_JPRB,1.4166E+02_JPRB,1.8670E+02_JPRB/)
KBO( :, 1,44,16) = (/&
&7.5137E+02_JPRB,7.5091E+02_JPRB,5.6353E+02_JPRB,3.7569E+02_JPRB,1.8785E+02_JPRB,1.3103E+02_JPRB/)
KBO( :, 2,44,16) = (/&
&7.0468E+02_JPRB,7.0426E+02_JPRB,5.2852E+02_JPRB,3.5235E+02_JPRB,1.7618E+02_JPRB,1.2458E+02_JPRB/)
KBO( :, 3,44,16) = (/&
&6.6086E+02_JPRB,6.6046E+02_JPRB,4.9565E+02_JPRB,3.3044E+02_JPRB,1.6522E+02_JPRB,1.3258E+02_JPRB/)
KBO( :, 4,44,16) = (/&
&6.1971E+02_JPRB,6.1934E+02_JPRB,4.6479E+02_JPRB,3.0986E+02_JPRB,1.5494E+02_JPRB,1.5142E+02_JPRB/)
KBO( :, 5,44,16) = (/&
&5.8152E+02_JPRB,5.8117E+02_JPRB,4.3614E+02_JPRB,2.9077E+02_JPRB,1.4539E+02_JPRB,1.8803E+02_JPRB/)
KBO( :, 1,45,16) = (/&
&7.7242E+02_JPRB,7.7196E+02_JPRB,5.7932E+02_JPRB,3.8622E+02_JPRB,1.9312E+02_JPRB,1.3645E+02_JPRB/)
KBO( :, 2,45,16) = (/&
&7.2383E+02_JPRB,7.2339E+02_JPRB,5.4287E+02_JPRB,3.6192E+02_JPRB,1.8097E+02_JPRB,1.2782E+02_JPRB/)
KBO( :, 3,45,16) = (/&
&6.7845E+02_JPRB,6.7804E+02_JPRB,5.0884E+02_JPRB,3.3923E+02_JPRB,1.6962E+02_JPRB,1.3514E+02_JPRB/)
KBO( :, 4,45,16) = (/&
&6.3619E+02_JPRB,6.3581E+02_JPRB,4.7715E+02_JPRB,3.1810E+02_JPRB,1.5906E+02_JPRB,1.5528E+02_JPRB/)
KBO( :, 5,45,16) = (/&
&5.9654E+02_JPRB,5.9618E+02_JPRB,4.4741E+02_JPRB,2.9827E+02_JPRB,1.4914E+02_JPRB,1.9320E+02_JPRB/)
KBO( :, 1,46,16) = (/&
&7.9501E+02_JPRB,7.9453E+02_JPRB,5.9626E+02_JPRB,3.9751E+02_JPRB,1.9876E+02_JPRB,1.4240E+02_JPRB/)
KBO( :, 2,46,16) = (/&
&7.4406E+02_JPRB,7.4362E+02_JPRB,5.5805E+02_JPRB,3.7204E+02_JPRB,1.8602E+02_JPRB,1.3140E+02_JPRB/)
KBO( :, 3,46,16) = (/&
&6.9726E+02_JPRB,6.9684E+02_JPRB,5.2295E+02_JPRB,3.4863E+02_JPRB,1.7432E+02_JPRB,1.3799E+02_JPRB/)
KBO( :, 4,46,16) = (/&
&6.5358E+02_JPRB,6.5318E+02_JPRB,4.9018E+02_JPRB,3.2679E+02_JPRB,1.6340E+02_JPRB,1.5937E+02_JPRB/)
KBO( :, 5,46,16) = (/&
&6.1254E+02_JPRB,6.1218E+02_JPRB,4.5941E+02_JPRB,3.0628E+02_JPRB,1.5314E+02_JPRB,1.9924E+02_JPRB/)
KBO( :, 1,47,16) = (/&
&8.2010E+02_JPRB,8.1961E+02_JPRB,6.1508E+02_JPRB,4.1005E+02_JPRB,2.0503E+02_JPRB,1.4924E+02_JPRB/)
KBO( :, 2,47,16) = (/&
&7.6659E+02_JPRB,7.6613E+02_JPRB,5.7494E+02_JPRB,3.8330E+02_JPRB,1.9165E+02_JPRB,1.3525E+02_JPRB/)
KBO( :, 3,47,16) = (/&
&7.1831E+02_JPRB,7.1788E+02_JPRB,5.3873E+02_JPRB,3.5916E+02_JPRB,1.7958E+02_JPRB,1.3959E+02_JPRB/)
KBO( :, 4,47,16) = (/&
&6.7281E+02_JPRB,6.7241E+02_JPRB,5.0461E+02_JPRB,3.3641E+02_JPRB,1.6821E+02_JPRB,1.6058E+02_JPRB/)
KBO( :, 5,47,16) = (/&
&6.3054E+02_JPRB,6.3016E+02_JPRB,4.7291E+02_JPRB,3.1527E+02_JPRB,1.5764E+02_JPRB,2.0056E+02_JPRB/)
KBO( :, 1,48,16) = (/&
&8.4633E+02_JPRB,8.4583E+02_JPRB,6.3475E+02_JPRB,4.2317E+02_JPRB,2.1159E+02_JPRB,1.5645E+02_JPRB/)
KBO( :, 2,48,16) = (/&
&7.9016E+02_JPRB,7.8968E+02_JPRB,5.9262E+02_JPRB,3.9508E+02_JPRB,1.9755E+02_JPRB,1.4053E+02_JPRB/)
KBO( :, 3,48,16) = (/&
&7.3934E+02_JPRB,7.3890E+02_JPRB,5.5451E+02_JPRB,3.6967E+02_JPRB,1.8484E+02_JPRB,1.4309E+02_JPRB/)
KBO( :, 4,48,16) = (/&
&6.9255E+02_JPRB,6.9213E+02_JPRB,5.1941E+02_JPRB,3.4628E+02_JPRB,1.7314E+02_JPRB,1.6459E+02_JPRB/)
KBO( :, 5,48,16) = (/&
&6.4886E+02_JPRB,6.4847E+02_JPRB,4.8665E+02_JPRB,3.2443E+02_JPRB,1.6222E+02_JPRB,2.0658E+02_JPRB/)
KBO( :, 1,49,16) = (/&
&8.7303E+02_JPRB,8.7251E+02_JPRB,6.5477E+02_JPRB,4.3652E+02_JPRB,2.1826E+02_JPRB,1.6405E+02_JPRB/)
KBO( :, 2,49,16) = (/&
&8.1423E+02_JPRB,8.1374E+02_JPRB,6.1067E+02_JPRB,4.0712E+02_JPRB,2.0356E+02_JPRB,1.4757E+02_JPRB/)
KBO( :, 3,49,16) = (/&
&7.6096E+02_JPRB,7.6050E+02_JPRB,5.7072E+02_JPRB,3.8048E+02_JPRB,1.9025E+02_JPRB,1.4935E+02_JPRB/)
KBO( :, 4,49,16) = (/&
&7.1274E+02_JPRB,7.1231E+02_JPRB,5.3455E+02_JPRB,3.5637E+02_JPRB,1.7819E+02_JPRB,1.7305E+02_JPRB/)
KBO( :, 5,49,16) = (/&
&6.6745E+02_JPRB,6.6705E+02_JPRB,5.0059E+02_JPRB,3.3373E+02_JPRB,1.6687E+02_JPRB,2.2042E+02_JPRB/)
KBO( :, 1,50,16) = (/&
&8.9886E+02_JPRB,8.9832E+02_JPRB,6.7415E+02_JPRB,4.4943E+02_JPRB,2.2472E+02_JPRB,1.7154E+02_JPRB/)
KBO( :, 2,50,16) = (/&
&8.3744E+02_JPRB,8.3694E+02_JPRB,6.2808E+02_JPRB,4.1872E+02_JPRB,2.0936E+02_JPRB,1.5447E+02_JPRB/)
KBO( :, 3,50,16) = (/&
&7.8206E+02_JPRB,7.8159E+02_JPRB,5.8654E+02_JPRB,3.9103E+02_JPRB,1.9552E+02_JPRB,1.5292E+02_JPRB/)
KBO( :, 4,50,16) = (/&
&7.3184E+02_JPRB,7.3140E+02_JPRB,5.4888E+02_JPRB,3.6592E+02_JPRB,1.8296E+02_JPRB,1.7616E+02_JPRB/)
KBO( :, 5,50,16) = (/&
&6.8529E+02_JPRB,6.8488E+02_JPRB,5.1397E+02_JPRB,3.4265E+02_JPRB,1.7133E+02_JPRB,2.2472E+02_JPRB/)
KBO( :, 1,51,16) = (/&
&9.2454E+02_JPRB,9.2398E+02_JPRB,6.9341E+02_JPRB,4.6227E+02_JPRB,2.3114E+02_JPRB,1.7932E+02_JPRB/)
KBO( :, 2,51,16) = (/&
&8.6100E+02_JPRB,8.6049E+02_JPRB,6.4575E+02_JPRB,4.3050E+02_JPRB,2.1525E+02_JPRB,1.6117E+02_JPRB/)
KBO( :, 3,51,16) = (/&
&8.0315E+02_JPRB,8.0267E+02_JPRB,6.0236E+02_JPRB,4.0158E+02_JPRB,2.0079E+02_JPRB,1.5563E+02_JPRB/)
KBO( :, 4,51,16) = (/&
&7.5078E+02_JPRB,7.5033E+02_JPRB,5.6309E+02_JPRB,3.7539E+02_JPRB,1.8770E+02_JPRB,1.7663E+02_JPRB/)
KBO( :, 5,51,16) = (/&
&7.0300E+02_JPRB,7.0257E+02_JPRB,5.2725E+02_JPRB,3.5150E+02_JPRB,1.7575E+02_JPRB,2.2386E+02_JPRB/)
KBO( :, 1,52,16) = (/&
&9.5090E+02_JPRB,9.5033E+02_JPRB,7.1318E+02_JPRB,4.7545E+02_JPRB,2.3773E+02_JPRB,1.8754E+02_JPRB/)
KBO( :, 2,52,16) = (/&
&8.8502E+02_JPRB,8.8448E+02_JPRB,6.6376E+02_JPRB,4.4251E+02_JPRB,2.2126E+02_JPRB,1.6850E+02_JPRB/)
KBO( :, 3,52,16) = (/&
&8.2471E+02_JPRB,8.2421E+02_JPRB,6.1853E+02_JPRB,4.1235E+02_JPRB,2.0618E+02_JPRB,1.6061E+02_JPRB/)
KBO( :, 4,52,16) = (/&
&7.7013E+02_JPRB,7.6967E+02_JPRB,5.7760E+02_JPRB,3.8507E+02_JPRB,1.9253E+02_JPRB,1.8010E+02_JPRB/)
KBO( :, 5,52,16) = (/&
&7.2097E+02_JPRB,7.2053E+02_JPRB,5.4073E+02_JPRB,3.6048E+02_JPRB,1.8024E+02_JPRB,2.2809E+02_JPRB/)
KBO( :, 1,53,16) = (/&
&9.7788E+02_JPRB,9.7729E+02_JPRB,7.3341E+02_JPRB,4.8894E+02_JPRB,2.4447E+02_JPRB,1.9637E+02_JPRB/)
KBO( :, 2,53,16) = (/&
&9.0961E+02_JPRB,9.0906E+02_JPRB,6.8221E+02_JPRB,4.5481E+02_JPRB,2.2740E+02_JPRB,1.7681E+02_JPRB/)
KBO( :, 3,53,16) = (/&
&8.4702E+02_JPRB,8.4651E+02_JPRB,6.3527E+02_JPRB,4.2351E+02_JPRB,2.1176E+02_JPRB,1.6836E+02_JPRB/)
KBO( :, 4,53,16) = (/&
&7.9046E+02_JPRB,7.8999E+02_JPRB,5.9285E+02_JPRB,3.9523E+02_JPRB,1.9762E+02_JPRB,1.8837E+02_JPRB/)
KBO( :, 5,53,16) = (/&
&7.3936E+02_JPRB,7.3892E+02_JPRB,5.5452E+02_JPRB,3.6968E+02_JPRB,1.8484E+02_JPRB,2.4127E+02_JPRB/)
KBO( :, 1,54,16) = (/&
&1.0035E+03_JPRB,1.0029E+03_JPRB,7.5259E+02_JPRB,5.0173E+02_JPRB,2.5087E+02_JPRB,2.0491E+02_JPRB/)
KBO( :, 2,54,16) = (/&
&9.3285E+02_JPRB,9.3229E+02_JPRB,6.9964E+02_JPRB,4.6643E+02_JPRB,2.3321E+02_JPRB,1.8242E+02_JPRB/)
KBO( :, 3,54,16) = (/&
&8.6846E+02_JPRB,8.6794E+02_JPRB,6.5134E+02_JPRB,4.3423E+02_JPRB,2.1712E+02_JPRB,1.7066E+02_JPRB/)
KBO( :, 4,54,16) = (/&
&8.0960E+02_JPRB,8.0911E+02_JPRB,6.0720E+02_JPRB,4.0480E+02_JPRB,2.0240E+02_JPRB,1.8019E+02_JPRB/)
KBO( :, 5,54,16) = (/&
&7.5654E+02_JPRB,7.5608E+02_JPRB,5.6740E+02_JPRB,3.7827E+02_JPRB,1.8914E+02_JPRB,2.2258E+02_JPRB/)
KBO( :, 1,55,16) = (/&
&1.0290E+03_JPRB,1.0283E+03_JPRB,7.7171E+02_JPRB,5.1448E+02_JPRB,2.5724E+02_JPRB,2.1368E+02_JPRB/)
KBO( :, 2,55,16) = (/&
&9.5574E+02_JPRB,9.5517E+02_JPRB,7.1681E+02_JPRB,4.7787E+02_JPRB,2.3894E+02_JPRB,1.8874E+02_JPRB/)
KBO( :, 3,55,16) = (/&
&8.8926E+02_JPRB,8.8873E+02_JPRB,6.6695E+02_JPRB,4.4463E+02_JPRB,2.2232E+02_JPRB,1.7135E+02_JPRB/)
KBO( :, 4,55,16) = (/&
&8.2830E+02_JPRB,8.2781E+02_JPRB,6.2123E+02_JPRB,4.1415E+02_JPRB,2.0708E+02_JPRB,1.6723E+02_JPRB/)
KBO( :, 5,55,16) = (/&
&7.7332E+02_JPRB,7.7285E+02_JPRB,5.7999E+02_JPRB,3.8666E+02_JPRB,1.9333E+02_JPRB,1.9285E+02_JPRB/)
KBO( :, 1,56,16) = (/&
&1.0544E+03_JPRB,1.0538E+03_JPRB,7.9084E+02_JPRB,5.2722E+02_JPRB,2.6389E+02_JPRB,2.2294E+02_JPRB/)
KBO( :, 2,56,16) = (/&
&9.7928E+02_JPRB,9.7870E+02_JPRB,7.3446E+02_JPRB,4.8964E+02_JPRB,2.4482E+02_JPRB,1.9643E+02_JPRB/)
KBO( :, 3,56,16) = (/&
&9.1058E+02_JPRB,9.1004E+02_JPRB,6.8294E+02_JPRB,4.5529E+02_JPRB,2.2765E+02_JPRB,1.7473E+02_JPRB/)
KBO( :, 4,56,16) = (/&
&8.4774E+02_JPRB,8.4724E+02_JPRB,6.3581E+02_JPRB,4.2387E+02_JPRB,2.1194E+02_JPRB,1.6206E+02_JPRB/)
KBO( :, 5,56,16) = (/&
&7.9097E+02_JPRB,7.9049E+02_JPRB,5.9323E+02_JPRB,3.9548E+02_JPRB,1.9774E+02_JPRB,1.7273E+02_JPRB/)
KBO( :, 1,57,16) = (/&
&1.0813E+03_JPRB,1.0806E+03_JPRB,8.1095E+02_JPRB,5.4063E+02_JPRB,2.7119E+02_JPRB,2.3288E+02_JPRB/)
KBO( :, 2,57,16) = (/&
&1.0033E+03_JPRB,1.0027E+03_JPRB,7.5245E+02_JPRB,5.0163E+02_JPRB,2.5082E+02_JPRB,2.0449E+02_JPRB/)
KBO( :, 3,57,16) = (/&
&9.3233E+02_JPRB,9.3177E+02_JPRB,6.9925E+02_JPRB,4.6617E+02_JPRB,2.3308E+02_JPRB,1.8109E+02_JPRB/)
KBO( :, 4,57,16) = (/&
&8.6794E+02_JPRB,8.6742E+02_JPRB,6.5095E+02_JPRB,4.3397E+02_JPRB,2.1699E+02_JPRB,1.6333E+02_JPRB/)
KBO( :, 5,57,16) = (/&
&8.0892E+02_JPRB,8.0843E+02_JPRB,6.0669E+02_JPRB,4.0446E+02_JPRB,2.0223E+02_JPRB,1.5955E+02_JPRB/)
KBO( :, 1,58,16) = (/&
&1.1081E+03_JPRB,1.1074E+03_JPRB,8.3108E+02_JPRB,5.5405E+02_JPRB,2.7884E+02_JPRB,2.4302E+02_JPRB/)
KBO( :, 2,58,16) = (/&
&1.0267E+03_JPRB,1.0261E+03_JPRB,7.7004E+02_JPRB,5.1336E+02_JPRB,2.5668E+02_JPRB,2.1265E+02_JPRB/)
KBO( :, 3,58,16) = (/&
&9.5368E+02_JPRB,9.5311E+02_JPRB,7.1526E+02_JPRB,4.7684E+02_JPRB,2.3842E+02_JPRB,1.8786E+02_JPRB/)
KBO( :, 4,58,16) = (/&
&8.8727E+02_JPRB,8.8673E+02_JPRB,6.6545E+02_JPRB,4.4363E+02_JPRB,2.2182E+02_JPRB,1.6726E+02_JPRB/)
KBO( :, 5,58,16) = (/&
&8.2643E+02_JPRB,8.2594E+02_JPRB,6.1982E+02_JPRB,4.1322E+02_JPRB,2.0661E+02_JPRB,1.5255E+02_JPRB/)
KBO( :, 1,59,16) = (/&
&1.1197E+03_JPRB,1.1190E+03_JPRB,8.3976E+02_JPRB,5.5984E+02_JPRB,2.8216E+02_JPRB,2.4731E+02_JPRB/)
KBO( :, 2,59,16) = (/&
&1.0365E+03_JPRB,1.0359E+03_JPRB,7.7738E+02_JPRB,5.1826E+02_JPRB,2.5916E+02_JPRB,2.1609E+02_JPRB/)
KBO( :, 3,59,16) = (/&
&9.6265E+02_JPRB,9.6208E+02_JPRB,7.2199E+02_JPRB,4.8133E+02_JPRB,2.4066E+02_JPRB,1.9071E+02_JPRB/)
KBO( :, 4,59,16) = (/&
&8.9534E+02_JPRB,8.9480E+02_JPRB,6.7151E+02_JPRB,4.4767E+02_JPRB,2.2384E+02_JPRB,1.6963E+02_JPRB/)
KBO( :, 5,59,16) = (/&
&8.3369E+02_JPRB,8.3319E+02_JPRB,6.2527E+02_JPRB,4.1685E+02_JPRB,2.0842E+02_JPRB,1.5178E+02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB4_B4
