!OCL SCALAR
SUBROUTINE RRTM_KGB4_B2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 4:  630-700 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO4 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,FRACREFBO
USE YOERRTA4 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 6, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*H2O), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 5) = (/&
&2.1807E-02_JPRB,2.2021E-02_JPRB,1.0044E-01_JPRB,1.4940E-01_JPRB,1.9004E-01_JPRB,2.1084E-01_JPRB/)
KBO( :, 2,13, 5) = (/&
&2.2325E-02_JPRB,2.2543E-02_JPRB,1.0227E-01_JPRB,1.5170E-01_JPRB,1.9324E-01_JPRB,2.1682E-01_JPRB/)
KBO( :, 3,13, 5) = (/&
&2.2866E-02_JPRB,2.3082E-02_JPRB,1.0400E-01_JPRB,1.5406E-01_JPRB,1.9625E-01_JPRB,2.2209E-01_JPRB/)
KBO( :, 4,13, 5) = (/&
&2.3407E-02_JPRB,2.3630E-02_JPRB,1.0542E-01_JPRB,1.5634E-01_JPRB,1.9882E-01_JPRB,2.2691E-01_JPRB/)
KBO( :, 5,13, 5) = (/&
&2.3969E-02_JPRB,2.4198E-02_JPRB,1.0673E-01_JPRB,1.5832E-01_JPRB,2.0084E-01_JPRB,2.3123E-01_JPRB/)
KBO( :, 1,14, 5) = (/&
&1.8584E-02_JPRB,1.8801E-02_JPRB,9.0492E-02_JPRB,1.3383E-01_JPRB,1.6989E-01_JPRB,1.8690E-01_JPRB/)
KBO( :, 2,14, 5) = (/&
&1.9043E-02_JPRB,1.9260E-02_JPRB,9.2363E-02_JPRB,1.3650E-01_JPRB,1.7338E-01_JPRB,1.9215E-01_JPRB/)
KBO( :, 3,14, 5) = (/&
&1.9509E-02_JPRB,1.9727E-02_JPRB,9.4036E-02_JPRB,1.3911E-01_JPRB,1.7652E-01_JPRB,1.9653E-01_JPRB/)
KBO( :, 4,14, 5) = (/&
&2.0012E-02_JPRB,2.0240E-02_JPRB,9.5547E-02_JPRB,1.4152E-01_JPRB,1.7904E-01_JPRB,2.0046E-01_JPRB/)
KBO( :, 5,14, 5) = (/&
&2.0601E-02_JPRB,2.0831E-02_JPRB,9.6825E-02_JPRB,1.4354E-01_JPRB,1.8105E-01_JPRB,2.0381E-01_JPRB/)
KBO( :, 1,15, 5) = (/&
&1.5764E-02_JPRB,1.5986E-02_JPRB,8.0805E-02_JPRB,1.1930E-01_JPRB,1.5084E-01_JPRB,1.6442E-01_JPRB/)
KBO( :, 2,15, 5) = (/&
&1.6176E-02_JPRB,1.6398E-02_JPRB,8.2630E-02_JPRB,1.2205E-01_JPRB,1.5430E-01_JPRB,1.6881E-01_JPRB/)
KBO( :, 3,15, 5) = (/&
&1.6614E-02_JPRB,1.6841E-02_JPRB,8.4265E-02_JPRB,1.2470E-01_JPRB,1.5722E-01_JPRB,1.7258E-01_JPRB/)
KBO( :, 4,15, 5) = (/&
&1.7119E-02_JPRB,1.7353E-02_JPRB,8.5716E-02_JPRB,1.2695E-01_JPRB,1.5969E-01_JPRB,1.7588E-01_JPRB/)
KBO( :, 5,15, 5) = (/&
&1.7713E-02_JPRB,1.7947E-02_JPRB,8.6884E-02_JPRB,1.2867E-01_JPRB,1.6168E-01_JPRB,1.7864E-01_JPRB/)
KBO( :, 1,16, 5) = (/&
&1.3330E-02_JPRB,1.3559E-02_JPRB,7.1525E-02_JPRB,1.0570E-01_JPRB,1.3292E-01_JPRB,1.4360E-01_JPRB/)
KBO( :, 2,16, 5) = (/&
&1.3693E-02_JPRB,1.3924E-02_JPRB,7.3291E-02_JPRB,1.0840E-01_JPRB,1.3614E-01_JPRB,1.4745E-01_JPRB/)
KBO( :, 3,16, 5) = (/&
&1.4116E-02_JPRB,1.4356E-02_JPRB,7.4804E-02_JPRB,1.1084E-01_JPRB,1.3892E-01_JPRB,1.5078E-01_JPRB/)
KBO( :, 4,16, 5) = (/&
&1.4627E-02_JPRB,1.4869E-02_JPRB,7.6067E-02_JPRB,1.1275E-01_JPRB,1.4132E-01_JPRB,1.5373E-01_JPRB/)
KBO( :, 5,16, 5) = (/&
&1.5182E-02_JPRB,1.5422E-02_JPRB,7.7137E-02_JPRB,1.1432E-01_JPRB,1.4325E-01_JPRB,1.5618E-01_JPRB/)
KBO( :, 1,17, 5) = (/&
&1.1226E-02_JPRB,1.1471E-02_JPRB,6.2864E-02_JPRB,9.2970E-02_JPRB,1.1624E-01_JPRB,1.2435E-01_JPRB/)
KBO( :, 2,17, 5) = (/&
&1.1567E-02_JPRB,1.1813E-02_JPRB,6.4427E-02_JPRB,9.5505E-02_JPRB,1.1921E-01_JPRB,1.2773E-01_JPRB/)
KBO( :, 3,17, 5) = (/&
&1.1990E-02_JPRB,1.2239E-02_JPRB,6.5773E-02_JPRB,9.7566E-02_JPRB,1.2183E-01_JPRB,1.3076E-01_JPRB/)
KBO( :, 4,17, 5) = (/&
&1.2459E-02_JPRB,1.2709E-02_JPRB,6.6900E-02_JPRB,9.9291E-02_JPRB,1.2409E-01_JPRB,1.3335E-01_JPRB/)
KBO( :, 5,17, 5) = (/&
&1.2942E-02_JPRB,1.3188E-02_JPRB,6.7902E-02_JPRB,1.0077E-01_JPRB,1.2586E-01_JPRB,1.3513E-01_JPRB/)
KBO( :, 1,18, 5) = (/&
&9.4274E-03_JPRB,9.6965E-03_JPRB,5.4803E-02_JPRB,8.1156E-02_JPRB,1.0095E-01_JPRB,1.0689E-01_JPRB/)
KBO( :, 2,18, 5) = (/&
&9.7636E-03_JPRB,1.0029E-02_JPRB,5.6180E-02_JPRB,8.3292E-02_JPRB,1.0368E-01_JPRB,1.0994E-01_JPRB/)
KBO( :, 3,18, 5) = (/&
&1.0159E-02_JPRB,1.0423E-02_JPRB,5.7359E-02_JPRB,8.5142E-02_JPRB,1.0612E-01_JPRB,1.1256E-01_JPRB/)
KBO( :, 4,18, 5) = (/&
&1.0557E-02_JPRB,1.0823E-02_JPRB,5.8403E-02_JPRB,8.6709E-02_JPRB,1.0803E-01_JPRB,1.1430E-01_JPRB/)
KBO( :, 5,18, 5) = (/&
&1.0979E-02_JPRB,1.1237E-02_JPRB,5.9376E-02_JPRB,8.7774E-02_JPRB,1.0903E-01_JPRB,1.1483E-01_JPRB/)
KBO( :, 1,19, 5) = (/&
&7.9098E-03_JPRB,8.2116E-03_JPRB,4.7414E-02_JPRB,7.0216E-02_JPRB,8.7160E-02_JPRB,9.1322E-02_JPRB/)
KBO( :, 2,19, 5) = (/&
&8.2326E-03_JPRB,8.5288E-03_JPRB,4.8610E-02_JPRB,7.2087E-02_JPRB,8.9657E-02_JPRB,9.3915E-02_JPRB/)
KBO( :, 3,19, 5) = (/&
&8.5662E-03_JPRB,8.8617E-03_JPRB,4.9664E-02_JPRB,7.3691E-02_JPRB,9.1636E-02_JPRB,9.5646E-02_JPRB/)
KBO( :, 4,19, 5) = (/&
&8.9074E-03_JPRB,9.1995E-03_JPRB,5.0599E-02_JPRB,7.4784E-02_JPRB,9.2706E-02_JPRB,9.6286E-02_JPRB/)
KBO( :, 5,19, 5) = (/&
&9.2777E-03_JPRB,9.5603E-03_JPRB,5.1404E-02_JPRB,7.5248E-02_JPRB,9.2890E-02_JPRB,9.6015E-02_JPRB/)
KBO( :, 1,20, 5) = (/&
&6.6406E-03_JPRB,6.9730E-03_JPRB,4.0765E-02_JPRB,6.0395E-02_JPRB,7.4894E-02_JPRB,7.7615E-02_JPRB/)
KBO( :, 2,20, 5) = (/&
&6.9207E-03_JPRB,7.2477E-03_JPRB,4.1802E-02_JPRB,6.1965E-02_JPRB,7.6901E-02_JPRB,7.9381E-02_JPRB/)
KBO( :, 3,20, 5) = (/&
&7.2065E-03_JPRB,7.5323E-03_JPRB,4.2689E-02_JPRB,6.3071E-02_JPRB,7.8052E-02_JPRB,8.0177E-02_JPRB/)
KBO( :, 4,20, 5) = (/&
&7.5033E-03_JPRB,7.8245E-03_JPRB,4.3401E-02_JPRB,6.3586E-02_JPRB,7.8425E-02_JPRB,8.0205E-02_JPRB/)
KBO( :, 5,20, 5) = (/&
&7.8207E-03_JPRB,8.1353E-03_JPRB,4.3986E-02_JPRB,6.3704E-02_JPRB,7.8211E-02_JPRB,7.9644E-02_JPRB/)
KBO( :, 1,21, 5) = (/&
&5.5684E-03_JPRB,5.9172E-03_JPRB,3.4857E-02_JPRB,5.1594E-02_JPRB,6.3858E-02_JPRB,6.5331E-02_JPRB/)
KBO( :, 2,21, 5) = (/&
&5.8079E-03_JPRB,6.1557E-03_JPRB,3.5708E-02_JPRB,5.2705E-02_JPRB,6.5132E-02_JPRB,6.6285E-02_JPRB/)
KBO( :, 3,21, 5) = (/&
&6.0503E-03_JPRB,6.4001E-03_JPRB,3.6352E-02_JPRB,5.3300E-02_JPRB,6.5675E-02_JPRB,6.6569E-02_JPRB/)
KBO( :, 4,21, 5) = (/&
&6.2998E-03_JPRB,6.6477E-03_JPRB,3.6852E-02_JPRB,5.3519E-02_JPRB,6.5720E-02_JPRB,6.6352E-02_JPRB/)
KBO( :, 5,21, 5) = (/&
&6.5744E-03_JPRB,6.9172E-03_JPRB,3.7271E-02_JPRB,5.3554E-02_JPRB,6.5371E-02_JPRB,6.5708E-02_JPRB/)
KBO( :, 1,22, 5) = (/&
&4.6792E-03_JPRB,5.0331E-03_JPRB,2.9657E-02_JPRB,4.3716E-02_JPRB,5.3931E-02_JPRB,5.4472E-02_JPRB/)
KBO( :, 2,22, 5) = (/&
&4.8778E-03_JPRB,5.2371E-03_JPRB,3.0261E-02_JPRB,4.4366E-02_JPRB,5.4607E-02_JPRB,5.4935E-02_JPRB/)
KBO( :, 3,22, 5) = (/&
&5.0770E-03_JPRB,5.4422E-03_JPRB,3.0710E-02_JPRB,4.4665E-02_JPRB,5.4836E-02_JPRB,5.4959E-02_JPRB/)
KBO( :, 4,22, 5) = (/&
&5.2927E-03_JPRB,5.6586E-03_JPRB,3.1096E-02_JPRB,4.4798E-02_JPRB,5.4724E-02_JPRB,5.4622E-02_JPRB/)
KBO( :, 5,22, 5) = (/&
&5.5434E-03_JPRB,5.9042E-03_JPRB,3.1379E-02_JPRB,4.4838E-02_JPRB,5.4360E-02_JPRB,5.3969E-02_JPRB/)
KBO( :, 1,23, 5) = (/&
&3.9250E-03_JPRB,4.2788E-03_JPRB,2.5012E-02_JPRB,3.6685E-02_JPRB,4.5117E-02_JPRB,4.5081E-02_JPRB/)
KBO( :, 2,23, 5) = (/&
&4.0873E-03_JPRB,4.4491E-03_JPRB,2.5443E-02_JPRB,3.7065E-02_JPRB,4.5485E-02_JPRB,4.5295E-02_JPRB/)
KBO( :, 3,23, 5) = (/&
&4.2581E-03_JPRB,4.6288E-03_JPRB,2.5803E-02_JPRB,3.7271E-02_JPRB,4.5559E-02_JPRB,4.5199E-02_JPRB/)
KBO( :, 4,23, 5) = (/&
&4.4522E-03_JPRB,4.8247E-03_JPRB,2.6083E-02_JPRB,3.7398E-02_JPRB,4.5404E-02_JPRB,4.4816E-02_JPRB/)
KBO( :, 5,23, 5) = (/&
&4.6797E-03_JPRB,5.0478E-03_JPRB,2.6273E-02_JPRB,3.7409E-02_JPRB,4.5088E-02_JPRB,4.4196E-02_JPRB/)
KBO( :, 1,24, 5) = (/&
&3.2858E-03_JPRB,3.6291E-03_JPRB,2.0947E-02_JPRB,3.0585E-02_JPRB,3.7522E-02_JPRB,3.7149E-02_JPRB/)
KBO( :, 2,24, 5) = (/&
&3.4236E-03_JPRB,3.7775E-03_JPRB,2.1296E-02_JPRB,3.0855E-02_JPRB,3.7729E-02_JPRB,3.7225E-02_JPRB/)
KBO( :, 3,24, 5) = (/&
&3.5756E-03_JPRB,3.9404E-03_JPRB,2.1574E-02_JPRB,3.1034E-02_JPRB,3.7731E-02_JPRB,3.7059E-02_JPRB/)
KBO( :, 4,24, 5) = (/&
&3.7547E-03_JPRB,4.1217E-03_JPRB,2.1772E-02_JPRB,3.1132E-02_JPRB,3.7589E-02_JPRB,3.6671E-02_JPRB/)
KBO( :, 5,24, 5) = (/&
&3.9592E-03_JPRB,4.3220E-03_JPRB,2.1911E-02_JPRB,3.1105E-02_JPRB,3.7336E-02_JPRB,3.6105E-02_JPRB/)
KBO( :, 1,25, 5) = (/&
&2.7485E-03_JPRB,3.0715E-03_JPRB,1.7485E-02_JPRB,2.5411E-02_JPRB,3.1088E-02_JPRB,3.0529E-02_JPRB/)
KBO( :, 2,25, 5) = (/&
&2.8696E-03_JPRB,3.2062E-03_JPRB,1.7760E-02_JPRB,2.5637E-02_JPRB,3.1212E-02_JPRB,3.0522E-02_JPRB/)
KBO( :, 3,25, 5) = (/&
&3.0093E-03_JPRB,3.3562E-03_JPRB,1.7965E-02_JPRB,2.5792E-02_JPRB,3.1200E-02_JPRB,3.0326E-02_JPRB/)
KBO( :, 4,25, 5) = (/&
&3.1710E-03_JPRB,3.5209E-03_JPRB,1.8112E-02_JPRB,2.5834E-02_JPRB,3.1084E-02_JPRB,2.9961E-02_JPRB/)
KBO( :, 5,25, 5) = (/&
&3.3541E-03_JPRB,3.7049E-03_JPRB,1.8221E-02_JPRB,2.5787E-02_JPRB,3.0865E-02_JPRB,2.9461E-02_JPRB/)
KBO( :, 1,26, 5) = (/&
&2.3019E-03_JPRB,2.5991E-03_JPRB,1.4558E-02_JPRB,2.1083E-02_JPRB,2.5705E-02_JPRB,2.5046E-02_JPRB/)
KBO( :, 2,26, 5) = (/&
&2.4097E-03_JPRB,2.7218E-03_JPRB,1.4765E-02_JPRB,2.1273E-02_JPRB,2.5791E-02_JPRB,2.4990E-02_JPRB/)
KBO( :, 3,26, 5) = (/&
&2.5374E-03_JPRB,2.8582E-03_JPRB,1.4920E-02_JPRB,2.1375E-02_JPRB,2.5785E-02_JPRB,2.4784E-02_JPRB/)
KBO( :, 4,26, 5) = (/&
&2.6838E-03_JPRB,3.0095E-03_JPRB,1.5036E-02_JPRB,2.1391E-02_JPRB,2.5681E-02_JPRB,2.4453E-02_JPRB/)
KBO( :, 5,26, 5) = (/&
&2.8416E-03_JPRB,3.1735E-03_JPRB,1.5124E-02_JPRB,2.1341E-02_JPRB,2.5468E-02_JPRB,2.4016E-02_JPRB/)
KBO( :, 1,27, 5) = (/&
&1.9284E-03_JPRB,2.1979E-03_JPRB,1.2092E-02_JPRB,1.7474E-02_JPRB,2.1233E-02_JPRB,2.0526E-02_JPRB/)
KBO( :, 2,27, 5) = (/&
&2.0271E-03_JPRB,2.3110E-03_JPRB,1.2248E-02_JPRB,1.7617E-02_JPRB,2.1305E-02_JPRB,2.0445E-02_JPRB/)
KBO( :, 3,27, 5) = (/&
&2.1413E-03_JPRB,2.4339E-03_JPRB,1.2368E-02_JPRB,1.7683E-02_JPRB,2.1297E-02_JPRB,2.0248E-02_JPRB/)
KBO( :, 4,27, 5) = (/&
&2.2700E-03_JPRB,2.5708E-03_JPRB,1.2461E-02_JPRB,1.7683E-02_JPRB,2.1187E-02_JPRB,1.9954E-02_JPRB/)
KBO( :, 5,27, 5) = (/&
&2.4050E-03_JPRB,2.7137E-03_JPRB,1.2547E-02_JPRB,1.7644E-02_JPRB,2.0996E-02_JPRB,1.9578E-02_JPRB/)
KBO( :, 1,28, 5) = (/&
&1.6177E-03_JPRB,1.8598E-03_JPRB,1.0025E-02_JPRB,1.4464E-02_JPRB,1.7533E-02_JPRB,1.6811E-02_JPRB/)
KBO( :, 2,28, 5) = (/&
&1.7070E-03_JPRB,1.9616E-03_JPRB,1.0146E-02_JPRB,1.4566E-02_JPRB,1.7595E-02_JPRB,1.6720E-02_JPRB/)
KBO( :, 3,28, 5) = (/&
&1.8084E-03_JPRB,2.0731E-03_JPRB,1.0240E-02_JPRB,1.4610E-02_JPRB,1.7567E-02_JPRB,1.6539E-02_JPRB/)
KBO( :, 4,28, 5) = (/&
&1.9191E-03_JPRB,2.1930E-03_JPRB,1.0326E-02_JPRB,1.4610E-02_JPRB,1.7462E-02_JPRB,1.6282E-02_JPRB/)
KBO( :, 5,28, 5) = (/&
&2.0364E-03_JPRB,2.3203E-03_JPRB,1.0409E-02_JPRB,1.4583E-02_JPRB,1.7296E-02_JPRB,1.5960E-02_JPRB/)
KBO( :, 1,29, 5) = (/&
&1.3593E-03_JPRB,1.5756E-03_JPRB,8.3017E-03_JPRB,1.1957E-02_JPRB,1.4479E-02_JPRB,1.3772E-02_JPRB/)
KBO( :, 2,29, 5) = (/&
&1.4401E-03_JPRB,1.6674E-03_JPRB,8.3969E-03_JPRB,1.2033E-02_JPRB,1.4515E-02_JPRB,1.3681E-02_JPRB/)
KBO( :, 3,29, 5) = (/&
&1.5286E-03_JPRB,1.7667E-03_JPRB,8.4784E-03_JPRB,1.2064E-02_JPRB,1.4477E-02_JPRB,1.3518E-02_JPRB/)
KBO( :, 4,29, 5) = (/&
&1.6239E-03_JPRB,1.8725E-03_JPRB,8.5587E-03_JPRB,1.2064E-02_JPRB,1.4381E-02_JPRB,1.3294E-02_JPRB/)
KBO( :, 5,29, 5) = (/&
&1.7270E-03_JPRB,1.9868E-03_JPRB,8.6438E-03_JPRB,1.2057E-02_JPRB,1.4239E-02_JPRB,1.3028E-02_JPRB/)
KBO( :, 1,30, 5) = (/&
&1.1445E-03_JPRB,1.3361E-03_JPRB,6.8720E-03_JPRB,9.8791E-03_JPRB,1.1950E-02_JPRB,1.1283E-02_JPRB/)
KBO( :, 2,30, 5) = (/&
&1.2156E-03_JPRB,1.4188E-03_JPRB,6.9493E-03_JPRB,9.9349E-03_JPRB,1.1964E-02_JPRB,1.1195E-02_JPRB/)
KBO( :, 3,30, 5) = (/&
&1.2922E-03_JPRB,1.5061E-03_JPRB,7.0248E-03_JPRB,9.9580E-03_JPRB,1.1924E-02_JPRB,1.1051E-02_JPRB/)
KBO( :, 4,30, 5) = (/&
&1.3747E-03_JPRB,1.6004E-03_JPRB,7.1033E-03_JPRB,9.9696E-03_JPRB,1.1840E-02_JPRB,1.0864E-02_JPRB/)
KBO( :, 5,30, 5) = (/&
&1.4679E-03_JPRB,1.7048E-03_JPRB,7.1904E-03_JPRB,9.9722E-03_JPRB,1.1724E-02_JPRB,1.0645E-02_JPRB/)
KBO( :, 1,31, 5) = (/&
&9.6571E-04_JPRB,1.1355E-03_JPRB,5.6867E-03_JPRB,8.1598E-03_JPRB,9.8539E-03_JPRB,9.2507E-03_JPRB/)
KBO( :, 2,31, 5) = (/&
&1.0268E-03_JPRB,1.2081E-03_JPRB,5.7561E-03_JPRB,8.2013E-03_JPRB,9.8560E-03_JPRB,9.1701E-03_JPRB/)
KBO( :, 3,31, 5) = (/&
&1.0932E-03_JPRB,1.2857E-03_JPRB,5.8273E-03_JPRB,8.2243E-03_JPRB,9.8178E-03_JPRB,9.0482E-03_JPRB/)
KBO( :, 4,31, 5) = (/&
&1.1666E-03_JPRB,1.3712E-03_JPRB,5.9075E-03_JPRB,8.2428E-03_JPRB,9.7465E-03_JPRB,8.8946E-03_JPRB/)
KBO( :, 5,31, 5) = (/&
&1.2509E-03_JPRB,1.4662E-03_JPRB,5.9896E-03_JPRB,8.2555E-03_JPRB,9.6578E-03_JPRB,8.7121E-03_JPRB/)
KBO( :, 1,32, 5) = (/&
&8.1549E-04_JPRB,9.6647E-04_JPRB,4.7087E-03_JPRB,6.7390E-03_JPRB,8.1222E-03_JPRB,7.5866E-03_JPRB/)
KBO( :, 2,32, 5) = (/&
&8.6808E-04_JPRB,1.0303E-03_JPRB,4.7745E-03_JPRB,6.7731E-03_JPRB,8.1188E-03_JPRB,7.5153E-03_JPRB/)
KBO( :, 3,32, 5) = (/&
&9.2635E-04_JPRB,1.0997E-03_JPRB,4.8447E-03_JPRB,6.7992E-03_JPRB,8.0828E-03_JPRB,7.4160E-03_JPRB/)
KBO( :, 4,32, 5) = (/&
&9.9293E-04_JPRB,1.1779E-03_JPRB,4.9222E-03_JPRB,6.8226E-03_JPRB,8.0279E-03_JPRB,7.2877E-03_JPRB/)
KBO( :, 5,32, 5) = (/&
&1.0686E-03_JPRB,1.2641E-03_JPRB,4.9952E-03_JPRB,6.8449E-03_JPRB,7.9628E-03_JPRB,7.1366E-03_JPRB/)
KBO( :, 1,33, 5) = (/&
&6.8866E-04_JPRB,8.2347E-04_JPRB,3.9045E-03_JPRB,5.5660E-03_JPRB,6.6934E-03_JPRB,6.2259E-03_JPRB/)
KBO( :, 2,33, 5) = (/&
&7.3455E-04_JPRB,8.7986E-04_JPRB,3.9663E-03_JPRB,5.5986E-03_JPRB,6.6866E-03_JPRB,6.1677E-03_JPRB/)
KBO( :, 3,33, 5) = (/&
&7.8698E-04_JPRB,9.4282E-04_JPRB,4.0361E-03_JPRB,5.6281E-03_JPRB,6.6584E-03_JPRB,6.0842E-03_JPRB/)
KBO( :, 4,33, 5) = (/&
&8.4706E-04_JPRB,1.0140E-03_JPRB,4.1036E-03_JPRB,5.6568E-03_JPRB,6.6185E-03_JPRB,5.9772E-03_JPRB/)
KBO( :, 5,33, 5) = (/&
&9.1579E-04_JPRB,1.0926E-03_JPRB,4.1728E-03_JPRB,5.6818E-03_JPRB,6.5697E-03_JPRB,5.8519E-03_JPRB/)
KBO( :, 1,34, 5) = (/&
&5.8058E-04_JPRB,7.0023E-04_JPRB,3.2403E-03_JPRB,4.6005E-03_JPRB,5.5166E-03_JPRB,5.1111E-03_JPRB/)
KBO( :, 2,34, 5) = (/&
&6.2122E-04_JPRB,7.5048E-04_JPRB,3.3005E-03_JPRB,4.6334E-03_JPRB,5.5099E-03_JPRB,5.0626E-03_JPRB/)
KBO( :, 3,34, 5) = (/&
&6.6865E-04_JPRB,8.0788E-04_JPRB,3.3630E-03_JPRB,4.6658E-03_JPRB,5.4906E-03_JPRB,4.9925E-03_JPRB/)
KBO( :, 4,34, 5) = (/&
&7.2278E-04_JPRB,8.7227E-04_JPRB,3.4246E-03_JPRB,4.6970E-03_JPRB,5.4619E-03_JPRB,4.9033E-03_JPRB/)
KBO( :, 5,34, 5) = (/&
&7.8420E-04_JPRB,9.4411E-04_JPRB,3.4913E-03_JPRB,4.7221E-03_JPRB,5.4290E-03_JPRB,4.7999E-03_JPRB/)
KBO( :, 1,35, 5) = (/&
&4.8680E-04_JPRB,5.9168E-04_JPRB,2.6886E-03_JPRB,3.8031E-03_JPRB,4.5472E-03_JPRB,4.2007E-03_JPRB/)
KBO( :, 2,35, 5) = (/&
&5.2287E-04_JPRB,6.3647E-04_JPRB,2.7442E-03_JPRB,3.8365E-03_JPRB,4.5442E-03_JPRB,4.1613E-03_JPRB/)
KBO( :, 3,35, 5) = (/&
&5.6494E-04_JPRB,6.8801E-04_JPRB,2.7990E-03_JPRB,3.8713E-03_JPRB,4.5326E-03_JPRB,4.1035E-03_JPRB/)
KBO( :, 4,35, 5) = (/&
&6.1346E-04_JPRB,7.4591E-04_JPRB,2.8564E-03_JPRB,3.9017E-03_JPRB,4.5150E-03_JPRB,4.0303E-03_JPRB/)
KBO( :, 5,35, 5) = (/&
&6.6714E-04_JPRB,8.1053E-04_JPRB,2.9207E-03_JPRB,3.9294E-03_JPRB,4.4955E-03_JPRB,3.9472E-03_JPRB/)
KBO( :, 1,36, 5) = (/&
&4.0556E-04_JPRB,4.9618E-04_JPRB,2.2284E-03_JPRB,3.1440E-03_JPRB,3.7492E-03_JPRB,3.4553E-03_JPRB/)
KBO( :, 2,36, 5) = (/&
&4.3716E-04_JPRB,5.3572E-04_JPRB,2.2775E-03_JPRB,3.1778E-03_JPRB,3.7514E-03_JPRB,3.4245E-03_JPRB/)
KBO( :, 3,36, 5) = (/&
&4.7403E-04_JPRB,5.8132E-04_JPRB,2.3270E-03_JPRB,3.2124E-03_JPRB,3.7468E-03_JPRB,3.3780E-03_JPRB/)
KBO( :, 4,36, 5) = (/&
&5.1659E-04_JPRB,6.3283E-04_JPRB,2.3801E-03_JPRB,3.2412E-03_JPRB,3.7380E-03_JPRB,3.3193E-03_JPRB/)
KBO( :, 5,36, 5) = (/&
&5.6320E-04_JPRB,6.9001E-04_JPRB,2.4401E-03_JPRB,3.2716E-03_JPRB,3.7268E-03_JPRB,3.2538E-03_JPRB/)
KBO( :, 1,37, 5) = (/&
&3.3445E-04_JPRB,4.1138E-04_JPRB,1.8414E-03_JPRB,2.5960E-03_JPRB,3.0918E-03_JPRB,2.8440E-03_JPRB/)
KBO( :, 2,37, 5) = (/&
&3.6139E-04_JPRB,4.4542E-04_JPRB,1.8850E-03_JPRB,2.6293E-03_JPRB,3.0984E-03_JPRB,2.8216E-03_JPRB/)
KBO( :, 3,37, 5) = (/&
&3.9302E-04_JPRB,4.8495E-04_JPRB,1.9291E-03_JPRB,2.6624E-03_JPRB,3.0995E-03_JPRB,2.7862E-03_JPRB/)
KBO( :, 4,37, 5) = (/&
&4.2962E-04_JPRB,5.3000E-04_JPRB,1.9778E-03_JPRB,2.6913E-03_JPRB,3.0985E-03_JPRB,2.7408E-03_JPRB/)
KBO( :, 5,37, 5) = (/&
&4.6957E-04_JPRB,5.7981E-04_JPRB,2.0321E-03_JPRB,2.7224E-03_JPRB,3.0939E-03_JPRB,2.6899E-03_JPRB/)
KBO( :, 1,38, 5) = (/&
&2.7565E-04_JPRB,3.4069E-04_JPRB,1.5215E-03_JPRB,2.1439E-03_JPRB,2.5502E-03_JPRB,2.3418E-03_JPRB/)
KBO( :, 2,38, 5) = (/&
&2.9863E-04_JPRB,3.7003E-04_JPRB,1.5598E-03_JPRB,2.1756E-03_JPRB,2.5600E-03_JPRB,2.3264E-03_JPRB/)
KBO( :, 3,38, 5) = (/&
&3.2577E-04_JPRB,4.0422E-04_JPRB,1.5995E-03_JPRB,2.2068E-03_JPRB,2.5657E-03_JPRB,2.2995E-03_JPRB/)
KBO( :, 4,38, 5) = (/&
&3.5709E-04_JPRB,4.4339E-04_JPRB,1.6429E-03_JPRB,2.2349E-03_JPRB,2.5695E-03_JPRB,2.2650E-03_JPRB/)
KBO( :, 5,38, 5) = (/&
&3.9150E-04_JPRB,4.8695E-04_JPRB,1.6922E-03_JPRB,2.2658E-03_JPRB,2.5693E-03_JPRB,2.2257E-03_JPRB/)
KBO( :, 1,39, 5) = (/&
&2.2724E-04_JPRB,2.8211E-04_JPRB,1.2574E-03_JPRB,1.7709E-03_JPRB,2.1038E-03_JPRB,1.9299E-03_JPRB/)
KBO( :, 2,39, 5) = (/&
&2.4681E-04_JPRB,3.0736E-04_JPRB,1.2915E-03_JPRB,1.8008E-03_JPRB,2.1155E-03_JPRB,1.9194E-03_JPRB/)
KBO( :, 3,39, 5) = (/&
&2.7014E-04_JPRB,3.3704E-04_JPRB,1.3268E-03_JPRB,1.8293E-03_JPRB,2.1247E-03_JPRB,1.8997E-03_JPRB/)
KBO( :, 4,39, 5) = (/&
&2.9696E-04_JPRB,3.7109E-04_JPRB,1.3658E-03_JPRB,1.8564E-03_JPRB,2.1316E-03_JPRB,1.8739E-03_JPRB/)
KBO( :, 5,39, 5) = (/&
&3.2661E-04_JPRB,4.0911E-04_JPRB,1.4099E-03_JPRB,1.8866E-03_JPRB,2.1349E-03_JPRB,1.8442E-03_JPRB/)
KBO( :, 1,40, 5) = (/&
&1.8579E-04_JPRB,2.3160E-04_JPRB,1.0365E-03_JPRB,1.4603E-03_JPRB,1.7343E-03_JPRB,1.5866E-03_JPRB/)
KBO( :, 2,40, 5) = (/&
&2.0221E-04_JPRB,2.5290E-04_JPRB,1.0666E-03_JPRB,1.4877E-03_JPRB,1.7476E-03_JPRB,1.5810E-03_JPRB/)
KBO( :, 3,40, 5) = (/&
&2.2187E-04_JPRB,2.7826E-04_JPRB,1.0975E-03_JPRB,1.5141E-03_JPRB,1.7589E-03_JPRB,1.5669E-03_JPRB/)
KBO( :, 4,40, 5) = (/&
&2.4464E-04_JPRB,3.0747E-04_JPRB,1.1320E-03_JPRB,1.5399E-03_JPRB,1.7682E-03_JPRB,1.5479E-03_JPRB/)
KBO( :, 5,40, 5) = (/&
&2.6982E-04_JPRB,3.4023E-04_JPRB,1.1712E-03_JPRB,1.5681E-03_JPRB,1.7744E-03_JPRB,1.5254E-03_JPRB/)
KBO( :, 1,41, 5) = (/&
&1.5166E-04_JPRB,1.8980E-04_JPRB,8.5379E-04_JPRB,1.2035E-03_JPRB,1.4293E-03_JPRB,1.3039E-03_JPRB/)
KBO( :, 2,41, 5) = (/&
&1.6546E-04_JPRB,2.0775E-04_JPRB,8.8025E-04_JPRB,1.2284E-03_JPRB,1.4432E-03_JPRB,1.3014E-03_JPRB/)
KBO( :, 3,41, 5) = (/&
&1.8194E-04_JPRB,2.2930E-04_JPRB,9.0741E-04_JPRB,1.2528E-03_JPRB,1.4560E-03_JPRB,1.2919E-03_JPRB/)
KBO( :, 4,41, 5) = (/&
&2.0120E-04_JPRB,2.5429E-04_JPRB,9.3787E-04_JPRB,1.2766E-03_JPRB,1.4664E-03_JPRB,1.2782E-03_JPRB/)
KBO( :, 5,41, 5) = (/&
&2.2263E-04_JPRB,2.8250E-04_JPRB,9.7232E-04_JPRB,1.3029E-03_JPRB,1.4746E-03_JPRB,1.2613E-03_JPRB/)
KBO( :, 1,42, 5) = (/&
&1.2374E-04_JPRB,1.5546E-04_JPRB,7.0307E-04_JPRB,9.9137E-04_JPRB,1.1774E-03_JPRB,1.0716E-03_JPRB/)
KBO( :, 2,42, 5) = (/&
&1.3533E-04_JPRB,1.7055E-04_JPRB,7.2623E-04_JPRB,1.0140E-03_JPRB,1.1917E-03_JPRB,1.0713E-03_JPRB/)
KBO( :, 3,42, 5) = (/&
&1.4914E-04_JPRB,1.8882E-04_JPRB,7.4998E-04_JPRB,1.0363E-03_JPRB,1.2049E-03_JPRB,1.0651E-03_JPRB/)
KBO( :, 4,42, 5) = (/&
&1.6539E-04_JPRB,2.1022E-04_JPRB,7.7693E-04_JPRB,1.0584E-03_JPRB,1.2160E-03_JPRB,1.0556E-03_JPRB/)
KBO( :, 5,42, 5) = (/&
&1.8361E-04_JPRB,2.3442E-04_JPRB,8.0719E-04_JPRB,1.0824E-03_JPRB,1.2253E-03_JPRB,1.0431E-03_JPRB/)
KBO( :, 1,43, 5) = (/&
&1.0045E-04_JPRB,1.2664E-04_JPRB,5.7734E-04_JPRB,8.1536E-04_JPRB,9.6884E-04_JPRB,8.7977E-04_JPRB/)
KBO( :, 2,43, 5) = (/&
&1.1005E-04_JPRB,1.3917E-04_JPRB,5.9774E-04_JPRB,8.3582E-04_JPRB,9.8292E-04_JPRB,8.8149E-04_JPRB/)
KBO( :, 3,43, 5) = (/&
&1.2153E-04_JPRB,1.5445E-04_JPRB,6.1853E-04_JPRB,8.5606E-04_JPRB,9.9619E-04_JPRB,8.7826E-04_JPRB/)
KBO( :, 4,43, 5) = (/&
&1.3510E-04_JPRB,1.7258E-04_JPRB,6.4186E-04_JPRB,8.7601E-04_JPRB,1.0075E-03_JPRB,8.7187E-04_JPRB/)
KBO( :, 5,43, 5) = (/&
&1.5043E-04_JPRB,1.9318E-04_JPRB,6.6828E-04_JPRB,8.9763E-04_JPRB,1.0172E-03_JPRB,8.6294E-04_JPRB/)
KBO( :, 1,44, 5) = (/&
&8.1305E-05_JPRB,1.0284E-04_JPRB,4.7336E-04_JPRB,6.6976E-04_JPRB,7.9626E-04_JPRB,7.2189E-04_JPRB/)
KBO( :, 2,44, 5) = (/&
&8.9193E-05_JPRB,1.1315E-04_JPRB,4.9111E-04_JPRB,6.8790E-04_JPRB,8.0980E-04_JPRB,7.2505E-04_JPRB/)
KBO( :, 3,44, 5) = (/&
&9.8676E-05_JPRB,1.2583E-04_JPRB,5.0913E-04_JPRB,7.0617E-04_JPRB,8.2256E-04_JPRB,7.2410E-04_JPRB/)
KBO( :, 4,44, 5) = (/&
&1.0996E-04_JPRB,1.4111E-04_JPRB,5.2937E-04_JPRB,7.2436E-04_JPRB,8.3410E-04_JPRB,7.2019E-04_JPRB/)
KBO( :, 5,44, 5) = (/&
&1.2282E-04_JPRB,1.5859E-04_JPRB,5.5236E-04_JPRB,7.4376E-04_JPRB,8.4405E-04_JPRB,7.1417E-04_JPRB/)
KBO( :, 1,45, 5) = (/&
&6.5786E-05_JPRB,8.3420E-05_JPRB,3.8779E-04_JPRB,5.4957E-04_JPRB,6.5386E-04_JPRB,5.9205E-04_JPRB/)
KBO( :, 2,45, 5) = (/&
&7.2236E-05_JPRB,9.1932E-05_JPRB,4.0331E-04_JPRB,5.6601E-04_JPRB,6.6677E-04_JPRB,5.9628E-04_JPRB/)
KBO( :, 3,45, 5) = (/&
&8.0050E-05_JPRB,1.0242E-04_JPRB,4.1883E-04_JPRB,5.8238E-04_JPRB,6.7888E-04_JPRB,5.9688E-04_JPRB/)
KBO( :, 4,45, 5) = (/&
&8.9405E-05_JPRB,1.1521E-04_JPRB,4.3614E-04_JPRB,5.9853E-04_JPRB,6.8997E-04_JPRB,5.9495E-04_JPRB/)
KBO( :, 5,45, 5) = (/&
&1.0018E-04_JPRB,1.3003E-04_JPRB,4.5610E-04_JPRB,6.1576E-04_JPRB,6.9970E-04_JPRB,5.9107E-04_JPRB/)
KBO( :, 1,46, 5) = (/&
&5.3104E-05_JPRB,6.7476E-05_JPRB,3.1711E-04_JPRB,4.5030E-04_JPRB,5.3634E-04_JPRB,4.8529E-04_JPRB/)
KBO( :, 2,46, 5) = (/&
&5.8310E-05_JPRB,7.4440E-05_JPRB,3.3050E-04_JPRB,4.6471E-04_JPRB,5.4814E-04_JPRB,4.8994E-04_JPRB/)
KBO( :, 3,46, 5) = (/&
&6.4721E-05_JPRB,8.3070E-05_JPRB,3.4388E-04_JPRB,4.7945E-04_JPRB,5.5942E-04_JPRB,4.9178E-04_JPRB/)
KBO( :, 4,46, 5) = (/&
&7.2446E-05_JPRB,9.3711E-05_JPRB,3.5879E-04_JPRB,4.9397E-04_JPRB,5.7010E-04_JPRB,4.9130E-04_JPRB/)
KBO( :, 5,46, 5) = (/&
&8.1435E-05_JPRB,1.0620E-04_JPRB,3.7604E-04_JPRB,5.0936E-04_JPRB,5.7974E-04_JPRB,4.8929E-04_JPRB/)
KBO( :, 1,47, 5) = (/&
&4.2686E-05_JPRB,5.4314E-05_JPRB,2.5853E-04_JPRB,3.6799E-04_JPRB,4.3908E-04_JPRB,3.9686E-04_JPRB/)
KBO( :, 2,47, 5) = (/&
&4.6834E-05_JPRB,5.9958E-05_JPRB,2.7010E-04_JPRB,3.8053E-04_JPRB,4.4992E-04_JPRB,4.0194E-04_JPRB/)
KBO( :, 3,47, 5) = (/&
&5.2031E-05_JPRB,6.6956E-05_JPRB,2.8174E-04_JPRB,3.9382E-04_JPRB,4.6023E-04_JPRB,4.0464E-04_JPRB/)
KBO( :, 4,47, 5) = (/&
&5.8344E-05_JPRB,7.5683E-05_JPRB,2.9437E-04_JPRB,4.0674E-04_JPRB,4.7039E-04_JPRB,4.0528E-04_JPRB/)
KBO( :, 5,47, 5) = (/&
&6.5774E-05_JPRB,8.6102E-05_JPRB,3.0904E-04_JPRB,4.2022E-04_JPRB,4.7955E-04_JPRB,4.0445E-04_JPRB/)
KBO( :, 1,48, 5) = (/&
&3.4313E-05_JPRB,4.3687E-05_JPRB,2.1071E-04_JPRB,3.0035E-04_JPRB,3.5902E-04_JPRB,3.2436E-04_JPRB/)
KBO( :, 2,48, 5) = (/&
&3.7593E-05_JPRB,4.8250E-05_JPRB,2.2059E-04_JPRB,3.1121E-04_JPRB,3.6875E-04_JPRB,3.2956E-04_JPRB/)
KBO( :, 3,48, 5) = (/&
&4.1785E-05_JPRB,5.3906E-05_JPRB,2.3062E-04_JPRB,3.2298E-04_JPRB,3.7819E-04_JPRB,3.3287E-04_JPRB/)
KBO( :, 4,48, 5) = (/&
&4.6905E-05_JPRB,6.0993E-05_JPRB,2.4128E-04_JPRB,3.3438E-04_JPRB,3.8763E-04_JPRB,3.3428E-04_JPRB/)
KBO( :, 5,48, 5) = (/&
&5.3020E-05_JPRB,6.9645E-05_JPRB,2.5366E-04_JPRB,3.4620E-04_JPRB,3.9625E-04_JPRB,3.3440E-04_JPRB/)
KBO( :, 1,49, 5) = (/&
&2.7583E-05_JPRB,3.5115E-05_JPRB,1.7155E-04_JPRB,2.4481E-04_JPRB,2.9317E-04_JPRB,2.6498E-04_JPRB/)
KBO( :, 2,49, 5) = (/&
&3.0170E-05_JPRB,3.8800E-05_JPRB,1.7986E-04_JPRB,2.5418E-04_JPRB,3.0189E-04_JPRB,2.7025E-04_JPRB/)
KBO( :, 3,49, 5) = (/&
&3.3521E-05_JPRB,4.3336E-05_JPRB,1.8852E-04_JPRB,2.6447E-04_JPRB,3.1043E-04_JPRB,2.7387E-04_JPRB/)
KBO( :, 4,49, 5) = (/&
&3.7657E-05_JPRB,4.9084E-05_JPRB,1.9758E-04_JPRB,2.7449E-04_JPRB,3.1899E-04_JPRB,2.7586E-04_JPRB/)
KBO( :, 5,49, 5) = (/&
&4.2653E-05_JPRB,5.6226E-05_JPRB,2.0799E-04_JPRB,2.8484E-04_JPRB,3.2703E-04_JPRB,2.7676E-04_JPRB/)
KBO( :, 1,50, 5) = (/&
&2.2217E-05_JPRB,2.8271E-05_JPRB,1.3969E-04_JPRB,1.9948E-04_JPRB,2.3919E-04_JPRB,2.1597E-04_JPRB/)
KBO( :, 2,50, 5) = (/&
&2.4266E-05_JPRB,3.1256E-05_JPRB,1.4667E-04_JPRB,2.0754E-04_JPRB,2.4693E-04_JPRB,2.2097E-04_JPRB/)
KBO( :, 3,50, 5) = (/&
&2.6941E-05_JPRB,3.4914E-05_JPRB,1.5413E-04_JPRB,2.1640E-04_JPRB,2.5457E-04_JPRB,2.2461E-04_JPRB/)
KBO( :, 4,50, 5) = (/&
&3.0285E-05_JPRB,3.9575E-05_JPRB,1.6186E-04_JPRB,2.2530E-04_JPRB,2.6234E-04_JPRB,2.2692E-04_JPRB/)
KBO( :, 5,50, 5) = (/&
&3.4382E-05_JPRB,4.5471E-05_JPRB,1.7067E-04_JPRB,2.3435E-04_JPRB,2.6986E-04_JPRB,2.2825E-04_JPRB/)
KBO( :, 1,51, 5) = (/&
&1.7903E-05_JPRB,2.2773E-05_JPRB,1.1369E-04_JPRB,1.6241E-04_JPRB,1.9498E-04_JPRB,1.7573E-04_JPRB/)
KBO( :, 2,51, 5) = (/&
&1.9536E-05_JPRB,2.5192E-05_JPRB,1.1954E-04_JPRB,1.6937E-04_JPRB,2.0181E-04_JPRB,1.8035E-04_JPRB/)
KBO( :, 3,51, 5) = (/&
&2.1660E-05_JPRB,2.8144E-05_JPRB,1.2601E-04_JPRB,1.7700E-04_JPRB,2.0866E-04_JPRB,1.8387E-04_JPRB/)
KBO( :, 4,51, 5) = (/&
&2.4364E-05_JPRB,3.1929E-05_JPRB,1.3264E-04_JPRB,1.8486E-04_JPRB,2.1560E-04_JPRB,1.8633E-04_JPRB/)
KBO( :, 5,51, 5) = (/&
&2.7713E-05_JPRB,3.6767E-05_JPRB,1.4007E-04_JPRB,1.9273E-04_JPRB,2.2249E-04_JPRB,1.8786E-04_JPRB/)
KBO( :, 1,52, 5) = (/&
&1.4419E-05_JPRB,1.8337E-05_JPRB,9.2470E-05_JPRB,1.3214E-04_JPRB,1.5869E-04_JPRB,1.4290E-04_JPRB/)
KBO( :, 2,52, 5) = (/&
&1.5732E-05_JPRB,2.0292E-05_JPRB,9.7355E-05_JPRB,1.3808E-04_JPRB,1.6476E-04_JPRB,1.4717E-04_JPRB/)
KBO( :, 3,52, 5) = (/&
&1.7402E-05_JPRB,2.2667E-05_JPRB,1.0291E-04_JPRB,1.4460E-04_JPRB,1.7083E-04_JPRB,1.5054E-04_JPRB/)
KBO( :, 4,52, 5) = (/&
&1.9581E-05_JPRB,2.5730E-05_JPRB,1.0857E-04_JPRB,1.5152E-04_JPRB,1.7697E-04_JPRB,1.5305E-04_JPRB/)
KBO( :, 5,52, 5) = (/&
&2.2301E-05_JPRB,2.9666E-05_JPRB,1.1484E-04_JPRB,1.5832E-04_JPRB,1.8319E-04_JPRB,1.5468E-04_JPRB/)
KBO( :, 1,53, 5) = (/&
&1.1603E-05_JPRB,1.4759E-05_JPRB,7.5154E-05_JPRB,1.0740E-04_JPRB,1.2904E-04_JPRB,1.1618E-04_JPRB/)
KBO( :, 2,53, 5) = (/&
&1.2667E-05_JPRB,1.6333E-05_JPRB,7.9235E-05_JPRB,1.1248E-04_JPRB,1.3438E-04_JPRB,1.2007E-04_JPRB/)
KBO( :, 3,53, 5) = (/&
&1.3975E-05_JPRB,1.8245E-05_JPRB,8.3933E-05_JPRB,1.1800E-04_JPRB,1.3960E-04_JPRB,1.2329E-04_JPRB/)
KBO( :, 4,53, 5) = (/&
&1.5718E-05_JPRB,2.0708E-05_JPRB,8.8803E-05_JPRB,1.2402E-04_JPRB,1.4502E-04_JPRB,1.2574E-04_JPRB/)
KBO( :, 5,53, 5) = (/&
&1.7916E-05_JPRB,2.3895E-05_JPRB,9.4069E-05_JPRB,1.2995E-04_JPRB,1.5061E-04_JPRB,1.2749E-04_JPRB/)
KBO( :, 1,54, 5) = (/&
&9.3552E-06_JPRB,1.1912E-05_JPRB,6.1100E-05_JPRB,8.7316E-05_JPRB,1.0492E-04_JPRB,9.4080E-05_JPRB/)
KBO( :, 2,54, 5) = (/&
&1.0223E-05_JPRB,1.3180E-05_JPRB,6.4519E-05_JPRB,9.1648E-05_JPRB,1.0960E-04_JPRB,9.7474E-05_JPRB/)
KBO( :, 3,54, 5) = (/&
&1.1260E-05_JPRB,1.4728E-05_JPRB,6.8487E-05_JPRB,9.6346E-05_JPRB,1.1410E-04_JPRB,1.0031E-04_JPRB/)
KBO( :, 4,54, 5) = (/&
&1.2653E-05_JPRB,1.6714E-05_JPRB,7.2680E-05_JPRB,1.0156E-04_JPRB,1.1881E-04_JPRB,1.0254E-04_JPRB/)
KBO( :, 5,54, 5) = (/&
&1.4429E-05_JPRB,1.9299E-05_JPRB,7.7137E-05_JPRB,1.0670E-04_JPRB,1.2378E-04_JPRB,1.0417E-04_JPRB/)
KBO( :, 1,55, 5) = (/&
&7.5478E-06_JPRB,9.6233E-06_JPRB,4.9651E-05_JPRB,7.0961E-05_JPRB,8.5289E-05_JPRB,7.6005E-05_JPRB/)
KBO( :, 2,55, 5) = (/&
&8.2560E-06_JPRB,1.0645E-05_JPRB,5.2535E-05_JPRB,7.4651E-05_JPRB,8.9338E-05_JPRB,7.8872E-05_JPRB/)
KBO( :, 3,55, 5) = (/&
&9.0843E-06_JPRB,1.1897E-05_JPRB,5.5871E-05_JPRB,7.8654E-05_JPRB,9.3220E-05_JPRB,8.1320E-05_JPRB/)
KBO( :, 4,55, 5) = (/&
&1.0193E-05_JPRB,1.3501E-05_JPRB,5.9444E-05_JPRB,8.3119E-05_JPRB,9.7325E-05_JPRB,8.3263E-05_JPRB/)
KBO( :, 5,55, 5) = (/&
&1.1628E-05_JPRB,1.5599E-05_JPRB,6.3252E-05_JPRB,8.7606E-05_JPRB,1.0169E-04_JPRB,8.4683E-05_JPRB/)
KBO( :, 1,56, 5) = (/&
&6.0903E-06_JPRB,7.7718E-06_JPRB,4.0310E-05_JPRB,5.7612E-05_JPRB,6.9244E-05_JPRB,6.1397E-05_JPRB/)
KBO( :, 2,56, 5) = (/&
&6.6641E-06_JPRB,8.5930E-06_JPRB,4.2736E-05_JPRB,6.0755E-05_JPRB,7.2744E-05_JPRB,6.3793E-05_JPRB/)
KBO( :, 3,56, 5) = (/&
&7.3291E-06_JPRB,9.6040E-06_JPRB,4.5523E-05_JPRB,6.4146E-05_JPRB,7.6097E-05_JPRB,6.5892E-05_JPRB/)
KBO( :, 4,56, 5) = (/&
&8.2059E-06_JPRB,1.0897E-05_JPRB,4.8582E-05_JPRB,6.7958E-05_JPRB,7.9612E-05_JPRB,6.7572E-05_JPRB/)
KBO( :, 5,56, 5) = (/&
&9.3593E-06_JPRB,1.2596E-05_JPRB,5.1826E-05_JPRB,7.1849E-05_JPRB,8.3426E-05_JPRB,6.8816E-05_JPRB/)
KBO( :, 1,57, 5) = (/&
&4.9169E-06_JPRB,6.2768E-06_JPRB,3.2692E-05_JPRB,4.6726E-05_JPRB,5.6174E-05_JPRB,4.9561E-05_JPRB/)
KBO( :, 2,57, 5) = (/&
&5.3758E-06_JPRB,6.9313E-06_JPRB,3.4730E-05_JPRB,4.9399E-05_JPRB,5.9171E-05_JPRB,5.1566E-05_JPRB/)
KBO( :, 3,57, 5) = (/&
&5.9131E-06_JPRB,7.7475E-06_JPRB,3.7055E-05_JPRB,5.2261E-05_JPRB,6.2056E-05_JPRB,5.3362E-05_JPRB/)
KBO( :, 4,57, 5) = (/&
&6.6016E-06_JPRB,8.7843E-06_JPRB,3.9661E-05_JPRB,5.5498E-05_JPRB,6.5058E-05_JPRB,5.4813E-05_JPRB/)
KBO( :, 5,57, 5) = (/&
&7.5245E-06_JPRB,1.0159E-05_JPRB,4.2420E-05_JPRB,5.8870E-05_JPRB,6.8384E-05_JPRB,5.5909E-05_JPRB/)
KBO( :, 1,58, 5) = (/&
&3.9769E-06_JPRB,5.0771E-06_JPRB,2.6520E-05_JPRB,3.7905E-05_JPRB,4.5566E-05_JPRB,3.9988E-05_JPRB/)
KBO( :, 2,58, 5) = (/&
&4.3395E-06_JPRB,5.5964E-06_JPRB,2.8222E-05_JPRB,4.0161E-05_JPRB,4.8120E-05_JPRB,4.1683E-05_JPRB/)
KBO( :, 3,58, 5) = (/&
&4.7765E-06_JPRB,6.2573E-06_JPRB,3.0162E-05_JPRB,4.2567E-05_JPRB,5.0612E-05_JPRB,4.3174E-05_JPRB/)
KBO( :, 4,58, 5) = (/&
&5.3191E-06_JPRB,7.0924E-06_JPRB,3.2377E-05_JPRB,4.5319E-05_JPRB,5.3172E-05_JPRB,4.4428E-05_JPRB/)
KBO( :, 5,58, 5) = (/&
&6.0584E-06_JPRB,8.2028E-06_JPRB,3.4727E-05_JPRB,4.8232E-05_JPRB,5.6042E-05_JPRB,4.5381E-05_JPRB/)
KBO( :, 1,59, 5) = (/&
&3.2625E-06_JPRB,4.1716E-06_JPRB,2.1747E-05_JPRB,3.1052E-05_JPRB,3.7329E-05_JPRB,3.2409E-05_JPRB/)
KBO( :, 2,59, 5) = (/&
&3.5622E-06_JPRB,4.6062E-06_JPRB,2.3191E-05_JPRB,3.2966E-05_JPRB,3.9488E-05_JPRB,3.3775E-05_JPRB/)
KBO( :, 3,59, 5) = (/&
&3.9265E-06_JPRB,5.1603E-06_JPRB,2.4857E-05_JPRB,3.5039E-05_JPRB,4.1610E-05_JPRB,3.4936E-05_JPRB/)
KBO( :, 4,59, 5) = (/&
&4.3796E-06_JPRB,5.8651E-06_JPRB,2.6758E-05_JPRB,3.7407E-05_JPRB,4.3840E-05_JPRB,3.5912E-05_JPRB/)
KBO( :, 5,59, 5) = (/&
&5.0004E-06_JPRB,6.8064E-06_JPRB,2.8778E-05_JPRB,3.9920E-05_JPRB,4.6344E-05_JPRB,3.6645E-05_JPRB/)
KBO( :, 1,13, 6) = (/&
&4.2535E-02_JPRB,4.2762E-02_JPRB,1.6998E-01_JPRB,2.5943E-01_JPRB,3.3118E-01_JPRB,3.6759E-01_JPRB/)
KBO( :, 2,13, 6) = (/&
&4.3681E-02_JPRB,4.3907E-02_JPRB,1.7098E-01_JPRB,2.6169E-01_JPRB,3.3567E-01_JPRB,3.7656E-01_JPRB/)
KBO( :, 3,13, 6) = (/&
&4.4881E-02_JPRB,4.5106E-02_JPRB,1.7235E-01_JPRB,2.6332E-01_JPRB,3.3843E-01_JPRB,3.8337E-01_JPRB/)
KBO( :, 4,13, 6) = (/&
&4.6097E-02_JPRB,4.6310E-02_JPRB,1.7381E-01_JPRB,2.6438E-01_JPRB,3.3969E-01_JPRB,3.8855E-01_JPRB/)
KBO( :, 5,13, 6) = (/&
&4.7339E-02_JPRB,4.7538E-02_JPRB,1.7512E-01_JPRB,2.6493E-01_JPRB,3.3999E-01_JPRB,3.9260E-01_JPRB/)
KBO( :, 1,14, 6) = (/&
&3.6653E-02_JPRB,3.6883E-02_JPRB,1.5729E-01_JPRB,2.3949E-01_JPRB,3.0622E-01_JPRB,3.3569E-01_JPRB/)
KBO( :, 2,14, 6) = (/&
&3.7645E-02_JPRB,3.7873E-02_JPRB,1.5902E-01_JPRB,2.4213E-01_JPRB,3.1018E-01_JPRB,3.4313E-01_JPRB/)
KBO( :, 3,14, 6) = (/&
&3.8674E-02_JPRB,3.8902E-02_JPRB,1.6072E-01_JPRB,2.4398E-01_JPRB,3.1256E-01_JPRB,3.4927E-01_JPRB/)
KBO( :, 4,14, 6) = (/&
&3.9715E-02_JPRB,3.9924E-02_JPRB,1.6228E-01_JPRB,2.4539E-01_JPRB,3.1431E-01_JPRB,3.5395E-01_JPRB/)
KBO( :, 5,14, 6) = (/&
&4.0819E-02_JPRB,4.1022E-02_JPRB,1.6343E-01_JPRB,2.4658E-01_JPRB,3.1537E-01_JPRB,3.5723E-01_JPRB/)
KBO( :, 1,15, 6) = (/&
&3.1489E-02_JPRB,3.1717E-02_JPRB,1.4459E-01_JPRB,2.1886E-01_JPRB,2.7929E-01_JPRB,3.0333E-01_JPRB/)
KBO( :, 2,15, 6) = (/&
&3.2325E-02_JPRB,3.2551E-02_JPRB,1.4651E-01_JPRB,2.2152E-01_JPRB,2.8283E-01_JPRB,3.1026E-01_JPRB/)
KBO( :, 3,15, 6) = (/&
&3.3201E-02_JPRB,3.3419E-02_JPRB,1.4819E-01_JPRB,2.2372E-01_JPRB,2.8570E-01_JPRB,3.1588E-01_JPRB/)
KBO( :, 4,15, 6) = (/&
&3.4109E-02_JPRB,3.4317E-02_JPRB,1.4957E-01_JPRB,2.2574E-01_JPRB,2.8792E-01_JPRB,3.2003E-01_JPRB/)
KBO( :, 5,15, 6) = (/&
&3.5196E-02_JPRB,3.5403E-02_JPRB,1.5074E-01_JPRB,2.2750E-01_JPRB,2.8937E-01_JPRB,3.2300E-01_JPRB/)
KBO( :, 1,16, 6) = (/&
&2.6937E-02_JPRB,2.7164E-02_JPRB,1.3162E-01_JPRB,1.9777E-01_JPRB,2.5164E-01_JPRB,2.7236E-01_JPRB/)
KBO( :, 2,16, 6) = (/&
&2.7655E-02_JPRB,2.7881E-02_JPRB,1.3342E-01_JPRB,2.0067E-01_JPRB,2.5537E-01_JPRB,2.7880E-01_JPRB/)
KBO( :, 3,16, 6) = (/&
&2.8404E-02_JPRB,2.8615E-02_JPRB,1.3503E-01_JPRB,2.0326E-01_JPRB,2.5856E-01_JPRB,2.8387E-01_JPRB/)
KBO( :, 4,16, 6) = (/&
&2.9270E-02_JPRB,2.9476E-02_JPRB,1.3640E-01_JPRB,2.0574E-01_JPRB,2.6105E-01_JPRB,2.8764E-01_JPRB/)
KBO( :, 5,16, 6) = (/&
&3.0417E-02_JPRB,3.0624E-02_JPRB,1.3764E-01_JPRB,2.0798E-01_JPRB,2.6293E-01_JPRB,2.9041E-01_JPRB/)
KBO( :, 1,17, 6) = (/&
&2.2953E-02_JPRB,2.3180E-02_JPRB,1.1845E-01_JPRB,1.7721E-01_JPRB,2.2460E-01_JPRB,2.4224E-01_JPRB/)
KBO( :, 2,17, 6) = (/&
&2.3559E-02_JPRB,2.3784E-02_JPRB,1.2023E-01_JPRB,1.8031E-01_JPRB,2.2852E-01_JPRB,2.4805E-01_JPRB/)
KBO( :, 3,17, 6) = (/&
&2.4252E-02_JPRB,2.4462E-02_JPRB,1.2174E-01_JPRB,1.8322E-01_JPRB,2.3188E-01_JPRB,2.5256E-01_JPRB/)
KBO( :, 4,17, 6) = (/&
&2.5160E-02_JPRB,2.5369E-02_JPRB,1.2317E-01_JPRB,1.8595E-01_JPRB,2.3461E-01_JPRB,2.5595E-01_JPRB/)
KBO( :, 5,17, 6) = (/&
&2.6326E-02_JPRB,2.6536E-02_JPRB,1.2445E-01_JPRB,1.8813E-01_JPRB,2.3684E-01_JPRB,2.5843E-01_JPRB/)
KBO( :, 1,18, 6) = (/&
&1.9482E-02_JPRB,1.9716E-02_JPRB,1.0560E-01_JPRB,1.5764E-01_JPRB,1.9885E-01_JPRB,2.1333E-01_JPRB/)
KBO( :, 2,18, 6) = (/&
&2.0020E-02_JPRB,2.0247E-02_JPRB,1.0728E-01_JPRB,1.6080E-01_JPRB,2.0278E-01_JPRB,2.1852E-01_JPRB/)
KBO( :, 3,18, 6) = (/&
&2.0718E-02_JPRB,2.0933E-02_JPRB,1.0881E-01_JPRB,1.6380E-01_JPRB,2.0619E-01_JPRB,2.2252E-01_JPRB/)
KBO( :, 4,18, 6) = (/&
&2.1659E-02_JPRB,2.1872E-02_JPRB,1.1021E-01_JPRB,1.6633E-01_JPRB,2.0912E-01_JPRB,2.2570E-01_JPRB/)
KBO( :, 5,18, 6) = (/&
&2.2723E-02_JPRB,2.2936E-02_JPRB,1.1153E-01_JPRB,1.6848E-01_JPRB,2.1149E-01_JPRB,2.2818E-01_JPRB/)
KBO( :, 1,19, 6) = (/&
&1.6474E-02_JPRB,1.6726E-02_JPRB,9.3278E-02_JPRB,1.3911E-01_JPRB,1.7470E-01_JPRB,1.8607E-01_JPRB/)
KBO( :, 2,19, 6) = (/&
&1.6988E-02_JPRB,1.7224E-02_JPRB,9.4914E-02_JPRB,1.4229E-01_JPRB,1.7855E-01_JPRB,1.9060E-01_JPRB/)
KBO( :, 3,19, 6) = (/&
&1.7719E-02_JPRB,1.7943E-02_JPRB,9.6402E-02_JPRB,1.4506E-01_JPRB,1.8201E-01_JPRB,1.9424E-01_JPRB/)
KBO( :, 4,19, 6) = (/&
&1.8600E-02_JPRB,1.8821E-02_JPRB,9.7809E-02_JPRB,1.4747E-01_JPRB,1.8495E-01_JPRB,1.9716E-01_JPRB/)
KBO( :, 5,19, 6) = (/&
&1.9511E-02_JPRB,1.9731E-02_JPRB,9.9198E-02_JPRB,1.4957E-01_JPRB,1.8726E-01_JPRB,1.9887E-01_JPRB/)
KBO( :, 1,20, 6) = (/&
&1.3891E-02_JPRB,1.4173E-02_JPRB,8.1755E-02_JPRB,1.2196E-01_JPRB,1.5249E-01_JPRB,1.6109E-01_JPRB/)
KBO( :, 2,20, 6) = (/&
&1.4432E-02_JPRB,1.4692E-02_JPRB,8.3314E-02_JPRB,1.2486E-01_JPRB,1.5622E-01_JPRB,1.6508E-01_JPRB/)
KBO( :, 3,20, 6) = (/&
&1.5139E-02_JPRB,1.5385E-02_JPRB,8.4783E-02_JPRB,1.2741E-01_JPRB,1.5952E-01_JPRB,1.6830E-01_JPRB/)
KBO( :, 4,20, 6) = (/&
&1.5913E-02_JPRB,1.6152E-02_JPRB,8.6223E-02_JPRB,1.2966E-01_JPRB,1.6214E-01_JPRB,1.7014E-01_JPRB/)
KBO( :, 5,20, 6) = (/&
&1.6685E-02_JPRB,1.6917E-02_JPRB,8.7642E-02_JPRB,1.3138E-01_JPRB,1.6356E-01_JPRB,1.7014E-01_JPRB/)
KBO( :, 1,21, 6) = (/&
&1.1702E-02_JPRB,1.2032E-02_JPRB,7.1105E-02_JPRB,1.0613E-01_JPRB,1.3235E-01_JPRB,1.3851E-01_JPRB/)
KBO( :, 2,21, 6) = (/&
&1.2249E-02_JPRB,1.2553E-02_JPRB,7.2595E-02_JPRB,1.0875E-01_JPRB,1.3581E-01_JPRB,1.4193E-01_JPRB/)
KBO( :, 3,21, 6) = (/&
&1.2879E-02_JPRB,1.3168E-02_JPRB,7.4032E-02_JPRB,1.1102E-01_JPRB,1.3861E-01_JPRB,1.4396E-01_JPRB/)
KBO( :, 4,21, 6) = (/&
&1.3537E-02_JPRB,1.3810E-02_JPRB,7.5416E-02_JPRB,1.1273E-01_JPRB,1.4012E-01_JPRB,1.4419E-01_JPRB/)
KBO( :, 5,21, 6) = (/&
&1.4190E-02_JPRB,1.4451E-02_JPRB,7.6688E-02_JPRB,1.1355E-01_JPRB,1.4025E-01_JPRB,1.4302E-01_JPRB/)
KBO( :, 1,22, 6) = (/&
&9.9001E-03_JPRB,1.0285E-02_JPRB,6.1552E-02_JPRB,9.1903E-02_JPRB,1.1446E-01_JPRB,1.1850E-01_JPRB/)
KBO( :, 2,22, 6) = (/&
&1.0402E-02_JPRB,1.0764E-02_JPRB,6.2928E-02_JPRB,9.4123E-02_JPRB,1.1729E-01_JPRB,1.2066E-01_JPRB/)
KBO( :, 3,22, 6) = (/&
&1.0945E-02_JPRB,1.1287E-02_JPRB,6.4219E-02_JPRB,9.5745E-02_JPRB,1.1884E-01_JPRB,1.2116E-01_JPRB/)
KBO( :, 4,22, 6) = (/&
&1.1502E-02_JPRB,1.1824E-02_JPRB,6.5352E-02_JPRB,9.6543E-02_JPRB,1.1912E-01_JPRB,1.2043E-01_JPRB/)
KBO( :, 5,22, 6) = (/&
&1.2057E-02_JPRB,1.2365E-02_JPRB,6.6306E-02_JPRB,9.6694E-02_JPRB,1.1850E-01_JPRB,1.1887E-01_JPRB/)
KBO( :, 1,23, 6) = (/&
&8.3712E-03_JPRB,8.8014E-03_JPRB,5.2987E-02_JPRB,7.9036E-02_JPRB,9.8229E-02_JPRB,1.0022E-01_JPRB/)
KBO( :, 2,23, 6) = (/&
&8.8086E-03_JPRB,9.2239E-03_JPRB,5.4159E-02_JPRB,8.0566E-02_JPRB,9.9889E-02_JPRB,1.0104E-01_JPRB/)
KBO( :, 3,23, 6) = (/&
&9.2697E-03_JPRB,9.6659E-03_JPRB,5.5152E-02_JPRB,8.1379E-02_JPRB,1.0039E-01_JPRB,1.0074E-01_JPRB/)
KBO( :, 4,23, 6) = (/&
&9.7327E-03_JPRB,1.0110E-02_JPRB,5.5972E-02_JPRB,8.1635E-02_JPRB,1.0009E-01_JPRB,9.9702E-02_JPRB/)
KBO( :, 5,23, 6) = (/&
&1.0213E-02_JPRB,1.0575E-02_JPRB,5.6627E-02_JPRB,8.1638E-02_JPRB,9.9238E-02_JPRB,9.8092E-02_JPRB/)
KBO( :, 1,24, 6) = (/&
&7.0727E-03_JPRB,7.5361E-03_JPRB,4.5321E-02_JPRB,6.7260E-02_JPRB,8.3279E-02_JPRB,8.3647E-02_JPRB/)
KBO( :, 2,24, 6) = (/&
&7.4427E-03_JPRB,7.8986E-03_JPRB,4.6188E-02_JPRB,6.8096E-02_JPRB,8.4019E-02_JPRB,8.3747E-02_JPRB/)
KBO( :, 3,24, 6) = (/&
&7.8269E-03_JPRB,8.2674E-03_JPRB,4.6892E-02_JPRB,6.8450E-02_JPRB,8.4013E-02_JPRB,8.3148E-02_JPRB/)
KBO( :, 4,24, 6) = (/&
&8.2189E-03_JPRB,8.6445E-03_JPRB,4.7510E-02_JPRB,6.8583E-02_JPRB,8.3512E-02_JPRB,8.2039E-02_JPRB/)
KBO( :, 5,24, 6) = (/&
&8.6506E-03_JPRB,9.0639E-03_JPRB,4.7979E-02_JPRB,6.8589E-02_JPRB,8.2686E-02_JPRB,8.0530E-02_JPRB/)
KBO( :, 1,25, 6) = (/&
&5.9648E-03_JPRB,6.4506E-03_JPRB,3.8407E-02_JPRB,5.6605E-02_JPRB,6.9840E-02_JPRB,6.9218E-02_JPRB/)
KBO( :, 2,25, 6) = (/&
&6.2753E-03_JPRB,6.7567E-03_JPRB,3.9061E-02_JPRB,5.7057E-02_JPRB,7.0098E-02_JPRB,6.9005E-02_JPRB/)
KBO( :, 3,25, 6) = (/&
&6.5979E-03_JPRB,7.0692E-03_JPRB,3.9618E-02_JPRB,5.7283E-02_JPRB,6.9890E-02_JPRB,6.8312E-02_JPRB/)
KBO( :, 4,25, 6) = (/&
&6.9472E-03_JPRB,7.4089E-03_JPRB,4.0072E-02_JPRB,5.7410E-02_JPRB,6.9371E-02_JPRB,6.7241E-02_JPRB/)
KBO( :, 5,25, 6) = (/&
&7.3458E-03_JPRB,7.7968E-03_JPRB,4.0424E-02_JPRB,5.7407E-02_JPRB,6.8690E-02_JPRB,6.5883E-02_JPRB/)
KBO( :, 1,26, 6) = (/&
&5.0276E-03_JPRB,5.5197E-03_JPRB,3.2341E-02_JPRB,4.7306E-02_JPRB,5.8159E-02_JPRB,5.6987E-02_JPRB/)
KBO( :, 2,26, 6) = (/&
&5.2905E-03_JPRB,5.7808E-03_JPRB,3.2856E-02_JPRB,4.7610E-02_JPRB,5.8188E-02_JPRB,5.6640E-02_JPRB/)
KBO( :, 3,26, 6) = (/&
&5.5724E-03_JPRB,6.0595E-03_JPRB,3.3306E-02_JPRB,4.7831E-02_JPRB,5.7928E-02_JPRB,5.5939E-02_JPRB/)
KBO( :, 4,26, 6) = (/&
&5.8946E-03_JPRB,6.3770E-03_JPRB,3.3653E-02_JPRB,4.7935E-02_JPRB,5.7502E-02_JPRB,5.4956E-02_JPRB/)
KBO( :, 5,26, 6) = (/&
&6.2574E-03_JPRB,6.7355E-03_JPRB,3.3928E-02_JPRB,4.7887E-02_JPRB,5.6970E-02_JPRB,5.3762E-02_JPRB/)
KBO( :, 1,27, 6) = (/&
&4.2349E-03_JPRB,4.7179E-03_JPRB,2.7116E-02_JPRB,3.9401E-02_JPRB,4.8220E-02_JPRB,4.6782E-02_JPRB/)
KBO( :, 2,27, 6) = (/&
&4.4634E-03_JPRB,4.9470E-03_JPRB,2.7543E-02_JPRB,3.9674E-02_JPRB,4.8162E-02_JPRB,4.6385E-02_JPRB/)
KBO( :, 3,27, 6) = (/&
&4.7202E-03_JPRB,5.2071E-03_JPRB,2.7886E-02_JPRB,3.9869E-02_JPRB,4.7941E-02_JPRB,4.5722E-02_JPRB/)
KBO( :, 4,27, 6) = (/&
&5.0160E-03_JPRB,5.5039E-03_JPRB,2.8167E-02_JPRB,3.9934E-02_JPRB,4.7615E-02_JPRB,4.4846E-02_JPRB/)
KBO( :, 5,27, 6) = (/&
&5.3481E-03_JPRB,5.8380E-03_JPRB,2.8394E-02_JPRB,3.9860E-02_JPRB,4.7184E-02_JPRB,4.3824E-02_JPRB/)
KBO( :, 1,28, 6) = (/&
&3.5674E-03_JPRB,4.0284E-03_JPRB,2.2673E-02_JPRB,3.2772E-02_JPRB,3.9872E-02_JPRB,3.8332E-02_JPRB/)
KBO( :, 2,28, 6) = (/&
&3.7734E-03_JPRB,4.2398E-03_JPRB,2.3008E-02_JPRB,3.3028E-02_JPRB,3.9810E-02_JPRB,3.7930E-02_JPRB/)
KBO( :, 3,28, 6) = (/&
&4.0097E-03_JPRB,4.4845E-03_JPRB,2.3286E-02_JPRB,3.3175E-02_JPRB,3.9654E-02_JPRB,3.7324E-02_JPRB/)
KBO( :, 4,28, 6) = (/&
&4.2788E-03_JPRB,4.7627E-03_JPRB,2.3514E-02_JPRB,3.3194E-02_JPRB,3.9398E-02_JPRB,3.6571E-02_JPRB/)
KBO( :, 5,28, 6) = (/&
&4.5757E-03_JPRB,5.0676E-03_JPRB,2.3719E-02_JPRB,3.3118E-02_JPRB,3.9020E-02_JPRB,3.5708E-02_JPRB/)
KBO( :, 1,29, 6) = (/&
&3.0115E-03_JPRB,3.4411E-03_JPRB,1.8911E-02_JPRB,2.7247E-02_JPRB,3.2943E-02_JPRB,3.1382E-02_JPRB/)
KBO( :, 2,29, 6) = (/&
&3.1994E-03_JPRB,3.6407E-03_JPRB,1.9179E-02_JPRB,2.7455E-02_JPRB,3.2911E-02_JPRB,3.1000E-02_JPRB/)
KBO( :, 3,29, 6) = (/&
&3.4147E-03_JPRB,3.8682E-03_JPRB,1.9409E-02_JPRB,2.7552E-02_JPRB,3.2798E-02_JPRB,3.0472E-02_JPRB/)
KBO( :, 4,29, 6) = (/&
&3.6579E-03_JPRB,4.1270E-03_JPRB,1.9605E-02_JPRB,2.7559E-02_JPRB,3.2573E-02_JPRB,2.9835E-02_JPRB/)
KBO( :, 5,29, 6) = (/&
&3.9162E-03_JPRB,4.3987E-03_JPRB,1.9809E-02_JPRB,2.7488E-02_JPRB,3.2240E-02_JPRB,2.9120E-02_JPRB/)
KBO( :, 1,30, 6) = (/&
&2.5481E-03_JPRB,2.9444E-03_JPRB,1.5745E-02_JPRB,2.2634E-02_JPRB,2.7226E-02_JPRB,2.5677E-02_JPRB/)
KBO( :, 2,30, 6) = (/&
&2.7188E-03_JPRB,3.1307E-03_JPRB,1.5966E-02_JPRB,2.2786E-02_JPRB,2.7220E-02_JPRB,2.5335E-02_JPRB/)
KBO( :, 3,30, 6) = (/&
&2.9148E-03_JPRB,3.3439E-03_JPRB,1.6160E-02_JPRB,2.2855E-02_JPRB,2.7119E-02_JPRB,2.4882E-02_JPRB/)
KBO( :, 4,30, 6) = (/&
&3.1280E-03_JPRB,3.5773E-03_JPRB,1.6348E-02_JPRB,2.2854E-02_JPRB,2.6917E-02_JPRB,2.4354E-02_JPRB/)
KBO( :, 5,30, 6) = (/&
&3.3553E-03_JPRB,3.8202E-03_JPRB,1.6558E-02_JPRB,2.2811E-02_JPRB,2.6630E-02_JPRB,2.3768E-02_JPRB/)
KBO( :, 1,31, 6) = (/&
&2.1615E-03_JPRB,2.5257E-03_JPRB,1.3098E-02_JPRB,1.8778E-02_JPRB,2.2519E-02_JPRB,2.1018E-02_JPRB/)
KBO( :, 2,31, 6) = (/&
&2.3170E-03_JPRB,2.6986E-03_JPRB,1.3284E-02_JPRB,1.8891E-02_JPRB,2.2515E-02_JPRB,2.0722E-02_JPRB/)
KBO( :, 3,31, 6) = (/&
&2.4905E-03_JPRB,2.8953E-03_JPRB,1.3459E-02_JPRB,1.8946E-02_JPRB,2.2414E-02_JPRB,2.0345E-02_JPRB/)
KBO( :, 4,31, 6) = (/&
&2.6777E-03_JPRB,3.1024E-03_JPRB,1.3649E-02_JPRB,1.8949E-02_JPRB,2.2235E-02_JPRB,1.9908E-02_JPRB/)
KBO( :, 5,31, 6) = (/&
&2.8803E-03_JPRB,3.3243E-03_JPRB,1.3860E-02_JPRB,1.8946E-02_JPRB,2.1996E-02_JPRB,1.9437E-02_JPRB/)
KBO( :, 1,32, 6) = (/&
&1.8385E-03_JPRB,2.1718E-03_JPRB,1.0896E-02_JPRB,1.5564E-02_JPRB,1.8628E-02_JPRB,1.7209E-02_JPRB/)
KBO( :, 2,32, 6) = (/&
&1.9787E-03_JPRB,2.3333E-03_JPRB,1.1058E-02_JPRB,1.5657E-02_JPRB,1.8613E-02_JPRB,1.6956E-02_JPRB/)
KBO( :, 3,32, 6) = (/&
&2.1311E-03_JPRB,2.5090E-03_JPRB,1.1225E-02_JPRB,1.5701E-02_JPRB,1.8522E-02_JPRB,1.6642E-02_JPRB/)
KBO( :, 4,32, 6) = (/&
&2.2971E-03_JPRB,2.6964E-03_JPRB,1.1416E-02_JPRB,1.5725E-02_JPRB,1.8369E-02_JPRB,1.6291E-02_JPRB/)
KBO( :, 5,32, 6) = (/&
&2.4814E-03_JPRB,2.9021E-03_JPRB,1.1629E-02_JPRB,1.5757E-02_JPRB,1.8177E-02_JPRB,1.5913E-02_JPRB/)
KBO( :, 1,33, 6) = (/&
&1.5686E-03_JPRB,1.8737E-03_JPRB,9.0681E-03_JPRB,1.2902E-02_JPRB,1.5408E-02_JPRB,1.4096E-02_JPRB/)
KBO( :, 2,33, 6) = (/&
&1.6920E-03_JPRB,2.0214E-03_JPRB,9.2168E-03_JPRB,1.2976E-02_JPRB,1.5384E-02_JPRB,1.3883E-02_JPRB/)
KBO( :, 3,33, 6) = (/&
&1.8273E-03_JPRB,2.1791E-03_JPRB,9.3843E-03_JPRB,1.3022E-02_JPRB,1.5304E-02_JPRB,1.3632E-02_JPRB/)
KBO( :, 4,33, 6) = (/&
&1.9765E-03_JPRB,2.3516E-03_JPRB,9.5730E-03_JPRB,1.3071E-02_JPRB,1.5178E-02_JPRB,1.3350E-02_JPRB/)
KBO( :, 5,33, 6) = (/&
&2.1452E-03_JPRB,2.5432E-03_JPRB,9.7830E-03_JPRB,1.3131E-02_JPRB,1.5037E-02_JPRB,1.3045E-02_JPRB/)
KBO( :, 1,34, 6) = (/&
&1.3372E-03_JPRB,1.6178E-03_JPRB,7.5519E-03_JPRB,1.0693E-02_JPRB,1.2740E-02_JPRB,1.1549E-02_JPRB/)
KBO( :, 2,34, 6) = (/&
&1.4461E-03_JPRB,1.7503E-03_JPRB,7.6945E-03_JPRB,1.0757E-02_JPRB,1.2715E-02_JPRB,1.1377E-02_JPRB/)
KBO( :, 3,34, 6) = (/&
&1.5660E-03_JPRB,1.8937E-03_JPRB,7.8583E-03_JPRB,1.0816E-02_JPRB,1.2648E-02_JPRB,1.1176E-02_JPRB/)
KBO( :, 4,34, 6) = (/&
&1.7014E-03_JPRB,2.0534E-03_JPRB,8.0448E-03_JPRB,1.0884E-02_JPRB,1.2559E-02_JPRB,1.0950E-02_JPRB/)
KBO( :, 5,34, 6) = (/&
&1.8558E-03_JPRB,2.2315E-03_JPRB,8.2423E-03_JPRB,1.0963E-02_JPRB,1.2464E-02_JPRB,1.0705E-02_JPRB/)
KBO( :, 1,35, 6) = (/&
&1.1329E-03_JPRB,1.3895E-03_JPRB,6.2880E-03_JPRB,8.8610E-03_JPRB,1.0532E-02_JPRB,9.4809E-03_JPRB/)
KBO( :, 2,35, 6) = (/&
&1.2284E-03_JPRB,1.5079E-03_JPRB,6.4262E-03_JPRB,8.9261E-03_JPRB,1.0516E-02_JPRB,9.3462E-03_JPRB/)
KBO( :, 3,35, 6) = (/&
&1.3351E-03_JPRB,1.6386E-03_JPRB,6.5845E-03_JPRB,8.9958E-03_JPRB,1.0468E-02_JPRB,9.1865E-03_JPRB/)
KBO( :, 4,35, 6) = (/&
&1.4573E-03_JPRB,1.7849E-03_JPRB,6.7614E-03_JPRB,9.0760E-03_JPRB,1.0410E-02_JPRB,9.0064E-03_JPRB/)
KBO( :, 5,35, 6) = (/&
&1.5970E-03_JPRB,1.9487E-03_JPRB,6.9420E-03_JPRB,9.1662E-03_JPRB,1.0351E-02_JPRB,8.8117E-03_JPRB/)
KBO( :, 1,36, 6) = (/&
&9.5211E-04_JPRB,1.1843E-03_JPRB,5.2312E-03_JPRB,7.3412E-03_JPRB,8.7087E-03_JPRB,7.7981E-03_JPRB/)
KBO( :, 2,36, 6) = (/&
&1.0354E-03_JPRB,1.2901E-03_JPRB,5.3625E-03_JPRB,7.4088E-03_JPRB,8.7005E-03_JPRB,7.6928E-03_JPRB/)
KBO( :, 3,36, 6) = (/&
&1.1296E-03_JPRB,1.4079E-03_JPRB,5.5138E-03_JPRB,7.4862E-03_JPRB,8.6732E-03_JPRB,7.5689E-03_JPRB/)
KBO( :, 4,36, 6) = (/&
&1.2388E-03_JPRB,1.5409E-03_JPRB,5.6750E-03_JPRB,7.5726E-03_JPRB,8.6424E-03_JPRB,7.4262E-03_JPRB/)
KBO( :, 5,36, 6) = (/&
&1.3638E-03_JPRB,1.6902E-03_JPRB,5.8416E-03_JPRB,7.6677E-03_JPRB,8.6124E-03_JPRB,7.2708E-03_JPRB/)
KBO( :, 1,37, 6) = (/&
&7.9067E-04_JPRB,9.9728E-04_JPRB,4.3412E-03_JPRB,6.0781E-03_JPRB,7.2010E-03_JPRB,6.4225E-03_JPRB/)
KBO( :, 2,37, 6) = (/&
&8.6207E-04_JPRB,1.0903E-03_JPRB,4.4618E-03_JPRB,6.1477E-03_JPRB,7.2040E-03_JPRB,6.3450E-03_JPRB/)
KBO( :, 3,37, 6) = (/&
&9.4365E-04_JPRB,1.1951E-03_JPRB,4.6016E-03_JPRB,6.2259E-03_JPRB,7.1949E-03_JPRB,6.2491E-03_JPRB/)
KBO( :, 4,37, 6) = (/&
&1.0390E-03_JPRB,1.3137E-03_JPRB,4.7474E-03_JPRB,6.3134E-03_JPRB,7.1835E-03_JPRB,6.1371E-03_JPRB/)
KBO( :, 5,37, 6) = (/&
&1.1493E-03_JPRB,1.4482E-03_JPRB,4.9008E-03_JPRB,6.4092E-03_JPRB,7.1759E-03_JPRB,6.0153E-03_JPRB/)
KBO( :, 1,38, 6) = (/&
&6.5574E-04_JPRB,8.3902E-04_JPRB,3.6029E-03_JPRB,5.0338E-03_JPRB,5.9535E-03_JPRB,5.2931E-03_JPRB/)
KBO( :, 2,38, 6) = (/&
&7.1723E-04_JPRB,9.2092E-04_JPRB,3.7143E-03_JPRB,5.1033E-03_JPRB,5.9664E-03_JPRB,5.2356E-03_JPRB/)
KBO( :, 3,38, 6) = (/&
&7.8817E-04_JPRB,1.0140E-03_JPRB,3.8410E-03_JPRB,5.1788E-03_JPRB,5.9694E-03_JPRB,5.1631E-03_JPRB/)
KBO( :, 4,38, 6) = (/&
&8.7142E-04_JPRB,1.1199E-03_JPRB,3.9722E-03_JPRB,5.2685E-03_JPRB,5.9738E-03_JPRB,5.0758E-03_JPRB/)
KBO( :, 5,38, 6) = (/&
&9.6814E-04_JPRB,1.2406E-03_JPRB,4.1130E-03_JPRB,5.3594E-03_JPRB,5.9796E-03_JPRB,4.9809E-03_JPRB/)
KBO( :, 1,39, 6) = (/&
&5.4394E-04_JPRB,7.0587E-04_JPRB,2.9920E-03_JPRB,4.1712E-03_JPRB,4.9241E-03_JPRB,4.3648E-03_JPRB/)
KBO( :, 2,39, 6) = (/&
&5.9679E-04_JPRB,7.7794E-04_JPRB,3.0938E-03_JPRB,4.2387E-03_JPRB,4.9429E-03_JPRB,4.3244E-03_JPRB/)
KBO( :, 3,39, 6) = (/&
&6.5862E-04_JPRB,8.6057E-04_JPRB,3.2080E-03_JPRB,4.3149E-03_JPRB,4.9560E-03_JPRB,4.2705E-03_JPRB/)
KBO( :, 4,39, 6) = (/&
&7.3136E-04_JPRB,9.5521E-04_JPRB,3.3261E-03_JPRB,4.3998E-03_JPRB,4.9704E-03_JPRB,4.2037E-03_JPRB/)
KBO( :, 5,39, 6) = (/&
&8.1646E-04_JPRB,1.0637E-03_JPRB,3.4565E-03_JPRB,4.4868E-03_JPRB,4.9875E-03_JPRB,4.1313E-03_JPRB/)
KBO( :, 1,40, 6) = (/&
&4.4679E-04_JPRB,5.8745E-04_JPRB,2.4763E-03_JPRB,3.4505E-03_JPRB,4.0708E-03_JPRB,3.5945E-03_JPRB/)
KBO( :, 2,40, 6) = (/&
&4.9169E-04_JPRB,6.5005E-04_JPRB,2.5677E-03_JPRB,3.5152E-03_JPRB,4.0943E-03_JPRB,3.5667E-03_JPRB/)
KBO( :, 3,40, 6) = (/&
&5.4450E-04_JPRB,7.2222E-04_JPRB,2.6693E-03_JPRB,3.5873E-03_JPRB,4.1135E-03_JPRB,3.5266E-03_JPRB/)
KBO( :, 4,40, 6) = (/&
&6.0712E-04_JPRB,8.0578E-04_JPRB,2.7753E-03_JPRB,3.6696E-03_JPRB,4.1353E-03_JPRB,3.4759E-03_JPRB/)
KBO( :, 5,40, 6) = (/&
&6.8061E-04_JPRB,9.0198E-04_JPRB,2.8937E-03_JPRB,3.7510E-03_JPRB,4.1595E-03_JPRB,3.4202E-03_JPRB/)
KBO( :, 1,41, 6) = (/&
&3.6654E-04_JPRB,4.8763E-04_JPRB,2.0497E-03_JPRB,2.8544E-03_JPRB,3.3652E-03_JPRB,2.9593E-03_JPRB/)
KBO( :, 2,41, 6) = (/&
&4.0436E-04_JPRB,5.4168E-04_JPRB,2.1297E-03_JPRB,2.9143E-03_JPRB,3.3913E-03_JPRB,2.9409E-03_JPRB/)
KBO( :, 3,41, 6) = (/&
&4.4941E-04_JPRB,6.0442E-04_JPRB,2.2197E-03_JPRB,2.9825E-03_JPRB,3.4145E-03_JPRB,2.9122E-03_JPRB/)
KBO( :, 4,41, 6) = (/&
&5.0288E-04_JPRB,6.7766E-04_JPRB,2.3143E-03_JPRB,3.0596E-03_JPRB,3.4407E-03_JPRB,2.8738E-03_JPRB/)
KBO( :, 5,41, 6) = (/&
&5.6627E-04_JPRB,7.6296E-04_JPRB,2.4209E-03_JPRB,3.1354E-03_JPRB,3.4693E-03_JPRB,2.8312E-03_JPRB/)
KBO( :, 1,42, 6) = (/&
&3.0056E-04_JPRB,4.0423E-04_JPRB,1.6955E-03_JPRB,2.3604E-03_JPRB,2.7815E-03_JPRB,2.4359E-03_JPRB/)
KBO( :, 2,42, 6) = (/&
&3.3240E-04_JPRB,4.5078E-04_JPRB,1.7662E-03_JPRB,2.4162E-03_JPRB,2.8087E-03_JPRB,2.4250E-03_JPRB/)
KBO( :, 3,42, 6) = (/&
&3.7060E-04_JPRB,5.0501E-04_JPRB,1.8455E-03_JPRB,2.4795E-03_JPRB,2.8342E-03_JPRB,2.4047E-03_JPRB/)
KBO( :, 4,42, 6) = (/&
&4.1638E-04_JPRB,5.6912E-04_JPRB,1.9299E-03_JPRB,2.5508E-03_JPRB,2.8626E-03_JPRB,2.3765E-03_JPRB/)
KBO( :, 5,42, 6) = (/&
&4.7089E-04_JPRB,6.4463E-04_JPRB,2.0249E-03_JPRB,2.6208E-03_JPRB,2.8943E-03_JPRB,2.3447E-03_JPRB/)
KBO( :, 1,43, 6) = (/&
&2.4502E-04_JPRB,3.3261E-04_JPRB,1.3991E-03_JPRB,1.9481E-03_JPRB,2.2961E-03_JPRB,2.0045E-03_JPRB/)
KBO( :, 2,43, 6) = (/&
&2.7152E-04_JPRB,3.7212E-04_JPRB,1.4606E-03_JPRB,1.9988E-03_JPRB,2.3241E-03_JPRB,1.9999E-03_JPRB/)
KBO( :, 3,43, 6) = (/&
&3.0343E-04_JPRB,4.1851E-04_JPRB,1.5301E-03_JPRB,2.0581E-03_JPRB,2.3515E-03_JPRB,1.9867E-03_JPRB/)
KBO( :, 4,43, 6) = (/&
&3.4217E-04_JPRB,4.7384E-04_JPRB,1.6047E-03_JPRB,2.1225E-03_JPRB,2.3804E-03_JPRB,1.9662E-03_JPRB/)
KBO( :, 5,43, 6) = (/&
&3.8865E-04_JPRB,5.3980E-04_JPRB,1.6888E-03_JPRB,2.1871E-03_JPRB,2.4134E-03_JPRB,1.9423E-03_JPRB/)
KBO( :, 1,44, 6) = (/&
&1.9915E-04_JPRB,2.7249E-04_JPRB,1.1527E-03_JPRB,1.6068E-03_JPRB,1.8949E-03_JPRB,1.6492E-03_JPRB/)
KBO( :, 2,44, 6) = (/&
&2.2104E-04_JPRB,3.0586E-04_JPRB,1.2059E-03_JPRB,1.6524E-03_JPRB,1.9220E-03_JPRB,1.6487E-03_JPRB/)
KBO( :, 3,44, 6) = (/&
&2.4764E-04_JPRB,3.4529E-04_JPRB,1.2668E-03_JPRB,1.7051E-03_JPRB,1.9490E-03_JPRB,1.6410E-03_JPRB/)
KBO( :, 4,44, 6) = (/&
&2.8005E-04_JPRB,3.9253E-04_JPRB,1.3322E-03_JPRB,1.7635E-03_JPRB,1.9786E-03_JPRB,1.6274E-03_JPRB/)
KBO( :, 5,44, 6) = (/&
&3.1937E-04_JPRB,4.4948E-04_JPRB,1.4058E-03_JPRB,1.8224E-03_JPRB,2.0114E-03_JPRB,1.6103E-03_JPRB/)
KBO( :, 1,45, 6) = (/&
&1.6169E-04_JPRB,2.2287E-04_JPRB,9.4886E-04_JPRB,1.3244E-03_JPRB,1.5624E-03_JPRB,1.3564E-03_JPRB/)
KBO( :, 2,45, 6) = (/&
&1.7988E-04_JPRB,2.5107E-04_JPRB,9.9462E-04_JPRB,1.3650E-03_JPRB,1.5885E-03_JPRB,1.3595E-03_JPRB/)
KBO( :, 3,45, 6) = (/&
&2.0188E-04_JPRB,2.8430E-04_JPRB,1.0481E-03_JPRB,1.4121E-03_JPRB,1.6151E-03_JPRB,1.3561E-03_JPRB/)
KBO( :, 4,45, 6) = (/&
&2.2901E-04_JPRB,3.2458E-04_JPRB,1.1056E-03_JPRB,1.4643E-03_JPRB,1.6434E-03_JPRB,1.3471E-03_JPRB/)
KBO( :, 5,45, 6) = (/&
&2.6215E-04_JPRB,3.7359E-04_JPRB,1.1700E-03_JPRB,1.5178E-03_JPRB,1.6750E-03_JPRB,1.3351E-03_JPRB/)
KBO( :, 1,46, 6) = (/&
&1.3087E-04_JPRB,1.8153E-04_JPRB,7.8014E-04_JPRB,1.0903E-03_JPRB,1.2862E-03_JPRB,1.1149E-03_JPRB/)
KBO( :, 2,46, 6) = (/&
&1.4588E-04_JPRB,2.0523E-04_JPRB,8.1887E-04_JPRB,1.1260E-03_JPRB,1.3113E-03_JPRB,1.1201E-03_JPRB/)
KBO( :, 3,46, 6) = (/&
&1.6401E-04_JPRB,2.3309E-04_JPRB,8.6531E-04_JPRB,1.1670E-03_JPRB,1.3362E-03_JPRB,1.1199E-03_JPRB/)
KBO( :, 4,46, 6) = (/&
&1.8657E-04_JPRB,2.6716E-04_JPRB,9.1576E-04_JPRB,1.2141E-03_JPRB,1.3636E-03_JPRB,1.1150E-03_JPRB/)
KBO( :, 5,46, 6) = (/&
&2.1433E-04_JPRB,3.0901E-04_JPRB,9.7156E-04_JPRB,1.2621E-03_JPRB,1.3940E-03_JPRB,1.1075E-03_JPRB/)
KBO( :, 1,47, 6) = (/&
&1.0532E-04_JPRB,1.4678E-04_JPRB,6.3931E-04_JPRB,8.9566E-04_JPRB,1.0570E-03_JPRB,9.1457E-04_JPRB/)
KBO( :, 2,47, 6) = (/&
&1.1765E-04_JPRB,1.6658E-04_JPRB,6.7225E-04_JPRB,9.2702E-04_JPRB,1.0808E-03_JPRB,9.2153E-04_JPRB/)
KBO( :, 3,47, 6) = (/&
&1.3241E-04_JPRB,1.8980E-04_JPRB,7.1202E-04_JPRB,9.6250E-04_JPRB,1.1041E-03_JPRB,9.2404E-04_JPRB/)
KBO( :, 4,47, 6) = (/&
&1.5090E-04_JPRB,2.1814E-04_JPRB,7.5592E-04_JPRB,1.0038E-03_JPRB,1.1296E-03_JPRB,9.2224E-04_JPRB/)
KBO( :, 5,47, 6) = (/&
&1.7385E-04_JPRB,2.5344E-04_JPRB,8.0420E-04_JPRB,1.0471E-03_JPRB,1.1580E-03_JPRB,9.1765E-04_JPRB/)
KBO( :, 1,48, 6) = (/&
&8.4617E-05_JPRB,1.1838E-04_JPRB,5.2334E-04_JPRB,7.3546E-04_JPRB,8.6835E-04_JPRB,7.5017E-04_JPRB/)
KBO( :, 2,48, 6) = (/&
&9.4785E-05_JPRB,1.3495E-04_JPRB,5.5091E-04_JPRB,7.6251E-04_JPRB,8.9031E-04_JPRB,7.5816E-04_JPRB/)
KBO( :, 3,48, 6) = (/&
&1.0679E-04_JPRB,1.5426E-04_JPRB,5.8488E-04_JPRB,7.9332E-04_JPRB,9.1168E-04_JPRB,7.6245E-04_JPRB/)
KBO( :, 4,48, 6) = (/&
&1.2188E-04_JPRB,1.7784E-04_JPRB,6.2314E-04_JPRB,8.2922E-04_JPRB,9.3479E-04_JPRB,7.6276E-04_JPRB/)
KBO( :, 5,48, 6) = (/&
&1.4083E-04_JPRB,2.0741E-04_JPRB,6.6491E-04_JPRB,8.6778E-04_JPRB,9.6073E-04_JPRB,7.6049E-04_JPRB/)
KBO( :, 1,49, 6) = (/&
&6.7867E-05_JPRB,9.5270E-05_JPRB,4.2786E-04_JPRB,6.0311E-04_JPRB,7.1217E-04_JPRB,6.1511E-04_JPRB/)
KBO( :, 2,49, 6) = (/&
&7.6245E-05_JPRB,1.0908E-04_JPRB,4.5097E-04_JPRB,6.2662E-04_JPRB,7.3243E-04_JPRB,6.2369E-04_JPRB/)
KBO( :, 3,49, 6) = (/&
&8.6029E-05_JPRB,1.2515E-04_JPRB,4.7966E-04_JPRB,6.5287E-04_JPRB,7.5158E-04_JPRB,6.2923E-04_JPRB/)
KBO( :, 4,49, 6) = (/&
&9.8304E-05_JPRB,1.4466E-04_JPRB,5.1259E-04_JPRB,6.8383E-04_JPRB,7.7254E-04_JPRB,6.3132E-04_JPRB/)
KBO( :, 5,49, 6) = (/&
&1.1386E-04_JPRB,1.6934E-04_JPRB,5.4863E-04_JPRB,7.1799E-04_JPRB,7.9596E-04_JPRB,6.3100E-04_JPRB/)
KBO( :, 1,50, 6) = (/&
&5.4470E-05_JPRB,7.6746E-05_JPRB,3.4976E-04_JPRB,4.9428E-04_JPRB,5.8397E-04_JPRB,5.0306E-04_JPRB/)
KBO( :, 2,50, 6) = (/&
&6.1410E-05_JPRB,8.8237E-05_JPRB,3.6915E-04_JPRB,5.1456E-04_JPRB,6.0217E-04_JPRB,5.1154E-04_JPRB/)
KBO( :, 3,50, 6) = (/&
&6.9439E-05_JPRB,1.0166E-04_JPRB,3.9314E-04_JPRB,5.3721E-04_JPRB,6.1939E-04_JPRB,5.1755E-04_JPRB/)
KBO( :, 4,50, 6) = (/&
&7.9454E-05_JPRB,1.1792E-04_JPRB,4.2160E-04_JPRB,5.6412E-04_JPRB,6.3835E-04_JPRB,5.2074E-04_JPRB/)
KBO( :, 5,50, 6) = (/&
&9.2275E-05_JPRB,1.3855E-04_JPRB,4.5301E-04_JPRB,5.9448E-04_JPRB,6.5950E-04_JPRB,5.2175E-04_JPRB/)
KBO( :, 1,51, 6) = (/&
&4.3722E-05_JPRB,6.1806E-05_JPRB,2.8578E-04_JPRB,4.0468E-04_JPRB,4.7855E-04_JPRB,4.1074E-04_JPRB/)
KBO( :, 2,51, 6) = (/&
&4.9457E-05_JPRB,7.1342E-05_JPRB,3.0211E-04_JPRB,4.2230E-04_JPRB,4.9488E-04_JPRB,4.1886E-04_JPRB/)
KBO( :, 3,51, 6) = (/&
&5.6064E-05_JPRB,8.2554E-05_JPRB,3.2225E-04_JPRB,4.4204E-04_JPRB,5.1049E-04_JPRB,4.2506E-04_JPRB/)
KBO( :, 4,51, 6) = (/&
&6.4238E-05_JPRB,9.6120E-05_JPRB,3.4672E-04_JPRB,4.6528E-04_JPRB,5.2743E-04_JPRB,4.2888E-04_JPRB/)
KBO( :, 5,51, 6) = (/&
&7.4796E-05_JPRB,1.1334E-04_JPRB,3.7378E-04_JPRB,4.9196E-04_JPRB,5.4618E-04_JPRB,4.3057E-04_JPRB/)
KBO( :, 1,52, 6) = (/&
&3.5070E-05_JPRB,4.9691E-05_JPRB,2.3330E-04_JPRB,3.3093E-04_JPRB,3.9172E-04_JPRB,3.3527E-04_JPRB/)
KBO( :, 2,52, 6) = (/&
&3.9769E-05_JPRB,5.7541E-05_JPRB,2.4706E-04_JPRB,3.4637E-04_JPRB,4.0670E-04_JPRB,3.4297E-04_JPRB/)
KBO( :, 3,52, 6) = (/&
&4.5223E-05_JPRB,6.6916E-05_JPRB,2.6381E-04_JPRB,3.6327E-04_JPRB,4.2045E-04_JPRB,3.4912E-04_JPRB/)
KBO( :, 4,52, 6) = (/&
&5.1871E-05_JPRB,7.8200E-05_JPRB,2.8472E-04_JPRB,3.8310E-04_JPRB,4.3533E-04_JPRB,3.5324E-04_JPRB/)
KBO( :, 5,52, 6) = (/&
&6.0522E-05_JPRB,9.2554E-05_JPRB,3.0796E-04_JPRB,4.0644E-04_JPRB,4.5190E-04_JPRB,3.5548E-04_JPRB/)
KBO( :, 1,53, 6) = (/&
&2.8114E-05_JPRB,3.9895E-05_JPRB,1.9033E-04_JPRB,2.7035E-04_JPRB,3.2027E-04_JPRB,2.7374E-04_JPRB/)
KBO( :, 2,53, 6) = (/&
&3.1912E-05_JPRB,4.6272E-05_JPRB,2.0180E-04_JPRB,2.8364E-04_JPRB,3.3368E-04_JPRB,2.8088E-04_JPRB/)
KBO( :, 3,53, 6) = (/&
&3.6415E-05_JPRB,5.4088E-05_JPRB,2.1570E-04_JPRB,2.9812E-04_JPRB,3.4609E-04_JPRB,2.8682E-04_JPRB/)
KBO( :, 4,53, 6) = (/&
&4.1826E-05_JPRB,6.3486E-05_JPRB,2.3334E-04_JPRB,3.1498E-04_JPRB,3.5898E-04_JPRB,2.9120E-04_JPRB/)
KBO( :, 5,53, 6) = (/&
&4.8885E-05_JPRB,7.5408E-05_JPRB,2.5337E-04_JPRB,3.3531E-04_JPRB,3.7352E-04_JPRB,2.9386E-04_JPRB/)
KBO( :, 1,54, 6) = (/&
&2.2610E-05_JPRB,3.2120E-05_JPRB,1.5540E-04_JPRB,2.2090E-04_JPRB,2.6189E-04_JPRB,2.2252E-04_JPRB/)
KBO( :, 2,54, 6) = (/&
&2.5670E-05_JPRB,3.7304E-05_JPRB,1.6500E-04_JPRB,2.3234E-04_JPRB,2.7383E-04_JPRB,2.2881E-04_JPRB/)
KBO( :, 3,54, 6) = (/&
&2.9398E-05_JPRB,4.3828E-05_JPRB,1.7662E-04_JPRB,2.4475E-04_JPRB,2.8488E-04_JPRB,2.3410E-04_JPRB/)
KBO( :, 4,54, 6) = (/&
&3.3830E-05_JPRB,5.1689E-05_JPRB,1.9147E-04_JPRB,2.5918E-04_JPRB,2.9621E-04_JPRB,2.3818E-04_JPRB/)
KBO( :, 5,54, 6) = (/&
&3.9626E-05_JPRB,6.1637E-05_JPRB,2.0865E-04_JPRB,2.7674E-04_JPRB,3.0891E-04_JPRB,2.4078E-04_JPRB/)
KBO( :, 1,55, 6) = (/&
&1.8209E-05_JPRB,2.5880E-05_JPRB,1.2688E-04_JPRB,1.8045E-04_JPRB,2.1398E-04_JPRB,1.8038E-04_JPRB/)
KBO( :, 2,55, 6) = (/&
&2.0657E-05_JPRB,3.0086E-05_JPRB,1.3493E-04_JPRB,1.9025E-04_JPRB,2.2450E-04_JPRB,1.8582E-04_JPRB/)
KBO( :, 3,55, 6) = (/&
&2.3739E-05_JPRB,3.5514E-05_JPRB,1.4460E-04_JPRB,2.0081E-04_JPRB,2.3430E-04_JPRB,1.9033E-04_JPRB/)
KBO( :, 4,55, 6) = (/&
&2.7397E-05_JPRB,4.2088E-05_JPRB,1.5714E-04_JPRB,2.1306E-04_JPRB,2.4416E-04_JPRB,1.9386E-04_JPRB/)
KBO( :, 5,55, 6) = (/&
&3.2153E-05_JPRB,5.0387E-05_JPRB,1.7186E-04_JPRB,2.2820E-04_JPRB,2.5533E-04_JPRB,1.9627E-04_JPRB/)
KBO( :, 1,56, 6) = (/&
&1.4654E-05_JPRB,2.0836E-05_JPRB,1.0350E-04_JPRB,1.4723E-04_JPRB,1.7458E-04_JPRB,1.4613E-04_JPRB/)
KBO( :, 2,56, 6) = (/&
&1.6602E-05_JPRB,2.4224E-05_JPRB,1.1023E-04_JPRB,1.5562E-04_JPRB,1.8380E-04_JPRB,1.5087E-04_JPRB/)
KBO( :, 3,56, 6) = (/&
&1.9145E-05_JPRB,2.8713E-05_JPRB,1.1831E-04_JPRB,1.6458E-04_JPRB,1.9243E-04_JPRB,1.5466E-04_JPRB/)
KBO( :, 4,56, 6) = (/&
&2.2162E-05_JPRB,3.4205E-05_JPRB,1.2877E-04_JPRB,1.7500E-04_JPRB,2.0107E-04_JPRB,1.5776E-04_JPRB/)
KBO( :, 5,56, 6) = (/&
&2.6047E-05_JPRB,4.1114E-05_JPRB,1.4137E-04_JPRB,1.8796E-04_JPRB,2.1083E-04_JPRB,1.5994E-04_JPRB/)
KBO( :, 1,57, 6) = (/&
&1.1795E-05_JPRB,1.6760E-05_JPRB,8.4304E-05_JPRB,1.1999E-04_JPRB,1.4218E-04_JPRB,1.1830E-04_JPRB/)
KBO( :, 2,57, 6) = (/&
&1.3335E-05_JPRB,1.9476E-05_JPRB,8.9964E-05_JPRB,1.2718E-04_JPRB,1.5035E-04_JPRB,1.2244E-04_JPRB/)
KBO( :, 3,57, 6) = (/&
&1.5412E-05_JPRB,2.3150E-05_JPRB,9.6680E-05_JPRB,1.3478E-04_JPRB,1.5779E-04_JPRB,1.2566E-04_JPRB/)
KBO( :, 4,57, 6) = (/&
&1.7896E-05_JPRB,2.7728E-05_JPRB,1.0539E-04_JPRB,1.4358E-04_JPRB,1.6536E-04_JPRB,1.2835E-04_JPRB/)
KBO( :, 5,57, 6) = (/&
&2.1071E-05_JPRB,3.3474E-05_JPRB,1.1614E-04_JPRB,1.5456E-04_JPRB,1.7382E-04_JPRB,1.3028E-04_JPRB/)
KBO( :, 1,58, 6) = (/&
&9.5144E-06_JPRB,1.3504E-05_JPRB,6.8670E-05_JPRB,9.7752E-05_JPRB,1.1572E-04_JPRB,9.5731E-05_JPRB/)
KBO( :, 2,58, 6) = (/&
&1.0727E-05_JPRB,1.5682E-05_JPRB,7.3425E-05_JPRB,1.0393E-04_JPRB,1.2288E-04_JPRB,9.9268E-05_JPRB/)
KBO( :, 3,58, 6) = (/&
&1.2418E-05_JPRB,1.8676E-05_JPRB,7.9036E-05_JPRB,1.1042E-04_JPRB,1.2941E-04_JPRB,1.0205E-04_JPRB/)
KBO( :, 4,58, 6) = (/&
&1.4470E-05_JPRB,2.2492E-05_JPRB,8.6301E-05_JPRB,1.1787E-04_JPRB,1.3601E-04_JPRB,1.0431E-04_JPRB/)
KBO( :, 5,58, 6) = (/&
&1.7068E-05_JPRB,2.7290E-05_JPRB,9.5445E-05_JPRB,1.2711E-04_JPRB,1.4326E-04_JPRB,1.0599E-04_JPRB/)
KBO( :, 1,59, 6) = (/&
&7.8205E-06_JPRB,1.1144E-05_JPRB,5.6553E-05_JPRB,8.0518E-05_JPRB,9.5253E-05_JPRB,7.7758E-05_JPRB/)
KBO( :, 2,59, 6) = (/&
&8.8412E-06_JPRB,1.2994E-05_JPRB,6.0645E-05_JPRB,8.5808E-05_JPRB,1.0137E-04_JPRB,8.0565E-05_JPRB/)
KBO( :, 3,59, 6) = (/&
&1.0275E-05_JPRB,1.5556E-05_JPRB,6.5508E-05_JPRB,9.1408E-05_JPRB,1.0703E-04_JPRB,8.2767E-05_JPRB/)
KBO( :, 4,59, 6) = (/&
&1.2026E-05_JPRB,1.8861E-05_JPRB,7.1879E-05_JPRB,9.7918E-05_JPRB,1.1277E-04_JPRB,8.4443E-05_JPRB/)
KBO( :, 5,59, 6) = (/&
&1.4259E-05_JPRB,2.3051E-05_JPRB,7.9857E-05_JPRB,1.0611E-04_JPRB,1.1921E-04_JPRB,8.5697E-05_JPRB/)
KBO( :, 1,13, 7) = (/&
&9.7647E-02_JPRB,9.7855E-02_JPRB,3.0363E-01_JPRB,4.7031E-01_JPRB,5.9904E-01_JPRB,6.6640E-01_JPRB/)
KBO( :, 2,13, 7) = (/&
&1.0049E-01_JPRB,1.0069E-01_JPRB,3.0218E-01_JPRB,4.6982E-01_JPRB,6.0036E-01_JPRB,6.7308E-01_JPRB/)
KBO( :, 3,13, 7) = (/&
&1.0377E-01_JPRB,1.0396E-01_JPRB,3.0033E-01_JPRB,4.6762E-01_JPRB,5.9983E-01_JPRB,6.7883E-01_JPRB/)
KBO( :, 4,13, 7) = (/&
&1.0704E-01_JPRB,1.0722E-01_JPRB,2.9892E-01_JPRB,4.6467E-01_JPRB,5.9751E-01_JPRB,6.8204E-01_JPRB/)
KBO( :, 5,13, 7) = (/&
&1.1023E-01_JPRB,1.1040E-01_JPRB,2.9802E-01_JPRB,4.6155E-01_JPRB,5.9382E-01_JPRB,6.8342E-01_JPRB/)
KBO( :, 1,14, 7) = (/&
&8.6235E-02_JPRB,8.6450E-02_JPRB,2.9028E-01_JPRB,4.5055E-01_JPRB,5.7620E-01_JPRB,6.3435E-01_JPRB/)
KBO( :, 2,14, 7) = (/&
&8.9084E-02_JPRB,8.9292E-02_JPRB,2.8945E-01_JPRB,4.5002E-01_JPRB,5.7817E-01_JPRB,6.3980E-01_JPRB/)
KBO( :, 3,14, 7) = (/&
&9.1939E-02_JPRB,9.2133E-02_JPRB,2.8902E-01_JPRB,4.4871E-01_JPRB,5.7814E-01_JPRB,6.4427E-01_JPRB/)
KBO( :, 4,14, 7) = (/&
&9.4793E-02_JPRB,9.4979E-02_JPRB,2.8897E-01_JPRB,4.4708E-01_JPRB,5.7621E-01_JPRB,6.4667E-01_JPRB/)
KBO( :, 5,14, 7) = (/&
&9.7493E-02_JPRB,9.7668E-02_JPRB,2.8924E-01_JPRB,4.4518E-01_JPRB,5.7317E-01_JPRB,6.4671E-01_JPRB/)
KBO( :, 1,15, 7) = (/&
&7.5804E-02_JPRB,7.6029E-02_JPRB,2.7446E-01_JPRB,4.2589E-01_JPRB,5.4720E-01_JPRB,5.9726E-01_JPRB/)
KBO( :, 2,15, 7) = (/&
&7.8300E-02_JPRB,7.8517E-02_JPRB,2.7502E-01_JPRB,4.2618E-01_JPRB,5.4948E-01_JPRB,6.0171E-01_JPRB/)
KBO( :, 3,15, 7) = (/&
&8.0785E-02_JPRB,8.0989E-02_JPRB,2.7599E-01_JPRB,4.2609E-01_JPRB,5.4964E-01_JPRB,6.0469E-01_JPRB/)
KBO( :, 4,15, 7) = (/&
&8.3195E-02_JPRB,8.3388E-02_JPRB,2.7720E-01_JPRB,4.2579E-01_JPRB,5.4827E-01_JPRB,6.0587E-01_JPRB/)
KBO( :, 5,15, 7) = (/&
&8.5455E-02_JPRB,8.5636E-02_JPRB,2.7832E-01_JPRB,4.2510E-01_JPRB,5.4565E-01_JPRB,6.0534E-01_JPRB/)
KBO( :, 1,16, 7) = (/&
&6.6118E-02_JPRB,6.6355E-02_JPRB,2.5732E-01_JPRB,3.9829E-01_JPRB,5.1265E-01_JPRB,5.5527E-01_JPRB/)
KBO( :, 2,16, 7) = (/&
&6.8340E-02_JPRB,6.8565E-02_JPRB,2.5922E-01_JPRB,3.9972E-01_JPRB,5.1481E-01_JPRB,5.5901E-01_JPRB/)
KBO( :, 3,16, 7) = (/&
&7.0479E-02_JPRB,7.0691E-02_JPRB,2.6131E-01_JPRB,4.0064E-01_JPRB,5.1513E-01_JPRB,5.6129E-01_JPRB/)
KBO( :, 4,16, 7) = (/&
&7.2489E-02_JPRB,7.2689E-02_JPRB,2.6335E-01_JPRB,4.0108E-01_JPRB,5.1406E-01_JPRB,5.6253E-01_JPRB/)
KBO( :, 5,16, 7) = (/&
&7.4397E-02_JPRB,7.4586E-02_JPRB,2.6518E-01_JPRB,4.0098E-01_JPRB,5.1222E-01_JPRB,5.6243E-01_JPRB/)
KBO( :, 1,17, 7) = (/&
&5.7406E-02_JPRB,5.7650E-02_JPRB,2.3930E-01_JPRB,3.6866E-01_JPRB,4.7357E-01_JPRB,5.0878E-01_JPRB/)
KBO( :, 2,17, 7) = (/&
&5.9309E-02_JPRB,5.9537E-02_JPRB,2.4214E-01_JPRB,3.7060E-01_JPRB,4.7573E-01_JPRB,5.1192E-01_JPRB/)
KBO( :, 3,17, 7) = (/&
&6.1082E-02_JPRB,6.1301E-02_JPRB,2.4481E-01_JPRB,3.7220E-01_JPRB,4.7608E-01_JPRB,5.1457E-01_JPRB/)
KBO( :, 4,17, 7) = (/&
&6.2769E-02_JPRB,6.2976E-02_JPRB,2.4726E-01_JPRB,3.7333E-01_JPRB,4.7575E-01_JPRB,5.1639E-01_JPRB/)
KBO( :, 5,17, 7) = (/&
&6.4538E-02_JPRB,6.4738E-02_JPRB,2.4921E-01_JPRB,3.7444E-01_JPRB,4.7491E-01_JPRB,5.1718E-01_JPRB/)
KBO( :, 1,18, 7) = (/&
&4.9552E-02_JPRB,4.9801E-02_JPRB,2.2056E-01_JPRB,3.3735E-01_JPRB,4.3161E-01_JPRB,4.5988E-01_JPRB/)
KBO( :, 2,18, 7) = (/&
&5.1121E-02_JPRB,5.1359E-02_JPRB,2.2361E-01_JPRB,3.3991E-01_JPRB,4.3345E-01_JPRB,4.6346E-01_JPRB/)
KBO( :, 3,18, 7) = (/&
&5.2593E-02_JPRB,5.2821E-02_JPRB,2.2654E-01_JPRB,3.4220E-01_JPRB,4.3440E-01_JPRB,4.6667E-01_JPRB/)
KBO( :, 4,18, 7) = (/&
&5.4109E-02_JPRB,5.4323E-02_JPRB,2.2905E-01_JPRB,3.4438E-01_JPRB,4.3513E-01_JPRB,4.6905E-01_JPRB/)
KBO( :, 5,18, 7) = (/&
&5.5939E-02_JPRB,5.6145E-02_JPRB,2.3107E-01_JPRB,3.4628E-01_JPRB,4.3581E-01_JPRB,4.7075E-01_JPRB/)
KBO( :, 1,19, 7) = (/&
&4.2494E-02_JPRB,4.2746E-02_JPRB,2.0106E-01_JPRB,3.0520E-01_JPRB,3.8813E-01_JPRB,4.1087E-01_JPRB/)
KBO( :, 2,19, 7) = (/&
&4.3779E-02_JPRB,4.4022E-02_JPRB,2.0425E-01_JPRB,3.0836E-01_JPRB,3.9036E-01_JPRB,4.1494E-01_JPRB/)
KBO( :, 3,19, 7) = (/&
&4.5047E-02_JPRB,4.5279E-02_JPRB,2.0714E-01_JPRB,3.1149E-01_JPRB,3.9227E-01_JPRB,4.1866E-01_JPRB/)
KBO( :, 4,19, 7) = (/&
&4.6572E-02_JPRB,4.6791E-02_JPRB,2.0960E-01_JPRB,3.1442E-01_JPRB,3.9443E-01_JPRB,4.2162E-01_JPRB/)
KBO( :, 5,19, 7) = (/&
&4.8486E-02_JPRB,4.8693E-02_JPRB,2.1178E-01_JPRB,3.1724E-01_JPRB,3.9648E-01_JPRB,4.2406E-01_JPRB/)
KBO( :, 1,20, 7) = (/&
&3.6269E-02_JPRB,3.6528E-02_JPRB,1.8145E-01_JPRB,2.7358E-01_JPRB,3.4556E-01_JPRB,3.6362E-01_JPRB/)
KBO( :, 2,20, 7) = (/&
&3.7339E-02_JPRB,3.7589E-02_JPRB,1.8454E-01_JPRB,2.7744E-01_JPRB,3.4849E-01_JPRB,3.6815E-01_JPRB/)
KBO( :, 3,20, 7) = (/&
&3.8549E-02_JPRB,3.8787E-02_JPRB,1.8732E-01_JPRB,2.8107E-01_JPRB,3.5173E-01_JPRB,3.7214E-01_JPRB/)
KBO( :, 4,20, 7) = (/&
&4.0135E-02_JPRB,4.0360E-02_JPRB,1.8991E-01_JPRB,2.8468E-01_JPRB,3.5494E-01_JPRB,3.7578E-01_JPRB/)
KBO( :, 5,20, 7) = (/&
&4.2034E-02_JPRB,4.2244E-02_JPRB,1.9231E-01_JPRB,2.8796E-01_JPRB,3.5825E-01_JPRB,3.7920E-01_JPRB/)
KBO( :, 1,21, 7) = (/&
&3.0838E-02_JPRB,3.1110E-02_JPRB,1.6217E-01_JPRB,2.4347E-01_JPRB,3.0519E-01_JPRB,3.1909E-01_JPRB/)
KBO( :, 2,21, 7) = (/&
&3.1802E-02_JPRB,3.2063E-02_JPRB,1.6515E-01_JPRB,2.4761E-01_JPRB,3.0911E-01_JPRB,3.2385E-01_JPRB/)
KBO( :, 3,21, 7) = (/&
&3.3062E-02_JPRB,3.3309E-02_JPRB,1.6796E-01_JPRB,2.5173E-01_JPRB,3.1324E-01_JPRB,3.2836E-01_JPRB/)
KBO( :, 4,21, 7) = (/&
&3.4629E-02_JPRB,3.4862E-02_JPRB,1.7066E-01_JPRB,2.5561E-01_JPRB,3.1762E-01_JPRB,3.3243E-01_JPRB/)
KBO( :, 5,21, 7) = (/&
&3.6342E-02_JPRB,3.6556E-02_JPRB,1.7331E-01_JPRB,2.5945E-01_JPRB,3.2161E-01_JPRB,3.3536E-01_JPRB/)
KBO( :, 1,22, 7) = (/&
&2.6185E-02_JPRB,2.6480E-02_JPRB,1.4390E-01_JPRB,2.1535E-01_JPRB,2.6825E-01_JPRB,2.7831E-01_JPRB/)
KBO( :, 2,22, 7) = (/&
&2.7170E-02_JPRB,2.7445E-02_JPRB,1.4681E-01_JPRB,2.1972E-01_JPRB,2.7298E-01_JPRB,2.8332E-01_JPRB/)
KBO( :, 3,22, 7) = (/&
&2.8461E-02_JPRB,2.8721E-02_JPRB,1.4967E-01_JPRB,2.2403E-01_JPRB,2.7800E-01_JPRB,2.8771E-01_JPRB/)
KBO( :, 4,22, 7) = (/&
&2.9895E-02_JPRB,3.0136E-02_JPRB,1.5252E-01_JPRB,2.2826E-01_JPRB,2.8245E-01_JPRB,2.9094E-01_JPRB/)
KBO( :, 5,22, 7) = (/&
&3.1389E-02_JPRB,3.1609E-02_JPRB,1.5546E-01_JPRB,2.3192E-01_JPRB,2.8576E-01_JPRB,2.9204E-01_JPRB/)
KBO( :, 1,23, 7) = (/&
&2.2242E-02_JPRB,2.2585E-02_JPRB,1.2678E-01_JPRB,1.8942E-01_JPRB,2.3494E-01_JPRB,2.4143E-01_JPRB/)
KBO( :, 2,23, 7) = (/&
&2.3269E-02_JPRB,2.3584E-02_JPRB,1.2966E-01_JPRB,1.9392E-01_JPRB,2.4012E-01_JPRB,2.4601E-01_JPRB/)
KBO( :, 3,23, 7) = (/&
&2.4462E-02_JPRB,2.4752E-02_JPRB,1.3262E-01_JPRB,1.9826E-01_JPRB,2.4479E-01_JPRB,2.4932E-01_JPRB/)
KBO( :, 4,23, 7) = (/&
&2.5724E-02_JPRB,2.5987E-02_JPRB,1.3562E-01_JPRB,2.0194E-01_JPRB,2.4827E-01_JPRB,2.5044E-01_JPRB/)
KBO( :, 5,23, 7) = (/&
&2.7009E-02_JPRB,2.7247E-02_JPRB,1.3866E-01_JPRB,2.0472E-01_JPRB,2.4987E-01_JPRB,2.4911E-01_JPRB/)
KBO( :, 1,24, 7) = (/&
&1.8924E-02_JPRB,1.9342E-02_JPRB,1.1105E-01_JPRB,1.6590E-01_JPRB,2.0499E-01_JPRB,2.0802E-01_JPRB/)
KBO( :, 2,24, 7) = (/&
&1.9910E-02_JPRB,2.0290E-02_JPRB,1.1397E-01_JPRB,1.7018E-01_JPRB,2.0970E-01_JPRB,2.1135E-01_JPRB/)
KBO( :, 3,24, 7) = (/&
&2.0965E-02_JPRB,2.1308E-02_JPRB,1.1690E-01_JPRB,1.7382E-01_JPRB,2.1319E-01_JPRB,2.1255E-01_JPRB/)
KBO( :, 4,24, 7) = (/&
&2.2052E-02_JPRB,2.2362E-02_JPRB,1.1976E-01_JPRB,1.7647E-01_JPRB,2.1472E-01_JPRB,2.1155E-01_JPRB/)
KBO( :, 5,24, 7) = (/&
&2.3159E-02_JPRB,2.3438E-02_JPRB,1.2254E-01_JPRB,1.7790E-01_JPRB,2.1436E-01_JPRB,2.0899E-01_JPRB/)
KBO( :, 1,25, 7) = (/&
&1.6126E-02_JPRB,1.6634E-02_JPRB,9.6918E-02_JPRB,1.4450E-01_JPRB,1.7776E-01_JPRB,1.7751E-01_JPRB/)
KBO( :, 2,25, 7) = (/&
&1.7005E-02_JPRB,1.7471E-02_JPRB,9.9655E-02_JPRB,1.4804E-01_JPRB,1.8117E-01_JPRB,1.7889E-01_JPRB/)
KBO( :, 3,25, 7) = (/&
&1.7908E-02_JPRB,1.8330E-02_JPRB,1.0231E-01_JPRB,1.5056E-01_JPRB,1.8277E-01_JPRB,1.7834E-01_JPRB/)
KBO( :, 4,25, 7) = (/&
&1.8834E-02_JPRB,1.9214E-02_JPRB,1.0481E-01_JPRB,1.5188E-01_JPRB,1.8269E-01_JPRB,1.7644E-01_JPRB/)
KBO( :, 5,25, 7) = (/&
&1.9803E-02_JPRB,2.0147E-02_JPRB,1.0706E-01_JPRB,1.5241E-01_JPRB,1.8142E-01_JPRB,1.7360E-01_JPRB/)
KBO( :, 1,26, 7) = (/&
&1.3733E-02_JPRB,1.4333E-02_JPRB,8.4163E-02_JPRB,1.2491E-01_JPRB,1.5264E-01_JPRB,1.4950E-01_JPRB/)
KBO( :, 2,26, 7) = (/&
&1.4485E-02_JPRB,1.5042E-02_JPRB,8.6571E-02_JPRB,1.2729E-01_JPRB,1.5433E-01_JPRB,1.4938E-01_JPRB/)
KBO( :, 3,26, 7) = (/&
&1.5263E-02_JPRB,1.5775E-02_JPRB,8.8793E-02_JPRB,1.2861E-01_JPRB,1.5456E-01_JPRB,1.4809E-01_JPRB/)
KBO( :, 4,26, 7) = (/&
&1.6060E-02_JPRB,1.6526E-02_JPRB,9.0766E-02_JPRB,1.2922E-01_JPRB,1.5373E-01_JPRB,1.4598E-01_JPRB/)
KBO( :, 5,26, 7) = (/&
&1.6936E-02_JPRB,1.7356E-02_JPRB,9.2410E-02_JPRB,1.2957E-01_JPRB,1.5224E-01_JPRB,1.4323E-01_JPRB/)
KBO( :, 1,27, 7) = (/&
&1.1673E-02_JPRB,1.2349E-02_JPRB,7.2668E-02_JPRB,1.0678E-01_JPRB,1.2946E-01_JPRB,1.2446E-01_JPRB/)
KBO( :, 2,27, 7) = (/&
&1.2313E-02_JPRB,1.2955E-02_JPRB,7.4613E-02_JPRB,1.0813E-01_JPRB,1.2998E-01_JPRB,1.2372E-01_JPRB/)
KBO( :, 3,27, 7) = (/&
&1.2974E-02_JPRB,1.3574E-02_JPRB,7.6365E-02_JPRB,1.0885E-01_JPRB,1.2958E-01_JPRB,1.2223E-01_JPRB/)
KBO( :, 4,27, 7) = (/&
&1.3688E-02_JPRB,1.4241E-02_JPRB,7.7870E-02_JPRB,1.0934E-01_JPRB,1.2859E-01_JPRB,1.2019E-01_JPRB/)
KBO( :, 5,27, 7) = (/&
&1.4500E-02_JPRB,1.5004E-02_JPRB,7.9154E-02_JPRB,1.0968E-01_JPRB,1.2721E-01_JPRB,1.1769E-01_JPRB/)
KBO( :, 1,28, 7) = (/&
&9.9017E-03_JPRB,1.0637E-02_JPRB,6.2269E-02_JPRB,9.0336E-02_JPRB,1.0873E-01_JPRB,1.0289E-01_JPRB/)
KBO( :, 2,28, 7) = (/&
&1.0447E-02_JPRB,1.1155E-02_JPRB,6.3837E-02_JPRB,9.1161E-02_JPRB,1.0870E-01_JPRB,1.0194E-01_JPRB/)
KBO( :, 3,28, 7) = (/&
&1.1031E-02_JPRB,1.1703E-02_JPRB,6.5234E-02_JPRB,9.1757E-02_JPRB,1.0813E-01_JPRB,1.0049E-01_JPRB/)
KBO( :, 4,28, 7) = (/&
&1.1687E-02_JPRB,1.2317E-02_JPRB,6.6435E-02_JPRB,9.2244E-02_JPRB,1.0722E-01_JPRB,9.8621E-02_JPRB/)
KBO( :, 5,28, 7) = (/&
&1.2452E-02_JPRB,1.3036E-02_JPRB,6.7452E-02_JPRB,9.2541E-02_JPRB,1.0617E-01_JPRB,9.6430E-02_JPRB/)
KBO( :, 1,29, 7) = (/&
&8.3943E-03_JPRB,9.1654E-03_JPRB,5.3047E-02_JPRB,7.5941E-02_JPRB,9.0764E-02_JPRB,8.4732E-02_JPRB/)
KBO( :, 2,29, 7) = (/&
&8.8669E-03_JPRB,9.6211E-03_JPRB,5.4351E-02_JPRB,7.6615E-02_JPRB,9.0534E-02_JPRB,8.3768E-02_JPRB/)
KBO( :, 3,29, 7) = (/&
&9.3976E-03_JPRB,1.0125E-02_JPRB,5.5501E-02_JPRB,7.7201E-02_JPRB,8.9989E-02_JPRB,8.2428E-02_JPRB/)
KBO( :, 4,29, 7) = (/&
&1.0017E-02_JPRB,1.0708E-02_JPRB,5.6489E-02_JPRB,7.7643E-02_JPRB,8.9310E-02_JPRB,8.0785E-02_JPRB/)
KBO( :, 5,29, 7) = (/&
&1.0736E-02_JPRB,1.1389E-02_JPRB,5.7305E-02_JPRB,7.7877E-02_JPRB,8.8545E-02_JPRB,7.8917E-02_JPRB/)
KBO( :, 1,30, 7) = (/&
&7.1195E-03_JPRB,7.9064E-03_JPRB,4.5048E-02_JPRB,6.3701E-02_JPRB,7.5506E-02_JPRB,6.9609E-02_JPRB/)
KBO( :, 2,30, 7) = (/&
&7.5430E-03_JPRB,8.3223E-03_JPRB,4.6141E-02_JPRB,6.4336E-02_JPRB,7.5249E-02_JPRB,6.8691E-02_JPRB/)
KBO( :, 3,30, 7) = (/&
&8.0392E-03_JPRB,8.8028E-03_JPRB,4.7092E-02_JPRB,6.4887E-02_JPRB,7.4865E-02_JPRB,6.7513E-02_JPRB/)
KBO( :, 4,30, 7) = (/&
&8.6260E-03_JPRB,9.3657E-03_JPRB,4.7903E-02_JPRB,6.5263E-02_JPRB,7.4401E-02_JPRB,6.6108E-02_JPRB/)
KBO( :, 5,30, 7) = (/&
&9.2967E-03_JPRB,1.0007E-02_JPRB,4.8615E-02_JPRB,6.5447E-02_JPRB,7.3852E-02_JPRB,6.4545E-02_JPRB/)
KBO( :, 1,31, 7) = (/&
&6.0475E-03_JPRB,6.8335E-03_JPRB,3.8158E-02_JPRB,5.3421E-02_JPRB,6.2695E-02_JPRB,5.7118E-02_JPRB/)
KBO( :, 2,31, 7) = (/&
&6.4423E-03_JPRB,7.2306E-03_JPRB,3.9087E-02_JPRB,5.4038E-02_JPRB,6.2533E-02_JPRB,5.6304E-02_JPRB/)
KBO( :, 3,31, 7) = (/&
&6.9157E-03_JPRB,7.6990E-03_JPRB,3.9885E-02_JPRB,5.4507E-02_JPRB,6.2314E-02_JPRB,5.5291E-02_JPRB/)
KBO( :, 4,31, 7) = (/&
&7.4643E-03_JPRB,8.2378E-03_JPRB,4.0585E-02_JPRB,5.4818E-02_JPRB,6.2007E-02_JPRB,5.4123E-02_JPRB/)
KBO( :, 5,31, 7) = (/&
&8.0870E-03_JPRB,8.8427E-03_JPRB,4.1238E-02_JPRB,5.4956E-02_JPRB,6.1571E-02_JPRB,5.2845E-02_JPRB/)
KBO( :, 1,32, 7) = (/&
&5.1572E-03_JPRB,5.9281E-03_JPRB,3.2288E-02_JPRB,4.4834E-02_JPRB,5.2063E-02_JPRB,4.6838E-02_JPRB/)
KBO( :, 2,32, 7) = (/&
&5.5343E-03_JPRB,6.3178E-03_JPRB,3.3066E-02_JPRB,4.5379E-02_JPRB,5.2022E-02_JPRB,4.6134E-02_JPRB/)
KBO( :, 3,32, 7) = (/&
&5.9793E-03_JPRB,6.7732E-03_JPRB,3.3755E-02_JPRB,4.5782E-02_JPRB,5.1906E-02_JPRB,4.5284E-02_JPRB/)
KBO( :, 4,32, 7) = (/&
&6.4923E-03_JPRB,7.2876E-03_JPRB,3.4382E-02_JPRB,4.6031E-02_JPRB,5.1677E-02_JPRB,4.4332E-02_JPRB/)
KBO( :, 5,32, 7) = (/&
&7.0596E-03_JPRB,7.8510E-03_JPRB,3.5020E-02_JPRB,4.6157E-02_JPRB,5.1326E-02_JPRB,4.3327E-02_JPRB/)
KBO( :, 1,33, 7) = (/&
&4.4193E-03_JPRB,5.1672E-03_JPRB,2.7281E-02_JPRB,3.7643E-02_JPRB,4.3289E-02_JPRB,3.8410E-02_JPRB/)
KBO( :, 2,33, 7) = (/&
&4.7780E-03_JPRB,5.5509E-03_JPRB,2.7954E-02_JPRB,3.8112E-02_JPRB,4.3323E-02_JPRB,3.7821E-02_JPRB/)
KBO( :, 3,33, 7) = (/&
&5.1954E-03_JPRB,5.9899E-03_JPRB,2.8558E-02_JPRB,3.8442E-02_JPRB,4.3253E-02_JPRB,3.7133E-02_JPRB/)
KBO( :, 4,33, 7) = (/&
&5.6675E-03_JPRB,6.4760E-03_JPRB,2.9162E-02_JPRB,3.8661E-02_JPRB,4.3077E-02_JPRB,3.6382E-02_JPRB/)
KBO( :, 5,33, 7) = (/&
&6.1867E-03_JPRB,6.9981E-03_JPRB,2.9817E-02_JPRB,3.8817E-02_JPRB,4.2791E-02_JPRB,3.5593E-02_JPRB/)
KBO( :, 1,34, 7) = (/&
&3.7967E-03_JPRB,4.5190E-03_JPRB,2.3030E-02_JPRB,3.1601E-02_JPRB,3.6054E-02_JPRB,3.1509E-02_JPRB/)
KBO( :, 2,34, 7) = (/&
&4.1317E-03_JPRB,4.8886E-03_JPRB,2.3612E-02_JPRB,3.1993E-02_JPRB,3.6114E-02_JPRB,3.1025E-02_JPRB/)
KBO( :, 3,34, 7) = (/&
&4.5197E-03_JPRB,5.3080E-03_JPRB,2.4172E-02_JPRB,3.2284E-02_JPRB,3.6075E-02_JPRB,3.0475E-02_JPRB/)
KBO( :, 4,34, 7) = (/&
&4.9490E-03_JPRB,5.7615E-03_JPRB,2.4765E-02_JPRB,3.2500E-02_JPRB,3.5934E-02_JPRB,2.9886E-02_JPRB/)
KBO( :, 5,34, 7) = (/&
&5.4277E-03_JPRB,6.2506E-03_JPRB,2.5457E-02_JPRB,3.2703E-02_JPRB,3.5717E-02_JPRB,2.9265E-02_JPRB/)
KBO( :, 1,35, 7) = (/&
&3.2485E-03_JPRB,3.9401E-03_JPRB,1.9395E-02_JPRB,2.6487E-02_JPRB,3.0061E-02_JPRB,2.5898E-02_JPRB/)
KBO( :, 2,35, 7) = (/&
&3.5574E-03_JPRB,4.2902E-03_JPRB,1.9918E-02_JPRB,2.6839E-02_JPRB,3.0137E-02_JPRB,2.5509E-02_JPRB/)
KBO( :, 3,35, 7) = (/&
&3.9084E-03_JPRB,4.6823E-03_JPRB,2.0454E-02_JPRB,2.7112E-02_JPRB,3.0123E-02_JPRB,2.5080E-02_JPRB/)
KBO( :, 4,35, 7) = (/&
&4.2975E-03_JPRB,5.1039E-03_JPRB,2.1052E-02_JPRB,2.7348E-02_JPRB,3.0028E-02_JPRB,2.4626E-02_JPRB/)
KBO( :, 5,35, 7) = (/&
&4.7400E-03_JPRB,5.5642E-03_JPRB,2.1748E-02_JPRB,2.7600E-02_JPRB,2.9873E-02_JPRB,2.4136E-02_JPRB/)
KBO( :, 1,36, 7) = (/&
&2.7607E-03_JPRB,3.4142E-03_JPRB,1.6292E-02_JPRB,2.2168E-02_JPRB,2.5071E-02_JPRB,2.1321E-02_JPRB/)
KBO( :, 2,36, 7) = (/&
&3.0408E-03_JPRB,3.7429E-03_JPRB,1.6771E-02_JPRB,2.2492E-02_JPRB,2.5167E-02_JPRB,2.1022E-02_JPRB/)
KBO( :, 3,36, 7) = (/&
&3.3541E-03_JPRB,4.1050E-03_JPRB,1.7286E-02_JPRB,2.2762E-02_JPRB,2.5179E-02_JPRB,2.0697E-02_JPRB/)
KBO( :, 4,36, 7) = (/&
&3.7038E-03_JPRB,4.4924E-03_JPRB,1.7882E-02_JPRB,2.3025E-02_JPRB,2.5128E-02_JPRB,2.0344E-02_JPRB/)
KBO( :, 5,36, 7) = (/&
&4.1115E-03_JPRB,4.9275E-03_JPRB,1.8561E-02_JPRB,2.3321E-02_JPRB,2.5038E-02_JPRB,1.9966E-02_JPRB/)
KBO( :, 1,37, 7) = (/&
&2.3165E-03_JPRB,2.9243E-03_JPRB,1.3632E-02_JPRB,1.8511E-02_JPRB,2.0911E-02_JPRB,1.7582E-02_JPRB/)
KBO( :, 2,37, 7) = (/&
&2.5620E-03_JPRB,3.2240E-03_JPRB,1.4078E-02_JPRB,1.8817E-02_JPRB,2.1021E-02_JPRB,1.7359E-02_JPRB/)
KBO( :, 3,37, 7) = (/&
&2.8378E-03_JPRB,3.5536E-03_JPRB,1.4566E-02_JPRB,1.9089E-02_JPRB,2.1062E-02_JPRB,1.7112E-02_JPRB/)
KBO( :, 4,37, 7) = (/&
&3.1506E-03_JPRB,3.9105E-03_JPRB,1.5134E-02_JPRB,1.9368E-02_JPRB,2.1055E-02_JPRB,1.6843E-02_JPRB/)
KBO( :, 5,37, 7) = (/&
&3.5154E-03_JPRB,4.3116E-03_JPRB,1.5780E-02_JPRB,1.9690E-02_JPRB,2.1025E-02_JPRB,1.6554E-02_JPRB/)
KBO( :, 1,38, 7) = (/&
&1.9436E-03_JPRB,2.5043E-03_JPRB,1.1409E-02_JPRB,1.5449E-02_JPRB,1.7439E-02_JPRB,1.4509E-02_JPRB/)
KBO( :, 2,38, 7) = (/&
&2.1585E-03_JPRB,2.7776E-03_JPRB,1.1822E-02_JPRB,1.5741E-02_JPRB,1.7560E-02_JPRB,1.4349E-02_JPRB/)
KBO( :, 3,38, 7) = (/&
&2.4018E-03_JPRB,3.0766E-03_JPRB,1.2278E-02_JPRB,1.6010E-02_JPRB,1.7625E-02_JPRB,1.4163E-02_JPRB/)
KBO( :, 4,38, 7) = (/&
&2.6807E-03_JPRB,3.4074E-03_JPRB,1.2821E-02_JPRB,1.6300E-02_JPRB,1.7653E-02_JPRB,1.3961E-02_JPRB/)
KBO( :, 5,38, 7) = (/&
&3.0074E-03_JPRB,3.7767E-03_JPRB,1.3427E-02_JPRB,1.6635E-02_JPRB,1.7670E-02_JPRB,1.3745E-02_JPRB/)
KBO( :, 1,39, 7) = (/&
&1.6324E-03_JPRB,2.1472E-03_JPRB,9.5576E-03_JPRB,1.2899E-02_JPRB,1.4546E-02_JPRB,1.1989E-02_JPRB/)
KBO( :, 2,39, 7) = (/&
&1.8200E-03_JPRB,2.3947E-03_JPRB,9.9337E-03_JPRB,1.3170E-02_JPRB,1.4671E-02_JPRB,1.1875E-02_JPRB/)
KBO( :, 3,39, 7) = (/&
&2.0341E-03_JPRB,2.6676E-03_JPRB,1.0368E-02_JPRB,1.3436E-02_JPRB,1.4754E-02_JPRB,1.1741E-02_JPRB/)
KBO( :, 4,39, 7) = (/&
&2.2822E-03_JPRB,2.9700E-03_JPRB,1.0873E-02_JPRB,1.3729E-02_JPRB,1.4811E-02_JPRB,1.1592E-02_JPRB/)
KBO( :, 5,39, 7) = (/&
&2.5777E-03_JPRB,3.3169E-03_JPRB,1.1451E-02_JPRB,1.4071E-02_JPRB,1.4864E-02_JPRB,1.1429E-02_JPRB/)
KBO( :, 1,40, 7) = (/&
&1.3560E-03_JPRB,1.8205E-03_JPRB,7.9786E-03_JPRB,1.0746E-02_JPRB,1.2116E-02_JPRB,9.8937E-03_JPRB/)
KBO( :, 2,40, 7) = (/&
&1.5188E-03_JPRB,2.0432E-03_JPRB,8.3209E-03_JPRB,1.1001E-02_JPRB,1.2248E-02_JPRB,9.8116E-03_JPRB/)
KBO( :, 3,40, 7) = (/&
&1.7047E-03_JPRB,2.2893E-03_JPRB,8.7183E-03_JPRB,1.1256E-02_JPRB,1.2346E-02_JPRB,9.7139E-03_JPRB/)
KBO( :, 4,40, 7) = (/&
&1.9222E-03_JPRB,2.5662E-03_JPRB,9.1877E-03_JPRB,1.1545E-02_JPRB,1.2425E-02_JPRB,9.6034E-03_JPRB/)
KBO( :, 5,40, 7) = (/&
&2.1827E-03_JPRB,2.8825E-03_JPRB,9.7216E-03_JPRB,1.1880E-02_JPRB,1.2506E-02_JPRB,9.4790E-03_JPRB/)
KBO( :, 1,41, 7) = (/&
&1.1245E-03_JPRB,1.5415E-03_JPRB,6.6591E-03_JPRB,8.9478E-03_JPRB,1.0087E-02_JPRB,8.1642E-03_JPRB/)
KBO( :, 2,41, 7) = (/&
&1.2648E-03_JPRB,1.7402E-03_JPRB,6.9688E-03_JPRB,9.1871E-03_JPRB,1.0221E-02_JPRB,8.1056E-03_JPRB/)
KBO( :, 3,41, 7) = (/&
&1.4266E-03_JPRB,1.9622E-03_JPRB,7.3306E-03_JPRB,9.4300E-03_JPRB,1.0328E-02_JPRB,8.0356E-03_JPRB/)
KBO( :, 4,41, 7) = (/&
&1.6162E-03_JPRB,2.2132E-03_JPRB,7.7614E-03_JPRB,9.7094E-03_JPRB,1.0422E-02_JPRB,7.9538E-03_JPRB/)
KBO( :, 5,41, 7) = (/&
&1.8452E-03_JPRB,2.5020E-03_JPRB,8.2540E-03_JPRB,1.0030E-02_JPRB,1.0522E-02_JPRB,7.8592E-03_JPRB/)
KBO( :, 1,42, 7) = (/&
&9.3219E-04_JPRB,1.3042E-03_JPRB,5.5558E-03_JPRB,7.4502E-03_JPRB,8.3930E-03_JPRB,6.7373E-03_JPRB/)
KBO( :, 2,42, 7) = (/&
&1.0531E-03_JPRB,1.4817E-03_JPRB,5.8359E-03_JPRB,7.6727E-03_JPRB,8.5267E-03_JPRB,6.6979E-03_JPRB/)
KBO( :, 3,42, 7) = (/&
&1.1932E-03_JPRB,1.6822E-03_JPRB,6.1662E-03_JPRB,7.9012E-03_JPRB,8.6371E-03_JPRB,6.6486E-03_JPRB/)
KBO( :, 4,42, 7) = (/&
&1.3591E-03_JPRB,1.9101E-03_JPRB,6.5594E-03_JPRB,8.1659E-03_JPRB,8.7400E-03_JPRB,6.5900E-03_JPRB/)
KBO( :, 5,42, 7) = (/&
&1.5595E-03_JPRB,2.1712E-03_JPRB,7.0143E-03_JPRB,8.4711E-03_JPRB,8.8520E-03_JPRB,6.5197E-03_JPRB/)
KBO( :, 1,43, 7) = (/&
&7.6655E-04_JPRB,1.0948E-03_JPRB,4.6199E-03_JPRB,6.1929E-03_JPRB,6.9738E-03_JPRB,5.5590E-03_JPRB/)
KBO( :, 2,43, 7) = (/&
&8.7006E-04_JPRB,1.2519E-03_JPRB,4.8725E-03_JPRB,6.3982E-03_JPRB,7.1051E-03_JPRB,5.5354E-03_JPRB/)
KBO( :, 3,43, 7) = (/&
&9.9067E-04_JPRB,1.4317E-03_JPRB,5.1714E-03_JPRB,6.6094E-03_JPRB,7.2167E-03_JPRB,5.5034E-03_JPRB/)
KBO( :, 4,43, 7) = (/&
&1.1333E-03_JPRB,1.6361E-03_JPRB,5.5238E-03_JPRB,6.8549E-03_JPRB,7.3224E-03_JPRB,5.4615E-03_JPRB/)
KBO( :, 5,43, 7) = (/&
&1.3078E-03_JPRB,1.8729E-03_JPRB,5.9392E-03_JPRB,7.1404E-03_JPRB,7.4395E-03_JPRB,5.4098E-03_JPRB/)
KBO( :, 1,44, 7) = (/&
&6.2716E-04_JPRB,9.1445E-04_JPRB,3.8379E-03_JPRB,5.1423E-03_JPRB,5.7885E-03_JPRB,4.5879E-03_JPRB/)
KBO( :, 2,44, 7) = (/&
&7.1539E-04_JPRB,1.0525E-03_JPRB,4.0608E-03_JPRB,5.3284E-03_JPRB,5.9139E-03_JPRB,4.5750E-03_JPRB/)
KBO( :, 3,44, 7) = (/&
&8.1868E-04_JPRB,1.2124E-03_JPRB,4.3261E-03_JPRB,5.5223E-03_JPRB,6.0237E-03_JPRB,4.5564E-03_JPRB/)
KBO( :, 4,44, 7) = (/&
&9.4076E-04_JPRB,1.3951E-03_JPRB,4.6439E-03_JPRB,5.7493E-03_JPRB,6.1304E-03_JPRB,4.5291E-03_JPRB/)
KBO( :, 5,44, 7) = (/&
&1.0905E-03_JPRB,1.6074E-03_JPRB,5.0184E-03_JPRB,6.0132E-03_JPRB,6.2498E-03_JPRB,4.4930E-03_JPRB/)
KBO( :, 1,45, 7) = (/&
&5.1229E-04_JPRB,7.6193E-04_JPRB,3.1853E-03_JPRB,4.2678E-03_JPRB,4.8007E-03_JPRB,3.7867E-03_JPRB/)
KBO( :, 2,45, 7) = (/&
&5.8700E-04_JPRB,8.8309E-04_JPRB,3.3822E-03_JPRB,4.4376E-03_JPRB,4.9204E-03_JPRB,3.7837E-03_JPRB/)
KBO( :, 3,45, 7) = (/&
&6.7532E-04_JPRB,1.0253E-03_JPRB,3.6172E-03_JPRB,4.6137E-03_JPRB,5.0263E-03_JPRB,3.7750E-03_JPRB/)
KBO( :, 4,45, 7) = (/&
&7.7992E-04_JPRB,1.1886E-03_JPRB,3.9001E-03_JPRB,4.8193E-03_JPRB,5.1305E-03_JPRB,3.7582E-03_JPRB/)
KBO( :, 5,45, 7) = (/&
&9.0898E-04_JPRB,1.3801E-03_JPRB,4.2375E-03_JPRB,5.0602E-03_JPRB,5.2468E-03_JPRB,3.7339E-03_JPRB/)
KBO( :, 1,46, 7) = (/&
&4.1645E-04_JPRB,6.3110E-04_JPRB,2.6350E-03_JPRB,3.5353E-03_JPRB,3.9769E-03_JPRB,3.1256E-03_JPRB/)
KBO( :, 2,46, 7) = (/&
&4.7902E-04_JPRB,7.3636E-04_JPRB,2.8091E-03_JPRB,3.6888E-03_JPRB,4.0884E-03_JPRB,3.1284E-03_JPRB/)
KBO( :, 3,46, 7) = (/&
&5.5407E-04_JPRB,8.6233E-04_JPRB,3.0151E-03_JPRB,3.8480E-03_JPRB,4.1890E-03_JPRB,3.1266E-03_JPRB/)
KBO( :, 4,46, 7) = (/&
&6.4357E-04_JPRB,1.0083E-03_JPRB,3.2677E-03_JPRB,4.0349E-03_JPRB,4.2897E-03_JPRB,3.1195E-03_JPRB/)
KBO( :, 5,46, 7) = (/&
&7.5354E-04_JPRB,1.1783E-03_JPRB,3.5685E-03_JPRB,4.2544E-03_JPRB,4.4018E-03_JPRB,3.1063E-03_JPRB/)
KBO( :, 1,47, 7) = (/&
&3.3601E-04_JPRB,5.1777E-04_JPRB,2.1723E-03_JPRB,2.9197E-03_JPRB,3.2860E-03_JPRB,2.5760E-03_JPRB/)
KBO( :, 2,47, 7) = (/&
&3.8754E-04_JPRB,6.0796E-04_JPRB,2.3239E-03_JPRB,3.0581E-03_JPRB,3.3911E-03_JPRB,2.5844E-03_JPRB/)
KBO( :, 3,47, 7) = (/&
&4.5065E-04_JPRB,7.1798E-04_JPRB,2.5022E-03_JPRB,3.2019E-03_JPRB,3.4875E-03_JPRB,2.5889E-03_JPRB/)
KBO( :, 4,47, 7) = (/&
&5.2613E-04_JPRB,8.4682E-04_JPRB,2.7238E-03_JPRB,3.3682E-03_JPRB,3.5815E-03_JPRB,2.5884E-03_JPRB/)
KBO( :, 5,47, 7) = (/&
&6.1929E-04_JPRB,9.9786E-04_JPRB,2.9897E-03_JPRB,3.5658E-03_JPRB,3.6861E-03_JPRB,2.5827E-03_JPRB/)
KBO( :, 1,48, 7) = (/&
&2.7083E-04_JPRB,4.2347E-04_JPRB,1.7899E-03_JPRB,2.4088E-03_JPRB,2.7136E-03_JPRB,2.1244E-03_JPRB/)
KBO( :, 2,48, 7) = (/&
&3.1279E-04_JPRB,4.9999E-04_JPRB,1.9206E-03_JPRB,2.5330E-03_JPRB,2.8112E-03_JPRB,2.1367E-03_JPRB/)
KBO( :, 3,48, 7) = (/&
&3.6550E-04_JPRB,5.9533E-04_JPRB,2.0740E-03_JPRB,2.6614E-03_JPRB,2.9002E-03_JPRB,2.1451E-03_JPRB/)
KBO( :, 4,48, 7) = (/&
&4.2897E-04_JPRB,7.0913E-04_JPRB,2.2662E-03_JPRB,2.8083E-03_JPRB,2.9875E-03_JPRB,2.1497E-03_JPRB/)
KBO( :, 5,48, 7) = (/&
&5.0746E-04_JPRB,8.4310E-04_JPRB,2.4995E-03_JPRB,2.9841E-03_JPRB,3.0838E-03_JPRB,2.1494E-03_JPRB/)
KBO( :, 1,49, 7) = (/&
&2.1798E-04_JPRB,3.4528E-04_JPRB,1.4710E-03_JPRB,1.9833E-03_JPRB,2.2375E-03_JPRB,1.7528E-03_JPRB/)
KBO( :, 2,49, 7) = (/&
&2.5177E-04_JPRB,4.0956E-04_JPRB,1.5850E-03_JPRB,2.0943E-03_JPRB,2.3273E-03_JPRB,1.7678E-03_JPRB/)
KBO( :, 3,49, 7) = (/&
&2.9568E-04_JPRB,4.9144E-04_JPRB,1.7161E-03_JPRB,2.2089E-03_JPRB,2.4094E-03_JPRB,1.7791E-03_JPRB/)
KBO( :, 4,49, 7) = (/&
&3.4874E-04_JPRB,5.9100E-04_JPRB,1.8818E-03_JPRB,2.3380E-03_JPRB,2.4892E-03_JPRB,1.7874E-03_JPRB/)
KBO( :, 5,49, 7) = (/&
&4.1458E-04_JPRB,7.0951E-04_JPRB,2.0849E-03_JPRB,2.4934E-03_JPRB,2.5772E-03_JPRB,1.7919E-03_JPRB/)
KBO( :, 1,50, 7) = (/&
&1.7585E-04_JPRB,2.8189E-04_JPRB,1.2093E-03_JPRB,1.6329E-03_JPRB,1.8441E-03_JPRB,1.4430E-03_JPRB/)
KBO( :, 2,50, 7) = (/&
&2.0319E-04_JPRB,3.3574E-04_JPRB,1.3080E-03_JPRB,1.7313E-03_JPRB,1.9256E-03_JPRB,1.4584E-03_JPRB/)
KBO( :, 3,50, 7) = (/&
&2.3954E-04_JPRB,4.0576E-04_JPRB,1.4210E-03_JPRB,1.8326E-03_JPRB,2.0011E-03_JPRB,1.4708E-03_JPRB/)
KBO( :, 4,50, 7) = (/&
&2.8402E-04_JPRB,4.9271E-04_JPRB,1.5642E-03_JPRB,1.9468E-03_JPRB,2.0746E-03_JPRB,1.4813E-03_JPRB/)
KBO( :, 5,50, 7) = (/&
&3.3943E-04_JPRB,5.9790E-04_JPRB,1.7417E-03_JPRB,2.0852E-03_JPRB,2.1555E-03_JPRB,1.4890E-03_JPRB/)
KBO( :, 1,51, 7) = (/&
&1.4190E-04_JPRB,2.2992E-04_JPRB,9.9404E-04_JPRB,1.3435E-03_JPRB,1.5181E-03_JPRB,1.1857E-03_JPRB/)
KBO( :, 2,51, 7) = (/&
&1.6404E-04_JPRB,2.7497E-04_JPRB,1.0789E-03_JPRB,1.4304E-03_JPRB,1.5921E-03_JPRB,1.2010E-03_JPRB/)
KBO( :, 3,51, 7) = (/&
&1.9404E-04_JPRB,3.3460E-04_JPRB,1.1768E-03_JPRB,1.5204E-03_JPRB,1.6616E-03_JPRB,1.2144E-03_JPRB/)
KBO( :, 4,51, 7) = (/&
&2.3131E-04_JPRB,4.1015E-04_JPRB,1.3000E-03_JPRB,1.6207E-03_JPRB,1.7290E-03_JPRB,1.2257E-03_JPRB/)
KBO( :, 5,51, 7) = (/&
&2.7780E-04_JPRB,5.0292E-04_JPRB,1.4546E-03_JPRB,1.7432E-03_JPRB,1.8024E-03_JPRB,1.2347E-03_JPRB/)
KBO( :, 1,52, 7) = (/&
&1.1444E-04_JPRB,1.8707E-04_JPRB,8.1510E-04_JPRB,1.1036E-03_JPRB,1.2481E-03_JPRB,9.7442E-04_JPRB/)
KBO( :, 2,52, 7) = (/&
&1.3222E-04_JPRB,2.2446E-04_JPRB,8.8966E-04_JPRB,1.1810E-03_JPRB,1.3153E-03_JPRB,9.8987E-04_JPRB/)
KBO( :, 3,52, 7) = (/&
&1.5685E-04_JPRB,2.7479E-04_JPRB,9.7350E-04_JPRB,1.2602E-03_JPRB,1.3785E-03_JPRB,1.0031E-03_JPRB/)
KBO( :, 4,52, 7) = (/&
&1.8798E-04_JPRB,3.3998E-04_JPRB,1.0787E-03_JPRB,1.3479E-03_JPRB,1.4399E-03_JPRB,1.0147E-03_JPRB/)
KBO( :, 5,52, 7) = (/&
&2.2685E-04_JPRB,4.2103E-04_JPRB,1.2129E-03_JPRB,1.4553E-03_JPRB,1.5058E-03_JPRB,1.0246E-03_JPRB/)
KBO( :, 1,53, 7) = (/&
&9.2203E-05_JPRB,1.5178E-04_JPRB,6.6684E-04_JPRB,9.0491E-04_JPRB,1.0248E-03_JPRB,8.0095E-04_JPRB/)
KBO( :, 2,53, 7) = (/&
&1.0645E-04_JPRB,1.8273E-04_JPRB,7.3180E-04_JPRB,9.7345E-04_JPRB,1.0848E-03_JPRB,8.1627E-04_JPRB/)
KBO( :, 3,53, 7) = (/&
&1.2645E-04_JPRB,2.2480E-04_JPRB,8.0421E-04_JPRB,1.0432E-03_JPRB,1.1420E-03_JPRB,8.2935E-04_JPRB/)
KBO( :, 4,53, 7) = (/&
&1.5240E-04_JPRB,2.8048E-04_JPRB,8.9332E-04_JPRB,1.1196E-03_JPRB,1.1976E-03_JPRB,8.4108E-04_JPRB/)
KBO( :, 5,53, 7) = (/&
&1.8493E-04_JPRB,3.5120E-04_JPRB,1.0092E-03_JPRB,1.2130E-03_JPRB,1.2568E-03_JPRB,8.5144E-04_JPRB/)
KBO( :, 1,54, 7) = (/&
&7.4475E-05_JPRB,1.2345E-04_JPRB,5.4618E-04_JPRB,7.4261E-04_JPRB,8.4183E-04_JPRB,6.5530E-04_JPRB/)
KBO( :, 2,54, 7) = (/&
&8.5959E-05_JPRB,1.4923E-04_JPRB,6.0251E-04_JPRB,8.0294E-04_JPRB,8.9490E-04_JPRB,6.6891E-04_JPRB/)
KBO( :, 3,54, 7) = (/&
&1.0229E-04_JPRB,1.8454E-04_JPRB,6.6507E-04_JPRB,8.6435E-04_JPRB,9.4622E-04_JPRB,6.8052E-04_JPRB/)
KBO( :, 4,54, 7) = (/&
&1.2399E-04_JPRB,2.3208E-04_JPRB,7.4156E-04_JPRB,9.3133E-04_JPRB,9.9626E-04_JPRB,6.9113E-04_JPRB/)
KBO( :, 5,54, 7) = (/&
&1.5132E-04_JPRB,2.9378E-04_JPRB,8.4147E-04_JPRB,1.0125E-03_JPRB,1.0494E-03_JPRB,7.0039E-04_JPRB/)
KBO( :, 1,55, 7) = (/&
&6.0192E-05_JPRB,1.0040E-04_JPRB,4.4700E-04_JPRB,6.0908E-04_JPRB,6.9112E-04_JPRB,5.3444E-04_JPRB/)
KBO( :, 2,55, 7) = (/&
&6.9457E-05_JPRB,1.2191E-04_JPRB,4.9554E-04_JPRB,6.6216E-04_JPRB,7.3789E-04_JPRB,5.4620E-04_JPRB/)
KBO( :, 3,55, 7) = (/&
&8.2806E-05_JPRB,1.5147E-04_JPRB,5.4968E-04_JPRB,7.1596E-04_JPRB,7.8355E-04_JPRB,5.5595E-04_JPRB/)
KBO( :, 4,55, 7) = (/&
&1.0089E-04_JPRB,1.9188E-04_JPRB,6.1506E-04_JPRB,7.7451E-04_JPRB,8.2844E-04_JPRB,5.6494E-04_JPRB/)
KBO( :, 5,55, 7) = (/&
&1.2391E-04_JPRB,2.4549E-04_JPRB,7.0152E-04_JPRB,8.4524E-04_JPRB,8.7589E-04_JPRB,5.7264E-04_JPRB/)
KBO( :, 1,56, 7) = (/&
&4.8580E-05_JPRB,8.1447E-05_JPRB,3.6499E-04_JPRB,4.9860E-04_JPRB,5.6674E-04_JPRB,4.3567E-04_JPRB/)
KBO( :, 2,56, 7) = (/&
&5.6047E-05_JPRB,9.9320E-05_JPRB,4.0649E-04_JPRB,5.4492E-04_JPRB,6.0760E-04_JPRB,4.4586E-04_JPRB/)
KBO( :, 3,56, 7) = (/&
&6.6893E-05_JPRB,1.2391E-04_JPRB,4.5320E-04_JPRB,5.9224E-04_JPRB,6.4818E-04_JPRB,4.5422E-04_JPRB/)
KBO( :, 4,56, 7) = (/&
&8.1912E-05_JPRB,1.5812E-04_JPRB,5.0921E-04_JPRB,6.4326E-04_JPRB,6.8817E-04_JPRB,4.6166E-04_JPRB/)
KBO( :, 5,56, 7) = (/&
&1.0126E-04_JPRB,2.0443E-04_JPRB,5.8380E-04_JPRB,7.0456E-04_JPRB,7.3041E-04_JPRB,4.6808E-04_JPRB/)
KBO( :, 1,57, 7) = (/&
&3.9160E-05_JPRB,6.5848E-05_JPRB,2.9734E-04_JPRB,4.0720E-04_JPRB,4.6401E-04_JPRB,3.5487E-04_JPRB/)
KBO( :, 2,57, 7) = (/&
&4.5169E-05_JPRB,8.0667E-05_JPRB,3.3303E-04_JPRB,4.4771E-04_JPRB,4.9960E-04_JPRB,3.6385E-04_JPRB/)
KBO( :, 3,57, 7) = (/&
&5.3922E-05_JPRB,1.0107E-04_JPRB,3.7271E-04_JPRB,4.8901E-04_JPRB,5.3556E-04_JPRB,3.7100E-04_JPRB/)
KBO( :, 4,57, 7) = (/&
&6.6309E-05_JPRB,1.2986E-04_JPRB,4.2066E-04_JPRB,5.3363E-04_JPRB,5.7118E-04_JPRB,3.7715E-04_JPRB/)
KBO( :, 5,57, 7) = (/&
&8.2558E-05_JPRB,1.6957E-04_JPRB,4.8458E-04_JPRB,5.8660E-04_JPRB,6.0854E-04_JPRB,3.8261E-04_JPRB/)
KBO( :, 1,58, 7) = (/&
&3.1595E-05_JPRB,5.3251E-05_JPRB,2.4214E-04_JPRB,3.3220E-04_JPRB,3.7979E-04_JPRB,2.8893E-04_JPRB/)
KBO( :, 2,58, 7) = (/&
&3.6453E-05_JPRB,6.5530E-05_JPRB,2.7256E-04_JPRB,3.6744E-04_JPRB,4.1068E-04_JPRB,2.9670E-04_JPRB/)
KBO( :, 3,58, 7) = (/&
&4.3522E-05_JPRB,8.2522E-05_JPRB,3.0670E-04_JPRB,4.0362E-04_JPRB,4.4239E-04_JPRB,3.0276E-04_JPRB/)
KBO( :, 4,58, 7) = (/&
&5.3718E-05_JPRB,1.0672E-04_JPRB,3.4774E-04_JPRB,4.4273E-04_JPRB,4.7408E-04_JPRB,3.0780E-04_JPRB/)
KBO( :, 5,58, 7) = (/&
&6.7377E-05_JPRB,1.4070E-04_JPRB,4.0225E-04_JPRB,4.8863E-04_JPRB,5.0717E-04_JPRB,3.1234E-04_JPRB/)
KBO( :, 1,59, 7) = (/&
&2.6095E-05_JPRB,4.4557E-05_JPRB,2.0135E-04_JPRB,2.7586E-04_JPRB,3.1509E-04_JPRB,2.3542E-04_JPRB/)
KBO( :, 2,59, 7) = (/&
&3.0251E-05_JPRB,5.5296E-05_JPRB,2.2770E-04_JPRB,3.0652E-04_JPRB,3.4210E-04_JPRB,2.4160E-04_JPRB/)
KBO( :, 3,59, 7) = (/&
&3.6364E-05_JPRB,7.0315E-05_JPRB,2.5762E-04_JPRB,3.3839E-04_JPRB,3.7008E-04_JPRB,2.4615E-04_JPRB/)
KBO( :, 4,59, 7) = (/&
&4.5252E-05_JPRB,9.1955E-05_JPRB,2.9410E-04_JPRB,3.7318E-04_JPRB,3.9814E-04_JPRB,2.4968E-04_JPRB/)
KBO( :, 5,59, 7) = (/&
&5.7239E-05_JPRB,1.2271E-04_JPRB,3.4336E-04_JPRB,4.1464E-04_JPRB,4.2794E-04_JPRB,2.5280E-04_JPRB/)
KBO( :, 1,13, 8) = (/&
&3.0593E-01_JPRB,3.0601E-01_JPRB,5.8936E-01_JPRB,8.8205E-01_JPRB,1.0947E+00_JPRB,1.1943E+00_JPRB/)
KBO( :, 2,13, 8) = (/&
&3.0576E-01_JPRB,3.0585E-01_JPRB,5.8416E-01_JPRB,8.7445E-01_JPRB,1.0842E+00_JPRB,1.1946E+00_JPRB/)
KBO( :, 3,13, 8) = (/&
&3.0730E-01_JPRB,3.0739E-01_JPRB,5.7838E-01_JPRB,8.6622E-01_JPRB,1.0736E+00_JPRB,1.1941E+00_JPRB/)
KBO( :, 4,13, 8) = (/&
&3.1143E-01_JPRB,3.1153E-01_JPRB,5.7236E-01_JPRB,8.5664E-01_JPRB,1.0623E+00_JPRB,1.1926E+00_JPRB/)
KBO( :, 5,13, 8) = (/&
&3.1821E-01_JPRB,3.1830E-01_JPRB,5.6671E-01_JPRB,8.4589E-01_JPRB,1.0496E+00_JPRB,1.1883E+00_JPRB/)
KBO( :, 1,14, 8) = (/&
&2.6541E-01_JPRB,2.6552E-01_JPRB,5.8043E-01_JPRB,8.8352E-01_JPRB,1.1026E+00_JPRB,1.1931E+00_JPRB/)
KBO( :, 2,14, 8) = (/&
&2.6695E-01_JPRB,2.6706E-01_JPRB,5.7539E-01_JPRB,8.7778E-01_JPRB,1.0951E+00_JPRB,1.1937E+00_JPRB/)
KBO( :, 3,14, 8) = (/&
&2.7112E-01_JPRB,2.7123E-01_JPRB,5.7000E-01_JPRB,8.7108E-01_JPRB,1.0869E+00_JPRB,1.1910E+00_JPRB/)
KBO( :, 4,14, 8) = (/&
&2.7807E-01_JPRB,2.7818E-01_JPRB,5.6514E-01_JPRB,8.6271E-01_JPRB,1.0767E+00_JPRB,1.1867E+00_JPRB/)
KBO( :, 5,14, 8) = (/&
&2.8739E-01_JPRB,2.8751E-01_JPRB,5.6126E-01_JPRB,8.5280E-01_JPRB,1.0643E+00_JPRB,1.1809E+00_JPRB/)
KBO( :, 1,15, 8) = (/&
&2.3178E-01_JPRB,2.3191E-01_JPRB,5.7184E-01_JPRB,8.7693E-01_JPRB,1.1022E+00_JPRB,1.1813E+00_JPRB/)
KBO( :, 2,15, 8) = (/&
&2.3560E-01_JPRB,2.3573E-01_JPRB,5.6724E-01_JPRB,8.7349E-01_JPRB,1.0976E+00_JPRB,1.1800E+00_JPRB/)
KBO( :, 3,15, 8) = (/&
&2.4219E-01_JPRB,2.4233E-01_JPRB,5.6272E-01_JPRB,8.6826E-01_JPRB,1.0904E+00_JPRB,1.1766E+00_JPRB/)
KBO( :, 4,15, 8) = (/&
&2.5074E-01_JPRB,2.5088E-01_JPRB,5.5919E-01_JPRB,8.6097E-01_JPRB,1.0807E+00_JPRB,1.1720E+00_JPRB/)
KBO( :, 5,15, 8) = (/&
&2.6000E-01_JPRB,2.6013E-01_JPRB,5.5698E-01_JPRB,8.5261E-01_JPRB,1.0688E+00_JPRB,1.1657E+00_JPRB/)
KBO( :, 1,16, 8) = (/&
&2.0414E-01_JPRB,2.0429E-01_JPRB,5.5967E-01_JPRB,8.6370E-01_JPRB,1.0904E+00_JPRB,1.1562E+00_JPRB/)
KBO( :, 2,16, 8) = (/&
&2.1009E-01_JPRB,2.1024E-01_JPRB,5.5625E-01_JPRB,8.6141E-01_JPRB,1.0865E+00_JPRB,1.1558E+00_JPRB/)
KBO( :, 3,16, 8) = (/&
&2.1753E-01_JPRB,2.1768E-01_JPRB,5.5355E-01_JPRB,8.5657E-01_JPRB,1.0800E+00_JPRB,1.1537E+00_JPRB/)
KBO( :, 4,16, 8) = (/&
&2.2581E-01_JPRB,2.2595E-01_JPRB,5.5210E-01_JPRB,8.5071E-01_JPRB,1.0712E+00_JPRB,1.1497E+00_JPRB/)
KBO( :, 5,16, 8) = (/&
&2.3451E-01_JPRB,2.3466E-01_JPRB,5.5166E-01_JPRB,8.4445E-01_JPRB,1.0599E+00_JPRB,1.1442E+00_JPRB/)
KBO( :, 1,17, 8) = (/&
&1.8111E-01_JPRB,1.8127E-01_JPRB,5.4370E-01_JPRB,8.4066E-01_JPRB,1.0633E+00_JPRB,1.1173E+00_JPRB/)
KBO( :, 2,17, 8) = (/&
&1.8751E-01_JPRB,1.8767E-01_JPRB,5.4225E-01_JPRB,8.3870E-01_JPRB,1.0603E+00_JPRB,1.1188E+00_JPRB/)
KBO( :, 3,17, 8) = (/&
&1.9478E-01_JPRB,1.9494E-01_JPRB,5.4182E-01_JPRB,8.3528E-01_JPRB,1.0547E+00_JPRB,1.1179E+00_JPRB/)
KBO( :, 4,17, 8) = (/&
&2.0226E-01_JPRB,2.0242E-01_JPRB,5.4242E-01_JPRB,8.3135E-01_JPRB,1.0462E+00_JPRB,1.1153E+00_JPRB/)
KBO( :, 5,17, 8) = (/&
&2.0977E-01_JPRB,2.0992E-01_JPRB,5.4408E-01_JPRB,8.2665E-01_JPRB,1.0353E+00_JPRB,1.1109E+00_JPRB/)
KBO( :, 1,18, 8) = (/&
&1.6037E-01_JPRB,1.6054E-01_JPRB,5.2354E-01_JPRB,8.0743E-01_JPRB,1.0214E+00_JPRB,1.0665E+00_JPRB/)
KBO( :, 2,18, 8) = (/&
&1.6652E-01_JPRB,1.6669E-01_JPRB,5.2468E-01_JPRB,8.0676E-01_JPRB,1.0196E+00_JPRB,1.0692E+00_JPRB/)
KBO( :, 3,18, 8) = (/&
&1.7290E-01_JPRB,1.7307E-01_JPRB,5.2655E-01_JPRB,8.0477E-01_JPRB,1.0147E+00_JPRB,1.0691E+00_JPRB/)
KBO( :, 4,18, 8) = (/&
&1.7934E-01_JPRB,1.7951E-01_JPRB,5.2943E-01_JPRB,8.0251E-01_JPRB,1.0069E+00_JPRB,1.0675E+00_JPRB/)
KBO( :, 5,18, 8) = (/&
&1.8580E-01_JPRB,1.8596E-01_JPRB,5.3218E-01_JPRB,7.9996E-01_JPRB,9.9675E-01_JPRB,1.0641E+00_JPRB/)
KBO( :, 1,19, 8) = (/&
&1.4147E-01_JPRB,1.4165E-01_JPRB,4.9931E-01_JPRB,7.6579E-01_JPRB,9.6706E-01_JPRB,1.0036E+00_JPRB/)
KBO( :, 2,19, 8) = (/&
&1.4680E-01_JPRB,1.4699E-01_JPRB,5.0235E-01_JPRB,7.6624E-01_JPRB,9.6598E-01_JPRB,1.0066E+00_JPRB/)
KBO( :, 3,19, 8) = (/&
&1.5225E-01_JPRB,1.5244E-01_JPRB,5.0654E-01_JPRB,7.6618E-01_JPRB,9.6124E-01_JPRB,1.0077E+00_JPRB/)
KBO( :, 4,19, 8) = (/&
&1.5772E-01_JPRB,1.5791E-01_JPRB,5.1074E-01_JPRB,7.6598E-01_JPRB,9.5363E-01_JPRB,1.0072E+00_JPRB/)
KBO( :, 5,19, 8) = (/&
&1.6330E-01_JPRB,1.6348E-01_JPRB,5.1433E-01_JPRB,7.6482E-01_JPRB,9.4459E-01_JPRB,1.0048E+00_JPRB/)
KBO( :, 1,20, 8) = (/&
&1.2415E-01_JPRB,1.2435E-01_JPRB,4.7152E-01_JPRB,7.1700E-01_JPRB,9.0180E-01_JPRB,9.3194E-01_JPRB/)
KBO( :, 2,20, 8) = (/&
&1.2873E-01_JPRB,1.2894E-01_JPRB,4.7682E-01_JPRB,7.1874E-01_JPRB,9.0028E-01_JPRB,9.3593E-01_JPRB/)
KBO( :, 3,20, 8) = (/&
&1.3332E-01_JPRB,1.3352E-01_JPRB,4.8227E-01_JPRB,7.2020E-01_JPRB,8.9592E-01_JPRB,9.3812E-01_JPRB/)
KBO( :, 4,20, 8) = (/&
&1.3806E-01_JPRB,1.3826E-01_JPRB,4.8689E-01_JPRB,7.2110E-01_JPRB,8.9003E-01_JPRB,9.3865E-01_JPRB/)
KBO( :, 5,20, 8) = (/&
&1.4304E-01_JPRB,1.4323E-01_JPRB,4.9097E-01_JPRB,7.2157E-01_JPRB,8.8366E-01_JPRB,9.3774E-01_JPRB/)
KBO( :, 1,21, 8) = (/&
&1.0824E-01_JPRB,1.0845E-01_JPRB,4.4084E-01_JPRB,6.6237E-01_JPRB,8.2840E-01_JPRB,8.5416E-01_JPRB/)
KBO( :, 2,21, 8) = (/&
&1.1215E-01_JPRB,1.1237E-01_JPRB,4.4741E-01_JPRB,6.6560E-01_JPRB,8.2721E-01_JPRB,8.5880E-01_JPRB/)
KBO( :, 3,21, 8) = (/&
&1.1610E-01_JPRB,1.1631E-01_JPRB,4.5328E-01_JPRB,6.6844E-01_JPRB,8.2433E-01_JPRB,8.6217E-01_JPRB/)
KBO( :, 4,21, 8) = (/&
&1.2031E-01_JPRB,1.2052E-01_JPRB,4.5831E-01_JPRB,6.7112E-01_JPRB,8.2101E-01_JPRB,8.6470E-01_JPRB/)
KBO( :, 5,21, 8) = (/&
&1.2513E-01_JPRB,1.2535E-01_JPRB,4.6228E-01_JPRB,6.7321E-01_JPRB,8.1773E-01_JPRB,8.6681E-01_JPRB/)
KBO( :, 1,22, 8) = (/&
&9.4136E-02_JPRB,9.4356E-02_JPRB,4.0812E-01_JPRB,6.0557E-01_JPRB,7.5102E-01_JPRB,7.7334E-01_JPRB/)
KBO( :, 2,22, 8) = (/&
&9.7453E-02_JPRB,9.7680E-02_JPRB,4.1479E-01_JPRB,6.0994E-01_JPRB,7.5090E-01_JPRB,7.7909E-01_JPRB/)
KBO( :, 3,22, 8) = (/&
&1.0097E-01_JPRB,1.0120E-01_JPRB,4.2075E-01_JPRB,6.1446E-01_JPRB,7.5039E-01_JPRB,7.8458E-01_JPRB/)
KBO( :, 4,22, 8) = (/&
&1.0505E-01_JPRB,1.0527E-01_JPRB,4.2583E-01_JPRB,6.1845E-01_JPRB,7.5036E-01_JPRB,7.8977E-01_JPRB/)
KBO( :, 5,22, 8) = (/&
&1.0993E-01_JPRB,1.1016E-01_JPRB,4.2991E-01_JPRB,6.2156E-01_JPRB,7.5073E-01_JPRB,7.9510E-01_JPRB/)
KBO( :, 1,23, 8) = (/&
&8.1349E-02_JPRB,8.1584E-02_JPRB,3.7354E-01_JPRB,5.4796E-01_JPRB,6.7356E-01_JPRB,6.9291E-01_JPRB/)
KBO( :, 2,23, 8) = (/&
&8.4276E-02_JPRB,8.4510E-02_JPRB,3.8021E-01_JPRB,5.5386E-01_JPRB,6.7570E-01_JPRB,7.0065E-01_JPRB/)
KBO( :, 3,23, 8) = (/&
&8.7640E-02_JPRB,8.7874E-02_JPRB,3.8598E-01_JPRB,5.5948E-01_JPRB,6.7838E-01_JPRB,7.0844E-01_JPRB/)
KBO( :, 4,23, 8) = (/&
&9.1780E-02_JPRB,9.2021E-02_JPRB,3.9102E-01_JPRB,5.6473E-01_JPRB,6.8175E-01_JPRB,7.1651E-01_JPRB/)
KBO( :, 5,23, 8) = (/&
&9.6686E-02_JPRB,9.6939E-02_JPRB,3.9533E-01_JPRB,5.6950E-01_JPRB,6.8602E-01_JPRB,7.2456E-01_JPRB/)
KBO( :, 1,24, 8) = (/&
&6.9990E-02_JPRB,7.0237E-02_JPRB,3.3858E-01_JPRB,4.9217E-01_JPRB,5.9977E-01_JPRB,6.1602E-01_JPRB/)
KBO( :, 2,24, 8) = (/&
&7.2713E-02_JPRB,7.2959E-02_JPRB,3.4483E-01_JPRB,4.9901E-01_JPRB,6.0467E-01_JPRB,6.2572E-01_JPRB/)
KBO( :, 3,24, 8) = (/&
&7.6092E-02_JPRB,7.6339E-02_JPRB,3.5052E-01_JPRB,5.0586E-01_JPRB,6.1039E-01_JPRB,6.3593E-01_JPRB/)
KBO( :, 4,24, 8) = (/&
&8.0272E-02_JPRB,8.0531E-02_JPRB,3.5585E-01_JPRB,5.1250E-01_JPRB,6.1729E-01_JPRB,6.4602E-01_JPRB/)
KBO( :, 5,24, 8) = (/&
&8.5043E-02_JPRB,8.5307E-02_JPRB,3.6095E-01_JPRB,5.1914E-01_JPRB,6.2467E-01_JPRB,6.5479E-01_JPRB/)
KBO( :, 1,25, 8) = (/&
&6.0058E-02_JPRB,6.0325E-02_JPRB,3.0404E-01_JPRB,4.3931E-01_JPRB,5.3180E-01_JPRB,5.4488E-01_JPRB/)
KBO( :, 2,25, 8) = (/&
&6.2808E-02_JPRB,6.3070E-02_JPRB,3.1019E-01_JPRB,4.4720E-01_JPRB,5.3927E-01_JPRB,5.5647E-01_JPRB/)
KBO( :, 3,25, 8) = (/&
&6.6253E-02_JPRB,6.6517E-02_JPRB,3.1620E-01_JPRB,4.5515E-01_JPRB,5.4804E-01_JPRB,5.6793E-01_JPRB/)
KBO( :, 4,25, 8) = (/&
&7.0286E-02_JPRB,7.0564E-02_JPRB,3.2210E-01_JPRB,4.6317E-01_JPRB,5.5729E-01_JPRB,5.7748E-01_JPRB/)
KBO( :, 5,25, 8) = (/&
&7.4631E-02_JPRB,7.4904E-02_JPRB,3.2818E-01_JPRB,4.7084E-01_JPRB,5.6535E-01_JPRB,5.8428E-01_JPRB/)
KBO( :, 1,26, 8) = (/&
&5.1659E-02_JPRB,5.1968E-02_JPRB,2.7136E-01_JPRB,3.9044E-01_JPRB,4.7061E-01_JPRB,4.8066E-01_JPRB/)
KBO( :, 2,26, 8) = (/&
&5.4454E-02_JPRB,5.4749E-02_JPRB,2.7780E-01_JPRB,3.9925E-01_JPRB,4.8060E-01_JPRB,4.9280E-01_JPRB/)
KBO( :, 3,26, 8) = (/&
&5.7864E-02_JPRB,5.8160E-02_JPRB,2.8427E-01_JPRB,4.0818E-01_JPRB,4.9092E-01_JPRB,5.0289E-01_JPRB/)
KBO( :, 4,26, 8) = (/&
&6.1551E-02_JPRB,6.1849E-02_JPRB,2.9095E-01_JPRB,4.1685E-01_JPRB,4.9998E-01_JPRB,5.1033E-01_JPRB/)
KBO( :, 5,26, 8) = (/&
&6.5434E-02_JPRB,6.5724E-02_JPRB,2.9806E-01_JPRB,4.2453E-01_JPRB,5.0716E-01_JPRB,5.1469E-01_JPRB/)
KBO( :, 1,27, 8) = (/&
&4.4574E-02_JPRB,4.4959E-02_JPRB,2.4126E-01_JPRB,3.4609E-01_JPRB,4.1629E-01_JPRB,4.2248E-01_JPRB/)
KBO( :, 2,27, 8) = (/&
&4.7372E-02_JPRB,4.7727E-02_JPRB,2.4803E-01_JPRB,3.5548E-01_JPRB,4.2721E-01_JPRB,4.3291E-01_JPRB/)
KBO( :, 3,27, 8) = (/&
&5.0509E-02_JPRB,5.0855E-02_JPRB,2.5505E-01_JPRB,3.6464E-01_JPRB,4.3687E-01_JPRB,4.4067E-01_JPRB/)
KBO( :, 4,27, 8) = (/&
&5.3857E-02_JPRB,5.4187E-02_JPRB,2.6242E-01_JPRB,3.7281E-01_JPRB,4.4478E-01_JPRB,4.4531E-01_JPRB/)
KBO( :, 5,27, 8) = (/&
&5.7275E-02_JPRB,5.7589E-02_JPRB,2.7029E-01_JPRB,3.7997E-01_JPRB,4.5055E-01_JPRB,4.4651E-01_JPRB/)
KBO( :, 1,28, 8) = (/&
&3.8595E-02_JPRB,3.9083E-02_JPRB,2.1409E-01_JPRB,3.0626E-01_JPRB,3.6758E-01_JPRB,3.6870E-01_JPRB/)
KBO( :, 2,28, 8) = (/&
&4.1250E-02_JPRB,4.1701E-02_JPRB,2.2115E-01_JPRB,3.1552E-01_JPRB,3.7756E-01_JPRB,3.7664E-01_JPRB/)
KBO( :, 3,28, 8) = (/&
&4.4090E-02_JPRB,4.4510E-02_JPRB,2.2858E-01_JPRB,3.2391E-01_JPRB,3.8579E-01_JPRB,3.8144E-01_JPRB/)
KBO( :, 4,28, 8) = (/&
&4.7006E-02_JPRB,4.7391E-02_JPRB,2.3638E-01_JPRB,3.3136E-01_JPRB,3.9193E-01_JPRB,3.8299E-01_JPRB/)
KBO( :, 5,28, 8) = (/&
&5.0054E-02_JPRB,5.0402E-02_JPRB,2.4452E-01_JPRB,3.3791E-01_JPRB,3.9580E-01_JPRB,3.8186E-01_JPRB/)
KBO( :, 1,29, 8) = (/&
&3.3476E-02_JPRB,3.4098E-02_JPRB,1.8985E-01_JPRB,2.7044E-01_JPRB,3.2310E-01_JPRB,3.1910E-01_JPRB/)
KBO( :, 2,29, 8) = (/&
&3.5905E-02_JPRB,3.6473E-02_JPRB,1.9710E-01_JPRB,2.7881E-01_JPRB,3.3147E-01_JPRB,3.2409E-01_JPRB/)
KBO( :, 3,29, 8) = (/&
&3.8420E-02_JPRB,3.8933E-02_JPRB,2.0468E-01_JPRB,2.8629E-01_JPRB,3.3775E-01_JPRB,3.2611E-01_JPRB/)
KBO( :, 4,29, 8) = (/&
&4.1043E-02_JPRB,4.1502E-02_JPRB,2.1261E-01_JPRB,2.9284E-01_JPRB,3.4187E-01_JPRB,3.2584E-01_JPRB/)
KBO( :, 5,29, 8) = (/&
&4.3764E-02_JPRB,4.4163E-02_JPRB,2.2069E-01_JPRB,2.9879E-01_JPRB,3.4414E-01_JPRB,3.2382E-01_JPRB/)
KBO( :, 1,30, 8) = (/&
&2.9059E-02_JPRB,2.9833E-02_JPRB,1.6831E-01_JPRB,2.3789E-01_JPRB,2.8228E-01_JPRB,2.7330E-01_JPRB/)
KBO( :, 2,30, 8) = (/&
&3.1236E-02_JPRB,3.1934E-02_JPRB,1.7554E-01_JPRB,2.4524E-01_JPRB,2.8861E-01_JPRB,2.7583E-01_JPRB/)
KBO( :, 3,30, 8) = (/&
&3.3473E-02_JPRB,3.4095E-02_JPRB,1.8314E-01_JPRB,2.5166E-01_JPRB,2.9297E-01_JPRB,2.7628E-01_JPRB/)
KBO( :, 4,30, 8) = (/&
&3.5829E-02_JPRB,3.6370E-02_JPRB,1.9099E-01_JPRB,2.5743E-01_JPRB,2.9573E-01_JPRB,2.7526E-01_JPRB/)
KBO( :, 5,30, 8) = (/&
&3.8342E-02_JPRB,3.8806E-02_JPRB,1.9889E-01_JPRB,2.6291E-01_JPRB,2.9753E-01_JPRB,2.7308E-01_JPRB/)
KBO( :, 1,31, 8) = (/&
&2.5215E-02_JPRB,2.6144E-02_JPRB,1.4919E-01_JPRB,2.0841E-01_JPRB,2.4479E-01_JPRB,2.3198E-01_JPRB/)
KBO( :, 2,31, 8) = (/&
&2.7144E-02_JPRB,2.7979E-02_JPRB,1.5634E-01_JPRB,2.1462E-01_JPRB,2.4940E-01_JPRB,2.3311E-01_JPRB/)
KBO( :, 3,31, 8) = (/&
&2.9169E-02_JPRB,2.9907E-02_JPRB,1.6380E-01_JPRB,2.2020E-01_JPRB,2.5250E-01_JPRB,2.3291E-01_JPRB/)
KBO( :, 4,31, 8) = (/&
&3.1339E-02_JPRB,3.1975E-02_JPRB,1.7145E-01_JPRB,2.2560E-01_JPRB,2.5484E-01_JPRB,2.3169E-01_JPRB/)
KBO( :, 5,31, 8) = (/&
&3.3710E-02_JPRB,3.4248E-02_JPRB,1.7897E-01_JPRB,2.3122E-01_JPRB,2.5681E-01_JPRB,2.2968E-01_JPRB/)
KBO( :, 1,32, 8) = (/&
&2.1908E-02_JPRB,2.2988E-02_JPRB,1.3234E-01_JPRB,1.8179E-01_JPRB,2.1098E-01_JPRB,1.9567E-01_JPRB/)
KBO( :, 2,32, 8) = (/&
&2.3644E-02_JPRB,2.4617E-02_JPRB,1.3932E-01_JPRB,1.8712E-01_JPRB,2.1438E-01_JPRB,1.9614E-01_JPRB/)
KBO( :, 3,32, 8) = (/&
&2.5493E-02_JPRB,2.6345E-02_JPRB,1.4655E-01_JPRB,1.9237E-01_JPRB,2.1705E-01_JPRB,1.9570E-01_JPRB/)
KBO( :, 4,32, 8) = (/&
&2.7518E-02_JPRB,2.8252E-02_JPRB,1.5380E-01_JPRB,1.9790E-01_JPRB,2.1948E-01_JPRB,1.9455E-01_JPRB/)
KBO( :, 5,32, 8) = (/&
&2.9773E-02_JPRB,3.0387E-02_JPRB,1.6098E-01_JPRB,2.0383E-01_JPRB,2.2190E-01_JPRB,1.9286E-01_JPRB/)
KBO( :, 1,33, 8) = (/&
&1.9045E-02_JPRB,2.0261E-02_JPRB,1.1752E-01_JPRB,1.5812E-01_JPRB,1.8110E-01_JPRB,1.6448E-01_JPRB/)
KBO( :, 2,33, 8) = (/&
&2.0626E-02_JPRB,2.1724E-02_JPRB,1.2423E-01_JPRB,1.6307E-01_JPRB,1.8397E-01_JPRB,1.6464E-01_JPRB/)
KBO( :, 3,33, 8) = (/&
&2.2336E-02_JPRB,2.3302E-02_JPRB,1.3114E-01_JPRB,1.6839E-01_JPRB,1.8664E-01_JPRB,1.6418E-01_JPRB/)
KBO( :, 4,33, 8) = (/&
&2.4266E-02_JPRB,2.5093E-02_JPRB,1.3811E-01_JPRB,1.7421E-01_JPRB,1.8938E-01_JPRB,1.6325E-01_JPRB/)
KBO( :, 5,33, 8) = (/&
&2.6466E-02_JPRB,2.7164E-02_JPRB,1.4513E-01_JPRB,1.8048E-01_JPRB,1.9238E-01_JPRB,1.6211E-01_JPRB/)
KBO( :, 1,34, 8) = (/&
&1.6556E-02_JPRB,1.7892E-02_JPRB,1.0429E-01_JPRB,1.3736E-01_JPRB,1.5516E-01_JPRB,1.3789E-01_JPRB/)
KBO( :, 2,34, 8) = (/&
&1.7996E-02_JPRB,1.9210E-02_JPRB,1.1072E-01_JPRB,1.4236E-01_JPRB,1.5794E-01_JPRB,1.3797E-01_JPRB/)
KBO( :, 3,34, 8) = (/&
&1.9608E-02_JPRB,2.0681E-02_JPRB,1.1739E-01_JPRB,1.4788E-01_JPRB,1.6081E-01_JPRB,1.3764E-01_JPRB/)
KBO( :, 4,34, 8) = (/&
&2.1464E-02_JPRB,2.2387E-02_JPRB,1.2421E-01_JPRB,1.5396E-01_JPRB,1.6395E-01_JPRB,1.3706E-01_JPRB/)
KBO( :, 5,34, 8) = (/&
&2.3594E-02_JPRB,2.4379E-02_JPRB,1.3126E-01_JPRB,1.6048E-01_JPRB,1.6756E-01_JPRB,1.3645E-01_JPRB/)
KBO( :, 1,35, 8) = (/&
&1.4319E-02_JPRB,1.5758E-02_JPRB,9.2204E-02_JPRB,1.1925E-01_JPRB,1.3286E-01_JPRB,1.1548E-01_JPRB/)
KBO( :, 2,35, 8) = (/&
&1.5652E-02_JPRB,1.6978E-02_JPRB,9.8399E-02_JPRB,1.2433E-01_JPRB,1.3567E-01_JPRB,1.1564E-01_JPRB/)
KBO( :, 3,35, 8) = (/&
&1.7169E-02_JPRB,1.8350E-02_JPRB,1.0487E-01_JPRB,1.3003E-01_JPRB,1.3879E-01_JPRB,1.1554E-01_JPRB/)
KBO( :, 4,35, 8) = (/&
&1.8944E-02_JPRB,1.9975E-02_JPRB,1.1167E-01_JPRB,1.3629E-01_JPRB,1.4236E-01_JPRB,1.1534E-01_JPRB/)
KBO( :, 5,35, 8) = (/&
&2.0938E-02_JPRB,2.1824E-02_JPRB,1.1877E-01_JPRB,1.4294E-01_JPRB,1.4651E-01_JPRB,1.1522E-01_JPRB/)
KBO( :, 1,36, 8) = (/&
&1.2304E-02_JPRB,1.3829E-02_JPRB,8.1120E-02_JPRB,1.0334E-01_JPRB,1.1366E-01_JPRB,9.6686E-02_JPRB/)
KBO( :, 2,36, 8) = (/&
&1.3517E-02_JPRB,1.4942E-02_JPRB,8.7082E-02_JPRB,1.0850E-01_JPRB,1.1660E-01_JPRB,9.6981E-02_JPRB/)
KBO( :, 3,36, 8) = (/&
&1.4939E-02_JPRB,1.6232E-02_JPRB,9.3439E-02_JPRB,1.1431E-01_JPRB,1.1995E-01_JPRB,9.7085E-02_JPRB/)
KBO( :, 4,36, 8) = (/&
&1.6604E-02_JPRB,1.7754E-02_JPRB,1.0020E-01_JPRB,1.2061E-01_JPRB,1.2384E-01_JPRB,9.7245E-02_JPRB/)
KBO( :, 5,36, 8) = (/&
&1.8458E-02_JPRB,1.9458E-02_JPRB,1.0732E-01_JPRB,1.2741E-01_JPRB,1.2840E-01_JPRB,9.7611E-02_JPRB/)
KBO( :, 1,37, 8) = (/&
&1.0441E-02_JPRB,1.2037E-02_JPRB,7.0733E-02_JPRB,8.9104E-02_JPRB,9.7006E-02_JPRB,8.0853E-02_JPRB/)
KBO( :, 2,37, 8) = (/&
&1.1538E-02_JPRB,1.3055E-02_JPRB,7.6444E-02_JPRB,9.4227E-02_JPRB,1.0002E-01_JPRB,8.1261E-02_JPRB/)
KBO( :, 3,37, 8) = (/&
&1.2840E-02_JPRB,1.4247E-02_JPRB,8.2653E-02_JPRB,9.9992E-02_JPRB,1.0351E-01_JPRB,8.1587E-02_JPRB/)
KBO( :, 4,37, 8) = (/&
&1.4355E-02_JPRB,1.5634E-02_JPRB,8.9312E-02_JPRB,1.0629E-01_JPRB,1.0761E-01_JPRB,8.2022E-02_JPRB/)
KBO( :, 5,37, 8) = (/&
&1.6059E-02_JPRB,1.7188E-02_JPRB,9.6394E-02_JPRB,1.1316E-01_JPRB,1.1240E-01_JPRB,8.2731E-02_JPRB/)
KBO( :, 1,38, 8) = (/&
&8.8645E-03_JPRB,1.0501E-02_JPRB,6.1698E-02_JPRB,7.6908E-02_JPRB,8.2883E-02_JPRB,6.7642E-02_JPRB/)
KBO( :, 2,38, 8) = (/&
&9.8554E-03_JPRB,1.1441E-02_JPRB,6.7213E-02_JPRB,8.1954E-02_JPRB,8.5931E-02_JPRB,6.8150E-02_JPRB/)
KBO( :, 3,38, 8) = (/&
&1.1041E-02_JPRB,1.2540E-02_JPRB,7.3258E-02_JPRB,8.7642E-02_JPRB,8.9506E-02_JPRB,6.8667E-02_JPRB/)
KBO( :, 4,38, 8) = (/&
&1.2430E-02_JPRB,1.3817E-02_JPRB,7.9801E-02_JPRB,9.3936E-02_JPRB,9.3782E-02_JPRB,6.9339E-02_JPRB/)
KBO( :, 5,38, 8) = (/&
&1.3983E-02_JPRB,1.5235E-02_JPRB,8.6814E-02_JPRB,1.0083E-01_JPRB,9.8742E-02_JPRB,7.0319E-02_JPRB/)
KBO( :, 1,39, 8) = (/&
&7.5404E-03_JPRB,9.1874E-03_JPRB,5.3906E-02_JPRB,6.6495E-02_JPRB,7.0902E-02_JPRB,5.6657E-02_JPRB/)
KBO( :, 2,39, 8) = (/&
&8.4340E-03_JPRB,1.0061E-02_JPRB,5.9245E-02_JPRB,7.1435E-02_JPRB,7.3979E-02_JPRB,5.7261E-02_JPRB/)
KBO( :, 3,39, 8) = (/&
&9.5242E-03_JPRB,1.1089E-02_JPRB,6.5132E-02_JPRB,7.7048E-02_JPRB,7.7636E-02_JPRB,5.7943E-02_JPRB/)
KBO( :, 4,39, 8) = (/&
&1.0781E-02_JPRB,1.2259E-02_JPRB,7.1549E-02_JPRB,8.3326E-02_JPRB,8.2004E-02_JPRB,5.8823E-02_JPRB/)
KBO( :, 5,39, 8) = (/&
&1.2213E-02_JPRB,1.3570E-02_JPRB,7.8488E-02_JPRB,9.0234E-02_JPRB,8.7139E-02_JPRB,6.0045E-02_JPRB/)
KBO( :, 1,40, 8) = (/&
&6.3480E-03_JPRB,7.9841E-03_JPRB,4.6707E-02_JPRB,5.7154E-02_JPRB,6.0478E-02_JPRB,4.7309E-02_JPRB/)
KBO( :, 2,40, 8) = (/&
&7.1416E-03_JPRB,8.7876E-03_JPRB,5.1799E-02_JPRB,6.1892E-02_JPRB,6.3504E-02_JPRB,4.7969E-02_JPRB/)
KBO( :, 3,40, 8) = (/&
&8.1113E-03_JPRB,9.7274E-03_JPRB,5.7484E-02_JPRB,6.7350E-02_JPRB,6.7140E-02_JPRB,4.8718E-02_JPRB/)
KBO( :, 4,40, 8) = (/&
&9.2465E-03_JPRB,1.0801E-02_JPRB,6.3707E-02_JPRB,7.3511E-02_JPRB,7.1497E-02_JPRB,4.9676E-02_JPRB/)
KBO( :, 5,40, 8) = (/&
&1.0544E-02_JPRB,1.2001E-02_JPRB,7.0505E-02_JPRB,8.0368E-02_JPRB,7.6674E-02_JPRB,5.0981E-02_JPRB/)
KBO( :, 1,41, 8) = (/&
&5.3391E-03_JPRB,6.9383E-03_JPRB,4.0421E-02_JPRB,4.9104E-02_JPRB,5.1567E-02_JPRB,3.9495E-02_JPRB/)
KBO( :, 2,41, 8) = (/&
&6.0420E-03_JPRB,7.6785E-03_JPRB,4.5260E-02_JPRB,5.3617E-02_JPRB,5.4523E-02_JPRB,4.0174E-02_JPRB/)
KBO( :, 3,41, 8) = (/&
&6.9017E-03_JPRB,8.5389E-03_JPRB,5.0726E-02_JPRB,5.8886E-02_JPRB,5.8106E-02_JPRB,4.0950E-02_JPRB/)
KBO( :, 4,41, 8) = (/&
&7.9215E-03_JPRB,9.5281E-03_JPRB,5.6758E-02_JPRB,6.4894E-02_JPRB,6.2425E-02_JPRB,4.1953E-02_JPRB/)
KBO( :, 5,41, 8) = (/&
&9.0958E-03_JPRB,1.0632E-02_JPRB,6.3380E-02_JPRB,7.1665E-02_JPRB,6.7575E-02_JPRB,4.3294E-02_JPRB/)
KBO( :, 1,42, 8) = (/&
&4.4874E-03_JPRB,6.0277E-03_JPRB,3.4973E-02_JPRB,4.2181E-02_JPRB,4.3972E-02_JPRB,3.2976E-02_JPRB/)
KBO( :, 2,42, 8) = (/&
&5.1084E-03_JPRB,6.7117E-03_JPRB,3.9569E-02_JPRB,4.6481E-02_JPRB,4.6838E-02_JPRB,3.3656E-02_JPRB/)
KBO( :, 3,42, 8) = (/&
&5.8774E-03_JPRB,7.5092E-03_JPRB,4.4793E-02_JPRB,5.1534E-02_JPRB,5.0349E-02_JPRB,3.4440E-02_JPRB/)
KBO( :, 4,42, 8) = (/&
&6.7906E-03_JPRB,8.4227E-03_JPRB,5.0631E-02_JPRB,5.7384E-02_JPRB,5.4620E-02_JPRB,3.5462E-02_JPRB/)
KBO( :, 5,42, 8) = (/&
&7.8525E-03_JPRB,9.4467E-03_JPRB,5.7082E-02_JPRB,6.4044E-02_JPRB,5.9718E-02_JPRB,3.6824E-02_JPRB/)
KBO( :, 1,43, 8) = (/&
&3.7422E-03_JPRB,5.2033E-03_JPRB,3.0024E-02_JPRB,3.6022E-02_JPRB,3.7358E-02_JPRB,2.7486E-02_JPRB/)
KBO( :, 2,43, 8) = (/&
&4.2855E-03_JPRB,5.8316E-03_JPRB,3.4344E-02_JPRB,4.0070E-02_JPRB,4.0089E-02_JPRB,2.8154E-02_JPRB/)
KBO( :, 3,43, 8) = (/&
&4.9638E-03_JPRB,6.5666E-03_JPRB,3.9296E-02_JPRB,4.4870E-02_JPRB,4.3472E-02_JPRB,2.8929E-02_JPRB/)
KBO( :, 4,43, 8) = (/&
&5.7736E-03_JPRB,7.4071E-03_JPRB,4.4883E-02_JPRB,5.0478E-02_JPRB,4.7614E-02_JPRB,2.9920E-02_JPRB/)
KBO( :, 5,43, 8) = (/&
&6.7269E-03_JPRB,8.3547E-03_JPRB,5.1126E-02_JPRB,5.6946E-02_JPRB,5.2603E-02_JPRB,3.1259E-02_JPRB/)
KBO( :, 1,44, 8) = (/&
&3.1123E-03_JPRB,4.4787E-03_JPRB,2.5629E-02_JPRB,3.0645E-02_JPRB,3.1662E-02_JPRB,2.2891E-02_JPRB/)
KBO( :, 2,44, 8) = (/&
&3.5819E-03_JPRB,5.0510E-03_JPRB,2.9662E-02_JPRB,3.4404E-02_JPRB,3.4213E-02_JPRB,2.3525E-02_JPRB/)
KBO( :, 3,44, 8) = (/&
&4.1717E-03_JPRB,5.7219E-03_JPRB,3.4337E-02_JPRB,3.8941E-02_JPRB,3.7437E-02_JPRB,2.4274E-02_JPRB/)
KBO( :, 4,44, 8) = (/&
&4.8874E-03_JPRB,6.4997E-03_JPRB,3.9651E-02_JPRB,4.4278E-02_JPRB,4.1431E-02_JPRB,2.5229E-02_JPRB/)
KBO( :, 5,44, 8) = (/&
&5.7377E-03_JPRB,7.3726E-03_JPRB,4.5649E-02_JPRB,5.0511E-02_JPRB,4.6265E-02_JPRB,2.6526E-02_JPRB/)
KBO( :, 1,45, 8) = (/&
&2.5853E-03_JPRB,3.8513E-03_JPRB,2.1823E-02_JPRB,2.6026E-02_JPRB,2.6804E-02_JPRB,1.9058E-02_JPRB/)
KBO( :, 2,45, 8) = (/&
&2.9888E-03_JPRB,4.3719E-03_JPRB,2.5563E-02_JPRB,2.9502E-02_JPRB,2.9182E-02_JPRB,1.9668E-02_JPRB/)
KBO( :, 3,45, 8) = (/&
&3.5037E-03_JPRB,4.9832E-03_JPRB,2.9957E-02_JPRB,3.3763E-02_JPRB,3.2213E-02_JPRB,2.0379E-02_JPRB/)
KBO( :, 4,45, 8) = (/&
&4.1322E-03_JPRB,5.6995E-03_JPRB,3.5000E-02_JPRB,3.8824E-02_JPRB,3.6032E-02_JPRB,2.1286E-02_JPRB/)
KBO( :, 5,45, 8) = (/&
&4.8892E-03_JPRB,6.5060E-03_JPRB,4.0741E-02_JPRB,4.4793E-02_JPRB,4.0699E-02_JPRB,2.2533E-02_JPRB/)
KBO( :, 1,46, 8) = (/&
&2.1331E-03_JPRB,3.2909E-03_JPRB,1.8461E-02_JPRB,2.1996E-02_JPRB,2.2623E-02_JPRB,1.5851E-02_JPRB/)
KBO( :, 2,46, 8) = (/&
&2.4815E-03_JPRB,3.7686E-03_JPRB,2.1893E-02_JPRB,2.5181E-02_JPRB,2.4805E-02_JPRB,1.6418E-02_JPRB/)
KBO( :, 3,46, 8) = (/&
&2.9255E-03_JPRB,4.3224E-03_JPRB,2.5992E-02_JPRB,2.9135E-02_JPRB,2.7620E-02_JPRB,1.7082E-02_JPRB/)
KBO( :, 4,46, 8) = (/&
&3.4773E-03_JPRB,4.9794E-03_JPRB,3.0754E-02_JPRB,3.3905E-02_JPRB,3.1233E-02_JPRB,1.7942E-02_JPRB/)
KBO( :, 5,46, 8) = (/&
&4.1439E-03_JPRB,5.7240E-03_JPRB,3.6209E-02_JPRB,3.9579E-02_JPRB,3.5705E-02_JPRB,1.9124E-02_JPRB/)
KBO( :, 1,47, 8) = (/&
&1.7489E-03_JPRB,2.7917E-03_JPRB,1.5439E-02_JPRB,1.8422E-02_JPRB,1.8978E-02_JPRB,1.3134E-02_JPRB/)
KBO( :, 2,47, 8) = (/&
&2.0428E-03_JPRB,3.2234E-03_JPRB,1.8541E-02_JPRB,2.1302E-02_JPRB,2.0952E-02_JPRB,1.3661E-02_JPRB/)
KBO( :, 3,47, 8) = (/&
&2.4192E-03_JPRB,3.7223E-03_JPRB,2.2314E-02_JPRB,2.4927E-02_JPRB,2.3525E-02_JPRB,1.4273E-02_JPRB/)
KBO( :, 4,47, 8) = (/&
&2.8969E-03_JPRB,4.3171E-03_JPRB,2.6764E-02_JPRB,2.9356E-02_JPRB,2.6874E-02_JPRB,1.5058E-02_JPRB/)
KBO( :, 5,47, 8) = (/&
&3.4807E-03_JPRB,5.0006E-03_JPRB,3.1906E-02_JPRB,3.4693E-02_JPRB,3.1094E-02_JPRB,1.6142E-02_JPRB/)
KBO( :, 1,48, 8) = (/&
&1.4327E-03_JPRB,2.3618E-03_JPRB,1.2851E-02_JPRB,1.5372E-02_JPRB,1.5885E-02_JPRB,1.0883E-02_JPRB/)
KBO( :, 2,48, 8) = (/&
&1.6785E-03_JPRB,2.7495E-03_JPRB,1.5626E-02_JPRB,1.7950E-02_JPRB,1.7654E-02_JPRB,1.1366E-02_JPRB/)
KBO( :, 3,48, 8) = (/&
&1.9967E-03_JPRB,3.1986E-03_JPRB,1.9069E-02_JPRB,2.1252E-02_JPRB,1.9987E-02_JPRB,1.1922E-02_JPRB/)
KBO( :, 4,48, 8) = (/&
&2.4067E-03_JPRB,3.7350E-03_JPRB,2.3203E-02_JPRB,2.5339E-02_JPRB,2.3066E-02_JPRB,1.2640E-02_JPRB/)
KBO( :, 5,48, 8) = (/&
&2.9156E-03_JPRB,4.3597E-03_JPRB,2.8035E-02_JPRB,3.0335E-02_JPRB,2.7010E-02_JPRB,1.3635E-02_JPRB/)
KBO( :, 1,49, 8) = (/&
&1.1689E-03_JPRB,1.9883E-03_JPRB,1.0644E-02_JPRB,1.2774E-02_JPRB,1.3257E-02_JPRB,9.0102E-03_JPRB/)
KBO( :, 2,49, 8) = (/&
&1.3778E-03_JPRB,2.3380E-03_JPRB,1.3100E-02_JPRB,1.5054E-02_JPRB,1.4830E-02_JPRB,9.4528E-03_JPRB/)
KBO( :, 3,49, 8) = (/&
&1.6437E-03_JPRB,2.7417E-03_JPRB,1.6213E-02_JPRB,1.8042E-02_JPRB,1.6928E-02_JPRB,9.9612E-03_JPRB/)
KBO( :, 4,49, 8) = (/&
&1.9940E-03_JPRB,3.2236E-03_JPRB,2.0024E-02_JPRB,2.1800E-02_JPRB,1.9739E-02_JPRB,1.0620E-02_JPRB/)
KBO( :, 5,49, 8) = (/&
&2.4346E-03_JPRB,3.7942E-03_JPRB,2.4548E-02_JPRB,2.6440E-02_JPRB,2.3396E-02_JPRB,1.1534E-02_JPRB/)
KBO( :, 1,50, 8) = (/&
&9.5607E-04_JPRB,1.6753E-03_JPRB,8.8167E-03_JPRB,1.0612E-02_JPRB,1.1052E-02_JPRB,7.4373E-03_JPRB/)
KBO( :, 2,50, 8) = (/&
&1.1316E-03_JPRB,1.9897E-03_JPRB,1.0983E-02_JPRB,1.2621E-02_JPRB,1.2456E-02_JPRB,7.8368E-03_JPRB/)
KBO( :, 3,50, 8) = (/&
&1.3565E-03_JPRB,2.3537E-03_JPRB,1.3790E-02_JPRB,1.5320E-02_JPRB,1.4346E-02_JPRB,8.2918E-03_JPRB/)
KBO( :, 4,50, 8) = (/&
&1.6563E-03_JPRB,2.7888E-03_JPRB,1.7295E-02_JPRB,1.8780E-02_JPRB,1.6915E-02_JPRB,8.8832E-03_JPRB/)
KBO( :, 5,50, 8) = (/&
&2.0379E-03_JPRB,3.3085E-03_JPRB,2.1524E-02_JPRB,2.3092E-02_JPRB,2.0305E-02_JPRB,9.7144E-03_JPRB/)
KBO( :, 1,51, 8) = (/&
&7.8250E-04_JPRB,1.4092E-03_JPRB,7.2896E-03_JPRB,8.7965E-03_JPRB,9.1930E-03_JPRB,6.1252E-03_JPRB/)
KBO( :, 2,51, 8) = (/&
&9.2963E-04_JPRB,1.6917E-03_JPRB,9.1856E-03_JPRB,1.0556E-02_JPRB,1.0442E-02_JPRB,6.4818E-03_JPRB/)
KBO( :, 3,51, 8) = (/&
&1.1199E-03_JPRB,2.0205E-03_JPRB,1.1706E-02_JPRB,1.2981E-02_JPRB,1.2146E-02_JPRB,6.8899E-03_JPRB/)
KBO( :, 4,51, 8) = (/&
&1.3754E-03_JPRB,2.4116E-03_JPRB,1.4910E-02_JPRB,1.6157E-02_JPRB,1.4484E-02_JPRB,7.4151E-03_JPRB/)
KBO( :, 5,51, 8) = (/&
&1.7057E-03_JPRB,2.8850E-03_JPRB,1.8848E-02_JPRB,2.0162E-02_JPRB,1.7617E-02_JPRB,8.1571E-03_JPRB/)
KBO( :, 1,52, 8) = (/&
&6.3740E-04_JPRB,1.1795E-03_JPRB,6.0058E-03_JPRB,7.2694E-03_JPRB,7.6231E-03_JPRB,5.0413E-03_JPRB/)
KBO( :, 2,52, 8) = (/&
&7.6292E-04_JPRB,1.4345E-03_JPRB,7.6473E-03_JPRB,8.7976E-03_JPRB,8.7274E-03_JPRB,5.3621E-03_JPRB/)
KBO( :, 3,52, 8) = (/&
&9.2276E-04_JPRB,1.7301E-03_JPRB,9.8884E-03_JPRB,1.0949E-02_JPRB,1.0250E-02_JPRB,5.7262E-03_JPRB/)
KBO( :, 4,52, 8) = (/&
&1.1390E-03_JPRB,2.0817E-03_JPRB,1.2797E-02_JPRB,1.3842E-02_JPRB,1.2367E-02_JPRB,6.1911E-03_JPRB/)
KBO( :, 5,52, 8) = (/&
&1.4240E-03_JPRB,2.5099E-03_JPRB,1.6438E-02_JPRB,1.7549E-02_JPRB,1.5248E-02_JPRB,6.8528E-03_JPRB/)
KBO( :, 1,53, 8) = (/&
&5.1732E-04_JPRB,9.8178E-04_JPRB,4.9291E-03_JPRB,5.9861E-03_JPRB,6.3013E-03_JPRB,4.1478E-03_JPRB/)
KBO( :, 2,53, 8) = (/&
&6.2319E-04_JPRB,1.2101E-03_JPRB,6.3342E-03_JPRB,7.2982E-03_JPRB,7.2668E-03_JPRB,4.4355E-03_JPRB/)
KBO( :, 3,53, 8) = (/&
&7.5896E-04_JPRB,1.4772E-03_JPRB,8.3073E-03_JPRB,9.1884E-03_JPRB,8.6166E-03_JPRB,4.7615E-03_JPRB/)
KBO( :, 4,53, 8) = (/&
&9.4032E-04_JPRB,1.7923E-03_JPRB,1.0926E-02_JPRB,1.1795E-02_JPRB,1.0522E-02_JPRB,5.1760E-03_JPRB/)
KBO( :, 5,53, 8) = (/&
&1.1855E-03_JPRB,2.1779E-03_JPRB,1.4267E-02_JPRB,1.5211E-02_JPRB,1.3151E-02_JPRB,5.7675E-03_JPRB/)
KBO( :, 1,54, 8) = (/&
&4.2099E-04_JPRB,8.1896E-04_JPRB,4.0587E-03_JPRB,4.9414E-03_JPRB,5.2122E-03_JPRB,3.3954E-03_JPRB/)
KBO( :, 2,54, 8) = (/&
&5.1072E-04_JPRB,1.0232E-03_JPRB,5.2659E-03_JPRB,6.0692E-03_JPRB,6.0577E-03_JPRB,3.6461E-03_JPRB/)
KBO( :, 3,54, 8) = (/&
&6.2630E-04_JPRB,1.2640E-03_JPRB,7.0010E-03_JPRB,7.7316E-03_JPRB,7.2545E-03_JPRB,3.9269E-03_JPRB/)
KBO( :, 4,54, 8) = (/&
&7.8065E-04_JPRB,1.5498E-03_JPRB,9.3602E-03_JPRB,1.0080E-02_JPRB,8.9779E-03_JPRB,4.2798E-03_JPRB/)
KBO( :, 5,54, 8) = (/&
&9.9133E-04_JPRB,1.8976E-03_JPRB,1.2427E-02_JPRB,1.3231E-02_JPRB,1.1388E-02_JPRB,4.7881E-03_JPRB/)
KBO( :, 1,55, 8) = (/&
&3.4264E-04_JPRB,6.8196E-04_JPRB,3.3418E-03_JPRB,4.0786E-03_JPRB,4.3077E-03_JPRB,2.7691E-03_JPRB/)
KBO( :, 2,55, 8) = (/&
&4.1827E-04_JPRB,8.6407E-04_JPRB,4.3772E-03_JPRB,5.0438E-03_JPRB,5.0439E-03_JPRB,2.9836E-03_JPRB/)
KBO( :, 3,55, 8) = (/&
&5.1651E-04_JPRB,1.0809E-03_JPRB,5.8977E-03_JPRB,6.5003E-03_JPRB,6.1007E-03_JPRB,3.2208E-03_JPRB/)
KBO( :, 4,55, 8) = (/&
&6.4755E-04_JPRB,1.3394E-03_JPRB,8.0143E-03_JPRB,8.6084E-03_JPRB,7.6585E-03_JPRB,3.5143E-03_JPRB/)
KBO( :, 5,55, 8) = (/&
&8.2913E-04_JPRB,1.6553E-03_JPRB,1.0821E-02_JPRB,1.1504E-02_JPRB,9.8668E-03_JPRB,3.9383E-03_JPRB/)
KBO( :, 1,56, 8) = (/&
&2.7803E-04_JPRB,5.6487E-04_JPRB,2.7420E-03_JPRB,3.3568E-03_JPRB,3.5496E-03_JPRB,2.2543E-03_JPRB/)
KBO( :, 2,56, 8) = (/&
&3.4121E-04_JPRB,7.2622E-04_JPRB,3.6228E-03_JPRB,4.1781E-03_JPRB,4.1862E-03_JPRB,2.4382E-03_JPRB/)
KBO( :, 3,56, 8) = (/&
&4.2449E-04_JPRB,9.2149E-04_JPRB,4.9469E-03_JPRB,5.4413E-03_JPRB,5.1116E-03_JPRB,2.6387E-03_JPRB/)
KBO( :, 4,56, 8) = (/&
&5.3591E-04_JPRB,1.1547E-03_JPRB,6.8316E-03_JPRB,7.3206E-03_JPRB,6.5078E-03_JPRB,2.8830E-03_JPRB/)
KBO( :, 5,56, 8) = (/&
&6.9206E-04_JPRB,1.4413E-03_JPRB,9.3865E-03_JPRB,9.9613E-03_JPRB,8.5223E-03_JPRB,3.2344E-03_JPRB/)
KBO( :, 1,57, 8) = (/&
&2.2504E-04_JPRB,4.6500E-04_JPRB,2.2403E-03_JPRB,2.7543E-03_JPRB,2.9166E-03_JPRB,1.8323E-03_JPRB/)
KBO( :, 2,57, 8) = (/&
&2.7798E-04_JPRB,6.0783E-04_JPRB,2.9851E-03_JPRB,3.4491E-03_JPRB,3.4628E-03_JPRB,1.9897E-03_JPRB/)
KBO( :, 3,57, 8) = (/&
&3.4753E-04_JPRB,7.8225E-04_JPRB,4.1312E-03_JPRB,4.5352E-03_JPRB,4.2657E-03_JPRB,2.1593E-03_JPRB/)
KBO( :, 4,57, 8) = (/&
&4.4202E-04_JPRB,9.9272E-04_JPRB,5.7973E-03_JPRB,6.1951E-03_JPRB,5.5060E-03_JPRB,2.3628E-03_JPRB/)
KBO( :, 5,57, 8) = (/&
&5.7558E-04_JPRB,1.2517E-03_JPRB,8.1058E-03_JPRB,8.5872E-03_JPRB,7.3360E-03_JPRB,2.6522E-03_JPRB/)
KBO( :, 1,58, 8) = (/&
&1.8228E-04_JPRB,3.8208E-04_JPRB,1.8308E-03_JPRB,2.2613E-03_JPRB,2.3970E-03_JPRB,1.4881E-03_JPRB/)
KBO( :, 2,58, 8) = (/&
&2.2635E-04_JPRB,5.0773E-04_JPRB,2.4625E-03_JPRB,2.8501E-03_JPRB,2.8647E-03_JPRB,1.6219E-03_JPRB/)
KBO( :, 3,58, 8) = (/&
&2.8516E-04_JPRB,6.6412E-04_JPRB,3.4519E-03_JPRB,3.7830E-03_JPRB,3.5592E-03_JPRB,1.7642E-03_JPRB/)
KBO( :, 4,58, 8) = (/&
&3.6538E-04_JPRB,8.5444E-04_JPRB,4.9230E-03_JPRB,5.2451E-03_JPRB,4.6580E-03_JPRB,1.9336E-03_JPRB/)
KBO( :, 5,58, 8) = (/&
&4.7911E-04_JPRB,1.0886E-03_JPRB,7.0070E-03_JPRB,7.4069E-03_JPRB,6.3208E-03_JPRB,2.1715E-03_JPRB/)
KBO( :, 1,59, 8) = (/&
&1.5316E-04_JPRB,3.3009E-04_JPRB,1.5697E-03_JPRB,1.9267E-03_JPRB,2.0287E-03_JPRB,1.2203E-03_JPRB/)
KBO( :, 2,59, 8) = (/&
&1.9174E-04_JPRB,4.4479E-04_JPRB,2.1483E-03_JPRB,2.4646E-03_JPRB,2.4521E-03_JPRB,1.3301E-03_JPRB/)
KBO( :, 3,59, 8) = (/&
&2.4392E-04_JPRB,5.8967E-04_JPRB,3.0690E-03_JPRB,3.3341E-03_JPRB,3.1017E-03_JPRB,1.4481E-03_JPRB/)
KBO( :, 4,59, 8) = (/&
&3.1594E-04_JPRB,7.6769E-04_JPRB,4.4545E-03_JPRB,4.7180E-03_JPRB,4.1523E-03_JPRB,1.5884E-03_JPRB/)
KBO( :, 5,59, 8) = (/&
&4.1934E-04_JPRB,9.8859E-04_JPRB,6.4430E-03_JPRB,6.7951E-03_JPRB,5.7622E-03_JPRB,1.7867E-03_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB4_B2
