!OCL SCALAR
SUBROUTINE RRTM_KGB4_B1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 4:  630-700 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO4 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,FRACREFBO
USE YOERRTA4 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 6, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*H2O), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 1) = (/&
&1.0590E-03_JPRB,1.1708E-03_JPRB,6.1804E-03_JPRB,8.3851E-03_JPRB,9.8401E-03_JPRB,1.0650E-02_JPRB/)
KBO( :, 2,13, 1) = (/&
&1.2737E-03_JPRB,1.3921E-03_JPRB,6.7837E-03_JPRB,9.1802E-03_JPRB,1.0724E-02_JPRB,1.1694E-02_JPRB/)
KBO( :, 3,13, 1) = (/&
&1.4928E-03_JPRB,1.6167E-03_JPRB,7.3037E-03_JPRB,9.8097E-03_JPRB,1.1413E-02_JPRB,1.2559E-02_JPRB/)
KBO( :, 4,13, 1) = (/&
&1.7101E-03_JPRB,1.8380E-03_JPRB,7.7361E-03_JPRB,1.0305E-02_JPRB,1.1932E-02_JPRB,1.3252E-02_JPRB/)
KBO( :, 5,13, 1) = (/&
&1.9268E-03_JPRB,2.0574E-03_JPRB,8.1040E-03_JPRB,1.0709E-02_JPRB,1.2321E-02_JPRB,1.3787E-02_JPRB/)
KBO( :, 1,14, 1) = (/&
&8.9853E-04_JPRB,1.0053E-03_JPRB,5.2612E-03_JPRB,7.1257E-03_JPRB,8.3170E-03_JPRB,8.6277E-03_JPRB/)
KBO( :, 2,14, 1) = (/&
&1.0785E-03_JPRB,1.1914E-03_JPRB,5.7513E-03_JPRB,7.7564E-03_JPRB,9.0118E-03_JPRB,9.3819E-03_JPRB/)
KBO( :, 3,14, 1) = (/&
&1.2591E-03_JPRB,1.3782E-03_JPRB,6.1715E-03_JPRB,8.2478E-03_JPRB,9.5484E-03_JPRB,9.9996E-03_JPRB/)
KBO( :, 4,14, 1) = (/&
&1.4397E-03_JPRB,1.5627E-03_JPRB,6.5193E-03_JPRB,8.6487E-03_JPRB,9.9620E-03_JPRB,1.0485E-02_JPRB/)
KBO( :, 5,14, 1) = (/&
&1.6201E-03_JPRB,1.7459E-03_JPRB,6.8165E-03_JPRB,8.9827E-03_JPRB,1.0273E-02_JPRB,1.0855E-02_JPRB/)
KBO( :, 1,15, 1) = (/&
&7.6248E-04_JPRB,8.6279E-04_JPRB,4.4557E-03_JPRB,6.0207E-03_JPRB,6.9896E-03_JPRB,7.0236E-03_JPRB/)
KBO( :, 2,15, 1) = (/&
&9.1117E-04_JPRB,1.0180E-03_JPRB,4.8561E-03_JPRB,6.5127E-03_JPRB,7.5369E-03_JPRB,7.5846E-03_JPRB/)
KBO( :, 3,15, 1) = (/&
&1.0596E-03_JPRB,1.1723E-03_JPRB,5.1898E-03_JPRB,6.9089E-03_JPRB,7.9643E-03_JPRB,8.0325E-03_JPRB/)
KBO( :, 4,15, 1) = (/&
&1.2094E-03_JPRB,1.3263E-03_JPRB,5.4734E-03_JPRB,7.2380E-03_JPRB,8.2957E-03_JPRB,8.3723E-03_JPRB/)
KBO( :, 5,15, 1) = (/&
&1.3603E-03_JPRB,1.4802E-03_JPRB,5.7085E-03_JPRB,7.5104E-03_JPRB,8.5497E-03_JPRB,8.6178E-03_JPRB/)
KBO( :, 1,16, 1) = (/&
&6.4558E-04_JPRB,7.3804E-04_JPRB,3.7596E-03_JPRB,5.0589E-03_JPRB,5.8485E-03_JPRB,5.7705E-03_JPRB/)
KBO( :, 2,16, 1) = (/&
&7.6748E-04_JPRB,8.6612E-04_JPRB,4.0796E-03_JPRB,5.4496E-03_JPRB,6.2858E-03_JPRB,6.2010E-03_JPRB/)
KBO( :, 3,16, 1) = (/&
&8.9029E-04_JPRB,9.9466E-04_JPRB,4.3523E-03_JPRB,5.7735E-03_JPRB,6.6286E-03_JPRB,6.5375E-03_JPRB/)
KBO( :, 4,16, 1) = (/&
&1.0154E-03_JPRB,1.1242E-03_JPRB,4.5767E-03_JPRB,6.0430E-03_JPRB,6.8981E-03_JPRB,6.7855E-03_JPRB/)
KBO( :, 5,16, 1) = (/&
&1.1412E-03_JPRB,1.2532E-03_JPRB,4.7673E-03_JPRB,6.2610E-03_JPRB,7.1083E-03_JPRB,6.9585E-03_JPRB/)
KBO( :, 1,17, 1) = (/&
&5.4461E-04_JPRB,6.2792E-04_JPRB,3.1575E-03_JPRB,4.2329E-03_JPRB,4.8773E-03_JPRB,4.7433E-03_JPRB/)
KBO( :, 2,17, 1) = (/&
&6.4498E-04_JPRB,7.3395E-04_JPRB,3.4178E-03_JPRB,4.5500E-03_JPRB,5.2291E-03_JPRB,5.0778E-03_JPRB/)
KBO( :, 3,17, 1) = (/&
&7.4677E-04_JPRB,8.4137E-04_JPRB,3.6368E-03_JPRB,4.8153E-03_JPRB,5.5080E-03_JPRB,5.3328E-03_JPRB/)
KBO( :, 4,17, 1) = (/&
&8.5117E-04_JPRB,9.5016E-04_JPRB,3.8176E-03_JPRB,5.0337E-03_JPRB,5.7279E-03_JPRB,5.5173E-03_JPRB/)
KBO( :, 5,17, 1) = (/&
&9.5670E-04_JPRB,1.0591E-03_JPRB,3.9736E-03_JPRB,5.2057E-03_JPRB,5.9001E-03_JPRB,5.6411E-03_JPRB/)
KBO( :, 1,18, 1) = (/&
&4.5831E-04_JPRB,5.3207E-04_JPRB,2.6453E-03_JPRB,3.5350E-03_JPRB,4.0595E-03_JPRB,3.9025E-03_JPRB/)
KBO( :, 2,18, 1) = (/&
&5.4148E-04_JPRB,6.2048E-04_JPRB,2.8564E-03_JPRB,3.7920E-03_JPRB,4.3430E-03_JPRB,4.1638E-03_JPRB/)
KBO( :, 3,18, 1) = (/&
&6.2620E-04_JPRB,7.1046E-04_JPRB,3.0316E-03_JPRB,4.0093E-03_JPRB,4.5705E-03_JPRB,4.3594E-03_JPRB/)
KBO( :, 4,18, 1) = (/&
&7.1296E-04_JPRB,8.0140E-04_JPRB,3.1785E-03_JPRB,4.1822E-03_JPRB,4.7500E-03_JPRB,4.4993E-03_JPRB/)
KBO( :, 5,18, 1) = (/&
&8.0117E-04_JPRB,8.9283E-04_JPRB,3.3073E-03_JPRB,4.3215E-03_JPRB,4.8888E-03_JPRB,4.5891E-03_JPRB/)
KBO( :, 1,19, 1) = (/&
&3.8494E-04_JPRB,4.4957E-04_JPRB,2.2130E-03_JPRB,2.9470E-03_JPRB,3.3734E-03_JPRB,3.2052E-03_JPRB/)
KBO( :, 2,19, 1) = (/&
&4.5392E-04_JPRB,5.2326E-04_JPRB,2.3822E-03_JPRB,3.1567E-03_JPRB,3.6037E-03_JPRB,3.4087E-03_JPRB/)
KBO( :, 3,19, 1) = (/&
&5.2442E-04_JPRB,5.9860E-04_JPRB,2.5231E-03_JPRB,3.3307E-03_JPRB,3.7894E-03_JPRB,3.5584E-03_JPRB/)
KBO( :, 4,19, 1) = (/&
&5.9668E-04_JPRB,6.7462E-04_JPRB,2.6423E-03_JPRB,3.4702E-03_JPRB,3.9343E-03_JPRB,3.6638E-03_JPRB/)
KBO( :, 5,19, 1) = (/&
&6.7047E-04_JPRB,7.5133E-04_JPRB,2.7479E-03_JPRB,3.5833E-03_JPRB,4.0439E-03_JPRB,3.7286E-03_JPRB/)
KBO( :, 1,20, 1) = (/&
&3.2391E-04_JPRB,3.8002E-04_JPRB,1.8505E-03_JPRB,2.4575E-03_JPRB,2.8045E-03_JPRB,2.6400E-03_JPRB/)
KBO( :, 2,20, 1) = (/&
&3.8111E-04_JPRB,4.4150E-04_JPRB,1.9855E-03_JPRB,2.6268E-03_JPRB,2.9913E-03_JPRB,2.7980E-03_JPRB/)
KBO( :, 3,20, 1) = (/&
&4.3985E-04_JPRB,5.0438E-04_JPRB,2.0980E-03_JPRB,2.7657E-03_JPRB,3.1412E-03_JPRB,2.9140E-03_JPRB/)
KBO( :, 4,20, 1) = (/&
&5.0012E-04_JPRB,5.6796E-04_JPRB,2.1952E-03_JPRB,2.8783E-03_JPRB,3.2557E-03_JPRB,2.9937E-03_JPRB/)
KBO( :, 5,20, 1) = (/&
&5.6151E-04_JPRB,6.3169E-04_JPRB,2.2834E-03_JPRB,2.9700E-03_JPRB,3.3427E-03_JPRB,3.0410E-03_JPRB/)
KBO( :, 1,21, 1) = (/&
&2.7240E-04_JPRB,3.2071E-04_JPRB,1.5442E-03_JPRB,2.0481E-03_JPRB,2.3310E-03_JPRB,2.1748E-03_JPRB/)
KBO( :, 2,21, 1) = (/&
&3.1992E-04_JPRB,3.7200E-04_JPRB,1.6519E-03_JPRB,2.1831E-03_JPRB,2.4822E-03_JPRB,2.2984E-03_JPRB/)
KBO( :, 3,21, 1) = (/&
&3.6883E-04_JPRB,4.2432E-04_JPRB,1.7430E-03_JPRB,2.2945E-03_JPRB,2.6004E-03_JPRB,2.3880E-03_JPRB/)
KBO( :, 4,21, 1) = (/&
&4.1890E-04_JPRB,4.7736E-04_JPRB,1.8230E-03_JPRB,2.3849E-03_JPRB,2.6916E-03_JPRB,2.4483E-03_JPRB/)
KBO( :, 5,21, 1) = (/&
&4.7018E-04_JPRB,5.3020E-04_JPRB,1.8963E-03_JPRB,2.4601E-03_JPRB,2.7620E-03_JPRB,2.4834E-03_JPRB/)
KBO( :, 1,22, 1) = (/&
&2.3153E-04_JPRB,2.7303E-04_JPRB,1.2915E-03_JPRB,1.7120E-03_JPRB,1.9456E-03_JPRB,1.7989E-03_JPRB/)
KBO( :, 2,22, 1) = (/&
&2.7103E-04_JPRB,3.1578E-04_JPRB,1.3773E-03_JPRB,1.8187E-03_JPRB,2.0643E-03_JPRB,1.8940E-03_JPRB/)
KBO( :, 3,22, 1) = (/&
&3.1187E-04_JPRB,3.5947E-04_JPRB,1.4512E-03_JPRB,1.9068E-03_JPRB,2.1566E-03_JPRB,1.9615E-03_JPRB/)
KBO( :, 4,22, 1) = (/&
&3.5350E-04_JPRB,4.0345E-04_JPRB,1.5172E-03_JPRB,1.9794E-03_JPRB,2.2288E-03_JPRB,2.0059E-03_JPRB/)
KBO( :, 5,22, 1) = (/&
&3.9619E-04_JPRB,4.4713E-04_JPRB,1.5771E-03_JPRB,2.0415E-03_JPRB,2.2843E-03_JPRB,2.0310E-03_JPRB/)
KBO( :, 1,23, 1) = (/&
&1.9680E-04_JPRB,2.3224E-04_JPRB,1.0785E-03_JPRB,1.4288E-03_JPRB,1.6223E-03_JPRB,1.4871E-03_JPRB/)
KBO( :, 2,23, 1) = (/&
&2.2970E-04_JPRB,2.6791E-04_JPRB,1.1474E-03_JPRB,1.5138E-03_JPRB,1.7153E-03_JPRB,1.5600E-03_JPRB/)
KBO( :, 3,23, 1) = (/&
&2.6356E-04_JPRB,3.0411E-04_JPRB,1.2075E-03_JPRB,1.5839E-03_JPRB,1.7875E-03_JPRB,1.6111E-03_JPRB/)
KBO( :, 4,23, 1) = (/&
&2.9823E-04_JPRB,3.4049E-04_JPRB,1.2615E-03_JPRB,1.6428E-03_JPRB,1.8444E-03_JPRB,1.6436E-03_JPRB/)
KBO( :, 5,23, 1) = (/&
&3.3366E-04_JPRB,3.7655E-04_JPRB,1.3106E-03_JPRB,1.6936E-03_JPRB,1.8885E-03_JPRB,1.6606E-03_JPRB/)
KBO( :, 1,24, 1) = (/&
&1.6732E-04_JPRB,1.9749E-04_JPRB,9.0024E-04_JPRB,1.1912E-03_JPRB,1.3515E-03_JPRB,1.2284E-03_JPRB/)
KBO( :, 2,24, 1) = (/&
&1.9470E-04_JPRB,2.2712E-04_JPRB,9.5558E-04_JPRB,1.2587E-03_JPRB,1.4239E-03_JPRB,1.2838E-03_JPRB/)
KBO( :, 3,24, 1) = (/&
&2.2281E-04_JPRB,2.5707E-04_JPRB,1.0048E-03_JPRB,1.3153E-03_JPRB,1.4808E-03_JPRB,1.3221E-03_JPRB/)
KBO( :, 4,24, 1) = (/&
&2.5169E-04_JPRB,2.8708E-04_JPRB,1.0484E-03_JPRB,1.3630E-03_JPRB,1.5260E-03_JPRB,1.3453E-03_JPRB/)
KBO( :, 5,24, 1) = (/&
&2.8094E-04_JPRB,3.1674E-04_JPRB,1.0886E-03_JPRB,1.4046E-03_JPRB,1.5614E-03_JPRB,1.3561E-03_JPRB/)
KBO( :, 1,25, 1) = (/&
&1.4236E-04_JPRB,1.6794E-04_JPRB,7.5125E-04_JPRB,9.9289E-04_JPRB,1.1254E-03_JPRB,1.0148E-03_JPRB/)
KBO( :, 2,25, 1) = (/&
&1.6512E-04_JPRB,1.9246E-04_JPRB,7.9598E-04_JPRB,1.0465E-03_JPRB,1.1819E-03_JPRB,1.0567E-03_JPRB/)
KBO( :, 3,25, 1) = (/&
&1.8845E-04_JPRB,2.1722E-04_JPRB,8.3598E-04_JPRB,1.0925E-03_JPRB,1.2269E-03_JPRB,1.0851E-03_JPRB/)
KBO( :, 4,25, 1) = (/&
&2.1255E-04_JPRB,2.4198E-04_JPRB,8.7137E-04_JPRB,1.1312E-03_JPRB,1.2632E-03_JPRB,1.1012E-03_JPRB/)
KBO( :, 5,25, 1) = (/&
&2.3642E-04_JPRB,2.6609E-04_JPRB,9.0373E-04_JPRB,1.1641E-03_JPRB,1.2904E-03_JPRB,1.1075E-03_JPRB/)
KBO( :, 1,26, 1) = (/&
&1.2135E-04_JPRB,1.4296E-04_JPRB,6.2705E-04_JPRB,8.2752E-04_JPRB,9.3670E-04_JPRB,8.3888E-04_JPRB/)
KBO( :, 2,26, 1) = (/&
&1.4025E-04_JPRB,1.6320E-04_JPRB,6.6335E-04_JPRB,8.7086E-04_JPRB,9.8124E-04_JPRB,8.7024E-04_JPRB/)
KBO( :, 3,26, 1) = (/&
&1.5968E-04_JPRB,1.8367E-04_JPRB,6.9554E-04_JPRB,9.0762E-04_JPRB,1.0171E-03_JPRB,8.9085E-04_JPRB/)
KBO( :, 4,26, 1) = (/&
&1.7968E-04_JPRB,2.0411E-04_JPRB,7.2423E-04_JPRB,9.3899E-04_JPRB,1.0460E-03_JPRB,9.0171E-04_JPRB/)
KBO( :, 5,26, 1) = (/&
&1.9911E-04_JPRB,2.2355E-04_JPRB,7.5041E-04_JPRB,9.6460E-04_JPRB,1.0668E-03_JPRB,9.0488E-04_JPRB/)
KBO( :, 1,27, 1) = (/&
&1.0341E-04_JPRB,1.2153E-04_JPRB,5.2310E-04_JPRB,6.8960E-04_JPRB,7.7919E-04_JPRB,6.9370E-04_JPRB/)
KBO( :, 2,27, 1) = (/&
&1.1910E-04_JPRB,1.3828E-04_JPRB,5.5242E-04_JPRB,7.2420E-04_JPRB,8.1412E-04_JPRB,7.1711E-04_JPRB/)
KBO( :, 3,27, 1) = (/&
&1.3529E-04_JPRB,1.5520E-04_JPRB,5.7820E-04_JPRB,7.5373E-04_JPRB,8.4285E-04_JPRB,7.3175E-04_JPRB/)
KBO( :, 4,27, 1) = (/&
&1.5173E-04_JPRB,1.7193E-04_JPRB,6.0154E-04_JPRB,7.7867E-04_JPRB,8.6563E-04_JPRB,7.3890E-04_JPRB/)
KBO( :, 5,27, 1) = (/&
&1.6753E-04_JPRB,1.8765E-04_JPRB,6.2289E-04_JPRB,7.9883E-04_JPRB,8.8130E-04_JPRB,7.3997E-04_JPRB/)
KBO( :, 1,28, 1) = (/&
&8.8061E-05_JPRB,1.0321E-04_JPRB,4.3625E-04_JPRB,5.7437E-04_JPRB,6.4777E-04_JPRB,5.7348E-04_JPRB/)
KBO( :, 2,28, 1) = (/&
&1.0110E-04_JPRB,1.1708E-04_JPRB,4.5983E-04_JPRB,6.0227E-04_JPRB,6.7553E-04_JPRB,5.9094E-04_JPRB/)
KBO( :, 3,28, 1) = (/&
&1.1455E-04_JPRB,1.3102E-04_JPRB,4.8047E-04_JPRB,6.2567E-04_JPRB,6.9826E-04_JPRB,6.0125E-04_JPRB/)
KBO( :, 4,28, 1) = (/&
&1.2801E-04_JPRB,1.4469E-04_JPRB,4.9957E-04_JPRB,6.4544E-04_JPRB,7.1609E-04_JPRB,6.0583E-04_JPRB/)
KBO( :, 5,28, 1) = (/&
&1.4086E-04_JPRB,1.5736E-04_JPRB,5.1693E-04_JPRB,6.6170E-04_JPRB,7.2796E-04_JPRB,6.0570E-04_JPRB/)
KBO( :, 1,29, 1) = (/&
&7.5003E-05_JPRB,8.7664E-05_JPRB,3.6374E-04_JPRB,4.7834E-04_JPRB,5.3844E-04_JPRB,4.7486E-04_JPRB/)
KBO( :, 2,29, 1) = (/&
&8.5847E-05_JPRB,9.9153E-05_JPRB,3.8260E-04_JPRB,5.0066E-04_JPRB,5.6048E-04_JPRB,4.8785E-04_JPRB/)
KBO( :, 3,29, 1) = (/&
&9.7004E-05_JPRB,1.1064E-04_JPRB,3.9929E-04_JPRB,5.1926E-04_JPRB,5.7857E-04_JPRB,4.9509E-04_JPRB/)
KBO( :, 4,29, 1) = (/&
&1.0798E-04_JPRB,1.2169E-04_JPRB,4.1471E-04_JPRB,5.3469E-04_JPRB,5.9200E-04_JPRB,4.9798E-04_JPRB/)
KBO( :, 5,29, 1) = (/&
&1.1839E-04_JPRB,1.3193E-04_JPRB,4.2885E-04_JPRB,5.4790E-04_JPRB,6.0121E-04_JPRB,4.9719E-04_JPRB/)
KBO( :, 1,30, 1) = (/&
&6.3856E-05_JPRB,7.4428E-05_JPRB,3.0309E-04_JPRB,3.9831E-04_JPRB,4.4748E-04_JPRB,3.9336E-04_JPRB/)
KBO( :, 2,30, 1) = (/&
&7.2870E-05_JPRB,8.3906E-05_JPRB,3.1816E-04_JPRB,4.1597E-04_JPRB,4.6500E-04_JPRB,4.0292E-04_JPRB/)
KBO( :, 3,30, 1) = (/&
&8.2079E-05_JPRB,9.3343E-05_JPRB,3.3169E-04_JPRB,4.3066E-04_JPRB,4.7913E-04_JPRB,4.0807E-04_JPRB/)
KBO( :, 4,30, 1) = (/&
&9.1015E-05_JPRB,1.0225E-04_JPRB,3.4430E-04_JPRB,4.4314E-04_JPRB,4.8947E-04_JPRB,4.0977E-04_JPRB/)
KBO( :, 5,30, 1) = (/&
&9.9395E-05_JPRB,1.1051E-04_JPRB,3.5570E-04_JPRB,4.5357E-04_JPRB,4.9658E-04_JPRB,4.0872E-04_JPRB/)
KBO( :, 1,31, 1) = (/&
&5.4357E-05_JPRB,6.3176E-05_JPRB,2.5245E-04_JPRB,3.3157E-04_JPRB,3.7178E-04_JPRB,3.2647E-04_JPRB/)
KBO( :, 2,31, 1) = (/&
&6.1861E-05_JPRB,7.0996E-05_JPRB,2.6445E-04_JPRB,3.4538E-04_JPRB,3.8570E-04_JPRB,3.3355E-04_JPRB/)
KBO( :, 3,31, 1) = (/&
&6.9416E-05_JPRB,7.8709E-05_JPRB,2.7554E-04_JPRB,3.5712E-04_JPRB,3.9671E-04_JPRB,3.3723E-04_JPRB/)
KBO( :, 4,31, 1) = (/&
&7.6656E-05_JPRB,8.5880E-05_JPRB,2.8577E-04_JPRB,3.6709E-04_JPRB,4.0449E-04_JPRB,3.3826E-04_JPRB/)
KBO( :, 5,31, 1) = (/&
&8.3388E-05_JPRB,9.2525E-05_JPRB,2.9501E-04_JPRB,3.7530E-04_JPRB,4.1001E-04_JPRB,3.3724E-04_JPRB/)
KBO( :, 1,32, 1) = (/&
&4.6259E-05_JPRB,5.3603E-05_JPRB,2.1016E-04_JPRB,2.7584E-04_JPRB,3.0892E-04_JPRB,2.7109E-04_JPRB/)
KBO( :, 2,32, 1) = (/&
&5.2498E-05_JPRB,6.0059E-05_JPRB,2.1987E-04_JPRB,2.8676E-04_JPRB,3.1987E-04_JPRB,2.7630E-04_JPRB/)
KBO( :, 3,32, 1) = (/&
&5.8656E-05_JPRB,6.6298E-05_JPRB,2.2891E-04_JPRB,2.9611E-04_JPRB,3.2832E-04_JPRB,2.7895E-04_JPRB/)
KBO( :, 4,32, 1) = (/&
&6.4498E-05_JPRB,7.2071E-05_JPRB,2.3718E-04_JPRB,3.0404E-04_JPRB,3.3430E-04_JPRB,2.7957E-04_JPRB/)
KBO( :, 5,32, 1) = (/&
&6.9916E-05_JPRB,7.7424E-05_JPRB,2.4471E-04_JPRB,3.1058E-04_JPRB,3.3850E-04_JPRB,2.7859E-04_JPRB/)
KBO( :, 1,33, 1) = (/&
&3.9361E-05_JPRB,4.5460E-05_JPRB,1.7493E-04_JPRB,2.2932E-04_JPRB,2.5656E-04_JPRB,2.2525E-04_JPRB/)
KBO( :, 2,33, 1) = (/&
&4.4512E-05_JPRB,5.0768E-05_JPRB,1.8281E-04_JPRB,2.3800E-04_JPRB,2.6516E-04_JPRB,2.2918E-04_JPRB/)
KBO( :, 3,33, 1) = (/&
&4.9514E-05_JPRB,5.5781E-05_JPRB,1.9016E-04_JPRB,2.4549E-04_JPRB,2.7165E-04_JPRB,2.3114E-04_JPRB/)
KBO( :, 4,33, 1) = (/&
&5.4222E-05_JPRB,6.0427E-05_JPRB,1.9683E-04_JPRB,2.5168E-04_JPRB,2.7625E-04_JPRB,2.3152E-04_JPRB/)
KBO( :, 5,33, 1) = (/&
&5.8568E-05_JPRB,6.4731E-05_JPRB,2.0299E-04_JPRB,2.5697E-04_JPRB,2.7939E-04_JPRB,2.3058E-04_JPRB/)
KBO( :, 1,34, 1) = (/&
&3.3323E-05_JPRB,3.8371E-05_JPRB,1.4532E-04_JPRB,1.9026E-04_JPRB,2.1273E-04_JPRB,1.8680E-04_JPRB/)
KBO( :, 2,34, 1) = (/&
&3.7542E-05_JPRB,4.2703E-05_JPRB,1.5176E-04_JPRB,1.9725E-04_JPRB,2.1949E-04_JPRB,1.8982E-04_JPRB/)
KBO( :, 3,34, 1) = (/&
&4.1603E-05_JPRB,4.6750E-05_JPRB,1.5775E-04_JPRB,2.0322E-04_JPRB,2.2449E-04_JPRB,1.9126E-04_JPRB/)
KBO( :, 4,34, 1) = (/&
&4.5410E-05_JPRB,5.0505E-05_JPRB,1.6321E-04_JPRB,2.0822E-04_JPRB,2.2810E-04_JPRB,1.9147E-04_JPRB/)
KBO( :, 5,34, 1) = (/&
&4.8872E-05_JPRB,5.3940E-05_JPRB,1.6826E-04_JPRB,2.1254E-04_JPRB,2.3048E-04_JPRB,1.9060E-04_JPRB/)
KBO( :, 1,35, 1) = (/&
&2.7848E-05_JPRB,3.2017E-05_JPRB,1.2019E-04_JPRB,1.5723E-04_JPRB,1.7574E-04_JPRB,1.5467E-04_JPRB/)
KBO( :, 2,35, 1) = (/&
&3.1305E-05_JPRB,3.5553E-05_JPRB,1.2549E-04_JPRB,1.6294E-04_JPRB,1.8117E-04_JPRB,1.5712E-04_JPRB/)
KBO( :, 3,35, 1) = (/&
&3.4621E-05_JPRB,3.8848E-05_JPRB,1.3039E-04_JPRB,1.6780E-04_JPRB,1.8517E-04_JPRB,1.5830E-04_JPRB/)
KBO( :, 4,35, 1) = (/&
&3.7704E-05_JPRB,4.1891E-05_JPRB,1.3491E-04_JPRB,1.7188E-04_JPRB,1.8805E-04_JPRB,1.5843E-04_JPRB/)
KBO( :, 5,35, 1) = (/&
&4.0476E-05_JPRB,4.4649E-05_JPRB,1.3909E-04_JPRB,1.7549E-04_JPRB,1.8997E-04_JPRB,1.5779E-04_JPRB/)
KBO( :, 1,36, 1) = (/&
&2.2956E-05_JPRB,2.6385E-05_JPRB,9.8921E-05_JPRB,1.2940E-04_JPRB,1.4463E-04_JPRB,1.2779E-04_JPRB/)
KBO( :, 2,36, 1) = (/&
&2.5793E-05_JPRB,2.9285E-05_JPRB,1.0333E-04_JPRB,1.3415E-04_JPRB,1.4912E-04_JPRB,1.2989E-04_JPRB/)
KBO( :, 3,36, 1) = (/&
&2.8520E-05_JPRB,3.1993E-05_JPRB,1.0740E-04_JPRB,1.3821E-04_JPRB,1.5246E-04_JPRB,1.3097E-04_JPRB/)
KBO( :, 4,36, 1) = (/&
&3.1028E-05_JPRB,3.4473E-05_JPRB,1.1115E-04_JPRB,1.4160E-04_JPRB,1.5487E-04_JPRB,1.3116E-04_JPRB/)
KBO( :, 5,36, 1) = (/&
&3.3268E-05_JPRB,3.6701E-05_JPRB,1.1464E-04_JPRB,1.4466E-04_JPRB,1.5648E-04_JPRB,1.3075E-04_JPRB/)
KBO( :, 1,37, 1) = (/&
&1.8563E-05_JPRB,2.1372E-05_JPRB,8.0857E-05_JPRB,1.0587E-04_JPRB,1.1839E-04_JPRB,1.0509E-04_JPRB/)
KBO( :, 2,37, 1) = (/&
&2.0902E-05_JPRB,2.3771E-05_JPRB,8.4550E-05_JPRB,1.0990E-04_JPRB,1.2224E-04_JPRB,1.0704E-04_JPRB/)
KBO( :, 3,37, 1) = (/&
&2.3158E-05_JPRB,2.6017E-05_JPRB,8.7968E-05_JPRB,1.1334E-04_JPRB,1.2513E-04_JPRB,1.0806E-04_JPRB/)
KBO( :, 4,37, 1) = (/&
&2.5232E-05_JPRB,2.8068E-05_JPRB,9.1139E-05_JPRB,1.1630E-04_JPRB,1.2729E-04_JPRB,1.0839E-04_JPRB/)
KBO( :, 5,37, 1) = (/&
&2.7075E-05_JPRB,2.9898E-05_JPRB,9.4071E-05_JPRB,1.1891E-04_JPRB,1.2874E-04_JPRB,1.0822E-04_JPRB/)
KBO( :, 1,38, 1) = (/&
&1.4988E-05_JPRB,1.7289E-05_JPRB,6.6055E-05_JPRB,8.6575E-05_JPRB,9.6855E-05_JPRB,8.6493E-05_JPRB/)
KBO( :, 2,38, 1) = (/&
&1.6918E-05_JPRB,1.9272E-05_JPRB,6.9150E-05_JPRB,8.9996E-05_JPRB,1.0016E-04_JPRB,8.8280E-05_JPRB/)
KBO( :, 3,38, 1) = (/&
&1.8783E-05_JPRB,2.1138E-05_JPRB,7.2026E-05_JPRB,9.2962E-05_JPRB,1.0270E-04_JPRB,8.9275E-05_JPRB/)
KBO( :, 4,38, 1) = (/&
&2.0496E-05_JPRB,2.2834E-05_JPRB,7.4689E-05_JPRB,9.5470E-05_JPRB,1.0459E-04_JPRB,8.9701E-05_JPRB/)
KBO( :, 5,38, 1) = (/&
&2.2016E-05_JPRB,2.4338E-05_JPRB,7.7162E-05_JPRB,9.7704E-05_JPRB,1.0591E-04_JPRB,8.9718E-05_JPRB/)
KBO( :, 1,39, 1) = (/&
&1.2096E-05_JPRB,1.3982E-05_JPRB,5.3949E-05_JPRB,7.0786E-05_JPRB,7.9230E-05_JPRB,7.1287E-05_JPRB/)
KBO( :, 2,39, 1) = (/&
&1.3689E-05_JPRB,1.5620E-05_JPRB,5.6546E-05_JPRB,7.3698E-05_JPRB,8.2063E-05_JPRB,7.2936E-05_JPRB/)
KBO( :, 3,39, 1) = (/&
&1.5231E-05_JPRB,1.7169E-05_JPRB,5.8966E-05_JPRB,7.6225E-05_JPRB,8.4277E-05_JPRB,7.3907E-05_JPRB/)
KBO( :, 4,39, 1) = (/&
&1.6645E-05_JPRB,1.8570E-05_JPRB,6.1204E-05_JPRB,7.8367E-05_JPRB,8.5941E-05_JPRB,7.4418E-05_JPRB/)
KBO( :, 5,39, 1) = (/&
&1.7901E-05_JPRB,1.9810E-05_JPRB,6.3290E-05_JPRB,8.0298E-05_JPRB,8.7131E-05_JPRB,7.4561E-05_JPRB/)
KBO( :, 1,40, 1) = (/&
&9.6276E-06_JPRB,1.1165E-05_JPRB,4.3831E-05_JPRB,5.7599E-05_JPRB,6.4509E-05_JPRB,5.8273E-05_JPRB/)
KBO( :, 2,40, 1) = (/&
&1.0939E-05_JPRB,1.2519E-05_JPRB,4.6024E-05_JPRB,6.0108E-05_JPRB,6.6994E-05_JPRB,5.9810E-05_JPRB/)
KBO( :, 3,40, 1) = (/&
&1.2220E-05_JPRB,1.3814E-05_JPRB,4.8073E-05_JPRB,6.2293E-05_JPRB,6.8988E-05_JPRB,6.0759E-05_JPRB/)
KBO( :, 4,40, 1) = (/&
&1.3401E-05_JPRB,1.4988E-05_JPRB,4.9968E-05_JPRB,6.4170E-05_JPRB,7.0494E-05_JPRB,6.1313E-05_JPRB/)
KBO( :, 5,40, 1) = (/&
&1.4450E-05_JPRB,1.6022E-05_JPRB,5.1742E-05_JPRB,6.5833E-05_JPRB,7.1594E-05_JPRB,6.1539E-05_JPRB/)
KBO( :, 1,41, 1) = (/&
&7.6383E-06_JPRB,8.8906E-06_JPRB,3.5555E-05_JPRB,4.6806E-05_JPRB,5.2458E-05_JPRB,4.7568E-05_JPRB/)
KBO( :, 2,41, 1) = (/&
&8.7190E-06_JPRB,1.0010E-05_JPRB,3.7422E-05_JPRB,4.8972E-05_JPRB,5.4631E-05_JPRB,4.8981E-05_JPRB/)
KBO( :, 3,41, 1) = (/&
&9.7816E-06_JPRB,1.1092E-05_JPRB,3.9150E-05_JPRB,5.0862E-05_JPRB,5.6413E-05_JPRB,4.9899E-05_JPRB/)
KBO( :, 4,41, 1) = (/&
&1.0770E-05_JPRB,1.2078E-05_JPRB,4.0765E-05_JPRB,5.2505E-05_JPRB,5.7788E-05_JPRB,5.0461E-05_JPRB/)
KBO( :, 5,41, 1) = (/&
&1.1650E-05_JPRB,1.2944E-05_JPRB,4.2271E-05_JPRB,5.3948E-05_JPRB,5.8801E-05_JPRB,5.0748E-05_JPRB/)
KBO( :, 1,42, 1) = (/&
&6.0542E-06_JPRB,7.0721E-06_JPRB,2.8820E-05_JPRB,3.8000E-05_JPRB,4.2624E-05_JPRB,3.8819E-05_JPRB/)
KBO( :, 2,42, 1) = (/&
&6.9406E-06_JPRB,7.9951E-06_JPRB,3.0412E-05_JPRB,3.9875E-05_JPRB,4.4529E-05_JPRB,4.0118E-05_JPRB/)
KBO( :, 3,42, 1) = (/&
&7.8202E-06_JPRB,8.8967E-06_JPRB,3.1870E-05_JPRB,4.1509E-05_JPRB,4.6106E-05_JPRB,4.0986E-05_JPRB/)
KBO( :, 4,42, 1) = (/&
&8.6462E-06_JPRB,9.7239E-06_JPRB,3.3236E-05_JPRB,4.2934E-05_JPRB,4.7338E-05_JPRB,4.1549E-05_JPRB/)
KBO( :, 5,42, 1) = (/&
&9.3841E-06_JPRB,1.0450E-05_JPRB,3.4511E-05_JPRB,4.4186E-05_JPRB,4.8277E-05_JPRB,4.1876E-05_JPRB/)
KBO( :, 1,43, 1) = (/&
&4.7535E-06_JPRB,5.5762E-06_JPRB,2.3267E-05_JPRB,3.0725E-05_JPRB,3.4509E-05_JPRB,3.1571E-05_JPRB/)
KBO( :, 2,43, 1) = (/&
&5.4765E-06_JPRB,6.3357E-06_JPRB,2.4631E-05_JPRB,3.2364E-05_JPRB,3.6180E-05_JPRB,3.2776E-05_JPRB/)
KBO( :, 3,43, 1) = (/&
&6.2063E-06_JPRB,7.0878E-06_JPRB,2.5870E-05_JPRB,3.3787E-05_JPRB,3.7588E-05_JPRB,3.3603E-05_JPRB/)
KBO( :, 4,43, 1) = (/&
&6.8971E-06_JPRB,7.7847E-06_JPRB,2.7025E-05_JPRB,3.5030E-05_JPRB,3.8710E-05_JPRB,3.4166E-05_JPRB/)
KBO( :, 5,43, 1) = (/&
&7.5200E-06_JPRB,8.3995E-06_JPRB,2.8111E-05_JPRB,3.6121E-05_JPRB,3.9582E-05_JPRB,3.4523E-05_JPRB/)
KBO( :, 1,44, 1) = (/&
&3.7108E-06_JPRB,4.3735E-06_JPRB,1.8735E-05_JPRB,2.4774E-05_JPRB,2.7859E-05_JPRB,2.5624E-05_JPRB/)
KBO( :, 2,44, 1) = (/&
&4.2986E-06_JPRB,4.9970E-06_JPRB,1.9896E-05_JPRB,2.6202E-05_JPRB,2.9326E-05_JPRB,2.6740E-05_JPRB/)
KBO( :, 3,44, 1) = (/&
&4.9004E-06_JPRB,5.6209E-06_JPRB,2.0953E-05_JPRB,2.7445E-05_JPRB,3.0581E-05_JPRB,2.7533E-05_JPRB/)
KBO( :, 4,44, 1) = (/&
&5.4800E-06_JPRB,6.2094E-06_JPRB,2.1942E-05_JPRB,2.8536E-05_JPRB,3.1606E-05_JPRB,2.8081E-05_JPRB/)
KBO( :, 5,44, 1) = (/&
&6.0067E-06_JPRB,6.7326E-06_JPRB,2.2861E-05_JPRB,2.9489E-05_JPRB,3.2408E-05_JPRB,2.8452E-05_JPRB/)
KBO( :, 1,45, 1) = (/&
&2.8911E-06_JPRB,3.4227E-06_JPRB,1.5064E-05_JPRB,1.9947E-05_JPRB,2.2457E-05_JPRB,2.0791E-05_JPRB/)
KBO( :, 2,45, 1) = (/&
&3.3674E-06_JPRB,3.9335E-06_JPRB,1.6057E-05_JPRB,2.1189E-05_JPRB,2.3743E-05_JPRB,2.1813E-05_JPRB/)
KBO( :, 3,45, 1) = (/&
&3.8624E-06_JPRB,4.4499E-06_JPRB,1.6962E-05_JPRB,2.2274E-05_JPRB,2.4852E-05_JPRB,2.2566E-05_JPRB/)
KBO( :, 4,45, 1) = (/&
&4.3456E-06_JPRB,4.9443E-06_JPRB,1.7794E-05_JPRB,2.3219E-05_JPRB,2.5777E-05_JPRB,2.3098E-05_JPRB/)
KBO( :, 5,45, 1) = (/&
&4.7911E-06_JPRB,5.3898E-06_JPRB,1.8581E-05_JPRB,2.4056E-05_JPRB,2.6509E-05_JPRB,2.3470E-05_JPRB/)
KBO( :, 1,46, 1) = (/&
&2.2383E-06_JPRB,2.6637E-06_JPRB,1.2073E-05_JPRB,1.6011E-05_JPRB,1.8044E-05_JPRB,1.6831E-05_JPRB/)
KBO( :, 2,46, 1) = (/&
&2.6247E-06_JPRB,3.0814E-06_JPRB,1.2921E-05_JPRB,1.7081E-05_JPRB,1.9170E-05_JPRB,1.7760E-05_JPRB/)
KBO( :, 3,46, 1) = (/&
&3.0283E-06_JPRB,3.5061E-06_JPRB,1.3701E-05_JPRB,1.8033E-05_JPRB,2.0150E-05_JPRB,1.8469E-05_JPRB/)
KBO( :, 4,46, 1) = (/&
&3.4307E-06_JPRB,3.9211E-06_JPRB,1.4408E-05_JPRB,1.8862E-05_JPRB,2.0983E-05_JPRB,1.8985E-05_JPRB/)
KBO( :, 5,46, 1) = (/&
&3.8069E-06_JPRB,4.3002E-06_JPRB,1.5076E-05_JPRB,1.9597E-05_JPRB,2.1654E-05_JPRB,1.9353E-05_JPRB/)
KBO( :, 1,47, 1) = (/&
&1.7157E-06_JPRB,2.0538E-06_JPRB,9.6246E-06_JPRB,1.2782E-05_JPRB,1.4416E-05_JPRB,1.3539E-05_JPRB/)
KBO( :, 2,47, 1) = (/&
&2.0274E-06_JPRB,2.3938E-06_JPRB,1.0355E-05_JPRB,1.3710E-05_JPRB,1.5413E-05_JPRB,1.4388E-05_JPRB/)
KBO( :, 3,47, 1) = (/&
&2.3547E-06_JPRB,2.7420E-06_JPRB,1.1027E-05_JPRB,1.4546E-05_JPRB,1.6278E-05_JPRB,1.5051E-05_JPRB/)
KBO( :, 4,47, 1) = (/&
&2.6881E-06_JPRB,3.0885E-06_JPRB,1.1632E-05_JPRB,1.5275E-05_JPRB,1.7026E-05_JPRB,1.5547E-05_JPRB/)
KBO( :, 5,47, 1) = (/&
&3.0058E-06_JPRB,3.4107E-06_JPRB,1.2197E-05_JPRB,1.5919E-05_JPRB,1.7642E-05_JPRB,1.5912E-05_JPRB/)
KBO( :, 1,48, 1) = (/&
&1.3107E-06_JPRB,1.5782E-06_JPRB,7.6508E-06_JPRB,1.0175E-05_JPRB,1.1482E-05_JPRB,1.0883E-05_JPRB/)
KBO( :, 2,48, 1) = (/&
&1.5615E-06_JPRB,1.8540E-06_JPRB,8.2825E-06_JPRB,1.0980E-05_JPRB,1.2364E-05_JPRB,1.1653E-05_JPRB/)
KBO( :, 3,48, 1) = (/&
&1.8258E-06_JPRB,2.1385E-06_JPRB,8.8579E-06_JPRB,1.1710E-05_JPRB,1.3124E-05_JPRB,1.2269E-05_JPRB/)
KBO( :, 4,48, 1) = (/&
&2.0996E-06_JPRB,2.4258E-06_JPRB,9.3784E-06_JPRB,1.2351E-05_JPRB,1.3790E-05_JPRB,1.2743E-05_JPRB/)
KBO( :, 5,48, 1) = (/&
&2.3667E-06_JPRB,2.6988E-06_JPRB,9.8574E-06_JPRB,1.2914E-05_JPRB,1.4353E-05_JPRB,1.3101E-05_JPRB/)
KBO( :, 1,49, 1) = (/&
&9.9722E-07_JPRB,1.2088E-06_JPRB,6.0640E-06_JPRB,8.0714E-06_JPRB,9.1144E-06_JPRB,8.7529E-06_JPRB/)
KBO( :, 2,49, 1) = (/&
&1.1984E-06_JPRB,1.4315E-06_JPRB,6.6089E-06_JPRB,8.7743E-06_JPRB,9.8916E-06_JPRB,9.4492E-06_JPRB/)
KBO( :, 3,49, 1) = (/&
&1.4119E-06_JPRB,1.6631E-06_JPRB,7.1011E-06_JPRB,9.4039E-06_JPRB,1.0560E-05_JPRB,1.0016E-05_JPRB/)
KBO( :, 4,49, 1) = (/&
&1.6351E-06_JPRB,1.8997E-06_JPRB,7.5513E-06_JPRB,9.9685E-06_JPRB,1.1148E-05_JPRB,1.0465E-05_JPRB/)
KBO( :, 5,49, 1) = (/&
&1.8579E-06_JPRB,2.1297E-06_JPRB,7.9577E-06_JPRB,1.0461E-05_JPRB,1.1654E-05_JPRB,1.0817E-05_JPRB/)
KBO( :, 1,50, 1) = (/&
&7.5886E-07_JPRB,9.2721E-07_JPRB,4.8038E-06_JPRB,6.3978E-06_JPRB,7.2231E-06_JPRB,7.0033E-06_JPRB/)
KBO( :, 2,50, 1) = (/&
&9.2100E-07_JPRB,1.1063E-06_JPRB,5.2714E-06_JPRB,7.0056E-06_JPRB,7.9040E-06_JPRB,7.6216E-06_JPRB/)
KBO( :, 3,50, 1) = (/&
&1.0933E-06_JPRB,1.2947E-06_JPRB,5.6945E-06_JPRB,7.5500E-06_JPRB,8.4922E-06_JPRB,8.1346E-06_JPRB/)
KBO( :, 4,50, 1) = (/&
&1.2741E-06_JPRB,1.4882E-06_JPRB,6.0797E-06_JPRB,8.0421E-06_JPRB,9.0066E-06_JPRB,8.5490E-06_JPRB/)
KBO( :, 5,50, 1) = (/&
&1.4586E-06_JPRB,1.6807E-06_JPRB,6.4274E-06_JPRB,8.4750E-06_JPRB,9.4574E-06_JPRB,8.8779E-06_JPRB/)
KBO( :, 1,51, 1) = (/&
&5.7629E-07_JPRB,7.1029E-07_JPRB,3.7943E-06_JPRB,5.0570E-06_JPRB,5.7108E-06_JPRB,5.5791E-06_JPRB/)
KBO( :, 2,51, 1) = (/&
&7.0702E-07_JPRB,8.5393E-07_JPRB,4.1966E-06_JPRB,5.5839E-06_JPRB,6.3056E-06_JPRB,6.1262E-06_JPRB/)
KBO( :, 3,51, 1) = (/&
&8.4587E-07_JPRB,1.0071E-06_JPRB,4.5610E-06_JPRB,6.0549E-06_JPRB,6.8186E-06_JPRB,6.5832E-06_JPRB/)
KBO( :, 4,51, 1) = (/&
&9.9205E-07_JPRB,1.1651E-06_JPRB,4.8914E-06_JPRB,6.4815E-06_JPRB,7.2681E-06_JPRB,6.9582E-06_JPRB/)
KBO( :, 5,51, 1) = (/&
&1.1437E-06_JPRB,1.3245E-06_JPRB,5.1899E-06_JPRB,6.8593E-06_JPRB,7.6670E-06_JPRB,7.2604E-06_JPRB/)
KBO( :, 1,52, 1) = (/&
&4.3584E-07_JPRB,5.4224E-07_JPRB,2.9855E-06_JPRB,3.9817E-06_JPRB,4.4976E-06_JPRB,4.4442E-06_JPRB/)
KBO( :, 2,52, 1) = (/&
&5.4097E-07_JPRB,6.5764E-07_JPRB,3.3334E-06_JPRB,4.4392E-06_JPRB,5.0153E-06_JPRB,4.9246E-06_JPRB/)
KBO( :, 3,52, 1) = (/&
&6.5253E-07_JPRB,7.8129E-07_JPRB,3.6456E-06_JPRB,4.8458E-06_JPRB,5.4625E-06_JPRB,5.3314E-06_JPRB/)
KBO( :, 4,52, 1) = (/&
&7.7086E-07_JPRB,9.1002E-07_JPRB,3.9287E-06_JPRB,5.2127E-06_JPRB,5.8546E-06_JPRB,5.6688E-06_JPRB/)
KBO( :, 5,52, 1) = (/&
&8.9444E-07_JPRB,1.0413E-06_JPRB,4.1837E-06_JPRB,5.5418E-06_JPRB,6.2037E-06_JPRB,5.9475E-06_JPRB/)
KBO( :, 1,53, 1) = (/&
&3.2796E-07_JPRB,4.1214E-07_JPRB,2.3394E-06_JPRB,3.1195E-06_JPRB,3.5262E-06_JPRB,3.5455E-06_JPRB/)
KBO( :, 2,53, 1) = (/&
&4.1213E-07_JPRB,5.0498E-07_JPRB,2.6399E-06_JPRB,3.5184E-06_JPRB,3.9742E-06_JPRB,3.9662E-06_JPRB/)
KBO( :, 3,53, 1) = (/&
&5.0194E-07_JPRB,6.0442E-07_JPRB,2.9073E-06_JPRB,3.8680E-06_JPRB,4.3642E-06_JPRB,4.3273E-06_JPRB/)
KBO( :, 4,53, 1) = (/&
&5.9752E-07_JPRB,7.0914E-07_JPRB,3.1505E-06_JPRB,4.1837E-06_JPRB,4.7059E-06_JPRB,4.6313E-06_JPRB/)
KBO( :, 5,53, 1) = (/&
&6.9765E-07_JPRB,8.1659E-07_JPRB,3.3684E-06_JPRB,4.4697E-06_JPRB,5.0106E-06_JPRB,4.8882E-06_JPRB/)
KBO( :, 1,54, 1) = (/&
&2.4768E-07_JPRB,3.1412E-07_JPRB,1.8333E-06_JPRB,2.4420E-06_JPRB,2.7649E-06_JPRB,2.7862E-06_JPRB/)
KBO( :, 2,54, 1) = (/&
&3.1476E-07_JPRB,3.8873E-07_JPRB,2.0902E-06_JPRB,2.7876E-06_JPRB,3.1500E-06_JPRB,3.1426E-06_JPRB/)
KBO( :, 3,54, 1) = (/&
&3.8724E-07_JPRB,4.6872E-07_JPRB,2.3192E-06_JPRB,3.0882E-06_JPRB,3.4874E-06_JPRB,3.4564E-06_JPRB/)
KBO( :, 4,54, 1) = (/&
&4.6434E-07_JPRB,5.5384E-07_JPRB,2.5276E-06_JPRB,3.3593E-06_JPRB,3.7832E-06_JPRB,3.7206E-06_JPRB/)
KBO( :, 5,54, 1) = (/&
&5.4537E-07_JPRB,6.4156E-07_JPRB,2.7141E-06_JPRB,3.6064E-06_JPRB,4.0468E-06_JPRB,3.9453E-06_JPRB/)
KBO( :, 1,55, 1) = (/&
&1.8693E-07_JPRB,2.3927E-07_JPRB,1.4336E-06_JPRB,1.9074E-06_JPRB,2.1635E-06_JPRB,2.1619E-06_JPRB/)
KBO( :, 2,55, 1) = (/&
&2.4025E-07_JPRB,2.9918E-07_JPRB,1.6519E-06_JPRB,2.2048E-06_JPRB,2.4926E-06_JPRB,2.4604E-06_JPRB/)
KBO( :, 3,55, 1) = (/&
&2.9872E-07_JPRB,3.6360E-07_JPRB,1.8488E-06_JPRB,2.4633E-06_JPRB,2.7832E-06_JPRB,2.7282E-06_JPRB/)
KBO( :, 4,55, 1) = (/&
&3.6075E-07_JPRB,4.3251E-07_JPRB,2.0265E-06_JPRB,2.6954E-06_JPRB,3.0391E-06_JPRB,2.9551E-06_JPRB/)
KBO( :, 5,55, 1) = (/&
&4.2648E-07_JPRB,5.0404E-07_JPRB,2.1855E-06_JPRB,2.9070E-06_JPRB,3.2663E-06_JPRB,3.1458E-06_JPRB/)
KBO( :, 1,56, 1) = (/&
&1.4054E-07_JPRB,1.8176E-07_JPRB,1.1161E-06_JPRB,1.4834E-06_JPRB,1.6858E-06_JPRB,1.6706E-06_JPRB/)
KBO( :, 2,56, 1) = (/&
&1.8272E-07_JPRB,2.2962E-07_JPRB,1.3014E-06_JPRB,1.7377E-06_JPRB,1.9656E-06_JPRB,1.9215E-06_JPRB/)
KBO( :, 3,56, 1) = (/&
&2.2968E-07_JPRB,2.8144E-07_JPRB,1.4702E-06_JPRB,1.9602E-06_JPRB,2.2149E-06_JPRB,2.1478E-06_JPRB/)
KBO( :, 4,56, 1) = (/&
&2.7973E-07_JPRB,3.3709E-07_JPRB,1.6219E-06_JPRB,2.1586E-06_JPRB,2.4358E-06_JPRB,2.3428E-06_JPRB/)
KBO( :, 5,56, 1) = (/&
&3.3292E-07_JPRB,3.9535E-07_JPRB,1.7578E-06_JPRB,2.3398E-06_JPRB,2.6321E-06_JPRB,2.5058E-06_JPRB/)
KBO( :, 1,57, 1) = (/&
&1.0510E-07_JPRB,1.3750E-07_JPRB,8.6405E-07_JPRB,1.1473E-06_JPRB,1.3076E-06_JPRB,1.2850E-06_JPRB/)
KBO( :, 2,57, 1) = (/&
&1.3849E-07_JPRB,1.7560E-07_JPRB,1.0222E-06_JPRB,1.3638E-06_JPRB,1.5446E-06_JPRB,1.4961E-06_JPRB/)
KBO( :, 3,57, 1) = (/&
&1.7599E-07_JPRB,2.1727E-07_JPRB,1.1659E-06_JPRB,1.5556E-06_JPRB,1.7583E-06_JPRB,1.6859E-06_JPRB/)
KBO( :, 4,57, 1) = (/&
&2.1642E-07_JPRB,2.6216E-07_JPRB,1.2954E-06_JPRB,1.7252E-06_JPRB,1.9483E-06_JPRB,1.8528E-06_JPRB/)
KBO( :, 5,57, 1) = (/&
&2.5937E-07_JPRB,3.0954E-07_JPRB,1.4120E-06_JPRB,1.8802E-06_JPRB,2.1177E-06_JPRB,1.9931E-06_JPRB/)
KBO( :, 1,58, 1) = (/&
&7.8562E-08_JPRB,1.0412E-07_JPRB,6.6697E-07_JPRB,8.8547E-07_JPRB,1.0122E-06_JPRB,9.8359E-07_JPRB/)
KBO( :, 2,58, 1) = (/&
&1.0505E-07_JPRB,1.3435E-07_JPRB,8.0186E-07_JPRB,1.0688E-06_JPRB,1.2123E-06_JPRB,1.1602E-06_JPRB/)
KBO( :, 3,58, 1) = (/&
&1.3491E-07_JPRB,1.6781E-07_JPRB,9.2343E-07_JPRB,1.2330E-06_JPRB,1.3947E-06_JPRB,1.3189E-06_JPRB/)
KBO( :, 4,58, 1) = (/&
&1.6755E-07_JPRB,2.0398E-07_JPRB,1.0341E-06_JPRB,1.3781E-06_JPRB,1.5576E-06_JPRB,1.4600E-06_JPRB/)
KBO( :, 5,58, 1) = (/&
&2.0219E-07_JPRB,2.4245E-07_JPRB,1.1337E-06_JPRB,1.5104E-06_JPRB,1.7029E-06_JPRB,1.5797E-06_JPRB/)
KBO( :, 1,59, 1) = (/&
&6.2032E-08_JPRB,8.2667E-08_JPRB,5.3358E-07_JPRB,7.0860E-07_JPRB,8.1061E-07_JPRB,7.5992E-07_JPRB/)
KBO( :, 2,59, 1) = (/&
&8.3464E-08_JPRB,1.0714E-07_JPRB,6.4596E-07_JPRB,8.6092E-07_JPRB,9.7714E-07_JPRB,9.0330E-07_JPRB/)
KBO( :, 3,59, 1) = (/&
&1.0772E-07_JPRB,1.3445E-07_JPRB,7.4727E-07_JPRB,9.9822E-07_JPRB,1.1293E-06_JPRB,1.0310E-06_JPRB/)
KBO( :, 4,59, 1) = (/&
&1.3434E-07_JPRB,1.6394E-07_JPRB,8.4000E-07_JPRB,1.1197E-06_JPRB,1.2658E-06_JPRB,1.1431E-06_JPRB/)
KBO( :, 5,59, 1) = (/&
&1.6260E-07_JPRB,1.9540E-07_JPRB,9.2328E-07_JPRB,1.2307E-06_JPRB,1.3881E-06_JPRB,1.2388E-06_JPRB/)
KBO( :, 1,13, 2) = (/&
&3.6523E-03_JPRB,3.8939E-03_JPRB,1.9272E-02_JPRB,2.7740E-02_JPRB,3.3512E-02_JPRB,3.3627E-02_JPRB/)
KBO( :, 2,13, 2) = (/&
&4.0698E-03_JPRB,4.3006E-03_JPRB,2.0140E-02_JPRB,2.9159E-02_JPRB,3.5603E-02_JPRB,3.6375E-02_JPRB/)
KBO( :, 3,13, 2) = (/&
&4.4412E-03_JPRB,4.6650E-03_JPRB,2.0907E-02_JPRB,3.0329E-02_JPRB,3.7178E-02_JPRB,3.8732E-02_JPRB/)
KBO( :, 4,13, 2) = (/&
&4.7483E-03_JPRB,4.9652E-03_JPRB,2.1592E-02_JPRB,3.1266E-02_JPRB,3.8222E-02_JPRB,4.0514E-02_JPRB/)
KBO( :, 5,13, 2) = (/&
&4.9829E-03_JPRB,5.1938E-03_JPRB,2.2168E-02_JPRB,3.1969E-02_JPRB,3.8794E-02_JPRB,4.1741E-02_JPRB/)
KBO( :, 1,14, 2) = (/&
&3.0865E-03_JPRB,3.3200E-03_JPRB,1.6531E-02_JPRB,2.3817E-02_JPRB,2.8897E-02_JPRB,2.8142E-02_JPRB/)
KBO( :, 2,14, 2) = (/&
&3.4362E-03_JPRB,3.6603E-03_JPRB,1.7252E-02_JPRB,2.4966E-02_JPRB,3.0545E-02_JPRB,3.0211E-02_JPRB/)
KBO( :, 3,14, 2) = (/&
&3.7431E-03_JPRB,3.9586E-03_JPRB,1.7899E-02_JPRB,2.5891E-02_JPRB,3.1684E-02_JPRB,3.1824E-02_JPRB/)
KBO( :, 4,14, 2) = (/&
&3.9872E-03_JPRB,4.1955E-03_JPRB,1.8459E-02_JPRB,2.6594E-02_JPRB,3.2362E-02_JPRB,3.2907E-02_JPRB/)
KBO( :, 5,14, 2) = (/&
&4.1703E-03_JPRB,4.3748E-03_JPRB,1.8911E-02_JPRB,2.7074E-02_JPRB,3.2683E-02_JPRB,3.3591E-02_JPRB/)
KBO( :, 1,15, 2) = (/&
&2.6115E-03_JPRB,2.8311E-03_JPRB,1.4085E-02_JPRB,2.0304E-02_JPRB,2.4710E-02_JPRB,2.3514E-02_JPRB/)
KBO( :, 2,15, 2) = (/&
&2.9041E-03_JPRB,3.1144E-03_JPRB,1.4680E-02_JPRB,2.1210E-02_JPRB,2.5931E-02_JPRB,2.4999E-02_JPRB/)
KBO( :, 3,15, 2) = (/&
&3.1530E-03_JPRB,3.3540E-03_JPRB,1.5212E-02_JPRB,2.1904E-02_JPRB,2.6711E-02_JPRB,2.6064E-02_JPRB/)
KBO( :, 4,15, 2) = (/&
&3.3446E-03_JPRB,3.5395E-03_JPRB,1.5641E-02_JPRB,2.2409E-02_JPRB,2.7141E-02_JPRB,2.6755E-02_JPRB/)
KBO( :, 5,15, 2) = (/&
&3.4849E-03_JPRB,3.6794E-03_JPRB,1.5995E-02_JPRB,2.2750E-02_JPRB,2.7330E-02_JPRB,2.7152E-02_JPRB/)
KBO( :, 1,16, 2) = (/&
&2.2129E-03_JPRB,2.4168E-03_JPRB,1.1928E-02_JPRB,1.7179E-02_JPRB,2.0938E-02_JPRB,1.9617E-02_JPRB/)
KBO( :, 2,16, 2) = (/&
&2.4536E-03_JPRB,2.6491E-03_JPRB,1.2409E-02_JPRB,1.7866E-02_JPRB,2.1799E-02_JPRB,2.0682E-02_JPRB/)
KBO( :, 3,16, 2) = (/&
&2.6514E-03_JPRB,2.8384E-03_JPRB,1.2822E-02_JPRB,1.8380E-02_JPRB,2.2338E-02_JPRB,2.1426E-02_JPRB/)
KBO( :, 4,16, 2) = (/&
&2.7951E-03_JPRB,2.9778E-03_JPRB,1.3157E-02_JPRB,1.8769E-02_JPRB,2.2630E-02_JPRB,2.1902E-02_JPRB/)
KBO( :, 5,16, 2) = (/&
&2.9036E-03_JPRB,3.0860E-03_JPRB,1.3435E-02_JPRB,1.9027E-02_JPRB,2.2746E-02_JPRB,2.2146E-02_JPRB/)
KBO( :, 1,17, 2) = (/&
&1.8735E-03_JPRB,2.0627E-03_JPRB,1.0036E-02_JPRB,1.4424E-02_JPRB,1.7577E-02_JPRB,1.6265E-02_JPRB/)
KBO( :, 2,17, 2) = (/&
&2.0662E-03_JPRB,2.2488E-03_JPRB,1.0418E-02_JPRB,1.4944E-02_JPRB,1.8199E-02_JPRB,1.7052E-02_JPRB/)
KBO( :, 3,17, 2) = (/&
&2.2194E-03_JPRB,2.3925E-03_JPRB,1.0739E-02_JPRB,1.5350E-02_JPRB,1.8589E-02_JPRB,1.7595E-02_JPRB/)
KBO( :, 4,17, 2) = (/&
&2.3291E-03_JPRB,2.4990E-03_JPRB,1.1009E-02_JPRB,1.5656E-02_JPRB,1.8796E-02_JPRB,1.7924E-02_JPRB/)
KBO( :, 5,17, 2) = (/&
&2.4168E-03_JPRB,2.5869E-03_JPRB,1.1220E-02_JPRB,1.5867E-02_JPRB,1.8872E-02_JPRB,1.8072E-02_JPRB/)
KBO( :, 1,18, 2) = (/&
&1.5803E-03_JPRB,1.7549E-03_JPRB,8.3982E-03_JPRB,1.2038E-02_JPRB,1.4657E-02_JPRB,1.3443E-02_JPRB/)
KBO( :, 2,18, 2) = (/&
&1.7325E-03_JPRB,1.9010E-03_JPRB,8.7001E-03_JPRB,1.2445E-02_JPRB,1.5124E-02_JPRB,1.4037E-02_JPRB/)
KBO( :, 3,18, 2) = (/&
&1.8506E-03_JPRB,2.0095E-03_JPRB,8.9599E-03_JPRB,1.2773E-02_JPRB,1.5415E-02_JPRB,1.4442E-02_JPRB/)
KBO( :, 4,18, 2) = (/&
&1.9372E-03_JPRB,2.0945E-03_JPRB,9.1682E-03_JPRB,1.3023E-02_JPRB,1.5571E-02_JPRB,1.4673E-02_JPRB/)
KBO( :, 5,18, 2) = (/&
&2.0086E-03_JPRB,2.1668E-03_JPRB,9.3360E-03_JPRB,1.3189E-02_JPRB,1.5627E-02_JPRB,1.4767E-02_JPRB/)
KBO( :, 1,19, 2) = (/&
&1.3263E-03_JPRB,1.4842E-03_JPRB,6.9965E-03_JPRB,1.0005E-02_JPRB,1.2171E-02_JPRB,1.1073E-02_JPRB/)
KBO( :, 2,19, 2) = (/&
&1.4463E-03_JPRB,1.5975E-03_JPRB,7.2420E-03_JPRB,1.0335E-02_JPRB,1.2532E-02_JPRB,1.1527E-02_JPRB/)
KBO( :, 3,19, 2) = (/&
&1.5391E-03_JPRB,1.6819E-03_JPRB,7.4473E-03_JPRB,1.0605E-02_JPRB,1.2756E-02_JPRB,1.1825E-02_JPRB/)
KBO( :, 4,19, 2) = (/&
&1.6087E-03_JPRB,1.7515E-03_JPRB,7.6132E-03_JPRB,1.0806E-02_JPRB,1.2879E-02_JPRB,1.1987E-02_JPRB/)
KBO( :, 5,19, 2) = (/&
&1.6667E-03_JPRB,1.8113E-03_JPRB,7.7489E-03_JPRB,1.0927E-02_JPRB,1.2923E-02_JPRB,1.2042E-02_JPRB/)
KBO( :, 1,20, 2) = (/&
&1.1106E-03_JPRB,1.2504E-03_JPRB,5.8179E-03_JPRB,8.3016E-03_JPRB,1.0088E-02_JPRB,9.1254E-03_JPRB/)
KBO( :, 2,20, 2) = (/&
&1.2060E-03_JPRB,1.3385E-03_JPRB,6.0163E-03_JPRB,8.5726E-03_JPRB,1.0368E-02_JPRB,9.4723E-03_JPRB/)
KBO( :, 3,20, 2) = (/&
&1.2789E-03_JPRB,1.4052E-03_JPRB,6.1769E-03_JPRB,8.7907E-03_JPRB,1.0541E-02_JPRB,9.6942E-03_JPRB/)
KBO( :, 4,20, 2) = (/&
&1.3351E-03_JPRB,1.4622E-03_JPRB,6.3118E-03_JPRB,8.9433E-03_JPRB,1.0640E-02_JPRB,9.8077E-03_JPRB/)
KBO( :, 5,20, 2) = (/&
&1.3825E-03_JPRB,1.5123E-03_JPRB,6.4218E-03_JPRB,9.0350E-03_JPRB,1.0672E-02_JPRB,9.8366E-03_JPRB/)
KBO( :, 1,21, 2) = (/&
&9.2789E-04_JPRB,1.0499E-03_JPRB,4.8309E-03_JPRB,6.8776E-03_JPRB,8.3442E-03_JPRB,7.5157E-03_JPRB/)
KBO( :, 2,21, 2) = (/&
&1.0039E-03_JPRB,1.1183E-03_JPRB,4.9870E-03_JPRB,7.1016E-03_JPRB,8.5650E-03_JPRB,7.7816E-03_JPRB/)
KBO( :, 3,21, 2) = (/&
&1.0617E-03_JPRB,1.1723E-03_JPRB,5.1161E-03_JPRB,7.2723E-03_JPRB,8.7032E-03_JPRB,7.9463E-03_JPRB/)
KBO( :, 4,21, 2) = (/&
&1.1070E-03_JPRB,1.2185E-03_JPRB,5.2236E-03_JPRB,7.3886E-03_JPRB,8.7799E-03_JPRB,8.0257E-03_JPRB/)
KBO( :, 5,21, 2) = (/&
&1.1455E-03_JPRB,1.2607E-03_JPRB,5.3143E-03_JPRB,7.4590E-03_JPRB,8.7976E-03_JPRB,8.0381E-03_JPRB/)
KBO( :, 1,22, 2) = (/&
&7.7838E-04_JPRB,8.8274E-04_JPRB,4.0143E-03_JPRB,5.7070E-03_JPRB,6.9079E-03_JPRB,6.2019E-03_JPRB/)
KBO( :, 2,22, 2) = (/&
&8.3803E-04_JPRB,9.3549E-04_JPRB,4.1360E-03_JPRB,5.8838E-03_JPRB,7.0782E-03_JPRB,6.4006E-03_JPRB/)
KBO( :, 3,22, 2) = (/&
&8.8314E-04_JPRB,9.7914E-04_JPRB,4.2374E-03_JPRB,6.0145E-03_JPRB,7.1845E-03_JPRB,6.5168E-03_JPRB/)
KBO( :, 4,22, 2) = (/&
&9.1968E-04_JPRB,1.0165E-03_JPRB,4.3241E-03_JPRB,6.1026E-03_JPRB,7.2358E-03_JPRB,6.5682E-03_JPRB/)
KBO( :, 5,22, 2) = (/&
&9.5047E-04_JPRB,1.0512E-03_JPRB,4.4012E-03_JPRB,6.1547E-03_JPRB,7.2428E-03_JPRB,6.5673E-03_JPRB/)
KBO( :, 1,23, 2) = (/&
&6.5215E-04_JPRB,7.4036E-04_JPRB,3.3305E-03_JPRB,4.7319E-03_JPRB,5.7142E-03_JPRB,5.1137E-03_JPRB/)
KBO( :, 2,23, 2) = (/&
&6.9894E-04_JPRB,7.8162E-04_JPRB,3.4264E-03_JPRB,4.8693E-03_JPRB,5.8456E-03_JPRB,5.2602E-03_JPRB/)
KBO( :, 3,23, 2) = (/&
&7.3388E-04_JPRB,8.1618E-04_JPRB,3.5078E-03_JPRB,4.9682E-03_JPRB,5.9222E-03_JPRB,5.3417E-03_JPRB/)
KBO( :, 4,23, 2) = (/&
&7.6333E-04_JPRB,8.4695E-04_JPRB,3.5799E-03_JPRB,5.0349E-03_JPRB,5.9564E-03_JPRB,5.3733E-03_JPRB/)
KBO( :, 5,23, 2) = (/&
&7.8904E-04_JPRB,8.7612E-04_JPRB,3.6454E-03_JPRB,5.0755E-03_JPRB,5.9574E-03_JPRB,5.3648E-03_JPRB/)
KBO( :, 1,24, 2) = (/&
&5.4610E-04_JPRB,6.1977E-04_JPRB,2.7598E-03_JPRB,3.9203E-03_JPRB,4.7245E-03_JPRB,4.2113E-03_JPRB/)
KBO( :, 2,24, 2) = (/&
&5.8222E-04_JPRB,6.5205E-04_JPRB,2.8366E-03_JPRB,4.0258E-03_JPRB,4.8222E-03_JPRB,4.3180E-03_JPRB/)
KBO( :, 3,24, 2) = (/&
&6.0969E-04_JPRB,6.7974E-04_JPRB,2.9034E-03_JPRB,4.1010E-03_JPRB,4.8778E-03_JPRB,4.3739E-03_JPRB/)
KBO( :, 4,24, 2) = (/&
&6.3347E-04_JPRB,7.0509E-04_JPRB,2.9644E-03_JPRB,4.1523E-03_JPRB,4.8995E-03_JPRB,4.3910E-03_JPRB/)
KBO( :, 5,24, 2) = (/&
&6.5545E-04_JPRB,7.3021E-04_JPRB,3.0198E-03_JPRB,4.1861E-03_JPRB,4.8976E-03_JPRB,4.3789E-03_JPRB/)
KBO( :, 1,25, 2) = (/&
&4.5690E-04_JPRB,5.1793E-04_JPRB,2.2852E-03_JPRB,3.2458E-03_JPRB,3.9043E-03_JPRB,3.4680E-03_JPRB/)
KBO( :, 2,25, 2) = (/&
&4.8458E-04_JPRB,5.4334E-04_JPRB,2.3475E-03_JPRB,3.3264E-03_JPRB,3.9752E-03_JPRB,3.5434E-03_JPRB/)
KBO( :, 3,25, 2) = (/&
&5.0654E-04_JPRB,5.6573E-04_JPRB,2.4036E-03_JPRB,3.3847E-03_JPRB,4.0147E-03_JPRB,3.5813E-03_JPRB/)
KBO( :, 4,25, 2) = (/&
&5.2568E-04_JPRB,5.8676E-04_JPRB,2.4547E-03_JPRB,3.4258E-03_JPRB,4.0284E-03_JPRB,3.5893E-03_JPRB/)
KBO( :, 5,25, 2) = (/&
&5.4469E-04_JPRB,6.0841E-04_JPRB,2.5000E-03_JPRB,3.4530E-03_JPRB,4.0252E-03_JPRB,3.5735E-03_JPRB/)
KBO( :, 1,26, 2) = (/&
&3.8205E-04_JPRB,4.3242E-04_JPRB,1.8925E-03_JPRB,2.6857E-03_JPRB,3.2237E-03_JPRB,2.8541E-03_JPRB/)
KBO( :, 2,26, 2) = (/&
&4.0335E-04_JPRB,4.5263E-04_JPRB,1.9438E-03_JPRB,2.7484E-03_JPRB,3.2757E-03_JPRB,2.9087E-03_JPRB/)
KBO( :, 3,26, 2) = (/&
&4.2092E-04_JPRB,4.7075E-04_JPRB,1.9904E-03_JPRB,2.7942E-03_JPRB,3.3026E-03_JPRB,2.9324E-03_JPRB/)
KBO( :, 4,26, 2) = (/&
&4.3655E-04_JPRB,4.8821E-04_JPRB,2.0326E-03_JPRB,2.8271E-03_JPRB,3.3119E-03_JPRB,2.9344E-03_JPRB/)
KBO( :, 5,26, 2) = (/&
&4.5316E-04_JPRB,5.0712E-04_JPRB,2.0685E-03_JPRB,2.8499E-03_JPRB,3.3084E-03_JPRB,2.9162E-03_JPRB/)
KBO( :, 1,27, 2) = (/&
&3.1896E-04_JPRB,3.6052E-04_JPRB,1.5673E-03_JPRB,2.2211E-03_JPRB,2.6601E-03_JPRB,2.3492E-03_JPRB/)
KBO( :, 2,27, 2) = (/&
&3.3544E-04_JPRB,3.7654E-04_JPRB,1.6095E-03_JPRB,2.2697E-03_JPRB,2.6969E-03_JPRB,2.3868E-03_JPRB/)
KBO( :, 3,27, 2) = (/&
&3.4965E-04_JPRB,3.9143E-04_JPRB,1.6478E-03_JPRB,2.3068E-03_JPRB,2.7163E-03_JPRB,2.4023E-03_JPRB/)
KBO( :, 4,27, 2) = (/&
&3.6268E-04_JPRB,4.0612E-04_JPRB,1.6818E-03_JPRB,2.3333E-03_JPRB,2.7227E-03_JPRB,2.3999E-03_JPRB/)
KBO( :, 5,27, 2) = (/&
&3.7708E-04_JPRB,4.2263E-04_JPRB,1.7104E-03_JPRB,2.3514E-03_JPRB,2.7191E-03_JPRB,2.3811E-03_JPRB/)
KBO( :, 1,28, 2) = (/&
&2.6585E-04_JPRB,3.0014E-04_JPRB,1.2979E-03_JPRB,1.8363E-03_JPRB,2.1935E-03_JPRB,1.9332E-03_JPRB/)
KBO( :, 2,28, 2) = (/&
&2.7887E-04_JPRB,3.1300E-04_JPRB,1.3325E-03_JPRB,1.8753E-03_JPRB,2.2207E-03_JPRB,1.9593E-03_JPRB/)
KBO( :, 3,28, 2) = (/&
&2.9041E-04_JPRB,3.2530E-04_JPRB,1.3637E-03_JPRB,1.9047E-03_JPRB,2.2348E-03_JPRB,1.9687E-03_JPRB/)
KBO( :, 4,28, 2) = (/&
&3.0139E-04_JPRB,3.3786E-04_JPRB,1.3910E-03_JPRB,1.9260E-03_JPRB,2.2395E-03_JPRB,1.9637E-03_JPRB/)
KBO( :, 5,28, 2) = (/&
&3.1381E-04_JPRB,3.5218E-04_JPRB,1.4147E-03_JPRB,1.9395E-03_JPRB,2.2363E-03_JPRB,1.9458E-03_JPRB/)
KBO( :, 1,29, 2) = (/&
&2.2143E-04_JPRB,2.4968E-04_JPRB,1.0748E-03_JPRB,1.5182E-03_JPRB,1.8078E-03_JPRB,1.5923E-03_JPRB/)
KBO( :, 2,29, 2) = (/&
&2.3186E-04_JPRB,2.6016E-04_JPRB,1.1033E-03_JPRB,1.5493E-03_JPRB,1.8281E-03_JPRB,1.6104E-03_JPRB/)
KBO( :, 3,29, 2) = (/&
&2.4121E-04_JPRB,2.7036E-04_JPRB,1.1285E-03_JPRB,1.5726E-03_JPRB,1.8388E-03_JPRB,1.6155E-03_JPRB/)
KBO( :, 4,29, 2) = (/&
&2.5062E-04_JPRB,2.8128E-04_JPRB,1.1506E-03_JPRB,1.5888E-03_JPRB,1.8420E-03_JPRB,1.6082E-03_JPRB/)
KBO( :, 5,29, 2) = (/&
&2.6130E-04_JPRB,2.9358E-04_JPRB,1.1704E-03_JPRB,1.5992E-03_JPRB,1.8391E-03_JPRB,1.5924E-03_JPRB/)
KBO( :, 1,30, 2) = (/&
&1.8434E-04_JPRB,2.0754E-04_JPRB,8.9026E-04_JPRB,1.2554E-03_JPRB,1.4899E-03_JPRB,1.3119E-03_JPRB/)
KBO( :, 2,30, 2) = (/&
&1.9271E-04_JPRB,2.1620E-04_JPRB,9.1339E-04_JPRB,1.2800E-03_JPRB,1.5055E-03_JPRB,1.3245E-03_JPRB/)
KBO( :, 3,30, 2) = (/&
&2.0034E-04_JPRB,2.2477E-04_JPRB,9.3373E-04_JPRB,1.2981E-03_JPRB,1.5133E-03_JPRB,1.3262E-03_JPRB/)
KBO( :, 4,30, 2) = (/&
&2.0838E-04_JPRB,2.3416E-04_JPRB,9.5188E-04_JPRB,1.3104E-03_JPRB,1.5159E-03_JPRB,1.3190E-03_JPRB/)
KBO( :, 5,30, 2) = (/&
&2.1766E-04_JPRB,2.4475E-04_JPRB,9.6842E-04_JPRB,1.3190E-03_JPRB,1.5130E-03_JPRB,1.3047E-03_JPRB/)
KBO( :, 1,31, 2) = (/&
&1.5342E-04_JPRB,1.7254E-04_JPRB,7.3736E-04_JPRB,1.0379E-03_JPRB,1.2280E-03_JPRB,1.0823E-03_JPRB/)
KBO( :, 2,31, 2) = (/&
&1.6018E-04_JPRB,1.7972E-04_JPRB,7.5593E-04_JPRB,1.0574E-03_JPRB,1.2397E-03_JPRB,1.0908E-03_JPRB/)
KBO( :, 3,31, 2) = (/&
&1.6648E-04_JPRB,1.8697E-04_JPRB,7.7274E-04_JPRB,1.0714E-03_JPRB,1.2460E-03_JPRB,1.0906E-03_JPRB/)
KBO( :, 4,31, 2) = (/&
&1.7342E-04_JPRB,1.9506E-04_JPRB,7.8773E-04_JPRB,1.0812E-03_JPRB,1.2476E-03_JPRB,1.0837E-03_JPRB/)
KBO( :, 5,31, 2) = (/&
&1.8149E-04_JPRB,2.0420E-04_JPRB,8.0154E-04_JPRB,1.0881E-03_JPRB,1.2445E-03_JPRB,1.0711E-03_JPRB/)
KBO( :, 1,32, 2) = (/&
&1.2767E-04_JPRB,1.4347E-04_JPRB,6.1066E-04_JPRB,8.5823E-04_JPRB,1.0121E-03_JPRB,8.9310E-04_JPRB/)
KBO( :, 2,32, 2) = (/&
&1.3312E-04_JPRB,1.4941E-04_JPRB,6.2581E-04_JPRB,8.7345E-04_JPRB,1.0214E-03_JPRB,8.9860E-04_JPRB/)
KBO( :, 3,32, 2) = (/&
&1.3844E-04_JPRB,1.5562E-04_JPRB,6.3952E-04_JPRB,8.8432E-04_JPRB,1.0259E-03_JPRB,8.9742E-04_JPRB/)
KBO( :, 4,32, 2) = (/&
&1.4447E-04_JPRB,1.6260E-04_JPRB,6.5205E-04_JPRB,8.9226E-04_JPRB,1.0266E-03_JPRB,8.9098E-04_JPRB/)
KBO( :, 5,32, 2) = (/&
&1.5144E-04_JPRB,1.7054E-04_JPRB,6.6359E-04_JPRB,8.9794E-04_JPRB,1.0240E-03_JPRB,8.8056E-04_JPRB/)
KBO( :, 1,33, 2) = (/&
&1.0619E-04_JPRB,1.1931E-04_JPRB,5.0573E-04_JPRB,7.0964E-04_JPRB,8.3455E-04_JPRB,7.3747E-04_JPRB/)
KBO( :, 2,33, 2) = (/&
&1.1061E-04_JPRB,1.2424E-04_JPRB,5.1808E-04_JPRB,7.2136E-04_JPRB,8.4148E-04_JPRB,7.4075E-04_JPRB/)
KBO( :, 3,33, 2) = (/&
&1.1517E-04_JPRB,1.2959E-04_JPRB,5.2944E-04_JPRB,7.3007E-04_JPRB,8.4469E-04_JPRB,7.3913E-04_JPRB/)
KBO( :, 4,33, 2) = (/&
&1.2041E-04_JPRB,1.3563E-04_JPRB,5.3985E-04_JPRB,7.3647E-04_JPRB,8.4479E-04_JPRB,7.3349E-04_JPRB/)
KBO( :, 5,33, 2) = (/&
&1.2648E-04_JPRB,1.4256E-04_JPRB,5.4947E-04_JPRB,7.4123E-04_JPRB,8.4271E-04_JPRB,7.2498E-04_JPRB/)
KBO( :, 1,34, 2) = (/&
&8.8157E-05_JPRB,9.9062E-05_JPRB,4.1842E-04_JPRB,5.8633E-04_JPRB,6.8789E-04_JPRB,6.0807E-04_JPRB/)
KBO( :, 2,34, 2) = (/&
&9.1811E-05_JPRB,1.0321E-04_JPRB,4.2863E-04_JPRB,5.9556E-04_JPRB,6.9312E-04_JPRB,6.1023E-04_JPRB/)
KBO( :, 3,34, 2) = (/&
&9.5729E-05_JPRB,1.0782E-04_JPRB,4.3808E-04_JPRB,6.0259E-04_JPRB,6.9556E-04_JPRB,6.0848E-04_JPRB/)
KBO( :, 4,34, 2) = (/&
&1.0025E-04_JPRB,1.1302E-04_JPRB,4.4678E-04_JPRB,6.0791E-04_JPRB,6.9562E-04_JPRB,6.0393E-04_JPRB/)
KBO( :, 5,34, 2) = (/&
&1.0555E-04_JPRB,1.1907E-04_JPRB,4.5478E-04_JPRB,6.1180E-04_JPRB,6.9395E-04_JPRB,5.9689E-04_JPRB/)
KBO( :, 1,35, 2) = (/&
&7.2889E-05_JPRB,8.1925E-05_JPRB,3.4533E-04_JPRB,4.8352E-04_JPRB,5.6643E-04_JPRB,5.0117E-04_JPRB/)
KBO( :, 2,35, 2) = (/&
&7.5938E-05_JPRB,8.5438E-05_JPRB,3.5394E-04_JPRB,4.9121E-04_JPRB,5.7081E-04_JPRB,5.0282E-04_JPRB/)
KBO( :, 3,35, 2) = (/&
&7.9261E-05_JPRB,8.9337E-05_JPRB,3.6188E-04_JPRB,4.9693E-04_JPRB,5.7284E-04_JPRB,5.0143E-04_JPRB/)
KBO( :, 4,35, 2) = (/&
&8.3119E-05_JPRB,9.3779E-05_JPRB,3.6918E-04_JPRB,5.0156E-04_JPRB,5.7314E-04_JPRB,4.9808E-04_JPRB/)
KBO( :, 5,35, 2) = (/&
&8.7666E-05_JPRB,9.8982E-05_JPRB,3.7599E-04_JPRB,5.0487E-04_JPRB,5.7194E-04_JPRB,4.9242E-04_JPRB/)
KBO( :, 1,36, 2) = (/&
&5.9995E-05_JPRB,6.7468E-05_JPRB,2.8433E-04_JPRB,3.9801E-04_JPRB,4.6610E-04_JPRB,4.1281E-04_JPRB/)
KBO( :, 2,36, 2) = (/&
&6.2532E-05_JPRB,7.0399E-05_JPRB,2.9160E-04_JPRB,4.0447E-04_JPRB,4.6992E-04_JPRB,4.1443E-04_JPRB/)
KBO( :, 3,36, 2) = (/&
&6.5308E-05_JPRB,7.3661E-05_JPRB,2.9838E-04_JPRB,4.0950E-04_JPRB,4.7187E-04_JPRB,4.1372E-04_JPRB/)
KBO( :, 4,36, 2) = (/&
&6.8562E-05_JPRB,7.7412E-05_JPRB,3.0448E-04_JPRB,4.1355E-04_JPRB,4.7234E-04_JPRB,4.1122E-04_JPRB/)
KBO( :, 5,36, 2) = (/&
&7.2367E-05_JPRB,8.1795E-05_JPRB,3.1033E-04_JPRB,4.1642E-04_JPRB,4.7161E-04_JPRB,4.0689E-04_JPRB/)
KBO( :, 1,37, 2) = (/&
&4.9059E-05_JPRB,5.5199E-05_JPRB,2.3317E-04_JPRB,3.2671E-04_JPRB,3.8295E-04_JPRB,3.3938E-04_JPRB/)
KBO( :, 2,37, 2) = (/&
&5.1165E-05_JPRB,5.7620E-05_JPRB,2.3941E-04_JPRB,3.3239E-04_JPRB,3.8652E-04_JPRB,3.4120E-04_JPRB/)
KBO( :, 3,37, 2) = (/&
&5.3443E-05_JPRB,6.0304E-05_JPRB,2.4519E-04_JPRB,3.3687E-04_JPRB,3.8853E-04_JPRB,3.4110E-04_JPRB/)
KBO( :, 4,37, 2) = (/&
&5.6114E-05_JPRB,6.3395E-05_JPRB,2.5044E-04_JPRB,3.4049E-04_JPRB,3.8930E-04_JPRB,3.3955E-04_JPRB/)
KBO( :, 5,37, 2) = (/&
&5.9214E-05_JPRB,6.6999E-05_JPRB,2.5546E-04_JPRB,3.4318E-04_JPRB,3.8905E-04_JPRB,3.3631E-04_JPRB/)
KBO( :, 1,38, 2) = (/&
&4.0104E-05_JPRB,4.5145E-05_JPRB,1.9118E-04_JPRB,2.6808E-04_JPRB,3.1457E-04_JPRB,2.7912E-04_JPRB/)
KBO( :, 2,38, 2) = (/&
&4.1848E-05_JPRB,4.7145E-05_JPRB,1.9649E-04_JPRB,2.7305E-04_JPRB,3.1789E-04_JPRB,2.8112E-04_JPRB/)
KBO( :, 3,38, 2) = (/&
&4.3721E-05_JPRB,4.9348E-05_JPRB,2.0143E-04_JPRB,2.7709E-04_JPRB,3.1990E-04_JPRB,2.8154E-04_JPRB/)
KBO( :, 4,38, 2) = (/&
&4.5908E-05_JPRB,5.1893E-05_JPRB,2.0595E-04_JPRB,2.8033E-04_JPRB,3.2086E-04_JPRB,2.8062E-04_JPRB/)
KBO( :, 5,38, 2) = (/&
&4.8428E-05_JPRB,5.4848E-05_JPRB,2.1030E-04_JPRB,2.8287E-04_JPRB,3.2098E-04_JPRB,2.7832E-04_JPRB/)
KBO( :, 1,39, 2) = (/&
&3.2779E-05_JPRB,3.6913E-05_JPRB,1.5676E-04_JPRB,2.1996E-04_JPRB,2.5835E-04_JPRB,2.2986E-04_JPRB/)
KBO( :, 2,39, 2) = (/&
&3.4226E-05_JPRB,3.8568E-05_JPRB,1.6127E-04_JPRB,2.2431E-04_JPRB,2.6140E-04_JPRB,2.3193E-04_JPRB/)
KBO( :, 3,39, 2) = (/&
&3.5764E-05_JPRB,4.0382E-05_JPRB,1.6550E-04_JPRB,2.2790E-04_JPRB,2.6334E-04_JPRB,2.3271E-04_JPRB/)
KBO( :, 4,39, 2) = (/&
&3.7558E-05_JPRB,4.2480E-05_JPRB,1.6939E-04_JPRB,2.3082E-04_JPRB,2.6439E-04_JPRB,2.3230E-04_JPRB/)
KBO( :, 5,39, 2) = (/&
&3.9596E-05_JPRB,4.4889E-05_JPRB,1.7315E-04_JPRB,2.3313E-04_JPRB,2.6477E-04_JPRB,2.3072E-04_JPRB/)
KBO( :, 1,40, 2) = (/&
&2.6669E-05_JPRB,3.0049E-05_JPRB,1.2812E-04_JPRB,1.8003E-04_JPRB,2.1187E-04_JPRB,1.8838E-04_JPRB/)
KBO( :, 2,40, 2) = (/&
&2.7871E-05_JPRB,3.1411E-05_JPRB,1.3197E-04_JPRB,1.8389E-04_JPRB,2.1472E-04_JPRB,1.9052E-04_JPRB/)
KBO( :, 3,40, 2) = (/&
&2.9115E-05_JPRB,3.2883E-05_JPRB,1.3564E-04_JPRB,1.8717E-04_JPRB,2.1664E-04_JPRB,1.9149E-04_JPRB/)
KBO( :, 4,40, 2) = (/&
&3.0569E-05_JPRB,3.4584E-05_JPRB,1.3899E-04_JPRB,1.8980E-04_JPRB,2.1779E-04_JPRB,1.9147E-04_JPRB/)
KBO( :, 5,40, 2) = (/&
&3.2192E-05_JPRB,3.6525E-05_JPRB,1.4223E-04_JPRB,1.9192E-04_JPRB,2.1835E-04_JPRB,1.9045E-04_JPRB/)
KBO( :, 1,41, 2) = (/&
&2.1671E-05_JPRB,2.4436E-05_JPRB,1.0464E-04_JPRB,1.4721E-04_JPRB,1.7354E-04_JPRB,1.5422E-04_JPRB/)
KBO( :, 2,41, 2) = (/&
&2.2673E-05_JPRB,2.5564E-05_JPRB,1.0794E-04_JPRB,1.5067E-04_JPRB,1.7624E-04_JPRB,1.5635E-04_JPRB/)
KBO( :, 3,41, 2) = (/&
&2.3692E-05_JPRB,2.6758E-05_JPRB,1.1109E-04_JPRB,1.5359E-04_JPRB,1.7809E-04_JPRB,1.5746E-04_JPRB/)
KBO( :, 4,41, 2) = (/&
&2.4859E-05_JPRB,2.8133E-05_JPRB,1.1398E-04_JPRB,1.5600E-04_JPRB,1.7932E-04_JPRB,1.5772E-04_JPRB/)
KBO( :, 5,41, 2) = (/&
&2.6157E-05_JPRB,2.9694E-05_JPRB,1.1679E-04_JPRB,1.5797E-04_JPRB,1.8006E-04_JPRB,1.5714E-04_JPRB/)
KBO( :, 1,42, 2) = (/&
&1.7599E-05_JPRB,1.9868E-05_JPRB,8.5428E-05_JPRB,1.2033E-04_JPRB,1.4210E-04_JPRB,1.2624E-04_JPRB/)
KBO( :, 2,42, 2) = (/&
&1.8437E-05_JPRB,2.0798E-05_JPRB,8.8247E-05_JPRB,1.2340E-04_JPRB,1.4460E-04_JPRB,1.2832E-04_JPRB/)
KBO( :, 3,42, 2) = (/&
&1.9276E-05_JPRB,2.1771E-05_JPRB,9.0940E-05_JPRB,1.2600E-04_JPRB,1.4636E-04_JPRB,1.2953E-04_JPRB/)
KBO( :, 4,42, 2) = (/&
&2.0214E-05_JPRB,2.2883E-05_JPRB,9.3444E-05_JPRB,1.2819E-04_JPRB,1.4761E-04_JPRB,1.2995E-04_JPRB/)
KBO( :, 5,42, 2) = (/&
&2.1256E-05_JPRB,2.4138E-05_JPRB,9.5879E-05_JPRB,1.2999E-04_JPRB,1.4842E-04_JPRB,1.2971E-04_JPRB/)
KBO( :, 1,43, 2) = (/&
&1.4241E-05_JPRB,1.6107E-05_JPRB,6.9575E-05_JPRB,9.8122E-05_JPRB,1.1610E-04_JPRB,1.0313E-04_JPRB/)
KBO( :, 2,43, 2) = (/&
&1.4953E-05_JPRB,1.6876E-05_JPRB,7.1989E-05_JPRB,1.0088E-04_JPRB,1.1847E-04_JPRB,1.0516E-04_JPRB/)
KBO( :, 3,43, 2) = (/&
&1.5643E-05_JPRB,1.7668E-05_JPRB,7.4322E-05_JPRB,1.0321E-04_JPRB,1.2016E-04_JPRB,1.0643E-04_JPRB/)
KBO( :, 4,43, 2) = (/&
&1.6392E-05_JPRB,1.8559E-05_JPRB,7.6469E-05_JPRB,1.0519E-04_JPRB,1.2140E-04_JPRB,1.0702E-04_JPRB/)
KBO( :, 5,43, 2) = (/&
&1.7225E-05_JPRB,1.9561E-05_JPRB,7.8569E-05_JPRB,1.0686E-04_JPRB,1.2228E-04_JPRB,1.0704E-04_JPRB/)
KBO( :, 1,44, 2) = (/&
&1.1498E-05_JPRB,1.3036E-05_JPRB,5.6576E-05_JPRB,7.9895E-05_JPRB,9.4733E-05_JPRB,8.4131E-05_JPRB/)
KBO( :, 2,44, 2) = (/&
&1.2106E-05_JPRB,1.3670E-05_JPRB,5.8637E-05_JPRB,8.2333E-05_JPRB,9.6917E-05_JPRB,8.6094E-05_JPRB/)
KBO( :, 3,44, 2) = (/&
&1.2676E-05_JPRB,1.4317E-05_JPRB,6.0634E-05_JPRB,8.4429E-05_JPRB,9.8546E-05_JPRB,8.7409E-05_JPRB/)
KBO( :, 4,44, 2) = (/&
&1.3277E-05_JPRB,1.5031E-05_JPRB,6.2499E-05_JPRB,8.6240E-05_JPRB,9.9772E-05_JPRB,8.8130E-05_JPRB/)
KBO( :, 5,44, 2) = (/&
&1.3943E-05_JPRB,1.5832E-05_JPRB,6.4310E-05_JPRB,8.7770E-05_JPRB,1.0066E-04_JPRB,8.8344E-05_JPRB/)
KBO( :, 1,45, 2) = (/&
&9.2693E-06_JPRB,1.0543E-05_JPRB,4.5963E-05_JPRB,6.4978E-05_JPRB,7.7194E-05_JPRB,6.8589E-05_JPRB/)
KBO( :, 2,45, 2) = (/&
&9.7957E-06_JPRB,1.1074E-05_JPRB,4.7739E-05_JPRB,6.7165E-05_JPRB,7.9241E-05_JPRB,7.0483E-05_JPRB/)
KBO( :, 3,45, 2) = (/&
&1.0267E-05_JPRB,1.1600E-05_JPRB,4.9445E-05_JPRB,6.9027E-05_JPRB,8.0769E-05_JPRB,7.1812E-05_JPRB/)
KBO( :, 4,45, 2) = (/&
&1.0754E-05_JPRB,1.2174E-05_JPRB,5.1050E-05_JPRB,7.0661E-05_JPRB,8.1921E-05_JPRB,7.2601E-05_JPRB/)
KBO( :, 5,45, 2) = (/&
&1.1287E-05_JPRB,1.2814E-05_JPRB,5.2605E-05_JPRB,7.2048E-05_JPRB,8.2819E-05_JPRB,7.2974E-05_JPRB/)
KBO( :, 1,46, 2) = (/&
&7.4503E-06_JPRB,8.5075E-06_JPRB,3.7281E-05_JPRB,5.2735E-05_JPRB,6.2776E-05_JPRB,5.5797E-05_JPRB/)
KBO( :, 2,46, 2) = (/&
&7.9071E-06_JPRB,8.9566E-06_JPRB,3.8801E-05_JPRB,5.4682E-05_JPRB,6.4662E-05_JPRB,5.7621E-05_JPRB/)
KBO( :, 3,46, 2) = (/&
&8.3054E-06_JPRB,9.3874E-06_JPRB,4.0254E-05_JPRB,5.6347E-05_JPRB,6.6096E-05_JPRB,5.8936E-05_JPRB/)
KBO( :, 4,46, 2) = (/&
&8.7047E-06_JPRB,9.8508E-06_JPRB,4.1643E-05_JPRB,5.7815E-05_JPRB,6.7206E-05_JPRB,5.9793E-05_JPRB/)
KBO( :, 5,46, 2) = (/&
&9.1293E-06_JPRB,1.0362E-05_JPRB,4.2978E-05_JPRB,5.9086E-05_JPRB,6.8087E-05_JPRB,6.0275E-05_JPRB/)
KBO( :, 1,47, 2) = (/&
&5.9482E-06_JPRB,6.8343E-06_JPRB,3.0152E-05_JPRB,4.2665E-05_JPRB,5.0898E-05_JPRB,4.5169E-05_JPRB/)
KBO( :, 2,47, 2) = (/&
&6.3610E-06_JPRB,7.2250E-06_JPRB,3.1455E-05_JPRB,4.4406E-05_JPRB,5.2643E-05_JPRB,4.6942E-05_JPRB/)
KBO( :, 3,47, 2) = (/&
&6.7018E-06_JPRB,7.5799E-06_JPRB,3.2695E-05_JPRB,4.5897E-05_JPRB,5.3992E-05_JPRB,4.8229E-05_JPRB/)
KBO( :, 4,47, 2) = (/&
&7.0296E-06_JPRB,7.9549E-06_JPRB,3.3896E-05_JPRB,4.7210E-05_JPRB,5.5050E-05_JPRB,4.9112E-05_JPRB/)
KBO( :, 5,47, 2) = (/&
&7.3684E-06_JPRB,8.3623E-06_JPRB,3.5042E-05_JPRB,4.8359E-05_JPRB,5.5895E-05_JPRB,4.9665E-05_JPRB/)
KBO( :, 1,48, 2) = (/&
&4.7226E-06_JPRB,5.4755E-06_JPRB,2.4366E-05_JPRB,3.4470E-05_JPRB,4.1173E-05_JPRB,3.6520E-05_JPRB/)
KBO( :, 2,48, 2) = (/&
&5.1075E-06_JPRB,5.8220E-06_JPRB,2.5469E-05_JPRB,3.6010E-05_JPRB,4.2797E-05_JPRB,3.8222E-05_JPRB/)
KBO( :, 3,48, 2) = (/&
&5.4030E-06_JPRB,6.1196E-06_JPRB,2.6535E-05_JPRB,3.7342E-05_JPRB,4.4049E-05_JPRB,3.9474E-05_JPRB/)
KBO( :, 4,48, 2) = (/&
&5.6740E-06_JPRB,6.4213E-06_JPRB,2.7566E-05_JPRB,3.8507E-05_JPRB,4.5041E-05_JPRB,4.0367E-05_JPRB/)
KBO( :, 5,48, 2) = (/&
&5.9485E-06_JPRB,6.7483E-06_JPRB,2.8544E-05_JPRB,3.9542E-05_JPRB,4.5839E-05_JPRB,4.0966E-05_JPRB/)
KBO( :, 1,49, 2) = (/&
&3.7285E-06_JPRB,4.3687E-06_JPRB,1.9662E-05_JPRB,2.7800E-05_JPRB,3.3218E-05_JPRB,2.9501E-05_JPRB/)
KBO( :, 2,49, 2) = (/&
&4.0884E-06_JPRB,4.6821E-06_JPRB,2.0602E-05_JPRB,2.9151E-05_JPRB,3.4721E-05_JPRB,3.1112E-05_JPRB/)
KBO( :, 3,49, 2) = (/&
&4.3499E-06_JPRB,4.9382E-06_JPRB,2.1513E-05_JPRB,3.0331E-05_JPRB,3.5872E-05_JPRB,3.2329E-05_JPRB/)
KBO( :, 4,49, 2) = (/&
&4.5782E-06_JPRB,5.1831E-06_JPRB,2.2388E-05_JPRB,3.1370E-05_JPRB,3.6806E-05_JPRB,3.3224E-05_JPRB/)
KBO( :, 5,49, 2) = (/&
&4.8038E-06_JPRB,5.4471E-06_JPRB,2.3228E-05_JPRB,3.2295E-05_JPRB,3.7558E-05_JPRB,3.3865E-05_JPRB/)
KBO( :, 1,50, 2) = (/&
&2.9385E-06_JPRB,3.4756E-06_JPRB,1.5868E-05_JPRB,2.2413E-05_JPRB,2.6776E-05_JPRB,2.3745E-05_JPRB/)
KBO( :, 2,50, 2) = (/&
&3.2647E-06_JPRB,3.7628E-06_JPRB,1.6666E-05_JPRB,2.3594E-05_JPRB,2.8150E-05_JPRB,2.5211E-05_JPRB/)
KBO( :, 3,50, 2) = (/&
&3.5024E-06_JPRB,3.9867E-06_JPRB,1.7439E-05_JPRB,2.4630E-05_JPRB,2.9198E-05_JPRB,2.6360E-05_JPRB/)
KBO( :, 4,50, 2) = (/&
&3.6969E-06_JPRB,4.1885E-06_JPRB,1.8186E-05_JPRB,2.5547E-05_JPRB,3.0054E-05_JPRB,2.7214E-05_JPRB/)
KBO( :, 5,50, 2) = (/&
&3.8815E-06_JPRB,4.4012E-06_JPRB,1.8910E-05_JPRB,2.6369E-05_JPRB,3.0754E-05_JPRB,2.7855E-05_JPRB/)
KBO( :, 1,51, 2) = (/&
&2.3100E-06_JPRB,2.7563E-06_JPRB,1.2803E-05_JPRB,1.8054E-05_JPRB,2.1547E-05_JPRB,1.9044E-05_JPRB/)
KBO( :, 2,51, 2) = (/&
&2.5961E-06_JPRB,3.0186E-06_JPRB,1.3477E-05_JPRB,1.9076E-05_JPRB,2.2781E-05_JPRB,2.0360E-05_JPRB/)
KBO( :, 3,51, 2) = (/&
&2.8167E-06_JPRB,3.2170E-06_JPRB,1.4130E-05_JPRB,1.9983E-05_JPRB,2.3743E-05_JPRB,2.1431E-05_JPRB/)
KBO( :, 4,51, 2) = (/&
&2.9847E-06_JPRB,3.3863E-06_JPRB,1.4767E-05_JPRB,2.0790E-05_JPRB,2.4523E-05_JPRB,2.2225E-05_JPRB/)
KBO( :, 5,51, 2) = (/&
&3.1380E-06_JPRB,3.5588E-06_JPRB,1.5387E-05_JPRB,2.1516E-05_JPRB,2.5161E-05_JPRB,2.2842E-05_JPRB/)
KBO( :, 1,52, 2) = (/&
&1.8092E-06_JPRB,2.1783E-06_JPRB,1.0320E-05_JPRB,1.4520E-05_JPRB,1.7296E-05_JPRB,1.5258E-05_JPRB/)
KBO( :, 2,52, 2) = (/&
&2.0552E-06_JPRB,2.4128E-06_JPRB,1.0887E-05_JPRB,1.5404E-05_JPRB,1.8400E-05_JPRB,1.6432E-05_JPRB/)
KBO( :, 3,52, 2) = (/&
&2.2593E-06_JPRB,2.5914E-06_JPRB,1.1440E-05_JPRB,1.6191E-05_JPRB,1.9279E-05_JPRB,1.7410E-05_JPRB/)
KBO( :, 4,52, 2) = (/&
&2.4069E-06_JPRB,2.7365E-06_JPRB,1.1980E-05_JPRB,1.6899E-05_JPRB,1.9980E-05_JPRB,1.8159E-05_JPRB/)
KBO( :, 5,52, 2) = (/&
&2.5360E-06_JPRB,2.8766E-06_JPRB,1.2509E-05_JPRB,1.7535E-05_JPRB,2.0563E-05_JPRB,1.8740E-05_JPRB/)
KBO( :, 1,53, 2) = (/&
&1.4105E-06_JPRB,1.7158E-06_JPRB,8.3084E-06_JPRB,1.1659E-05_JPRB,1.3847E-05_JPRB,1.2214E-05_JPRB/)
KBO( :, 2,53, 2) = (/&
&1.6202E-06_JPRB,1.9199E-06_JPRB,8.7865E-06_JPRB,1.2420E-05_JPRB,1.4832E-05_JPRB,1.3260E-05_JPRB/)
KBO( :, 3,53, 2) = (/&
&1.8048E-06_JPRB,2.0833E-06_JPRB,9.2542E-06_JPRB,1.3103E-05_JPRB,1.5629E-05_JPRB,1.4148E-05_JPRB/)
KBO( :, 4,53, 2) = (/&
&1.9388E-06_JPRB,2.2099E-06_JPRB,9.7095E-06_JPRB,1.3720E-05_JPRB,1.6258E-05_JPRB,1.4856E-05_JPRB/)
KBO( :, 5,53, 2) = (/&
&2.0484E-06_JPRB,2.3252E-06_JPRB,1.0159E-05_JPRB,1.4275E-05_JPRB,1.6786E-05_JPRB,1.5408E-05_JPRB/)
KBO( :, 1,54, 2) = (/&
&1.1001E-06_JPRB,1.3520E-06_JPRB,6.6915E-06_JPRB,9.3651E-06_JPRB,1.1080E-05_JPRB,9.6915E-06_JPRB/)
KBO( :, 2,54, 2) = (/&
&1.2776E-06_JPRB,1.5264E-06_JPRB,7.0980E-06_JPRB,1.0019E-05_JPRB,1.1951E-05_JPRB,1.0599E-05_JPRB/)
KBO( :, 3,54, 2) = (/&
&1.4389E-06_JPRB,1.6744E-06_JPRB,7.4896E-06_JPRB,1.0605E-05_JPRB,1.2661E-05_JPRB,1.1371E-05_JPRB/)
KBO( :, 4,54, 2) = (/&
&1.5618E-06_JPRB,1.7856E-06_JPRB,7.8730E-06_JPRB,1.1139E-05_JPRB,1.3225E-05_JPRB,1.2005E-05_JPRB/)
KBO( :, 5,54, 2) = (/&
&1.6563E-06_JPRB,1.8821E-06_JPRB,8.2537E-06_JPRB,1.1621E-05_JPRB,1.3700E-05_JPRB,1.2497E-05_JPRB/)
KBO( :, 1,55, 2) = (/&
&8.5645E-07_JPRB,1.0639E-06_JPRB,5.3882E-06_JPRB,7.5160E-06_JPRB,8.8564E-06_JPRB,7.6411E-06_JPRB/)
KBO( :, 2,55, 2) = (/&
&1.0060E-06_JPRB,1.2118E-06_JPRB,5.7336E-06_JPRB,8.0780E-06_JPRB,9.6170E-06_JPRB,8.4151E-06_JPRB/)
KBO( :, 3,55, 2) = (/&
&1.1442E-06_JPRB,1.3431E-06_JPRB,6.0604E-06_JPRB,8.5801E-06_JPRB,1.0247E-05_JPRB,9.0709E-06_JPRB/)
KBO( :, 4,55, 2) = (/&
&1.2568E-06_JPRB,1.4421E-06_JPRB,6.3829E-06_JPRB,9.0380E-06_JPRB,1.0752E-05_JPRB,9.6232E-06_JPRB/)
KBO( :, 5,55, 2) = (/&
&1.3389E-06_JPRB,1.5239E-06_JPRB,6.7048E-06_JPRB,9.4560E-06_JPRB,1.1172E-05_JPRB,1.0049E-05_JPRB/)
KBO( :, 1,56, 2) = (/&
&6.6442E-07_JPRB,8.3379E-07_JPRB,4.3324E-06_JPRB,6.0198E-06_JPRB,7.0629E-06_JPRB,6.0049E-06_JPRB/)
KBO( :, 2,56, 2) = (/&
&7.8950E-07_JPRB,9.5952E-07_JPRB,4.6273E-06_JPRB,6.5047E-06_JPRB,7.7219E-06_JPRB,6.6682E-06_JPRB/)
KBO( :, 3,56, 2) = (/&
&9.0717E-07_JPRB,1.0738E-06_JPRB,4.9008E-06_JPRB,6.9329E-06_JPRB,8.2806E-06_JPRB,7.2285E-06_JPRB/)
KBO( :, 4,56, 2) = (/&
&1.0084E-06_JPRB,1.1629E-06_JPRB,5.1710E-06_JPRB,7.3266E-06_JPRB,8.7308E-06_JPRB,7.6993E-06_JPRB/)
KBO( :, 5,56, 2) = (/&
&1.0813E-06_JPRB,1.2332E-06_JPRB,5.4414E-06_JPRB,7.6876E-06_JPRB,9.1018E-06_JPRB,8.0751E-06_JPRB/)
KBO( :, 1,57, 2) = (/&
&5.1317E-07_JPRB,6.4951E-07_JPRB,3.4793E-06_JPRB,4.8121E-06_JPRB,5.6195E-06_JPRB,4.7031E-06_JPRB/)
KBO( :, 2,57, 2) = (/&
&6.1735E-07_JPRB,7.5758E-07_JPRB,3.7304E-06_JPRB,5.2293E-06_JPRB,6.1863E-06_JPRB,5.2741E-06_JPRB/)
KBO( :, 3,57, 2) = (/&
&7.1698E-07_JPRB,8.5543E-07_JPRB,3.9609E-06_JPRB,5.5969E-06_JPRB,6.6797E-06_JPRB,5.7513E-06_JPRB/)
KBO( :, 4,57, 2) = (/&
&8.0608E-07_JPRB,9.3608E-07_JPRB,4.1867E-06_JPRB,5.9326E-06_JPRB,7.0780E-06_JPRB,6.1535E-06_JPRB/)
KBO( :, 5,57, 2) = (/&
&8.7220E-07_JPRB,9.9722E-07_JPRB,4.4123E-06_JPRB,6.2442E-06_JPRB,7.4063E-06_JPRB,6.4839E-06_JPRB/)
KBO( :, 1,58, 2) = (/&
&3.9480E-07_JPRB,5.0435E-07_JPRB,2.7935E-06_JPRB,3.8432E-06_JPRB,4.4657E-06_JPRB,3.6764E-06_JPRB/)
KBO( :, 2,58, 2) = (/&
&4.8219E-07_JPRB,5.9772E-07_JPRB,3.0073E-06_JPRB,4.2025E-06_JPRB,4.9518E-06_JPRB,4.1625E-06_JPRB/)
KBO( :, 3,58, 2) = (/&
&5.6606E-07_JPRB,6.8070E-07_JPRB,3.2015E-06_JPRB,4.5174E-06_JPRB,5.3832E-06_JPRB,4.5681E-06_JPRB/)
KBO( :, 4,58, 2) = (/&
&6.4282E-07_JPRB,7.5255E-07_JPRB,3.3896E-06_JPRB,4.8024E-06_JPRB,5.7338E-06_JPRB,4.9081E-06_JPRB/)
KBO( :, 5,58, 2) = (/&
&7.0311E-07_JPRB,8.0645E-07_JPRB,3.5782E-06_JPRB,5.0698E-06_JPRB,6.0234E-06_JPRB,5.1890E-06_JPRB/)
KBO( :, 1,59, 2) = (/&
&3.1539E-07_JPRB,4.0480E-07_JPRB,2.2738E-06_JPRB,3.1211E-06_JPRB,3.6182E-06_JPRB,2.9204E-06_JPRB/)
KBO( :, 2,59, 2) = (/&
&3.8822E-07_JPRB,4.8324E-07_JPRB,2.4529E-06_JPRB,3.4232E-06_JPRB,4.0269E-06_JPRB,3.3117E-06_JPRB/)
KBO( :, 3,59, 2) = (/&
&4.5803E-07_JPRB,5.5251E-07_JPRB,2.6142E-06_JPRB,3.6873E-06_JPRB,4.3909E-06_JPRB,3.6397E-06_JPRB/)
KBO( :, 4,59, 2) = (/&
&5.2209E-07_JPRB,6.1313E-07_JPRB,2.7709E-06_JPRB,3.9267E-06_JPRB,4.6885E-06_JPRB,3.9100E-06_JPRB/)
KBO( :, 5,59, 2) = (/&
&5.7356E-07_JPRB,6.5884E-07_JPRB,2.9288E-06_JPRB,4.1516E-06_JPRB,4.9350E-06_JPRB,4.1280E-06_JPRB/)
KBO( :, 1,13, 3) = (/&
&7.6409E-03_JPRB,7.8630E-03_JPRB,3.5099E-02_JPRB,5.1489E-02_JPRB,6.3478E-02_JPRB,6.7045E-02_JPRB/)
KBO( :, 2,13, 3) = (/&
&7.6194E-03_JPRB,7.8439E-03_JPRB,3.6320E-02_JPRB,5.3590E-02_JPRB,6.5755E-02_JPRB,7.0861E-02_JPRB/)
KBO( :, 3,13, 3) = (/&
&7.6221E-03_JPRB,7.8478E-03_JPRB,3.7408E-02_JPRB,5.5388E-02_JPRB,6.7789E-02_JPRB,7.4140E-02_JPRB/)
KBO( :, 4,13, 3) = (/&
&7.7245E-03_JPRB,7.9516E-03_JPRB,3.8346E-02_JPRB,5.6822E-02_JPRB,6.9566E-02_JPRB,7.7166E-02_JPRB/)
KBO( :, 5,13, 3) = (/&
&7.8978E-03_JPRB,8.1255E-03_JPRB,3.9191E-02_JPRB,5.7916E-02_JPRB,7.1029E-02_JPRB,7.9766E-02_JPRB/)
KBO( :, 1,14, 3) = (/&
&6.3458E-03_JPRB,6.5743E-03_JPRB,3.0544E-02_JPRB,4.4937E-02_JPRB,5.5150E-02_JPRB,5.7197E-02_JPRB/)
KBO( :, 2,14, 3) = (/&
&6.3293E-03_JPRB,6.5605E-03_JPRB,3.1591E-02_JPRB,4.6706E-02_JPRB,5.7142E-02_JPRB,6.0155E-02_JPRB/)
KBO( :, 3,14, 3) = (/&
&6.3587E-03_JPRB,6.5945E-03_JPRB,3.2496E-02_JPRB,4.8185E-02_JPRB,5.8909E-02_JPRB,6.2706E-02_JPRB/)
KBO( :, 4,14, 3) = (/&
&6.4686E-03_JPRB,6.7092E-03_JPRB,3.3313E-02_JPRB,4.9362E-02_JPRB,6.0431E-02_JPRB,6.4908E-02_JPRB/)
KBO( :, 5,14, 3) = (/&
&6.6255E-03_JPRB,6.8640E-03_JPRB,3.4024E-02_JPRB,5.0218E-02_JPRB,6.1528E-02_JPRB,6.6516E-02_JPRB/)
KBO( :, 1,15, 3) = (/&
&5.2608E-03_JPRB,5.4955E-03_JPRB,2.6384E-02_JPRB,3.8869E-02_JPRB,4.7602E-02_JPRB,4.8635E-02_JPRB/)
KBO( :, 2,15, 3) = (/&
&5.2548E-03_JPRB,5.4956E-03_JPRB,2.7249E-02_JPRB,4.0345E-02_JPRB,4.9310E-02_JPRB,5.0945E-02_JPRB/)
KBO( :, 3,15, 3) = (/&
&5.2993E-03_JPRB,5.5500E-03_JPRB,2.8019E-02_JPRB,4.1551E-02_JPRB,5.0814E-02_JPRB,5.2823E-02_JPRB/)
KBO( :, 4,15, 3) = (/&
&5.4066E-03_JPRB,5.6608E-03_JPRB,2.8708E-02_JPRB,4.2452E-02_JPRB,5.1926E-02_JPRB,5.4154E-02_JPRB/)
KBO( :, 5,15, 3) = (/&
&5.5521E-03_JPRB,5.8017E-03_JPRB,2.9282E-02_JPRB,4.3007E-02_JPRB,5.2526E-02_JPRB,5.4943E-02_JPRB/)
KBO( :, 1,16, 3) = (/&
&4.3548E-03_JPRB,4.5880E-03_JPRB,2.2610E-02_JPRB,3.3375E-02_JPRB,4.0790E-02_JPRB,4.1260E-02_JPRB/)
KBO( :, 2,16, 3) = (/&
&4.3619E-03_JPRB,4.6068E-03_JPRB,2.3348E-02_JPRB,3.4577E-02_JPRB,4.2241E-02_JPRB,4.3009E-02_JPRB/)
KBO( :, 3,16, 3) = (/&
&4.4136E-03_JPRB,4.6705E-03_JPRB,2.3984E-02_JPRB,3.5504E-02_JPRB,4.3353E-02_JPRB,4.4224E-02_JPRB/)
KBO( :, 4,16, 3) = (/&
&4.5178E-03_JPRB,4.7766E-03_JPRB,2.4528E-02_JPRB,3.6072E-02_JPRB,4.4010E-02_JPRB,4.4975E-02_JPRB/)
KBO( :, 5,16, 3) = (/&
&4.6504E-03_JPRB,4.9071E-03_JPRB,2.4942E-02_JPRB,3.6363E-02_JPRB,4.4282E-02_JPRB,4.5379E-02_JPRB/)
KBO( :, 1,17, 3) = (/&
&3.6046E-03_JPRB,3.8291E-03_JPRB,1.9257E-02_JPRB,2.8451E-02_JPRB,3.4711E-02_JPRB,3.4756E-02_JPRB/)
KBO( :, 2,17, 3) = (/&
&3.6213E-03_JPRB,3.8592E-03_JPRB,1.9862E-02_JPRB,2.9374E-02_JPRB,3.5819E-02_JPRB,3.5957E-02_JPRB/)
KBO( :, 3,17, 3) = (/&
&3.6771E-03_JPRB,3.9291E-03_JPRB,2.0363E-02_JPRB,2.9994E-02_JPRB,3.6526E-02_JPRB,3.6699E-02_JPRB/)
KBO( :, 4,17, 3) = (/&
&3.7714E-03_JPRB,4.0283E-03_JPRB,2.0759E-02_JPRB,3.0326E-02_JPRB,3.6910E-02_JPRB,3.7152E-02_JPRB/)
KBO( :, 5,17, 3) = (/&
&3.8899E-03_JPRB,4.1466E-03_JPRB,2.1065E-02_JPRB,3.0505E-02_JPRB,3.7035E-02_JPRB,3.7347E-02_JPRB/)
KBO( :, 1,18, 3) = (/&
&2.9885E-03_JPRB,3.1998E-03_JPRB,1.6296E-02_JPRB,2.4061E-02_JPRB,2.9310E-02_JPRB,2.9021E-02_JPRB/)
KBO( :, 2,18, 3) = (/&
&3.0092E-03_JPRB,3.2357E-03_JPRB,1.6767E-02_JPRB,2.4711E-02_JPRB,3.0069E-02_JPRB,2.9818E-02_JPRB/)
KBO( :, 3,18, 3) = (/&
&3.0601E-03_JPRB,3.3019E-03_JPRB,1.7137E-02_JPRB,2.5107E-02_JPRB,3.0527E-02_JPRB,3.0314E-02_JPRB/)
KBO( :, 4,18, 3) = (/&
&3.1433E-03_JPRB,3.3904E-03_JPRB,1.7445E-02_JPRB,2.5340E-02_JPRB,3.0772E-02_JPRB,3.0595E-02_JPRB/)
KBO( :, 5,18, 3) = (/&
&3.2491E-03_JPRB,3.4975E-03_JPRB,1.7663E-02_JPRB,2.5461E-02_JPRB,3.0822E-02_JPRB,3.0677E-02_JPRB/)
KBO( :, 1,19, 3) = (/&
&2.4792E-03_JPRB,2.6786E-03_JPRB,1.3691E-02_JPRB,2.0180E-02_JPRB,2.4544E-02_JPRB,2.4040E-02_JPRB/)
KBO( :, 2,19, 3) = (/&
&2.4982E-03_JPRB,2.7134E-03_JPRB,1.4049E-02_JPRB,2.0629E-02_JPRB,2.5069E-02_JPRB,2.4597E-02_JPRB/)
KBO( :, 3,19, 3) = (/&
&2.5452E-03_JPRB,2.7746E-03_JPRB,1.4344E-02_JPRB,2.0921E-02_JPRB,2.5390E-02_JPRB,2.4935E-02_JPRB/)
KBO( :, 4,19, 3) = (/&
&2.6196E-03_JPRB,2.8530E-03_JPRB,1.4579E-02_JPRB,2.1097E-02_JPRB,2.5555E-02_JPRB,2.5107E-02_JPRB/)
KBO( :, 5,19, 3) = (/&
&2.7162E-03_JPRB,2.9530E-03_JPRB,1.4732E-02_JPRB,2.1186E-02_JPRB,2.5572E-02_JPRB,2.5118E-02_JPRB/)
KBO( :, 1,20, 3) = (/&
&2.0528E-03_JPRB,2.2395E-03_JPRB,1.1440E-02_JPRB,1.6822E-02_JPRB,2.0437E-02_JPRB,1.9854E-02_JPRB/)
KBO( :, 2,20, 3) = (/&
&2.0711E-03_JPRB,2.2736E-03_JPRB,1.1723E-02_JPRB,1.7158E-02_JPRB,2.0817E-02_JPRB,2.0254E-02_JPRB/)
KBO( :, 3,20, 3) = (/&
&2.1151E-03_JPRB,2.3293E-03_JPRB,1.1957E-02_JPRB,1.7380E-02_JPRB,2.1050E-02_JPRB,2.0492E-02_JPRB/)
KBO( :, 4,20, 3) = (/&
&2.1833E-03_JPRB,2.4015E-03_JPRB,1.2129E-02_JPRB,1.7522E-02_JPRB,2.1168E-02_JPRB,2.0597E-02_JPRB/)
KBO( :, 5,20, 3) = (/&
&2.2724E-03_JPRB,2.4949E-03_JPRB,1.2249E-02_JPRB,1.7578E-02_JPRB,2.1166E-02_JPRB,2.0571E-02_JPRB/)
KBO( :, 1,21, 3) = (/&
&1.6965E-03_JPRB,1.8666E-03_JPRB,9.5200E-03_JPRB,1.3965E-02_JPRB,1.6952E-02_JPRB,1.6357E-02_JPRB/)
KBO( :, 2,21, 3) = (/&
&1.7152E-03_JPRB,1.9002E-03_JPRB,9.7517E-03_JPRB,1.4227E-02_JPRB,1.7236E-02_JPRB,1.6650E-02_JPRB/)
KBO( :, 3,21, 3) = (/&
&1.7567E-03_JPRB,1.9510E-03_JPRB,9.9283E-03_JPRB,1.4408E-02_JPRB,1.7419E-02_JPRB,1.6821E-02_JPRB/)
KBO( :, 4,21, 3) = (/&
&1.8182E-03_JPRB,2.0179E-03_JPRB,1.0061E-02_JPRB,1.4512E-02_JPRB,1.7502E-02_JPRB,1.6883E-02_JPRB/)
KBO( :, 5,21, 3) = (/&
&1.9002E-03_JPRB,2.1049E-03_JPRB,1.0160E-02_JPRB,1.4547E-02_JPRB,1.7493E-02_JPRB,1.6838E-02_JPRB/)
KBO( :, 1,22, 3) = (/&
&1.4012E-03_JPRB,1.5543E-03_JPRB,7.9187E-03_JPRB,1.1582E-02_JPRB,1.4044E-02_JPRB,1.3475E-02_JPRB/)
KBO( :, 2,22, 3) = (/&
&1.4217E-03_JPRB,1.5878E-03_JPRB,8.0975E-03_JPRB,1.1789E-02_JPRB,1.4260E-02_JPRB,1.3686E-02_JPRB/)
KBO( :, 3,22, 3) = (/&
&1.4625E-03_JPRB,1.6356E-03_JPRB,8.2342E-03_JPRB,1.1928E-02_JPRB,1.4399E-02_JPRB,1.3802E-02_JPRB/)
KBO( :, 4,22, 3) = (/&
&1.5189E-03_JPRB,1.6982E-03_JPRB,8.3363E-03_JPRB,1.1996E-02_JPRB,1.4455E-02_JPRB,1.3830E-02_JPRB/)
KBO( :, 5,22, 3) = (/&
&1.5929E-03_JPRB,1.7785E-03_JPRB,8.4131E-03_JPRB,1.2015E-02_JPRB,1.4430E-02_JPRB,1.3772E-02_JPRB/)
KBO( :, 1,23, 3) = (/&
&1.1570E-03_JPRB,1.2929E-03_JPRB,6.5744E-03_JPRB,9.5929E-03_JPRB,1.1615E-02_JPRB,1.1086E-02_JPRB/)
KBO( :, 2,23, 3) = (/&
&1.1790E-03_JPRB,1.3257E-03_JPRB,6.7098E-03_JPRB,9.7544E-03_JPRB,1.1782E-02_JPRB,1.1237E-02_JPRB/)
KBO( :, 3,23, 3) = (/&
&1.2175E-03_JPRB,1.3704E-03_JPRB,6.8141E-03_JPRB,9.8515E-03_JPRB,1.1889E-02_JPRB,1.1315E-02_JPRB/)
KBO( :, 4,23, 3) = (/&
&1.2686E-03_JPRB,1.4282E-03_JPRB,6.8934E-03_JPRB,9.9002E-03_JPRB,1.1920E-02_JPRB,1.1318E-02_JPRB/)
KBO( :, 5,23, 3) = (/&
&1.3340E-03_JPRB,1.5001E-03_JPRB,6.9577E-03_JPRB,9.9108E-03_JPRB,1.1886E-02_JPRB,1.1254E-02_JPRB/)
KBO( :, 1,24, 3) = (/&
&9.5574E-04_JPRB,1.0753E-03_JPRB,5.4476E-03_JPRB,7.9376E-03_JPRB,9.5959E-03_JPRB,9.1100E-03_JPRB/)
KBO( :, 2,24, 3) = (/&
&9.7834E-04_JPRB,1.1070E-03_JPRB,5.5506E-03_JPRB,8.0557E-03_JPRB,9.7276E-03_JPRB,9.2176E-03_JPRB/)
KBO( :, 3,24, 3) = (/&
&1.0140E-03_JPRB,1.1485E-03_JPRB,5.6323E-03_JPRB,8.1281E-03_JPRB,9.8028E-03_JPRB,9.2635E-03_JPRB/)
KBO( :, 4,24, 3) = (/&
&1.0594E-03_JPRB,1.2005E-03_JPRB,5.6966E-03_JPRB,8.1612E-03_JPRB,9.8145E-03_JPRB,9.2505E-03_JPRB/)
KBO( :, 5,24, 3) = (/&
&1.1172E-03_JPRB,1.2644E-03_JPRB,5.7523E-03_JPRB,8.1643E-03_JPRB,9.7794E-03_JPRB,9.1865E-03_JPRB/)
KBO( :, 1,25, 3) = (/&
&7.9031E-04_JPRB,8.9498E-04_JPRB,4.5093E-03_JPRB,6.5597E-03_JPRB,7.9226E-03_JPRB,7.4814E-03_JPRB/)
KBO( :, 2,25, 3) = (/&
&8.1263E-04_JPRB,9.2459E-04_JPRB,4.5880E-03_JPRB,6.6467E-03_JPRB,8.0247E-03_JPRB,7.5572E-03_JPRB/)
KBO( :, 3,25, 3) = (/&
&8.4479E-04_JPRB,9.6257E-04_JPRB,4.6527E-03_JPRB,6.6977E-03_JPRB,8.0725E-03_JPRB,7.5813E-03_JPRB/)
KBO( :, 4,25, 3) = (/&
&8.8545E-04_JPRB,1.0093E-03_JPRB,4.7088E-03_JPRB,6.7186E-03_JPRB,8.0725E-03_JPRB,7.5582E-03_JPRB/)
KBO( :, 5,25, 3) = (/&
&9.3639E-04_JPRB,1.0658E-03_JPRB,4.7580E-03_JPRB,6.7210E-03_JPRB,8.0368E-03_JPRB,7.4940E-03_JPRB/)
KBO( :, 1,26, 3) = (/&
&6.5440E-04_JPRB,7.4555E-04_JPRB,3.7287E-03_JPRB,5.4156E-03_JPRB,6.5397E-03_JPRB,6.1435E-03_JPRB/)
KBO( :, 2,26, 3) = (/&
&6.7588E-04_JPRB,7.7292E-04_JPRB,3.7917E-03_JPRB,5.4786E-03_JPRB,6.6119E-03_JPRB,6.1927E-03_JPRB/)
KBO( :, 3,26, 3) = (/&
&7.0450E-04_JPRB,8.0706E-04_JPRB,3.8452E-03_JPRB,5.5137E-03_JPRB,6.6415E-03_JPRB,6.2018E-03_JPRB/)
KBO( :, 4,26, 3) = (/&
&7.4139E-04_JPRB,8.4916E-04_JPRB,3.8959E-03_JPRB,5.5296E-03_JPRB,6.6347E-03_JPRB,6.1729E-03_JPRB/)
KBO( :, 5,26, 3) = (/&
&7.8678E-04_JPRB,8.9964E-04_JPRB,3.9398E-03_JPRB,5.5339E-03_JPRB,6.6007E-03_JPRB,6.1130E-03_JPRB/)
KBO( :, 1,27, 3) = (/&
&5.4261E-04_JPRB,6.2138E-04_JPRB,3.0812E-03_JPRB,4.4673E-03_JPRB,5.3930E-03_JPRB,5.0432E-03_JPRB/)
KBO( :, 2,27, 3) = (/&
&5.6244E-04_JPRB,6.4623E-04_JPRB,3.1326E-03_JPRB,4.5130E-03_JPRB,5.4441E-03_JPRB,5.0746E-03_JPRB/)
KBO( :, 3,27, 3) = (/&
&5.8793E-04_JPRB,6.7665E-04_JPRB,3.1799E-03_JPRB,4.5386E-03_JPRB,5.4598E-03_JPRB,5.0735E-03_JPRB/)
KBO( :, 4,27, 3) = (/&
&6.2139E-04_JPRB,7.1456E-04_JPRB,3.2246E-03_JPRB,4.5530E-03_JPRB,5.4488E-03_JPRB,5.0440E-03_JPRB/)
KBO( :, 5,27, 3) = (/&
&6.6189E-04_JPRB,7.5928E-04_JPRB,3.2622E-03_JPRB,4.5583E-03_JPRB,5.4192E-03_JPRB,4.9887E-03_JPRB/)
KBO( :, 1,28, 3) = (/&
&4.5041E-04_JPRB,5.1802E-04_JPRB,2.5459E-03_JPRB,3.6826E-03_JPRB,4.4432E-03_JPRB,4.1386E-03_JPRB/)
KBO( :, 2,28, 3) = (/&
&4.6818E-04_JPRB,5.4025E-04_JPRB,2.5901E-03_JPRB,3.7166E-03_JPRB,4.4776E-03_JPRB,4.1576E-03_JPRB/)
KBO( :, 3,28, 3) = (/&
&4.9122E-04_JPRB,5.6731E-04_JPRB,2.6317E-03_JPRB,3.7378E-03_JPRB,4.4848E-03_JPRB,4.1511E-03_JPRB/)
KBO( :, 4,28, 3) = (/&
&5.2165E-04_JPRB,6.0153E-04_JPRB,2.6701E-03_JPRB,3.7517E-03_JPRB,4.4733E-03_JPRB,4.1214E-03_JPRB/)
KBO( :, 5,28, 3) = (/&
&5.5747E-04_JPRB,6.4051E-04_JPRB,2.7007E-03_JPRB,3.7587E-03_JPRB,4.4498E-03_JPRB,4.0722E-03_JPRB/)
KBO( :, 1,29, 3) = (/&
&3.7413E-04_JPRB,4.3196E-04_JPRB,2.1044E-03_JPRB,3.0343E-03_JPRB,3.6585E-03_JPRB,3.3981E-03_JPRB/)
KBO( :, 2,29, 3) = (/&
&3.9017E-04_JPRB,4.5166E-04_JPRB,2.1424E-03_JPRB,3.0612E-03_JPRB,3.6810E-03_JPRB,3.4095E-03_JPRB/)
KBO( :, 3,29, 3) = (/&
&4.1157E-04_JPRB,4.7625E-04_JPRB,2.1792E-03_JPRB,3.0806E-03_JPRB,3.6837E-03_JPRB,3.4002E-03_JPRB/)
KBO( :, 4,29, 3) = (/&
&4.3865E-04_JPRB,5.0663E-04_JPRB,2.2090E-03_JPRB,3.0938E-03_JPRB,3.6744E-03_JPRB,3.3735E-03_JPRB/)
KBO( :, 5,29, 3) = (/&
&4.7012E-04_JPRB,5.4039E-04_JPRB,2.2354E-03_JPRB,3.1005E-03_JPRB,3.6551E-03_JPRB,3.3297E-03_JPRB/)
KBO( :, 1,30, 3) = (/&
&3.1103E-04_JPRB,3.6024E-04_JPRB,1.7406E-03_JPRB,2.5005E-03_JPRB,3.0110E-03_JPRB,2.7911E-03_JPRB/)
KBO( :, 2,30, 3) = (/&
&3.2577E-04_JPRB,3.7785E-04_JPRB,1.7737E-03_JPRB,2.5236E-03_JPRB,3.0255E-03_JPRB,2.7972E-03_JPRB/)
KBO( :, 3,30, 3) = (/&
&3.4538E-04_JPRB,4.0017E-04_JPRB,1.8036E-03_JPRB,2.5406E-03_JPRB,3.0269E-03_JPRB,2.7870E-03_JPRB/)
KBO( :, 4,30, 3) = (/&
&3.6935E-04_JPRB,4.2673E-04_JPRB,1.8286E-03_JPRB,2.5529E-03_JPRB,3.0186E-03_JPRB,2.7615E-03_JPRB/)
KBO( :, 5,30, 3) = (/&
&3.9676E-04_JPRB,4.5608E-04_JPRB,1.8513E-03_JPRB,2.5584E-03_JPRB,3.0040E-03_JPRB,2.7242E-03_JPRB/)
KBO( :, 1,31, 3) = (/&
&2.5900E-04_JPRB,3.0066E-04_JPRB,1.4406E-03_JPRB,2.0618E-03_JPRB,2.4773E-03_JPRB,2.2948E-03_JPRB/)
KBO( :, 2,31, 3) = (/&
&2.7261E-04_JPRB,3.1655E-04_JPRB,1.4684E-03_JPRB,2.0810E-03_JPRB,2.4873E-03_JPRB,2.2978E-03_JPRB/)
KBO( :, 3,31, 3) = (/&
&2.9037E-04_JPRB,3.3669E-04_JPRB,1.4928E-03_JPRB,2.0966E-03_JPRB,2.4881E-03_JPRB,2.2878E-03_JPRB/)
KBO( :, 4,31, 3) = (/&
&3.1154E-04_JPRB,3.5979E-04_JPRB,1.5138E-03_JPRB,2.1064E-03_JPRB,2.4823E-03_JPRB,2.2654E-03_JPRB/)
KBO( :, 5,31, 3) = (/&
&3.3507E-04_JPRB,3.8509E-04_JPRB,1.5342E-03_JPRB,2.1116E-03_JPRB,2.4709E-03_JPRB,2.2338E-03_JPRB/)
KBO( :, 1,32, 3) = (/&
&2.1614E-04_JPRB,2.5126E-04_JPRB,1.1930E-03_JPRB,1.7007E-03_JPRB,2.0381E-03_JPRB,1.8878E-03_JPRB/)
KBO( :, 2,32, 3) = (/&
&2.2861E-04_JPRB,2.6571E-04_JPRB,1.2162E-03_JPRB,1.7180E-03_JPRB,2.0460E-03_JPRB,1.8890E-03_JPRB/)
KBO( :, 3,32, 3) = (/&
&2.4457E-04_JPRB,2.8365E-04_JPRB,1.2363E-03_JPRB,1.7307E-03_JPRB,2.0470E-03_JPRB,1.8790E-03_JPRB/)
KBO( :, 4,32, 3) = (/&
&2.6297E-04_JPRB,3.0364E-04_JPRB,1.2543E-03_JPRB,1.7385E-03_JPRB,2.0430E-03_JPRB,1.8594E-03_JPRB/)
KBO( :, 5,32, 3) = (/&
&2.8320E-04_JPRB,3.2527E-04_JPRB,1.2726E-03_JPRB,1.7439E-03_JPRB,2.0334E-03_JPRB,1.8328E-03_JPRB/)
KBO( :, 1,33, 3) = (/&
&1.8077E-04_JPRB,2.1039E-04_JPRB,9.8840E-04_JPRB,1.4043E-03_JPRB,1.6777E-03_JPRB,1.5543E-03_JPRB/)
KBO( :, 2,33, 3) = (/&
&1.9220E-04_JPRB,2.2350E-04_JPRB,1.0074E-03_JPRB,1.4187E-03_JPRB,1.6838E-03_JPRB,1.5538E-03_JPRB/)
KBO( :, 3,33, 3) = (/&
&2.0626E-04_JPRB,2.3918E-04_JPRB,1.0244E-03_JPRB,1.4289E-03_JPRB,1.6852E-03_JPRB,1.5443E-03_JPRB/)
KBO( :, 4,33, 3) = (/&
&2.2215E-04_JPRB,2.5639E-04_JPRB,1.0403E-03_JPRB,1.4356E-03_JPRB,1.6818E-03_JPRB,1.5277E-03_JPRB/)
KBO( :, 5,33, 3) = (/&
&2.3958E-04_JPRB,2.7494E-04_JPRB,1.0565E-03_JPRB,1.4410E-03_JPRB,1.6741E-03_JPRB,1.5054E-03_JPRB/)
KBO( :, 1,34, 3) = (/&
&1.5119E-04_JPRB,1.7609E-04_JPRB,8.1855E-04_JPRB,1.1596E-03_JPRB,1.3812E-03_JPRB,1.2791E-03_JPRB/)
KBO( :, 2,34, 3) = (/&
&1.6145E-04_JPRB,1.8785E-04_JPRB,8.3425E-04_JPRB,1.1712E-03_JPRB,1.3866E-03_JPRB,1.2773E-03_JPRB/)
KBO( :, 3,34, 3) = (/&
&1.7367E-04_JPRB,2.0133E-04_JPRB,8.4883E-04_JPRB,1.1799E-03_JPRB,1.3882E-03_JPRB,1.2691E-03_JPRB/)
KBO( :, 4,34, 3) = (/&
&1.8734E-04_JPRB,2.1609E-04_JPRB,8.6307E-04_JPRB,1.1863E-03_JPRB,1.3855E-03_JPRB,1.2550E-03_JPRB/)
KBO( :, 5,34, 3) = (/&
&2.0225E-04_JPRB,2.3202E-04_JPRB,8.7752E-04_JPRB,1.1920E-03_JPRB,1.3795E-03_JPRB,1.2363E-03_JPRB/)
KBO( :, 1,35, 3) = (/&
&1.2586E-04_JPRB,1.4671E-04_JPRB,6.7658E-04_JPRB,9.5649E-04_JPRB,1.1370E-03_JPRB,1.0523E-03_JPRB/)
KBO( :, 2,35, 3) = (/&
&1.3479E-04_JPRB,1.5694E-04_JPRB,6.9016E-04_JPRB,9.6658E-04_JPRB,1.1423E-03_JPRB,1.0509E-03_JPRB/)
KBO( :, 3,35, 3) = (/&
&1.4527E-04_JPRB,1.6840E-04_JPRB,7.0251E-04_JPRB,9.7407E-04_JPRB,1.1435E-03_JPRB,1.0441E-03_JPRB/)
KBO( :, 4,35, 3) = (/&
&1.5691E-04_JPRB,1.8098E-04_JPRB,7.1533E-04_JPRB,9.8058E-04_JPRB,1.1418E-03_JPRB,1.0326E-03_JPRB/)
KBO( :, 5,35, 3) = (/&
&1.6957E-04_JPRB,1.9459E-04_JPRB,7.2799E-04_JPRB,9.8636E-04_JPRB,1.1378E-03_JPRB,1.0171E-03_JPRB/)
KBO( :, 1,36, 3) = (/&
&1.0414E-04_JPRB,1.2151E-04_JPRB,5.5801E-04_JPRB,7.8827E-04_JPRB,9.3599E-04_JPRB,8.6559E-04_JPRB/)
KBO( :, 2,36, 3) = (/&
&1.1170E-04_JPRB,1.3016E-04_JPRB,5.6976E-04_JPRB,7.9724E-04_JPRB,9.4085E-04_JPRB,8.6498E-04_JPRB/)
KBO( :, 3,36, 3) = (/&
&1.2056E-04_JPRB,1.3986E-04_JPRB,5.8091E-04_JPRB,8.0448E-04_JPRB,9.4273E-04_JPRB,8.5997E-04_JPRB/)
KBO( :, 4,36, 3) = (/&
&1.3038E-04_JPRB,1.5047E-04_JPRB,5.9203E-04_JPRB,8.1040E-04_JPRB,9.4179E-04_JPRB,8.5084E-04_JPRB/)
KBO( :, 5,36, 3) = (/&
&1.4104E-04_JPRB,1.6199E-04_JPRB,6.0308E-04_JPRB,8.1605E-04_JPRB,9.3933E-04_JPRB,8.3818E-04_JPRB/)
KBO( :, 1,37, 3) = (/&
&8.5323E-05_JPRB,9.9664E-05_JPRB,4.5884E-04_JPRB,6.4852E-04_JPRB,7.6974E-04_JPRB,7.1141E-04_JPRB/)
KBO( :, 2,37, 3) = (/&
&9.1527E-05_JPRB,1.0682E-04_JPRB,4.6909E-04_JPRB,6.5669E-04_JPRB,7.7467E-04_JPRB,7.1194E-04_JPRB/)
KBO( :, 3,37, 3) = (/&
&9.8871E-05_JPRB,1.1487E-04_JPRB,4.7886E-04_JPRB,6.6345E-04_JPRB,7.7695E-04_JPRB,7.0849E-04_JPRB/)
KBO( :, 4,37, 3) = (/&
&1.0704E-04_JPRB,1.2374E-04_JPRB,4.8883E-04_JPRB,6.6930E-04_JPRB,7.7737E-04_JPRB,7.0168E-04_JPRB/)
KBO( :, 5,37, 3) = (/&
&1.1597E-04_JPRB,1.3339E-04_JPRB,4.9841E-04_JPRB,6.7481E-04_JPRB,7.7624E-04_JPRB,6.9182E-04_JPRB/)
KBO( :, 1,38, 3) = (/&
&6.9864E-05_JPRB,8.1702E-05_JPRB,3.7720E-04_JPRB,5.3356E-04_JPRB,6.3309E-04_JPRB,5.8498E-04_JPRB/)
KBO( :, 2,38, 3) = (/&
&7.4949E-05_JPRB,8.7605E-05_JPRB,3.8612E-04_JPRB,5.4085E-04_JPRB,6.3774E-04_JPRB,5.8615E-04_JPRB/)
KBO( :, 3,38, 3) = (/&
&8.1032E-05_JPRB,9.4290E-05_JPRB,3.9469E-04_JPRB,5.4710E-04_JPRB,6.4046E-04_JPRB,5.8424E-04_JPRB/)
KBO( :, 4,38, 3) = (/&
&8.7830E-05_JPRB,1.0169E-04_JPRB,4.0337E-04_JPRB,5.5261E-04_JPRB,6.4155E-04_JPRB,5.7913E-04_JPRB/)
KBO( :, 5,38, 3) = (/&
&9.5293E-05_JPRB,1.0978E-04_JPRB,4.1177E-04_JPRB,5.5788E-04_JPRB,6.4154E-04_JPRB,5.7166E-04_JPRB/)
KBO( :, 1,39, 3) = (/&
&5.7197E-05_JPRB,6.6973E-05_JPRB,3.1005E-04_JPRB,4.3874E-04_JPRB,5.2056E-04_JPRB,4.8131E-04_JPRB/)
KBO( :, 2,39, 3) = (/&
&6.1371E-05_JPRB,7.1842E-05_JPRB,3.1779E-04_JPRB,4.4531E-04_JPRB,5.2502E-04_JPRB,4.8298E-04_JPRB/)
KBO( :, 3,39, 3) = (/&
&6.6407E-05_JPRB,7.7394E-05_JPRB,3.2540E-04_JPRB,4.5115E-04_JPRB,5.2799E-04_JPRB,4.8215E-04_JPRB/)
KBO( :, 4,39, 3) = (/&
&7.2064E-05_JPRB,8.3560E-05_JPRB,3.3301E-04_JPRB,4.5632E-04_JPRB,5.2961E-04_JPRB,4.7858E-04_JPRB/)
KBO( :, 5,39, 3) = (/&
&7.8303E-05_JPRB,9.0355E-05_JPRB,3.4035E-04_JPRB,4.6134E-04_JPRB,5.3031E-04_JPRB,4.7308E-04_JPRB/)
KBO( :, 1,40, 3) = (/&
&4.6522E-05_JPRB,5.4522E-05_JPRB,2.5421E-04_JPRB,3.6027E-04_JPRB,4.2767E-04_JPRB,3.9473E-04_JPRB/)
KBO( :, 2,40, 3) = (/&
&4.9863E-05_JPRB,5.8471E-05_JPRB,2.6092E-04_JPRB,3.6612E-04_JPRB,4.3197E-04_JPRB,3.9681E-04_JPRB/)
KBO( :, 3,40, 3) = (/&
&5.3968E-05_JPRB,6.3027E-05_JPRB,2.6757E-04_JPRB,3.7152E-04_JPRB,4.3513E-04_JPRB,3.9683E-04_JPRB/)
KBO( :, 4,40, 3) = (/&
&5.8623E-05_JPRB,6.8126E-05_JPRB,2.7426E-04_JPRB,3.7636E-04_JPRB,4.3711E-04_JPRB,3.9452E-04_JPRB/)
KBO( :, 5,40, 3) = (/&
&6.3789E-05_JPRB,7.3766E-05_JPRB,2.8070E-04_JPRB,3.8106E-04_JPRB,4.3831E-04_JPRB,3.9053E-04_JPRB/)
KBO( :, 1,41, 3) = (/&
&3.7804E-05_JPRB,4.4333E-05_JPRB,2.0821E-04_JPRB,2.9549E-04_JPRB,3.5103E-04_JPRB,3.2341E-04_JPRB/)
KBO( :, 2,41, 3) = (/&
&4.0492E-05_JPRB,4.7550E-05_JPRB,2.1408E-04_JPRB,3.0089E-04_JPRB,3.5532E-04_JPRB,3.2587E-04_JPRB/)
KBO( :, 3,41, 3) = (/&
&4.3795E-05_JPRB,5.1265E-05_JPRB,2.1987E-04_JPRB,3.0577E-04_JPRB,3.5843E-04_JPRB,3.2638E-04_JPRB/)
KBO( :, 4,41, 3) = (/&
&4.7619E-05_JPRB,5.5462E-05_JPRB,2.2575E-04_JPRB,3.1023E-04_JPRB,3.6066E-04_JPRB,3.2506E-04_JPRB/)
KBO( :, 5,41, 3) = (/&
&5.1898E-05_JPRB,6.0154E-05_JPRB,2.3138E-04_JPRB,3.1463E-04_JPRB,3.6219E-04_JPRB,3.2225E-04_JPRB/)
KBO( :, 1,42, 3) = (/&
&3.0725E-05_JPRB,3.6043E-05_JPRB,1.7048E-04_JPRB,2.4228E-04_JPRB,2.8802E-04_JPRB,2.6497E-04_JPRB/)
KBO( :, 2,42, 3) = (/&
&3.2881E-05_JPRB,3.8663E-05_JPRB,1.7559E-04_JPRB,2.4716E-04_JPRB,2.9210E-04_JPRB,2.6748E-04_JPRB/)
KBO( :, 3,42, 3) = (/&
&3.5527E-05_JPRB,4.1681E-05_JPRB,1.8062E-04_JPRB,2.5152E-04_JPRB,2.9511E-04_JPRB,2.6841E-04_JPRB/)
KBO( :, 4,42, 3) = (/&
&3.8664E-05_JPRB,4.5134E-05_JPRB,1.8577E-04_JPRB,2.5564E-04_JPRB,2.9747E-04_JPRB,2.6786E-04_JPRB/)
KBO( :, 5,42, 3) = (/&
&4.2195E-05_JPRB,4.9021E-05_JPRB,1.9068E-04_JPRB,2.5970E-04_JPRB,2.9919E-04_JPRB,2.6599E-04_JPRB/)
KBO( :, 1,43, 3) = (/&
&2.4891E-05_JPRB,2.9187E-05_JPRB,1.3928E-04_JPRB,1.9831E-04_JPRB,2.3592E-04_JPRB,2.1675E-04_JPRB/)
KBO( :, 2,43, 3) = (/&
&2.6593E-05_JPRB,3.1301E-05_JPRB,1.4374E-04_JPRB,2.0272E-04_JPRB,2.3983E-04_JPRB,2.1942E-04_JPRB/)
KBO( :, 3,43, 3) = (/&
&2.8690E-05_JPRB,3.3747E-05_JPRB,1.4810E-04_JPRB,2.0668E-04_JPRB,2.4285E-04_JPRB,2.2071E-04_JPRB/)
KBO( :, 4,43, 3) = (/&
&3.1232E-05_JPRB,3.6547E-05_JPRB,1.5256E-04_JPRB,2.1038E-04_JPRB,2.4515E-04_JPRB,2.2071E-04_JPRB/)
KBO( :, 5,43, 3) = (/&
&3.4120E-05_JPRB,3.9743E-05_JPRB,1.5683E-04_JPRB,2.1407E-04_JPRB,2.4696E-04_JPRB,2.1958E-04_JPRB/)
KBO( :, 1,44, 3) = (/&
&2.0144E-05_JPRB,2.3605E-05_JPRB,1.1366E-04_JPRB,1.6217E-04_JPRB,1.9304E-04_JPRB,1.7720E-04_JPRB/)
KBO( :, 2,44, 3) = (/&
&2.1468E-05_JPRB,2.5288E-05_JPRB,1.1746E-04_JPRB,1.6601E-04_JPRB,1.9664E-04_JPRB,1.7978E-04_JPRB/)
KBO( :, 3,44, 3) = (/&
&2.3117E-05_JPRB,2.7255E-05_JPRB,1.2127E-04_JPRB,1.6962E-04_JPRB,1.9955E-04_JPRB,1.8133E-04_JPRB/)
KBO( :, 4,44, 3) = (/&
&2.5167E-05_JPRB,2.9525E-05_JPRB,1.2515E-04_JPRB,1.7298E-04_JPRB,2.0188E-04_JPRB,1.8182E-04_JPRB/)
KBO( :, 5,44, 3) = (/&
&2.7509E-05_JPRB,3.2133E-05_JPRB,1.2890E-04_JPRB,1.7631E-04_JPRB,2.0373E-04_JPRB,1.8128E-04_JPRB/)
KBO( :, 1,45, 3) = (/&
&1.6315E-05_JPRB,1.9099E-05_JPRB,9.2658E-05_JPRB,1.3247E-04_JPRB,1.5777E-04_JPRB,1.4481E-04_JPRB/)
KBO( :, 2,45, 3) = (/&
&1.7341E-05_JPRB,2.0427E-05_JPRB,9.5960E-05_JPRB,1.3596E-04_JPRB,1.6122E-04_JPRB,1.4738E-04_JPRB/)
KBO( :, 3,45, 3) = (/&
&1.8647E-05_JPRB,2.2022E-05_JPRB,9.9238E-05_JPRB,1.3912E-04_JPRB,1.6388E-04_JPRB,1.4901E-04_JPRB/)
KBO( :, 4,45, 3) = (/&
&2.0262E-05_JPRB,2.3840E-05_JPRB,1.0260E-04_JPRB,1.4211E-04_JPRB,1.6610E-04_JPRB,1.4980E-04_JPRB/)
KBO( :, 5,45, 3) = (/&
&2.2167E-05_JPRB,2.5969E-05_JPRB,1.0588E-04_JPRB,1.4512E-04_JPRB,1.6796E-04_JPRB,1.4976E-04_JPRB/)
KBO( :, 1,46, 3) = (/&
&1.3211E-05_JPRB,1.5446E-05_JPRB,7.5427E-05_JPRB,1.0806E-04_JPRB,1.2876E-04_JPRB,1.1821E-04_JPRB/)
KBO( :, 2,46, 3) = (/&
&1.3990E-05_JPRB,1.6470E-05_JPRB,7.8248E-05_JPRB,1.1113E-04_JPRB,1.3193E-04_JPRB,1.2064E-04_JPRB/)
KBO( :, 3,46, 3) = (/&
&1.5013E-05_JPRB,1.7753E-05_JPRB,8.1102E-05_JPRB,1.1397E-04_JPRB,1.3444E-04_JPRB,1.2234E-04_JPRB/)
KBO( :, 4,46, 3) = (/&
&1.6277E-05_JPRB,1.9210E-05_JPRB,8.3980E-05_JPRB,1.1663E-04_JPRB,1.3652E-04_JPRB,1.2338E-04_JPRB/)
KBO( :, 5,46, 3) = (/&
&1.7816E-05_JPRB,2.0932E-05_JPRB,8.6856E-05_JPRB,1.1931E-04_JPRB,1.3833E-04_JPRB,1.2371E-04_JPRB/)
KBO( :, 1,47, 3) = (/&
&1.0695E-05_JPRB,1.2476E-05_JPRB,6.1245E-05_JPRB,8.7921E-05_JPRB,1.0481E-04_JPRB,9.6236E-05_JPRB/)
KBO( :, 2,47, 3) = (/&
&1.1263E-05_JPRB,1.3243E-05_JPRB,6.3648E-05_JPRB,9.0656E-05_JPRB,1.0772E-04_JPRB,9.8519E-05_JPRB/)
KBO( :, 3,47, 3) = (/&
&1.2048E-05_JPRB,1.4259E-05_JPRB,6.6115E-05_JPRB,9.3168E-05_JPRB,1.1009E-04_JPRB,1.0023E-04_JPRB/)
KBO( :, 4,47, 3) = (/&
&1.3032E-05_JPRB,1.5427E-05_JPRB,6.8598E-05_JPRB,9.5568E-05_JPRB,1.1206E-04_JPRB,1.0142E-04_JPRB/)
KBO( :, 5,47, 3) = (/&
&1.4254E-05_JPRB,1.6795E-05_JPRB,7.1096E-05_JPRB,9.7934E-05_JPRB,1.1379E-04_JPRB,1.0199E-04_JPRB/)
KBO( :, 1,48, 3) = (/&
&8.6841E-06_JPRB,1.0096E-05_JPRB,4.9694E-05_JPRB,7.1452E-05_JPRB,8.5259E-05_JPRB,7.8307E-05_JPRB/)
KBO( :, 2,48, 3) = (/&
&9.0796E-06_JPRB,1.0659E-05_JPRB,5.1740E-05_JPRB,7.3900E-05_JPRB,8.7875E-05_JPRB,8.0451E-05_JPRB/)
KBO( :, 3,48, 3) = (/&
&9.6769E-06_JPRB,1.1450E-05_JPRB,5.3831E-05_JPRB,7.6095E-05_JPRB,9.0067E-05_JPRB,8.2117E-05_JPRB/)
KBO( :, 4,48, 3) = (/&
&1.0440E-05_JPRB,1.2385E-05_JPRB,5.5960E-05_JPRB,7.8221E-05_JPRB,9.1891E-05_JPRB,8.3379E-05_JPRB/)
KBO( :, 5,48, 3) = (/&
&1.1399E-05_JPRB,1.3468E-05_JPRB,5.8115E-05_JPRB,8.0301E-05_JPRB,9.3494E-05_JPRB,8.4132E-05_JPRB/)
KBO( :, 1,49, 3) = (/&
&7.0695E-06_JPRB,8.1883E-06_JPRB,4.0270E-05_JPRB,5.7981E-05_JPRB,6.9259E-05_JPRB,6.3681E-05_JPRB/)
KBO( :, 2,49, 3) = (/&
&7.3322E-06_JPRB,8.5897E-06_JPRB,4.2014E-05_JPRB,6.0156E-05_JPRB,7.1569E-05_JPRB,6.5714E-05_JPRB/)
KBO( :, 3,49, 3) = (/&
&7.7779E-06_JPRB,9.1932E-06_JPRB,4.3778E-05_JPRB,6.2075E-05_JPRB,7.3581E-05_JPRB,6.7311E-05_JPRB/)
KBO( :, 4,49, 3) = (/&
&8.3667E-06_JPRB,9.9391E-06_JPRB,4.5605E-05_JPRB,6.3945E-05_JPRB,7.5254E-05_JPRB,6.8602E-05_JPRB/)
KBO( :, 5,49, 3) = (/&
&9.1100E-06_JPRB,1.0797E-05_JPRB,4.7455E-05_JPRB,6.5783E-05_JPRB,7.6741E-05_JPRB,6.9496E-05_JPRB/)
KBO( :, 1,50, 3) = (/&
&5.7666E-06_JPRB,6.6617E-06_JPRB,3.2634E-05_JPRB,4.7026E-05_JPRB,5.6231E-05_JPRB,5.1646E-05_JPRB/)
KBO( :, 2,50, 3) = (/&
&5.9413E-06_JPRB,6.9423E-06_JPRB,3.4121E-05_JPRB,4.8951E-05_JPRB,5.8275E-05_JPRB,5.3533E-05_JPRB/)
KBO( :, 3,50, 3) = (/&
&6.2683E-06_JPRB,7.3972E-06_JPRB,3.5607E-05_JPRB,5.0641E-05_JPRB,6.0090E-05_JPRB,5.4999E-05_JPRB/)
KBO( :, 4,50, 3) = (/&
&6.7199E-06_JPRB,7.9879E-06_JPRB,3.7167E-05_JPRB,5.2275E-05_JPRB,6.1608E-05_JPRB,5.6235E-05_JPRB/)
KBO( :, 5,50, 3) = (/&
&7.3034E-06_JPRB,8.6808E-06_JPRB,3.8757E-05_JPRB,5.3881E-05_JPRB,6.2968E-05_JPRB,5.7167E-05_JPRB/)
KBO( :, 1,51, 3) = (/&
&4.7086E-06_JPRB,5.4299E-06_JPRB,2.6424E-05_JPRB,3.8115E-05_JPRB,4.5610E-05_JPRB,4.1794E-05_JPRB/)
KBO( :, 2,51, 3) = (/&
&4.8287E-06_JPRB,5.6240E-06_JPRB,2.7697E-05_JPRB,3.9799E-05_JPRB,4.7412E-05_JPRB,4.3512E-05_JPRB/)
KBO( :, 3,51, 3) = (/&
&5.0606E-06_JPRB,5.9604E-06_JPRB,2.8952E-05_JPRB,4.1290E-05_JPRB,4.9031E-05_JPRB,4.4849E-05_JPRB/)
KBO( :, 4,51, 3) = (/&
&5.4065E-06_JPRB,6.4263E-06_JPRB,3.0283E-05_JPRB,4.2717E-05_JPRB,5.0424E-05_JPRB,4.5995E-05_JPRB/)
KBO( :, 5,51, 3) = (/&
&5.8615E-06_JPRB,6.9820E-06_JPRB,3.1641E-05_JPRB,4.4120E-05_JPRB,5.1647E-05_JPRB,4.6912E-05_JPRB/)
KBO( :, 1,52, 3) = (/&
&3.8436E-06_JPRB,4.4274E-06_JPRB,2.1373E-05_JPRB,3.0858E-05_JPRB,3.6953E-05_JPRB,3.3785E-05_JPRB/)
KBO( :, 2,52, 3) = (/&
&3.9328E-06_JPRB,4.5651E-06_JPRB,2.2468E-05_JPRB,3.2320E-05_JPRB,3.8527E-05_JPRB,3.5353E-05_JPRB/)
KBO( :, 3,52, 3) = (/&
&4.0914E-06_JPRB,4.8085E-06_JPRB,2.3521E-05_JPRB,3.3631E-05_JPRB,3.9963E-05_JPRB,3.6585E-05_JPRB/)
KBO( :, 4,52, 3) = (/&
&4.3531E-06_JPRB,5.1701E-06_JPRB,2.4643E-05_JPRB,3.4861E-05_JPRB,4.1208E-05_JPRB,3.7630E-05_JPRB/)
KBO( :, 5,52, 3) = (/&
&4.7050E-06_JPRB,5.6131E-06_JPRB,2.5801E-05_JPRB,3.6084E-05_JPRB,4.2308E-05_JPRB,3.8507E-05_JPRB/)
KBO( :, 1,53, 3) = (/&
&3.1307E-06_JPRB,3.6090E-06_JPRB,1.7271E-05_JPRB,2.4948E-05_JPRB,2.9905E-05_JPRB,2.7291E-05_JPRB/)
KBO( :, 2,53, 3) = (/&
&3.2062E-06_JPRB,3.7126E-06_JPRB,1.8207E-05_JPRB,2.6210E-05_JPRB,3.1263E-05_JPRB,2.8728E-05_JPRB/)
KBO( :, 3,53, 3) = (/&
&3.3144E-06_JPRB,3.8844E-06_JPRB,1.9096E-05_JPRB,2.7367E-05_JPRB,3.2548E-05_JPRB,2.9869E-05_JPRB/)
KBO( :, 4,53, 3) = (/&
&3.5077E-06_JPRB,4.1595E-06_JPRB,2.0034E-05_JPRB,2.8427E-05_JPRB,3.3652E-05_JPRB,3.0823E-05_JPRB/)
KBO( :, 5,53, 3) = (/&
&3.7772E-06_JPRB,4.5101E-06_JPRB,2.1018E-05_JPRB,2.9487E-05_JPRB,3.4629E-05_JPRB,3.1664E-05_JPRB/)
KBO( :, 1,54, 3) = (/&
&2.5452E-06_JPRB,2.9417E-06_JPRB,1.3965E-05_JPRB,2.0178E-05_JPRB,2.4209E-05_JPRB,2.1911E-05_JPRB/)
KBO( :, 2,54, 3) = (/&
&2.6173E-06_JPRB,3.0265E-06_JPRB,1.4760E-05_JPRB,2.1266E-05_JPRB,2.5377E-05_JPRB,2.3188E-05_JPRB/)
KBO( :, 3,54, 3) = (/&
&2.6943E-06_JPRB,3.1475E-06_JPRB,1.5512E-05_JPRB,2.2269E-05_JPRB,2.6497E-05_JPRB,2.4193E-05_JPRB/)
KBO( :, 4,54, 3) = (/&
&2.8346E-06_JPRB,3.3549E-06_JPRB,1.6295E-05_JPRB,2.3183E-05_JPRB,2.7474E-05_JPRB,2.5015E-05_JPRB/)
KBO( :, 5,54, 3) = (/&
&3.0408E-06_JPRB,3.6324E-06_JPRB,1.7127E-05_JPRB,2.4100E-05_JPRB,2.8339E-05_JPRB,2.5745E-05_JPRB/)
KBO( :, 1,55, 3) = (/&
&2.0632E-06_JPRB,2.3940E-06_JPRB,1.1296E-05_JPRB,1.6316E-05_JPRB,1.9586E-05_JPRB,1.7519E-05_JPRB/)
KBO( :, 2,55, 3) = (/&
&2.1373E-06_JPRB,2.4691E-06_JPRB,1.1961E-05_JPRB,1.7242E-05_JPRB,2.0583E-05_JPRB,1.8621E-05_JPRB/)
KBO( :, 3,55, 3) = (/&
&2.1949E-06_JPRB,2.5561E-06_JPRB,1.2600E-05_JPRB,1.8111E-05_JPRB,2.1559E-05_JPRB,1.9499E-05_JPRB/)
KBO( :, 4,55, 3) = (/&
&2.2950E-06_JPRB,2.7109E-06_JPRB,1.3250E-05_JPRB,1.8899E-05_JPRB,2.2414E-05_JPRB,2.0198E-05_JPRB/)
KBO( :, 5,55, 3) = (/&
&2.4530E-06_JPRB,2.9291E-06_JPRB,1.3951E-05_JPRB,1.9686E-05_JPRB,2.3177E-05_JPRB,2.0800E-05_JPRB/)
KBO( :, 1,56, 3) = (/&
&1.6642E-06_JPRB,1.9426E-06_JPRB,9.1341E-06_JPRB,1.3181E-05_JPRB,1.5829E-05_JPRB,1.3992E-05_JPRB/)
KBO( :, 2,56, 3) = (/&
&1.7429E-06_JPRB,2.0139E-06_JPRB,9.6851E-06_JPRB,1.3963E-05_JPRB,1.6681E-05_JPRB,1.4936E-05_JPRB/)
KBO( :, 3,56, 3) = (/&
&1.7896E-06_JPRB,2.0795E-06_JPRB,1.0225E-05_JPRB,1.4716E-05_JPRB,1.7517E-05_JPRB,1.5702E-05_JPRB/)
KBO( :, 4,56, 3) = (/&
&1.8607E-06_JPRB,2.1923E-06_JPRB,1.0768E-05_JPRB,1.5397E-05_JPRB,1.8274E-05_JPRB,1.6306E-05_JPRB/)
KBO( :, 5,56, 3) = (/&
&1.9799E-06_JPRB,2.3617E-06_JPRB,1.1356E-05_JPRB,1.6070E-05_JPRB,1.8948E-05_JPRB,1.6801E-05_JPRB/)
KBO( :, 1,57, 3) = (/&
&1.3353E-06_JPRB,1.5730E-06_JPRB,7.3811E-06_JPRB,1.0640E-05_JPRB,1.2777E-05_JPRB,1.1158E-05_JPRB/)
KBO( :, 2,57, 3) = (/&
&1.4179E-06_JPRB,1.6416E-06_JPRB,7.8345E-06_JPRB,1.1296E-05_JPRB,1.3506E-05_JPRB,1.1962E-05_JPRB/)
KBO( :, 3,57, 3) = (/&
&1.4599E-06_JPRB,1.6939E-06_JPRB,8.2917E-06_JPRB,1.1945E-05_JPRB,1.4220E-05_JPRB,1.2633E-05_JPRB/)
KBO( :, 4,57, 3) = (/&
&1.5112E-06_JPRB,1.7747E-06_JPRB,8.7450E-06_JPRB,1.2531E-05_JPRB,1.4885E-05_JPRB,1.3158E-05_JPRB/)
KBO( :, 5,57, 3) = (/&
&1.5993E-06_JPRB,1.9047E-06_JPRB,9.2362E-06_JPRB,1.3103E-05_JPRB,1.5471E-05_JPRB,1.3571E-05_JPRB/)
KBO( :, 1,58, 3) = (/&
&1.0682E-06_JPRB,1.2707E-06_JPRB,5.9673E-06_JPRB,8.5915E-06_JPRB,1.0313E-05_JPRB,8.8875E-06_JPRB/)
KBO( :, 2,58, 3) = (/&
&1.1510E-06_JPRB,1.3372E-06_JPRB,6.3383E-06_JPRB,9.1371E-06_JPRB,1.0932E-05_JPRB,9.5717E-06_JPRB/)
KBO( :, 3,58, 3) = (/&
&1.1918E-06_JPRB,1.3813E-06_JPRB,6.7246E-06_JPRB,9.6935E-06_JPRB,1.1539E-05_JPRB,1.0149E-05_JPRB/)
KBO( :, 4,58, 3) = (/&
&1.2303E-06_JPRB,1.4399E-06_JPRB,7.1031E-06_JPRB,1.0198E-05_JPRB,1.2120E-05_JPRB,1.0603E-05_JPRB/)
KBO( :, 5,58, 3) = (/&
&1.2943E-06_JPRB,1.5387E-06_JPRB,7.5113E-06_JPRB,1.0682E-05_JPRB,1.2629E-05_JPRB,1.0955E-05_JPRB/)
KBO( :, 1,59, 3) = (/&
&8.6844E-07_JPRB,1.0371E-06_JPRB,4.8749E-06_JPRB,7.0111E-06_JPRB,8.4115E-06_JPRB,7.1461E-06_JPRB/)
KBO( :, 2,59, 3) = (/&
&9.4083E-07_JPRB,1.0954E-06_JPRB,5.1836E-06_JPRB,7.4691E-06_JPRB,8.9328E-06_JPRB,7.7016E-06_JPRB/)
KBO( :, 3,59, 3) = (/&
&9.7741E-07_JPRB,1.1331E-06_JPRB,5.5070E-06_JPRB,7.9393E-06_JPRB,9.4488E-06_JPRB,8.1607E-06_JPRB/)
KBO( :, 4,59, 3) = (/&
&1.0092E-06_JPRB,1.1806E-06_JPRB,5.8246E-06_JPRB,8.3651E-06_JPRB,9.9432E-06_JPRB,8.5246E-06_JPRB/)
KBO( :, 5,59, 3) = (/&
&1.0602E-06_JPRB,1.2608E-06_JPRB,6.1682E-06_JPRB,8.7778E-06_JPRB,1.0376E-05_JPRB,8.8030E-06_JPRB/)
KBO( :, 1,13, 4) = (/&
&1.1944E-02_JPRB,1.2168E-02_JPRB,5.9922E-02_JPRB,8.9367E-02_JPRB,1.1074E-01_JPRB,1.1944E-01_JPRB/)
KBO( :, 2,13, 4) = (/&
&1.2086E-02_JPRB,1.2304E-02_JPRB,6.1460E-02_JPRB,9.1456E-02_JPRB,1.1344E-01_JPRB,1.2412E-01_JPRB/)
KBO( :, 3,13, 4) = (/&
&1.2357E-02_JPRB,1.2570E-02_JPRB,6.2887E-02_JPRB,9.3358E-02_JPRB,1.1570E-01_JPRB,1.2845E-01_JPRB/)
KBO( :, 4,13, 4) = (/&
&1.2729E-02_JPRB,1.2937E-02_JPRB,6.4147E-02_JPRB,9.5013E-02_JPRB,1.1762E-01_JPRB,1.3226E-01_JPRB/)
KBO( :, 5,13, 4) = (/&
&1.3238E-02_JPRB,1.3440E-02_JPRB,6.5153E-02_JPRB,9.6392E-02_JPRB,1.1918E-01_JPRB,1.3570E-01_JPRB/)
KBO( :, 1,14, 4) = (/&
&1.0012E-02_JPRB,1.0247E-02_JPRB,5.2975E-02_JPRB,7.8942E-02_JPRB,9.7346E-02_JPRB,1.0368E-01_JPRB/)
KBO( :, 2,14, 4) = (/&
&1.0180E-02_JPRB,1.0410E-02_JPRB,5.4409E-02_JPRB,8.0856E-02_JPRB,9.9740E-02_JPRB,1.0751E-01_JPRB/)
KBO( :, 3,14, 4) = (/&
&1.0467E-02_JPRB,1.0689E-02_JPRB,5.5693E-02_JPRB,8.2579E-02_JPRB,1.0188E-01_JPRB,1.1093E-01_JPRB/)
KBO( :, 4,14, 4) = (/&
&1.0854E-02_JPRB,1.1067E-02_JPRB,5.6775E-02_JPRB,8.4028E-02_JPRB,1.0368E-01_JPRB,1.1389E-01_JPRB/)
KBO( :, 5,14, 4) = (/&
&1.1343E-02_JPRB,1.1549E-02_JPRB,5.7714E-02_JPRB,8.5292E-02_JPRB,1.0511E-01_JPRB,1.1652E-01_JPRB/)
KBO( :, 1,15, 4) = (/&
&8.3778E-03_JPRB,8.6309E-03_JPRB,4.6498E-02_JPRB,6.9169E-02_JPRB,8.4926E-02_JPRB,8.9479E-02_JPRB/)
KBO( :, 2,15, 4) = (/&
&8.5667E-03_JPRB,8.8101E-03_JPRB,4.7757E-02_JPRB,7.0912E-02_JPRB,8.7130E-02_JPRB,9.2622E-02_JPRB/)
KBO( :, 3,15, 4) = (/&
&8.8588E-03_JPRB,9.0893E-03_JPRB,4.8864E-02_JPRB,7.2379E-02_JPRB,8.9054E-02_JPRB,9.5411E-02_JPRB/)
KBO( :, 4,15, 4) = (/&
&9.2397E-03_JPRB,9.4599E-03_JPRB,4.9829E-02_JPRB,7.3692E-02_JPRB,9.0686E-02_JPRB,9.7794E-02_JPRB/)
KBO( :, 5,15, 4) = (/&
&9.6728E-03_JPRB,9.8843E-03_JPRB,5.0711E-02_JPRB,7.4868E-02_JPRB,9.2000E-02_JPRB,9.9673E-02_JPRB/)
KBO( :, 1,16, 4) = (/&
&7.0032E-03_JPRB,7.2800E-03_JPRB,4.0493E-02_JPRB,6.0087E-02_JPRB,7.3654E-02_JPRB,7.6847E-02_JPRB/)
KBO( :, 2,16, 4) = (/&
&7.2046E-03_JPRB,7.4657E-03_JPRB,4.1559E-02_JPRB,6.1552E-02_JPRB,7.5591E-02_JPRB,7.9522E-02_JPRB/)
KBO( :, 3,16, 4) = (/&
&7.4951E-03_JPRB,7.7408E-03_JPRB,4.2525E-02_JPRB,6.2872E-02_JPRB,7.7303E-02_JPRB,8.1850E-02_JPRB/)
KBO( :, 4,16, 4) = (/&
&7.8374E-03_JPRB,8.0731E-03_JPRB,4.3431E-02_JPRB,6.4066E-02_JPRB,7.8697E-02_JPRB,8.3564E-02_JPRB/)
KBO( :, 5,16, 4) = (/&
&8.2028E-03_JPRB,8.4261E-03_JPRB,4.4256E-02_JPRB,6.5005E-02_JPRB,7.9598E-02_JPRB,8.4430E-02_JPRB/)
KBO( :, 1,17, 4) = (/&
&5.8518E-03_JPRB,6.1531E-03_JPRB,3.4959E-02_JPRB,5.1741E-02_JPRB,6.3466E-02_JPRB,6.5605E-02_JPRB/)
KBO( :, 2,17, 4) = (/&
&6.0575E-03_JPRB,6.3417E-03_JPRB,3.5874E-02_JPRB,5.3013E-02_JPRB,6.5151E-02_JPRB,6.7823E-02_JPRB/)
KBO( :, 3,17, 4) = (/&
&6.3232E-03_JPRB,6.5951E-03_JPRB,3.6761E-02_JPRB,5.4168E-02_JPRB,6.6560E-02_JPRB,6.9496E-02_JPRB/)
KBO( :, 4,17, 4) = (/&
&6.6221E-03_JPRB,6.8782E-03_JPRB,3.7567E-02_JPRB,5.5100E-02_JPRB,6.7478E-02_JPRB,7.0358E-02_JPRB/)
KBO( :, 5,17, 4) = (/&
&6.9347E-03_JPRB,7.1778E-03_JPRB,3.8256E-02_JPRB,5.5641E-02_JPRB,6.7818E-02_JPRB,7.0537E-02_JPRB/)
KBO( :, 1,18, 4) = (/&
&4.8880E-03_JPRB,5.2055E-03_JPRB,2.9960E-02_JPRB,4.4255E-02_JPRB,5.4342E-02_JPRB,5.5684E-02_JPRB/)
KBO( :, 2,18, 4) = (/&
&5.0836E-03_JPRB,5.3884E-03_JPRB,3.0780E-02_JPRB,4.5359E-02_JPRB,5.5706E-02_JPRB,5.7297E-02_JPRB/)
KBO( :, 3,18, 4) = (/&
&5.3194E-03_JPRB,5.6126E-03_JPRB,3.1543E-02_JPRB,4.6238E-02_JPRB,5.6632E-02_JPRB,5.8242E-02_JPRB/)
KBO( :, 4,18, 4) = (/&
&5.5796E-03_JPRB,5.8558E-03_JPRB,3.2190E-02_JPRB,4.6796E-02_JPRB,5.7064E-02_JPRB,5.8579E-02_JPRB/)
KBO( :, 5,18, 4) = (/&
&5.8422E-03_JPRB,6.1083E-03_JPRB,3.2701E-02_JPRB,4.7066E-02_JPRB,5.7105E-02_JPRB,5.8483E-02_JPRB/)
KBO( :, 1,19, 4) = (/&
&4.0830E-03_JPRB,4.4003E-03_JPRB,2.5536E-02_JPRB,3.7635E-02_JPRB,4.6188E-02_JPRB,4.6830E-02_JPRB/)
KBO( :, 2,19, 4) = (/&
&4.2621E-03_JPRB,4.5739E-03_JPRB,2.6225E-02_JPRB,3.8473E-02_JPRB,4.7113E-02_JPRB,4.7821E-02_JPRB/)
KBO( :, 3,19, 4) = (/&
&4.4701E-03_JPRB,4.7726E-03_JPRB,2.6827E-02_JPRB,3.9028E-02_JPRB,4.7627E-02_JPRB,4.8310E-02_JPRB/)
KBO( :, 4,19, 4) = (/&
&4.6836E-03_JPRB,4.9742E-03_JPRB,2.7306E-02_JPRB,3.9355E-02_JPRB,4.7801E-02_JPRB,4.8408E-02_JPRB/)
KBO( :, 5,19, 4) = (/&
&4.9101E-03_JPRB,5.1908E-03_JPRB,2.7671E-02_JPRB,3.9547E-02_JPRB,4.7738E-02_JPRB,4.8196E-02_JPRB/)
KBO( :, 1,20, 4) = (/&
&3.4183E-03_JPRB,3.7281E-03_JPRB,2.1635E-02_JPRB,3.1767E-02_JPRB,3.8910E-02_JPRB,3.9035E-02_JPRB/)
KBO( :, 2,20, 4) = (/&
&3.5755E-03_JPRB,3.8847E-03_JPRB,2.2172E-02_JPRB,3.2321E-02_JPRB,3.9468E-02_JPRB,3.9630E-02_JPRB/)
KBO( :, 3,20, 4) = (/&
&3.7470E-03_JPRB,4.0489E-03_JPRB,2.2621E-02_JPRB,3.2676E-02_JPRB,3.9755E-02_JPRB,3.9891E-02_JPRB/)
KBO( :, 4,20, 4) = (/&
&3.9257E-03_JPRB,4.2203E-03_JPRB,2.2997E-02_JPRB,3.2924E-02_JPRB,3.9820E-02_JPRB,3.9868E-02_JPRB/)
KBO( :, 5,20, 4) = (/&
&4.1248E-03_JPRB,4.4107E-03_JPRB,2.3239E-02_JPRB,3.3086E-02_JPRB,3.9734E-02_JPRB,3.9622E-02_JPRB/)
KBO( :, 1,21, 4) = (/&
&2.8606E-03_JPRB,3.1596E-03_JPRB,1.8191E-02_JPRB,2.6601E-02_JPRB,3.2515E-02_JPRB,3.2317E-02_JPRB/)
KBO( :, 2,21, 4) = (/&
&2.9928E-03_JPRB,3.2930E-03_JPRB,1.8598E-02_JPRB,2.6970E-02_JPRB,3.2866E-02_JPRB,3.2699E-02_JPRB/)
KBO( :, 3,21, 4) = (/&
&3.1369E-03_JPRB,3.4309E-03_JPRB,1.8968E-02_JPRB,2.7247E-02_JPRB,3.3035E-02_JPRB,3.2834E-02_JPRB/)
KBO( :, 4,21, 4) = (/&
&3.2911E-03_JPRB,3.5807E-03_JPRB,1.9242E-02_JPRB,2.7455E-02_JPRB,3.3060E-02_JPRB,3.2754E-02_JPRB/)
KBO( :, 5,21, 4) = (/&
&3.4660E-03_JPRB,3.7486E-03_JPRB,1.9402E-02_JPRB,2.7577E-02_JPRB,3.2988E-02_JPRB,3.2505E-02_JPRB/)
KBO( :, 1,22, 4) = (/&
&2.3958E-03_JPRB,2.6786E-03_JPRB,1.5221E-02_JPRB,2.2163E-02_JPRB,2.7039E-02_JPRB,2.6675E-02_JPRB/)
KBO( :, 2,22, 4) = (/&
&2.5089E-03_JPRB,2.7922E-03_JPRB,1.5555E-02_JPRB,2.2444E-02_JPRB,2.7268E-02_JPRB,2.6915E-02_JPRB/)
KBO( :, 3,22, 4) = (/&
&2.6330E-03_JPRB,2.9125E-03_JPRB,1.5842E-02_JPRB,2.2675E-02_JPRB,2.7372E-02_JPRB,2.6968E-02_JPRB/)
KBO( :, 4,22, 4) = (/&
&2.7694E-03_JPRB,3.0464E-03_JPRB,1.6030E-02_JPRB,2.2843E-02_JPRB,2.7392E-02_JPRB,2.6856E-02_JPRB/)
KBO( :, 5,22, 4) = (/&
&2.9232E-03_JPRB,3.1956E-03_JPRB,1.6145E-02_JPRB,2.2906E-02_JPRB,2.7331E-02_JPRB,2.6610E-02_JPRB/)
KBO( :, 1,23, 4) = (/&
&2.0042E-03_JPRB,2.2640E-03_JPRB,1.2690E-02_JPRB,1.8401E-02_JPRB,2.2404E-02_JPRB,2.1959E-02_JPRB/)
KBO( :, 2,23, 4) = (/&
&2.1023E-03_JPRB,2.3617E-03_JPRB,1.2965E-02_JPRB,1.8637E-02_JPRB,2.2564E-02_JPRB,2.2109E-02_JPRB/)
KBO( :, 3,23, 4) = (/&
&2.2103E-03_JPRB,2.4685E-03_JPRB,1.3173E-02_JPRB,1.8833E-02_JPRB,2.2645E-02_JPRB,2.2108E-02_JPRB/)
KBO( :, 4,23, 4) = (/&
&2.3303E-03_JPRB,2.5871E-03_JPRB,1.3312E-02_JPRB,1.8940E-02_JPRB,2.2663E-02_JPRB,2.1985E-02_JPRB/)
KBO( :, 5,23, 4) = (/&
&2.4661E-03_JPRB,2.7218E-03_JPRB,1.3399E-02_JPRB,1.8972E-02_JPRB,2.2604E-02_JPRB,2.1760E-02_JPRB/)
KBO( :, 1,24, 4) = (/&
&1.6762E-03_JPRB,1.9090E-03_JPRB,1.0559E-02_JPRB,1.5252E-02_JPRB,1.8521E-02_JPRB,1.8042E-02_JPRB/)
KBO( :, 2,24, 4) = (/&
&1.7614E-03_JPRB,1.9932E-03_JPRB,1.0770E-02_JPRB,1.5455E-02_JPRB,1.8647E-02_JPRB,1.8128E-02_JPRB/)
KBO( :, 3,24, 4) = (/&
&1.8564E-03_JPRB,2.0890E-03_JPRB,1.0927E-02_JPRB,1.5598E-02_JPRB,1.8716E-02_JPRB,1.8097E-02_JPRB/)
KBO( :, 4,24, 4) = (/&
&1.9618E-03_JPRB,2.1951E-03_JPRB,1.1029E-02_JPRB,1.5669E-02_JPRB,1.8728E-02_JPRB,1.7971E-02_JPRB/)
KBO( :, 5,24, 4) = (/&
&2.0788E-03_JPRB,2.3139E-03_JPRB,1.1094E-02_JPRB,1.5685E-02_JPRB,1.8656E-02_JPRB,1.7765E-02_JPRB/)
KBO( :, 1,25, 4) = (/&
&1.4025E-03_JPRB,1.6067E-03_JPRB,8.7676E-03_JPRB,1.2632E-02_JPRB,1.5295E-02_JPRB,1.4808E-02_JPRB/)
KBO( :, 2,25, 4) = (/&
&1.4767E-03_JPRB,1.6810E-03_JPRB,8.9285E-03_JPRB,1.2792E-02_JPRB,1.5398E-02_JPRB,1.4849E-02_JPRB/)
KBO( :, 3,25, 4) = (/&
&1.5600E-03_JPRB,1.7664E-03_JPRB,9.0451E-03_JPRB,1.2893E-02_JPRB,1.5458E-02_JPRB,1.4803E-02_JPRB/)
KBO( :, 4,25, 4) = (/&
&1.6518E-03_JPRB,1.8613E-03_JPRB,9.1218E-03_JPRB,1.2945E-02_JPRB,1.5449E-02_JPRB,1.4682E-02_JPRB/)
KBO( :, 5,25, 4) = (/&
&1.7503E-03_JPRB,1.9622E-03_JPRB,9.1788E-03_JPRB,1.2954E-02_JPRB,1.5378E-02_JPRB,1.4496E-02_JPRB/)
KBO( :, 1,26, 4) = (/&
&1.1743E-03_JPRB,1.3515E-03_JPRB,7.2680E-03_JPRB,1.0453E-02_JPRB,1.2624E-02_JPRB,1.2143E-02_JPRB/)
KBO( :, 2,26, 4) = (/&
&1.2397E-03_JPRB,1.4187E-03_JPRB,7.3884E-03_JPRB,1.0572E-02_JPRB,1.2713E-02_JPRB,1.2158E-02_JPRB/)
KBO( :, 3,26, 4) = (/&
&1.3121E-03_JPRB,1.4944E-03_JPRB,7.4769E-03_JPRB,1.0647E-02_JPRB,1.2748E-02_JPRB,1.2101E-02_JPRB/)
KBO( :, 4,26, 4) = (/&
&1.3904E-03_JPRB,1.5774E-03_JPRB,7.5401E-03_JPRB,1.0684E-02_JPRB,1.2728E-02_JPRB,1.1986E-02_JPRB/)
KBO( :, 5,26, 4) = (/&
&1.4736E-03_JPRB,1.6625E-03_JPRB,7.5925E-03_JPRB,1.0683E-02_JPRB,1.2662E-02_JPRB,1.1823E-02_JPRB/)
KBO( :, 1,27, 4) = (/&
&9.8402E-04_JPRB,1.1373E-03_JPRB,6.0162E-03_JPRB,8.6394E-03_JPRB,1.0419E-02_JPRB,9.9561E-03_JPRB/)
KBO( :, 2,27, 4) = (/&
&1.0411E-03_JPRB,1.1972E-03_JPRB,6.1086E-03_JPRB,8.7287E-03_JPRB,1.0483E-02_JPRB,9.9519E-03_JPRB/)
KBO( :, 3,27, 4) = (/&
&1.1029E-03_JPRB,1.2633E-03_JPRB,6.1781E-03_JPRB,8.7827E-03_JPRB,1.0501E-02_JPRB,9.8918E-03_JPRB/)
KBO( :, 4,27, 4) = (/&
&1.1695E-03_JPRB,1.3344E-03_JPRB,6.2341E-03_JPRB,8.8083E-03_JPRB,1.0478E-02_JPRB,9.7857E-03_JPRB/)
KBO( :, 5,27, 4) = (/&
&1.2409E-03_JPRB,1.4079E-03_JPRB,6.2822E-03_JPRB,8.8079E-03_JPRB,1.0418E-02_JPRB,9.6453E-03_JPRB/)
KBO( :, 1,28, 4) = (/&
&8.2502E-04_JPRB,9.5751E-04_JPRB,4.9758E-03_JPRB,7.1338E-03_JPRB,8.5938E-03_JPRB,8.1599E-03_JPRB/)
KBO( :, 2,28, 4) = (/&
&8.7450E-04_JPRB,1.0105E-03_JPRB,5.0486E-03_JPRB,7.1996E-03_JPRB,8.6369E-03_JPRB,8.1441E-03_JPRB/)
KBO( :, 3,28, 4) = (/&
&9.2664E-04_JPRB,1.0674E-03_JPRB,5.1070E-03_JPRB,7.2390E-03_JPRB,8.6457E-03_JPRB,8.0849E-03_JPRB/)
KBO( :, 4,28, 4) = (/&
&9.8426E-04_JPRB,1.1287E-03_JPRB,5.1587E-03_JPRB,7.2593E-03_JPRB,8.6218E-03_JPRB,7.9907E-03_JPRB/)
KBO( :, 5,28, 4) = (/&
&1.0460E-03_JPRB,1.1932E-03_JPRB,5.2066E-03_JPRB,7.2612E-03_JPRB,8.5694E-03_JPRB,7.8705E-03_JPRB/)
KBO( :, 1,29, 4) = (/&
&6.9236E-04_JPRB,8.0674E-04_JPRB,4.1133E-03_JPRB,5.8863E-03_JPRB,7.0815E-03_JPRB,6.6900E-03_JPRB/)
KBO( :, 2,29, 4) = (/&
&7.3441E-04_JPRB,8.5270E-04_JPRB,4.1735E-03_JPRB,5.9349E-03_JPRB,7.1122E-03_JPRB,6.6683E-03_JPRB/)
KBO( :, 3,29, 4) = (/&
&7.7930E-04_JPRB,9.0247E-04_JPRB,4.2252E-03_JPRB,5.9662E-03_JPRB,7.1136E-03_JPRB,6.6140E-03_JPRB/)
KBO( :, 4,29, 4) = (/&
&8.2905E-04_JPRB,9.5490E-04_JPRB,4.2746E-03_JPRB,5.9835E-03_JPRB,7.0898E-03_JPRB,6.5328E-03_JPRB/)
KBO( :, 5,29, 4) = (/&
&8.8288E-04_JPRB,1.0121E-03_JPRB,4.3168E-03_JPRB,5.9898E-03_JPRB,7.0475E-03_JPRB,6.4307E-03_JPRB/)
KBO( :, 1,30, 4) = (/&
&5.8109E-04_JPRB,6.7992E-04_JPRB,3.4007E-03_JPRB,4.8546E-03_JPRB,5.8338E-03_JPRB,5.4857E-03_JPRB/)
KBO( :, 2,30, 4) = (/&
&6.1672E-04_JPRB,7.1953E-04_JPRB,3.4531E-03_JPRB,4.8921E-03_JPRB,5.8538E-03_JPRB,5.4623E-03_JPRB/)
KBO( :, 3,30, 4) = (/&
&6.5564E-04_JPRB,7.6235E-04_JPRB,3.5001E-03_JPRB,4.9200E-03_JPRB,5.8508E-03_JPRB,5.4136E-03_JPRB/)
KBO( :, 4,30, 4) = (/&
&6.9916E-04_JPRB,8.0837E-04_JPRB,3.5445E-03_JPRB,4.9361E-03_JPRB,5.8315E-03_JPRB,5.3448E-03_JPRB/)
KBO( :, 5,30, 4) = (/&
&7.4588E-04_JPRB,8.5907E-04_JPRB,3.5814E-03_JPRB,4.9470E-03_JPRB,5.7972E-03_JPRB,5.2575E-03_JPRB/)
KBO( :, 1,31, 4) = (/&
&4.8773E-04_JPRB,5.7298E-04_JPRB,2.8142E-03_JPRB,4.0034E-03_JPRB,4.8046E-03_JPRB,4.5018E-03_JPRB/)
KBO( :, 2,31, 4) = (/&
&5.1790E-04_JPRB,6.0687E-04_JPRB,2.8592E-03_JPRB,4.0352E-03_JPRB,4.8163E-03_JPRB,4.4785E-03_JPRB/)
KBO( :, 3,31, 4) = (/&
&5.5259E-04_JPRB,6.4420E-04_JPRB,2.9026E-03_JPRB,4.0596E-03_JPRB,4.8128E-03_JPRB,4.4370E-03_JPRB/)
KBO( :, 4,31, 4) = (/&
&5.9027E-04_JPRB,6.8473E-04_JPRB,2.9396E-03_JPRB,4.0779E-03_JPRB,4.7972E-03_JPRB,4.3789E-03_JPRB/)
KBO( :, 5,31, 4) = (/&
&6.3109E-04_JPRB,7.2996E-04_JPRB,2.9730E-03_JPRB,4.0892E-03_JPRB,4.7703E-03_JPRB,4.3063E-03_JPRB/)
KBO( :, 1,32, 4) = (/&
&4.0943E-04_JPRB,4.8260E-04_JPRB,2.3307E-03_JPRB,3.3026E-03_JPRB,3.9553E-03_JPRB,3.6951E-03_JPRB/)
KBO( :, 2,32, 4) = (/&
&4.3585E-04_JPRB,5.1194E-04_JPRB,2.3706E-03_JPRB,3.3307E-03_JPRB,3.9627E-03_JPRB,3.6751E-03_JPRB/)
KBO( :, 3,32, 4) = (/&
&4.6644E-04_JPRB,5.4471E-04_JPRB,2.4075E-03_JPRB,3.3544E-03_JPRB,3.9608E-03_JPRB,3.6388E-03_JPRB/)
KBO( :, 4,32, 4) = (/&
&4.9918E-04_JPRB,5.8045E-04_JPRB,2.4395E-03_JPRB,3.3725E-03_JPRB,3.9485E-03_JPRB,3.5900E-03_JPRB/)
KBO( :, 5,32, 4) = (/&
&5.3458E-04_JPRB,6.2069E-04_JPRB,2.4710E-03_JPRB,3.3839E-03_JPRB,3.9292E-03_JPRB,3.5299E-03_JPRB/)
KBO( :, 1,33, 4) = (/&
&3.4410E-04_JPRB,4.0654E-04_JPRB,1.9317E-03_JPRB,2.7269E-03_JPRB,3.2560E-03_JPRB,3.0357E-03_JPRB/)
KBO( :, 2,33, 4) = (/&
&3.6780E-04_JPRB,4.3231E-04_JPRB,1.9669E-03_JPRB,2.7524E-03_JPRB,3.2622E-03_JPRB,3.0171E-03_JPRB/)
KBO( :, 3,33, 4) = (/&
&3.9422E-04_JPRB,4.6103E-04_JPRB,1.9979E-03_JPRB,2.7749E-03_JPRB,3.2617E-03_JPRB,2.9869E-03_JPRB/)
KBO( :, 4,33, 4) = (/&
&4.2274E-04_JPRB,4.9289E-04_JPRB,2.0268E-03_JPRB,2.7910E-03_JPRB,3.2533E-03_JPRB,2.9461E-03_JPRB/)
KBO( :, 5,33, 4) = (/&
&4.5356E-04_JPRB,5.2826E-04_JPRB,2.0558E-03_JPRB,2.8026E-03_JPRB,3.2388E-03_JPRB,2.8971E-03_JPRB/)
KBO( :, 1,34, 4) = (/&
&2.8907E-04_JPRB,3.4197E-04_JPRB,1.6017E-03_JPRB,2.2527E-03_JPRB,2.6816E-03_JPRB,2.4934E-03_JPRB/)
KBO( :, 2,34, 4) = (/&
&3.0999E-04_JPRB,3.6459E-04_JPRB,1.6314E-03_JPRB,2.2770E-03_JPRB,2.6881E-03_JPRB,2.4774E-03_JPRB/)
KBO( :, 3,34, 4) = (/&
&3.3292E-04_JPRB,3.8989E-04_JPRB,1.6587E-03_JPRB,2.2965E-03_JPRB,2.6882E-03_JPRB,2.4516E-03_JPRB/)
KBO( :, 4,34, 4) = (/&
&3.5758E-04_JPRB,4.1817E-04_JPRB,1.6851E-03_JPRB,2.3118E-03_JPRB,2.6837E-03_JPRB,2.4183E-03_JPRB/)
KBO( :, 5,34, 4) = (/&
&3.8443E-04_JPRB,4.4891E-04_JPRB,1.7117E-03_JPRB,2.3241E-03_JPRB,2.6734E-03_JPRB,2.3789E-03_JPRB/)
KBO( :, 1,35, 4) = (/&
&2.4163E-04_JPRB,2.8613E-04_JPRB,1.3262E-03_JPRB,1.8610E-03_JPRB,2.2092E-03_JPRB,2.0492E-03_JPRB/)
KBO( :, 2,35, 4) = (/&
&2.5980E-04_JPRB,3.0590E-04_JPRB,1.3518E-03_JPRB,1.8829E-03_JPRB,2.2161E-03_JPRB,2.0364E-03_JPRB/)
KBO( :, 3,35, 4) = (/&
&2.7948E-04_JPRB,3.2806E-04_JPRB,1.3762E-03_JPRB,1.9000E-03_JPRB,2.2186E-03_JPRB,2.0149E-03_JPRB/)
KBO( :, 4,35, 4) = (/&
&3.0066E-04_JPRB,3.5268E-04_JPRB,1.4004E-03_JPRB,1.9149E-03_JPRB,2.2165E-03_JPRB,1.9889E-03_JPRB/)
KBO( :, 5,35, 4) = (/&
&3.2401E-04_JPRB,3.7942E-04_JPRB,1.4250E-03_JPRB,1.9278E-03_JPRB,2.2099E-03_JPRB,1.9578E-03_JPRB/)
KBO( :, 1,36, 4) = (/&
&2.0066E-04_JPRB,2.3797E-04_JPRB,1.0962E-03_JPRB,1.5363E-03_JPRB,1.8202E-03_JPRB,1.6851E-03_JPRB/)
KBO( :, 2,36, 4) = (/&
&2.1623E-04_JPRB,2.5498E-04_JPRB,1.1188E-03_JPRB,1.5557E-03_JPRB,1.8279E-03_JPRB,1.6749E-03_JPRB/)
KBO( :, 3,36, 4) = (/&
&2.3303E-04_JPRB,2.7423E-04_JPRB,1.1407E-03_JPRB,1.5718E-03_JPRB,1.8325E-03_JPRB,1.6591E-03_JPRB/)
KBO( :, 4,36, 4) = (/&
&2.5102E-04_JPRB,2.9534E-04_JPRB,1.1626E-03_JPRB,1.5863E-03_JPRB,1.8324E-03_JPRB,1.6382E-03_JPRB/)
KBO( :, 5,36, 4) = (/&
&2.7107E-04_JPRB,3.1839E-04_JPRB,1.1850E-03_JPRB,1.5990E-03_JPRB,1.8295E-03_JPRB,1.6138E-03_JPRB/)
KBO( :, 1,37, 4) = (/&
&1.6489E-04_JPRB,1.9598E-04_JPRB,9.0338E-04_JPRB,1.2660E-03_JPRB,1.4992E-03_JPRB,1.3858E-03_JPRB/)
KBO( :, 2,37, 4) = (/&
&1.7800E-04_JPRB,2.1035E-04_JPRB,9.2319E-04_JPRB,1.2835E-03_JPRB,1.5078E-03_JPRB,1.3789E-03_JPRB/)
KBO( :, 3,37, 4) = (/&
&1.9213E-04_JPRB,2.2670E-04_JPRB,9.4286E-04_JPRB,1.2987E-03_JPRB,1.5138E-03_JPRB,1.3673E-03_JPRB/)
KBO( :, 4,37, 4) = (/&
&2.0731E-04_JPRB,2.4467E-04_JPRB,9.6260E-04_JPRB,1.3129E-03_JPRB,1.5159E-03_JPRB,1.3520E-03_JPRB/)
KBO( :, 5,37, 4) = (/&
&2.2426E-04_JPRB,2.6433E-04_JPRB,9.8317E-04_JPRB,1.3255E-03_JPRB,1.5160E-03_JPRB,1.3330E-03_JPRB/)
KBO( :, 1,38, 4) = (/&
&1.3545E-04_JPRB,1.6133E-04_JPRB,7.4423E-04_JPRB,1.0430E-03_JPRB,1.2345E-03_JPRB,1.1400E-03_JPRB/)
KBO( :, 2,38, 4) = (/&
&1.4647E-04_JPRB,1.7346E-04_JPRB,7.6176E-04_JPRB,1.0590E-03_JPRB,1.2440E-03_JPRB,1.1357E-03_JPRB/)
KBO( :, 3,38, 4) = (/&
&1.5834E-04_JPRB,1.8731E-04_JPRB,7.7933E-04_JPRB,1.0731E-03_JPRB,1.2505E-03_JPRB,1.1275E-03_JPRB/)
KBO( :, 4,38, 4) = (/&
&1.7112E-04_JPRB,2.0254E-04_JPRB,7.9709E-04_JPRB,1.0866E-03_JPRB,1.2542E-03_JPRB,1.1163E-03_JPRB/)
KBO( :, 5,38, 4) = (/&
&1.8543E-04_JPRB,2.1932E-04_JPRB,8.1567E-04_JPRB,1.0989E-03_JPRB,1.2562E-03_JPRB,1.1014E-03_JPRB/)
KBO( :, 1,39, 4) = (/&
&1.1128E-04_JPRB,1.3279E-04_JPRB,6.1308E-04_JPRB,8.5960E-04_JPRB,1.0171E-03_JPRB,9.3831E-04_JPRB/)
KBO( :, 2,39, 4) = (/&
&1.2054E-04_JPRB,1.4305E-04_JPRB,6.2838E-04_JPRB,8.7394E-04_JPRB,1.0264E-03_JPRB,9.3635E-04_JPRB/)
KBO( :, 3,39, 4) = (/&
&1.3051E-04_JPRB,1.5480E-04_JPRB,6.4408E-04_JPRB,8.8688E-04_JPRB,1.0332E-03_JPRB,9.3078E-04_JPRB/)
KBO( :, 4,39, 4) = (/&
&1.4126E-04_JPRB,1.6774E-04_JPRB,6.5994E-04_JPRB,8.9946E-04_JPRB,1.0378E-03_JPRB,9.2268E-04_JPRB/)
KBO( :, 5,39, 4) = (/&
&1.5338E-04_JPRB,1.8209E-04_JPRB,6.7678E-04_JPRB,9.1123E-04_JPRB,1.0413E-03_JPRB,9.1137E-04_JPRB/)
KBO( :, 1,40, 4) = (/&
&9.0705E-05_JPRB,1.0852E-04_JPRB,5.0355E-04_JPRB,7.0681E-04_JPRB,8.3684E-04_JPRB,7.7091E-04_JPRB/)
KBO( :, 2,40, 4) = (/&
&9.8348E-05_JPRB,1.1706E-04_JPRB,5.1697E-04_JPRB,7.2009E-04_JPRB,8.4601E-04_JPRB,7.7004E-04_JPRB/)
KBO( :, 3,40, 4) = (/&
&1.0671E-04_JPRB,1.2689E-04_JPRB,5.3086E-04_JPRB,7.3191E-04_JPRB,8.5298E-04_JPRB,7.6666E-04_JPRB/)
KBO( :, 4,40, 4) = (/&
&1.1570E-04_JPRB,1.3781E-04_JPRB,5.4507E-04_JPRB,7.4355E-04_JPRB,8.5831E-04_JPRB,7.6093E-04_JPRB/)
KBO( :, 5,40, 4) = (/&
&1.2578E-04_JPRB,1.4990E-04_JPRB,5.6002E-04_JPRB,7.5473E-04_JPRB,8.6284E-04_JPRB,7.5245E-04_JPRB/)
KBO( :, 1,41, 4) = (/&
&7.3817E-05_JPRB,8.8549E-05_JPRB,4.1325E-04_JPRB,5.8106E-04_JPRB,6.8830E-04_JPRB,6.3269E-04_JPRB/)
KBO( :, 2,41, 4) = (/&
&8.0158E-05_JPRB,9.5680E-05_JPRB,4.2501E-04_JPRB,5.9293E-04_JPRB,6.9700E-04_JPRB,6.3310E-04_JPRB/)
KBO( :, 3,41, 4) = (/&
&8.7116E-05_JPRB,1.0384E-04_JPRB,4.3722E-04_JPRB,6.0369E-04_JPRB,7.0401E-04_JPRB,6.3122E-04_JPRB/)
KBO( :, 4,41, 4) = (/&
&9.4610E-05_JPRB,1.1303E-04_JPRB,4.4976E-04_JPRB,6.1448E-04_JPRB,7.0977E-04_JPRB,6.2726E-04_JPRB/)
KBO( :, 5,41, 4) = (/&
&1.0305E-04_JPRB,1.2324E-04_JPRB,4.6311E-04_JPRB,6.2475E-04_JPRB,7.1477E-04_JPRB,6.2101E-04_JPRB/)
KBO( :, 1,42, 4) = (/&
&6.0047E-05_JPRB,7.2210E-05_JPRB,3.3900E-04_JPRB,4.7749E-04_JPRB,5.6596E-04_JPRB,5.1926E-04_JPRB/)
KBO( :, 2,42, 4) = (/&
&6.5307E-05_JPRB,7.8183E-05_JPRB,3.4927E-04_JPRB,4.8800E-04_JPRB,5.7404E-04_JPRB,5.2049E-04_JPRB/)
KBO( :, 3,42, 4) = (/&
&7.1083E-05_JPRB,8.4948E-05_JPRB,3.5991E-04_JPRB,4.9776E-04_JPRB,5.8092E-04_JPRB,5.1968E-04_JPRB/)
KBO( :, 4,42, 4) = (/&
&7.7339E-05_JPRB,9.2668E-05_JPRB,3.7098E-04_JPRB,5.0759E-04_JPRB,5.8676E-04_JPRB,5.1717E-04_JPRB/)
KBO( :, 5,42, 4) = (/&
&8.4391E-05_JPRB,1.0128E-04_JPRB,3.8284E-04_JPRB,5.1710E-04_JPRB,5.9200E-04_JPRB,5.1265E-04_JPRB/)
KBO( :, 1,43, 4) = (/&
&4.8611E-05_JPRB,5.8601E-05_JPRB,2.7749E-04_JPRB,3.9145E-04_JPRB,4.6464E-04_JPRB,4.2584E-04_JPRB/)
KBO( :, 2,43, 4) = (/&
&5.2925E-05_JPRB,6.3562E-05_JPRB,2.8637E-04_JPRB,4.0094E-04_JPRB,4.7226E-04_JPRB,4.2773E-04_JPRB/)
KBO( :, 3,43, 4) = (/&
&5.7704E-05_JPRB,6.9143E-05_JPRB,2.9565E-04_JPRB,4.0976E-04_JPRB,4.7882E-04_JPRB,4.2784E-04_JPRB/)
KBO( :, 4,43, 4) = (/&
&6.2890E-05_JPRB,7.5555E-05_JPRB,3.0531E-04_JPRB,4.1861E-04_JPRB,4.8454E-04_JPRB,4.2632E-04_JPRB/)
KBO( :, 5,43, 4) = (/&
&6.8733E-05_JPRB,8.2754E-05_JPRB,3.1574E-04_JPRB,4.2729E-04_JPRB,4.8985E-04_JPRB,4.2324E-04_JPRB/)
KBO( :, 1,44, 4) = (/&
&3.9255E-05_JPRB,4.7428E-05_JPRB,2.2682E-04_JPRB,3.2053E-04_JPRB,3.8115E-04_JPRB,3.4904E-04_JPRB/)
KBO( :, 2,44, 4) = (/&
&4.2756E-05_JPRB,5.1518E-05_JPRB,2.3446E-04_JPRB,3.2900E-04_JPRB,3.8818E-04_JPRB,3.5126E-04_JPRB/)
KBO( :, 3,44, 4) = (/&
&4.6702E-05_JPRB,5.6118E-05_JPRB,2.4254E-04_JPRB,3.3696E-04_JPRB,3.9445E-04_JPRB,3.5204E-04_JPRB/)
KBO( :, 4,44, 4) = (/&
&5.0988E-05_JPRB,6.1414E-05_JPRB,2.5093E-04_JPRB,3.4483E-04_JPRB,3.9984E-04_JPRB,3.5150E-04_JPRB/)
KBO( :, 5,44, 4) = (/&
&5.5818E-05_JPRB,6.7413E-05_JPRB,2.6004E-04_JPRB,3.5271E-04_JPRB,4.0508E-04_JPRB,3.4955E-04_JPRB/)
KBO( :, 1,45, 4) = (/&
&3.1677E-05_JPRB,3.8360E-05_JPRB,1.8523E-04_JPRB,2.6222E-04_JPRB,3.1238E-04_JPRB,2.8592E-04_JPRB/)
KBO( :, 2,45, 4) = (/&
&3.4522E-05_JPRB,4.1731E-05_JPRB,1.9192E-04_JPRB,2.6971E-04_JPRB,3.1883E-04_JPRB,2.8860E-04_JPRB/)
KBO( :, 3,45, 4) = (/&
&3.7775E-05_JPRB,4.5523E-05_JPRB,1.9882E-04_JPRB,2.7680E-04_JPRB,3.2469E-04_JPRB,2.8979E-04_JPRB/)
KBO( :, 4,45, 4) = (/&
&4.1306E-05_JPRB,4.9872E-05_JPRB,2.0608E-04_JPRB,2.8384E-04_JPRB,3.2984E-04_JPRB,2.8984E-04_JPRB/)
KBO( :, 5,45, 4) = (/&
&4.5292E-05_JPRB,5.4864E-05_JPRB,2.1395E-04_JPRB,2.9088E-04_JPRB,3.3473E-04_JPRB,2.8876E-04_JPRB/)
KBO( :, 1,46, 4) = (/&
&2.5501E-05_JPRB,3.0949E-05_JPRB,1.5106E-04_JPRB,2.1422E-04_JPRB,2.5570E-04_JPRB,2.3396E-04_JPRB/)
KBO( :, 2,46, 4) = (/&
&2.7795E-05_JPRB,3.3698E-05_JPRB,1.5681E-04_JPRB,2.2083E-04_JPRB,2.6153E-04_JPRB,2.3683E-04_JPRB/)
KBO( :, 3,46, 4) = (/&
&3.0473E-05_JPRB,3.6830E-05_JPRB,1.6271E-04_JPRB,2.2704E-04_JPRB,2.6695E-04_JPRB,2.3842E-04_JPRB/)
KBO( :, 4,46, 4) = (/&
&3.3376E-05_JPRB,4.0385E-05_JPRB,1.6899E-04_JPRB,2.3332E-04_JPRB,2.7178E-04_JPRB,2.3894E-04_JPRB/)
KBO( :, 5,46, 4) = (/&
&3.6637E-05_JPRB,4.4507E-05_JPRB,1.7585E-04_JPRB,2.3962E-04_JPRB,2.7638E-04_JPRB,2.3855E-04_JPRB/)
KBO( :, 1,47, 4) = (/&
&2.0450E-05_JPRB,2.4871E-05_JPRB,1.2285E-04_JPRB,1.7458E-04_JPRB,2.0883E-04_JPRB,1.9097E-04_JPRB/)
KBO( :, 2,47, 4) = (/&
&2.2286E-05_JPRB,2.7086E-05_JPRB,1.2784E-04_JPRB,1.8042E-04_JPRB,2.1404E-04_JPRB,1.9395E-04_JPRB/)
KBO( :, 3,47, 4) = (/&
&2.4454E-05_JPRB,2.9649E-05_JPRB,1.3286E-04_JPRB,1.8591E-04_JPRB,2.1910E-04_JPRB,1.9581E-04_JPRB/)
KBO( :, 4,47, 4) = (/&
&2.6844E-05_JPRB,3.2545E-05_JPRB,1.3825E-04_JPRB,1.9143E-04_JPRB,2.2358E-04_JPRB,1.9673E-04_JPRB/)
KBO( :, 5,47, 4) = (/&
&2.9484E-05_JPRB,3.5918E-05_JPRB,1.4411E-04_JPRB,1.9700E-04_JPRB,2.2781E-04_JPRB,1.9684E-04_JPRB/)
KBO( :, 1,48, 4) = (/&
&1.6395E-05_JPRB,1.9987E-05_JPRB,9.9787E-05_JPRB,1.4214E-04_JPRB,1.7032E-04_JPRB,1.5582E-04_JPRB/)
KBO( :, 2,48, 4) = (/&
&1.7860E-05_JPRB,2.1753E-05_JPRB,1.0413E-04_JPRB,1.4725E-04_JPRB,1.7499E-04_JPRB,1.5884E-04_JPRB/)
KBO( :, 3,48, 4) = (/&
&1.9600E-05_JPRB,2.3834E-05_JPRB,1.0839E-04_JPRB,1.5207E-04_JPRB,1.7957E-04_JPRB,1.6083E-04_JPRB/)
KBO( :, 4,48, 4) = (/&
&2.1567E-05_JPRB,2.6208E-05_JPRB,1.1299E-04_JPRB,1.5690E-04_JPRB,1.8370E-04_JPRB,1.6199E-04_JPRB/)
KBO( :, 5,48, 4) = (/&
&2.3704E-05_JPRB,2.8946E-05_JPRB,1.1797E-04_JPRB,1.6178E-04_JPRB,1.8753E-04_JPRB,1.6246E-04_JPRB/)
KBO( :, 1,49, 4) = (/&
&1.3139E-05_JPRB,1.6062E-05_JPRB,8.0976E-05_JPRB,1.1562E-04_JPRB,1.3876E-04_JPRB,1.2714E-04_JPRB/)
KBO( :, 2,49, 4) = (/&
&1.4304E-05_JPRB,1.7455E-05_JPRB,8.4710E-05_JPRB,1.2004E-04_JPRB,1.4288E-04_JPRB,1.3003E-04_JPRB/)
KBO( :, 3,49, 4) = (/&
&1.5690E-05_JPRB,1.9136E-05_JPRB,8.8348E-05_JPRB,1.2427E-04_JPRB,1.4700E-04_JPRB,1.3213E-04_JPRB/)
KBO( :, 4,49, 4) = (/&
&1.7304E-05_JPRB,2.1080E-05_JPRB,9.2222E-05_JPRB,1.2844E-04_JPRB,1.5072E-04_JPRB,1.3349E-04_JPRB/)
KBO( :, 5,49, 4) = (/&
&1.9045E-05_JPRB,2.3296E-05_JPRB,9.6473E-05_JPRB,1.3272E-04_JPRB,1.5420E-04_JPRB,1.3424E-04_JPRB/)
KBO( :, 1,50, 4) = (/&
&1.0555E-05_JPRB,1.2937E-05_JPRB,6.5695E-05_JPRB,9.4043E-05_JPRB,1.1302E-04_JPRB,1.0345E-04_JPRB/)
KBO( :, 2,50, 4) = (/&
&1.1477E-05_JPRB,1.4031E-05_JPRB,6.8893E-05_JPRB,9.7810E-05_JPRB,1.1659E-04_JPRB,1.0618E-04_JPRB/)
KBO( :, 3,50, 4) = (/&
&1.2581E-05_JPRB,1.5385E-05_JPRB,7.2022E-05_JPRB,1.0152E-04_JPRB,1.2023E-04_JPRB,1.0825E-04_JPRB/)
KBO( :, 4,50, 4) = (/&
&1.3900E-05_JPRB,1.6979E-05_JPRB,7.5298E-05_JPRB,1.0513E-04_JPRB,1.2362E-04_JPRB,1.0965E-04_JPRB/)
KBO( :, 5,50, 4) = (/&
&1.5333E-05_JPRB,1.8783E-05_JPRB,7.8918E-05_JPRB,1.0888E-04_JPRB,1.2677E-04_JPRB,1.1057E-04_JPRB/)
KBO( :, 1,51, 4) = (/&
&8.4921E-06_JPRB,1.0428E-05_JPRB,5.3292E-05_JPRB,7.6448E-05_JPRB,9.1988E-05_JPRB,8.4025E-05_JPRB/)
KBO( :, 2,51, 4) = (/&
&9.2127E-06_JPRB,1.1285E-05_JPRB,5.6005E-05_JPRB,7.9650E-05_JPRB,9.5066E-05_JPRB,8.6539E-05_JPRB/)
KBO( :, 3,51, 4) = (/&
&1.0093E-05_JPRB,1.2374E-05_JPRB,5.8695E-05_JPRB,8.2891E-05_JPRB,9.8274E-05_JPRB,8.8509E-05_JPRB/)
KBO( :, 4,51, 4) = (/&
&1.1165E-05_JPRB,1.3675E-05_JPRB,6.1461E-05_JPRB,8.6028E-05_JPRB,1.0132E-04_JPRB,8.9926E-05_JPRB/)
KBO( :, 5,51, 4) = (/&
&1.2344E-05_JPRB,1.5149E-05_JPRB,6.4533E-05_JPRB,8.9294E-05_JPRB,1.0416E-04_JPRB,9.0887E-05_JPRB/)
KBO( :, 1,52, 4) = (/&
&6.8430E-06_JPRB,8.4090E-06_JPRB,4.3193E-05_JPRB,6.2073E-05_JPRB,7.4815E-05_JPRB,6.8216E-05_JPRB/)
KBO( :, 2,52, 4) = (/&
&7.3942E-06_JPRB,9.0790E-06_JPRB,4.5492E-05_JPRB,6.4818E-05_JPRB,7.7473E-05_JPRB,7.0540E-05_JPRB/)
KBO( :, 3,52, 4) = (/&
&8.0962E-06_JPRB,9.9455E-06_JPRB,4.7801E-05_JPRB,6.7638E-05_JPRB,8.0241E-05_JPRB,7.2366E-05_JPRB/)
KBO( :, 4,52, 4) = (/&
&8.9532E-06_JPRB,1.0996E-05_JPRB,5.0136E-05_JPRB,7.0352E-05_JPRB,8.2988E-05_JPRB,7.3738E-05_JPRB/)
KBO( :, 5,52, 4) = (/&
&9.9254E-06_JPRB,1.2206E-05_JPRB,5.2722E-05_JPRB,7.3154E-05_JPRB,8.5502E-05_JPRB,7.4723E-05_JPRB/)
KBO( :, 1,53, 4) = (/&
&5.5275E-06_JPRB,6.7826E-06_JPRB,3.4992E-05_JPRB,5.0387E-05_JPRB,6.0795E-05_JPRB,5.5379E-05_JPRB/)
KBO( :, 2,53, 4) = (/&
&5.9360E-06_JPRB,7.3070E-06_JPRB,3.6904E-05_JPRB,5.2681E-05_JPRB,6.3070E-05_JPRB,5.7475E-05_JPRB/)
KBO( :, 3,53, 4) = (/&
&6.4916E-06_JPRB,7.9876E-06_JPRB,3.8885E-05_JPRB,5.5123E-05_JPRB,6.5445E-05_JPRB,5.9194E-05_JPRB/)
KBO( :, 4,53, 4) = (/&
&7.1721E-06_JPRB,8.8314E-06_JPRB,4.0856E-05_JPRB,5.7465E-05_JPRB,6.7875E-05_JPRB,6.0530E-05_JPRB/)
KBO( :, 5,53, 4) = (/&
&7.9695E-06_JPRB,9.8225E-06_JPRB,4.3031E-05_JPRB,5.9870E-05_JPRB,7.0118E-05_JPRB,6.1520E-05_JPRB/)
KBO( :, 1,54, 4) = (/&
&4.4841E-06_JPRB,5.4855E-06_JPRB,2.8370E-05_JPRB,4.0916E-05_JPRB,4.9401E-05_JPRB,4.4764E-05_JPRB/)
KBO( :, 2,54, 4) = (/&
&4.7805E-06_JPRB,5.8965E-06_JPRB,2.9962E-05_JPRB,4.2832E-05_JPRB,5.1350E-05_JPRB,4.6575E-05_JPRB/)
KBO( :, 3,54, 4) = (/&
&5.2175E-06_JPRB,6.4303E-06_JPRB,3.1646E-05_JPRB,4.4921E-05_JPRB,5.3377E-05_JPRB,4.8101E-05_JPRB/)
KBO( :, 4,54, 4) = (/&
&5.7596E-06_JPRB,7.1078E-06_JPRB,3.3313E-05_JPRB,4.6951E-05_JPRB,5.5518E-05_JPRB,4.9299E-05_JPRB/)
KBO( :, 5,54, 4) = (/&
&6.4121E-06_JPRB,7.9214E-06_JPRB,3.5145E-05_JPRB,4.9005E-05_JPRB,5.7497E-05_JPRB,5.0216E-05_JPRB/)
KBO( :, 1,55, 4) = (/&
&3.6502E-06_JPRB,4.4452E-06_JPRB,2.3004E-05_JPRB,3.3225E-05_JPRB,4.0131E-05_JPRB,3.6076E-05_JPRB/)
KBO( :, 2,55, 4) = (/&
&3.8584E-06_JPRB,4.7638E-06_JPRB,2.4322E-05_JPRB,3.4820E-05_JPRB,4.1798E-05_JPRB,3.7608E-05_JPRB/)
KBO( :, 3,55, 4) = (/&
&4.1970E-06_JPRB,5.1824E-06_JPRB,2.5746E-05_JPRB,3.6594E-05_JPRB,4.3525E-05_JPRB,3.8921E-05_JPRB/)
KBO( :, 4,55, 4) = (/&
&4.6296E-06_JPRB,5.7238E-06_JPRB,2.7170E-05_JPRB,3.8354E-05_JPRB,4.5386E-05_JPRB,3.9954E-05_JPRB/)
KBO( :, 5,55, 4) = (/&
&5.1596E-06_JPRB,6.3897E-06_JPRB,2.8703E-05_JPRB,4.0103E-05_JPRB,4.7130E-05_JPRB,4.0748E-05_JPRB/)
KBO( :, 1,56, 4) = (/&
&2.9798E-06_JPRB,3.6097E-06_JPRB,1.8645E-05_JPRB,2.6958E-05_JPRB,3.2565E-05_JPRB,2.9049E-05_JPRB/)
KBO( :, 2,56, 4) = (/&
&3.1203E-06_JPRB,3.8503E-06_JPRB,1.9728E-05_JPRB,2.8285E-05_JPRB,3.3997E-05_JPRB,3.0362E-05_JPRB/)
KBO( :, 3,56, 4) = (/&
&3.3770E-06_JPRB,4.1764E-06_JPRB,2.0929E-05_JPRB,2.9782E-05_JPRB,3.5468E-05_JPRB,3.1480E-05_JPRB/)
KBO( :, 4,56, 4) = (/&
&3.7197E-06_JPRB,4.6073E-06_JPRB,2.2137E-05_JPRB,3.1299E-05_JPRB,3.7064E-05_JPRB,3.2373E-05_JPRB/)
KBO( :, 5,56, 4) = (/&
&4.1476E-06_JPRB,5.1481E-06_JPRB,2.3420E-05_JPRB,3.2792E-05_JPRB,3.8590E-05_JPRB,3.3070E-05_JPRB/)
KBO( :, 1,57, 4) = (/&
&2.4380E-06_JPRB,2.9371E-06_JPRB,1.5101E-05_JPRB,2.1849E-05_JPRB,2.6384E-05_JPRB,2.3378E-05_JPRB/)
KBO( :, 2,57, 4) = (/&
&2.5283E-06_JPRB,3.1131E-06_JPRB,1.5990E-05_JPRB,2.2961E-05_JPRB,2.7628E-05_JPRB,2.4501E-05_JPRB/)
KBO( :, 3,57, 4) = (/&
&2.7173E-06_JPRB,3.3659E-06_JPRB,1.6995E-05_JPRB,2.4208E-05_JPRB,2.8876E-05_JPRB,2.5443E-05_JPRB/)
KBO( :, 4,57, 4) = (/&
&2.9882E-06_JPRB,3.7073E-06_JPRB,1.8018E-05_JPRB,2.5516E-05_JPRB,3.0235E-05_JPRB,2.6220E-05_JPRB/)
KBO( :, 5,57, 4) = (/&
&3.3309E-06_JPRB,4.1429E-06_JPRB,1.9094E-05_JPRB,2.6794E-05_JPRB,3.1575E-05_JPRB,2.6825E-05_JPRB/)
KBO( :, 1,58, 4) = (/&
&1.9991E-06_JPRB,2.3969E-06_JPRB,1.2235E-05_JPRB,1.7713E-05_JPRB,2.1380E-05_JPRB,1.8819E-05_JPRB/)
KBO( :, 2,58, 4) = (/&
&2.0552E-06_JPRB,2.5217E-06_JPRB,1.2969E-05_JPRB,1.8641E-05_JPRB,2.2450E-05_JPRB,1.9754E-05_JPRB/)
KBO( :, 3,58, 4) = (/&
&2.1912E-06_JPRB,2.7184E-06_JPRB,1.3803E-05_JPRB,1.9678E-05_JPRB,2.3501E-05_JPRB,2.0555E-05_JPRB/)
KBO( :, 4,58, 4) = (/&
&2.4045E-06_JPRB,2.9869E-06_JPRB,1.4668E-05_JPRB,2.0799E-05_JPRB,2.4657E-05_JPRB,2.1216E-05_JPRB/)
KBO( :, 5,58, 4) = (/&
&2.6779E-06_JPRB,3.3369E-06_JPRB,1.5570E-05_JPRB,2.1893E-05_JPRB,2.5824E-05_JPRB,2.1730E-05_JPRB/)
KBO( :, 1,59, 4) = (/&
&1.6438E-06_JPRB,1.9701E-06_JPRB,1.0010E-05_JPRB,1.4487E-05_JPRB,1.7470E-05_JPRB,1.5234E-05_JPRB/)
KBO( :, 2,59, 4) = (/&
&1.6869E-06_JPRB,2.0683E-06_JPRB,1.0627E-05_JPRB,1.5272E-05_JPRB,1.8381E-05_JPRB,1.5979E-05_JPRB/)
KBO( :, 3,59, 4) = (/&
&1.7947E-06_JPRB,2.2294E-06_JPRB,1.1332E-05_JPRB,1.6155E-05_JPRB,1.9286E-05_JPRB,1.6622E-05_JPRB/)
KBO( :, 4,59, 4) = (/&
&1.9699E-06_JPRB,2.4516E-06_JPRB,1.2063E-05_JPRB,1.7108E-05_JPRB,2.0268E-05_JPRB,1.7134E-05_JPRB/)
KBO( :, 5,59, 4) = (/&
&2.1967E-06_JPRB,2.7433E-06_JPRB,1.2831E-05_JPRB,1.8043E-05_JPRB,2.1274E-05_JPRB,1.7524E-05_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB4_B1
