!OCL SCALAR
SUBROUTINE RRTM_KGB4_A1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 4:  630-700 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO4 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,FRACREFBO
USE YOERRTA4 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 9 and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 9 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15,
!     JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 9) = (/&
&6.4733E-02_JPRB,6.0521E-02_JPRB,5.8252E-02_JPRB,5.6866E-02_JPRB,5.6526E-02_JPRB,5.5742E-02_JPRB,&
&5.2046E-02_JPRB,6.4733E-02_JPRB,5.6233E-02_JPRB/)
KAO( :, 2, 1, 9) = (/&
&6.5477E-02_JPRB,6.3047E-02_JPRB,6.3106E-02_JPRB,6.4612E-02_JPRB,6.6790E-02_JPRB,6.7507E-02_JPRB,&
&6.4723E-02_JPRB,6.5477E-02_JPRB,7.2720E-02_JPRB/)
KAO( :, 3, 1, 9) = (/&
&6.6216E-02_JPRB,6.6108E-02_JPRB,6.9181E-02_JPRB,7.4268E-02_JPRB,7.9047E-02_JPRB,8.0497E-02_JPRB,&
&7.8280E-02_JPRB,6.6216E-02_JPRB,9.1648E-02_JPRB/)
KAO( :, 4, 1, 9) = (/&
&6.6791E-02_JPRB,6.9579E-02_JPRB,7.6737E-02_JPRB,8.5244E-02_JPRB,9.1845E-02_JPRB,9.4527E-02_JPRB,&
&9.2441E-02_JPRB,6.6791E-02_JPRB,1.1307E-01_JPRB/)
KAO( :, 5, 1, 9) = (/&
&6.7298E-02_JPRB,7.3839E-02_JPRB,8.5356E-02_JPRB,9.7147E-02_JPRB,1.0554E-01_JPRB,1.0978E-01_JPRB,&
&1.0752E-01_JPRB,6.7298E-02_JPRB,1.3678E-01_JPRB/)
KAO( :, 1, 2, 9) = (/&
&7.0877E-02_JPRB,6.5253E-02_JPRB,6.1232E-02_JPRB,5.7942E-02_JPRB,5.5662E-02_JPRB,5.3703E-02_JPRB,&
&5.0251E-02_JPRB,7.0877E-02_JPRB,4.8550E-02_JPRB/)
KAO( :, 2, 2, 9) = (/&
&7.1555E-02_JPRB,6.7492E-02_JPRB,6.5473E-02_JPRB,6.4551E-02_JPRB,6.5054E-02_JPRB,6.5264E-02_JPRB,&
&6.3231E-02_JPRB,7.1555E-02_JPRB,6.3334E-02_JPRB/)
KAO( :, 3, 2, 9) = (/&
&7.2159E-02_JPRB,7.0218E-02_JPRB,7.0742E-02_JPRB,7.3278E-02_JPRB,7.6459E-02_JPRB,7.8274E-02_JPRB,&
&7.6836E-02_JPRB,7.2159E-02_JPRB,8.0528E-02_JPRB/)
KAO( :, 4, 2, 9) = (/&
&7.2672E-02_JPRB,7.3326E-02_JPRB,7.7456E-02_JPRB,8.3314E-02_JPRB,8.9061E-02_JPRB,9.2382E-02_JPRB,&
&9.1438E-02_JPRB,7.2672E-02_JPRB,1.0017E-01_JPRB/)
KAO( :, 5, 2, 9) = (/&
&7.3068E-02_JPRB,7.7090E-02_JPRB,8.5132E-02_JPRB,9.4518E-02_JPRB,1.0309E-01_JPRB,1.0796E-01_JPRB,&
&1.0651E-01_JPRB,7.3067E-02_JPRB,1.2229E-01_JPRB/)
KAO( :, 1, 3, 9) = (/&
&7.7836E-02_JPRB,7.0551E-02_JPRB,6.4559E-02_JPRB,5.9167E-02_JPRB,5.4414E-02_JPRB,5.0314E-02_JPRB,&
&4.5794E-02_JPRB,7.7836E-02_JPRB,3.8882E-02_JPRB/)
KAO( :, 2, 3, 9) = (/&
&7.8435E-02_JPRB,7.2532E-02_JPRB,6.8092E-02_JPRB,6.4613E-02_JPRB,6.2358E-02_JPRB,6.0608E-02_JPRB,&
&5.8276E-02_JPRB,7.8435E-02_JPRB,5.1370E-02_JPRB/)
KAO( :, 3, 3, 9) = (/&
&7.8932E-02_JPRB,7.4825E-02_JPRB,7.2527E-02_JPRB,7.1989E-02_JPRB,7.2471E-02_JPRB,7.2873E-02_JPRB,&
&7.1766E-02_JPRB,7.8932E-02_JPRB,6.6086E-02_JPRB/)
KAO( :, 4, 3, 9) = (/&
&7.9379E-02_JPRB,7.7501E-02_JPRB,7.8388E-02_JPRB,8.0847E-02_JPRB,8.4097E-02_JPRB,8.6801E-02_JPRB,&
&8.6568E-02_JPRB,7.9379E-02_JPRB,8.3141E-02_JPRB/)
KAO( :, 5, 3, 9) = (/&
&7.9699E-02_JPRB,8.0691E-02_JPRB,8.5121E-02_JPRB,9.1008E-02_JPRB,9.7441E-02_JPRB,1.0226E-01_JPRB,&
&1.0163E-01_JPRB,7.9699E-02_JPRB,1.0254E-01_JPRB/)
KAO( :, 1, 4, 9) = (/&
&8.4906E-02_JPRB,7.6241E-02_JPRB,6.8684E-02_JPRB,6.1260E-02_JPRB,5.4322E-02_JPRB,4.8027E-02_JPRB,&
&4.1411E-02_JPRB,8.4906E-02_JPRB,3.0325E-02_JPRB/)
KAO( :, 2, 4, 9) = (/&
&8.5698E-02_JPRB,7.8243E-02_JPRB,7.1748E-02_JPRB,6.5778E-02_JPRB,6.0935E-02_JPRB,5.6719E-02_JPRB,&
&5.2610E-02_JPRB,8.5698E-02_JPRB,4.0549E-02_JPRB/)
KAO( :, 3, 4, 9) = (/&
&8.6275E-02_JPRB,8.0324E-02_JPRB,7.5429E-02_JPRB,7.2009E-02_JPRB,6.9531E-02_JPRB,6.7539E-02_JPRB,&
&6.5470E-02_JPRB,8.6275E-02_JPRB,5.2700E-02_JPRB/)
KAO( :, 4, 4, 9) = (/&
&8.6713E-02_JPRB,8.2575E-02_JPRB,8.0462E-02_JPRB,7.9748E-02_JPRB,7.9735E-02_JPRB,8.0326E-02_JPRB,&
&7.9974E-02_JPRB,8.6713E-02_JPRB,6.7029E-02_JPRB/)
KAO( :, 5, 4, 9) = (/&
&8.7027E-02_JPRB,8.5276E-02_JPRB,8.6509E-02_JPRB,8.8819E-02_JPRB,9.1761E-02_JPRB,9.4798E-02_JPRB,&
&9.4801E-02_JPRB,8.7027E-02_JPRB,8.3508E-02_JPRB/)
KAO( :, 1, 5, 9) = (/&
&9.1507E-02_JPRB,8.1620E-02_JPRB,7.2828E-02_JPRB,6.4142E-02_JPRB,5.5568E-02_JPRB,4.7251E-02_JPRB,&
&3.8880E-02_JPRB,9.1507E-02_JPRB,2.3229E-02_JPRB/)
KAO( :, 2, 5, 9) = (/&
&9.2405E-02_JPRB,8.3679E-02_JPRB,7.5863E-02_JPRB,6.8216E-02_JPRB,6.1046E-02_JPRB,5.4513E-02_JPRB,&
&4.8261E-02_JPRB,9.2405E-02_JPRB,3.1508E-02_JPRB/)
KAO( :, 3, 5, 9) = (/&
&9.3115E-02_JPRB,8.5700E-02_JPRB,7.9335E-02_JPRB,7.3579E-02_JPRB,6.8420E-02_JPRB,6.3872E-02_JPRB,&
&5.9567E-02_JPRB,9.3115E-02_JPRB,4.1511E-02_JPRB/)
KAO( :, 4, 5, 9) = (/&
&9.3636E-02_JPRB,8.7963E-02_JPRB,8.3776E-02_JPRB,8.0336E-02_JPRB,7.7284E-02_JPRB,7.5046E-02_JPRB,&
&7.2882E-02_JPRB,9.3636E-02_JPRB,5.3333E-02_JPRB/)
KAO( :, 5, 5, 9) = (/&
&9.4011E-02_JPRB,9.0504E-02_JPRB,8.9128E-02_JPRB,8.8247E-02_JPRB,8.7824E-02_JPRB,8.7979E-02_JPRB,&
&8.7078E-02_JPRB,9.4011E-02_JPRB,6.7155E-02_JPRB/)
KAO( :, 1, 6, 9) = (/&
&9.7472E-02_JPRB,8.6538E-02_JPRB,7.6624E-02_JPRB,6.6824E-02_JPRB,5.7059E-02_JPRB,4.7268E-02_JPRB,&
&3.7138E-02_JPRB,9.7472E-02_JPRB,1.7221E-02_JPRB/)
KAO( :, 2, 6, 9) = (/&
&9.8451E-02_JPRB,8.8518E-02_JPRB,7.9536E-02_JPRB,7.0737E-02_JPRB,6.1956E-02_JPRB,5.3328E-02_JPRB,&
&4.4923E-02_JPRB,9.8451E-02_JPRB,2.3780E-02_JPRB/)
KAO( :, 3, 6, 9) = (/&
&9.9270E-02_JPRB,9.0592E-02_JPRB,8.2992E-02_JPRB,7.5645E-02_JPRB,6.8338E-02_JPRB,6.1246E-02_JPRB,&
&5.4647E-02_JPRB,9.9270E-02_JPRB,3.1821E-02_JPRB/)
KAO( :, 4, 6, 9) = (/&
&9.9874E-02_JPRB,9.2825E-02_JPRB,8.7145E-02_JPRB,8.1713E-02_JPRB,7.6024E-02_JPRB,7.0895E-02_JPRB,&
&6.6256E-02_JPRB,9.9874E-02_JPRB,4.1514E-02_JPRB/)
KAO( :, 5, 6, 9) = (/&
&1.0031E-01_JPRB,9.5362E-02_JPRB,9.2196E-02_JPRB,8.8672E-02_JPRB,8.5237E-02_JPRB,8.2164E-02_JPRB,&
&7.9017E-02_JPRB,1.0031E-01_JPRB,5.2892E-02_JPRB/)
KAO( :, 1, 7, 9) = (/&
&1.0232E-01_JPRB,9.0553E-02_JPRB,7.9624E-02_JPRB,6.8906E-02_JPRB,5.8070E-02_JPRB,4.7256E-02_JPRB,&
&3.6147E-02_JPRB,1.0232E-01_JPRB,1.2551E-02_JPRB/)
KAO( :, 2, 7, 9) = (/&
&1.0337E-01_JPRB,9.2407E-02_JPRB,8.2434E-02_JPRB,7.2548E-02_JPRB,6.2643E-02_JPRB,5.2753E-02_JPRB,&
&4.2581E-02_JPRB,1.0337E-01_JPRB,1.7575E-02_JPRB/)
KAO( :, 3, 7, 9) = (/&
&1.0428E-01_JPRB,9.4463E-02_JPRB,8.5756E-02_JPRB,7.7103E-02_JPRB,6.8472E-02_JPRB,5.9711E-02_JPRB,&
&5.0861E-02_JPRB,1.0428E-01_JPRB,2.3865E-02_JPRB/)
KAO( :, 4, 7, 9) = (/&
&1.0499E-01_JPRB,9.6649E-02_JPRB,8.9715E-02_JPRB,8.2804E-02_JPRB,7.5682E-02_JPRB,6.8094E-02_JPRB,&
&6.0862E-02_JPRB,1.0499E-01_JPRB,3.1546E-02_JPRB/)
KAO( :, 5, 7, 9) = (/&
&1.0547E-01_JPRB,9.9180E-02_JPRB,9.4519E-02_JPRB,8.9479E-02_JPRB,8.3717E-02_JPRB,7.7813E-02_JPRB,&
&7.1993E-02_JPRB,1.0547E-01_JPRB,4.0721E-02_JPRB/)
KAO( :, 1, 8, 9) = (/&
&1.0518E-01_JPRB,9.2886E-02_JPRB,8.1191E-02_JPRB,6.9957E-02_JPRB,5.8508E-02_JPRB,4.6965E-02_JPRB,&
&3.4947E-02_JPRB,1.0518E-01_JPRB,9.1670E-03_JPRB/)
KAO( :, 2, 8, 9) = (/&
&1.0636E-01_JPRB,9.4674E-02_JPRB,8.4036E-02_JPRB,7.3413E-02_JPRB,6.2776E-02_JPRB,5.2007E-02_JPRB,&
&4.0951E-02_JPRB,1.0636E-01_JPRB,1.2998E-02_JPRB/)
KAO( :, 3, 8, 9) = (/&
&1.0733E-01_JPRB,9.6738E-02_JPRB,8.7252E-02_JPRB,7.7783E-02_JPRB,6.8203E-02_JPRB,5.8372E-02_JPRB,&
&4.8034E-02_JPRB,1.0733E-01_JPRB,1.7878E-02_JPRB/)
KAO( :, 4, 8, 9) = (/&
&1.0812E-01_JPRB,9.8911E-02_JPRB,9.1152E-02_JPRB,8.3173E-02_JPRB,7.4963E-02_JPRB,6.6116E-02_JPRB,&
&5.6655E-02_JPRB,1.0812E-01_JPRB,2.3868E-02_JPRB/)
KAO( :, 5, 8, 9) = (/&
&1.0863E-01_JPRB,1.0151E-01_JPRB,9.5717E-02_JPRB,8.9578E-02_JPRB,8.2572E-02_JPRB,7.4669E-02_JPRB,&
&6.6397E-02_JPRB,1.0863E-01_JPRB,3.1082E-02_JPRB/)
KAO( :, 1, 9, 9) = (/&
&1.0589E-01_JPRB,9.3378E-02_JPRB,8.1320E-02_JPRB,6.9699E-02_JPRB,5.7939E-02_JPRB,4.5963E-02_JPRB,&
&3.3510E-02_JPRB,1.0589E-01_JPRB,1.5005E-02_JPRB/)
KAO( :, 2, 9, 9) = (/&
&1.0710E-01_JPRB,9.5046E-02_JPRB,8.3992E-02_JPRB,7.2968E-02_JPRB,6.1840E-02_JPRB,5.0670E-02_JPRB,&
&3.9172E-02_JPRB,1.0710E-01_JPRB,1.6687E-02_JPRB/)
KAO( :, 3, 9, 9) = (/&
&1.0811E-01_JPRB,9.7025E-02_JPRB,8.7062E-02_JPRB,7.7135E-02_JPRB,6.7008E-02_JPRB,5.6693E-02_JPRB,&
&4.5539E-02_JPRB,1.0811E-01_JPRB,1.9062E-02_JPRB/)
KAO( :, 4, 9, 9) = (/&
&1.0893E-01_JPRB,9.9210E-02_JPRB,9.0893E-02_JPRB,8.2268E-02_JPRB,7.3432E-02_JPRB,6.3872E-02_JPRB,&
&5.3354E-02_JPRB,1.0893E-01_JPRB,2.2517E-02_JPRB/)
KAO( :, 5, 9, 9) = (/&
&1.0951E-01_JPRB,1.0180E-01_JPRB,9.5328E-02_JPRB,8.8533E-02_JPRB,8.0777E-02_JPRB,7.1933E-02_JPRB,&
&6.1860E-02_JPRB,1.0951E-01_JPRB,2.7194E-02_JPRB/)
KAO( :, 1,10, 9) = (/&
&1.0463E-01_JPRB,9.2191E-02_JPRB,8.0132E-02_JPRB,6.8413E-02_JPRB,5.6641E-02_JPRB,4.4619E-02_JPRB,&
&3.2080E-02_JPRB,1.0463E-01_JPRB,8.3991E-02_JPRB/)
KAO( :, 2,10, 9) = (/&
&1.0582E-01_JPRB,9.3770E-02_JPRB,8.2627E-02_JPRB,7.1539E-02_JPRB,6.0265E-02_JPRB,4.8989E-02_JPRB,&
&3.7366E-02_JPRB,1.0582E-01_JPRB,8.5008E-02_JPRB/)
KAO( :, 3,10, 9) = (/&
&1.0683E-01_JPRB,9.5651E-02_JPRB,8.5587E-02_JPRB,7.5429E-02_JPRB,6.5154E-02_JPRB,5.4715E-02_JPRB,&
&4.3408E-02_JPRB,1.0683E-01_JPRB,8.6636E-02_JPRB/)
KAO( :, 4,10, 9) = (/&
&1.0759E-01_JPRB,9.7764E-02_JPRB,8.9220E-02_JPRB,8.0336E-02_JPRB,7.1349E-02_JPRB,6.1576E-02_JPRB,&
&5.0720E-02_JPRB,1.0759E-01_JPRB,8.8133E-02_JPRB/)
KAO( :, 5,10, 9) = (/&
&1.0814E-01_JPRB,1.0027E-01_JPRB,9.3476E-02_JPRB,8.6461E-02_JPRB,7.8470E-02_JPRB,6.9232E-02_JPRB,&
&5.8604E-02_JPRB,1.0814E-01_JPRB,8.9595E-02_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.0192E-01_JPRB,8.9934E-02_JPRB,7.8442E-02_JPRB,6.7206E-02_JPRB,5.5807E-02_JPRB,4.4274E-02_JPRB,&
&3.2485E-02_JPRB,1.0192E-01_JPRB,2.1346E-01_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.0294E-01_JPRB,9.1474E-02_JPRB,8.1001E-02_JPRB,7.0324E-02_JPRB,5.9618E-02_JPRB,4.8890E-02_JPRB,&
&3.7724E-02_JPRB,1.0294E-01_JPRB,2.1319E-01_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.0376E-01_JPRB,9.3370E-02_JPRB,8.3962E-02_JPRB,7.4435E-02_JPRB,6.4795E-02_JPRB,5.4795E-02_JPRB,&
&4.3827E-02_JPRB,1.0376E-01_JPRB,2.1289E-01_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.0437E-01_JPRB,9.5489E-02_JPRB,8.7682E-02_JPRB,7.9614E-02_JPRB,7.1102E-02_JPRB,6.1619E-02_JPRB,&
&5.1046E-02_JPRB,1.0437E-01_JPRB,2.1287E-01_JPRB/)
KAO( :, 5,11, 9) = (/&
&1.0475E-01_JPRB,9.8083E-02_JPRB,9.2124E-02_JPRB,8.5743E-02_JPRB,7.7946E-02_JPRB,6.9048E-02_JPRB,&
&5.8627E-02_JPRB,1.0475E-01_JPRB,2.1310E-01_JPRB/)
KAO( :, 1,12, 9) = (/&
&9.7261E-02_JPRB,8.5991E-02_JPRB,7.5324E-02_JPRB,6.4737E-02_JPRB,5.3989E-02_JPRB,4.3184E-02_JPRB,&
&3.2169E-02_JPRB,9.7261E-02_JPRB,3.5384E-01_JPRB/)
KAO( :, 2,12, 9) = (/&
&9.8101E-02_JPRB,8.7528E-02_JPRB,7.7838E-02_JPRB,6.7921E-02_JPRB,5.8031E-02_JPRB,4.8011E-02_JPRB,&
&3.7356E-02_JPRB,9.8101E-02_JPRB,3.5110E-01_JPRB/)
KAO( :, 3,12, 9) = (/&
&9.8721E-02_JPRB,8.9358E-02_JPRB,8.0844E-02_JPRB,7.2156E-02_JPRB,6.3303E-02_JPRB,5.3812E-02_JPRB,&
&4.3478E-02_JPRB,9.8721E-02_JPRB,3.4905E-01_JPRB/)
KAO( :, 4,12, 9) = (/&
&9.9073E-02_JPRB,9.1448E-02_JPRB,8.4556E-02_JPRB,7.7373E-02_JPRB,6.9369E-02_JPRB,6.0482E-02_JPRB,&
&5.0434E-02_JPRB,9.9073E-02_JPRB,3.4710E-01_JPRB/)
KAO( :, 5,12, 9) = (/&
&9.9229E-02_JPRB,9.3917E-02_JPRB,8.9028E-02_JPRB,8.3070E-02_JPRB,7.5795E-02_JPRB,6.7464E-02_JPRB,&
&5.7745E-02_JPRB,9.9229E-02_JPRB,3.4526E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&9.0938E-02_JPRB,8.0633E-02_JPRB,7.0954E-02_JPRB,6.1198E-02_JPRB,5.1349E-02_JPRB,4.1513E-02_JPRB,&
&3.1321E-02_JPRB,9.0938E-02_JPRB,4.7630E-01_JPRB/)
KAO( :, 2,13, 9) = (/&
&9.1524E-02_JPRB,8.2076E-02_JPRB,7.3333E-02_JPRB,6.4427E-02_JPRB,5.5526E-02_JPRB,4.6304E-02_JPRB,&
&3.6408E-02_JPRB,9.1524E-02_JPRB,4.7149E-01_JPRB/)
KAO( :, 3,13, 9) = (/&
&9.1870E-02_JPRB,8.3785E-02_JPRB,7.6354E-02_JPRB,6.8726E-02_JPRB,6.0650E-02_JPRB,5.1878E-02_JPRB,&
&4.2350E-02_JPRB,9.1870E-02_JPRB,4.6781E-01_JPRB/)
KAO( :, 4,13, 9) = (/&
&9.2057E-02_JPRB,8.5864E-02_JPRB,8.0053E-02_JPRB,7.3650E-02_JPRB,6.6361E-02_JPRB,5.8175E-02_JPRB,&
&4.8890E-02_JPRB,9.2057E-02_JPRB,4.6471E-01_JPRB/)
KAO( :, 5,13, 9) = (/&
&9.2051E-02_JPRB,8.8153E-02_JPRB,8.4238E-02_JPRB,7.8829E-02_JPRB,7.2224E-02_JPRB,6.4662E-02_JPRB,&
&5.5790E-02_JPRB,9.2051E-02_JPRB,4.6177E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&1.8970E-01_JPRB,1.6722E-01_JPRB,1.5940E-01_JPRB,1.4654E-01_JPRB,1.3412E-01_JPRB,1.1990E-01_JPRB,&
&1.0153E-01_JPRB,1.8970E-01_JPRB,1.2683E-01_JPRB/)
KAO( :, 2, 1,10) = (/&
&1.9310E-01_JPRB,1.7584E-01_JPRB,1.7032E-01_JPRB,1.6287E-01_JPRB,1.5198E-01_JPRB,1.3637E-01_JPRB,&
&1.1338E-01_JPRB,1.9310E-01_JPRB,1.6492E-01_JPRB/)
KAO( :, 3, 1,10) = (/&
&1.9644E-01_JPRB,1.8616E-01_JPRB,1.8463E-01_JPRB,1.7853E-01_JPRB,1.6686E-01_JPRB,1.5307E-01_JPRB,&
&1.3006E-01_JPRB,1.9644E-01_JPRB,2.0951E-01_JPRB/)
KAO( :, 4, 1,10) = (/&
&1.9909E-01_JPRB,1.9510E-01_JPRB,1.9794E-01_JPRB,1.9455E-01_JPRB,1.8814E-01_JPRB,1.6970E-01_JPRB,&
&1.4049E-01_JPRB,1.9909E-01_JPRB,2.6023E-01_JPRB/)
KAO( :, 5, 1,10) = (/&
&2.0141E-01_JPRB,2.0423E-01_JPRB,2.1198E-01_JPRB,2.1359E-01_JPRB,2.0320E-01_JPRB,1.7839E-01_JPRB,&
&1.6166E-01_JPRB,2.0141E-01_JPRB,3.1814E-01_JPRB/)
KAO( :, 1, 2,10) = (/&
&1.8513E-01_JPRB,1.6417E-01_JPRB,1.5570E-01_JPRB,1.4299E-01_JPRB,1.3028E-01_JPRB,1.1558E-01_JPRB,&
&9.7575E-02_JPRB,1.8513E-01_JPRB,1.2033E-01_JPRB/)
KAO( :, 2, 2,10) = (/&
&1.8950E-01_JPRB,1.7381E-01_JPRB,1.6710E-01_JPRB,1.5962E-01_JPRB,1.4697E-01_JPRB,1.3061E-01_JPRB,&
&1.0961E-01_JPRB,1.8950E-01_JPRB,1.5920E-01_JPRB/)
KAO( :, 3, 2,10) = (/&
&1.9362E-01_JPRB,1.8395E-01_JPRB,1.8195E-01_JPRB,1.7419E-01_JPRB,1.6167E-01_JPRB,1.4828E-01_JPRB,&
&1.2568E-01_JPRB,1.9362E-01_JPRB,2.0282E-01_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.9721E-01_JPRB,1.9348E-01_JPRB,1.9530E-01_JPRB,1.9112E-01_JPRB,1.8284E-01_JPRB,1.6500E-01_JPRB,&
&1.3708E-01_JPRB,1.9721E-01_JPRB,2.5204E-01_JPRB/)
KAO( :, 5, 2,10) = (/&
&2.0023E-01_JPRB,2.0320E-01_JPRB,2.1020E-01_JPRB,2.0819E-01_JPRB,1.9741E-01_JPRB,1.7466E-01_JPRB,&
&1.5343E-01_JPRB,2.0023E-01_JPRB,3.0808E-01_JPRB/)
KAO( :, 1, 3,10) = (/&
&1.8001E-01_JPRB,1.5918E-01_JPRB,1.4957E-01_JPRB,1.3634E-01_JPRB,1.2400E-01_JPRB,1.1052E-01_JPRB,&
&9.3510E-02_JPRB,1.8001E-01_JPRB,1.0219E-01_JPRB/)
KAO( :, 2, 3,10) = (/&
&1.8528E-01_JPRB,1.6901E-01_JPRB,1.6096E-01_JPRB,1.5327E-01_JPRB,1.4061E-01_JPRB,1.2481E-01_JPRB,&
&1.0682E-01_JPRB,1.8528E-01_JPRB,1.3773E-01_JPRB/)
KAO( :, 3, 3,10) = (/&
&1.9023E-01_JPRB,1.7929E-01_JPRB,1.7582E-01_JPRB,1.6700E-01_JPRB,1.5430E-01_JPRB,1.4161E-01_JPRB,&
&1.2252E-01_JPRB,1.9023E-01_JPRB,1.7877E-01_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.9469E-01_JPRB,1.8893E-01_JPRB,1.8906E-01_JPRB,1.8314E-01_JPRB,1.7449E-01_JPRB,1.5948E-01_JPRB,&
&1.3408E-01_JPRB,1.9469E-01_JPRB,2.2723E-01_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.9821E-01_JPRB,1.9946E-01_JPRB,2.0415E-01_JPRB,1.9922E-01_JPRB,1.8972E-01_JPRB,1.7229E-01_JPRB,&
&1.5170E-01_JPRB,1.9821E-01_JPRB,2.8243E-01_JPRB/)
KAO( :, 1, 4,10) = (/&
&1.7916E-01_JPRB,1.5693E-01_JPRB,1.4317E-01_JPRB,1.2970E-01_JPRB,1.1820E-01_JPRB,1.0542E-01_JPRB,&
&8.8810E-02_JPRB,1.7916E-01_JPRB,8.1629E-02_JPRB/)
KAO( :, 2, 4,10) = (/&
&1.8393E-01_JPRB,1.6496E-01_JPRB,1.5408E-01_JPRB,1.4656E-01_JPRB,1.3470E-01_JPRB,1.1968E-01_JPRB,&
&1.0109E-01_JPRB,1.8393E-01_JPRB,1.1300E-01_JPRB/)
KAO( :, 3, 4,10) = (/&
&1.8829E-01_JPRB,1.7395E-01_JPRB,1.6912E-01_JPRB,1.6090E-01_JPRB,1.4836E-01_JPRB,1.3533E-01_JPRB,&
&1.1688E-01_JPRB,1.8829E-01_JPRB,1.5011E-01_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.9238E-01_JPRB,1.8364E-01_JPRB,1.8242E-01_JPRB,1.7617E-01_JPRB,1.6761E-01_JPRB,1.5430E-01_JPRB,&
&1.3056E-01_JPRB,1.9230E-01_JPRB,1.9532E-01_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.9574E-01_JPRB,1.9463E-01_JPRB,1.9705E-01_JPRB,1.9264E-01_JPRB,1.8511E-01_JPRB,1.7157E-01_JPRB,&
&1.5145E-01_JPRB,1.9574E-01_JPRB,2.4701E-01_JPRB/)
KAO( :, 1, 5,10) = (/&
&1.8797E-01_JPRB,1.6453E-01_JPRB,1.4533E-01_JPRB,1.2686E-01_JPRB,1.1219E-01_JPRB,9.8719E-02_JPRB,&
&8.1932E-02_JPRB,1.8797E-01_JPRB,6.5166E-02_JPRB/)
KAO( :, 2, 5,10) = (/&
&1.9160E-01_JPRB,1.6925E-01_JPRB,1.5218E-01_JPRB,1.4014E-01_JPRB,1.2917E-01_JPRB,1.1302E-01_JPRB,&
&9.4480E-02_JPRB,1.9160E-01_JPRB,9.2077E-02_JPRB/)
KAO( :, 3, 5,10) = (/&
&1.9446E-01_JPRB,1.7578E-01_JPRB,1.6402E-01_JPRB,1.5506E-01_JPRB,1.4235E-01_JPRB,1.2780E-01_JPRB,&
&1.1066E-01_JPRB,1.9446E-01_JPRB,1.2479E-01_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.9736E-01_JPRB,1.8183E-01_JPRB,1.7664E-01_JPRB,1.6999E-01_JPRB,1.6179E-01_JPRB,1.4826E-01_JPRB,&
&1.2816E-01_JPRB,1.9736E-01_JPRB,1.6346E-01_JPRB/)
KAO( :, 5, 5,10) = (/&
&2.0011E-01_JPRB,1.9074E-01_JPRB,1.9082E-01_JPRB,1.8829E-01_JPRB,1.8080E-01_JPRB,1.6858E-01_JPRB,&
&1.5009E-01_JPRB,2.0011E-01_JPRB,2.0822E-01_JPRB/)
KAO( :, 1, 6,10) = (/&
&2.0223E-01_JPRB,1.7699E-01_JPRB,1.5322E-01_JPRB,1.3128E-01_JPRB,1.1092E-01_JPRB,9.1561E-02_JPRB,&
&7.3661E-02_JPRB,2.0223E-01_JPRB,5.1377E-02_JPRB/)
KAO( :, 2, 6,10) = (/&
&2.0512E-01_JPRB,1.7967E-01_JPRB,1.5788E-01_JPRB,1.3938E-01_JPRB,1.2268E-01_JPRB,1.0543E-01_JPRB,&
&8.7385E-02_JPRB,2.0512E-01_JPRB,7.3853E-02_JPRB/)
KAO( :, 3, 6,10) = (/&
&2.0790E-01_JPRB,1.8450E-01_JPRB,1.6529E-01_JPRB,1.5112E-01_JPRB,1.3529E-01_JPRB,1.2022E-01_JPRB,&
&1.0398E-01_JPRB,2.0790E-01_JPRB,1.0087E-01_JPRB/)
KAO( :, 4, 6,10) = (/&
&2.1004E-01_JPRB,1.8823E-01_JPRB,1.7509E-01_JPRB,1.6284E-01_JPRB,1.5386E-01_JPRB,1.4155E-01_JPRB,&
&1.2427E-01_JPRB,2.1004E-01_JPRB,1.3360E-01_JPRB/)
KAO( :, 5, 6,10) = (/&
&2.1183E-01_JPRB,1.9428E-01_JPRB,1.8513E-01_JPRB,1.8177E-01_JPRB,1.7498E-01_JPRB,1.6423E-01_JPRB,&
&1.4704E-01_JPRB,2.1183E-01_JPRB,1.7178E-01_JPRB/)
KAO( :, 1, 7,10) = (/&
&2.1966E-01_JPRB,1.9223E-01_JPRB,1.6487E-01_JPRB,1.4075E-01_JPRB,1.1743E-01_JPRB,9.2352E-02_JPRB,&
&6.7165E-02_JPRB,2.1966E-01_JPRB,3.9844E-02_JPRB/)
KAO( :, 2, 7,10) = (/&
&2.2289E-01_JPRB,1.9505E-01_JPRB,1.7012E-01_JPRB,1.4711E-01_JPRB,1.2482E-01_JPRB,1.0166E-01_JPRB,&
&8.1116E-02_JPRB,2.2289E-01_JPRB,5.8803E-02_JPRB/)
KAO( :, 3, 7,10) = (/&
&2.2562E-01_JPRB,1.9918E-01_JPRB,1.7558E-01_JPRB,1.5579E-01_JPRB,1.3361E-01_JPRB,1.1381E-01_JPRB,&
&9.8296E-02_JPRB,2.2562E-01_JPRB,8.2105E-02_JPRB/)
KAO( :, 4, 7,10) = (/&
&2.2798E-01_JPRB,2.0283E-01_JPRB,1.8393E-01_JPRB,1.6360E-01_JPRB,1.4672E-01_JPRB,1.3482E-01_JPRB,&
&1.1942E-01_JPRB,2.2798E-01_JPRB,1.1013E-01_JPRB/)
KAO( :, 5, 7,10) = (/&
&2.2965E-01_JPRB,2.0713E-01_JPRB,1.9045E-01_JPRB,1.7711E-01_JPRB,1.6890E-01_JPRB,1.5875E-01_JPRB,&
&1.4294E-01_JPRB,2.2965E-01_JPRB,1.4301E-01_JPRB/)
KAO( :, 1, 8,10) = (/&
&2.3927E-01_JPRB,2.0940E-01_JPRB,1.7953E-01_JPRB,1.5074E-01_JPRB,1.2505E-01_JPRB,9.7338E-02_JPRB,&
&6.8761E-02_JPRB,2.3927E-01_JPRB,3.1572E-02_JPRB/)
KAO( :, 2, 8,10) = (/&
&2.4243E-01_JPRB,2.1216E-01_JPRB,1.8359E-01_JPRB,1.5756E-01_JPRB,1.3069E-01_JPRB,1.0456E-01_JPRB,&
&7.7923E-02_JPRB,2.4243E-01_JPRB,4.5978E-02_JPRB/)
KAO( :, 3, 8,10) = (/&
&2.4547E-01_JPRB,2.1534E-01_JPRB,1.8853E-01_JPRB,1.6503E-01_JPRB,1.3896E-01_JPRB,1.1377E-01_JPRB,&
&9.3425E-02_JPRB,2.4547E-01_JPRB,6.4381E-02_JPRB/)
KAO( :, 4, 8,10) = (/&
&2.4802E-01_JPRB,2.1966E-01_JPRB,1.9648E-01_JPRB,1.7197E-01_JPRB,1.4872E-01_JPRB,1.2967E-01_JPRB,&
&1.1417E-01_JPRB,2.4802E-01_JPRB,8.7970E-02_JPRB/)
KAO( :, 5, 8,10) = (/&
&2.4998E-01_JPRB,2.2309E-01_JPRB,2.0261E-01_JPRB,1.8232E-01_JPRB,1.6517E-01_JPRB,1.5264E-01_JPRB,&
&1.3834E-01_JPRB,2.4998E-01_JPRB,1.1639E-01_JPRB/)
KAO( :, 1, 9,10) = (/&
&2.6148E-01_JPRB,2.2882E-01_JPRB,1.9618E-01_JPRB,1.6370E-01_JPRB,1.3448E-01_JPRB,1.0395E-01_JPRB,&
&7.1629E-02_JPRB,2.6148E-01_JPRB,2.8503E-02_JPRB/)
KAO( :, 2, 9,10) = (/&
&2.6519E-01_JPRB,2.3210E-01_JPRB,1.9937E-01_JPRB,1.7015E-01_JPRB,1.3964E-01_JPRB,1.0892E-01_JPRB,&
&7.8889E-02_JPRB,2.6519E-01_JPRB,3.8008E-02_JPRB/)
KAO( :, 3, 9,10) = (/&
&2.6824E-01_JPRB,2.3478E-01_JPRB,2.0449E-01_JPRB,1.7562E-01_JPRB,1.4652E-01_JPRB,1.1674E-01_JPRB,&
&9.2270E-02_JPRB,2.6824E-01_JPRB,5.2422E-02_JPRB/)
KAO( :, 4, 9,10) = (/&
&2.7078E-01_JPRB,2.3877E-01_JPRB,2.1054E-01_JPRB,1.8264E-01_JPRB,1.5412E-01_JPRB,1.3041E-01_JPRB,&
&1.0749E-01_JPRB,2.7078E-01_JPRB,7.0338E-02_JPRB/)
KAO( :, 5, 9,10) = (/&
&2.7264E-01_JPRB,2.4161E-01_JPRB,2.1662E-01_JPRB,1.8978E-01_JPRB,1.6860E-01_JPRB,1.4804E-01_JPRB,&
&1.3080E-01_JPRB,2.7264E-01_JPRB,9.2554E-02_JPRB/)
KAO( :, 1,10,10) = (/&
&2.8201E-01_JPRB,2.4678E-01_JPRB,2.1156E-01_JPRB,1.7638E-01_JPRB,1.4352E-01_JPRB,1.1084E-01_JPRB,&
&7.6972E-02_JPRB,2.8201E-01_JPRB,1.2471E-01_JPRB/)
KAO( :, 2,10,10) = (/&
&2.8576E-01_JPRB,2.5006E-01_JPRB,2.1438E-01_JPRB,1.8231E-01_JPRB,1.4961E-01_JPRB,1.1549E-01_JPRB,&
&8.2006E-02_JPRB,2.8576E-01_JPRB,1.2496E-01_JPRB/)
KAO( :, 3,10,10) = (/&
&2.8893E-01_JPRB,2.5286E-01_JPRB,2.1949E-01_JPRB,1.8787E-01_JPRB,1.5551E-01_JPRB,1.2228E-01_JPRB,&
&9.3406E-02_JPRB,2.8893E-01_JPRB,1.2857E-01_JPRB/)
KAO( :, 4,10,10) = (/&
&2.9143E-01_JPRB,2.5653E-01_JPRB,2.2518E-01_JPRB,1.9466E-01_JPRB,1.6197E-01_JPRB,1.3409E-01_JPRB,&
&1.0614E-01_JPRB,2.9143E-01_JPRB,1.3664E-01_JPRB/)
KAO( :, 5,10,10) = (/&
&2.9269E-01_JPRB,2.5878E-01_JPRB,2.3097E-01_JPRB,1.9967E-01_JPRB,1.7426E-01_JPRB,1.4933E-01_JPRB,&
&1.2477E-01_JPRB,2.9269E-01_JPRB,1.4648E-01_JPRB/)
KAO( :, 1,11,10) = (/&
&3.0003E-01_JPRB,2.6255E-01_JPRB,2.2506E-01_JPRB,1.8819E-01_JPRB,1.5371E-01_JPRB,1.1851E-01_JPRB,&
&8.1809E-02_JPRB,3.0003E-01_JPRB,3.1454E-01_JPRB/)
KAO( :, 2,11,10) = (/&
&3.0324E-01_JPRB,2.6535E-01_JPRB,2.2775E-01_JPRB,1.9448E-01_JPRB,1.5903E-01_JPRB,1.2292E-01_JPRB,&
&8.8865E-02_JPRB,3.0324E-01_JPRB,3.0861E-01_JPRB/)
KAO( :, 3,11,10) = (/&
&3.0493E-01_JPRB,2.6686E-01_JPRB,2.3266E-01_JPRB,1.9918E-01_JPRB,1.6490E-01_JPRB,1.3153E-01_JPRB,&
&1.0078E-01_JPRB,3.0493E-01_JPRB,3.0699E-01_JPRB/)
KAO( :, 4,11,10) = (/&
&3.0577E-01_JPRB,2.6940E-01_JPRB,2.3789E-01_JPRB,2.0495E-01_JPRB,1.7338E-01_JPRB,1.4467E-01_JPRB,&
&1.1314E-01_JPRB,3.0577E-01_JPRB,3.1082E-01_JPRB/)
KAO( :, 5,11,10) = (/&
&3.0551E-01_JPRB,2.7044E-01_JPRB,2.4227E-01_JPRB,2.1229E-01_JPRB,1.8801E-01_JPRB,1.5979E-01_JPRB,&
&1.3090E-01_JPRB,3.0551E-01_JPRB,3.1527E-01_JPRB/)
KAO( :, 1,12,10) = (/&
&3.1134E-01_JPRB,2.7243E-01_JPRB,2.3354E-01_JPRB,1.9639E-01_JPRB,1.6090E-01_JPRB,1.2387E-01_JPRB,&
&8.6052E-02_JPRB,3.1134E-01_JPRB,5.2978E-01_JPRB/)
KAO( :, 2,12,10) = (/&
&3.1359E-01_JPRB,2.7441E-01_JPRB,2.3677E-01_JPRB,2.0238E-01_JPRB,1.6552E-01_JPRB,1.2901E-01_JPRB,&
&9.5207E-02_JPRB,3.1359E-01_JPRB,5.2052E-01_JPRB/)
KAO( :, 3,12,10) = (/&
&3.1415E-01_JPRB,2.7537E-01_JPRB,2.4122E-01_JPRB,2.0715E-01_JPRB,1.7193E-01_JPRB,1.3997E-01_JPRB,&
&1.0720E-01_JPRB,3.1415E-01_JPRB,5.1560E-01_JPRB/)
KAO( :, 4,12,10) = (/&
&3.1372E-01_JPRB,2.7678E-01_JPRB,2.4609E-01_JPRB,2.1256E-01_JPRB,1.8335E-01_JPRB,1.5322E-01_JPRB,&
&1.2081E-01_JPRB,3.1372E-01_JPRB,5.1557E-01_JPRB/)
KAO( :, 5,12,10) = (/&
&3.1239E-01_JPRB,2.7822E-01_JPRB,2.4956E-01_JPRB,2.2367E-01_JPRB,1.9838E-01_JPRB,1.6937E-01_JPRB,&
&1.3606E-01_JPRB,3.1239E-01_JPRB,5.1667E-01_JPRB/)
KAO( :, 1,13,10) = (/&
&3.1638E-01_JPRB,2.7683E-01_JPRB,2.3750E-01_JPRB,2.0114E-01_JPRB,1.6456E-01_JPRB,1.2632E-01_JPRB,&
&8.9253E-02_JPRB,3.1638E-01_JPRB,7.3497E-01_JPRB/)
KAO( :, 2,13,10) = (/&
&3.1671E-01_JPRB,2.7713E-01_JPRB,2.4097E-01_JPRB,2.0542E-01_JPRB,1.6866E-01_JPRB,1.3347E-01_JPRB,&
&9.9658E-02_JPRB,3.1671E-01_JPRB,7.1891E-01_JPRB/)
KAO( :, 3,13,10) = (/&
&3.1659E-01_JPRB,2.7824E-01_JPRB,2.4448E-01_JPRB,2.1048E-01_JPRB,1.7715E-01_JPRB,1.4549E-01_JPRB,&
&1.1132E-01_JPRB,3.1659E-01_JPRB,7.1020E-01_JPRB/)
KAO( :, 4,13,10) = (/&
&3.1484E-01_JPRB,2.7845E-01_JPRB,2.4849E-01_JPRB,2.1796E-01_JPRB,1.8948E-01_JPRB,1.5955E-01_JPRB,&
&1.2635E-01_JPRB,3.1484E-01_JPRB,7.0756E-01_JPRB/)
KAO( :, 5,13,10) = (/&
&3.1186E-01_JPRB,2.8054E-01_JPRB,2.5362E-01_JPRB,2.3086E-01_JPRB,2.0496E-01_JPRB,1.7512E-01_JPRB,&
&1.4143E-01_JPRB,3.1186E-01_JPRB,7.0584E-01_JPRB/)
KAO( :, 1, 1,11) = (/&
&3.1327E-01_JPRB,2.7438E-01_JPRB,2.3864E-01_JPRB,2.1648E-01_JPRB,1.8690E-01_JPRB,1.5673E-01_JPRB,&
&1.2734E-01_JPRB,3.1327E-01_JPRB,1.4986E-01_JPRB/)
KAO( :, 2, 1,11) = (/&
&3.1392E-01_JPRB,2.7491E-01_JPRB,2.5200E-01_JPRB,2.2734E-01_JPRB,2.0303E-01_JPRB,1.7541E-01_JPRB,&
&1.4089E-01_JPRB,3.1392E-01_JPRB,1.9707E-01_JPRB/)
KAO( :, 3, 1,11) = (/&
&3.1383E-01_JPRB,2.7650E-01_JPRB,2.6109E-01_JPRB,2.4195E-01_JPRB,2.1927E-01_JPRB,1.8650E-01_JPRB,&
&1.4955E-01_JPRB,3.1383E-01_JPRB,2.5159E-01_JPRB/)
KAO( :, 4, 1,11) = (/&
&3.1272E-01_JPRB,2.8403E-01_JPRB,2.7223E-01_JPRB,2.5585E-01_JPRB,2.2854E-01_JPRB,2.0092E-01_JPRB,&
&1.8691E-01_JPRB,3.1272E-01_JPRB,3.1304E-01_JPRB/)
KAO( :, 5, 1,11) = (/&
&3.1090E-01_JPRB,2.8955E-01_JPRB,2.8191E-01_JPRB,2.6664E-01_JPRB,2.4121E-01_JPRB,2.1301E-01_JPRB,&
&2.4137E-01_JPRB,3.1090E-01_JPRB,3.8118E-01_JPRB/)
KAO( :, 1, 2,11) = (/&
&3.1324E-01_JPRB,2.7422E-01_JPRB,2.3920E-01_JPRB,2.1500E-01_JPRB,1.8495E-01_JPRB,1.5528E-01_JPRB,&
&1.2577E-01_JPRB,3.1324E-01_JPRB,1.5045E-01_JPRB/)
KAO( :, 2, 2,11) = (/&
&3.1470E-01_JPRB,2.7557E-01_JPRB,2.5223E-01_JPRB,2.2657E-01_JPRB,2.0210E-01_JPRB,1.7421E-01_JPRB,&
&1.3837E-01_JPRB,3.1470E-01_JPRB,1.9866E-01_JPRB/)
KAO( :, 3, 2,11) = (/&
&3.1536E-01_JPRB,2.7926E-01_JPRB,2.6141E-01_JPRB,2.4214E-01_JPRB,2.1888E-01_JPRB,1.8478E-01_JPRB,&
&1.5074E-01_JPRB,3.1536E-01_JPRB,2.5677E-01_JPRB/)
KAO( :, 4, 2,11) = (/&
&3.1504E-01_JPRB,2.8779E-01_JPRB,2.7376E-01_JPRB,2.5633E-01_JPRB,2.2942E-01_JPRB,1.9993E-01_JPRB,&
&1.7112E-01_JPRB,3.1504E-01_JPRB,3.2302E-01_JPRB/)
KAO( :, 5, 2,11) = (/&
&3.1381E-01_JPRB,2.9324E-01_JPRB,2.8519E-01_JPRB,2.6951E-01_JPRB,2.4055E-01_JPRB,2.0793E-01_JPRB,&
&2.1700E-01_JPRB,3.1381E-01_JPRB,3.9625E-01_JPRB/)
KAO( :, 1, 3,11) = (/&
&3.1204E-01_JPRB,2.7315E-01_JPRB,2.3704E-01_JPRB,2.1094E-01_JPRB,1.7966E-01_JPRB,1.4896E-01_JPRB,&
&1.2013E-01_JPRB,3.1204E-01_JPRB,1.3758E-01_JPRB/)
KAO( :, 2, 3,11) = (/&
&3.1466E-01_JPRB,2.7547E-01_JPRB,2.5029E-01_JPRB,2.2183E-01_JPRB,1.9651E-01_JPRB,1.6912E-01_JPRB,&
&1.3258E-01_JPRB,3.1466E-01_JPRB,1.8586E-01_JPRB/)
KAO( :, 3, 3,11) = (/&
&3.1617E-01_JPRB,2.7992E-01_JPRB,2.5948E-01_JPRB,2.3884E-01_JPRB,2.1445E-01_JPRB,1.8030E-01_JPRB,&
&1.4450E-01_JPRB,3.1617E-01_JPRB,2.4266E-01_JPRB/)
KAO( :, 4, 3,11) = (/&
&3.1681E-01_JPRB,2.8890E-01_JPRB,2.7221E-01_JPRB,2.5334E-01_JPRB,2.2580E-01_JPRB,1.9471E-01_JPRB,&
&1.5799E-01_JPRB,3.1681E-01_JPRB,3.0762E-01_JPRB/)
KAO( :, 5, 3,11) = (/&
&3.1660E-01_JPRB,2.9490E-01_JPRB,2.8472E-01_JPRB,2.6817E-01_JPRB,2.3814E-01_JPRB,2.0506E-01_JPRB,&
&1.8418E-01_JPRB,3.1660E-01_JPRB,3.8162E-01_JPRB/)
KAO( :, 1, 4,11) = (/&
&3.0866E-01_JPRB,2.7016E-01_JPRB,2.3341E-01_JPRB,2.0592E-01_JPRB,1.7365E-01_JPRB,1.4152E-01_JPRB,&
&1.1350E-01_JPRB,3.0866E-01_JPRB,1.1729E-01_JPRB/)
KAO( :, 2, 4,11) = (/&
&3.1261E-01_JPRB,2.7364E-01_JPRB,2.4679E-01_JPRB,2.1687E-01_JPRB,1.8912E-01_JPRB,1.6227E-01_JPRB,&
&1.2877E-01_JPRB,3.1261E-01_JPRB,1.6263E-01_JPRB/)
KAO( :, 3, 4,11) = (/&
&3.1517E-01_JPRB,2.7866E-01_JPRB,2.5633E-01_JPRB,2.3322E-01_JPRB,2.0818E-01_JPRB,1.7524E-01_JPRB,&
&1.4011E-01_JPRB,3.1517E-01_JPRB,2.1741E-01_JPRB/)
KAO( :, 4, 4,11) = (/&
&3.1718E-01_JPRB,2.8802E-01_JPRB,2.6947E-01_JPRB,2.4866E-01_JPRB,2.2061E-01_JPRB,1.8942E-01_JPRB,&
&1.5695E-01_JPRB,3.1727E-01_JPRB,2.8012E-01_JPRB/)
KAO( :, 5, 4,11) = (/&
&3.1858E-01_JPRB,2.9479E-01_JPRB,2.8190E-01_JPRB,2.6309E-01_JPRB,2.3448E-01_JPRB,2.0068E-01_JPRB,&
&1.6930E-01_JPRB,3.1858E-01_JPRB,3.4979E-01_JPRB/)
KAO( :, 1, 5,11) = (/&
&3.0359E-01_JPRB,2.6572E-01_JPRB,2.2874E-01_JPRB,1.9974E-01_JPRB,1.6826E-01_JPRB,1.3653E-01_JPRB,&
&1.0959E-01_JPRB,3.0359E-01_JPRB,9.5564E-02_JPRB/)
KAO( :, 2, 5,11) = (/&
&3.0961E-01_JPRB,2.7098E-01_JPRB,2.4191E-01_JPRB,2.1172E-01_JPRB,1.8197E-01_JPRB,1.5688E-01_JPRB,&
&1.2682E-01_JPRB,3.0961E-01_JPRB,1.3546E-01_JPRB/)
KAO( :, 3, 5,11) = (/&
&3.1431E-01_JPRB,2.7737E-01_JPRB,2.5231E-01_JPRB,2.2743E-01_JPRB,2.0217E-01_JPRB,1.7268E-01_JPRB,&
&1.3768E-01_JPRB,3.1431E-01_JPRB,1.8484E-01_JPRB/)
KAO( :, 4, 5,11) = (/&
&3.1787E-01_JPRB,2.8734E-01_JPRB,2.6579E-01_JPRB,2.4308E-01_JPRB,2.1533E-01_JPRB,1.8679E-01_JPRB,&
&1.5347E-01_JPRB,3.1787E-01_JPRB,2.4315E-01_JPRB/)
KAO( :, 5, 5,11) = (/&
&3.2027E-01_JPRB,2.9468E-01_JPRB,2.7870E-01_JPRB,2.5695E-01_JPRB,2.3189E-01_JPRB,2.0016E-01_JPRB,&
&1.6850E-01_JPRB,3.2027E-01_JPRB,3.1159E-01_JPRB/)
KAO( :, 1, 6,11) = (/&
&2.9865E-01_JPRB,2.6139E-01_JPRB,2.2417E-01_JPRB,1.9237E-01_JPRB,1.6261E-01_JPRB,1.3306E-01_JPRB,&
&1.0402E-01_JPRB,2.9865E-01_JPRB,7.4728E-02_JPRB/)
KAO( :, 2, 6,11) = (/&
&3.0619E-01_JPRB,2.6800E-01_JPRB,2.3652E-01_JPRB,2.0579E-01_JPRB,1.7684E-01_JPRB,1.5168E-01_JPRB,&
&1.2223E-01_JPRB,3.0619E-01_JPRB,1.0829E-01_JPRB/)
KAO( :, 3, 6,11) = (/&
&3.1241E-01_JPRB,2.7514E-01_JPRB,2.4815E-01_JPRB,2.2081E-01_JPRB,1.9720E-01_JPRB,1.6917E-01_JPRB,&
&1.3396E-01_JPRB,3.1241E-01_JPRB,1.5151E-01_JPRB/)
KAO( :, 4, 6,11) = (/&
&3.1661E-01_JPRB,2.8538E-01_JPRB,2.6104E-01_JPRB,2.3841E-01_JPRB,2.1165E-01_JPRB,1.8243E-01_JPRB,&
&1.4887E-01_JPRB,3.1661E-01_JPRB,2.0348E-01_JPRB/)
KAO( :, 5, 6,11) = (/&
&3.2000E-01_JPRB,2.9293E-01_JPRB,2.7479E-01_JPRB,2.5146E-01_JPRB,2.2881E-01_JPRB,1.9893E-01_JPRB,&
&1.6745E-01_JPRB,3.2000E-01_JPRB,2.6520E-01_JPRB/)
KAO( :, 1, 7,11) = (/&
&3.0081E-01_JPRB,2.6324E-01_JPRB,2.2567E-01_JPRB,1.8947E-01_JPRB,1.5824E-01_JPRB,1.2934E-01_JPRB,&
&9.9139E-02_JPRB,3.0081E-01_JPRB,5.8236E-02_JPRB/)
KAO( :, 2, 7,11) = (/&
&3.0785E-01_JPRB,2.6938E-01_JPRB,2.3362E-01_JPRB,2.0225E-01_JPRB,1.7197E-01_JPRB,1.4526E-01_JPRB,&
&1.1606E-01_JPRB,3.0785E-01_JPRB,8.6143E-02_JPRB/)
KAO( :, 3, 7,11) = (/&
&3.1355E-01_JPRB,2.7471E-01_JPRB,2.4475E-01_JPRB,2.1558E-01_JPRB,1.9203E-01_JPRB,1.6359E-01_JPRB,&
&1.2884E-01_JPRB,3.1355E-01_JPRB,1.2279E-01_JPRB/)
KAO( :, 4, 7,11) = (/&
&3.1773E-01_JPRB,2.8339E-01_JPRB,2.5534E-01_JPRB,2.3396E-01_JPRB,2.0755E-01_JPRB,1.7658E-01_JPRB,&
&1.4450E-01_JPRB,3.1773E-01_JPRB,1.6752E-01_JPRB/)
KAO( :, 5, 7,11) = (/&
&3.2073E-01_JPRB,2.9018E-01_JPRB,2.6952E-01_JPRB,2.4697E-01_JPRB,2.2381E-01_JPRB,1.9623E-01_JPRB,&
&1.6582E-01_JPRB,3.2073E-01_JPRB,2.2165E-01_JPRB/)
KAO( :, 1, 8,11) = (/&
&3.1629E-01_JPRB,2.7676E-01_JPRB,2.3728E-01_JPRB,1.9776E-01_JPRB,1.6109E-01_JPRB,1.2901E-01_JPRB,&
&9.4699E-02_JPRB,3.1629E-01_JPRB,4.5300E-02_JPRB/)
KAO( :, 2, 8,11) = (/&
&3.2227E-01_JPRB,2.8203E-01_JPRB,2.4214E-01_JPRB,2.0636E-01_JPRB,1.7262E-01_JPRB,1.4016E-01_JPRB,&
&1.0877E-01_JPRB,3.2227E-01_JPRB,6.8853E-02_JPRB/)
KAO( :, 3, 8,11) = (/&
&3.2688E-01_JPRB,2.8607E-01_JPRB,2.5069E-01_JPRB,2.1556E-01_JPRB,1.8748E-01_JPRB,1.5661E-01_JPRB,&
&1.2299E-01_JPRB,3.2688E-01_JPRB,1.0018E-01_JPRB/)
KAO( :, 4, 8,11) = (/&
&3.2981E-01_JPRB,2.9140E-01_JPRB,2.5712E-01_JPRB,2.3078E-01_JPRB,2.0158E-01_JPRB,1.7058E-01_JPRB,&
&1.4006E-01_JPRB,3.2981E-01_JPRB,1.3838E-01_JPRB/)
KAO( :, 5, 8,11) = (/&
&3.3188E-01_JPRB,2.9618E-01_JPRB,2.6784E-01_JPRB,2.4209E-01_JPRB,2.1696E-01_JPRB,1.9240E-01_JPRB,&
&1.6480E-01_JPRB,3.3188E-01_JPRB,1.8388E-01_JPRB/)
KAO( :, 1, 9,11) = (/&
&3.4054E-01_JPRB,2.9798E-01_JPRB,2.5543E-01_JPRB,2.1287E-01_JPRB,1.7079E-01_JPRB,1.3421E-01_JPRB,&
&9.5710E-02_JPRB,3.4054E-01_JPRB,3.8236E-02_JPRB/)
KAO( :, 2, 9,11) = (/&
&3.4633E-01_JPRB,3.0305E-01_JPRB,2.5976E-01_JPRB,2.1890E-01_JPRB,1.8147E-01_JPRB,1.4225E-01_JPRB,&
&1.0350E-01_JPRB,3.4633E-01_JPRB,5.6238E-02_JPRB/)
KAO( :, 3, 9,11) = (/&
&3.5037E-01_JPRB,3.0657E-01_JPRB,2.6602E-01_JPRB,2.2678E-01_JPRB,1.8994E-01_JPRB,1.5344E-01_JPRB,&
&1.1667E-01_JPRB,3.5037E-01_JPRB,8.1743E-02_JPRB/)
KAO( :, 4, 9,11) = (/&
&3.5228E-01_JPRB,3.0944E-01_JPRB,2.6992E-01_JPRB,2.3660E-01_JPRB,2.0123E-01_JPRB,1.6487E-01_JPRB,&
&1.3602E-01_JPRB,3.5228E-01_JPRB,1.1413E-01_JPRB/)
KAO( :, 5, 9,11) = (/&
&3.5225E-01_JPRB,3.1211E-01_JPRB,2.7731E-01_JPRB,2.4493E-01_JPRB,2.1160E-01_JPRB,1.8738E-01_JPRB,&
&1.6276E-01_JPRB,3.5225E-01_JPRB,1.5348E-01_JPRB/)
KAO( :, 1,10,11) = (/&
&3.6852E-01_JPRB,3.2247E-01_JPRB,2.7644E-01_JPRB,2.3039E-01_JPRB,1.8448E-01_JPRB,1.4188E-01_JPRB,&
&9.9757E-02_JPRB,3.6852E-01_JPRB,1.4040E-01_JPRB/)
KAO( :, 2,10,11) = (/&
&3.7315E-01_JPRB,3.2652E-01_JPRB,2.7989E-01_JPRB,2.3366E-01_JPRB,1.9261E-01_JPRB,1.5003E-01_JPRB,&
&1.0586E-01_JPRB,3.7315E-01_JPRB,1.4526E-01_JPRB/)
KAO( :, 3,10,11) = (/&
&3.7571E-01_JPRB,3.2878E-01_JPRB,2.8366E-01_JPRB,2.4104E-01_JPRB,1.9987E-01_JPRB,1.5820E-01_JPRB,&
&1.1578E-01_JPRB,3.7571E-01_JPRB,1.5497E-01_JPRB/)
KAO( :, 4,10,11) = (/&
&3.7705E-01_JPRB,3.3024E-01_JPRB,2.8735E-01_JPRB,2.4933E-01_JPRB,2.0907E-01_JPRB,1.6748E-01_JPRB,&
&1.3413E-01_JPRB,3.7705E-01_JPRB,1.6746E-01_JPRB/)
KAO( :, 5,10,11) = (/&
&3.7628E-01_JPRB,3.3247E-01_JPRB,2.9343E-01_JPRB,2.5663E-01_JPRB,2.1748E-01_JPRB,1.8673E-01_JPRB,&
&1.6058E-01_JPRB,3.7628E-01_JPRB,1.8275E-01_JPRB/)
KAO( :, 1,11,11) = (/&
&4.0038E-01_JPRB,3.5035E-01_JPRB,3.0034E-01_JPRB,2.5030E-01_JPRB,2.0116E-01_JPRB,1.5522E-01_JPRB,&
&1.0823E-01_JPRB,4.0038E-01_JPRB,3.5490E-01_JPRB/)
KAO( :, 2,11,11) = (/&
&4.0396E-01_JPRB,3.5350E-01_JPRB,3.0301E-01_JPRB,2.5425E-01_JPRB,2.0946E-01_JPRB,1.6195E-01_JPRB,&
&1.1374E-01_JPRB,4.0396E-01_JPRB,3.4856E-01_JPRB/)
KAO( :, 3,11,11) = (/&
&4.0565E-01_JPRB,3.5496E-01_JPRB,3.0665E-01_JPRB,2.6112E-01_JPRB,2.1551E-01_JPRB,1.6958E-01_JPRB,&
&1.2572E-01_JPRB,4.0565E-01_JPRB,3.5076E-01_JPRB/)
KAO( :, 4,11,11) = (/&
&4.0558E-01_JPRB,3.5595E-01_JPRB,3.0938E-01_JPRB,2.6840E-01_JPRB,2.2301E-01_JPRB,1.8046E-01_JPRB,&
&1.4403E-01_JPRB,4.0558E-01_JPRB,3.5722E-01_JPRB/)
KAO( :, 5,11,11) = (/&
&4.0446E-01_JPRB,3.5712E-01_JPRB,3.1553E-01_JPRB,2.7323E-01_JPRB,2.3366E-01_JPRB,2.0210E-01_JPRB,&
&1.6875E-01_JPRB,4.0446E-01_JPRB,3.6719E-01_JPRB/)
KAO( :, 1,12,11) = (/&
&4.3154E-01_JPRB,3.7764E-01_JPRB,3.2370E-01_JPRB,2.6981E-01_JPRB,2.1804E-01_JPRB,1.6850E-01_JPRB,&
&1.1669E-01_JPRB,4.3154E-01_JPRB,6.0134E-01_JPRB/)
KAO( :, 2,12,11) = (/&
&4.3374E-01_JPRB,3.7956E-01_JPRB,3.2536E-01_JPRB,2.7466E-01_JPRB,2.2555E-01_JPRB,1.7385E-01_JPRB,&
&1.2290E-01_JPRB,4.3374E-01_JPRB,5.8479E-01_JPRB/)
KAO( :, 3,12,11) = (/&
&4.3331E-01_JPRB,3.7916E-01_JPRB,3.2808E-01_JPRB,2.8000E-01_JPRB,2.3156E-01_JPRB,1.8166E-01_JPRB,&
&1.3630E-01_JPRB,4.3331E-01_JPRB,5.7701E-01_JPRB/)
KAO( :, 4,12,11) = (/&
&4.3216E-01_JPRB,3.8009E-01_JPRB,3.3136E-01_JPRB,2.8692E-01_JPRB,2.3835E-01_JPRB,1.9569E-01_JPRB,&
&1.5406E-01_JPRB,4.3216E-01_JPRB,5.7788E-01_JPRB/)
KAO( :, 5,12,11) = (/&
&4.2924E-01_JPRB,3.7929E-01_JPRB,3.3644E-01_JPRB,2.9162E-01_JPRB,2.5358E-01_JPRB,2.1598E-01_JPRB,&
&1.7801E-01_JPRB,4.2924E-01_JPRB,5.8590E-01_JPRB/)
KAO( :, 1,13,11) = (/&
&4.5507E-01_JPRB,3.9820E-01_JPRB,3.4134E-01_JPRB,2.8486E-01_JPRB,2.3199E-01_JPRB,1.7908E-01_JPRB,&
&1.2378E-01_JPRB,4.5507E-01_JPRB,8.3466E-01_JPRB/)
KAO( :, 2,13,11) = (/&
&4.5560E-01_JPRB,3.9865E-01_JPRB,3.4207E-01_JPRB,2.9076E-01_JPRB,2.3824E-01_JPRB,1.8413E-01_JPRB,&
&1.3231E-01_JPRB,4.5560E-01_JPRB,8.1743E-01_JPRB/)
KAO( :, 3,13,11) = (/&
&4.5408E-01_JPRB,3.9738E-01_JPRB,3.4508E-01_JPRB,2.9494E-01_JPRB,2.4447E-01_JPRB,1.9400E-01_JPRB,&
&1.4658E-01_JPRB,4.5408E-01_JPRB,8.0395E-01_JPRB/)
KAO( :, 4,13,11) = (/&
&4.5061E-01_JPRB,3.9693E-01_JPRB,3.4841E-01_JPRB,3.0086E-01_JPRB,2.5386E-01_JPRB,2.0976E-01_JPRB,&
&1.6407E-01_JPRB,4.5061E-01_JPRB,8.0112E-01_JPRB/)
KAO( :, 5,13,11) = (/&
&4.4632E-01_JPRB,3.9509E-01_JPRB,3.5179E-01_JPRB,3.0910E-01_JPRB,2.7153E-01_JPRB,2.3030E-01_JPRB,&
&1.8645E-01_JPRB,4.4632E-01_JPRB,8.0445E-01_JPRB/)
KAO( :, 1, 1,12) = (/&
&4.5134E-01_JPRB,3.9508E-01_JPRB,3.3890E-01_JPRB,2.8825E-01_JPRB,2.4778E-01_JPRB,1.9924E-01_JPRB,&
&1.4875E-01_JPRB,4.5134E-01_JPRB,1.8824E-01_JPRB/)
KAO( :, 2, 1,12) = (/&
&4.4302E-01_JPRB,3.8780E-01_JPRB,3.3477E-01_JPRB,2.9793E-01_JPRB,2.5163E-01_JPRB,2.0880E-01_JPRB,&
&1.6421E-01_JPRB,4.4302E-01_JPRB,2.4393E-01_JPRB/)
KAO( :, 3, 1,12) = (/&
&4.3442E-01_JPRB,3.8027E-01_JPRB,3.4110E-01_JPRB,2.9993E-01_JPRB,2.6022E-01_JPRB,2.1949E-01_JPRB,&
&2.0337E-01_JPRB,4.3442E-01_JPRB,3.1211E-01_JPRB/)
KAO( :, 4, 1,12) = (/&
&4.2548E-01_JPRB,3.7248E-01_JPRB,3.4001E-01_JPRB,3.0363E-01_JPRB,2.6872E-01_JPRB,2.3529E-01_JPRB,&
&2.6208E-01_JPRB,4.2548E-01_JPRB,4.0218E-01_JPRB/)
KAO( :, 5, 1,12) = (/&
&4.1637E-01_JPRB,3.7184E-01_JPRB,3.3956E-01_JPRB,3.0702E-01_JPRB,2.7666E-01_JPRB,3.0048E-01_JPRB,&
&3.3370E-01_JPRB,4.1637E-01_JPRB,5.1810E-01_JPRB/)
KAO( :, 1, 2,12) = (/&
&4.5993E-01_JPRB,4.0257E-01_JPRB,3.4522E-01_JPRB,2.9460E-01_JPRB,2.5120E-01_JPRB,2.0075E-01_JPRB,&
&1.4994E-01_JPRB,4.5993E-01_JPRB,1.8380E-01_JPRB/)
KAO( :, 2, 2,12) = (/&
&4.5214E-01_JPRB,3.9569E-01_JPRB,3.4306E-01_JPRB,3.0314E-01_JPRB,2.5542E-01_JPRB,2.1170E-01_JPRB,&
&1.6517E-01_JPRB,4.5214E-01_JPRB,2.4302E-01_JPRB/)
KAO( :, 3, 2,12) = (/&
&4.4392E-01_JPRB,3.8859E-01_JPRB,3.4836E-01_JPRB,3.0544E-01_JPRB,2.6499E-01_JPRB,2.2418E-01_JPRB,&
&1.8731E-01_JPRB,4.4392E-01_JPRB,3.1300E-01_JPRB/)
KAO( :, 4, 2,12) = (/&
&4.3542E-01_JPRB,3.8194E-01_JPRB,3.4769E-01_JPRB,3.0985E-01_JPRB,2.7291E-01_JPRB,2.3160E-01_JPRB,&
&2.4758E-01_JPRB,4.3542E-01_JPRB,3.9636E-01_JPRB/)
KAO( :, 5, 2,12) = (/&
&4.2659E-01_JPRB,3.8102E-01_JPRB,3.4597E-01_JPRB,3.1267E-01_JPRB,2.8101E-01_JPRB,2.8559E-01_JPRB,&
&3.2264E-01_JPRB,4.2659E-01_JPRB,5.0187E-01_JPRB/)
KAO( :, 1, 3,12) = (/&
&4.6833E-01_JPRB,4.0988E-01_JPRB,3.5146E-01_JPRB,2.9725E-01_JPRB,2.5255E-01_JPRB,2.0071E-01_JPRB,&
&1.4658E-01_JPRB,4.6833E-01_JPRB,1.7493E-01_JPRB/)
KAO( :, 2, 3,12) = (/&
&4.6121E-01_JPRB,4.0366E-01_JPRB,3.4878E-01_JPRB,3.0682E-01_JPRB,2.5668E-01_JPRB,2.1030E-01_JPRB,&
&1.6556E-01_JPRB,4.6121E-01_JPRB,2.3373E-01_JPRB/)
KAO( :, 3, 3,12) = (/&
&4.5378E-01_JPRB,3.9716E-01_JPRB,3.5415E-01_JPRB,3.0895E-01_JPRB,2.6677E-01_JPRB,2.2483E-01_JPRB,&
&1.7374E-01_JPRB,4.5378E-01_JPRB,3.0656E-01_JPRB/)
KAO( :, 4, 3,12) = (/&
&4.4576E-01_JPRB,3.9132E-01_JPRB,3.5375E-01_JPRB,3.1409E-01_JPRB,2.7473E-01_JPRB,2.3114E-01_JPRB,&
&2.1677E-01_JPRB,4.4576E-01_JPRB,3.9296E-01_JPRB/)
KAO( :, 5, 3,12) = (/&
&4.3705E-01_JPRB,3.9046E-01_JPRB,3.5326E-01_JPRB,3.1679E-01_JPRB,2.8502E-01_JPRB,2.5712E-01_JPRB,&
&2.8930E-01_JPRB,4.3705E-01_JPRB,4.9026E-01_JPRB/)
KAO( :, 1, 4,12) = (/&
&4.7595E-01_JPRB,4.1655E-01_JPRB,3.5714E-01_JPRB,2.9920E-01_JPRB,2.5213E-01_JPRB,1.9982E-01_JPRB,&
&1.4381E-01_JPRB,4.7595E-01_JPRB,1.5872E-01_JPRB/)
KAO( :, 2, 4,12) = (/&
&4.7033E-01_JPRB,4.1161E-01_JPRB,3.5414E-01_JPRB,3.0922E-01_JPRB,2.5846E-01_JPRB,2.0731E-01_JPRB,&
&1.6215E-01_JPRB,4.7033E-01_JPRB,2.1800E-01_JPRB/)
KAO( :, 3, 4,12) = (/&
&4.6352E-01_JPRB,4.0565E-01_JPRB,3.5971E-01_JPRB,3.1204E-01_JPRB,2.6678E-01_JPRB,2.2292E-01_JPRB,&
&1.7122E-01_JPRB,4.6352E-01_JPRB,2.9018E-01_JPRB/)
KAO( :, 4, 4,12) = (/&
&4.5585E-01_JPRB,4.0027E-01_JPRB,3.5920E-01_JPRB,3.1814E-01_JPRB,2.7571E-01_JPRB,2.2988E-01_JPRB,&
&1.8807E-01_JPRB,4.5585E-01_JPRB,3.7615E-01_JPRB/)
KAO( :, 5, 4,12) = (/&
&4.4747E-01_JPRB,3.9994E-01_JPRB,3.6045E-01_JPRB,3.2102E-01_JPRB,2.8482E-01_JPRB,2.4194E-01_JPRB,&
&2.4872E-01_JPRB,4.4747E-01_JPRB,4.7733E-01_JPRB/)
KAO( :, 1, 5,12) = (/&
&4.8332E-01_JPRB,4.2296E-01_JPRB,3.6260E-01_JPRB,3.0235E-01_JPRB,2.5042E-01_JPRB,1.9864E-01_JPRB,&
&1.4130E-01_JPRB,4.8332E-01_JPRB,1.3745E-01_JPRB/)
KAO( :, 2, 5,12) = (/&
&4.7867E-01_JPRB,4.1890E-01_JPRB,3.5947E-01_JPRB,3.1127E-01_JPRB,2.5927E-01_JPRB,2.0493E-01_JPRB,&
&1.5750E-01_JPRB,4.7867E-01_JPRB,1.9596E-01_JPRB/)
KAO( :, 3, 5,12) = (/&
&4.7259E-01_JPRB,4.1358E-01_JPRB,3.6520E-01_JPRB,3.1459E-01_JPRB,2.6723E-01_JPRB,2.2048E-01_JPRB,&
&1.7032E-01_JPRB,4.7259E-01_JPRB,2.6742E-01_JPRB/)
KAO( :, 4, 5,12) = (/&
&4.6538E-01_JPRB,4.0850E-01_JPRB,3.6518E-01_JPRB,3.2176E-01_JPRB,2.7688E-01_JPRB,2.2777E-01_JPRB,&
&1.8088E-01_JPRB,4.6538E-01_JPRB,3.5196E-01_JPRB/)
KAO( :, 5, 5,12) = (/&
&4.5769E-01_JPRB,4.0896E-01_JPRB,3.6726E-01_JPRB,3.2571E-01_JPRB,2.8321E-01_JPRB,2.4098E-01_JPRB,&
&2.1462E-01_JPRB,4.5769E-01_JPRB,4.5123E-01_JPRB/)
KAO( :, 1, 6,12) = (/&
&4.8993E-01_JPRB,4.2877E-01_JPRB,3.6756E-01_JPRB,3.0637E-01_JPRB,2.4861E-01_JPRB,1.9592E-01_JPRB,&
&1.4097E-01_JPRB,4.8993E-01_JPRB,1.1309E-01_JPRB/)
KAO( :, 2, 6,12) = (/&
&4.8623E-01_JPRB,4.2551E-01_JPRB,3.6480E-01_JPRB,3.1259E-01_JPRB,2.5937E-01_JPRB,2.0293E-01_JPRB,&
&1.5359E-01_JPRB,4.8623E-01_JPRB,1.6654E-01_JPRB/)
KAO( :, 3, 6,12) = (/&
&4.8158E-01_JPRB,4.2145E-01_JPRB,3.6981E-01_JPRB,3.1811E-01_JPRB,2.6579E-01_JPRB,2.1805E-01_JPRB,&
&1.7034E-01_JPRB,4.8158E-01_JPRB,2.3416E-01_JPRB/)
KAO( :, 4, 6,12) = (/&
&4.7580E-01_JPRB,4.1675E-01_JPRB,3.7108E-01_JPRB,3.2456E-01_JPRB,2.7803E-01_JPRB,2.2833E-01_JPRB,&
&1.8066E-01_JPRB,4.7580E-01_JPRB,3.1607E-01_JPRB/)
KAO( :, 5, 6,12) = (/&
&4.6758E-01_JPRB,4.1652E-01_JPRB,3.7367E-01_JPRB,3.3147E-01_JPRB,2.8380E-01_JPRB,2.4223E-01_JPRB,&
&1.9841E-01_JPRB,4.6758E-01_JPRB,4.1181E-01_JPRB/)
KAO( :, 1, 7,12) = (/&
&4.9556E-01_JPRB,4.3365E-01_JPRB,3.7175E-01_JPRB,3.0985E-01_JPRB,2.4854E-01_JPRB,1.9277E-01_JPRB,&
&1.4013E-01_JPRB,4.9556E-01_JPRB,8.9473E-02_JPRB/)
KAO( :, 2, 7,12) = (/&
&4.9363E-01_JPRB,4.3195E-01_JPRB,3.7029E-01_JPRB,3.1256E-01_JPRB,2.5963E-01_JPRB,2.0328E-01_JPRB,&
&1.5194E-01_JPRB,4.9363E-01_JPRB,1.3619E-01_JPRB/)
KAO( :, 3, 7,12) = (/&
&4.8988E-01_JPRB,4.2866E-01_JPRB,3.7265E-01_JPRB,3.2073E-01_JPRB,2.6549E-01_JPRB,2.1787E-01_JPRB,&
&1.7010E-01_JPRB,4.8988E-01_JPRB,1.9644E-01_JPRB/)
KAO( :, 4, 7,12) = (/&
&4.8356E-01_JPRB,4.2335E-01_JPRB,3.7640E-01_JPRB,3.2648E-01_JPRB,2.8045E-01_JPRB,2.3190E-01_JPRB,&
&1.7955E-01_JPRB,4.8356E-01_JPRB,2.7163E-01_JPRB/)
KAO( :, 5, 7,12) = (/&
&4.7613E-01_JPRB,4.2343E-01_JPRB,3.7941E-01_JPRB,3.3677E-01_JPRB,2.8839E-01_JPRB,2.4416E-01_JPRB,&
&1.9240E-01_JPRB,4.7613E-01_JPRB,3.6146E-01_JPRB/)
KAO( :, 1, 8,12) = (/&
&4.9952E-01_JPRB,4.3713E-01_JPRB,3.7469E-01_JPRB,3.1228E-01_JPRB,2.4992E-01_JPRB,1.8992E-01_JPRB,&
&1.3910E-01_JPRB,4.9952E-01_JPRB,7.0068E-02_JPRB/)
KAO( :, 2, 8,12) = (/&
&4.9876E-01_JPRB,4.3647E-01_JPRB,3.7415E-01_JPRB,3.1359E-01_JPRB,2.5898E-01_JPRB,2.0365E-01_JPRB,&
&1.5225E-01_JPRB,4.9876E-01_JPRB,1.0911E-01_JPRB/)
KAO( :, 3, 8,12) = (/&
&4.9561E-01_JPRB,4.3367E-01_JPRB,3.7478E-01_JPRB,3.2253E-01_JPRB,2.6652E-01_JPRB,2.1802E-01_JPRB,&
&1.6931E-01_JPRB,4.9561E-01_JPRB,1.6065E-01_JPRB/)
KAO( :, 4, 8,12) = (/&
&4.9132E-01_JPRB,4.2995E-01_JPRB,3.8056E-01_JPRB,3.2825E-01_JPRB,2.8313E-01_JPRB,2.3561E-01_JPRB,&
&1.7963E-01_JPRB,4.9132E-01_JPRB,2.2657E-01_JPRB/)
KAO( :, 5, 8,12) = (/&
&4.8493E-01_JPRB,4.3037E-01_JPRB,3.8392E-01_JPRB,3.3999E-01_JPRB,2.9506E-01_JPRB,2.4592E-01_JPRB,&
&1.9305E-01_JPRB,4.8493E-01_JPRB,3.0798E-01_JPRB/)
KAO( :, 1, 9,12) = (/&
&5.0297E-01_JPRB,4.4011E-01_JPRB,3.7727E-01_JPRB,3.1445E-01_JPRB,2.5164E-01_JPRB,1.8923E-01_JPRB,&
&1.3630E-01_JPRB,5.0297E-01_JPRB,5.5928E-02_JPRB/)
KAO( :, 2, 9,12) = (/&
&5.0280E-01_JPRB,4.3999E-01_JPRB,3.7719E-01_JPRB,3.1439E-01_JPRB,2.5596E-01_JPRB,2.0387E-01_JPRB,&
&1.5194E-01_JPRB,5.0280E-01_JPRB,8.7259E-02_JPRB/)
KAO( :, 3, 9,12) = (/&
&5.0165E-01_JPRB,4.3899E-01_JPRB,3.7733E-01_JPRB,3.2316E-01_JPRB,2.6815E-01_JPRB,2.1765E-01_JPRB,&
&1.6729E-01_JPRB,5.0165E-01_JPRB,1.3032E-01_JPRB/)
KAO( :, 4, 9,12) = (/&
&4.9775E-01_JPRB,4.3558E-01_JPRB,3.8325E-01_JPRB,3.2898E-01_JPRB,2.8348E-01_JPRB,2.3696E-01_JPRB,&
&1.7992E-01_JPRB,4.9775E-01_JPRB,1.8697E-01_JPRB/)
KAO( :, 5, 9,12) = (/&
&4.9256E-01_JPRB,4.3533E-01_JPRB,3.8600E-01_JPRB,3.4285E-01_JPRB,2.9917E-01_JPRB,2.4757E-01_JPRB,&
&1.9469E-01_JPRB,4.9256E-01_JPRB,2.5776E-01_JPRB/)
KAO( :, 1,10,12) = (/&
&5.1773E-01_JPRB,4.5305E-01_JPRB,3.8832E-01_JPRB,3.2361E-01_JPRB,2.5894E-01_JPRB,1.9444E-01_JPRB,&
&1.3626E-01_JPRB,5.1773E-01_JPRB,1.7143E-01_JPRB/)
KAO( :, 2,10,12) = (/&
&5.2014E-01_JPRB,4.5518E-01_JPRB,3.9014E-01_JPRB,3.2511E-01_JPRB,2.6137E-01_JPRB,2.0558E-01_JPRB,&
&1.5091E-01_JPRB,5.2014E-01_JPRB,1.7878E-01_JPRB/)
KAO( :, 3,10,12) = (/&
&5.1859E-01_JPRB,4.5376E-01_JPRB,3.8899E-01_JPRB,3.2977E-01_JPRB,2.7178E-01_JPRB,2.1806E-01_JPRB,&
&1.6450E-01_JPRB,5.1859E-01_JPRB,1.8778E-01_JPRB/)
KAO( :, 4,10,12) = (/&
&5.1464E-01_JPRB,4.5036E-01_JPRB,3.9278E-01_JPRB,3.3429E-01_JPRB,2.8520E-01_JPRB,2.3593E-01_JPRB,&
&1.7923E-01_JPRB,5.1464E-01_JPRB,2.0686E-01_JPRB/)
KAO( :, 5,10,12) = (/&
&5.1018E-01_JPRB,4.4905E-01_JPRB,3.9440E-01_JPRB,3.4703E-01_JPRB,3.0026E-01_JPRB,2.4817E-01_JPRB,&
&1.9727E-01_JPRB,5.1018E-01_JPRB,2.4342E-01_JPRB/)
KAO( :, 1,11,12) = (/&
&5.4832E-01_JPRB,4.7977E-01_JPRB,4.1126E-01_JPRB,3.4274E-01_JPRB,2.7420E-01_JPRB,2.0703E-01_JPRB,&
&1.4636E-01_JPRB,5.4832E-01_JPRB,4.2229E-01_JPRB/)
KAO( :, 2,11,12) = (/&
&5.4890E-01_JPRB,4.8029E-01_JPRB,4.1169E-01_JPRB,3.4308E-01_JPRB,2.7803E-01_JPRB,2.1902E-01_JPRB,&
&1.5675E-01_JPRB,5.4890E-01_JPRB,4.1304E-01_JPRB/)
KAO( :, 3,11,12) = (/&
&5.4760E-01_JPRB,4.7912E-01_JPRB,4.1148E-01_JPRB,3.4845E-01_JPRB,2.8802E-01_JPRB,2.2864E-01_JPRB,&
&1.6957E-01_JPRB,5.4760E-01_JPRB,4.1866E-01_JPRB/)
KAO( :, 4,11,12) = (/&
&5.4451E-01_JPRB,4.7646E-01_JPRB,4.1466E-01_JPRB,3.5324E-01_JPRB,3.0043E-01_JPRB,2.4253E-01_JPRB,&
&1.8588E-01_JPRB,5.4451E-01_JPRB,4.2963E-01_JPRB/)
KAO( :, 5,11,12) = (/&
&5.3844E-01_JPRB,4.7499E-01_JPRB,4.1514E-01_JPRB,3.6472E-01_JPRB,3.0977E-01_JPRB,2.5655E-01_JPRB,&
&2.1387E-01_JPRB,5.3844E-01_JPRB,4.4513E-01_JPRB/)
KAO( :, 1,12,12) = (/&
&5.9065E-01_JPRB,5.1684E-01_JPRB,4.4304E-01_JPRB,3.6914E-01_JPRB,2.9536E-01_JPRB,2.2452E-01_JPRB,&
&1.5812E-01_JPRB,5.9065E-01_JPRB,7.0088E-01_JPRB/)
KAO( :, 2,12,12) = (/&
&5.8872E-01_JPRB,5.1516E-01_JPRB,4.4157E-01_JPRB,3.6818E-01_JPRB,3.0050E-01_JPRB,2.3470E-01_JPRB,&
&1.6533E-01_JPRB,5.8872E-01_JPRB,6.8724E-01_JPRB/)
KAO( :, 3,12,12) = (/&
&5.8657E-01_JPRB,5.1328E-01_JPRB,4.4183E-01_JPRB,3.7357E-01_JPRB,3.0883E-01_JPRB,2.4369E-01_JPRB,&
&1.7720E-01_JPRB,5.8657E-01_JPRB,6.7692E-01_JPRB/)
KAO( :, 4,12,12) = (/&
&5.8202E-01_JPRB,5.0954E-01_JPRB,4.4287E-01_JPRB,3.7996E-01_JPRB,3.1901E-01_JPRB,2.5355E-01_JPRB,&
&1.9754E-01_JPRB,5.8202E-01_JPRB,6.8063E-01_JPRB/)
KAO( :, 5,12,12) = (/&
&5.7488E-01_JPRB,5.0736E-01_JPRB,4.4448E-01_JPRB,3.8734E-01_JPRB,3.2636E-01_JPRB,2.7530E-01_JPRB,&
&2.2896E-01_JPRB,5.7488E-01_JPRB,6.8864E-01_JPRB/)
KAO( :, 1,13,12) = (/&
&6.3330E-01_JPRB,5.5414E-01_JPRB,4.7500E-01_JPRB,3.9585E-01_JPRB,3.1697E-01_JPRB,2.4329E-01_JPRB,&
&1.7024E-01_JPRB,6.3330E-01_JPRB,9.6193E-01_JPRB/)
KAO( :, 2,13,12) = (/&
&6.3223E-01_JPRB,5.5319E-01_JPRB,4.7424E-01_JPRB,3.9638E-01_JPRB,3.2473E-01_JPRB,2.5152E-01_JPRB,&
&1.7599E-01_JPRB,6.3223E-01_JPRB,9.4444E-01_JPRB/)
KAO( :, 3,13,12) = (/&
&6.2744E-01_JPRB,5.4905E-01_JPRB,4.7373E-01_JPRB,4.0076E-01_JPRB,3.3050E-01_JPRB,2.6025E-01_JPRB,&
&1.8993E-01_JPRB,6.2744E-01_JPRB,9.2859E-01_JPRB/)
KAO( :, 4,13,12) = (/&
&6.2161E-01_JPRB,5.4502E-01_JPRB,4.7279E-01_JPRB,4.0774E-01_JPRB,3.3922E-01_JPRB,2.7164E-01_JPRB,&
&2.1216E-01_JPRB,6.2161E-01_JPRB,9.1983E-01_JPRB/)
KAO( :, 5,13,12) = (/&
&6.1416E-01_JPRB,5.4190E-01_JPRB,4.7545E-01_JPRB,4.1094E-01_JPRB,3.4988E-01_JPRB,2.9767E-01_JPRB,&
&2.4315E-01_JPRB,6.1416E-01_JPRB,9.2076E-01_JPRB/)
KAO( :, 1, 1,13) = (/&
&5.6801E-01_JPRB,4.9753E-01_JPRB,4.2614E-01_JPRB,3.5562E-01_JPRB,2.9784E-01_JPRB,2.3762E-01_JPRB,&
&1.7067E-01_JPRB,5.6801E-01_JPRB,2.8847E-01_JPRB/)
KAO( :, 2, 1,13) = (/&
&5.4506E-01_JPRB,4.7713E-01_JPRB,4.0945E-01_JPRB,3.5614E-01_JPRB,2.9906E-01_JPRB,2.3687E-01_JPRB,&
&2.1806E-01_JPRB,5.4506E-01_JPRB,3.9566E-01_JPRB/)
KAO( :, 3, 1,13) = (/&
&5.2208E-01_JPRB,4.5704E-01_JPRB,4.0103E-01_JPRB,3.5099E-01_JPRB,2.9640E-01_JPRB,2.7382E-01_JPRB,&
&2.9611E-01_JPRB,5.2208E-01_JPRB,5.3813E-01_JPRB/)
KAO( :, 4, 1,13) = (/&
&5.0009E-01_JPRB,4.3777E-01_JPRB,3.9424E-01_JPRB,3.4743E-01_JPRB,3.1380E-01_JPRB,3.5655E-01_JPRB,&
&3.8844E-01_JPRB,5.0009E-01_JPRB,7.1248E-01_JPRB/)
KAO( :, 5, 1,13) = (/&
&4.7842E-01_JPRB,4.2067E-01_JPRB,3.8681E-01_JPRB,3.4438E-01_JPRB,3.8224E-01_JPRB,4.4874E-01_JPRB,&
&4.9670E-01_JPRB,4.7842E-01_JPRB,9.2069E-01_JPRB/)
KAO( :, 1, 2,13) = (/&
&5.8929E-01_JPRB,5.1576E-01_JPRB,4.4253E-01_JPRB,3.6899E-01_JPRB,3.0866E-01_JPRB,2.4593E-01_JPRB,&
&1.7419E-01_JPRB,5.8929E-01_JPRB,2.7016E-01_JPRB/)
KAO( :, 2, 2,13) = (/&
&5.6495E-01_JPRB,4.9446E-01_JPRB,4.2405E-01_JPRB,3.6956E-01_JPRB,3.0941E-01_JPRB,2.4584E-01_JPRB,&
&2.0900E-01_JPRB,5.6495E-01_JPRB,3.6136E-01_JPRB/)
KAO( :, 3, 2,13) = (/&
&5.4068E-01_JPRB,4.7328E-01_JPRB,4.1750E-01_JPRB,3.6380E-01_JPRB,3.0869E-01_JPRB,2.6782E-01_JPRB,&
&2.8845E-01_JPRB,5.4068E-01_JPRB,4.8684E-01_JPRB/)
KAO( :, 4, 2,13) = (/&
&5.1706E-01_JPRB,4.5259E-01_JPRB,4.0848E-01_JPRB,3.6075E-01_JPRB,3.1658E-01_JPRB,3.4323E-01_JPRB,&
&3.8025E-01_JPRB,5.1706E-01_JPRB,6.5346E-01_JPRB/)
KAO( :, 5, 2,13) = (/&
&4.9404E-01_JPRB,4.3831E-01_JPRB,4.0091E-01_JPRB,3.5604E-01_JPRB,3.7274E-01_JPRB,4.3563E-01_JPRB,&
&4.8657E-01_JPRB,4.9404E-01_JPRB,8.5443E-01_JPRB/)
KAO( :, 1, 3,13) = (/&
&6.1460E-01_JPRB,5.3792E-01_JPRB,4.6119E-01_JPRB,3.8446E-01_JPRB,3.1580E-01_JPRB,2.5245E-01_JPRB,&
&1.8069E-01_JPRB,6.1460E-01_JPRB,2.4476E-01_JPRB/)
KAO( :, 2, 3,13) = (/&
&5.8902E-01_JPRB,5.1550E-01_JPRB,4.4201E-01_JPRB,3.8201E-01_JPRB,3.1981E-01_JPRB,2.5246E-01_JPRB,&
&1.9290E-01_JPRB,5.8902E-01_JPRB,3.2384E-01_JPRB/)
KAO( :, 3, 3,13) = (/&
&5.6359E-01_JPRB,4.9325E-01_JPRB,4.3340E-01_JPRB,3.7717E-01_JPRB,3.1924E-01_JPRB,2.6085E-01_JPRB,&
&2.6060E-01_JPRB,5.6359E-01_JPRB,4.2953E-01_JPRB/)
KAO( :, 4, 3,13) = (/&
&5.3858E-01_JPRB,4.7139E-01_JPRB,4.2433E-01_JPRB,3.7392E-01_JPRB,3.2043E-01_JPRB,3.1006E-01_JPRB,&
&3.4867E-01_JPRB,5.3858E-01_JPRB,5.6773E-01_JPRB/)
KAO( :, 5, 3,13) = (/&
&5.1490E-01_JPRB,4.5696E-01_JPRB,4.1592E-01_JPRB,3.6991E-01_JPRB,3.4822E-01_JPRB,4.0122E-01_JPRB,&
&4.5118E-01_JPRB,5.1490E-01_JPRB,7.4387E-01_JPRB/)
KAO( :, 1, 4,13) = (/&
&6.4145E-01_JPRB,5.6134E-01_JPRB,4.8123E-01_JPRB,4.0119E-01_JPRB,3.2332E-01_JPRB,2.5778E-01_JPRB,&
&1.8494E-01_JPRB,6.4145E-01_JPRB,2.1630E-01_JPRB/)
KAO( :, 2, 4,13) = (/&
&6.1419E-01_JPRB,5.3750E-01_JPRB,4.6079E-01_JPRB,3.9241E-01_JPRB,3.2922E-01_JPRB,2.5906E-01_JPRB,&
&1.8892E-01_JPRB,6.1419E-01_JPRB,2.9208E-01_JPRB/)
KAO( :, 3, 4,13) = (/&
&5.8813E-01_JPRB,5.1468E-01_JPRB,4.4799E-01_JPRB,3.9004E-01_JPRB,3.2671E-01_JPRB,2.6510E-01_JPRB,&
&2.2685E-01_JPRB,5.8813E-01_JPRB,3.9137E-01_JPRB/)
KAO( :, 4, 4,13) = (/&
&5.6273E-01_JPRB,4.9248E-01_JPRB,4.4059E-01_JPRB,3.8556E-01_JPRB,3.3060E-01_JPRB,2.8625E-01_JPRB,&
&3.0760E-01_JPRB,5.6273E-01_JPRB,5.0589E-01_JPRB/)
KAO( :, 5, 4,13) = (/&
&5.3804E-01_JPRB,4.7588E-01_JPRB,4.3067E-01_JPRB,3.8369E-01_JPRB,3.3395E-01_JPRB,3.5921E-01_JPRB,&
&4.0495E-01_JPRB,5.3804E-01_JPRB,6.5237E-01_JPRB/)
KAO( :, 1, 5,13) = (/&
&6.6759E-01_JPRB,5.8420E-01_JPRB,5.0082E-01_JPRB,4.1745E-01_JPRB,3.3417E-01_JPRB,2.6101E-01_JPRB,&
&1.8769E-01_JPRB,6.6759E-01_JPRB,1.9371E-01_JPRB/)
KAO( :, 2, 5,13) = (/&
&6.3993E-01_JPRB,5.5998E-01_JPRB,4.8009E-01_JPRB,4.0342E-01_JPRB,3.3762E-01_JPRB,2.6493E-01_JPRB,&
&1.8973E-01_JPRB,6.3993E-01_JPRB,2.6409E-01_JPRB/)
KAO( :, 3, 5,13) = (/&
&6.1332E-01_JPRB,5.3667E-01_JPRB,4.6314E-01_JPRB,4.0266E-01_JPRB,3.3397E-01_JPRB,2.6941E-01_JPRB,&
&2.0819E-01_JPRB,6.1332E-01_JPRB,3.5928E-01_JPRB/)
KAO( :, 4, 5,13) = (/&
&5.8743E-01_JPRB,5.1406E-01_JPRB,4.5644E-01_JPRB,3.9637E-01_JPRB,3.3947E-01_JPRB,2.7620E-01_JPRB,&
&2.6432E-01_JPRB,5.8743E-01_JPRB,4.7554E-01_JPRB/)
KAO( :, 5, 5,13) = (/&
&5.6212E-01_JPRB,4.9526E-01_JPRB,4.4574E-01_JPRB,3.9617E-01_JPRB,3.3572E-01_JPRB,3.1407E-01_JPRB,&
&3.5828E-01_JPRB,5.6212E-01_JPRB,6.0837E-01_JPRB/)
KAO( :, 1, 6,13) = (/&
&6.9473E-01_JPRB,6.0793E-01_JPRB,5.2119E-01_JPRB,4.3440E-01_JPRB,3.4764E-01_JPRB,2.6336E-01_JPRB,&
&1.8896E-01_JPRB,6.9473E-01_JPRB,1.7250E-01_JPRB/)
KAO( :, 2, 6,13) = (/&
&6.6721E-01_JPRB,5.8382E-01_JPRB,5.0053E-01_JPRB,4.1719E-01_JPRB,3.4561E-01_JPRB,2.7121E-01_JPRB,&
&1.9177E-01_JPRB,6.6721E-01_JPRB,2.4044E-01_JPRB/)
KAO( :, 3, 6,13) = (/&
&6.4000E-01_JPRB,5.6004E-01_JPRB,4.8024E-01_JPRB,4.1554E-01_JPRB,3.4402E-01_JPRB,2.7206E-01_JPRB,&
&2.0202E-01_JPRB,6.4000E-01_JPRB,3.3099E-01_JPRB/)
KAO( :, 4, 6,13) = (/&
&6.1394E-01_JPRB,5.3727E-01_JPRB,4.7423E-01_JPRB,4.0811E-01_JPRB,3.4656E-01_JPRB,2.7984E-01_JPRB,&
&2.2944E-01_JPRB,6.1394E-01_JPRB,4.4214E-01_JPRB/)
KAO( :, 5, 6,13) = (/&
&5.9084E-01_JPRB,5.1879E-01_JPRB,4.6252E-01_JPRB,4.0758E-01_JPRB,3.4602E-01_JPRB,2.8751E-01_JPRB,&
&3.0432E-01_JPRB,5.9084E-01_JPRB,5.7787E-01_JPRB/)
KAO( :, 1, 7,13) = (/&
&7.2249E-01_JPRB,6.3225E-01_JPRB,5.4192E-01_JPRB,4.5166E-01_JPRB,3.6141E-01_JPRB,2.7115E-01_JPRB,&
&1.8926E-01_JPRB,7.2249E-01_JPRB,1.4840E-01_JPRB/)
KAO( :, 2, 7,13) = (/&
&6.9569E-01_JPRB,6.0876E-01_JPRB,5.2183E-01_JPRB,4.3493E-01_JPRB,3.5253E-01_JPRB,2.7700E-01_JPRB,&
&1.9463E-01_JPRB,6.9569E-01_JPRB,2.1366E-01_JPRB/)
KAO( :, 3, 7,13) = (/&
&6.7030E-01_JPRB,5.8656E-01_JPRB,5.0282E-01_JPRB,4.3054E-01_JPRB,3.5472E-01_JPRB,2.7582E-01_JPRB,&
&2.0558E-01_JPRB,6.7030E-01_JPRB,3.0169E-01_JPRB/)
KAO( :, 4, 7,13) = (/&
&6.4750E-01_JPRB,5.6659E-01_JPRB,4.9555E-01_JPRB,4.2297E-01_JPRB,3.5382E-01_JPRB,2.8571E-01_JPRB,&
&2.1673E-01_JPRB,6.4750E-01_JPRB,4.1281E-01_JPRB/)
KAO( :, 5, 7,13) = (/&
&6.2512E-01_JPRB,5.4760E-01_JPRB,4.8374E-01_JPRB,4.2116E-01_JPRB,3.5619E-01_JPRB,2.8468E-01_JPRB,&
&2.6466E-01_JPRB,6.2512E-01_JPRB,5.4714E-01_JPRB/)
KAO( :, 1, 8,13) = (/&
&7.5294E-01_JPRB,6.5887E-01_JPRB,5.6474E-01_JPRB,4.7064E-01_JPRB,3.7654E-01_JPRB,2.8248E-01_JPRB,&
&1.8974E-01_JPRB,7.5294E-01_JPRB,1.2274E-01_JPRB/)
KAO( :, 2, 8,13) = (/&
&7.2891E-01_JPRB,6.3781E-01_JPRB,5.4671E-01_JPRB,4.5563E-01_JPRB,3.6498E-01_JPRB,2.8342E-01_JPRB,&
&1.9844E-01_JPRB,7.2891E-01_JPRB,1.8310E-01_JPRB/)
KAO( :, 3, 8,13) = (/&
&7.0557E-01_JPRB,6.1744E-01_JPRB,5.2928E-01_JPRB,4.4666E-01_JPRB,3.6716E-01_JPRB,2.8351E-01_JPRB,&
&2.0879E-01_JPRB,7.0557E-01_JPRB,2.6614E-01_JPRB/)
KAO( :, 4, 8,13) = (/&
&6.8244E-01_JPRB,5.9719E-01_JPRB,5.1867E-01_JPRB,4.4210E-01_JPRB,3.6383E-01_JPRB,2.9223E-01_JPRB,&
&2.1877E-01_JPRB,6.8244E-01_JPRB,3.7635E-01_JPRB/)
KAO( :, 5, 8,13) = (/&
&6.6089E-01_JPRB,5.7833E-01_JPRB,5.0944E-01_JPRB,4.4005E-01_JPRB,3.6857E-01_JPRB,2.9676E-01_JPRB,&
&2.4160E-01_JPRB,6.6089E-01_JPRB,5.0930E-01_JPRB/)
KAO( :, 1, 9,13) = (/&
&7.8582E-01_JPRB,6.8762E-01_JPRB,5.8934E-01_JPRB,4.9123E-01_JPRB,3.9298E-01_JPRB,2.9487E-01_JPRB,&
&1.9668E-01_JPRB,7.8582E-01_JPRB,9.8816E-02_JPRB/)
KAO( :, 2, 9,13) = (/&
&7.6340E-01_JPRB,6.6798E-01_JPRB,5.7260E-01_JPRB,4.7718E-01_JPRB,3.8186E-01_JPRB,2.8922E-01_JPRB,&
&2.0391E-01_JPRB,7.6340E-01_JPRB,1.5257E-01_JPRB/)
KAO( :, 3, 9,13) = (/&
&7.4083E-01_JPRB,6.4825E-01_JPRB,5.5561E-01_JPRB,4.6459E-01_JPRB,3.8180E-01_JPRB,2.9456E-01_JPRB,&
&2.1305E-01_JPRB,7.4083E-01_JPRB,2.2771E-01_JPRB/)
KAO( :, 4, 9,13) = (/&
&7.2071E-01_JPRB,6.3065E-01_JPRB,5.4414E-01_JPRB,4.6459E-01_JPRB,3.7956E-01_JPRB,3.0226E-01_JPRB,&
&2.2460E-01_JPRB,7.2071E-01_JPRB,3.3060E-01_JPRB/)
KAO( :, 5, 9,13) = (/&
&7.0101E-01_JPRB,6.1340E-01_JPRB,5.3848E-01_JPRB,4.5996E-01_JPRB,3.8516E-01_JPRB,3.1030E-01_JPRB,&
&2.3292E-01_JPRB,7.0101E-01_JPRB,4.5916E-01_JPRB/)
KAO( :, 1,10,13) = (/&
&8.1699E-01_JPRB,7.1490E-01_JPRB,6.1279E-01_JPRB,5.1070E-01_JPRB,4.0862E-01_JPRB,3.0651E-01_JPRB,&
&2.0447E-01_JPRB,8.1699E-01_JPRB,2.0223E-01_JPRB/)
KAO( :, 2,10,13) = (/&
&7.9680E-01_JPRB,6.9725E-01_JPRB,5.9768E-01_JPRB,4.9808E-01_JPRB,3.9857E-01_JPRB,2.9954E-01_JPRB,&
&2.1116E-01_JPRB,7.9680E-01_JPRB,2.1512E-01_JPRB/)
KAO( :, 3,10,13) = (/&
&7.7769E-01_JPRB,6.8054E-01_JPRB,5.8332E-01_JPRB,4.8646E-01_JPRB,3.9735E-01_JPRB,3.0638E-01_JPRB,&
&2.2182E-01_JPRB,7.7769E-01_JPRB,2.3973E-01_JPRB/)
KAO( :, 4,10,13) = (/&
&7.5760E-01_JPRB,6.6294E-01_JPRB,5.6993E-01_JPRB,4.8571E-01_JPRB,3.9617E-01_JPRB,3.1482E-01_JPRB,&
&2.3294E-01_JPRB,7.5760E-01_JPRB,3.0285E-01_JPRB/)
KAO( :, 5,10,13) = (/&
&7.3618E-01_JPRB,6.4414E-01_JPRB,5.6442E-01_JPRB,4.8052E-01_JPRB,4.0378E-01_JPRB,3.2545E-01_JPRB,&
&2.3666E-01_JPRB,7.3618E-01_JPRB,4.1601E-01_JPRB/)
KAO( :, 1,11,13) = (/&
&8.3942E-01_JPRB,7.3450E-01_JPRB,6.2963E-01_JPRB,5.2471E-01_JPRB,4.1987E-01_JPRB,3.1499E-01_JPRB,&
&2.1173E-01_JPRB,8.3942E-01_JPRB,5.1704E-01_JPRB/)
KAO( :, 2,11,13) = (/&
&8.2051E-01_JPRB,7.1798E-01_JPRB,6.1544E-01_JPRB,5.1289E-01_JPRB,4.1041E-01_JPRB,3.1180E-01_JPRB,&
&2.2477E-01_JPRB,8.2051E-01_JPRB,5.0715E-01_JPRB/)
KAO( :, 3,11,13) = (/&
&8.0104E-01_JPRB,7.0099E-01_JPRB,6.0089E-01_JPRB,5.0362E-01_JPRB,4.1222E-01_JPRB,3.2198E-01_JPRB,&
&2.3377E-01_JPRB,8.0104E-01_JPRB,5.0602E-01_JPRB/)
KAO( :, 4,11,13) = (/&
&7.7897E-01_JPRB,6.8168E-01_JPRB,5.9030E-01_JPRB,5.0190E-01_JPRB,4.1316E-01_JPRB,3.3484E-01_JPRB,&
&2.4521E-01_JPRB,7.7897E-01_JPRB,5.2719E-01_JPRB/)
KAO( :, 5,11,13) = (/&
&7.5657E-01_JPRB,6.6294E-01_JPRB,5.8168E-01_JPRB,4.9940E-01_JPRB,4.2397E-01_JPRB,3.4229E-01_JPRB,&
&2.5422E-01_JPRB,7.5657E-01_JPRB,5.6893E-01_JPRB/)
KAO( :, 1,12,13) = (/&
&8.6084E-01_JPRB,7.5332E-01_JPRB,6.4569E-01_JPRB,5.3811E-01_JPRB,4.3054E-01_JPRB,3.2302E-01_JPRB,&
&2.2089E-01_JPRB,8.6084E-01_JPRB,8.5915E-01_JPRB/)
KAO( :, 2,12,13) = (/&
&8.4383E-01_JPRB,7.3849E-01_JPRB,6.3296E-01_JPRB,5.2757E-01_JPRB,4.2272E-01_JPRB,3.2652E-01_JPRB,&
&2.3662E-01_JPRB,8.4383E-01_JPRB,8.4258E-01_JPRB/)
KAO( :, 3,12,13) = (/&
&8.2461E-01_JPRB,7.2162E-01_JPRB,6.1861E-01_JPRB,5.2173E-01_JPRB,4.2609E-01_JPRB,3.3651E-01_JPRB,&
&2.4602E-01_JPRB,8.2461E-01_JPRB,8.2424E-01_JPRB/)
KAO( :, 4,12,13) = (/&
&8.0362E-01_JPRB,7.0330E-01_JPRB,6.1076E-01_JPRB,5.1642E-01_JPRB,4.3196E-01_JPRB,3.5024E-01_JPRB,&
&2.5788E-01_JPRB,8.0362E-01_JPRB,8.1526E-01_JPRB/)
KAO( :, 5,12,13) = (/&
&7.8196E-01_JPRB,6.8686E-01_JPRB,5.9993E-01_JPRB,5.1915E-01_JPRB,4.4219E-01_JPRB,3.5857E-01_JPRB,&
&2.8318E-01_JPRB,7.8196E-01_JPRB,8.4417E-01_JPRB/)
KAO( :, 1,13,13) = (/&
&8.9885E-01_JPRB,7.8652E-01_JPRB,6.7417E-01_JPRB,5.6190E-01_JPRB,4.4957E-01_JPRB,3.3736E-01_JPRB,&
&2.3468E-01_JPRB,8.9885E-01_JPRB,1.1747E+00_JPRB/)
KAO( :, 2,13,13) = (/&
&8.8176E-01_JPRB,7.7157E-01_JPRB,6.6138E-01_JPRB,5.5126E-01_JPRB,4.4334E-01_JPRB,3.4503E-01_JPRB,&
&2.4591E-01_JPRB,8.8176E-01_JPRB,1.1474E+00_JPRB/)
KAO( :, 3,13,13) = (/&
&8.6445E-01_JPRB,7.5644E-01_JPRB,6.4871E-01_JPRB,5.4797E-01_JPRB,4.4798E-01_JPRB,3.5260E-01_JPRB,&
&2.5729E-01_JPRB,8.6445E-01_JPRB,1.1167E+00_JPRB/)
KAO( :, 4,13,13) = (/&
&8.4531E-01_JPRB,7.3968E-01_JPRB,6.4228E-01_JPRB,5.4288E-01_JPRB,4.5703E-01_JPRB,3.6588E-01_JPRB,&
&2.7546E-01_JPRB,8.4531E-01_JPRB,1.0937E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&8.2636E-01_JPRB,7.2791E-01_JPRB,6.3427E-01_JPRB,5.5035E-01_JPRB,4.6456E-01_JPRB,3.8210E-01_JPRB,&
&3.1914E-01_JPRB,8.2636E-01_JPRB,1.1091E+00_JPRB/)
KAO( :, 1, 1,14) = (/&
&6.4697E-01_JPRB,5.6581E-01_JPRB,4.8619E-01_JPRB,4.0514E-01_JPRB,3.2628E-01_JPRB,2.6560E-01_JPRB,&
&2.6000E-01_JPRB,6.4697E-01_JPRB,5.4302E-01_JPRB/)
KAO( :, 2, 1,14) = (/&
&6.1615E-01_JPRB,5.3934E-01_JPRB,4.6216E-01_JPRB,3.9067E-01_JPRB,3.3456E-01_JPRB,3.3408E-01_JPRB,&
&3.5677E-01_JPRB,6.1615E-01_JPRB,7.5638E-01_JPRB/)
KAO( :, 3, 1,14) = (/&
&5.8533E-01_JPRB,5.1238E-01_JPRB,4.4004E-01_JPRB,3.8617E-01_JPRB,3.9537E-01_JPRB,4.4466E-01_JPRB,&
&4.7278E-01_JPRB,5.8533E-01_JPRB,1.0166E+00_JPRB/)
KAO( :, 4, 1,14) = (/&
&5.5669E-01_JPRB,4.8735E-01_JPRB,4.2781E-01_JPRB,4.2678E-01_JPRB,5.1253E-01_JPRB,5.7332E-01_JPRB,&
&6.0788E-01_JPRB,5.5669E-01_JPRB,1.3240E+00_JPRB/)
KAO( :, 5, 1,14) = (/&
&5.2879E-01_JPRB,4.6247E-01_JPRB,4.2802E-01_JPRB,5.3254E-01_JPRB,6.4936E-01_JPRB,7.2566E-01_JPRB,&
&7.6206E-01_JPRB,5.2879E-01_JPRB,1.6773E+00_JPRB/)
KAO( :, 1, 2,14) = (/&
&6.8303E-01_JPRB,5.9781E-01_JPRB,5.1220E-01_JPRB,4.2706E-01_JPRB,3.4379E-01_JPRB,2.7382E-01_JPRB,&
&2.5162E-01_JPRB,6.8303E-01_JPRB,5.1036E-01_JPRB/)
KAO( :, 2, 2,14) = (/&
&6.4954E-01_JPRB,5.6917E-01_JPRB,4.8810E-01_JPRB,4.1304E-01_JPRB,3.4632E-01_JPRB,3.2639E-01_JPRB,&
&3.5170E-01_JPRB,6.4954E-01_JPRB,7.2343E-01_JPRB/)
KAO( :, 3, 2,14) = (/&
&6.1641E-01_JPRB,5.3958E-01_JPRB,4.6497E-01_JPRB,4.0263E-01_JPRB,3.9007E-01_JPRB,4.3907E-01_JPRB,&
&4.7004E-01_JPRB,6.1641E-01_JPRB,9.8553E-01_JPRB/)
KAO( :, 4, 2,14) = (/&
&5.8470E-01_JPRB,5.1185E-01_JPRB,4.4927E-01_JPRB,4.3064E-01_JPRB,5.0846E-01_JPRB,5.7765E-01_JPRB,&
&6.1669E-01_JPRB,5.8470E-01_JPRB,1.2985E+00_JPRB/)
KAO( :, 5, 2,14) = (/&
&5.5467E-01_JPRB,4.8565E-01_JPRB,4.4367E-01_JPRB,5.2819E-01_JPRB,6.4947E-01_JPRB,7.3873E-01_JPRB,&
&7.8515E-01_JPRB,5.5467E-01_JPRB,1.6649E+00_JPRB/)
KAO( :, 1, 3,14) = (/&
&7.2604E-01_JPRB,6.3550E-01_JPRB,5.4494E-01_JPRB,4.5437E-01_JPRB,3.6385E-01_JPRB,2.8334E-01_JPRB,&
&2.2702E-01_JPRB,7.2604E-01_JPRB,4.3950E-01_JPRB/)
KAO( :, 2, 3,14) = (/&
&6.8954E-01_JPRB,6.0362E-01_JPRB,5.1760E-01_JPRB,4.3356E-01_JPRB,3.5873E-01_JPRB,3.0878E-01_JPRB,&
&3.1582E-01_JPRB,6.8954E-01_JPRB,6.3380E-01_JPRB/)
KAO( :, 3, 3,14) = (/&
&6.5385E-01_JPRB,5.7238E-01_JPRB,4.9126E-01_JPRB,4.2254E-01_JPRB,3.7557E-01_JPRB,4.0304E-01_JPRB,&
&4.3683E-01_JPRB,6.5385E-01_JPRB,8.8264E-01_JPRB/)
KAO( :, 4, 3,14) = (/&
&6.1901E-01_JPRB,5.4191E-01_JPRB,4.7603E-01_JPRB,4.2566E-01_JPRB,4.6990E-01_JPRB,5.3966E-01_JPRB,&
&5.8392E-01_JPRB,6.1901E-01_JPRB,1.1869E+00_JPRB/)
KAO( :, 5, 3,14) = (/&
&5.8653E-01_JPRB,5.1354E-01_JPRB,4.5882E-01_JPRB,4.9733E-01_JPRB,6.1274E-01_JPRB,7.0260E-01_JPRB,&
&7.5851E-01_JPRB,5.8653E-01_JPRB,1.5549E+00_JPRB/)
KAO( :, 1, 4,14) = (/&
&7.7382E-01_JPRB,6.7722E-01_JPRB,5.8077E-01_JPRB,4.8422E-01_JPRB,3.8766E-01_JPRB,2.9794E-01_JPRB,&
&2.1506E-01_JPRB,7.7382E-01_JPRB,3.8561E-01_JPRB/)
KAO( :, 2, 4,14) = (/&
&7.3238E-01_JPRB,6.4104E-01_JPRB,5.4969E-01_JPRB,4.5833E-01_JPRB,3.7818E-01_JPRB,3.0063E-01_JPRB,&
&2.7269E-01_JPRB,7.3238E-01_JPRB,5.4567E-01_JPRB/)
KAO( :, 3, 4,14) = (/&
&6.9409E-01_JPRB,6.0760E-01_JPRB,5.2105E-01_JPRB,4.4727E-01_JPRB,3.7346E-01_JPRB,3.5556E-01_JPRB,&
&3.8970E-01_JPRB,6.9409E-01_JPRB,7.5575E-01_JPRB/)
KAO( :, 4, 4,14) = (/&
&6.5680E-01_JPRB,5.7500E-01_JPRB,5.0421E-01_JPRB,4.3210E-01_JPRB,4.2750E-01_JPRB,4.8792E-01_JPRB,&
&5.3313E-01_JPRB,6.5680E-01_JPRB,1.0436E+00_JPRB/)
KAO( :, 5, 4,14) = (/&
&6.2089E-01_JPRB,5.4362E-01_JPRB,4.8130E-01_JPRB,4.7140E-01_JPRB,5.6311E-01_JPRB,6.4743E-01_JPRB,&
&7.0793E-01_JPRB,6.2089E-01_JPRB,1.3960E+00_JPRB/)
KAO( :, 1, 5,14) = (/&
&8.2229E-01_JPRB,7.1962E-01_JPRB,6.1700E-01_JPRB,5.1439E-01_JPRB,4.1134E-01_JPRB,3.0886E-01_JPRB,&
&2.1652E-01_JPRB,8.2229E-01_JPRB,3.4617E-01_JPRB/)
KAO( :, 2, 5,14) = (/&
&7.7737E-01_JPRB,6.8035E-01_JPRB,5.8334E-01_JPRB,4.8633E-01_JPRB,3.9777E-01_JPRB,3.0668E-01_JPRB,&
&2.4242E-01_JPRB,7.7737E-01_JPRB,4.8134E-01_JPRB/)
KAO( :, 3, 5,14) = (/&
&7.3545E-01_JPRB,6.4364E-01_JPRB,5.5194E-01_JPRB,4.7124E-01_JPRB,3.8457E-01_JPRB,3.2665E-01_JPRB,&
&3.3917E-01_JPRB,7.3545E-01_JPRB,6.5879E-01_JPRB/)
KAO( :, 4, 5,14) = (/&
&6.9572E-01_JPRB,6.0902E-01_JPRB,5.3204E-01_JPRB,4.5117E-01_JPRB,4.0273E-01_JPRB,4.3738E-01_JPRB,&
&4.7818E-01_JPRB,6.9572E-01_JPRB,9.0069E-01_JPRB/)
KAO( :, 5, 5,14) = (/&
&6.5745E-01_JPRB,5.7553E-01_JPRB,5.0705E-01_JPRB,4.6147E-01_JPRB,5.1159E-01_JPRB,5.9239E-01_JPRB,&
&6.4809E-01_JPRB,6.5745E-01_JPRB,1.2234E+00_JPRB/)
KAO( :, 1, 6,14) = (/&
&8.7308E-01_JPRB,7.6408E-01_JPRB,6.5505E-01_JPRB,5.4604E-01_JPRB,4.3705E-01_JPRB,3.2789E-01_JPRB,&
&2.2557E-01_JPRB,8.7308E-01_JPRB,2.9961E-01_JPRB/)
KAO( :, 2, 6,14) = (/&
&8.2540E-01_JPRB,7.2233E-01_JPRB,6.1930E-01_JPRB,5.1628E-01_JPRB,4.1422E-01_JPRB,3.2146E-01_JPRB,&
&2.2994E-01_JPRB,8.2540E-01_JPRB,4.2262E-01_JPRB/)
KAO( :, 3, 6,14) = (/&
&7.7924E-01_JPRB,6.8203E-01_JPRB,5.8479E-01_JPRB,4.9474E-01_JPRB,4.0395E-01_JPRB,3.1715E-01_JPRB,&
&2.8904E-01_JPRB,7.7924E-01_JPRB,5.7314E-01_JPRB/)
KAO( :, 4, 6,14) = (/&
&7.3709E-01_JPRB,6.4513E-01_JPRB,5.5979E-01_JPRB,4.7521E-01_JPRB,3.9636E-01_JPRB,3.8185E-01_JPRB,&
&4.1862E-01_JPRB,7.3709E-01_JPRB,7.8091E-01_JPRB/)
KAO( :, 5, 6,14) = (/&
&6.9621E-01_JPRB,6.0938E-01_JPRB,5.3478E-01_JPRB,4.6425E-01_JPRB,4.6297E-01_JPRB,5.2802E-01_JPRB,&
&5.8170E-01_JPRB,6.9621E-01_JPRB,1.0527E+00_JPRB/)
KAO( :, 1, 7,14) = (/&
&9.2395E-01_JPRB,8.0850E-01_JPRB,6.9306E-01_JPRB,5.7769E-01_JPRB,4.6224E-01_JPRB,3.4691E-01_JPRB,&
&2.3084E-01_JPRB,9.2395E-01_JPRB,2.5497E-01_JPRB/)
KAO( :, 2, 7,14) = (/&
&8.7317E-01_JPRB,7.6415E-01_JPRB,6.5513E-01_JPRB,5.4606E-01_JPRB,4.3714E-01_JPRB,3.3528E-01_JPRB,&
&2.3202E-01_JPRB,8.7317E-01_JPRB,3.7202E-01_JPRB/)
KAO( :, 3, 7,14) = (/&
&8.2438E-01_JPRB,7.2141E-01_JPRB,6.1853E-01_JPRB,5.1767E-01_JPRB,4.2475E-01_JPRB,3.2596E-01_JPRB,&
&2.5061E-01_JPRB,8.2438E-01_JPRB,5.0761E-01_JPRB/)
KAO( :, 4, 7,14) = (/&
&7.7804E-01_JPRB,6.8094E-01_JPRB,5.8814E-01_JPRB,5.0039E-01_JPRB,4.0791E-01_JPRB,3.4702E-01_JPRB,&
&3.6090E-01_JPRB,7.7804E-01_JPRB,6.8063E-01_JPRB/)
KAO( :, 5, 7,14) = (/&
&7.3636E-01_JPRB,6.4448E-01_JPRB,5.6430E-01_JPRB,4.8129E-01_JPRB,4.3569E-01_JPRB,4.6156E-01_JPRB,&
&5.1425E-01_JPRB,7.3636E-01_JPRB,9.1422E-01_JPRB/)
KAO( :, 1, 8,14) = (/&
&9.7397E-01_JPRB,8.5236E-01_JPRB,7.3070E-01_JPRB,6.0905E-01_JPRB,4.8737E-01_JPRB,3.6576E-01_JPRB,&
&2.4401E-01_JPRB,9.7397E-01_JPRB,2.1663E-01_JPRB/)
KAO( :, 2, 8,14) = (/&
&9.2100E-01_JPRB,8.0595E-01_JPRB,6.9096E-01_JPRB,5.7592E-01_JPRB,4.6092E-01_JPRB,3.4695E-01_JPRB,&
&2.4168E-01_JPRB,9.2100E-01_JPRB,3.2348E-01_JPRB/)
KAO( :, 3, 8,14) = (/&
&8.7221E-01_JPRB,7.6329E-01_JPRB,6.5435E-01_JPRB,5.4550E-01_JPRB,4.4631E-01_JPRB,3.4181E-01_JPRB,&
&2.3826E-01_JPRB,8.7221E-01_JPRB,4.5837E-01_JPRB/)
KAO( :, 4, 8,14) = (/&
&8.2606E-01_JPRB,7.2291E-01_JPRB,6.2015E-01_JPRB,5.2779E-01_JPRB,4.2860E-01_JPRB,3.3690E-01_JPRB,&
&3.1094E-01_JPRB,8.2606E-01_JPRB,6.1646E-01_JPRB/)
KAO( :, 5, 8,14) = (/&
&7.8339E-01_JPRB,6.8563E-01_JPRB,5.9715E-01_JPRB,5.0560E-01_JPRB,4.2904E-01_JPRB,4.0836E-01_JPRB,&
&4.4759E-01_JPRB,7.8339E-01_JPRB,8.2068E-01_JPRB/)
KAO( :, 1, 9,14) = (/&
&1.0301E+00_JPRB,9.0147E-01_JPRB,7.7271E-01_JPRB,6.4407E-01_JPRB,5.1534E-01_JPRB,3.8666E-01_JPRB,&
&2.5795E-01_JPRB,1.0301E+00_JPRB,1.8238E-01_JPRB/)
KAO( :, 2, 9,14) = (/&
&9.7820E-01_JPRB,8.5599E-01_JPRB,7.3388E-01_JPRB,6.1168E-01_JPRB,4.8943E-01_JPRB,3.6719E-01_JPRB,&
&2.5130E-01_JPRB,9.7820E-01_JPRB,2.7990E-01_JPRB/)
KAO( :, 3, 9,14) = (/&
&9.2786E-01_JPRB,8.1203E-01_JPRB,6.9612E-01_JPRB,5.8026E-01_JPRB,4.6878E-01_JPRB,3.5884E-01_JPRB,&
&2.4589E-01_JPRB,9.2786E-01_JPRB,4.0829E-01_JPRB/)
KAO( :, 4, 9,14) = (/&
&8.8063E-01_JPRB,7.7081E-01_JPRB,6.6089E-01_JPRB,5.5869E-01_JPRB,4.5326E-01_JPRB,3.4687E-01_JPRB,&
&2.8154E-01_JPRB,8.8063E-01_JPRB,5.6423E-01_JPRB/)
KAO( :, 5, 9,14) = (/&
&8.3750E-01_JPRB,7.3300E-01_JPRB,6.3612E-01_JPRB,5.3674E-01_JPRB,4.4242E-01_JPRB,3.8121E-01_JPRB,&
&3.9514E-01_JPRB,8.3750E-01_JPRB,7.6101E-01_JPRB/)
KAO( :, 1,10,14) = (/&
&1.0910E+00_JPRB,9.5477E-01_JPRB,8.1845E-01_JPRB,6.8213E-01_JPRB,5.4582E-01_JPRB,4.0946E-01_JPRB,&
&2.7317E-01_JPRB,1.0910E+00_JPRB,2.4894E-01_JPRB/)
KAO( :, 2,10,14) = (/&
&1.0359E+00_JPRB,9.0651E-01_JPRB,7.7708E-01_JPRB,6.4767E-01_JPRB,5.1833E-01_JPRB,3.8894E-01_JPRB,&
&2.6039E-01_JPRB,1.0359E+00_JPRB,2.7831E-01_JPRB/)
KAO( :, 3,10,14) = (/&
&9.8652E-01_JPRB,8.6341E-01_JPRB,7.4018E-01_JPRB,6.1698E-01_JPRB,4.9398E-01_JPRB,3.7879E-01_JPRB,&
&2.6008E-01_JPRB,9.8652E-01_JPRB,3.7798E-01_JPRB/)
KAO( :, 4,10,14) = (/&
&9.4211E-01_JPRB,8.2452E-01_JPRB,7.0695E-01_JPRB,5.9553E-01_JPRB,4.8274E-01_JPRB,3.6793E-01_JPRB,&
&2.7883E-01_JPRB,9.4211E-01_JPRB,5.3013E-01_JPRB/)
KAO( :, 5,10,14) = (/&
&9.0248E-01_JPRB,7.8992E-01_JPRB,6.8355E-01_JPRB,5.7648E-01_JPRB,4.7251E-01_JPRB,3.8441E-01_JPRB,&
&3.6799E-01_JPRB,9.0248E-01_JPRB,7.2595E-01_JPRB/)
KAO( :, 1,11,14) = (/&
&1.1319E+00_JPRB,9.9048E-01_JPRB,8.4899E-01_JPRB,7.0760E-01_JPRB,5.6613E-01_JPRB,4.2478E-01_JPRB,&
&2.8341E-01_JPRB,1.1319E+00_JPRB,6.1592E-01_JPRB/)
KAO( :, 2,11,14) = (/&
&1.0823E+00_JPRB,9.4725E-01_JPRB,8.1199E-01_JPRB,6.7675E-01_JPRB,5.4154E-01_JPRB,4.0630E-01_JPRB,&
&2.7609E-01_JPRB,1.0823E+00_JPRB,6.1773E-01_JPRB/)
KAO( :, 3,11,14) = (/&
&1.0367E+00_JPRB,9.0731E-01_JPRB,7.7783E-01_JPRB,6.4834E-01_JPRB,5.2311E-01_JPRB,3.9934E-01_JPRB,&
&2.8089E-01_JPRB,1.0367E+00_JPRB,6.2937E-01_JPRB/)
KAO( :, 4,11,14) = (/&
&9.9754E-01_JPRB,8.7303E-01_JPRB,7.4854E-01_JPRB,6.3329E-01_JPRB,5.1385E-01_JPRB,3.9730E-01_JPRB,&
&3.1217E-01_JPRB,9.9754E-01_JPRB,6.7492E-01_JPRB/)
KAO( :, 5,11,14) = (/&
&9.6377E-01_JPRB,8.4344E-01_JPRB,7.3462E-01_JPRB,6.2175E-01_JPRB,5.1718E-01_JPRB,4.2421E-01_JPRB,&
&3.9708E-01_JPRB,9.6377E-01_JPRB,8.2165E-01_JPRB/)
KAO( :, 1,12,14) = (/&
&1.1865E+00_JPRB,1.0383E+00_JPRB,8.9009E-01_JPRB,7.4185E-01_JPRB,5.9361E-01_JPRB,4.4539E-01_JPRB,&
&2.9703E-01_JPRB,1.1865E+00_JPRB,1.0367E+00_JPRB/)
KAO( :, 2,12,14) = (/&
&1.1417E+00_JPRB,9.9913E-01_JPRB,8.5647E-01_JPRB,7.1379E-01_JPRB,5.7124E-01_JPRB,4.2863E-01_JPRB,&
&2.9688E-01_JPRB,1.1417E+00_JPRB,1.0233E+00_JPRB/)
KAO( :, 3,12,14) = (/&
&1.1032E+00_JPRB,9.6547E-01_JPRB,8.2760E-01_JPRB,6.8985E-01_JPRB,5.6085E-01_JPRB,4.2892E-01_JPRB,&
&3.0866E-01_JPRB,1.1032E+00_JPRB,1.0143E+00_JPRB/)
KAO( :, 4,12,14) = (/&
&1.0706E+00_JPRB,9.3688E-01_JPRB,8.0548E-01_JPRB,6.8453E-01_JPRB,5.5710E-01_JPRB,4.4460E-01_JPRB,&
&3.4889E-01_JPRB,1.0706E+00_JPRB,1.0266E+00_JPRB/)
KAO( :, 5,12,14) = (/&
&1.0446E+00_JPRB,9.1422E-01_JPRB,8.0059E-01_JPRB,6.8230E-01_JPRB,5.7500E-01_JPRB,4.7448E-01_JPRB,&
&4.2513E-01_JPRB,1.0446E+00_JPRB,1.0801E+00_JPRB/)
KAO( :, 1,13,14) = (/&
&1.2550E+00_JPRB,1.0982E+00_JPRB,9.4143E-01_JPRB,7.8461E-01_JPRB,6.2776E-01_JPRB,4.7103E-01_JPRB,&
&3.1423E-01_JPRB,1.2550E+00_JPRB,1.4399E+00_JPRB/)
KAO( :, 2,13,14) = (/&
&1.2174E+00_JPRB,1.0653E+00_JPRB,9.1318E-01_JPRB,7.6114E-01_JPRB,6.0904E-01_JPRB,4.6025E-01_JPRB,&
&3.2716E-01_JPRB,1.2174E+00_JPRB,1.4068E+00_JPRB/)
KAO( :, 3,13,14) = (/&
&1.1864E+00_JPRB,1.0381E+00_JPRB,8.9001E-01_JPRB,7.4479E-01_JPRB,6.0816E-01_JPRB,4.7143E-01_JPRB,&
&3.4454E-01_JPRB,1.1864E+00_JPRB,1.3882E+00_JPRB/)
KAO( :, 4,13,14) = (/&
&1.1616E+00_JPRB,1.0165E+00_JPRB,8.7886E-01_JPRB,7.4766E-01_JPRB,6.1245E-01_JPRB,5.0020E-01_JPRB,&
&3.8828E-01_JPRB,1.1616E+00_JPRB,1.3917E+00_JPRB/)
KAO( :, 5,13,14) = (/&
&1.1397E+00_JPRB,9.9781E-01_JPRB,8.7736E-01_JPRB,7.5469E-01_JPRB,6.4460E-01_JPRB,5.3210E-01_JPRB,&
&4.5910E-01_JPRB,1.1397E+00_JPRB,1.4042E+00_JPRB/)
KAO( :, 1, 1,15) = (/&
&6.7013E-01_JPRB,5.8657E-01_JPRB,5.0312E-01_JPRB,4.1845E-01_JPRB,3.3604E-01_JPRB,3.2447E-01_JPRB,&
&3.1596E-01_JPRB,6.7013E-01_JPRB,1.0209E+00_JPRB/)
KAO( :, 2, 1,15) = (/&
&6.3713E-01_JPRB,5.5910E-01_JPRB,4.7959E-01_JPRB,4.0042E-01_JPRB,4.3246E-01_JPRB,4.5455E-01_JPRB,&
&4.4491E-01_JPRB,6.3714E-01_JPRB,1.4151E+00_JPRB/)
KAO( :, 3, 1,15) = (/&
&6.0413E-01_JPRB,5.2881E-01_JPRB,4.5365E-01_JPRB,5.1141E-01_JPRB,5.7932E-01_JPRB,6.0400E-01_JPRB,&
&5.9194E-01_JPRB,6.0413E-01_JPRB,1.8935E+00_JPRB/)
KAO( :, 4, 1,15) = (/&
&5.7379E-01_JPRB,5.0236E-01_JPRB,5.0998E-01_JPRB,6.6283E-01_JPRB,7.5577E-01_JPRB,7.9134E-01_JPRB,&
&7.7383E-01_JPRB,5.7379E-01_JPRB,2.4386E+00_JPRB/)
KAO( :, 5, 1,15) = (/&
&5.4412E-01_JPRB,4.7644E-01_JPRB,6.4179E-01_JPRB,8.3374E-01_JPRB,9.4901E-01_JPRB,9.9647E-01_JPRB,&
&9.6829E-01_JPRB,5.4412E-01_JPRB,3.0668E+00_JPRB/)
KAO( :, 1, 2,15) = (/&
&7.1168E-01_JPRB,6.2291E-01_JPRB,5.3428E-01_JPRB,4.4560E-01_JPRB,3.5787E-01_JPRB,3.3695E-01_JPRB,&
&3.3151E-01_JPRB,7.1168E-01_JPRB,1.0408E+00_JPRB/)
KAO( :, 2, 2,15) = (/&
&6.7551E-01_JPRB,5.8980E-01_JPRB,5.0589E-01_JPRB,4.2379E-01_JPRB,4.5484E-01_JPRB,4.7493E-01_JPRB,&
&4.6615E-01_JPRB,6.7551E-01_JPRB,1.4628E+00_JPRB/)
KAO( :, 3, 2,15) = (/&
&6.3979E-01_JPRB,5.6002E-01_JPRB,4.8033E-01_JPRB,5.3992E-01_JPRB,6.1725E-01_JPRB,6.4789E-01_JPRB,&
&6.3640E-01_JPRB,6.3979E-01_JPRB,1.9740E+00_JPRB/)
KAO( :, 4, 2,15) = (/&
&6.0574E-01_JPRB,5.3026E-01_JPRB,5.4102E-01_JPRB,7.0781E-01_JPRB,8.0810E-01_JPRB,8.5154E-01_JPRB,&
&8.3777E-01_JPRB,6.0574E-01_JPRB,2.5770E+00_JPRB/)
KAO( :, 5, 2,15) = (/&
&5.7367E-01_JPRB,5.0230E-01_JPRB,6.8564E-01_JPRB,8.9765E-01_JPRB,1.0319E+00_JPRB,1.0843E+00_JPRB,&
&1.0692E+00_JPRB,5.7367E-01_JPRB,3.2665E+00_JPRB/)
KAO( :, 1, 3,15) = (/&
&7.6206E-01_JPRB,6.6694E-01_JPRB,5.7209E-01_JPRB,4.7696E-01_JPRB,3.8092E-01_JPRB,3.2070E-01_JPRB,&
&3.1660E-01_JPRB,7.6206E-01_JPRB,9.6051E-01_JPRB/)
KAO( :, 2, 3,15) = (/&
&7.2225E-01_JPRB,6.3222E-01_JPRB,5.4222E-01_JPRB,4.5212E-01_JPRB,4.4022E-01_JPRB,4.6467E-01_JPRB,&
&4.5854E-01_JPRB,7.2225E-01_JPRB,1.3827E+00_JPRB/)
KAO( :, 3, 3,15) = (/&
&6.8319E-01_JPRB,5.9821E-01_JPRB,5.1315E-01_JPRB,5.2942E-01_JPRB,6.1251E-01_JPRB,6.4502E-01_JPRB,&
&6.3732E-01_JPRB,6.8319E-01_JPRB,1.9060E+00_JPRB/)
KAO( :, 4, 3,15) = (/&
&6.4520E-01_JPRB,5.6501E-01_JPRB,5.4637E-01_JPRB,7.0565E-01_JPRB,8.1836E-01_JPRB,8.6755E-01_JPRB,&
&8.5856E-01_JPRB,6.4520E-01_JPRB,2.5416E+00_JPRB/)
KAO( :, 5, 3,15) = (/&
&6.1032E-01_JPRB,5.3440E-01_JPRB,6.8762E-01_JPRB,9.1192E-01_JPRB,1.0544E+00_JPRB,1.1220E+00_JPRB,&
&1.1118E+00_JPRB,6.1032E-01_JPRB,3.2899E+00_JPRB/)
KAO( :, 1, 4,15) = (/&
&8.1880E-01_JPRB,7.1671E-01_JPRB,6.1469E-01_JPRB,5.1259E-01_JPRB,4.1035E-01_JPRB,3.0900E-01_JPRB,&
&2.8774E-01_JPRB,8.1880E-01_JPRB,8.3214E-01_JPRB/)
KAO( :, 2, 4,15) = (/&
&7.7244E-01_JPRB,6.7627E-01_JPRB,5.8000E-01_JPRB,4.8371E-01_JPRB,4.1707E-01_JPRB,4.3611E-01_JPRB,&
&4.3242E-01_JPRB,7.7244E-01_JPRB,1.2349E+00_JPRB/)
KAO( :, 3, 4,15) = (/&
&7.3041E-01_JPRB,6.3939E-01_JPRB,5.4855E-01_JPRB,5.1182E-01_JPRB,5.8284E-01_JPRB,6.2247E-01_JPRB,&
&6.1822E-01_JPRB,7.3041E-01_JPRB,1.7591E+00_JPRB/)
KAO( :, 4, 4,15) = (/&
&6.8937E-01_JPRB,6.0366E-01_JPRB,5.5228E-01_JPRB,6.8053E-01_JPRB,7.9580E-01_JPRB,8.4999E-01_JPRB,&
&8.5210E-01_JPRB,6.8937E-01_JPRB,2.4071E+00_JPRB/)
KAO( :, 5, 4,15) = (/&
&6.5021E-01_JPRB,5.6936E-01_JPRB,6.6656E-01_JPRB,8.9418E-01_JPRB,1.0485E+00_JPRB,1.1290E+00_JPRB,&
&1.1228E+00_JPRB,6.5021E-01_JPRB,3.1879E+00_JPRB/)
KAO( :, 1, 5,15) = (/&
&8.7693E-01_JPRB,7.6771E-01_JPRB,6.5835E-01_JPRB,5.4884E-01_JPRB,4.4068E-01_JPRB,3.3005E-01_JPRB,&
&2.5822E-01_JPRB,8.7693E-01_JPRB,6.9752E-01_JPRB/)
KAO( :, 2, 5,15) = (/&
&8.2534E-01_JPRB,7.2250E-01_JPRB,6.1982E-01_JPRB,5.1679E-01_JPRB,4.1772E-01_JPRB,4.0063E-01_JPRB,&
&4.0196E-01_JPRB,8.2534E-01_JPRB,1.0779E+00_JPRB/)
KAO( :, 3, 5,15) = (/&
&7.7811E-01_JPRB,6.8129E-01_JPRB,5.8442E-01_JPRB,5.0960E-01_JPRB,5.4382E-01_JPRB,5.8808E-01_JPRB,&
&5.9145E-01_JPRB,7.7811E-01_JPRB,1.5826E+00_JPRB/)
KAO( :, 4, 5,15) = (/&
&7.3361E-01_JPRB,6.4251E-01_JPRB,5.6661E-01_JPRB,6.4134E-01_JPRB,7.5938E-01_JPRB,8.2208E-01_JPRB,&
&8.2942E-01_JPRB,7.3361E-01_JPRB,2.2230E+00_JPRB/)
KAO( :, 5, 5,15) = (/&
&6.9110E-01_JPRB,6.0518E-01_JPRB,6.5033E-01_JPRB,8.5838E-01_JPRB,1.0195E+00_JPRB,1.1130E+00_JPRB,&
&1.1201E+00_JPRB,6.9110E-01_JPRB,3.0082E+00_JPRB/)
KAO( :, 1, 6,15) = (/&
&9.3756E-01_JPRB,8.2068E-01_JPRB,7.0383E-01_JPRB,5.8672E-01_JPRB,4.6972E-01_JPRB,3.5270E-01_JPRB,&
&2.3642E-01_JPRB,9.3756E-01_JPRB,5.8692E-01_JPRB/)
KAO( :, 2, 6,15) = (/&
&8.8146E-01_JPRB,7.7172E-01_JPRB,6.6172E-01_JPRB,5.5196E-01_JPRB,4.4195E-01_JPRB,3.6409E-01_JPRB,&
&3.5917E-01_JPRB,8.8146E-01_JPRB,9.0877E-01_JPRB/)
KAO( :, 3, 6,15) = (/&
&8.2746E-01_JPRB,7.2459E-01_JPRB,6.2157E-01_JPRB,5.2255E-01_JPRB,4.9923E-01_JPRB,5.3612E-01_JPRB,&
&5.4635E-01_JPRB,8.2746E-01_JPRB,1.3807E+00_JPRB/)
KAO( :, 4, 6,15) = (/&
&7.7986E-01_JPRB,6.8286E-01_JPRB,5.9009E-01_JPRB,6.0449E-01_JPRB,7.0052E-01_JPRB,7.7068E-01_JPRB,&
&7.9084E-01_JPRB,7.7986E-01_JPRB,1.9934E+00_JPRB/)
KAO( :, 5, 6,15) = (/&
&7.3459E-01_JPRB,6.4331E-01_JPRB,6.4051E-01_JPRB,8.0328E-01_JPRB,9.6129E-01_JPRB,1.0614E+00_JPRB,&
&1.0888E+00_JPRB,7.3459E-01_JPRB,2.7652E+00_JPRB/)
KAO( :, 1, 7,15) = (/&
&1.0010E+00_JPRB,8.7619E-01_JPRB,7.5131E-01_JPRB,6.2639E-01_JPRB,5.0149E-01_JPRB,3.7652E-01_JPRB,&
&2.5149E-01_JPRB,1.0010E+00_JPRB,5.1478E-01_JPRB/)
KAO( :, 2, 7,15) = (/&
&9.4042E-01_JPRB,8.2317E-01_JPRB,7.0607E-01_JPRB,5.8870E-01_JPRB,4.7134E-01_JPRB,3.5775E-01_JPRB,&
&3.1227E-01_JPRB,9.4042E-01_JPRB,7.6928E-01_JPRB/)
KAO( :, 3, 7,15) = (/&
&8.8237E-01_JPRB,7.7255E-01_JPRB,6.6259E-01_JPRB,5.5268E-01_JPRB,4.7859E-01_JPRB,4.7554E-01_JPRB,&
&4.9216E-01_JPRB,8.8237E-01_JPRB,1.1825E+00_JPRB/)
KAO( :, 4, 7,15) = (/&
&8.2933E-01_JPRB,7.2604E-01_JPRB,6.2305E-01_JPRB,5.8548E-01_JPRB,6.3044E-01_JPRB,7.0378E-01_JPRB,&
&7.3153E-01_JPRB,8.2933E-01_JPRB,1.7634E+00_JPRB/)
KAO( :, 5, 7,15) = (/&
&7.8131E-01_JPRB,6.8426E-01_JPRB,6.4094E-01_JPRB,7.3798E-01_JPRB,8.8857E-01_JPRB,9.9138E-01_JPRB,&
&1.0340E+00_JPRB,7.8131E-01_JPRB,2.5071E+00_JPRB/)
KAO( :, 1, 8,15) = (/&
&1.0680E+00_JPRB,9.3481E-01_JPRB,8.0158E-01_JPRB,6.6826E-01_JPRB,5.3482E-01_JPRB,4.0154E-01_JPRB,&
&2.6788E-01_JPRB,1.0680E+00_JPRB,4.6455E-01_JPRB/)
KAO( :, 2, 8,15) = (/&
&1.0024E+00_JPRB,8.7742E-01_JPRB,7.5246E-01_JPRB,6.2743E-01_JPRB,5.0223E-01_JPRB,3.7717E-01_JPRB,&
&2.7719E-01_JPRB,1.0024E+00_JPRB,6.8110E-01_JPRB/)
KAO( :, 3, 8,15) = (/&
&9.4024E-01_JPRB,8.2314E-01_JPRB,7.0609E-01_JPRB,5.8881E-01_JPRB,4.8025E-01_JPRB,4.2864E-01_JPRB,&
&4.3393E-01_JPRB,9.4024E-01_JPRB,1.0170E+00_JPRB/)
KAO( :, 4, 8,15) = (/&
&8.8264E-01_JPRB,7.7273E-01_JPRB,6.6282E-01_JPRB,5.8404E-01_JPRB,5.7821E-01_JPRB,6.2771E-01_JPRB,&
&6.6458E-01_JPRB,8.8264E-01_JPRB,1.5302E+00_JPRB/)
KAO( :, 5, 8,15) = (/&
&8.3199E-01_JPRB,7.2845E-01_JPRB,6.5427E-01_JPRB,6.8741E-01_JPRB,8.0945E-01_JPRB,9.0978E-01_JPRB,&
&9.6418E-01_JPRB,8.3199E-01_JPRB,2.2337E+00_JPRB/)
KAO( :, 1, 9,15) = (/&
&1.1381E+00_JPRB,9.9610E-01_JPRB,8.5409E-01_JPRB,7.1197E-01_JPRB,5.6977E-01_JPRB,4.2770E-01_JPRB,&
&2.8544E-01_JPRB,1.1381E+00_JPRB,4.2382E-01_JPRB/)
KAO( :, 2, 9,15) = (/&
&1.0667E+00_JPRB,9.3372E-01_JPRB,8.0061E-01_JPRB,6.6744E-01_JPRB,5.3433E-01_JPRB,4.0118E-01_JPRB,&
&2.6997E-01_JPRB,1.0667E+00_JPRB,6.1324E-01_JPRB/)
KAO( :, 3, 9,15) = (/&
&1.0035E+00_JPRB,8.7845E-01_JPRB,7.5330E-01_JPRB,6.2805E-01_JPRB,5.0276E-01_JPRB,4.0704E-01_JPRB,&
&3.7170E-01_JPRB,1.0035E+00_JPRB,9.0055E-01_JPRB/)
KAO( :, 4, 9,15) = (/&
&9.4646E-01_JPRB,8.2850E-01_JPRB,7.1051E-01_JPRB,6.0313E-01_JPRB,5.4959E-01_JPRB,5.4972E-01_JPRB,&
&5.8769E-01_JPRB,9.4646E-01_JPRB,1.3351E+00_JPRB/)
KAO( :, 5, 9,15) = (/&
&8.9740E-01_JPRB,7.8559E-01_JPRB,6.8592E-01_JPRB,6.6573E-01_JPRB,7.2528E-01_JPRB,8.1924E-01_JPRB,&
&8.7543E-01_JPRB,8.9740E-01_JPRB,1.9504E+00_JPRB/)
KAO( :, 1,10,15) = (/&
&1.2073E+00_JPRB,1.0565E+00_JPRB,9.0576E-01_JPRB,7.5488E-01_JPRB,6.0419E-01_JPRB,4.5329E-01_JPRB,&
&3.0227E-01_JPRB,1.2073E+00_JPRB,3.9999E-01_JPRB/)
KAO( :, 2,10,15) = (/&
&1.1382E+00_JPRB,9.9608E-01_JPRB,8.5413E-01_JPRB,7.1184E-01_JPRB,5.6976E-01_JPRB,4.2763E-01_JPRB,&
&2.8536E-01_JPRB,1.1382E+00_JPRB,5.7883E-01_JPRB/)
KAO( :, 3,10,15) = (/&
&1.0785E+00_JPRB,9.4391E-01_JPRB,8.0923E-01_JPRB,6.7459E-01_JPRB,5.3984E-01_JPRB,4.1488E-01_JPRB,&
&3.3805E-01_JPRB,1.0785E+00_JPRB,8.3839E-01_JPRB/)
KAO( :, 4,10,15) = (/&
&1.0278E+00_JPRB,8.9961E-01_JPRB,7.7127E-01_JPRB,6.4730E-01_JPRB,5.5430E-01_JPRB,5.1106E-01_JPRB,&
&5.2425E-01_JPRB,1.0278E+00_JPRB,1.2284E+00_JPRB/)
KAO( :, 5,10,15) = (/&
&9.8618E-01_JPRB,8.6326E-01_JPRB,7.4679E-01_JPRB,6.7988E-01_JPRB,6.7637E-01_JPRB,7.4989E-01_JPRB,&
&8.0479E-01_JPRB,9.8618E-01_JPRB,1.7791E+00_JPRB/)
KAO( :, 1,11,15) = (/&
&1.2644E+00_JPRB,1.1063E+00_JPRB,9.4846E-01_JPRB,7.9047E-01_JPRB,6.3247E-01_JPRB,4.7453E-01_JPRB,&
&3.1659E-01_JPRB,1.2644E+00_JPRB,7.4298E-01_JPRB/)
KAO( :, 2,11,15) = (/&
&1.2071E+00_JPRB,1.0565E+00_JPRB,9.0557E-01_JPRB,7.5491E-01_JPRB,6.0392E-01_JPRB,4.5270E-01_JPRB,&
&3.0399E-01_JPRB,1.2071E+00_JPRB,8.1705E-01_JPRB/)
KAO( :, 3,11,15) = (/&
&1.1615E+00_JPRB,1.0165E+00_JPRB,8.7147E-01_JPRB,7.2637E-01_JPRB,5.8138E-01_JPRB,4.5624E-01_JPRB,&
&3.7840E-01_JPRB,1.1615E+00_JPRB,9.7765E-01_JPRB/)
KAO( :, 4,11,15) = (/&
&1.1264E+00_JPRB,9.8590E-01_JPRB,8.4531E-01_JPRB,7.1438E-01_JPRB,6.1502E-01_JPRB,5.6197E-01_JPRB,&
&5.7803E-01_JPRB,1.1264E+00_JPRB,1.3520E+00_JPRB/)
KAO( :, 5,11,15) = (/&
&1.0994E+00_JPRB,9.6216E-01_JPRB,8.3568E-01_JPRB,7.5689E-01_JPRB,7.4680E-01_JPRB,8.2884E-01_JPRB,&
&8.8880E-01_JPRB,1.0994E+00_JPRB,1.9292E+00_JPRB/)
KAO( :, 1,12,15) = (/&
&1.3647E+00_JPRB,1.1941E+00_JPRB,1.0237E+00_JPRB,8.5312E-01_JPRB,6.8264E-01_JPRB,5.1188E-01_JPRB,&
&3.4108E-01_JPRB,1.3647E+00_JPRB,1.2788E+00_JPRB/)
KAO( :, 2,12,15) = (/&
&1.3242E+00_JPRB,1.1588E+00_JPRB,9.9341E-01_JPRB,8.2794E-01_JPRB,6.6255E-01_JPRB,4.9690E-01_JPRB,&
&3.3841E-01_JPRB,1.3242E+00_JPRB,1.2778E+00_JPRB/)
KAO( :, 3,12,15) = (/&
&1.2955E+00_JPRB,1.1336E+00_JPRB,9.7197E-01_JPRB,8.1003E-01_JPRB,6.5411E-01_JPRB,5.1488E-01_JPRB,&
&4.3081E-01_JPRB,1.2955E+00_JPRB,1.3626E+00_JPRB/)
KAO( :, 4,12,15) = (/&
&1.2745E+00_JPRB,1.1153E+00_JPRB,9.5614E-01_JPRB,8.1202E-01_JPRB,6.9456E-01_JPRB,6.2323E-01_JPRB,&
&6.4228E-01_JPRB,1.2745E+00_JPRB,1.6020E+00_JPRB/)
KAO( :, 5,12,15) = (/&
&1.2602E+00_JPRB,1.1028E+00_JPRB,9.6134E-01_JPRB,8.5786E-01_JPRB,8.3175E-01_JPRB,9.1010E-01_JPRB,&
&9.8660E-01_JPRB,1.2602E+00_JPRB,2.1013E+00_JPRB/)
KAO( :, 1,13,15) = (/&
&1.5182E+00_JPRB,1.3286E+00_JPRB,1.1388E+00_JPRB,9.4918E-01_JPRB,7.5925E-01_JPRB,5.6967E-01_JPRB,&
&3.7977E-01_JPRB,1.5182E+00_JPRB,1.8162E+00_JPRB/)
KAO( :, 2,13,15) = (/&
&1.4954E+00_JPRB,1.3087E+00_JPRB,1.1217E+00_JPRB,9.3496E-01_JPRB,7.4798E-01_JPRB,5.6069E-01_JPRB,&
&3.8653E-01_JPRB,1.4954E+00_JPRB,1.7757E+00_JPRB/)
KAO( :, 3,13,15) = (/&
&1.4806E+00_JPRB,1.2956E+00_JPRB,1.1104E+00_JPRB,9.2545E-01_JPRB,7.5238E-01_JPRB,5.8983E-01_JPRB,&
&4.8997E-01_JPRB,1.4806E+00_JPRB,1.8395E+00_JPRB/)
KAO( :, 4,13,15) = (/&
&1.4707E+00_JPRB,1.2870E+00_JPRB,1.1033E+00_JPRB,9.3978E-01_JPRB,7.9436E-01_JPRB,6.9884E-01_JPRB,&
&7.1743E-01_JPRB,1.4707E+00_JPRB,1.9733E+00_JPRB/)
KAO( :, 5,13,15) = (/&
&1.4617E+00_JPRB,1.2790E+00_JPRB,1.1197E+00_JPRB,9.8344E-01_JPRB,9.3195E-01_JPRB,9.9536E-01_JPRB,&
&1.0841E+00_JPRB,1.4617E+00_JPRB,2.3960E+00_JPRB/)
KAO( :, 1, 1,16) = (/&
&6.7204E-01_JPRB,5.8835E-01_JPRB,4.9493E-01_JPRB,4.2075E-01_JPRB,3.2404E-01_JPRB,3.2835E-01_JPRB,&
&3.1694E-01_JPRB,6.7204E-01_JPRB,1.1553E+00_JPRB/)
KAO( :, 2, 1,16) = (/&
&6.3886E-01_JPRB,5.4837E-01_JPRB,4.7048E-01_JPRB,4.0570E-01_JPRB,4.5211E-01_JPRB,4.4664E-01_JPRB,&
&4.2417E-01_JPRB,6.3887E-01_JPRB,1.6108E+00_JPRB/)
KAO( :, 3, 1,16) = (/&
&6.0571E-01_JPRB,5.3024E-01_JPRB,4.5482E-01_JPRB,5.4623E-01_JPRB,6.0722E-01_JPRB,6.1523E-01_JPRB,&
&6.0675E-01_JPRB,6.0571E-01_JPRB,2.1229E+00_JPRB/)
KAO( :, 4, 1,16) = (/&
&5.7537E-01_JPRB,5.0361E-01_JPRB,5.5977E-01_JPRB,6.9780E-01_JPRB,7.7428E-01_JPRB,7.8387E-01_JPRB,&
&7.5743E-01_JPRB,5.7537E-01_JPRB,2.8238E+00_JPRB/)
KAO( :, 5, 1,16) = (/&
&5.4532E-01_JPRB,4.7762E-01_JPRB,7.0785E-01_JPRB,8.9753E-01_JPRB,9.9932E-01_JPRB,1.0137E+00_JPRB,&
&1.0005E+00_JPRB,5.4532E-01_JPRB,3.5639E+00_JPRB/)
KAO( :, 1, 2,16) = (/&
&7.1419E-01_JPRB,6.2513E-01_JPRB,5.3613E-01_JPRB,4.4716E-01_JPRB,3.5137E-01_JPRB,3.4275E-01_JPRB,&
&3.2618E-01_JPRB,7.1419E-01_JPRB,1.2386E+00_JPRB/)
KAO( :, 2, 2,16) = (/&
&6.7776E-01_JPRB,5.9352E-01_JPRB,5.0900E-01_JPRB,4.3513E-01_JPRB,4.7304E-01_JPRB,4.9853E-01_JPRB,&
&4.7175E-01_JPRB,6.7776E-01_JPRB,1.7603E+00_JPRB/)
KAO( :, 3, 2,16) = (/&
&6.4195E-01_JPRB,5.6188E-01_JPRB,4.8194E-01_JPRB,5.9011E-01_JPRB,6.5773E-01_JPRB,6.7703E-01_JPRB,&
&6.5466E-01_JPRB,6.4195E-01_JPRB,2.4018E+00_JPRB/)
KAO( :, 4, 2,16) = (/&
&6.0760E-01_JPRB,5.3187E-01_JPRB,6.1665E-01_JPRB,7.6305E-01_JPRB,8.6650E-01_JPRB,8.7779E-01_JPRB,&
&8.4546E-01_JPRB,6.0760E-01_JPRB,3.1623E+00_JPRB/)
KAO( :, 5, 2,16) = (/&
&5.7557E-01_JPRB,5.0389E-01_JPRB,7.8645E-01_JPRB,9.9605E-01_JPRB,1.1101E+00_JPRB,1.1441E+00_JPRB,&
&1.0872E+00_JPRB,5.7557E-01_JPRB,4.0554E+00_JPRB/)
KAO( :, 1, 3,16) = (/&
&7.6539E-01_JPRB,6.6993E-01_JPRB,5.7468E-01_JPRB,4.7908E-01_JPRB,3.8366E-01_JPRB,3.3164E-01_JPRB,&
&3.1419E-01_JPRB,7.6539E-01_JPRB,1.2218E+00_JPRB/)
KAO( :, 2, 3,16) = (/&
&7.2520E-01_JPRB,6.3496E-01_JPRB,5.4460E-01_JPRB,4.5403E-01_JPRB,4.7919E-01_JPRB,4.8518E-01_JPRB,&
&4.6775E-01_JPRB,7.2520E-01_JPRB,1.7874E+00_JPRB/)
KAO( :, 3, 3,16) = (/&
&6.8607E-01_JPRB,6.0066E-01_JPRB,5.1535E-01_JPRB,6.0192E-01_JPRB,6.5742E-01_JPRB,6.8742E-01_JPRB,&
&6.6482E-01_JPRB,6.8607E-01_JPRB,2.4947E+00_JPRB/)
KAO( :, 4, 3,16) = (/&
&6.4786E-01_JPRB,5.6724E-01_JPRB,6.3678E-01_JPRB,8.0813E-01_JPRB,8.8359E-01_JPRB,9.1109E-01_JPRB,&
&8.7792E-01_JPRB,6.4786E-01_JPRB,3.3575E+00_JPRB/)
KAO( :, 5, 3,16) = (/&
&6.1260E-01_JPRB,5.3649E-01_JPRB,8.2910E-01_JPRB,1.0492E+00_JPRB,1.1703E+00_JPRB,1.2063E+00_JPRB,&
&1.1675E+00_JPRB,6.1260E-01_JPRB,4.3791E+00_JPRB/)
KAO( :, 1, 4,16) = (/&
&8.2264E-01_JPRB,7.2018E-01_JPRB,6.1760E-01_JPRB,5.1504E-01_JPRB,4.1228E-01_JPRB,3.1403E-01_JPRB,&
&3.0330E-01_JPRB,8.2264E-01_JPRB,1.1500E+00_JPRB/)
KAO( :, 2, 4,16) = (/&
&7.7591E-01_JPRB,6.7905E-01_JPRB,5.8222E-01_JPRB,4.8587E-01_JPRB,4.6170E-01_JPRB,4.7497E-01_JPRB,&
&4.5862E-01_JPRB,7.7591E-01_JPRB,1.7280E+00_JPRB/)
KAO( :, 3, 4,16) = (/&
&7.3290E-01_JPRB,6.4193E-01_JPRB,5.5048E-01_JPRB,5.9279E-01_JPRB,6.6051E-01_JPRB,6.8079E-01_JPRB,&
&6.5994E-01_JPRB,7.3290E-01_JPRB,2.4901E+00_JPRB/)
KAO( :, 4, 4,16) = (/&
&6.9170E-01_JPRB,6.0563E-01_JPRB,6.4428E-01_JPRB,8.1421E-01_JPRB,9.0809E-01_JPRB,9.3805E-01_JPRB,&
&8.9044E-01_JPRB,6.9170E-01_JPRB,3.4202E+00_JPRB/)
KAO( :, 5, 4,16) = (/&
&6.5200E-01_JPRB,5.7086E-01_JPRB,8.5544E-01_JPRB,1.0841E+00_JPRB,1.2072E+00_JPRB,1.2191E+00_JPRB,&
&1.2042E+00_JPRB,6.5200E-01_JPRB,4.5618E+00_JPRB/)
KAO( :, 1, 5,16) = (/&
&8.8181E-01_JPRB,7.7179E-01_JPRB,6.6204E-01_JPRB,5.5199E-01_JPRB,4.3343E-01_JPRB,3.3186E-01_JPRB,&
&2.7727E-01_JPRB,8.8181E-01_JPRB,1.0520E+00_JPRB/)
KAO( :, 2, 5,16) = (/&
&8.2952E-01_JPRB,7.2638E-01_JPRB,6.2324E-01_JPRB,5.1947E-01_JPRB,4.3588E-01_JPRB,4.4832E-01_JPRB,&
&4.3512E-01_JPRB,8.2952E-01_JPRB,1.6494E+00_JPRB/)
KAO( :, 3, 5,16) = (/&
&7.8170E-01_JPRB,6.8471E-01_JPRB,5.8732E-01_JPRB,5.7928E-01_JPRB,6.4579E-01_JPRB,6.6360E-01_JPRB,&
&6.4439E-01_JPRB,7.8170E-01_JPRB,2.4300E+00_JPRB/)
KAO( :, 4, 5,16) = (/&
&7.3700E-01_JPRB,6.4559E-01_JPRB,6.4470E-01_JPRB,8.1536E-01_JPRB,9.1269E-01_JPRB,9.3873E-01_JPRB,&
&9.0753E-01_JPRB,7.3700E-01_JPRB,3.4492E+00_JPRB/)
KAO( :, 5, 5,16) = (/&
&6.9437E-01_JPRB,6.0807E-01_JPRB,8.7385E-01_JPRB,1.1073E+00_JPRB,1.2374E+00_JPRB,1.2510E+00_JPRB,&
&1.2316E+00_JPRB,6.9437E-01_JPRB,4.6799E+00_JPRB/)
KAO( :, 1, 6,16) = (/&
&9.4656E-01_JPRB,8.2884E-01_JPRB,7.1064E-01_JPRB,5.9233E-01_JPRB,4.7420E-01_JPRB,3.5608E-01_JPRB,&
&2.4362E-01_JPRB,9.4656E-01_JPRB,9.2837E-01_JPRB/)
KAO( :, 2, 6,16) = (/&
&8.9042E-01_JPRB,7.7970E-01_JPRB,6.6875E-01_JPRB,5.5799E-01_JPRB,4.4670E-01_JPRB,4.1251E-01_JPRB,&
&4.0025E-01_JPRB,8.9042E-01_JPRB,1.5112E+00_JPRB/)
KAO( :, 3, 6,16) = (/&
&8.3666E-01_JPRB,7.3284E-01_JPRB,6.2869E-01_JPRB,5.5096E-01_JPRB,6.1404E-01_JPRB,6.3375E-01_JPRB,&
&6.1412E-01_JPRB,8.3666E-01_JPRB,2.3236E+00_JPRB/)
KAO( :, 4, 6,16) = (/&
&7.8888E-01_JPRB,6.9101E-01_JPRB,6.2966E-01_JPRB,7.9961E-01_JPRB,8.9414E-01_JPRB,9.2254E-01_JPRB,&
&8.7581E-01_JPRB,7.8888E-01_JPRB,3.3711E+00_JPRB/)
KAO( :, 5, 6,16) = (/&
&7.4306E-01_JPRB,6.5113E-01_JPRB,8.7601E-01_JPRB,1.1131E+00_JPRB,1.2418E+00_JPRB,1.2838E+00_JPRB,&
&1.2412E+00_JPRB,7.4306E-01_JPRB,4.6947E+00_JPRB/)
KAO( :, 1, 7,16) = (/&
&1.0141E+00_JPRB,8.8774E-01_JPRB,7.6121E-01_JPRB,6.3477E-01_JPRB,5.0825E-01_JPRB,3.8150E-01_JPRB,&
&2.5476E-01_JPRB,1.0141E+00_JPRB,7.9663E-01_JPRB/)
KAO( :, 2, 7,16) = (/&
&9.5399E-01_JPRB,8.3513E-01_JPRB,7.1620E-01_JPRB,5.9743E-01_JPRB,4.7818E-01_JPRB,3.7373E-01_JPRB,&
&3.6192E-01_JPRB,9.5399E-01_JPRB,1.3655E+00_JPRB/)
KAO( :, 3, 7,16) = (/&
&8.9634E-01_JPRB,7.8499E-01_JPRB,6.7347E-01_JPRB,5.6171E-01_JPRB,5.7673E-01_JPRB,5.9473E-01_JPRB,&
&5.7642E-01_JPRB,8.9634E-01_JPRB,2.1680E+00_JPRB/)
KAO( :, 4, 7,16) = (/&
&8.4326E-01_JPRB,7.3869E-01_JPRB,6.3388E-01_JPRB,7.7423E-01_JPRB,8.6537E-01_JPRB,8.9227E-01_JPRB,&
&8.6433E-01_JPRB,8.4326E-01_JPRB,3.2604E+00_JPRB/)
KAO( :, 5, 7,16) = (/&
&7.9491E-01_JPRB,6.9647E-01_JPRB,8.6797E-01_JPRB,1.1053E+00_JPRB,1.2365E+00_JPRB,1.2774E+00_JPRB,&
&1.2375E+00_JPRB,7.9491E-01_JPRB,4.6484E+00_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.0826E+00_JPRB,9.4750E-01_JPRB,8.1241E-01_JPRB,6.7724E-01_JPRB,5.4220E-01_JPRB,4.0687E-01_JPRB,&
&2.7135E-01_JPRB,1.0826E+00_JPRB,6.7305E-01_JPRB/)
KAO( :, 2, 8,16) = (/&
&1.0187E+00_JPRB,8.9193E-01_JPRB,7.6505E-01_JPRB,6.3785E-01_JPRB,5.1061E-01_JPRB,3.8339E-01_JPRB,&
&3.2268E-01_JPRB,1.0187E+00_JPRB,1.2085E+00_JPRB/)
KAO( :, 3, 8,16) = (/&
&9.5858E-01_JPRB,8.3946E-01_JPRB,7.2017E-01_JPRB,6.0051E-01_JPRB,5.3532E-01_JPRB,5.5217E-01_JPRB,&
&5.3452E-01_JPRB,9.5858E-01_JPRB,2.0055E+00_JPRB/)
KAO( :, 4, 8,16) = (/&
&9.0233E-01_JPRB,7.9038E-01_JPRB,6.7816E-01_JPRB,7.4178E-01_JPRB,8.2987E-01_JPRB,8.5828E-01_JPRB,&
&8.2989E-01_JPRB,9.0233E-01_JPRB,3.1045E+00_JPRB/)
KAO( :, 5, 8,16) = (/&
&8.5134E-01_JPRB,7.4583E-01_JPRB,8.5421E-01_JPRB,1.0895E+00_JPRB,1.2207E+00_JPRB,1.2603E+00_JPRB,&
&1.2206E+00_JPRB,8.5134E-01_JPRB,4.5597E+00_JPRB/)
KAO( :, 1, 9,16) = (/&
&1.1564E+00_JPRB,1.0121E+00_JPRB,8.6800E-01_JPRB,7.2367E-01_JPRB,5.7876E-01_JPRB,4.3457E-01_JPRB,&
&2.8981E-01_JPRB,1.1564E+00_JPRB,5.5525E-01_JPRB/)
KAO( :, 2, 9,16) = (/&
&1.0903E+00_JPRB,9.5491E-01_JPRB,8.1871E-01_JPRB,6.8281E-01_JPRB,5.4658E-01_JPRB,4.0983E-01_JPRB,&
&2.8183E-01_JPRB,1.0903E+00_JPRB,1.0488E+00_JPRB/)
KAO( :, 3, 9,16) = (/&
&1.0293E+00_JPRB,9.0147E-01_JPRB,7.7309E-01_JPRB,6.4495E-01_JPRB,5.1624E-01_JPRB,5.0522E-01_JPRB,&
&4.8904E-01_JPRB,1.0293E+00_JPRB,1.8131E+00_JPRB/)
KAO( :, 4, 9,16) = (/&
&9.7173E-01_JPRB,8.5120E-01_JPRB,7.3048E-01_JPRB,7.0120E-01_JPRB,7.8672E-01_JPRB,8.1370E-01_JPRB,&
&7.8991E-01_JPRB,9.7173E-01_JPRB,2.9196E+00_JPRB/)
KAO( :, 5, 9,16) = (/&
&9.1923E-01_JPRB,8.0514E-01_JPRB,8.3021E-01_JPRB,1.0615E+00_JPRB,1.1921E+00_JPRB,1.2331E+00_JPRB,&
&1.1982E+00_JPRB,9.1923E-01_JPRB,4.4066E+00_JPRB/)
KAO( :, 1,10,16) = (/&
&1.2374E+00_JPRB,1.0830E+00_JPRB,9.2878E-01_JPRB,7.7400E-01_JPRB,6.1971E-01_JPRB,4.6496E-01_JPRB,&
&3.0999E-01_JPRB,1.2374E+00_JPRB,5.8062E-01_JPRB/)
KAO( :, 2,10,16) = (/&
&1.1711E+00_JPRB,1.0252E+00_JPRB,8.7935E-01_JPRB,7.3302E-01_JPRB,5.8682E-01_JPRB,4.4044E-01_JPRB,&
&2.9397E-01_JPRB,1.1711E+00_JPRB,9.3348E-01_JPRB/)
KAO( :, 3,10,16) = (/&
&1.1097E+00_JPRB,9.7179E-01_JPRB,8.3349E-01_JPRB,6.9517E-01_JPRB,5.5660E-01_JPRB,4.7411E-01_JPRB,&
&4.6026E-01_JPRB,1.1097E+00_JPRB,1.6848E+00_JPRB/)
KAO( :, 4,10,16) = (/&
&1.0572E+00_JPRB,9.2545E-01_JPRB,7.9343E-01_JPRB,6.8000E-01_JPRB,7.6310E-01_JPRB,7.9077E-01_JPRB,&
&7.6860E-01_JPRB,1.0572E+00_JPRB,2.7940E+00_JPRB/)
KAO( :, 5,10,16) = (/&
&1.0175E+00_JPRB,8.9035E-01_JPRB,8.2349E-01_JPRB,1.0563E+00_JPRB,1.1865E+00_JPRB,1.2328E+00_JPRB,&
&1.1994E+00_JPRB,1.0175E+00_JPRB,4.3373E+00_JPRB/)
KAO( :, 1,11,16) = (/&
&1.3078E+00_JPRB,1.1446E+00_JPRB,9.8121E-01_JPRB,8.1822E-01_JPRB,6.5451E-01_JPRB,4.9148E-01_JPRB,&
&3.2796E-01_JPRB,1.3078E+00_JPRB,8.7955E-01_JPRB/)
KAO( :, 2,11,16) = (/&
&1.2495E+00_JPRB,1.0937E+00_JPRB,9.3769E-01_JPRB,7.8176E-01_JPRB,6.2549E-01_JPRB,4.6880E-01_JPRB,&
&3.1026E-01_JPRB,1.2495E+00_JPRB,1.1103E+00_JPRB/)
KAO( :, 3,11,16) = (/&
&1.2067E+00_JPRB,1.0559E+00_JPRB,9.0509E-01_JPRB,7.5401E-01_JPRB,6.0340E-01_JPRB,5.7377E-01_JPRB,&
&5.5854E-01_JPRB,1.2067E+00_JPRB,1.9965E+00_JPRB/)
KAO( :, 4,11,16) = (/&
&1.1748E+00_JPRB,1.0281E+00_JPRB,8.8102E-01_JPRB,8.1540E-01_JPRB,9.2020E-01_JPRB,9.5681E-01_JPRB,&
&9.3190E-01_JPRB,1.1748E+00_JPRB,3.3092E+00_JPRB/)
KAO( :, 5,11,16) = (/&
&1.1528E+00_JPRB,1.0088E+00_JPRB,9.8178E-01_JPRB,1.2680E+00_JPRB,1.4334E+00_JPRB,1.4913E+00_JPRB,&
&1.4507E+00_JPRB,1.1528E+00_JPRB,5.1215E+00_JPRB/)
KAO( :, 1,12,16) = (/&
&1.4264E+00_JPRB,1.2483E+00_JPRB,1.0700E+00_JPRB,8.9156E-01_JPRB,7.1342E-01_JPRB,5.3490E-01_JPRB,&
&3.5601E-01_JPRB,1.4264E+00_JPRB,1.5795E+00_JPRB/)
KAO( :, 2,12,16) = (/&
&1.3956E+00_JPRB,1.2210E+00_JPRB,1.0467E+00_JPRB,8.7214E-01_JPRB,6.9777E-01_JPRB,5.2320E-01_JPRB,&
&3.7423E-01_JPRB,1.3956E+00_JPRB,1.5601E+00_JPRB/)
KAO( :, 3,12,16) = (/&
&1.3711E+00_JPRB,1.1997E+00_JPRB,1.0285E+00_JPRB,8.5684E-01_JPRB,6.8534E-01_JPRB,6.9284E-01_JPRB,&
&6.7781E-01_JPRB,1.3711E+00_JPRB,2.3512E+00_JPRB/)
KAO( :, 4,12,16) = (/&
&1.3565E+00_JPRB,1.1870E+00_JPRB,1.0173E+00_JPRB,9.7613E-01_JPRB,1.1079E+00_JPRB,1.1568E+00_JPRB,&
&1.1307E+00_JPRB,1.3565E+00_JPRB,3.8814E+00_JPRB/)
KAO( :, 5,12,16) = (/&
&1.3408E+00_JPRB,1.1733E+00_JPRB,1.1680E+00_JPRB,1.5162E+00_JPRB,1.7205E+00_JPRB,1.8012E+00_JPRB,&
&1.7627E+00_JPRB,1.3408E+00_JPRB,5.9949E+00_JPRB/)
KAO( :, 1,13,16) = (/&
&1.6257E+00_JPRB,1.4225E+00_JPRB,1.2194E+00_JPRB,1.0160E+00_JPRB,8.1283E-01_JPRB,6.0965E-01_JPRB,&
&4.0604E-01_JPRB,1.6257E+00_JPRB,2.2989E+00_JPRB/)
KAO( :, 2,13,16) = (/&
&1.6092E+00_JPRB,1.4081E+00_JPRB,1.2069E+00_JPRB,1.0056E+00_JPRB,8.0424E-01_JPRB,6.0284E-01_JPRB,&
&4.5252E-01_JPRB,1.6092E+00_JPRB,2.2727E+00_JPRB/)
KAO( :, 3,13,16) = (/&
&1.6030E+00_JPRB,1.4026E+00_JPRB,1.2019E+00_JPRB,1.0013E+00_JPRB,8.1602E-01_JPRB,8.3675E-01_JPRB,&
&8.2085E-01_JPRB,1.6030E+00_JPRB,2.7443E+00_JPRB/)
KAO( :, 4,13,16) = (/&
&1.5933E+00_JPRB,1.3941E+00_JPRB,1.1949E+00_JPRB,1.1601E+00_JPRB,1.3266E+00_JPRB,1.3927E+00_JPRB,&
&1.3677E+00_JPRB,1.5933E+00_JPRB,4.4922E+00_JPRB/)
KAO( :, 5,13,16) = (/&
&1.5870E+00_JPRB,1.3885E+00_JPRB,1.3769E+00_JPRB,1.7994E+00_JPRB,2.0601E+00_JPRB,2.1667E+00_JPRB,&
&2.1254E+00_JPRB,1.5870E+00_JPRB,6.9188E+00_JPRB/)



!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB4_A1
