!OCL SCALAR
SUBROUTINE RRTM_KGB3_B2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO    ,ABSN2OAO   ,ABSN2OBO
USE YOERRTA3 , ONLY : ABSN2OA ,ABSN2OB  ,ETAREF    ,H2OREF     ,&
           &N2OREF     ,CO2REF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different H2O to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = H2O/(H2O+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of H2O.  For instance, JS=1 refers to no H2O, 
!     JS = 2 corresponds to eta = 0.25, etc.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 5) = (/&
&4.7279E-04_JPRB,8.7098E-04_JPRB,9.0543E-04_JPRB,9.3823E-04_JPRB,7.8919E-03_JPRB/)
KBO( :, 2,13, 5) = (/&
&6.4177E-04_JPRB,1.1728E-03_JPRB,1.1865E-03_JPRB,1.1108E-03_JPRB,8.6809E-03_JPRB/)
KBO( :, 3,13, 5) = (/&
&8.7771E-04_JPRB,1.5520E-03_JPRB,1.5457E-03_JPRB,1.3624E-03_JPRB,9.6358E-03_JPRB/)
KBO( :, 4,13, 5) = (/&
&1.1913E-03_JPRB,2.0247E-03_JPRB,1.9864E-03_JPRB,1.6883E-03_JPRB,1.0697E-02_JPRB/)
KBO( :, 5,13, 5) = (/&
&1.5849E-03_JPRB,2.6087E-03_JPRB,2.5214E-03_JPRB,2.0902E-03_JPRB,1.1832E-02_JPRB/)
KBO( :, 1,14, 5) = (/&
&3.9797E-04_JPRB,7.4264E-04_JPRB,7.7131E-04_JPRB,7.8917E-04_JPRB,6.3875E-03_JPRB/)
KBO( :, 2,14, 5) = (/&
&5.4883E-04_JPRB,1.0041E-03_JPRB,1.0164E-03_JPRB,9.4462E-04_JPRB,7.1228E-03_JPRB/)
KBO( :, 3,14, 5) = (/&
&7.5764E-04_JPRB,1.3360E-03_JPRB,1.3281E-03_JPRB,1.1660E-03_JPRB,7.9451E-03_JPRB/)
KBO( :, 4,14, 5) = (/&
&1.0318E-03_JPRB,1.7525E-03_JPRB,1.7145E-03_JPRB,1.4506E-03_JPRB,8.8337E-03_JPRB/)
KBO( :, 5,14, 5) = (/&
&1.3764E-03_JPRB,2.2658E-03_JPRB,2.1860E-03_JPRB,1.8014E-03_JPRB,9.7391E-03_JPRB/)
KBO( :, 1,15, 5) = (/&
&3.3164E-04_JPRB,6.3085E-04_JPRB,6.5753E-04_JPRB,6.6377E-04_JPRB,4.8736E-03_JPRB/)
KBO( :, 2,15, 5) = (/&
&4.6431E-04_JPRB,8.5791E-04_JPRB,8.7041E-04_JPRB,8.0246E-04_JPRB,5.4864E-03_JPRB/)
KBO( :, 3,15, 5) = (/&
&6.4635E-04_JPRB,1.1477E-03_JPRB,1.1413E-03_JPRB,9.9664E-04_JPRB,6.1519E-03_JPRB/)
KBO( :, 4,15, 5) = (/&
&8.8542E-04_JPRB,1.5118E-03_JPRB,1.4797E-03_JPRB,1.2450E-03_JPRB,6.8384E-03_JPRB/)
KBO( :, 5,15, 5) = (/&
&1.1860E-03_JPRB,1.9607E-03_JPRB,1.8917E-03_JPRB,1.5514E-03_JPRB,7.5330E-03_JPRB/)
KBO( :, 1,16, 5) = (/&
&2.7547E-04_JPRB,5.3540E-04_JPRB,5.5986E-04_JPRB,5.5850E-04_JPRB,3.5571E-03_JPRB/)
KBO( :, 2,16, 5) = (/&
&3.9076E-04_JPRB,7.3210E-04_JPRB,7.4449E-04_JPRB,6.8182E-04_JPRB,4.0376E-03_JPRB/)
KBO( :, 3,16, 5) = (/&
&5.4914E-04_JPRB,9.8388E-04_JPRB,9.7975E-04_JPRB,8.5148E-04_JPRB,4.5400E-03_JPRB/)
KBO( :, 4,16, 5) = (/&
&7.5647E-04_JPRB,1.3013E-03_JPRB,1.2750E-03_JPRB,1.0673E-03_JPRB,5.0491E-03_JPRB/)
KBO( :, 5,16, 5) = (/&
&1.0168E-03_JPRB,1.6894E-03_JPRB,1.6327E-03_JPRB,1.3347E-03_JPRB,5.5864E-03_JPRB/)
KBO( :, 1,17, 5) = (/&
&2.3152E-04_JPRB,4.5640E-04_JPRB,4.7753E-04_JPRB,4.7152E-04_JPRB,2.6479E-03_JPRB/)
KBO( :, 2,17, 5) = (/&
&3.3215E-04_JPRB,6.2600E-04_JPRB,6.3690E-04_JPRB,5.8069E-04_JPRB,3.0163E-03_JPRB/)
KBO( :, 3,17, 5) = (/&
&4.6960E-04_JPRB,8.4466E-04_JPRB,8.4113E-04_JPRB,7.2795E-04_JPRB,3.3924E-03_JPRB/)
KBO( :, 4,17, 5) = (/&
&6.4890E-04_JPRB,1.1190E-03_JPRB,1.0981E-03_JPRB,9.1560E-04_JPRB,3.7876E-03_JPRB/)
KBO( :, 5,17, 5) = (/&
&8.7357E-04_JPRB,1.4542E-03_JPRB,1.4067E-03_JPRB,1.1490E-03_JPRB,4.2015E-03_JPRB/)
KBO( :, 1,18, 5) = (/&
&1.9932E-04_JPRB,3.9153E-04_JPRB,4.0894E-04_JPRB,3.9983E-04_JPRB,2.0392E-03_JPRB/)
KBO( :, 2,18, 5) = (/&
&2.8740E-04_JPRB,5.3802E-04_JPRB,5.4670E-04_JPRB,4.9548E-04_JPRB,2.3218E-03_JPRB/)
KBO( :, 3,18, 5) = (/&
&4.0688E-04_JPRB,7.2769E-04_JPRB,7.2473E-04_JPRB,6.2367E-04_JPRB,2.6171E-03_JPRB/)
KBO( :, 4,18, 5) = (/&
&5.6212E-04_JPRB,9.6442E-04_JPRB,9.4622E-04_JPRB,7.8767E-04_JPRB,2.9286E-03_JPRB/)
KBO( :, 5,18, 5) = (/&
&7.5657E-04_JPRB,1.2523E-03_JPRB,1.2126E-03_JPRB,9.8987E-04_JPRB,3.2584E-03_JPRB/)
KBO( :, 1,19, 5) = (/&
&1.7300E-04_JPRB,3.3615E-04_JPRB,3.5010E-04_JPRB,3.3920E-04_JPRB,1.6249E-03_JPRB/)
KBO( :, 2,19, 5) = (/&
&2.4990E-04_JPRB,4.6314E-04_JPRB,4.6930E-04_JPRB,4.2253E-04_JPRB,1.8509E-03_JPRB/)
KBO( :, 3,19, 5) = (/&
&3.5374E-04_JPRB,6.2681E-04_JPRB,6.2354E-04_JPRB,5.3462E-04_JPRB,2.0903E-03_JPRB/)
KBO( :, 4,19, 5) = (/&
&4.8808E-04_JPRB,8.3000E-04_JPRB,8.1368E-04_JPRB,6.7693E-04_JPRB,2.3442E-03_JPRB/)
KBO( :, 5,19, 5) = (/&
&6.5622E-04_JPRB,1.0763E-03_JPRB,1.0415E-03_JPRB,8.5100E-04_JPRB,2.6149E-03_JPRB/)
KBO( :, 1,20, 5) = (/&
&1.5202E-04_JPRB,2.9089E-04_JPRB,3.0118E-04_JPRB,2.8847E-04_JPRB,1.3195E-03_JPRB/)
KBO( :, 2,20, 5) = (/&
&2.1947E-04_JPRB,4.0137E-04_JPRB,4.0488E-04_JPRB,3.6160E-04_JPRB,1.5051E-03_JPRB/)
KBO( :, 3,20, 5) = (/&
&3.1005E-04_JPRB,5.4229E-04_JPRB,5.3773E-04_JPRB,4.5934E-04_JPRB,1.7011E-03_JPRB/)
KBO( :, 4,20, 5) = (/&
&4.2687E-04_JPRB,7.1641E-04_JPRB,7.0062E-04_JPRB,5.8213E-04_JPRB,1.9126E-03_JPRB/)
KBO( :, 5,20, 5) = (/&
&5.7243E-04_JPRB,9.2825E-04_JPRB,8.9565E-04_JPRB,7.3135E-04_JPRB,2.1352E-03_JPRB/)
KBO( :, 1,21, 5) = (/&
&1.3342E-04_JPRB,2.5207E-04_JPRB,2.5927E-04_JPRB,2.4529E-04_JPRB,1.0741E-03_JPRB/)
KBO( :, 2,21, 5) = (/&
&1.9233E-04_JPRB,3.4753E-04_JPRB,3.4906E-04_JPRB,3.0934E-04_JPRB,1.2262E-03_JPRB/)
KBO( :, 3,21, 5) = (/&
&2.7108E-04_JPRB,4.6836E-04_JPRB,4.6295E-04_JPRB,3.9387E-04_JPRB,1.3885E-03_JPRB/)
KBO( :, 4,21, 5) = (/&
&3.7228E-04_JPRB,6.1777E-04_JPRB,6.0200E-04_JPRB,4.9887E-04_JPRB,1.5626E-03_JPRB/)
KBO( :, 5,21, 5) = (/&
&4.9911E-04_JPRB,7.9951E-04_JPRB,7.6864E-04_JPRB,6.2637E-04_JPRB,1.7443E-03_JPRB/)
KBO( :, 1,22, 5) = (/&
&1.1876E-04_JPRB,2.2232E-04_JPRB,2.2723E-04_JPRB,2.1144E-04_JPRB,8.6475E-04_JPRB/)
KBO( :, 2,22, 5) = (/&
&1.7098E-04_JPRB,3.0547E-04_JPRB,3.0556E-04_JPRB,2.6827E-04_JPRB,9.8817E-04_JPRB/)
KBO( :, 3,22, 5) = (/&
&2.4024E-04_JPRB,4.1043E-04_JPRB,4.0412E-04_JPRB,3.4171E-04_JPRB,1.1213E-03_JPRB/)
KBO( :, 4,22, 5) = (/&
&3.2954E-04_JPRB,5.4028E-04_JPRB,5.2414E-04_JPRB,4.3238E-04_JPRB,1.2619E-03_JPRB/)
KBO( :, 5,22, 5) = (/&
&4.4187E-04_JPRB,6.9761E-04_JPRB,6.6809E-04_JPRB,5.4249E-04_JPRB,1.4080E-03_JPRB/)
KBO( :, 1,23, 5) = (/&
&1.0533E-04_JPRB,1.9573E-04_JPRB,1.9910E-04_JPRB,1.8269E-04_JPRB,6.9257E-04_JPRB/)
KBO( :, 2,23, 5) = (/&
&1.5155E-04_JPRB,2.6816E-04_JPRB,2.6720E-04_JPRB,2.3262E-04_JPRB,7.9308E-04_JPRB/)
KBO( :, 3,23, 5) = (/&
&2.1274E-04_JPRB,3.5921E-04_JPRB,3.5244E-04_JPRB,2.9616E-04_JPRB,9.0068E-04_JPRB/)
KBO( :, 4,23, 5) = (/&
&2.9190E-04_JPRB,4.7191E-04_JPRB,4.5593E-04_JPRB,3.7445E-04_JPRB,1.0136E-03_JPRB/)
KBO( :, 5,23, 5) = (/&
&3.9138E-04_JPRB,6.0878E-04_JPRB,5.8059E-04_JPRB,4.6968E-04_JPRB,1.1306E-03_JPRB/)
KBO( :, 1,24, 5) = (/&
&9.2582E-05_JPRB,1.7167E-04_JPRB,1.7398E-04_JPRB,1.5781E-04_JPRB,5.4677E-04_JPRB/)
KBO( :, 2,24, 5) = (/&
&1.3344E-04_JPRB,2.3456E-04_JPRB,2.3315E-04_JPRB,2.0139E-04_JPRB,6.2782E-04_JPRB/)
KBO( :, 3,24, 5) = (/&
&1.8769E-04_JPRB,3.1365E-04_JPRB,3.0670E-04_JPRB,2.5637E-04_JPRB,7.1420E-04_JPRB/)
KBO( :, 4,24, 5) = (/&
&2.5773E-04_JPRB,4.1174E-04_JPRB,3.9630E-04_JPRB,3.2402E-04_JPRB,8.0431E-04_JPRB/)
KBO( :, 5,24, 5) = (/&
&3.4549E-04_JPRB,5.3124E-04_JPRB,5.0449E-04_JPRB,4.0653E-04_JPRB,8.9759E-04_JPRB/)
KBO( :, 1,25, 5) = (/&
&8.1720E-05_JPRB,1.5080E-04_JPRB,1.5235E-04_JPRB,1.3662E-04_JPRB,4.3240E-04_JPRB/)
KBO( :, 2,25, 5) = (/&
&1.1805E-04_JPRB,2.0558E-04_JPRB,2.0367E-04_JPRB,1.7460E-04_JPRB,4.9748E-04_JPRB/)
KBO( :, 3,25, 5) = (/&
&1.6632E-04_JPRB,2.7459E-04_JPRB,2.6746E-04_JPRB,2.2227E-04_JPRB,5.6662E-04_JPRB/)
KBO( :, 4,25, 5) = (/&
&2.2820E-04_JPRB,3.6032E-04_JPRB,3.4539E-04_JPRB,2.8107E-04_JPRB,6.3853E-04_JPRB/)
KBO( :, 5,25, 5) = (/&
&3.0509E-04_JPRB,4.6497E-04_JPRB,4.3993E-04_JPRB,3.5289E-04_JPRB,7.1328E-04_JPRB/)
KBO( :, 1,26, 5) = (/&
&7.3023E-05_JPRB,1.3337E-04_JPRB,1.3413E-04_JPRB,1.1892E-04_JPRB,3.4584E-04_JPRB/)
KBO( :, 2,26, 5) = (/&
&1.0560E-04_JPRB,1.8141E-04_JPRB,1.7894E-04_JPRB,1.5213E-04_JPRB,3.9839E-04_JPRB/)
KBO( :, 3,26, 5) = (/&
&1.4861E-04_JPRB,2.4208E-04_JPRB,2.3462E-04_JPRB,1.9371E-04_JPRB,4.5384E-04_JPRB/)
KBO( :, 4,26, 5) = (/&
&2.0313E-04_JPRB,3.1741E-04_JPRB,3.0291E-04_JPRB,2.4516E-04_JPRB,5.1150E-04_JPRB/)
KBO( :, 5,26, 5) = (/&
&2.7025E-04_JPRB,4.0891E-04_JPRB,3.8585E-04_JPRB,3.0810E-04_JPRB,5.7158E-04_JPRB/)
KBO( :, 1,27, 5) = (/&
&6.5244E-05_JPRB,1.1779E-04_JPRB,1.1796E-04_JPRB,1.0347E-04_JPRB,2.7274E-04_JPRB/)
KBO( :, 2,27, 5) = (/&
&9.4317E-05_JPRB,1.6003E-04_JPRB,1.5711E-04_JPRB,1.3251E-04_JPRB,3.1462E-04_JPRB/)
KBO( :, 3,27, 5) = (/&
&1.3235E-04_JPRB,2.1338E-04_JPRB,2.0578E-04_JPRB,1.6888E-04_JPRB,3.5874E-04_JPRB/)
KBO( :, 4,27, 5) = (/&
&1.7994E-04_JPRB,2.7923E-04_JPRB,2.6567E-04_JPRB,2.1397E-04_JPRB,4.0423E-04_JPRB/)
KBO( :, 5,27, 5) = (/&
&2.3815E-04_JPRB,3.5878E-04_JPRB,3.3808E-04_JPRB,2.6908E-04_JPRB,4.5194E-04_JPRB/)
KBO( :, 1,28, 5) = (/&
&5.8135E-05_JPRB,1.0393E-04_JPRB,1.0358E-04_JPRB,8.9974E-05_JPRB,2.1186E-04_JPRB/)
KBO( :, 2,28, 5) = (/&
&8.3922E-05_JPRB,1.4106E-04_JPRB,1.3783E-04_JPRB,1.1539E-04_JPRB,2.4486E-04_JPRB/)
KBO( :, 3,28, 5) = (/&
&1.1719E-04_JPRB,1.8771E-04_JPRB,1.8042E-04_JPRB,1.4725E-04_JPRB,2.7921E-04_JPRB/)
KBO( :, 4,28, 5) = (/&
&1.5846E-04_JPRB,2.4498E-04_JPRB,2.3269E-04_JPRB,1.8682E-04_JPRB,3.1493E-04_JPRB/)
KBO( :, 5,28, 5) = (/&
&2.0834E-04_JPRB,3.1383E-04_JPRB,2.9568E-04_JPRB,2.3488E-04_JPRB,3.5235E-04_JPRB/)
KBO( :, 1,29, 5) = (/&
&5.2156E-05_JPRB,9.2110E-05_JPRB,9.1288E-05_JPRB,7.8487E-05_JPRB,1.6379E-04_JPRB/)
KBO( :, 2,29, 5) = (/&
&7.4907E-05_JPRB,1.2474E-04_JPRB,1.2134E-04_JPRB,1.0081E-04_JPRB,1.8924E-04_JPRB/)
KBO( :, 3,29, 5) = (/&
&1.0389E-04_JPRB,1.6543E-04_JPRB,1.5862E-04_JPRB,1.2884E-04_JPRB,2.1564E-04_JPRB/)
KBO( :, 4,29, 5) = (/&
&1.3949E-04_JPRB,2.1507E-04_JPRB,2.0416E-04_JPRB,1.6349E-04_JPRB,2.4336E-04_JPRB/)
KBO( :, 5,29, 5) = (/&
&1.8193E-04_JPRB,2.7457E-04_JPRB,2.5880E-04_JPRB,2.0529E-04_JPRB,2.7230E-04_JPRB/)
KBO( :, 1,30, 5) = (/&
&4.6665E-05_JPRB,8.1578E-05_JPRB,8.0475E-05_JPRB,6.8545E-05_JPRB,1.2523E-04_JPRB/)
KBO( :, 2,30, 5) = (/&
&6.6590E-05_JPRB,1.1011E-04_JPRB,1.0677E-04_JPRB,8.8175E-05_JPRB,1.4448E-04_JPRB/)
KBO( :, 3,30, 5) = (/&
&9.1666E-05_JPRB,1.4544E-04_JPRB,1.3932E-04_JPRB,1.1280E-04_JPRB,1.6467E-04_JPRB/)
KBO( :, 4,30, 5) = (/&
&1.2214E-04_JPRB,1.8830E-04_JPRB,1.7882E-04_JPRB,1.4301E-04_JPRB,1.8584E-04_JPRB/)
KBO( :, 5,30, 5) = (/&
&1.5808E-04_JPRB,2.3937E-04_JPRB,2.2601E-04_JPRB,1.7927E-04_JPRB,2.0804E-04_JPRB/)
KBO( :, 1,31, 5) = (/&
&4.1774E-05_JPRB,7.2293E-05_JPRB,7.1044E-05_JPRB,6.0014E-05_JPRB,9.4404E-05_JPRB/)
KBO( :, 2,31, 5) = (/&
&5.9153E-05_JPRB,9.7142E-05_JPRB,9.4034E-05_JPRB,7.7303E-05_JPRB,1.0876E-04_JPRB/)
KBO( :, 3,31, 5) = (/&
&8.0749E-05_JPRB,1.2773E-04_JPRB,1.2231E-04_JPRB,9.8861E-05_JPRB,1.2383E-04_JPRB/)
KBO( :, 4,31, 5) = (/&
&1.0665E-04_JPRB,1.6459E-04_JPRB,1.5646E-04_JPRB,1.2511E-04_JPRB,1.3969E-04_JPRB/)
KBO( :, 5,31, 5) = (/&
&1.3708E-04_JPRB,2.0815E-04_JPRB,1.9687E-04_JPRB,1.5634E-04_JPRB,1.5670E-04_JPRB/)
KBO( :, 1,32, 5) = (/&
&3.7360E-05_JPRB,6.4042E-05_JPRB,6.2763E-05_JPRB,5.2674E-05_JPRB,7.1295E-05_JPRB/)
KBO( :, 2,32, 5) = (/&
&5.2458E-05_JPRB,8.5627E-05_JPRB,8.2786E-05_JPRB,6.7846E-05_JPRB,8.1990E-05_JPRB/)
KBO( :, 3,32, 5) = (/&
&7.0948E-05_JPRB,1.1205E-04_JPRB,1.0732E-04_JPRB,8.6659E-05_JPRB,9.3329E-05_JPRB/)
KBO( :, 4,32, 5) = (/&
&9.2912E-05_JPRB,1.4361E-04_JPRB,1.3667E-04_JPRB,1.0937E-04_JPRB,1.0550E-04_JPRB/)
KBO( :, 5,32, 5) = (/&
&1.1872E-04_JPRB,1.8058E-04_JPRB,1.7108E-04_JPRB,1.3607E-04_JPRB,1.1861E-04_JPRB/)
KBO( :, 1,33, 5) = (/&
&3.3330E-05_JPRB,5.6651E-05_JPRB,5.5404E-05_JPRB,4.6257E-05_JPRB,5.3603E-05_JPRB/)
KBO( :, 2,33, 5) = (/&
&4.6366E-05_JPRB,7.5365E-05_JPRB,7.2815E-05_JPRB,5.9541E-05_JPRB,6.1709E-05_JPRB/)
KBO( :, 3,33, 5) = (/&
&6.2117E-05_JPRB,9.8064E-05_JPRB,9.4002E-05_JPRB,7.5880E-05_JPRB,7.0404E-05_JPRB/)
KBO( :, 4,33, 5) = (/&
&8.0785E-05_JPRB,1.2503E-04_JPRB,1.1911E-04_JPRB,9.5440E-05_JPRB,7.9842E-05_JPRB/)
KBO( :, 5,33, 5) = (/&
&1.0266E-04_JPRB,1.5642E-04_JPRB,1.4831E-04_JPRB,1.1813E-04_JPRB,8.9956E-05_JPRB/)
KBO( :, 1,34, 5) = (/&
&2.9453E-05_JPRB,4.9674E-05_JPRB,4.8494E-05_JPRB,4.0330E-05_JPRB,4.1449E-05_JPRB/)
KBO( :, 2,34, 5) = (/&
&4.0587E-05_JPRB,6.5763E-05_JPRB,6.3519E-05_JPRB,5.1852E-05_JPRB,4.7772E-05_JPRB/)
KBO( :, 3,34, 5) = (/&
&5.3941E-05_JPRB,8.5109E-05_JPRB,8.1613E-05_JPRB,6.5908E-05_JPRB,5.4645E-05_JPRB/)
KBO( :, 4,34, 5) = (/&
&6.9742E-05_JPRB,1.0800E-04_JPRB,1.0292E-04_JPRB,8.2540E-05_JPRB,6.2110E-05_JPRB/)
KBO( :, 5,34, 5) = (/&
&8.8248E-05_JPRB,1.3461E-04_JPRB,1.2764E-04_JPRB,1.0173E-04_JPRB,7.0115E-05_JPRB/)
KBO( :, 1,35, 5) = (/&
&2.5087E-05_JPRB,4.2259E-05_JPRB,4.1255E-05_JPRB,3.4275E-05_JPRB,3.1533E-05_JPRB/)
KBO( :, 2,35, 5) = (/&
&3.4377E-05_JPRB,5.5779E-05_JPRB,5.3928E-05_JPRB,4.4037E-05_JPRB,3.6467E-05_JPRB/)
KBO( :, 3,35, 5) = (/&
&4.5509E-05_JPRB,7.1962E-05_JPRB,6.9073E-05_JPRB,5.5855E-05_JPRB,4.1858E-05_JPRB/)
KBO( :, 4,35, 5) = (/&
&5.8672E-05_JPRB,9.1085E-05_JPRB,8.6867E-05_JPRB,6.9736E-05_JPRB,4.7718E-05_JPRB/)
KBO( :, 5,35, 5) = (/&
&7.4086E-05_JPRB,1.1331E-04_JPRB,1.0750E-04_JPRB,8.5753E-05_JPRB,5.3964E-05_JPRB/)
KBO( :, 1,36, 5) = (/&
&2.0525E-05_JPRB,3.4767E-05_JPRB,3.4001E-05_JPRB,2.8297E-05_JPRB,2.3548E-05_JPRB/)
KBO( :, 2,36, 5) = (/&
&2.8104E-05_JPRB,4.5872E-05_JPRB,4.4441E-05_JPRB,3.6357E-05_JPRB,2.7355E-05_JPRB/)
KBO( :, 3,36, 5) = (/&
&3.7199E-05_JPRB,5.9142E-05_JPRB,5.6864E-05_JPRB,4.6074E-05_JPRB,3.1516E-05_JPRB/)
KBO( :, 4,36, 5) = (/&
&4.7973E-05_JPRB,7.4842E-05_JPRB,7.1480E-05_JPRB,5.7473E-05_JPRB,3.6056E-05_JPRB/)
KBO( :, 5,36, 5) = (/&
&6.0589E-05_JPRB,9.3078E-05_JPRB,8.8416E-05_JPRB,7.0645E-05_JPRB,4.0905E-05_JPRB/)
KBO( :, 1,37, 5) = (/&
&1.6118E-05_JPRB,2.7523E-05_JPRB,2.6979E-05_JPRB,2.2543E-05_JPRB,1.8010E-05_JPRB/)
KBO( :, 2,37, 5) = (/&
&2.2165E-05_JPRB,3.6407E-05_JPRB,3.5348E-05_JPRB,2.9008E-05_JPRB,2.0983E-05_JPRB/)
KBO( :, 3,37, 5) = (/&
&2.9444E-05_JPRB,4.7055E-05_JPRB,4.5326E-05_JPRB,3.6808E-05_JPRB,2.4249E-05_JPRB/)
KBO( :, 4,37, 5) = (/&
&3.8081E-05_JPRB,5.9681E-05_JPRB,5.7081E-05_JPRB,4.5982E-05_JPRB,2.7813E-05_JPRB/)
KBO( :, 5,37, 5) = (/&
&4.8212E-05_JPRB,7.4374E-05_JPRB,7.0740E-05_JPRB,5.6602E-05_JPRB,3.1635E-05_JPRB/)
KBO( :, 1,38, 5) = (/&
&1.2610E-05_JPRB,2.1718E-05_JPRB,2.1343E-05_JPRB,1.7908E-05_JPRB,1.3720E-05_JPRB/)
KBO( :, 2,38, 5) = (/&
&1.7424E-05_JPRB,2.8812E-05_JPRB,2.8034E-05_JPRB,2.3079E-05_JPRB,1.6034E-05_JPRB/)
KBO( :, 3,38, 5) = (/&
&2.3240E-05_JPRB,3.7339E-05_JPRB,3.6033E-05_JPRB,2.9331E-05_JPRB,1.8589E-05_JPRB/)
KBO( :, 4,38, 5) = (/&
&3.0149E-05_JPRB,4.7476E-05_JPRB,4.5479E-05_JPRB,3.6700E-05_JPRB,2.1382E-05_JPRB/)
KBO( :, 5,38, 5) = (/&
&3.8276E-05_JPRB,5.9294E-05_JPRB,5.6476E-05_JPRB,4.5256E-05_JPRB,2.4387E-05_JPRB/)
KBO( :, 1,39, 5) = (/&
&9.8494E-06_JPRB,1.7119E-05_JPRB,1.6865E-05_JPRB,1.4215E-05_JPRB,1.0374E-05_JPRB/)
KBO( :, 2,39, 5) = (/&
&1.3680E-05_JPRB,2.2781E-05_JPRB,2.2215E-05_JPRB,1.8350E-05_JPRB,1.2167E-05_JPRB/)
KBO( :, 3,39, 5) = (/&
&1.8324E-05_JPRB,2.9603E-05_JPRB,2.8623E-05_JPRB,2.3356E-05_JPRB,1.4153E-05_JPRB/)
KBO( :, 4,39, 5) = (/&
&2.3849E-05_JPRB,3.7739E-05_JPRB,3.6208E-05_JPRB,2.9278E-05_JPRB,1.6336E-05_JPRB/)
KBO( :, 5,39, 5) = (/&
&3.0362E-05_JPRB,4.7240E-05_JPRB,4.5057E-05_JPRB,3.6164E-05_JPRB,1.8690E-05_JPRB/)
KBO( :, 1,40, 5) = (/&
&7.4339E-06_JPRB,1.3096E-05_JPRB,1.2949E-05_JPRB,1.0994E-05_JPRB,7.9222E-06_JPRB/)
KBO( :, 2,40, 5) = (/&
&1.0423E-05_JPRB,1.7529E-05_JPRB,1.7143E-05_JPRB,1.4230E-05_JPRB,9.3215E-06_JPRB/)
KBO( :, 3,40, 5) = (/&
&1.4064E-05_JPRB,2.2897E-05_JPRB,2.2194E-05_JPRB,1.8169E-05_JPRB,1.0878E-05_JPRB/)
KBO( :, 4,40, 5) = (/&
&1.8421E-05_JPRB,2.9319E-05_JPRB,2.8191E-05_JPRB,2.2850E-05_JPRB,1.2595E-05_JPRB/)
KBO( :, 5,40, 5) = (/&
&2.3560E-05_JPRB,3.6849E-05_JPRB,3.5209E-05_JPRB,2.8311E-05_JPRB,1.4456E-05_JPRB/)
KBO( :, 1,41, 5) = (/&
&5.5704E-06_JPRB,9.9619E-06_JPRB,9.8891E-06_JPRB,8.4654E-06_JPRB,6.0394E-06_JPRB/)
KBO( :, 2,41, 5) = (/&
&7.8899E-06_JPRB,1.3424E-05_JPRB,1.3166E-05_JPRB,1.0990E-05_JPRB,7.1317E-06_JPRB/)
KBO( :, 3,41, 5) = (/&
&1.0739E-05_JPRB,1.7632E-05_JPRB,1.7133E-05_JPRB,1.4077E-05_JPRB,8.3487E-06_JPRB/)
KBO( :, 4,41, 5) = (/&
&1.4162E-05_JPRB,2.2683E-05_JPRB,2.1860E-05_JPRB,1.7767E-05_JPRB,9.6986E-06_JPRB/)
KBO( :, 5,41, 5) = (/&
&1.8206E-05_JPRB,2.8635E-05_JPRB,2.7414E-05_JPRB,2.2091E-05_JPRB,1.1170E-05_JPRB/)
KBO( :, 1,42, 5) = (/&
&4.1581E-06_JPRB,7.5591E-06_JPRB,7.5361E-06_JPRB,6.5108E-06_JPRB,4.5852E-06_JPRB/)
KBO( :, 2,42, 5) = (/&
&5.9538E-06_JPRB,1.0259E-05_JPRB,1.0094E-05_JPRB,8.4784E-06_JPRB,5.4324E-06_JPRB/)
KBO( :, 3,42, 5) = (/&
&8.1801E-06_JPRB,1.3552E-05_JPRB,1.3202E-05_JPRB,1.0892E-05_JPRB,6.3816E-06_JPRB/)
KBO( :, 4,42, 5) = (/&
&1.0865E-05_JPRB,1.7520E-05_JPRB,1.6925E-05_JPRB,1.3796E-05_JPRB,7.4382E-06_JPRB/)
KBO( :, 5,42, 5) = (/&
&1.4044E-05_JPRB,2.2222E-05_JPRB,2.1312E-05_JPRB,1.7215E-05_JPRB,8.5974E-06_JPRB/)
KBO( :, 1,43, 5) = (/&
&3.0295E-06_JPRB,5.6227E-06_JPRB,5.6370E-06_JPRB,4.9291E-06_JPRB,3.4644E-06_JPRB/)
KBO( :, 2,43, 5) = (/&
&4.3992E-06_JPRB,7.7006E-06_JPRB,7.6071E-06_JPRB,6.4406E-06_JPRB,4.1177E-06_JPRB/)
KBO( :, 3,43, 5) = (/&
&6.1168E-06_JPRB,1.0248E-05_JPRB,1.0014E-05_JPRB,8.3065E-06_JPRB,4.8541E-06_JPRB/)
KBO( :, 4,43, 5) = (/&
&8.2022E-06_JPRB,1.3332E-05_JPRB,1.2916E-05_JPRB,1.0567E-05_JPRB,5.6783E-06_JPRB/)
KBO( :, 5,43, 5) = (/&
&1.0679E-05_JPRB,1.7006E-05_JPRB,1.6348E-05_JPRB,1.3242E-05_JPRB,6.5871E-06_JPRB/)
KBO( :, 1,44, 5) = (/&
&2.1752E-06_JPRB,4.1354E-06_JPRB,4.1745E-06_JPRB,3.7028E-06_JPRB,2.6072E-06_JPRB/)
KBO( :, 2,44, 5) = (/&
&3.2105E-06_JPRB,5.7219E-06_JPRB,5.6778E-06_JPRB,4.8546E-06_JPRB,3.1066E-06_JPRB/)
KBO( :, 3,44, 5) = (/&
&4.5242E-06_JPRB,7.6797E-06_JPRB,7.5307E-06_JPRB,6.2874E-06_JPRB,3.6742E-06_JPRB/)
KBO( :, 4,44, 5) = (/&
&6.1342E-06_JPRB,1.0065E-05_JPRB,9.7795E-06_JPRB,8.0353E-06_JPRB,4.3146E-06_JPRB/)
KBO( :, 5,44, 5) = (/&
&8.0572E-06_JPRB,1.2919E-05_JPRB,1.2450E-05_JPRB,1.0118E-05_JPRB,5.0246E-06_JPRB/)
KBO( :, 1,45, 5) = (/&
&1.5520E-06_JPRB,3.0304E-06_JPRB,3.0821E-06_JPRB,2.7797E-06_JPRB,1.9539E-06_JPRB/)
KBO( :, 2,45, 5) = (/&
&2.3304E-06_JPRB,4.2364E-06_JPRB,4.2250E-06_JPRB,3.6531E-06_JPRB,2.3326E-06_JPRB/)
KBO( :, 3,45, 5) = (/&
&3.3303E-06_JPRB,5.7394E-06_JPRB,5.6502E-06_JPRB,4.7523E-06_JPRB,2.7664E-06_JPRB/)
KBO( :, 4,45, 5) = (/&
&4.5711E-06_JPRB,7.5789E-06_JPRB,7.3862E-06_JPRB,6.0991E-06_JPRB,3.2606E-06_JPRB/)
KBO( :, 5,45, 5) = (/&
&6.0612E-06_JPRB,9.7914E-06_JPRB,9.4635E-06_JPRB,7.7174E-06_JPRB,3.8129E-06_JPRB/)
KBO( :, 1,46, 5) = (/&
&1.0896E-06_JPRB,2.1957E-06_JPRB,2.2531E-06_JPRB,2.0749E-06_JPRB,1.4595E-06_JPRB/)
KBO( :, 2,46, 5) = (/&
&1.6682E-06_JPRB,3.1035E-06_JPRB,3.1144E-06_JPRB,2.7296E-06_JPRB,1.7441E-06_JPRB/)
KBO( :, 3,46, 5) = (/&
&2.4227E-06_JPRB,4.2500E-06_JPRB,4.2020E-06_JPRB,3.5671E-06_JPRB,2.0729E-06_JPRB/)
KBO( :, 4,46, 5) = (/&
&3.3718E-06_JPRB,5.6598E-06_JPRB,5.5353E-06_JPRB,4.5977E-06_JPRB,2.4518E-06_JPRB/)
KBO( :, 5,46, 5) = (/&
&4.5215E-06_JPRB,7.3662E-06_JPRB,7.1417E-06_JPRB,5.8470E-06_JPRB,2.8782E-06_JPRB/)
KBO( :, 1,47, 5) = (/&
&7.4469E-07_JPRB,1.5605E-06_JPRB,1.6200E-06_JPRB,1.5335E-06_JPRB,1.0893E-06_JPRB/)
KBO( :, 2,47, 5) = (/&
&1.1672E-06_JPRB,2.2327E-06_JPRB,2.2585E-06_JPRB,2.0143E-06_JPRB,1.3019E-06_JPRB/)
KBO( :, 3,47, 5) = (/&
&1.7284E-06_JPRB,3.0966E-06_JPRB,3.0782E-06_JPRB,2.6442E-06_JPRB,1.5506E-06_JPRB/)
KBO( :, 4,47, 5) = (/&
&2.4447E-06_JPRB,4.1671E-06_JPRB,4.0916E-06_JPRB,3.4253E-06_JPRB,1.8389E-06_JPRB/)
KBO( :, 5,47, 5) = (/&
&3.3234E-06_JPRB,5.4710E-06_JPRB,5.3227E-06_JPRB,4.3793E-06_JPRB,2.1666E-06_JPRB/)
KBO( :, 1,48, 5) = (/&
&5.0356E-07_JPRB,1.1031E-06_JPRB,1.1612E-06_JPRB,1.1366E-06_JPRB,8.1111E-07_JPRB/)
KBO( :, 2,48, 5) = (/&
&8.0967E-07_JPRB,1.5982E-06_JPRB,1.6316E-06_JPRB,1.4855E-06_JPRB,9.6803E-07_JPRB/)
KBO( :, 3,48, 5) = (/&
&1.2240E-06_JPRB,2.2449E-06_JPRB,2.2458E-06_JPRB,1.9554E-06_JPRB,1.1545E-06_JPRB/)
KBO( :, 4,48, 5) = (/&
&1.7609E-06_JPRB,3.0561E-06_JPRB,3.0144E-06_JPRB,2.5471E-06_JPRB,1.3716E-06_JPRB/)
KBO( :, 5,48, 5) = (/&
&2.4302E-06_JPRB,4.0500E-06_JPRB,3.9537E-06_JPRB,3.2729E-06_JPRB,1.6214E-06_JPRB/)
KBO( :, 1,49, 5) = (/&
&3.3669E-07_JPRB,7.7562E-07_JPRB,8.3013E-07_JPRB,8.4661E-07_JPRB,6.0239E-07_JPRB/)
KBO( :, 2,49, 5) = (/&
&5.5618E-07_JPRB,1.1378E-06_JPRB,1.1737E-06_JPRB,1.0960E-06_JPRB,7.1701E-07_JPRB/)
KBO( :, 3,49, 5) = (/&
&8.5966E-07_JPRB,1.6189E-06_JPRB,1.6315E-06_JPRB,1.4432E-06_JPRB,8.5489E-07_JPRB/)
KBO( :, 4,49, 5) = (/&
&1.2600E-06_JPRB,2.2310E-06_JPRB,2.2122E-06_JPRB,1.8904E-06_JPRB,1.0169E-06_JPRB/)
KBO( :, 5,49, 5) = (/&
&1.7668E-06_JPRB,2.9864E-06_JPRB,2.9265E-06_JPRB,2.4403E-06_JPRB,1.2053E-06_JPRB/)
KBO( :, 1,50, 5) = (/&
&2.2597E-07_JPRB,5.4865E-07_JPRB,5.9834E-07_JPRB,6.3972E-07_JPRB,4.5578E-07_JPRB/)
KBO( :, 2,50, 5) = (/&
&3.8336E-07_JPRB,8.1421E-07_JPRB,8.4965E-07_JPRB,8.1592E-07_JPRB,5.4000E-07_JPRB/)
KBO( :, 3,50, 5) = (/&
&6.0620E-07_JPRB,1.1725E-06_JPRB,1.1909E-06_JPRB,1.0720E-06_JPRB,6.4348E-07_JPRB/)
KBO( :, 4,50, 5) = (/&
&9.0494E-07_JPRB,1.6354E-06_JPRB,1.6304E-06_JPRB,1.4100E-06_JPRB,7.6597E-07_JPRB/)
KBO( :, 5,50, 5) = (/&
&1.2886E-06_JPRB,2.2119E-06_JPRB,2.1763E-06_JPRB,1.8292E-06_JPRB,9.0912E-07_JPRB/)
KBO( :, 1,51, 5) = (/&
&1.5102E-07_JPRB,3.8839E-07_JPRB,4.3315E-07_JPRB,4.8969E-07_JPRB,3.4866E-07_JPRB/)
KBO( :, 2,51, 5) = (/&
&2.6341E-07_JPRB,5.8277E-07_JPRB,6.1614E-07_JPRB,6.1112E-07_JPRB,4.1018E-07_JPRB/)
KBO( :, 3,51, 5) = (/&
&4.2666E-07_JPRB,8.4914E-07_JPRB,8.6978E-07_JPRB,7.9868E-07_JPRB,4.8807E-07_JPRB/)
KBO( :, 4,51, 5) = (/&
&6.4908E-07_JPRB,1.1984E-06_JPRB,1.2019E-06_JPRB,1.0530E-06_JPRB,5.8123E-07_JPRB/)
KBO( :, 5,51, 5) = (/&
&9.3904E-07_JPRB,1.6385E-06_JPRB,1.6190E-06_JPRB,1.3734E-06_JPRB,6.9028E-07_JPRB/)
KBO( :, 1,52, 5) = (/&
&9.9875E-08_JPRB,2.7392E-07_JPRB,3.1411E-07_JPRB,3.7992E-07_JPRB,2.6732E-07_JPRB/)
KBO( :, 2,52, 5) = (/&
&1.7936E-07_JPRB,4.1537E-07_JPRB,4.4601E-07_JPRB,4.6002E-07_JPRB,3.1160E-07_JPRB/)
KBO( :, 3,52, 5) = (/&
&2.9800E-07_JPRB,6.1230E-07_JPRB,6.3323E-07_JPRB,5.9558E-07_JPRB,3.6937E-07_JPRB/)
KBO( :, 4,52, 5) = (/&
&4.6262E-07_JPRB,8.7457E-07_JPRB,8.8316E-07_JPRB,7.8544E-07_JPRB,4.3987E-07_JPRB/)
KBO( :, 5,52, 5) = (/&
&6.8072E-07_JPRB,1.2094E-06_JPRB,1.2006E-06_JPRB,1.0296E-06_JPRB,5.2264E-07_JPRB/)
KBO( :, 1,53, 5) = (/&
&6.5343E-08_JPRB,1.9251E-07_JPRB,2.2851E-07_JPRB,2.9947E-07_JPRB,2.0556E-07_JPRB/)
KBO( :, 2,53, 5) = (/&
&1.2091E-07_JPRB,2.9469E-07_JPRB,3.2248E-07_JPRB,3.4877E-07_JPRB,2.3686E-07_JPRB/)
KBO( :, 3,53, 5) = (/&
&2.0627E-07_JPRB,4.3946E-07_JPRB,4.5963E-07_JPRB,4.4471E-07_JPRB,2.7889E-07_JPRB/)
KBO( :, 4,53, 5) = (/&
&3.2743E-07_JPRB,6.3522E-07_JPRB,6.4653E-07_JPRB,5.8508E-07_JPRB,3.3168E-07_JPRB/)
KBO( :, 5,53, 5) = (/&
&4.9060E-07_JPRB,8.8881E-07_JPRB,8.8708E-07_JPRB,7.7003E-07_JPRB,3.9409E-07_JPRB/)
KBO( :, 1,54, 5) = (/&
&4.3306E-08_JPRB,1.3699E-07_JPRB,1.6897E-07_JPRB,2.4035E-07_JPRB,1.6171E-07_JPRB/)
KBO( :, 2,54, 5) = (/&
&8.2182E-08_JPRB,2.1109E-07_JPRB,2.3589E-07_JPRB,2.6887E-07_JPRB,1.8465E-07_JPRB/)
KBO( :, 3,54, 5) = (/&
&1.4392E-07_JPRB,3.1803E-07_JPRB,3.3664E-07_JPRB,3.3573E-07_JPRB,2.1605E-07_JPRB/)
KBO( :, 4,54, 5) = (/&
&2.3356E-07_JPRB,4.6489E-07_JPRB,4.7688E-07_JPRB,4.3961E-07_JPRB,2.5649E-07_JPRB/)
KBO( :, 5,54, 5) = (/&
&3.5601E-07_JPRB,6.5756E-07_JPRB,6.5990E-07_JPRB,5.7981E-07_JPRB,3.0495E-07_JPRB/)
KBO( :, 1,55, 5) = (/&
&2.8854E-08_JPRB,9.8072E-08_JPRB,1.2651E-07_JPRB,1.9577E-07_JPRB,1.2893E-07_JPRB/)
KBO( :, 2,55, 5) = (/&
&5.5873E-08_JPRB,1.5168E-07_JPRB,1.7364E-07_JPRB,2.1001E-07_JPRB,1.4600E-07_JPRB/)
KBO( :, 3,55, 5) = (/&
&1.0041E-07_JPRB,2.3068E-07_JPRB,2.4750E-07_JPRB,2.5542E-07_JPRB,1.6992E-07_JPRB/)
KBO( :, 4,55, 5) = (/&
&1.6665E-07_JPRB,3.4087E-07_JPRB,3.5250E-07_JPRB,3.3178E-07_JPRB,2.0129E-07_JPRB/)
KBO( :, 5,55, 5) = (/&
&2.5859E-07_JPRB,4.8718E-07_JPRB,4.9183E-07_JPRB,4.3783E-07_JPRB,2.3951E-07_JPRB/)
KBO( :, 1,56, 5) = (/&
&1.9183E-08_JPRB,7.0296E-08_JPRB,9.5958E-08_JPRB,1.6166E-07_JPRB,1.0324E-07_JPRB/)
KBO( :, 2,56, 5) = (/&
&3.7690E-08_JPRB,1.0873E-07_JPRB,1.2816E-07_JPRB,1.6606E-07_JPRB,1.1573E-07_JPRB/)
KBO( :, 3,56, 5) = (/&
&6.9564E-08_JPRB,1.6681E-07_JPRB,1.8184E-07_JPRB,1.9538E-07_JPRB,1.3395E-07_JPRB/)
KBO( :, 4,56, 5) = (/&
&1.1817E-07_JPRB,2.4912E-07_JPRB,2.5998E-07_JPRB,2.5068E-07_JPRB,1.5820E-07_JPRB/)
KBO( :, 5,56, 5) = (/&
&1.8685E-07_JPRB,3.5979E-07_JPRB,3.6566E-07_JPRB,3.3044E-07_JPRB,1.8828E-07_JPRB/)
KBO( :, 1,57, 5) = (/&
&1.2749E-08_JPRB,5.0514E-08_JPRB,7.4147E-08_JPRB,1.3511E-07_JPRB,8.3045E-08_JPRB/)
KBO( :, 2,57, 5) = (/&
&2.5237E-08_JPRB,7.7785E-08_JPRB,9.5012E-08_JPRB,1.3300E-07_JPRB,9.1992E-08_JPRB/)
KBO( :, 3,57, 5) = (/&
&4.7790E-08_JPRB,1.2024E-07_JPRB,1.3358E-07_JPRB,1.5060E-07_JPRB,1.0586E-07_JPRB/)
KBO( :, 4,57, 5) = (/&
&8.3233E-08_JPRB,1.8139E-07_JPRB,1.9136E-07_JPRB,1.8973E-07_JPRB,1.2456E-07_JPRB/)
KBO( :, 5,57, 5) = (/&
&1.3430E-07_JPRB,2.6480E-07_JPRB,2.7113E-07_JPRB,2.4926E-07_JPRB,1.4817E-07_JPRB/)
KBO( :, 1,58, 5) = (/&
&8.6071E-09_JPRB,3.6748E-08_JPRB,5.8348E-08_JPRB,1.1389E-07_JPRB,6.7280E-08_JPRB/)
KBO( :, 2,58, 5) = (/&
&1.7003E-08_JPRB,5.6012E-08_JPRB,7.1270E-08_JPRB,1.0797E-07_JPRB,7.3801E-08_JPRB/)
KBO( :, 3,58, 5) = (/&
&3.2884E-08_JPRB,8.7017E-08_JPRB,9.8797E-08_JPRB,1.1752E-07_JPRB,8.4329E-08_JPRB/)
KBO( :, 4,58, 5) = (/&
&5.8722E-08_JPRB,1.3250E-07_JPRB,1.4147E-07_JPRB,1.4468E-07_JPRB,9.8923E-08_JPRB/)
KBO( :, 5,58, 5) = (/&
&9.6718E-08_JPRB,1.9549E-07_JPRB,2.0167E-07_JPRB,1.8889E-07_JPRB,1.1761E-07_JPRB/)
KBO( :, 1,59, 5) = (/&
&6.5762E-09_JPRB,2.8839E-08_JPRB,4.7240E-08_JPRB,9.4281E-08_JPRB,5.6347E-08_JPRB/)
KBO( :, 2,59, 5) = (/&
&1.2969E-08_JPRB,4.3747E-08_JPRB,5.6620E-08_JPRB,8.8361E-08_JPRB,6.2071E-08_JPRB/)
KBO( :, 3,59, 5) = (/&
&2.5275E-08_JPRB,6.8112E-08_JPRB,7.8014E-08_JPRB,9.4814E-08_JPRB,7.1293E-08_JPRB/)
KBO( :, 4,59, 5) = (/&
&4.5565E-08_JPRB,1.0415E-07_JPRB,1.1172E-07_JPRB,1.1566E-07_JPRB,8.4152E-08_JPRB/)
KBO( :, 5,59, 5) = (/&
&7.5655E-08_JPRB,1.5435E-07_JPRB,1.5965E-07_JPRB,1.5065E-07_JPRB,1.0042E-07_JPRB/)
KBO( :, 1,13, 6) = (/&
&1.4917E-03_JPRB,1.8975E-03_JPRB,1.8217E-03_JPRB,1.6462E-03_JPRB,1.5445E-02_JPRB/)
KBO( :, 2,13, 6) = (/&
&2.0332E-03_JPRB,2.5878E-03_JPRB,2.4581E-03_JPRB,2.0975E-03_JPRB,1.7016E-02_JPRB/)
KBO( :, 3,13, 6) = (/&
&2.7157E-03_JPRB,3.4479E-03_JPRB,3.2442E-03_JPRB,2.6787E-03_JPRB,1.8566E-02_JPRB/)
KBO( :, 4,13, 6) = (/&
&3.5630E-03_JPRB,4.4992E-03_JPRB,4.2037E-03_JPRB,3.3897E-03_JPRB,2.0183E-02_JPRB/)
KBO( :, 5,13, 6) = (/&
&4.5925E-03_JPRB,5.7651E-03_JPRB,5.3543E-03_JPRB,4.2359E-03_JPRB,2.1919E-02_JPRB/)
KBO( :, 1,14, 6) = (/&
&1.2829E-03_JPRB,1.6450E-03_JPRB,1.5791E-03_JPRB,1.4049E-03_JPRB,1.2669E-02_JPRB/)
KBO( :, 2,14, 6) = (/&
&1.7594E-03_JPRB,2.2519E-03_JPRB,2.1337E-03_JPRB,1.8028E-03_JPRB,1.3983E-02_JPRB/)
KBO( :, 3,14, 6) = (/&
&2.3660E-03_JPRB,3.0125E-03_JPRB,2.8248E-03_JPRB,2.3088E-03_JPRB,1.5340E-02_JPRB/)
KBO( :, 4,14, 6) = (/&
&3.1206E-03_JPRB,3.9492E-03_JPRB,3.6685E-03_JPRB,2.9292E-03_JPRB,1.6758E-02_JPRB/)
KBO( :, 5,14, 6) = (/&
&4.0424E-03_JPRB,5.0714E-03_JPRB,4.6797E-03_JPRB,3.6711E-03_JPRB,1.8318E-02_JPRB/)
KBO( :, 1,15, 6) = (/&
&1.1010E-03_JPRB,1.4255E-03_JPRB,1.3650E-03_JPRB,1.2017E-03_JPRB,9.7184E-03_JPRB/)
KBO( :, 2,15, 6) = (/&
&1.5219E-03_JPRB,1.9593E-03_JPRB,1.8495E-03_JPRB,1.5487E-03_JPRB,1.0782E-02_JPRB/)
KBO( :, 3,15, 6) = (/&
&2.0586E-03_JPRB,2.6324E-03_JPRB,2.4574E-03_JPRB,1.9892E-03_JPRB,1.1885E-02_JPRB/)
KBO( :, 4,15, 6) = (/&
&2.7279E-03_JPRB,3.4587E-03_JPRB,3.1990E-03_JPRB,2.5317E-03_JPRB,1.3076E-02_JPRB/)
KBO( :, 5,15, 6) = (/&
&3.5476E-03_JPRB,4.4511E-03_JPRB,4.0873E-03_JPRB,3.1825E-03_JPRB,1.4381E-02_JPRB/)
KBO( :, 1,16, 6) = (/&
&9.4439E-04_JPRB,1.2342E-03_JPRB,1.1791E-03_JPRB,1.0290E-03_JPRB,7.0974E-03_JPRB/)
KBO( :, 2,16, 6) = (/&
&1.3152E-03_JPRB,1.7038E-03_JPRB,1.6038E-03_JPRB,1.3320E-03_JPRB,7.9219E-03_JPRB/)
KBO( :, 3,16, 6) = (/&
&1.7873E-03_JPRB,2.2957E-03_JPRB,2.1360E-03_JPRB,1.7165E-03_JPRB,8.8130E-03_JPRB/)
KBO( :, 4,16, 6) = (/&
&2.3776E-03_JPRB,3.0227E-03_JPRB,2.7856E-03_JPRB,2.1917E-03_JPRB,9.7773E-03_JPRB/)
KBO( :, 5,16, 6) = (/&
&3.1042E-03_JPRB,3.9007E-03_JPRB,3.5645E-03_JPRB,2.7609E-03_JPRB,1.0823E-02_JPRB/)
KBO( :, 1,17, 6) = (/&
&8.1418E-04_JPRB,1.0727E-03_JPRB,1.0215E-03_JPRB,8.8282E-04_JPRB,5.2836E-03_JPRB/)
KBO( :, 2,17, 6) = (/&
&1.1389E-03_JPRB,1.4851E-03_JPRB,1.3936E-03_JPRB,1.1467E-03_JPRB,5.9459E-03_JPRB/)
KBO( :, 3,17, 6) = (/&
&1.5530E-03_JPRB,2.0047E-03_JPRB,1.8586E-03_JPRB,1.4830E-03_JPRB,6.6722E-03_JPRB/)
KBO( :, 4,17, 6) = (/&
&2.0750E-03_JPRB,2.6425E-03_JPRB,2.4247E-03_JPRB,1.8986E-03_JPRB,7.4589E-03_JPRB/)
KBO( :, 5,17, 6) = (/&
&2.7144E-03_JPRB,3.4191E-03_JPRB,3.1093E-03_JPRB,2.3947E-03_JPRB,8.3055E-03_JPRB/)
KBO( :, 1,18, 6) = (/&
&7.0743E-04_JPRB,9.3753E-04_JPRB,8.9000E-04_JPRB,7.5959E-04_JPRB,4.0718E-03_JPRB/)
KBO( :, 2,18, 6) = (/&
&9.9182E-04_JPRB,1.3005E-03_JPRB,1.2154E-03_JPRB,9.9062E-04_JPRB,4.6245E-03_JPRB/)
KBO( :, 3,18, 6) = (/&
&1.3564E-03_JPRB,1.7551E-03_JPRB,1.6207E-03_JPRB,1.2856E-03_JPRB,5.2287E-03_JPRB/)
KBO( :, 4,18, 6) = (/&
&1.8159E-03_JPRB,2.3174E-03_JPRB,2.1151E-03_JPRB,1.6469E-03_JPRB,5.8797E-03_JPRB/)
KBO( :, 5,18, 6) = (/&
&2.3773E-03_JPRB,3.0052E-03_JPRB,2.7189E-03_JPRB,2.0800E-03_JPRB,6.5746E-03_JPRB/)
KBO( :, 1,19, 6) = (/&
&6.1525E-04_JPRB,8.1970E-04_JPRB,7.7553E-04_JPRB,6.5423E-04_JPRB,3.2676E-03_JPRB/)
KBO( :, 2,19, 6) = (/&
&8.6391E-04_JPRB,1.1368E-03_JPRB,1.0592E-03_JPRB,8.5683E-04_JPRB,3.7402E-03_JPRB/)
KBO( :, 3,19, 6) = (/&
&1.1842E-03_JPRB,1.5349E-03_JPRB,1.4113E-03_JPRB,1.1133E-03_JPRB,4.2531E-03_JPRB/)
KBO( :, 4,19, 6) = (/&
&1.5850E-03_JPRB,2.0314E-03_JPRB,1.8453E-03_JPRB,1.4271E-03_JPRB,4.8022E-03_JPRB/)
KBO( :, 5,19, 6) = (/&
&2.0738E-03_JPRB,2.6347E-03_JPRB,2.3756E-03_JPRB,1.8073E-03_JPRB,5.3894E-03_JPRB/)
KBO( :, 1,20, 6) = (/&
&5.3813E-04_JPRB,7.1852E-04_JPRB,6.7742E-04_JPRB,5.6610E-04_JPRB,2.6837E-03_JPRB/)
KBO( :, 2,20, 6) = (/&
&7.5609E-04_JPRB,9.9539E-04_JPRB,9.2396E-04_JPRB,7.4319E-04_JPRB,3.0864E-03_JPRB/)
KBO( :, 3,20, 6) = (/&
&1.0360E-03_JPRB,1.3460E-03_JPRB,1.2317E-03_JPRB,9.6600E-04_JPRB,3.5220E-03_JPRB/)
KBO( :, 4,20, 6) = (/&
&1.3841E-03_JPRB,1.7811E-03_JPRB,1.6124E-03_JPRB,1.2411E-03_JPRB,3.9882E-03_JPRB/)
KBO( :, 5,20, 6) = (/&
&1.8083E-03_JPRB,2.3047E-03_JPRB,2.0753E-03_JPRB,1.5749E-03_JPRB,4.4863E-03_JPRB/)
KBO( :, 1,21, 6) = (/&
&4.7047E-04_JPRB,6.2774E-04_JPRB,5.8945E-04_JPRB,4.8888E-04_JPRB,2.2094E-03_JPRB/)
KBO( :, 2,21, 6) = (/&
&6.6102E-04_JPRB,8.6924E-04_JPRB,8.0377E-04_JPRB,6.4244E-04_JPRB,2.5494E-03_JPRB/)
KBO( :, 3,21, 6) = (/&
&9.0363E-04_JPRB,1.1757E-03_JPRB,1.0725E-03_JPRB,8.3681E-04_JPRB,2.9166E-03_JPRB/)
KBO( :, 4,21, 6) = (/&
&1.2048E-03_JPRB,1.5526E-03_JPRB,1.4031E-03_JPRB,1.0775E-03_JPRB,3.3103E-03_JPRB/)
KBO( :, 5,21, 6) = (/&
&1.5718E-03_JPRB,2.0028E-03_JPRB,1.8024E-03_JPRB,1.3677E-03_JPRB,3.7308E-03_JPRB/)
KBO( :, 1,22, 6) = (/&
&4.1907E-04_JPRB,5.5771E-04_JPRB,5.2119E-04_JPRB,4.2792E-04_JPRB,1.8003E-03_JPRB/)
KBO( :, 2,22, 6) = (/&
&5.8671E-04_JPRB,7.7133E-04_JPRB,7.0998E-04_JPRB,5.6325E-04_JPRB,2.0828E-03_JPRB/)
KBO( :, 3,22, 6) = (/&
&7.9916E-04_JPRB,1.0396E-03_JPRB,9.4560E-04_JPRB,7.3497E-04_JPRB,2.3875E-03_JPRB/)
KBO( :, 4,22, 6) = (/&
&1.0624E-03_JPRB,1.3663E-03_JPRB,1.2338E-03_JPRB,9.4591E-04_JPRB,2.7147E-03_JPRB/)
KBO( :, 5,22, 6) = (/&
&1.3828E-03_JPRB,1.7569E-03_JPRB,1.5791E-03_JPRB,1.1986E-03_JPRB,3.0625E-03_JPRB/)
KBO( :, 1,23, 6) = (/&
&3.7268E-04_JPRB,4.9540E-04_JPRB,4.6049E-04_JPRB,3.7441E-04_JPRB,1.4599E-03_JPRB/)
KBO( :, 2,23, 6) = (/&
&5.1963E-04_JPRB,6.8295E-04_JPRB,6.2616E-04_JPRB,4.9378E-04_JPRB,1.6928E-03_JPRB/)
KBO( :, 3,23, 6) = (/&
&7.0552E-04_JPRB,9.1627E-04_JPRB,8.3118E-04_JPRB,6.4434E-04_JPRB,1.9439E-03_JPRB/)
KBO( :, 4,23, 6) = (/&
&9.3566E-04_JPRB,1.1987E-03_JPRB,1.0808E-03_JPRB,8.2747E-04_JPRB,2.2129E-03_JPRB/)
KBO( :, 5,23, 6) = (/&
&1.2165E-03_JPRB,1.5386E-03_JPRB,1.3793E-03_JPRB,1.0460E-03_JPRB,2.4958E-03_JPRB/)
KBO( :, 1,24, 6) = (/&
&3.2966E-04_JPRB,4.3876E-04_JPRB,4.0641E-04_JPRB,3.2767E-04_JPRB,1.1682E-03_JPRB/)
KBO( :, 2,24, 6) = (/&
&4.5833E-04_JPRB,6.0226E-04_JPRB,5.5059E-04_JPRB,4.3248E-04_JPRB,1.3581E-03_JPRB/)
KBO( :, 3,24, 6) = (/&
&6.2099E-04_JPRB,8.0461E-04_JPRB,7.2851E-04_JPRB,5.6351E-04_JPRB,1.5621E-03_JPRB/)
KBO( :, 4,24, 6) = (/&
&8.2193E-04_JPRB,1.0497E-03_JPRB,9.4428E-04_JPRB,7.2199E-04_JPRB,1.7793E-03_JPRB/)
KBO( :, 5,24, 6) = (/&
&1.0685E-03_JPRB,1.3449E-03_JPRB,1.2028E-03_JPRB,9.1046E-04_JPRB,2.0052E-03_JPRB/)
KBO( :, 1,25, 6) = (/&
&2.9215E-04_JPRB,3.8885E-04_JPRB,3.5906E-04_JPRB,2.8752E-04_JPRB,9.3498E-04_JPRB/)
KBO( :, 2,25, 6) = (/&
&4.0498E-04_JPRB,5.3121E-04_JPRB,4.8436E-04_JPRB,3.7925E-04_JPRB,1.0888E-03_JPRB/)
KBO( :, 3,25, 6) = (/&
&5.4724E-04_JPRB,7.0707E-04_JPRB,6.3870E-04_JPRB,4.9281E-04_JPRB,1.2539E-03_JPRB/)
KBO( :, 4,25, 6) = (/&
&7.2403E-04_JPRB,9.2061E-04_JPRB,8.2594E-04_JPRB,6.2991E-04_JPRB,1.4275E-03_JPRB/)
KBO( :, 5,25, 6) = (/&
&9.4207E-04_JPRB,1.1779E-03_JPRB,1.0503E-03_JPRB,7.9277E-04_JPRB,1.6058E-03_JPRB/)
KBO( :, 1,26, 6) = (/&
&2.6060E-04_JPRB,3.4625E-04_JPRB,3.1865E-04_JPRB,2.5360E-04_JPRB,7.5595E-04_JPRB/)
KBO( :, 2,26, 6) = (/&
&3.5990E-04_JPRB,4.7096E-04_JPRB,4.2792E-04_JPRB,3.3380E-04_JPRB,8.8083E-04_JPRB/)
KBO( :, 3,26, 6) = (/&
&4.8540E-04_JPRB,6.2457E-04_JPRB,5.6257E-04_JPRB,4.3260E-04_JPRB,1.0137E-03_JPRB/)
KBO( :, 4,26, 6) = (/&
&6.4236E-04_JPRB,8.1177E-04_JPRB,7.2596E-04_JPRB,5.5153E-04_JPRB,1.1519E-03_JPRB/)
KBO( :, 5,26, 6) = (/&
&8.3673E-04_JPRB,1.0378E-03_JPRB,9.2177E-04_JPRB,6.9311E-04_JPRB,1.2938E-03_JPRB/)
KBO( :, 1,27, 6) = (/&
&2.3167E-04_JPRB,3.0750E-04_JPRB,2.8206E-04_JPRB,2.2335E-04_JPRB,6.0157E-04_JPRB/)
KBO( :, 2,27, 6) = (/&
&3.1908E-04_JPRB,4.1650E-04_JPRB,3.7750E-04_JPRB,2.9327E-04_JPRB,7.0083E-04_JPRB/)
KBO( :, 3,27, 6) = (/&
&4.3021E-04_JPRB,5.5097E-04_JPRB,4.9488E-04_JPRB,3.7918E-04_JPRB,8.0532E-04_JPRB/)
KBO( :, 4,27, 6) = (/&
&5.6999E-04_JPRB,7.1551E-04_JPRB,6.3770E-04_JPRB,4.8255E-04_JPRB,9.1424E-04_JPRB/)
KBO( :, 5,27, 6) = (/&
&7.4251E-04_JPRB,9.1481E-04_JPRB,8.0913E-04_JPRB,6.0585E-04_JPRB,1.0264E-03_JPRB/)
KBO( :, 1,28, 6) = (/&
&2.0524E-04_JPRB,2.7221E-04_JPRB,2.4906E-04_JPRB,1.9634E-04_JPRB,4.7063E-04_JPRB/)
KBO( :, 2,28, 6) = (/&
&2.8255E-04_JPRB,3.6755E-04_JPRB,3.3244E-04_JPRB,2.5733E-04_JPRB,5.4784E-04_JPRB/)
KBO( :, 3,28, 6) = (/&
&3.8119E-04_JPRB,4.8546E-04_JPRB,4.3507E-04_JPRB,3.3192E-04_JPRB,6.2929E-04_JPRB/)
KBO( :, 4,28, 6) = (/&
&5.0531E-04_JPRB,6.3052E-04_JPRB,5.6015E-04_JPRB,4.2208E-04_JPRB,7.1426E-04_JPRB/)
KBO( :, 5,28, 6) = (/&
&6.5768E-04_JPRB,8.0589E-04_JPRB,7.1092E-04_JPRB,5.3007E-04_JPRB,8.0182E-04_JPRB/)
KBO( :, 1,29, 6) = (/&
&1.8268E-04_JPRB,2.4155E-04_JPRB,2.2044E-04_JPRB,1.7290E-04_JPRB,3.6473E-04_JPRB/)
KBO( :, 2,29, 6) = (/&
&2.5147E-04_JPRB,3.2531E-04_JPRB,2.9347E-04_JPRB,2.2618E-04_JPRB,4.2431E-04_JPRB/)
KBO( :, 3,29, 6) = (/&
&3.3930E-04_JPRB,4.2940E-04_JPRB,3.8351E-04_JPRB,2.9136E-04_JPRB,4.8729E-04_JPRB/)
KBO( :, 4,29, 6) = (/&
&4.4909E-04_JPRB,5.5754E-04_JPRB,4.9362E-04_JPRB,3.7031E-04_JPRB,5.5277E-04_JPRB/)
KBO( :, 5,29, 6) = (/&
&5.8288E-04_JPRB,7.1165E-04_JPRB,6.2625E-04_JPRB,4.6539E-04_JPRB,6.2094E-04_JPRB/)
KBO( :, 1,30, 6) = (/&
&1.6275E-04_JPRB,2.1427E-04_JPRB,1.9492E-04_JPRB,1.5221E-04_JPRB,2.7882E-04_JPRB/)
KBO( :, 2,30, 6) = (/&
&2.2397E-04_JPRB,2.8807E-04_JPRB,2.5905E-04_JPRB,1.9884E-04_JPRB,3.2464E-04_JPRB/)
KBO( :, 3,30, 6) = (/&
&3.0173E-04_JPRB,3.8020E-04_JPRB,3.3838E-04_JPRB,2.5591E-04_JPRB,3.7279E-04_JPRB/)
KBO( :, 4,30, 6) = (/&
&3.9835E-04_JPRB,4.9290E-04_JPRB,4.3523E-04_JPRB,3.2539E-04_JPRB,4.2318E-04_JPRB/)
KBO( :, 5,30, 6) = (/&
&5.1512E-04_JPRB,6.2814E-04_JPRB,5.5236E-04_JPRB,4.0928E-04_JPRB,4.7644E-04_JPRB/)
KBO( :, 1,31, 6) = (/&
&1.4541E-04_JPRB,1.9050E-04_JPRB,1.7269E-04_JPRB,1.3415E-04_JPRB,2.0988E-04_JPRB/)
KBO( :, 2,31, 6) = (/&
&1.9968E-04_JPRB,2.5579E-04_JPRB,2.2917E-04_JPRB,1.7504E-04_JPRB,2.4454E-04_JPRB/)
KBO( :, 3,31, 6) = (/&
&2.6831E-04_JPRB,3.3713E-04_JPRB,2.9924E-04_JPRB,2.2534E-04_JPRB,2.8116E-04_JPRB/)
KBO( :, 4,31, 6) = (/&
&3.5296E-04_JPRB,4.3603E-04_JPRB,3.8460E-04_JPRB,2.8657E-04_JPRB,3.1971E-04_JPRB/)
KBO( :, 5,31, 6) = (/&
&4.5385E-04_JPRB,5.5422E-04_JPRB,4.8747E-04_JPRB,3.6051E-04_JPRB,3.6033E-04_JPRB/)
KBO( :, 1,32, 6) = (/&
&1.3012E-04_JPRB,1.6979E-04_JPRB,1.5332E-04_JPRB,1.1846E-04_JPRB,1.5858E-04_JPRB/)
KBO( :, 2,32, 6) = (/&
&1.7811E-04_JPRB,2.2758E-04_JPRB,2.0328E-04_JPRB,1.5447E-04_JPRB,1.8500E-04_JPRB/)
KBO( :, 3,32, 6) = (/&
&2.3846E-04_JPRB,2.9920E-04_JPRB,2.6508E-04_JPRB,1.9890E-04_JPRB,2.1289E-04_JPRB/)
KBO( :, 4,32, 6) = (/&
&3.1195E-04_JPRB,3.8579E-04_JPRB,3.4029E-04_JPRB,2.5305E-04_JPRB,2.4226E-04_JPRB/)
KBO( :, 5,32, 6) = (/&
&3.9831E-04_JPRB,4.8846E-04_JPRB,4.3040E-04_JPRB,3.1815E-04_JPRB,2.7351E-04_JPRB/)
KBO( :, 1,33, 6) = (/&
&1.1634E-04_JPRB,1.5147E-04_JPRB,1.3636E-04_JPRB,1.0475E-04_JPRB,1.1978E-04_JPRB/)
KBO( :, 2,33, 6) = (/&
&1.5863E-04_JPRB,2.0248E-04_JPRB,1.8050E-04_JPRB,1.3665E-04_JPRB,1.3973E-04_JPRB/)
KBO( :, 3,33, 6) = (/&
&2.1137E-04_JPRB,2.6530E-04_JPRB,2.3496E-04_JPRB,1.7592E-04_JPRB,1.6087E-04_JPRB/)
KBO( :, 4,33, 6) = (/&
&2.7467E-04_JPRB,3.4079E-04_JPRB,3.0109E-04_JPRB,2.2372E-04_JPRB,1.8344E-04_JPRB/)
KBO( :, 5,33, 6) = (/&
&3.4782E-04_JPRB,4.2919E-04_JPRB,3.7950E-04_JPRB,2.8080E-04_JPRB,2.0757E-04_JPRB/)
KBO( :, 1,34, 6) = (/&
&1.0312E-04_JPRB,1.3408E-04_JPRB,1.2041E-04_JPRB,9.2110E-05_JPRB,9.2903E-05_JPRB/)
KBO( :, 2,34, 6) = (/&
&1.4008E-04_JPRB,1.7871E-04_JPRB,1.5914E-04_JPRB,1.2016E-04_JPRB,1.0831E-04_JPRB/)
KBO( :, 3,34, 6) = (/&
&1.8556E-04_JPRB,2.3329E-04_JPRB,2.0678E-04_JPRB,1.5464E-04_JPRB,1.2476E-04_JPRB/)
KBO( :, 4,34, 6) = (/&
&2.3939E-04_JPRB,2.9833E-04_JPRB,2.6429E-04_JPRB,1.9649E-04_JPRB,1.4248E-04_JPRB/)
KBO( :, 5,34, 6) = (/&
&3.0117E-04_JPRB,3.7373E-04_JPRB,3.3162E-04_JPRB,2.4605E-04_JPRB,1.6152E-04_JPRB/)
KBO( :, 1,35, 6) = (/&
&8.8443E-05_JPRB,1.1512E-04_JPRB,1.0336E-04_JPRB,7.8950E-05_JPRB,7.0684E-05_JPRB/)
KBO( :, 2,35, 6) = (/&
&1.1985E-04_JPRB,1.5327E-04_JPRB,1.3658E-04_JPRB,1.0311E-04_JPRB,8.2504E-05_JPRB/)
KBO( :, 3,35, 6) = (/&
&1.5813E-04_JPRB,1.9962E-04_JPRB,1.7734E-04_JPRB,1.3276E-04_JPRB,9.5244E-05_JPRB/)
KBO( :, 4,35, 6) = (/&
&2.0303E-04_JPRB,2.5445E-04_JPRB,2.2617E-04_JPRB,1.6859E-04_JPRB,1.0907E-04_JPRB/)
KBO( :, 5,35, 6) = (/&
&2.5457E-04_JPRB,3.1764E-04_JPRB,2.8275E-04_JPRB,2.1067E-04_JPRB,1.2401E-04_JPRB/)
KBO( :, 1,36, 6) = (/&
&7.3105E-05_JPRB,9.5553E-05_JPRB,8.5894E-05_JPRB,6.5665E-05_JPRB,5.2586E-05_JPRB/)
KBO( :, 2,36, 6) = (/&
&9.9088E-05_JPRB,1.2731E-04_JPRB,1.1366E-04_JPRB,8.5950E-05_JPRB,6.1603E-05_JPRB/)
KBO( :, 3,36, 6) = (/&
&1.3052E-04_JPRB,1.6575E-04_JPRB,1.4766E-04_JPRB,1.1085E-04_JPRB,7.1395E-05_JPRB/)
KBO( :, 4,36, 6) = (/&
&1.6737E-04_JPRB,2.1100E-04_JPRB,1.8817E-04_JPRB,1.4082E-04_JPRB,8.2060E-05_JPRB/)
KBO( :, 5,36, 6) = (/&
&2.0971E-04_JPRB,2.6328E-04_JPRB,2.3482E-04_JPRB,1.7583E-04_JPRB,9.3616E-05_JPRB/)
KBO( :, 1,37, 6) = (/&
&5.7964E-05_JPRB,7.6160E-05_JPRB,6.8576E-05_JPRB,5.2541E-05_JPRB,4.0073E-05_JPRB/)
KBO( :, 2,37, 6) = (/&
&7.8834E-05_JPRB,1.0183E-04_JPRB,9.1063E-05_JPRB,6.9045E-05_JPRB,4.7111E-05_JPRB/)
KBO( :, 3,37, 6) = (/&
&1.0412E-04_JPRB,1.3294E-04_JPRB,1.1864E-04_JPRB,8.9322E-05_JPRB,5.4770E-05_JPRB/)
KBO( :, 4,37, 6) = (/&
&1.3382E-04_JPRB,1.6952E-04_JPRB,1.5143E-04_JPRB,1.1374E-04_JPRB,6.3134E-05_JPRB/)
KBO( :, 5,37, 6) = (/&
&1.6808E-04_JPRB,2.1196E-04_JPRB,1.8928E-04_JPRB,1.4220E-04_JPRB,7.2225E-05_JPRB/)
KBO( :, 1,38, 6) = (/&
&4.5775E-05_JPRB,6.0479E-05_JPRB,5.4555E-05_JPRB,4.1902E-05_JPRB,3.0397E-05_JPRB/)
KBO( :, 2,38, 6) = (/&
&6.2496E-05_JPRB,8.1164E-05_JPRB,7.2708E-05_JPRB,5.5274E-05_JPRB,3.5878E-05_JPRB/)
KBO( :, 3,38, 6) = (/&
&8.2782E-05_JPRB,1.0626E-04_JPRB,9.5002E-05_JPRB,7.1740E-05_JPRB,4.1841E-05_JPRB/)
KBO( :, 4,38, 6) = (/&
&1.0670E-04_JPRB,1.3583E-04_JPRB,1.2149E-04_JPRB,9.1558E-05_JPRB,4.8377E-05_JPRB/)
KBO( :, 5,38, 6) = (/&
&1.3438E-04_JPRB,1.7021E-04_JPRB,1.5213E-04_JPRB,1.1463E-04_JPRB,5.5512E-05_JPRB/)
KBO( :, 1,39, 6) = (/&
&3.6095E-05_JPRB,4.7960E-05_JPRB,4.3340E-05_JPRB,3.3379E-05_JPRB,2.2882E-05_JPRB/)
KBO( :, 2,39, 6) = (/&
&4.9468E-05_JPRB,6.4614E-05_JPRB,5.7979E-05_JPRB,4.4199E-05_JPRB,2.7110E-05_JPRB/)
KBO( :, 3,39, 6) = (/&
&6.5728E-05_JPRB,8.4830E-05_JPRB,7.5966E-05_JPRB,5.7541E-05_JPRB,3.1729E-05_JPRB/)
KBO( :, 4,39, 6) = (/&
&8.4989E-05_JPRB,1.0871E-04_JPRB,9.7338E-05_JPRB,7.3595E-05_JPRB,3.6816E-05_JPRB/)
KBO( :, 5,39, 6) = (/&
&1.0733E-04_JPRB,1.3655E-04_JPRB,1.2216E-04_JPRB,9.2289E-05_JPRB,4.2380E-05_JPRB/)
KBO( :, 1,40, 6) = (/&
&2.7548E-05_JPRB,3.6866E-05_JPRB,3.3398E-05_JPRB,2.5816E-05_JPRB,1.7406E-05_JPRB/)
KBO( :, 2,40, 6) = (/&
&3.8017E-05_JPRB,4.9978E-05_JPRB,4.4939E-05_JPRB,3.4363E-05_JPRB,2.0717E-05_JPRB/)
KBO( :, 3,40, 6) = (/&
&5.0843E-05_JPRB,6.5998E-05_JPRB,5.9173E-05_JPRB,4.4960E-05_JPRB,2.4340E-05_JPRB/)
KBO( :, 4,40, 6) = (/&
&6.6103E-05_JPRB,8.4982E-05_JPRB,7.6165E-05_JPRB,5.7734E-05_JPRB,2.8334E-05_JPRB/)
KBO( :, 5,40, 6) = (/&
&8.3889E-05_JPRB,1.0718E-04_JPRB,9.5971E-05_JPRB,7.2651E-05_JPRB,3.2716E-05_JPRB/)
KBO( :, 1,41, 6) = (/&
&2.0891E-05_JPRB,2.8160E-05_JPRB,2.5581E-05_JPRB,1.9853E-05_JPRB,1.3219E-05_JPRB/)
KBO( :, 2,41, 6) = (/&
&2.9056E-05_JPRB,3.8448E-05_JPRB,3.4643E-05_JPRB,2.6578E-05_JPRB,1.5803E-05_JPRB/)
KBO( :, 3,41, 6) = (/&
&3.9119E-05_JPRB,5.1086E-05_JPRB,4.5870E-05_JPRB,3.4949E-05_JPRB,1.8643E-05_JPRB/)
KBO( :, 4,41, 6) = (/&
&5.1167E-05_JPRB,6.6144E-05_JPRB,5.9321E-05_JPRB,4.5078E-05_JPRB,2.1781E-05_JPRB/)
KBO( :, 5,41, 6) = (/&
&6.5313E-05_JPRB,8.3807E-05_JPRB,7.5100E-05_JPRB,5.6965E-05_JPRB,2.5228E-05_JPRB/)
KBO( :, 1,42, 6) = (/&
&1.5797E-05_JPRB,2.1452E-05_JPRB,1.9541E-05_JPRB,1.5234E-05_JPRB,9.9864E-06_JPRB/)
KBO( :, 2,42, 6) = (/&
&2.2148E-05_JPRB,2.9506E-05_JPRB,2.6644E-05_JPRB,2.0507E-05_JPRB,1.1995E-05_JPRB/)
KBO( :, 3,42, 6) = (/&
&3.0028E-05_JPRB,3.9456E-05_JPRB,3.5478E-05_JPRB,2.7113E-05_JPRB,1.4215E-05_JPRB/)
KBO( :, 4,42, 6) = (/&
&3.9526E-05_JPRB,5.1380E-05_JPRB,4.6122E-05_JPRB,3.5139E-05_JPRB,1.6670E-05_JPRB/)
KBO( :, 5,42, 6) = (/&
&5.0747E-05_JPRB,6.5409E-05_JPRB,5.8661E-05_JPRB,4.4588E-05_JPRB,1.9369E-05_JPRB/)
KBO( :, 1,43, 6) = (/&
&1.1685E-05_JPRB,1.6001E-05_JPRB,1.4628E-05_JPRB,1.1471E-05_JPRB,7.4936E-06_JPRB/)
KBO( :, 2,43, 6) = (/&
&1.6548E-05_JPRB,2.2213E-05_JPRB,2.0113E-05_JPRB,1.5537E-05_JPRB,9.0536E-06_JPRB/)
KBO( :, 3,43, 6) = (/&
&2.2638E-05_JPRB,2.9954E-05_JPRB,2.6979E-05_JPRB,2.0685E-05_JPRB,1.0779E-05_JPRB/)
KBO( :, 4,43, 6) = (/&
&3.0048E-05_JPRB,3.9293E-05_JPRB,3.5311E-05_JPRB,2.6968E-05_JPRB,1.2697E-05_JPRB/)
KBO( :, 5,43, 6) = (/&
&3.8860E-05_JPRB,5.0338E-05_JPRB,4.5183E-05_JPRB,3.4410E-05_JPRB,1.4806E-05_JPRB/)
KBO( :, 1,44, 6) = (/&
&8.5348E-06_JPRB,1.1792E-05_JPRB,1.0825E-05_JPRB,8.5515E-06_JPRB,5.5871E-06_JPRB/)
KBO( :, 2,44, 6) = (/&
&1.2224E-05_JPRB,1.6542E-05_JPRB,1.5023E-05_JPRB,1.1659E-05_JPRB,6.7947E-06_JPRB/)
KBO( :, 3,44, 6) = (/&
&1.6899E-05_JPRB,2.2521E-05_JPRB,2.0321E-05_JPRB,1.5633E-05_JPRB,8.1320E-06_JPRB/)
KBO( :, 4,44, 6) = (/&
&2.2637E-05_JPRB,2.9783E-05_JPRB,2.6801E-05_JPRB,2.0525E-05_JPRB,9.6227E-06_JPRB/)
KBO( :, 5,44, 6) = (/&
&2.9511E-05_JPRB,3.8437E-05_JPRB,3.4531E-05_JPRB,2.6356E-05_JPRB,1.1265E-05_JPRB/)
KBO( :, 1,45, 6) = (/&
&6.2053E-06_JPRB,8.6498E-06_JPRB,7.9828E-06_JPRB,6.3587E-06_JPRB,4.1355E-06_JPRB/)
KBO( :, 2,45, 6) = (/&
&8.9924E-06_JPRB,1.2274E-05_JPRB,1.1184E-05_JPRB,8.7228E-06_JPRB,5.0646E-06_JPRB/)
KBO( :, 3,45, 6) = (/&
&1.2577E-05_JPRB,1.6878E-05_JPRB,1.5263E-05_JPRB,1.1781E-05_JPRB,6.0980E-06_JPRB/)
KBO( :, 4,45, 6) = (/&
&1.7004E-05_JPRB,2.2510E-05_JPRB,2.0287E-05_JPRB,1.5579E-05_JPRB,7.2495E-06_JPRB/)
KBO( :, 5,45, 6) = (/&
&2.2345E-05_JPRB,2.9273E-05_JPRB,2.6327E-05_JPRB,2.0139E-05_JPRB,8.5241E-06_JPRB/)
KBO( :, 1,46, 6) = (/&
&4.4535E-06_JPRB,6.2663E-06_JPRB,5.8215E-06_JPRB,4.6847E-06_JPRB,3.0403E-06_JPRB/)
KBO( :, 2,46, 6) = (/&
&6.5386E-06_JPRB,9.0087E-06_JPRB,8.2383E-06_JPRB,6.4650E-06_JPRB,3.7495E-06_JPRB/)
KBO( :, 3,46, 6) = (/&
&9.2626E-06_JPRB,1.2523E-05_JPRB,1.1353E-05_JPRB,8.7958E-06_JPRB,4.5455E-06_JPRB/)
KBO( :, 4,46, 6) = (/&
&1.2652E-05_JPRB,1.6866E-05_JPRB,1.5224E-05_JPRB,1.1726E-05_JPRB,5.4324E-06_JPRB/)
KBO( :, 5,46, 6) = (/&
&1.6782E-05_JPRB,2.2115E-05_JPRB,1.9910E-05_JPRB,1.5271E-05_JPRB,6.4154E-06_JPRB/)
KBO( :, 1,47, 6) = (/&
&3.1255E-06_JPRB,4.4445E-06_JPRB,4.1625E-06_JPRB,3.3973E-06_JPRB,2.2248E-06_JPRB/)
KBO( :, 2,47, 6) = (/&
&4.6607E-06_JPRB,6.4871E-06_JPRB,5.9609E-06_JPRB,4.7149E-06_JPRB,2.7633E-06_JPRB/)
KBO( :, 3,47, 6) = (/&
&6.6996E-06_JPRB,9.1349E-06_JPRB,8.3072E-06_JPRB,6.4651E-06_JPRB,3.3751E-06_JPRB/)
KBO( :, 4,47, 6) = (/&
&9.2705E-06_JPRB,1.2449E-05_JPRB,1.1256E-05_JPRB,8.6999E-06_JPRB,4.0582E-06_JPRB/)
KBO( :, 5,47, 6) = (/&
&1.2429E-05_JPRB,1.6480E-05_JPRB,1.4854E-05_JPRB,1.1428E-05_JPRB,4.8166E-06_JPRB/)
KBO( :, 1,48, 6) = (/&
&2.1776E-06_JPRB,3.1287E-06_JPRB,2.9593E-06_JPRB,2.4588E-06_JPRB,1.6162E-06_JPRB/)
KBO( :, 2,48, 6) = (/&
&3.3004E-06_JPRB,4.6424E-06_JPRB,4.2915E-06_JPRB,3.4279E-06_JPRB,2.0216E-06_JPRB/)
KBO( :, 3,48, 6) = (/&
&4.8178E-06_JPRB,6.6317E-06_JPRB,6.0512E-06_JPRB,4.7347E-06_JPRB,2.4869E-06_JPRB/)
KBO( :, 4,48, 6) = (/&
&6.7632E-06_JPRB,9.1507E-06_JPRB,8.2914E-06_JPRB,6.4284E-06_JPRB,3.0099E-06_JPRB/)
KBO( :, 5,48, 6) = (/&
&9.1697E-06_JPRB,1.2234E-05_JPRB,1.1042E-05_JPRB,8.5224E-06_JPRB,3.5919E-06_JPRB/)
KBO( :, 1,49, 6) = (/&
&1.5053E-06_JPRB,2.1858E-06_JPRB,2.0909E-06_JPRB,1.7774E-06_JPRB,1.1638E-06_JPRB/)
KBO( :, 2,49, 6) = (/&
&2.3208E-06_JPRB,3.3001E-06_JPRB,3.0741E-06_JPRB,2.4849E-06_JPRB,1.4655E-06_JPRB/)
KBO( :, 3,49, 6) = (/&
&3.4426E-06_JPRB,4.7874E-06_JPRB,4.3858E-06_JPRB,3.4542E-06_JPRB,1.8145E-06_JPRB/)
KBO( :, 4,49, 6) = (/&
&4.9073E-06_JPRB,6.6937E-06_JPRB,6.0798E-06_JPRB,4.7299E-06_JPRB,2.2116E-06_JPRB/)
KBO( :, 5,49, 6) = (/&
&6.7349E-06_JPRB,9.0453E-06_JPRB,8.1769E-06_JPRB,6.3309E-06_JPRB,2.6545E-06_JPRB/)
KBO( :, 1,50, 6) = (/&
&1.0462E-06_JPRB,1.5340E-06_JPRB,1.4848E-06_JPRB,1.2964E-06_JPRB,8.5273E-07_JPRB/)
KBO( :, 2,50, 6) = (/&
&1.6402E-06_JPRB,2.3557E-06_JPRB,2.2124E-06_JPRB,1.8137E-06_JPRB,1.0799E-06_JPRB/)
KBO( :, 3,50, 6) = (/&
&2.4709E-06_JPRB,3.4712E-06_JPRB,3.1941E-06_JPRB,2.5342E-06_JPRB,1.3448E-06_JPRB/)
KBO( :, 4,50, 6) = (/&
&3.5758E-06_JPRB,4.9168E-06_JPRB,4.4776E-06_JPRB,3.4964E-06_JPRB,1.6496E-06_JPRB/)
KBO( :, 5,50, 6) = (/&
&4.9702E-06_JPRB,6.7202E-06_JPRB,6.0835E-06_JPRB,4.7222E-06_JPRB,1.9912E-06_JPRB/)
KBO( :, 1,51, 6) = (/&
&7.2663E-07_JPRB,1.0750E-06_JPRB,1.0542E-06_JPRB,9.5059E-07_JPRB,6.2987E-07_JPRB/)
KBO( :, 2,51, 6) = (/&
&1.1582E-06_JPRB,1.6789E-06_JPRB,1.5910E-06_JPRB,1.3276E-06_JPRB,8.0106E-07_JPRB/)
KBO( :, 3,51, 6) = (/&
&1.7719E-06_JPRB,2.5144E-06_JPRB,2.3267E-06_JPRB,1.8622E-06_JPRB,1.0033E-06_JPRB/)
KBO( :, 4,51, 6) = (/&
&2.6046E-06_JPRB,3.6115E-06_JPRB,3.2983E-06_JPRB,2.5872E-06_JPRB,1.2381E-06_JPRB/)
KBO( :, 5,51, 6) = (/&
&3.6697E-06_JPRB,4.9945E-06_JPRB,4.5288E-06_JPRB,3.5236E-06_JPRB,1.5031E-06_JPRB/)
KBO( :, 1,52, 6) = (/&
&5.0128E-07_JPRB,7.4829E-07_JPRB,7.4503E-07_JPRB,6.9902E-07_JPRB,4.6417E-07_JPRB/)
KBO( :, 2,52, 6) = (/&
&8.1290E-07_JPRB,1.1889E-06_JPRB,1.1383E-06_JPRB,9.7075E-07_JPRB,5.9124E-07_JPRB/)
KBO( :, 3,52, 6) = (/&
&1.2637E-06_JPRB,1.8111E-06_JPRB,1.6874E-06_JPRB,1.3654E-06_JPRB,7.4485E-07_JPRB/)
KBO( :, 4,52, 6) = (/&
&1.8870E-06_JPRB,2.6414E-06_JPRB,2.4208E-06_JPRB,1.9088E-06_JPRB,9.2398E-07_JPRB/)
KBO( :, 5,52, 6) = (/&
&2.6982E-06_JPRB,3.6981E-06_JPRB,3.3605E-06_JPRB,2.6209E-06_JPRB,1.1284E-06_JPRB/)
KBO( :, 1,53, 6) = (/&
&3.4316E-07_JPRB,5.1730E-07_JPRB,5.2428E-07_JPRB,5.1650E-07_JPRB,3.4163E-07_JPRB/)
KBO( :, 2,53, 6) = (/&
&5.6636E-07_JPRB,8.3600E-07_JPRB,8.0988E-07_JPRB,7.0959E-07_JPRB,4.3402E-07_JPRB/)
KBO( :, 3,53, 6) = (/&
&8.9539E-07_JPRB,1.2957E-06_JPRB,1.2170E-06_JPRB,9.9881E-07_JPRB,5.4917E-07_JPRB/)
KBO( :, 4,53, 6) = (/&
&1.3585E-06_JPRB,1.9213E-06_JPRB,1.7681E-06_JPRB,1.4039E-06_JPRB,6.8487E-07_JPRB/)
KBO( :, 5,53, 6) = (/&
&1.9728E-06_JPRB,2.7267E-06_JPRB,2.4840E-06_JPRB,1.9431E-06_JPRB,8.4127E-07_JPRB/)
KBO( :, 1,54, 6) = (/&
&2.3729E-07_JPRB,3.6141E-07_JPRB,3.7346E-07_JPRB,3.8814E-07_JPRB,2.5965E-07_JPRB/)
KBO( :, 2,54, 6) = (/&
&3.9847E-07_JPRB,5.9281E-07_JPRB,5.8145E-07_JPRB,5.2497E-07_JPRB,3.2865E-07_JPRB/)
KBO( :, 3,54, 6) = (/&
&6.4012E-07_JPRB,9.3418E-07_JPRB,8.8451E-07_JPRB,7.3760E-07_JPRB,4.1726E-07_JPRB/)
KBO( :, 4,54, 6) = (/&
&9.8548E-07_JPRB,1.4072E-06_JPRB,1.3009E-06_JPRB,1.0414E-06_JPRB,5.2304E-07_JPRB/)
KBO( :, 5,54, 6) = (/&
&1.4524E-06_JPRB,2.0243E-06_JPRB,1.8490E-06_JPRB,1.4514E-06_JPRB,6.4582E-07_JPRB/)
KBO( :, 1,55, 6) = (/&
&1.6422E-07_JPRB,2.5313E-07_JPRB,2.6741E-07_JPRB,2.9555E-07_JPRB,2.0083E-07_JPRB/)
KBO( :, 2,55, 6) = (/&
&2.8085E-07_JPRB,4.2089E-07_JPRB,4.1847E-07_JPRB,3.9112E-07_JPRB,2.5331E-07_JPRB/)
KBO( :, 3,55, 6) = (/&
&4.5840E-07_JPRB,6.7405E-07_JPRB,6.4380E-07_JPRB,5.4696E-07_JPRB,3.2245E-07_JPRB/)
KBO( :, 4,55, 6) = (/&
&7.1591E-07_JPRB,1.0314E-06_JPRB,9.5879E-07_JPRB,7.7462E-07_JPRB,4.0636E-07_JPRB/)
KBO( :, 5,55, 6) = (/&
&1.0707E-06_JPRB,1.5050E-06_JPRB,1.3785E-06_JPRB,1.0868E-06_JPRB,5.0407E-07_JPRB/)
KBO( :, 1,56, 6) = (/&
&1.1297E-07_JPRB,1.7654E-07_JPRB,1.9160E-07_JPRB,2.2785E-07_JPRB,1.5600E-07_JPRB/)
KBO( :, 2,56, 6) = (/&
&1.9687E-07_JPRB,2.9736E-07_JPRB,3.0024E-07_JPRB,2.9250E-07_JPRB,1.9557E-07_JPRB/)
KBO( :, 3,56, 6) = (/&
&3.2655E-07_JPRB,4.8379E-07_JPRB,4.6673E-07_JPRB,4.0545E-07_JPRB,2.4926E-07_JPRB/)
KBO( :, 4,56, 6) = (/&
&5.1776E-07_JPRB,7.5239E-07_JPRB,7.0397E-07_JPRB,5.7515E-07_JPRB,3.1570E-07_JPRB/)
KBO( :, 5,56, 6) = (/&
&7.8583E-07_JPRB,1.1146E-06_JPRB,1.0242E-06_JPRB,8.1180E-07_JPRB,3.9355E-07_JPRB/)
KBO( :, 1,57, 6) = (/&
&7.7200E-08_JPRB,1.2264E-07_JPRB,1.3766E-07_JPRB,1.7856E-07_JPRB,1.2187E-07_JPRB/)
KBO( :, 2,57, 6) = (/&
&1.3715E-07_JPRB,2.0905E-07_JPRB,2.1488E-07_JPRB,2.1998E-07_JPRB,1.5127E-07_JPRB/)
KBO( :, 3,57, 6) = (/&
&2.3136E-07_JPRB,3.4526E-07_JPRB,3.3687E-07_JPRB,3.0067E-07_JPRB,1.9276E-07_JPRB/)
KBO( :, 4,57, 6) = (/&
&3.7265E-07_JPRB,5.4598E-07_JPRB,5.1453E-07_JPRB,4.2632E-07_JPRB,2.4529E-07_JPRB/)
KBO( :, 5,57, 6) = (/&
&5.7396E-07_JPRB,8.2172E-07_JPRB,7.5794E-07_JPRB,6.0477E-07_JPRB,3.0747E-07_JPRB/)
KBO( :, 1,58, 6) = (/&
&5.2955E-08_JPRB,8.5764E-08_JPRB,1.0017E-07_JPRB,1.4310E-07_JPRB,9.6433E-08_JPRB/)
KBO( :, 2,58, 6) = (/&
&9.5831E-08_JPRB,1.4757E-07_JPRB,1.5479E-07_JPRB,1.6745E-07_JPRB,1.1819E-07_JPRB/)
KBO( :, 3,58, 6) = (/&
&1.6444E-07_JPRB,2.4707E-07_JPRB,2.4397E-07_JPRB,2.2463E-07_JPRB,1.5059E-07_JPRB/)
KBO( :, 4,58, 6) = (/&
&2.6896E-07_JPRB,3.9698E-07_JPRB,3.7706E-07_JPRB,3.1744E-07_JPRB,1.9236E-07_JPRB/)
KBO( :, 5,58, 6) = (/&
&4.2027E-07_JPRB,6.0686E-07_JPRB,5.6217E-07_JPRB,4.5216E-07_JPRB,2.4243E-07_JPRB/)
KBO( :, 1,59, 6) = (/&
&4.0613E-08_JPRB,6.6330E-08_JPRB,7.8756E-08_JPRB,1.1682E-07_JPRB,8.0763E-08_JPRB/)
KBO( :, 2,59, 6) = (/&
&7.4110E-08_JPRB,1.1464E-07_JPRB,1.2119E-07_JPRB,1.3394E-07_JPRB,1.0024E-07_JPRB/)
KBO( :, 3,59, 6) = (/&
&1.2825E-07_JPRB,1.9327E-07_JPRB,1.9161E-07_JPRB,1.7847E-07_JPRB,1.2887E-07_JPRB/)
KBO( :, 4,59, 6) = (/&
&2.1125E-07_JPRB,3.1279E-07_JPRB,2.9779E-07_JPRB,2.5217E-07_JPRB,1.6539E-07_JPRB/)
KBO( :, 5,59, 6) = (/&
&3.3221E-07_JPRB,4.8128E-07_JPRB,4.4648E-07_JPRB,3.6014E-07_JPRB,2.0916E-07_JPRB/)
KBO( :, 1,13, 7) = (/&
&4.0082E-03_JPRB,4.7471E-03_JPRB,4.2106E-03_JPRB,3.3097E-03_JPRB,2.9797E-02_JPRB/)
KBO( :, 2,13, 7) = (/&
&5.4956E-03_JPRB,6.4503E-03_JPRB,5.6741E-03_JPRB,4.3606E-03_JPRB,3.3076E-02_JPRB/)
KBO( :, 3,13, 7) = (/&
&7.3201E-03_JPRB,8.5434E-03_JPRB,7.4724E-03_JPRB,5.6899E-03_JPRB,3.6718E-02_JPRB/)
KBO( :, 4,13, 7) = (/&
&9.4768E-03_JPRB,1.1006E-02_JPRB,9.6490E-03_JPRB,7.3607E-03_JPRB,4.0562E-02_JPRB/)
KBO( :, 5,13, 7) = (/&
&1.2016E-02_JPRB,1.3883E-02_JPRB,1.2248E-02_JPRB,9.4126E-03_JPRB,4.4607E-02_JPRB/)
KBO( :, 1,14, 7) = (/&
&3.5182E-03_JPRB,4.1440E-03_JPRB,3.6712E-03_JPRB,2.8865E-03_JPRB,2.5106E-02_JPRB/)
KBO( :, 2,14, 7) = (/&
&4.8368E-03_JPRB,5.6585E-03_JPRB,4.9763E-03_JPRB,3.8241E-03_JPRB,2.8178E-02_JPRB/)
KBO( :, 3,14, 7) = (/&
&6.4391E-03_JPRB,7.4926E-03_JPRB,6.5797E-03_JPRB,5.0127E-03_JPRB,3.1499E-02_JPRB/)
KBO( :, 4,14, 7) = (/&
&8.3556E-03_JPRB,9.6590E-03_JPRB,8.4959E-03_JPRB,6.4956E-03_JPRB,3.4983E-02_JPRB/)
KBO( :, 5,14, 7) = (/&
&1.0636E-02_JPRB,1.2197E-02_JPRB,1.0778E-02_JPRB,8.2927E-03_JPRB,3.8677E-02_JPRB/)
KBO( :, 1,15, 7) = (/&
&3.0808E-03_JPRB,3.6180E-03_JPRB,3.2024E-03_JPRB,2.5077E-03_JPRB,2.0133E-02_JPRB/)
KBO( :, 2,15, 7) = (/&
&4.2342E-03_JPRB,4.9408E-03_JPRB,4.3573E-03_JPRB,3.3447E-03_JPRB,2.2811E-02_JPRB/)
KBO( :, 3,15, 7) = (/&
&5.6484E-03_JPRB,6.5425E-03_JPRB,5.7598E-03_JPRB,4.4050E-03_JPRB,2.5648E-02_JPRB/)
KBO( :, 4,15, 7) = (/&
&7.3569E-03_JPRB,8.4459E-03_JPRB,7.4478E-03_JPRB,5.6997E-03_JPRB,2.8633E-02_JPRB/)
KBO( :, 5,15, 7) = (/&
&9.4079E-03_JPRB,1.0695E-02_JPRB,9.4525E-03_JPRB,7.2671E-03_JPRB,3.1750E-02_JPRB/)
KBO( :, 1,16, 7) = (/&
&2.6937E-03_JPRB,3.1581E-03_JPRB,2.7980E-03_JPRB,2.1775E-03_JPRB,1.5394E-02_JPRB/)
KBO( :, 2,16, 7) = (/&
&3.7085E-03_JPRB,4.3109E-03_JPRB,3.8048E-03_JPRB,2.9219E-03_JPRB,1.7507E-02_JPRB/)
KBO( :, 3,16, 7) = (/&
&4.9609E-03_JPRB,5.7164E-03_JPRB,5.0355E-03_JPRB,3.8483E-03_JPRB,1.9730E-02_JPRB/)
KBO( :, 4,16, 7) = (/&
&6.4895E-03_JPRB,7.4002E-03_JPRB,6.5219E-03_JPRB,4.9806E-03_JPRB,2.2084E-02_JPRB/)
KBO( :, 5,16, 7) = (/&
&8.3163E-03_JPRB,9.4051E-03_JPRB,8.2914E-03_JPRB,6.3525E-03_JPRB,2.4551E-02_JPRB/)
KBO( :, 1,17, 7) = (/&
&2.3642E-03_JPRB,2.7668E-03_JPRB,2.4489E-03_JPRB,1.8988E-03_JPRB,1.1868E-02_JPRB/)
KBO( :, 2,17, 7) = (/&
&3.2598E-03_JPRB,3.7811E-03_JPRB,3.3290E-03_JPRB,2.5510E-03_JPRB,1.3559E-02_JPRB/)
KBO( :, 3,17, 7) = (/&
&4.3747E-03_JPRB,5.0202E-03_JPRB,4.4155E-03_JPRB,3.3613E-03_JPRB,1.5340E-02_JPRB/)
KBO( :, 4,17, 7) = (/&
&5.7340E-03_JPRB,6.5189E-03_JPRB,5.7286E-03_JPRB,4.3538E-03_JPRB,1.7220E-02_JPRB/)
KBO( :, 5,17, 7) = (/&
&7.3600E-03_JPRB,8.2990E-03_JPRB,7.2992E-03_JPRB,5.5548E-03_JPRB,1.9205E-02_JPRB/)
KBO( :, 1,18, 7) = (/&
&2.0898E-03_JPRB,2.4405E-03_JPRB,2.1542E-03_JPRB,1.6626E-03_JPRB,9.4417E-03_JPRB/)
KBO( :, 2,18, 7) = (/&
&2.8863E-03_JPRB,3.3353E-03_JPRB,2.9318E-03_JPRB,2.2352E-03_JPRB,1.0813E-02_JPRB/)
KBO( :, 3,18, 7) = (/&
&3.8771E-03_JPRB,4.4358E-03_JPRB,3.8935E-03_JPRB,2.9472E-03_JPRB,1.2260E-02_JPRB/)
KBO( :, 4,18, 7) = (/&
&5.0839E-03_JPRB,5.7663E-03_JPRB,5.0610E-03_JPRB,3.8229E-03_JPRB,1.3797E-02_JPRB/)
KBO( :, 5,18, 7) = (/&
&6.5362E-03_JPRB,7.3472E-03_JPRB,6.4549E-03_JPRB,4.8781E-03_JPRB,1.5427E-02_JPRB/)
KBO( :, 1,19, 7) = (/&
&1.8517E-03_JPRB,2.1548E-03_JPRB,1.8965E-03_JPRB,1.4580E-03_JPRB,7.7773E-03_JPRB/)
KBO( :, 2,19, 7) = (/&
&2.5576E-03_JPRB,2.9471E-03_JPRB,2.5846E-03_JPRB,1.9612E-03_JPRB,8.9176E-03_JPRB/)
KBO( :, 3,19, 7) = (/&
&3.4345E-03_JPRB,3.9244E-03_JPRB,3.4362E-03_JPRB,2.5906E-03_JPRB,1.0132E-02_JPRB/)
KBO( :, 4,19, 7) = (/&
&4.5064E-03_JPRB,5.0994E-03_JPRB,4.4700E-03_JPRB,3.3642E-03_JPRB,1.1431E-02_JPRB/)
KBO( :, 5,19, 7) = (/&
&5.8097E-03_JPRB,6.5083E-03_JPRB,5.7046E-03_JPRB,4.2905E-03_JPRB,1.2808E-02_JPRB/)
KBO( :, 1,20, 7) = (/&
&1.6458E-03_JPRB,1.9103E-03_JPRB,1.6781E-03_JPRB,1.2831E-03_JPRB,6.5141E-03_JPRB/)
KBO( :, 2,20, 7) = (/&
&2.2698E-03_JPRB,2.6130E-03_JPRB,2.2877E-03_JPRB,1.7278E-03_JPRB,7.4849E-03_JPRB/)
KBO( :, 3,20, 7) = (/&
&3.0464E-03_JPRB,3.4772E-03_JPRB,3.0427E-03_JPRB,2.2845E-03_JPRB,8.5198E-03_JPRB/)
KBO( :, 4,20, 7) = (/&
&4.0053E-03_JPRB,4.5205E-03_JPRB,3.9563E-03_JPRB,2.9671E-03_JPRB,9.6230E-03_JPRB/)
KBO( :, 5,20, 7) = (/&
&5.1704E-03_JPRB,5.7875E-03_JPRB,5.0542E-03_JPRB,3.7806E-03_JPRB,1.0800E-02_JPRB/)
KBO( :, 1,21, 7) = (/&
&1.4548E-03_JPRB,1.6903E-03_JPRB,1.4830E-03_JPRB,1.1276E-03_JPRB,5.4461E-03_JPRB/)
KBO( :, 2,21, 7) = (/&
&2.0031E-03_JPRB,2.3102E-03_JPRB,2.0214E-03_JPRB,1.5202E-03_JPRB,6.2763E-03_JPRB/)
KBO( :, 3,21, 7) = (/&
&2.6919E-03_JPRB,3.0723E-03_JPRB,2.6854E-03_JPRB,2.0114E-03_JPRB,7.1636E-03_JPRB/)
KBO( :, 4,21, 7) = (/&
&3.5436E-03_JPRB,4.0040E-03_JPRB,3.4935E-03_JPRB,2.6088E-03_JPRB,8.1098E-03_JPRB/)
KBO( :, 5,21, 7) = (/&
&4.5742E-03_JPRB,5.1416E-03_JPRB,4.4723E-03_JPRB,3.3261E-03_JPRB,9.1112E-03_JPRB/)
KBO( :, 1,22, 7) = (/&
&1.3025E-03_JPRB,1.5176E-03_JPRB,1.3319E-03_JPRB,1.0078E-03_JPRB,4.4970E-03_JPRB/)
KBO( :, 2,22, 7) = (/&
&1.7911E-03_JPRB,2.0676E-03_JPRB,1.8104E-03_JPRB,1.3583E-03_JPRB,5.1953E-03_JPRB/)
KBO( :, 3,22, 7) = (/&
&2.4070E-03_JPRB,2.7511E-03_JPRB,2.4021E-03_JPRB,1.7933E-03_JPRB,5.9455E-03_JPRB/)
KBO( :, 4,22, 7) = (/&
&3.1635E-03_JPRB,3.5916E-03_JPRB,3.1285E-03_JPRB,2.3228E-03_JPRB,6.7435E-03_JPRB/)
KBO( :, 5,22, 7) = (/&
&4.0745E-03_JPRB,4.6107E-03_JPRB,4.0048E-03_JPRB,2.9650E-03_JPRB,7.5904E-03_JPRB/)
KBO( :, 1,23, 7) = (/&
&1.1628E-03_JPRB,1.3564E-03_JPRB,1.1911E-03_JPRB,9.0035E-04_JPRB,3.6865E-03_JPRB/)
KBO( :, 2,23, 7) = (/&
&1.5981E-03_JPRB,1.8458E-03_JPRB,1.6157E-03_JPRB,1.2111E-03_JPRB,4.2718E-03_JPRB/)
KBO( :, 3,23, 7) = (/&
&2.1434E-03_JPRB,2.4578E-03_JPRB,2.1451E-03_JPRB,1.5961E-03_JPRB,4.9004E-03_JPRB/)
KBO( :, 4,23, 7) = (/&
&2.8070E-03_JPRB,3.2089E-03_JPRB,2.7931E-03_JPRB,2.0693E-03_JPRB,5.5690E-03_JPRB/)
KBO( :, 5,23, 7) = (/&
&3.6060E-03_JPRB,4.1114E-03_JPRB,3.5718E-03_JPRB,2.6408E-03_JPRB,6.2767E-03_JPRB/)
KBO( :, 1,24, 7) = (/&
&1.0349E-03_JPRB,1.2079E-03_JPRB,1.0608E-03_JPRB,8.0145E-04_JPRB,2.9772E-03_JPRB/)
KBO( :, 2,24, 7) = (/&
&1.4200E-03_JPRB,1.6442E-03_JPRB,1.4384E-03_JPRB,1.0762E-03_JPRB,3.4619E-03_JPRB/)
KBO( :, 3,24, 7) = (/&
&1.8974E-03_JPRB,2.1881E-03_JPRB,1.9089E-03_JPRB,1.4192E-03_JPRB,3.9815E-03_JPRB/)
KBO( :, 4,24, 7) = (/&
&2.4779E-03_JPRB,2.8499E-03_JPRB,2.4818E-03_JPRB,1.8400E-03_JPRB,4.5322E-03_JPRB/)
KBO( :, 5,24, 7) = (/&
&3.1754E-03_JPRB,3.6385E-03_JPRB,3.1666E-03_JPRB,2.3457E-03_JPRB,5.1151E-03_JPRB/)
KBO( :, 1,25, 7) = (/&
&9.2232E-04_JPRB,1.0772E-03_JPRB,9.4524E-04_JPRB,7.1253E-04_JPRB,2.4032E-03_JPRB/)
KBO( :, 2,25, 7) = (/&
&1.2605E-03_JPRB,1.4648E-03_JPRB,1.2810E-03_JPRB,9.5673E-04_JPRB,2.8023E-03_JPRB/)
KBO( :, 3,25, 7) = (/&
&1.6782E-03_JPRB,1.9434E-03_JPRB,1.6961E-03_JPRB,1.2611E-03_JPRB,3.2283E-03_JPRB/)
KBO( :, 4,25, 7) = (/&
&2.1858E-03_JPRB,2.5220E-03_JPRB,2.1978E-03_JPRB,1.6329E-03_JPRB,3.6803E-03_JPRB/)
KBO( :, 5,25, 7) = (/&
&2.7953E-03_JPRB,3.2125E-03_JPRB,2.7973E-03_JPRB,2.0776E-03_JPRB,4.1586E-03_JPRB/)
KBO( :, 1,26, 7) = (/&
&8.2577E-04_JPRB,9.6602E-04_JPRB,8.4698E-04_JPRB,6.3651E-04_JPRB,1.9589E-03_JPRB/)
KBO( :, 2,26, 7) = (/&
&1.1231E-03_JPRB,1.3082E-03_JPRB,1.1442E-03_JPRB,8.5380E-04_JPRB,2.2874E-03_JPRB/)
KBO( :, 3,26, 7) = (/&
&1.4894E-03_JPRB,1.7283E-03_JPRB,1.5086E-03_JPRB,1.1231E-03_JPRB,2.6381E-03_JPRB/)
KBO( :, 4,26, 7) = (/&
&1.9347E-03_JPRB,2.2358E-03_JPRB,1.9486E-03_JPRB,1.4502E-03_JPRB,3.0100E-03_JPRB/)
KBO( :, 5,26, 7) = (/&
&2.4718E-03_JPRB,2.8431E-03_JPRB,2.4753E-03_JPRB,1.8399E-03_JPRB,3.4018E-03_JPRB/)
KBO( :, 1,27, 7) = (/&
&7.3643E-04_JPRB,8.6319E-04_JPRB,7.5644E-04_JPRB,5.6757E-04_JPRB,1.5698E-03_JPRB/)
KBO( :, 2,27, 7) = (/&
&9.9721E-04_JPRB,1.1634E-03_JPRB,1.0175E-03_JPRB,7.5949E-04_JPRB,1.8348E-03_JPRB/)
KBO( :, 3,27, 7) = (/&
&1.3189E-03_JPRB,1.5314E-03_JPRB,1.3364E-03_JPRB,9.9619E-04_JPRB,2.1183E-03_JPRB/)
KBO( :, 4,27, 7) = (/&
&1.7109E-03_JPRB,1.9771E-03_JPRB,1.7222E-03_JPRB,1.2827E-03_JPRB,2.4187E-03_JPRB/)
KBO( :, 5,27, 7) = (/&
&2.1861E-03_JPRB,2.5131E-03_JPRB,2.1851E-03_JPRB,1.6243E-03_JPRB,2.7339E-03_JPRB/)
KBO( :, 1,28, 7) = (/&
&6.5434E-04_JPRB,7.6837E-04_JPRB,6.7291E-04_JPRB,5.0480E-04_JPRB,1.2349E-03_JPRB/)
KBO( :, 2,28, 7) = (/&
&8.8335E-04_JPRB,1.0312E-03_JPRB,9.0136E-04_JPRB,6.7348E-04_JPRB,1.4454E-03_JPRB/)
KBO( :, 3,28, 7) = (/&
&1.1654E-03_JPRB,1.3544E-03_JPRB,1.1806E-03_JPRB,8.8065E-04_JPRB,1.6701E-03_JPRB/)
KBO( :, 4,28, 7) = (/&
&1.5130E-03_JPRB,1.7468E-03_JPRB,1.5197E-03_JPRB,1.1317E-03_JPRB,1.9084E-03_JPRB/)
KBO( :, 5,28, 7) = (/&
&1.9346E-03_JPRB,2.2214E-03_JPRB,1.9275E-03_JPRB,1.4311E-03_JPRB,2.1590E-03_JPRB/)
KBO( :, 1,29, 7) = (/&
&5.8250E-04_JPRB,6.8415E-04_JPRB,5.9900E-04_JPRB,4.4923E-04_JPRB,9.6138E-04_JPRB/)
KBO( :, 2,29, 7) = (/&
&7.8379E-04_JPRB,9.1559E-04_JPRB,7.9935E-04_JPRB,5.9724E-04_JPRB,1.1264E-03_JPRB/)
KBO( :, 3,29, 7) = (/&
&1.0337E-03_JPRB,1.2006E-03_JPRB,1.0452E-03_JPRB,7.7918E-04_JPRB,1.3027E-03_JPRB/)
KBO( :, 4,29, 7) = (/&
&1.3430E-03_JPRB,1.5485E-03_JPRB,1.3445E-03_JPRB,9.9943E-04_JPRB,1.4903E-03_JPRB/)
KBO( :, 5,29, 7) = (/&
&1.7207E-03_JPRB,1.9712E-03_JPRB,1.7058E-03_JPRB,1.2628E-03_JPRB,1.6874E-03_JPRB/)
KBO( :, 1,30, 7) = (/&
&5.1788E-04_JPRB,6.0851E-04_JPRB,5.3244E-04_JPRB,3.9922E-04_JPRB,7.3807E-04_JPRB/)
KBO( :, 2,30, 7) = (/&
&6.9560E-04_JPRB,8.1280E-04_JPRB,7.0896E-04_JPRB,5.2926E-04_JPRB,8.6555E-04_JPRB/)
KBO( :, 3,30, 7) = (/&
&9.1854E-04_JPRB,1.0653E-03_JPRB,9.2608E-04_JPRB,6.8944E-04_JPRB,1.0029E-03_JPRB/)
KBO( :, 4,30, 7) = (/&
&1.1948E-03_JPRB,1.3752E-03_JPRB,1.1917E-03_JPRB,8.8341E-04_JPRB,1.1491E-03_JPRB/)
KBO( :, 5,30, 7) = (/&
&1.5335E-03_JPRB,1.7547E-03_JPRB,1.5125E-03_JPRB,1.1162E-03_JPRB,1.3024E-03_JPRB/)
KBO( :, 1,31, 7) = (/&
&4.6092E-04_JPRB,5.4211E-04_JPRB,4.7408E-04_JPRB,3.5509E-04_JPRB,5.5682E-04_JPRB/)
KBO( :, 2,31, 7) = (/&
&6.1918E-04_JPRB,7.2321E-04_JPRB,6.3005E-04_JPRB,4.6997E-04_JPRB,6.5454E-04_JPRB/)
KBO( :, 3,31, 7) = (/&
&8.1881E-04_JPRB,9.4822E-04_JPRB,8.2290E-04_JPRB,6.1141E-04_JPRB,7.5997E-04_JPRB/)
KBO( :, 4,31, 7) = (/&
&1.0668E-03_JPRB,1.2267E-03_JPRB,1.0593E-03_JPRB,7.8292E-04_JPRB,8.7195E-04_JPRB/)
KBO( :, 5,31, 7) = (/&
&1.3704E-03_JPRB,1.5681E-03_JPRB,1.3465E-03_JPRB,9.8920E-04_JPRB,9.8973E-04_JPRB/)
KBO( :, 1,32, 7) = (/&
&4.1152E-04_JPRB,4.8409E-04_JPRB,4.2308E-04_JPRB,3.1645E-04_JPRB,4.2168E-04_JPRB/)
KBO( :, 2,32, 7) = (/&
&5.5334E-04_JPRB,6.4575E-04_JPRB,5.6167E-04_JPRB,4.1833E-04_JPRB,4.9677E-04_JPRB/)
KBO( :, 3,32, 7) = (/&
&7.3299E-04_JPRB,8.4766E-04_JPRB,7.3383E-04_JPRB,5.4370E-04_JPRB,5.7774E-04_JPRB/)
KBO( :, 4,32, 7) = (/&
&9.5588E-04_JPRB,1.0987E-03_JPRB,9.4586E-04_JPRB,6.9613E-04_JPRB,6.6384E-04_JPRB/)
KBO( :, 5,32, 7) = (/&
&1.2288E-03_JPRB,1.4065E-03_JPRB,1.2040E-03_JPRB,8.8013E-04_JPRB,7.5486E-04_JPRB/)
KBO( :, 1,33, 7) = (/&
&3.6854E-04_JPRB,4.3316E-04_JPRB,3.7817E-04_JPRB,2.8260E-04_JPRB,3.1899E-04_JPRB/)
KBO( :, 2,33, 7) = (/&
&4.9646E-04_JPRB,5.7816E-04_JPRB,5.0221E-04_JPRB,3.7315E-04_JPRB,3.7656E-04_JPRB/)
KBO( :, 3,33, 7) = (/&
&6.5808E-04_JPRB,7.6063E-04_JPRB,6.5667E-04_JPRB,4.8480E-04_JPRB,4.3876E-04_JPRB/)
KBO( :, 4,33, 7) = (/&
&8.5867E-04_JPRB,9.8782E-04_JPRB,8.4748E-04_JPRB,6.2133E-04_JPRB,5.0517E-04_JPRB/)
KBO( :, 5,33, 7) = (/&
&1.1037E-03_JPRB,1.2658E-03_JPRB,1.0801E-03_JPRB,7.8611E-04_JPRB,5.7532E-04_JPRB/)
KBO( :, 1,34, 7) = (/&
&3.2867E-04_JPRB,3.8572E-04_JPRB,3.3622E-04_JPRB,2.5071E-04_JPRB,2.4855E-04_JPRB/)
KBO( :, 2,34, 7) = (/&
&4.4343E-04_JPRB,5.1569E-04_JPRB,4.4686E-04_JPRB,3.3101E-04_JPRB,2.9381E-04_JPRB/)
KBO( :, 3,34, 7) = (/&
&5.8810E-04_JPRB,6.7990E-04_JPRB,5.8528E-04_JPRB,4.3031E-04_JPRB,3.4255E-04_JPRB/)
KBO( :, 4,34, 7) = (/&
&7.6737E-04_JPRB,8.8428E-04_JPRB,7.5640E-04_JPRB,5.5217E-04_JPRB,3.9478E-04_JPRB/)
KBO( :, 5,34, 7) = (/&
&9.8517E-04_JPRB,1.1342E-03_JPRB,9.6554E-04_JPRB,6.9951E-04_JPRB,4.5002E-04_JPRB/)
KBO( :, 1,35, 7) = (/&
&2.8513E-04_JPRB,3.3438E-04_JPRB,2.9108E-04_JPRB,2.1672E-04_JPRB,1.8974E-04_JPRB/)
KBO( :, 2,35, 7) = (/&
&3.8542E-04_JPRB,4.4857E-04_JPRB,3.8802E-04_JPRB,2.8661E-04_JPRB,2.2492E-04_JPRB/)
KBO( :, 3,35, 7) = (/&
&5.1208E-04_JPRB,5.9329E-04_JPRB,5.0967E-04_JPRB,3.7356E-04_JPRB,2.6284E-04_JPRB/)
KBO( :, 4,35, 7) = (/&
&6.6882E-04_JPRB,7.7366E-04_JPRB,6.6059E-04_JPRB,4.8046E-04_JPRB,3.0352E-04_JPRB/)
KBO( :, 5,35, 7) = (/&
&8.5775E-04_JPRB,9.9358E-04_JPRB,8.4548E-04_JPRB,6.1010E-04_JPRB,3.4691E-04_JPRB/)
KBO( :, 1,36, 7) = (/&
&2.3908E-04_JPRB,2.8086E-04_JPRB,2.4432E-04_JPRB,1.8172E-04_JPRB,1.4131E-04_JPRB/)
KBO( :, 2,36, 7) = (/&
&3.2447E-04_JPRB,3.7866E-04_JPRB,3.2729E-04_JPRB,2.4123E-04_JPRB,1.6828E-04_JPRB/)
KBO( :, 3,36, 7) = (/&
&4.3244E-04_JPRB,5.0306E-04_JPRB,4.3179E-04_JPRB,3.1573E-04_JPRB,1.9752E-04_JPRB/)
KBO( :, 4,36, 7) = (/&
&5.6587E-04_JPRB,6.5843E-04_JPRB,5.6206E-04_JPRB,4.0778E-04_JPRB,2.2899E-04_JPRB/)
KBO( :, 5,36, 7) = (/&
&7.2600E-04_JPRB,8.4746E-04_JPRB,7.2177E-04_JPRB,5.1967E-04_JPRB,2.6262E-04_JPRB/)
KBO( :, 1,37, 7) = (/&
&1.9223E-04_JPRB,2.2635E-04_JPRB,1.9687E-04_JPRB,1.4630E-04_JPRB,1.0794E-04_JPRB/)
KBO( :, 2,37, 7) = (/&
&2.6242E-04_JPRB,3.0724E-04_JPRB,2.6553E-04_JPRB,1.9547E-04_JPRB,1.2910E-04_JPRB/)
KBO( :, 3,37, 7) = (/&
&3.5150E-04_JPRB,4.1071E-04_JPRB,3.5262E-04_JPRB,2.5740E-04_JPRB,1.5213E-04_JPRB/)
KBO( :, 4,37, 7) = (/&
&4.6185E-04_JPRB,5.4051E-04_JPRB,4.6167E-04_JPRB,3.3450E-04_JPRB,1.7700E-04_JPRB/)
KBO( :, 5,37, 7) = (/&
&5.9416E-04_JPRB,6.9865E-04_JPRB,5.9573E-04_JPRB,4.2859E-04_JPRB,2.0366E-04_JPRB/)
KBO( :, 1,38, 7) = (/&
&1.5396E-04_JPRB,1.8186E-04_JPRB,1.5820E-04_JPRB,1.1745E-04_JPRB,8.2026E-05_JPRB/)
KBO( :, 2,38, 7) = (/&
&2.1139E-04_JPRB,2.4853E-04_JPRB,2.1486E-04_JPRB,1.5802E-04_JPRB,9.8555E-05_JPRB/)
KBO( :, 3,38, 7) = (/&
&2.8454E-04_JPRB,3.3433E-04_JPRB,2.8721E-04_JPRB,2.0943E-04_JPRB,1.1661E-04_JPRB/)
KBO( :, 4,38, 7) = (/&
&3.7538E-04_JPRB,4.4233E-04_JPRB,3.7835E-04_JPRB,2.7384E-04_JPRB,1.3622E-04_JPRB/)
KBO( :, 5,38, 7) = (/&
&4.8432E-04_JPRB,5.7425E-04_JPRB,4.9054E-04_JPRB,3.5276E-04_JPRB,1.5730E-04_JPRB/)
KBO( :, 1,39, 7) = (/&
&1.2310E-04_JPRB,1.4596E-04_JPRB,1.2703E-04_JPRB,9.4291E-05_JPRB,6.1783E-05_JPRB/)
KBO( :, 2,39, 7) = (/&
&1.6994E-04_JPRB,2.0085E-04_JPRB,1.7375E-04_JPRB,1.2772E-04_JPRB,7.4607E-05_JPRB/)
KBO( :, 3,39, 7) = (/&
&2.2988E-04_JPRB,2.7190E-04_JPRB,2.3385E-04_JPRB,1.7039E-04_JPRB,8.8689E-05_JPRB/)
KBO( :, 4,39, 7) = (/&
&3.0447E-04_JPRB,3.6157E-04_JPRB,3.0996E-04_JPRB,2.2416E-04_JPRB,1.0404E-04_JPRB/)
KBO( :, 5,39, 7) = (/&
&3.9383E-04_JPRB,4.7143E-04_JPRB,4.0364E-04_JPRB,2.9022E-04_JPRB,1.2062E-04_JPRB/)
KBO( :, 1,40, 7) = (/&
&9.5155E-05_JPRB,1.1332E-04_JPRB,9.8734E-05_JPRB,7.3344E-05_JPRB,4.6985E-05_JPRB/)
KBO( :, 2,40, 7) = (/&
&1.3236E-04_JPRB,1.5726E-04_JPRB,1.3621E-04_JPRB,1.0020E-04_JPRB,5.7054E-05_JPRB/)
KBO( :, 3,40, 7) = (/&
&1.8031E-04_JPRB,2.1454E-04_JPRB,1.8484E-04_JPRB,1.3474E-04_JPRB,6.8162E-05_JPRB/)
KBO( :, 4,40, 7) = (/&
&2.4017E-04_JPRB,2.8725E-04_JPRB,2.4684E-04_JPRB,1.7861E-04_JPRB,8.0321E-05_JPRB/)
KBO( :, 5,40, 7) = (/&
&3.1223E-04_JPRB,3.7700E-04_JPRB,3.2358E-04_JPRB,2.3279E-04_JPRB,9.3499E-05_JPRB/)
KBO( :, 1,41, 7) = (/&
&7.3040E-05_JPRB,8.7365E-05_JPRB,7.6219E-05_JPRB,5.6696E-05_JPRB,3.5628E-05_JPRB/)
KBO( :, 2,41, 7) = (/&
&1.0242E-04_JPRB,1.2231E-04_JPRB,1.0608E-04_JPRB,7.8149E-05_JPRB,4.3528E-05_JPRB/)
KBO( :, 3,41, 7) = (/&
&1.4051E-04_JPRB,1.6819E-04_JPRB,1.4521E-04_JPRB,1.0598E-04_JPRB,5.2277E-05_JPRB/)
KBO( :, 4,41, 7) = (/&
&1.8838E-04_JPRB,2.2688E-04_JPRB,1.9542E-04_JPRB,1.4156E-04_JPRB,6.1894E-05_JPRB/)
KBO( :, 5,41, 7) = (/&
&2.4622E-04_JPRB,2.9976E-04_JPRB,2.5798E-04_JPRB,1.8586E-04_JPRB,7.2357E-05_JPRB/)
KBO( :, 1,42, 7) = (/&
&5.5864E-05_JPRB,6.7119E-05_JPRB,5.8652E-05_JPRB,4.3719E-05_JPRB,2.6853E-05_JPRB/)
KBO( :, 2,42, 7) = (/&
&7.9009E-05_JPRB,9.4831E-05_JPRB,8.2368E-05_JPRB,6.0798E-05_JPRB,3.3017E-05_JPRB/)
KBO( :, 3,42, 7) = (/&
&1.0919E-04_JPRB,1.3143E-04_JPRB,1.1371E-04_JPRB,8.3133E-05_JPRB,3.9881E-05_JPRB/)
KBO( :, 4,42, 7) = (/&
&1.4736E-04_JPRB,1.7866E-04_JPRB,1.5424E-04_JPRB,1.1195E-04_JPRB,4.7449E-05_JPRB/)
KBO( :, 5,42, 7) = (/&
&1.9372E-04_JPRB,2.3766E-04_JPRB,2.0511E-04_JPRB,1.4803E-04_JPRB,5.5730E-05_JPRB/)
KBO( :, 1,43, 7) = (/&
&4.1761E-05_JPRB,5.0398E-05_JPRB,4.4130E-05_JPRB,3.2985E-05_JPRB,2.0073E-05_JPRB/)
KBO( :, 2,43, 7) = (/&
&5.9645E-05_JPRB,7.1916E-05_JPRB,6.2599E-05_JPRB,4.6330E-05_JPRB,2.4864E-05_JPRB/)
KBO( :, 3,43, 7) = (/&
&8.3194E-05_JPRB,1.0064E-04_JPRB,8.7232E-05_JPRB,6.3942E-05_JPRB,3.0235E-05_JPRB/)
KBO( :, 4,43, 7) = (/&
&1.1320E-04_JPRB,1.3803E-04_JPRB,1.1940E-04_JPRB,8.6870E-05_JPRB,3.6178E-05_JPRB/)
KBO( :, 5,43, 7) = (/&
&1.4992E-04_JPRB,1.8511E-04_JPRB,1.6011E-04_JPRB,1.1587E-04_JPRB,4.2707E-05_JPRB/)
KBO( :, 1,44, 7) = (/&
&3.0801E-05_JPRB,3.7349E-05_JPRB,3.2753E-05_JPRB,2.4577E-05_JPRB,1.4891E-05_JPRB/)
KBO( :, 2,44, 7) = (/&
&4.4487E-05_JPRB,5.3871E-05_JPRB,4.6990E-05_JPRB,3.4888E-05_JPRB,1.8592E-05_JPRB/)
KBO( :, 3,44, 7) = (/&
&6.2658E-05_JPRB,7.6156E-05_JPRB,6.6129E-05_JPRB,4.8623E-05_JPRB,2.2773E-05_JPRB/)
KBO( :, 4,44, 7) = (/&
&8.6061E-05_JPRB,1.0547E-04_JPRB,9.1388E-05_JPRB,6.6679E-05_JPRB,2.7431E-05_JPRB/)
KBO( :, 5,44, 7) = (/&
&1.1501E-04_JPRB,1.4274E-04_JPRB,1.2369E-04_JPRB,8.9747E-05_JPRB,3.2565E-05_JPRB/)
KBO( :, 1,45, 7) = (/&
&2.2608E-05_JPRB,2.7541E-05_JPRB,2.4185E-05_JPRB,1.8232E-05_JPRB,1.0958E-05_JPRB/)
KBO( :, 2,45, 7) = (/&
&3.3025E-05_JPRB,4.0159E-05_JPRB,3.5109E-05_JPRB,2.6156E-05_JPRB,1.3799E-05_JPRB/)
KBO( :, 3,45, 7) = (/&
&4.7011E-05_JPRB,5.7379E-05_JPRB,4.9919E-05_JPRB,3.6820E-05_JPRB,1.7031E-05_JPRB/)
KBO( :, 4,45, 7) = (/&
&6.5198E-05_JPRB,8.0265E-05_JPRB,6.9669E-05_JPRB,5.0975E-05_JPRB,2.0660E-05_JPRB/)
KBO( :, 5,45, 7) = (/&
&8.7915E-05_JPRB,1.0965E-04_JPRB,9.5159E-05_JPRB,6.9236E-05_JPRB,2.4675E-05_JPRB/)
KBO( :, 1,46, 7) = (/&
&1.6373E-05_JPRB,2.0043E-05_JPRB,1.7624E-05_JPRB,1.3360E-05_JPRB,7.9926E-06_JPRB/)
KBO( :, 2,46, 7) = (/&
&2.4216E-05_JPRB,2.9567E-05_JPRB,2.5903E-05_JPRB,1.9373E-05_JPRB,1.0160E-05_JPRB/)
KBO( :, 3,46, 7) = (/&
&3.4868E-05_JPRB,4.2722E-05_JPRB,3.7241E-05_JPRB,2.7564E-05_JPRB,1.2643E-05_JPRB/)
KBO( :, 4,46, 7) = (/&
&4.8882E-05_JPRB,6.0410E-05_JPRB,5.2522E-05_JPRB,3.8539E-05_JPRB,1.5455E-05_JPRB/)
KBO( :, 5,46, 7) = (/&
&6.6579E-05_JPRB,8.3392E-05_JPRB,7.2472E-05_JPRB,5.2864E-05_JPRB,1.8586E-05_JPRB/)
KBO( :, 1,47, 7) = (/&
&1.1599E-05_JPRB,1.4268E-05_JPRB,1.2567E-05_JPRB,9.5846E-06_JPRB,5.7865E-06_JPRB/)
KBO( :, 2,47, 7) = (/&
&1.7394E-05_JPRB,2.1321E-05_JPRB,1.8719E-05_JPRB,1.4063E-05_JPRB,7.4320E-06_JPRB/)
KBO( :, 3,47, 7) = (/&
&2.5375E-05_JPRB,3.1189E-05_JPRB,2.7244E-05_JPRB,2.0242E-05_JPRB,9.3345E-06_JPRB/)
KBO( :, 4,47, 7) = (/&
&3.6020E-05_JPRB,4.4624E-05_JPRB,3.8868E-05_JPRB,2.8612E-05_JPRB,1.1506E-05_JPRB/)
KBO( :, 5,47, 7) = (/&
&4.9650E-05_JPRB,6.2358E-05_JPRB,5.4247E-05_JPRB,3.9674E-05_JPRB,1.3945E-05_JPRB/)
KBO( :, 1,48, 7) = (/&
&8.1592E-06_JPRB,1.0088E-05_JPRB,8.9029E-06_JPRB,6.8352E-06_JPRB,4.1486E-06_JPRB/)
KBO( :, 2,48, 7) = (/&
&1.2414E-05_JPRB,1.5281E-05_JPRB,1.3442E-05_JPRB,1.0147E-05_JPRB,5.3865E-06_JPRB/)
KBO( :, 3,48, 7) = (/&
&1.8355E-05_JPRB,2.2636E-05_JPRB,1.9815E-05_JPRB,1.4784E-05_JPRB,6.8320E-06_JPRB/)
KBO( :, 4,48, 7) = (/&
&2.6399E-05_JPRB,3.2787E-05_JPRB,2.8606E-05_JPRB,2.1130E-05_JPRB,8.4972E-06_JPRB/)
KBO( :, 5,48, 7) = (/&
&3.6834E-05_JPRB,4.6374E-05_JPRB,4.0398E-05_JPRB,2.9623E-05_JPRB,1.0383E-05_JPRB/)
KBO( :, 1,49, 7) = (/&
&5.6950E-06_JPRB,7.0854E-06_JPRB,6.2658E-06_JPRB,4.8460E-06_JPRB,2.9411E-06_JPRB/)
KBO( :, 2,49, 7) = (/&
&8.8040E-06_JPRB,1.0880E-05_JPRB,9.5884E-06_JPRB,7.2776E-06_JPRB,3.8607E-06_JPRB/)
KBO( :, 3,49, 7) = (/&
&1.3194E-05_JPRB,1.6321E-05_JPRB,1.4323E-05_JPRB,1.0731E-05_JPRB,4.9471E-06_JPRB/)
KBO( :, 4,49, 7) = (/&
&1.9231E-05_JPRB,2.3945E-05_JPRB,2.0927E-05_JPRB,1.5515E-05_JPRB,6.2112E-06_JPRB/)
KBO( :, 5,49, 7) = (/&
&2.7183E-05_JPRB,3.4291E-05_JPRB,2.9917E-05_JPRB,2.1999E-05_JPRB,7.6566E-06_JPRB/)
KBO( :, 1,50, 7) = (/&
&3.9958E-06_JPRB,5.0015E-06_JPRB,4.4366E-06_JPRB,3.4585E-06_JPRB,2.1227E-06_JPRB/)
KBO( :, 2,50, 7) = (/&
&6.2784E-06_JPRB,7.7901E-06_JPRB,6.8759E-06_JPRB,5.2490E-06_JPRB,2.8123E-06_JPRB/)
KBO( :, 3,50, 7) = (/&
&9.5367E-06_JPRB,1.1828E-05_JPRB,1.0406E-05_JPRB,7.8273E-06_JPRB,3.6384E-06_JPRB/)
KBO( :, 4,50, 7) = (/&
&1.4076E-05_JPRB,1.7574E-05_JPRB,1.5384E-05_JPRB,1.1445E-05_JPRB,4.6069E-06_JPRB/)
KBO( :, 5,50, 7) = (/&
&2.0158E-05_JPRB,2.5470E-05_JPRB,2.2251E-05_JPRB,1.6406E-05_JPRB,5.7245E-06_JPRB/)
KBO( :, 1,51, 7) = (/&
&2.7988E-06_JPRB,3.5266E-06_JPRB,3.1403E-06_JPRB,2.4729E-06_JPRB,1.5428E-06_JPRB/)
KBO( :, 2,51, 7) = (/&
&4.4758E-06_JPRB,5.5781E-06_JPRB,4.9313E-06_JPRB,3.7868E-06_JPRB,2.0615E-06_JPRB/)
KBO( :, 3,51, 7) = (/&
&6.8951E-06_JPRB,8.5722E-06_JPRB,7.5560E-06_JPRB,5.7084E-06_JPRB,2.6915E-06_JPRB/)
KBO( :, 4,51, 7) = (/&
&1.0304E-05_JPRB,1.2894E-05_JPRB,1.1308E-05_JPRB,8.4393E-06_JPRB,3.4363E-06_JPRB/)
KBO( :, 5,51, 7) = (/&
&1.4945E-05_JPRB,1.8920E-05_JPRB,1.6546E-05_JPRB,1.2232E-05_JPRB,4.3031E-06_JPRB/)
KBO( :, 1,52, 7) = (/&
&1.9435E-06_JPRB,2.4685E-06_JPRB,2.2098E-06_JPRB,1.7634E-06_JPRB,1.1143E-06_JPRB/)
KBO( :, 2,52, 7) = (/&
&3.1695E-06_JPRB,3.9713E-06_JPRB,3.5183E-06_JPRB,2.7199E-06_JPRB,1.5011E-06_JPRB/)
KBO( :, 3,52, 7) = (/&
&4.9592E-06_JPRB,6.1828E-06_JPRB,5.4581E-06_JPRB,4.1434E-06_JPRB,1.9775E-06_JPRB/)
KBO( :, 4,52, 7) = (/&
&7.5082E-06_JPRB,9.4119E-06_JPRB,8.2722E-06_JPRB,6.1949E-06_JPRB,2.5467E-06_JPRB/)
KBO( :, 5,52, 7) = (/&
&1.1026E-05_JPRB,1.3984E-05_JPRB,1.2246E-05_JPRB,9.0780E-06_JPRB,3.2145E-06_JPRB/)
KBO( :, 1,53, 7) = (/&
&1.3359E-06_JPRB,1.7128E-06_JPRB,1.5439E-06_JPRB,1.2551E-06_JPRB,7.9874E-07_JPRB/)
KBO( :, 2,53, 7) = (/&
&2.2274E-06_JPRB,2.8086E-06_JPRB,2.4951E-06_JPRB,1.9446E-06_JPRB,1.0843E-06_JPRB/)
KBO( :, 3,53, 7) = (/&
&3.5445E-06_JPRB,4.4342E-06_JPRB,3.9206E-06_JPRB,2.9916E-06_JPRB,1.4407E-06_JPRB/)
KBO( :, 4,53, 7) = (/&
&5.4423E-06_JPRB,6.8307E-06_JPRB,6.0173E-06_JPRB,4.5231E-06_JPRB,1.8721E-06_JPRB/)
KBO( :, 5,53, 7) = (/&
&8.0931E-06_JPRB,1.0281E-05_JPRB,9.0168E-06_JPRB,6.7031E-06_JPRB,2.3821E-06_JPRB/)
KBO( :, 1,54, 7) = (/&
&9.2652E-07_JPRB,1.1988E-06_JPRB,1.0892E-06_JPRB,9.0472E-07_JPRB,5.9185E-07_JPRB/)
KBO( :, 2,54, 7) = (/&
&1.5791E-06_JPRB,2.0042E-06_JPRB,1.7864E-06_JPRB,1.4053E-06_JPRB,8.0903E-07_JPRB/)
KBO( :, 3,54, 7) = (/&
&2.5564E-06_JPRB,3.2106E-06_JPRB,2.8433E-06_JPRB,2.1812E-06_JPRB,1.0829E-06_JPRB/)
KBO( :, 4,54, 7) = (/&
&3.9810E-06_JPRB,5.0042E-06_JPRB,4.4158E-06_JPRB,3.3311E-06_JPRB,1.4179E-06_JPRB/)
KBO( :, 5,54, 7) = (/&
&5.9940E-06_JPRB,7.6213E-06_JPRB,6.6941E-06_JPRB,4.9908E-06_JPRB,1.8162E-06_JPRB/)
KBO( :, 1,55, 7) = (/&
&6.4271E-07_JPRB,8.3986E-07_JPRB,7.6969E-07_JPRB,6.5622E-07_JPRB,4.4680E-07_JPRB/)
KBO( :, 2,55, 7) = (/&
&1.1202E-06_JPRB,1.4315E-06_JPRB,1.2812E-06_JPRB,1.0198E-06_JPRB,6.1469E-07_JPRB/)
KBO( :, 3,55, 7) = (/&
&1.8463E-06_JPRB,2.3303E-06_JPRB,2.0672E-06_JPRB,1.5950E-06_JPRB,8.2848E-07_JPRB/)
KBO( :, 4,55, 7) = (/&
&2.9187E-06_JPRB,3.6752E-06_JPRB,3.2484E-06_JPRB,2.4593E-06_JPRB,1.0923E-06_JPRB/)
KBO( :, 5,55, 7) = (/&
&4.4490E-06_JPRB,5.6623E-06_JPRB,4.9799E-06_JPRB,3.7232E-06_JPRB,1.4079E-06_JPRB/)
KBO( :, 1,56, 7) = (/&
&4.4222E-07_JPRB,5.8443E-07_JPRB,5.4132E-07_JPRB,4.7675E-07_JPRB,3.3738E-07_JPRB/)
KBO( :, 2,56, 7) = (/&
&7.8907E-07_JPRB,1.0157E-06_JPRB,9.1377E-07_JPRB,7.3810E-07_JPRB,4.6671E-07_JPRB/)
KBO( :, 3,56, 7) = (/&
&1.3248E-06_JPRB,1.6819E-06_JPRB,1.4956E-06_JPRB,1.1622E-06_JPRB,6.3354E-07_JPRB/)
KBO( :, 4,56, 7) = (/&
&2.1296E-06_JPRB,2.6885E-06_JPRB,2.3793E-06_JPRB,1.8091E-06_JPRB,8.4125E-07_JPRB/)
KBO( :, 5,56, 7) = (/&
&3.2905E-06_JPRB,4.1906E-06_JPRB,3.6905E-06_JPRB,2.7667E-06_JPRB,1.0917E-06_JPRB/)
KBO( :, 1,57, 7) = (/&
&3.0166E-07_JPRB,4.0366E-07_JPRB,3.7890E-07_JPRB,3.4759E-07_JPRB,2.5495E-07_JPRB/)
KBO( :, 2,57, 7) = (/&
&5.5161E-07_JPRB,7.1542E-07_JPRB,6.4792E-07_JPRB,5.3334E-07_JPRB,3.5433E-07_JPRB/)
KBO( :, 3,57, 7) = (/&
&9.4470E-07_JPRB,1.2069E-06_JPRB,1.0761E-06_JPRB,8.4394E-07_JPRB,4.8446E-07_JPRB/)
KBO( :, 4,57, 7) = (/&
&1.5448E-06_JPRB,1.9571E-06_JPRB,1.7349E-06_JPRB,1.3257E-06_JPRB,6.4791E-07_JPRB/)
KBO( :, 5,57, 7) = (/&
&2.4231E-06_JPRB,3.0885E-06_JPRB,2.7246E-06_JPRB,2.0476E-06_JPRB,8.4650E-07_JPRB/)
KBO( :, 1,58, 7) = (/&
&2.0615E-07_JPRB,2.7966E-07_JPRB,2.6659E-07_JPRB,2.5672E-07_JPRB,1.9490E-07_JPRB/)
KBO( :, 2,58, 7) = (/&
&3.8634E-07_JPRB,5.0506E-07_JPRB,4.6082E-07_JPRB,3.8792E-07_JPRB,2.7193E-07_JPRB/)
KBO( :, 3,58, 7) = (/&
&6.7545E-07_JPRB,8.6794E-07_JPRB,7.7672E-07_JPRB,6.1534E-07_JPRB,3.7439E-07_JPRB/)
KBO( :, 4,58, 7) = (/&
&1.1229E-06_JPRB,1.4289E-06_JPRB,1.2690E-06_JPRB,9.7539E-07_JPRB,5.0417E-07_JPRB/)
KBO( :, 5,58, 7) = (/&
&1.7888E-06_JPRB,2.2841E-06_JPRB,2.0182E-06_JPRB,1.5209E-06_JPRB,6.6299E-07_JPRB/)
KBO( :, 1,59, 7) = (/&
&1.5864E-07_JPRB,2.1618E-07_JPRB,2.0732E-07_JPRB,2.0350E-07_JPRB,1.6565E-07_JPRB/)
KBO( :, 2,59, 7) = (/&
&3.0072E-07_JPRB,3.9451E-07_JPRB,3.6086E-07_JPRB,3.0632E-07_JPRB,2.3297E-07_JPRB/)
KBO( :, 3,59, 7) = (/&
&5.3103E-07_JPRB,6.8463E-07_JPRB,6.1355E-07_JPRB,4.8792E-07_JPRB,3.2258E-07_JPRB/)
KBO( :, 4,59, 7) = (/&
&8.9096E-07_JPRB,1.1377E-06_JPRB,1.0113E-06_JPRB,7.7874E-07_JPRB,4.3608E-07_JPRB/)
KBO( :, 5,59, 7) = (/&
&1.4311E-06_JPRB,1.8344E-06_JPRB,1.6214E-06_JPRB,1.2223E-06_JPRB,5.7456E-07_JPRB/)
KBO( :, 1,13, 8) = (/&
&1.1431E-02_JPRB,1.2741E-02_JPRB,1.1436E-02_JPRB,9.1621E-03_JPRB,8.0519E-02_JPRB/)
KBO( :, 2,13, 8) = (/&
&1.5206E-02_JPRB,1.7160E-02_JPRB,1.5555E-02_JPRB,1.2454E-02_JPRB,8.6864E-02_JPRB/)
KBO( :, 3,13, 8) = (/&
&1.9976E-02_JPRB,2.2722E-02_JPRB,2.0654E-02_JPRB,1.6502E-02_JPRB,9.4446E-02_JPRB/)
KBO( :, 4,13, 8) = (/&
&2.5954E-02_JPRB,2.9643E-02_JPRB,2.6781E-02_JPRB,2.1406E-02_JPRB,1.0333E-01_JPRB/)
KBO( :, 5,13, 8) = (/&
&3.3352E-02_JPRB,3.7953E-02_JPRB,3.4189E-02_JPRB,2.7277E-02_JPRB,1.1304E-01_JPRB/)
KBO( :, 1,14, 8) = (/&
&1.0179E-02_JPRB,1.1389E-02_JPRB,1.0176E-02_JPRB,8.0522E-03_JPRB,6.5504E-02_JPRB/)
KBO( :, 2,14, 8) = (/&
&1.3641E-02_JPRB,1.5355E-02_JPRB,1.3817E-02_JPRB,1.0906E-02_JPRB,7.2230E-02_JPRB/)
KBO( :, 3,14, 8) = (/&
&1.8023E-02_JPRB,2.0418E-02_JPRB,1.8352E-02_JPRB,1.4437E-02_JPRB,8.0150E-02_JPRB/)
KBO( :, 4,14, 8) = (/&
&2.3532E-02_JPRB,2.6705E-02_JPRB,2.3876E-02_JPRB,1.8758E-02_JPRB,8.9038E-02_JPRB/)
KBO( :, 5,14, 8) = (/&
&3.0239E-02_JPRB,3.4282E-02_JPRB,3.0614E-02_JPRB,2.4017E-02_JPRB,9.8577E-02_JPRB/)
KBO( :, 1,15, 8) = (/&
&9.0090E-03_JPRB,1.0120E-02_JPRB,9.0167E-03_JPRB,7.0764E-03_JPRB,5.2591E-02_JPRB/)
KBO( :, 2,15, 8) = (/&
&1.2186E-02_JPRB,1.3734E-02_JPRB,1.2258E-02_JPRB,9.5696E-03_JPRB,5.9402E-02_JPRB/)
KBO( :, 3,15, 8) = (/&
&1.6225E-02_JPRB,1.8333E-02_JPRB,1.6340E-02_JPRB,1.2688E-02_JPRB,6.7127E-02_JPRB/)
KBO( :, 4,15, 8) = (/&
&2.1185E-02_JPRB,2.4042E-02_JPRB,2.1332E-02_JPRB,1.6578E-02_JPRB,7.5512E-02_JPRB/)
KBO( :, 5,15, 8) = (/&
&2.7141E-02_JPRB,3.0928E-02_JPRB,2.7480E-02_JPRB,2.1333E-02_JPRB,8.4521E-02_JPRB/)
KBO( :, 1,16, 8) = (/&
&7.9666E-03_JPRB,8.9862E-03_JPRB,7.9671E-03_JPRB,6.2242E-03_JPRB,4.1294E-02_JPRB/)
KBO( :, 2,16, 8) = (/&
&1.0885E-02_JPRB,1.2270E-02_JPRB,1.0885E-02_JPRB,8.4303E-03_JPRB,4.7519E-02_JPRB/)
KBO( :, 3,16, 8) = (/&
&1.4511E-02_JPRB,1.6442E-02_JPRB,1.4544E-02_JPRB,1.1234E-02_JPRB,5.4415E-02_JPRB/)
KBO( :, 4,16, 8) = (/&
&1.8926E-02_JPRB,2.1554E-02_JPRB,1.9076E-02_JPRB,1.4750E-02_JPRB,6.1801E-02_JPRB/)
KBO( :, 5,16, 8) = (/&
&2.4236E-02_JPRB,2.7687E-02_JPRB,2.4633E-02_JPRB,1.9024E-02_JPRB,6.9624E-02_JPRB/)
KBO( :, 1,17, 8) = (/&
&7.1080E-03_JPRB,8.0147E-03_JPRB,7.0758E-03_JPRB,5.4873E-03_JPRB,3.3297E-02_JPRB/)
KBO( :, 2,17, 8) = (/&
&9.7388E-03_JPRB,1.0991E-02_JPRB,9.6940E-03_JPRB,7.4587E-03_JPRB,3.8754E-02_JPRB/)
KBO( :, 3,17, 8) = (/&
&1.2971E-02_JPRB,1.4712E-02_JPRB,1.2980E-02_JPRB,9.9806E-03_JPRB,4.4673E-02_JPRB/)
KBO( :, 4,17, 8) = (/&
&1.6920E-02_JPRB,1.9221E-02_JPRB,1.7037E-02_JPRB,1.3131E-02_JPRB,5.0878E-02_JPRB/)
KBO( :, 5,17, 8) = (/&
&2.1675E-02_JPRB,2.4688E-02_JPRB,2.1958E-02_JPRB,1.6944E-02_JPRB,5.7392E-02_JPRB/)
KBO( :, 1,18, 8) = (/&
&6.4048E-03_JPRB,7.2149E-03_JPRB,6.3423E-03_JPRB,4.8705E-03_JPRB,2.7610E-02_JPRB/)
KBO( :, 2,18, 8) = (/&
&8.7579E-03_JPRB,9.8929E-03_JPRB,8.6960E-03_JPRB,6.6399E-03_JPRB,3.2241E-02_JPRB/)
KBO( :, 3,18, 8) = (/&
&1.1674E-02_JPRB,1.3178E-02_JPRB,1.1614E-02_JPRB,8.8937E-03_JPRB,3.7151E-02_JPRB/)
KBO( :, 4,18, 8) = (/&
&1.5226E-02_JPRB,1.7183E-02_JPRB,1.5190E-02_JPRB,1.1678E-02_JPRB,4.2321E-02_JPRB/)
KBO( :, 5,18, 8) = (/&
&1.9521E-02_JPRB,2.2065E-02_JPRB,1.9536E-02_JPRB,1.5022E-02_JPRB,4.7759E-02_JPRB/)
KBO( :, 1,19, 8) = (/&
&5.7780E-03_JPRB,6.5097E-03_JPRB,5.7073E-03_JPRB,4.3362E-03_JPRB,2.3517E-02_JPRB/)
KBO( :, 2,19, 8) = (/&
&7.8980E-03_JPRB,8.8943E-03_JPRB,7.8019E-03_JPRB,5.9182E-03_JPRB,2.7464E-02_JPRB/)
KBO( :, 3,19, 8) = (/&
&1.0547E-02_JPRB,1.1813E-02_JPRB,1.0378E-02_JPRB,7.9082E-03_JPRB,3.1653E-02_JPRB/)
KBO( :, 4,19, 8) = (/&
&1.3780E-02_JPRB,1.5395E-02_JPRB,1.3544E-02_JPRB,1.0334E-02_JPRB,3.6068E-02_JPRB/)
KBO( :, 5,19, 8) = (/&
&1.7661E-02_JPRB,1.9769E-02_JPRB,1.7387E-02_JPRB,1.3263E-02_JPRB,4.0672E-02_JPRB/)
KBO( :, 1,20, 8) = (/&
&5.2358E-03_JPRB,5.8943E-03_JPRB,5.1609E-03_JPRB,3.8930E-03_JPRB,2.0265E-02_JPRB/)
KBO( :, 2,20, 8) = (/&
&7.1650E-03_JPRB,8.0337E-03_JPRB,7.0303E-03_JPRB,5.3009E-03_JPRB,2.3642E-02_JPRB/)
KBO( :, 3,20, 8) = (/&
&9.5768E-03_JPRB,1.0673E-02_JPRB,9.3270E-03_JPRB,7.0467E-03_JPRB,2.7210E-02_JPRB/)
KBO( :, 4,20, 8) = (/&
&1.2520E-02_JPRB,1.3910E-02_JPRB,1.2148E-02_JPRB,9.1772E-03_JPRB,3.0955E-02_JPRB/)
KBO( :, 5,20, 8) = (/&
&1.6054E-02_JPRB,1.7830E-02_JPRB,1.5571E-02_JPRB,1.1760E-02_JPRB,3.4856E-02_JPRB/)
KBO( :, 1,21, 8) = (/&
&4.7306E-03_JPRB,5.3228E-03_JPRB,4.6480E-03_JPRB,3.4934E-03_JPRB,1.7415E-02_JPRB/)
KBO( :, 2,21, 8) = (/&
&6.4837E-03_JPRB,7.2505E-03_JPRB,6.3214E-03_JPRB,4.7410E-03_JPRB,2.0248E-02_JPRB/)
KBO( :, 3,21, 8) = (/&
&8.6672E-03_JPRB,9.6479E-03_JPRB,8.3920E-03_JPRB,6.2776E-03_JPRB,2.3246E-02_JPRB/)
KBO( :, 4,21, 8) = (/&
&1.1340E-02_JPRB,1.2581E-02_JPRB,1.0918E-02_JPRB,8.1620E-03_JPRB,2.6397E-02_JPRB/)
KBO( :, 5,21, 8) = (/&
&1.4560E-02_JPRB,1.6102E-02_JPRB,1.3967E-02_JPRB,1.0440E-02_JPRB,2.9697E-02_JPRB/)
KBO( :, 1,22, 8) = (/&
&4.3418E-03_JPRB,4.8765E-03_JPRB,4.2505E-03_JPRB,3.1831E-03_JPRB,1.4725E-02_JPRB/)
KBO( :, 2,22, 8) = (/&
&5.9449E-03_JPRB,6.6380E-03_JPRB,5.7744E-03_JPRB,4.3038E-03_JPRB,1.7073E-02_JPRB/)
KBO( :, 3,22, 8) = (/&
&7.9389E-03_JPRB,8.8321E-03_JPRB,7.6615E-03_JPRB,5.6883E-03_JPRB,1.9560E-02_JPRB/)
KBO( :, 4,22, 8) = (/&
&1.0382E-02_JPRB,1.1507E-02_JPRB,9.9583E-03_JPRB,7.3808E-03_JPRB,2.2180E-02_JPRB/)
KBO( :, 5,22, 8) = (/&
&1.3348E-02_JPRB,1.4718E-02_JPRB,1.2724E-02_JPRB,9.4158E-03_JPRB,2.4942E-02_JPRB/)
KBO( :, 1,23, 8) = (/&
&3.9755E-03_JPRB,4.4601E-03_JPRB,3.8791E-03_JPRB,2.8940E-03_JPRB,1.2317E-02_JPRB/)
KBO( :, 2,23, 8) = (/&
&5.4326E-03_JPRB,6.0675E-03_JPRB,5.2649E-03_JPRB,3.9079E-03_JPRB,1.4261E-02_JPRB/)
KBO( :, 3,23, 8) = (/&
&7.2471E-03_JPRB,8.0652E-03_JPRB,6.9775E-03_JPRB,5.1609E-03_JPRB,1.6319E-02_JPRB/)
KBO( :, 4,23, 8) = (/&
&9.4853E-03_JPRB,1.0499E-02_JPRB,9.0669E-03_JPRB,6.6817E-03_JPRB,1.8494E-02_JPRB/)
KBO( :, 5,23, 8) = (/&
&1.2224E-02_JPRB,1.3433E-02_JPRB,1.1575E-02_JPRB,8.5016E-03_JPRB,2.0803E-02_JPRB/)
KBO( :, 1,24, 8) = (/&
&3.6237E-03_JPRB,4.0664E-03_JPRB,3.5327E-03_JPRB,2.6249E-03_JPRB,1.0111E-02_JPRB/)
KBO( :, 2,24, 8) = (/&
&4.9405E-03_JPRB,5.5284E-03_JPRB,4.7867E-03_JPRB,3.5422E-03_JPRB,1.1712E-02_JPRB/)
KBO( :, 3,24, 8) = (/&
&6.5941E-03_JPRB,7.3367E-03_JPRB,6.3412E-03_JPRB,4.6740E-03_JPRB,1.3407E-02_JPRB/)
KBO( :, 4,24, 8) = (/&
&8.6500E-03_JPRB,9.5582E-03_JPRB,8.2387E-03_JPRB,6.0413E-03_JPRB,1.5203E-02_JPRB/)
KBO( :, 5,24, 8) = (/&
&1.1160E-02_JPRB,1.2258E-02_JPRB,1.0518E-02_JPRB,7.6745E-03_JPRB,1.7120E-02_JPRB/)
KBO( :, 1,25, 8) = (/&
&3.2923E-03_JPRB,3.7097E-03_JPRB,3.2174E-03_JPRB,2.3852E-03_JPRB,8.2743E-03_JPRB/)
KBO( :, 2,25, 8) = (/&
&4.4868E-03_JPRB,5.0333E-03_JPRB,4.3547E-03_JPRB,3.2140E-03_JPRB,9.5864E-03_JPRB/)
KBO( :, 3,25, 8) = (/&
&6.0022E-03_JPRB,6.6817E-03_JPRB,5.7652E-03_JPRB,4.2348E-03_JPRB,1.0982E-02_JPRB/)
KBO( :, 4,25, 8) = (/&
&7.8855E-03_JPRB,8.7187E-03_JPRB,7.4913E-03_JPRB,5.4655E-03_JPRB,1.2469E-02_JPRB/)
KBO( :, 5,25, 8) = (/&
&1.0169E-02_JPRB,1.1196E-02_JPRB,9.5768E-03_JPRB,6.9385E-03_JPRB,1.4057E-02_JPRB/)
KBO( :, 1,26, 8) = (/&
&2.9966E-03_JPRB,3.3936E-03_JPRB,2.9435E-03_JPRB,2.1773E-03_JPRB,6.8226E-03_JPRB/)
KBO( :, 2,26, 8) = (/&
&4.0887E-03_JPRB,4.6003E-03_JPRB,3.9768E-03_JPRB,2.9281E-03_JPRB,7.9056E-03_JPRB/)
KBO( :, 3,26, 8) = (/&
&5.4745E-03_JPRB,6.1149E-03_JPRB,5.2640E-03_JPRB,3.8491E-03_JPRB,9.0607E-03_JPRB/)
KBO( :, 4,26, 8) = (/&
&7.1886E-03_JPRB,7.9856E-03_JPRB,6.8456E-03_JPRB,4.9643E-03_JPRB,1.0300E-02_JPRB/)
KBO( :, 5,26, 8) = (/&
&9.2596E-03_JPRB,1.0248E-02_JPRB,8.7489E-03_JPRB,6.3014E-03_JPRB,1.1624E-02_JPRB/)
KBO( :, 1,27, 8) = (/&
&2.7156E-03_JPRB,3.0876E-03_JPRB,2.6805E-03_JPRB,1.9822E-03_JPRB,5.5158E-03_JPRB/)
KBO( :, 2,27, 8) = (/&
&3.7104E-03_JPRB,4.1900E-03_JPRB,3.6215E-03_JPRB,2.6593E-03_JPRB,6.4001E-03_JPRB/)
KBO( :, 3,27, 8) = (/&
&4.9667E-03_JPRB,5.5771E-03_JPRB,4.8004E-03_JPRB,3.4928E-03_JPRB,7.3466E-03_JPRB/)
KBO( :, 4,27, 8) = (/&
&6.5120E-03_JPRB,7.2813E-03_JPRB,6.2396E-03_JPRB,4.5038E-03_JPRB,8.3626E-03_JPRB/)
KBO( :, 5,27, 8) = (/&
&8.3748E-03_JPRB,9.3312E-03_JPRB,7.9649E-03_JPRB,5.7101E-03_JPRB,9.4540E-03_JPRB/)
KBO( :, 1,28, 8) = (/&
&2.4540E-03_JPRB,2.8015E-03_JPRB,2.4332E-03_JPRB,1.7986E-03_JPRB,4.3717E-03_JPRB/)
KBO( :, 2,28, 8) = (/&
&3.3533E-03_JPRB,3.8065E-03_JPRB,3.2907E-03_JPRB,2.4104E-03_JPRB,5.0844E-03_JPRB/)
KBO( :, 3,28, 8) = (/&
&4.4816E-03_JPRB,5.0648E-03_JPRB,4.3611E-03_JPRB,3.1641E-03_JPRB,5.8491E-03_JPRB/)
KBO( :, 4,28, 8) = (/&
&5.8656E-03_JPRB,6.6059E-03_JPRB,5.6649E-03_JPRB,4.0783E-03_JPRB,6.6719E-03_JPRB/)
KBO( :, 5,28, 8) = (/&
&7.5375E-03_JPRB,8.4524E-03_JPRB,7.2181E-03_JPRB,5.1634E-03_JPRB,7.5534E-03_JPRB/)
KBO( :, 1,29, 8) = (/&
&2.2199E-03_JPRB,2.5468E-03_JPRB,2.2116E-03_JPRB,1.6320E-03_JPRB,3.4313E-03_JPRB/)
KBO( :, 2,29, 8) = (/&
&3.0284E-03_JPRB,3.4576E-03_JPRB,2.9908E-03_JPRB,2.1868E-03_JPRB,4.0007E-03_JPRB/)
KBO( :, 3,29, 8) = (/&
&4.0394E-03_JPRB,4.5959E-03_JPRB,3.9584E-03_JPRB,2.8693E-03_JPRB,4.6141E-03_JPRB/)
KBO( :, 4,29, 8) = (/&
&5.2804E-03_JPRB,5.9851E-03_JPRB,5.1333E-03_JPRB,3.6901E-03_JPRB,5.2723E-03_JPRB/)
KBO( :, 5,29, 8) = (/&
&6.7815E-03_JPRB,7.6482E-03_JPRB,6.5273E-03_JPRB,4.6670E-03_JPRB,5.9784E-03_JPRB/)
KBO( :, 1,30, 8) = (/&
&2.0046E-03_JPRB,2.3130E-03_JPRB,2.0090E-03_JPRB,1.4794E-03_JPRB,2.6543E-03_JPRB/)
KBO( :, 2,30, 8) = (/&
&2.7295E-03_JPRB,3.1369E-03_JPRB,2.7138E-03_JPRB,1.9812E-03_JPRB,3.1043E-03_JPRB/)
KBO( :, 3,30, 8) = (/&
&3.6356E-03_JPRB,4.1607E-03_JPRB,3.5841E-03_JPRB,2.5951E-03_JPRB,3.5892E-03_JPRB/)
KBO( :, 4,30, 8) = (/&
&4.7491E-03_JPRB,5.4103E-03_JPRB,4.6363E-03_JPRB,3.3323E-03_JPRB,4.1088E-03_JPRB/)
KBO( :, 5,30, 8) = (/&
&6.1030E-03_JPRB,6.9063E-03_JPRB,5.8950E-03_JPRB,4.2074E-03_JPRB,4.6673E-03_JPRB/)
KBO( :, 1,31, 8) = (/&
&1.8116E-03_JPRB,2.1021E-03_JPRB,1.8264E-03_JPRB,1.3426E-03_JPRB,2.0192E-03_JPRB/)
KBO( :, 2,31, 8) = (/&
&2.4626E-03_JPRB,2.8445E-03_JPRB,2.4615E-03_JPRB,1.7947E-03_JPRB,2.3682E-03_JPRB/)
KBO( :, 3,31, 8) = (/&
&3.2770E-03_JPRB,3.7680E-03_JPRB,3.2435E-03_JPRB,2.3454E-03_JPRB,2.7454E-03_JPRB/)
KBO( :, 4,31, 8) = (/&
&4.2825E-03_JPRB,4.8933E-03_JPRB,4.1907E-03_JPRB,3.0057E-03_JPRB,3.1516E-03_JPRB/)
KBO( :, 5,31, 8) = (/&
&5.5107E-03_JPRB,6.2496E-03_JPRB,5.3257E-03_JPRB,3.7889E-03_JPRB,3.5873E-03_JPRB/)
KBO( :, 1,32, 8) = (/&
&1.6409E-03_JPRB,1.9128E-03_JPRB,1.6615E-03_JPRB,1.2200E-03_JPRB,1.5399E-03_JPRB/)
KBO( :, 2,32, 8) = (/&
&2.2276E-03_JPRB,2.5834E-03_JPRB,2.2335E-03_JPRB,1.6257E-03_JPRB,1.8108E-03_JPRB/)
KBO( :, 3,32, 8) = (/&
&2.9642E-03_JPRB,3.4164E-03_JPRB,2.9366E-03_JPRB,2.1192E-03_JPRB,2.1049E-03_JPRB/)
KBO( :, 4,32, 8) = (/&
&3.8783E-03_JPRB,4.4382E-03_JPRB,3.7929E-03_JPRB,2.7120E-03_JPRB,2.4216E-03_JPRB/)
KBO( :, 5,32, 8) = (/&
&5.0008E-03_JPRB,5.6727E-03_JPRB,4.8212E-03_JPRB,3.4168E-03_JPRB,2.7630E-03_JPRB/)
KBO( :, 1,33, 8) = (/&
&1.4896E-03_JPRB,1.7425E-03_JPRB,1.5121E-03_JPRB,1.1085E-03_JPRB,1.1708E-03_JPRB/)
KBO( :, 2,33, 8) = (/&
&2.0219E-03_JPRB,2.3499E-03_JPRB,2.0274E-03_JPRB,1.4717E-03_JPRB,1.3798E-03_JPRB/)
KBO( :, 3,33, 8) = (/&
&2.6933E-03_JPRB,3.1059E-03_JPRB,2.6641E-03_JPRB,1.9145E-03_JPRB,1.6078E-03_JPRB/)
KBO( :, 4,33, 8) = (/&
&3.5312E-03_JPRB,4.0360E-03_JPRB,3.4383E-03_JPRB,2.4485E-03_JPRB,1.8549E-03_JPRB/)
KBO( :, 5,33, 8) = (/&
&4.5576E-03_JPRB,5.1702E-03_JPRB,4.3769E-03_JPRB,3.0873E-03_JPRB,2.1221E-03_JPRB/)
KBO( :, 1,34, 8) = (/&
&1.3461E-03_JPRB,1.5773E-03_JPRB,1.3654E-03_JPRB,9.9848E-04_JPRB,9.1828E-04_JPRB/)
KBO( :, 2,34, 8) = (/&
&1.8293E-03_JPRB,2.1264E-03_JPRB,1.8294E-03_JPRB,1.3224E-03_JPRB,1.0850E-03_JPRB/)
KBO( :, 3,34, 8) = (/&
&2.4421E-03_JPRB,2.8129E-03_JPRB,2.4038E-03_JPRB,1.7186E-03_JPRB,1.2670E-03_JPRB/)
KBO( :, 4,34, 8) = (/&
&3.2077E-03_JPRB,3.6631E-03_JPRB,3.1076E-03_JPRB,2.1997E-03_JPRB,1.4654E-03_JPRB/)
KBO( :, 5,34, 8) = (/&
&4.1521E-03_JPRB,4.7027E-03_JPRB,3.9614E-03_JPRB,2.7773E-03_JPRB,1.6801E-03_JPRB/)
KBO( :, 1,35, 8) = (/&
&1.1832E-03_JPRB,1.3882E-03_JPRB,1.1991E-03_JPRB,8.7402E-04_JPRB,7.0393E-04_JPRB/)
KBO( :, 2,35, 8) = (/&
&1.6136E-03_JPRB,1.8765E-03_JPRB,1.6089E-03_JPRB,1.1585E-03_JPRB,8.3445E-04_JPRB/)
KBO( :, 3,35, 8) = (/&
&2.1631E-03_JPRB,2.4899E-03_JPRB,2.1186E-03_JPRB,1.5089E-03_JPRB,9.7770E-04_JPRB/)
KBO( :, 4,35, 8) = (/&
&2.8535E-03_JPRB,3.2542E-03_JPRB,2.7485E-03_JPRB,1.9364E-03_JPRB,1.1343E-03_JPRB/)
KBO( :, 5,35, 8) = (/&
&3.7092E-03_JPRB,4.1965E-03_JPRB,3.5164E-03_JPRB,2.4522E-03_JPRB,1.3039E-03_JPRB/)
KBO( :, 1,36, 8) = (/&
&1.0066E-03_JPRB,1.1833E-03_JPRB,1.0195E-03_JPRB,7.4064E-04_JPRB,5.2366E-04_JPRB/)
KBO( :, 2,36, 8) = (/&
&1.3815E-03_JPRB,1.6071E-03_JPRB,1.3739E-03_JPRB,9.8573E-04_JPRB,6.2344E-04_JPRB/)
KBO( :, 3,36, 8) = (/&
&1.8626E-03_JPRB,2.1449E-03_JPRB,1.8191E-03_JPRB,1.2898E-03_JPRB,7.3360E-04_JPRB/)
KBO( :, 4,36, 8) = (/&
&2.4741E-03_JPRB,2.8182E-03_JPRB,2.3729E-03_JPRB,1.6635E-03_JPRB,8.5436E-04_JPRB/)
KBO( :, 5,36, 8) = (/&
&3.2336E-03_JPRB,3.6568E-03_JPRB,3.0504E-03_JPRB,2.1181E-03_JPRB,9.8625E-04_JPRB/)
KBO( :, 1,37, 8) = (/&
&8.2084E-04_JPRB,9.6709E-04_JPRB,8.3229E-04_JPRB,6.0374E-04_JPRB,4.0420E-04_JPRB/)
KBO( :, 2,37, 8) = (/&
&1.1372E-03_JPRB,1.3254E-03_JPRB,1.1300E-03_JPRB,8.0872E-04_JPRB,4.8417E-04_JPRB/)
KBO( :, 3,37, 8) = (/&
&1.5468E-03_JPRB,1.7826E-03_JPRB,1.5083E-03_JPRB,1.0643E-03_JPRB,5.7283E-04_JPRB/)
KBO( :, 4,37, 8) = (/&
&2.0724E-03_JPRB,2.3603E-03_JPRB,1.9807E-03_JPRB,1.3829E-03_JPRB,6.7031E-04_JPRB/)
KBO( :, 5,37, 8) = (/&
&2.7301E-03_JPRB,3.0852E-03_JPRB,2.5656E-03_JPRB,1.7725E-03_JPRB,7.7693E-04_JPRB/)
KBO( :, 1,38, 8) = (/&
&6.6765E-04_JPRB,7.8856E-04_JPRB,6.7796E-04_JPRB,4.9087E-04_JPRB,3.1034E-04_JPRB/)
KBO( :, 2,38, 8) = (/&
&9.3399E-04_JPRB,1.0908E-03_JPRB,9.2831E-04_JPRB,6.6210E-04_JPRB,3.7420E-04_JPRB/)
KBO( :, 3,38, 8) = (/&
&1.2829E-03_JPRB,1.4801E-03_JPRB,1.2480E-03_JPRB,8.7788E-04_JPRB,4.4529E-04_JPRB/)
KBO( :, 4,38, 8) = (/&
&1.7334E-03_JPRB,1.9765E-03_JPRB,1.6521E-03_JPRB,1.1484E-03_JPRB,5.2389E-04_JPRB/)
KBO( :, 5,38, 8) = (/&
&2.3042E-03_JPRB,2.6028E-03_JPRB,2.1565E-03_JPRB,1.4823E-03_JPRB,6.1008E-04_JPRB/)
KBO( :, 1,39, 8) = (/&
&5.4315E-04_JPRB,6.4310E-04_JPRB,5.5211E-04_JPRB,3.9890E-04_JPRB,2.3583E-04_JPRB/)
KBO( :, 2,39, 8) = (/&
&7.6743E-04_JPRB,8.9797E-04_JPRB,7.6314E-04_JPRB,5.4269E-04_JPRB,2.8632E-04_JPRB/)
KBO( :, 3,39, 8) = (/&
&1.0649E-03_JPRB,1.2299E-03_JPRB,1.0342E-03_JPRB,7.2462E-04_JPRB,3.4293E-04_JPRB/)
KBO( :, 4,39, 8) = (/&
&1.4519E-03_JPRB,1.6575E-03_JPRB,1.3791E-03_JPRB,9.5496E-04_JPRB,4.0575E-04_JPRB/)
KBO( :, 5,39, 8) = (/&
&1.9462E-03_JPRB,2.1987E-03_JPRB,1.8149E-03_JPRB,1.2411E-03_JPRB,4.7487E-04_JPRB/)
KBO( :, 1,40, 8) = (/&
&4.2660E-04_JPRB,5.0722E-04_JPRB,4.3537E-04_JPRB,3.1438E-04_JPRB,1.8128E-04_JPRB/)
KBO( :, 2,40, 8) = (/&
&6.1039E-04_JPRB,7.1647E-04_JPRB,6.0817E-04_JPRB,4.3189E-04_JPRB,2.2187E-04_JPRB/)
KBO( :, 3,40, 8) = (/&
&8.5703E-04_JPRB,9.9240E-04_JPRB,8.3374E-04_JPRB,5.8276E-04_JPRB,2.6760E-04_JPRB/)
KBO( :, 4,40, 8) = (/&
&1.1823E-03_JPRB,1.3510E-03_JPRB,1.1225E-03_JPRB,7.7459E-04_JPRB,3.1857E-04_JPRB/)
KBO( :, 5,40, 8) = (/&
&1.6018E-03_JPRB,1.8123E-03_JPRB,1.4916E-03_JPRB,1.0158E-03_JPRB,3.7479E-04_JPRB/)
KBO( :, 1,41, 8) = (/&
&3.3271E-04_JPRB,3.9736E-04_JPRB,3.4108E-04_JPRB,2.4624E-04_JPRB,1.3885E-04_JPRB/)
KBO( :, 2,41, 8) = (/&
&4.8225E-04_JPRB,5.6846E-04_JPRB,4.8237E-04_JPRB,3.4216E-04_JPRB,1.7137E-04_JPRB/)
KBO( :, 3,41, 8) = (/&
&6.8576E-04_JPRB,7.9688E-04_JPRB,6.6837E-04_JPRB,4.6622E-04_JPRB,2.0821E-04_JPRB/)
KBO( :, 4,41, 8) = (/&
&9.5732E-04_JPRB,1.0976E-03_JPRB,9.0996E-04_JPRB,6.2571E-04_JPRB,2.4955E-04_JPRB/)
KBO( :, 5,41, 8) = (/&
&1.3120E-03_JPRB,1.4870E-03_JPRB,1.2214E-03_JPRB,8.2829E-04_JPRB,2.9516E-04_JPRB/)
KBO( :, 1,42, 8) = (/&
&2.5867E-04_JPRB,3.1042E-04_JPRB,2.6645E-04_JPRB,1.9244E-04_JPRB,1.0554E-04_JPRB/)
KBO( :, 2,42, 8) = (/&
&3.8005E-04_JPRB,4.4981E-04_JPRB,3.8160E-04_JPRB,2.7033E-04_JPRB,1.3138E-04_JPRB/)
KBO( :, 3,42, 8) = (/&
&5.4750E-04_JPRB,6.3852E-04_JPRB,5.3511E-04_JPRB,3.7262E-04_JPRB,1.6089E-04_JPRB/)
KBO( :, 4,42, 8) = (/&
&7.7370E-04_JPRB,8.8989E-04_JPRB,7.3675E-04_JPRB,5.0530E-04_JPRB,1.9414E-04_JPRB/)
KBO( :, 5,42, 8) = (/&
&1.0732E-03_JPRB,1.2192E-03_JPRB,9.9944E-04_JPRB,6.7542E-04_JPRB,2.3100E-04_JPRB/)
KBO( :, 1,43, 8) = (/&
&1.9608E-04_JPRB,2.3654E-04_JPRB,2.0330E-04_JPRB,1.4692E-04_JPRB,7.9640E-05_JPRB/)
KBO( :, 2,43, 8) = (/&
&2.9244E-04_JPRB,3.4786E-04_JPRB,2.9536E-04_JPRB,2.0929E-04_JPRB,1.0013E-04_JPRB/)
KBO( :, 3,43, 8) = (/&
&4.2746E-04_JPRB,5.0109E-04_JPRB,4.1968E-04_JPRB,2.9227E-04_JPRB,1.2370E-04_JPRB/)
KBO( :, 4,43, 8) = (/&
&6.1258E-04_JPRB,7.0737E-04_JPRB,5.8531E-04_JPRB,4.0077E-04_JPRB,1.5047E-04_JPRB/)
KBO( :, 5,43, 8) = (/&
&8.6089E-04_JPRB,9.8132E-04_JPRB,8.0325E-04_JPRB,5.4165E-04_JPRB,1.8030E-04_JPRB/)
KBO( :, 1,44, 8) = (/&
&1.4641E-04_JPRB,1.7759E-04_JPRB,1.5289E-04_JPRB,1.1076E-04_JPRB,5.9627E-05_JPRB/)
KBO( :, 2,44, 8) = (/&
&2.2184E-04_JPRB,2.6534E-04_JPRB,2.2560E-04_JPRB,1.6005E-04_JPRB,7.5777E-05_JPRB/)
KBO( :, 3,44, 8) = (/&
&3.2924E-04_JPRB,3.8780E-04_JPRB,3.2524E-04_JPRB,2.2657E-04_JPRB,9.4517E-05_JPRB/)
KBO( :, 4,44, 8) = (/&
&4.7893E-04_JPRB,5.5571E-04_JPRB,4.5993E-04_JPRB,3.1465E-04_JPRB,1.1599E-04_JPRB/)
KBO( :, 5,44, 8) = (/&
&6.8243E-04_JPRB,7.8130E-04_JPRB,6.3916E-04_JPRB,4.3040E-04_JPRB,1.4006E-04_JPRB/)
KBO( :, 1,45, 8) = (/&
&1.0865E-04_JPRB,1.3251E-04_JPRB,1.1435E-04_JPRB,8.2960E-05_JPRB,4.4212E-05_JPRB/)
KBO( :, 2,45, 8) = (/&
&1.6729E-04_JPRB,2.0128E-04_JPRB,1.7134E-04_JPRB,1.2183E-04_JPRB,5.6830E-05_JPRB/)
KBO( :, 3,45, 8) = (/&
&2.5229E-04_JPRB,2.9908E-04_JPRB,2.5083E-04_JPRB,1.7486E-04_JPRB,7.1604E-05_JPRB/)
KBO( :, 4,45, 8) = (/&
&3.7262E-04_JPRB,4.3452E-04_JPRB,3.5986E-04_JPRB,2.4619E-04_JPRB,8.8632E-05_JPRB/)
KBO( :, 5,45, 8) = (/&
&5.3882E-04_JPRB,6.2004E-04_JPRB,5.0717E-04_JPRB,3.4090E-04_JPRB,1.0793E-04_JPRB/)
KBO( :, 1,46, 8) = (/&
&7.9358E-05_JPRB,9.7327E-05_JPRB,8.4209E-05_JPRB,6.1250E-05_JPRB,3.2459E-05_JPRB/)
KBO( :, 2,46, 8) = (/&
&1.2429E-04_JPRB,1.5045E-04_JPRB,1.2830E-04_JPRB,9.1466E-05_JPRB,4.2241E-05_JPRB/)
KBO( :, 3,46, 8) = (/&
&1.9053E-04_JPRB,2.2736E-04_JPRB,1.9100E-04_JPRB,1.3325E-04_JPRB,5.3783E-05_JPRB/)
KBO( :, 4,46, 8) = (/&
&2.8614E-04_JPRB,3.3570E-04_JPRB,2.7828E-04_JPRB,1.9050E-04_JPRB,6.7218E-05_JPRB/)
KBO( :, 5,46, 8) = (/&
&4.2039E-04_JPRB,4.8635E-04_JPRB,3.9774E-04_JPRB,2.6724E-04_JPRB,8.2582E-05_JPRB/)
KBO( :, 1,47, 8) = (/&
&5.6453E-05_JPRB,6.9628E-05_JPRB,6.0410E-05_JPRB,4.4150E-05_JPRB,2.3634E-05_JPRB/)
KBO( :, 2,47, 8) = (/&
&9.0039E-05_JPRB,1.0971E-04_JPRB,9.3809E-05_JPRB,6.7082E-05_JPRB,3.1174E-05_JPRB/)
KBO( :, 3,47, 8) = (/&
&1.4053E-04_JPRB,1.6882E-04_JPRB,1.4207E-04_JPRB,9.9462E-05_JPRB,4.0177E-05_JPRB/)
KBO( :, 4,47, 8) = (/&
&2.1477E-04_JPRB,2.5374E-04_JPRB,2.1068E-04_JPRB,1.4451E-04_JPRB,5.0742E-05_JPRB/)
KBO( :, 5,47, 8) = (/&
&3.2088E-04_JPRB,3.7357E-04_JPRB,3.0615E-04_JPRB,2.0585E-04_JPRB,6.2901E-05_JPRB/)
KBO( :, 1,48, 8) = (/&
&3.9798E-05_JPRB,4.9340E-05_JPRB,4.2936E-05_JPRB,3.1533E-05_JPRB,1.7003E-05_JPRB/)
KBO( :, 2,48, 8) = (/&
&6.4659E-05_JPRB,7.9275E-05_JPRB,6.7974E-05_JPRB,4.8844E-05_JPRB,2.2754E-05_JPRB/)
KBO( :, 3,48, 8) = (/&
&1.0277E-04_JPRB,1.2433E-04_JPRB,1.0493E-04_JPRB,7.3715E-05_JPRB,2.9706E-05_JPRB/)
KBO( :, 4,48, 8) = (/&
&1.5992E-04_JPRB,1.9034E-04_JPRB,1.5838E-04_JPRB,1.0886E-04_JPRB,3.7936E-05_JPRB/)
KBO( :, 5,48, 8) = (/&
&2.4325E-04_JPRB,2.8513E-04_JPRB,2.3408E-04_JPRB,1.5755E-04_JPRB,4.7492E-05_JPRB/)
KBO( :, 1,49, 8) = (/&
&2.7802E-05_JPRB,3.4616E-05_JPRB,3.0218E-05_JPRB,2.2308E-05_JPRB,1.2061E-05_JPRB/)
KBO( :, 2,49, 8) = (/&
&4.6014E-05_JPRB,5.6761E-05_JPRB,4.8820E-05_JPRB,3.5239E-05_JPRB,1.6386E-05_JPRB/)
KBO( :, 3,49, 8) = (/&
&7.4491E-05_JPRB,9.0741E-05_JPRB,7.6795E-05_JPRB,5.4143E-05_JPRB,2.1687E-05_JPRB/)
KBO( :, 4,49, 8) = (/&
&1.1802E-04_JPRB,1.4153E-04_JPRB,1.1806E-04_JPRB,8.1356E-05_JPRB,2.8022E-05_JPRB/)
KBO( :, 5,49, 8) = (/&
&1.8279E-04_JPRB,2.1583E-04_JPRB,1.7754E-04_JPRB,1.1970E-04_JPRB,3.5456E-05_JPRB/)
KBO( :, 1,50, 8) = (/&
&1.9540E-05_JPRB,2.4400E-05_JPRB,2.1361E-05_JPRB,1.5837E-05_JPRB,8.6997E-06_JPRB/)
KBO( :, 2,50, 8) = (/&
&3.2918E-05_JPRB,4.0822E-05_JPRB,3.5205E-05_JPRB,2.5512E-05_JPRB,1.1990E-05_JPRB/)
KBO( :, 3,50, 8) = (/&
&5.4255E-05_JPRB,6.6526E-05_JPRB,5.6438E-05_JPRB,3.9950E-05_JPRB,1.6073E-05_JPRB/)
KBO( :, 4,50, 8) = (/&
&8.7526E-05_JPRB,1.0571E-04_JPRB,8.8383E-05_JPRB,6.1066E-05_JPRB,2.1006E-05_JPRB/)
KBO( :, 5,50, 8) = (/&
&1.3799E-04_JPRB,1.6415E-04_JPRB,1.3524E-04_JPRB,9.1334E-05_JPRB,2.6847E-05_JPRB/)
KBO( :, 1,51, 8) = (/&
&1.3715E-05_JPRB,1.7170E-05_JPRB,1.5061E-05_JPRB,1.1220E-05_JPRB,6.3066E-06_JPRB/)
KBO( :, 2,51, 8) = (/&
&2.3525E-05_JPRB,2.9290E-05_JPRB,2.5329E-05_JPRB,1.8432E-05_JPRB,8.8176E-06_JPRB/)
KBO( :, 3,51, 8) = (/&
&3.9460E-05_JPRB,4.8672E-05_JPRB,4.1377E-05_JPRB,2.9397E-05_JPRB,1.1971E-05_JPRB/)
KBO( :, 4,51, 8) = (/&
&6.4794E-05_JPRB,7.8837E-05_JPRB,6.6040E-05_JPRB,4.5759E-05_JPRB,1.5830E-05_JPRB/)
KBO( :, 5,51, 8) = (/&
&1.0402E-04_JPRB,1.2470E-04_JPRB,1.0290E-04_JPRB,6.9640E-05_JPRB,2.0433E-05_JPRB/)
KBO( :, 1,52, 8) = (/&
&9.5578E-06_JPRB,1.1986E-05_JPRB,1.0529E-05_JPRB,7.8831E-06_JPRB,4.5278E-06_JPRB/)
KBO( :, 2,52, 8) = (/&
&1.6679E-05_JPRB,2.0856E-05_JPRB,1.8076E-05_JPRB,1.3211E-05_JPRB,6.4244E-06_JPRB/)
KBO( :, 3,52, 8) = (/&
&2.8477E-05_JPRB,3.5320E-05_JPRB,3.0103E-05_JPRB,2.1468E-05_JPRB,8.8391E-06_JPRB/)
KBO( :, 4,52, 8) = (/&
&4.7594E-05_JPRB,5.8357E-05_JPRB,4.8987E-05_JPRB,3.4026E-05_JPRB,1.1833E-05_JPRB/)
KBO( :, 5,52, 8) = (/&
&7.7798E-05_JPRB,9.3982E-05_JPRB,7.7692E-05_JPRB,5.2723E-05_JPRB,1.5437E-05_JPRB/)
KBO( :, 1,53, 8) = (/&
&6.6072E-06_JPRB,8.2930E-06_JPRB,7.2961E-06_JPRB,5.4893E-06_JPRB,3.2145E-06_JPRB/)
KBO( :, 2,53, 8) = (/&
&1.1726E-05_JPRB,1.4716E-05_JPRB,1.2781E-05_JPRB,9.3822E-06_JPRB,4.6284E-06_JPRB/)
KBO( :, 3,53, 8) = (/&
&2.0380E-05_JPRB,2.5407E-05_JPRB,2.1715E-05_JPRB,1.5543E-05_JPRB,6.4582E-06_JPRB/)
KBO( :, 4,53, 8) = (/&
&3.4658E-05_JPRB,4.2781E-05_JPRB,3.5988E-05_JPRB,2.5111E-05_JPRB,8.7586E-06_JPRB/)
KBO( :, 5,53, 8) = (/&
&5.7694E-05_JPRB,7.0240E-05_JPRB,5.8204E-05_JPRB,3.9606E-05_JPRB,1.1558E-05_JPRB/)
KBO( :, 1,54, 8) = (/&
&4.6231E-06_JPRB,5.8094E-06_JPRB,5.1159E-06_JPRB,3.8681E-06_JPRB,2.3617E-06_JPRB/)
KBO( :, 2,54, 8) = (/&
&8.3487E-06_JPRB,1.0507E-05_JPRB,9.1409E-06_JPRB,6.7324E-06_JPRB,3.4457E-06_JPRB/)
KBO( :, 3,54, 8) = (/&
&1.4749E-05_JPRB,1.8473E-05_JPRB,1.5818E-05_JPRB,1.1366E-05_JPRB,4.8678E-06_JPRB/)
KBO( :, 4,54, 8) = (/&
&2.5524E-05_JPRB,3.1693E-05_JPRB,2.6712E-05_JPRB,1.8698E-05_JPRB,6.6754E-06_JPRB/)
KBO( :, 5,54, 8) = (/&
&4.3244E-05_JPRB,5.3058E-05_JPRB,4.4050E-05_JPRB,3.0042E-05_JPRB,8.8957E-06_JPRB/)
KBO( :, 1,55, 8) = (/&
&3.2435E-06_JPRB,4.0809E-06_JPRB,3.5968E-06_JPRB,2.7333E-06_JPRB,1.7666E-06_JPRB/)
KBO( :, 2,55, 8) = (/&
&5.9644E-06_JPRB,7.5172E-06_JPRB,6.5506E-06_JPRB,4.8409E-06_JPRB,2.6116E-06_JPRB/)
KBO( :, 3,55, 8) = (/&
&1.0704E-05_JPRB,1.3462E-05_JPRB,1.1547E-05_JPRB,8.3238E-06_JPRB,3.7328E-06_JPRB/)
KBO( :, 4,55, 8) = (/&
&1.8846E-05_JPRB,2.3522E-05_JPRB,1.9854E-05_JPRB,1.3943E-05_JPRB,5.1720E-06_JPRB/)
KBO( :, 5,55, 8) = (/&
&3.2477E-05_JPRB,4.0113E-05_JPRB,3.3370E-05_JPRB,2.2811E-05_JPRB,6.9569E-06_JPRB/)
KBO( :, 1,56, 8) = (/&
&2.2574E-06_JPRB,2.8460E-06_JPRB,2.5125E-06_JPRB,1.9227E-06_JPRB,1.3179E-06_JPRB/)
KBO( :, 2,56, 8) = (/&
&4.2369E-06_JPRB,5.3474E-06_JPRB,4.6648E-06_JPRB,3.4587E-06_JPRB,1.9756E-06_JPRB/)
KBO( :, 3,56, 8) = (/&
&7.7258E-06_JPRB,9.7496E-06_JPRB,8.3766E-06_JPRB,6.0549E-06_JPRB,2.8571E-06_JPRB/)
KBO( :, 4,56, 8) = (/&
&1.3829E-05_JPRB,1.7347E-05_JPRB,1.4668E-05_JPRB,1.0332E-05_JPRB,4.0014E-06_JPRB/)
KBO( :, 5,56, 8) = (/&
&2.4242E-05_JPRB,3.0140E-05_JPRB,2.5119E-05_JPRB,1.7219E-05_JPRB,5.4349E-06_JPRB/)
KBO( :, 1,57, 8) = (/&
&1.5562E-06_JPRB,1.9665E-06_JPRB,1.7413E-06_JPRB,1.3458E-06_JPRB,9.8093E-07_JPRB/)
KBO( :, 2,57, 8) = (/&
&2.9891E-06_JPRB,3.7795E-06_JPRB,3.2995E-06_JPRB,2.4572E-06_JPRB,1.4913E-06_JPRB/)
KBO( :, 3,57, 8) = (/&
&5.5415E-06_JPRB,7.0117E-06_JPRB,6.0356E-06_JPRB,4.3741E-06_JPRB,2.1827E-06_JPRB/)
KBO( :, 4,57, 8) = (/&
&1.0083E-05_JPRB,1.2702E-05_JPRB,1.0763E-05_JPRB,7.6047E-06_JPRB,3.0916E-06_JPRB/)
KBO( :, 5,57, 8) = (/&
&1.7987E-05_JPRB,2.2497E-05_JPRB,1.8783E-05_JPRB,1.2912E-05_JPRB,4.2413E-06_JPRB/)
KBO( :, 1,58, 8) = (/&
&1.0750E-06_JPRB,1.3607E-06_JPRB,1.2097E-06_JPRB,9.4788E-07_JPRB,7.3838E-07_JPRB/)
KBO( :, 2,58, 8) = (/&
&2.1150E-06_JPRB,2.6811E-06_JPRB,2.3427E-06_JPRB,1.7529E-06_JPRB,1.1369E-06_JPRB/)
KBO( :, 3,58, 8) = (/&
&3.9927E-06_JPRB,5.0636E-06_JPRB,4.3652E-06_JPRB,3.1731E-06_JPRB,1.6853E-06_JPRB/)
KBO( :, 4,58, 8) = (/&
&7.3820E-06_JPRB,9.3320E-06_JPRB,7.9215E-06_JPRB,5.6104E-06_JPRB,2.4126E-06_JPRB/)
KBO( :, 5,58, 8) = (/&
&1.3390E-05_JPRB,1.6843E-05_JPRB,1.4081E-05_JPRB,9.7051E-06_JPRB,3.3415E-06_JPRB/)
KBO( :, 1,59, 8) = (/&
&8.4145E-07_JPRB,1.0679E-06_JPRB,9.4979E-07_JPRB,7.4709E-07_JPRB,6.3499E-07_JPRB/)
KBO( :, 2,59, 8) = (/&
&1.6828E-06_JPRB,2.1406E-06_JPRB,1.8681E-06_JPRB,1.3967E-06_JPRB,9.8499E-07_JPRB/)
KBO( :, 3,59, 8) = (/&
&3.2239E-06_JPRB,4.0954E-06_JPRB,3.5264E-06_JPRB,2.5580E-06_JPRB,1.4693E-06_JPRB/)
KBO( :, 4,59, 8) = (/&
&6.0392E-06_JPRB,7.6569E-06_JPRB,6.4911E-06_JPRB,4.5821E-06_JPRB,2.1121E-06_JPRB/)
KBO( :, 5,59, 8) = (/&
&1.1097E-05_JPRB,1.4009E-05_JPRB,1.1691E-05_JPRB,8.0420E-06_JPRB,2.9314E-06_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB3_B2
